#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspcreate_ PETSCDRAWSPCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspcreate_ petscdrawspcreate
#endif
PETSC_EXTERN void petscdrawspcreate_(PetscDraw *a, int *b, PetscDrawSP *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDrawSPCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspsetdimension_ PETSCDRAWSPSETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspsetdimension_ petscdrawspsetdimension
#endif
PETSC_EXTERN void petscdrawspsetdimension_(PetscDrawSP *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPSetDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspgetdimension_ PETSCDRAWSPGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspgetdimension_ petscdrawspgetdimension
#endif
PETSC_EXTERN void petscdrawspgetdimension_(PetscDrawSP *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspreset_ PETSCDRAWSPRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspreset_ petscdrawspreset
#endif
PETSC_EXTERN void petscdrawspreset_(PetscDrawSP *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspdestroy_ PETSCDRAWSPDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspdestroy_ petscdrawspdestroy
#endif
PETSC_EXTERN void petscdrawspdestroy_(PetscDrawSP *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawSPDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspaddpoint_ PETSCDRAWSPADDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspaddpoint_ petscdrawspaddpoint
#endif
PETSC_EXTERN void petscdrawspaddpoint_(PetscDrawSP *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDrawSPAddPoint(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspaddpointcolorized_ PETSCDRAWSPADDPOINTCOLORIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspaddpointcolorized_ petscdrawspaddpointcolorized
#endif
PETSC_EXTERN void petscdrawspaddpointcolorized_(PetscDrawSP *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscDrawSPAddPointColorized(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspdraw_ PETSCDRAWSPDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspdraw_ petscdrawspdraw
#endif
PETSC_EXTERN void petscdrawspdraw_(PetscDrawSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPDraw(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspsave_ PETSCDRAWSPSAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspsave_ petscdrawspsave
#endif
PETSC_EXTERN void petscdrawspsave_(PetscDrawSP *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPSave(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspsetlimits_ PETSCDRAWSPSETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspsetlimits_ petscdrawspsetlimits
#endif
PETSC_EXTERN void petscdrawspsetlimits_(PetscDrawSP *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSPSetLimits(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspgetaxis_ PETSCDRAWSPGETAXIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspgetaxis_ petscdrawspgetaxis
#endif
PETSC_EXTERN void petscdrawspgetaxis_(PetscDrawSP *a, PetscDrawAxis *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawSPGetAxis(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawspgetdraw_ PETSCDRAWSPGETDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawspgetdraw_ petscdrawspgetdraw
#endif
PETSC_EXTERN void petscdrawspgetdraw_(PetscDrawSP *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawSPGetDraw(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
