  type, extends(tPetscObject) ::  tSNESLineSearch
  end type tSNESLineSearch
  SNESLineSearch, parameter :: PETSC_NULL_SNESLINESEARCH = tSNESLineSearch(0)
  SNESLineSearch, target :: PETSC_NULL_SNESLINESEARCH_ARRAY(1) = [tSNESLineSearch(0)]
  SNESLineSearch, pointer :: PETSC_NULL_SNESLINESEARCH_POINTER(:) => PETSC_NULL_SNESLINESEARCH_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESLINESEARCH
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESLINESEARCH_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESLINESEARCH_POINTER
#endif

  type, extends(tPetscObject) ::  tSNES
  end type tSNES
  SNES, parameter :: PETSC_NULL_SNES = tSNES(0)
  SNES, target :: PETSC_NULL_SNES_ARRAY(1) = [tSNES(0)]
  SNES, pointer :: PETSC_NULL_SNES_POINTER(:) => PETSC_NULL_SNES_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNES
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNES_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNES_POINTER
#endif

  type eSNESNewtonTRFallbackType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNewtonTRFallbackType

  SNESNewtonTRFallbackType, parameter :: PETSC_NULL_SNESNEWTONTRFALLBACKTYPE = eSNESNewtonTRFallbackType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNEWTONTRFALLBACKTYPE
#endif
    SNESNewtonTRFallbackType, parameter :: SNES_TR_FALLBACK_NEWTON = eSNESNewtonTRFallbackType(0)
    SNESNewtonTRFallbackType, parameter :: SNES_TR_FALLBACK_CAUCHY = eSNESNewtonTRFallbackType(1)
    SNESNewtonTRFallbackType, parameter :: SNES_TR_FALLBACK_DOGLEG = eSNESNewtonTRFallbackType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_FALLBACK_NEWTON
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_FALLBACK_CAUCHY
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_FALLBACK_DOGLEG
#endif

  type eSNESNewtonTRQNType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNewtonTRQNType

  SNESNewtonTRQNType, parameter :: PETSC_NULL_SNESNEWTONTRQNTYPE = eSNESNewtonTRQNType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNEWTONTRQNTYPE
#endif
    SNESNewtonTRQNType, parameter :: SNES_TR_QN_NONE = eSNESNewtonTRQNType(0)
    SNESNewtonTRQNType, parameter :: SNES_TR_QN_SAME = eSNESNewtonTRQNType(1)
    SNESNewtonTRQNType, parameter :: SNES_TR_QN_DIFFERENT = eSNESNewtonTRQNType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_QN_NONE
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_QN_SAME
!DEC$ ATTRIBUTES DLLEXPORT::SNES_TR_QN_DIFFERENT
#endif

  type eSNESConvergedReason
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESConvergedReason

  SNESConvergedReason, parameter :: PETSC_NULL_SNESCONVERGEDREASON = eSNESConvergedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESCONVERGEDREASON
#endif
    SNESConvergedReason, parameter :: SNES_CONVERGED_FNORM_ABS = eSNESConvergedReason(2)
    SNESConvergedReason, parameter :: SNES_CONVERGED_FNORM_RELATIVE = eSNESConvergedReason(3)
    SNESConvergedReason, parameter :: SNES_CONVERGED_SNORM_RELATIVE = eSNESConvergedReason(4)
    SNESConvergedReason, parameter :: SNES_CONVERGED_ITS = eSNESConvergedReason(5)
    SNESConvergedReason, parameter :: SNES_BREAKOUT_INNER_ITER = eSNESConvergedReason(6)
    SNESConvergedReason, parameter :: SNES_CONVERGED_USER = eSNESConvergedReason(7)
    SNESConvergedReason, parameter :: SNES_DIVERGED_FUNCTION_DOMAIN = eSNESConvergedReason(-1)
    SNESConvergedReason, parameter :: SNES_DIVERGED_FUNCTION_COUNT = eSNESConvergedReason(-2)
    SNESConvergedReason, parameter :: SNES_DIVERGED_LINEAR_SOLVE = eSNESConvergedReason(-3)
    SNESConvergedReason, parameter :: SNES_DIVERGED_FNORM_NAN = eSNESConvergedReason(-4)
    SNESConvergedReason, parameter :: SNES_DIVERGED_MAX_IT = eSNESConvergedReason(-5)
    SNESConvergedReason, parameter :: SNES_DIVERGED_LINE_SEARCH = eSNESConvergedReason(-6)
    SNESConvergedReason, parameter :: SNES_DIVERGED_INNER = eSNESConvergedReason(-7)
    SNESConvergedReason, parameter :: SNES_DIVERGED_LOCAL_MIN = eSNESConvergedReason(-8)
    SNESConvergedReason, parameter :: SNES_DIVERGED_DTOL = eSNESConvergedReason(-9)
    SNESConvergedReason, parameter :: SNES_DIVERGED_JACOBIAN_DOMAIN = eSNESConvergedReason(-10)
    SNESConvergedReason, parameter :: SNES_DIVERGED_TR_DELTA = eSNESConvergedReason(-11)
    SNESConvergedReason, parameter :: SNES_CONVERGED_TR_DELTA_DEPRECATED = eSNESConvergedReason(-11)
    SNESConvergedReason, parameter :: SNES_DIVERGED_USER = eSNESConvergedReason(-12)
    SNESConvergedReason, parameter :: SNES_CONVERGED_ITERATING = eSNESConvergedReason(0)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_FNORM_ABS 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_FNORM_RELATIVE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_SNORM_RELATIVE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_ITS 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_BREAKOUT_INNER_ITER 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_FUNCTION_DOMAIN 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_FUNCTION_COUNT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_LINEAR_SOLVE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_FNORM_NAN 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_MAX_IT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_LINE_SEARCH 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_INNER 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_LOCAL_MIN 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_DTOL 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_JACOBIAN_DOMAIN 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_TR_DELTA 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_TR_DELTA_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_DIVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_CONVERGED_ITERATING 
#endif

  type eSNESNormSchedule
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNormSchedule

  SNESNormSchedule, parameter :: PETSC_NULL_SNESNORMSCHEDULE = eSNESNormSchedule(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNORMSCHEDULE
#endif
    SNESNormSchedule, parameter :: SNES_NORM_DEFAULT = eSNESNormSchedule(-1)
    SNESNormSchedule, parameter :: SNES_NORM_NONE = eSNESNormSchedule(0)
    SNESNormSchedule, parameter :: SNES_NORM_ALWAYS = eSNESNormSchedule(1)
    SNESNormSchedule, parameter :: SNES_NORM_INITIAL_ONLY = eSNESNormSchedule(2)
    SNESNormSchedule, parameter :: SNES_NORM_FINAL_ONLY = eSNESNormSchedule(3)
    SNESNormSchedule, parameter :: SNES_NORM_INITIAL_FINAL_ONLY = eSNESNormSchedule(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_ALWAYS 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_INITIAL_ONLY 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_FINAL_ONLY 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NORM_INITIAL_FINAL_ONLY 
#endif

  type eSNESFunctionType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESFunctionType

  SNESFunctionType, parameter :: PETSC_NULL_SNESFUNCTIONTYPE = eSNESFunctionType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESFUNCTIONTYPE
#endif
    SNESFunctionType, parameter :: SNES_FUNCTION_DEFAULT = eSNESFunctionType(-1)
    SNESFunctionType, parameter :: SNES_FUNCTION_UNPRECONDITIONED = eSNESFunctionType(0)
    SNESFunctionType, parameter :: SNES_FUNCTION_PRECONDITIONED = eSNESFunctionType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FUNCTION_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FUNCTION_UNPRECONDITIONED 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FUNCTION_PRECONDITIONED 
#endif

  type eSNESLineSearchReason
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESLineSearchReason

  SNESLineSearchReason, parameter :: PETSC_NULL_SNESLINESEARCHREASON = eSNESLineSearchReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESLINESEARCHREASON
#endif
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_SUCCEEDED = eSNESLineSearchReason(0)
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_FAILED_NANORINF = eSNESLineSearchReason(1)
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_FAILED_DOMAIN = eSNESLineSearchReason(2)
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_FAILED_REDUCT = eSNESLineSearchReason(3)
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_FAILED_USER = eSNESLineSearchReason(4)
    SNESLineSearchReason, parameter :: SNES_LINESEARCH_FAILED_FUNCTION = eSNESLineSearchReason(5)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_SUCCEEDED
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_FAILED_NANORINF
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_FAILED_DOMAIN
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_FAILED_REDUCT
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_FAILED_USER
!DEC$ ATTRIBUTES DLLEXPORT::SNES_LINESEARCH_FAILED_FUNCTION
#endif

  type eSNESNGMRESRestartType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNGMRESRestartType

  SNESNGMRESRestartType, parameter :: PETSC_NULL_SNESNGMRESRESTARTTYPE = eSNESNGMRESRestartType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNGMRESRESTARTTYPE
#endif
    SNESNGMRESRestartType, parameter :: SNES_NGMRES_RESTART_NONE = eSNESNGMRESRestartType(0)
    SNESNGMRESRestartType, parameter :: SNES_NGMRES_RESTART_PERIODIC = eSNESNGMRESRestartType(1)
    SNESNGMRESRestartType, parameter :: SNES_NGMRES_RESTART_DIFFERENCE = eSNESNGMRESRestartType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_RESTART_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_RESTART_PERIODIC 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_RESTART_DIFFERENCE 
#endif

  type eSNESNGMRESSelectType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNGMRESSelectType

  SNESNGMRESSelectType, parameter :: PETSC_NULL_SNESNGMRESSELECTTYPE = eSNESNGMRESSelectType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNGMRESSELECTTYPE
#endif
    SNESNGMRESSelectType, parameter :: SNES_NGMRES_SELECT_NONE = eSNESNGMRESSelectType(0)
    SNESNGMRESSelectType, parameter :: SNES_NGMRES_SELECT_DIFFERENCE = eSNESNGMRESSelectType(1)
    SNESNGMRESSelectType, parameter :: SNES_NGMRES_SELECT_LINESEARCH = eSNESNGMRESSelectType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_SELECT_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_SELECT_DIFFERENCE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NGMRES_SELECT_LINESEARCH 
#endif

  type eSNESNCGType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNCGType

  SNESNCGType, parameter :: PETSC_NULL_SNESNCGTYPE = eSNESNCGType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNCGTYPE
#endif
    SNESNCGType, parameter :: SNES_NCG_FR = eSNESNCGType(0)
    SNESNCGType, parameter :: SNES_NCG_PRP = eSNESNCGType(1)
    SNESNCGType, parameter :: SNES_NCG_HS = eSNESNCGType(2)
    SNESNCGType, parameter :: SNES_NCG_DY = eSNESNCGType(3)
    SNESNCGType, parameter :: SNES_NCG_CD = eSNESNCGType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NCG_FR 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NCG_PRP 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NCG_HS 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NCG_DY 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NCG_CD 
#endif

  type eSNESQNScaleType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESQNScaleType

  SNESQNScaleType, parameter :: PETSC_NULL_SNESQNSCALETYPE = eSNESQNScaleType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESQNSCALETYPE
#endif
    SNESQNScaleType, parameter :: SNES_QN_SCALE_DEFAULT = eSNESQNScaleType(0)
    SNESQNScaleType, parameter :: SNES_QN_SCALE_NONE = eSNESQNScaleType(1)
    SNESQNScaleType, parameter :: SNES_QN_SCALE_SCALAR = eSNESQNScaleType(2)
    SNESQNScaleType, parameter :: SNES_QN_SCALE_DIAGONAL = eSNESQNScaleType(3)
    SNESQNScaleType, parameter :: SNES_QN_SCALE_JACOBIAN = eSNESQNScaleType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_SCALE_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_SCALE_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_SCALE_SCALAR 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_SCALE_DIAGONAL 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_SCALE_JACOBIAN 
#endif

  type eSNESQNRestartType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESQNRestartType

  SNESQNRestartType, parameter :: PETSC_NULL_SNESQNRESTARTTYPE = eSNESQNRestartType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESQNRESTARTTYPE
#endif
    SNESQNRestartType, parameter :: SNES_QN_RESTART_DEFAULT = eSNESQNRestartType(0)
    SNESQNRestartType, parameter :: SNES_QN_RESTART_NONE = eSNESQNRestartType(1)
    SNESQNRestartType, parameter :: SNES_QN_RESTART_POWELL = eSNESQNRestartType(2)
    SNESQNRestartType, parameter :: SNES_QN_RESTART_PERIODIC = eSNESQNRestartType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_RESTART_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_RESTART_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_RESTART_POWELL 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_RESTART_PERIODIC 
#endif

  type eSNESQNType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESQNType

  SNESQNType, parameter :: PETSC_NULL_SNESQNTYPE = eSNESQNType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESQNTYPE
#endif
    SNESQNType, parameter :: SNES_QN_LBFGS = eSNESQNType(0)
    SNESQNType, parameter :: SNES_QN_BROYDEN = eSNESQNType(1)
    SNESQNType, parameter :: SNES_QN_BADBROYDEN = eSNESQNType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_LBFGS 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_BROYDEN 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_QN_BADBROYDEN 
#endif

  type eSNESCompositeType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESCompositeType

  SNESCompositeType, parameter :: PETSC_NULL_SNESCOMPOSITETYPE = eSNESCompositeType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESCOMPOSITETYPE
#endif
    SNESCompositeType, parameter :: SNES_COMPOSITE_ADDITIVE = eSNESCompositeType(0)
    SNESCompositeType, parameter :: SNES_COMPOSITE_MULTIPLICATIVE = eSNESCompositeType(1)
    SNESCompositeType, parameter :: SNES_COMPOSITE_ADDITIVEOPTIMAL = eSNESCompositeType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_COMPOSITE_ADDITIVE
!DEC$ ATTRIBUTES DLLEXPORT::SNES_COMPOSITE_MULTIPLICATIVE
!DEC$ ATTRIBUTES DLLEXPORT::SNES_COMPOSITE_ADDITIVEOPTIMAL
#endif

  type eSNESFASType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESFASType

  SNESFASType, parameter :: PETSC_NULL_SNESFASTYPE = eSNESFASType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESFASTYPE
#endif
    SNESFASType, parameter :: SNES_FAS_MULTIPLICATIVE = eSNESFASType(0)
    SNESFASType, parameter :: SNES_FAS_ADDITIVE = eSNESFASType(1)
    SNESFASType, parameter :: SNES_FAS_FULL = eSNESFASType(2)
    SNESFASType, parameter :: SNES_FAS_KASKADE = eSNESFASType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FAS_MULTIPLICATIVE
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FAS_ADDITIVE
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FAS_FULL
!DEC$ ATTRIBUTES DLLEXPORT::SNES_FAS_KASKADE
#endif

  type eSNESNewtonALCorrectionType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eSNESNewtonALCorrectionType

  SNESNewtonALCorrectionType, parameter :: PETSC_NULL_SNESNEWTONALCORRECTIONTYPE = eSNESNewtonALCorrectionType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SNESNEWTONALCORRECTIONTYPE
#endif
    SNESNewtonALCorrectionType, parameter :: SNES_NEWTONAL_CORRECTION_EXACT = eSNESNewtonALCorrectionType(0)
    SNESNewtonALCorrectionType, parameter :: SNES_NEWTONAL_CORRECTION_NORMAL = eSNESNewtonALCorrectionType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NEWTONAL_CORRECTION_EXACT 
!DEC$ ATTRIBUTES DLLEXPORT::SNES_NEWTONAL_CORRECTION_NORMAL 
#endif

  CHARACTER(LEN=*), PARAMETER :: SNESNEWTONLS = 'newtonls'
  CHARACTER(LEN=*), PARAMETER :: SNESNEWTONTR = 'newtontr'
  CHARACTER(LEN=*), PARAMETER :: SNESNEWTONTRDC = 'newtontrdc'
  CHARACTER(LEN=*), PARAMETER :: SNESPYTHON = 'python'
  CHARACTER(LEN=*), PARAMETER :: SNESNRICHARDSON = 'nrichardson'
  CHARACTER(LEN=*), PARAMETER :: SNESKSPONLY = 'ksponly'
  CHARACTER(LEN=*), PARAMETER :: SNESKSPTRANSPOSEONLY = 'ksptransposeonly'
  CHARACTER(LEN=*), PARAMETER :: SNESVINEWTONRSLS = 'vinewtonrsls'
  CHARACTER(LEN=*), PARAMETER :: SNESVINEWTONSSLS = 'vinewtonssls'
  CHARACTER(LEN=*), PARAMETER :: SNESNGMRES = 'ngmres'
  CHARACTER(LEN=*), PARAMETER :: SNESQN = 'qn'
  CHARACTER(LEN=*), PARAMETER :: SNESSHELL = 'shell'
  CHARACTER(LEN=*), PARAMETER :: SNESNGS = 'ngs'
  CHARACTER(LEN=*), PARAMETER :: SNESNCG = 'ncg'
  CHARACTER(LEN=*), PARAMETER :: SNESFAS = 'fas'
  CHARACTER(LEN=*), PARAMETER :: SNESMS = 'ms'
  CHARACTER(LEN=*), PARAMETER :: SNESNASM = 'nasm'
  CHARACTER(LEN=*), PARAMETER :: SNESANDERSON = 'anderson'
  CHARACTER(LEN=*), PARAMETER :: SNESASPIN = 'aspin'
  CHARACTER(LEN=*), PARAMETER :: SNESCOMPOSITE = 'composite'
  CHARACTER(LEN=*), PARAMETER :: SNESPATCH = 'patch'
  CHARACTER(LEN=*), PARAMETER :: SNESNEWTONAL = 'newtonal'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNESNEWTONLS
!DEC$ ATTRIBUTES DLLEXPORT::SNESNEWTONTR
!DEC$ ATTRIBUTES DLLEXPORT::SNESNEWTONTRDC
!DEC$ ATTRIBUTES DLLEXPORT::SNESPYTHON
!DEC$ ATTRIBUTES DLLEXPORT::SNESNRICHARDSON
!DEC$ ATTRIBUTES DLLEXPORT::SNESKSPONLY
!DEC$ ATTRIBUTES DLLEXPORT::SNESKSPTRANSPOSEONLY
!DEC$ ATTRIBUTES DLLEXPORT::SNESVINEWTONRSLS
!DEC$ ATTRIBUTES DLLEXPORT::SNESVINEWTONSSLS
!DEC$ ATTRIBUTES DLLEXPORT::SNESNGMRES
!DEC$ ATTRIBUTES DLLEXPORT::SNESQN
!DEC$ ATTRIBUTES DLLEXPORT::SNESSHELL
!DEC$ ATTRIBUTES DLLEXPORT::SNESNGS
!DEC$ ATTRIBUTES DLLEXPORT::SNESNCG
!DEC$ ATTRIBUTES DLLEXPORT::SNESFAS
!DEC$ ATTRIBUTES DLLEXPORT::SNESMS
!DEC$ ATTRIBUTES DLLEXPORT::SNESNASM
!DEC$ ATTRIBUTES DLLEXPORT::SNESANDERSON
!DEC$ ATTRIBUTES DLLEXPORT::SNESASPIN
!DEC$ ATTRIBUTES DLLEXPORT::SNESCOMPOSITE
!DEC$ ATTRIBUTES DLLEXPORT::SNESPATCH
!DEC$ ATTRIBUTES DLLEXPORT::SNESNEWTONAL
#endif

  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHBT = 'bt'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHNLEQERR = 'nleqerr'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHBASIC = 'basic'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHNONE = 'none'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHSECANT = 'secant'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHL2 = 'PETSC_DEPRECATED_MACRO(3,'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHCP = 'cp'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHSHELL = 'shell'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHNCGLINEAR = 'ncglinear'
  CHARACTER(LEN=*), PARAMETER :: SNESLINESEARCHBISECTION = 'bisection'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHBT
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHNLEQERR
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHBASIC
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHNONE
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHSECANT
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHL2
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHCP
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHSHELL
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHNCGLINEAR
!DEC$ ATTRIBUTES DLLEXPORT::SNESLINESEARCHBISECTION
#endif

  CHARACTER(LEN=*), PARAMETER :: SNESMSM62 = 'm62'
  CHARACTER(LEN=*), PARAMETER :: SNESMSEULER = 'euler'
  CHARACTER(LEN=*), PARAMETER :: SNESMSJAMESON83 = 'jameson83'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP11 = 'vltp11'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP21 = 'vltp21'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP31 = 'vltp31'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP41 = 'vltp41'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP51 = 'vltp51'
  CHARACTER(LEN=*), PARAMETER :: SNESMSVLTP61 = 'vltp61'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSM62
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSEULER
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSJAMESON83
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP11
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP21
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP31
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP41
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP51
!DEC$ ATTRIBUTES DLLEXPORT::SNESMSVLTP61
#endif

