#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmsettype_ SNESNASMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmsettype_ snesnasmsettype
#endif
PETSC_EXTERN void snesnasmsettype_(SNES *a, PCASMType *b, PetscErrorCode *ierr)
{
  *ierr = SNESNASMSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmgettype_ SNESNASMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmgettype_ snesnasmgettype
#endif
PETSC_EXTERN void snesnasmgettype_(SNES *a, PCASMType *b, PetscErrorCode *ierr)
{
  *ierr = SNESNASMGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmsetsubdomains_ SNESNASMSETSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmsetsubdomains_ snesnasmsetsubdomains
#endif
PETSC_EXTERN void snesnasmsetsubdomains_(SNES *a, PetscInt *b, SNES c[], VecScatter d[], VecScatter e[], VecScatter f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESNASMSetSubdomains(*a, *b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmsetcomputefinaljacobian_ SNESNASMSETCOMPUTEFINALJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmsetcomputefinaljacobian_ snesnasmsetcomputefinaljacobian
#endif
PETSC_EXTERN void snesnasmsetcomputefinaljacobian_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESNASMSetComputeFinalJacobian(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmsetdamping_ SNESNASMSETDAMPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmsetdamping_ snesnasmsetdamping
#endif
PETSC_EXTERN void snesnasmsetdamping_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = SNESNASMSetDamping(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmgetdamping_ SNESNASMGETDAMPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmgetdamping_ snesnasmgetdamping
#endif
PETSC_EXTERN void snesnasmgetdamping_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESNASMGetDamping(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmgetsnes_ SNESNASMGETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmgetsnes_ snesnasmgetsnes
#endif
PETSC_EXTERN void snesnasmgetsnes_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESNASMGetSNES(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmgetnumber_ SNESNASMGETNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmgetnumber_ snesnasmgetnumber
#endif
PETSC_EXTERN void snesnasmgetnumber_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESNASMGetNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnasmsetweight_ SNESNASMSETWEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnasmsetweight_ snesnasmsetweight
#endif
PETSC_EXTERN void snesnasmsetweight_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = SNESNASMSetWeight(*a, *b);
  if (*ierr) return;
}
