#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsetf_ MATFDCOLORINGSETF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsetf_ matfdcoloringsetf
#endif
PETSC_EXTERN void matfdcoloringsetf_(MatFDColoring *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringSetF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringview_ MATFDCOLORINGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringview_ matfdcoloringview
#endif
PETSC_EXTERN void matfdcoloringview_(MatFDColoring *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatFDColoringView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsetparameters_ MATFDCOLORINGSETPARAMETERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsetparameters_ matfdcoloringsetparameters
#endif
PETSC_EXTERN void matfdcoloringsetparameters_(MatFDColoring *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringSetParameters(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsetblocksize_ MATFDCOLORINGSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsetblocksize_ matfdcoloringsetblocksize
#endif
PETSC_EXTERN void matfdcoloringsetblocksize_(MatFDColoring *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringSetBlockSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsetup_ MATFDCOLORINGSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsetup_ matfdcoloringsetup
#endif
PETSC_EXTERN void matfdcoloringsetup_(Mat *a, ISColoring *b, MatFDColoring *c, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringSetUp(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsetfromoptions_ MATFDCOLORINGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsetfromoptions_ matfdcoloringsetfromoptions
#endif
PETSC_EXTERN void matfdcoloringsetfromoptions_(MatFDColoring *a, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringsettype_ MATFDCOLORINGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringsettype_ matfdcoloringsettype
#endif
PETSC_EXTERN void matfdcoloringsettype_(MatFDColoring *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatFDColoringSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringcreate_ MATFDCOLORINGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringcreate_ matfdcoloringcreate
#endif
PETSC_EXTERN void matfdcoloringcreate_(Mat *a, ISColoring *b, MatFDColoring *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatFDColoringCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringdestroy_ MATFDCOLORINGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringdestroy_ matfdcoloringdestroy
#endif
PETSC_EXTERN void matfdcoloringdestroy_(MatFDColoring *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatFDColoringDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringapply_ MATFDCOLORINGAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringapply_ matfdcoloringapply
#endif
PETSC_EXTERN void matfdcoloringapply_(Mat *a, MatFDColoring *b, Vec *c, void *d, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringApply(*a, *b, *c, d);
  if (*ierr) return;
}
