#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductreplacemats_ MATPRODUCTREPLACEMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductreplacemats_ matproductreplacemats
#endif
PETSC_EXTERN void matproductreplacemats_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = MatProductReplaceMats(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductsetfromoptions_ MATPRODUCTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductsetfromoptions_ matproductsetfromoptions
#endif
PETSC_EXTERN void matproductsetfromoptions_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatProductSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductview_ MATPRODUCTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductview_ matproductview
#endif
PETSC_EXTERN void matproductview_(Mat *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatProductView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductnumeric_ MATPRODUCTNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductnumeric_ matproductnumeric
#endif
PETSC_EXTERN void matproductnumeric_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatProductNumeric(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductsymbolic_ MATPRODUCTSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductsymbolic_ matproductsymbolic
#endif
PETSC_EXTERN void matproductsymbolic_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatProductSymbolic(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductsetfill_ MATPRODUCTSETFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductsetfill_ matproductsetfill
#endif
PETSC_EXTERN void matproductsetfill_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatProductSetFill(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductsetalgorithm_ MATPRODUCTSETALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductsetalgorithm_ matproductsetalgorithm
#endif
PETSC_EXTERN void matproductsetalgorithm_(Mat *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatProductSetAlgorithm(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductgetalgorithm_ MATPRODUCTGETALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductgetalgorithm_ matproductgetalgorithm
#endif
PETSC_EXTERN void matproductgetalgorithm_(Mat *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatProductGetAlgorithm(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductsettype_ MATPRODUCTSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductsettype_ matproductsettype
#endif
PETSC_EXTERN void matproductsettype_(Mat *a, MatProductType *b, PetscErrorCode *ierr)
{
  *ierr = MatProductSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductclear_ MATPRODUCTCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductclear_ matproductclear
#endif
PETSC_EXTERN void matproductclear_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatProductClear(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductcreatewithmat_ MATPRODUCTCREATEWITHMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductcreatewithmat_ matproductcreatewithmat
#endif
PETSC_EXTERN void matproductcreatewithmat_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = MatProductCreateWithMat(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductcreate_ MATPRODUCTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductcreate_ matproductcreate
#endif
PETSC_EXTERN void matproductcreate_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(d);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatProductCreate(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductgettype_ MATPRODUCTGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductgettype_ matproductgettype
#endif
PETSC_EXTERN void matproductgettype_(Mat *a, MatProductType *b, PetscErrorCode *ierr)
{
  *ierr = MatProductGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matproductgetmats_ MATPRODUCTGETMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matproductgetmats_ matproductgetmats
#endif
PETSC_EXTERN void matproductgetmats_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatProductGetMats(*a, b, c, d);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
