#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsetvalueslocalfast_ MATSEQAIJSETVALUESLOCALFAST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsetvalueslocalfast_ matseqaijsetvalueslocalfast
#endif
PETSC_EXTERN void matseqaijsetvalueslocalfast_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], const PetscScalar f[], InsertMode *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  *ierr = MatSeqAIJSetValuesLocalFast(*a, *b, c, *d, e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsettotalpreallocation_ MATSEQAIJSETTOTALPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsettotalpreallocation_ matseqaijsettotalpreallocation
#endif
PETSC_EXTERN void matseqaijsettotalpreallocation_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSeqAIJSetTotalPreallocation(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsetcolumnindices_ MATSEQAIJSETCOLUMNINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsetcolumnindices_ matseqaijsetcolumnindices
#endif
PETSC_EXTERN void matseqaijsetcolumnindices_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSeqAIJSetColumnIndices(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstorevalues_ MATSTOREVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstorevalues_ matstorevalues
#endif
PETSC_EXTERN void matstorevalues_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatStoreValues(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matretrievevalues_ MATRETRIEVEVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matretrievevalues_ matretrievevalues
#endif
PETSC_EXTERN void matretrievevalues_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatRetrieveValues(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqaij_ MATCREATESEQAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqaij_ matcreateseqaij
#endif
PETSC_EXTERN void matcreateseqaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateSeqAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsetpreallocation_ MATSEQAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsetpreallocation_ matseqaijsetpreallocation
#endif
PETSC_EXTERN void matseqaijsetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatSeqAIJSetPreallocation(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsetpreallocationcsr_ MATSEQAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsetpreallocationcsr_ matseqaijsetpreallocationcsr
#endif
PETSC_EXTERN void matseqaijsetpreallocationcsr_(Mat *a, const PetscInt b[], const PetscInt c[], const PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatSeqAIJSetPreallocationCSR(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijkron_ MATSEQAIJKRON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijkron_ matseqaijkron
#endif
PETSC_EXTERN void matseqaijkron_(Mat *a, Mat *b, MatReuse *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatSeqAIJKron(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijgetmaxrownonzeros_ MATSEQAIJGETMAXROWNONZEROS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijgetmaxrownonzeros_ matseqaijgetmaxrownonzeros
#endif
PETSC_EXTERN void matseqaijgetmaxrownonzeros_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSeqAIJGetMaxRowNonzeros(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqaijwitharrays_ MATCREATESEQAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqaijwitharrays_ matcreateseqaijwitharrays
#endif
PETSC_EXTERN void matcreateseqaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt d[], PetscInt e[], PetscScalar f[], Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateSeqAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, d, e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqaijfromtriple_ MATCREATESEQAIJFROMTRIPLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqaijfromtriple_ matcreateseqaijfromtriple
#endif
PETSC_EXTERN void matcreateseqaijfromtriple_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt d[], PetscInt e[], PetscScalar f[], Mat *g, PetscCount *h, PetscBool *i, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateSeqAIJFromTriple(MPI_Comm_f2c(*(a)), *b, *c, d, e, f, g, *h, *i ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqaijsettype_ MATSEQAIJSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqaijsettype_ matseqaijsettype
#endif
PETSC_EXTERN void matseqaijsettype_(Mat *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatSeqAIJSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
