#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcreset_ PCRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcreset_ pcreset
#endif
PETSC_EXTERN void pcreset_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdestroy_ PCDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdestroy_ pcdestroy
#endif
PETSC_EXTERN void pcdestroy_(PC *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PCDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetdiagonalscale_ PCGETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetdiagonalscale_ pcgetdiagonalscale
#endif
PETSC_EXTERN void pcgetdiagonalscale_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCGetDiagonalScale(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetdiagonalscale_ PCSETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetdiagonalscale_ pcsetdiagonalscale
#endif
PETSC_EXTERN void pcsetdiagonalscale_(PC *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = PCSetDiagonalScale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdiagonalscaleleft_ PCDIAGONALSCALELEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdiagonalscaleleft_ pcdiagonalscaleleft
#endif
PETSC_EXTERN void pcdiagonalscaleleft_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCDiagonalScaleLeft(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdiagonalscaleright_ PCDIAGONALSCALERIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdiagonalscaleright_ pcdiagonalscaleright
#endif
PETSC_EXTERN void pcdiagonalscaleright_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCDiagonalScaleRight(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetuseamat_ PCSETUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetuseamat_ pcsetuseamat
#endif
PETSC_EXTERN void pcsetuseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCSetUseAmat(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcseterroriffailure_ PCSETERRORIFFAILURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcseterroriffailure_ pcseterroriffailure
#endif
PETSC_EXTERN void pcseterroriffailure_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCSetErrorIfFailure(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetuseamat_ PCGETUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetuseamat_ pcgetuseamat
#endif
PETSC_EXTERN void pcgetuseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCGetUseAmat(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetkspnestlevel_ PCSETKSPNESTLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetkspnestlevel_ pcsetkspnestlevel
#endif
PETSC_EXTERN void pcsetkspnestlevel_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCSetKSPNestLevel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetkspnestlevel_ PCGETKSPNESTLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetkspnestlevel_ pcgetkspnestlevel
#endif
PETSC_EXTERN void pcgetkspnestlevel_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCGetKSPNestLevel(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccreate_ PCCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccreate_ pccreate
#endif
PETSC_EXTERN void pccreate_(MPI_Fint *a, PC *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapply_ PCAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapply_ pcapply
#endif
PETSC_EXTERN void pcapply_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCApply(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmatapply_ PCMATAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmatapply_ pcmatapply
#endif
PETSC_EXTERN void pcmatapply_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCMatApply(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmatapplytranspose_ PCMATAPPLYTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmatapplytranspose_ pcmatapplytranspose
#endif
PETSC_EXTERN void pcmatapplytranspose_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCMatApplyTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplysymmetricleft_ PCAPPLYSYMMETRICLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplysymmetricleft_ pcapplysymmetricleft
#endif
PETSC_EXTERN void pcapplysymmetricleft_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCApplySymmetricLeft(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplysymmetricright_ PCAPPLYSYMMETRICRIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplysymmetricright_ pcapplysymmetricright
#endif
PETSC_EXTERN void pcapplysymmetricright_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCApplySymmetricRight(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplytranspose_ PCAPPLYTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplytranspose_ pcapplytranspose
#endif
PETSC_EXTERN void pcapplytranspose_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCApplyTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplytransposeexists_ PCAPPLYTRANSPOSEEXISTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplytransposeexists_ pcapplytransposeexists
#endif
PETSC_EXTERN void pcapplytransposeexists_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCApplyTransposeExists(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplybaorab_ PCAPPLYBAORAB
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplybaorab_ pcapplybaorab
#endif
PETSC_EXTERN void pcapplybaorab_(PC *a, PCSide *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = PCApplyBAorAB(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplybaorabtranspose_ PCAPPLYBAORABTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplybaorabtranspose_ pcapplybaorabtranspose
#endif
PETSC_EXTERN void pcapplybaorabtranspose_(PC *a, PCSide *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = PCApplyBAorABTranspose(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplyrichardsonexists_ PCAPPLYRICHARDSONEXISTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplyrichardsonexists_ pcapplyrichardsonexists
#endif
PETSC_EXTERN void pcapplyrichardsonexists_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCApplyRichardsonExists(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcapplyrichardson_ PCAPPLYRICHARDSON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcapplyrichardson_ pcapplyrichardson
#endif
PETSC_EXTERN void pcapplyrichardson_(PC *a, Vec *b, Vec *c, Vec *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscInt *h, PetscBool *i, PetscInt *j, PCRichardsonConvergedReason *k, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(j);
  *ierr = PCApplyRichardson(*a, *b, *c, *d, *e, *f, *g, *h, *i ? PETSC_TRUE : PETSC_FALSE, j, k);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetfailedreason_ PCSETFAILEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetfailedreason_ pcsetfailedreason
#endif
PETSC_EXTERN void pcsetfailedreason_(PC *a, PCFailedReason *b, PetscErrorCode *ierr)
{
  *ierr = PCSetFailedReason(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetfailedreason_ PCGETFAILEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetfailedreason_ pcgetfailedreason
#endif
PETSC_EXTERN void pcgetfailedreason_(PC *a, PCFailedReason *b, PetscErrorCode *ierr)
{
  *ierr = PCGetFailedReason(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcreducefailedreason_ PCREDUCEFAILEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcreducefailedreason_ pcreducefailedreason
#endif
PETSC_EXTERN void pcreducefailedreason_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCReduceFailedReason(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetup_ PCSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetup_ pcsetup
#endif
PETSC_EXTERN void pcsetup_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetuponblocks_ PCSETUPONBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetuponblocks_ pcsetuponblocks
#endif
PETSC_EXTERN void pcsetuponblocks_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCSetUpOnBlocks(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmodifysubmatrices_ PCMODIFYSUBMATRICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmodifysubmatrices_ pcmodifysubmatrices
#endif
PETSC_EXTERN void pcmodifysubmatrices_(PC *a, PetscInt *b, const IS c[], const IS d[], Mat e[], void *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PCModifySubMatrices(*a, *b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetoperators_ PCSETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetoperators_ pcsetoperators
#endif
PETSC_EXTERN void pcsetoperators_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCSetOperators(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetreusepreconditioner_ PCSETREUSEPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetreusepreconditioner_ pcsetreusepreconditioner
#endif
PETSC_EXTERN void pcsetreusepreconditioner_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCSetReusePreconditioner(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetreusepreconditioner_ PCGETREUSEPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetreusepreconditioner_ pcgetreusepreconditioner
#endif
PETSC_EXTERN void pcgetreusepreconditioner_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCGetReusePreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetoperators_ PCGETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetoperators_ pcgetoperators
#endif
PETSC_EXTERN void pcgetoperators_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCGetOperators(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetoperatorsset_ PCGETOPERATORSSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetoperatorsset_ pcgetoperatorsset
#endif
PETSC_EXTERN void pcgetoperatorsset_(PC *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PCGetOperatorsSet(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetmatrix_ PCFACTORGETMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetmatrix_ pcfactorgetmatrix
#endif
PETSC_EXTERN void pcfactorgetmatrix_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCFactorGetMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetoptionsprefix_ PCSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetoptionsprefix_ pcsetoptionsprefix
#endif
PETSC_EXTERN void pcsetoptionsprefix_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcappendoptionsprefix_ PCAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcappendoptionsprefix_ pcappendoptionsprefix
#endif
PETSC_EXTERN void pcappendoptionsprefix_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgetoptionsprefix_ PCGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgetoptionsprefix_ pcgetoptionsprefix
#endif
PETSC_EXTERN void pcgetoptionsprefix_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpresolve_ PCPRESOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpresolve_ pcpresolve
#endif
PETSC_EXTERN void pcpresolve_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  *ierr = PCPreSolve(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpostsolve_ PCPOSTSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpostsolve_ pcpostsolve
#endif
PETSC_EXTERN void pcpostsolve_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  *ierr = PCPostSolve(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcload_ PCLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcload_ pcload
#endif
PETSC_EXTERN void pcload_(PC *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PCLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcviewfromoptions_ PCVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcviewfromoptions_ pcviewfromoptions
#endif
PETSC_EXTERN void pcviewfromoptions_(PC *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PCViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcview_ PCVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcview_ pcview
#endif
PETSC_EXTERN void pcview_(PC *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PCView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccomputeoperator_ PCCOMPUTEOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccomputeoperator_ pccomputeoperator
#endif
PETSC_EXTERN void pccomputeoperator_(PC *a, char *b, Mat *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCComputeOperator(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsetcoordinates_ PCSETCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsetcoordinates_ pcsetcoordinates
#endif
PETSC_EXTERN void pcsetcoordinates_(PC *a, PetscInt *b, PetscInt *c, PetscReal d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = PCSetCoordinates(*a, *b, *c, d);
  if (*ierr) return;
}
