#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetproceqlim_ PCGAMGSETPROCEQLIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetproceqlim_ pcgamgsetproceqlim
#endif
PETSC_EXTERN void pcgamgsetproceqlim_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetProcEqLim(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetcoarseeqlim_ PCGAMGSETCOARSEEQLIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetcoarseeqlim_ pcgamgsetcoarseeqlim
#endif
PETSC_EXTERN void pcgamgsetcoarseeqlim_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetCoarseEqLim(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetrepartition_ PCGAMGSETREPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetrepartition_ pcgamgsetrepartition
#endif
PETSC_EXTERN void pcgamgsetrepartition_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetRepartition(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetusesaesteig_ PCGAMGSETUSESAESTEIG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetusesaesteig_ pcgamgsetusesaesteig
#endif
PETSC_EXTERN void pcgamgsetusesaesteig_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetUseSAEstEig(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetrecomputeesteig_ PCGAMGSETRECOMPUTEESTEIG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetrecomputeesteig_ pcgamgsetrecomputeesteig
#endif
PETSC_EXTERN void pcgamgsetrecomputeesteig_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetRecomputeEstEig(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgseteigenvalues_ PCGAMGSETEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgseteigenvalues_ pcgamgseteigenvalues
#endif
PETSC_EXTERN void pcgamgseteigenvalues_(PC *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetEigenvalues(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetreuseinterpolation_ PCGAMGSETREUSEINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetreuseinterpolation_ pcgamgsetreuseinterpolation
#endif
PETSC_EXTERN void pcgamgsetreuseinterpolation_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetReuseInterpolation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgasmsetuseaggs_ PCGAMGASMSETUSEAGGS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgasmsetuseaggs_ pcgamgasmsetuseaggs
#endif
PETSC_EXTERN void pcgamgasmsetuseaggs_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGASMSetUseAggs(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetparallelcoarsegridsolve_ PCGAMGSETPARALLELCOARSEGRIDSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetparallelcoarsegridsolve_ pcgamgsetparallelcoarsegridsolve
#endif
PETSC_EXTERN void pcgamgsetparallelcoarsegridsolve_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetParallelCoarseGridSolve(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetcpupincoarsegrids_ PCGAMGSETCPUPINCOARSEGRIDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetcpupincoarsegrids_ pcgamgsetcpupincoarsegrids
#endif
PETSC_EXTERN void pcgamgsetcpupincoarsegrids_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetCpuPinCoarseGrids(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetcoarsegridlayouttype_ PCGAMGSETCOARSEGRIDLAYOUTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetcoarsegridlayouttype_ pcgamgsetcoarsegridlayouttype
#endif
PETSC_EXTERN void pcgamgsetcoarsegridlayouttype_(PC *a, PCGAMGLayoutType *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetCoarseGridLayoutType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetnlevels_ PCGAMGSETNLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetnlevels_ pcgamgsetnlevels
#endif
PETSC_EXTERN void pcgamgsetnlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetNlevels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgasmsethem_ PCGAMGASMSETHEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgasmsethem_ pcgamgasmsethem
#endif
PETSC_EXTERN void pcgamgasmsethem_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGASMSetHEM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetthreshold_ PCGAMGSETTHRESHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetthreshold_ pcgamgsetthreshold
#endif
PETSC_EXTERN void pcgamgsetthreshold_(PC *a, PetscReal b[], PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCGAMGSetThreshold(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetrankreductionfactors_ PCGAMGSETRANKREDUCTIONFACTORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetrankreductionfactors_ pcgamgsetrankreductionfactors
#endif
PETSC_EXTERN void pcgamgsetrankreductionfactors_(PC *a, PetscInt b[], PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCGAMGSetRankReductionFactors(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetthresholdscale_ PCGAMGSETTHRESHOLDSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetthresholdscale_ pcgamgsetthresholdscale
#endif
PETSC_EXTERN void pcgamgsetthresholdscale_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCGAMGSetThresholdScale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsettype_ PCGAMGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsettype_ pcgamgsettype
#endif
PETSC_EXTERN void pcgamgsettype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCGAMGSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamggettype_ PCGAMGGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamggettype_ pcgamggettype
#endif
PETSC_EXTERN void pcgamggettype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCGAMGGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgsetinjectionindex_ PCGAMGSETINJECTIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgsetinjectionindex_ pcgamgsetinjectionindex
#endif
PETSC_EXTERN void pcgamgsetinjectionindex_(PC *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PCGAMGSetInjectionIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamginitializepackage_ PCGAMGINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamginitializepackage_ pcgamginitializepackage
#endif
PETSC_EXTERN void pcgamginitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PCGAMGInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgfinalizepackage_ PCGAMGFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgfinalizepackage_ pcgamgfinalizepackage
#endif
PETSC_EXTERN void pcgamgfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PCGAMGFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgamgcreategraph_ PCGAMGCREATEGRAPH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgamgcreategraph_ pcgamgcreategraph
#endif
PETSC_EXTERN void pcgamgcreategraph_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCGAMGCreateGraph(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
