#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetupmatsolvertype_ PCFACTORSETUPMATSOLVERTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetupmatsolvertype_ pcfactorsetupmatsolvertype
#endif
PETSC_EXTERN void pcfactorsetupmatsolvertype_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetUpMatSolverType(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetzeropivot_ PCFACTORSETZEROPIVOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetzeropivot_ pcfactorsetzeropivot
#endif
PETSC_EXTERN void pcfactorsetzeropivot_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetZeroPivot(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetshifttype_ PCFACTORSETSHIFTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetshifttype_ pcfactorsetshifttype
#endif
PETSC_EXTERN void pcfactorsetshifttype_(PC *a, MatFactorShiftType *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetShiftType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetshiftamount_ PCFACTORSETSHIFTAMOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetshiftamount_ pcfactorsetshiftamount
#endif
PETSC_EXTERN void pcfactorsetshiftamount_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetShiftAmount(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetdroptolerance_ PCFACTORSETDROPTOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetdroptolerance_ pcfactorsetdroptolerance
#endif
PETSC_EXTERN void pcfactorsetdroptolerance_(PC *a, PetscReal *b, PetscReal *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetDropTolerance(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetzeropivot_ PCFACTORGETZEROPIVOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetzeropivot_ pcfactorgetzeropivot
#endif
PETSC_EXTERN void pcfactorgetzeropivot_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCFactorGetZeroPivot(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetshiftamount_ PCFACTORGETSHIFTAMOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetshiftamount_ pcfactorgetshiftamount
#endif
PETSC_EXTERN void pcfactorgetshiftamount_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCFactorGetShiftAmount(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetshifttype_ PCFACTORGETSHIFTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetshifttype_ pcfactorgetshifttype
#endif
PETSC_EXTERN void pcfactorgetshifttype_(PC *a, MatFactorShiftType *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorGetShiftType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetlevels_ PCFACTORGETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetlevels_ pcfactorgetlevels
#endif
PETSC_EXTERN void pcfactorgetlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCFactorGetLevels(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetlevels_ PCFACTORSETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetlevels_ pcfactorsetlevels
#endif
PETSC_EXTERN void pcfactorsetlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetLevels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetallowdiagonalfill_ PCFACTORSETALLOWDIAGONALFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetallowdiagonalfill_ pcfactorsetallowdiagonalfill
#endif
PETSC_EXTERN void pcfactorsetallowdiagonalfill_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetAllowDiagonalFill(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetallowdiagonalfill_ PCFACTORGETALLOWDIAGONALFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetallowdiagonalfill_ pcfactorgetallowdiagonalfill
#endif
PETSC_EXTERN void pcfactorgetallowdiagonalfill_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFactorGetAllowDiagonalFill(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorreorderfornonzerodiagonal_ PCFACTORREORDERFORNONZERODIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorreorderfornonzerodiagonal_ pcfactorreorderfornonzerodiagonal
#endif
PETSC_EXTERN void pcfactorreorderfornonzerodiagonal_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorReorderForNonzeroDiagonal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetmatsolvertype_ PCFACTORSETMATSOLVERTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetmatsolvertype_ pcfactorsetmatsolvertype
#endif
PETSC_EXTERN void pcfactorsetmatsolvertype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCFactorSetMatSolverType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetmatsolvertype_ PCFACTORGETMATSOLVERTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetmatsolvertype_ pcfactorgetmatsolvertype
#endif
PETSC_EXTERN void pcfactorgetmatsolvertype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCFactorGetMatSolverType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetfill_ PCFACTORSETFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetfill_ pcfactorsetfill
#endif
PETSC_EXTERN void pcfactorsetfill_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetFill(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetuseinplace_ PCFACTORSETUSEINPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetuseinplace_ pcfactorsetuseinplace
#endif
PETSC_EXTERN void pcfactorsetuseinplace_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetUseInPlace(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorgetuseinplace_ PCFACTORGETUSEINPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorgetuseinplace_ pcfactorgetuseinplace
#endif
PETSC_EXTERN void pcfactorgetuseinplace_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFactorGetUseInPlace(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetmatorderingtype_ PCFACTORSETMATORDERINGTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetmatorderingtype_ pcfactorsetmatorderingtype
#endif
PETSC_EXTERN void pcfactorsetmatorderingtype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCFactorSetMatOrderingType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetcolumnpivot_ PCFACTORSETCOLUMNPIVOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetcolumnpivot_ pcfactorsetcolumnpivot
#endif
PETSC_EXTERN void pcfactorsetcolumnpivot_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetColumnPivot(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetpivotinblocks_ PCFACTORSETPIVOTINBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetpivotinblocks_ pcfactorsetpivotinblocks
#endif
PETSC_EXTERN void pcfactorsetpivotinblocks_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetPivotInBlocks(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfactorsetreusefill_ PCFACTORSETREUSEFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfactorsetreusefill_ pcfactorsetreusefill
#endif
PETSC_EXTERN void pcfactorsetreusefill_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFactorSetReuseFill(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
