#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetlocalsubdomains_ PCASMSETLOCALSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetlocalsubdomains_ pcasmsetlocalsubdomains
#endif
PETSC_EXTERN void pcasmsetlocalsubdomains_(PC *a, PetscInt *b, IS c[], IS d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PCASMSetLocalSubdomains(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsettotalsubdomains_ PCASMSETTOTALSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsettotalsubdomains_ pcasmsettotalsubdomains
#endif
PETSC_EXTERN void pcasmsettotalsubdomains_(PC *a, PetscInt *b, IS c[], IS d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PCASMSetTotalSubdomains(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetoverlap_ PCASMSETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetoverlap_ pcasmsetoverlap
#endif
PETSC_EXTERN void pcasmsetoverlap_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCASMSetOverlap(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsettype_ PCASMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsettype_ pcasmsettype
#endif
PETSC_EXTERN void pcasmsettype_(PC *a, PCASMType *b, PetscErrorCode *ierr)
{
  *ierr = PCASMSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmgettype_ PCASMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmgettype_ pcasmgettype
#endif
PETSC_EXTERN void pcasmgettype_(PC *a, PCASMType *b, PetscErrorCode *ierr)
{
  *ierr = PCASMGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetlocaltype_ PCASMSETLOCALTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetlocaltype_ pcasmsetlocaltype
#endif
PETSC_EXTERN void pcasmsetlocaltype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCASMSetLocalType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmgetlocaltype_ PCASMGETLOCALTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmgetlocaltype_ pcasmgetlocaltype
#endif
PETSC_EXTERN void pcasmgetlocaltype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCASMGetLocalType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetsortindices_ PCASMSETSORTINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetsortindices_ pcasmsetsortindices
#endif
PETSC_EXTERN void pcasmsetsortindices_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCASMSetSortIndices(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetdmsubdomains_ PCASMSETDMSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetdmsubdomains_ pcasmsetdmsubdomains
#endif
PETSC_EXTERN void pcasmsetdmsubdomains_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCASMSetDMSubdomains(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmgetdmsubdomains_ PCASMGETDMSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmgetdmsubdomains_ pcasmgetdmsubdomains
#endif
PETSC_EXTERN void pcasmgetdmsubdomains_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCASMGetDMSubdomains(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmgetsubmattype_ PCASMGETSUBMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmgetsubmattype_ pcasmgetsubmattype
#endif
PETSC_EXTERN void pcasmgetsubmattype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCASMGetSubMatType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcasmsetsubmattype_ PCASMSETSUBMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcasmsetsubmattype_ pcasmsetsubmattype
#endif
PETSC_EXTERN void pcasmsetsubmattype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCASMSetSubMatType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
