#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspload_ KSPLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspload_ kspload
#endif
PETSC_EXTERN void kspload_(KSP *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = KSPLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspview_ KSPVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspview_ kspview
#endif
PETSC_EXTERN void kspview_(KSP *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = KSPView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspviewfromoptions_ KSPVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspviewfromoptions_ kspviewfromoptions
#endif
PETSC_EXTERN void kspviewfromoptions_(KSP *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = KSPViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetnormtype_ KSPSETNORMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetnormtype_ kspsetnormtype
#endif
PETSC_EXTERN void kspsetnormtype_(KSP *a, KSPNormType *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetNormType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetchecknormiteration_ KSPSETCHECKNORMITERATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetchecknormiteration_ kspsetchecknormiteration
#endif
PETSC_EXTERN void kspsetchecknormiteration_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetCheckNormIteration(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetlagnorm_ KSPSETLAGNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetlagnorm_ kspsetlagnorm
#endif
PETSC_EXTERN void kspsetlagnorm_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetLagNorm(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetsupportednorm_ KSPSETSUPPORTEDNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetsupportednorm_ kspsetsupportednorm
#endif
PETSC_EXTERN void kspsetsupportednorm_(KSP *a, KSPNormType *b, PCSide *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = KSPSetSupportedNorm(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetnormtype_ KSPGETNORMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetnormtype_ kspgetnormtype
#endif
PETSC_EXTERN void kspgetnormtype_(KSP *a, KSPNormType *b, PetscErrorCode *ierr)
{
  *ierr = KSPGetNormType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetoperators_ KSPSETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetoperators_ kspsetoperators
#endif
PETSC_EXTERN void kspsetoperators_(KSP *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = KSPSetOperators(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetoperators_ KSPGETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetoperators_ kspgetoperators
#endif
PETSC_EXTERN void kspgetoperators_(KSP *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = KSPGetOperators(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetoperatorsset_ KSPGETOPERATORSSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetoperatorsset_ kspgetoperatorsset
#endif
PETSC_EXTERN void kspgetoperatorsset_(KSP *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = KSPGetOperatorsSet(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetnestlevel_ KSPSETNESTLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetnestlevel_ kspsetnestlevel
#endif
PETSC_EXTERN void kspsetnestlevel_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetNestLevel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetnestlevel_ KSPGETNESTLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetnestlevel_ kspgetnestlevel
#endif
PETSC_EXTERN void kspgetnestlevel_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = KSPGetNestLevel(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcreate_ KSPCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcreate_ kspcreate
#endif
PETSC_EXTERN void kspcreate_(MPI_Fint *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsettype_ KSPSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsettype_ kspsettype
#endif
PETSC_EXTERN void kspsettype_(KSP *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = KSPSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgettype_ KSPGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgettype_ kspgettype
#endif
PETSC_EXTERN void kspgettype_(KSP *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = KSPGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
