#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetglobaltonaturalsf_ DMPLEXSETGLOBALTONATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetglobaltonaturalsf_ dmplexsetglobaltonaturalsf
#endif
PETSC_EXTERN void dmplexsetglobaltonaturalsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetGlobalToNaturalSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetglobaltonaturalsf_ DMPLEXGETGLOBALTONATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetglobaltonaturalsf_ dmplexgetglobaltonaturalsf
#endif
PETSC_EXTERN void dmplexgetglobaltonaturalsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetGlobalToNaturalSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
