#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfcreateembeddedsf_ PETSCSFCREATEEMBEDDEDSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfcreateembeddedsf_ petscsfcreateembeddedsf
#endif
PETSC_EXTERN void petscsfcreateembeddedsf_(PetscSF *a, PetscInt *b, const PetscInt *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscSFCreateEmbeddedSF(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
