#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprkregisterdestroy_ TSMPRKREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprkregisterdestroy_ tsmprkregisterdestroy
#endif
PETSC_EXTERN void tsmprkregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSMPRKRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprkinitializepackage_ TSMPRKINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprkinitializepackage_ tsmprkinitializepackage
#endif
PETSC_EXTERN void tsmprkinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSMPRKInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprkfinalizepackage_ TSMPRKFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprkfinalizepackage_ tsmprkfinalizepackage
#endif
PETSC_EXTERN void tsmprkfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSMPRKFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprkregister_ TSMPRKREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprkregister_ tsmprkregister
#endif
PETSC_EXTERN void tsmprkregister_(char *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscReal f[], const PetscReal g[], const PetscReal h[], const PetscInt i[], const PetscReal j[], const PetscReal k[], const PetscReal l[], const PetscInt m[], const PetscReal n[], const PetscReal o[], const PetscReal p[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLREAL(k);
  CHKFORTRANNULLREAL(l);
  CHKFORTRANNULLINTEGER(m);
  CHKFORTRANNULLREAL(n);
  CHKFORTRANNULLREAL(o);
  CHKFORTRANNULLREAL(p);
  *ierr = TSMPRKRegister(c_a, *b, *c, *d, *e, f, g, h, i, j, k, l, m, n, o, p);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprksettype_ TSMPRKSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprksettype_ tsmprksettype
#endif
PETSC_EXTERN void tsmprksettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSMPRKSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmprkgettype_ TSMPRKGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmprkgettype_ tsmprkgettype
#endif
PETSC_EXTERN void tsmprkgettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSMPRKGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
