#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspsettype_ TSSSPSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspsettype_ tssspsettype
#endif
PETSC_EXTERN void tssspsettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSSSPSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspgettype_ TSSSPGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspgettype_ tssspgettype
#endif
PETSC_EXTERN void tssspgettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSSSPGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspsetnumstages_ TSSSPSETNUMSTAGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspsetnumstages_ tssspsetnumstages
#endif
PETSC_EXTERN void tssspsetnumstages_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSSPSetNumStages(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspgetnumstages_ TSSSPGETNUMSTAGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspgetnumstages_ tssspgetnumstages
#endif
PETSC_EXTERN void tssspgetnumstages_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSSSPGetNumStages(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspinitializepackage_ TSSSPINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspinitializepackage_ tssspinitializepackage
#endif
PETSC_EXTERN void tssspinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSSSPInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssspfinalizepackage_ TSSSPFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssspfinalizepackage_ tssspfinalizepackage
#endif
PETSC_EXTERN void tssspfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSSSPFinalizePackage();
  if (*ierr) return;
}
