#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkregisterdestroy_ TSRKREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkregisterdestroy_ tsrkregisterdestroy
#endif
PETSC_EXTERN void tsrkregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSRKRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkinitializepackage_ TSRKINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkinitializepackage_ tsrkinitializepackage
#endif
PETSC_EXTERN void tsrkinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSRKInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkfinalizepackage_ TSRKFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkfinalizepackage_ tsrkfinalizepackage
#endif
PETSC_EXTERN void tsrkfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSRKFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkregister_ TSRKREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkregister_ tsrkregister
#endif
PETSC_EXTERN void tsrkregister_(char *a, PetscInt *b, PetscInt *c, const PetscReal d[], const PetscReal e[], const PetscReal f[], const PetscReal g[], PetscInt *h, const PetscReal i[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(i);
  *ierr = TSRKRegister(c_a, *b, *c, d, e, f, g, *h, i);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkgetorder_ TSRKGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkgetorder_ tsrkgetorder
#endif
PETSC_EXTERN void tsrkgetorder_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSRKGetOrder(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrksettype_ TSRKSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrksettype_ tsrksettype
#endif
PETSC_EXTERN void tsrksettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSRKSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkgettype_ TSRKGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkgettype_ tsrkgettype
#endif
PETSC_EXTERN void tsrkgettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSRKGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrksetmultirate_ TSRKSETMULTIRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrksetmultirate_ tsrksetmultirate
#endif
PETSC_EXTERN void tsrksetmultirate_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSRKSetMultirate(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrkgetmultirate_ TSRKGETMULTIRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrkgetmultirate_ tsrkgetmultirate
#endif
PETSC_EXTERN void tsrkgetmultirate_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSRKGetMultirate(*a, b);
  if (*ierr) return;
}
