#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggpuflops_ PETSCLOGGPUFLOPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggpuflops_ petscloggpuflops
#endif
PETSC_EXTERN void petscloggpuflops_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuFlops(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputimeadd_ PETSCLOGGPUTIMEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputimeadd_ petscloggputimeadd
#endif
PETSC_EXTERN void petscloggputimeadd_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuTimeAdd(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogcputogpu_ PETSCLOGCPUTOGPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogcputogpu_ petsclogcputogpu
#endif
PETSC_EXTERN void petsclogcputogpu_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogCpuToGpu(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputocpu_ PETSCLOGGPUTOCPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputocpu_ petscloggputocpu
#endif
PETSC_EXTERN void petscloggputocpu_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuToCpu(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogcputogpuscalar_ PETSCLOGCPUTOGPUSCALAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogcputogpuscalar_ petsclogcputogpuscalar
#endif
PETSC_EXTERN void petsclogcputogpuscalar_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogCpuToGpuScalar(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputocpuscalar_ PETSCLOGGPUTOCPUSCALAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputocpuscalar_ petscloggputocpuscalar
#endif
PETSC_EXTERN void petscloggputocpuscalar_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuToCpuScalar(*a);
  if (*ierr) return;
}
