#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsctestfile_ PETSCTESTFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsctestfile_ petsctestfile
#endif
PETSC_EXTERN void petsctestfile_(char a[], char *b, PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscTestFile(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsctestdirectory_ PETSCTESTDIRECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsctestdirectory_ petsctestdirectory
#endif
PETSC_EXTERN void petsctestdirectory_(char a[], char *b, PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscTestDirectory(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscls_ PETSCLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscls_ petscls
#endif
PETSC_EXTERN void petscls_(MPI_Fint *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscLs(MPI_Comm_f2c(*(a)), c_b, c, l_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
