#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorcreate_ PETSCREGRESSORCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorcreate_ petscregressorcreate
#endif
PETSC_EXTERN void petscregressorcreate_(MPI_Fint *a, PetscRegressor *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscRegressorCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorview_ PETSCREGRESSORVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorview_ petscregressorview
#endif
PETSC_EXTERN void petscregressorview_(PetscRegressor *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscRegressorView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorviewfromoptions_ PETSCREGRESSORVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorviewfromoptions_ petscregressorviewfromoptions
#endif
PETSC_EXTERN void petscregressorviewfromoptions_(PetscRegressor *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscRegressorViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorsetfromoptions_ PETSCREGRESSORSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorsetfromoptions_ petscregressorsetfromoptions
#endif
PETSC_EXTERN void petscregressorsetfromoptions_(PetscRegressor *a, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorsetup_ PETSCREGRESSORSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorsetup_ petscregressorsetup
#endif
PETSC_EXTERN void petscregressorsetup_(PetscRegressor *a, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorfit_ PETSCREGRESSORFIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorfit_ petscregressorfit
#endif
PETSC_EXTERN void petscregressorfit_(PetscRegressor *a, Mat *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorFit(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorpredict_ PETSCREGRESSORPREDICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorpredict_ petscregressorpredict
#endif
PETSC_EXTERN void petscregressorpredict_(PetscRegressor *a, Mat *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorPredict(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorreset_ PETSCREGRESSORRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorreset_ petscregressorreset
#endif
PETSC_EXTERN void petscregressorreset_(PetscRegressor *a, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressordestroy_ PETSCREGRESSORDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressordestroy_ petscregressordestroy
#endif
PETSC_EXTERN void petscregressordestroy_(PetscRegressor *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscRegressorDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorsettype_ PETSCREGRESSORSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorsettype_ petscregressorsettype
#endif
PETSC_EXTERN void petscregressorsettype_(PetscRegressor *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscRegressorSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorgettype_ PETSCREGRESSORGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorgettype_ petscregressorgettype
#endif
PETSC_EXTERN void petscregressorgettype_(PetscRegressor *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscRegressorGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorsetregularizerweight_ PETSCREGRESSORSETREGULARIZERWEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorsetregularizerweight_ petscregressorsetregularizerweight
#endif
PETSC_EXTERN void petscregressorsetregularizerweight_(PetscRegressor *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorSetRegularizerWeight(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorgettao_ PETSCREGRESSORGETTAO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorgettao_ petscregressorgettao
#endif
PETSC_EXTERN void petscregressorgettao_(PetscRegressor *a, Tao *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscRegressorGetTao(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorsetoptionsprefix_ PETSCREGRESSORSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorsetoptionsprefix_ petscregressorsetoptionsprefix
#endif
PETSC_EXTERN void petscregressorsetoptionsprefix_(PetscRegressor *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscRegressorSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorappendoptionsprefix_ PETSCREGRESSORAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorappendoptionsprefix_ petscregressorappendoptionsprefix
#endif
PETSC_EXTERN void petscregressorappendoptionsprefix_(PetscRegressor *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscRegressorAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorgetoptionsprefix_ PETSCREGRESSORGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorgetoptionsprefix_ petscregressorgetoptionsprefix
#endif
PETSC_EXTERN void petscregressorgetoptionsprefix_(PetscRegressor *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscRegressorGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
