#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterpetsctofftw_ VECSCATTERPETSCTOFFTW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterpetsctofftw_ vecscatterpetsctofftw
#endif
PETSC_EXTERN void vecscatterpetsctofftw_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecScatterPetscToFFTW(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscatterfftwtopetsc_ VECSCATTERFFTWTOPETSC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscatterfftwtopetsc_ vecscatterfftwtopetsc
#endif
PETSC_EXTERN void vecscatterfftwtopetsc_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecScatterFFTWToPetsc(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatevecsfftw_ MATCREATEVECSFFTW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatevecsfftw_ matcreatevecsfftw
#endif
PETSC_EXTERN void matcreatevecsfftw_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateVecsFFTW(*a, b, c, d);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
