#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeextremesingularvalues_ KSPCOMPUTEEXTREMESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeextremesingularvalues_ kspcomputeextremesingularvalues
#endif
PETSC_EXTERN void kspcomputeextremesingularvalues_(KSP *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = KSPComputeExtremeSingularValues(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeeigenvalues_ KSPCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeeigenvalues_ kspcomputeeigenvalues
#endif
PETSC_EXTERN void kspcomputeeigenvalues_(KSP *a, PetscInt *b, PetscReal c[], PetscReal d[], PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = KSPComputeEigenvalues(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeritz_ KSPCOMPUTERITZ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeritz_ kspcomputeritz
#endif
PETSC_EXTERN void kspcomputeritz_(KSP *a, PetscBool *b, PetscBool *c, PetscInt *d, Vec e[], PetscReal f[], PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = KSPComputeRitz(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetuponblocks_ KSPSETUPONBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetuponblocks_ kspsetuponblocks
#endif
PETSC_EXTERN void kspsetuponblocks_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPSetUpOnBlocks(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetreusepreconditioner_ KSPSETREUSEPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetreusepreconditioner_ kspsetreusepreconditioner
#endif
PETSC_EXTERN void kspsetreusepreconditioner_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetReusePreconditioner(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetreusepreconditioner_ KSPGETREUSEPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetreusepreconditioner_ kspgetreusepreconditioner
#endif
PETSC_EXTERN void kspgetreusepreconditioner_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetReusePreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetskippcsetfromoptions_ KSPSETSKIPPCSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetskippcsetfromoptions_ kspsetskippcsetfromoptions
#endif
PETSC_EXTERN void kspsetskippcsetfromoptions_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetSkipPCSetFromOptions(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetup_ KSPSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetup_ kspsetup
#endif
PETSC_EXTERN void kspsetup_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergedreasonview_ KSPCONVERGEDREASONVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergedreasonview_ kspconvergedreasonview
#endif
PETSC_EXTERN void kspconvergedreasonview_(KSP *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = KSPConvergedReasonView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergedreasonviewcancel_ KSPCONVERGEDREASONVIEWCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergedreasonviewcancel_ kspconvergedreasonviewcancel
#endif
PETSC_EXTERN void kspconvergedreasonviewcancel_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedReasonViewCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergedreasonviewfromoptions_ KSPCONVERGEDREASONVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergedreasonviewfromoptions_ kspconvergedreasonviewfromoptions
#endif
PETSC_EXTERN void kspconvergedreasonviewfromoptions_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPConvergedReasonViewFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspconvergedrateview_ KSPCONVERGEDRATEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspconvergedrateview_ kspconvergedrateview
#endif
PETSC_EXTERN void kspconvergedrateview_(KSP *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = KSPConvergedRateView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsolve_ KSPSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsolve_ kspsolve
#endif
PETSC_EXTERN void kspsolve_(KSP *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = KSPSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsolvetranspose_ KSPSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsolvetranspose_ kspsolvetranspose
#endif
PETSC_EXTERN void kspsolvetranspose_(KSP *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = KSPSolveTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmatsolve_ KSPMATSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmatsolve_ kspmatsolve
#endif
PETSC_EXTERN void kspmatsolve_(KSP *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = KSPMatSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmatsolvetranspose_ KSPMATSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmatsolvetranspose_ kspmatsolvetranspose
#endif
PETSC_EXTERN void kspmatsolvetranspose_(KSP *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = KSPMatSolveTranspose(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetmatsolvebatchsize_ KSPSETMATSOLVEBATCHSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetmatsolvebatchsize_ kspsetmatsolvebatchsize
#endif
PETSC_EXTERN void kspsetmatsolvebatchsize_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetMatSolveBatchSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetmatsolvebatchsize_ KSPGETMATSOLVEBATCHSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetmatsolvebatchsize_ kspgetmatsolvebatchsize
#endif
PETSC_EXTERN void kspgetmatsolvebatchsize_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = KSPGetMatSolveBatchSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspresetviewers_ KSPRESETVIEWERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspresetviewers_ kspresetviewers
#endif
PETSC_EXTERN void kspresetviewers_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPResetViewers(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspreset_ KSPRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspreset_ kspreset
#endif
PETSC_EXTERN void kspreset_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspdestroy_ KSPDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspdestroy_ kspdestroy
#endif
PETSC_EXTERN void kspdestroy_(KSP *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = KSPDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetpcside_ KSPSETPCSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetpcside_ kspsetpcside
#endif
PETSC_EXTERN void kspsetpcside_(KSP *a, PCSide *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetPCSide(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetpcside_ KSPGETPCSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetpcside_ kspgetpcside
#endif
PETSC_EXTERN void kspgetpcside_(KSP *a, PCSide *b, PetscErrorCode *ierr)
{
  *ierr = KSPGetPCSide(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgettolerances_ KSPGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgettolerances_ kspgettolerances
#endif
PETSC_EXTERN void kspgettolerances_(KSP *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = KSPGetTolerances(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsettolerances_ KSPSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsettolerances_ kspsettolerances
#endif
PETSC_EXTERN void kspsettolerances_(KSP *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = KSPSetTolerances(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetminimumiterations_ KSPSETMINIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetminimumiterations_ kspsetminimumiterations
#endif
PETSC_EXTERN void kspsetminimumiterations_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetMinimumIterations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetminimumiterations_ KSPGETMINIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetminimumiterations_ kspgetminimumiterations
#endif
PETSC_EXTERN void kspgetminimumiterations_(KSP *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = KSPGetMinimumIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetinitialguessnonzero_ KSPSETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetinitialguessnonzero_ kspsetinitialguessnonzero
#endif
PETSC_EXTERN void kspsetinitialguessnonzero_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetInitialGuessNonzero(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetinitialguessnonzero_ KSPGETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetinitialguessnonzero_ kspgetinitialguessnonzero
#endif
PETSC_EXTERN void kspgetinitialguessnonzero_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetInitialGuessNonzero(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspseterrorifnotconverged_ KSPSETERRORIFNOTCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspseterrorifnotconverged_ kspseterrorifnotconverged
#endif
PETSC_EXTERN void kspseterrorifnotconverged_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetErrorIfNotConverged(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgeterrorifnotconverged_ KSPGETERRORIFNOTCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgeterrorifnotconverged_ kspgeterrorifnotconverged
#endif
PETSC_EXTERN void kspgeterrorifnotconverged_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetErrorIfNotConverged(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetinitialguessknoll_ KSPSETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetinitialguessknoll_ kspsetinitialguessknoll
#endif
PETSC_EXTERN void kspsetinitialguessknoll_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetInitialGuessKnoll(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetinitialguessknoll_ KSPGETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetinitialguessknoll_ kspgetinitialguessknoll
#endif
PETSC_EXTERN void kspgetinitialguessknoll_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetInitialGuessKnoll(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetcomputesingularvalues_ KSPGETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetcomputesingularvalues_ kspgetcomputesingularvalues
#endif
PETSC_EXTERN void kspgetcomputesingularvalues_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetComputeSingularValues(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetcomputesingularvalues_ KSPSETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetcomputesingularvalues_ kspsetcomputesingularvalues
#endif
PETSC_EXTERN void kspsetcomputesingularvalues_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetComputeSingularValues(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetcomputeeigenvalues_ KSPGETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetcomputeeigenvalues_ kspgetcomputeeigenvalues
#endif
PETSC_EXTERN void kspgetcomputeeigenvalues_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetComputeEigenvalues(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetcomputeeigenvalues_ KSPSETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetcomputeeigenvalues_ kspsetcomputeeigenvalues
#endif
PETSC_EXTERN void kspsetcomputeeigenvalues_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetComputeEigenvalues(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetcomputeritz_ KSPSETCOMPUTERITZ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetcomputeritz_ kspsetcomputeritz
#endif
PETSC_EXTERN void kspsetcomputeritz_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetComputeRitz(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetrhs_ KSPGETRHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetrhs_ kspgetrhs
#endif
PETSC_EXTERN void kspgetrhs_(KSP *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGetRhs(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetsolution_ KSPGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetsolution_ kspgetsolution
#endif
PETSC_EXTERN void kspgetsolution_(KSP *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGetSolution(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetpc_ KSPSETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetpc_ kspsetpc
#endif
PETSC_EXTERN void kspsetpc_(KSP *a, PC *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetPC(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetpc_ KSPGETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetpc_ kspgetpc
#endif
PETSC_EXTERN void kspgetpc_(KSP *a, PC *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGetPC(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitor_ KSPMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitor_ kspmonitor
#endif
PETSC_EXTERN void kspmonitor_(KSP *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = KSPMonitor(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorcancel_ KSPMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorcancel_ kspmonitorcancel
#endif
PETSC_EXTERN void kspmonitorcancel_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetmonitorcontext_ KSPGETMONITORCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetmonitorcontext_ kspgetmonitorcontext
#endif
PETSC_EXTERN void kspgetmonitorcontext_(KSP *a, void *b, PetscErrorCode *ierr)
{
  *ierr = KSPGetMonitorContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetresidualhistory_ KSPSETRESIDUALHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetresidualhistory_ kspsetresidualhistory
#endif
PETSC_EXTERN void kspsetresidualhistory_(KSP *a, PetscReal b[], PetscCount *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = KSPSetResidualHistory(*a, b, *c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspseterrorhistory_ KSPSETERRORHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspseterrorhistory_ kspseterrorhistory
#endif
PETSC_EXTERN void kspseterrorhistory_(KSP *a, PetscReal b[], PetscCount *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = KSPSetErrorHistory(*a, b, *c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeconvergencerate_ KSPCOMPUTECONVERGENCERATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeconvergencerate_ kspcomputeconvergencerate
#endif
PETSC_EXTERN void kspcomputeconvergencerate_(KSP *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = KSPComputeConvergenceRate(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetconvergencecontext_ KSPGETCONVERGENCECONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetconvergencecontext_ kspgetconvergencecontext
#endif
PETSC_EXTERN void kspgetconvergencecontext_(KSP *a, void *b, PetscErrorCode *ierr)
{
  *ierr = KSPGetConvergenceContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspbuildsolution_ KSPBUILDSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspbuildsolution_ kspbuildsolution
#endif
PETSC_EXTERN void kspbuildsolution_(KSP *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = KSPBuildSolution(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspbuildresidual_ KSPBUILDRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspbuildresidual_ kspbuildresidual
#endif
PETSC_EXTERN void kspbuildresidual_(KSP *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = KSPBuildResidual(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetdiagonalscale_ KSPSETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetdiagonalscale_ kspsetdiagonalscale
#endif
PETSC_EXTERN void kspsetdiagonalscale_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetDiagonalScale(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetdiagonalscale_ KSPGETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetdiagonalscale_ kspgetdiagonalscale
#endif
PETSC_EXTERN void kspgetdiagonalscale_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetDiagonalScale(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetdiagonalscalefix_ KSPSETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetdiagonalscalefix_ kspsetdiagonalscalefix
#endif
PETSC_EXTERN void kspsetdiagonalscalefix_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetDiagonalScaleFix(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetdiagonalscalefix_ KSPGETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetdiagonalscalefix_ kspgetdiagonalscalefix
#endif
PETSC_EXTERN void kspgetdiagonalscalefix_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = KSPGetDiagonalScaleFix(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetuseexplicittranspose_ KSPSETUSEEXPLICITTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetuseexplicittranspose_ kspsetuseexplicittranspose
#endif
PETSC_EXTERN void kspsetuseexplicittranspose_(KSP *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetUseExplicitTranspose(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
