#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeoperator_ KSPCOMPUTEOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeoperator_ kspcomputeoperator
#endif
PETSC_EXTERN void kspcomputeoperator_(KSP *a, char *b, Mat *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = KSPComputeOperator(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspcomputeeigenvaluesexplicitly_ KSPCOMPUTEEIGENVALUESEXPLICITLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspcomputeeigenvaluesexplicitly_ kspcomputeeigenvaluesexplicitly
#endif
PETSC_EXTERN void kspcomputeeigenvaluesexplicitly_(KSP *a, PetscInt *b, PetscReal c[], PetscReal d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = KSPComputeEigenvaluesExplicitly(*a, *b, c, d);
  if (*ierr) return;
}
