#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetdm_ VECGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetdm_ vecgetdm
#endif
PETSC_EXTERN void vecgetdm_(Vec *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetdm_ VECSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetdm_ vecsetdm
#endif
PETSC_EXTERN void vecsetdm_(Vec *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = VecSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetdm_ MATGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetdm_ matgetdm
#endif
PETSC_EXTERN void matgetdm_(Mat *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetdm_ MATSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetdm_ matsetdm
#endif
PETSC_EXTERN void matsetdm_(Mat *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = MatSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfdcoloringusedm_ MATFDCOLORINGUSEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfdcoloringusedm_ matfdcoloringusedm
#endif
PETSC_EXTERN void matfdcoloringusedm_(Mat *a, MatFDColoring *b, PetscErrorCode *ierr)
{
  *ierr = MatFDColoringUseDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreate_ DMCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreate_ dmcreate
#endif
PETSC_EXTERN void dmcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmclone_ DMCLONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmclone_ dmclone
#endif
PETSC_EXTERN void dmclone_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMClone(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetvectype_ DMSETVECTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetvectype_ dmsetvectype
#endif
PETSC_EXTERN void dmsetvectype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetVecType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetvectype_ DMGETVECTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetvectype_ dmgetvectype
#endif
PETSC_EXTERN void dmgetvectype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMGetVecType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetiscoloringtype_ DMSETISCOLORINGTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetiscoloringtype_ dmsetiscoloringtype
#endif
PETSC_EXTERN void dmsetiscoloringtype_(DM *a, ISColoringType *b, PetscErrorCode *ierr)
{
  *ierr = DMSetISColoringType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetiscoloringtype_ DMGETISCOLORINGTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetiscoloringtype_ dmgetiscoloringtype
#endif
PETSC_EXTERN void dmgetiscoloringtype_(DM *a, ISColoringType *b, PetscErrorCode *ierr)
{
  *ierr = DMGetISColoringType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetmattype_ DMSETMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetmattype_ dmsetmattype
#endif
PETSC_EXTERN void dmsetmattype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetMatType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetmattype_ DMGETMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetmattype_ dmgetmattype
#endif
PETSC_EXTERN void dmgetmattype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMGetMatType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetoptionsprefix_ DMSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetoptionsprefix_ dmsetoptionsprefix
#endif
PETSC_EXTERN void dmsetoptionsprefix_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmappendoptionsprefix_ DMAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmappendoptionsprefix_ dmappendoptionsprefix
#endif
PETSC_EXTERN void dmappendoptionsprefix_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetoptionsprefix_ DMGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetoptionsprefix_ dmgetoptionsprefix
#endif
PETSC_EXTERN void dmgetoptionsprefix_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdestroy_ DMDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdestroy_ dmdestroy
#endif
PETSC_EXTERN void dmdestroy_(DM *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetup_ DMSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetup_ dmsetup
#endif
PETSC_EXTERN void dmsetup_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetfromoptions_ DMSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetfromoptions_ dmsetfromoptions
#endif
PETSC_EXTERN void dmsetfromoptions_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmviewfromoptions_ DMVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmviewfromoptions_ dmviewfromoptions
#endif
PETSC_EXTERN void dmviewfromoptions_(DM *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmview_ DMVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmview_ dmview
#endif
PETSC_EXTERN void dmview_(DM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreateglobalvector_ DMCREATEGLOBALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreateglobalvector_ dmcreateglobalvector
#endif
PETSC_EXTERN void dmcreateglobalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMCreateGlobalVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatelocalvector_ DMCREATELOCALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatelocalvector_ dmcreatelocalvector
#endif
PETSC_EXTERN void dmcreatelocalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMCreateLocalVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlocaltoglobalmapping_ DMGETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlocaltoglobalmapping_ dmgetlocaltoglobalmapping
#endif
PETSC_EXTERN void dmgetlocaltoglobalmapping_(DM *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetLocalToGlobalMapping(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetblocksize_ DMGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetblocksize_ dmgetblocksize
#endif
PETSC_EXTERN void dmgetblocksize_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreateinterpolation_ DMCREATEINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreateinterpolation_ dmcreateinterpolation
#endif
PETSC_EXTERN void dmcreateinterpolation_(DM *a, DM *b, Mat *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMCreateInterpolation(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreateinterpolationscale_ DMCREATEINTERPOLATIONSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreateinterpolationscale_ dmcreateinterpolationscale
#endif
PETSC_EXTERN void dmcreateinterpolationscale_(DM *a, DM *b, Mat *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMCreateInterpolationScale(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreaterestriction_ DMCREATERESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreaterestriction_ dmcreaterestriction
#endif
PETSC_EXTERN void dmcreaterestriction_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateRestriction(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreateinjection_ DMCREATEINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreateinjection_ dmcreateinjection
#endif
PETSC_EXTERN void dmcreateinjection_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateInjection(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatemassmatrix_ DMCREATEMASSMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatemassmatrix_ dmcreatemassmatrix
#endif
PETSC_EXTERN void dmcreatemassmatrix_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateMassMatrix(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatemassmatrixlumped_ DMCREATEMASSMATRIXLUMPED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatemassmatrixlumped_ dmcreatemassmatrixlumped
#endif
PETSC_EXTERN void dmcreatemassmatrixlumped_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateMassMatrixLumped(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreategradientmatrix_ DMCREATEGRADIENTMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreategradientmatrix_ dmcreategradientmatrix
#endif
PETSC_EXTERN void dmcreategradientmatrix_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateGradientMatrix(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatecoloring_ DMCREATECOLORING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatecoloring_ dmcreatecoloring
#endif
PETSC_EXTERN void dmcreatecoloring_(DM *a, ISColoringType *b, ISColoring *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCreateColoring(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatematrix_ DMCREATEMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatematrix_ dmcreatematrix
#endif
PETSC_EXTERN void dmcreatematrix_(DM *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMCreateMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetmatrixpreallocateskip_ DMSETMATRIXPREALLOCATESKIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetmatrixpreallocateskip_ dmsetmatrixpreallocateskip
#endif
PETSC_EXTERN void dmsetmatrixpreallocateskip_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSetMatrixPreallocateSkip(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetmatrixpreallocateonly_ DMSETMATRIXPREALLOCATEONLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetmatrixpreallocateonly_ dmsetmatrixpreallocateonly
#endif
PETSC_EXTERN void dmsetmatrixpreallocateonly_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSetMatrixPreallocateOnly(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetmatrixstructureonly_ DMSETMATRIXSTRUCTUREONLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetmatrixstructureonly_ dmsetmatrixstructureonly
#endif
PETSC_EXTERN void dmsetmatrixstructureonly_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSetMatrixStructureOnly(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetblockingtype_ DMSETBLOCKINGTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetblockingtype_ dmsetblockingtype
#endif
PETSC_EXTERN void dmsetblockingtype_(DM *a, DMBlockingType *b, PetscErrorCode *ierr)
{
  *ierr = DMSetBlockingType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetblockingtype_ DMGETBLOCKINGTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetblockingtype_ dmgetblockingtype
#endif
PETSC_EXTERN void dmgetblockingtype_(DM *a, DMBlockingType *b, PetscErrorCode *ierr)
{
  *ierr = DMGetBlockingType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatesubdm_ DMCREATESUBDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatesubdm_ dmcreatesubdm
#endif
PETSC_EXTERN void dmcreatesubdm_(DM *a, PetscInt *b, const PetscInt c[], IS *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMCreateSubDM(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmrefine_ DMREFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmrefine_ dmrefine
#endif
PETSC_EXTERN void dmrefine_(DM *a, MPI_Fint *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMRefine(*a, MPI_Comm_f2c(*(b)), c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolate_ DMINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolate_ dminterpolate
#endif
PETSC_EXTERN void dminterpolate_(DM *a, Mat *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMInterpolate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolatesolution_ DMINTERPOLATESOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolatesolution_ dminterpolatesolution
#endif
PETSC_EXTERN void dminterpolatesolution_(DM *a, DM *b, Mat *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMInterpolateSolution(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetrefinelevel_ DMGETREFINELEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetrefinelevel_ dmgetrefinelevel
#endif
PETSC_EXTERN void dmgetrefinelevel_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetRefineLevel(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetrefinelevel_ DMSETREFINELEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetrefinelevel_ dmsetrefinelevel
#endif
PETSC_EXTERN void dmsetrefinelevel_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSetRefineLevel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmextrude_ DMEXTRUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmextrude_ dmextrude
#endif
PETSC_EXTERN void dmextrude_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMExtrude(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhasbasistransform_ DMHASBASISTRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhasbasistransform_ dmhasbasistransform
#endif
PETSC_EXTERN void dmhasbasistransform_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasBasisTransform(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopytransform_ DMCOPYTRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopytransform_ dmcopytransform
#endif
PETSC_EXTERN void dmcopytransform_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMCopyTransform(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocal_ DMGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocal_ dmglobaltolocal
#endif
PETSC_EXTERN void dmglobaltolocal_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocal(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocalbegin_ DMGLOBALTOLOCALBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocalbegin_ dmglobaltolocalbegin
#endif
PETSC_EXTERN void dmglobaltolocalbegin_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocalBegin(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocalend_ DMGLOBALTOLOCALEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocalend_ dmglobaltolocalend
#endif
PETSC_EXTERN void dmglobaltolocalend_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocalEnd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltoglobal_ DMLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltoglobal_ dmlocaltoglobal
#endif
PETSC_EXTERN void dmlocaltoglobal_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToGlobal(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltoglobalbegin_ DMLOCALTOGLOBALBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltoglobalbegin_ dmlocaltoglobalbegin
#endif
PETSC_EXTERN void dmlocaltoglobalbegin_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToGlobalBegin(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltoglobalend_ DMLOCALTOGLOBALEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltoglobalend_ dmlocaltoglobalend
#endif
PETSC_EXTERN void dmlocaltoglobalend_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToGlobalEnd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltolocalbegin_ DMLOCALTOLOCALBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltolocalbegin_ dmlocaltolocalbegin
#endif
PETSC_EXTERN void dmlocaltolocalbegin_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToLocalBegin(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltolocalend_ DMLOCALTOLOCALEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltolocalend_ dmlocaltolocalend
#endif
PETSC_EXTERN void dmlocaltolocalend_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToLocalEnd(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcoarsen_ DMCOARSEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcoarsen_ dmcoarsen
#endif
PETSC_EXTERN void dmcoarsen_(DM *a, MPI_Fint *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCoarsen(*a, MPI_Comm_f2c(*(b)), c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmrestrict_ DMRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmrestrict_ dmrestrict
#endif
PETSC_EXTERN void dmrestrict_(DM *a, Mat *b, Vec *c, Mat *d, DM *e, PetscErrorCode *ierr)
{
  *ierr = DMRestrict(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsubdomainrestrict_ DMSUBDOMAINRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsubdomainrestrict_ dmsubdomainrestrict
#endif
PETSC_EXTERN void dmsubdomainrestrict_(DM *a, VecScatter *b, VecScatter *c, DM *d, PetscErrorCode *ierr)
{
  *ierr = DMSubDomainRestrict(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoarsenlevel_ DMGETCOARSENLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoarsenlevel_ dmgetcoarsenlevel
#endif
PETSC_EXTERN void dmgetcoarsenlevel_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetCoarsenLevel(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoarsenlevel_ DMSETCOARSENLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoarsenlevel_ dmsetcoarsenlevel
#endif
PETSC_EXTERN void dmsetcoarsenlevel_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoarsenLevel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmrefinehierarchy_ DMREFINEHIERARCHY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmrefinehierarchy_ dmrefinehierarchy
#endif
PETSC_EXTERN void dmrefinehierarchy_(DM *a, PetscInt *b, DM c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMRefineHierarchy(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcoarsenhierarchy_ DMCOARSENHIERARCHY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcoarsenhierarchy_ dmcoarsenhierarchy
#endif
PETSC_EXTERN void dmcoarsenhierarchy_(DM *a, PetscInt *b, DM c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCoarsenHierarchy(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetapplicationcontext_ DMSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetapplicationcontext_ dmsetapplicationcontext
#endif
PETSC_EXTERN void dmsetapplicationcontext_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMSetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetapplicationcontext_ DMGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetapplicationcontext_ dmgetapplicationcontext
#endif
PETSC_EXTERN void dmgetapplicationcontext_(DM *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = DMGetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhasvariablebounds_ DMHASVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhasvariablebounds_ dmhasvariablebounds
#endif
PETSC_EXTERN void dmhasvariablebounds_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasVariableBounds(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcomputevariablebounds_ DMCOMPUTEVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcomputevariablebounds_ dmcomputevariablebounds
#endif
PETSC_EXTERN void dmcomputevariablebounds_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMComputeVariableBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhascoloring_ DMHASCOLORING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhascoloring_ dmhascoloring
#endif
PETSC_EXTERN void dmhascoloring_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasColoring(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhascreaterestriction_ DMHASCREATERESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhascreaterestriction_ dmhascreaterestriction
#endif
PETSC_EXTERN void dmhascreaterestriction_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasCreateRestriction(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhascreateinjection_ DMHASCREATEINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhascreateinjection_ dmhascreateinjection
#endif
PETSC_EXTERN void dmhascreateinjection_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasCreateInjection(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsettype_ DMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsettype_ dmsettype
#endif
PETSC_EXTERN void dmsettype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgettype_ DMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgettype_ dmgettype
#endif
PETSC_EXTERN void dmgettype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmconvert_ DMCONVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmconvert_ dmconvert
#endif
PETSC_EXTERN void dmconvert_(DM *a, char *b, DM *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMConvert(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmload_ DMLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmload_ dmload
#endif
PETSC_EXTERN void dmload_(DM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmprintcellindices_ DMPRINTCELLINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmprintcellindices_ dmprintcellindices
#endif
PETSC_EXTERN void dmprintcellindices_(PetscInt *a, char b[], PetscInt *c, const PetscInt d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPrintCellIndices(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmprintcellvector_ DMPRINTCELLVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmprintcellvector_ dmprintcellvector
#endif
PETSC_EXTERN void dmprintcellvector_(PetscInt *a, char b[], PetscInt *c, const PetscScalar d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMPrintCellVector(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmprintcellvectorreal_ DMPRINTCELLVECTORREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmprintcellvectorreal_ dmprintcellvectorreal
#endif
PETSC_EXTERN void dmprintcellvectorreal_(PetscInt *a, char b[], PetscInt *c, const PetscReal d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLREAL(d);
  *ierr = DMPrintCellVectorReal(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmprintcellmatrix_ DMPRINTCELLMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmprintcellmatrix_ dmprintcellmatrix
#endif
PETSC_EXTERN void dmprintcellmatrix_(PetscInt *a, char b[], PetscInt *c, PetscInt *d, const PetscScalar e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLSCALAR(e);
  *ierr = DMPrintCellMatrix(*a, c_b, *c, *d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmprintlocalvec_ DMPRINTLOCALVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmprintlocalvec_ dmprintlocalvec
#endif
PETSC_EXTERN void dmprintlocalvec_(DM *a, char b[], PetscReal *c, Vec *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPrintLocalVec(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlocalsection_ DMGETLOCALSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlocalsection_ dmgetlocalsection
#endif
PETSC_EXTERN void dmgetlocalsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetLocalSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetlocalsection_ DMSETLOCALSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetlocalsection_ dmsetlocalsection
#endif
PETSC_EXTERN void dmsetlocalsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  *ierr = DMSetLocalSection(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetdefaultconstraints_ DMGETDEFAULTCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetdefaultconstraints_ dmgetdefaultconstraints
#endif
PETSC_EXTERN void dmgetdefaultconstraints_(DM *a, PetscSection *b, Mat *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMGetDefaultConstraints(*a, b, c, d);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetdefaultconstraints_ DMSETDEFAULTCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetdefaultconstraints_ dmsetdefaultconstraints
#endif
PETSC_EXTERN void dmsetdefaultconstraints_(DM *a, PetscSection *b, Mat *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMSetDefaultConstraints(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetglobalsection_ DMGETGLOBALSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetglobalsection_ dmgetglobalsection
#endif
PETSC_EXTERN void dmgetglobalsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetGlobalSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetglobalsection_ DMSETGLOBALSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetglobalsection_ dmsetglobalsection
#endif
PETSC_EXTERN void dmsetglobalsection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  *ierr = DMSetGlobalSection(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetsectionsf_ DMGETSECTIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetsectionsf_ dmgetsectionsf
#endif
PETSC_EXTERN void dmgetsectionsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetSectionSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetsectionsf_ DMSETSECTIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetsectionsf_ dmsetsectionsf
#endif
PETSC_EXTERN void dmsetsectionsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMSetSectionSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatesectionsf_ DMCREATESECTIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatesectionsf_ dmcreatesectionsf
#endif
PETSC_EXTERN void dmcreatesectionsf_(DM *a, PetscSection *b, PetscSection *c, PetscErrorCode *ierr)
{
  *ierr = DMCreateSectionSF(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetpointsf_ DMGETPOINTSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetpointsf_ dmgetpointsf
#endif
PETSC_EXTERN void dmgetpointsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetPointSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetpointsf_ DMSETPOINTSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetpointsf_ dmsetpointsf
#endif
PETSC_EXTERN void dmsetpointsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMSetPointSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetnaturalsf_ DMGETNATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetnaturalsf_ dmgetnaturalsf
#endif
PETSC_EXTERN void dmgetnaturalsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetNaturalSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetnaturalsf_ DMSETNATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetnaturalsf_ dmsetnaturalsf
#endif
PETSC_EXTERN void dmsetnaturalsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMSetNaturalSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmclearfields_ DMCLEARFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmclearfields_ dmclearfields
#endif
PETSC_EXTERN void dmclearfields_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMClearFields(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetnumfields_ DMGETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetnumfields_ dmgetnumfields
#endif
PETSC_EXTERN void dmgetnumfields_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetNumFields(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetnumfields_ DMSETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetnumfields_ dmsetnumfields
#endif
PETSC_EXTERN void dmsetnumfields_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSetNumFields(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetfield_ DMGETFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetfield_ dmgetfield
#endif
PETSC_EXTERN void dmgetfield_(DM *a, PetscInt *b, DMLabel *c, PetscObject *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMGetField(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetfield_ DMSETFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetfield_ dmsetfield
#endif
PETSC_EXTERN void dmsetfield_(DM *a, PetscInt *b, DMLabel *c, PetscObject *d, PetscErrorCode *ierr)
{
  *ierr = DMSetField(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmaddfield_ DMADDFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmaddfield_ dmaddfield
#endif
PETSC_EXTERN void dmaddfield_(DM *a, DMLabel *b, PetscObject *c, PetscErrorCode *ierr)
{
  *ierr = DMAddField(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetfieldavoidtensor_ DMSETFIELDAVOIDTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetfieldavoidtensor_ dmsetfieldavoidtensor
#endif
PETSC_EXTERN void dmsetfieldavoidtensor_(DM *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = DMSetFieldAvoidTensor(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetfieldavoidtensor_ DMGETFIELDAVOIDTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetfieldavoidtensor_ dmgetfieldavoidtensor
#endif
PETSC_EXTERN void dmgetfieldavoidtensor_(DM *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMGetFieldAvoidTensor(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopyfields_ DMCOPYFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopyfields_ dmcopyfields
#endif
PETSC_EXTERN void dmcopyfields_(DM *a, PetscInt *b, PetscInt *c, DM *d, PetscErrorCode *ierr)
{
  *ierr = DMCopyFields(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetadjacency_ DMGETADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetadjacency_ dmgetadjacency
#endif
PETSC_EXTERN void dmgetadjacency_(DM *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = DMGetAdjacency(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetadjacency_ DMSETADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetadjacency_ dmsetadjacency
#endif
PETSC_EXTERN void dmsetadjacency_(DM *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = DMSetAdjacency(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetbasicadjacency_ DMGETBASICADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetbasicadjacency_ dmgetbasicadjacency
#endif
PETSC_EXTERN void dmgetbasicadjacency_(DM *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = DMGetBasicAdjacency(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetbasicadjacency_ DMSETBASICADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetbasicadjacency_ dmsetbasicadjacency
#endif
PETSC_EXTERN void dmsetbasicadjacency_(DM *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = DMSetBasicAdjacency(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetnumds_ DMGETNUMDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetnumds_ dmgetnumds
#endif
PETSC_EXTERN void dmgetnumds_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetNumDS(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcleards_ DMCLEARDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcleards_ dmcleards
#endif
PETSC_EXTERN void dmcleards_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMClearDS(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetds_ DMGETDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetds_ dmgetds
#endif
PETSC_EXTERN void dmgetds_(DM *a, PetscDS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetDS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellds_ DMGETCELLDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellds_ dmgetcellds
#endif
PETSC_EXTERN void dmgetcellds_(DM *a, PetscInt *b, PetscDS *c, PetscDS *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMGetCellDS(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetregionds_ DMGETREGIONDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetregionds_ dmgetregionds
#endif
PETSC_EXTERN void dmgetregionds_(DM *a, DMLabel *b, IS *c, PetscDS *d, PetscDS *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMGetRegionDS(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetregionds_ DMSETREGIONDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetregionds_ dmsetregionds
#endif
PETSC_EXTERN void dmsetregionds_(DM *a, DMLabel *b, IS *c, PetscDS *d, PetscDS *e, PetscErrorCode *ierr)
{
  *ierr = DMSetRegionDS(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetregionnumds_ DMGETREGIONNUMDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetregionnumds_ dmgetregionnumds
#endif
PETSC_EXTERN void dmgetregionnumds_(DM *a, PetscInt *b, DMLabel *c, IS *d, PetscDS *e, PetscDS *f, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMGetRegionNumDS(*a, *b, c, d, e, f);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetregionnumds_ DMSETREGIONNUMDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetregionnumds_ dmsetregionnumds
#endif
PETSC_EXTERN void dmsetregionnumds_(DM *a, PetscInt *b, DMLabel *c, IS *d, PetscDS *e, PetscDS *f, PetscErrorCode *ierr)
{
  *ierr = DMSetRegionNumDS(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfindregionnum_ DMFINDREGIONNUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfindregionnum_ dmfindregionnum
#endif
PETSC_EXTERN void dmfindregionnum_(DM *a, PetscDS *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMFindRegionNum(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatefedefault_ DMCREATEFEDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatefedefault_ dmcreatefedefault
#endif
PETSC_EXTERN void dmcreatefedefault_(DM *a, PetscInt *b, char c[], PetscInt *d, PetscFE *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMCreateFEDefault(*a, *b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreateds_ DMCREATEDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreateds_ dmcreateds
#endif
PETSC_EXTERN void dmcreateds_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMCreateDS(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmusetensororder_ DMUSETENSORORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmusetensororder_ dmusetensororder
#endif
PETSC_EXTERN void dmusetensororder_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMUseTensorOrder(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcomputeexactsolution_ DMCOMPUTEEXACTSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcomputeexactsolution_ dmcomputeexactsolution
#endif
PETSC_EXTERN void dmcomputeexactsolution_(DM *a, PetscReal *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMComputeExactSolution(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopyds_ DMCOPYDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopyds_ dmcopyds
#endif
PETSC_EXTERN void dmcopyds_(DM *a, PetscInt *b, PetscInt *c, DM *d, PetscErrorCode *ierr)
{
  *ierr = DMCopyDS(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopydisc_ DMCOPYDISC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopydisc_ dmcopydisc
#endif
PETSC_EXTERN void dmcopydisc_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMCopyDisc(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetdimension_ DMGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetdimension_ dmgetdimension
#endif
PETSC_EXTERN void dmgetdimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetdimension_ DMSETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetdimension_ dmsetdimension
#endif
PETSC_EXTERN void dmsetdimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSetDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetdimpoints_ DMGETDIMPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetdimpoints_ dmgetdimpoints
#endif
PETSC_EXTERN void dmgetdimpoints_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMGetDimPoints(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetoutputdm_ DMGETOUTPUTDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetoutputdm_ dmgetoutputdm
#endif
PETSC_EXTERN void dmgetoutputdm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetOutputDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetoutputsequencenumber_ DMGETOUTPUTSEQUENCENUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetoutputsequencenumber_ dmgetoutputsequencenumber
#endif
PETSC_EXTERN void dmgetoutputsequencenumber_(DM *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = DMGetOutputSequenceNumber(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetoutputsequencenumber_ DMSETOUTPUTSEQUENCENUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetoutputsequencenumber_ dmsetoutputsequencenumber
#endif
PETSC_EXTERN void dmsetoutputsequencenumber_(DM *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = DMSetOutputSequenceNumber(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmoutputsequenceload_ DMOUTPUTSEQUENCELOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmoutputsequenceload_ dmoutputsequenceload
#endif
PETSC_EXTERN void dmoutputsequenceload_(DM *a, PetscViewer *b, char c[], PetscInt *d, PetscReal *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  CHKFORTRANNULLREAL(e);
  *ierr = DMOutputSequenceLoad(*a, v_b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetoutputsequencelength_ DMGETOUTPUTSEQUENCELENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetoutputsequencelength_ dmgetoutputsequencelength
#endif
PETSC_EXTERN void dmgetoutputsequencelength_(DM *a, PetscViewer *b, char c[], PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMGetOutputSequenceLength(*a, v_b, c_c, d);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetusenatural_ DMGETUSENATURAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetusenatural_ dmgetusenatural
#endif
PETSC_EXTERN void dmgetusenatural_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMGetUseNatural(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetusenatural_ DMSETUSENATURAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetusenatural_ dmsetusenatural
#endif
PETSC_EXTERN void dmsetusenatural_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSetUseNatural(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatelabel_ DMCREATELABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatelabel_ dmcreatelabel
#endif
PETSC_EXTERN void dmcreatelabel_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMCreateLabel(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatelabelatindex_ DMCREATELABELATINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatelabelatindex_ dmcreatelabelatindex
#endif
PETSC_EXTERN void dmcreatelabelatindex_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMCreateLabelAtIndex(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabelvalue_ DMGETLABELVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabelvalue_ dmgetlabelvalue
#endif
PETSC_EXTERN void dmgetlabelvalue_(DM *a, char b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMGetLabelValue(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetlabelvalue_ DMSETLABELVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetlabelvalue_ dmsetlabelvalue
#endif
PETSC_EXTERN void dmsetlabelvalue_(DM *a, char b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetLabelValue(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmclearlabelvalue_ DMCLEARLABELVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmclearlabelvalue_ dmclearlabelvalue
#endif
PETSC_EXTERN void dmclearlabelvalue_(DM *a, char b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMClearLabelValue(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabelsize_ DMGETLABELSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabelsize_ dmgetlabelsize
#endif
PETSC_EXTERN void dmgetlabelsize_(DM *a, char b[], PetscInt *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMGetLabelSize(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabelidis_ DMGETLABELIDIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabelidis_ dmgetlabelidis
#endif
PETSC_EXTERN void dmgetlabelidis_(DM *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMGetLabelIdIS(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetstratumsize_ DMGETSTRATUMSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetstratumsize_ dmgetstratumsize
#endif
PETSC_EXTERN void dmgetstratumsize_(DM *a, char b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMGetStratumSize(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetstratumis_ DMGETSTRATUMIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetstratumis_ dmgetstratumis
#endif
PETSC_EXTERN void dmgetstratumis_(DM *a, char b[], PetscInt *c, IS *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMGetStratumIS(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetstratumis_ DMSETSTRATUMIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetstratumis_ dmsetstratumis
#endif
PETSC_EXTERN void dmsetstratumis_(DM *a, char b[], PetscInt *c, IS *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetStratumIS(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmclearlabelstratum_ DMCLEARLABELSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmclearlabelstratum_ dmclearlabelstratum
#endif
PETSC_EXTERN void dmclearlabelstratum_(DM *a, char b[], PetscInt *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMClearLabelStratum(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetnumlabels_ DMGETNUMLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetnumlabels_ dmgetnumlabels
#endif
PETSC_EXTERN void dmgetnumlabels_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetNumLabels(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabelname_ DMGETLABELNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabelname_ dmgetlabelname
#endif
PETSC_EXTERN void dmgetlabelname_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMGetLabelName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhaslabel_ DMHASLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhaslabel_ dmhaslabel
#endif
PETSC_EXTERN void dmhaslabel_(DM *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = DMHasLabel(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabel_ DMGETLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabel_ dmgetlabel
#endif
PETSC_EXTERN void dmgetlabel_(DM *a, char b[], DMLabel *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMGetLabel(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabelbynum_ DMGETLABELBYNUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabelbynum_ dmgetlabelbynum
#endif
PETSC_EXTERN void dmgetlabelbynum_(DM *a, PetscInt *b, DMLabel *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMGetLabelByNum(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmaddlabel_ DMADDLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmaddlabel_ dmaddlabel
#endif
PETSC_EXTERN void dmaddlabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMAddLabel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetlabel_ DMSETLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetlabel_ dmsetlabel
#endif
PETSC_EXTERN void dmsetlabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMSetLabel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmremovelabel_ DMREMOVELABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmremovelabel_ dmremovelabel
#endif
PETSC_EXTERN void dmremovelabel_(DM *a, char b[], DMLabel *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMRemoveLabel(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmremovelabelbyself_ DMREMOVELABELBYSELF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmremovelabelbyself_ dmremovelabelbyself
#endif
PETSC_EXTERN void dmremovelabelbyself_(DM *a, DMLabel *b, PetscBool *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMRemoveLabelBySelf(*a, b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlabeloutput_ DMGETLABELOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlabeloutput_ dmgetlabeloutput
#endif
PETSC_EXTERN void dmgetlabeloutput_(DM *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = DMGetLabelOutput(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetlabeloutput_ DMSETLABELOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetlabeloutput_ dmsetlabeloutput
#endif
PETSC_EXTERN void dmsetlabeloutput_(DM *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetLabelOutput(*a, c_b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopylabels_ DMCOPYLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopylabels_ dmcopylabels
#endif
PETSC_EXTERN void dmcopylabels_(DM *a, DM *b, PetscCopyMode *c, PetscBool *d, DMCopyLabelsMode *e, PetscErrorCode *ierr)
{
  *ierr = DMCopyLabels(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoarsedm_ DMGETCOARSEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoarsedm_ dmgetcoarsedm
#endif
PETSC_EXTERN void dmgetcoarsedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoarseDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoarsedm_ DMSETCOARSEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoarsedm_ dmsetcoarsedm
#endif
PETSC_EXTERN void dmsetcoarsedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoarseDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetfinedm_ DMGETFINEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetfinedm_ dmgetfinedm
#endif
PETSC_EXTERN void dmgetfinedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetFineDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetfinedm_ DMSETFINEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetfinedm_ dmsetfinedm
#endif
PETSC_EXTERN void dmsetfinedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMSetFineDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmisboundarypoint_ DMISBOUNDARYPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmisboundarypoint_ dmisboundarypoint
#endif
PETSC_EXTERN void dmisboundarypoint_(DM *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMIsBoundaryPoint(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmhasbound_ DMHASBOUND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmhasbound_ dmhasbound
#endif
PETSC_EXTERN void dmhasbound_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMHasBound(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcompatibility_ DMGETCOMPATIBILITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcompatibility_ dmgetcompatibility
#endif
PETSC_EXTERN void dmgetcompatibility_(DM *a, DM *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = DMGetCompatibility(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmonitorcancel_ DMMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmonitorcancel_ dmmonitorcancel
#endif
PETSC_EXTERN void dmmonitorcancel_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmonitor_ DMMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmonitor_ dmmonitor
#endif
PETSC_EXTERN void dmmonitor_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMMonitor(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcomputeerror_ DMCOMPUTEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcomputeerror_ dmcomputeerror
#endif
PETSC_EXTERN void dmcomputeerror_(DM *a, Vec *b, PetscReal c[], Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMComputeError(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetnumauxiliaryvec_ DMGETNUMAUXILIARYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetnumauxiliaryvec_ dmgetnumauxiliaryvec
#endif
PETSC_EXTERN void dmgetnumauxiliaryvec_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetNumAuxiliaryVec(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetauxiliaryvec_ DMGETAUXILIARYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetauxiliaryvec_ dmgetauxiliaryvec
#endif
PETSC_EXTERN void dmgetauxiliaryvec_(DM *a, DMLabel *b, PetscInt *c, PetscInt *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMGetAuxiliaryVec(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetauxiliaryvec_ DMSETAUXILIARYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetauxiliaryvec_ dmsetauxiliaryvec
#endif
PETSC_EXTERN void dmsetauxiliaryvec_(DM *a, DMLabel *b, PetscInt *c, PetscInt *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMSetAuxiliaryVec(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetauxiliarylabels_ DMGETAUXILIARYLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetauxiliarylabels_ dmgetauxiliarylabels
#endif
PETSC_EXTERN void dmgetauxiliarylabels_(DM *a, DMLabel b[], PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMGetAuxiliaryLabels(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcopyauxiliaryvec_ DMCOPYAUXILIARYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcopyauxiliaryvec_ dmcopyauxiliaryvec
#endif
PETSC_EXTERN void dmcopyauxiliaryvec_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMCopyAuxiliaryVec(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmclearauxiliaryvec_ DMCLEARAUXILIARYVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmclearauxiliaryvec_ dmclearauxiliaryvec
#endif
PETSC_EXTERN void dmclearauxiliaryvec_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMClearAuxiliaryVec(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpolytopematchorientation_ DMPOLYTOPEMATCHORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpolytopematchorientation_ dmpolytopematchorientation
#endif
PETSC_EXTERN void dmpolytopematchorientation_(DMPolytopeType *a, const PetscInt b[], const PetscInt c[], PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = DMPolytopeMatchOrientation(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpolytopegetorientation_ DMPOLYTOPEGETORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpolytopegetorientation_ dmpolytopegetorientation
#endif
PETSC_EXTERN void dmpolytopegetorientation_(DMPolytopeType *a, const PetscInt b[], const PetscInt c[], PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPolytopeGetOrientation(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpolytopematchvertexorientation_ DMPOLYTOPEMATCHVERTEXORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpolytopematchvertexorientation_ dmpolytopematchvertexorientation
#endif
PETSC_EXTERN void dmpolytopematchvertexorientation_(DMPolytopeType *a, const PetscInt b[], const PetscInt c[], PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = DMPolytopeMatchVertexOrientation(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpolytopegetvertexorientation_ DMPOLYTOPEGETVERTEXORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpolytopegetvertexorientation_ dmpolytopegetvertexorientation
#endif
PETSC_EXTERN void dmpolytopegetvertexorientation_(DMPolytopeType *a, const PetscInt b[], const PetscInt c[], PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPolytopeGetVertexOrientation(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpolytopeincelltest_ DMPOLYTOPEINCELLTEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpolytopeincelltest_ dmpolytopeincelltest
#endif
PETSC_EXTERN void dmpolytopeincelltest_(DMPolytopeType *a, const PetscReal b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = DMPolytopeInCellTest(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmreordersectionsetdefault_ DMREORDERSECTIONSETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmreordersectionsetdefault_ dmreordersectionsetdefault
#endif
PETSC_EXTERN void dmreordersectionsetdefault_(DM *a, DMReorderDefaultFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMReorderSectionSetDefault(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmreordersectiongetdefault_ DMREORDERSECTIONGETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmreordersectiongetdefault_ dmreordersectiongetdefault
#endif
PETSC_EXTERN void dmreordersectiongetdefault_(DM *a, DMReorderDefaultFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMReorderSectionGetDefault(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmreordersectionsettype_ DMREORDERSECTIONSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmreordersectionsettype_ dmreordersectionsettype
#endif
PETSC_EXTERN void dmreordersectionsettype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMReorderSectionSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmreordersectiongettype_ DMREORDERSECTIONGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmreordersectiongettype_ dmreordersectiongettype
#endif
PETSC_EXTERN void dmreordersectiongettype_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMReorderSectionGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
