#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkcreate_ DMNETWORKCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkcreate_ dmnetworkcreate
#endif
PETSC_EXTERN void dmnetworkcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMNetworkCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
