#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfielddestroy_ DMFIELDDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfielddestroy_ dmfielddestroy
#endif
PETSC_EXTERN void dmfielddestroy_(DMField *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMFieldDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldview_ DMFIELDVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldview_ dmfieldview
#endif
PETSC_EXTERN void dmfieldview_(DMField *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMFieldView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldsettype_ DMFIELDSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldsettype_ dmfieldsettype
#endif
PETSC_EXTERN void dmfieldsettype_(DMField *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMFieldSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldgettype_ DMFIELDGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldgettype_ dmfieldgettype
#endif
PETSC_EXTERN void dmfieldgettype_(DMField *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMFieldGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldgetnumcomponents_ DMFIELDGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldgetnumcomponents_ dmfieldgetnumcomponents
#endif
PETSC_EXTERN void dmfieldgetnumcomponents_(DMField *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMFieldGetNumComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldgetdm_ DMFIELDGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldgetdm_ dmfieldgetdm
#endif
PETSC_EXTERN void dmfieldgetdm_(DMField *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMFieldGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldevaluate_ DMFIELDEVALUATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldevaluate_ dmfieldevaluate
#endif
PETSC_EXTERN void dmfieldevaluate_(DMField *a, Vec *b, PetscDataType *c, void *d, void *e, void *f, PetscErrorCode *ierr)
{
  *ierr = DMFieldEvaluate(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldevaluatefe_ DMFIELDEVALUATEFE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldevaluatefe_ dmfieldevaluatefe
#endif
PETSC_EXTERN void dmfieldevaluatefe_(DMField *a, IS *b, PetscQuadrature *c, PetscDataType *d, void *e, void *f, void *g, PetscErrorCode *ierr)
{
  *ierr = DMFieldEvaluateFE(*a, *b, *c, *d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldevaluatefv_ DMFIELDEVALUATEFV
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldevaluatefv_ dmfieldevaluatefv
#endif
PETSC_EXTERN void dmfieldevaluatefv_(DMField *a, IS *b, PetscDataType *c, void *d, void *e, void *f, PetscErrorCode *ierr)
{
  *ierr = DMFieldEvaluateFV(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldgetdegree_ DMFIELDGETDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldgetdegree_ dmfieldgetdegree
#endif
PETSC_EXTERN void dmfieldgetdegree_(DMField *a, IS *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMFieldGetDegree(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldcreatedefaultquadrature_ DMFIELDCREATEDEFAULTQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldcreatedefaultquadrature_ dmfieldcreatedefaultquadrature
#endif
PETSC_EXTERN void dmfieldcreatedefaultquadrature_(DMField *a, IS *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMFieldCreateDefaultQuadrature(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldcreatedefaultfacequadrature_ DMFIELDCREATEDEFAULTFACEQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldcreatedefaultfacequadrature_ dmfieldcreatedefaultfacequadrature
#endif
PETSC_EXTERN void dmfieldcreatedefaultfacequadrature_(DMField *a, IS *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMFieldCreateDefaultFaceQuadrature(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
