#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsctabulationdestroy_ PETSCTABULATIONDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsctabulationdestroy_ petsctabulationdestroy
#endif
PETSC_EXTERN void petsctabulationdestroy_(PetscTabulation *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscTabulationDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesettype_ PETSCFESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesettype_ petscfesettype
#endif
PETSC_EXTERN void petscfesettype_(PetscFE *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscFESetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegettype_ PETSCFEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegettype_ petscfegettype
#endif
PETSC_EXTERN void petscfegettype_(PetscFE *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscFEGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeviewfromoptions_ PETSCFEVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeviewfromoptions_ petscfeviewfromoptions
#endif
PETSC_EXTERN void petscfeviewfromoptions_(PetscFE *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscFEViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeview_ PETSCFEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeview_ petscfeview
#endif
PETSC_EXTERN void petscfeview_(PetscFE *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscFEView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetfromoptions_ PETSCFESETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetfromoptions_ petscfesetfromoptions
#endif
PETSC_EXTERN void petscfesetfromoptions_(PetscFE *a, PetscErrorCode *ierr)
{
  *ierr = PetscFESetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetup_ PETSCFESETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetup_ petscfesetup
#endif
PETSC_EXTERN void petscfesetup_(PetscFE *a, PetscErrorCode *ierr)
{
  *ierr = PetscFESetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfedestroy_ PETSCFEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfedestroy_ petscfedestroy
#endif
PETSC_EXTERN void petscfedestroy_(PetscFE *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscFEDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreate_ PETSCFECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreate_ petscfecreate
#endif
PETSC_EXTERN void petscfecreate_(MPI_Fint *a, PetscFE *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFECreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetspatialdimension_ PETSCFEGETSPATIALDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetspatialdimension_ petscfegetspatialdimension
#endif
PETSC_EXTERN void petscfegetspatialdimension_(PetscFE *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscFEGetSpatialDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetnumcomponents_ PETSCFESETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetnumcomponents_ petscfesetnumcomponents
#endif
PETSC_EXTERN void petscfesetnumcomponents_(PetscFE *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscFESetNumComponents(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetnumcomponents_ PETSCFEGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetnumcomponents_ petscfegetnumcomponents
#endif
PETSC_EXTERN void petscfegetnumcomponents_(PetscFE *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscFEGetNumComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesettilesizes_ PETSCFESETTILESIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesettilesizes_ petscfesettilesizes
#endif
PETSC_EXTERN void petscfesettilesizes_(PetscFE *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = PetscFESetTileSizes(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegettilesizes_ PETSCFEGETTILESIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegettilesizes_ petscfegettilesizes
#endif
PETSC_EXTERN void petscfegettilesizes_(PetscFE *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscFEGetTileSizes(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetbasisspace_ PETSCFEGETBASISSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetbasisspace_ petscfegetbasisspace
#endif
PETSC_EXTERN void petscfegetbasisspace_(PetscFE *a, PetscSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFEGetBasisSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetbasisspace_ PETSCFESETBASISSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetbasisspace_ petscfesetbasisspace
#endif
PETSC_EXTERN void petscfesetbasisspace_(PetscFE *a, PetscSpace *b, PetscErrorCode *ierr)
{
  *ierr = PetscFESetBasisSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetdualspace_ PETSCFEGETDUALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetdualspace_ petscfegetdualspace
#endif
PETSC_EXTERN void petscfegetdualspace_(PetscFE *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFEGetDualSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetdualspace_ PETSCFESETDUALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetdualspace_ petscfesetdualspace
#endif
PETSC_EXTERN void petscfesetdualspace_(PetscFE *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  *ierr = PetscFESetDualSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetquadrature_ PETSCFEGETQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetquadrature_ petscfegetquadrature
#endif
PETSC_EXTERN void petscfegetquadrature_(PetscFE *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFEGetQuadrature(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetquadrature_ PETSCFESETQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetquadrature_ petscfesetquadrature
#endif
PETSC_EXTERN void petscfesetquadrature_(PetscFE *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  *ierr = PetscFESetQuadrature(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetfacequadrature_ PETSCFEGETFACEQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetfacequadrature_ petscfegetfacequadrature
#endif
PETSC_EXTERN void petscfegetfacequadrature_(PetscFE *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFEGetFaceQuadrature(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetfacequadrature_ PETSCFESETFACEQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetfacequadrature_ petscfesetfacequadrature
#endif
PETSC_EXTERN void petscfesetfacequadrature_(PetscFE *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  *ierr = PetscFESetFaceQuadrature(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecopyquadrature_ PETSCFECOPYQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecopyquadrature_ petscfecopyquadrature
#endif
PETSC_EXTERN void petscfecopyquadrature_(PetscFE *a, PetscFE *b, PetscErrorCode *ierr)
{
  *ierr = PetscFECopyQuadrature(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetcelltabulation_ PETSCFEGETCELLTABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetcelltabulation_ petscfegetcelltabulation
#endif
PETSC_EXTERN void petscfegetcelltabulation_(PetscFE *a, PetscInt *b, PetscTabulation *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscFEGetCellTabulation(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeexpandfacequadrature_ PETSCFEEXPANDFACEQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeexpandfacequadrature_ petscfeexpandfacequadrature
#endif
PETSC_EXTERN void petscfeexpandfacequadrature_(PetscFE *a, PetscQuadrature *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscFEExpandFaceQuadrature(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetfacetabulation_ PETSCFEGETFACETABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetfacetabulation_ petscfegetfacetabulation
#endif
PETSC_EXTERN void petscfegetfacetabulation_(PetscFE *a, PetscInt *b, PetscTabulation *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscFEGetFaceTabulation(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetfacecentroidtabulation_ PETSCFEGETFACECENTROIDTABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetfacecentroidtabulation_ petscfegetfacecentroidtabulation
#endif
PETSC_EXTERN void petscfegetfacecentroidtabulation_(PetscFE *a, PetscTabulation *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFEGetFaceCentroidTabulation(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatetabulation_ PETSCFECREATETABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatetabulation_ petscfecreatetabulation
#endif
PETSC_EXTERN void petscfecreatetabulation_(PetscFE *a, PetscInt *b, PetscInt *c, const PetscReal d[], PetscInt *e, PetscTabulation *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscFECreateTabulation(*a, *b, *c, d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecomputetabulation_ PETSCFECOMPUTETABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecomputetabulation_ petscfecomputetabulation
#endif
PETSC_EXTERN void petscfecomputetabulation_(PetscFE *a, PetscInt *b, const PetscReal c[], PetscInt *d, PetscTabulation *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = PetscFEComputeTabulation(*a, *b, c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreateheighttrace_ PETSCFECREATEHEIGHTTRACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreateheighttrace_ petscfecreateheighttrace
#endif
PETSC_EXTERN void petscfecreateheighttrace_(PetscFE *a, PetscInt *b, PetscFE *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscFECreateHeightTrace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetdimension_ PETSCFEGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetdimension_ petscfegetdimension
#endif
PETSC_EXTERN void petscfegetdimension_(PetscFE *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscFEGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfepushforward_ PETSCFEPUSHFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfepushforward_ petscfepushforward
#endif
PETSC_EXTERN void petscfepushforward_(PetscFE *a, PetscFEGeom **b, PetscInt *c, PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscFEPushforward(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfepushforwardgradient_ PETSCFEPUSHFORWARDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfepushforwardgradient_ petscfepushforwardgradient
#endif
PETSC_EXTERN void petscfepushforwardgradient_(PetscFE *a, PetscFEGeom **b, PetscInt *c, PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscFEPushforwardGradient(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfepushforwardhessian_ PETSCFEPUSHFORWARDHESSIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfepushforwardhessian_ petscfepushforwardhessian
#endif
PETSC_EXTERN void petscfepushforwardhessian_(PetscFE *a, PetscFEGeom **b, PetscInt *c, PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscFEPushforwardHessian(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegrate_ PETSCFEINTEGRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegrate_ petscfeintegrate
#endif
PETSC_EXTERN void petscfeintegrate_(PetscDS *a, PetscInt *b, PetscInt *c, PetscFEGeom **d, const PetscScalar e[], PetscDS *f, const PetscScalar g[], PetscScalar h[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(h);
  *ierr = PetscFEIntegrate(*a, *b, *c, *d, e, *f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegrateresidual_ PETSCFEINTEGRATERESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegrateresidual_ petscfeintegrateresidual
#endif
PETSC_EXTERN void petscfeintegrateresidual_(PetscDS *a, PetscFormKey *b, PetscInt *c, PetscFEGeom **d, const PetscScalar e[], const PetscScalar f[], PetscDS *g, const PetscScalar h[], PetscReal *i, PetscScalar j[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(j);
  *ierr = PetscFEIntegrateResidual(*a, *b, *c, *d, e, f, *g, h, *i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegratebdresidual_ PETSCFEINTEGRATEBDRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegratebdresidual_ petscfeintegratebdresidual
#endif
PETSC_EXTERN void petscfeintegratebdresidual_(PetscDS *a, PetscWeakForm *b, PetscFormKey *c, PetscInt *d, PetscFEGeom **e, const PetscScalar f[], const PetscScalar g[], PetscDS *h, const PetscScalar i[], PetscReal *j, PetscScalar k[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLSCALAR(k);
  *ierr = PetscFEIntegrateBdResidual(*a, *b, *c, *d, *e, f, g, *h, i, *j, k);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegratehybridresidual_ PETSCFEINTEGRATEHYBRIDRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegratehybridresidual_ petscfeintegratehybridresidual
#endif
PETSC_EXTERN void petscfeintegratehybridresidual_(PetscDS *a, PetscDS *b, PetscFormKey *c, PetscInt *d, PetscInt *e, PetscFEGeom **f, PetscFEGeom **g, const PetscScalar h[], const PetscScalar i[], PetscDS *j, const PetscScalar k[], PetscReal *l, PetscScalar m[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLSCALAR(k);
  CHKFORTRANNULLSCALAR(m);
  *ierr = PetscFEIntegrateHybridResidual(*a, *b, *c, *d, *e, *f, *g, h, i, *j, k, *l, m);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegratejacobian_ PETSCFEINTEGRATEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegratejacobian_ petscfeintegratejacobian
#endif
PETSC_EXTERN void petscfeintegratejacobian_(PetscDS *a, PetscDS *b, PetscFEJacobianType *c, PetscFormKey *d, PetscInt *e, PetscFEGeom **f, const PetscScalar g[], const PetscScalar h[], PetscDS *i, const PetscScalar j[], PetscReal *k, PetscReal *l, PetscScalar m[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(j);
  CHKFORTRANNULLSCALAR(m);
  *ierr = PetscFEIntegrateJacobian(*a, *b, *c, *d, *e, *f, g, h, *i, j, *k, *l, m);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegratebdjacobian_ PETSCFEINTEGRATEBDJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegratebdjacobian_ petscfeintegratebdjacobian
#endif
PETSC_EXTERN void petscfeintegratebdjacobian_(PetscDS *a, PetscWeakForm *b, PetscFEJacobianType *c, PetscFormKey *d, PetscInt *e, PetscFEGeom **f, const PetscScalar g[], const PetscScalar h[], PetscDS *i, const PetscScalar j[], PetscReal *k, PetscReal *l, PetscScalar m[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(j);
  CHKFORTRANNULLSCALAR(m);
  *ierr = PetscFEIntegrateBdJacobian(*a, *b, *c, *d, *e, *f, g, h, *i, j, *k, *l, m);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfeintegratehybridjacobian_ PETSCFEINTEGRATEHYBRIDJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfeintegratehybridjacobian_ petscfeintegratehybridjacobian
#endif
PETSC_EXTERN void petscfeintegratehybridjacobian_(PetscDS *a, PetscDS *b, PetscFEJacobianType *c, PetscFormKey *d, PetscInt *e, PetscInt *f, PetscFEGeom **g, PetscFEGeom **h, const PetscScalar i[], const PetscScalar j[], PetscDS *k, const PetscScalar l[], PetscReal *m, PetscReal *n, PetscScalar o[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLSCALAR(j);
  CHKFORTRANNULLSCALAR(l);
  CHKFORTRANNULLSCALAR(o);
  *ierr = PetscFEIntegrateHybridJacobian(*a, *b, *c, *d, *e, *f, *g, *h, i, j, *k, l, *m, *n, o);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegetheightsubspace_ PETSCFEGETHEIGHTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegetheightsubspace_ petscfegetheightsubspace
#endif
PETSC_EXTERN void petscfegetheightsubspace_(PetscFE *a, PetscInt *b, PetscFE *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscFEGetHeightSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscferefine_ PETSCFEREFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscferefine_ petscferefine
#endif
PETSC_EXTERN void petscferefine_(PetscFE *a, PetscFE *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFERefine(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatefromspaces_ PETSCFECREATEFROMSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatefromspaces_ petscfecreatefromspaces
#endif
PETSC_EXTERN void petscfecreatefromspaces_(PetscSpace *a, PetscDualSpace *b, PetscQuadrature *c, PetscQuadrature *d, PetscFE *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscFECreateFromSpaces(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatedefault_ PETSCFECREATEDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatedefault_ petscfecreatedefault
#endif
PETSC_EXTERN void petscfecreatedefault_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscBool *d, char e[], PetscInt *f, PetscFE *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  CHKFORTRANNULLOBJECT(g);
  *ierr = PetscFECreateDefault(MPI_Comm_f2c(*(a)), *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, c_e, *f, g);
  if (*ierr) return;
  FREECHAR(e, c_e);
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatebycell_ PETSCFECREATEBYCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatebycell_ petscfecreatebycell
#endif
PETSC_EXTERN void petscfecreatebycell_(MPI_Fint *a, PetscInt *b, PetscInt *c, DMPolytopeType *d, char e[], PetscInt *f, PetscFE *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  CHKFORTRANNULLOBJECT(g);
  *ierr = PetscFECreateByCell(MPI_Comm_f2c(*(a)), *b, *c, *d, c_e, *f, g);
  if (*ierr) return;
  FREECHAR(e, c_e);
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatelagrange_ PETSCFECREATELAGRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatelagrange_ petscfecreatelagrange
#endif
PETSC_EXTERN void petscfecreatelagrange_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscBool *d, PetscInt *e, PetscInt *f, PetscFE *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = PetscFECreateLagrange(MPI_Comm_f2c(*(a)), *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatelagrangebycell_ PETSCFECREATELAGRANGEBYCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatelagrangebycell_ petscfecreatelagrangebycell
#endif
PETSC_EXTERN void petscfecreatelagrangebycell_(MPI_Fint *a, PetscInt *b, PetscInt *c, DMPolytopeType *d, PetscInt *e, PetscInt *f, PetscFE *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = PetscFECreateLagrangeByCell(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfelimitdegree_ PETSCFELIMITDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfelimitdegree_ petscfelimitdegree
#endif
PETSC_EXTERN void petscfelimitdegree_(PetscFE *a, PetscInt *b, PetscInt *c, PetscFE *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscFELimitDegree(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatebrokenelement_ PETSCFECREATEBROKENELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatebrokenelement_ petscfecreatebrokenelement
#endif
PETSC_EXTERN void petscfecreatebrokenelement_(PetscFE *a, PetscFE *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFECreateBrokenElement(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfesetname_ PETSCFESETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfesetname_ petscfesetname
#endif
PETSC_EXTERN void petscfesetname_(PetscFE *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscFESetName(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatecellgeometry_ PETSCFECREATECELLGEOMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatecellgeometry_ petscfecreatecellgeometry
#endif
PETSC_EXTERN void petscfecreatecellgeometry_(PetscFE *a, PetscQuadrature *b, PetscFEGeom **c, PetscErrorCode *ierr)
{
  *ierr = PetscFECreateCellGeometry(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfedestroycellgeometry_ PETSCFEDESTROYCELLGEOMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfedestroycellgeometry_ petscfedestroycellgeometry
#endif
PETSC_EXTERN void petscfedestroycellgeometry_(PetscFE *a, PetscFEGeom **b, PetscErrorCode *ierr)
{
  *ierr = PetscFEDestroyCellGeometry(*a, *b);
  if (*ierr) return;
}
