#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdotbegin_ VECDOTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdotbegin_ vecdotbegin
#endif
PETSC_EXTERN void vecdotbegin_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecDotBegin(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdotend_ VECDOTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdotend_ vecdotend
#endif
PETSC_EXTERN void vecdotend_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecDotEnd(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectdotbegin_ VECTDOTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectdotbegin_ vectdotbegin
#endif
PETSC_EXTERN void vectdotbegin_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecTDotBegin(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectdotend_ VECTDOTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectdotend_ vectdotend
#endif
PETSC_EXTERN void vectdotend_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecTDotEnd(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnormbegin_ VECNORMBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnormbegin_ vecnormbegin
#endif
PETSC_EXTERN void vecnormbegin_(Vec *a, NormType *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecNormBegin(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnormend_ VECNORMEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnormend_ vecnormend
#endif
PETSC_EXTERN void vecnormend_(Vec *a, NormType *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecNormEnd(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmdotbegin_ VECMDOTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmdotbegin_ vecmdotbegin
#endif
PETSC_EXTERN void vecmdotbegin_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMDotBegin(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmdotend_ VECMDOTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmdotend_ vecmdotend
#endif
PETSC_EXTERN void vecmdotend_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMDotEnd(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmtdotbegin_ VECMTDOTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmtdotbegin_ vecmtdotbegin
#endif
PETSC_EXTERN void vecmtdotbegin_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMTDotBegin(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmtdotend_ VECMTDOTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmtdotend_ vecmtdotend
#endif
PETSC_EXTERN void vecmtdotend_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMTDotEnd(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccommsplitreductionbegin_ PETSCCOMMSPLITREDUCTIONBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccommsplitreductionbegin_ petsccommsplitreductionbegin
#endif
PETSC_EXTERN void petsccommsplitreductionbegin_(MPI_Fint *a, PetscErrorCode *ierr)
{
  *ierr = PetscCommSplitReductionBegin(MPI_Comm_f2c(*(a)));
  if (*ierr) return;
}
