#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintmulterror_ PETSCINTMULTERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintmulterror_ petscintmulterror
#endif
PETSC_EXTERN void petscintmulterror_(PetscInt *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscIntMultError(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintsumerror_ PETSCINTSUMERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintsumerror_ petscintsumerror
#endif
PETSC_EXTERN void petscintsumerror_(PetscInt *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscIntSumError(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccitationsregister_ PETSCCITATIONSREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccitationsregister_ petsccitationsregister
#endif
PETSC_EXTERN void petsccitationsregister_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscCitationsRegister(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
