#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetordering_ DMPLEXGETORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetordering_ dmplexgetordering
#endif
PETSC_EXTERN void dmplexgetordering_(DM *a, char *b, DMLabel *c, IS *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexGetOrdering(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetordering1d_ DMPLEXGETORDERING1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetordering1d_ dmplexgetordering1d
#endif
PETSC_EXTERN void dmplexgetordering1d_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetOrdering1D(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpermute_ DMPLEXPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpermute_ dmplexpermute
#endif
PETSC_EXTERN void dmplexpermute_(DM *a, IS *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexPermute(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreordersetdefault_ DMPLEXREORDERSETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreordersetdefault_ dmplexreordersetdefault
#endif
PETSC_EXTERN void dmplexreordersetdefault_(DM *a, DMReorderDefaultFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexReorderSetDefault(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreordergetdefault_ DMPLEXREORDERGETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreordergetdefault_ dmplexreordergetdefault
#endif
PETSC_EXTERN void dmplexreordergetdefault_(DM *a, DMReorderDefaultFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexReorderGetDefault(*a, b);
  if (*ierr) return;
}
