#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetlocaltoglobalmapping_ VECGETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetlocaltoglobalmapping_ vecgetlocaltoglobalmapping
#endif
PETSC_EXTERN void vecgetlocaltoglobalmapping_(Vec *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGetLocalToGlobalMapping(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecassemblybegin_ VECASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecassemblybegin_ vecassemblybegin
#endif
PETSC_EXTERN void vecassemblybegin_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecAssemblyBegin(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecassemblyend_ VECASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecassemblyend_ vecassemblyend
#endif
PETSC_EXTERN void vecassemblyend_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecAssemblyEnd(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpointwisemax_ VECPOINTWISEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpointwisemax_ vecpointwisemax
#endif
PETSC_EXTERN void vecpointwisemax_(Vec *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecPointwiseMax(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpointwisemin_ VECPOINTWISEMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpointwisemin_ vecpointwisemin
#endif
PETSC_EXTERN void vecpointwisemin_(Vec *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecPointwiseMin(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpointwisemaxabs_ VECPOINTWISEMAXABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpointwisemaxabs_ vecpointwisemaxabs
#endif
PETSC_EXTERN void vecpointwisemaxabs_(Vec *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecPointwiseMaxAbs(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpointwisedivide_ VECPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpointwisedivide_ vecpointwisedivide
#endif
PETSC_EXTERN void vecpointwisedivide_(Vec *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecPointwiseDivide(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpointwisemult_ VECPOINTWISEMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpointwisemult_ vecpointwisemult
#endif
PETSC_EXTERN void vecpointwisemult_(Vec *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecPointwiseMult(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecduplicate_ VECDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecduplicate_ vecduplicate
#endif
PETSC_EXTERN void vecduplicate_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdestroy_ VECDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdestroy_ vecdestroy
#endif
PETSC_EXTERN void vecdestroy_(Vec *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = VecDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecviewfromoptions_ VECVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecviewfromoptions_ vecviewfromoptions
#endif
PETSC_EXTERN void vecviewfromoptions_(Vec *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = VecViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecview_ VECVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecview_ vecview
#endif
PETSC_EXTERN void vecview_(Vec *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecviewnative_ VECVIEWNATIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecviewnative_ vecviewnative
#endif
PETSC_EXTERN void vecviewnative_(Vec *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecViewNative(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetsize_ VECGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetsize_ vecgetsize
#endif
PETSC_EXTERN void vecgetsize_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetlocalsize_ VECGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetlocalsize_ vecgetlocalsize
#endif
PETSC_EXTERN void vecgetlocalsize_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecGetLocalSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetownershiprange_ VECGETOWNERSHIPRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetownershiprange_ vecgetownershiprange
#endif
PETSC_EXTERN void vecgetownershiprange_(Vec *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecGetOwnershipRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecresetarray_ VECRESETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecresetarray_ vecresetarray
#endif
PETSC_EXTERN void vecresetarray_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecResetArray(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecload_ VECLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecload_ vecload
#endif
PETSC_EXTERN void vecload_(Vec *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecreciprocal_ VECRECIPROCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecreciprocal_ vecreciprocal
#endif
PETSC_EXTERN void vecreciprocal_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecReciprocal(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veczeroentries_ VECZEROENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veczeroentries_ veczeroentries
#endif
PETSC_EXTERN void veczeroentries_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecZeroEntries(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetblocksize_ VECGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetblocksize_ vecgetblocksize
#endif
PETSC_EXTERN void vecgetblocksize_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecappendoptionsprefix_ VECAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecappendoptionsprefix_ vecappendoptionsprefix
#endif
PETSC_EXTERN void vecappendoptionsprefix_(Vec *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = VecAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetoptionsprefix_ VECGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetoptionsprefix_ vecgetoptionsprefix
#endif
PETSC_EXTERN void vecgetoptionsprefix_(Vec *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = VecGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetstate_ VECGETSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetstate_ vecgetstate
#endif
PETSC_EXTERN void vecgetstate_(Vec *a, PetscObjectState *b, PetscErrorCode *ierr)
{
  *ierr = VecGetState(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccopy_ VECCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccopy_ veccopy
#endif
PETSC_EXTERN void veccopy_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecCopy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetlayout_ VECGETLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetlayout_ vecgetlayout
#endif
PETSC_EXTERN void vecgetlayout_(Vec *a, PetscLayout *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGetLayout(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecflag_ VECFLAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecflag_ vecflag
#endif
PETSC_EXTERN void vecflag_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = VecFlag(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecbindtocpu_ VECBINDTOCPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecbindtocpu_ vecbindtocpu
#endif
PETSC_EXTERN void vecbindtocpu_(Vec *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = VecBindToCPU(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecboundtocpu_ VECBOUNDTOCPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecboundtocpu_ vecboundtocpu
#endif
PETSC_EXTERN void vecboundtocpu_(Vec *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = VecBoundToCPU(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetbindingpropagates_ VECGETBINDINGPROPAGATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetbindingpropagates_ vecgetbindingpropagates
#endif
PETSC_EXTERN void vecgetbindingpropagates_(Vec *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = VecGetBindingPropagates(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetpinnedmemorymin_ VECGETPINNEDMEMORYMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetpinnedmemorymin_ vecgetpinnedmemorymin
#endif
PETSC_EXTERN void vecgetpinnedmemorymin_(Vec *a, size_t *b, PetscErrorCode *ierr)
{
  *ierr = VecGetPinnedMemoryMin(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetoffloadmask_ VECGETOFFLOADMASK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetoffloadmask_ vecgetoffloadmask
#endif
PETSC_EXTERN void vecgetoffloadmask_(Vec *a, PetscOffloadMask *b, PetscErrorCode *ierr)
{
  *ierr = VecGetOffloadMask(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecerrorweightednorms_ VECERRORWEIGHTEDNORMS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecerrorweightednorms_ vecerrorweightednorms
#endif
PETSC_EXTERN void vecerrorweightednorms_(Vec *a, Vec *b, Vec *c, NormType *d, PetscReal *e, Vec *f, PetscReal *g, Vec *h, PetscReal *i, PetscReal *j, PetscInt *k, PetscReal *l, PetscInt *m, PetscReal *n, PetscInt *o, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLINTEGER(k);
  CHKFORTRANNULLREAL(l);
  CHKFORTRANNULLINTEGER(m);
  CHKFORTRANNULLREAL(n);
  CHKFORTRANNULLINTEGER(o);
  *ierr = VecErrorWeightedNorms(*a, *b, *c, *d, *e, *f, *g, *h, *i, j, k, l, m, n, o);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstashgetinfo_ VECSTASHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstashgetinfo_ vecstashgetinfo
#endif
PETSC_EXTERN void vecstashgetinfo_(Vec *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = VecStashGetInfo(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetlocaltoglobalmapping_ VECSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetlocaltoglobalmapping_ vecsetlocaltoglobalmapping
#endif
PETSC_EXTERN void vecsetlocaltoglobalmapping_(Vec *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  *ierr = VecSetLocalToGlobalMapping(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetpreallocationcoo_ VECSETPREALLOCATIONCOO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetpreallocationcoo_ vecsetpreallocationcoo
#endif
PETSC_EXTERN void vecsetpreallocationcoo_(Vec *a, PetscCount *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecSetPreallocationCOO(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetpreallocationcoolocal_ VECSETPREALLOCATIONCOOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetpreallocationcoolocal_ vecsetpreallocationcoolocal
#endif
PETSC_EXTERN void vecsetpreallocationcoolocal_(Vec *a, PetscCount *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecSetPreallocationCOOLocal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvaluescoo_ VECSETVALUESCOO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvaluescoo_ vecsetvaluescoo
#endif
PETSC_EXTERN void vecsetvaluescoo_(Vec *a, const PetscScalar b[], InsertMode *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecSetValuesCOO(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetoption_ VECSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetoption_ vecsetoption
#endif
PETSC_EXTERN void vecsetoption_(Vec *a, VecOption *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = VecSetOption(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstashsetinitialsize_ VECSTASHSETINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstashsetinitialsize_ vecstashsetinitialsize
#endif
PETSC_EXTERN void vecstashsetinitialsize_(Vec *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = VecStashSetInitialSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetrandom_ VECSETRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetrandom_ vecsetrandom
#endif
PETSC_EXTERN void vecsetrandom_(Vec *a, PetscRandom *b, PetscErrorCode *ierr)
{
  *ierr = VecSetRandom(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetfromoptions_ VECSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetfromoptions_ vecsetfromoptions
#endif
PETSC_EXTERN void vecsetfromoptions_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetsizes_ VECSETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetsizes_ vecsetsizes
#endif
PETSC_EXTERN void vecsetsizes_(Vec *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = VecSetSizes(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetblocksize_ VECSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetblocksize_ vecsetblocksize
#endif
PETSC_EXTERN void vecsetblocksize_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = VecSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetoptionsprefix_ VECSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetoptionsprefix_ vecsetoptionsprefix
#endif
PETSC_EXTERN void vecsetoptionsprefix_(Vec *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = VecSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetup_ VECSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetup_ vecsetup
#endif
PETSC_EXTERN void vecsetup_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecswap_ VECSWAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecswap_ vecswap
#endif
PETSC_EXTERN void vecswap_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecSwap(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstashviewfromoptions_ VECSTASHVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstashviewfromoptions_ vecstashviewfromoptions
#endif
PETSC_EXTERN void vecstashviewfromoptions_(Vec *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = VecStashViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstashview_ VECSTASHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstashview_ vecstashview
#endif
PETSC_EXTERN void vecstashview_(Vec *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecStashView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetlayout_ VECSETLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetlayout_ vecsetlayout
#endif
PETSC_EXTERN void vecsetlayout_(Vec *a, PetscLayout *b, PetscErrorCode *ierr)
{
  *ierr = VecSetLayout(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetbindingpropagates_ VECSETBINDINGPROPAGATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetbindingpropagates_ vecsetbindingpropagates
#endif
PETSC_EXTERN void vecsetbindingpropagates_(Vec *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = VecSetBindingPropagates(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetpinnedmemorymin_ VECSETPINNEDMEMORYMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetpinnedmemorymin_ vecsetpinnedmemorymin
#endif
PETSC_EXTERN void vecsetpinnedmemorymin_(Vec *a, size_t *b, PetscErrorCode *ierr)
{
  *ierr = VecSetPinnedMemoryMin(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetvec_ PETSCOPTIONSGETVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetvec_ petscoptionsgetvec
#endif
PETSC_EXTERN void petscoptionsgetvec_(PetscOptions *a, char b[], char c[], Vec *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetVec(*a, c_b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
