#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitor_ TSMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitor_ tsmonitor
#endif
PETSC_EXTERN void tsmonitor_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = TSMonitor(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorcancel_ TSMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorcancel_ tsmonitorcancel
#endif
PETSC_EXTERN void tsmonitorcancel_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordefault_ TSMONITORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordefault_ tsmonitordefault
#endif
PETSC_EXTERN void tsmonitordefault_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorDefault(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorwallclocktimesetup_ TSMONITORWALLCLOCKTIMESETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorwallclocktimesetup_ tsmonitorwallclocktimesetup
#endif
PETSC_EXTERN void tsmonitorwallclocktimesetup_(TS *a, PetscViewerAndFormat **b, PetscErrorCode *ierr)
{
  *ierr = TSMonitorWallClockTimeSetUp(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorwallclocktime_ TSMONITORWALLCLOCKTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorwallclocktime_ tsmonitorwallclocktime
#endif
PETSC_EXTERN void tsmonitorwallclocktime_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorWallClockTime(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorextreme_ TSMONITOREXTREME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorextreme_ tsmonitorextreme
#endif
PETSC_EXTERN void tsmonitorextreme_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorExtreme(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgtimestep_ TSMONITORLGTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgtimestep_ tsmonitorlgtimestep
#endif
PETSC_EXTERN void tsmonitorlgtimestep_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGTimeStep(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawsolution_ TSMONITORDRAWSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawsolution_ tsmonitordrawsolution
#endif
PETSC_EXTERN void tsmonitordrawsolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorDrawSolution(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawsolutionphase_ TSMONITORDRAWSOLUTIONPHASE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawsolutionphase_ tsmonitordrawsolutionphase
#endif
PETSC_EXTERN void tsmonitordrawsolutionphase_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorDrawSolutionPhase(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawsolutionfunction_ TSMONITORDRAWSOLUTIONFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawsolutionfunction_ tsmonitordrawsolutionfunction
#endif
PETSC_EXTERN void tsmonitordrawsolutionfunction_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorDrawSolutionFunction(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawerror_ TSMONITORDRAWERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawerror_ tsmonitordrawerror
#endif
PETSC_EXTERN void tsmonitordrawerror_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorDrawError(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorsolutionsetup_ TSMONITORSOLUTIONSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorsolutionsetup_ tsmonitorsolutionsetup
#endif
PETSC_EXTERN void tsmonitorsolutionsetup_(TS *a, PetscViewerAndFormat **b, PetscErrorCode *ierr)
{
  *ierr = TSMonitorSolutionSetup(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorsolution_ TSMONITORSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorsolution_ tsmonitorsolution
#endif
PETSC_EXTERN void tsmonitorsolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorSolution(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorsolutionvtk_ TSMONITORSOLUTIONVTK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorsolutionvtk_ tsmonitorsolutionvtk
#endif
PETSC_EXTERN void tsmonitorsolutionvtk_(TS *a, PetscInt *b, PetscReal *c, Vec *d, TSMonitorVTKCtx *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorSolutionVTK(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorsolutionvtkdestroy_ TSMONITORSOLUTIONVTKDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorsolutionvtkdestroy_ tsmonitorsolutionvtkdestroy
#endif
PETSC_EXTERN void tsmonitorsolutionvtkdestroy_(TSMonitorVTKCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorSolutionVTKDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorsolutionvtkctxcreate_ TSMONITORSOLUTIONVTKCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorsolutionvtkctxcreate_ tsmonitorsolutionvtkctxcreate
#endif
PETSC_EXTERN void tsmonitorsolutionvtkctxcreate_(char a[], TSMonitorVTKCtx *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSMonitorSolutionVTKCtxCreate(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgsolution_ TSMONITORLGSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgsolution_ tsmonitorlgsolution
#endif
PETSC_EXTERN void tsmonitorlgsolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGSolution(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgerror_ TSMONITORLGERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgerror_ tsmonitorlgerror
#endif
PETSC_EXTERN void tsmonitorlgerror_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGError(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorspswarmsolution_ TSMONITORSPSWARMSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorspswarmsolution_ tsmonitorspswarmsolution
#endif
PETSC_EXTERN void tsmonitorspswarmsolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorSPSwarmSolution(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorhgswarmsolution_ TSMONITORHGSWARMSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorhgswarmsolution_ tsmonitorhgswarmsolution
#endif
PETSC_EXTERN void tsmonitorhgswarmsolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorHGSwarmSolution(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorerror_ TSMONITORERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorerror_ tsmonitorerror
#endif
PETSC_EXTERN void tsmonitorerror_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorError(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgsnesiterations_ TSMONITORLGSNESITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgsnesiterations_ tsmonitorlgsnesiterations
#endif
PETSC_EXTERN void tsmonitorlgsnesiterations_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGSNESIterations(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgkspiterations_ TSMONITORLGKSPITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgkspiterations_ tsmonitorlgkspiterations
#endif
PETSC_EXTERN void tsmonitorlgkspiterations_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGKSPIterations(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorenvelope_ TSMONITORENVELOPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorenvelope_ tsmonitorenvelope
#endif
PETSC_EXTERN void tsmonitorenvelope_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorEnvelope(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorenvelopegetbounds_ TSMONITORENVELOPEGETBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorenvelopegetbounds_ tsmonitorenvelopegetbounds
#endif
PETSC_EXTERN void tsmonitorenvelopegetbounds_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSMonitorEnvelopeGetBounds(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsdmswarmmonitormoments_ TSDMSWARMMONITORMOMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsdmswarmmonitormoments_ tsdmswarmmonitormoments
#endif
PETSC_EXTERN void tsdmswarmmonitormoments_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscViewerAndFormat **e, PetscErrorCode *ierr)
{
  *ierr = TSDMSwarmMonitorMoments(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawctxdestroy_ TSMONITORDRAWCTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawctxdestroy_ tsmonitordrawctxdestroy
#endif
PETSC_EXTERN void tsmonitordrawctxdestroy_(TSMonitorDrawCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorDrawCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitordrawctxcreate_ TSMONITORDRAWCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitordrawctxcreate_ tsmonitordrawctxcreate
#endif
PETSC_EXTERN void tsmonitordrawctxcreate_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, TSMonitorDrawCtx *i, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(i);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(i);
  *ierr = TSMonitorDrawCtxCreate(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgctxcreate_ TSMONITORLGCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgctxcreate_ tsmonitorlgctxcreate
#endif
PETSC_EXTERN void tsmonitorlgctxcreate_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, TSMonitorLGCtx *i, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(i);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(i);
  *ierr = TSMonitorLGCtxCreate(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgctxdestroy_ TSMONITORLGCTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgctxdestroy_ tsmonitorlgctxdestroy
#endif
PETSC_EXTERN void tsmonitorlgctxdestroy_(TSMonitorLGCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorLGCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorenvelopectxcreate_ TSMONITORENVELOPECTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorenvelopectxcreate_ tsmonitorenvelopectxcreate
#endif
PETSC_EXTERN void tsmonitorenvelopectxcreate_(TS *a, TSMonitorEnvelopeCtx *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSMonitorEnvelopeCtxCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorenvelopectxdestroy_ TSMONITORENVELOPECTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorenvelopectxdestroy_ tsmonitorenvelopectxdestroy
#endif
PETSC_EXTERN void tsmonitorenvelopectxdestroy_(TSMonitorEnvelopeCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorEnvelopeCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorspctxcreate_ TSMONITORSPCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorspctxcreate_ tsmonitorspctxcreate
#endif
PETSC_EXTERN void tsmonitorspctxcreate_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, PetscInt *i, PetscBool *j, PetscBool *k, TSMonitorSPCtx *l, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_l = !*(void**) l ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(l);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(l);
  *ierr = TSMonitorSPCtxCreate(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, *h, *i, *j ? PETSC_TRUE : PETSC_FALSE, *k ? PETSC_TRUE : PETSC_FALSE, l);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_l && !*(void**) l) *(void **) l = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorspctxdestroy_ TSMONITORSPCTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorspctxdestroy_ tsmonitorspctxdestroy
#endif
PETSC_EXTERN void tsmonitorspctxdestroy_(TSMonitorSPCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorSPCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorhgctxcreate_ TSMONITORHGCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorhgctxcreate_ tsmonitorhgctxcreate
#endif
PETSC_EXTERN void tsmonitorhgctxcreate_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, PetscInt *i, PetscInt *j, PetscBool *k, TSMonitorHGCtx *l, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_l = !*(void**) l ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(l);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(l);
  *ierr = TSMonitorHGCtxCreate(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, *h, *i, *j, *k ? PETSC_TRUE : PETSC_FALSE, l);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_l && !*(void**) l) *(void **) l = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorhgctxdestroy_ TSMONITORHGCTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorhgctxdestroy_ tsmonitorhgctxdestroy
#endif
PETSC_EXTERN void tsmonitorhgctxdestroy_(TSMonitorHGCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorHGCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
