#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstart_ PETSCLOGHANDLERSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstart_ petscloghandlerstart
#endif
PETSC_EXTERN void petscloghandlerstart_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerStart(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstop_ PETSCLOGHANDLERSTOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstop_ petscloghandlerstop
#endif
PETSC_EXTERN void petscloghandlerstop_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerStop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscaddlogdouble_ PETSCADDLOGDOUBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscaddlogdouble_ petscaddlogdouble
#endif
PETSC_EXTERN void petscaddlogdouble_(PetscLogDouble *a, PetscLogDouble *b, PetscLogDouble *c, PetscErrorCode *ierr)
{
  *ierr = PetscAddLogDouble(a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscaddlogdoublecnt_ PETSCADDLOGDOUBLECNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscaddlogdoublecnt_ petscaddlogdoublecnt
#endif
PETSC_EXTERN void petscaddlogdoublecnt_(PetscLogDouble *a, PetscLogDouble *b, PetscLogDouble *c, PetscLogDouble *d, PetscLogDouble *e, PetscErrorCode *ierr)
{
  *ierr = PetscAddLogDoubleCnt(a, b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggetdefaulthandler_ PETSCLOGGETDEFAULTHANDLER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggetdefaulthandler_ petscloggetdefaulthandler
#endif
PETSC_EXTERN void petscloggetdefaulthandler_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLogGetDefaultHandler(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggetstate_ PETSCLOGGETSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggetstate_ petscloggetstate
#endif
PETSC_EXTERN void petscloggetstate_(PetscLogState *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLogGetState(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogisactive_ PETSCLOGISACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogisactive_ petsclogisactive
#endif
PETSC_EXTERN void petsclogisactive_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscLogIsActive(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogdefaultbegin_ PETSCLOGDEFAULTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogdefaultbegin_ petsclogdefaultbegin
#endif
PETSC_EXTERN void petsclogdefaultbegin_(PetscErrorCode *ierr)
{
  *ierr = PetscLogDefaultBegin();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclognestedbegin_ PETSCLOGNESTEDBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclognestedbegin_ petsclognestedbegin
#endif
PETSC_EXTERN void petsclognestedbegin_(PetscErrorCode *ierr)
{
  *ierr = PetscLogNestedBegin();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogmpebegin_ PETSCLOGMPEBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogmpebegin_ petsclogmpebegin
#endif
PETSC_EXTERN void petsclogmpebegin_(PetscErrorCode *ierr)
{
  *ierr = PetscLogMPEBegin();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogperfstubsbegin_ PETSCLOGPERFSTUBSBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogperfstubsbegin_ petsclogperfstubsbegin
#endif
PETSC_EXTERN void petsclogperfstubsbegin_(PetscErrorCode *ierr)
{
  *ierr = PetscLogPerfstubsBegin();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogactions_ PETSCLOGACTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogactions_ petsclogactions
#endif
PETSC_EXTERN void petsclogactions_(PetscBool *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogActions(*a ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogobjects_ PETSCLOGOBJECTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogobjects_ petsclogobjects
#endif
PETSC_EXTERN void petsclogobjects_(PetscBool *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogObjects(*a ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstageregister_ PETSCLOGSTAGEREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstageregister_ petsclogstageregister
#endif
PETSC_EXTERN void petsclogstageregister_(char a[], PetscLogStage *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogStageRegister(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagepush_ PETSCLOGSTAGEPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagepush_ petsclogstagepush
#endif
PETSC_EXTERN void petsclogstagepush_(PetscLogStage *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogStagePush(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagepop_ PETSCLOGSTAGEPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagepop_ petsclogstagepop
#endif
PETSC_EXTERN void petsclogstagepop_(PetscErrorCode *ierr)
{
  *ierr = PetscLogStagePop();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagesetactive_ PETSCLOGSTAGESETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagesetactive_ petsclogstagesetactive
#endif
PETSC_EXTERN void petsclogstagesetactive_(PetscLogStage *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogStageSetActive(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagegetactive_ PETSCLOGSTAGEGETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagegetactive_ petsclogstagegetactive
#endif
PETSC_EXTERN void petsclogstagegetactive_(PetscLogStage *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscLogStageGetActive(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagesetvisible_ PETSCLOGSTAGESETVISIBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagesetvisible_ petsclogstagesetvisible
#endif
PETSC_EXTERN void petsclogstagesetvisible_(PetscLogStage *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogStageSetVisible(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagegetvisible_ PETSCLOGSTAGEGETVISIBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagegetvisible_ petsclogstagegetvisible
#endif
PETSC_EXTERN void petsclogstagegetvisible_(PetscLogStage *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscLogStageGetVisible(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagegetid_ PETSCLOGSTAGEGETID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagegetid_ petsclogstagegetid
#endif
PETSC_EXTERN void petsclogstagegetid_(char a[], PetscLogStage *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogStageGetId(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagegetname_ PETSCLOGSTAGEGETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagegetname_ petsclogstagegetname
#endif
PETSC_EXTERN void petsclogstagegetname_(PetscLogStage *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscLogStageGetName(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventregister_ PETSCLOGEVENTREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventregister_ petsclogeventregister
#endif
PETSC_EXTERN void petsclogeventregister_(char a[], PetscClassId *b, PetscLogEvent *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogEventRegister(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventsetcollective_ PETSCLOGEVENTSETCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventsetcollective_ petsclogeventsetcollective
#endif
PETSC_EXTERN void petsclogeventsetcollective_(PetscLogEvent *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventSetCollective(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventincludeclass_ PETSCLOGEVENTINCLUDECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventincludeclass_ petsclogeventincludeclass
#endif
PETSC_EXTERN void petsclogeventincludeclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventIncludeClass(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventexcludeclass_ PETSCLOGEVENTEXCLUDECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventexcludeclass_ petsclogeventexcludeclass
#endif
PETSC_EXTERN void petsclogeventexcludeclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventExcludeClass(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventactivate_ PETSCLOGEVENTACTIVATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventactivate_ petsclogeventactivate
#endif
PETSC_EXTERN void petsclogeventactivate_(PetscLogEvent *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventActivate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventdeactivate_ PETSCLOGEVENTDEACTIVATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventdeactivate_ petsclogeventdeactivate
#endif
PETSC_EXTERN void petsclogeventdeactivate_(PetscLogEvent *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventDeactivate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventdeactivatepush_ PETSCLOGEVENTDEACTIVATEPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventdeactivatepush_ petsclogeventdeactivatepush
#endif
PETSC_EXTERN void petsclogeventdeactivatepush_(PetscLogEvent *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventDeactivatePush(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventdeactivatepop_ PETSCLOGEVENTDEACTIVATEPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventdeactivatepop_ petsclogeventdeactivatepop
#endif
PETSC_EXTERN void petsclogeventdeactivatepop_(PetscLogEvent *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventDeactivatePop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventsetactiveall_ PETSCLOGEVENTSETACTIVEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventsetactiveall_ petsclogeventsetactiveall
#endif
PETSC_EXTERN void petsclogeventsetactiveall_(PetscLogEvent *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventSetActiveAll(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventactivateclass_ PETSCLOGEVENTACTIVATECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventactivateclass_ petsclogeventactivateclass
#endif
PETSC_EXTERN void petsclogeventactivateclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventActivateClass(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventdeactivateclass_ PETSCLOGEVENTDEACTIVATECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventdeactivateclass_ petsclogeventdeactivateclass
#endif
PETSC_EXTERN void petsclogeventdeactivateclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventDeactivateClass(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventsync_ PETSCLOGEVENTSYNC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventsync_ petsclogeventsync
#endif
PETSC_EXTERN void petsclogeventsync_(PetscLogEvent *a, MPI_Fint *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventSync(*a, MPI_Comm_f2c(*(b)));
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstagegetperfinfo_ PETSCLOGSTAGEGETPERFINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstagegetperfinfo_ petsclogstagegetperfinfo
#endif
PETSC_EXTERN void petsclogstagegetperfinfo_(PetscLogStage *a, PetscEventPerfInfo **b, PetscErrorCode *ierr)
{
  *ierr = PetscLogStageGetPerfInfo(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventgetperfinfo_ PETSCLOGEVENTGETPERFINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventgetperfinfo_ petsclogeventgetperfinfo
#endif
PETSC_EXTERN void petsclogeventgetperfinfo_(PetscLogStage *a, PetscLogEvent *b, PetscEventPerfInfo **c, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventGetPerfInfo(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventsetdof_ PETSCLOGEVENTSETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventsetdof_ petsclogeventsetdof
#endif
PETSC_EXTERN void petsclogeventsetdof_(PetscLogEvent *a, PetscInt *b, PetscLogDouble *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventSetDof(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventseterror_ PETSCLOGEVENTSETERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventseterror_ petsclogeventseterror
#endif
PETSC_EXTERN void petsclogeventseterror_(PetscLogEvent *a, PetscInt *b, PetscLogDouble *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogEventSetError(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventgetid_ PETSCLOGEVENTGETID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventgetid_ petsclogeventgetid
#endif
PETSC_EXTERN void petsclogeventgetid_(char a[], PetscLogEvent *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogEventGetId(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventgetname_ PETSCLOGEVENTGETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventgetname_ petsclogeventgetname
#endif
PETSC_EXTERN void petsclogeventgetname_(PetscLogEvent *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscLogEventGetName(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventspause_ PETSCLOGEVENTSPAUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventspause_ petsclogeventspause
#endif
PETSC_EXTERN void petsclogeventspause_(PetscErrorCode *ierr)
{
  *ierr = PetscLogEventsPause();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogeventsresume_ PETSCLOGEVENTSRESUME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogeventsresume_ petsclogeventsresume
#endif
PETSC_EXTERN void petsclogeventsresume_(PetscErrorCode *ierr)
{
  *ierr = PetscLogEventsResume();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogobjectcreate_ PETSCLOGOBJECTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogobjectcreate_ petsclogobjectcreate
#endif
PETSC_EXTERN void petsclogobjectcreate_(PetscObject *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_CREATE(a);
  *ierr = PetscLogObjectCreate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogobjectdestroy_ PETSCLOGOBJECTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogobjectdestroy_ petsclogobjectdestroy
#endif
PETSC_EXTERN void petsclogobjectdestroy_(PetscObject *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  *ierr = PetscLogObjectDestroy(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogclassgetclassid_ PETSCLOGCLASSGETCLASSID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogclassgetclassid_ petsclogclassgetclassid
#endif
PETSC_EXTERN void petsclogclassgetclassid_(char a[], PetscClassId *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogClassGetClassId(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogdump_ PETSCLOGDUMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogdump_ petsclogdump
#endif
PETSC_EXTERN void petsclogdump_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogDump(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogmpedump_ PETSCLOGMPEDUMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogmpedump_ petsclogmpedump
#endif
PETSC_EXTERN void petsclogmpedump_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscLogMPEDump(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogview_ PETSCLOGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogview_ petsclogview
#endif
PETSC_EXTERN void petsclogview_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscLogView(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogviewfromoptions_ PETSCLOGVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogviewfromoptions_ petsclogviewfromoptions
#endif
PETSC_EXTERN void petsclogviewfromoptions_(PetscErrorCode *ierr)
{
  *ierr = PetscLogViewFromOptions();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogsetthreshold_ PETSCLOGSETTHRESHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogsetthreshold_ petsclogsetthreshold
#endif
PETSC_EXTERN void petsclogsetthreshold_(PetscLogDouble *a, PetscLogDouble *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogSetThreshold(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetflops_ PETSCGETFLOPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetflops_ petscgetflops
#endif
PETSC_EXTERN void petscgetflops_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscGetFlops(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogflops_ PETSCLOGFLOPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogflops_ petsclogflops
#endif
PETSC_EXTERN void petsclogflops_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogFlops(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputime_ PETSCLOGGPUTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputime_ petscloggputime
#endif
PETSC_EXTERN void petscloggputime_(PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuTime();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputimebegin_ PETSCLOGGPUTIMEBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputimebegin_ petscloggputimebegin
#endif
PETSC_EXTERN void petscloggputimebegin_(PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuTimeBegin();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloggputimeend_ PETSCLOGGPUTIMEEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloggputimeend_ petscloggputimeend
#endif
PETSC_EXTERN void petscloggputimeend_(PetscErrorCode *ierr)
{
  *ierr = PetscLogGpuTimeEnd();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscclassidregister_ PETSCCLASSIDREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscclassidregister_ petscclassidregister
#endif
PETSC_EXTERN void petscclassidregister_(char a[], PetscClassId *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscClassIdRegister(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
