#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsnescomputeobjectivefem_ DMPLEXSNESCOMPUTEOBJECTIVEFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsnescomputeobjectivefem_ dmplexsnescomputeobjectivefem
#endif
PETSC_EXTERN void dmplexsnescomputeobjectivefem_(DM *a, Vec *b, PetscReal *c, void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexSNESComputeObjectiveFEM(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsnescomputeresidualfem_ DMPLEXSNESCOMPUTERESIDUALFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsnescomputeresidualfem_ dmplexsnescomputeresidualfem
#endif
PETSC_EXTERN void dmplexsnescomputeresidualfem_(DM *a, Vec *b, Vec *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexSNESComputeResidualFEM(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsnescomputeresidualds_ DMPLEXSNESCOMPUTERESIDUALDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsnescomputeresidualds_ dmplexsnescomputeresidualds
#endif
PETSC_EXTERN void dmplexsnescomputeresidualds_(DM *a, Vec *b, Vec *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexSNESComputeResidualDS(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsnescomputeboundaryfem_ DMPLEXSNESCOMPUTEBOUNDARYFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsnescomputeboundaryfem_ dmplexsnescomputeboundaryfem
#endif
PETSC_EXTERN void dmplexsnescomputeboundaryfem_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSNESComputeBoundaryFEM(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescomputejacobianaction_ DMSNESCOMPUTEJACOBIANACTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescomputejacobianaction_ dmsnescomputejacobianaction
#endif
PETSC_EXTERN void dmsnescomputejacobianaction_(DM *a, Vec *b, Vec *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMSNESComputeJacobianAction(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsnescomputejacobianfem_ DMPLEXSNESCOMPUTEJACOBIANFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsnescomputejacobianfem_ dmplexsnescomputejacobianfem
#endif
PETSC_EXTERN void dmplexsnescomputejacobianfem_(DM *a, Vec *b, Mat *c, Mat *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexSNESComputeJacobianFEM(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescreatejacobianmf_ DMSNESCREATEJACOBIANMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescreatejacobianmf_ dmsnescreatejacobianmf
#endif
PETSC_EXTERN void dmsnescreatejacobianmf_(DM *a, Vec *b, void *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMSNESCreateJacobianMF(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetsneslocalfem_ DMPLEXSETSNESLOCALFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetsneslocalfem_ dmplexsetsneslocalfem
#endif
PETSC_EXTERN void dmplexsetsneslocalfem_(DM *a, PetscBool *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetSNESLocalFEM(*a, *b ? PETSC_TRUE : PETSC_FALSE, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescheckdiscretization_ DMSNESCHECKDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescheckdiscretization_ dmsnescheckdiscretization
#endif
PETSC_EXTERN void dmsnescheckdiscretization_(SNES *a, DM *b, PetscReal *c, Vec *d, PetscReal *e, PetscReal f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMSNESCheckDiscretization(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescheckresidual_ DMSNESCHECKRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescheckresidual_ dmsnescheckresidual
#endif
PETSC_EXTERN void dmsnescheckresidual_(SNES *a, DM *b, Vec *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  *ierr = DMSNESCheckResidual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescheckjacobian_ DMSNESCHECKJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescheckjacobian_ dmsnescheckjacobian
#endif
PETSC_EXTERN void dmsnescheckjacobian_(SNES *a, DM *b, Vec *c, PetscReal *d, PetscBool *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = DMSNESCheckJacobian(*a, *b, *c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnescheckfromoptions_ DMSNESCHECKFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnescheckfromoptions_ dmsnescheckfromoptions
#endif
PETSC_EXTERN void dmsnescheckfromoptions_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMSNESCheckFromOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetsnesvariablebounds_ DMPLEXSETSNESVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetsnesvariablebounds_ dmplexsetsnesvariablebounds
#endif
PETSC_EXTERN void dmplexsetsnesvariablebounds_(DM *a, SNES *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetSNESVariableBounds(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesconvergedcorrectpressure_ SNESCONVERGEDCORRECTPRESSURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesconvergedcorrectpressure_ snesconvergedcorrectpressure
#endif
PETSC_EXTERN void snesconvergedcorrectpressure_(SNES *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, SNESConvergedReason *f, void *g, PetscErrorCode *ierr)
{
  *ierr = SNESConvergedCorrectPressure(*a, *b, *c, *d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmonitorfields_ SNESMONITORFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmonitorfields_ snesmonitorfields
#endif
PETSC_EXTERN void snesmonitorfields_(SNES *a, PetscInt *b, PetscReal *c, PetscViewerAndFormat **d, PetscErrorCode *ierr)
{
  *ierr = SNESMonitorFields(*a, *b, *c, *d);
  if (*ierr) return;
}
