#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatefft_ MATCREATEFFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatefft_ matcreatefft
#endif
PETSC_EXTERN void matcreatefft_(MPI_Fint *a, PetscInt *b, const PetscInt c[], char *d, Mat *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateFFT(MPI_Comm_f2c(*(a)), *b, c, c_d, e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
