#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcohesiveextrudegettensor_ DMPLEXTRANSFORMCOHESIVEEXTRUDEGETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcohesiveextrudegettensor_ dmplextransformcohesiveextrudegettensor
#endif
PETSC_EXTERN void dmplextransformcohesiveextrudegettensor_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexTransformCohesiveExtrudeGetTensor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcohesiveextrudesettensor_ DMPLEXTRANSFORMCOHESIVEEXTRUDESETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcohesiveextrudesettensor_ dmplextransformcohesiveextrudesettensor
#endif
PETSC_EXTERN void dmplextransformcohesiveextrudesettensor_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformCohesiveExtrudeSetTensor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcohesiveextrudegetwidth_ DMPLEXTRANSFORMCOHESIVEEXTRUDEGETWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcohesiveextrudegetwidth_ dmplextransformcohesiveextrudegetwidth
#endif
PETSC_EXTERN void dmplextransformcohesiveextrudegetwidth_(DMPlexTransform *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexTransformCohesiveExtrudeGetWidth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcohesiveextrudesetwidth_ DMPLEXTRANSFORMCOHESIVEEXTRUDESETWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcohesiveextrudesetwidth_ dmplextransformcohesiveextrudesetwidth
#endif
PETSC_EXTERN void dmplextransformcohesiveextrudesetwidth_(DMPlexTransform *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformCohesiveExtrudeSetWidth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcohesiveextrudegetunsplit_ DMPLEXTRANSFORMCOHESIVEEXTRUDEGETUNSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcohesiveextrudegetunsplit_ dmplextransformcohesiveextrudegetunsplit
#endif
PETSC_EXTERN void dmplextransformcohesiveextrudegetunsplit_(DMPlexTransform *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexTransformCohesiveExtrudeGetUnsplit(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
