#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturecreate_ PETSCQUADRATURECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturecreate_ petscquadraturecreate
#endif
PETSC_EXTERN void petscquadraturecreate_(MPI_Fint *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscQuadratureCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadratureduplicate_ PETSCQUADRATUREDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadratureduplicate_ petscquadratureduplicate
#endif
PETSC_EXTERN void petscquadratureduplicate_(PetscQuadrature *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscQuadratureDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturedestroy_ PETSCQUADRATUREDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturedestroy_ petscquadraturedestroy
#endif
PETSC_EXTERN void petscquadraturedestroy_(PetscQuadrature *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscQuadratureDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturegetcelltype_ PETSCQUADRATUREGETCELLTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturegetcelltype_ petscquadraturegetcelltype
#endif
PETSC_EXTERN void petscquadraturegetcelltype_(PetscQuadrature *a, DMPolytopeType *b, PetscErrorCode *ierr)
{
  *ierr = PetscQuadratureGetCellType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturesetcelltype_ PETSCQUADRATURESETCELLTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturesetcelltype_ petscquadraturesetcelltype
#endif
PETSC_EXTERN void petscquadraturesetcelltype_(PetscQuadrature *a, DMPolytopeType *b, PetscErrorCode *ierr)
{
  *ierr = PetscQuadratureSetCellType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturegetorder_ PETSCQUADRATUREGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturegetorder_ petscquadraturegetorder
#endif
PETSC_EXTERN void petscquadraturegetorder_(PetscQuadrature *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscQuadratureGetOrder(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturesetorder_ PETSCQUADRATURESETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturesetorder_ petscquadraturesetorder
#endif
PETSC_EXTERN void petscquadraturesetorder_(PetscQuadrature *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscQuadratureSetOrder(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturegetnumcomponents_ PETSCQUADRATUREGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturegetnumcomponents_ petscquadraturegetnumcomponents
#endif
PETSC_EXTERN void petscquadraturegetnumcomponents_(PetscQuadrature *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscQuadratureGetNumComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturesetnumcomponents_ PETSCQUADRATURESETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturesetnumcomponents_ petscquadraturesetnumcomponents
#endif
PETSC_EXTERN void petscquadraturesetnumcomponents_(PetscQuadrature *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscQuadratureSetNumComponents(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadratureequal_ PETSCQUADRATUREEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadratureequal_ petscquadratureequal
#endif
PETSC_EXTERN void petscquadratureequal_(PetscQuadrature *a, PetscQuadrature *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscQuadratureEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadraturepushforward_ PETSCQUADRATUREPUSHFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadraturepushforward_ petscquadraturepushforward
#endif
PETSC_EXTERN void petscquadraturepushforward_(PetscQuadrature *a, PetscInt *b, const PetscReal c[], const PetscReal d[], const PetscReal e[], PetscInt *f, PetscQuadrature *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLOBJECT(g);
  *ierr = PetscQuadraturePushForward(*a, *b, c, d, e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadratureview_ PETSCQUADRATUREVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadratureview_ petscquadratureview
#endif
PETSC_EXTERN void petscquadratureview_(PetscQuadrature *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscQuadratureView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscquadratureexpandcomposite_ PETSCQUADRATUREEXPANDCOMPOSITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscquadratureexpandcomposite_ petscquadratureexpandcomposite
#endif
PETSC_EXTERN void petscquadratureexpandcomposite_(PetscQuadrature *a, PetscInt *b, const PetscReal c[], const PetscReal d[], PetscQuadrature *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscQuadratureExpandComposite(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtjacobinorm_ PETSCDTJACOBINORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtjacobinorm_ petscdtjacobinorm
#endif
PETSC_EXTERN void petscdtjacobinorm_(PetscReal *a, PetscReal *b, PetscInt *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = PetscDTJacobiNorm(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtjacobievaljet_ PETSCDTJACOBIEVALJET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtjacobievaljet_ petscdtjacobievaljet
#endif
PETSC_EXTERN void petscdtjacobievaljet_(PetscReal *a, PetscReal *b, PetscInt *c, const PetscReal d[], PetscInt *e, PetscInt *f, PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscDTJacobiEvalJet(*a, *b, *c, d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtjacobieval_ PETSCDTJACOBIEVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtjacobieval_ petscdtjacobieval
#endif
PETSC_EXTERN void petscdtjacobieval_(PetscInt *a, PetscReal *b, PetscReal *c, const PetscReal *d, PetscInt *e, const PetscInt *f, PetscReal g[], PetscReal h[], PetscReal i[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLREAL(i);
  *ierr = PetscDTJacobiEval(*a, *b, *c, d, *e, f, g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtlegendreeval_ PETSCDTLEGENDREEVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtlegendreeval_ petscdtlegendreeval
#endif
PETSC_EXTERN void petscdtlegendreeval_(PetscInt *a, const PetscReal *b, PetscInt *c, const PetscInt *d, PetscReal e[], PetscReal f[], PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscDTLegendreEval(*a, b, *c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtindextogradedorder_ PETSCDTINDEXTOGRADEDORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtindextogradedorder_ petscdtindextogradedorder
#endif
PETSC_EXTERN void petscdtindextogradedorder_(PetscInt *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDTIndexToGradedOrder(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgradedordertoindex_ PETSCDTGRADEDORDERTOINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgradedordertoindex_ petscdtgradedordertoindex
#endif
PETSC_EXTERN void petscdtgradedordertoindex_(PetscInt *a, const PetscInt b[], PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDTGradedOrderToIndex(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtpkdevaljet_ PETSCDTPKDEVALJET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtpkdevaljet_ petscdtpkdevaljet
#endif
PETSC_EXTERN void petscdtpkdevaljet_(PetscInt *a, PetscInt *b, const PetscReal c[], PetscInt *d, PetscInt *e, PetscReal f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscDTPKDEvalJet(*a, *b, c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtptrimmedsize_ PETSCDTPTRIMMEDSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtptrimmedsize_ petscdtptrimmedsize
#endif
PETSC_EXTERN void petscdtptrimmedsize_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscDTPTrimmedSize(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtptrimmedevaljet_ PETSCDTPTRIMMEDEVALJET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtptrimmedevaljet_ petscdtptrimmedevaljet
#endif
PETSC_EXTERN void petscdtptrimmedevaljet_(PetscInt *a, PetscInt *b, const PetscReal c[], PetscInt *d, PetscInt *e, PetscInt *f, PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscDTPTrimmedEvalJet(*a, *b, c, *d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgaussjacobiquadrature_ PETSCDTGAUSSJACOBIQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgaussjacobiquadrature_ petscdtgaussjacobiquadrature
#endif
PETSC_EXTERN void petscdtgaussjacobiquadrature_(PetscInt *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal f[], PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscDTGaussJacobiQuadrature(*a, *b, *c, *d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgausslobattojacobiquadrature_ PETSCDTGAUSSLOBATTOJACOBIQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgausslobattojacobiquadrature_ petscdtgausslobattojacobiquadrature
#endif
PETSC_EXTERN void petscdtgausslobattojacobiquadrature_(PetscInt *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal f[], PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = PetscDTGaussLobattoJacobiQuadrature(*a, *b, *c, *d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgaussquadrature_ PETSCDTGAUSSQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgaussquadrature_ petscdtgaussquadrature
#endif
PETSC_EXTERN void petscdtgaussquadrature_(PetscInt *a, PetscReal *b, PetscReal *c, PetscReal d[], PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTGaussQuadrature(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgausslobattolegendrequadrature_ PETSCDTGAUSSLOBATTOLEGENDREQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgausslobattolegendrequadrature_ petscdtgausslobattolegendrequadrature
#endif
PETSC_EXTERN void petscdtgausslobattolegendrequadrature_(PetscInt *a, PetscGaussLobattoLegendreCreateType *b, PetscReal c[], PetscReal d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscDTGaussLobattoLegendreQuadrature(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtgausstensorquadrature_ PETSCDTGAUSSTENSORQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtgausstensorquadrature_ petscdtgausstensorquadrature
#endif
PETSC_EXTERN void petscdtgausstensorquadrature_(PetscInt *a, PetscInt *b, PetscInt *c, PetscReal *d, PetscReal *e, PetscQuadrature *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscDTGaussTensorQuadrature(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtstroudconicalquadrature_ PETSCDTSTROUDCONICALQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtstroudconicalquadrature_ petscdtstroudconicalquadrature
#endif
PETSC_EXTERN void petscdtstroudconicalquadrature_(PetscInt *a, PetscInt *b, PetscInt *c, PetscReal *d, PetscReal *e, PetscQuadrature *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscDTStroudConicalQuadrature(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtsimplexquadrature_ PETSCDTSIMPLEXQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtsimplexquadrature_ petscdtsimplexquadrature
#endif
PETSC_EXTERN void petscdtsimplexquadrature_(PetscInt *a, PetscInt *b, PetscDTSimplexQuadratureType *c, PetscQuadrature *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscDTSimplexQuadrature(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdttanhsinhtensorquadrature_ PETSCDTTANHSINHTENSORQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdttanhsinhtensorquadrature_ petscdttanhsinhtensorquadrature
#endif
PETSC_EXTERN void petscdttanhsinhtensorquadrature_(PetscInt *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscQuadrature *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscDTTanhSinhTensorQuadrature(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdttensorquadraturecreate_ PETSCDTTENSORQUADRATURECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdttensorquadraturecreate_ petscdttensorquadraturecreate
#endif
PETSC_EXTERN void petscdttensorquadraturecreate_(PetscQuadrature *a, PetscQuadrature *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDTTensorQuadratureCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtreconstructpoly_ PETSCDTRECONSTRUCTPOLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtreconstructpoly_ petscdtreconstructpoly
#endif
PETSC_EXTERN void petscdtreconstructpoly_(PetscInt *a, PetscInt *b, const PetscReal c[], PetscInt *d, const PetscReal e[], PetscReal f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscDTReconstructPoly(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgausslobattolegendreintegrate_ PETSCGAUSSLOBATTOLEGENDREINTEGRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgausslobattolegendreintegrate_ petscgausslobattolegendreintegrate
#endif
PETSC_EXTERN void petscgausslobattolegendreintegrate_(PetscInt *a, PetscReal b[], PetscReal c[], const PetscReal d[], PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscGaussLobattoLegendreIntegrate(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtindextobary_ PETSCDTINDEXTOBARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtindextobary_ petscdtindextobary
#endif
PETSC_EXTERN void petscdtindextobary_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscDTIndexToBary(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtbarytoindex_ PETSCDTBARYTOINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtbarytoindex_ petscdtbarytoindex
#endif
PETSC_EXTERN void petscdtbarytoindex_(PetscInt *a, PetscInt *b, const PetscInt c[], PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscDTBaryToIndex(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtcreatequadraturebycell_ PETSCDTCREATEQUADRATUREBYCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtcreatequadraturebycell_ petscdtcreatequadraturebycell
#endif
PETSC_EXTERN void petscdtcreatequadraturebycell_(DMPolytopeType *a, PetscInt *b, PetscDTSimplexQuadratureType *c, PetscQuadrature *d, PetscQuadrature *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscDTCreateQuadratureByCell(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtcreatedefaultquadrature_ PETSCDTCREATEDEFAULTQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtcreatedefaultquadrature_ petscdtcreatedefaultquadrature
#endif
PETSC_EXTERN void petscdtcreatedefaultquadrature_(DMPolytopeType *a, PetscInt *b, PetscQuadrature *c, PetscQuadrature *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscDTCreateDefaultQuadrature(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
