#!/usr/bin/python3
if __name__ == '__main__':
  import sys
  import os
  sys.path.insert(0, os.path.abspath('config'))
  import configure
  configure_options = [
    '--prefix=/opt/petsc/linux-c-opt',
    '--with-bison=1',
    '--with-cmake=0',
    '--with-fftw=1',
    '--with-gsl=1',
    '--with-hdf5-fortran-bindings=1',
    '--with-hdf5=1',
    '--with-hwloc=1',
    '--with-hypre-include=/usr/include/hypre',
    '--with-hypre-lib=/usr/lib/libHYPRE.so',
    '--with-kokkos-include=/usr/include/kokkos',
    '--with-kokkos-lib=libkokkoscore.so',
    '--with-kokkos=1',
    '--with-libjpeg=1',
    '--with-metis=1',
    '--with-mpi-dir=/usr',
    '--with-mpi-f90module-visibility=0',
    '--with-mumps=1',
    '--with-parmetis=1',
    '--with-pastix=1',
    '--with-petsc4py=1',
    '--with-ptscotch-include=/usr/include',
    '--with-ptscotch-lib=[libesmumps.so,libptscotch.so,libptscotcherr.so,libscotch.so,libscotcherr.so]',
    '--with-ptscotch=1',
    '--with-scalapack=1',
    '--with-shared-libraries=1',
    '--with-suitesparse=1',
    '--with-superlu-include=/usr/include/superlu',
    '--with-superlu-lib=-lsuperlu',
    '--with-superlu_dist-include=/usr/include/superlu_dist',
    '--with-superlu_dist-lib=-lsuperlu_dist',
    '--with-triangle=1',
    '--with-yaml=1',
    '--with-zfp=1',
    '--with-zoltan=1',
    'CFLAGS=-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/petsc/src=/usr/src/debug/petsc -flto=auto',
    'CXXFLAGS=-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/petsc/src=/usr/src/debug/petsc -flto=auto',
    'FFLAGS=-march=x86-64 -mtune=generic -O2 -pipe -fno-plt         -Wp,-D_FORTIFY_SOURCE=3 -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/petsc/src=/usr/src/debug/petsc',
    'LDFLAGS=-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs -flto=auto',
    'MAKEFLAGS=-j32',
    'PETSC_ARCH=linux-c-opt',
  ]
  configure.petsc_configure(configure_options)
