"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.numOpenSockets = exports.ProxyServer = void 0;
exports.createProxyServer = createProxyServer;
exports.createServer = createProxyServer;
exports.createProxy = createProxyServer;
const index_1 = require("./http-proxy/index");
Object.defineProperty(exports, "ProxyServer", { enumerable: true, get: function () { return index_1.ProxyServer; } });
var ws_incoming_1 = require("./http-proxy/passes/ws-incoming");
Object.defineProperty(exports, "numOpenSockets", { enumerable: true, get: function () { return ws_incoming_1.numOpenSockets; } });
/**
 * Creates the proxy server.
 *
 * Examples:
 *
 *    httpProxy.createProxyServer({ .. }, 8000)
 *    // => '{ web: [Function], ws: [Function] ... }'
 *
 * @param {Object} Options Config object passed to the proxy
 *
 * @return {Object} Proxy Proxy object with handlers for `ws` and `web` requests
 *
 * @api public
 */
function createProxyServer(options = {}) {
    return new index_1.ProxyServer(options);
}
/**
 * Export the proxy "Server" as the main export.
 */
exports.default = index_1.ProxyServer;
