/*!
 * Font Awesome Free 7.0.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _so;
  var z = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      }
    };
  var a = "classic",
    o = "duotone",
    d = "sharp",
    t = "sharp-duotone",
    i = "chisel",
    n = "etch",
    h = "jelly",
    s = "jelly-duo",
    f = "jelly-fill",
    g = "notdog",
    l = "notdog-duo",
    u = "slab",
    p = "slab-press",
    e = "thumbprint",
    w = "whiteboard",
    m = "Classic",
    y = "Duotone",
    x = "Sharp",
    c = "Sharp Duotone",
    I = "Chisel",
    b = "Etch",
    F = "Jelly",
    v = "Jelly Duo",
    S = "Jelly Fill",
    A = "Notdog",
    P = "Notdog Duo",
    j = "Slab",
    B = "Slab Press",
    N = "Thumbprint",
    k = "Whiteboard",
    so = (_so = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, a, m), o, y), d, x), t, c), i, I), n, b), h, F), s, v), f, S), g, A), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, l, P), u, j), p, B), e, N), w, k));
  var io = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      }
    };
  var Ro = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var Oo = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Go = ["kit"];
  var D = "kit",
    r = "kit-duotone",
    T = "Kit",
    C = "Kit Duotone",
    qo = _defineProperty(_defineProperty({}, D, T), r, C);
  var Xo = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var et = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var dt = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _fl;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var f$1 = "classic",
    a$1 = "duotone",
    n$1 = "sharp",
    t$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    u$1 = "jelly",
    s$1 = "jelly-duo",
    p$1 = "jelly-fill",
    y$1 = "notdog",
    e$1 = "notdog-duo",
    m$1 = "slab",
    c$1 = "slab-press",
    r$1 = "thumbprint",
    w$1 = "whiteboard",
    x$1 = "Classic",
    I$1 = "Duotone",
    b$1 = "Sharp",
    F$1 = "Sharp Duotone",
    v$1 = "Chisel",
    S$1 = "Etch",
    A$1 = "Jelly",
    j$1 = "Jelly Duo",
    P$1 = "Jelly Fill",
    B$1 = "Notdog",
    k$1 = "Notdog Duo",
    N$1 = "Slab",
    D$1 = "Slab Press",
    C$1 = "Thumbprint",
    T$1 = "Whiteboard",
    fl = (_fl = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, f$1, x$1), a$1, I$1), n$1, b$1), t$1, F$1), h$1, v$1), g$1, S$1), u$1, A$1), s$1, j$1), p$1, P$1), y$1, B$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, e$1, k$1), m$1, N$1), c$1, D$1), r$1, C$1), w$1, T$1));
  var L = "kit",
    d$1 = "kit-duotone",
    R$1 = "Kit",
    W$1 = "Kit Duotone",
    lo$1 = _defineProperty(_defineProperty({}, L, R$1), d$1, W$1);
  var zo$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      }
    },
    J$1 = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"]
    },
    Go$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      }
    },
    _$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    K$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    M$1 = K$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    O$1 = ["aw", "fw", "pull-left", "pull-right"],
    Ho$1 = [].concat(_toConsumableArray(Object.keys(J$1)), _$1, O$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(K$1.map(function (o) {
      return "".concat(o, "x");
    })).concat(M$1.map(function (o) {
      return "w-".concat(o);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[a];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, z);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), z[a]), Oo['kit']), Oo['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, Ro);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[a]), dt['kit']), dt['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Go$1);
  _PREFIX_TO_LONG_STYLE[a] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[a]), et['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, zo$1);
  _LONG_STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[a]), Xo['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, io);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Go), _toConsumableArray(Ho$1));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "square-github": [448, 512, ["github-square"], "f092", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM265.8 407.7c0-1.8 0-6 .1-11.6 .1-11.4 .1-28.8 .1-43.7 0-15.6-5.2-25.5-11.3-30.7 37-4.1 76-9.2 76-73.1 0-18.2-6.5-27.3-17.1-39 1.7-4.3 7.4-22-1.7-45-13.9-4.3-45.7 17.9-45.7 17.9-26.6-7.5-56.6-7.5-83.2 0 0 0-31.8-22.2-45.7-17.9-9.1 22.9-3.5 40.6-1.7 45-10.6 11.7-15.6 20.8-15.6 39 0 63.6 37.3 69 74.3 73.1-4.8 4.3-9.1 11.7-10.6 22.3-9.5 4.3-33.8 11.7-48.3-13.9-9.1-15.8-25.5-17.1-25.5-17.1-16.2-.2-1.1 10.2-1.1 10.2 10.8 5 18.4 24.2 18.4 24.2 9.7 29.7 56.1 19.7 56.1 19.7 0 9 .1 21.7 .1 30.6 0 4.8 .1 8.6 .1 10 0 4.3-3 9.5-11.5 8-66-22.1-112.2-84.9-112.2-158.3 0-91.8 70.2-161.5 162-161.5S388 165.6 388 257.4c.1 73.4-44.7 136.3-110.7 158.3-8.4 1.5-11.5-3.7-11.5-8zm-90.5-54.8c-.2-1.5 1.1-2.8 3-3.2 1.9-.2 3.7 .6 3.9 1.9 .3 1.3-1 2.6-3 3-1.9 .4-3.7-.4-3.9-1.7zm-9.1 3.2c-2.2 .2-3.7-.9-3.7-2.4 0-1.3 1.5-2.4 3.5-2.4 1.9-.2 3.7 .9 3.7 2.4 0 1.3-1.5 2.4-3.5 2.4zm-14.3-2.2c-1.9-.4-3.2-1.9-2.8-3.2s2.4-1.9 4.1-1.5c2 .6 3.3 2.1 2.8 3.4-.4 1.3-2.4 1.9-4.1 1.3zm-12.5-7.3c-1.5-1.3-1.9-3.2-.9-4.1 .9-1.1 2.8-.9 4.3 .6 1.3 1.3 1.8 3.3 .9 4.1-.9 1.1-2.8 .9-4.3-.6zm-8.5-10c-1.1-1.5-1.1-3.2 0-3.9 1.1-.9 2.8-.2 3.7 1.3 1.1 1.5 1.1 3.3 0 4.1-.9 .6-2.6 0-3.7-1.5zm-6.3-8.8c-1.1-1.3-1.3-2.8-.4-3.5 .9-.9 2.4-.4 3.5 .6 1.1 1.3 1.3 2.8 .4 3.5-.9 .9-2.4 .4-3.5-.6zm-6-6.4c-1.3-.6-1.9-1.7-1.5-2.6 .4-.6 1.5-.9 2.8-.4 1.3 .7 1.9 1.8 1.5 2.6-.4 .9-1.7 1.1-2.8 .4z"],
    "think-peaks": [576, 512, [], "f731", "M465.4 409.4l87.1-150.2-32-.3-55.1 95-206.2-353.9-236.2 407.4 32 .3 204.2-352.1 206.2 353.8zM110.1 365.3l32.1 0 117.4-202.5 203.4 349.1 32.5 .1-235.8-404.6-149.6 257.9z"],
    "google-drive": [512, 512, [], "f3aa", "M339 314.9L175.4 32 336.6 32 500.2 314.9 339 314.9zM201.5 338.5l-80.6 141.5 310.5 0 80.6-141.5-310.5 0zM154.1 67.4L0 338.5 80.6 480 237 208.8 154.1 67.4z"],
    "autoprefixer": [640, 512, [], "f41c", "M318.4 16l-161 480 77.5 0 25.4-81.4 119.5 0 25.2 81.4 77.5 0-164.1-480zM278.1 357.9l41.2-130.4 1.5 0 40.9 130.4-83.6 0zM640 405L630 373.6 462.1 358 481.5 414.5 640 405zM177.9 358L10 373.7 0 405 158.5 414.4 177.9 358z"],
    "square-viadeo": [448, 512, ["viadeo-square"], "f2aa", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM118.3 381.2c-68-73.6-19.8-196.1 81.2-196.1 13.3 0 26.6 2.1 39.1 6.7-4.3 8.4-7.3 17.6-8.4 27.1-9.7-4.1-20.2-6-30.7-6-48.8 0-84.6 41.7-84.6 88.9 0 43 28.5 78.7 69.5 85.9 61.5-24 72.9-117.6 72.9-175 0-7.3 0-14.8-.6-22.1-11.2-32.9-26.6-64.6-44.2-94.5 27.1 18.3 41.9 62.5 44.2 94.1l0 .4c7.7 22.5 11.8 46.2 11.8 70 0 54.1-21.9 99-68.3 128.2l-2.4 .2c50 1 86.2-38.6 86.2-87.2 0-12.2-2.1-24.3-6.9-35.7 9.5-1.9 18.5-5.6 26.4-10.5 15.3 36.6 12.6 87.3-22.8 125.6-42.4 46.2-120 46.6-162.4 0zM274.6 217.6c21.9-12 49.6-30.7 62.3-53 1.5-3 4.1-8.6 4.5-12-12.5 27.9-44.2 49.8-73.9 56.7-4.7-7.3-7.5-15.5-7.5-24.3 0-10.3 5.2-24.1 12.9-31.6 8.3-7.9 18-10.9 27.9-14.1 16-5.1 32.5-10.3 44.5-35.9 32.5 46.2 13.1 130.3-36.3 130.3-13.3 0-25.1-7.1-34.4-16.1z"],
    "cpanel": [640, 512, [], "f388", "M210.3 220.2c-5.6-24.8-26.9-41.2-51-41.2l-37 0c-7.1 0-12.5 4.5-14.3 10.9L73.1 320 97.8 319.9c6.8 0 12.3-4.5 14.2-10.7l25.8-95.7 19.8 0c8.4 0 16.2 5.6 18.3 14.8 2.5 10.9-5.9 22.6-18.3 22.6l-10.3 0c-7 0-12.5 4.6-14.3 10.8l-6.4 23.8 32 0c37.2 0 58.3-36.2 51.7-65.3zm-156.5 28l18.6 0c6.9 0 12.4-4.4 14.3-10.9l6.2-23.6-40 0C30 213.7 9 227.8 1.7 254.8-7 288.6 18.5 320 52 320l12.4 0 7.1-26.1c1.2-4.4-2.2-8.3-6.4-8.3l-11.3 0c-24.7 0-24.9-37.4 0-37.4zm247.5-34.8l-77.9 0-3.5 13.4c-2.4 9.6 4.5 18.5 14.2 18.5l57.5 0c4 0 2.4 4.3 2.1 5.3l-8.6 31.8c-.4 1.4-.9 5.3-5.5 5.3l-34.9 0c-5.3 0-5.3-7.9 0-7.9l21.6 0c6.8 0 12.3-4.6 14.2-10.8l3.5-13.2-48.4 0c-39.2 0-43.6 63.8-.7 63.8l57.5 .2c11.2 0 20.6-7.2 23.4-17.8l14-51.8c4.8-19.2-9.7-36.8-28.5-36.8zM633.1 179l-18.9 0c-4.9 0-9.2 3.2-10.4 7.9L568.2 320c20.7 0 39.8-13.8 44.9-34.5l26.5-98.2c1.2-4.3-2-8.3-6.5-8.3zM396.8 213.7l0 .1-48.3 0-26.2 98c-1.2 4.4 2.2 8.3 6.4 8.3l18.9 0c4.8 0 9.2-3 10.4-7.8l17.2-64 19.8 0c12.5 0 21.4 11.8 18.1 23.4l-10.6 40c-1.2 4.3 1.9 8.3 6.4 8.3l19.1 0c4.6 0 9.1-2.9 10.3-7.8l8.8-33.1c9-33.1-15.9-65.4-50.3-65.4zm98.3 74.6c-3.6 0-6-3.4-5.1-6.7l8-30c.9-3.9 3.7-6 7.8-6l32.9 0c2.6 0 4.6 2.4 3.9 5.1l-.7 2.6c-.6 2-1.9 3-3.9 3l-21.6 0c-7 0-12.6 4.6-14.2 10.8l-3.5 13 53.4 0c10.5 0 20.3-6.6 23.2-17.6l3.2-12c4.9-19.1-9.3-36.8-28.3-36.8l-47.3 0c-17.9 0-33.8 12-38.6 29.6l-10.8 40c-5 17.7 8.3 36.7 28.3 36.7l66.7 0c6.8 0 12.3-4.5 14.2-10.7l5.7-21-73.3 0z"],
    "mendeley": [640, 512, [], "f7b3", "M624.6 325.2c-12.3-12.4-29.7-19.2-48.4-17.2-43.3-1-49.7-34.9-37.5-98.8 22.8-57.5-14.9-131.5-87.4-130.8-77.4 .7-81.7 82-130.9 82-48.1 0-54-81.3-130.9-82-72.9-.8-110.1 73.3-87.4 130.8 12.2 63.9 5.8 97.8-37.5 98.8-21.2-2.3-37 6.5-53 22.5-19.9 19.7-19.3 94.8 42.6 102.6 47.1 5.9 81.6-42.9 61.2-87.8-47.3-103.7 185.9-106.1 146.5-8.2-.1 .1-.2 .2-.3 .4-26.8 42.8 6.8 97.4 58.8 95.2 52.1 2.1 85.4-52.6 58.8-95.2-.1-.2-.2-.3-.3-.4-39.4-97.9 193.8-95.5 146.5 8.2-4.6 10-6.7 21.3-5.7 33 4.9 53.4 68.7 74.1 104.9 35.2 17.8-14.8 23.1-65.6 0-88.3zM320.7 306.1l-.6 0c-43.4 0-62.8-37.5-62.8-62.8 0-34.7 28.2-62.8 62.8-62.8l.6 0c34.7 0 62.8 28.1 62.8 62.8 0 25-19.2 62.8-62.8 62.8z"],
    "draft2digital": [512, 512, [], "f396", "M496 398.1l-144-82.2 0 64.7-91.3 0c30.8-35 81.8-95.9 111.8-149.3 35.2-62.6 16.1-123.4-12.8-153.3-4.4-4.6-62.2-62.9-166-41.2-59.1 12.4-89.4 43.4-104.3 67.3-13.1 20.9-17 39.8-18.2 47.7-5.5 33 19.4 67.1 56.7 67.1 31.7 0 57.3-25.7 57.3-57.4 0-27.1-19.7-52.1-48-56.8 1.8-7.3 17.7-21.1 26.3-24.7 41.1-17.3 78 5.2 83.3 33.5 8.3 44.3-37.1 90.4-69.7 127.6-76.6 87-142.8 155.7-161.1 174.8l336-.1 0 64.2 144-81.9zM385.9 371l47.1 27.2-47.1 27.2 0-54.4zM105.4 161.4a22.4 22.4 0 1 1 44.8 0 22.4 22.4 0 1 1 -44.8 0zM98.5 380.5c25.6-27.4 97.7-104.7 150.8-169.9 35.1-43.1 40.3-82.4 28.4-112.7-7.4-18.8-17.5-30.2-24.3-35.7 45.3 2.1 68 23.4 82.2 38.3 0 0 42.4 48.2 5.8 113.3-37 65.9-110.9 147.5-128.5 166.7l-114.4 0z"],
    "replyd": [448, 512, [], "f3e6", "M320 480l-192 0C57.6 480 0 422.4 0 352L0 160C0 89.6 57.6 32 128 32l192 0c70.4 0 128 57.6 128 128l0 192c0 70.4-57.6 128-128 128zM193.4 273.2c-6.1-2-11.6-3.1-16.4-3.1-7.2 0-13.5 1.9-18.9 5.6s-9.6 9-12.8 15.8l-1.1 0-4.2-18.3-28 0 0 138.9 36.1 0 0-89.7c1.5-5.4 4.4-9.8 8.7-13.2s9.8-5.1 16.2-5.1c4.6 0 9.8 1 15.6 3.1l4.8-34zM308.6 376.6c-3.2 2.4-7.7 4.8-13.7 7.1s-12.8 3.5-20.4 3.5c-12.2 0-21.1-3-26.5-8.9-5.5-5.9-8.5-14.7-9-26.4l83.3 0c.9-4.8 1.6-9.4 2.1-13.9 .5-4.4 .7-8.6 .7-12.5 0-10.7-1.6-19.7-4.7-26.9-3.2-7.2-7.3-13-12.5-17.2-5.2-4.3-11.1-7.3-17.8-9.2-6.7-1.8-13.5-2.8-20.6-2.8-21.1 0-37.5 6.1-49.2 18.3s-17.5 30.5-17.5 55c0 22.8 5.2 40.7 15.6 53.7 10.4 13.1 26.8 19.6 49.2 19.6 10.7 0 20.9-1.5 30.4-4.6s17.1-6.8 22.6-11.2l-12-23.6zm-21.8-70.3c3.8 5.4 5.3 13.1 4.6 23.1l-51.7 0c.9-9.4 3.7-17 8.2-22.6s11.5-8.5 21-8.5c8.2-.1 14.1 2.6 17.9 8zm79.9 2.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4-9.6-5.7-16.7-5.7c-6.7 0-12 1.9-16.1 5.7s-6.1 8.9-6.1 15.4 2 11.7 6.1 15.6zm0 100.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4-9.6-5.7-16.7-5.7c-6.7 0-12 1.9-16.1 5.7s-6.1 8.9-6.1 15.4c0 6.6 2 11.7 6.1 15.6z"],
    "empire": [512, 512, [], "f1d1", "M295.6 54.2c-10.8-2.2-22.1-3.3-33.5-3.6l0-18.2c78.1 2.2 146.1 44 184.6 106.6l-15.8 9.1c-6.1-9.7-12.7-18.8-20.2-27.1l-18 15.5c-26-29.6-61.4-50.7-101.9-58.4l4.8-23.9zM61.4 322.4l23-7.7c-6.4-18.3-10-38.2-10-58.7s3.3-40.4 9.7-58.7l-22.7-7.7c3.6-10.8 8.3-21.3 13.6-31l-15.8-9.1C42 181 32.1 217.5 32.1 256s10 75 27.1 106.6L75 353.5c-5.3-10-9.7-20.3-13.6-31.1zM221.1 434c-40.4-8-75.8-29.1-101.9-58.7l-18 15.8c-7.5-8.6-14.4-17.7-20.2-27.4l-16 9.4c38.5 62.3 106.8 104.3 184.9 106.6l0-18.3c-11.3-.3-22.7-1.7-33.5-3.6l4.7-23.8zM101.3 120.9l18 15.5c26-29.6 61.4-50.7 101.9-58.4l-4.7-23.8c10.8-2.2 22.1-3.3 33.5-3.6l0-18.2C171.9 34.6 103.9 76.4 65.4 139l15.8 9.1c6-9.7 12.6-18.9 20.1-27.2zM410.7 391.1l-18-15.8c-26 29.6-61.4 50.7-101.9 58.7l4.7 23.8c-10.8 1.9-22.1 3.3-33.5 3.6l0 18.3c78.1-2.2 146.4-44.3 184.9-106.6l-16.1-9.4c-5.7 9.7-12.6 18.8-20.1 27.4zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm483.8 0a235.8 235.8 0 1 0 -471.6 0 235.8 235.8 0 1 0 471.6 0zm-39-106.6L437 158.5c5.3 9.7 10 20.2 13.6 31l-22.7 7.7c6.4 18.3 9.7 38.2 9.7 58.7s-3.6 40.4-10 58.7l23 7.7c-3.9 10.8-8.3 21-13.6 31l15.8 9.1C470 331 479.9 294.5 479.9 256s-9.9-75-27.1-106.6zm-183 177.7c16.3-3.3 30.4-11.6 40.7-23.5l51.2 44.8c11.9-13.6 21.3-29.3 27.1-46.8l-64.2-22.1c2.5-7.5 3.9-15.2 3.9-23.5s-1.4-16.1-3.9-23.5l64.5-22.1c-6.1-17.4-15.5-33.2-27.4-46.8l-51.2 44.8c-10.2-11.9-24.4-20.5-40.7-23.8l13.3-66.4c-8.6-1.9-17.7-2.8-27.1-2.8s-18.5 .8-27.1 2.8l13.3 66.4c-16.3 3.3-30.4 11.9-40.7 23.8l-51.2-44.8c-11.9 13.6-21.3 29.3-27.4 46.8l64.5 22.1c-2.5 7.5-3.9 15.2-3.9 23.5s1.4 16.1 3.9 23.5l-64.2 22.1c5.8 17.4 15.2 33.2 27.1 46.8l51.2-44.8c10.2 11.9 24.4 20.2 40.7 23.5l-13.3 66.7c8.6 1.7 17.7 2.8 27.1 2.8s18.5-1.1 27.1-2.8l-13.3-66.7z"],
    "accessible-icon": [448, 512, [62107], "f368", "M423.9 255.8L411 413.1c-3.3 40.7-63.9 35.1-60.6-4.9l10-122.5-41.1 2.3c10.1 20.7 15.8 43.9 15.8 68.5 0 41.2-16.1 78.7-42.3 106.5l-39.3-39.3c57.9-63.7 13.1-167.2-74-167.2-25.9 0-49.5 9.9-67.2 26L73 243.2c22-20.7 50.1-35.1 81.4-40.2l75.3-85.7-42.6-24.8-51.6 46C105.5 165.3 64.9 120 95 93.1l68-60.7c9.8-8.8 24.1-10.2 35.5-3.6 0 0 139.3 80.9 139.5 81.1 16.2 10.1 20.7 36 6.1 52.6l-58.4 66.5 106.1-5.9c18.5-1.1 33.6 14.4 32.1 32.7zM359 101.8A50.9 50.9 0 1 0 359 0 50.9 50.9 0 1 0 359 101.8zM179.6 456.5c-80.6 0-127.4-90.6-82.7-156.1L57.2 260.7C36.4 287 24 320.3 24 356.4 24 487.1 174.7 557.8 275.4 478.9l-39.7-39.7c-16 10.9-35.3 17.3-56.1 17.3z"],
    "quora": [448, 512, [], "f2c4", "M440.7 386.7l-29.3 0c-1.5 13.5-10.5 30.8-33 30.8-20.5 0-35.3-14.2-49.5-35.8 44.2-34.2 74.7-87.5 74.7-153 .1-117.5-96.6-196.7-198.4-196.7-99.7 0-197.7 79.7-197.7 196.7 0 134.1 131.3 221.6 249 189 19.7 33.6 45.7 62.3 95.2 62.3 81.8 0 90.8-75.3 89-93.3zM297.2 329.2c-19.5-29.2-43.7-52.2-91.5-52.2-30.5 0-54.3 10-69 22.8l12.2 24.3c6.2-3 13-4 19.8-4 35.5 0 53.7 30.8 69.2 61.3-10 3-20.7 4.2-32.7 4.2-75 0-107.5-53-107.5-156.7 0-104.4 32.5-157.9 107.5-157.9 76.2 0 108.7 53.5 108.7 157.7 .1 41.8-5.4 75.6-16.7 100.5z"],
    "cc-jcb": [576, 512, [], "f24b", "M431.5 244.3l0-32.3c41.2 0 38.5 .2 38.5 .2 7.3 1.3 13.3 7.3 13.3 16 0 8.8-6 14.5-13.3 15.8-1.2 .4-3.3 .3-38.5 .3zm42.8 20.2c-2.8-.7-3.3-.5-42.8-.5l0 35c39.6 0 40 .2 42.8-.5 7.5-1.5 13.5-8 13.5-17 0-8.7-6-15.5-13.5-17zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM182 192.3l-57 0c0 67.1 10.7 109.7-35.8 109.7-19.5 0-38.8-5.7-57.2-14.8l0 28c30 8.3 68 8.3 68 8.3 97.9 0 82-47.7 82-131.2zm178.5 4.5c-63.4-16-165-14.9-165 59.3 0 77.1 108.2 73.6 165 59.2l0-28.3C312.9 311.7 253 309 253 256s59.8-55.6 107.5-31.2l0-28zM544 286.5c0-18.5-16.5-30.5-38-32l0-.8c19.5-2.7 30.3-15.5 30.3-30.2 0-19-15.7-30-37-31 0 0 6.3-.3-120.3-.3l0 127.5 122.7 0c24.3 .1 42.3-12.9 42.3-33.2z"],
    "fedora": [448, 512, [], "f798", "M0 255.8C.1 132.2 100.3 32 224 32S448 132.3 448 256 347.8 479.9 224.1 480L50.9 480C22.8 480 .1 457.3 0 429.2l0 0 0-173.4 0 0zm342.6-63.1c0-39.7-35.6-68.5-73.2-68.5-34.9 0-65.8 26.3-70.1 59.9-.2 3.8-.4 5-.4 8.5-.1 21.1 0 42.8-.8 64.4 .9 26.1 1 52.1 0 76.6 0 27.1-19.4 45.5-44.7 45.5s-45.8-20.2-45.8-45.5c.5-27.7 22.6-45.3 48.5-46.1l.2 0 26.3-.2 0-37.3-26.3 .2c-47.1-.4-84.6 36.5-85.9 83.4 0 45.6 37.5 82.9 83 82.9 43 0 78.7-33.6 82.6-75.6l.2-53.5 32.6-.3c25.3 .2 25-37.8-.2-37.3l-32.4 .3c0-6.4 .1-12.8 .1-19.2 .1-12.7 .1-25.4-.1-38.2 .1-16.5 15.8-31.2 33.2-31.2 17.5 0 35.9 8.7 35.9 31.2 0 3.2-.1 5.1-.3 6.3-1.9 10.5 5.2 20.4 15.7 21.9 10.6 1.5 20.2-6.1 21.2-16.6 .6-4.2 .7-7.9 .7-11.6z"],
    "duolingo": [576, 512, [], "e812", "M504.3 230.5c10.4 88.5-43.4 172.1-128.2 199s-176.6-10.3-218.9-88.7c-72 3-137.4-39.8-163.2-105.5-2.6-6.6-1.9-14 1.9-19.9s10.2-9.7 17.2-10.1l96.1-6-23.8-75.9c-6.3-20-2.2-41.9 11-58.3s33.7-25 54.5-23c52.2 5 86.8 4.8 104-.6S300 16.7 339-16.9c15.9-13.7 37.7-18.5 57.8-12.7s36.1 21.3 42.4 41.4L462.8 87 543.6 37.3c6-3.7 13.4-4.3 19.9-1.6s11.3 8.3 12.9 15.2c16.2 68.2-12.4 140.3-72.1 179.5zM258.5 475.9l0 0c15.1 7.5 21.5 25.8 14.2 41s-25.4 21.9-40.7 14.9l-43.9-21c-15.1-7.5-21.5-25.8-14.2-41s25.4-21.9 40.7-14.9l43.8 21zM564.6 345.7c14.8 8.4 20 27.3 11.6 42.2l-23.9 42.4c-8.7 14.3-27.1 19.2-41.6 10.9s-19.9-26.6-12-41.4l23.9-42.4c4-7.1 10.7-12.4 18.6-14.6s16.3-1.2 23.4 2.9z"],
    "firstdraft": [384, 512, [], "f3a1", "M384 192l-64 0 0 128-128 0 0 128-192 0 0-25.6 166.4 0 0-128 128 0 0-128 89.6 0 0 25.6zm-25.6 38.4l0 128-128 0 0 128-166.4 0 0 25.6 192 0 0-128 128 0 0-153.6-25.6 0zm25.6 192l-89.6 0 0 89.6 25.6 0 0-64 64 0 0-25.6zM0 0l0 384 128 0 0-128 128 0 0-128 128 0 0-128-384 0z"],
    "freebsd": [448, 512, [], "f3a4", "M303.7 96.2c11.1-11.1 115.5-77 139.2-53.2 23.7 23.7-42.1 128.1-53.2 139.2s-39.4 .9-63.1-22.9c-23.8-23.7-34.1-52-22.9-63.1zM109.9 68.1C73.6 47.5 22 24.6 5.6 41.1-11 57.7 12.7 110.5 33.5 146.8 52 114.6 78.3 87.5 109.9 68.1zM406.7 174c3.3 11.3 2.7 20.7-2.7 26.1-20.3 20.3-87.5-27-109.3-70.1-18-32.3-11.1-53.4 14.9-48.7 5.7-3.6 12.3-7.6 19.6-11.6-29.8-15.5-63.6-24.3-99.5-24.3-119.1 0-215.6 96.5-215.6 215.6 0 119 96.5 215.6 215.6 215.6S445.3 380.1 445.3 261c0-38.4-10.1-74.5-27.7-105.8-3.9 7-7.6 13.3-10.9 18.8z"],
    "odysee": [512, 512, [], "e5c6", "M406.7 463c-42.3 30.8-94.4 49-150.7 49-111.1 0-205.7-70.8-241.1-169.8 2.4 1.7 5.9 3.6 7.9 4.4 16.3 7.4 40.1-5.4 62.9-28.7 6.9-6.9 14.4-12.4 22.8-17.3 18.3-11.9 37.6-20.8 58.4-27.2 0 0 22.3 34.2 43.1 74.8s-22.3 54-27.2 54c-.3 0-.8 0-1.5-.1-11-.5-70-3-56 51.1 14.9 57.4 97.5 36.6 139.6 8.9s31.7-118.3 31.7-118.3c41.1-6.4 54 37.1 57.9 59.4 .8 4.6 1.1 9.9 1.4 15.5 1.1 21.2 2.3 45.6 35.3 46.4 5.3 0 10.6-.8 15.5-2l0-.1zm-95.3-23.7c-2-.5-3.5-2.5-3-5 1-2.5 3-3.5 5-3s3.5 3 3 5-2.5 3.5-5 3zm-207-95.6c1.5-.5 3.5 1 4 3 0 2-1 4-3 4-1.5 .5-3.5-1-4-3-.5-1.5 1-3.5 3-4zM451.8 421c37.5-44.6 60.2-102.2 60.2-165 0-67.5-26.1-128.9-68.8-174.7-.1 23.5-6.1 48.2-16.8 69.2-11.9 20.3-49 58.9-69.8 78.7-.7 .3-1.1 .9-1.5 1.4-.2 .2-.3 .4-.5 .6-5 6.9-4 16.8 3 21.8 21.3 15.8 56.4 45.6 59.4 72.8 3.5 34.9 27.9 75.6 34.2 86.2 .8 1.3 1.3 2.1 1.4 2.4 0 2.2-.4 4.3-.8 6.5l0 .1zM390.7 251c-.5 3 1 5.9 4 6.4s5.9-1 6.4-4-1-5.9-4-6.4c-3-1-5.9 1-6.4 4zm61.4-60.9l-11.4 5.4-3 12.9-5.4-11.4-12.9-3 11.4-5.4 3-12.9 5.4 11.4 12.9 3zM395.5 41.3c-16.2 8.2-22.1 32.8-29 61.4-.3 1.4-.7 2.8-1 4.2-9.5 38.5-30.6 37.6-41.7 37.2-1.1 0-2-.1-2.9-.1-5.1 0-6-4-8.9-17.1-2.6-12.1-6.9-32-17.9-63.6-22.7-65.8-82.7-49.4-128.2-22.2-55.3 33.1-34.4 101.9-19.8 149.4 .7 2.2 1.4 4.4 2 6.6-4 4-13.8 7.5-26 11.9-12.1 4.3-26.6 9.5-40.3 16.9-33.9 18-70.3 49-79.8 62.6-1.3-10.7-2-21.5-2-32.5 0-141.4 114.6-256 256-256 51.4 0 99.4 15.2 139.5 41.3zM58.9 189.6c-1.5-2-4.5-3-6.4-1.5s-3 4.5-1.5 6.4 4.5 3 6.4 1.5c2.5-1.5 3-4.5 1.5-6.4zM327.3 64.9c2-1.5 5-.5 6.4 1.5 1.5 2.5 1 5.4-1.5 6.4-2 1.5-5 .5-6.4-1.5s-.5-5 1.5-6.4zM95.1 105c-.5 1.5 .5 3 2 3 1.5 .5 3-.5 3-2 .5-1.5-.5-3-2-3s-3 .5-3 2zm84.7-.5c-3.5-43.1 37.1-54 37.1-54 44.1-15.4 56 5.9 66.4 37.6s3 42.6-38.6 58.9-61.9-4.5-64.9-42.6l0 .1zm89.6 14.9l1 0c2.5 0 5-2 5-5 2-6.9 1-14.4-2-20.8-1.5-2-4-3.5-6.4-2.5-3 1-4.5 4-3.5 6.9 2 4.5 3 9.9 1.5 14.9-.5 3 1.5 5.9 4.5 6.4l-.1 .1zm-9.9-41.6c-2 0-4-1-5-3s-2-3.5-3-5c-2-2-2-5.4 0-7.4s5.4-2 7.4 0c2 2.5 3.5 5 5 7.4s.5 5.9-2.5 7.4c-.6 0-1 .2-1.3 .3-.2 .1-.4 .2-.6 .2l0 .1z"],
    "gg-circle": [512, 512, [], "f261", "M257.5 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM208 382.8l-125.7-125.7 125.7-125.7 35.2 35.4-24.2 24.2-11.1-11.1-77.2 77.2 77.2 77.2 26.6-26.6-53.1-52.9 24.4-24.4 77.2 77.2-75 75.2zm99-2.2l-35.2-35.2 24.1-24.4 11.1 11.1 77.2-77.2-77.2-77.2-26.5 26.5 53.1 52.9-24.4 24.4-77.2-77.2 75-75 125.7 125.7-125.7 125.6z"],
    "cloudflare": [640, 512, [], "e07d", "M407.9 319.9L177.1 317c-.7 0-1.4-.2-2-.5s-1.2-.8-1.6-1.4c-.4-.6-.7-1.3-.7-2s0-1.4 .2-2.1c.4-1.1 1.1-2.1 2.1-2.8s2.1-1.2 3.3-1.2l232.9-2.9c27.6-1.3 57.5-23.6 68-50.8l13.3-34.5c.4-.9 .5-1.9 .5-2.9 0-.5-.1-1.1-.2-1.6-7.4-32.2-25-61.1-50.3-82.3s-56.7-33.7-89.7-35.5-65.6 7.3-93 25.7-48 45.3-58.8 76.5c-11.3-8.5-24.9-13.3-39-13.7s-28 3.5-39.8 11.4-20.8 19.1-25.9 32.3-5.9 27.6-2.4 41.3c-52.3 1.5-94.2 44.1-94.2 96.5 0 4.7 .3 9.3 1 14 .2 1.1 .7 2.1 1.5 2.8s1.9 1.1 2.9 1.1l426.1 .1c0 0 .1 0 .1 0 1.2 0 2.3-.4 3.3-1.1s1.6-1.7 2-2.9l3.3-11.3c3.9-13.4 2.4-25.8-4.1-34.9-6-8.4-16.1-13.3-28.2-13.9zm105.9-98.8c-2.1 0-4.3 .1-6.4 .2-.8 .1-1.5 .3-2.1 .8s-1 1.1-1.3 1.8l-9.1 31.2c-3.9 13.4-2.4 25.8 4.1 34.9 6 8.4 16.1 13.3 28.2 13.9l49.2 2.9c.7 0 1.4 .2 2 .5s1.1 .8 1.5 1.4c.4 .6 .7 1.3 .8 2s0 1.5-.2 2.1c-.4 1.1-1.1 2.1-2.1 2.8s-2.1 1.2-3.3 1.2l-51.1 2.9c-27.8 1.3-57.7 23.6-68.1 50.8l-3.7 9.6c-.2 .4-.2 .8-.2 1.3s.2 .8 .4 1.2 .6 .7 .9 .9 .8 .3 1.2 .3c0 0 .1 0 .1 0l175.9 0c1 0 2-.3 2.8-.9s1.4-1.5 1.7-2.4c3.1-11.1 4.7-22.5 4.7-34 0-69.3-56.5-125.5-126.1-125.5z"],
    "hackerrank": [512, 512, [], "f5f7", "M477.9 128C463.4 103 285.5 0 256.5 0s-206.9 102.8-221.3 128-14.5 230.8 0 256 192.4 128 221.3 128 206.8-102.9 221.3-128 14.5-231 0-256zM316.5 414.2c-4 0-40.9-35.8-38-38.7 .9-.9 6.3-1.5 17.5-1.8 0-26.2 .6-68.6 .9-86.3 0-2-.4-3.4-.4-5.8l-79.9 0c0 7.1-.5 36.2 1.4 72.9 .2 4.5-1.6 6-5.7 5.9-10.1 0-20.3-.1-30.4-.1-4.1 0-5.9-1.5-5.7-6.1 .9-33.4 3-84-.2-212.7l0-3.2c-9.7-.4-16.4-1-17.3-1.8-2.9-2.9 34.5-38.7 38.5-38.7s41.2 35.8 38.3 38.7c-.9 .9-7.9 1.5-16.8 1.8l0 3.2c-2.4 25.8-2 79.6-2.6 105.4l80.3 0c0-4.6 .4-34.7-1.2-83.6-.1-3.4 1-5.2 4.2-5.2 11.1-.1 22.2-.1 33.2-.1 3.5 0 4.6 1.7 4.5 5.4-3.7 191.3-.7 177.9-.7 210.3 8.9 .4 16.8 1 17.7 1.8 2.9 2.9-33.6 38.7-37.6 38.7l0 0z"],
    "skyatlas": [640, 512, [], "f216", "M640 329.3c0 65.9-52.5 114.4-117.5 114.4-165.9 0-196.6-249.7-359.7-249.7-146.9 0-147.1 212.2 5.6 212.2 42.5 0 90.9-17.8 125.3-42.5 5.6-4.1 16.9-16.3 22.8-16.3s10.9 5 10.9 10.9c0 7.8-13.1 19.1-18.7 24.1-40.9 35.6-100.3 61.2-154.7 61.2-83.4 .1-154-59-154-144.9S67.5 149.6 152.8 149.6c185.3 0 222.5 245.9 361.9 245.9 99.9 0 94.8-139.7 3.4-139.7-17.5 0-35 11.6-46.9 11.6-8.4 0-15.9-7.2-15.9-15.6 0-11.6 5.3-23.7 5.3-36.3 0-66.6-50.9-114.7-116.9-114.7-53.1 0-80 36.9-88.8 36.9-6.2 0-11.2-5-11.2-11.2 0-5.6 4.1-10.3 7.8-14.4 25.3-28.8 64.7-43.7 102.8-43.7 79.4 0 139.1 58.4 139.1 137.8 0 6.9-.3 13.7-1.2 20.6 11.9-3.1 24.1-4.7 35.9-4.7 60.7 0 111.9 45.3 111.9 107.2z"],
    "deskpro": [512, 512, [], "f38f", "M222 512l31.1-38.4c12.3-.2 25.6-1.4 36.5-6.6 38.9-18.6 38.4-61.9 38.3-63.8-.1-5-.8-4.4-28.9-37.4l79.1 0c-.2 50.1-7.3 68.5-10.2 75.7-9.4 23.7-43.9 62.8-95.2 69.4-8.7 1.1-32.8 1.2-50.7 1.1zM422.4 344.3c38.6 0 58.5-13.6 73.7-30.9l-175.5-.3-17.4 31.3 119.2-.1zM378.8 120.4l0 168.3-73.5 0-32.7 55.5-6.5 0c-52.3 0-58.1-56.5-58.3-58.9-1.2-13.2-21.3-11.6-20.1 1.8 1.4 15.8 8.8 40 26.4 57.1l-91 0c-25.5 0-110.8-26.8-107-114l0-213.3c0-16 9.7-16.6 15-16.8l82 0c.2 0 .3 .1 .5 .1 4.3-.4 50.1-2.1 50.1 43.7 0 13.3 20.2 13.4 20.2 0 0-18.2-5.5-32.8-15.8-43.7l84.2 0C361-.2 378.8 79.6 378.8 120.4zm-132.5 56l64 29.3c13.3-45.5-42.2-71.7-64-29.3z"],
    "resolving": [512, 512, [], "f3e7", "M289.2 278.2c46-13.3 49.6-23.5 44-43.4L322 195.5c-6.1-20.9-18.4-28.1-71.1-12.8l-188.2 54.1 28.6 98.6 197.9-57.2zM256.5 8C139.4 8 41.2 88.7 15.2 197.5l221.9-63.9c34.8-10.2 54.2-11.7 79.3-8.2 36.3 6.1 52.7 25 61.4 55.2l10.7 37.8c8.2 28.1 1 50.6-23.5 73.6-19.4 17.4-31.2 24.5-61.4 33.2l-92.6 26.6 220.4 27.1 9.7 34.2-48.1 13.3-286.8-37.3 23 80.2C166 491.3 209.5 504 255.5 504 392.5 504 504 392.6 504 255.7 505 119.4 393.5 8 256.5 8zM46.3 388.6L8 256.8c0 48.5 14.3 93.4 38.3 131.8z"],
    "blackberry": [512, 512, [], "f37b", "M166 116.9c0 23.4-16.4 49.1-72.5 49.1l-70.1 0 21-88.8 67.8 0c42.1 0 53.8 23.3 53.8 39.7zM292.2 77.2l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-25.7 70.1-49.1 .1-16.4-11.6-39.7-53.7-39.7zM88.8 208.1l-67.8 0-21 88.8 70.1 0c56.1 0 72.5-23.4 72.5-49.1 0-16.3-11.7-39.7-53.8-39.7zm180.1 0l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-23.4 70.1-49.1 0-16.3-11.7-39.7-53.7-39.7zm189.3-53.8l-67.8 0-18.7 88.8 70.1 0c53.8 0 70.1-23.4 70.1-49.1 .1-16.3-11.6-39.7-53.7-39.7zm-28 137.9l-67.8 0-18.7 88.8 70.1 0c56.1 0 70.1-23.4 70.1-49.1 0-16.3-11.6-39.7-53.7-39.7zM240.8 346l-67.8 0-18.7 88.8 70.1 0c56.1 0 70.1-25.7 70.1-49.1 .1-16.3-11.6-39.7-53.7-39.7z"],
    "stripe-s": [384, 512, [], "f42a", "M155.6 154.6c0-22.3 18.6-30.9 48.4-30.9 43.4 0 98.5 13.3 141.9 36.7l0-134.3c-47.3-18.9-94.5-26.1-141.8-26.1-115.7 0-192.8 60.4-192.8 161.4 0 157.9 216.8 132.3 216.8 200.4 0 26.4-22.9 34.9-54.7 34.9-47.2 0-108.2-19.5-156.1-45.5l0 128.5c49.3 21.3 102.3 32.3 156 32.4 118.6 0 200.3-51 200.3-153.6 0-170.2-218-139.7-218-203.9z"],
    "square-behance": [448, 512, ["behance-square"], "f1b5", "M155.3 318.4c17.2 0 31.2-6.1 31.2-25.4 0-19.7-11.7-27.4-30.3-27.5l-46 0 0 52.9 45.1 0zm-5.4-129.6l-39.6 0 0 44.8 42.7 0c15.1 0 25.8-6.6 25.8-22.9 0-17.7-13.7-21.9-28.9-21.9zm129.5 74.8l62.2 0c-1.7-18.5-11.3-29.7-30.5-29.7-18.3 0-30.5 11.4-31.7 29.7zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM349.5 185l-77.8 0 0-18.9 77.8 0 0 18.9zM193.7 243.7c23.6 6.7 35 27.5 35 51.6 0 39-32.7 55.7-67.6 55.9l-93.1 0 0-192 90.5 0c32.9 0 61.4 9.3 61.4 47.5 0 19.3-9 28.8-26.2 37zm118.7-38.6c43.5 0 67.6 34.3 67.6 75.4 0 1.6-.1 3.3-.2 5 0 .8-.1 1.5-.1 2.2l-100.2 0c0 22.2 11.7 35.3 34.1 35.3 11.6 0 26.5-6.2 30.2-18.1l33.7 0c-10.4 31.9-31.9 46.8-65.1 46.8-43.8 0-71.1-29.7-71.1-73 0-41.8 28.7-73.6 71.1-73.6z"],
    "servicestack": [512, 512, [], "f3ec", "M96 216c81.7 10.2 273.7 102.3 304 232L8 448c99.5-8.1 184.5-137 88-232zM128 64c32.3 35.6 47.7 83.9 46.4 133.6 82.9 33.7 207.3 123.7 233.6 250.4l96 0C463.3 231.9 230.8 79.5 128 64z"],
    "rocketchat": [576, 512, [], "f3e8", "M284.5 224.8c-6.7 0-13.3 2.1-18.9 5.8s-9.9 9.1-12.5 15.4-3.2 13.1-1.9 19.7 4.6 12.7 9.4 17.4 10.9 8 17.5 9.3 13.5 .6 19.7-2 11.5-7 15.3-12.6 5.7-12.2 5.7-18.9c0-9.1-3.7-17.8-10.1-24.2s-15.1-10-24.2-9.9zm-110.4 0c-6.7 0-13.3 2.1-18.9 5.8s-9.9 9.1-12.5 15.4-3.2 13.1-1.9 19.7 4.6 12.7 9.4 17.4 10.9 8 17.5 9.3 13.5 .6 19.7-2 11.5-7 15.3-12.6 5.7-12.2 5.7-18.9c0-9.1-3.7-17.8-10.1-24.2s-15.1-10-24.2-10l0 0zm220.9 0a34.1 34.1 0 1 0 .4 68.2 34.1 34.1 0 1 0 -.4-68.2zm153.8-55.3c-15.5-24.2-37.3-45.6-64.7-63.6-52.9-34.8-122.4-54-195.7-54-24.2 0-48.3 2.1-72 6.4-14.9-14.3-31.5-26.6-49.5-36.6-66.8-33.3-125.6-20.9-155.3-10.2-2.3 .8-4.3 2.1-5.9 3.9s-2.7 3.9-3.3 6.2-.5 4.7 .1 7.1 1.8 4.4 3.5 6.1C27 56.5 61.6 99.3 53.1 138.3 20 172.2 2 213 2 255.6 2 299 20 339.8 53.1 373.7 61.6 412.7 27 455.6 6 477.2 4.3 479 3.2 481.1 2.5 483.4s-.7 4.7-.1 7 1.7 4.5 3.3 6.2 3.6 3.1 5.9 3.9c29.7 10.7 88.5 23.1 155.3-10.2 18-10 34.7-22.3 49.5-36.6 23.8 4.3 47.9 6.4 72 6.4 73.3 0 142.8-19.2 195.7-54 27.4-18 49.1-39.4 64.7-63.6 17.3-26.9 26.1-55.9 26.1-86.1 0-31-8.8-60-26.1-86.9l0 0zM285.4 409.9c-30.2 .1-60.3-3.8-89.4-11.5l-20.1 19.4c-11.2 10.7-23.6 20-37.1 27.6-16.4 8.2-34.2 13.3-52.5 14.9 1-1.8 1.9-3.6 2.8-5.4 20.2-37.1 25.6-70.5 16.3-100.1-33-26-52.8-59.2-52.8-95.4 0-83.1 104.3-150.5 232.8-150.5s232.9 67.4 232.9 150.5c0 83.1-104.3 150.5-232.9 150.5z"],
    "rebel": [512, 512, [], "f1d0", "M256.9 504c-139.3 0-247.5-116.2-243.3-254.1 2.8-79.2 43.2-152.2 116.5-200.4 .3 0 1.9-.6 1.1 .8-5.8 5.5-111.3 129.8-14.1 226.4 49.8 49.5 90 2.5 90 2.5 38.5-50.1-.6-125.9-.6-125.9-10-24.9-45.7-40.1-45.7-40.1l28.8-31.8c24.4 10.5 43.2 38.7 43.2 38.7 .8-29.6-21.9-61.4-21.9-61.4L255.5 8 299.8 58.1c-20.5 28.8-21.9 62.6-21.9 62.6 13.8-23 43.5-39.3 43.5-39.3l28.5 31.8c-27.4 8.9-45.4 39.9-45.4 39.9-15.8 28.5-27.1 89.4 .6 127.3 32.4 44.6 87.7-2.8 87.7-2.8 102.7-91.9-10.5-225-10.5-225-6.1-5.5 .8-2.8 .8-2.8 50.1 36.5 114.6 84.4 116.2 204.8 2 145.6-99.9 249.4-242.4 249.4z"],
    "square-web-awesome": [448, 512, [], "e683", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM235 177.6l53 46.4 52.2-10.4c-2.6-3.9-4.2-8.5-4.2-13.6 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13-10.3 23.6-23.2 24L304.5 349.1c-5.2 11.5-16.6 18.9-29.2 18.9l-102.6 0c-12.6 0-24-7.4-29.2-18.9L87.2 224c-12.9-.4-23.2-11-23.2-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 5-1.5 9.7-4.2 13.6L160 224 213.1 177.6c-8.9-4.1-15-13.1-15-23.6 0-14.4 11.6-26 26-26s26 11.6 26 26c0 10.5-6.2 19.5-15.1 23.6z"],
    "linktree": [448, 512, [], "e7d8", "M32 173.4l125.8 0-89.4-85.4 49.5-51 85.2 87.8 0-124.8 73.9 0 0 124.8 85.2-87.6 49.4 50.8-89.4 85.2 125.7 0 0 70.5-126.4 0 90 87.6-49.3 49.8-122.2-123-122.2 123-49.5-49.6 90-87.6-126.4 0 0-70.5zM202.9 344.8l73.9 0 0 167.2-73.9 0 0-167.2z"],
    "simplybuilt": [512, 512, [], "f215", "M481.6 64l-106 0C361.1 64 349 75.8 349 90.3l0 39.6-185.3 0 0-39.6c0-14.5-12-26.3-26.6-26.3l-106 0C16.5 64 4.7 75.8 4.7 90.3l0 331.4c0 14.5 11.8 26.3 26.6 26.3l450.4 0c14.8 0 26.6-11.8 26.6-26.3l0-331.4c-.2-14.5-12-26.3-26.7-26.3zM150.5 222.7a66.5 66.5 0 1 1 -.3 133.1 66.5 66.5 0 1 1 .3-133.1zm211.9 .1a66.5 66.5 0 1 1 .3 132.9 66.5 66.5 0 1 1 -.3-132.9z"],
    "stubber": [448, 512, [], "e5c7", "M136.5 294.2l58.8 22.9c9.1-36.8 25.4-61.1 55-61.1 49.4 0 71.4 63.6 142.4 63.6 15.6 0 35.9-2.8 55.3-13.3l0 61.7c0 61.8-50.4 112-112.3 112L0 480 41.8 424 0 368 41.7 312 0 256.1 41.8 200.1 0 144.1 41.8 88 0 32 335.7 32C397.6 32 448 82.3 448 144.1l0 51.3c-9.2 36.3-25.9 60.6-55 60.6-49.6 0-71.6-63.5-142.4-63.5-35.9 0-95.2 14.6-114.1 101.6l0 .1z"],
    "apper": [640, 512, [], "f371", "M42.1 239.1c22.2 0 29 2.8 33.5 14.6l.8 0 0-22.9c0-11.3-4.8-15.4-17.9-15.4-11.3 0-14.4 2.5-15.1 12.8l-38.6 0c.3-13.9 1.5-19.1 5.8-24.4 7.3-8.8 18.9-11.8 46.1-11.8 33 0 47.1 5 53.9 18.9 2 4.3 4 15.6 4 23.7l0 76.3-38.3 0 1.3-19.1-1 0c-5.3 15.6-13.6 20.4-35.5 20.4-30.3 0-41.1-10.1-41.1-37.3 0-25.2 12.3-35.8 42.1-35.8zm17.1 48.1c13.1 0 16.9-3 16.9-13.4 0-9.1-4.3-11.6-19.6-11.6-13.1 0-17.9 3-17.9 12.1-.1 10.4 3.7 12.9 20.6 12.9zM137 192.3l38.3 0-1.5 20.6 .8 0c9.1-17.1 15.9-20.9 37.5-20.9 14.4 0 24.7 3 31.5 9.1 9.8 8.6 12.8 20.4 12.8 48.1 0 30-3 43.1-12.1 52.9-6.8 7.3-16.4 10.1-33.2 10.1-20.4 0-29.2-5.5-33.8-21.2l-.8 0 0 70.3-39.5 0 0-169zM217.9 253c0-27.5-3.3-32.5-20.7-32.5-16.9 0-20.7 5-20.7 28.7 0 28 3.5 33.5 21.2 33.5 16.4 0 20.2-5.6 20.2-29.7zm57.9-60.7l38.3 0-1.5 20.6 .8 0c9.1-17.1 15.9-20.9 37.5-20.9 14.4 0 24.7 3 31.5 9.1 9.8 8.6 12.8 20.4 12.8 48.1 0 30-3 43.1-12.1 52.9-6.8 7.3-16.4 10.1-33.3 10.1-20.4 0-29.2-5.5-33.8-21.2l-.8 0 0 70.3-39.5 0 0-169 .1 0zM356.7 253c0-27.5-3.3-32.5-20.7-32.5-16.9 0-20.7 5-20.7 28.7 0 28 3.5 33.5 21.2 33.5 16.4 0 20.2-5.6 20.2-29.7zm53.8-3.8c0-25.4 3.3-37.8 12.3-45.8 8.8-8.1 22.2-11.3 45.1-11.3 42.8 0 55.7 12.8 55.7 55.7l0 11.1-75.3 0c-.3 2-.3 4-.3 4.8 0 16.9 4.5 21.9 20.1 21.9 13.9 0 17.9-3 17.9-13.9l37.5 0 0 2.3c0 9.8-2.5 18.9-6.8 24.7-7.3 9.8-19.6 13.6-44.3 13.6-27.5 0-41.6-3.3-50.6-12.3-8.5-8.5-11.3-21.3-11.3-50.8zm76.4-11.6c-.3-1.8-.3-3.3-.3-3.8 0-12.3-3.3-14.6-19.6-14.6-14.4 0-17.1 3-18.1 15.1l-.3 3.3 38.3 0zm55.6-45.3l38.3 0-1.8 19.9 .7 0c6.8-14.9 14.4-20.2 29.7-20.2 10.8 0 19.1 3.3 23.4 9.3 5.3 7.3 6.8 14.4 6.8 34 0 1.5 0 5 .2 9.3l-35 0c.3-1.8 .3-3.3 .3-4 0-15.4-2-19.4-10.3-19.4-6.3 0-10.8 3.3-13.1 9.3-1 3-1 4.3-1 12.3l0 68-38.3 0 0-118.5 .1 0z"],
    "google-scholar": [512, 512, [], "e63b", "M390.9 298.5s0 .1 .1 .1c9.2 19.4 14.4 41.1 14.4 64-.1 82.5-66.9 149.4-149.4 149.4S106.7 445.1 106.7 362.7c0-22.9 5.2-44.6 14.4-64 1.7-3.6 3.6-7.2 5.6-10.7 4.4-7.6 9.4-14.7 15-21.3 27.4-32.6 68.5-53.3 114.4-53.3 33.6 0 64.6 11.1 89.6 29.9 9.1 6.9 17.4 14.7 24.8 23.5 5.6 6.6 10.6 13.8 15 21.3 2 3.4 3.8 7 5.5 10.5l-.1-.1zm26.4-18.8c-30.1-58.4-91-98.4-161.3-98.4s-131.2 40-161.3 98.4l-94.7-77 256-202.7 256 202.7-94.7 77.1 0-.1z"],
    "yarn": [512, 512, [], "f7e3", "M401.9 345.2c-39 9.3-48.4 32.1-104 47.4 0 0-2.7 4-10.4 5.8-13.4 3.3-63.9 6-68.5 6.1-12.4 .1-19.9-3.2-22-8.2-6.4-15.3 9.2-22 9.2-22-8.1-5-9-9.9-9.8-8.1-2.4 5.8-3.6 20.1-10.1 26.5-8.8 8.9-25.5 5.9-35.3 .8-10.8-5.7 .8-19.2 .8-19.2s-5.8 3.4-10.5-3.6c-6-9.3-17.1-37.3 11.5-62-1.3-10.1-4.6-53.7 40.6-85.6 0 0-20.6-22.8-12.9-43.3 5-13.4 7-13.3 8.6-13.9 5.7-2.2 11.3-4.6 15.4-9.1 20.6-22.2 46.8-18 46.8-18s12.4-37.8 23.9-30.4c3.5 2.3 16.3 30.6 16.3 30.6s13.6-7.9 15.1-5c8.2 16 9.2 46.5 5.6 65.1-6.1 30.6-21.4 47.1-27.6 57.5-1.4 2.4 16.5 10 27.8 41.3 10.4 28.6 1.1 52.7 2.8 55.3 .8 1.4 13.7 .8 36.4-13.2 12.8-7.9 28.1-16.9 45.4-17 16.7-.5 17.6 19.2 4.9 22.2zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm416.7 75.2c-1.7-13.6-13.2-23-28-22.8-22 .3-40.5 11.7-52.8 19.2-4.8 3-8.9 5.2-12.4 6.8 3.1-44.5-22.5-73.1-28.7-79.4 7.8-11.3 18.4-27.8 23.4-53.2 4.3-21.7 3-55.5-6.9-74.5-1.6-3.1-7.4-11.2-21-7.4-9.7-20-13-22.1-15.6-23.8-1.1-.7-23.6-16.4-41.4 28-12.2 .9-31.3 5.3-47.5 22.8-2 2.2-5.9 3.8-10.1 5.4l.1 0c-8.4 3-12.3 9.9-16.9 22.3-6.5 17.4 .2 34.6 6.8 45.7-17.8 15.9-37 39.8-35.7 82.5-34 36-11.8 73-5.6 79.6-1.6 11.1 3.7 19.4 12 23.8 12.6 6.7 30.3 9.6 43.9 2.8 4.9 5.2 13.8 10.1 30 10.1 6.8 0 58-2.9 72.6-6.5 6.8-1.6 11.5-4.5 14.6-7.1 9.8-3.1 36.8-12.3 62.2-28.7 18-11.7 24.2-14.2 37.6-17.4 12.9-3.2 21-15.1 19.4-28.2z"],
    "stack-overflow": [384, 512, [], "f16c", "M291 311l-195.7-41.3-8.2 39.3 195.7 41 8.2-39zm51-87L188.5 95.7 163 126.5 316.5 254.8 342 224zm-31.2 39.7L129.5 179 112.8 215.5 294 300 310.8 263.7zM262.3 32l-32 24 119.3 160.3 32-24-119.3-160.3zm20.5 328l-200 0 0 39.7 200 0 0-39.7zm39.7 80l-279.5 0 0-120-40 0 0 160 359.5 0 0-160-40 0 0 120z"],
    "bluetooth": [384, 512, [], "f293", "M260.6 171.1l-42.9 42.9-.3-86 43.2 43.1zM217.4 390.9l43.1-43.1-42.9-42.9-.2 86zM384 259.4C384 465 312.1 512 198.9 512S0 465 0 259.4 83.4 0 196.6 0 384 53.9 384 259.4zm-158.5 0l79.4-88.6-125.1-134.3 0 176.9-73.8-73.8-27 26.9 92.7 93-92.7 93 26.9 26.9 73.8-73.8 2.3 170 127.4-127.5-83.9-88.7z"],
    "creative-commons-nc-jp": [512, 512, [], "f4ea", "M255.7 8C111.6 8 8 124.8 8 256 8 392.4 119.8 504 255.7 504 385.9 504 504 403.2 504 256 504 117.2 396.5 8 255.7 8zm.6 450.7c-112 0-203.6-92.5-203.6-202.7 0-21.1 3-41.2 9-60.3l127 56.5-27.9 0 0 38.6 58.1 0 5.7 11.8 0 18.7-63.8 0 0 38.7 63.8 0 0 56 61.7 0 0-56 64.2 0 0-35.7 81 36.1c-1.5 2.2-57.1 98.3-175.2 98.3zm87.6-137.3l-57.6 0 0-18.7 2.9-5.6 54.7 24.3zm6.5-51.4l0-17.8-38.6 0 63-116-65.8 0-43.4 96-23-10.2-39.6-85.7-65.8 0 27.3 51-81.9-36.5c27.8-44.1 82.6-98.1 173.7-98.1 112.8 0 203 90 203 203.4 0 21-2.7 40.6-7.9 59L350.4 270z"],
    "reddit": [512, 512, [], "f1a1", "M0 256C0 114.6 114.6 0 256 0S512 114.6 512 256 397.4 512 256 512L37.1 512c-13.7 0-20.5-16.5-10.9-26.2L75 437C28.7 390.7 0 326.7 0 256zM349.6 153.6c23.6 0 42.7-19.1 42.7-42.7s-19.1-42.7-42.7-42.7c-20.6 0-37.8 14.6-41.8 34-34.5 3.7-61.4 33-61.4 68.4l0 .2c-37.5 1.6-71.8 12.3-99 29.1-10.1-7.8-22.8-12.5-36.5-12.5-33 0-59.8 26.8-59.8 59.8 0 24 14.1 44.6 34.4 54.1 2 69.4 77.6 125.2 170.6 125.2s168.7-55.9 170.6-125.3c20.2-9.6 34.1-30.2 34.1-54 0-33-26.8-59.8-59.8-59.8-13.7 0-26.3 4.6-36.4 12.4-27.4-17-62.1-27.7-100-29.1l0-.2c0-25.4 18.9-46.5 43.4-49.9 4.4 18.8 21.3 32.8 41.5 32.8l.1 .2zM177.1 246.9c16.7 0 29.5 17.6 28.5 39.3s-13.5 29.6-30.3 29.6-31.4-8.8-30.4-30.5 15.4-38.3 32.1-38.3l.1-.1zm190.1 38.3c1 21.7-13.7 30.5-30.4 30.5s-29.3-7.9-30.3-29.6 11.8-39.3 28.5-39.3 31.2 16.6 32.1 38.3l.1 .1zm-48.1 56.7c-10.3 24.6-34.6 41.9-63 41.9s-52.7-17.3-63-41.9c-1.2-2.9 .8-6.2 3.9-6.5 18.4-1.9 38.3-2.9 59.1-2.9s40.7 1 59.1 2.9c3.1 .3 5.1 3.6 3.9 6.5z"],
    "connectdevelop": [576, 512, [], "f20e", "M550.8 241l-50.1-86.8c1.1-2.1 1.9-4.6 1.9-7.2 0-8-6.7-14.7-14.7-15L432.4 36.1c.5-1.6 1.1-3.2 1.1-4.8 0-8.6-7-15.3-15.3-15.3-4.8 0-8.8 2.1-11.8 5.6l-106.6 0c-2.7-3.5-6.7-5.6-11.5-5.6s-8.8 2.1-11.5 5.6l-106.1 0c-2.9-3.5-7-5.6-11.8-5.6-8.3 0-15.3 6.7-15.3 15.3 0 1.6 .5 3.5 1.1 4.8l-56 97.2c-5.4 2.4-9.1 7.5-9.1 13.7 0 .5 .3 1.1 .3 1.6L26.6 240.7c-7.2 1.3-12.6 7.5-12.6 15 0 7.2 5.1 13.4 12.1 15l55.2 95.4c-.5 1.6-.8 2.9-.8 4.8 0 7.2 5.1 13.4 12.1 14.7l51.7 89.7c-.5 1.6-1.1 3.5-1.1 5.4 0 8.6 7 15.3 15.3 15.3 4.8 0 8.8-2.1 11.5-5.4l106.9 0c2.7 3.2 7 5.4 11.5 5.4s8.8-2.1 11.5-5.4l107.1 0c2.7 2.9 6.7 4.8 11 4.8 8.6 0 15.3-7 15.3-15.3 0-1.6-.3-2.9-.8-4.3l51.7-90.3c7-1.3 12.1-7.5 12.1-14.7 0-1.6-.3-3.2-.8-4.8l54.9-95.4c7-1.3 12.3-7.5 12.3-15 0-7.2-5.1-13.4-11.8-14.7zm-397 209.7l-43.7-75.8 43.7 0 0 75.8zm0-83.8l-43.7 0c-.3-1.1-.8-2.1-1.3-3.2l45-47.4 0 50.6zm0-62.4l-50.4 53.3c-1.3-.5-2.7-1.3-4-1.6L43.7 259.8c.5-1.3 .5-2.7 .5-4s0-2.4-.3-3.5l52-90c2.7-.3 5.4-1.1 7.8-2.7l50.1 52 0 92.9zm0-102.3L108 154.8c1.3-2.1 2.1-4.8 2.1-7.8 0-.3-.3-.8-.3-1.1l43.9-15.8 0 72.1zm0-80.6l-43.7 15.8 43.7-75.5 0 59.7zm326.5 39.1l.8 1.3-35.4 167.1-63.8-67.2 98-101.5 .3 .3zM292.1 355.1l11.5 11.8-22.8 0 11.3-11.8zm-.3-11.3l-83.3-85.4 79.6-84.4 83 87.6-79.3 82.2zm5.4 5.9l79.3-82.2 67.5 71.3-5.9 28.1-124 0-16.9-17.1zM410.7 44.4c1.1 .5 2.1 1.1 3.5 1.3l57.9 100.7 0 .5c0 2.9 .8 5.6 2.1 7.8l-97.5 101.2-83-87.6 117.1-124zm-9.1-2.1l-113.6 120.3-57.1-60.3 166.3-60 4.3 0zm-123.5 0c2.7 2.7 6.2 4.3 10.2 4.3s7.5-1.6 10.2-4.3l75 0-148.4 53.6-50.9-53.6 103.9 0zM161.9 47.9l1.1-2.1c.9-.2 1.8-.5 2.7-.8l51.2 53.8-54.9 19.8 0-70.7zm0 79.3l60.8-22 59.7 63.2-79.6 84.1-41-42.1 0-83.3zm0 92.7l36.4 37.8-36.4 38.3 0-76.1zm0 87.9l42.1-44.5 82.8 86-17.1 17.7-107.7 0 0-59.2zm7 162.1c-1.6-1.6-3.5-2.7-5.9-3.5l-1.1-1.6 0-89.7 99.9 0-91.6 94.8-1.3 0zm129.9 0c-2.7-2.4-6.4-4.3-10.4-4.3s-7.8 1.9-10.4 4.3l-96.4 0 91.6-94.8 38.3 0 91.6 94.8-104.2 0zm120-11.8l-4.3 7.5c-1.3 .3-2.4 .8-3.5 1.3l-89.2-91.9 114.4 0-17.4 83zm12.9-22.2l12.9-60.8 22 0-34.8 60.8zm34.8-68.8l-20.4 0 4.6-21.2 17.1 18.2c-.5 .8-1.1 1.9-1.3 2.9zm66.2-107.4l-55.4 96.7c-1.3 .5-2.7 1.1-4 1.9l-20.6-22 34.6-163.9 45.8 79.3c-.3 1.3-.8 2.7-.8 4.3 0 1.3 .3 2.4 .5 3.7z"],
    "researchgate": [448, 512, [], "f4f8", "M0 32l0 448 448 0 0-448-448 0zM262.2 366.4c-6.6 3-33.2 6-50-14.2-9.2-10.6-25.3-33.3-42.2-63.6-8.9 0-14.7 0-21.4-.6l0 46.4c0 23.5 6 21.2 25.8 23.9l0 8.1c-6.9-.3-23.1-.8-35.6-.8-13.1 0-26.1 .6-33.6 .8l0-8.1c15.5-2.9 22-1.3 22-23.9l0-109.4c0-22.6-6.4-21-22-23.9l0-8.1c25.8 1 53.1-.6 70.9-.6 31.7 0 55.9 14.4 55.9 45.6 0 21.1-16.7 42.2-39.2 47.5 13.6 24.2 30 45.6 42.2 58.9 7.2 7.8 17.2 14.7 27.2 14.7l0 7.3zm22.9-135c-23.3 0-32.2-15.7-32.2-32.2l0-32.2c0-12.2 8.8-30.4 34-30.4s30.4 17.9 30.4 17.9l-10.7 7.2s-5.5-12.5-19.7-12.5c-7.9 0-19.7 7.3-19.7 19.7l0 26.8c0 13.4 6.6 23.3 17.9 23.3 14.1 0 21.5-10.9 21.5-26.8l-17.9 0 0-10.7 30.4 0c0 20.5 4.7 49.9-34 49.9zM168.6 276.1c-9.4 0-13.6-.3-20-.8l0-69.7c6.4-.6 15-.6 22.5-.6 23.3 0 37.2 12.2 37.2 34.5 0 21.9-15 36.6-39.7 36.6z"],
    "signal-messenger": [512, 512, [], "e663", "M256 0c-13.3 0-26.3 1-39.1 3l3.7 23.7C232.1 24.9 244 24 256 24s23.9 .9 35.4 2.7L295.1 3C282.3 1 269.3 0 256 0zm60.8 7.3l-5.7 23.3c23.4 5.7 45.4 14.9 65.4 27.1l12.5-20.5c-22.1-13.4-46.4-23.6-72.2-29.9zm76.4 61.6c19.1 14 36 30.9 50.1 50.1l19.4-14.2C447 83.6 428.4 65 407.3 49.5L393.1 68.8zm81.7 54.2l-20.5 12.5c12.2 20 21.4 42 27.1 65.4l23.3-5.7c-6.3-25.8-16.5-50.1-29.9-72.2zm10.5 97.5c1.8 11.5 2.7 23.4 2.7 35.4s-.9 23.9-2.7 35.4l23.7 3.7c1.9-12.7 3-25.8 3-39.1s-1-26.3-3-39.1l-23.7 3.7zm-31 155.9l20.5 12.5c13.4-22.1 23.6-46.4 29.9-72.2l-23.3-5.7c-5.7 23.4-14.9 45.4-27.1 65.4zm8.2 30.8l-19.4-14.2c-14 19.1-30.9 36-50.1 50.1l14.2 19.4c21.1-15.5 39.8-34.1 55.2-55.2zm-86.1 47c-20 12.2-42 21.4-65.4 27.1l5.7 23.3c25.8-6.3 50.1-16.5 72.2-29.9l-12.5-20.5zM295.1 509l-3.7-23.7C279.9 487.1 268 488 256 488s-23.9-.9-35.4-2.7L216.9 509c12.7 1.9 25.8 3 39.1 3s26.3-1 39.1-3zm-94.1-27.6c-17.6-4.3-34.4-10.6-50.1-18.6l-7.8-4-32.8 7.7 5.5 23.4 24.3-5.7c17.4 8.9 35.9 15.8 55.3 20.5l5.7-23.3zM95.4 494.6L90 471.3 48.3 481c-10.4 2.4-19.7-6.9-17.3-17.3l9.7-41.6-23.4-5.5-9.7 41.6C1.2 486 26 510.8 53.8 504.4l41.6-9.7zm-50-92.9l7.7-32.8-4-7.8c-8-15.7-14.3-32.5-18.6-50.1L7.3 316.7C12 336.1 18.9 354.7 27.7 372l-5.7 24.3 23.4 5.5zM3 295.1l23.7-3.7C24.9 279.9 24 268 24 256s.9-23.9 2.7-35.4L3 216.9C1 229.7 0 242.7 0 256s1 26.3 3 39.1zm27.6-94.1c5.7-23.4 14.9-45.4 27.1-65.4L37.2 123.1c-13.4 22.1-23.6 46.4-29.9 72.2l23.3 5.7zm18.9-96.2l19.4 14.2c14-19.1 30.9-36 50.1-50.1L104.7 49.5C83.6 65 65 83.6 49.5 104.7zm86.1-47c20-12.2 42-21.4 65.4-27.1L195.2 7.3c-25.8 6.3-50.1 16.5-72.2 29.9l12.5 20.5zM256 464c114.9 0 208-93.1 208-208S370.9 48 256 48 48 141.1 48 256c0 36.4 9.4 70.7 25.8 100.5 1.6 2.9 2.1 6.2 1.4 9.4l-21.6 92.5 92.5-21.6c3.2-.7 6.5-.2 9.4 1.4 29.8 16.5 64 25.8 100.5 25.8z"],
    "xing": [384, 512, [], "f168", "M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5L9.8 346c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3L26.4 134.4c-4.3-7.8 .3-14.1 8.5-14.1l65.1 0c7.3 0 13.3 4.1 18 12.2L162.7 210zM382.6 46.1l-144 253 0 .3 91.6 166.6c3.9 7.1 .2 14.1-8.5 14.1l-65.2 0c-7.6 0-13.6-4-18-12.2L146.1 299.4c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2l65.7 0c8 0 12.3 6.7 8.5 14.1z"],
    "square-js": [448, 512, ["js-square"], "f3b9", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM180.9 444.9c-33.7 0-53.2-17.4-63.2-38.5L152 385.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5l0-143.1 42.1 0 0 143.7c0 43.6-25.6 63.5-62.9 63.5zm85.8-43L301 382.1c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6-39.1 0-64.4-18.6-76.7-43z"],
    "fonticons": [448, 512, [], "f280", "M0 32l0 448 448 0 0-448-448 0zM187 172.9c-18.4 0-19 9.9-19 27.4l0 23.3c0 2.4-3.5 4.4-.6 4.4l67.4 0-11.1 37.3-55.7 0 0 112.9c0 5.8-2 6.7 3.2 7.3l43.5 4.1 0 25.1-130.7 0 0-25.7 21.3-2c5.2-.6 6.7-2.3 6.7-7.9l0-111.4c0-2.3-2.9-2.3-5.8-2.3l-22.2 0 0-37.4 28 0 0-21c0-49.6 26.5-70 77.3-70 34.1 0 64.7 8.2 64.7 52.8l-50.7 6.1c.3-18.7-4.4-23-16.3-23zm74.3 241.8l0-25.1 20.4-2.6c5.2-.6 7.6-1.7 7.6-7.3l0-107.9c0-4.1-2.9-6.7-6.7-7.9l-24.2-6.4 6.7-29.5 80.2 0 0 151.7c0 5.8-2.6 6.4 2.9 7.3l15.7 2.6 0 25.1-102.6 0zm80.8-255.5l9 33.2-7.3 7.3-31.2-16.6-31.2 16.6-7.3-7.3 9-33.2-21.8-24.2 3.5-9.6 27.7 0 15.5-28 9.3 0 15.5 28 27.7 0 3.5 9.6-21.9 24.2z"],
    "ups": [384, 512, [], "f7e0", "M103.2 303c-5.2 3.6-32.6 13.1-32.6-19l0-104-32.7 0 0 102.6c0 74.9 80.2 51.1 97.9 39l0-141.6-32.6 0 0 123zM4 74.8L4 295.7c0 103.7 74.9 135.2 187.7 184.1 112.4-48.9 187.7-80.2 187.7-184.1l0-220.9C263.1 13.2 97.6 25.2 4 74.8zM362.1 295.7c0 86.6-53.2 113.6-170.4 165.3-117.5-51.8-170.5-78.7-170.5-165.3l0-126.4c102.3-93.8 231.6-100 340.9-89.8l0 216.2zM152.5 188.3l0 212.8 32.7 0 0-68.7c24.4 7.3 71.7-2.6 71.7-78.5 0-97.4-80.7-80.9-104.4-65.6zm32.7 117.3l0-100.3c8.4-4.2 38.4-12.7 38.4 49.3 0 67.9-36.4 51.8-38.4 51zm79.1-86.4c.1 47.3 51.6 42.5 52.2 70.4 .6 23.5-30.4 23-50.8 4.9l0 30.1c36.2 21.5 81.9 8.1 83.2-33.5 1.7-51.5-54.1-46.6-53.4-73.2 .6-20.3 30.6-20.5 48.5-2.2l0-28.4c-28.5-22-79.9-9.2-79.7 31.9z"],
    "amazon-pay": [640, 512, [], "f42c", "M14 325.3c2.3-4.2 5.2-4.9 9.7-2.5 10.4 5.6 20.6 11.4 31.2 16.7 40.6 20.2 83.3 35.8 127.4 46.3 20.8 5 41.9 9 63.2 11.8 31.5 4.2 63.2 6 95 5.2 17.4-.4 34.8-1.8 52.1-3.8 56.2-6.6 111.1-21 163.3-42.8 2.9-1.2 5.9-2 9.1-1.2 6.7 1.8 9 9 4.1 13.9-3 2.7-6.2 5.2-9.6 7.4-30.7 21.1-64.2 36.4-99.6 47.9-24.5 7.9-49.6 13.8-75.1 17.6-17.6 2.7-35.4 4.3-53.2 4.8-.8 0-1.7 .2-2.5 .3l-21.1 0c-.8-.1-1.7-.2-2.5-.3-3.6-.2-7.2-.3-10.7-.4-16.9-.8-33.7-2.5-50.4-5.3-27.4-4.5-54.3-11.5-80.4-20.9-53.7-19.4-103.1-48.9-145.6-87-1.8-1.6-3-3.8-4.4-5.7l0-2zM172 65.1l-4.3 .6c-13.8 1.7-26.8 6.9-38 15.1-2.4 1.7-4.6 3.5-7.1 5.4-.2-.4-.3-.9-.4-1.4-.4-2.7-.8-5.5-1.3-8.2-.7-4.6-3-6.6-7.6-6.6l-11.5 0c-6.9 0-8.2 1.3-8.2 8.2l0 209.3c0 1 0 2 .1 3 .2 3 2 4.9 4.9 5 7 .1 14.1 .1 21.1 0 2.9 0 4.7-2 5-5 .1-1 .1-2 .1-3l0-72.4c1.1 .9 1.7 1.4 2.2 1.9 17.9 14.9 38.5 19.8 61 15.4 20.4-4 34.6-16.5 43.8-34.9 7-13.9 9.9-28.7 10.3-44.1 .5-17.1-1.2-33.9-8.1-49.8-8.5-19.6-22.6-32.5-43.9-36.9-3.2-.7-6.5-1-9.8-1.5-2.8-.1-5.5-.1-8.3-.1zM124.6 107c-.1-.7 .1-1.3 .4-1.9s.8-1.1 1.3-1.4c13.7-9.5 28.8-14.5 45.6-13.2 14.9 1.1 27.1 8.4 33.5 25.9 3.9 10.7 4.9 21.8 4.9 33 0 10.4-.8 20.6-4 30.6-6.8 21.3-22.4 29.4-42.6 28.5-14-.6-26.2-6-37.4-13.9-.6-.3-1-.8-1.3-1.4s-.4-1.2-.4-1.9c.1-14.1 0-28.1 0-42.2s.1-28 0-42.1zM330.3 65.1c-1 .1-2 .3-2.9 .4-9.7 .4-19.4 1.8-28.9 4.1-6.1 1.6-12 3.8-17.9 5.8-3.6 1.2-5.4 3.8-5.3 7.7 .1 3.3-.1 6.6 0 9.9 .1 4.8 2.1 6.1 6.8 4.9 7.8-2 15.6-4.2 23.5-5.7 12.3-2.3 24.7-3.3 37.2-1.4 6.5 1 12.6 2.9 16.8 8.4 3.7 4.8 5.1 10.5 5.3 16.4 .3 8.3 .2 16.6 .3 24.9 0 .5-.1 .9-.2 1.4-.5-.1-.9 0-1.3-.1-10.5-2.6-21.2-4.2-32-4.9-11.3-.6-22.5 .1-33.3 3.9-12.9 4.5-23.3 12.3-29.4 24.9-4.7 9.8-5.4 20.2-3.9 30.7 2 14 9 24.8 21.4 31.7 11.9 6.6 24.8 7.4 37.9 5.4 15.1-2.3 28.5-8.7 40.3-18.4 .5-.4 1-.8 1.6-1.1 .6 3.8 1.1 7.4 1.8 11 .6 3.1 2.5 5.1 5.4 5.2 5.4 .1 10.9 .1 16.3 0 1.3 0 2.5-.5 3.4-1.4s1.4-2.1 1.5-3.3c.1-.9 .1-1.9 .1-2.8l0-106c0-4.3-.3-8.6-.9-12.9-1.9-12.9-7.4-23.5-19-30.4-6.7-4-14.1-6-21.8-7.1-3.6-.5-7.2-.8-10.8-1.3-3.9 .1-7.9 .1-11.9 .1zm35 127.7c0 .6-.1 1.2-.3 1.7s-.7 1-1.2 1.3c-11.2 8.1-23.5 13.5-37.4 14.9-5.7 .6-11.4 .4-16.8-1.8-3-1.1-5.6-2.9-7.8-5.2s-3.7-5.1-4.6-8.1c-2-6.3-2-13.1-.1-19.4 2.5-8.3 8.4-13 16.4-15.6 8-2.4 16.5-3.2 24.8-2.2 8.4 .7 16.6 2.3 25 3.4 1.6 .2 2.1 1 2.1 2.6-.1 4.8 0 9.5 0 14.3s-.2 9.4-.1 14.1zM625.2 322.2c-1-5-4.8-6.9-9.1-8.3-6.8-2.1-13.9-3.5-21-3.9-13.1-1.1-26.3-.5-39.2 1.9-14.3 2.7-27.9 7.3-40 15.6-1.4 .9-2.7 2.1-3.7 3.5-.4 .6-.6 1.3-.7 1.9s0 1.4 .2 2.1c.4 1.5 2.1 1.9 3.6 1.8 .7 0 1.5 0 2.2-.1 7.8-.8 15.5-1.7 23.3-2.5 11.4-1.1 22.9-1.8 34.3-.9 4.9 .4 9.7 1.3 14.4 2.7 5.1 1.4 7.4 5.2 7.6 10.4 .4 8-1.4 15.7-3.5 23.3-4.1 15.4-10 30.3-15.8 45.1-.4 1-.8 2-1 3-.5 2.9 1.2 4.8 4.1 4.1 1.8-.4 3.4-1.3 4.8-2.5 4.5-4.2 8.8-8.7 12.7-13.4 12.8-16.4 20.3-35.3 24.7-55.6 .8-3.6 1.4-7.3 2.1-10.9l0-17.3zM493.1 199c-12.9-35.7-25.8-71.4-38.7-107.2-2-5.7-4.2-11.3-6.3-16.9-1.1-2.9-3.2-4.8-6.4-4.8-7.6-.1-15.2-.2-22.9-.1-2.5 0-3.7 2-3.2 4.5 .5 2.1 1.1 4.1 1.9 6.1 19.6 48.5 39.3 97 59.1 145.5 1.7 4.1 2.1 7.6 .2 11.8-3.3 7.3-5.9 15-9.3 22.3-3 6.5-8 11.4-15.2 13.3-5 1.3-10.2 1.7-15.4 1.1-2.5-.2-5-.8-7.5-1-3.4-.2-5.1 1.3-5.2 4.8-.1 3.3-.1 6.6 0 9.9 .1 5.5 2 8 7.4 8.9 5.6 1.1 11.2 1.8 16.9 2 17.1 .4 30.7-6.5 39.5-21.4 3.5-5.9 6.6-12 9.2-18.4 23.7-59.8 47.2-119.7 70.6-179.6 .7-1.8 1.3-3.6 1.6-5.5 .4-2.8-.9-4.4-3.7-4.4-6.6-.1-13.3 0-19.9 0-1.7-.1-3.4 .3-4.7 1.3s-2.4 2.3-3 3.9c-.5 1.4-1.1 2.7-1.6 4.1l-34.8 100c-2.5 7.2-5.1 14.5-7.7 22.2-.4-1.1-.6-1.7-.9-2.4z"],
    "pandora": [384, 512, [], "e7da", "M201.3 32L0 32 0 480 120.2 480c11.2 0 20.3-9.1 20.3-20.3l0-86.1 30.1 0c147.1 0 207.3-82.9 207.3-179.9 0-119.7-90.9-161.8-176.5-161.8z"],
    "openid": [448, 512, [], "f19b", "M271.5 432l-68 32C88.5 453.7 0 392.5 0 318.2 0 246.7 82.5 187.2 191.7 173.9l0 43c-71.5 12.5-124 53-124 101.3 0 51 58.5 93.3 135.7 103l0-340 68-33.2 0 384 .1 0zM448 291l-131.3-28.5 36.8-20.7c-19.5-11.5-43.5-20-70-24.8l0-43c46.2 5.5 87.7 19.5 120.3 39.3l35-19.8 9.2 97.5z"],
    "vsco": [512, 512, [], "e7dd", "M357.6 256c0-27.1-10.6-52.5-29.7-71.7s-44.6-29.7-71.7-29.7l-.1 0c-27.1 0-52.6 10.6-71.7 29.7s-29.7 44.6-29.7 71.7c0 27.1 10.6 52.5 29.7 71.7 19.2 19.2 44.6 29.7 71.7 29.7l.1 0c27.1 0 52.6-10.6 71.7-29.7 19.2-19.2 29.7-44.6 29.7-71.7zM176.3 482.1c23 8.1 47 12.6 71.6 13.4l0-59.1c-17.1-.7-33.5-3.8-49-8.9l-22.6 54.6zm137-54.6c-15.5 5.1-32 8.2-49 8.9l0 59.1c24.6-.8 48.6-5.3 71.6-13.4l-22.6-54.6zM92.5 431.2c20.2 18.9 43.3 34 68.7 45l22.5-54.5c-18.3-7.9-35.1-18.8-49.8-31.9L92.5 431.2zm285.9-41.4c-14.6 13.2-31.4 24-49.8 31.9l22.5 54.5c25.4-11 48.4-26.1 68.7-45l-41.4-41.4zM145.4 378.2c13.6 12.1 29 21.9 45.8 29 18 7.6 37.1 12 56.7 12.9l0-46.8c-26.4-1.8-50.3-12.3-69.1-28.6l-33.4 33.4zm188-33.4c-18.8 16.3-42.7 26.8-69.1 28.6l0 46.8c19.6-.9 38.7-5.3 56.7-12.9 16.8-7.1 32.2-16.9 45.8-29l-33.4-33.4zM38.5 356.6c10.7 23.2 25 44.3 42.5 63.1l41.3-41.3c-12.4-13.4-22.9-28.6-30.9-45.2L38.5 356.6zm382.4-23.5c-8 16.6-18.5 31.9-30.9 45.2l41.3 41.3c17.5-18.7 31.8-39.9 42.5-63.1l-52.9-23.5zm-331-69c1.1 18.8 5.4 37.2 12.8 54.5 7.5 17.8 18 34 31.2 48.2l33.5-33.5c-16.4-18.8-26.9-42.8-28.7-69.2l-48.8 0zm283.7 0c-1.8 26.4-12.3 50.4-28.7 69.2l33.5 33.5c13.1-14.2 23.6-30.4 31.2-48.2 7.3-17.4 11.6-35.7 12.7-54.5l-48.7 0zm-357.1 0c.9 26.7 6.1 52.7 15.6 77.5L85 318.2c-6.4-17-10.3-35.1-11.3-54l-57.1 0zm422.1 0c-1 18.9-5 37.1-11.3 54l52.8 23.5c9.5-24.8 14.7-50.8 15.6-77.5l-57.1 0zM32.1 170.4c-9.5 24.8-14.7 50.8-15.6 77.5l57.1 0c1-18.9 5-37.1 11.3-54L32.1 170.4zm101.7-25.2c-13.1 14.2-23.6 30.4-31.2 48.2-7.3 17.4-11.6 35.7-12.8 54.5l48.8 0c1.8-26.4 12.3-50.4 28.7-69.2l-33.5-33.5zm211.1 33.5c16.4 18.8 26.9 42.8 28.7 69.2l48.7 0c-1.1-18.8-5.4-37.2-12.7-54.5-7.5-17.8-18-34-31.2-48.2l-33.5 33.5zm82.4 15.2c6.4 17 10.3 35.1 11.3 54l57.1 0c-.9-26.7-6.1-52.7-15.6-77.5l-52.8 23.5zM81 92.3C63.4 111 49.2 132.2 38.5 155.4l52.9 23.5c8-16.6 18.5-31.9 30.9-45.2L81 92.3zm309 41.3c12.4 13.4 22.9 28.6 30.9 45.2l52.9-23.5c-10.7-23.2-25-44.3-42.5-63.1L390 133.7zM248 91.8c-19.6 .9-38.7 5.3-56.7 12.9-16.8 7.1-32.2 16.9-45.8 29l33.4 33.4c18.8-16.3 42.7-26.8 69.1-28.6l0-46.7zm16.3 46.7c26.4 1.8 50.3 12.3 69.1 28.6l33.4-33.4c-13.6-12.1-29-21.9-45.8-29-18-7.6-37.1-12-56.7-12.9l0 46.7zM161.2 35.8c-25.4 11-48.4 26.1-68.7 45l41.4 41.4c14.7-13.2 31.4-24 49.8-31.9L161.2 35.8zM328.6 90.3c18.3 7.9 35.1 18.8 49.8 31.9l41.4-41.4c-20.2-18.9-43.3-34-68.7-45L328.6 90.3zM248 16.4c-24.6 .8-48.6 5.3-71.6 13.4l22.6 54.6c15.5-5.1 32-8.2 49-8.9l0-59.1zm16.3 59.1c17.1 .7 33.5 3.8 49 8.9l22.6-54.6c-23-8.1-47-12.6-71.6-13.4l0 59.1zM512.2 264.2l-.2 0C507.8 399 399.2 507.7 264.3 511.9l0 .1-16.3 0 0-.1C113.1 507.7 4.5 399 .2 264.1l-.2 0 0-16.3 .2 0C4.5 113 113.1 4.3 248 .1l0-.1 16.3 0 0 .1C399.2 4.3 507.8 113 512 247.9l.2 0 0 16.3z"],
    "ubuntu": [576, 512, [], "f7df", "M469.2 75c0-20.1-8-39.3-22.2-53.5s-33.4-22.2-53.5-22.2-39.3 8-53.5 22.2-22.2 33.4-22.2 53.5c0 20.1 8 39.3 22.1 53.5s33.4 22.1 53.5 22.1 39.3-8 53.5-22.1 22.1-33.4 22.1-53.5l.1 0zm-315 165.7a75.6 75.6 0 1 0 -151.2 0 75.6 75.6 0 1 0 151.2 0zM57 346c18.6 46.9 51 87 93 115.1s91.5 42.6 142 41.7c-14.7-18.6-22.9-41.5-23.2-65.2-6.8-.9-13.3-2.1-19.5-3.4-26.8-5.7-51.9-17.3-73.6-34s-39.3-38.1-51.7-62.5c-20.9 9.9-44.5 12.8-67.1 8.2l.1 .1zm395.1 89.8a75.6 75.6 0 1 0 -151.2 0 75.6 75.6 0 1 0 151.2 0zM444 351.6c18.5 14.8 31.6 35.2 37.2 58.2 33.3-41.3 52.6-92.2 54.8-145.2s-12.5-105.4-42.2-149.4c-8.6 21.5-24 39.6-43.8 51.6 15.4 28.6 22.9 60.8 21.9 93.2s-10.7 64-28 91.6l.1 0zM101.1 135.4c12.4 2.7 24.3 7.5 35.1 14.3 16.6-24.2 38.9-44.1 64.8-58S255.8 70.4 285.2 70c.2-5.9 .9-11.9 2-17.7 3.6-16.7 11.1-32.3 21.8-45.5-47.7-3.8-95.4 6-137.6 28.5S94.3 91.7 70.8 133.4c2.7-.2 5.3-.3 8-.3 7.5 0 15 .8 22.4 2.3l-.1 0z"],
    "viacoin": [384, 512, [], "f237", "M384 32l-64 0-80.7 192-94.5 0-80.8-192-64 0 48 112-48 0 0 48 68.5 0 13.8 32-82.3 0 0 48 102.8 0 89.2 208 89.2-208 102.8 0 0-48-82.3 0 13.8-32 68.5 0 0-48-48 0 48-112zM192 336l-27-64 54 0-27 64z"],
    "zhihu": [640, 512, [], "f63f", "M170.5 148.1l0 217.5 23.4 0 7.7 26.4 42-26.4 49.5 0 0-217.5-122.7 0zm97.8 193.9l-27.9 0-27.9 17.5-5.1-17.5-11.9 0 0-170.3 72.8 0 0 170.3zM149.8 247.7l-52.3 0c1.7-27.1 2.2-51.6 2.2-73.5l51.2 0s2-22.6-8.6-22.3l-88.5 0c3.5-13.1 7.9-26.7 13.1-40.7 0 0-24.1 0-32.3 21.6-3.4 8.9-13.2 43.1-30.7 78.1 5.9-.6 25.4-1.2 36.8-22.2 2.1-5.9 2.5-6.7 5.1-14.5l28.9 0c0 10.5-1.2 66.9-1.7 73.4l-52.3 0c-11.7 0-15.6 23.6-15.6 23.6l65.6 0c-4.4 49.9-28 91.9-70.8 125.1 20.5 5.9 40.9-.9 51-9.9 0 0 23-20.9 35.6-69.3l54 64.9s7.9-26.9-1.2-40c-7.6-8.9-28.1-33.1-36.8-41.8L87.9 312c4.4-14 7-27.6 7.9-40.7l61.6 0s-.1-23.6-7.6-23.6l0 0zm412-1.6c20.8-25.6 45-58.6 45-58.6s-18.6-14.8-27.4-4.1c-6 8.2-36.8 48.2-36.8 48.2l19.2 14.4zM411.8 187c-9-8.2-25.9 2.1-25.9 2.1s39.5 55 41.1 57.4l19.5-13.7s-25.7-37.6-34.7-45.9l0 0 0 0zM640 258.4c-19.8 0-130.9 .9-131.1 .9l0-101c4.8 0 12.4-.4 22.8-1.2 40.9-2.4 70.1-4 87.8-4.8 0 0 12.2-27.2-.6-33.4-3.1-1.2-23.2 4.6-23.2 4.6s-165.2 16.5-232.4 18c1.6 8.8 7.6 17.1 15.8 19.6 13.3 3.5 22.7 1.7 49.2 .9 24.8-1.6 43.7-2.4 56.5-2.4l0 99.8-133.5 0s2.8 22.3 25.5 22.9l107.9 0 0 70.9c0 14-11.2 22-24.5 21.1-14.1 .1-26.1-1.1-41.7-1.8 2 4 6.3 14.4 19.3 21.8 9.9 4.8 16.2 6.6 26 6.6 29.6 0 45.7-17.3 44.9-45.3l0-73.3 122.4 0c9.7 0 8.7-23.8 8.7-23.8l0 0z"],
    "yandex": [256, 512, [], "f413", "M153.1 315.8L65.7 512 2 512 98 302.2C52.9 279.3 22.8 237.8 22.8 161.1 22.7 53.7 90.8 0 171.7 0l82.3 0 0 512-55.1 0 0-196.2-45.8 0zM198.9 46.5l-29.4 0c-44.4 0-87.4 29.4-87.4 114.6 0 82.3 39.4 108.8 87.4 108.8l29.4 0 0-223.4z"],
    "pixiv": [448, 512, [], "e640", "M96 32C43 32 0 75 0 128L0 384c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96L96 32zm77.7 217.3a60.1 60.1 0 1 0 120.3 0 60.1 60.1 0 1 0 -120.3 0zM119.1 387.8c-.3-.8-.5-1.7-.5-2.6l0-244.3c0-1.8 .7-3.6 2-4.9s3-2 4.9-2l16.9 0c1.2 0 2.3 .3 3.3 .8s1.9 1.3 2.5 2.3l14 21.8c19.7-15.6 44.5-25 71.6-25 63.6 0 115.2 51.6 115.2 115.2S297.5 364.5 233.8 364.5c-22 0-42.6-6.2-60.1-16.9l0 37.6c0 .9-.2 1.8-.5 2.6s-.9 1.6-1.5 2.2-1.4 1.1-2.2 1.5-1.7 .5-2.6 .5l-41.3 0c-.9 0-1.8-.2-2.6-.5s-1.6-.9-2.2-1.5-1.1-1.4-1.5-2.2z"],
    "openai": [512, 512, [], "e7cf", "M196.4 185.8l0-48.6c0-4.1 1.5-7.2 5.1-9.2l97.8-56.3c13.3-7.7 29.2-11.3 45.6-11.3 61.4 0 100.4 47.6 100.4 98.3 0 3.6 0 7.7-.5 11.8L343.3 111.1c-6.1-3.6-12.3-3.6-18.4 0L196.4 185.8zM424.7 375.2l0-116.2c0-7.2-3.1-12.3-9.2-15.9L287 168.4 329 144.3c3.6-2 6.7-2 10.2 0L437 200.7c28.2 16.4 47.1 51.2 47.1 85 0 38.9-23 74.8-59.4 89.6l0 0zM166.2 272.8l-42-24.6c-3.6-2-5.1-5.1-5.1-9.2l0-112.6c0-54.8 42-96.3 98.8-96.3 21.5 0 41.5 7.2 58.4 20L175.4 108.5c-6.1 3.6-9.2 8.7-9.2 15.9l0 148.5 0 0zm90.4 52.2l-60.2-33.8 0-71.7 60.2-33.8 60.2 33.8 0 71.7-60.2 33.8zm38.7 155.7c-21.5 0-41.5-7.2-58.4-20l100.9-58.4c6.1-3.6 9.2-8.7 9.2-15.9l0-148.5 42.5 24.6c3.6 2 5.1 5.1 5.1 9.2l0 112.6c0 54.8-42.5 96.3-99.3 96.3l0 0zM173.8 366.5L76.1 310.2c-28.2-16.4-47.1-51.2-47.1-85 0-39.4 23.6-74.8 59.9-89.6l0 116.7c0 7.2 3.1 12.3 9.2 15.9l128 74.2-42 24.1c-3.6 2-6.7 2-10.2 0zm-5.6 84c-57.9 0-100.4-43.5-100.4-97.3 0-4.1 .5-8.2 1-12.3l100.9 58.4c6.1 3.6 12.3 3.6 18.4 0l128.5-74.2 0 48.6c0 4.1-1.5 7.2-5.1 9.2l-97.8 56.3c-13.3 7.7-29.2 11.3-45.6 11.3l0 0zm127 60.9c62 0 113.7-44 125.4-102.4 57.3-14.9 94.2-68.6 94.2-123.4 0-35.8-15.4-70.7-43-95.7 2.6-10.8 4.1-21.5 4.1-32.3 0-73.2-59.4-128-128-128-13.8 0-27.1 2-40.4 6.7-23-22.5-54.8-36.9-89.6-36.9-62 0-113.7 44-125.4 102.4-57.3 14.8-94.2 68.6-94.2 123.4 0 35.8 15.4 70.7 43 95.7-2.6 10.8-4.1 21.5-4.1 32.3 0 73.2 59.4 128 128 128 13.8 0 27.1-2 40.4-6.7 23 22.5 54.8 36.9 89.6 36.9z"],
    "sith": [448, 512, [], "f512", "M0 32l69.7 118.8-58.9-11.5 69.8 91c-3 17-3 34.4 0 51.4l-69.8 91 58.9-11.5-69.7 118.8 118.8-69.7-11.5 58.9 91-69.8c17 3 34.5 3 51.5 0l91 69.8-11.5-58.9 118.7 69.7-69.7-118.8 58.9 11.5-69.8-91c3-17 3-34.4 0-51.4l69.8-91-58.9 11.5 69.7-118.8-118.7 69.7 11.5-58.9-91.1 69.9c-8.5-1.5-17.1-2.3-25.7-2.3s-17.2 .8-25.7 2.3L107.2 42.8 118.8 101.7 0 32zM224 380.2a124.2 124.2 0 1 1 0-248.4 124.2 124.2 0 1 1 0 248.4zm0-211.8a87.6 87.6 0 1 0 0 175.1 87.6 87.6 0 1 0 0-175.1z"],
    "nfc-directional": [512, 512, [], "e530", "M211.8 488.6c1.6 2.5 2.1 5.6 1.4 8.5-.6 2.9-2.4 5.5-4.9 7.1-2.6 1.6-5.6 2.1-8.6 1.5-61.4-13.9-115.6-49.9-152.2-101.2S-5.4 290.3 1.6 227.7c7-62.7 36.8-120.5 83.7-162.5 46.9-42 107.7-65.2 170.7-65.2 1.5 0 2.1 .3 4.3 .9 1.4 .6 1.8 1.4 3.7 2.5 1.1 1.1 1.9 2.3 2.5 3.7 .5 1.4 .8 2.8 .8 4.3l0 101 24.5-25.9c1-1.1 2.2-2 3.6-2.6 1.3-.6 2.8-.9 4.3-1 1.5-.1 2.9 .2 4.3 .7s2.7 1.3 3.8 2.4c1 1 1.9 2.2 2.5 3.6 .6 1.3 1 2.8 1 4.3s-.2 3-.7 4.3c-.6 1.4-1.4 2.6-2.4 3.7l-44 46.6c-1.1 1.1-2.3 2-3.7 2.6-1.5 .6-3 .9-5.4 .9-.6 0-2.2-.3-3.6-.9s-2.7-1.5-3.7-2.6l-44.1-46.6c-2-2.2-3.1-5.1-3-8.1 0-3 1.3-6.7 3.5-7.9 2.2-2.1 5.1-3.2 8.1-3.1 3 .1 5.8 1.3 7.9 3.5l24.5 26 0-89.5c-56.4 2.8-109.8 25.8-150.5 65-40.6 39.1-65.7 91.7-70.6 147.9S34.4 348.1 67.7 393.7c32.4 45.5 82 77.5 137 89.9 2.9 .7 5.5 2.5 7.1 5zM171.4 126.1c-.8 1.3-1.9 2.4-3.1 3.2-20.5 13.9-37.2 32.6-48.8 54.5s-17.7 46.3-17.7 71.1 6.1 49.2 17.7 70.2c11.6 22.8 28.3 41.5 48.8 55.4 2.5 1.7 4.2 4.3 4.7 7.3 .6 2.9-.9 6-1.7 8.4-1.7 2.5-5.2 4.2-7.3 3.9-2.9 1.4-6 .8-8.4-.9-23.6-16-42.8-37.5-56.1-62.7-13.3-25.1-20.3-53.1-20.3-81.6 0-28.4 7-56.5 20.3-81.6 13.3-25.2 32.5-46.7 56.1-62.7 1.2-.8 2.6-1.4 4-1.8 1.5-.3 3-.3 4.5 0 1.4 .2 2.8 .8 4.1 1.6s2.3 1.9 3.2 3.1c.8 1.2 1.4 2.6 1.7 4.1s.3 3 0 4.4c-.3 1.5-.8 2.9-1.7 4.1zM340.9 383.5c.8-1.2 1.9-2.3 2.2-3.1l0-.1c21.3-14 38-32.7 49.6-54.6 11.5-21.8 17.5-46.2 17.5-70.9s-6-49.1-17.5-71c-11.6-22.7-28.3-40.5-49.6-54.5-.3-.8-1.4-1.9-2.2-3.1-.8-1.3-1.4-2.7-1.6-4.1-1.2-1.5-.3-3 0-4.4 .3-1.5 .9-2.9 1.7-4.1 .9-1.2 1.1-2.3 3.2-3.1 1.2-.8 2.6-1.3 4.1-1.6s2.9-.3 4.4 0 2.8 .9 4.1 1.8c23.4 16 42.7 37.5 55.9 62.6 13.3 25.1 19.4 53.1 19.4 81.5 0 28.5-6.1 56.5-19.4 81.6-13.2 25.1-32.5 46.6-55.9 62.6-1.3 .9-2.6 1.5-4.1 1.8s-2.9 .3-4.4 0-2.9-1.7-4.1-1.6c-2.1-.8-2.3-1.9-3.2-3.1-.8-1.2-1.4-2.6-1.7-4.1-.3-1.4-1.2-2.9 0-4.4 .2-1.4 .8-2.8 1.6-4.1zM312.3 6.3c56.2 12.7 106.4 44 142.7 88.7 30.4 37.6 49.6 83 55.3 131 5.6 48-2.4 96.7-23.2 140.3-20.9 43.6-53.6 80.5-94.5 106.3-40.9 25.7-88.2 39.4-136.6 39.4-1.5 0-2.9-.3-4.3-.9-1.4-.5-2.6-1.4-3.7-2.4-1.9-1.1-1.9-2.3-2.4-3.7-.6-1.4-.9-2.8-.9-4.3l0-99.2-24.5 26c-2.1 2.2-4.9 2.6-7.9 3.6-3 .1-5.9-1.1-8.1-4-2.2-1.2-3.5-4-3.5-7-.1-3 1-5.9 3-8.1l44.1-46.6c1.3-2.2 5.1-3.4 7.3-3.4 4 0 6.9 1.2 9.1 3.4l44 46.6c2.1 2.2 3.2 5.1 3.1 8.1s-1.4 5.8-3.5 7c-2.2 2.9-5.1 4.1-8.1 4-3-1-5.9-1.4-7.9-3.6l-24.5-25.9 0 87.5c56.4-2.8 109.8-25.8 150.5-65 40.7-40 65.8-91.7 70.7-147.9 4.8-57.1-10.8-112.3-44.1-157.9-33.3-45.6-82-77.5-137-89.9-1.5-.3-2.8-.9-4.1-1.8-1.2-.9-2.2-1.9-3-3.2-.8-1.2-2.2-2.6-1.6-4.1-.2-1.5-.2-3 .1-4.4 .4-1.4 1-2.8 1.8-4 .9-1.2 2-2.2 3.2-3 1.3-.8 2.7-1.3 4.1-1.6 1.5-.3 3-.2 4.4 .1zm40.8 249.8c0 31.4-17.5 61.1-49.3 83.5-2.1 1.5-4.8 2.3-7.4 2-2.7-.2-5.2-1.3-7-3.2l-70.1-69.8c-2.2-2.1-4.2-5-3.4-8 0-3 1.2-5.9 3.3-8 2.2-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3l63.1 62.8c20.8-17.1 32.2-37.9 32.2-59.3 0-23.9-14.1-47-39.7-65.1-2.5-1.7-4.1-4.3-4.6-7.3-.5-2.9 .1-6 1.9-8.4 1.7-2.5 4.3-4.1 7.3-4.6 2.9-.5 6 .1 8.4 1.9 31.8 22.4 49.3 52.1 49.3 83.5zM216.7 341.5c-3 .5-6-.2-8.5-1.9-31.7-22.4-50.1-52.1-50.1-83.5s18.4-61.1 50.1-83.5c2.2-1.6 4.9-2.3 7.5-2.1 2.7 .3 5.1 1.4 7 3.3l70.1 69.8c2.1 2.1 3.3 5 3.3 8s-2 5.8-3.3 8c-2.1 2.1-5 3.3-7.9 3.3-3 0-6.8-1.2-8-3.3l-63.1-62.9c-20.9 17.3-32.2 38-32.2 59.4 0 23 14.1 47 39.7 65 2.4 1.8 4.1 4.4 4.6 7.4 .5 2.9-.2 5.9-1.9 8.4-1.7 2.4-4.4 4.1-7.3 4.6z"],
    "creative-commons-by": [512, 512, [], "f4e7", "M322.9 194.4l0 101.4-28.3 0 0 120.5-77.1 0 0-120.4-28.3 0 0-101.5c0-4.4 1.6-8.2 4.6-11.3 3.1-3.1 6.9-4.7 11.3-4.7l101.9 0c4.1 0 7.8 1.6 11.1 4.7 3.1 3.2 4.8 6.9 4.8 11.3zm-32.5-64.5a34.5 34.5 0 1 1 -69 .8 34.5 34.5 0 1 1 69-.8zM255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3z"],
    "umbraco": [512, 512, [], "f8e8", "M256.3 8a248 248 0 1 0 -.7 496 248 248 0 1 0 .7-496zm145 266c-.8 27.1-5.4 48.8-14 65s-23.1 27.9-43.5 35c-20.4 7.1-48.9 10.6-85.4 10.5l-4.6 0c-36.5 .1-65-3.3-85.4-10.5s-34.9-18.8-43.5-35c-8.6-16.2-13.2-37.9-14-65-.7-10.2-.7-20.5 0-30.7 .4-14.7 1.6-29.3 3.6-43.9 1.9-13.4 3.6-22.6 5.4-32 1-4.9 1.3-6.4 1.8-8.4 .3-1.1 .9-2.1 1.8-2.8s2-1.1 3.1-1.1l.7 0 32 5c1.2 .2 2.2 .8 3 1.7s1.2 2.1 1.2 3.3c0 .3 0 .5 0 .8l-1.7 8.8c-1.6 8.8-3.2 20.1-4.8 33.7-1.7 14-2.5 28.1-2.6 42.2-.2 27 2.5 46.9 8.1 59.8 2.8 6.4 7.2 12 12.6 16.4s11.9 7.4 18.7 8.8c18.8 4 38.1 5.7 57.3 5.1l10.3 0c19.2 .6 38.5-1.2 57.3-5.2 6.8-1.4 13.2-4.5 18.6-8.8s9.7-10 12.5-16.4c5.7-12.9 8.4-32.9 8.1-59.8-.1-14.1-1-28.2-2.6-42.1-1.7-13.6-3.3-24.8-4.9-33.7l-1.7-8.8c0-.3 0-.5 0-.8 0-1.2 .4-2.4 1.2-3.3s1.8-1.5 3-1.7l32-5 .8 0c1.1 0 2.2 .4 3.1 1.1s1.5 1.7 1.8 2.8c.6 2 .8 3.6 1.8 8.4 1.8 9.6 3.5 18.8 5.4 32 2 14.6 3.2 29.2 3.6 43.9 .7 10.2 .7 20.5 0 30.7l0 0z"],
    "hooli": [640, 512, [], "f427", "M144.5 352l38.3 .8c-13.2-4.6-26-10.2-38.3-16.8l0 16zm57.7-5.3l0 5.3-19.4 .8c36.5 12.5 69.9 14.2 94.7 7.2-19.9 .2-45.8-2.6-75.3-13.3zM611.1 231.5c15.9 0 28.9-12.9 28.9-28.9s-12.9-24.5-28.9-24.5c-15.9 0-28.9 8.6-28.9 24.5s12.9 28.9 28.9 28.9zM582.1 352l57.9 0 0-110.5-57.9 0 0 110.5zm-73.7 0l57.9 0 0-195.3-57.9 27.3 0 168zm-31-119.4c-18.2-18.2-50.4-17.1-50.4-17.1s-32.3-1.1-50.4 17.1c-18.2 18.2-16.8 33.9-16.8 52.6s-1.4 34.3 16.8 52.5 50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.8-33.8 16.8-52.5-.1-18.8 1.3-34.5-16.8-52.6zm-39.8 71.9c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5l0-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9l0 40.4zM331.4 232.6c-18.2-18.2-50.4-17.1-50.4-17.1s-32.2-1.1-50.4 17.1c-1.9 1.9-3.7 3.9-5.3 6-38.2-29.6-72.5-46.5-102.1-61.1l0-20.7-22.5 10.6c-54.4-22.1-89-18.2-97.3 .1 0 0-24.9 32.8 61.8 110.8l0 73.7 57.9 0 0-28.6c-6.5-4.2-13-8.7-19.4-13.6-14.8-11.2-27.4-21.6-38.4-31.4l0-31c13.1 14.7 30.5 31.4 53.4 50.3l4.5 3.6 0-29.8c0-6.9 1.7-18.2 10.8-18.2s10.6 6.9 10.6 15l0 48.7c18 12.2 37.3 22.1 57.7 29.6l0-93.9c0-18.7-13.4-37.4-40.6-37.4-15.8-.1-30.5 8.2-38.5 21.9l0-54.3c41.9 20.9 83.9 46.5 99.9 58.3-10.2 14.6-9.3 28.1-9.3 43.7 0 18.7-1.4 34.3 16.8 52.5s50.4 17.1 50.4 17.1 32.3 1.1 50.4-17.1c18.2-18.2 16.7-33.8 16.7-52.5 0-18.5 1.5-34.2-16.7-52.3zM65.2 184l0 63.3c-48.7-54.5-38.9-76-35.2-79.1 13.5-11.4 37.5-8 64.4 2.1L65.2 184zM291.7 304.5c0 3.6-1.8 12.5-10.7 12.5s-10.7-8.9-10.7-12.5l0-40.4c0-8.7 7.3-10.9 10.7-10.9s10.7 2.1 10.7 10.9l0 40.4z"],
    "square-git": [448, 512, ["git-square"], "f1d2", "M120.8 335.5c-5.9-.4-12.6-.8-20.2-1.3-3.3 4.1-6.6 8.4-6.6 13.5 0 18.5 65.5 18.5 65.5-1.5 0-8.3-7.4-8.7-38.8-10.7l.1 0zm7.8-117.9c-32.3 0-33.7 44.5-.7 44.5 32.5 0 31.7-44.5 .7-44.5zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM243.9 172.2c-14.5 0-22.9-8.4-22.9-22.9s8.4-22.3 22.9-22.3c14.7 0 23.1 7.8 23.1 22.3s-8.4 22.9-23.1 22.9zM149.6 195l49.5 0 0 21.6-23.4 1.8c4.6 5.8 9.4 14 9.4 25.7 0 48.7-57.2 47.2-74.2 42.4l-8.4 13.4c5 .3 9.8 .6 14.3 .8 56.3 3.2 80.5 4.6 80.5 38.5 0 29.2-25.7 45.7-69.9 45.7-46 0-63.5-11.6-63.5-31.7 0-11.4 5.1-17.5 14-25.9-8.4-3.5-11.2-9.9-11.2-16.8 0-9.6 7.4-16.3 23-30.6l.2-.2c-12.4-6.1-21.8-19.3-21.8-38.1 0-51.6 56.6-53.3 81.6-46.8l-.1 .2zM270.5 303.1l13 1.8 0 20.1-72.4 0 0-20.1c2.7-.4 5-.7 6.9-.9 9.9-1.2 10.1-1.3 10.1-6l0-74.7c0-4.4-.9-4.7-10.1-7.8-1.9-.7-4.2-1.4-6.9-2.4l2.8-20.6 52.6 0 0 105.5c0 4.1 .2 4.6 4.1 5.1l-.1 0zm106.6-10.4L384 315c-10.9 5.4-26.9 10.2-41.4 10.2-30.2 0-41.7-12.2-41.7-40.9l0-66.6c0-.8 0-1.4-.2-1.8-.8-1.2-4.2-.7-19.6-.7l0-22.6c22.3-2.5 31.2-13.7 34-41.4l24.2 0c0 33.3-.6 38 .7 38.6 .3 .1 .7 0 1.3 0l35.8 0 0 25.4-37.8 0 0 61.6c-.2 6.3-.9 30.4 37.9 15.9l-.1 0z"],
    "odnoklassniki": [320, 512, [], "f263", "M275.1 334c-27.4 17.4-65.1 24.3-90 26.9l20.9 20.6 76.3 76.3c27.9 28.6-17.5 73.3-45.7 45.7-19.1-19.4-47.1-47.4-76.3-76.6L84 503.4c-28.2 27.5-73.6-17.6-45.4-45.7 19.4-19.4 47.1-47.4 76.3-76.3l20.6-20.6c-24.6-2.6-62.9-9.1-90.6-26.9-32.6-21-46.9-33.3-34.3-59 7.4-14.6 27.7-26.9 54.6-5.7 0 0 36.3 28.9 94.9 28.9S255 269.2 255 269.2c26.9-21.1 47.1-8.9 54.6 5.7 12.4 25.7-1.9 38-34.5 59.1zm14.6-204.7a129.7 129.7 0 1 1 -259.4 .4 129.7 129.7 0 1 1 259.4-.4zm-193.4 .4a63.7 63.7 0 1 0 127.4-.4 63.7 63.7 0 1 0 -127.4 .4z"],
    "drupal": [384, 512, [], "f1a9", "M272.3 108.1C236.5 72.5 202.5 38.4 192.4 0 182.4 38.4 148.1 72.5 112.4 108.1 58.8 161.7-1.9 222.4-1.9 313.4-4.3 420.7 80.8 509.6 188.1 512s196.2-82.8 198.5-190.1c.1-2.8 .1-5.6 0-8.5 0-91.1-60.8-151.7-114.3-205.3zM98 331.1c-5.9 7.5-11 15.6-15.2 24.2-.3 .7-.8 1.3-1.3 1.8s-1.2 .8-2 1l-1.7 0c-4.3 0-9.2-8.5-9.2-8.5-1.3-2-2.5-4.2-3.7-6.4l-.8-1.8c-11.2-25.7-1.5-62.3-1.5-62.3 4.8-17.8 12.7-34.7 23.2-49.9 6.4-9.6 13.5-18.9 21-27.7l9.2 9.2 43.5 44.4c.8 .9 1.3 2.1 1.3 3.3s-.5 2.4-1.3 3.3L114.1 312.3 98 331.1zm96.6 127.3c-12.9-.1-25.6-3.9-36.4-11s-19.4-17.1-24.6-28.9-7-24.9-5-37.7 7.6-24.7 16.2-34.4c14.2-16.9 31.5-33.5 50.3-55.3 22.3 23.8 36.9 40.1 51.2 58 1.1 1.4 2.1 2.9 3 4.4 7.8 11.1 12 24.4 12 38 0 8.8-1.7 17.4-5 25.5s-8.2 15.5-14.4 21.7-13.5 11.1-21.6 14.5-16.7 5.1-25.5 5.1l-.2 0zM320.7 351.6c-.4 1.4-1.2 2.6-2.3 3.6s-2.4 1.6-3.8 1.8l-1.3 0c-2.6-.9-4.9-2.7-6.3-5.1-11.6-17.5-24.9-33.9-39.5-49l-17.8-18.4-59.1-61.3c-12.4-11.5-24.2-23.6-35.4-36.3-.3-.5-.6-.9-.9-1.4-2-2.8-3.6-5.9-4.7-9.2l0-1.8c-.8-5-.4-10.1 1.2-15s4.4-9.2 8-12.7c11.4-11.4 23-23 33.8-34.9 12 13.3 24.8 26 37.4 38.6 25.8 24 49.1 50.5 69.6 79.1 17.3 24.5 26.7 53.8 27 83.8-.1 12.9-2.2 25.8-6 38.2z"],
    "blogger-b": [448, 512, [], "f37d", "M446.6 222.7c-1.8-8-6.8-15.4-12.5-18.5-1.8-1-13-2.2-25-2.7-20.1-.9-22.3-1.3-28.7-5-10.1-5.9-12.8-12.3-12.9-29.5-.1-33-13.8-63.7-40.9-91.3-19.3-19.7-40.9-33-65.5-40.5-5.9-1.8-19.1-2.4-63.3-2.9-69.4-.8-84.8 .6-108.4 10-43.5 17.2-74.7 53.8-86.1 100.6-2.1 8.8-2.6 22.9-3.1 103.9-.6 101.5 .1 116.4 6.4 136.5 15.6 49.6 59.9 86.3 104.4 94.3 14.8 2.7 197.3 3.3 216 .8 32.5-4.4 58-17.5 81.9-41.9 17.3-17.7 28.1-36.8 35.2-62.1 4.9-17.6 4.5-142.8 2.5-151.7zM124.5 159.1c7.8-7.9 10-8.2 58.8-8.2 43.9 0 45.4 .1 51.8 3.4 9.3 4.7 13.4 11.3 13.4 21.9 0 9.5-3.8 16.2-12.3 21.6-4.6 2.9-7.3 3.1-50.3 3.3-26.5 .2-47.7-.4-50.8-1.2-16.6-4.7-22.8-28.5-10.6-40.8zM316.3 358.9l-14.9 2.4-77.5 .9c-68.1 .8-87.3-.4-90.9-2-7.1-3.1-13.8-11.7-14.9-19.4-1.1-7.3 2.6-17.3 8.2-22.4 7.1-6.4 10.2-6.6 97.3-6.7 89.6-.1 89.1-.1 97.6 7.8 12.1 11.3 9.5 31.2-4.9 39.4z"],
    "invision": [448, 512, [], "f7b0", "M407.4 32L40.6 32C18.2 32 0 50.2 0 72.6L0 439.4C0 461.8 18.2 480 40.6 480l366.8 0c22.4 0 40.6-18.2 40.6-40.6l0-366.8C448 50.2 429.8 32 407.4 32zM176.1 145.6c.4 23.4-22.4 27.3-26.6 27.4-14.9 0-27.1-12-27.1-27 .1-35.2 53.1-35.5 53.7-.4zM332.8 377c-65.6 0-34.1-74-25-106.6 14.1-46.4-45.2-59-59.9 .7l-25.8 103.3-45.1 0 8.1-32.5c-31.5 51.8-94.6 44.4-94.6-4.3 .1-14.3 .9-14 23-104.1l-31.8 0 9.7-35.6 76.4 0c-33.6 133.7-32.6 126.9-32.9 138.2 0 20.9 40.9 13.5 57.4-23.2l19.8-79.4-32.3 0 9.7-35.6 68.8 0-8.9 40.5c40.5-75.5 127.9-47.8 101.8 38-14.2 51.1-14.6 50.7-14.9 58.8 0 15.5 17.5 22.6 31.8-16.9L386 325c-10.5 36.7-29.4 52-53.2 52z"],
    "facebook-f": [320, 512, [], "f39e", "M80 299.3l0 212.7 116 0 0-212.7 86.5 0 18-97.8-104.5 0 0-34.6c0-51.7 20.3-71.5 72.7-71.5 16.3 0 29.4 .4 37 1.2l0-88.7C291.4 4 256.4 0 236.2 0 129.3 0 80 50.5 80 159.4l0 42.1-66 0 0 97.8 66 0z"],
    "centos": [448, 512, [], "f789", "M289.6 97.5l31.6 31.7-76.3 76.5 0-108.2 44.7 0zM127.2 129.2l76.3 76.5 0-108.2-44.7 0-31.6 31.7zm41.5-41.6l44.7 0 0 127.9 10.8 10.8 10.8-10.8 0-127.9 44.7 0-55.5-55.6-55.5 55.6zm26.2 168.1l-10.8-10.8-128.6 0 0-44.8-55.5 55.6 55.5 55.6 0-44.8 128.6 0 10.8-10.8zM274.2 235l107.9 0 0-44.8-31.6-31.7-76.3 76.5zm173.3 20.7l-55.5-55.6 0 44.8-127.7 0-10.8 10.8 10.8 10.8 127.7 0 0 44.8 55.5-55.6zM65.4 176.2l32.5-31.7 90.3 90.5 15.3 0 0-15.3-90.3-90.5 31.6-31.7-79.4 0 0 78.7zM382.1 97.5l-78.5 0 31.6 31.7-90.3 90.5 0 15.3 15.3 0 90.3-90.5 31.6 31.7 0-78.7zM203.5 413.9l0-108.1-76.3 76.5 31.6 31.7 44.7 0 0-.1zM65.4 235l108.8 0-76.3-76.5-32.5 31.7 0 44.8zM382.1 335.2l-31.6 31.7-90.3-90.5-15.3 0 0 15.3 90.3 90.5-31.6 31.7 78.5 0 0-78.7zm0-58.8l-107.9 0 76.3 76.5 31.6-31.7 0-44.8zM321.2 382.2l-76.3-76.5 0 108.1 44.7 0 31.6-31.6zM97.9 352.9l76.3-76.5-108.8 0 0 44.8 32.5 31.7zm181.8 70.9l-44.7 0 0-127.9-10.8-10.8-10.8 10.8 0 127.9-44.7 0 55.5 55.6 55.5-55.6zM113.2 382.2l90.3-90.5 0-15.3-15.3 0-90.3 90.5-32.5-31.7 0 78.7 79.4 0-31.6-31.7z"],
    "cc-amazon-pay": [576, 512, [], "f42d", "M124.7 201.8c.1-11.8 0-23.5 0-35.3l0-35.3c0-1.3 .4-2 1.4-2.7 11.5-8 24.1-12.1 38.2-11.1 12.5 .9 22.7 7 28.1 21.7 3.3 8.9 4.1 18.2 4.1 27.7 0 8.7-.7 17.3-3.4 25.6-5.7 17.8-18.7 24.7-35.7 23.9-11.7-.5-21.9-5-31.4-11.7-.9-.8-1.4-1.6-1.3-2.8zm154.9 14.6c4.6 1.8 9.3 2 14.1 1.5 11.6-1.2 21.9-5.7 31.3-12.5 .9-.6 1.3-1.3 1.3-2.5-.1-3.9 0-7.9 0-11.8 0-4-.1-8 0-12 0-1.4-.4-2-1.8-2.2-7-.9-13.9-2.2-20.9-2.9-7-.6-14-.3-20.8 1.9-6.7 2.2-11.7 6.2-13.7 13.1-1.6 5.4-1.6 10.8 .1 16.2 1.6 5.5 5.2 9.2 10.4 11.2zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM368.5 103.9c.4 1.7 .9 3.4 1.6 5.1 16.5 40.6 32.9 81.3 49.5 121.9 1.4 3.5 1.7 6.4 .2 9.9-2.8 6.2-4.9 12.6-7.8 18.7-2.6 5.5-6.7 9.5-12.7 11.2-4.2 1.1-8.5 1.3-12.9 .9-2.1-.2-4.2-.7-6.3-.8-2.8-.2-4.2 1.1-4.3 4-.1 2.8-.1 5.6 0 8.3 .1 4.6 1.6 6.7 6.2 7.5 4.7 .8 9.4 1.6 14.2 1.7 14.3 .3 25.7-5.4 33.1-17.9 2.9-4.9 5.6-10.1 7.7-15.4 19.8-50.1 39.5-100.3 59.2-150.5 .6-1.5 1.1-3 1.3-4.6 .4-2.4-.7-3.6-3.1-3.7-5.6-.1-11.1 0-16.7 0-3.1 0-5.3 1.4-6.4 4.3-.4 1.1-.9 2.3-1.3 3.4l-29.1 83.7c-2.1 6.1-4.2 12.1-6.5 18.6-.4-.9-.6-1.4-.8-1.9-10.8-29.9-21.6-59.9-32.4-89.8-1.7-4.7-3.5-9.5-5.3-14.2-.9-2.5-2.7-4-5.4-4-6.4-.1-12.8-.2-19.2-.1-2.2 0-3.3 1.6-2.8 3.7zM242.4 206c1.7 11.7 7.6 20.8 18 26.6 9.9 5.5 20.7 6.2 31.7 4.6 12.7-1.9 23.9-7.3 33.8-15.5 .4-.3 .8-.6 1.4-1 .5 3.2 .9 6.2 1.5 9.2 .5 2.6 2.1 4.3 4.5 4.4 4.6 .1 9.1 .1 13.7 0 2.3-.1 3.8-1.6 4-3.9 .1-.8 .1-1.6 .1-2.3l0-88.8c0-3.6-.2-7.2-.7-10.8-1.6-10.8-6.2-19.7-15.9-25.4-5.6-3.3-11.8-5-18.2-5.9-3-.4-6-.7-9.1-1.1l-10 0c-.8 .1-1.6 .3-2.5 .3-8.2 .4-16.3 1.4-24.2 3.5-5.1 1.3-10 3.2-15 4.9-3 1-4.5 3.2-4.4 6.5 .1 2.8-.1 5.6 0 8.3 .1 4.1 1.8 5.2 5.7 4.1 6.5-1.7 13.1-3.5 19.7-4.8 10.3-1.9 20.7-2.7 31.1-1.2 5.4 .8 10.5 2.4 14.1 7 3.1 4 4.2 8.8 4.4 13.7 .3 6.9 .2 13.9 .3 20.8 0 .4-.1 .7-.2 1.2-.4 0-.8 0-1.1-.1-8.8-2.1-17.7-3.6-26.8-4.1-9.5-.5-18.9 .1-27.9 3.2-10.8 3.8-19.5 10.3-24.6 20.8-4.1 8.3-4.6 17-3.4 25.8zM98.7 106.9l0 175.3c0 .8 0 1.7 .1 2.5 .2 2.5 1.7 4.1 4.1 4.2 5.9 .1 11.8 .1 17.7 0 2.5 0 4-1.7 4.1-4.1 .1-.8 .1-1.7 .1-2.5l0-60.7c.9 .7 1.4 1.2 1.9 1.6 15 12.5 32.2 16.6 51.1 12.9 17.1-3.4 28.9-13.9 36.7-29.2 5.8-11.6 8.3-24.1 8.7-37 .5-14.3-1-28.4-6.8-41.7-7.1-16.4-18.9-27.3-36.7-30.9-2.7-.6-5.5-.8-8.2-1.2l-7 0c-1.2 .2-2.4 .3-3.6 .5-11.7 1.4-22.3 5.8-31.8 12.7-2 1.4-3.9 3-5.9 4.5-.1-.5-.3-.8-.4-1.2-.4-2.3-.7-4.6-1.1-6.9-.6-3.9-2.5-5.5-6.4-5.6l-9.7 0c-5.9-.1-6.9 1-6.9 6.8zM493.6 339c-2.7-.7-5.1 0-7.6 1-43.9 18.4-89.5 30.2-136.8 35.8-14.5 1.7-29.1 2.8-43.7 3.2-26.6 .7-53.2-.8-79.6-4.3-17.8-2.4-35.5-5.7-53-9.9-37-8.9-72.7-21.7-106.7-38.8-8.8-4.4-17.4-9.3-26.1-14-3.8-2.1-6.2-1.5-8.2 2.1l0 1.7c1.2 1.6 2.2 3.4 3.7 4.8 36 32.2 76.6 56.5 122 72.9 21.9 7.9 44.4 13.7 67.3 17.5 14 2.3 28 3.8 42.2 4.5 3 .1 6 .2 9 .4 .7 0 1.4 .2 2.1 .3l17.7 0c.7-.1 1.4-.3 2.1-.3 14.9-.4 29.8-1.8 44.6-4 21.4-3.2 42.4-8.1 62.9-14.7 29.6-9.6 57.7-22.4 83.4-40.1 2.8-1.9 5.7-3.8 8-6.2 4.3-4.4 2.3-10.4-3.3-11.9zM544 311.3c-.8-4.2-4-5.8-7.6-7-5.7-1.9-11.6-2.8-17.6-3.3-11-.9-22-.4-32.8 1.6-12 2.2-23.4 6.1-33.5 13.1-1.2 .8-2.4 1.8-3.1 3-.6 .9-.7 2.3-.5 3.4 .3 1.3 1.7 1.6 3 1.5 .6 0 1.2 0 1.8-.1l19.5-2.1c9.6-.9 19.2-1.5 28.8-.8 4.1 .3 8.1 1.2 12 2.2 4.3 1.1 6.2 4.4 6.4 8.7 .3 6.7-1.2 13.1-2.9 19.5-3.5 12.9-8.3 25.4-13.3 37.8-.3 .8-.7 1.7-.8 2.5-.4 2.5 1 4 3.4 3.5 1.4-.3 3-1.1 4-2.1 3.7-3.6 7.5-7.2 10.6-11.2 10.7-13.8 17-29.6 20.7-46.6 .7-3 1.2-6.1 1.7-9.1 .2-4.7 .2-9.6 .2-14.5z"],
    "ebay": [640, 512, [], "f4f4", "M606.5 189.5l-54.8 109.9-54.9-109.9-37.5 0 10.9 20.6c-11.5-19-35.9-26-63.3-26-31.8 0-67.9 8.7-71.5 43.1l33.7 0c1.4-13.8 15.7-21.8 35-21.8 26 0 41 9.6 41 33l0 3.4c-12.7 0-28 .1-41.7 .4-42.4 .9-69.6 10-76.7 34.4 1-5.2 1.5-10.6 1.5-16.2 0-52.1-39.7-76.2-75.4-76.2-21.3 0-43 5.5-58.7 24.2l0-80.6-32.1 0 0 169.5c0 10.3-.6 22.9-1.1 33.1l31.5 0c.7-6.3 1.1-12.9 1.1-19.5 13.6 16.6 35.4 24.9 58.7 24.9 36.9 0 64.9-21.9 73.3-54.2-.5 2.8-.7 5.8-.7 9 0 24.1 21.1 45 60.6 45 26.6 0 45.8-5.7 61.9-25.5 0 6.6 .3 13.3 1.1 20.2l29.8 0c-.7-8.2-1-17.5-1-26.8l0-65.6c0-9.3-1.7-17.2-4.8-23.8l61.5 116.1-28.5 54.1 35.9 0 99.2-194.8-34 0zM244.2 313.8c-29.6 0-50.2-21.5-50.2-53.8 0-32.4 20.6-53.8 50.2-53.8 29.8 0 50.2 21.4 50.2 53.8 0 32.3-20.4 53.8-50.2 53.8zm200.9-47.3c0 30-17.9 48.4-51.6 48.4-25.1 0-35-13.4-35-25.8 0-19.1 18.1-24.4 47.2-25.3 13.1-.5 27.6-.6 39.4-.6l0 3.3zM33.2 268.1l128.8 0 0-8.5c0-51.7-33.1-75.4-78.4-75.4-56.8 0-83 30.8-83 77.6 0 42.5 25.3 74 82.5 74 31.4 0 68-11.7 74.4-46.1l-33.1 0c-12 35.8-87.7 36.7-91.2-21.6zm95-21.4l-94.4 0c6.9-56.6 92.1-54.7 94.4 0z"],
    "contao": [512, 512, [], "f26d", "M45.4 305c14.4 67.1 26.4 129 68.2 175L34 480c-18.7 0-34-15.2-34-34L0 66C0 47.3 15.2 32 34 32l57.7 0c-13.8 12.6-26.1 27.2-36.9 43.6-45.4 70-27 146.8-9.4 229.4zM478 32l-90.2 0c21.4 21.4 39.2 49.5 52.7 84.1L303.4 145.4c-14.9-29-37.8-53.3-82.6-43.9-24.6 5.3-41 19.3-48.3 34.6-8.8 18.7-13.2 39.8 8.2 140.3 21.1 100.2 33.7 117.7 49.5 131.2 12.9 11.1 33.4 17 58.3 11.7 44.5-9.4 55.7-40.7 57.4-73.2l137.4-29.6c3.2 71.5-18.7 125.2-57.4 163.6l52.1 0c18.7 0 34-15.2 34-34L512 66c0-18.8-15.2-34-34-34z"],
    "ello": [512, 512, [], "f5f1", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM399.8 293.2C383.3 358.5 323.8 404.8 256 404.8S128.7 358.5 112.2 293.2c-1.6-7.4 2.5-15.7 9.9-17.4s15.7 2.5 17.4 9.9c14 52.9 62 90.1 116.6 90.1s102.5-37.2 116.6-90.1c1.7-7.4 9.9-12.4 17.4-9.9 7.4 1.7 12.4 9.9 9.9 17.4z"],
    "sistrix": [448, 512, [], "f3ee", "M448 449L301.2 300.2c20-27.9 31.9-62.2 31.9-99.2 0-93.1-74.7-168.9-166.5-168.9-91.9-.1-166.6 75.7-166.6 168.8S74.7 369.8 166.5 369.8c39.8 0 76.3-14.2 105-37.9L417.5 480 448 449zM166.5 330.8c-70.6 0-128.1-58.3-128.1-129.9S95.9 71 166.5 71 294.6 129.3 294.6 200.9 237.2 330.8 166.5 330.8z"],
    "periscope": [448, 512, [], "f3da", "M370 63.6c-38.6-41-89.5-63.6-143.4-63.6-114.7 0-208.1 96.2-208.1 214.4 0 75.1 57.8 159.8 82.7 192.7 36.6 48.4 91.4 104.9 125.4 104.9 41.6 0 112.9-94.2 120.9-105 24.6-33.1 82-118.3 82-192.6 0-56.5-21.1-110.1-59.5-150.8zM226.6 493.9c-42.5 0-190-167.3-190-279.4 0-107.4 83.9-196.3 190-196.3 100.8 0 184.7 89 184.7 196.3 .1 112.1-147.4 279.4-184.7 279.4zM338 206.8c0 59.1-51.1 109.7-110.8 109.7-100.6 0-150.7-108.2-92.9-181.8l0 .4c0 24.5 20.1 44.4 44.8 44.4s44.8-19.9 44.8-44.4c0-18.2-11.1-33.8-26.9-40.7 76.6-19.2 141 39.3 141 112.4z"],
    "expeditedssl": [512, 512, [], "f23e", "M256 43.4a212.6 212.6 0 1 0 0 425.2 212.6 212.6 0 1 0 0-425.2zM158.6 176.3c0-53.7 43.7-97.4 97.4-97.4s97.4 43.7 97.4 97.4l0 26.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-26.6c0-82.1-124-82.1-124 0l0 26.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-26.6 .2 0zM397.7 380c0 9.7-8 17.7-17.7 17.7l-248 0c-9.7 0-17.7-8-17.7-17.7l0-141.7c0-9.7 8-17.7 17.7-17.7l248 0c9.7 0 17.7 8 17.7 17.7l0 141.7zm-248-137.3l0 132.9c0 2.5-1.9 4.4-4.4 4.4l-8.9 0c-2.5 0-4.4-1.9-4.4-4.4l0-132.9c0-2.5 1.9-4.4 4.4-4.4l8.9 0c2.5 0 4.4 1.9 4.4 4.4zm141.7 48.7c0 13-7.2 24.4-17.7 30.4l0 31.6c0 5-3.9 8.9-8.9 8.9l-17.7 0c-5 0-8.9-3.9-8.9-8.9l0-31.6c-10.5-6.1-17.7-17.4-17.7-30.4 0-19.7 15.8-35.4 35.4-35.4s35.5 15.8 35.5 35.4zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 17.7a230.3 230.3 0 1 1 0 460.6 230.3 230.3 0 1 1 0-460.6z"],
    "napster": [512, 512, [], "f3d2", "M306.3 373.6c-14.2 13.6-31.3 24.1-50.4 30.5-19-6.4-36.2-16.9-50.3-30.5l100.7 0zm44-199.6c20-16.9 43.6-29.2 69.6-36.2l0 161.2c0 219.4-328 217.6-328 .3l0-161.6c25.9 6.9 49.6 19.6 69.5 36.4 56.8-40 132.5-39.9 188.9-.1zM141.5 115.5c64.4-60 164.3-60.1 228.9-.2-7.1 3.5-13.9 7.3-20.6 11.5-58.7-30.5-129.2-30.4-187.9 .1-6.3-4-13.9-8.2-20.4-11.4zM51.8 93.2l0 69.3c-58.4 36.5-58.4 121.1 .1 158.3 26.4 245.1 381.7 240.3 407.6 1.5l.3-1.7c58.7-36.3 58.9-121.7 .2-158.2l0-69.2c-17.3 .5-34 3-50.1 7.4-82-91.5-225.5-91.5-307.5 .1-16.3-4.4-33.1-7-50.6-7.5zM267.2 352s36-.3 61.3-1.5c10.2-.5 21.1-4 25.5-6.5 26.3-15.1 25.4-39.2 26.2-47.4-79.5-.6-99.9-3.9-113 55.4zM131.7 296.7c.8 8.2-.1 32.3 26.2 47.4 4.4 2.5 15.2 6 25.5 6.5 25.3 1.1 61.3 1.5 61.3 1.5-13.2-59.4-33.7-56.1-113-55.4zM300.8 420.1c-3.2-5.3-6.9-7.3-6.9-7.3-24.8 7.3-52.2 6.9-75.9 0 0 0-2.9 1.5-6.4 6.6-2.8 4.1-3.7 9.6-3.7 9.6 29.1 17.6 67.1 17.6 96.2 0-.1-.1-.3-4-3.3-8.9z"],
    "delicious": [448, 512, [], "f1a5", "M446.6 68c-.4-1.5-.9-3-1.4-4.5-.9-2.5-2-4.8-3.3-7.1-1.4-2.4-3-4.8-4.7-6.9-2.1-2.5-4.4-4.8-6.9-6.8-1.1-.9-2.2-1.7-3.3-2.5-1.3-.9-2.6-1.7-4-2.4-1.8-1-3.6-1.8-5.5-2.5-1.7-.7-3.5-1.3-5.4-1.7-3.8-1-7.9-1.5-12-1.5l-352 0C21.6 32 .1 53.5 .1 80l0 352c0 4.1 .5 8.2 1.5 12 2 7.7 5.8 14.6 11 20.3 1 1.1 2.1 2.2 3.3 3.3 5.7 5.2 12.6 9 20.3 11 3.8 1 7.9 1.5 12 1.5l352 0c26.5 0 48-21.5 48-48l0-352.1c-.1-4.1-.6-8.2-1.6-12zM416.1 432c0 8.8-7.2 16-16 16l-176 0 0-192-192 0 0-176c0-8.8 7.2-16 16-16l176 0 0 192 192 0 0 176z"],
    "guilded": [448, 512, [], "e07e", "M443.9 64L5 64c0 103.3 22.2 180.1 43.4 222.4 64.1 127.8 176 161.6 177.3 161.6 55.7-20.5 104.5-56.3 140.6-103.5 25.9-33.9 53.1-87.2 65.9-145.8l-259.9 0c4.1 36.4 22.2 67.9 45.1 86.9l88.6 0c-17 28.2-48.2 54.4-80.5 69.5-31.2-13.3-69.1-46.5-96.5-98.4-26.7-53.8-27.1-105.9-27.1-105.9l336.1 0c4-28.8 5.9-57.9 5.9-86.9z"],
    "xbox": [512, 512, [], "f412", "M369.9 318.2c44.3 54.3 64.7 98.8 54.4 118.7-7.9 15.1-56.7 44.6-92.6 55.9-29.6 9.3-68.4 13.3-100.4 10.2-38.2-3.7-76.9-17.4-110.1-39-27.9-18.2-34.2-25.7-34.2-40.6 0-29.9 32.9-82.3 89.2-142.1 32-33.9 76.5-73.7 81.4-72.6 9.4 2.1 84.3 75.1 112.3 109.5zM188.6 143.8c-29.7-26.9-58.1-53.9-86.4-63.4-15.2-5.1-16.3-4.8-28.7 8.1-29.2 30.4-53.5 79.7-60.3 122.4-5.4 34.2-6.1 43.8-4.2 60.5 5.6 50.5 17.3 85.4 40.5 120.9 9.5 14.6 12.1 17.3 9.3 9.9-4.2-11-.3-37.5 9.5-64 14.3-39 53.9-112.9 120.3-194.4zm311.6 63.5c-16.9-80-67.5-130.3-74.6-130.3-7.3 0-24.2 6.5-36 13.9-23.3 14.5-41 31.4-64.3 52.8 42.4 53.3 102.2 139.4 122.9 202.3 6.8 20.7 9.7 41.1 7.4 52.3-1.7 8.5-1.7 8.5 1.4 4.6 6.1-7.7 19.9-31.3 25.4-43.5 7.4-16.2 15-40.2 18.6-58.7 4.3-22.5 3.9-70.8-.8-93.4zM141.3 43c47.7-2.5 109.7 34.5 114.3 35.4 .7 .1 10.4-4.2 21.6-9.7 63.9-31.1 94-25.8 107.4-25.2-63.9-39.3-152.7-50-233.9-11.7-23.4 11.1-24 11.9-9.4 11.2z"],
    "untappd": [640, 512, [], "f405", "M401.5 49.9C321.7 210 316.9 202.4 313.6 223.1l-5.2 32.8c-1.9 12-6.6 23.5-13.7 33.4L145.8 497.1c-7.6 10.6-20.4 16.2-33.4 14.6-40.3-5-77.8-32.2-95.3-68.5-5.7-11.8-4.5-25.8 3.1-36.4L169.1 198.9c7.1-9.9 16.4-18 27.2-23.7l29.3-15.5c18.5-9.8 9.7-11.9 135.6-138.9 1-4.8 1-7.3 3.6-8 3-.7 6.6-1 6.3-4.6l-.4-4.6c-.2-1.9 1.3-3.6 3.2-3.6 4.5-.1 13.2 1.2 25.6 10 12.3 8.9 16.4 16.8 17.7 21.1 .6 1.8-.6 3.7-2.4 4.2l-4.5 1.1c-3.4 .9-2.5 4.4-2.3 7.4 .1 2.8-2.3 3.6-6.5 6.1zM230.3 36.4c3.4 .9 2.5 4.4 2.3 7.4-.2 2.7 2.1 3.5 6.4 6 7.9 15.9 15.3 30.5 22.2 44 .7 1.3 2.3 1.5 3.3 .5 11.2-12 24.6-26.2 40.5-42.6 1.3-1.4 1.4-3.5 .1-4.9-8-8.2-16.5-16.9-25.6-26.1-1-4.7-1-7.3-3.6-8-3-.8-6.6-1-6.3-4.6 .3-3.3 1.4-8.1-2.8-8.2-4.5-.1-13.2 1.1-25.6 10-12.3 8.9-16.4 16.8-17.7 21.1-1.4 4.2 3.6 4.6 6.8 5.4zM620.2 406.7L471.4 198.8c-13.2-18.5-26.6-23.4-56.4-39.1-11.2-5.9-14.2-10.9-30.5-28.9-1-1.1-2.9-.9-3.6 .5-46.3 88.8-47.1 82.8-49 94.8-1.7 10.7-1.3 20 .3 29.8 1.9 12 6.6 23.5 13.7 33.4L494.8 497.2c7.6 10.6 20.2 16.2 33.1 14.7 40.3-4.9 78-32 95.7-68.6 5.4-11.9 4.3-25.9-3.4-36.6z"],
    "google-plus-g": [640, 512, [], "f0d5", "M386.3 228.5c1.8 9.7 3.1 19.4 3.1 32 0 109.8-73.6 187.5-184.4 187.5-106.1 0-192-85.9-192-192S98.9 64 205 64c51.9 0 95.1 18.9 128.6 50.3l-52.1 50c-14.1-13.6-39-29.6-76.5-29.6-65.5 0-118.9 54.2-118.9 121.3S139.5 377.3 205 377.3c76 0 104.5-54.7 109-82.8l-109 0 0-66 181.3 0 0 0zm185.4 6.4l0-55.7-56 0 0 55.7-55.7 0 0 56 55.7 0 0 55.7 56 0 0-55.7 55.7 0 0-56-55.7 0z"],
    "github-alt": [512, 512, [], "f113", "M202.1 328.7c0 20.9-10.9 55.1-36.7 55.1s-36.7-34.2-36.7-55.1 10.9-55.1 36.7-55.1 36.7 34.2 36.7 55.1zM496 278.2c0 31.9-3.2 65.7-17.5 95-37.9 76.6-142.1 74.8-216.7 74.8-75.8 0-186.2 2.7-225.6-74.8-14.6-29-20.2-63.1-20.2-95 0-41.9 13.9-81.5 41.5-113.6-5.2-15.8-7.7-32.4-7.7-48.8 0-21.5 4.9-32.3 14.6-51.8 45.3 0 74.3 9 108.8 36 29-6.9 58.8-10 88.7-10 27 0 54.2 2.9 80.4 9.2 34-26.7 63-35.2 107.8-35.2 9.8 19.5 14.6 30.3 14.6 51.8 0 16.4-2.6 32.7-7.7 48.2 27.5 32.4 39 72.3 39 114.2zm-64.3 50.5c0-43.9-26.7-82.6-73.5-82.6-18.9 0-37 3.4-56 6-14.9 2.3-29.8 3.2-45.1 3.2-15.2 0-30.1-.9-45.1-3.2-18.7-2.6-37-6-56-6-46.8 0-73.5 38.7-73.5 82.6 0 87.8 80.4 101.3 150.4 101.3l48.2 0c70.3 0 150.6-13.4 150.6-101.3zm-82.6-55.1c-25.8 0-36.7 34.2-36.7 55.1s10.9 55.1 36.7 55.1 36.7-34.2 36.7-55.1-10.9-55.1-36.7-55.1z"],
    "get-pocket": [448, 512, [], "f265", "M407.6 64l-367 0C18.5 64 0 82.5 0 104.6L0 239.8C0 364.5 99.7 464 224.2 464 348.2 464 448 364.5 448 239.8l0-135.2C448 82.2 430.3 64 407.6 64zm-162 268.5c-12.4 11.8-31.4 11.1-42.4 0-113.7-108.9-114.9-105.1-114.9-123.2 0-16.9 13.8-30.7 30.7-30.7 17 0 16.1 3.8 105.2 89.3 90.6-86.9 88.6-89.3 105.5-89.3s30.7 13.8 30.7 30.7c0 17.8-2.9 15.7-114.8 123.2z"],
    "glide": [448, 512, [], "f2a5", "M252.8 148.6c0 8.8-1.6 17.7-3.4 26.4-5.8 27.8-11.6 55.8-17.3 83.6-1.4 6.3-8.3 4.9-13.7 4.9-23.8 0-30.5-26-30.5-45.5 0-29.3 11.2-68.1 38.5-83.1 4.3-2.5 9.2-4.2 14.1-4.2 11.4 0 12.3 8.3 12.3 17.9zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM384 267c0-5.1-20.8-37.7-25.5-39.5-2.2-.9-7.2-2.3-9.6-2.3-23.1 0-38.7 10.5-58.2 21.5l-.5-.5c4.3-29.4 14.6-57.2 14.6-87.4 0-44.6-23.8-62.7-67.5-62.7-71.7 0-108 70.8-108 123.5 0 54.7 32 85 86.3 85 7.5 0 6.9-.6 6.9 2.3-10.5 80.3-56.5 82.9-56.5 58.9 0-24.4 28-36.5 28.3-38-.2-7.6-29.3-17.2-36.7-17.2-21.1 0-32.7 33-32.7 50.6 0 32.3 20.4 54.7 53.3 54.7 48.2 0 83.4-49.7 94.3-91.7 9.4-37.7 7-39.4 12.3-42.1 20-10.1 35.8-16.8 58.4-16.8 11.1 0 19 2.3 36.7 5.2 1.8 .1 4.1-1.7 4.1-3.5z"],
    "bity": [512, 512, [], "f37a", "M86.5 67.2c95.4-89.2 246.1-91.2 343.1 3.8 14.3 14.1-6.4 37.1-22.4 21.5-84.8-82.4-215.8-80.3-298.9-3.2-16.3 15.1-36.5-8.3-21.8-22.1zm98.9 418.6c19.3 5.7 29.3-23.6 7.9-30-112.2-33.9-175.8-149.7-147.5-261 5-19.6-24.9-28.1-30.2-7.1-32.1 127.4 41.1 259.8 169.8 298.1zm148.1-2c121.9-40.2 192.9-166.9 164.4-291-4.5-19.7-34.9-13.8-30 7.9 24.2 107.7-37.1 217.9-143.2 253.4-21.2 7-10.4 36 8.8 29.7zm-62.9-79l.2-71.8c0-8.2-6.6-14.8-14.8-14.8s-14.8 6.7-14.8 14.8l-.2 71.8c0 8.2 6.6 14.8 14.8 14.8s14.8-6.6 14.8-14.8zm71-269c2.1 90.9 4.7 131.9-85.5 132.5-92.5-.7-86.9-44.3-85.5-132.5 0-21.8-32.5-19.6-32.5 0l0 71.6c0 69.3 60.7 90.9 118 90.1 57.3 .8 118-20.8 118-90.1l0-71.6c0-19.6-32.5-21.8-32.5 0z"],
    "wpexplorer": [512, 512, [], "f2de", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm480 0a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM160.9 124.6l86.9 37.1-37.1 86.9-86.9-37.1 37.1-86.9zm110 169.1l46.6 94-14.6 0-50-100-48.9 100-14 0 51.1-106.9-22.3-9.4 6-14 68.6 29.1-6 14.3-16.5-7.1zM259.1 177.4l68.6 29.4-29.4 68.3-68.3-29.1 29.1-68.6zm80.3 42.9l54.6 23.1-23.4 54.3-54.3-23.1 23.1-54.3z"],
    "megaport": [512, 512, [], "f5a3", "M222.5 209.6l0 66.2 33.5 33.5 33.3-33.3 0-66.4-33.4-33.4-33.4 33.4zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM401.1 422.4l-26.1 19.2-26-19.2 0-65.5-33.4-33.4-33.4 33.4 0 65.5-26.2 19.2-26.1-19.2 0-65.5-33.4-33.4-33.5 33.4 0 65.5-26.1 19.2-26.1-19.2 0-87 59.5-59.5 0-87.9 59.5-59.5 0-75.6 26.1-19.2 26.1 19.2 0 75.6 59.5 59.5 0 87.6 59.7 59.7 0 87.1-.1 0z"],
    "mdb": [576, 512, [], "f8ca", "M17.4 160.4l-10.4 191.6 43.9 0 5.6-79.8 27.9 79.8 44.7 0 25.5-77.4 4.8 77.4 45.5 0-12.8-191.6-45.5 0-40.7 117.3-42.3-117.3-46.3 0zm281 0l-47.9 0 0 191.6 47.9 0s95 .8 94.2-95.8c-.8-94.2-94.2-95.8-94.2-95.8l0 0zm-1.2 146.5l0-102.1s46 4.3 46.8 50.6-46.8 51.5-46.8 51.5l0 0zm238.3-74.2c7.2-11.4 10-25 8-38.3-5.3-35.8-55.1-34.3-55.1-34.3l-51.9 0 0 191.6 45.5 0s87 4.8 87-63.8c0-43.1-33.5-55.1-33.5-55.1l0 0zm-51.9-31.9s13.6-1.6 16 9.6c1.4 6.7-4 12-4 12l-12 0 0-21.6zm-.1 109.5l.1-24.9 0-18.2 .1 0s41.6-4.7 41.2 22.4c-.3 25.7-41.3 20.7-41.3 20.7l0 0z"],
    "page4": [512, 512, [], "f3d7", "M256 504C119 504 8 393 8 256S119 8 256 8c20.9 0 41.3 2.6 60.7 7.5L50.3 392 256 392 256 504zm0-143.6l0-213.6-149.4 213.6 149.4 0zM352 392l0 92.7c45.7-19.2 84.5-51.7 111.4-92.7L352 392zm57.4-138.2l-21.2 8.4 21.2 8.3 0-16.7zm-20.3 54.5c-6.7 0-8 6.3-8 12.9l0 7.7 16.2 0 0-10c0-5.9-2.3-10.6-8.2-10.6zM504 256c0 37.3-8.2 72.7-23 104.4l-129 0 0-333.1C441.3 64.8 504 153.1 504 256zM368.4 143.6l68.2 0 0-47.6-13.9 0 0 32.6-13.9 0 0-29.6-13.9 0 0 29.6-12.7 0 0-32.6-13.9 0 0 47.6 .1 0zm68.1 185.3l-26.5 0 0-11c0-15.4-5.6-25.2-20.9-25.2-15.4 0-20.7 10.6-20.7 25.9l0 25.3 68.2 0 0-15-.1 0zm0-103l-68.2 29.7 0 12.4 68.2 29.5 0-16.6-14.4-5.7 0-26.5 14.4-5.9 0-16.9zm-4.8-68.5l-35.6 0 0 26.6 13.9 0 0-12.2 11 0c8.6 15.8 1.3 35.3-18.6 35.3-22.5 0-28.3-25.3-15.5-37.7l-11.6-10.6c-16.2 17.5-12.2 63.9 27.1 63.9 34 0 44.7-35.9 29.3-65.3z"],
    "the-red-yeti": [512, 512, [], "f69d", "M488.7 241.7l20.7 7.1c-9.6-23.9-23.9-37-31.7-44.8l7.1-18.2c.2 0 12.3-27.8-2.5-30.7-.6-11.3-6.6-27-18.4-27-7.6-10.6-17.7-12.3-30.7-5.9-9.1 4.4-17.6 10-25.3 16.5-5.3-6.4-3 .4-3-29.8-37.1-24.3-45.4-11.7-74.8 3l.5 .5c-22-7.7-45.1-12.2-68.4-13.3-5.5-8.7-18.6-19.1-25.1-25.1l24.8 7.1c-5.5-5.5-26.8-12.9-34.2-15.2 18.2-4.1 29.8-20.8 42.5-33-34.9-10.1-67.9-5.9-97.9 11.8l12-44.2-1.8-.5c-31.6 24.2-33 41.9-33.7 45.5-.9-2.4-6.3-19.6-15.2-27-3.3 8.1-3.5 17.1-.5 25.3 3 8.4 5.9 14.8 8.4 18.9-16-3.3-28.3-4.9-49.2 0l-3.7 0 33 14.3c-20.2 18.9-36.1 41.9-46.7 67.4l-1.7 8.4 1.7 1.7 7.6-4.7c-3.3 11.6-5.3 19.4-6.6 25.8-10.9 12.2-20.2 25.8-27.8 40.3-15 1-31.8 10.8-40.3 14.3l3 3.4 28.8 1c-.5 1-.7 2.2-1.2 3.2-7.3 6.4-39.8 37.7-33 80.7l20.2-22.4c.5 1.7 .7 3.4 1.2 5.2 0 25.5 .4 89.6 64.9 150.5 43.6 40 96 60.2 157.5 60.2 121.7 0 223-87.3 223-211.5 6.8-9.7-1.2 3 16.7-25.1l13 14.3 2.5-.5c-1.8-11.7-4.8-23.1-8.9-34.2-1.5-4.8-3.8-9.3-6.8-13.3l0 0zM398.5 111.2l-.5 21.9c5.5 18.1 16.9 17.2 22.4 17.2l-3.4-4.7 22.4-5.4c-9 .5-18 .5-27 0 12.8-2.1 33.3-29 43-11.3 3.4 7.6 6.4 17.2 9.3 27.8l1.7-5.9c-1.3-5-1.8-10.1-1.7-15.2 5.4 .5 8.8 3.4 9.3 10.1 .5 6.4 1.7 14.8 3.4 25.3l4.7-11.3c4.6 0 4.5-3.6-2.5 20.7-20.9-8.7-35.1-8.4-46.5-8.4l18.2-16c-25.3 8.2-33 10.8-54.8 20.9-1.1-5.4-5-13.5-16-19.9-3.2 3.8-2.8 .9-.7 14.8l-2.5 0c-1.2-8.2-4.1-16-8.4-23.1l4.2-3.4c8.4-7.1 11.8-14.3 10.6-21.9-.5-6.4-5.4-13.5-13.5-20.7 5.6-3.4 15.2-.4 28.3 8.5zm-39.6-10.1c2.7 1.9 11.4 5.4 18.9 17.2 4.2 8.4 4 9.8 3.4 11.1-.5 2.4-.5 4.3-3 7.1-1.7 2.5-5.4 4.7-11.8 7.6-7.6-13-16.5-23.6-27.8-31.2l20.3-11.8zm-267.4 42l1.2-1.7c1.2-2.9 4.2-7.6 9.3-15.2l2.5-3.4-13 12.3 5.4-4.7-10.1 9.3-4.2 1.2c12.3-24.1 23.1-41.3 32.5-50.2 9.3-9.3 16-16 20.2-19.4l-6.4 1.2c-11.3-4.2-19.4-7.1-24.8-8.4 2.5-.5 3.7-.5 3.2-.5 10.3 0 17.5 .5 20.9 1.2 5.2 1.7 10.6 2.5 16 2.5l.5-1.7-8.4-35.8 13.5 29c2.8-4.4 4.8-9.2 5.9-14.3 1.7-6.4 5.4-13 10.1-19.4s7.6-10.6 9.3-11.3c-2.6 8.3-4.7 16.8-6.4 25.3l-1.7 7.1-.5 4.7 2.5 2.5c21.9-13.5 45.5-19.4 71.3-18.9l21.1 .5c-11.8 13.5-27.8 21.9-48.5 24.8-7.7 1.4-15.6 2.4-23.4 2.9l-.2-.5-2.5-1.2c-4.8-1-9.7-.3-14 2-2.5-.2-4.9-.5-7.1-.7l-2.5 1.7 .5 1.2c2 .2 3.9 .5 6.2 .7l-2 3.4 3.4-.5-10.6 11.3c-4.2 3-5.4 6.4-4.2 9.3l5.4-3.4 1.2 0c6.1-8.2 15.2-13.6 25.3-15.2l0-3c6.4 .5 13 1 19.4 1.2 6.4 0 8.4 .5 5.4 1.2 7.2 4 14.1 8.6 20.7 13.5 13.5 10.1 23.6 21.9 30 35.4 8.8 18.2 13.5 37.1 13.5 56.6 0 9.5-1 19-3 28.3-3.5 15.9-8.9 31.3-16 46l2.5 .5c18.2-19.7 41.9-16 49.2-16l-6.4 5.9 22.4 17.7-1.7 30.7c-5.4-12.3-16.5-21.1-33-27.8 16.5 14.8 23.6 21.1 21.9 20.2-4.8-2.8-3.5-1.9-10.8-3.7 4.1 4.1 17.5 18.8 18.2 20.7l.2 .2-.2 .2c0 1.8 1.6-1.2-14 22.9-75.2-15.3-106.3-42.7-141.2-63.2l11.8 1.2c-11.8-18.5-15.6-17.7-38.4-26.1l10.6-8.4c-8.8-3-18.2-3-28.3 .5l7.6-10.6-1.2-1.7c-14.9 4.3-19.8 9.2-22.6 11.3-1.1-5.5-2.8-12.4-12.3-28.8l-1.2 27-13.2-5c1.5-25.2 5.4-50.5 13.2-74.6zM368 473.1c-49.9 25-56.1 22.4-59 23.9-29.8-11.8-50.9-31.7-63.5-58.8l30 16.5c-9.8-9.3-18.3-16.5-38.4-44.3l11.8 23.1-17.7-7.6c14.2 21.1 23.5 51.7 66.6 73.5-120.8 24.2-199-72.1-200.9-74.3 11.1 9.2 22.9 17.5 35.4 24.8 3.4 1.7 7.1 2.5 10.1 1.2l-16-20.7c9.2 4.2 9.5 4.5 69.1 29-42.5-20.7-73.8-40.8-93.2-60.2-.5 6.4-1.2 10.1-1.2 10.1 8.7 7.3 15.8 16.4 20.7 26.6-39-18.9-57.6-47.6-71.3-82.6 49.9 55.1 118.9 37.5 120.5 37.1 34.8 16.4 69.9 23.6 113.9 10.6 3.3 0 20.3 17 25.3 39.1l4.2-3-2.5-23.6c9 9 24.9 22.6 34.4 13-15.6-5.3-23.5-9.5-29.5-31.7 4.6 4.2 7.6 9 27.8 15l1.2-1.2-10.5-14.2c11.7-4.8-3.5 1 32-10.8 4.3 34.3 9 49.2 .7 89.5zM483.3 258.7l-2.5 .5 3 9.3c-3.5 5.9-23.7 44.3-71.6 79.7-39.5 29.8-76.6 39.1-80.9 40.3l-7.6-7.1-1.2 3 14.3 16-7.1-4.7 3.4 4.2-1.2 0-21.9-13.5 9.3 26.6-19-27.9-1.2 2.5 7.6 29c-6.1-8.2-21-32.6-56.8-39.6l32.5 21.2c-31.2 4.7-63 2.5-93.2-6.4-4.2-1.2-8.9-2.5-13.5-4.2l1.2-3-44.8-22.4 26.1 22.4c-57.7 9.1-113-25.4-126.4-83.4L29.3 284.8 7 307.1c19.5-57.5 25.6-57.9 51.4-70.1-9.1-5.3-1.6-3.3-38.4-9.3 15.8-5.8 33-15.4 73 5.2 1.2-.7 2.4-1.3 3.7-1.7 .6-3.2 .4-.8 1-11.8 3.9 10 3.6 8.7 3 9.3l1.7 .5c12.7-6.5 8.9-4.5 17-8.9l-5.4 13.5 22.3-5.8-8.4 8.4 2.5 2.5c4.5-1.8 30.3 3.4 40.8 16l-23.6-2.5c39.4 23 51.5 54 55.8 69.6l1.7-1.2c-2.8-22.3-12.4-33.9-16-40.1 4.2 5 39.2 34.6 110.4 46-11.3-.5-23.1 5.4-34.9 18.9l46.7-20.2-9.3 21.9c7.6-10.1 14.8-23.6 21.2-39.6l0-.5 1.2-3-1.2 16c13.5-41.8 25.3-78.5 35.4-109.7l13.5-27.8 0-2-5.4-4.2 10.1 0 5.9 4.2 2.5-1.2-3.4-16 12.3 18.9 41.8-20.2-14.8 13 .5 2.9 17.7-.5c11.1 .4 22.1 1.8 33 4.2l-23.6 2.5-1.2 3 26.6 23.1c9.9 9.9 18.9 20.6 27 32-11.2-3.3-10.3-3.4-21.2-3.4l12.3 32.5-8.9-12.8zm-6.1-71.3l-3.9 13-14.3-11.8 18.2-1.2zm-254.8 7.1c1.7 10.6 4.7 17.7 8.8 21.9-9.3 6.6-27.5 13.9-46.5 16l.5 1.2c8.3 1.3 16.9 .4 24.8-2.5l-7.1 13c4.2-1.7 10.1-7.1 17.7-14.8 11.9-5.5 12.7-5.1 20.2-16-12.7-6.4-15.7-13.7-18.4-18.8zm3.7-102.3c-6.4-3.4-10.6 3-12.3 18.9s2.5 29.5 11.8 39.6 18.2 10.6 26.1 3 3.4-23.6-11.3-47.7c-3.5-5.7-8.4-10.5-14.3-13.8l0 0zm-4.7 46.3c5.4 2.2 10.5 1.9 12.3-10.6l0-4.7-1.2 .5c-4.3-3.1-2.5-4.5-1.7-6.2l.5-.5c-.9-1.2-5-8.1-12.5 4.7-.5-13.5 .5-21.9 3-24.8 1.2-2.5 4.7-1.2 11.3 4.2 6.4 5.4 11.3 16 15.2 32.5 6.5 28-19.8 26.2-26.9 4.9zm-45-5.5c1.6 .3 9.3-1.1 9.3-14.8l-.5 0c-5.4-1.1-2.2-5.5-.7-5.9-1.7-3-3.4-4.2-5.4-4.7-8.1 0-11.6 12.7-8.1 21.2 .5 1.1 1.3 2 2.2 2.8s2 1.2 3.2 1.4l0 0zm40.1-50.1l-2.5 .5 .5 3c9.1-.5 18.1 1.5 26.1 5.9-2.5-5.5-10-14.3-28.3-14.3l.5 2.5 3.7 2.4zm-71.8 49.4c21.7 16.8 16.5 21.4 46.5 23.6l-2.9-4.7c8.4-7.2 13.7-17.3 14.8-28.3 1.7-16-1.2-29.5-8.8-41.3l13-7.6c0-.3 0-.6-.1-.9s-.2-.6-.4-.8c-2.2-.9-4.6-1.2-7-.9s-4.6 1.2-6.5 2.6c-12.7 6.7-28 20.9-29 22.4-1.7 1.7-3.4 5.9-5.4 13.5-1.9 7.7-2.9 15.6-2.9 23.6-4.7-8-10.5-6.4-19.9-5.9l7.1 7.6c-16.5 0-23.3 15.4-23.6 16 6.8 0 4.6-7.6 30-12.3-4.3-6.3-3.3-5-4.9-6.6zm18.7-18.7c1.2-7.6 3.4-13 6.4-17.2 5.4-6.4 10.6-10.1 16-11.8 4.2-1.7 7.1 1.2 10.1 9.3 2.5 8.2 3.5 16.8 3 25.3-.5 9.3-3.4 17.2-8.4 23.1-2.9 3.4-5.4 5.9-6.4 7.6-3.8 .4-7.6 .2-11.3-.5l-7.1-3.4-5.4-6.4c.8-10 1.3-18.8 3.1-26zm42 56.1c-34.8 14.4-34.7 14-36.1 14.3-20.8 4.7-19-24.4-18.9-24.8l5.9-1.2-.5-2.5c-20.2-2.6-31 4.2-32.5 4.9 .5 .5 3 3.4 5.9 9.3 4.2-6.4 8.8-10.1 15.2-10.6-1.7 11.2-1.2 22.7 1.7 33.7 .1 .5 2.6 17.4 27.5 24.1 11.3 3 27 1.2 48.9-5.4l-9.2 .5c-4.2-14.8-6.4-24.8-5.9-29.5 11.3-8.8 21.9-11.3 30.7-7.6l2.5 0-11.8-7.6-7.1 .5c-5.9 1.2-12.3 4.2-19.4 8.4l3.1-6.5z"],
    "jira": [512, 512, [], "f7b1", "M498.5 241.7c-72.9-72.7-169.4-169.9-241.5-241.7-165.5 164.9-242.5 241.7-242.5 241.7-7.9 7.9-7.9 20.7 0 28.7 132.8 132.3 61.8 61.5 242.5 241.6 379.4-378 15.7-16.7 241.5-241.7 8-7.9 8-20.7 0-28.6zM257 331.7l-76-75.7 76-75.7 76 75.7-76 75.7z"],
    "fedex": [640, 512, [], "f797", "M586 284.5l53.3-59.9-62.4 0-21.7 24.8-22.5-24.8-118.7 0 0-16 56.1 0 0-48.1-151.2 0 0 75.5-.5 0c-9.6-11-21.5-14.8-35.4-14.8-28.4 0-49.8 19.4-57.3 44.9-18-59.4-97.4-57.6-121.9-14l0-24.2-54.8 0 0-26.2 60 0 0-41.1-109 0 0 184.4 49 0 0-77.5 48.9 0c-1.5 5.7-2.3 11.8-2.3 18.2 0 73.1 102.6 91.4 130.2 23.7l-42 0c-14.7 20.9-45.8 8.9-45.8-14.6l85.5 0c3.7 30.5 27.4 56.9 60.1 56.9 14.1 0 27-6.9 34.9-18.6l.5 0 0 11.9 212.2 0 22.1-25 22.3 25 64.4 0-54-60.5zM139.3 267.9c6.1-26.3 41.7-25.6 46.5 0l-46.5 0zm153.4 48.9c-34.6 0-34-62.8 0-62.8 32.6 0 34.5 62.8 0 62.8zm167.8 19.1l-94.4 0 0-166.5 95 0 0 30.2-56.1 0 0 33.9 55.5 0 0 28.1-56.1 0 0 44.7 56.1 0 0 29.6zm-45.9-39.8l0-24.4 56.1 0 0-44 50.7 57-50.7 57 0-45.6-56.1 0zm138.6 10.3l-26.1 29.5-38.1 0 45.6-51.2-45.6-51.2 39.7 0 26.6 29.3 25.6-29.3 38.5 0-45.4 51 46 51.4-40.5 0-26.3-29.5z"],
    "evernote": [384, 512, [], "f839", "M121.1 132.2c1.6 22.3-17.6 21.6-21.6 21.6-68.9 0-73.6-1-83.6 3.3-.6 .2-.7 0-.4-.4L124.1 46.4c.4-.4 .6-.2 .4 .4-4.4 10-3.4 15.1-3.4 85.4zm79 308c-14.7-37.1 13-76.9 52.5-76.6 17.5 0 22.6 23.2 7.9 31.4-6.2 3.3-24.9 1.7-25.1 19.2 0 17.1 19.7 25 31.2 24.9 6 0 11.9-1.2 17.5-3.5s10.6-5.7 14.8-9.9 7.6-9.3 9.9-14.8 3.5-11.5 3.5-17.5l0-.1c0-11.6-7.8-47.2-47.5-55.3-7.7-1.5-65-6.3-68.4-50.5-3.7 16.9-17.4 63.5-43.1 69.1-8.7 1.9-69.7 7.6-112.9-36.8 0 0-18.6-15.2-28.2-58-3.4-15.7-9.3-39.7-11.1-62 0-18 11.1-30.4 25.1-32.2 81 0 90 2.3 101-7.8 9.8-9.2 7.8-15.5 7.8-102.8 1-8.3 7.8-30.8 53.4-24.1 6 .9 31.9 4.2 37.5 30.6L290 74.8c20.4 3.7 70.9 7 80.6 57.9 22.7 121.1 8.9 238.5 7.8 238.5-16 114.4-111.1 108.9-111.1 108.9-19-.2-54.2-9.4-67.3-39.8l0 0zM281 235.4c-1 1.9-2.2 6 .9 7 14.1 4.9 39.8 6.8 45.9 5.5 3.1-.2 3.1-4.4 2.5-6.6-3.5-21.8-40.8-26.5-49.2-5.9l0 0z"],
    "usb": [640, 512, [], "f287", "M633.5 256c0 3.1-1.7 6.1-4.5 7.5L539.9 317c-1.4 .8-2.8 1.4-4.5 1.4-1.4 0-3.1-.3-4.5-1.1-2.8-1.7-4.5-4.5-4.5-7.8l0-35.6-230.7 0c25.3 39.6 40.5 106.9 69.6 106.9l26.7 0 0-26.8c0-5 3.9-8.9 8.9-8.9l89.1 0c5 0 8.9 3.9 8.9 8.9l0 89.1c0 5-3.9 8.9-8.9 8.9l-89.1 0c-5 0-8.9-3.9-8.9-8.9l0-26.7-26.7 0c-75.4 0-81.1-142.5-124.7-142.5l-100.3 0c-8.1 30.6-35.9 53.5-69 53.5-39.3-.1-71.3-32.1-71.3-71.4s32-71.3 71.3-71.3c33.1 0 61 22.8 69 53.5 39.1 0 43.9 9.5 74.6-60.4 40.1-89.1 58.1-82.1 108.9-82.1 7.5-20.9 27-35.6 50.4-35.6 29.5 0 53.5 23.9 53.5 53.5s-23.9 53.5-53.5 53.5c-23.4 0-42.9-14.8-50.4-35.6l-29.8 0c-29.1 0-44.3 67.4-69.6 106.9l302.1 0 0-35.6c0-3.3 1.7-6.1 4.5-7.8s6.4-1.4 8.9 .3L629 248.8c2.8 1.1 4.5 4.1 4.5 7.2z"],
    "angrycreative": [640, 512, [], "f36e", "M640 238.2l-3.2 28.2-34.5 2.3-2 18.1 34.5-2.3-3.2 28.2-34.4 2.2-2.3 20.1 34.4-2.2-3 26.1-64.7 4.1 12.7-113.2-47.3 115.4-31.9 2-23.8-117.8 30.3-2 13.6 79.4 31.7-82.4 93.1-6.2zM426.8 371.5l28.3-1.8 12.9-120.1-28.4 1.9-12.8 120zM162 388.1l-19.4-36-3.5 37.4-28.2 1.7 2.7-29.1c-11 18-32 34.3-56.9 35.8-32.8 2-59.7-20.9-56.4-58.2 2.6-29.3 26.7-62.8 67.5-65.4 37.7-2.4 47.6 23.2 51.3 28.8l2.8-30.8 38.9-2.5c20.1-1.3 38.7 3.7 42.5 23.7l2.6-26.6 64.8-4.2-2.7 27.9-36.4 2.4-1.7 17.9 36.4-2.3-2.7 27.9-36.4 2.3-1.9 19.9 36.3-2.3-2.1 20.8 55-117.2 23.8-1.6 32.1 110.6 8.9-85.6-22.3 1.4 2.9-27.9 75-4.9-3 28-24.3 1.6-9.7 91.9-58 3.7-4.3-15.6-39.4 2.5-8 16.3-126.2 7.7zm-44.3-70.2l-26.4 1.7c-6.7-12.4-14.4-16.6-26.3-15.8-19 1.2-33.3 17.5-34.6 33.3-1.4 16 7.3 32.5 28.7 31.2 12.8-.8 21.3-8.6 28.9-18.9l27-1.7 2.7-29.8zm56.1-7.7c1.2-12.9-7.6-13.6-26.1-12.4L145 326.3c14.2-.9 27.5-2.1 28.8-16.1zM194.9 381l5.8-60c-5 13.5-14.7 21.1-27.9 26.6L194.9 381zm135.4-45l-7.9-37.8-15.8 39.3 23.7-1.5zM160.2 261.4l-4.3-17.5-39.6 2.6-8.1 18.2-31.9 2.1 57-121.9 23.9-1.6 30.7 102 9.9-104.7 27-1.8 37.8 63.6 6.5-66.6 28.5-1.9-4 41.2c7.4-13.5 22.9-44.7 63.6-47.5 40.5-2.8 52.4 29.3 53.4 30.3l3.3-32 39.3-2.7c12.7-.9 27.8 .3 36.3 9.7l-4.4-11.9 32.2-2.2 12.9 43.2 23-45.7 31-2.2-43.6 78.4-4.8 44.3-28.4 1.9 4.8-44.3-15.8-43c1 22.3-9.2 40.1-32 49.6l25.2 38.8-36.4 2.4-19.2-36.8-4 38.3-28.4 1.9 3.3-31.5c-6.7 9.3-19.7 35.4-59.6 38-26.2 1.7-45.6-10.3-55.4-39.2l-4 40.3-25 1.6-37.6-63.3-6.3 66.2-56.8 3.7zm276.6-82.1c10.2-.7 17.5-2.1 21.6-4.3 4.5-2.4 7-6.4 7.6-12.1 .6-5.3-.6-8.8-3.4-10.4-3.6-2.1-10.6-2.8-22.9-2l-2.9 28.8zM327.7 214c5.6 5.9 12.7 8.5 21.3 7.9 4.7-.3 9.1-1.8 13.3-4.1 5.5-3 10.6-8 15.1-14.3l-34.2 2.3 2.4-23.9 63.1-4.3 1.2-12-31.2 2.1c-4.1-3.7-7.8-6.6-11.1-8.1-4-1.7-8.1-2.8-12.2-2.5-8 .5-15.3 3.6-22 9.2-7.7 6.4-12 14.5-12.9 24.4-1.1 9.6 1.4 17.3 7.2 23.3zm-201.3 8.2l23.8-1.6-8.3-37.6-15.5 39.2z"],
    "mizuni": [512, 512, [], "f3cc", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM176 359.9c-31.4 10.6-58.8 27.3-80 48.2L96 136c0-22.1 17.9-40 40-40s40 17.9 40 40l0 223.9zM296 350c-12.9-2-26.2-3.1-39.8-3.1-13.8 0-27.2 1.1-40.2 3.1l0-214c0-22.1 17.9-40 40-40s40 17.9 40 40l0 214zm120 57.7c-21.2-20.8-48.6-37.4-80-48L336 136c0-22.1 17.9-40 40-40s40 17.9 40 40l0 271.7z"],
    "itch-io": [512, 512, [], "f83a", "M71.9 34.8C50.2 47.7 7.4 96.8 7 109.7l0 21.3c0 27.1 25.3 50.8 48.2 50.8 27.6 0 50.5-22.8 50.5-50 0 27.1 22.2 50 49.8 50s49-22.8 49-50c0 27.1 23.6 50 51.2 50l.5 0c27.6 0 51.2-22.8 51.2-50 0 27.1 21.5 50 49 50s49.8-22.8 49.8-50c0 27.1 23 50 50.5 50 23 0 48.3-23.8 48.3-50.8l0-21.3c-.4-12.9-43.2-62.1-64.9-75-67.4-2.3-114.2-2.7-184-2.7S91.1 33.1 71.9 34.8zM204.2 169.2c-22 38.4-77.9 38.7-99.8 .2-13.2 23.1-43.2 32.1-56 27.7-3.9 40.2-13.7 237.1 17.7 269.2 80 18.7 302.1 18.1 379.8 0 31.6-32.3 21.3-232 17.7-269.2-12.9 4.4-42.9-4.6-56-27.7-22 38.5-77.8 38.1-99.8-.2-7.1 12.5-23 28.9-51.8 28.9-10.4 .3-20.8-2.2-29.9-7.3s-16.7-12.6-21.9-21.6l0 0zm-41.6 53.8c16.5 0 31.1 0 49.2 19.8 29.3-3 58.9-3 88.2 0 18.2-19.7 32.8-19.7 49.2-19.7 52.3 0 65.2 77.5 83.9 144.4 17.3 62.2-5.5 63.7-34 63.7-42.1-1.6-65.5-32.2-65.5-62.8-39.3 6.4-101.9 8.8-155.6 0 0 30.6-23.3 61.2-65.5 62.8-28.4-.1-51.2-1.6-33.9-63.7 18.7-67 31.6-144.4 83.9-144.4l0-.1zM256 270.8s-44.4 40.8-52.4 55.2l29-1.2 0 25.3c0 1.5 21.3 .2 23.3 .2 11.6 .5 23.3 1 23.3-.2l0-25.3 29 1.2c-8-14.5-52.4-55.2-52.4-55.2l.1 0z"],
    "windows": [448, 512, [], "f17a", "M0 93.7l183.6-25.3 0 177.4-183.6 0 0-152.1zM0 418.3l183.6 25.3 0-175.2-183.6 0 0 149.9zm203.8 28l244.2 33.7 0-211.6-244.2 0 0 177.9zm0-380.6l0 180.1 244.2 0 0-213.8-244.2 33.7z"],
    "stumbleupon": [512, 512, [], "f1a4", "M502.9 266l0 69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3l0-70.2 34.3 16 51.1-15.2 0 70.6c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338l0-72 85.9 0zM278.2 207.8l34.3 16 51.1-15.2 0-35.6c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2l0 162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6l0-68.6-86 0 0 69.7c0 62 50.3 112.3 112.4 112.3 61.6 0 112.4-49.5 112.4-110.8l0-160.3c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7l0 30.9z"],
    "google": [512, 512, [], "f1a0", "M500 261.8C500 403.3 403.1 504 260 504 122.8 504 12 393.2 12 256S122.8 8 260 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9c-88.3-85.2-252.5-21.2-252.5 118.2 0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9l-140.8 0 0-85.3 236.1 0c2.3 12.7 3.9 24.9 3.9 41.4z"],
    "discord": [576, 512, [], "f392", "M492.5 69.8c-.2-.3-.4-.6-.8-.7-38.1-17.5-78.4-30-119.7-37.1-.4-.1-.8 0-1.1 .1s-.6 .4-.8 .8c-5.5 9.9-10.5 20.2-14.9 30.6-44.6-6.8-89.9-6.8-134.4 0-4.5-10.5-9.5-20.7-15.1-30.6-.2-.3-.5-.6-.8-.8s-.7-.2-1.1-.2c-41.3 7.1-81.6 19.6-119.7 37.1-.3 .1-.6 .4-.8 .7-76.2 113.8-97.1 224.9-86.9 334.5 0 .3 .1 .5 .2 .8s.3 .4 .5 .6c44.4 32.9 94 58 146.8 74.2 .4 .1 .8 .1 1.1 0s.7-.4 .9-.7c11.3-15.4 21.4-31.8 30-48.8 .1-.2 .2-.5 .2-.8s0-.5-.1-.8-.2-.5-.4-.6-.4-.3-.7-.4c-15.8-6.1-31.2-13.4-45.9-21.9-.3-.2-.5-.4-.7-.6s-.3-.6-.3-.9 0-.6 .2-.9 .3-.5 .6-.7c3.1-2.3 6.2-4.7 9.1-7.1 .3-.2 .6-.4 .9-.4s.7 0 1 .1c96.2 43.9 200.4 43.9 295.5 0 .3-.1 .7-.2 1-.2s.7 .2 .9 .4c2.9 2.4 6 4.9 9.1 7.2 .2 .2 .4 .4 .6 .7s.2 .6 .2 .9-.1 .6-.3 .9-.4 .5-.6 .6c-14.7 8.6-30 15.9-45.9 21.8-.2 .1-.5 .2-.7 .4s-.3 .4-.4 .7-.1 .5-.1 .8 .1 .5 .2 .8c8.8 17 18.8 33.3 30 48.8 .2 .3 .6 .6 .9 .7s.8 .1 1.1 0c52.9-16.2 102.6-41.3 147.1-74.2 .2-.2 .4-.4 .5-.6s.2-.5 .2-.8c12.3-126.8-20.5-236.9-86.9-334.5zm-302 267.7c-29 0-52.8-26.6-52.8-59.2s23.4-59.2 52.8-59.2c29.7 0 53.3 26.8 52.8 59.2 0 32.7-23.4 59.2-52.8 59.2zm195.4 0c-29 0-52.8-26.6-52.8-59.2s23.4-59.2 52.8-59.2c29.7 0 53.3 26.8 52.8 59.2 0 32.7-23.2 59.2-52.8 59.2z"],
    "hacker-news": [448, 512, [], "f1d4", "M0 32l0 448 448 0 0-448-448 0zM21.2 229.2l-.2 0c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4zm218 53.9l0 100.9-31.4 0 0-102.7-79.8-153.3 37.3 0c52.5 98.3 49.2 101.2 59.3 125.6 12.3-27 5.8-24.4 60.6-125.6l34.8 0-80.8 155.1z"],
    "eleventy": [640, 512, ["11ty"], "e7d6", "M615.3 168.5c2.3 0 4.6 .7 6.6 2.2 1.9 1.4 3.1 3.3 3.8 5 1.4 3.3 1.8 7.3 1.8 11.3 0 2.2-.3 4.9-.7 7.6l0 .4-50.9 264.9 0 0c-4 22.1-8.5 39.4-13.6 51.7-5 12.1-10.9 21.6-18.6 27l0 0c-7.5 5.3-16.9 7.7-27.6 8l-3 0c-16 0-29.3-4.2-36.9-14.8-.1-.1-.1-.1-.2-.2-.1-.2-.3-.4-.5-.6l0 0c-1.8-2.4-2.5-5.2-2.9-7.4-.5-2.8-.7-6.1-.7-9.8 0-7.3 .6-13.5 2.1-18.2 1.4-4.4 4.8-10.4 12.2-10.4l1.3 .1c.2 0 .4 .1 .5 .1 .3 .1 .6 .1 .8 .2 .6 .1 1.3 .3 2.2 .6l7.6 2.2 .1 0 7.6 2.1c.9 .2 1.7 .4 2.2 .5 .4 .1 .6 .1 .7 .1 0 0 .1 0 .2-.1 .1-.1 .4-.2 .8-.6 .9-.9 2.2-2.6 3.6-5.7 2.6-5.8 4.2-14.7 4.2-27.4 0-.7-.3-3.4-1.3-8.9-.9-5.1-2.3-12.2-4.2-21.1l-56-232.9-.1-.4 0-.3c-.4-2.7-.7-5.3-.7-7.3 0-3.7 .4-7.5 1.7-10.6 .7-1.6 1.8-3.4 3.5-4.9 1.9-1.5 4.2-2.3 6.5-2.3l34.6 0c4.6 0 8.7 1.7 11.9 5l1.3 1.5c1.2 1.6 2 3.4 2.7 5.2 .9 2.4 1.5 5.1 2 8.1l30.4 161.2 23.8-160c.8-5.8 2.2-11.4 5.1-15.1 3-3.8 7.2-5.8 12-5.8l24 0zM375.1 34.6c2.6 0 5.1 .7 7.4 2.3 2.2 1.5 3.7 3.6 4.7 5.7 1.9 4 2.5 9.1 2.5 14.5l0 111.2c0 .1 0 .2 0 .3l32.4 0c2.5 0 5 .6 7.2 2.1 2.2 1.4 3.7 3.4 4.8 5.5 2 3.9 2.6 8.8 2.6 13.9l0 15.4c0 5-.6 9.8-2.6 13.7-1.1 2-2.6 4-4.8 5.4-2.2 1.4-4.7 2-7.1 2l-32.5 0 0 145.8c0 10.8 .7 19.5 2 26.2 1.4 6.9 3.1 10.9 4.7 12.9 1.2 1.5 2.2 2.5 3.1 3.2l2.2 1.4 .1 .1 2.9 .8c1.2 .2 2.6 .3 4.3 .3l20.3 0c4.5 0 8.9 1.7 11.8 5.8 2.6 3.6 3.3 8.1 3.3 12.2l0 17.2c0 4.5-.8 9.3-3.4 13.1-3 4.2-7.5 6-12.3 6l0 0-29.1 .1c-8 0-15-.6-21.2-1.7-6.7-1.3-13.4-4.1-20.1-8.1-7.2-4.4-13-10.3-17.5-17.8-4.5-7.5-7.9-17.5-10.5-29.5-2.6-12.2-3.9-26.6-3.9-43l0-144.9-13.4 0c-2.4 0-4.9-.6-7.1-2-2.2-1.4-3.7-3.4-4.8-5.4-2-3.9-2.6-8.7-2.6-13.7l0-15.4c0-5.1 .6-10 2.6-13.9 1.1-2.1 2.6-4 4.8-5.5 2.2-1.5 4.7-2.1 7.2-2.1l13.4 0 0-.6 5.2-111.2 0-.1 .3-3.9c.5-3.8 1.3-7.4 2.7-10.3 2.1-4.2 6-7.9 11.8-7.9l28.6 0zm-268 11.7c1.8 .3 3.6 .9 5.3 2.1 2.1 1.5 3.5 3.5 4.4 5.4 1.7 3.7 2.3 8.4 2.3 13.2l0 377.8c0 6.7-.6 12.6-2.4 17.1-.9 2.3-2.3 4.7-4.4 6.5-2.3 2-5.1 3-8.1 3l-43.7 0c-3 0-5.8-1.1-8.1-3.1-2.1-1.9-3.4-4.3-4.2-6.5-1.7-4.5-2.3-10.3-2.3-17l0-315.8c-4.8 1.2-8.7 2.2-11.5 2.9-1.9 .5-3.4 .8-4.4 1.1-.5 .1-.9 .2-1.2 .3-.1 0-.3 .1-.5 .1-.1 0-.2 0-.3 .1 0 0-.2 0-.3 0 0 0-.2 0-.4 0l0 0c-.1 0-.3 0-.4 0-.1 0-.2 0-.2 0-2.2 .1-4.5-.4-6.6-1.7-2.3-1.4-3.8-3.4-4.7-5.3-1.8-3.7-2.3-8.4-2.3-13l0-27.4c0-4.4 .7-8.8 2.6-12.4 2.1-3.9 5.5-6.6 9.8-7.6l75.5-19.5c1.4-.4 2.9-.5 4.4-.5l1.8 .1zm143.8-.5c1.8 .3 3.6 .9 5.2 2.1 2.1 1.5 3.5 3.5 4.4 5.4 1.7 3.7 2.2 8.4 2.2 13.2l0 377.8c0 6.7-.6 12.6-2.4 17.1-.9 2.3-2.3 4.7-4.4 6.5-2.3 2-5.1 3-8.1 3l-43.7 0c-3 0-5.8-1.1-8.1-3.1-2.1-1.9-3.4-4.3-4.2-6.5-1.7-4.5-2.3-10.3-2.3-17l0-315.8c-4.8 1.2-8.7 2.2-11.5 2.9-1.9 .5-3.4 .8-4.4 1.1-.5 .1-.9 .2-1.2 .3-.1 0-.3 .1-.5 .1-.1 0-.2 0-.3 .1-.1 0-.2 0-.3 0 0 0-.2 0-.4 0l0 0c-.1 0-.2 0-.3 0-.1 0-.2 0-.3 0-2.2 .1-4.5-.4-6.6-1.7-2.3-1.4-3.8-3.4-4.7-5.3-1.8-3.7-2.3-8.3-2.3-13l0-27.4c0-4.4 .7-8.7 2.6-12.4 2.1-3.9 5.5-6.6 9.8-7.6l75.4-19.4c1.4-.4 2.9-.5 4.4-.5l1.8 .1z"],
    "teamspeak": [576, 512, [], "f4f9", "M152.8 37.2c-32.2 38.1-56.1 82.6-69.9 130.5 0 .2-.1 .3-.1 .5-39.3 16.2-66.8 54.8-66.8 99.8 0 59.6 48.4 108 108 108s108-48.4 108-108c0-53.5-38.9-97.9-90-106.5 15.7-41.8 40.4-79.6 72.3-110.7 1.8-1.6 4-2.6 6.3-3.1 37.2-11.5 76.7-13.3 114.8-5.2 119.3 25.1 198.6 138.2 181.7 258.8-8.4 62.6-38.6 112.7-87.7 151.4-50.1 39.7-107.5 54.3-170.2 52.2l-24-1c12.4 2.8 25 4.9 37.6 6.3 40.7 4.2 81.4 2.1 120.1-12.5 94-35.5 149.3-102.3 162.9-202.5 4.8-52.6-5.8-105.4-30.8-152-70.4-131.9-234.2-181.6-366-111.2-2.4 1.4-4.5 3.1-6.3 5.2l.1 0zM309.4 433.9c-2.1 11.5-4.2 21.9-14.6 31.3 53.2-1 123.2-29.2 161.8-97.1 39.7-69.9 37.6-139.9-6.3-207.8-36.5-55.3-89.8-82.4-156.6-86.6 1.5 2.3 3.2 4.4 5.2 6.3l5.2 6.3c25.1 31.3 37.6 67.9 42.8 107.5 2.1 15.7-1 30.3-13.6 41.8-4.2 3.1-5.2 6.3-4.2 10.4l7.3 17.7 29.3 54.3c5.2 11.5 4.2 19.8-6.3 28.2-3.2 2.5-6.7 4.6-10.4 6.3l-18.8 8.4 3.1 13.6c3.1 6.3 1 12.5-3.1 17.7-2.5 2.4-3.8 5.9-3.1 9.4 2.1 11.5-2.1 19.8-12.5 25.1-2.1 1-4.2 5.2-5.2 7.3l0-.1zm-133.6-3.1c16.7 11.5 34.5 20.9 53.2 26.1 24 5.2 41.8-6.3 44.9-30.3 1-8.4 5.2-14.6 12.5-17.7 7.3-4.2 8.4-7.3 2.1-13.6l-9.4-8.4 13.6-4.2c6.3-2.1 7.3-5.2 5.2-11.5-1.4-3-2.4-6.2-3.1-9.4-3.1-14.6-2.1-15.7 11.5-18.8 8.4-3.1 15.7-6.3 21.9-12.5 3.1-2.1 3.1-4.2 1-8.4l-16.7-30.3c-1-1.9-2.1-3.8-3.1-5.7-6.4-11.7-13-23.6-15.7-37.1-2.1-9.4-1-17.7 8.4-24 5.2-4.2 8.4-9.4 8.4-16.7-.4-10.1-1.5-20.3-3.1-30.3-6.3-37.6-23-68.9-51.2-95-5.2-4.2-9.4-6.3-16.7-4.2l-35.6 12.7 6 3.6c6.3 3.7 12.2 7.3 17 12.1 30.3 26.1 41.8 61.6 45.9 100.2 1 8.4 0 16.7-7.3 21.9-8.4 5.2-10.4 12.5-7.3 20.9 4.9 13.2 10.4 26 16.7 38.6L291.6 318c-6.3 8.4-13.6 11.5-21.9 14.6-12.5 3.1-14.6 7.3-10.4 20.9 .6 1.5 1.4 2.8 2.1 4.2 2.1 5.2 1 8.4-4.2 10.4l-12.5 3.1 5.2 4.2 4.2 4.2c4.2 5.2 4.2 8.4-2.1 10.4-7.3 4.2-11.5 9.4-11.5 17.7 0 12.5-7.3 19.8-18.8 24-3.8 1-7.6 1.5-11.5 1l-34.5-2.1 .1 .2z"],
    "supple": [640, 512, [], "f3f9", "M640 262.5c0 64.1-109 116.1-243.5 116.1-24.8 0-48.6-1.8-71.1-5 7.7 .4 15.5 .6 23.4 .6 134.5 0 243.5-56.9 243.5-127.1 0-29.4-19.1-56.4-51.2-78 60 21.1 98.9 55.1 98.9 93.4zM47.7 227.9c-.1-70.2 108.8-127.3 243.3-127.6 7.9 0 15.6 .2 23.3 .5-22.5-3.2-46.3-4.9-71-4.9-134.5 .4-243.4 52.6-243.3 116.7 .1 38.3 39.1 72.3 99.3 93.3-32.3-21.5-51.5-48.6-51.6-78zm60.2 39.9S118.4 281 137.2 281c17.9 0 28.4-11.5 28.4-25.1 0-28-40.2-25.1-40.2-39.7 0-5.4 5.3-9.1 12.5-9.1 5.7 0 11.3 2.6 11.3 6.6l0 3.9 14.2 0 0-7.9c0-12.1-15.4-16.8-25.4-16.8-16.5 0-28.5 10.2-28.5 24.1 0 26.6 40.2 25.4 40.2 39.9 0 6.6-5.8 10.1-12.3 10.1-11.9 0-20.7-10.1-20.7-10.1l-8.8 10.9zm120.8-73.6l0 54.4c0 11.3-7.1 17.8-17.8 17.8s-17.8-6.5-17.8-17.7l0-54.5-15.8 0 0 55c0 18.9 13.4 31.9 33.7 31.9 20.1 0 33.4-13 33.4-31.9l0-55-15.7 0zm34.4 85.4l15.8 0 0-29.5 15.5 0c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8l-39.1 0 0 13.4 7.8 0 0 72zm15.8-43l0-29.1 12.9 0c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5.1 14.7-14 14.7l-12.6 0zm57 43l15.8 0 0-29.5 15.5 0c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8l-39.1 0 0 13.4 7.8 0 0 72zm15.7-43l0-29.1 12.9 0c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5 14.7-14 14.7l-12.6 0zm57.1 34.8c0 5.8 2.4 8.2 8.2 8.2l37.6 0c5.8 0 8.2-2.4 8.2-8.2l0-13-14.3 0 0 5.2c0 1.7-1 2.6-2.6 2.6l-18.6 0c-1.7 0-2.6-1-2.6-2.6l0-61.2c0-5.7-2.4-8.2-8.2-8.2l-15.4 0 0 13.4 5.2 0c1.7 0 2.6 1 2.6 2.6l0 61.2-.1 0zm63.4 0c0 5.8 2.4 8.2 8.2 8.2l38.7 0c5.7 0 8.2-2.4 8.2-8.2l0-13-14.3 0 0 5.2c0 1.7-1 2.6-2.6 2.6l-19.7 0c-1.7 0-2.6-1-2.6-2.6l0-20.3 27.7 0 0-13.4-27.7 0 0-22.4 19.2 0c1.7 0 2.6 1 2.6 2.6l0 5.2 14.2 0 0-13c0-5.7-2.5-8.2-8.2-8.2l-51.6 0 0 13.4 7.8 0 0 63.9 .1 0zm58.9-76l0 5.9 1.6 0 0-5.9 2.7 0 0-1.2-7 0 0 1.2 2.7 0zm5.7-1.2l0 7.1 1.5 0 0-5.7 2.3 5.7 1.3 0 2.3-5.7 0 5.7 1.5 0 0-7.1-2.3 0-2.1 5.1-2.1-5.1-2.4 0z"],
    "square-twitter": [448, 512, ["twitter-square"], "f081", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM351.3 199.3c0 86.7-66 186.6-186.6 186.6-37.2 0-71.7-10.8-100.7-29.4 5.3 .6 10.4 .8 15.8 .8 30.7 0 58.9-10.4 81.4-28-28.8-.6-53-19.5-61.3-45.5 10.1 1.5 19.2 1.5 29.6-1.2-30-6.1-52.5-32.5-52.5-64.4l0-.8c8.7 4.9 18.9 7.9 29.6 8.3-9-6-16.4-14.1-21.5-23.6s-7.8-20.2-7.7-31c0-12.2 3.2-23.4 8.9-33.1 32.3 39.8 80.8 65.8 135.2 68.6-9.3-44.5 24-80.6 64-80.6 18.9 0 35.9 7.9 47.9 20.7 14.8-2.8 29-8.3 41.6-15.8-4.9 15.2-15.2 28-28.8 36.1 13.2-1.4 26-5.1 37.8-10.2-8.9 13.1-20.1 24.7-32.9 34 .2 2.8 .2 5.7 .2 8.5z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0 0-64 373.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96z"],
    "wirsindhandwerk": [448, 512, ["wsh"], "e2d0", "M18.9 479.8l83.4 0 0-112-83.4 47 0 65zm329 0l82.4 0 0-65-82.4-47 0 112zm0-448l0 219.8-123.6-72.4-121.7 72.4 0-219.8-83.7 0 0 360.8 205.4-122.3 206 122.3 0-360.8-82.3 0z"],
    "confluence": [512, 512, [], "f78d", "M2.8 412.2c-4.5 7.6-2.1 17.5 5.5 22.2l105.9 65.2c7.7 4.7 17.7 2.4 22.4-5.3 0-.1 .1-.2 .1-.2 67.1-112.2 80.5-95.9 280.9-.7 8.1 3.9 17.8 .4 21.7-7.7 .1-.1 .1-.3 .2-.4l50.4-114.1c3.6-8.1-.1-17.6-8.1-21.3-22.2-10.4-66.2-31.2-105.9-50.3-247.9-120.6-330.8 45.7-373.1 112.6zM510.2 100.1c4.5-7.6 2.1-17.5-5.5-22.2L398.9 12.8c-7.5-5-17.6-3.1-22.6 4.4-.2 .3-.4 .6-.6 1-67.3 112.6-81.1 95.6-280.6 .9-8.1-3.9-17.8-.4-21.7 7.7-.1 .1-.1 .3-.2 .4L22.7 141.3c-3.6 8.1 .1 17.6 8.1 21.3 22.2 10.4 66.3 31.2 106 50.4 248 120 330.8-45.4 373.4-112.9z"],
    "digg": [512, 512, [], "f1a6", "M81.7 172.3l-81.7 0 0 174.4 132.7 0 0-250.7-51 0 0 76.3zm0 133.4l-30.8 0 0-92.3 30.8 0 0 92.3zM378.9 172.3l0 174.4 81.8 0 0 28.5-81.8 0 0 40.8 133.1 0 0-243.7-133.1 0zm81.8 133.4l-30.8 0 0-92.3 30.8 0 0 92.3zm-235.6 41l82.1 0 0 28.5-82.1 0 0 40.8 133.3 0 0-243.7-133.3 0 0 174.4zm51.2-133.3l30.8 0 0 92.3-30.8 0 0-92.3zM153.3 96l51.3 0 0 51-51.3 0 0-51zm0 76.3l51.3 0 0 174.4-51.3 0 0-174.4z"],
    "threads": [448, 512, [], "e618", "M331.5 235.7c2.2 .9 4.2 1.9 6.3 2.8 29.2 14.1 50.6 35.2 61.8 61.4 15.7 36.5 17.2 95.8-30.3 143.2-36.2 36.2-80.3 52.5-142.6 53l-.3 0c-70.2-.5-124.1-24.1-160.4-70.2-32.3-41-48.9-98.1-49.5-169.6l0-.5C17 184.3 33.6 127.2 65.9 86.2 102.2 40.1 156.2 16.5 226.4 16l.3 0c70.3 .5 124.9 24 162.3 69.9 18.4 22.7 32 50 40.6 81.7l-40.4 10.8c-7.1-25.8-17.8-47.8-32.2-65.4-29.2-35.8-73-54.2-130.5-54.6-57 .5-100.1 18.8-128.2 54.4-26.2 33.3-39.8 81.5-40.3 143.2 .5 61.7 14.1 109.9 40.3 143.3 28 35.6 71.2 53.9 128.2 54.4 51.4-.4 85.4-12.6 113.7-40.9 32.3-32.2 31.7-71.8 21.4-95.9-6.1-14.2-17.1-26-31.9-34.9-3.7 26.9-11.8 48.3-24.7 64.8-17.1 21.8-41.4 33.6-72.7 35.3-23.6 1.3-46.3-4.4-63.9-16-20.8-13.8-33-34.8-34.3-59.3-2.5-48.3 35.7-83 95.2-86.4 21.1-1.2 40.9-.3 59.2 2.8-2.4-14.8-7.3-26.6-14.6-35.2-10-11.7-25.6-17.7-46.2-17.8l-.7 0c-16.6 0-39 4.6-53.3 26.3l-34.4-23.6c19.2-29.1 50.3-45.1 87.8-45.1l.8 0c62.6 .4 99.9 39.5 103.7 107.7l-.2 .2 .1 0zm-156 68.8c1.3 25.1 28.4 36.8 54.6 35.3 25.6-1.4 54.6-11.4 59.5-73.2-13.2-2.9-27.8-4.4-43.4-4.4-4.8 0-9.6 .1-14.4 .4-42.9 2.4-57.2 23.2-56.2 41.8l-.1 .1z"],
    "wpressr": [512, 512, ["rendact"], "f3e4", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM427.3 166.6c-15.2 34.5-30.4 69-45.6 103.5-2.4 5.5-6.9 8.2-13 8.2-23 0-46 .1-69 0-5.1 0-8.2 1.9-10.3 6.7-10.2 23.6-20.6 47-31 70.5-1.5 3.5-4.1 5.3-7.9 5.3-45.9 0-91.9 0-137.8 0-3.1 0-5.6-1.1-7.7-3.4-11.2-12.3-22.5-24.6-33.7-36.9-2.7-3-2.8-6.2-1.2-9.7 8.7-19.5 17.3-39.1 25.9-58.7 12.9-29.4 25.9-58.7 38.7-88.1 1.7-3.9 4.3-5.7 8.5-5.7 14.2 .1 28.5 0 42.7 0 6.2 0 9.2 4.8 6.7 10.6-13.6 30.8-27.2 61.6-40.7 92.3-5.7 13-11.4 26-17.1 39-3.9 9 7.1 12 11 5.6 .2-.4-1.4 4.2 30-67.7 1.4-3.1 3.4-4.4 6.8-4.4 15.2 .1 30.4 0 45.6 0 5.6 0 7.9 3.6 5.7 8.7-8.3 19-16.7 37.9-25 56.9-5 11.4 8.1 12.5 11.3 5.3 0-.1 27.9-63.3 32.2-73.2 2-4.6 5.4-6.5 10.3-6.5 26.4 .1 52.9 0 79.3 0 12.4 0 13.9-13.6 3.9-13.6-25.3 0-50.5 0-75.8 0-6.3 0-7.8-2.5-5.3-8.3 5.8-13.1 11.6-26.1 17.3-39.2 1.7-4 4.5-5.8 8.8-5.8 23.1 .1 26 0 130.8 0 6.1 0 8 2.8 5.6 8.3z"],
    "yoast": [448, 512, [], "f2b1", "M91.3 76l186 0-7 18.9-179 0c-39.7 0-71.9 31.6-71.9 70.3l0 205.4c0 35.4 24.9 70.3 84 70.3l0 19.1-12.1 0C41.2 460 0 419.8 0 370.5L0 165.2C0 115.9 40.7 76 91.3 76zM320.4 20l66.5 0c-143.8 378.1-145.7 398.9-184.7 439.3-20.8 21.6-49.3 31.7-78.3 32.7l0-51.1c49.2-7.7 64.6-49.9 64.6-75.3 0-20.1 .6-12.6-82.1-223.2l61.4 0 50.4 156.6 102.2-279zM448 161.5l0 298.5-214 0c6.6-9.6 10.7-16.3 12.1-19.4l182.5 0 0-279.1c0-32.5-17.1-51.9-48.2-62.9L387.1 81c41.7 13.6 60.9 43.1 60.9 80.5z"],
    "nimblr": [384, 512, [], "f5a8", "M246.6 353.3a27 27 0 1 1 0-54 27 27 0 1 1 0 54zm-79.4-27a27.1 27.1 0 1 1 -54.3 0 27.1 27.1 0 1 1 54.3 0zM191.8 159C157 159 89.4 178.8 59.2 227L14 0 14 335.5C14 433.1 93.6 512 191.8 512S369.5 433 369.5 335.5 290.1 159 191.8 159zm0 308.1c-73.3 0-132.5-58.9-132.5-131.6s59.2-131.6 132.5-131.6 132.5 58.9 132.5 131.5-59.3 131.6-132.5 131.6l0 .1z"],
    "pixelfed": [512, 512, [], "e7db", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM235.7 311.9l47 0c44.2 0 80.1-34.9 80.1-78s-35.9-78-80.1-78l-67.8 0c-25.5 0-46.2 20.1-46.2 45l0 175.1 67-64.1z"],
    "yahoo": [512, 512, [], "f19e", "M223.8 141.1l-56.7 143.2-56-143.2-96.1 0 105.8 249.1-38.6 89.8 94.2 0 140.9-338.9-93.6 0zM329.2 276.9a58.2 58.2 0 1 0 0 116.4 58.2 58.2 0 1 0 0-116.4zM394.7 32l-93 223.5 104.8 0 92.6-223.5-104.4 0z"],
    "bluesky": [576, 512, [], "e671", "M407.8 294.7c-3.3-.4-6.7-.8-10-1.3 3.4 .4 6.7 .9 10 1.3zM288 227.1C261.9 176.4 190.9 81.9 124.9 35.3 61.6-9.4 37.5-1.7 21.6 5.5 3.3 13.8 0 41.9 0 58.4S9.1 194 15 213.9c19.5 65.7 89.1 87.9 153.2 80.7 3.3-.5 6.6-.9 10-1.4-3.3 .5-6.6 1-10 1.4-93.9 14-177.3 48.2-67.9 169.9 120.3 124.6 164.8-26.7 187.7-103.4 22.9 76.7 49.2 222.5 185.6 103.4 102.4-103.4 28.1-156-65.8-169.9-3.3-.4-6.7-.8-10-1.3 3.4 .4 6.7 .9 10 1.3 64.1 7.1 133.6-15.1 153.2-80.7 5.9-19.9 15-138.9 15-155.5s-3.3-44.7-21.6-52.9c-15.8-7.1-40-14.9-103.2 29.8-66.1 46.6-137.1 141.1-163.2 191.8z"],
    "scribd": [384, 512, [], "f28a", "M42.6 252.7c-16.1-19-24.7-45.9-24.8-79.9 0-100.4 75.2-153.1 167.2-153.1 98.6-1.6 156.8 49 184.3 70.6l-50.5 72.1-37.3-24.6 26.9-38.6c-36.5-24-79.4-36.5-123-35.8-50.7-.8-111.7 27.2-111.7 76.2 0 18.7 11.2 20.7 28.6 15.6 23.3-5.3 41.9 .6 55.8 14 26.4 24.3 23.2 67.6-.7 91.9-29.2 29.5-85.2 27.3-114.8-8.4zm317.7 5.9c-15.5-18.8-38.9-29.4-63.2-28.6-38.1-2-71.1 28-70.5 67.2-.7 16.8 6 33 18.4 44.3 14.1 13.9 33 19.7 56.3 14.4 17.4-5.1 28.6-3.1 28.6 15.6 0 4.3-.5 8.5-1.4 12.7-16.7 40.9-59.5 64.4-121.4 64.4-51.9 .2-102.4-16.4-144.1-47.3l33.7-39.4-35.6-27.4-60.8 71.8 15.4 13.8c52.5 46.8 120.4 72.5 190.7 72.2 51.4 0 94.4-10.5 133.6-44.1 57.1-51.4 54.2-149.2 20.3-189.6z"],
    "creative-commons-pd": [512, 512, [], "f4ec", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 449.5c-139.2 0-235.8-138-190.2-267.9l78.8 35.1c-2.1 10.5-3.3 21.5-3.3 32.9 0 99 73.9 126.9 120.4 126.9 22.9 0 53.5-6.7 79.4-29.5L305 311.1c-5.5 6.3-17.6 16.7-36.3 16.7-37.8 0-53.7-39.9-53.9-71.9 230.4 102.6 216.5 96.5 217.9 96.8-34.3 62.4-100.6 104.8-176.7 104.8zm194.2-150l-224-100c18.8-34 54.9-30.7 74.7-11l40.4-41.6c-27.1-23.3-58-27.5-78.1-27.5-47.4 0-80.9 20.5-100.7 51.6L87.6 145.6c36.1-54.9 98.1-91.2 168.5-91.2 111.1 0 201.5 90.4 201.5 201.5 0 18-2.4 35.4-6.8 52-.3-.1-.4-.2-.6-.4z"],
    "earlybirds": [512, 512, [], "f39a", "M329.3 47.5c1.2-13 21.3-14 36.6-8.7 .9 .3 26.2 9.7 19 15.2-27.9-7.4-56.4 18.2-55.6-6.5zm-201 6.9c30.7-8.1 62 20 61.1-7.1-1.3-14.2-23.4-15.3-40.2-9.6-1 .3-28.7 10.5-20.9 16.7zM335.5 160a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-159.7 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM494.3 323.2c-9.9 24-40.7 11-63.9-1.2-13.5 69.1-58.1 111.4-126.3 124.2 .3 .9-2-.1 24 1 33.6 1.4 63.8-3.1 97.4-8-19.8-13.8-11.4-37.1-9.8-38.1 1.4-.9 14.7 1.7 21.6 11.5 8.6-12.5 28.4-14.8 30.2-13.6 1.6 1.1 6.6 20.9-6.9 34.6 4.7-.9 8.2-1.6 9.8-2.1 2.6-.8 17.7 11.3 3.1 13.3-14.3 2.3-22.6 5.1-47.1 10.8-45.9 10.7-85.9 11.8-117.7 12.8l1 11.6c3.8 18.1-23.4 24.3-27.6 6.2 .8 17.9-27.1 21.8-28.4-1l-.5 5.3c-.7 18.4-28.4 17.9-28.3-.6-7.5 13.5-28.1 6.8-26.4-8.5l1.2-12.4c-36.7 .9-59.7 3.1-61.8 3.1-20.9 0-20.9-31.6 0-31.6 2.4 0 27.7 1.3 63.2 2.8-61.1-15.5-103.7-55-114.9-118.2-25 12.8-57.5 26.8-68.2 .8-10.5-25.4 21.5-42.6 66.8-73.4 .7-6.6 1.6-13.3 2.7-19.8-14.4-19.6-11.6-36.3-16.1-60.4-16.8 2.4-23.2-9.1-23.6-23.1 .3-7.3 2.1-14.9 2.4-15.4 1.1-1.8 10.1-2 12.7-2.6 6-31.7 50.6-33.2 90.9-34.5 19.7-21.8 45.2-41.5 80.9-48.3-15.3-19.4-3.4-39.9-2.4-40.4 1.7-.8 21.2 4.3 26.3 23.2 5.2-8.8 18.3-11.4 19.6-10.7 1.1 .6 6.4 15-4.9 25.9 40.3 3.5 72.2 24.7 96 50.7 36.1 1.5 71.8 5.9 77.1 34 2.7 .6 11.6 .8 12.7 2.6 .3 .5 2.1 8.1 2.4 15.4-.5 13.9-6.8 25.4-23.6 23.1-3.2 17.3-2.7 32.9-8.7 47.7 2.4 11.7 4 23.8 4.8 36.4 37 25.4 70.3 42.5 60.3 66.9zM223.5 159.9c.9-44-37.9-42.2-78.6-40.3-21.7 1-38.9 1.9-45.5 13.9-11.4 20.9 5.9 92.9 23.2 101.2 9.8 4.7 73.4 7.9 86.3-7.1 8.2-9.4 15-49.4 14.6-67.7zm52 58.3c-4.3-12.4-6-30.1-15.3-32.7-2-.5-9-.5-11 0-10 2.8-10.8 22.1-17 37.2 15.4 0 19.3 9.7 23.7 9.7 4.3 0 6.3-11.3 19.6-14.2zm135.7-84.7c-6.6-12.1-24.8-12.9-46.5-13.9-40.2-1.9-78.2-3.8-77.3 40.3-.5 18.3 5 58.3 13.2 67.8 13 14.9 76.6 11.8 86.3 7.1 15.8-7.6 36.5-78.9 24.3-101.3z"],
    "square-odnoklassniki": [448, 512, ["odnoklassniki-square"], "f264", "M224 137.1c-5.4-.3-10.8 .6-15.9 2.4s-9.7 4.8-13.6 8.5-7 8.2-9.2 13.2-3.2 10.3-3.2 15.7 1.1 10.8 3.2 15.7 5.3 9.5 9.2 13.2 8.6 6.6 13.6 8.5 10.5 2.7 15.9 2.4c5.4 .3 10.8-.6 15.9-2.4s9.7-4.8 13.6-8.5 7-8.2 9.2-13.2 3.2-10.3 3.2-15.7-1.1-10.8-3.2-15.7-5.3-9.5-9.2-13.2-8.6-6.6-13.6-8.5-10.5-2.7-15.9-2.4zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM224 258a81 81 0 1 1 0-162.1 81 81 0 1 1 0 162.1zm59.3 6.2c16.8-13.2 29.5-5.5 34.1 3.6 7.8 16-1.1 23.7-21.5 37-17.1 10.9-40.7 15.2-56.2 16.8l13 12.9 47.7 47.7c17.4 17.9-11 45.8-28.6 28.6-12-12.2-29.5-29.7-47.7-47.9l-47.7 47.9c-17.7 17.2-46-11-28.4-28.6 3.7-3.7 7.9-7.9 12.5-12.5 10.4-10.4 22.6-22.7 35.2-35.2l12.9-12.9c-15.4-1.6-39.3-5.7-56.6-16.8-20.3-13.3-29.3-20.9-21.4-37 4.6-9.1 17.3-16.8 34.1-3.6 0 0 22.7 18 59.3 18s59.3-18 59.3-18z"],
    "markdown": [640, 512, [], "f60f", "M593.8 59.1l-547.6 0C20.7 59.1 0 79.8 0 105.2L0 406.7c0 25.5 20.7 46.2 46.2 46.2l547.7 0c25.5 0 46.2-20.7 46.1-46.1l0-301.6c0-25.4-20.7-46.1-46.2-46.1zM338.5 360.6l-61.5 0 0-120-61.5 76.9-61.5-76.9 0 120-61.7 0 0-209.2 61.5 0 61.5 76.9 61.5-76.9 61.5 0 0 209.2 .2 0zm135.3 3.1l-92.3-107.7 61.5 0 0-104.6 61.5 0 0 104.6 61.5 0-92.2 107.7z"],
    "typo3": [448, 512, [], "f42b", "M178.7 78.4c0-24.7 5.4-32.4 13.9-39.4-69.5 8.5-149.3 34-176.3 66.4-5.4 7.7-9.3 20.8-9.3 37.1 0 103.5 106.8 337.5 184.1 337.5 36.3 0 97.3-59.5 146.7-139-7 2.3-11.6 2.3-18.5 2.3-57.2 0-140.6-198.5-140.6-264.9zM301.5 32c-30.1 0-41.7 5.4-41.7 36.3 0 66.4 53.8 198.5 101.7 198.5 26.3 0 78.8-99.7 78.8-182.3 0-40.9-67-52.5-138.8-52.5z"],
    "joomla": [448, 512, [], "f1aa", "M.6 92.1c0-33.3 26.8-60.1 59.8-60.1 30 0 54.5 21.9 59.2 50.2 32.6-7.6 67.1 .6 96.5 30l-44.3 44.3c-20.5-20.5-42.6-16.3-55.4-3.5-14.3 14.3-14.3 37.9 0 52.2l99.5 99.5-44 44.3c-87.7-87.2-49.7-49.7-99.8-99.7-26.8-26.5-35-64.8-24.8-98.9-26.9-5.8-46.7-29.7-46.7-58.3zM130.1 208.5l44.3 44.3c10-10 89.7-89.7 99.7-99.8 14.3-14.3 37.6-14.3 51.9 0 12.8 12.8 17 35-3.5 55.4l44 44.3c31.2-31.2 38.5-67.6 28.9-101.2 29.2-4.1 51.9-29.2 51.9-59.5 0-33.2-26.8-60.1-59.8-60.1-30.3 0-55.4 22.5-59.5 51.6-33.8-9.9-71.7-1.5-98.3 25.1-18.3 19.1-71.1 71.5-99.6 99.9zM396.4 360.7c8.2-32.7-.9-68.5-26.3-93.9-11.8-12.2 5 4.7-99.5-99.7l-44.3 44.3 99.7 99.7c14.3 14.3 14.3 37.6 0 51.9-12.8 12.8-35 17-55.4-3.5l-44 44.3c27.6 30.2 68 38.8 102.7 28 5.5 27.4 29.7 48.1 58.9 48.1 33 0 59.8-26.8 59.8-60.1 0-30.2-22.5-55-51.6-59.1zm-84.3-53.1l-44-44.3c-87 86.4-50.4 50.4-99.7 99.8-14.3 14.3-37.6 14.3-51.9 0-13.1-13.4-16.9-35.3 3.2-55.4l-44-44.3c-30.2 30.2-38 65.2-29.5 98.3-26.7 6-46.2 29.9-46.2 58.2 0 33.3 26.8 60.1 59.8 60.1 28.6 0 52.5-19.8 58.6-46.7 32.7 8.2 68.5-.6 94.2-26 32.1-32 12.2-12.4 99.5-99.7z"],
    "weixin": [576, 512, [], "f1d7", "M385.2 167.6c6.4 0 12.6 .3 18.8 1.1-16.6-78.4-100.7-136.7-196.3-136.7-107.2 0-194.7 72.8-194.7 165.4 0 53.4 29.3 97.5 77.9 131.6l-19.3 58.6 68-34.1c24.4 4.8 43.8 9.7 68.2 9.7 6.2 0 12.1-.3 18.3-.8-4-12.9-6.2-26.6-6.2-40.8-.1-84.9 72.9-154 165.3-154zM280.7 114.7c14.5 0 24.2 9.7 24.2 24.4 0 14.5-9.7 24.2-24.2 24.2-14.8 0-29.3-9.7-29.3-24.2 .1-14.7 14.6-24.4 29.3-24.4zM144.3 163.3c-14.5 0-29.3-9.7-29.3-24.2 0-14.8 14.8-24.4 29.3-24.4 14.8 0 24.4 9.7 24.4 24.4 0 14.6-9.6 24.2-24.4 24.2zM563 319.4c0-77.9-77.9-141.3-165.4-141.3-92.7 0-165.4 63.4-165.4 141.3S305 460.7 397.6 460.7c19.3 0 38.9-5.1 58.6-9.9l53.4 29.3-14.8-48.6C534 402.1 563 363.2 563 319.4zM343.9 294.9c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.8 0 24.4 9.7 24.4 19.3 0 10-9.7 19.6-24.4 19.6zm107.1 0c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.5 0 24.4 9.7 24.4 19.3 .1 10-9.9 19.6-24.4 19.6z"],
    "grunt": [384, 512, [], "f3ad", "M61.6 189.3c-1.1 10 5.2 19.1 5.2 19.1 .7-7.5 2.2-12.8 4-16.6 .4 10.3 3.2 23.5 12.8 34.1 6.9 7.6 35.6 23.3 54.9 6.1 1 2.4 2.1 5.3 3 8.5 2.9 10.3-2.7 25.3-2.7 25.3s15.1-17.1 13.9-32.5c10.8-.5 21.4-8.4 21.1-19.5 0 0-18.9 10.4-35.5-8.8-9.7-11.2-40.9-42-83.1-31.8 4.3 1 8.9 2.4 13.5 4.1l-.1 0c-4.2 2-6.5 7.1-7 12zm28.3-1.8c19.5 11 37.4 25.7 44.9 37-5.7 3.3-21.7 10.4-38-1.7-10.3-7.6-9.8-26.2-6.9-35.3zM232 233.3c-1.2 15.5 13.9 32.5 13.9 32.5s-5.6-15-2.7-25.3c.9-3.2 2-6 3-8.5 19.3 17.3 48 1.5 54.8-6.1 9.6-10.6 12.3-23.8 12.8-34.1 1.8 3.8 3.4 9.1 4 16.6 0 0 6.4-9.1 5.2-19.1-.6-5-2.9-10-7-11.8l-.1 0c4.6-1.8 9.2-3.2 13.5-4.1-42.3-10.2-73.4 20.6-83.1 31.8-16.7 19.2-35.5 8.8-35.5 8.8-.2 10.9 10.4 18.9 21.2 19.3zm62.7-45.8c3 9.1 3.4 27.7-7 35.4-16.3 12.1-32.2 5-37.9 1.6 7.5-11.4 25.4-26 44.9-37zm-134.4 231l-29.4 0c-5.5 0-8.2 1.6-9.5 2.9-1.9 2-2.2 4.7-.9 8.1 3.5 9.1 11.4 16.5 13.7 18.6 3.1 2.7 7.5 4.3 11.8 4.3 4.4 0 8.3-1.7 11-4.6 7.5-8.2 11.9-17.1 13-19.8 .6-1.5 1.3-4.5-.9-6.8-1.8-1.8-4.7-2.7-8.8-2.7zM349.5 317.3c-2.4 17.9-13 33.8-24.6 43.7-3.1-22.7-3.7-55.5-3.7-62.4 0-14.7 9.5-24.5 12.2-26.1 2.5-1.5 5.4-3 8.3-4.6 18-9.6 40.4-21.6 40.4-43.7 0-16.2-9.3-23.2-15.4-27.8-.8-.6-1.5-1.1-2.2-1.7-2.1-1.7-3.7-3-4.3-4.4-4.4-9.8-3.6-34.2-1.7-37.6 .6-.6 16.7-20.9 11.8-39.2-2-7.4-6.9-13.3-14.1-17-5.3-2.7-11.9-4.2-19.5-4.5-.1-2-.5-3.9-.9-5.9-.6-2.6-1.1-5.3-.9-8.1 .4-4.7 .8-9 2.2-11.3 8.4-13.3 28.8-17.6 29-17.6l12.3-2.4-8.1-9.5c-.1-.2-17.3-17.5-46.3-17.5-7.9 0-16 1.3-24.1 3.9-24.2 7.8-42.9 30.5-49.4 39.3-3.1-1-6.3-1.9-9.6-2.7-4.2-15.8 9-38.5 9-38.5s-13.6-3-33.7 15.2c-2.6-6.5-8.1-20.5-1.8-37.2-29.5 10.4-36.9 26.3-39.1 40.7-7.6-5.4-6.7-23.1-7.2-27.6-7.5 .9-29.2 21.9-28.2 48.3-2 .5-3.9 1.1-5.9 1.7-6.5-8.8-25.1-31.5-49.4-39.3-7.9-2.2-16-3.5-23.9-3.5-29 0-46.1 17.3-46.3 17.5l-8.1 9.4 12.3 2.4c.2 0 20.6 4.3 29 17.6 1.4 2.2 1.8 6.6 2.2 11.3 .2 2.8-.4 5.5-.9 8.1-.4 1.9-.8 3.9-.9 5.9-7.7 .3-14.2 1.8-19.5 4.5-7.2 3.7-12.1 9.6-14.1 17-5 18.2 11.2 38.5 11.8 39.2 1.9 3.4 2.7 27.8-1.7 37.6-.6 1.4-2.2 2.7-4.3 4.4-.7 .5-1.4 1.1-2.2 1.7-6.1 4.6-15.4 11.7-15.4 27.8 0 22.1 22.4 34.1 40.4 43.7 3 1.6 5.8 3.1 8.3 4.6 2.7 1.6 12.2 11.4 12.2 26.1 0 6.9-.6 39.7-3.7 62.4-11.6-9.9-22.2-25.9-24.6-43.8 0 0-29.2 22.6-20.6 70.8 5.2 29.5 23.2 46.1 47 54.7 8.8 19.1 29.4 45.7 67.3 49.6 14.4 11.8 34.4 19.5 63.6 19.5l.2 0c29.1 0 49.1-7.7 63.6-19.5 37.9-3.9 58.5-30.5 67.3-49.6 23.8-8.7 41.7-25.2 47-54.7 8.2-48.4-21.1-70.9-21.1-70.9zM306 37.7c5.6-1.8 11.6-2.7 17.7-2.7 11 0 19.9 3 24.7 5-3.1 1.4-6.4 3.2-9.7 5.3-2.4-.4-5.6-.8-9.2-.8-10.5 0-20.5 3.1-28.7 8.9-12.3 8.7-18 16.9-20.7 22.4-2.2-1.3-4.5-2.5-7.1-3.7-1.6-.8-3.1-1.5-4.7-2.2 6.1-9.1 19.9-26.5 37.7-32.2zm21 18.2c-.8 1-1.6 2.1-2.3 3.2-3.3 5.2-3.9 11.6-4.4 17.8-.5 6.4-1.1 12.5-4.4 17-4.2 .8-8.1 1.7-11.5 2.7-2.3-3.1-5.6-7-10.5-11.2 1.4-4.8 5.5-16.1 13.5-22.5 5.6-4.3 12.2-6.7 19.6-7zM45.9 45.3c-3.3-2.2-6.6-4-9.7-5.3 4.8-2 13.7-5 24.7-5 6.1 0 12 .9 17.7 2.7 17.8 5.8 31.6 23.2 37.7 32.1-1.6 .7-3.2 1.4-4.8 2.2-2.5 1.2-4.9 2.5-7.1 3.7-2.6-5.4-8.3-13.7-20.7-22.4-8.3-5.8-18.2-8.9-28.8-8.9-3.4 .1-6.6 .5-9 .9zM90.6 85.4c-4.9 4.2-8.3 8-10.5 11.2-3.4-.9-7.3-1.9-11.5-2.7-3.3-4.4-3.8-10.5-4.3-16.9-.5-6.2-1.1-12.6-4.4-17.8-.7-1.1-1.5-2.2-2.3-3.2 7.4 .3 14 2.6 19.5 7 8 6.3 12.1 17.6 13.5 22.4zM58.4 259.9c-2.7-1.6-5.6-3.1-8.4-4.6-14.9-8-30.2-16.3-30.2-30.5 0-11.1 4.3-14.6 8.9-18.2l.5-.4c.7-.6 1.4-1.2 2.2-1.8-.9 7.2-1.9 13.3-2.7 14.9 0 0 12.1-15 15.7-44.3 1.4-11.5-1.1-34.3-5.1-43 .2 4.9 0 9.8-.3 14.4-.4-.8-.8-1.6-1.3-2.2-3.2-4-11.8-17.5-9.4-26.6 .9-3.5 3.1-6 6.7-7.8 3.8-1.9 8.8-2.9 15.1-2.9 12.3 0 25.9 3.7 32.9 6 25.1 8 55.4 30.9 64.1 37.7 .2 .2 .4 .3 .4 .3l5.6 3.9-3.5-5.8c-.2-.3-19.1-31.4-53.2-46.5 2-2.9 7.4-8.1 21.6-15.1 21.4-10.5 46.5-15.8 74.3-15.8 27.9 0 52.9 5.3 74.3 15.8 14.2 6.9 19.6 12.2 21.6 15.1-34 15.1-52.9 46.2-53.1 46.5l-3.5 5.8 5.6-3.9s.2-.1 .4-.3c8.7-6.8 39-29.8 64.1-37.7 7-2.2 20.6-6 32.9-6 6.3 0 11.3 1 15.1 2.9 3.5 1.8 5.7 4.4 6.7 7.8 2.5 9.1-6.1 22.6-9.4 26.6-.5 .6-.9 1.3-1.3 2.2-.3-4.6-.5-9.5-.3-14.4-4 8.8-6.5 31.5-5.1 43 3.6 29.3 15.7 44.3 15.7 44.3-.8-1.6-1.8-7.7-2.7-14.9 .7 .6 1.5 1.2 2.2 1.8l.5 .4c4.6 3.7 8.9 7.1 8.9 18.2 0 14.2-15.4 22.5-30.2 30.5-2.9 1.5-5.7 3.1-8.4 4.6-8.7 5-18 16.7-19.1 34.2-.9 14.6 .9 49.9 3.4 75.9-12.4 4.8-26.7 6.4-39.7 6.8-2-4.1-3.9-8.5-5.5-13.1-.7-2-19.6-51.1-26.4-62.2 5.5 39 17.5 73.7 23.5 89.6-3.5-.5-7.3-.7-11.7-.7l-117 0c-4.4 0-8.3 .3-11.7 .7 6-15.9 18.1-50.6 23.5-89.6-6.8 11.2-25.7 60.3-26.4 62.2-1.6 4.6-3.5 9-5.5 13.1-13-.4-27.2-2-39.7-6.8 2.5-26 4.3-61.2 3.4-75.9-.9-17.4-10.3-29.2-19-34.2zM35.1 404.6c-12.1-20-8.7-54.1-3.7-59.1 10.9 34.4 47.2 44.3 74.4 45.4-2.7 4.2-5.2 7.6-7 10l-1.4 1.4c-7.2 7.8-8.6 18.5-4.1 31.8-22.7-.1-46.3-9.8-58.2-29.5zm45.7 43.5c6 1.1 12.2 1.9 18.6 2.4 3.5 8 7.4 15.9 12.3 23.1-14.4-5.9-24.4-16-30.9-25.5zm111.5 50.1c-60.6-.1-78.3-45.8-84.9-64.7-3.7-10.5-3.4-18.2 .9-23.1 2.9-3.3 9.5-7.2 24.6-7.2l118.8 0c15.1 0 21.8 3.9 24.6 7.2 4.2 4.8 4.5 12.6 .9 23.1-6.6 18.8-24.3 64.6-84.9 64.7zm80.6-24.6c4.9-7.2 8.8-15.1 12.3-23.1 6.4-.5 12.6-1.3 18.6-2.4-6.5 9.5-16.5 19.6-30.9 25.5zm76.6-69c-12 19.7-35.6 29.3-58.1 29.7 4.5-13.3 3.1-24.1-4.1-31.8-.4-.5-.9-1-1.4-1.5-1.8-2.4-4.3-5.8-7-10 27.2-1.2 63.5-11 74.4-45.4 5 5 8.4 39.1-3.8 59zM192.2 187.7l.2 0c12.7-.1 27.2-17.8 27.2-17.8-9.9 6-18.8 8.1-27.3 8.3-8.5-.2-17.4-2.3-27.3-8.3 0 0 14.5 17.6 27.2 17.8zm61.7 230.7l-29.4 0c-4.2 0-7.2 .9-8.9 2.7-2.2 2.3-1.5 5.2-.9 6.7 1 2.6 5.5 11.3 13 19.3 2.7 2.9 6.6 4.5 11 4.5s8.7-1.6 11.8-4.2c2.3-2 10.2-9.2 13.7-18.1 1.3-3.3 1-6-.9-7.9-1.3-1.3-4-2.9-9.4-3z"],
    "rockrms": [512, 512, [], "f3e9", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM413.4 427.5l-90 0-112-131.3c-17.9-20.4-3.9-56.1 26.6-56.1l75.3 0-84.6-99.3-84.3 98.9-90 0 147.1-172.5c14.4-18.4 41.3-17.3 54.5 0L413.7 252.3c19 22.8 2 57.2-27.6 56.1-.6 0-74.2 .2-74.2 .2L413.4 427.5z"],
    "unsplash": [448, 512, [], "e07c", "M448 230.2l0 249.8-448 0 0-249.8 141.1 0 0 124.9 165.7 0 0-124.9 141.1 0zM306.9 32l-165.7 0 0 124.9 165.7 0 0-124.9z"],
    "square-instagram": [448, 512, ["instagram-square"], "e055", "M194.4 211.7a53.3 53.3 0 1 0 59.2 88.6 53.3 53.3 0 1 0 -59.2-88.6zm142.3-68.4c-5.2-5.2-11.5-9.3-18.4-12-18.1-7.1-57.6-6.8-83.1-6.5-4.1 0-7.9 .1-11.2 .1s-7.2 0-11.4-.1c-25.5-.3-64.8-.7-82.9 6.5-6.9 2.7-13.1 6.8-18.4 12s-9.3 11.5-12 18.4c-7.1 18.1-6.7 57.7-6.5 83.2 0 4.1 .1 7.9 .1 11.1s0 7-.1 11.1c-.2 25.5-.6 65.1 6.5 83.2 2.7 6.9 6.8 13.1 12 18.4s11.5 9.3 18.4 12c18.1 7.1 57.6 6.8 83.1 6.5 4.1 0 7.9-.1 11.2-.1s7.2 0 11.4 .1c25.5 .3 64.8 .7 82.9-6.5 6.9-2.7 13.1-6.8 18.4-12s9.3-11.5 12-18.4c7.2-18 6.8-57.4 6.5-83 0-4.2-.1-8.1-.1-11.4s0-7.1 .1-11.4c.3-25.5 .7-64.9-6.5-83-2.7-6.9-6.8-13.1-12-18.4l0 .2zm-67.1 44.5c18.1 12.1 30.6 30.9 34.9 52.2s-.2 43.5-12.3 61.6c-6 9-13.7 16.6-22.6 22.6s-19 10.1-29.6 12.2c-21.3 4.2-43.5-.2-61.6-12.3s-30.6-30.9-34.9-52.2 .2-43.5 12.2-61.6 30.9-30.6 52.2-34.9 43.5 .2 61.6 12.2l.1 0zm29.2-1.3c-3.1-2.1-5.6-5.1-7.1-8.6s-1.8-7.3-1.1-11.1 2.6-7.1 5.2-9.8 6.1-4.5 9.8-5.2 7.6-.4 11.1 1.1 6.5 3.9 8.6 7 3.2 6.8 3.2 10.6c0 2.5-.5 5-1.4 7.3s-2.4 4.4-4.1 6.2-3.9 3.2-6.2 4.2-4.8 1.5-7.3 1.5c-3.8 0-7.5-1.1-10.6-3.2l-.1 0zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM357 389c-18.7 18.7-41.4 24.6-67 25.9-26.4 1.5-105.6 1.5-132 0-25.6-1.3-48.3-7.2-67-25.9s-24.6-41.4-25.8-67c-1.5-26.4-1.5-105.6 0-132 1.3-25.6 7.1-48.3 25.8-67s41.5-24.6 67-25.8c26.4-1.5 105.6-1.5 132 0 25.6 1.3 48.3 7.1 67 25.8s24.6 41.4 25.8 67c1.5 26.3 1.5 105.4 0 131.9-1.3 25.6-7.1 48.3-25.8 67l0 .1z"],
    "first-order-alt": [512, 512, [], "f50a", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 7.8a240.2 240.2 0 1 1 0 480.4 240.2 240.2 0 1 1 0-480.4zm0 20.5a219.7 219.7 0 1 0 0 439.4 219.7 219.7 0 1 0 0-439.4zm0 8.2a211.5 211.5 0 1 1 0 423 211.5 211.5 0 1 1 0-423zm186.2 260c-4.4 17.1-11.2 33.5-20.1 48.7l-74.1-35.9 61.5 54.8c-10.6 14.1-23.2 26.6-37.2 37.3l-54.8-61.6 35.9 74.3c-15.2 9-31.6 15.8-48.6 20.2l-27.3-78.5 4.8 82.9c-8.6 1.2-17.4 1.8-26.3 1.8s-17.7-.6-26.3-1.8l4.8-82.5-27.2 78c-17.1-4.5-33.4-11.3-48.7-20.2l35.9-74.3-54.9 61.6c-14-10.7-26.6-23.2-37.2-37.3l61.6-54.9-74.3 35.9C80.7 338 74 321.7 69.5 304.6l77.8-27.1-82.2 4.8c-1.2-8.6-1.8-17.3-1.8-26.2 0-9 .6-17.8 1.8-26.5l82.4 4.8-77.9-27.2c4.5-17.1 11.3-33.5 20.2-48.7l74.2 35.9-61.5-54.9c10.7-14 23.2-26.6 37.3-37.2l54.8 61.5-35.8-74.2c15.2-8.9 31.6-15.7 48.6-20.1l26.9 77.2-4.7-81.6c8.6-1.2 17.4-1.8 26.3-1.8s17.7 .6 26.3 1.8l-4.7 82.2 27-77.8c17.3 4.5 33.6 11.4 48.6 20.2l-35.8 74.1 54.7-61.5c14.1 10.7 26.6 23.2 37.2 37.2l-61.4 54.8 74.1-35.9c8.9 15.2 15.7 31.6 20.2 48.6l-77.8 27.1 82.2-4.7c1.2 8.7 1.8 17.5 1.8 26.5 0 8.9-.6 17.6-1.8 26.2l-82.1-4.7 77.7 27.1z"],
    "fulcrum": [256, 512, [], "f50b", "M63.8 164.1L28.4 207.7-7 164.1 28.4 120.6 63.8 164.1zM112.2 0l-20.5 198.2-51 57.8 51 57.8 20.5 198.2 0-211.1-41.1-44.9 41.1-44.9 0-211.1zm79.7 164.1l35.4 43.6 35.4-43.6-35.4-43.5-35.4 43.5zm-48.5 47l41.1 44.9-41.1 44.9 0 211.1 20.6-198.2 51-57.8-51-57.8-20.6-198.2 0 211.1z"],
    "brave-reverse": [448, 512, [], "e63d", "M298.5 0c3 0 5.8 1.3 7.8 3.6l38.1 44c.5-.1 1-.2 1.5-.3 9.2-1.6 18.6-2.2 27.7-1.2 11.6 1.4 21.5 5.4 28.9 12.9 7.7 7.8 15.4 15.8 22.6 23.6 2.5 2.7 4.9 5.2 6.9 7.4 .7 .8 1.4 1.5 1.9 2 3.4 3.7 4.2 8.1 2.7 11.9l-9.8 24.6 13.1 38.1c.7 2 .8 4.1 .2 6.2-.1 .4-.1 .4-.5 2.1l-1.5 5.8c-1.6 6.3-3.5 13.3-5.4 20.9-5.6 21.6-11.2 43.2-16.4 63.4-12.9 49.9-21.4 82.7-23.4 90.9-11.1 44.5-19.9 60-48.3 80.3-24.9 17.8-76.8 53.6-86.8 60-1 .6-2 1.3-3.4 2.3-.5 .4-3.2 2.2-3.9 2.7-4.9 3.3-8.3 5.5-12.1 7.3-4.7 2.2-9.3 3.5-13.9 3.5s-9.1-1.2-13.9-3.5c-3.7-1.8-7.2-3.9-12.1-7.3-.8-.5-3.4-2.4-3.9-2.7-1.4-1-2.5-1.7-3.4-2.3-10-6.4-61.9-42.1-86.8-60-28.4-20.4-37.2-35.8-48.3-80.3-2-8.2-10.5-41-23.3-90.5-5.3-20.6-10.9-42.2-16.5-63.8-2-7.6-3.8-14.6-5.4-20.9l-1.5-5.8-.5-2.1c-.5-2-.4-4.2 .2-6.2l13.1-38.1-9.9-24.5c-1.5-3.8-.7-8.2 2-11.2 1.2-1.3 1.8-2 2.6-2.8 2-2.2 4.4-4.7 6.9-7.4 7.3-7.7 15-15.7 22.7-23.5 7.4-7.5 17.3-11.6 28.9-12.9 9.1-1.1 18.5-.5 27.7 1.2 .5 .1 1 .2 1.5 .3l38.1-44c2-2.4 4.8-3.7 7.8-3.7l148 0zm-4.7 21.1l-138.6 0-39.1 45.1c-2.6 3-6.7 4.3-10.6 3.2-.2-.1-.7-.2-1.5-.4-1.3-.3-2.9-.6-4.5-.9-7.4-1.3-14.9-1.8-21.7-1-7.3 .9-13 3.2-16.6 6.9-7.6 7.7-15.2 15.6-22.3 23.3-1.7 1.8-3.3 3.5-4.8 5.1l8.8 22c1 2.4 1 5 .2 7.5L29.7 170.6c.4 1.4 .5 1.9 1.2 4.8 1.6 6.3 3.5 13.3 5.4 20.9 5.6 21.6 11.2 43.2 16.4 63.4 12.9 50 21.4 82.8 23.4 91 10.1 40.1 16.4 51.3 40.2 68.3 24.6 17.6 76.3 53.2 85.9 59.3 1.2 .8 2.5 1.6 4 2.7 .6 .4 3.2 2.2 3.9 2.7 4 2.8 6.7 4.4 9.2 5.6 2.2 1 3.9 1.5 5.1 1.5s2.9-.5 5.1-1.5c2.5-1.2 5.2-2.8 9.2-5.6 .7-.5 3.3-2.3 3.9-2.7 1.6-1.1 2.8-1.9 4-2.7 9.6-6.1 61.3-41.7 85.9-59.3 23.8-17.1 30.2-28.2 40.1-68.3 2.1-8.3 10.5-41.1 23.3-90.7 5.3-20.6 10.9-42.2 16.5-63.8 2-7.6 3.8-14.6 5.4-20.9 .7-2.9 .9-3.4 1.2-4.8l-13.3-38.8c-.8-2.4-.8-5.1 .2-7.5l8.8-22c-1.5-1.6-3.1-3.3-4.8-5.1-7.2-7.6-14.7-15.5-22.3-23.3-3.7-3.7-9.3-6-16.6-6.9-6.8-.8-14.4-.3-21.7 1-1.7 .3-3.2 .6-4.5 .9-.8 .2-1.3 .3-1.5 .4-3.8 1.1-7.9-.2-10.6-3.2L293.8 21.1zM224.5 316c2.8 0 20.9 6.5 35.4 14.1s25 13 28.3 15.2 1.3 6.2-1.7 8.4-44.1 34.6-48.1 38.2-9.8 9.5-13.8 9.5-9.8-5.9-13.8-9.5-45.1-36-48.1-38.2-5.1-6.2-1.7-8.4 13.9-7.5 28.3-15.2 32.5-14.1 35.4-14.1l-.2 0zm.1-230.7c.7 0 8.8 .2 20.5 4.2 12.3 4.2 25.7 9.4 31.9 9.4s51.9-8.9 51.9-8.9 54.2 66.7 54.2 81-6.8 18-13.7 25.4-36.8 39.8-40.7 43.9-11.9 10.5-7.1 21.8 11.7 25.8 3.9 40.4-21 24.4-29.4 22.8-28.4-12.2-35.7-17.1-30.5-24.3-30.5-31.8 24-20.8 28.4-23.9 24.7-14.8 25.1-19.4 .3-6-5.7-17.4-16.7-26.7-14.9-36.8 19.1-15.4 31.5-20.2 36.2-13.7 39.2-15.1 2.2-2.7-6.8-3.6-34.6-4.3-46.1-1.1-31.2 8.2-32.8 10.9-3 2.7-1.4 11.8 10.1 52.8 10.9 60.6 2.4 12.9-5.8 14.8-22.1 5.2-26.8 5.2-18.6-3.3-26.8-5.2-6.6-7-5.8-14.8 9.3-51.5 10.9-60.6 .2-9.2-1.4-11.8-21.3-7.6-32.8-10.9-37.1 .2-46.1 1.1-9.8 2.2-6.8 3.6 26.8 10.4 39.2 15.1 29.7 10 31.5 20.2-9 25.4-14.9 36.8-6.1 12.8-5.7 17.4 20.6 16.4 25.1 19.4 28.4 16.4 28.4 23.9-23.2 27-30.5 31.8-27.2 15.4-35.7 17.1-21.7-8.2-29.4-22.8-.8-29.1 3.9-40.4-3.3-17.7-7.1-21.8-33.8-36.5-40.7-43.9-13.7-11.2-13.7-25.4 54.2-81 54.2-81 45.8 8.9 51.9 8.9 19.5-5.2 31.9-9.4 20.6-4.2 20.6-4.2l-.3 0z"],
    "avianex": [512, 512, [], "f374", "M453.2 32l-312 0C102.3 32 65 63.2 57.9 101.7L1.3 410.3C-5.8 448.8 20 480 59 480l312 0c38.9 0 76.2-31.2 83.3-69.7L511 101.8C518 63.2 492.2 32 453.2 32zM395 379.3l-32 13.5-115.4-110c-14.7 10-29.2 19.5-41.7 27.1l22.1 64.2-17.9 12.7-40.6-61-52.4-48.1 15.7-15.4 58 31.1c9.3-10.5 20.8-22.6 32.8-34.9l-20.5-29.6-68.8-99.8 18.8-28.9 8.9-4.8 103.1 112.4 4.9 4.5c19.4-18.8 33.8-32.4 33.8-32.4 7.7-6.5 21.5-2.9 30.7 7.9 9 10.5 10.6 24.7 2.7 31.3-1.8 1.3-15.5 11.4-35.3 25.6l4.5 7.3 94.9 119.4-6.3 7.9z"],
    "ns8": [640, 512, [], "f3d5", "M104.3 269.2l26.1 0 0-26.2-26.1 0 0 26.2zM156.8 243l-.1-26.2 0-.9c-.2-10.4-4.4-20.3-11.9-27.6s-17.5-11.3-27.9-11.1-20.3 4.4-27.6 11.8-11.3 17.5-11.2 27.9l0 .2 26.4 0 0-.2c.1-3.4 1.5-6.6 3.9-9s5.7-3.7 9.1-3.7 6.7 1.3 9.1 3.7 3.8 5.6 3.9 9l0 26.2 26.3 0zm52.4 25.8c0 12-2.4 23.8-6.9 34.9s-11.3 21.1-19.7 29.6-18.5 15.2-29.6 19.7-22.9 6.9-34.9 6.9l-.6 0c-24.2 0-47.3-9.6-64.4-26.7S26.3 293 26.3 268.8l-26.3 0 0 .2c0 15.4 3.1 30.7 9 44.9s14.6 27.2 25.5 38.1 23.9 19.5 38.1 25.4 29.5 8.9 44.9 8.9l.8 0c15.4 0 30.7-3 44.9-9s27.2-14.6 38.1-25.5 19.5-23.8 25.4-38.1 8.9-29.5 8.9-44.9l0-26-26.3 0 0 26zm-157.2 0c.1 17.3 7 33.9 19.2 46.1s28.8 19.1 46.1 19.1 33.9-6.9 46.1-19.1 19.2-28.8 19.2-46.1l-26.3 0c-.2 10.2-4.4 20-11.7 27.2s-17.1 11.2-27.4 11.2-20.1-4-27.4-11.2-11.5-16.9-11.7-27.2l0-26-26.3 0 0-26.6c.3-17.3 7.4-33.8 19.7-45.8s29-18.8 46.3-18.6 33.8 7.2 45.9 19.5 18.9 28.9 18.9 46.2l0 25.3 26.3 0 0-25.3c0-24.3-9.7-47.7-26.9-64.9s-40.5-26.9-64.9-26.9-47.7 9.7-64.9 26.9-26.9 40.5-26.9 64.9l0 25.4 26.3 0 0 26zm418.4-71.2c13.7 0 24.6 6.6 30.1 18.3l.7 1.5 23.2-11.5-.6-1.4c-8-19.3-28.5-31.3-53.4-31.3-23.1 0-43.6 11.4-51 28.4-.1 26.9-.2 23.9 0 24.8 4.7 11 14.6 19.4 28.7 24.2 6.5 2 13.1 3.3 19.8 4 5.5 .7 10.6 1.4 15.8 3.1 6.4 2.1 10.5 5.3 12.8 9.8l0 9.9c-3.7 7.5-13.8 12.3-25.8 12.3-14.3 0-26-6.9-31.9-19l-.7-1.5-23 11.5 .6 1.4c7.9 19.4 29.6 32 55.3 32 23.6 0 44.6-11.4 52.3-28.4l.2-25.9-.2-.7c-4.9-11-15.2-19.6-28.9-24.2-7.7-2.7-14.3-3.6-20.7-4.4-5-.5-10-1.5-14.8-2.9-6.3-1.9-10.4-5.1-12.6-9.6l0-8.4c3.4-7.4 12.9-12.1 24.2-12.1l0 0zM287.6 311.3l26.1 0 0-68.4-26.1 0 0 68.4zM639.8 258c-2.9-6.3-8.3-12-15.4-16.7 5.6-3.8 10.1-9.1 13-15.3l.2-25.3-.2-.7c-7.4-16-26.7-26.7-48.2-26.7S548.5 184 541.1 200l-.2 25.3 .2 .7c2.9 6.1 7.4 11.4 13 15.3-7.2 4.7-12.5 10.5-15.4 16.7l-.2 28.9 .2 .7c7.6 16 27.9 26.7 50.6 26.7s43.1-10.7 50.6-26.7l.2-28.9-.2-.7zm-73.2-50.8c3.6-6.3 12.6-10.5 22.6-10.5s19 4.2 22.6 10.5l0 13.7c-3.5 6.2-12.6 10.3-22.6 10.3s-19.1-4.2-22.6-10.3l0-13.7zm47.3 72.2c-3.8 6.6-13.3 10.9-24.7 10.9-11.1 0-21-4.4-24.7-10.9l0-16.2c3.7-6.3 13.5-10.5 24.7-10.5 11.3 0 20.9 4.1 24.7 10.5l0 16.2zM376.4 266l-59.8-89.7-29 0 0 40.6 26.5 0 0 .4 62.5 94.1 25.7 0 0-135.1-25.9 0 0 89.7z"],
    "square-pinterest": [448, 512, ["pinterest-square"], "f0d3", "M384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l72.6 0-2.2-.8c-5.4-48.1-3.1-57.5 15.7-134.7 3.9-16 8.5-35 13.9-57.9 0 0-7.3-14.8-7.3-36.5 0-70.7 75.5-78 75.5-25 0 13.5-5.4 31.1-11.2 49.8-3.3 10.6-6.6 21.5-9.1 32-5.7 24.5 12.3 44.4 36.4 44.4 43.7 0 77.2-46 77.2-112.4 0-58.8-42.3-99.9-102.6-99.9-69.9 0-110.9 52.4-110.9 106.6 0 21.1 8.2 43.7 18.3 56 2 2.4 2.3 4.5 1.7 7-1.1 4.7-3.1 12.9-4.7 19.2-1 4-1.8 7.3-2.1 8.6-1.1 4.5-3.5 5.5-8.2 3.3-30.6-14.3-49.8-59.1-49.8-95.1 0-77.5 56.2-148.6 162.2-148.6 85.2 0 151.4 60.7 151.4 141.8 0 84.6-53.3 152.7-127.4 152.7-24.9 0-48.3-12.9-56.3-28.2 0 0-12.3 46.9-15.3 58.4-5 19.3-17.6 42.9-27.4 59.3L384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64z"],
    "bluetooth-b": [256, 512, [], "f294", "M164.9 260L257.5 156.7 111.6 0 111.6 206.3 25.4 120.2-6 151.6 102.1 260-6 368.4 25.4 399.8 111.6 313.7 114.3 512 262.8 363.4 164.9 260zm40.9-103l-50 50-.3-100.3 50.3 50.3zm-50 156l50 50-50.3 50.3 .3-100.3z"],
    "gripfire": [320, 512, [], "f3ac", "M80.5 301.4c0-73.8 105.1-122.5 105.1-203 0-47.1-34-88-39.1-90.4 .4 3.3 .6 6.7 .6 10 0 92.1-147.1 153.9-147.1 268.6 0 49.8 32.2 79.2 66.5 108.3 65.1 46.7 78.1 71.4 78.1 86.6 0 10.1-4.8 17-4.8 22.3 13.1-16.7 17.4-31.9 17.5-46.4 0-29.6-21.7-56.3-44.2-86.5-16-22.3-32.6-42.6-32.6-69.5zm205.3-39c-12.1-66.8-78-124.4-94.7-130.9l4 7.2c2.4 5.1 3.4 10.9 3.4 17.1 0 44.7-54.2 111.2-56.6 116.7-2.2 5.1-3.2 10.5-3.2 15.8 0 20.1 15.2 42.1 17.9 42.1 2.4 0 56.6-55.4 58.1-87.7 6.4 11.7 9.1 22.6 9.1 33.4 0 41.2-41.8 96.9-41.8 96.9 0 11.6 31.9 53.2 35.5 53.2 1 0 2.2-1.4 3.2-2.4 37.9-39.3 67.3-85 67.3-136.8 0-8-.7-16.2-2.2-24.6z"],
    "square-google-plus": [448, 512, ["google-plus-square"], "f0d4", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM64 256c0-55.3 44.7-100 100-100 27 0 49.5 9.8 67 26.2l-27.1 26.1c-7.4-7.1-20.3-15.4-39.8-15.4-34.1 0-61.9 28.2-61.9 63.2 0 34.9 27.8 63.2 61.9 63.2 39.6 0 54.4-28.5 56.8-43.1l-56.9 0 0-34.4 94.4 0c1 5 1.6 10.1 1.6 16.6 0 57.1-38.3 97.6-96 97.6-55.3 0-100-44.7-100-100zm291 18.2l0 29-29.2 0 0-29-29 0 0-29.2 29 0 0-29 29.2 0 0 29 29 0 0 29.2-29 0z"],
    "app-store": [512, 512, [], "f36f", "M255.9 120.9l9.1-15.7c5.6-9.8 18.1-13.1 27.9-7.5s13.1 18.1 7.5 27.9l-87.5 151.5 63.3 0c20.5 0 32 24.1 23.1 40.8l-185.5 0c-11.3 0-20.4-9.1-20.4-20.4s9.1-20.4 20.4-20.4l52 0 66.6-115.4-20.8-36.1c-5.6-9.8-2.3-22.2 7.5-27.9 9.8-5.6 22.2-2.3 27.9 7.5l8.9 15.7zm-78.7 218l-19.6 34c-5.6 9.8-18.1 13.1-27.9 7.5s-13.1-18.1-7.5-27.9l14.6-25.2c16.4-5.1 29.8-1.2 40.4 11.6zm168.9-61.7l53.1 0c11.3 0 20.4 9.1 20.4 20.4S410.5 318 399.2 318l-29.5 0 19.9 34.5c5.6 9.8 2.3 22.2-7.5 27.9-9.8 5.6-22.2 2.3-27.9-7.5-33.5-58.1-58.7-101.6-75.4-130.6-17.1-29.5-4.9-59.1 7.2-69.1 13.4 23 33.4 57.7 60.1 104zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM40 256a216 216 0 1 1 432 0 216 216 0 1 1 -432 0z"],
    "wix": [640, 512, [], "f5cf", "M393.4 131.7c0 13 2.1 32.7-28.7 43.8-9.5 3.4-16 9.7-16 9.7 0-31 4.7-42.2 17.4-48.9 9.8-5.1 27.2-4.6 27.2-4.6zM277.6 167.2l-34.2 132.7-28.5-108.6c-7.7-32-20.8-48.5-48.4-48.5-27.4 0-40.7 16.2-48.4 48.5L89.5 299.9 55.3 167.2C49.7 140.5 23.9 129 0 132L65.6 379.9s21.6 1.6 32.5-4c14.2-7.2 21-12.8 29.6-46.6 7.7-30.1 29.1-118.4 31.1-124.7 4.8-14.9 11.1-13.8 15.4 0 2 6.3 23.5 94.6 31.1 124.7 8.6 33.7 15.4 39.3 29.6 46.6 10.8 5.5 32.5 4 32.5 4L332.9 132c-24.4-3.1-49.8 8.9-55.3 35.3zm115.8 5.2s-4.1 6.3-13.5 11.6c-6 3.4-11.8 5.6-18 8.6-15.1 7.3-13.2 13.9-13.2 35.2l0 152.1s16.6 2.1 27.4-3.4c13.9-7.1 17.1-14 17.3-44.8l0-150.3 0 0 0-9zm163.4 84.1L640 132.8s-35.1-6-52.5 9.8c-13.3 12.1-24.4 29.6-54.2 72.5-.5 .7-6.3 10.5-13.1 0-29.3-42.2-40.8-60.3-54.2-72.5-17.4-15.8-52.5-9.8-52.5-9.8l83.2 123.7-83 123.4s36.6 4.6 54-11.2c11.5-10.5 17.6-20.4 52.5-70.7 6.8-10.5 12.6-.8 13.1 0 29.4 42.4 39.2 58.1 53.1 70.7 17.4 15.8 53.3 11.2 53.3 11.2l-83-123.4z"],
    "intercom": [448, 512, [], "f7af", "M392 32L56 32C25.1 32 0 57.1 0 88L0 424c0 30.9 25.1 56 56 56l336 0c30.9 0 56-25.1 56-56l0-336c0-30.9-25.1-56-56-56zM283.7 114.1c0-19.8 29.9-19.8 29.9 0l0 199.5c0 19.8-29.9 19.8-29.9 0l0-199.5zm-74.6-7.5c0-19.8 29.9-19.8 29.9 0l0 216.5c0 19.8-29.9 19.8-29.9 0l0-216.5zm-74.7 7.5c0-19.8 29.9-19.8 29.9 0l0 199.5c0 19.8-29.9 19.8-29.9 0l0-199.5zM59.7 144c0-19.8 29.9-19.8 29.9 0l0 134.3c0 19.8-29.9 19.8-29.9 0l0-134.3zM383.1 371.8c-72.8 63-241.7 65.4-318.1 0-15-12.8 4.4-35.5 19.4-22.7 65.9 55.3 216.1 53.9 279.3 0 14.9-12.9 34.3 9.8 19.4 22.7zm5.2-93.5c0 19.8-29.9 19.8-29.9 0l0-134.3c0-19.8 29.9-19.8 29.9 0l0 134.3z"],
    "reacteurope": [576, 512, [], "f75d", "M250.7 211.7l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3-2 6.8zm63.7 0l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.2-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3-1.9 6.8zm-91.3 50.5l-3.4 0c-4.8 0-3.8 4-3.8 12.1 0 4.7-2.3 6.1-5.8 6.1s-5.8-1.4-5.8-6.1l0-36.6c0-4.7 2.3-6.1 5.8-6.1s5.8 1.4 5.8 6.1c0 7.2-.7 10.5 3.8 10.5l3.4 0c4.7-.1 3.8-3.9 3.8-12.3 0-9.9-6.7-14.1-16.8-14.1l-.2 0c-10.1 0-16.8 4.2-16.8 14.1l0 40.1c0 10.4 6.7 14.1 16.8 14.1l.2 0c10.1 0 16.8-3.8 16.8-14.1 0-9.9 1.1-13.8-3.8-13.8zm-80.7 17.4l-14.7 0 0-19.3 11.4 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-11.4 0 0-18.3 14.4 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-21.7 0c-2.4-.1-3.7 1.3-3.7 3.8l0 59.1c0 2.5 1.3 3.8 3.8 3.8l21.9 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8zm-42-18.5c4.6-2 7.3-6 7.3-12.4l0-11.9c0-10.1-6.7-14.1-16.8-14.1l-13.4 0c-2.5 0-3.8 1.3-3.8 3.8l0 59.1c0 2.5 1.3 3.8 3.8 3.8l3.4 0c2.5 0 3.8-1.3 3.8-3.8l0-22.9 5.6 0 7.4 23.5c.2 1 .8 1.8 1.6 2.4s1.8 .9 2.7 .8l3.3 0c2.8 0 4-1.8 3.2-4.4l-8.1-23.9zm-3.8-14c0 4.8-2.5 6.1-6.1 6.1l-5.8 0 0-20.9 5.8 0c3.6 0 6.1 1.3 6.1 6.1l0 8.7zM176.1 226c-.1-.5-.2-1-.4-1.4s-.6-.8-1-1.1-.8-.6-1.3-.7-1-.2-1.5-.1l-6.9 0c-.5 0-1 0-1.4 .2s-.9 .4-1.3 .7-.7 .7-.9 1.1-.4 .9-.4 1.4l-11 59.2c-.5 2.7 .9 4.1 3.4 4.1l3 0c.5 .1 1 0 1.5-.2s.9-.4 1.3-.7 .7-.7 .9-1.2 .4-.9 .4-1.4l1.8-11.3 12.2 0 1.8 11.3c0 .5 .2 1 .4 1.4s.5 .9 .9 1.2 .8 .6 1.3 .7 1 .2 1.5 .2l3.5 0c2.6 0 3.9-1.4 3.4-4.1L176.1 226zm-12.3 39.3l4.7-29.7 4.7 29.7-9.4 0zm89.3 20.2l0-53.2 7.5 0c2.5 0 3.8-1.3 3.8-3.8l0-2.1c0-2.5-1.3-3.8-3.8-3.8l-25.8 0c-2.5 0-3.8 1.3-3.8 3.8l0 2.1c0 2.5 1.3 3.8 3.8 3.8l7.3 0 0 53.2c0 2.5 1.3 3.8 3.8 3.8l3.4 0c2.5 0 3.8-1.3 3.8-3.8l0 0zm248-.8l-19.4 0 0-26.7 16.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-16.1 0 0-25.8 19.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-22.2 0c-.3-.1-.5-.1-.8 0s-.5 .2-.7 .4-.3 .4-.4 .7-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l22.5 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l0 0zM408 221.8l-.8 0c-10.1 0-15.3 4.7-15.3 14.1l0 40.1c0 9.3 5.2 14.1 15.3 14.1l.8 0c10.1 0 15.3-4.8 15.3-14.1l0-40.1c0-9.4-5.2-14.1-15.3-14.1l0 0zm10.2 52.4c-.1 8-3 11.1-10.5 11.1s-10.5-3.1-10.5-11.1l0-36.6c0-7.9 3-11.1 10.5-11.1s10.5 3.2 10.5 11.1l0 36.6zm-46.5-14.5c6.1-1.6 9.2-6.1 9.2-13.3l0-9.7c0-9.4-5.2-14.1-15.3-14.1l-13.7 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l1.2 0c.3 0 .5 0 .8-.1s.5-.2 .6-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-26.9 11.6 0 10.4 27.2c.2 .5 .5 .9 .9 1.1s.9 .4 1.4 .4l1.5 0c1.4 0 2-1 1.5-2.3l-10.6-27.3zm-6.4-3.9l-10.2 0 0-28.5 10.2 0c7.5 0 10.5 3.1 10.5 11.1l0 6.4c0 7.8-3 11-10.5 11l0 0zm85.9-33.1l-13.7 0c-.3-.1-.5-.1-.8 0s-.5 .2-.7 .4-.3 .4-.4 .7-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l1.2 0c.3 0 .5 0 .8-.1s.5-.2 .6-.4 .3-.4 .4-.6 .1-.5 .1-.8l0-26.1 10.6 0c10.1 0 15.3-4.8 15.3-14.1l0-10.5c0-9.4-5.2-14.1-15.3-14.1zm10.2 22.8c0 7.9-3 11.1-10.5 11.1l-10.2 0 0-29.2 10.2 0c7.5-.1 10.5 3.1 10.5 11l0 7.1zM259.6 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zM487.2 171.9c-11.7-4.4-23.5-8.1-35.6-11.3 19.6-78 11.6-134.7-22.3-153.9-34.5-19.4-85.9 4.3-138.2 55.2 3.4 3.3 6.8 6.7 10.2 10.2 82.5-80 119.6-53.5 120.9-52.8 22.4 12.7 36 55.8 15.5 137.8-27.8-6.4-56.1-10.7-84.6-13-71.9-100.5-140.6-142.1-182.2-142.1-30.8 0-43.8 21-47.6 27.7-18.1 32-13.3 84.2 .1 133.8-70.5 20.3-120.7 54.1-120.3 95 .5 59.6 103.2 87.8 122.1 92.8-20.5 81.9-10.1 135.6 22.3 153.9 28 15.8 75.1 6 138.2-55.2-3.4-3.3-6.8-6.7-10.2-10.2-82.5 80-119.7 53.5-120.9 52.8-22.3-12.6-36-55.6-15.5-137.9 12.4 2.9 41.8 9.5 84.6 13 71.9 100.4 140.6 142 182.1 142 30.8 0 43.8-21 47.6-27.7 18-31.9 13.3-84.1-.1-133.8 152.3-43.8 156.2-130.2 33.9-176.3l0 0zM136 36.8c2.9-5.1 11.9-20.3 34.9-20.3 36.8 0 98.8 39.6 163.3 126.2-31.3-1.8-62.7-1.5-93.9 .9 13-18.3 27.1-35.8 42.2-52.4-3.4-3.5-6.8-6.9-10.2-10.2-18.3 20.2-35.3 41.7-50.7 64.2-28.5 2.7-56.7 7.6-84.4 14.6-.2-1.4-24.3-82.2-1.2-123l0 0zM440.8 475.1c-2.9 5.1-11.8 20.3-34.9 20.3-36.7 0-98.7-39.4-163.3-126.2 31.3 1.8 62.7 1.5 93.9-.9-13 18.3-27.1 35.8-42.2 52.4 3.4 3.5 6.8 6.9 10.2 10.2 18.4-20.2 35.3-41.7 50.7-64.2 47.3-4.7 80.3-13.5 84.4-14.6 22.7 84.4 4.5 117 1.2 123zm9.1-138.6c-3.6-11.9-7.7-24.1-12.4-36.4-2.1 0-4.2-.5-6.1-1.5s-3.5-2.4-4.6-4.2l-.1 .1c-1.6 1.5-3.4 2.7-5.4 3.6 5.7 14.3 10.6 28.4 14.7 42.2-23.7 6-47.7 10.3-72 13 3.5-5.3 17.2-26.2 32.2-54.2-2.1-.8-4.2-1.9-6-3.2-1.1 1.2-3.6 4.2-10.9 4.2-6.2 11.2-17.4 30.9-33.9 55.2-37.4 3.3-75 3.6-112.4 1-7.9-11.2-21.5-31.1-36.8-57.8-1-.4-2-.9-3-1.5-1.9 1.6-3.9 3.2-12.6 3.2 6.3 11.2 17.5 30.7 33.8 54.6-24.3-2.3-48.4-6.2-72.2-11.7 3.9-14 8.6-28.3 14.1-42.9-3.2 0-5.4 .2-8.4-1-2.2 .8-4.6 1.1-6.9 1-4.9 13.4-9.1 26.5-12.7 39.4-159.9-42.6-140.3-123.6-1.5-164 3.6 11.9 7.7 24.1 12.4 36.4 10.4 0 12.9 3.4 14.4 5.3 .7-.8 1.4-1.6 2.3-2.2-5.8-14.7-10.9-29.2-15.2-43.3 7-1.8 32.4-8.4 72-13-15.9 24.3-26.7 43.9-32.8 55.3 3.1 1.8 5.3 4.6 6.4 8 2.5-3.7 6.1-6.6 10.2-8.4 6.5-11.7 17.9-31.9 34.8-56.9 37.4-3.3 75-3.6 112.4-1 31.5 44.6 28.9 48.1 42.5 64.5 2.6-3.5 6.3-6 10.4-7.4-6.4-11.4-17.6-31-34.3-55.5 40.4 4.1 65 10 72.2 11.7-4 14.4-8.9 29.2-14.6 44.2 2.5 1 4.8 2.4 6.8 4.3l.1 .1c1-1.5 2.3-2.8 3.8-3.8s3.3-1.6 5.1-1.8c4.9-13.4 9.2-26.6 12.8-39.5 11.7 3.1 23.2 6.8 34.5 11 106.1 39.9 74 87.9 72.6 90.4-19.8 35.1-80.1 55.2-105.7 62.5zm-114.4-114l-1.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.6 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 49.8c0 7.9-2.6 11.1-10.1 11.1s-10.1-3.1-10.1-11.1l0-49.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-1.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 51.5c0 9.6 5 14.1 15.1 14.1l.4 0c10.1 0 15.1-4.6 15.1-14.1l0-51.5c0-.3-.1-.5-.2-.8s-.3-.5-.5-.6-.4-.3-.7-.4-.5-.1-.8-.1zM321.8 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zm-31.1 7.4l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1zm5.1-30.8l-19.4 0 0-26.7 16.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-16.1 0 0-25.8 19.1 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.5-.1-.8s-.2-.5-.4-.7-.4-.3-.7-.4-.5-.1-.8-.1l-22.2 0c-.3 0-.5 0-.8 .1s-.5 .2-.7 .4-.3 .4-.4 .6-.1 .5-.1 .8l0 63c0 .3 0 .5 .1 .8s.2 .5 .4 .6 .4 .3 .7 .4 .5 .1 .8 .1l22.5 0c.3 0 .5 0 .8-.1s.5-.2 .7-.4 .3-.4 .4-.7 .1-.5 .1-.8l0-.8c0-.3 0-.6-.1-.8s-.2-.5-.4-.7-.4-.4-.7-.4-.5-.1-.8-.1l0 0zm-7.4-99.4l-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1-2.3-6.8z"],
    "waze": [512, 512, [], "f83f", "M502.6 201.7c14.5 85.9-30.9 167.9-113.2 208.1 13 34.1-12.4 70.2-48.3 70.2-13.2 0-26-5.1-35.6-14.2s-15.3-21.6-16-34.8c-6.4 .2-64.2 0-76.3-.6-.3 6.8-1.9 13.5-4.7 19.6s-6.9 11.7-11.9 16.3-10.8 8.2-17.2 10.5-13.2 3.4-19.9 3.1c-33.9-1.4-58-34.8-47-67.9-37.2-13.1-72.5-34.9-99.6-70.8-13-17.3-.5-41.8 20.8-41.8 46.3 0 32.2-54.2 43.2-110.3 18.4-93.9 116.8-157.1 211.7-157.1 102.5 0 197.2 70.7 214.1 169.7zM373.9 388.3c42-19.2 81.3-56.7 96.3-102.1 40.5-123.1-64.2-228-181.7-228-83.4 0-170.3 55.4-186.1 136-9.5 48.9 5 131.4-68.7 131.4 24.9 33.1 58.3 52.6 93.7 64 24.7-21.8 63.9-15.5 79.8 14.3 14.2 1 79.2 1.2 87.9 .8 3.5-6.9 8.5-12.9 14.7-17.5s13.2-7.9 20.8-9.5 15.4-1.4 22.9 .4 14.5 5.3 20.5 10.2zM205.5 187.1c0-34.7 50.8-34.7 50.8 0s-50.8 34.7-50.8 0zm116.6 0c0-34.7 50.9-34.7 50.9 0s-50.9 34.8-50.9 0zM199.5 257.8c-3.4-16.9 22.2-22.2 25.6-5.2l.1 .3c4.1 21.4 29.8 44 64.1 43.1 35.7-.9 59.3-22.2 64.1-42.8 4.5-16.1 28.6-10.4 25.5 6-5.2 22.2-31.2 62-91.5 62.9-42.6 0-80.9-27.8-87.9-64.2l0 0z"],
    "creative-commons-remix": [512, 512, [], "f4ee", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zM418.1 260.4l4.9 2.2 0 70c-7.2 3.6-63.4 27.5-67.3 28.8-6.5-1.8-113.7-46.8-137.3-56.2l-64.2 26.6-63.3-27.5 0-63.8 59.3-24.8c-.7-.7-.4 5-.4-70.4l67.3-29.7 151.9 62.9 0 61.6 49.1 20.3zm-70.4 81.5l0-43.8-.4 0 0-1.8-113.8-46.5 0 45.2 113.8 46.9 0-.4 .4 .4zm7.5-57.6l39.9-16.4-36.8-15.5-39 16.4 35.9 15.5zm52.3 38.1l0-43-44.3 18.6 0 43.4 44.3-19z"],
    "bandcamp": [512, 512, [], "f2d5", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm48.2 326.1l-181 0 84.7-156.1 181 0-84.7 156.1z"],
    "square-web-awesome-stroke": [448, 512, [], "e684", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm235 81.6l53 46.4 52.2-10.4c-2.6-3.9-4.2-8.5-4.2-13.6 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13-10.3 23.6-23.2 24L304.5 349.1c-5.2 11.5-16.6 18.9-29.2 18.9l-102.6 0c-12.6 0-24-7.4-29.2-18.9L87.2 224c-12.9-.4-23.2-11-23.2-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 5-1.5 9.7-4.2 13.6L160 224 213.1 177.6c-8.9-4.1-15-13.1-15-23.6 0-14.4 11.6-26 26-26s26 11.6 26 26c0 10.5-6.2 19.5-15.1 23.6z"],
    "vimeo-v": [448, 512, [], "f27d", "M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3-35.2-129.2-50.2-204.9-79.3-204.9-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"],
    "strava": [384, 512, [], "f428", "M158.4 0L7 292 96.2 292 158.4 175.9 220.1 292 308.6 292 158.4 0zM308.6 292l-43.9 88.2-44.6-88.2-67.6 0 112.2 220 111.5-220-67.6 0z"],
    "uniregistry": [384, 512, [], "f404", "M192 480c39.5 0 76.2-11.8 106.8-32.2l-213.5 0C115.8 468.2 152.5 480 192 480zM102.9 286.9l0-12.4-102.9 0 0 12.4c0 2.5 0 5 .1 7.4l103.1 0c-.2-2.4-.3-4.9-.3-7.4zm20.5 57l-114.9 0c2.6 8.5 5.8 16.8 9.6 24.8l138.3 0c-12.9-5.7-24.1-14.2-33-24.8zm-17.7-34.7l-104.4 0c.9 7.6 2.2 15 3.9 22.3l109.7 0c-4-6.9-7.2-14.4-9.2-22.3zm-2.8-69.3l-102.9 0 0 17.3 102.9 0 0-17.3zm0-173.2l-102.9 0 0 4.9 102.9 0 0-4.9zm0-34.7l-102.9 0 0 2.5 102.9 0 0-2.5zm0 69.3l-102.9 0 0 7.4 102.9 0 0-7.4zm0 104l-102.9 0 0 14.8 102.9 0 0-14.8zm0-69.3l-102.9 0 0 9.9 102.9 0 0-9.9zm0 34.6l-102.9 0 0 12.4 102.9 0 0-12.4zM269.1 331.5l109.7 0c1.8-7.3 3.1-14.7 3.9-22.3l-104.4 0c-2.1 7.9-5.2 15.4-9.2 22.3zm12-185.7l102.9 0 0-9.8-102.9 0 0 9.8zm0 37.2l102.9 0 0-12.4-102.9 0 0 12.4zm0-74.3l102.9 0 0-7.4-102.9 0 0 7.4zm0-76.7l0 2.5 102.9 0 0-2.5-102.9 0zM78.1 442.9l227.7 0c11.8-8.7 22.7-18.6 32.2-29.7l-293.1 0c9.6 11 21.4 21 33.2 29.7zm203-371.3l102.9 0 0-4.9-102.9 0 0 4.9zm0 148.5l102.9 0 0-14.8-102.9 0 0 14.8zM38.8 405.7l305.3 0c6.7-8.5 12.6-17.6 17.8-27.2L23 378.5c5.2 9.6 9.2 18.7 15.8 27.2zm188.8-37.1l139.4 0c3.7-8 5.8-16.2 8.5-24.8l-115 0c-8.8 10.7-20.1 19.2-32.9 24.8zm53.5-81.7c0 2.5-.1 5-.4 7.4l103.1 0c.1-2.5 .2-4.9 .2-7.4l0-12.4-102.9 0 0 12.4zm0-29.7l102.9 0 0-17.3-102.9 0 0 17.3z"],
    "cc-diners-club": [576, 512, [], "f24c", "M239.7 79.9a175.8 175.8 0 1 0 0 351.6 175.8 175.8 0 1 0 0-351.6zM199.8 359.5c-41.7-15.9-71.4-56.4-71.4-103.8s29.7-87.9 71.4-104.1l0 207.9zm79.8 .3l0-208.2c41.7 16.2 71.4 56.7 71.4 104.1s-29.7 87.9-71.4 104.1zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM329.7 448l-90.3 0C133.2 448 45.6 362.5 45.6 257.8 45.6 143.2 133.2 64 239.4 64l90.3 0c105 0 200.7 79.2 200.7 193.8 0 104.7-95.7 190.2-200.7 190.2z"],
    "pinterest": [512, 512, [], "f0d2", "M504 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3 .8-3.4 5-20.3 6.9-28.1 .6-2.5 .3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2C161.5 437.2 163.5 467.4 165.6 487 73.4 450.9 8 361.1 8 256 8 119 119 8 256 8S504 119 504 256z"],
    "algolia": [512, 512, [], "f36c", "M256 0c-139.9 0-254 112.7-256 252.1-2 141.5 112.9 258.7 254.5 259.5 43.7 .3 85.9-10.4 123.3-30.7 3.6-2 4.2-7 1.1-9.7l-24-21.2c-4.9-4.3-11.8-5.5-17.8-3-26.1 11.1-54.5 16.8-83.7 16.4-114.4-1.5-206.9-96.6-205.1-211 1.8-112.9 94.3-204.2 207.7-204.2l207.7 0 0 369-117.8-104.7c-3.8-3.4-9.7-2.7-12.7 1.3-18.9 25-49.7 40.6-83.9 38.2-47.5-3.3-85.9-41.5-89.5-88.9-4.2-56.6 40.6-103.9 96.3-103.9 50.4 0 91.9 38.8 96.2 88 .4 4.4 2.4 8.5 5.7 11.4l30.7 27.2c3.5 3.1 9 1.2 9.9-3.4 2.2-11.8 3-24.2 2.1-36.8-4.9-72-63.3-130-135.4-134.4-82.7-5.1-151.8 59.5-154 140.6-2.1 78.9 62.6 147 141.6 148.7 33 .7 63.6-9.6 88.3-27.6L495 509.4c6.6 5.8 17 1.2 17-7.7l0-492c0-5.4-4.4-9.7-9.7-9.7L256 0z"],
    "stackpath": [448, 512, [], "f842", "M244.6 232.4c0 8.5-4.3 20.5-21.3 20.5l-19.6 0 0-41.5 19.6 0c17.1 0 21.3 12.4 21.3 21zM448 32l0 448-448 0 0-448 448 0zM151.3 287.8c0-21.2-12.1-34.5-46.7-44.8-20.6-7.4-26-10.9-26-18.6s7-14.6 20.4-14.6c14.1 0 20.8 8.4 20.8 18.4l30.7 0 .2-.6c.5-19.6-15.1-41.6-51.1-41.6-23.4 0-52.6 10.8-52.6 38.3 0 19.4 9.2 31.3 50.7 44.4 17.3 6.2 21.9 10.4 21.9 19.5 0 15.2-19.1 14.2-19.5 14.2-20.4 0-25.7-9.1-25.7-21.9l-30.8 0-.2 .6c-.7 31.3 28.4 45.2 56.6 45.2 30 0 51.1-13.6 51.1-38.3zm125.4-55.6c0-25.3-18.4-45.5-53.4-45.5l-51.8 0 0 138.2 32.2 0 0-47.4 19.6 0c30.3 0 53.4-16 53.4-45.4zM297.9 325l49.1-138.2-31.1 0-47.9 138.2 29.9 0zM404.5 186.8l-31.1 0-47.9 138.2 29.9 0 49.1-138.2z"],
    "octopus-deploy": [512, 512, [], "e082", "M455.7 349.2c-45.9-39.1-36.7-77.9-16.1-128.1 35.7-87-23.5-186.9-109.6-212.8-92.9-27.9-195.7 16-230.3 108.8-8.7 23.5-12.5 48.5-11 73.5 1.7 29.5 14.7 53 24.1 80.3 17.2 50.2-28.1 92.7-66.7 117.6-46.8 30.2-36.3 39.9-8.4 41.9 23.4 1.7 44.5-4.5 65.3-15 9.2-4.6 40.7-18.9 45.1-28.6-12.2 26.6-37 72.7-21.5 102.1 19.1 36.2 67.1-31.8 76.7-45.8 8.6-12.6 43-81.3 63.6-46.9 18.9 31.4 8.6 76.4 35.7 104.6 32.9 34.2 51.2-18.3 51.4-44.2 .2-16.4-6.1-95.9 29.9-59.9 21.4 21.4 52.9 71.2 88.6 67 38.7-4.5-22.1-68-28.3-78.7 5.4 4.3 53.7 34.1 53.8 9.5 .1-18.8-30.1-34.7-42.5-45.3z"],
    "yammer": [512, 512, [], "f840", "M500.7 159.5c-.4-1.8-1.2-3.4-2.3-4.8s-2.5-2.6-4.1-3.5c-3.1-1.6-6.7-2-10.1-1.1l-26.4 6.6 0-.2-22.3 5.8-1.2 .3-.6-2.2c-15.5-58.3-45-111.9-86.1-156.2-2.6-2.7-6.1-4.2-9.8-4.3s-7.3 1.3-10 3.8l-102.9 102.7-199.9 0c-6.6 0-12.9 2.6-17.6 7.3S0 124.8 0 131.4l0 249C0 387 2.6 393.3 7.3 398s11 7.3 17.6 7.3L225 405.3 328.1 508c2.6 2.6 6 4 9.7 4s7.1-1.4 9.7-4c.1-.1 .2-.3 .4-.4 29.3-31.5 52.8-67.8 69.6-107.4 6.9-16.5 12.7-33.5 17.3-50.8l0 0 20.4 5.3 0-.1 28.3 7.3c.9 .2 1.7 .4 2.6 .5 1.4 .2 2.8 .2 4.1-.1 2.5-.5 4.8-1.7 6.7-3.4s3.2-4 3.8-6.5c15.2-63.4 15.2-129.6 .1-193l0 0zM337.1 24.7l0 0 0 0 0 0zM226.9 189.8l-52.6 91.3c-1 1.7-1.5 3.7-1.5 5.7l0 46.2c0 5.8-2.3 11.4-6.5 15.6s-9.7 6.4-15.6 6.4l-3.4 0c-5.8 0-11.4-2.3-15.6-6.4s-6.5-9.7-6.5-15.6l0-45.7c0-1.9-.5-3.8-1.4-5.5L72.3 189.6c-1.9-3.4-2.8-7.1-2.8-11s1.1-7.6 3-10.9 4.7-6.1 8.1-8 7.1-2.9 11-2.9l3.3 0c4 0 8 1.1 11.5 3.2s6.3 5.1 8.1 8.7l36.4 70.3 37.5-70.5c1.8-3.5 4.6-6.4 7.9-8.4s7.2-3.2 11.1-3.2 7.8 .9 11.2 2.8 6.3 4.7 8.2 8.1c2 3.3 3 7.1 3 11s-1 7.7-3 11l0 0zM337.1 24.7c35.9 40.6 61.9 89 75.8 141.3l.6 2-114.1 29.6 0-66.1c0-6.6-2.7-12.9-7.3-17.6s-11-7.3-17.6-7.3l-19.4 0 82.1-81.8zM397.6 392l0 0 0 0c-14.7 34.8-35.1 67-60.2 95.2l-82.2-81.9 19.2 0c6.6 0 12.9-2.6 17.6-7.3s7.3-11 7.3-17.6l0-66.2 114.6 29.9c-4.4 16.3-9.8 32.3-16.3 47.9l0 0zm84-52.4l0 0-50.6-13.1-131.7-34.3 0-72.5 119.7-31 4.5-1.2c29.9-7.7 49.2-12.8 58.1-15.1 12 55.1 12 112.1 0 167.2z"],
    "modx": [448, 512, [], "f285", "M356 241.8l36.7 23.7 0 214.5-133-83.8 96.3-154.4zM440 75l-213.7 0-23 37.8 153.5 96.5 83.2-134.3zM351 217.8l-295.8-185.8 0 214.5 46 29 249.8-57.7zM97 294.2L8 437 221.7 437 346.7 236.5 97 294.2z"],
    "square-threads": [448, 512, [], "e619", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM294.2 244.3c19.5 9.3 33.7 23.5 41.2 40.9 10.4 24.3 11.4 63.9-20.2 95.4-24.2 24.1-53.5 35-95.1 35.3l-.2 0c-46.8-.3-82.8-16.1-106.9-46.8-21.5-27.3-32.6-65.4-33-113.1l0-.2c.4-47.7 11.5-85.7 33-113.1 24.2-30.7 60.2-46.5 106.9-46.8l.2 0c46.9 .3 83.3 16 108.2 46.6 12.3 15.1 21.3 33.3 27 54.4l-26.9 7.2c-4.7-17.2-11.9-31.9-21.4-43.6-19.4-23.9-48.7-36.1-87-36.4-38 .3-66.8 12.5-85.5 36.2-17.5 22.3-26.6 54.4-26.9 95.5 .3 41.1 9.4 73.3 26.9 95.5 18.7 23.8 47.4 36 85.5 36.2 34.3-.3 56.9-8.4 75.8-27.3 21.5-21.5 21.1-47.9 14.2-64-4-9.4-11.4-17.3-21.3-23.3-2.4 18-7.9 32.2-16.5 43.2-11.4 14.5-27.7 22.4-48.4 23.5-15.7 .9-30.8-2.9-42.6-10.7-13.9-9.2-22-23.2-22.9-39.5-1.7-32.2 23.8-55.3 63.5-57.6 14.1-.8 27.3-.2 39.5 1.9-1.6-9.9-4.9-17.7-9.8-23.4-6.7-7.8-17.1-11.8-30.8-11.9l-.4 0c-11 0-26 3.1-35.6 17.6l-23-15.8c12.8-19.4 33.6-30.1 58.5-30.1l.6 0c41.8 .3 66.6 26.3 69.1 71.8 1.4 .6 2.8 1.2 4.2 1.9l.1 .5zm-71.8 67.5c17-.9 36.4-7.6 39.7-48.8-8.8-1.9-18.6-2.9-29-2.9-3.2 0-6.4 .1-9.6 .3-28.6 1.6-38.1 15.5-37.4 27.9 .9 16.7 19 24.5 36.4 23.6l-.1-.1z"],
    "old-republic": [512, 512, [], "f510", "M243.8 10.2c7.5-.3 15-.3 22.5-.1 3.6 .1 7.2 .4 10.8 .7 4.9 .3 9.8 1 14.7 1.6 2.9 .4 5.8 1 8.7 1.5 7.9 1.3 15.7 3.3 23.4 5.4 12.2 3.5 24.2 7.9 35.8 13.2 26.6 12.2 50.9 29.2 71.6 49.9 20 20.1 36.7 43.5 48.9 69.2 1.1 2.6 2.4 5.1 3.5 7.7 2.8 6.4 5.4 13 7.6 19.6 4.1 12.3 7.3 25 9.4 37.8 .6 3.1 1 6.3 1.4 9.5 .5 3.8 .9 7.7 1.2 11.6 .8 8.3 .8 16.7 .8 25.1-.1 5-.3 9.9-.7 14.9-.2 3.4-.5 6.8-1 10.1-.4 2.7-.6 5.5-1.1 8.2-.9 5.1-1.7 10.3-2.9 15.4-4.1 18.5-10.3 36.6-18.5 53.6-15.8 32.8-38.8 62.2-67.1 85.1-17.3 14.1-36.4 25.9-56.9 34.9-6.2 2.7-12.5 5.3-18.9 7.4-3.5 1.2-7 2.4-10.6 3.4-6.6 1.9-13.3 3.6-20 5-4.7 .9-9.3 1.7-14 2.5-5.3 .7-10.5 1.4-15.8 1.7-6.7 .7-13.4 .8-20.1 .8-6.8 0-13.6-.1-20.4-.8-3.3-.2-6.6-.5-9.8-1-2.7-.4-5.5-.6-8.2-1.1-4.1-.7-8.2-1.4-12.4-2.2-4.2-.9-8.5-1.9-12.7-3-8.6-2.2-17.1-5-25.4-8.1-10.5-4.1-20.8-8.7-30.6-14.2-2.1-1.2-4.3-2.3-6.4-3.6-11.2-6.6-21.9-14.1-31.9-22.3-34.7-28.4-61.4-66.4-76.4-108.7-3.1-8.7-5.7-17.6-7.8-26.7-1.5-6.2-2.5-12.4-3.6-18.7-.4-2.3-.6-4.7-1-7.1-.6-4-.8-8-1.2-11.9-.8-9.5-.7-19-.5-28.5 .1-3.5 .3-7 .7-10.5 .3-3.2 .5-6.4 .9-9.5 .4-2.8 .7-5.6 1.2-8.4 .7-3.9 1.3-7.9 2.1-11.8 3.4-16.5 8.5-32.7 15.3-48.2 1.2-2.9 2.6-5.7 3.9-8.6 8.1-16.7 17.9-32.6 29.5-47.1 20-25.4 45.1-46.7 73.3-62.5 7.5-4.2 15.2-8 23.1-11.4 15.8-6.9 32.4-12 49.3-15.4 3.5-.7 7-1.2 10.6-1.8 2.6-.5 5.3-.7 7.9-1.1 3.5-.5 7.1-.7 10.6-1 2.5-.2 4.9-.4 7.4-.5zm8.6 24.4c-9.2 .1-18.4 1-27.6 2.2-7.3 1.1-14.5 2.6-21.7 4.3-13.9 3.5-27.5 8.3-40.5 14.4-10.5 5-20.6 10.7-30.2 17.2-4.2 2.9-8.4 5.8-12.3 9-5.1 4-10 8.2-14.7 12.6-2.5 2.2-4.8 4.7-7.2 7.1-28.2 28.8-48.4 65.4-57.5 104.7-2 8.4-3.5 17-4.4 25.6-1.1 8.9-1.4 17.9-1.4 26.8 .1 7.1 .4 14.3 1.2 21.4 .6 7.1 1.9 14.2 3.2 21.2 1.1 4.6 2 9.3 3.3 13.9 6.3 23.4 16.5 45.7 30.1 65.8 8.6 13 18.8 24.9 30 35.8 16.3 15.8 35 29 55.3 39.2 7.3 3.5 14.7 6.9 22.3 9.6 5 1.8 10.1 3.6 15.2 5 11.3 3.2 22.8 5.6 34.4 7.1 2.9 .3 5.8 .6 8.7 .9 13.8 1.1 27.7 1 41.5-.4 4.4-.6 8.9-1 13.3-1.8 3.6-.7 7.3-1.2 10.9-2.1 4.1-1 8.3-1.9 12.4-3.1 26.5-7.3 51.6-19.7 73.6-36.2 15.8-11.8 30-25.8 42.1-41.3 3.3-4 6.2-8.3 9.1-12.6 3.4-5.1 6.6-10.2 9.6-15.5 2.4-4.4 4.7-8.9 7-13.4 5.7-12.1 10.3-24.6 13.8-37.5 2.6-10 4.7-20.2 5.9-30.4 1.8-13.5 1.9-27.1 1.3-40.7-.3-3.9-.7-7.8-1-11.7-2.2-19.1-6.8-37.9-13.8-55.8-6-15.1-13.5-29.6-22.6-43.1-12.7-18.8-28.2-35.7-46-49.8-25-20-54.5-34.5-85.6-42.1-7.8-1.9-15.7-3.3-23.6-4.4-3.9-.6-7.8-.8-11.8-1.2-7.4-.6-14.8-.7-22.2-.6zM147.3 83.5c13.3-8.9 28.1-15.4 43.3-20.2-3.2 1.8-6.4 3.4-9.5 5.3-11.2 6.7-21.5 14.9-30.4 24.5-6.8 7.4-12.8 15.7-17 24.9-3.3 6.9-5.6 14.2-6.9 21.7-.9 4.8-1.3 9.8-1.2 14.8 .1 13.7 4.4 27.1 11.3 38.8 5.9 10.2 13.6 19.3 22.4 27.3 4.9 4.4 10.2 8.1 15 12.6 2.3 2.2 4.5 4.4 6.4 6.9 2.6 3.3 4.9 7 6 11.1 .9 3 .7 6.2 .7 9.3 0 4.1 0 8.2 0 12.3 .1 3.5 0 7.1 .1 10.6 .1 2.4 0 4.8 .1 7.1 .2 5.8 .1 11.5 .1 17.3 .1 2.9 0 5.8 .1 8.7 0 1.6 .1 3.3 0 4.9-.9 .1-1.8 .2-2.7 .2-11 0-21.9-2.6-32-6.9-6-2.7-11.8-5.9-17.1-9.8-5.8-4.2-11.1-9-15.8-14.3-6.5-7.2-12-15.4-16.6-23.9-1.1-2-2.2-4-3.2-6.1-1.2-2.6-2.6-5.1-3.7-7.8-4-9.7-6.6-19.9-8.1-30.3-.5-4.4-1.1-8.9-1.2-13.3-.7-15.7 .8-31.6 4.7-46.8 2.1-8.2 4.8-16.2 8.3-23.8 6.3-14.2 15.3-27.2 26.3-38.2 6.3-6.2 13.1-11.8 20.5-16.7zM322.7 63.4c2.7 .7 5.4 1.7 8.1 2.7 6.4 2.3 12.7 4.8 18.7 8 13.1 6.4 25.3 14.8 35.8 25 10.2 10 18.7 21.6 25.1 34.3 1.3 2.7 2.6 5.5 3.8 8.3 6.3 15.1 10 31.3 11.2 47.6 .4 4.5 .4 9.1 .5 13.6 .1 11.6-1.5 23.3-4.3 34.5-2 7.3-4.3 14.5-7.9 21.2-3.2 6.6-6.7 13.2-10.8 19.2-6.9 10.5-15.6 19.9-25.8 27.2-10.5 7.6-22.6 13-35.4 15.4-3.5 .7-7.1 1.1-10.7 1.2-1.8 .1-3.7 .2-5.6-.1-.3-2.1 0-4.3 0-6.5 0-3.7 .1-7.4 .1-11.2 .2-7 0-14.1 .2-21.1 0-2.4 0-4.8 0-7.1 .2-5.1 0-10.1 .1-15.2 .1-3-.2-6 .5-9 .7-2.5 1.8-4.9 3.1-7.1 4.5-7.3 11.1-13 17.7-18.3 5.4-4.2 10.5-8.8 15-13.8 7.7-8.4 14.2-17.9 18.8-28.3 2.5-5.9 4.5-12.1 5.5-18.5 .9-4.4 1.1-8.8 1-13.3 0-7.8-1.4-15.6-3.6-23.2-1.8-5.7-4.3-11.2-7.1-16.4-3.9-6.9-8.6-13.3-14-19.2-9.9-10.8-21.8-19.9-34.6-27.1-1.8-1-3.8-1.8-5.6-3zM221.9 121.9c1-1.2 2-2.3 3.1-3.4-.6 .9-1.3 1.8-2 2.7-3.1 3.9-5.5 8.3-7 13.1-.9 3.3-1.7 6.6-1.7 10-.1 2.5-.1 5.1 .3 7.6 1.1 7.6 4.3 14.9 8.8 21.1 2 2.7 4.2 5.3 6.9 7.3 1.6 1.3 3.5 2.1 5.3 3 3.1 1.7 6.3 3.2 9.1 5.5 2.7 2.1 4.6 5.3 4.4 8.8 0 73.7 0 147.3 0 221 0 1.4-.1 2.7 0 4 .1 1.5 .8 2.8 1.5 4.1 .9 1.7 1.8 3.3 3.2 4.6 .9 .8 2 1.4 3.2 1.2 1.5-.2 2.7-1.4 3.4-2.6 1-1.5 1.7-3.2 2.3-4.9 .8-2.1 .4-4.4 .5-6.6 .1-4 0-8.1 .1-12.1 0-5.9 0-11.8 .1-17.7 .1-3.6 0-7.2 .1-10.9 .2-4 0-8.1 .1-12.1 0-6 0-12 .1-18 .1-3.6 0-7.2 .1-10.9 .1-3.9 0-7.9 .1-11.8 0-6 0-12 .1-18 .2-3.9 0-7.9 .2-11.8 .3 1.4 .1 2.9 .2 4.4 .2 3.6 .4 7.2 .8 10.8 .3 3.4 .4 6.9 .9 10.3 .4 3.1 .5 6.2 1 9.3 .6 4.1 .9 8.2 1.5 12.3 1.5 9 2.8 18.1 5.1 27 1.1 4.8 2.4 9.6 4 14.3 2.5 7.9 5.7 15.7 10.3 22.6 1.7 2.6 3.9 5 6.1 7.2 .3 .2 .6 .5 .9 .7 .6 .3 1.3-.1 1.7-.6 .7-.9 1.2-1.9 1.7-2.9 4.1-7.8 8.2-15.6 12.3-23.3 .7-1.3 1.4-2.6 2.6-3.6 1.8-1.6 3.8-2.7 6-3.6 2.9-1.2 5.9-2.2 9-2.4 6.6-.6 13.1 .7 19.6 1.8 3.7 .6 7.4 1.2 11.1 1.4 3.7 .1 7.5 .1 11.2-.3 8.6-.9 17-3 24.9-6.2 5.3-2.2 10.5-4.8 15.3-7.9 11.5-7.2 21.5-16.6 30-27 1.2-1.4 2.2-2.9 3.5-4.3-1.2 3.2-2.7 6.4-4.2 9.5-1.3 2.9-2.8 5.6-4.3 8.4-5.2 9.6-11 18.9-17.8 27.5-4 5.2-8.5 10.1-13.3 14.6-6.6 6.1-14.1 11.4-22.4 14.8-8.2 3.4-17.3 4.6-26.1 3.3-3.6-.6-7-1.7-10.4-2.9-2.8-1-5.4-2.4-8-3.7-3.4-1.7-6.6-3.8-9.7-6.1 2.7 3.1 5.7 5.9 8.7 8.6 4.3 3.8 8.7 7.3 13.6 10.2 4 2.5 8.3 4.4 12.8 5.5 1.5 .4 3 .5 4.5 .6-1.3 1.1-2.6 2-4 3-9.6 6.5-20 11.9-30.7 16.4-20.9 8.7-43.2 14-65.7 15.3-4.7 .2-9.3 .4-14 .4-5-.1-10-.1-14.9-.7-11.2-.8-22.3-2.7-33.2-5.4-10.4-2.7-20.6-6.1-30.3-10.6-8.7-3.9-17.1-8.4-25-13.8-1.8-1.3-3.7-2.5-5.4-4.1 6.6-1.2 13-3.4 19-6.5 5.7-2.9 11-6.7 15.6-11.1 2.2-2.2 4.3-4.6 6.2-7.1-3.4 2.1-6.9 4.2-10.6 5.8-4.4 2.2-9.1 3.8-13.8 5-5.7 1.5-11.7 1.7-17.6 1.1-8.1-1-15.9-4.3-22.5-9-4.3-2.9-8.2-6.4-12-10.1-9.9-10.2-18.2-21.8-25.7-33.9-3.9-6.3-7.5-12.7-11.1-19.2-1-2-2.1-4.1-3.2-6.1 2.8 2.9 5.6 6 8.4 8.9 19.2 19.2 37.6 32.3 53.7 35.5 3.1 .7 6.3 .5 9.5 .8 2.8 .3 5.6 .2 8.3 .3 5 .1 10.1 0 15.2-.2 3.6-.2 7.3-.7 10.9-1.1 2.1-.2 4.1-.7 6.1-1.2 3.9-1 8.1-1 11.8 .6 4.8 1.8 8.4 5.6 11.4 9.7 2.2 3 4.1 6.2 5.7 9.6 1.2 2.4 2.5 4.8 3.6 7.3 1 2.2 2.2 4.4 3.4 6.5 .7 1 1.4 2.2 2.6 2.6 1.1-.8 1.7-1.9 2.3-3 2.1-4.2 3.4-8.6 4.9-13 2-6.6 3.8-13.3 5.2-20 2.2-9.3 3.2-18.7 4.5-28.1 .6-4 .8-8 1.3-12 .9-10.6 1.9-21.3 2.2-31.9 .1-1.9 .2-3.7 .3-5.6 0-4.3 .2-8.7 .2-13 0-2.4 0-4.8 0-7.1 0-5.1-.2-10.1-.2-15.2-.2-6.6-.7-13.2-1.3-19.8-.7-5.9-1.5-11.8-3.1-17.5-2-7.7-5.6-15-9.8-21.8-3.2-5.1-6.8-9.9-11.1-14-3.9-3.9-8.6-7.1-13.9-8.4-1.5-.4-3.1-.4-4.6-.6 .1-3 .7-5.9 1.3-8.8 1.6-7.7 3.8-15.3 6.8-22.6 1.5-4 3.4-7.9 5.4-11.7 3.4-6.6 7.6-12.8 12.5-18.5zm31.3 1.7c.4-.1 .7-.1 1.1-.2 .2 1.8 .1 3.6 .1 5.4l0 38.1c0 1.7 .1 3.5-.2 5.2-.4 0-.7 0-1.1 0-.9-3.8-1.7-7.6-2.6-11.3-.4-1.5-.6-3.1-1.1-4.6-1.7-.2-3.4-.2-5.2-.2-5.1 0-10.1 0-15.2 0-1.7 0-3.3 .1-5 0 0-.4-.3-.9 .2-1.2 1.3-.7 2.7-.9 4.1-1.4 3.4-1.1 6.9-2.2 10.3-3.3 1.4-.5 2.9-.7 4.2-1.5 0-.6 0-1.1 0-1.7-1.2-.6-2.5-.9-3.8-1.3-3.1-1-6.3-2-9.4-3-1.8-.6-3.7-1-5.4-1.8 0-.4-.1-.7-.1-1.1 5.1-.2 10.2 .1 15.3-.1 3.4-.1 6.7 .1 10.1-.1 .1-.4 .3-.8 .4-1.2 1.1-4.9 2.3-9.8 3.4-14.7zm6-.2c.4 0 .7 .1 1.1 .2 1 3.8 1.7 7.8 2.7 11.6 .4 1.4 .6 2.9 1 4.3 2.5 .2 5.1 0 7.6 0 5.2 .1 10.3 .1 15.5 .1 .8 0 1.5 0 2.3 .1 0 .4-.1 .7-.1 1.1-1.8 .8-3.8 1.2-5.7 1.9-3.7 1.2-7.5 2.4-11.2 3.6-.6 .2-1.1 .4-1.7 .6-.2 .6-.2 1.1-.1 1.7 .9 .5 1.8 .8 2.8 1.1 4.9 1.5 9.7 3.1 14.6 4.6 .4 .1 .8 .3 1.1 .5 .4 .3 .2 .8 .2 1.2-1.7 .1-3.3 0-5 0-5.2 0-10.3 0-15.5 0-1.6 0-3.2 0-4.8 .2-.5 1.7-.7 3.4-1.2 5.1-.9 3.6-1.5 7.2-2.5 10.8-.4 0-.7 0-1.1 .1-.3-1.7-.2-3.5-.2-5.2l0-38.1c0-1.8-.1-3.6 .1-5.4zm-186 45c1.1-2.2 2.1-4.4 3.4-6.5-1.8 7.6-2.9 15.3-3.6 23-.8 7.7-.8 15.5-.5 23.2 1.1 19.9 5.5 39.8 14.2 57.9 3 6 6.4 11.8 10.5 17.1 6.1 7.5 12.5 14.8 19.8 21.1 4.8 4.1 10 7.8 15.5 10.8 3.3 1.7 6.5 3.4 9.9 4.7 5 2 10.2 3.6 15.4 4.9 3.8 1 7.8 1.4 11.5 2.7 5 1.6 9.5 4.6 13 8.4 4.9 5.2 8.1 11.9 10.2 18.7 1 2.9 1.6 5.9 2.2 8.9 .2 .8 .2 1.5 .2 2.3-6.5 2.8-13.3 5.1-20.3 6.2-4.1 .8-8.3 1-12.5 1.1-10.2 .2-20.5-1.8-30.1-5.1-3.7-1.4-7.5-2.9-11-4.7-8.1-3.8-15.6-8.7-22.5-14.5-2.9-2.6-5.8-5.1-8.4-8-9.2-9.8-16.3-21.4-21.8-33.7-2.4-5.5-4.6-11.2-6.4-17-1.2-3.9-2.4-7.9-3.3-11.9-.7-2.9-1.2-5.9-1.9-8.9-.5-2.1-.7-4.3-1-6.5-.8-5.4-1.3-10.9-1.3-16.4 .1-6.2 .2-12.4 1.1-18.5 .4-2.9 .7-5.7 1.2-8.6 1-5.7 2.1-11.4 3.7-16.9 3.1-11.6 7.5-23 12.7-33.8zm363.7-6.4c1.1 1.7 1.9 3.5 2.8 5.3 2.1 4.5 4.2 8.9 6 13.5 7.6 18.8 12.3 38.8 13 59 0 1.8 .1 3.5 .1 5.3 .1 9.6-1.3 19.1-3.2 28.5-.7 3.6-1.5 7.2-2.6 10.7-4 14.7-10 29-18.4 41.8-8.2 12.6-19 23.5-31.8 31.4-5.7 3.6-11.8 6.6-18 9.2-5.8 2.2-11.7 4-17.8 5.1-6.4 1-12.9 1.5-19.4 1.2-7.9-.5-15.8-2.1-23.2-4.8-1.9-.8-3.9-1.5-5.8-2.3-.2-1.5 .2-3 .5-4.5 1.2-5.7 3-11.4 5.7-16.6 2.4-4.5 5.5-8.7 9.5-11.9 2.4-2.1 5.2-3.6 8.2-4.8 3.6-1.5 7.5-2 11.2-2.8 7.2-1.7 14.4-3.9 21.2-7 10.3-4.7 19.7-11.4 27.6-19.5 1.6-1.6 3.2-3.2 4.7-4.9 3.4-3.8 6.7-7.6 9.8-11.5 7.5-10.1 12.8-21.6 16.7-33.5 1.6-5.3 3.2-10.6 4.2-16.1 .6-2.9 1-5.8 1.5-8.7 .9-6.1 1.6-12.2 1.7-18.4 .1-6.6 .1-13.3-.5-19.9-.7-8-1.9-16-3.7-23.8z"],
    "suse": [640, 512, [], "f7d6", "M604.5 210a10.4 10.4 0 1 1 -11.4-17.4 10.4 10.4 0 1 1 11.4 17.4zM621 187.2a38.5 38.5 0 1 1 -75 17.6 38.5 38.5 0 1 1 75-17.6zM433.7 336.7c3.2 4.6 5.8 9 7.3 13.4 1 3.1 2.4 7.3 5.5 8.9 .2 .1 .3 .2 .5 .2 5.7 2.1 20.3 1.7 20.3 1.7l26.8 0c2.3 0 22.4 0 21.9-2.3-2.4-10.8-14.9-12.7-24.4-18.3-8.7-5.2-17-11.1-20.8-21.3-2-5.2-.8-17.4 2.6-21.8 2.5-3.2 6.1-5.3 10-6.2 4.3-.9 8.8-.1 13.1 .3 5.3 .5 10.6 1.5 15.9 2.2 10.3 1.3 20.6 1.9 31 1.6 17.1-.5 34.2-3.2 50.4-8.7 11.3-3.8 22.4-8.9 32-16.1 10.9-8.1 8.1-7.4-3-6.2-13.3 1.4-26.6 1.6-39.9 .8-12.4-.7-24.7-2.2-35.9-7.9-8.8-4.6-16.4-9.1-23.4-16.2-1-1.1-1.7-4.2 .2-6.2 1.9-1.9 5.8-.8 7 .2 12.2 10.2 30.5 18.6 49.3 19.5 10.2 .5 20.1 .7 30.4 .3 5.1-.2 12.8-.2 17.9-.3 2.6 0 9.8 .7 11.2-2.1 .4-.8 .4-1.8 .3-2.7-1.5-40.9-4.5-86.9-47.3-106.5-31.9-14.6-79.7-37.2-99.9-46.6-4.7-2.2-10.2 1.3-10.2 6.5 0 13.6 .7 33.3 .7 51.1-9.7-9.9-26-16.1-38.4-21.8-14.1-6.5-28.7-12-43.5-16.6-29.8-9.2-60.7-14.9-91.7-18-35.2-3.5-71-1.8-105.7 5.3-56.9 12.2-113.1 39.7-155.7 79.8-26.1 24.6-46.6 59.7-48 95.2-2 50.3 12.1 77.3 38 105.2 41.3 44.4 130.2 50.6 166.2-2 16.2-23.7 19.7-55.8 8-82-11.8-26.2-38.8-45.1-67.4-46-22.2-.7-45.9 10.6-54.5 31.1-6.5 15.7-2.8 35.1 9 47.3 4.6 4.8 10.9 8.7 17.7 7.1 4-.9 7.4-3.9 8-8 .9-6-4.4-9.9-7.6-14.5-5.8-8.3-4.7-20.9 2.7-27.9 6.2-6 15.3-7.8 23.9-7.7 8 0 16.2 1.4 23.1 5.5 9.7 5.7 16.2 16.2 18.4 27.2 6.7 33-20.2 59.9-56.6 62-18.6 1.1-37.6-3.8-52.1-15.5-36.9-29.8-45.9-90.3-3.8-122.7 40-30.7 90.4-22.8 120.2-6.8 23.8 12.8 41.5 33.6 55 56.7 6.7 11.6 12.5 23.7 17.8 36.1 5.1 11.8 9.9 23.8 20.2 32.5 6.8 5.8 15.2 5.6 24.1 5.6l50.8 0c6.9 0 5.2-4.6 2.2-7.7-6.7-6.9-16.4-8.4-25.4-10.9-20.5-5.6-18.4-32.8-12.7-32.8 18.3 0 18.9 .6 34.9 .3 23.2-.3 30.2-1.7 48.3 5 9.7 3.6 19 13.1 25.1 21.7z"],
    "app-store-ios": [448, 512, [], "f370", "M400 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM127 384.5c-5.5 9.6-17.8 12.8-27.3 7.3-9.6-5.5-12.8-17.8-7.3-27.3l14.3-24.7c16.1-4.9 29.3-1.1 39.6 11.4L127 384.5zm138.9-53.9L84 330.6c-11 0-20-9-20-20s9-20 20-20l51 0 65.4-113.2-20.5-35.4c-5.5-9.6-2.2-21.8 7.3-27.3 9.6-5.5 21.8-2.2 27.3 7.3l8.9 15.4 8.9-15.4c5.5-9.6 17.8-12.8 27.3-7.3 9.6 5.5 12.8 17.8 7.3 27.3l-85.8 148.6 62.1 0c20.2 0 31.5 23.7 22.7 40zm98.1 0l-29 0 19.6 33.9c5.5 9.6 2.2 21.8-7.3 27.3-9.6 5.5-21.8 2.2-27.3-7.3-32.9-56.9-57.5-99.7-74-128.1-16.7-29-4.8-58 7.1-67.8 13.1 22.7 32.7 56.7 58.9 102l52 0c11 0 20 9 20 20 0 11.1-9 20-20 20z"],
    "square-dribbble": [448, 512, ["dribbble-square"], "f397", "M165.9 132.5c-38.3 18-66.8 53.3-75.7 95.7 6.1 .1 62.4 .3 126.4-16.7-22.7-40.2-47.1-74.1-50.7-79zm26.1-9.1c3.8 5.1 28.6 38.9 51 80 48.6-18.3 69.1-45.9 71.6-49.4-33.6-29.8-79.3-41.1-122.6-30.6zM277.4 382c-2-12-10-53.8-29.2-103.6-55.1 18.8-93.8 56.4-108.1 85.6 40.5 31.6 93.3 36.7 137.3 18zM227.8 232.6C159.6 253 93.4 252.2 87.4 252l0 4.2c0 35.1 13.3 67.1 35.1 91.4 22.2-37.9 67.1-77.9 116.5-91.8-3.4-7.8-7.2-15.5-11.1-23.2l-.1 0zm72.5 136.9c30.7-20.7 52.5-53.6 58.6-91.6-4.6-1.5-42.3-12.7-85.1-5.8 17.9 49.1 25.1 89.1 26.5 97.4zm-34.8-119c45.5-5.7 90.7 3.4 95.2 4.4-.3-32.3-11.8-61.9-30.9-85.1-2.9 3.9-25.8 33.2-76.3 53.9 4.8 9.8 8.3 17.8 12 26.8zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zM224 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"],
    "uikit": [448, 512, [], "f403", "M443.9 128l0 256-225.9 128-218-128 0-214.3 87.6 45.1 0 117 133.5 75.5 135.8-75.5 0-151-101.1-57.6 87.6-53.1 100.5 57.9zM308.6 49.1l-84.8-49.1-88.6 54.8 86 47.3 87.4-53z"],
    "superpowers": [448, 512, [], "f2dd", "M448 32c-83.3 11-166.8 22-250 33-92 12.5-163.3 86.7-169 180-3.3 55.5 18 109.5 57.8 148.2L0 480c83.3-11 166.5-22 249.8-33 91.8-12.5 163.3-86.8 168.7-179.8 3.5-55.5-18-109.5-57.7-148.2L448 32zM368.3 264.3c-4.2 79.5-74 139.2-152.8 134.5-79.5-4.7-140.7-71-136.3-151 4.5-79.2 74.3-139.3 153-134.5 79.3 4.7 140.5 71 136.1 151z"],
    "youtube": [576, 512, [61802], "f167", "M549.7 124.1C543.5 100.4 524.9 81.8 501.4 75.5 458.9 64 288.1 64 288.1 64S117.3 64 74.7 75.5C51.2 81.8 32.7 100.4 26.4 124.1 15 167 15 256.4 15 256.4s0 89.4 11.4 132.3c6.3 23.6 24.8 41.5 48.3 47.8 42.6 11.5 213.4 11.5 213.4 11.5s170.8 0 213.4-11.5c23.5-6.3 42-24.2 48.3-47.8 11.4-42.9 11.4-132.3 11.4-132.3s0-89.4-11.4-132.3zM232.2 337.6l0-162.4 142.7 81.2-142.7 81.2z"],
    "ember": [640, 512, [], "f423", "M639.9 254.6c-1.1-10.7-10.7-6.8-10.7-6.8s-15.6 12.1-29.3 10.7c-13.7-1.3-9.4-32-9.4-32s3-28.1-5.1-30.4c-8.1-2.4-18 7.3-18 7.3s-12.4 13.7-18.3 31.2l-1.6 .5s1.9-30.6-.3-37.6c-1.6-3.5-16.4-3.2-18.8 3s-14.2 49.2-15 67.2c0 0-23.1 19.6-43.3 22.8s-25-9.4-25-9.4 54.8-15.3 52.9-59.1-44.2-27.6-49-24c-4.6 3.5-29.4 18.4-36.6 59.7-.2 1.4-.7 7.5-.7 7.5s-21.2 14.2-33 18c0 0 33-55.6-7.3-80.9-11.4-6.8-21.3-.5-27.2 5.3 13.6-17.3 46.4-64.2 36.9-105.2-5.8-24.4-18-27.1-29.2-23.1-17 6.7-23.5 16.7-23.5 16.7s-22 32-27.1 79.5-12.6 105.1-12.6 105.1-10.5 10.2-20.2 10.7-5.4-28.7-5.4-28.7 7.5-44.6 7-52.1-1.1-11.6-9.9-14.2c-8.9-2.7-18.5 8.6-18.5 8.6s-25.5 38.7-27.7 44.6l-1.3 2.4-1.3-1.6s18-52.7 .8-53.5-28.5 18.8-28.5 18.8-19.6 32.8-20.4 36.5l-1.3-1.6s8.1-38.2 6.4-47.6c-1.6-9.4-10.5-7.5-10.5-7.5s-11.3-1.3-14.2 5.9-13.7 55.3-15 70.7c0 0-28.2 20.2-46.8 20.4-18.5 .3-16.7-11.8-16.7-11.8s68-23.3 49.4-69.2c-8.3-11.8-18-15.5-31.7-15.3-13.7 .3-30.3 8.6-41.3 33.3-5.3 11.8-6.8 23-7.8 31.5 0 0-12.3 2.4-18.8-2.9s-10 0-10 0-11.2 14-.1 18.3 28.1 6.1 28.1 6.1c1.6 7.5 6.2 19.5 19.6 29.7 20.2 15.3 58.8-1.3 58.8-1.3l15.9-8.8s.5 14.6 12.1 16.7 16.4 1 36.5-47.9c11.8-25 12.6-23.6 12.6-23.6l1.3-.3s-9.1 46.8-5.6 59.7C187.7 319.4 203 318 203 318s8.3 2.4 15-21.2 19.6-49.9 19.6-49.9l1.6 0s-5.6 48.1 3 63.7 30.9 5.3 30.9 5.3 15.6-7.8 18-10.2c0 0 18.5 15.8 44.6 12.9 58.3-11.5 79.1-25.9 79.1-25.9s10 24.4 41.1 26.7c35.5 2.7 54.8-18.6 54.8-18.6s-.3 13.5 12.1 18.6 20.7-22.8 20.7-22.8l20.7-57.2 1.9 0s1.1 37.3 21.5 43.2 47-13.7 47-13.7 6.4-3.5 5.3-14.3zm-578 5.3c.8-32 21.8-45.9 29-39 7.3 7 4.6 22-9.1 31.4-13.7 9.5-19.9 7.6-19.9 7.6zM334.7 136.1s19.1-49.7 23.6-25.5-40 96.2-40 96.2c.5-16.2 16.4-70.7 16.4-70.7zm22.8 138.4c-12.6 33-43.3 19.6-43.3 19.6s-3.5-11.8 6.4-44.9 33.3-20.2 33.3-20.2 16.2 12.4 3.6 45.5zm84.6-14.6s-3-10.5 8.1-30.6c11-20.2 19.6-9.1 19.6-9.1s9.4 10.2-1.3 25.5-26.4 14.2-26.4 14.2z"],
    "bootstrap": [576, 512, [], "f836", "M333.5 201.4c0-22.1-15.6-34.3-43-34.3l-50.4 0 0 71.2 42.5 0c32.8-.1 50.9-13.3 50.9-36.9zM517 188.6c-9.5-30.9-10.9-68.8-9.8-98.1 1.1-30.5-22.7-58.5-54.7-58.5L123.7 32c-32.1 0-55.8 28.1-54.7 58.5 1 29.3-.3 67.2-9.8 98.1-9.6 31-25.7 50.6-52.2 53.1l0 28.5c26.4 2.5 42.6 22.1 52.2 53.1 9.5 30.9 10.9 68.8 9.8 98.1-1.1 30.5 22.7 58.5 54.7 58.5l328.7 0c32.1 0 55.8-28.1 54.7-58.5-1-29.3 .3-67.2 9.8-98.1 9.6-31 25.7-50.6 52.1-53.1l0-28.5c-26.3-2.5-42.5-22.1-52-53.1zM300.2 375.1l-97.9 0 0-238.3 97.4 0c43.3 0 71.7 23.4 71.7 59.4 0 25.3-19.1 47.9-43.5 51.8l0 1.3c33.2 3.6 55.5 26.6 55.5 58.3 0 42.1-31.3 67.5-83.2 67.5zm-10-108.7l-50.1 0 0 78.4 52.3 0c34.2 0 52.3-13.7 52.3-39.5 0-25.7-18.6-38.9-54.5-38.9z"],
    "itunes": [448, 512, [], "f3b4", "M223.6 80.3a171.3 171.3 0 1 0 .2 342.5 171.3 171.3 0 1 0 -.2-342.5zm79.4 240c-3.2 13.6-13.5 21.2-27.3 23.8-12.1 2.2-22.2 2.8-31.9-5-11.8-10-12-26.4-1.4-36.8 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 3.2-3.6 2.2-2 2.2-80.8 0-5.6-2.7-7.1-8.4-6.1-4 .7-91.9 17.1-91.9 17.1-5 1.1-6.7 2.6-6.7 8.3 0 116.1 .5 110.8-1.2 118.5-2.1 9-7.6 15.8-14.9 19.6-8.3 4.6-23.4 6.6-31.4 5.2-21.4-4-28.9-28.7-14.4-42.9 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 5-5.7 .9-127 2.6-133.7 .4-2.6 1.5-4.8 3.5-6.4 2.1-1.7 5.8-2.7 6.7-2.7 101-19 113.3-21.4 115.1-21.4 5.7-.4 9 3 9 8.7-.1 170.6 .4 161.4-1 167.6zM345.2 32L102.8 32C45.9 32 0 77.9 0 134.8L0 377.2C0 434.1 45.9 480 102.8 480l242.4 0c57 0 102.8-45.9 102.8-102.8l0-242.4C448 77.9 402.1 32 345.2 32zM223.6 59a192.5 192.5 0 1 1 0 385 192.5 192.5 0 1 1 0-385z"],
    "square-xing": [448, 512, ["xing-square"], "f169", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM93.8 320.2c-5.5 0-8.7-5.3-6-10.3l49.3-86.7c.1 0 .1-.1 0-.2l-31.4-54c-3-5.6 .2-10.1 6-10.1l46.6 0c5.2 0 9.5 2.9 12.9 8.7l31.9 55.3c-1.3 2.3-18 31.7-50.1 88.2-3.5 6.2-7.7 9.1-12.6 9.1l-46.6 0zm163.5-33.4l0 .2 65.5 119c2.8 5.1 .1 10.1-6 10.1l-46.6 0c-5.5 0-9.7-2.9-12.9-8.7l-66-120.3c1.8-3.2 22.9-40.4 63.3-111.6 11.7-20.7 25.1-44.3 40.1-70.8 3.3-5.8 7.4-8.7 12.5-8.7l46.9 0c5.7-.1 8.8 4.7 6 10L257.3 286.8z"],
    "css3-alt": [384, 512, [], "f38b", "M0 32L34.9 427.8 192 480 349.1 427.8 384 32 0 32zm313.1 80l-4.8 47.3-115.3 49.3-.3 .1 111.5 0-12.8 146.6-98.2 28.7-98.8-29.2-6.4-73.9 48.9 0 3.2 38.3 52.6 13.3 54.7-15.4 3.7-61.6-166.3-.5 0-.1-.2 .1-3.6-46.3 112.1-46.7 6.5-2.7-122.9 0-5.8-47.3 242.2 0z"],
    "squarespace": [512, 512, [], "f5be", "M186.1 343.3c-9.7 9.7-9.7 25.3 0 34.9s25.3 9.6 34.9 0L378.3 221.1c19.3-19.3 50.6-19.3 69.9 0s19.3 50.6 0 69.9L294 445.1c19.3 19.3 50.5 19.3 69.8 0l0 0 119.3-119.2c38.6-38.6 38.6-101.1 0-139.7-38.6-38.6-101.2-38.6-139.7 0L186.1 343.3zM430.7 238.5c-9.7-9.7-25.3-9.7-34.9 0L238.5 395.7c-19.3 19.3-50.5 19.3-69.8 0l0 0c-9.6-9.6-25.3-9.7-34.9 0l0 0c-9.7 9.6-9.7 25.3 0 34.9l0 0c38.6 38.6 101.1 38.6 139.7 0L430.7 273.5c9.6-9.7 9.6-25.3 0-34.9zm-262 87.3L325.9 168.7c9.6-9.6 9.6-25.3 0-34.9-9.6-9.6-25.3-9.6-34.9 0L133.7 290.9c-19.3 19.3-50.6 19.3-69.9 0l0 0c-19.3-19.3-19.3-50.5 0-69.8l0 0 154.2-154.2c-19.3-19.3-50.5-19.3-69.8 0l0 0-119.2 119.3c-38.6 38.6-38.6 101.1 0 139.7 38.6 38.6 101.1 38.6 139.7 0zM81.3 273.5c9.6 9.6 25.3 9.6 34.9 0L273.5 116.3c19.3-19.3 50.6-19.3 69.8 0l0 0c9.7 9.6 25.3 9.6 34.9 0s9.6-25.3 0-34.9c-38.6-38.6-101.1-38.6-139.7 0L81.3 238.5c-9.6 9.6-9.6 25.3 0 34.9l0 0z"],
    "trello": [448, 512, [], "f181", "M392.3 32L56.1 32c-31 0-56.1 25.1-56.1 56-.1 0 0-4 0 336 0 30.9 25.1 56 56 56l336.2 0c30.8-.2 55.7-25.2 55.7-56l0-336c.1-30.8-24.8-55.8-55.6-56zM197 371.3c-.2 14.7-12.1 26.6-26.9 26.6l-82.7 0c-14.8 .1-26.9-11.8-27-26.6l0-254.2c0-14.8 12-26.9 26.9-26.9l82.9 0c14.8 0 26.9 12 26.9 26.9l0 254.2-.1 0zm193.1-112c0 14.8-12 26.9-26.9 26.9l-81 0c-14.8 0-26.9-12-26.9-26.9l0-142.1c0-14.8 12-26.9 26.8-26.9l81.1 0c14.8 0 26.9 12 26.9 26.9l0 142.1z"],
    "viadeo": [448, 512, [], "f2a9", "M276.4 150.5l0 .7c-17.9-52.6-42.6-103.4-70.8-151.2 43.3 29.2 67 100 70.8 150.5zm32.7 121.7c7.6 18.2 11 37.5 11 57 0 77.7-57.8 141-137.8 139.4l3.8-.3c74.2-46.7 109.3-118.6 109.3-205.1 0-38.1-6.5-75.9-18.9-112 1 11.7 1 23.7 1 35.4 0 91.8-18.1 241.6-116.6 280-65.7-11.4-111.3-68.6-111.3-137.4 0-75.6 57.4-142.3 135.4-142.3 16.8 0 33.7 3.1 49.1 9.6 1.7-15.1 6.5-29.9 13.4-43.3-19.9-7.2-41.2-10.7-62.5-10.7-161.5 0-238.7 195.9-129.9 313.7 67.9 74.6 192 73.9 259.8 0 56.6-61.3 60.9-142.4 36.4-201-12.7 8-27.1 13.9-42.2 17zM418.3 11.7c-31 66.5-81.3 47.2-115.8 80.1-12.4 12-20.6 34-20.6 50.5 0 14.1 4.5 27.1 12 38.8 47.4-11 98.3-46 118.2-90.7-.7 5.5-4.8 14.4-7.2 19.2-20.3 35.7-64.6 65.6-99.7 84.9 14.8 14.4 33.7 25.8 55 25.8 79 0 110.1-134.6 58.1-208.6z"],
    "searchengin": [448, 512, [], "f3eb", "M214.6 130.3l-67.2 28.2 0-115.3-54.7 190.3 54.7-24.2 0 130.3 67.2-209.3zM131.4 33.6l-1.3 4.7-15.2 52.9C74.6 106.7 46 145.8 46 191.5 46 243.8 80.3 287.4 129.4 297l0 53.6C51.5 340.1-6 272.4-6 191.6-6 111.1 53.8 44.4 131.4 33.6zM442.8 480.8c-11.2 11.2-23.1 12.3-28.6 10.5-5.4-1.8-27.1-19.9-60.4-44.4-33.3-24.6-33.6-35.7-43-56.7-9.4-20.9-30.4-42.6-57.5-52.4l-9.7-14.7c-24.7 16.9-53 26.9-81.3 28.7l2.1-6.6 15.9-49.5c46.5-11.9 80.9-54 80.9-104.2 0-54.5-38.4-102.1-96-107.1l0-52.1c83.2 5.1 148.8 74.5 148.8 159.3 0 33.6-11.2 64.7-29 90.4l14.6 9.6c9.8 27.1 31.5 48 52.4 57.4s32.2 9.7 56.8 43c24.6 33.2 42.7 54.9 44.5 60.3s.7 17.3-10.5 28.5zm-9.9-17.9c0-4.4-3.6-8-8-8s-8 3.6-8 8 3.6 8 8 8 8-3.6 8-8z"],
    "paypal": [384, 512, [], "f1ed", "M111.9 295.9c-3.5 19.2-17.4 108.7-21.5 134-.3 1.8-1 2.5-3 2.5l-74.6 0c-7.6 0-13.1-6.6-12.1-13.9L59.3 46.6c1.5-9.6 10.1-16.9 20-16.9 152.3 0 165.1-3.7 204 11.4 60.1 23.3 65.6 79.5 44 140.3-21.5 62.6-72.5 89.5-140.1 90.3-43.4 .7-69.5-7-75.3 24.2zM357.6 152c-1.8-1.3-2.5-1.8-3 1.3-2 11.4-5.1 22.5-8.8 33.6-39.9 113.8-150.5 103.9-204.5 103.9-6.1 0-10.1 3.3-10.9 9.4-22.6 140.4-27.1 169.7-27.1 169.7-1 7.1 3.5 12.9 10.6 12.9l63.5 0c8.6 0 15.7-6.3 17.4-14.9 .7-5.4-1.1 6.1 14.4-91.3 4.6-22 14.3-19.7 29.3-19.7 71 0 126.4-28.8 142.9-112.3 6.5-34.8 4.6-71.4-23.8-92.6z"],
    "square-bluesky": [448, 512, [], "e6a3", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 247.4c14.5-30 54-85.8 90.7-113.3 26.5-19.9 69.3-35.2 69.3 13.7 0 9.8-5.6 82.1-8.9 93.8-11.4 40.8-53 51.2-90 44.9 64.7 11 81.2 47.5 45.6 84-67.5 69.3-97-17.4-104.6-39.6l-.3-.9c-.9-2.6-1.4-4.1-1.8-4.1s-.9 1.5-1.8 4.1c-.1 .3-.2 .6-.3 .9-7.6 22.2-37.1 108.8-104.6 39.6-35.5-36.5-19.1-73 45.6-84-37 6.3-78.6-4.1-90-44.9-3.3-11.7-8.9-84-8.9-93.8 0-48.9 42.9-33.5 69.3-13.7 36.7 27.5 76.2 83.4 90.7 113.3z"],
    "d-and-d-beyond": [640, 512, [], "f6ca", "M313.8 241.5c13.8 0 21-10.1 24.8-17.9-1-1.1-5-4.2-7.4-6.6-2.4 4.3-8.2 10.7-13.9 10.7-10.2 0-15.4-14.7-3.2-26.6-.5-.2-4.3-1.8-8 2.4 0-3 1-5.1 2.1-6.6-3.5 1.3-9.8 5.6-11.4 7.9 .2-5.8 1.6-7.5 .6-9l-.2-.2s-8.5 5.6-9.3 14.7c0 0 1.1-1.6 2.1-1.9 .6-.3 1.3 0 .6 1.9-.2 .6-5.8 15.7 5.1 26-.6-1.6-1.9-7.6 2.4-1.9-.3 .1 5.8 7.1 15.7 7.1zm52.4-21.1c0-4-4.9-4.4-5.6-4.5 2 3.9 .9 7.5 .2 9 2.5-.4 5.4-1.6 5.4-4.5zm10.3 5.2c0-6.4-6.2-11.4-13.5-10.7 8 1.3 5.6 13.8-5 11.4 3.7-2.6 3.2-9.9-1.3-12.5 1.4 4.2-3 8.2-7.4 4.6-2.4-1.9-8-6.6-10.6-8.6-2.4-2.1-5.5-1-6.6-1.8-1.3-1.1-.5-3.8-2.2-5-1.6-.8-3-.3-4.8-1-1.6-.6-2.7-1.9-2.6-3.5-2.5 4.4 3.4 6.3 4.5 8.5 1 1.9-.8 4.8 4 8.5 14.8 11.6 9.1 8 10.4 18.1 .6 4.3 4.2 6.7 6.4 7.4-2.1-1.9-2.9-6.4 0-9.3 0 13.9 19.2 13.3 23.1 6.4-2.4 1.1-7-.2-9-1.9 7.7 1 14.2-4.1 14.6-10.6zm-39.4-18.4c2 .8 1.6 .7 6.4 4.5 10.2-24.5 21.7-15.7 22-15.5 2.2-1.9 9.8-3.8 13.8-2.7-2.4-2.7-7.5-6.2-13.3-6.2-4.7 0-7.4 2.2-8 1.3-.8-1.4 3.2-3.4 3.2-3.4-5.4 .2-9.6 6.7-11.2 5.9-1.1-.5 1.4-3.7 1.4-3.7-5.1 2.9-9.3 9.1-10.2 13 4.6-5.8 13.8-9.8 19.7-9-10.5 .5-19.5 9.7-23.8 15.8zm242.5 51.9c-20.7 0-40 1.3-50.3 2.1l7.4 8.2 0 77.2-7.4 8.2c10.4 .8 30.9 2.1 51.6 2.1 42.1 0 59.1-20.7 59.1-48.9 0-29.3-23.2-48.9-60.4-48.9zm-15.1 75.6l0-53.3c30.1-3.3 46.8 3.8 46.8 26.3 0 25.6-21.4 30.2-46.8 27zM301.6 181c-1-3.4-.2-6.9 1.1-9.4 1 3 2.6 6.4 7.5 9-.5-2.4-.2-5.6 .5-8-1.4-5.4 2.1-9.9 6.4-9.9 6.9 0 8.5 8.8 4.7 14.4 2.1 3.2 5.5 5.6 7.7 7.8 3.2-3.7 5.5-9.5 5.5-13.8 0-8.2-5.5-15.9-16.7-16.5-20-.9-20.2 16.6-20 18.9 .5 5.2 3.4 7.8 3.3 7.5zm-.4 6c-.5 1.8-7 3.7-10.2 6.9 4.8-1 7-.2 7.8 1.8 .5 1.4-.2 3.4-.5 5.6 1.6-1.8 7-5.5 11-6.2-1-.3-3.4-.8-4.3-.8 2.9-3.4 9.3-4.5 12.8-3.7-2.2-.2-6.7 1.1-8.5 2.6 1.6 .3 3 .6 4.3 1.1-2.1 .8-4.8 3.4-5.8 6.1 7-5 13.1 5.2 7 8.2 .8 .2 2.7 0 3.5-.5-.3 1.1-1.9 3-3 3.4 2.9 0 7-1.9 8.2-4.6 0 0-1.8 .6-2.6-.2s.3-4.3 .3-4.3c-2.3 2.9-3.4-1.3-1.3-4.2-1-.3-3.5-.6-4.6-.5 3.2-1.1 10.4-1.8 11.2-.3 .6 1.1-1 3.4-1 3.4 4-.5 8.3 1.1 6.7 5.1 2.9-1.4 5.5-5.9 4.8-10.4-.3 1-1.6 2.4-2.9 2.7 .2-1.4-1-2.2-1.9-2.6 1.7-9.6-14.6-14.2-14.1-23.9-1 1.3-1.8 5-.8 7.1 2.7 3.2 8.7 6.7 10.1 12.2-2.6-6.4-15.1-11.4-14.6-20.2-1.6 1.6-2.6 7.8-1.3 11 2.4 1.4 4.5 3.8 4.8 6.1-2.2-5.1-11.4-6.1-13.9-12.2-.6 2.2-.3 5 1 6.7 0 0-2.2-.8-7-.6 1.7 .6 5.1 3.5 4.8 5.2zm25.9 7.4c-2.7 0-3.5-2.1-4.2-4.3 3.3 1.3 4.2 4.3 4.2 4.3zm38.9 3.7l-1-.6c-1.1-1-2.9-1.4-4.7-1.4-2.9 0-5.8 1.3-7.5 3.4-.8 .8-1.4 1.8-2.1 2.6l0 15.7c3.5 2.6 7.1-2.9 3-7.2 1.5 .3 4.6 2.7 5.1 3.2 0 0 2.6-.5 5-.5 2.1 0 3.9 .3 5.6 1.1l0-18.4c-1.1 .5-2.2 1-2.7 1.4l-.7 .7zM79.9 305.9c17.2-4.6 16.2-18 16.2-19.9 0-20.6-24.1-25-37-25l-56.1 0 8.3 8.6 0 29.5-11.3 0 11.4 14.6 0 32.3-8.4 8.6c61.7 0 73.8 1.5 86.4-5.9 6.7-4 9.9-9.8 9.9-17.6 0-5.1 2.6-18.8-19.4-25.2zM38.6 278.4c20 0 29.6-.8 29.6 9.1l0 3c0 12.1-19 8.8-29.6 8.8l0-20.9zm0 59.2l0-22.6c12.2 0 32.7-2.3 32.7 8.8l0 4.5 .2 0c0 11.2-12.5 9.3-32.9 9.3zm101.2-19.3l23.1 .2 0-.2 14.1-21.2-37.2 0 0-14.9 52.4 0-14.1-21 0-.2-73.5 .2 7.4 8.2 0 77.1-7.4 8.2 81.2 0 14.1-21.2-60.1 .2 0-15.4zm214.7-60.1c-73.9 0-77.5 99.3-.3 99.3 77.9 0 74.1-99.3 .3-99.3zm-.3 77.5c-37.4 0-36.9-55.3 .2-55.3 36.8 .1 38.8 55.3-.2 55.3zm-91.3-8.3l44.1-66.2-41.7 0 6.1 7.2-20.5 37.2-.3 0-21-37.2 6.4-7.2-44.9 0 44.1 65.8 .2 19.4-7.7 8.2 42.6 0-7.2-8.2-.2-19zM234.5 176.1c1.6 1.3 2.9 2.4 2.9 6.6l0 38.8c0 4.2-.8 5.3-2.7 6.4-.1 .1-7.5 4.5-7.9 4.6l35.1 0c10 0 17.4-1.5 26-8.6-.6-5 .2-9.5 .8-12 0-.2-1.8 1.4-2.7 3.5 0-5.7 1.6-15.4 9.6-20.5-.1 0-3.7-.8-9 1.1 2-3.1 10-7.9 10.4-7.9-8.2-26-38-22.9-32.2-22.9-30.9 0-32.6 .3-39.9-4 .1 .8 .5 8.2 9.6 14.9zm21.5 5.5c4.6 0 23.1-3.3 23.1 17.3 0 20.7-18.4 17.3-23.1 17.3l0-34.6zm228.9 79.6l7 8.3 0 42.5-.3 0c-5.4-14.4-42.3-41.5-45.2-50.9l-31.6 0 7.4 8.5 0 76.9-7.2 8.3 39 0-7.4-8.2 0-47.4 .3 0c3.7 10.6 44.5 42.9 48.5 55.6l21.3 0 0-85.2 7.4-8.3-39.2-.1zM378.2 165.1c-32.2 0-32.8 .2-39.9-4 .1 .7 .5 8.3 9.6 14.9 3.1 2 2.9 4.3 2.9 9.5 1.8-1.1 3.8-2.2 6.1-3-1.1 1.1-2.7 2.7-3.5 4.5 1-1.1 7.5-5.1 14.6-3.5-1.6 .3-4 1.1-6.1 2.9 .1 0 2.1-1.1 7.5-.3l0-4.3c4.7 0 23.1-3.4 23.1 17.3 0 20.5-18.5 17.3-19.7 17.3 5.7 4.4 5.8 12 2.2 16.3l.3 0c33.4 0 36.7-27.3 36.7-34 0-3.8-1.1-32-33.8-33.6z"],
    "microsoft": [448, 512, [], "f3ca", "M0 32l214.6 0 0 214.6-214.6 0 0-214.6zm233.4 0l214.6 0 0 214.6-214.6 0 0-214.6zM0 265.4l214.6 0 0 214.6-214.6 0 0-214.6zm233.4 0l214.6 0 0 214.6-214.6 0 0-214.6z"],
    "fly": [320, 512, [], "f417", "M165.9 427.8c12.9 11.7 33.7 33.3 33.2 50.7 0 .8-.1 1.6-.1 2.5-1.8 19.8-18.8 31.1-39.1 31-25-.1-39.9-16.8-38.7-35.8 1-16.2 20.5-36.7 32.4-47.6 2.3-2.1 2.7-2.7 5.6-3.6 3.4 0 3.9 .3 6.7 2.8zM300 67.3c-16.3-25.7-38.6-40.6-63.3-52.1-25.5-10.7-54.6-15.4-76.6-15.2-44.1 0-71.2 13.2-81.1 17.3-53.6 27.9-84.4 69.9-82.9 141.3 7.1 82.2 97 176 155.8 233.8 1.7 1.6 4.5 4.5 6.2 5.1l3.3 .1c2.1-.7 1.8-.5 3.5-2.1 52.3-49.2 140.7-145.8 155.9-215.7 7-39.2 3.1-72.5-20.8-112.5zM154.9 351.9c-28-51.1-65.2-130.7-69.3-189-3.4-47.5 11.4-131.2 69.3-136.7l0 325.7zM296.8 180c-16.4 56.8-77.3 128-118.9 170.3 27.8-51.9 65.2-133.3 67.2-191.9 1.6-45.9-9.8-105.8-48-131.4 88.8 18.3 115.5 98.1 99.7 153z"],
    "cc-stripe": [576, 512, [], "f1f5", "M492.4 220.8c-8.9 0-18.7 6.7-18.7 22.7l36.7 0c0-16-9.3-22.7-18-22.7zM375 223.4c-8.2 0-13.3 2.9-17 7l.2 52.8c3.5 3.7 8.5 6.7 16.8 6.7 13.1 0 21.9-14.3 21.9-33.4 0-18.6-9-33.2-21.9-33.1zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM122.2 281.1c0 25.6-20.3 40.1-49.9 40.3-12.2 0-25.6-2.4-38.8-8.1l0-33.9c12 6.4 27.1 11.3 38.9 11.3 7.9 0 13.6-2.1 13.6-8.7 0-17-54-10.6-54-49.9 0-25.2 19.2-40.2 48-40.2 11.8 0 23.5 1.8 35.3 6.5l0 33.4c-10.8-5.8-24.5-9.1-35.3-9.1-7.5 0-12.1 2.2-12.1 7.7 0 16 54.3 8.4 54.3 50.7zM191 224.5l-27 0 0 50.5c0 20.9 22.5 14.4 27 12.6l0 28.9c-4.7 2.6-13.3 4.7-24.9 4.7-21.1 0-36.9-15.5-36.9-36.5l.2-113.9 34.7-7.4 0 30.8 26.9 0 0 30.3zm74 2.4c-4.5-1.5-18.7-3.6-27.1 7.4l0 84.4-35.5 0 0-124.5 30.7 0 2.2 10.5c8.3-15.3 24.9-12.2 29.6-10.5l.1 0 0 32.7zm44.1 91.8l-35.7 0 0-124.5 35.7 0 0 124.5zm0-142.9l-35.7 7.6 0-28.9 35.7-7.6 0 28.9zm74.1 145.5c-12.4 0-20-5.3-25.1-9l-.1 40.2-35.5 7.5 0-165.8 31.3 0 1.8 8.8c4.9-4.5 13.9-11.1 27.8-11.1 24.9 0 48.4 22.5 48.4 63.8 0 45.1-23.2 65.5-48.6 65.6zm160.4-51.5l-69.5 0c1.6 16.6 13.8 21.5 27.6 21.5 14.1 0 25.2-3 34.9-7.9l0 28.6c-9.7 5.3-22.4 9.2-39.4 9.2-34.6 0-58.8-21.7-58.8-64.5 0-36.2 20.5-64.9 54.3-64.9 33.7 0 51.3 28.7 51.3 65.1 0 3.5-.3 10.9-.4 12.9z"],
    "wordpress-simple": [512, 512, [], "f411", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM33 256c0-32.3 6.9-63 19.3-90.7L158.7 456.7C84.3 420.5 33 344.2 33 256zM256 479c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2-48.8 146.3-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3 39.9-60.5 108.4-100.5 186.3-100.5 58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"],
    "sellsy": [640, 512, [], "f213", "M540 237.3c3.1-12.3 4.3-24.8 4.3-37.4 0-92.5-75.4-167.9-167.9-167.9-77.2 0-144.6 53-163 127.8-15.3-13.2-34.9-20.5-55.2-20.5-46.3 0-84 37.7-84 84 0 7.4 .9 15 3.1 22.4-42.9 20.2-70.8 63.7-70.8 111.2 0 68 55.5 123.2 123.2 123.2l381.2 0c67.7 0 123.2-55.2 123.2-123.2 0-56.4-38.9-106-94.1-119.5zM200.2 401.6c0 8.3-7 15.3-15.3 15.3l-30.9 0c-8.3 0-15.3-7-15.3-15.3l0-110.9c0-8.3 7-15.3 15.3-15.3l30.9 0c8.3 0 15.3 7 15.3 15.3l0 110.9zm89.5 0c0 8.3-7 15.3-15.3 15.3l-30.9 0c-8.3 0-15.3-7-15.3-15.3l0-131.5c0-8.3 7-15.3 15.3-15.3l30.9 0c8.3 0 15.3 7 15.3 15.3l0 131.5zm89.5 0c0 8.3-7 15.3-15.3 15.3l-31 0c-8.3 0-15.3-7-15.3-15.3l0-162.7c0-8.3 7-15.3 15.3-15.3l31 0c8.3 0 15.3 7 15.3 15.3l0 162.7zm87 0c0 8.3-7 15.3-15.3 15.3l-28.5 0c-8.3 0-15.3-7-15.3-15.3l0-224.6c0-8.6 7-15.6 15.3-15.6l28.5 0c8.3 0 15.3 7 15.3 15.6l0 224.6z"],
    "dashcube": [448, 512, [], "f210", "M326.9 104l-216.2 0c-51.1 0-91.2 43.3-91.2 93.5l0 229.5c0 50.5 40.1 85 91.2 85l227.2 0c51.1 0 91.2-34.5 91.2-85l0-427-102.2 104zM154.2 416.5c-17.7 0-32.4-15.1-32.4-32.8l0-142.9c0-17.7 14.7-32.5 32.4-32.5l140.7 0c17.7 0 32 14.8 32 32.5l0 123.5 51.1 52.3-223.8 0 0-.1z"],
    "gitter": [384, 512, [], "f426", "M66.4 322.5l-50.4 0 0-322.5 50.4 0 0 322.5zM166.9 76.1l-50.4 0 0 435.9 50.4 0 0-435.9zm100.6 0l-50.4 0 0 435.9 50.4 0 0-435.9zM368 76l-50.4 0 0 247 50.4 0 0-247z"],
    "wolf-pack-battalion": [448, 512, [], "f514", "M236.2 471.5l10.6 15.8 5.3-12.3 5.3 7 0 29.9c21.1-7.9 21.1-66.9 25.5-97.2 4.6-31.9-.9-92.8 81.4-149.1-8.9-23.6-12-49.4-2.6-80 27.9 3.4 53.9 10.6 63.3 54.1l-30.3 8.4c11.1 23 17 46.8 13.2 72.1l-27.3-7-6.2 33.4-18.5-7-8.8 33.4-19.4-7 26.4 21.1 8.8-28.2 24.6 5.2 7-35.6 26.4 14.5c.2-20 7-58.1-8.8-84.5l26.4 5.3c4-22.1-2.4-39.2-7.9-56.7l22.4 9.7c-.4-25.1-29.9-56.8-61.6-58.5-20.2-1.1-56.7-25.2-54.1-51.9 2-19.9 17.4-42.6 43.1-49.7-44 36.5-9.7 67.3 5.3 73.5 4.4-11.4 17.5-69.1 0-130.2-40.4 22.9-89.7 65.1-93.2 147.8l-58 38.7-3.5 93.2 107.3-59.8 7 7-17.6 3.5-44 38.7-15.8-5.3-28.1 49.3-3.5 119.6 21.1 15.8-32.5 15.8-32.6-15.8 21.1-15.8-3.5-119.6-28.2-49.3-15.8 5.3-44-38.7-17.6-3.5 7-7 107.3 59.8-3.5-93.3-58.1-38.7c-3.5-82.8-52.7-125-93.2-147.9-17.5 61.1-4.4 118.8 0 130.2 15-6.2 49.3-37 5.3-73.5 25.7 7.1 41.1 29.8 43.1 49.7 2.6 26.7-33.9 50.8-54.1 51.9-31.7 1.7-61.2 33.4-61.6 58.5l22.4-9.7C13.4 224.7 7 241.8 11 263.9l26.4-5.3c-15.8 26.4-9.1 64.4-8.8 84.4l26.4-14.5 7 35.6 24.6-5.3 8.8 28.2 26.4-21.1-19.4 7-8.8-33.4-18.5 7-6.2-33.4-27.3 7C38 294.8 43.8 271 55 248l-30.3-8.4c9.4-43.5 35.5-50.8 63.3-54.1 9.4 30.6 6.2 56.5-2.6 80.1 82.3 56.3 76.8 117.2 81.4 149.1 4.4 30.3 4.4 89.3 25.5 97.2l0-29.8 5.3-7 5.3 12.3 10.6-15.8 11.4 21.1 11.4-21.1 0 0zm79.2-95L299.5 366c7.5-4.4 13.8-8.4 19.4-12.3-.6 7.2-.3 13.8-3.5 22.8l0 0zm28.2-49.3c-.4 10.9-.9 21.7-1.8 31.7-7.8-1.9-15.6-3.8-21.1-7 8.2-7.9 15.6-16.3 22.9-24.7l0 0zm24.6 5.3c0-13.4-2.1-24.2-5.3-33.4-5.5 9.5-11.7 18.6-18.5 27.3l23.8 6.2zm3.5-80.9c19.4 12.8 27.8 33.7 29.9 56.3-12.3-4.5-24.6-9.3-37-10.6 5.1-12 6.6-28.1 7-45.7l0 0zm-1.8-45.7c.8 14.3 1.8 28.8 1.8 42.2 19.2-8.1 29.8-9.7 44-14.1-10.6-19-27.2-25.5-45.8-28.2l0 0zM134.2 376.5L150 366c-7.5-4.4-13.8-8.4-19.4-12.3 .6 7.3 .3 13.9 3.5 22.9l0 0zM106 327.3c.4 10.9 .9 21.7 1.8 31.7 7.8-1.9 15.6-3.8 21.1-7-8.2-7.9-15.6-16.3-22.9-24.7zm-24.6 5.3c0-13.4 2-24.2 5.3-33.4 5.5 9.5 11.7 18.6 18.5 27.3l-23.8 6.2zm-3.5-80.9c-19.4 12.8-27.8 33.7-29.9 56.3 12.3-4.5 24.6-9.3 37-10.6-5-12-6.6-28.1-7-45.7l-.1 0zm1.8-45.7c-.8 14.3-1.8 28.8-1.8 42.2-19.2-8.1-29.8-9.7-44-14.1 10.6-19 27.2-25.5 45.8-28.1z"],
    "lastfm": [512, 512, [], "f202", "M225.8 367.1l-18.8-51s-30.5 34-76.2 34c-40.5 0-69.2-35.2-69.2-91.5 0-72.1 36.4-97.9 72.1-97.9 66.5 0 74.8 53.3 100.9 134.9 18.8 56.9 54 102.6 155.4 102.6 72.7 0 122-22.3 122-80.9 0-72.9-62.7-80.6-115-92.1-25.8-5.9-33.4-16.4-33.4-34 0-19.9 15.8-31.7 41.6-31.7 28.2 0 43.4 10.6 45.7 35.8l58.6-7c-4.7-52.8-41.1-74.5-100.9-74.5-52.8 0-104.4 19.9-104.4 83.9 0 39.9 19.4 65.1 68 76.8 44.9 10.6 79.8 13.8 79.8 45.7 0 21.7-21.1 30.5-61 30.5-59.2 0-83.9-31.1-97.9-73.9-32-96.8-43.6-163-161.3-163-86.1 0-131.8 54.5-131.8 147.2 0 89.1 45.7 137.2 127.9 137.2 66.2 0 97.9-31.1 97.9-31.1z"],
    "shopware": [512, 512, [], "f5b5", "M403.5 455.4c-42.6 31.7-94.4 48.7-147.5 48.6-137.2 0-248-111-248-248 0-137.2 111-248 248-248 61.2-.1 120.2 22.6 165.7 63.5 .6 .5 .9 1.2 1.1 1.9s.1 1.5-.3 2.2-.8 1.3-1.5 1.6-1.4 .5-2.2 .4c-18.8-2.5-37.7-3.7-56.7-3.7-129.4 0-222.4 53.5-222.4 155.4 0 109 92.1 145.9 176.8 178.7 33.6 13 65.4 25.4 87 41.6 .4 .3 .8 .8 1.1 1.3s.4 1 .4 1.6-.1 1.1-.4 1.6-.6 .9-1.1 1.3l-.1 0zM503 233.1c-.1-.9-.5-1.8-1.3-2.4-51.8-43-93.6-60.5-144.5-60.5-84.1 0-80.3 52.2-80.3 53.6 0 42.6 52.1 62 112.3 84.5 31.1 11.6 63.2 23.6 92.7 39.9 .4 .2 .9 .4 1.4 .4s1 0 1.5-.2 .9-.4 1.3-.8 .6-.8 .8-1.2c14.1-36 19.5-74.8 16-113.3z"],
    "blogger": [448, 512, [], "f37c", "M162.4 196c4.8-4.9 6.2-5.1 36.4-5.1 27.2 0 28.1 .1 32.1 2.1 5.8 2.9 8.3 7 8.3 13.6 0 5.9-2.4 10-7.6 13.4-2.8 1.8-4.5 1.9-31.1 2.1-16.4 .1-29.5-.2-31.5-.8-10.3-2.9-14.1-17.7-6.6-25.3zm61.4 94.5c-53.9 0-55.8 .2-60.2 4.1-3.5 3.1-5.7 9.4-5.1 13.9 .7 4.7 4.8 10.1 9.2 12 2.2 1 14.1 1.7 56.3 1.2l47.9-.6 9.2-1.5c9-5.1 10.5-17.4 3.1-24.4-5.3-4.7-5-4.7-60.4-4.7zM447.2 420.6c-3.5 28.4-23 50.4-51.1 57.5-7.2 1.8-9.7 1.9-172.9 1.8-157.8 0-165.9-.1-172-1.8-8.4-2.2-15.6-5.5-22.3-10-5.6-3.8-13.9-11.8-17-16.4-3.8-5.6-8.2-15.3-10-22S0 420.3 0 256.3c0-163.1 0-166.6 1.8-173.7 6.3-24.7 25.9-43.6 51.2-49.2 7.3-1.6 332.1-1.9 340-.3 21.2 4.3 37.9 17.1 47.6 36.4 7.7 15.3 7-1.5 7.3 180.6 .2 115.8 0 164.5-.7 170.5zM361.8 235.4c-1.1-5-4.2-9.6-7.7-11.5-1.1-.6-8-1.3-15.5-1.7-12.4-.6-13.8-.8-17.8-3.1-6.2-3.6-7.9-7.6-8-18.3 0-20.4-8.5-39.4-25.3-56.5-12-12.2-25.3-20.5-40.6-25.1-3.6-1.1-11.8-1.5-39.2-1.8-42.9-.5-52.5 .4-67.1 6.2-27 10.7-46.3 33.4-53.4 62.4-1.3 5.4-1.6 14.2-1.9 64.3-.4 62.8 0 72.1 4 84.5 9.7 30.7 37.1 53.4 64.6 58.4 9.2 1.7 122.2 2.1 133.7 .5 20.1-2.7 35.9-10.8 50.7-25.9 10.7-10.9 17.4-22.8 21.8-38.5 3.2-10.9 2.9-88.4 1.7-93.9z"],
    "edge": [512, 512, [], "f282", "M120.1 37.4c41-25.2 87.6-38.2 134.9-37.4 168 0 257 123.8 257 219.5-.1 32.7-13 63.9-35.9 87.2-22.9 23.2-54 36.5-86.7 37-75.2 0-91.5-23.1-91.5-32 0-3.8 1.2-6.2 4.8-9.4l1-1.2 .4-1.6c10.5-11.5 15.9-26.2 15.9-41.6 0-78.7-82.2-142.7-184-142.7-37.5-.3-74.5 8.9-107.5 26.9 27-57.5 82.7-97.6 91.3-103.8 .8-.6 .3-.8 .3-.8zm15.6 318.1c-1.4 30 4.6 60 16.4 87.2 13.6 26.4 32.7 51 56.5 69.3-59.5-11.5-111.5-43.9-149.4-89.3-38.1-46.4-59.2-104.3-59.2-164.8 0-51.2 62.4-94.4 136-94.4 36.6-.6 72.4 10.9 101.8 32.7l-3.6 1.2c-51.5 17.6-98.5 90.7-98.5 158.1zM469.8 400l-.7 .1c-11.8 18.8-25.9 35.1-42.2 49.5-30.8 28-68.1 45.5-108.8 49.9-18.6 .3-36.8-3.2-53.8-11.4-25.6-10.3-47.1-30-61.6-53-14.4-23.9-21.1-51.7-19-79.6-.6-20.1 5.4-40.3 15-58.2 13.9 33.1 37.5 61.3 67.6 80.8s65.5 29.5 101.4 28.6c31 .3 62.1-6.7 90.2-20.5l1.9-.9c3.9-2.3 7.7-3.9 11.6 0 4.5 4.9 1.8 9.2-1.2 14-.2 .2-.3 .5-.4 .7z"],
    "ioxhost": [640, 512, [], "f208", "M616 160l-67.3 0C511.2 70.7 422.9 8 320 8 183 8 72 119 72 256 72 272.4 73.6 288.5 76.7 304L24 304c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24l67.3 0c37.5 89.3 125.8 152 228.7 152 137 0 248-111 248-248 0-16.4-1.6-32.5-4.7-48l52.7 0c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24zm-96 96c0 110.5-89.5 200-200 200-75.7 0-141.6-42-175.5-104L424 352c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24l-298.2 0c-3.8-15.4-5.8-31.4-5.8-48 0-110.5 89.5-200 200-200 75.7 0 141.6 42 175.5 104L216 160c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24l298.2 0c3.8 15.4 5.8 31.4 5.8 48zM216 232l208 0c13.3 0 24 10.7 24 24 0 13.2-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24 0-13.2 10.7-24 24-24z"],
    "schlix": [448, 512, [], "f3ea", "M350.5 157.7l-54.2-46.1 73.4-39 78.3 44.2-97.5 40.9zM192 122.1l45.7-28.2 34.7 34.6-55.4 29-25-35.4zm-65.1 6.6l31.9-22.1 17.2 28.4-36.7 22.5-12.4-28.8zm-23.3 88.2l-8.8-34.8 29.6-18.3 13.1 35.3-33.9 17.8zM82.4 133.2l23.9-18.1 8.9 24-26.7 18.3-6.1-24.2zM59 206.5l-3.6-28.4 22.3-15.5 6.1 28.7-24.8 15.2zM28.4 223.1l20.8-12.8 3.3 33.4-22.9 12-1.2-32.6zM1.4 268L20.6 257.8 21 296 0 304.8 1.4 268zm59.1 59.3l-28.3 8.3-1.6-46.8 25.1-10.7 4.8 49.2zM99 263.2l-31.1 13-5.2-40.8 27.4-14.4 8.9 42.2zM123.2 377l-41.6 5.9-8.1-63.5 35.2-10.8 14.5 68.4zm28.5-139.9l21.2 57.1-46.2 13.6-13.7-54.1 38.7-16.6zm85.7 230.5l-70.9-3.3-24.3-95.8 55.2-8.6 40 107.7zM152.5 187.9l42.2-22.4 28 45.9-50.8 21.3-19.4-44.8zm41 94.9l61.3-18.7 52.8 86.6-79.8 11.3-34.3-79.2zm51.4-85.6l67.3-28.8 65.5 65.4-88.6 26.2-44.2-62.8z"],
    "d-and-d": [576, 512, [], "f38d", "M82.9 98.9c-.6-17.2 2-33.8 12.7-48.2 .3 7.4 1.2 14.5 4.2 21.6 5.9-27.5 19.7-49.3 42.3-65.5-1.9 5.9-3.5 11.8-3 17.7 8.7-7.4 18.8-17.8 44.4-22.7 14.7-2.8 29.7-2 42.1 1 38.5 9.3 61 34.3 69.7 72.3 5.3 23.1 .7 45-8.3 66.4-5.2 12.4-12 24.4-20.7 35.1-2-1.9-3.9-3.8-5.8-5.6-42.8-40.8-26.8-25.2-37.4-37.4-1.1-1.2-1-2.2-.1-3.6 8.3-13.5 11.8-28.2 10-44-1.1-9.8-4.3-18.9-11.3-26.2-14.5-15.3-39.2-15-53.5 .6-11.4 12.5-14.1 27.4-10.9 43.6 .2 1.3 .4 2.7 0 3.9-3.4 13.7-4.6 27.6-2.5 41.6 .1 .5 .1 1.1 .1 1.6 0 .3-.1 .5-.2 1.1-21.8-11-36-28.3-43.2-52.2-8.3 17.8-11.1 35.5-6.6 54.1-15.6-15.2-21.3-34.3-22-55.2zM552.5 222.1c-11.6-11.6-25-20.4-40.1-26.6-12.8-5.2-26-7.9-39.9-7.1-10 .6-19.6 3.1-29 6.4-2.5 .9-5.1 1.6-7.7 2.2-4.9 1.2-7.3-3.1-4.7-6.8 3.2-4.6 3.4-4.2 15-12 .6-.4 1.2-.8 2.2-1.5l-2.5 0c-.6 0-1.2 .2-1.9 .3-19.3 3.3-30.7 15.5-48.9 29.6-10.4 8.1-13.8 3.8-12-.5 1.4-3.5 3.3-6.7 5.1-10 1-1.8 2.3-3.4 3.5-5.1-.2-.2-.5-.3-.7-.5-27 18.3-46.7 42.4-57.7 73.3 .3 .3 .7 .6 1 .9 .3-.6 .5-1.2 .9-1.7 10.4-12.1 22.8-21.8 36.6-29.8 18.2-10.6 37.5-18.3 58.7-20.2 4.3-.4 8.7-.1 13.1-.1-1.8 .7-3.5 .9-5.3 1.1-18.5 2.4-35.5 9-51.5 18.5-30.2 17.9-54.5 42.2-75.1 70.4-.3 .4-.4 .9-.7 1.3 14.5 5.3 24 17.3 36.1 25.6 .2-.1 .3-.2 .4-.4l1.2-2.7c12.2-26.9 27-52.3 46.7-74.5 16.7-18.8 38-25.3 62.5-20 5.9 1.3 11.4 4.4 17.2 6.8 2.3-1.4 5.1-3.2 8-4.7 8.4-4.3 17.4-7 26.7-9 14.7-3.1 29.5-4.9 44.5-1.3l0-.5c-.5-.4-1.2-.8-1.7-1.4zM317.1 397.6c-39.4-33-22.8-19.5-42.7-35.6-.8 .9 0-.2-1.9 3-11.2 19.1-25.5 35.3-44 47.6-10.3 6.8-21.5 11.8-34.1 11.8-21.6 0-38.2-9.5-49.4-27.8-12-19.5-13.3-40.7-8.2-62.6 7.8-33.8 30.1-55.2 38.6-64.3-18.7-6.2-33 1.7-46.4 13.9 .8-13.9 4.3-26.2 11.8-37.3-24.3 10.6-45.9 25-64.8 43.9-.3-5.8 5.4-43.7 5.6-44.7 .3-2.7-.6-5.3-3-7.4-24.2 24.7-44.5 51.8-56.1 84.6 7.4-5.9 14.9-11.4 23.6-16.2-8.3 22.3-19.6 52.8-7.8 101.1 4.6 19 11.9 36.8 24.1 52.3 2.9 3.7 6.3 6.9 9.5 10.3 .2-.2 .4-.3 .6-.5-1.4-7-2.2-14.1-1.5-21.9 2.2 3.2 3.9 6 5.9 8.6 12.6 16 28.7 27.4 47.2 35.6 25 11.3 51.1 13.3 77.9 8.6 54.9-9.7 90.7-48.6 116-98.8 1-1.8 .6-2.9-.9-4.2zm172-46.4c-9.5-3.1-22.2-4.2-28.7-2.9 9.9 4 14.1 6.6 18.8 12 12.6 14.4 10.4 34.7-5.4 45.6-11.7 8.1-24.9 10.5-38.9 9.1-1.2-.1-2.3-.4-3-.6 2.8-3.7 6-7 8.1-10.8 9.4-16.8 5.4-42.1-8.7-56.1-2.1-2.1-4.6-3.9-7-5.9-.3 1.3-.1 2.1 .1 2.8 4.2 16.6-8.1 32.4-24.8 31.8-7.6-.3-13.9-3.8-19.6-8.5-19.5-16.1-39.1-32.1-58.5-48.3-5.9-4.9-12.5-8.1-20.1-8.7-4.6-.4-9.3-.6-13.9-.9-5.9-.4-8.8-2.8-10.4-8.4-.9-3.4-1.5-6.8-2.2-10.2-1.5-8.1-6.2-13-14.3-14.2-4.4-.7-8.9-1-13.3-1.5-13-1.4-19.8-7.4-22.6-20.3-5 11-1.6 22.4 7.3 29.9 4.5 3.8 9.3 7.3 13.8 11.2 4.6 3.8 7.4 8.7 7.9 14.8 .4 4.7 .8 9.5 1.8 14.1 2.2 10.6 8.9 18.4 17 25.1 16.5 13.7 33 27.3 49.5 41.1 17.9 15 13.9 32.8 13 56-.9 22.9 12.2 42.9 33.5 51.2 1 .4 2 .6 3.6 1.1-15.7-18.2-10.1-44.1 .7-52.3 .3 2.2 .4 4.3 .9 6.4 9.4 44.1 45.4 64.2 85 56.9 16-2.9 30.6-8.9 42.9-19.8 2-1.8 3.7-4.1 5.9-6.5-19.3 4.6-35.8 .1-50.9-10.6 .7-.3 1.3-.3 1.9-.3 21.3 1.8 40.6-3.4 57-17.4 19.5-16.6 26.6-42.9 17.4-66-8.3-20.1-23.6-32.3-43.8-38.9zM99.8 179.3c-5.3-9.2-13.2-15.6-22.1-21.3 13.7-.5 26.6 .2 39.6 3.7-7-12.2-8.5-24.7-5-38.7 5.3 11.9 13.7 20.1 23.6 26.8 19.7 13.2 35.7 19.6 46.7 30.2 3.4 3.3 6.3 7.1 9.6 10.9-.8-2.1-1.4-4.1-2.2-6-5-10.6-13-18.6-22.6-25-1.8-1.2-2.8-2.5-3.4-4.5-3.3-12.5-3-25.1-.7-37.6 1-5.5 2.8-10.9 4.5-16.3 .8-2.4 2.3-4.6 4-6.6 .6 6.9 0 25.5 19.6 46 10.8 11.3 22.4 21.9 33.9 32.7 9 8.5 18.3 16.7 25.5 26.8 1.1 1.6 2.2 3.3 3.8 4.7-5-13-14.2-24.1-24.2-33.8-9.6-9.3-19.4-18.4-29.2-27.4-3.3-3-4.6-6.7-5.1-10.9-1.2-10.4 0-20.6 4.3-30.2 .5-1 1.1-2 1.9-3.3 .5 4.2 .6 7.9 1.4 11.6 4.8 23.1 20.4 36.3 49.3 63.5 10 9.4 19.3 19.2 25.6 31.6 4.8 9.3 7.3 19 5.7 29.6-.1 .6 .5 1.7 1.1 2 6.2 2.6 10 6.9 9.7 14.3 7.7-2.6 12.5-8 16.4-14.5 4.2 20.2-9.1 50.3-27.2 58.7 .4-4.5 5-23.4-16.5-27.7-6.8-1.3-12.8-1.3-22.9-2.1 4.7-9 10.4-20.6 .5-22.4-24.9-4.6-52.8 1.9-57.8 4.6 8.2 .4 16.3 1 23.5 3.3-2 6.5-4 12.7-5.8 18.9-1.9 6.5 2.1 14.6 9.3 9.6 1.2-.9 2.3-1.9 3.3-2.7-3.1 17.9-2.9 15.9-2.8 18.3 .3 10.2 9.5 7.8 15.7 7.3-2.5 11.8-29.5 27.3-45.4 25.8 7-4.7 12.7-10.3 15.9-17.9-6.5 .8-12.9 1.6-19.2 2.4l-.3-.9c4.7-3.4 8-7.8 10.2-13.1 8.7-21.1-3.6-38-25-39.9-9.1-.8-17.8 .8-25.9 5.5 6.2-15.6 17.2-26.6 32.6-34.5-15.2-4.3-8.9-2.7-24.6-6.3 14.6-9.3 30.2-13.2 46.5-14.6-5.2-3.2-48.1-3.6-70.2 20.9 7.9 1.4 15.5 2.8 23.2 4.2-23.8 7-44 19.7-62.4 35.6 1.1-4.8 2.7-9.5 3.3-14.3 .6-4.5 .8-9.2 .1-13.6-1.5-9.4-8.9-15.1-19.7-16.3-7.9-.9-15.6 .1-23.3 1.3-.9 .1-1.7 .3-2.9 0 15.8-14.8 36-21.7 53.1-33.5 6-4.5 6.8-8.2 3-14.9zm128.4 26.8c3.3 16 12.6 25.5 23.8 24.3-4.6-11.3-12.1-19.5-23.8-24.3z"],
    "vuejs": [448, 512, [], "f41f", "M356.9 64.3l-76.9 0-56 88.6-48-88.6-176 0 224 383.7 224-383.7-91.1 0zM55.7 96.3l53.8 0 114.5 198.2 114.4-198.2 53.8 0-168.2 288.2-168.3-288.2z"],
    "meta": [640, 512, [], "e49b", "M640 317.9c0 91.3-39.4 148.5-110.3 148.5-62.6 0-95.8-34.6-156.9-136.6l-31.4-52.6c-8.3-12.5-14.5-24.2-21.2-35-20.1 33.8-47.1 83-47.1 83-67 116.6-104.6 141.2-156.9 141.2-72.8 0-116.2-57.3-116.2-145.9 0-143 79.8-278.1 183.9-278.1 50.2 0 93.8 24.7 144.8 89.5 37.1-50.1 78.1-89.5 130.6-89.5 99.1 0 180.7 125.7 180.7 275.5zM287.4 192.2c-42.9-62.1-70.9-80.5-104.4-80.5-61.9 0-113.8 106.1-113.8 210 0 48.5 18.5 75.7 49.6 75.7 30.2 0 49-19 103.2-103.8 0 0 24.7-39.1 65.4-101.4zM531.2 397.4c32.2 0 46.9-27.5 46.9-74.9 0-124.2-54.3-225.4-123.2-225.4-33.2 0-61.1 25.9-94.9 78 9.4 13.8 19.1 29 29.3 45.4l37.5 62.4c58.7 94.1 73.5 114.5 104.4 114.5z"],
    "creative-commons-share": [512, 512, [], "f4f2", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm101 132.4c7.8 0 13.7 6.1 13.7 13.7l0 182.5c0 7.7-6.1 13.7-13.7 13.7l-135.1 0c-7.7 0-13.7-6-13.7-13.7l0-54-54 0c-7.8 0-13.7-6-13.7-13.7l0-182.5c0-8.2 6.6-12.7 12.4-13.7l136.4 0c7.7 0 13.7 6 13.7 13.7l0 54 54 0zM167.9 300.3l40.7 0 0-101.4c0-7.4 5.8-12.6 12-13.7l55.8 0 0-40.3-108.5 0 0 155.4zm176.2-88.1l-108.5 0 0 155.4 108.5 0 0-155.4z"],
    "studiovinari": [512, 512, [], "f3f8", "M480.7 187.7l4.2 28 0 28-25.1 44.1-39.8 78.4-56.1 67.5-79.1 37.8-17.7 24.5-7.7 12-9.6 4s17.3-63.6 19.4-63.6 20.3 .7 20.3 .7l66.7-38.6-92.5 26.1-55.9 36.8-22.8 28-6.6 1.4 20.8-73.6 6.9-5.5 20.7 12.9 88.3-45.2 56.8-51.5 14.8-68.4-125.4 23.3 15.2-18.2-173.4-53.3 81.9-10.5-166-122.9 114.9 18.1-101.3-108 252.9 126.6-31.5-38 124.4 74.4-143.3-99 18.7 38.4-49.6-18.1-45.5-84.3 194.6 122-42.9-55.8 108 96.4 12-8.9-21-16.4 4.2-37.8 37.8-10.4 29.2 24.7 11.5 4.2-7 6.2 8.5 12-13.1 7.4-10.3 20.2 10.5 23.9z"],
    "bitbucket": [512, 512, [61810], "f171", "M22.2 32c-2.1 0-4.2 .4-6.1 1.1s-3.7 1.9-5.2 3.4-2.7 3.2-3.5 5.1-1.3 4-1.3 6.1c0 .9 .1 1.9 .2 2.8L74.1 462.7c.8 5.1 3.4 9.7 7.3 13s8.8 5.2 14 5.2l325.7 0c3.8 .1 7.5-1.3 10.5-3.7s4.9-5.9 5.5-9.7L505 50.7c.7-4.2-.3-8.4-2.8-11.9s-6.2-5.7-10.4-6.4c-.9-.1-1.9-.2-2.8-.2L22.2 32zM308.1 329.8l-104 0-28.1-147 157.3 0-25.2 147z"],
    "vk": [448, 512, [], "f189", "M31.5 63.5C0 95 0 145.7 0 247L0 265C0 366.3 0 417 31.5 448.5S113.7 480 215 480l17.9 0c101.4 0 152.1 0 183.5-31.5S448 366.3 448 265l0-17.9c0-101.4 0-152.1-31.5-183.5S334.3 32 233 32L215 32C113.7 32 63 32 31.5 63.5zM75.6 168.3l51.1 0c1.7 85.5 39.4 121.7 69.3 129.2l0-129.2 48.2 0 0 73.7c29.5-3.2 60.5-36.8 70.9-73.7l48.2 0c-3.9 19.2-11.8 37.3-23.1 53.3s-25.7 29.5-42.5 39.6c18.7 9.3 35.2 22.4 48.4 38.5s22.9 34.9 28.3 55l-53 0c-4.9-17.5-14.8-33.1-28.6-45s-30.7-19.4-48.7-21.6l0 66.6-5.8 0c-102.1 0-160.3-70-162.8-186.5z"],
    "github": [512, 512, [], "f09b", "M173.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3 .3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5 .3-6.2 2.3zm44.2-1.7c-2.9 .7-4.9 2.6-4.6 4.9 .3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM252.8 8c-138.7 0-244.8 105.3-244.8 244 0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1 100-33.2 167.8-128.1 167.8-239 0-138.7-112.5-244-251.2-244zM105.2 352.9c-1.3 1-1 3.3 .7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3 .3 2.9 2.3 3.9 1.6 1 3.6 .7 4.3-.7 .7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3 .7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3 .7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9s4.3 3.3 5.6 2.3c1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"],
    "codiepie": [512, 512, [], "f284", "M442.5 202.9c30.7 0 33.5 53.1-.3 53.1l-10.8 0 0 44.3-26.6 0 0-97.4 37.7 0zM492 352.6C449.9 444.5 370.4 504 268 504 131 504 20 393 20 256S131 8 268 8c97.4 0 172.8 53.7 218.2 138.4L300.2 255.2 492 352.6zm-38.5 12.5l-60.3-30.7c-27.1 44.3-70.4 71.4-122.4 71.4-82.5 0-149.2-66.7-149.2-148.9 0-82.5 66.7-149.2 149.2-149.2 48.4 0 88.9 23.5 116.9 63.4l59.5-34.6C406.5 73.9 342.5 36.5 268 36.5 146.8 36.5 48.5 134.8 48.5 256S146.8 475.5 268 475.5c78.6 0 146.5-42.1 185.5-110.4z"],
    "pied-piper": [448, 512, [], "f2ae", "M440.2 23.2c-26.7 6.8-68.1 28.5-114.6 67.5-30.9-17.5-65.8-26.7-101.4-26.7-114.9 0-208 93.1-208 208s93.1 208 208 208 208-93.1 208-208c.1-54.1-21-106.1-58.7-144.8-6.6 8.5-12.3 17.7-17 27.4 28.9 32.3 44.8 74.1 44.9 117.4 0 97.7-79.4 177.1-177.1 177.1-30.8 0-61-8.1-87.6-23.4 82.9-107.3 150.8-37.8 184.3-226.6 5.8-32.6 28-94.3 126.2-160.2 8.1-5.4 2.4-18.1-7-15.7zM109.3 406.4C89.8 389.8 74.2 369.2 63.5 346s-16.3-48.5-16.3-74c0-97.7 79.4-177.1 177.1-177.1 26.6 0 52.8 6.1 76.6 17.8-66 62.1-126.9 152.9-191.6 293.8z"],
    "raspberry-pi": [448, 512, [], "f7bb", "M392.5 232.5l-3.7-6.5c.1-46.4-21.4-65.3-46.5-79.7 7.6-2 15.4-3.6 17.6-13.2 13.1-3.3 15.8-9.4 17.1-15.8 3.4-2.3 14.8-8.7 13.6-19.7 6.4-4.4 10-10.1 8.1-18.1 6.9-7.5 8.7-13.7 5.8-19.4 8.3-10.3 4.6-15.6 1.1-20.9 6.2-11.2 .7-23.2-16.6-21.2-6.9-10.1-21.9-7.8-24.2-7.8-2.6-3.2-6-6-16.5-4.7-6.8-6.1-14.4-5-22.3-2.1-9.3-7.3-15.5-1.4-22.6 .8-11.3-3.6-13.9 1.3-19.4 3.4-12.3-2.6-16.1 3-22 8.9l-6.9-.1c-18.6 10.8-27.8 32.8-31.1 44.1-3.3-11.3-12.5-33.3-31.1-44.1l-6.9 .1c-5.9-5.9-9.7-11.5-22-8.9-5.6-2-8.1-7-19.4-3.4-4.6-1.4-8.9-4.4-13.9-4.3-2.6 .1-5.5 1-8.7 3.5-7.9-3-15.5-4-22.3 2.1-10.5-1.3-14 1.4-16.5 4.7-2.3 0-17.3-2.3-24.2 7.8-17.3-2-22.7 10-16.5 21.2-3.5 5.4-7.2 10.7 1.1 20.9-2.9 5.7-1.1 11.9 5.8 19.4-1.8 8 1.8 13.7 8.1 18.1-1.2 11 10.2 17.4 13.6 19.7 1.3 6.4 4 12.4 17.1 15.8 2.2 9.5 10 11.2 17.6 13.2-25.1 14.4-46.6 33.3-46.5 79.7l-3.7 6.5c-28.8 17.2-54.7 72.7-14.2 117.7 2.6 14.1 7.1 24.2 11 35.4 5.9 45.2 44.5 66.3 54.6 68.8 14.9 11.2 30.8 21.8 52.2 29.2 20.3 20.6 42.3 28.4 64.3 28.4l1 0c22.1 0 44-7.8 64.2-28.4 21.5-7.4 37.3-18 52.2-29.2 10.2-2.5 48.7-23.6 54.6-68.8 3.9-11.2 8.4-21.3 11-35.4 40.6-45.1 14.7-100.5-14-117.7zm-22.2-8c-1.5 18.7-98.9-65.1-82.1-67.9 45.7-7.5 83.6 19.2 82.1 67.9zm-43 93.1c-24.5 15.8-59.8 5.6-78.8-22.8s-14.6-64.2 9.9-80 59.8-5.6 78.8 22.8 14.6 64.2-9.9 80zM259.4 29.3c.8 4.2 1.8 6.8 2.9 7.6 5.4-5.8 9.8-11.7 16.8-17.3 0 3.3-1.7 6.8 2.5 9.4 3.7-5 8.8-9.5 15.5-13.3-3.2 5.6-.6 7.3 1.2 9.6 5.1-4.4 10-8.8 19.4-12.3-2.6 3.1-6.2 6.2-2.4 9.8 5.3-3.3 10.6-6.6 23.1-8.9-2.8 3.1-8.7 6.3-5.1 9.4 6.6-2.5 14-4.4 22.1-5.4-3.9 3.2-7.1 6.3-3.9 8.8 7.1-2.2 16.9-5.1 26.4-2.6l-6 6.1c-.7 .8 14.1 .6 23.9 .8-3.6 5-7.2 9.7-9.3 18.2 1 1 5.8 .4 10.4 0-4.7 9.9-12.8 12.3-14.7 16.6 2.9 2.2 6.8 1.6 11.2 .1-3.4 6.9-10.4 11.7-16 17.3 1.4 1 3.9 1.6 9.7 .9-5.2 5.5-11.4 10.5-18.8 15 1.3 1.5 5.8 1.5 10 1.6-6.7 6.5-15.3 9.9-23.4 14.2 4 2.7 6.9 2.1 10 2.1-5.7 4.7-15.4 7.1-24.4 10 1.7 2.7 3.4 3.4 7.1 4.1-9.5 5.3-23.2 2.9-27 5.6 .9 2.7 3.6 4.4 6.7 5.8-15.4 .9-57.3-.6-65.4-32.3 15.7-17.3 44.4-37.5 93.7-62.6-38.4 12.8-73 30-102 53.5-34.3-15.9-10.8-55.9 5.8-71.8zM225 143.9c24.2-.3 54.1 17.8 54 34.7-.1 15-21 27.1-53.8 26.9-32.1-.4-53.7-15.2-53.6-29.8 0-11.9 26.2-32.5 53.4-31.8zM102 131.1c3.7-.7 5.4-1.5 7.1-4.1-9-2.8-18.7-5.3-24.4-10 3.1 0 6 .7 10-2.1-8.1-4.3-16.7-7.7-23.4-14.2 4.2-.1 8.7 0 10-1.6-7.4-4.5-13.6-9.5-18.8-15 5.8 .7 8.3 .1 9.7-.9-5.6-5.6-12.7-10.4-16-17.3 4.3 1.5 8.3 2 11.2-.1-1.9-4.2-10-6.7-14.7-16.6 4.6 .4 9.4 1 10.4 0-2.1-8.5-5.8-13.3-9.3-18.2 9.8-.1 24.6 0 23.9-.8l-6-6.1c9.5-2.5 19.3 .4 26.4 2.6 3.2-2.5-.1-5.6-3.9-8.8 8.1 1.1 15.4 2.9 22.1 5.4 3.5-3.1-2.3-6.3-5.1-9.4 12.5 2.3 17.8 5.6 23.1 8.9 3.8-3.6 .2-6.7-2.4-9.8 9.4 3.4 14.3 7.9 19.4 12.3 1.7-2.3 4.4-4 1.2-9.6 6.7 3.8 11.8 8.3 15.5 13.3 4.1-2.6 2.5-6.2 2.5-9.4 7 5.6 11.4 11.5 16.8 17.3 1.1-.8 2-3.4 2.9-7.6 16.6 15.9 40.1 55.9 6 71.8-29-23.5-63.6-40.7-102-53.5 49.3 25 78 45.3 93.7 62.6-8 31.8-50 33.2-65.4 32.3 3.1-1.4 5.8-3.2 6.7-5.8-4-2.8-17.6-.4-27.2-5.6zm60.1 24.1c16.8 2.8-80.6 86.5-82.1 67.9-1.5-48.7 36.5-75.5 82.1-67.9zM58.7 342c-23.7-18.8-31.3-73.7 12.6-98.3 26.5-7 9 107.8-12.6 98.3zm91 98.2c-13.3 7.9-45.8 4.7-68.8-27.9-15.5-27.4-13.5-55.2-2.6-63.4 16.3-9.8 41.5 3.4 60.9 25.6 16.9 20 24.6 55.3 10.5 65.7zM123.3 320.5c-24.5-15.8-28.9-51.6-9.9-80s54.3-38.6 78.8-22.8 28.9 51.6 9.9 80c-19.1 28.4-54.4 38.6-78.8 22.8zM225.5 496c-29.4 1.2-58.2-23.7-57.8-32.3-.4-12.7 35.8-22.6 59.3-22 23.7-1 55.6 7.5 55.7 18.9 .5 11-28.8 35.9-57.2 35.4zm58.9-124.9c.2 29.7-26.2 53.8-58.8 54s-59.2-23.8-59.4-53.4l0-.6c-.2-29.7 26.2-53.8 58.8-54s59.2 23.8 59.4 53.4l0 .6zm82.2 42.7c-25.3 34.6-59.6 35.9-72.3 26.3-13.3-12.4-3.2-50.9 15.1-72 20.9-23.3 43.3-38.5 58.9-26.6 10.5 10.3 16.7 49.1-1.7 72.3zm22.9-73.2c-21.5 9.4-39-105.3-12.6-98.3 43.9 24.7 36.3 79.6 12.6 98.3z"],
    "css3": [512, 512, [], "f13c", "M480 32l-64 368-223.3 80-192.7-80 19.6-94.8 82 0-8 40.6 116.4 44.4 134.1-44.4 18.8-97.1-333.4 0 16-82 333.7 0 10.5-52.7-333.4 0 16.3-82 407.4 0z"],
    "hubspot": [448, 512, [], "f3b2", "M235.8 211.6c-25.1 23.7-40.8 57.3-40.8 94.6 0 29.3 9.7 56.3 26 78L171.5 434c-4.4-1.6-9.1-2.5-14-2.5-10.8 0-20.9 4.2-28.5 11.8s-11.8 17.8-11.8 28.6 4.2 20.9 11.8 28.5 17.8 11.6 28.5 11.6c10.8 0 20.9-3.9 28.6-11.6 7.6-7.6 11.8-17.8 11.8-28.5 0-4.2-.6-8.2-1.9-12.1l50-50.2c22 16.9 49.4 26.9 79.3 26.9 71.9 0 130-58.3 130-130.2 0-65.2-47.7-119.2-110.2-128.7l0-61.6c17.5-7.4 28.2-23.8 28.2-42.9 0-26.1-20.9-47.9-47-47.9S279.6 47 279.6 73.1c0 19.1 10.7 35.5 28.2 42.9l0 61.2c-15.2 2.1-29.6 6.7-42.7 13.6-27.6-20.9-117.5-85.7-168.9-124.8 1.2-4.4 2-9 2-13.8 0-28.8-23.5-52.2-52.4-52.2-28.8 0-52.2 23.4-52.2 52.2 0 28.9 23.4 52.3 52.2 52.3 9.8 0 18.9-2.9 26.8-7.6L235.8 211.6zm89.5 25.6a69 69 0 1 1 0 138 69 69 0 1 1 0-138z"],
    "cmplid": [640, 512, [], "e360", "M226.1 388.2c0-.7-.2-1.5-.6-2.1s-1-1.1-1.7-1.4c-.5-.2-1.1-.4-1.6-.4l-149.6 0c-3.1 0-6.2-.8-8.9-2.2s-5.1-3.5-6.9-6.1-2.9-5.5-3.3-8.6 0-6.2 1.1-9.1L81.6 255.7c2-7.2 6.2-13.5 12-18.2s12.9-7.4 20.4-7.8l148.6 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6l10.8-41.1c.4-1 .3-2-.1-2.9s-1.2-1.6-2.1-2c-.4-.2-.9-.3-1.4-.3-.1 0-.1 0-.2 0l-148.5 0c-22.2 1.2-43.4 9.2-60.8 23s-30 32.7-36.2 54.1L3.5 358.8c-3.2 8.7-4.2 18-3 27.1s4.6 17.9 9.9 25.5 12.3 13.8 20.5 18 17.3 6.5 26.5 6.6c1 0 1.9 0 2.9-.1l148.6 0c1.5-.1 2.9-.7 4-1.6s2-2.2 2.4-3.6l10.7-41.1c.2-.5 .3-.9 .3-1.4zm80.5-307c.2-.4 .3-.9 .3-1.4 0-.5-.1-1-.3-1.5s-.5-.9-.8-1.2-.8-.6-1.2-.8-1-.3-1.5-.3l-41.2 0c-1.5 .1-2.9 .6-4 1.6s-2 2.2-2.4 3.6l-21.3 80.9 51.1 0 21.4-80.9zm-126.3 287l51.1 0 32-122.6-51.1 0-32 122.6zM511.9 79.7c0-1-.5-1.9-1.2-2.6s-1.7-1.1-2.6-1.1c-.1 0-.1 0-.2 0l-41 0c-1.5 .1-2.9 .6-4.1 1.5s-2 2.2-2.5 3.6L368.9 430.6c-.2 .4-.3 .9-.3 1.3 0 1 .4 2 1.1 2.7s1.7 1.1 2.7 1.1l41.2 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6L511.5 81.2c.2-.5 .3-1 .3-1.5zM324.6 384.5l-41 0c-1.5 .1-2.9 .7-4 1.6s-2 2.2-2.4 3.6l-10.7 41.1c-.2 .4-.3 .9-.3 1.4 0 .5 .1 1 .3 1.5s.5 .9 .8 1.2 .8 .6 1.2 .8 1 .3 1.5 .3c.1 0 .2 0 .3 0l40.9 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6l10.8-41.1c.2-.6 .3-1.2 .3-1.8s-.3-1.2-.6-1.7-.8-.9-1.3-1.2-1.2-.4-1.8-.4c-.1 0-.2 0-.3 0l0 0zM636 76.1l-41 0c-1.5 .1-2.9 .6-4 1.5s-2 2.2-2.4 3.6L497.1 430.6c-.2 .4-.2 .9-.2 1.3 0 1 .4 2 1.1 2.7s1.7 1.1 2.7 1.1l41.1 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6L639.7 81.2c.2-.5 .3-1 .3-1.5-.1-1-.5-1.9-1.2-2.5s-1.6-1-2.6-1c-.1 0-.1 0-.2 0l0-.1zM371.6 225.2l10.8-41.1c.2-.4 .2-.9 .2-1.4 0-1-.4-2-1.1-2.7s-1.7-1.1-2.7-1.1l-41.3 0c-1.5 .1-2.9 .7-4 1.6s-2 2.2-2.4 3.6l-10.8 41.1c-.2 .5-.3 1-.3 1.5l0 .2c.1 1 .5 1.8 1.2 2.5s1.6 1 2.6 1c.1 0 .2 0 .3 0l41.1 0c1.5-.1 2.9-.6 4-1.6s2-2.2 2.4-3.6z"],
    "dyalog": [448, 512, [], "f399", "M16 32l0 119.2 64 0 0-55.2 107.2 0C300.6 96 368 176.2 368 255.9 368 332 309.4 416 187.2 416l-171.2 0 0 64 171.2 0C347.9 480 432 367.3 432 255.9 432 197.2 409.9 142.5 369.7 101.6 324.9 56 261.7 32 187.2 32L16 32z"],
    "elementor": [512, 512, [], "f430", "M.5 256c0 141 113.6 255 254.6 255 142 0 256-114 256-255 0-140-114-253.9-256-253.9-141 0-254.6 113.9-254.6 253.9zM192.1 150l0 213-43 0 0-213 43 0zm42 0l128 0 0 43-128 0 0-43zm128 85l0 43-128 0 0-43 128 0zm-128 85l128 0 0 43-128 0 0-43z"],
    "first-order": [448, 512, [], "f2b0", "M13.3 229.2c.1-.1 .2-.3 .3-.4 0 .1 0 .3-.1 .4l-.2 0zM224.4 96.6c-7.1 0-14.6 .6-21.4 1.7l3.7 67.4-22-64c-14.3 3.7-27.7 9.4-40 16.6l29.4 61.4-45.1-50.9c-11.4 8.9-21.7 19.1-30.6 30.9l50.6 45.4-61.1-29.7c-7.1 12.3-12.9 25.7-16.6 40l64.3 22.6-68-4c-.9 7.1-1.4 14.6-1.4 22s.6 14.6 1.4 21.7l67.7-4-64 22.6c3.7 14.3 9.4 27.7 16.6 40.3L149 306.9 98.1 352c8.9 11.7 19.1 22.3 30.9 30.9l44.9-50.9-29.5 61.4c12.3 7.4 25.7 13.1 40 16.9l22.3-64.6-4 68c7.1 1.1 14.6 1.7 21.7 1.7 7.4 0 14.6-.6 21.7-1.7l-4-68.6 22.6 65.1c14.3-4 27.7-9.4 40-16.9l-29.4-61.3 44.9 50.9c11.7-8.9 22-19.1 30.6-30.9l-50.6-45.1 61.1 29.4c7.1-12.3 12.9-25.7 16.6-40.3l-64-22.3 67.4 4c1.1-7.1 1.4-14.3 1.4-21.7s-.3-14.9-1.4-22l-67.7 4 64-22.3c-3.7-14.3-9.1-28-16.6-40.3l-60.9 29.7 50.6-45.4c-8.9-11.7-19.1-22-30.6-30.9l-45.1 50.9 29.4-61.1c-12.3-7.4-25.7-13.1-40-16.9l-22.3 64.3 4-67.7c-7.1-1.2-14.3-1.7-21.7-1.7zM443.8 128L443.8 384 224.4 512 5 384 5 128 224.4 0 443.8 128zm-17.1 10.3l-202.3-117.4-202.3 117.4 0 235.1 202.3 117.7 202.3-117.7 0-235.1zM224.4 37.1l187.7 109.4 0 218.9-187.7 109.5-187.7-109.5 0-218.8 187.7-109.5zm0 50.9c-92.3 0-166.9 75.1-166.9 168 0 92.6 74.6 167.7 166.9 167.7 92 0 166.9-75.1 166.9-167.7 0-92.9-74.9-168-166.9-168z"],
    "dribbble": [512, 512, [], "f17d", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM420 122.4c29.5 36 47.4 82 47.8 132-7-1.5-77-15.7-147.5-6.8-5.8-14-11.2-26.4-18.6-41.6 78.3-32 113.8-77.5 118.3-83.5zM396.4 97.9c-3.8 5.4-35.7 48.3-111 76.5-34.7-63.8-73.2-116.2-79-124 67.2-16.2 138 1.3 190.1 47.5zM165.9 64.6c5.6 7.7 43.4 60.1 78.5 122.5-99.1 26.3-186.4 25.9-195.8 25.8 13.7-65.7 58-120.4 117.3-148.3zM44.2 256.3c0-2.2 0-4.3 .1-6.5 9.3 .2 111.9 1.5 217.7-30.1 6.1 11.9 11.9 23.9 17.2 35.9-76.6 21.6-146.2 83.5-180.5 142.3-33.8-37.6-54.5-87.2-54.5-141.6zM126 423.4c22.1-45.2 82.2-103.6 167.6-132.8 29.7 77.3 42 142.1 45.2 160.6-68.1 29-150 21.1-212.8-27.9zm248.4 8.5c-2.2-12.9-13.4-74.9-41.2-151 66.4-10.6 124.7 6.8 131.9 9.1-9.4 58.9-43.3 109.8-90.8 142z"],
    "linkedin": [448, 512, [], "f08c", "M416 32L31.9 32C14.3 32 0 46.5 0 64.3L0 447.7C0 465.5 14.3 480 31.9 480L416 480c17.6 0 32-14.5 32-32.3l0-383.4C448 46.5 433.6 32 416 32zM135.4 416l-66.4 0 0-213.8 66.5 0 0 213.8-.1 0zM102.2 96a38.5 38.5 0 1 1 0 77 38.5 38.5 0 1 1 0-77zM384.3 416l-66.4 0 0-104c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9l0 105.8-66.4 0 0-213.8 63.7 0 0 29.2 .9 0c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9l0 117.2z"],
    "cc-paypal": [576, 512, [], "f1f4", "M186.3 258.2c0 12.2-9.7 21.5-22 21.5-9.2 0-16-5.2-16-15 0-12.2 9.5-22 21.7-22 9.3 0 16.3 5.7 16.3 15.5zM80.5 209.7l-4.7 0c-1.5 0-3 1-3.2 2.7l-4.3 26.7 8.2-.3c11 0 19.5-1.5 21.5-14.2 2.3-13.4-6.2-14.9-17.5-14.9zm284 0l-4.5 0c-1.8 0-3 1-3.2 2.7l-4.2 26.7 8-.3c13 0 22-3 22-18-.1-10.6-9.6-11.1-18.1-11.1zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM128.3 215.4c0-21-16.2-28-34.7-28l-40 0c-2.5 0-5 2-5.2 4.7L32 294.2c-.3 2 1.2 4 3.2 4l19 0c2.7 0 5.2-2.9 5.5-5.7l4.5-26.6c1-7.2 13.2-4.7 18-4.7 28.6 0 46.1-17 46.1-45.8zm84.2 8.8l-19 0c-3.8 0-4 5.5-4.2 8.2-5.8-8.5-14.2-10-23.7-10-24.5 0-43.2 21.5-43.2 45.2 0 19.5 12.2 32.2 31.7 32.2 9 0 20.2-4.9 26.5-11.9-.5 1.5-1 4.7-1 6.2 0 2.3 1 4 3.2 4l17.2 0c2.7 0 5-2.9 5.5-5.7l10.2-64.3c.3-1.9-1.2-3.9-3.2-3.9zM253 322.1l63.7-92.6c.5-.5 .5-1 .5-1.7 0-1.7-1.5-3.5-3.2-3.5l-19.2 0c-1.7 0-3.5 1-4.5 2.5l-26.5 39-11-37.5c-.8-2.2-3-4-5.5-4l-18.7 0c-1.7 0-3.2 1.8-3.2 3.5 0 1.2 19.5 56.8 21.2 62.1-2.7 3.8-20.5 28.6-20.5 31.6 0 1.8 1.5 3.2 3.2 3.2l19.2 0c1.8-.1 3.5-1.1 4.5-2.6zM412.3 215.4c0-21-16.2-28-34.7-28l-39.7 0c-2.7 0-5.2 2-5.5 4.7l-16.2 102c-.2 2 1.3 4 3.2 4l20.5 0c2 0 3.5-1.5 4-3.2l4.5-29c1-7.2 13.2-4.7 18-4.7 28.4 0 45.9-17 45.9-45.8zm84.2 8.8l-19 0c-3.8 0-4 5.5-4.3 8.2-5.5-8.5-14-10-23.7-10-24.5 0-43.2 21.5-43.2 45.2 0 19.5 12.2 32.2 31.7 32.2 9.3 0 20.5-4.9 26.5-11.9-.3 1.5-1 4.7-1 6.2 0 2.3 1 4 3.2 4l17.3 0c2.7 0 5-2.9 5.5-5.7l10.2-64.3c.3-1.9-1.2-3.9-3.2-3.9zM544 190.9c0-2-1.5-3.5-3.2-3.5l-18.5 0c-1.5 0-3 1.2-3.2 2.7l-16.2 104-.3 .5c0 1.8 1.5 3.5 3.5 3.5l16.5 0c2.5 0 5-2.9 5.2-5.7l16.2-101.2 0-.3zm-90 51.8c-12.2 0-21.7 9.7-21.7 22 0 9.7 7 15 16.2 15 12 0 21.7-9.2 21.7-21.5 .1-9.8-6.9-15.5-16.2-15.5z"],
    "dhl": [640, 512, [], "f790", "M238 301.2l58.7 0 22.3-30.2-58.7 0-22.3 30.2zM0 282.9l0 6.4 81.8 0 4.7-6.4-86.5 0zM172.9 271c-8.7 0-6-3.6-4.6-5.5 2.8-3.8 7.6-10.4 10.4-14.1s2.8-5.9-2.8-5.9l-51 0-41.1 55.8 100.1 0c33.1 0 51.5-22.5 57.2-30.3l-68.2 0zm317.5-6.9l39.3-53.4-62.2 0-39.3 53.4 62.2 0zM95.3 271l-95.3 0 0 6.4 90.6 0 4.7-6.4zm111-26.6c-2.8 3.8-7.5 10.4-10.3 14.2-1.4 2-4.1 5.5 4.6 5.5l45.6 0s7.3-10 13.5-18.4c8.4-11.4 .7-35-29.2-35l-117.9 0-20.4 27.8 111.4 0c5.6 0 5.5 2.2 2.7 5.9zM0 301.2l73.1 0 4.7-6.4-77.8 0 0 6.4zm323 0l58.7 0 22.3-30.2-58.7 0c-.1 0-22.3 30.2-22.3 30.2zm222 .1l95 0 0-6.4-90.3 0-4.7 6.4zM567.3 271l-4.7 6.4 77.4 0 0-6.4-72.7 0zm-13.5 18.3l86.2 0 0-6.4-81.5 0-4.7 6.4zM389.6 210.7l-22.5 30.6-26.2 0 22.5-30.6-58.7 0-39.3 53.4 143.6 0 39.3-53.4-58.7 0zM423.1 271s-4.3 5.9-6.4 8.7c-7.4 10-.9 21.6 23.2 21.6l94.3 0 22.3-30.3-133.4 0z"],
    "tex": [640, 512, [], "e7ff", "M620.8 95.4c-30.8 .4-42.1 16.6-47.7 24.5l-.1 .1-55.7 80.5 82.8 121.1c7.5 10.6 11.3 12.5 35.4 12.5l0 9.1c-9.1-.7-28-.7-37.7-.7-12.4 0-30.8 0-42.9 .7l0-9.1c13.2-.8 16.6-7.3 16.6-10.2 0-1.1 0-2.3-3-6.4l-65.5-96.3-60.2 87.9c-1.9 2.7-3.8 5.4-3.8 10.2 0 6.1 3.4 13.6 15 14.7l0 9.1c-9.4-.7-27.1-.7-37.2-.7l-2.8 0-11.7 82.6-195.9 0 0-9.1c26.7 0 30.9 0 30.9-16.9l0-203.2c0-16.9-4.3-16.9-30.9-16.9l0-10.3 19.8 0c-4.8-61.1-10.8-71.7-68-71.8l-20.7 0c-6.8 1.5-6.8 6.1-6.8 14.4l0 205c0 13.6 1.1 17.8 32.4 17.8l10.5 0 0 9.1-.4 0c-17.9-.3-36.7-.7-54.9-.7s-36.9 .3-54.8 .7l-.6 0 0-9.1 10.7 0c31.7 0 32.8-4.1 32.8-17.8l0-205c0-8.7 0-13.2-7.2-14.3l-20.8 0c-58.4 0-63.7 10.9-68.6 73.3l-6.8 0 6.3-83.3 217.5 0 6.1 81.8 164.1 0 9 83.3-6.8 0c-5.3-49.8-12.1-73-70.3-73l-51.5 0c-15 0-15.8 1.9-15.8 14.6l0 93.3 35.5 0c35.5 0 38.9-12.8 38.9-44l6 0 0 97.9-6 0c0-31.8-3.4-44.8-38.9-44.8l-35.5 0 0 105.2c0 13 .7 14.8 15.8 14.8l52.2 0c61.1 0 69.9-25.8 77.4-73.6-7.7 0-16.3 .2-22.2 .7l0-9.1c7.2 0 31.7-.4 47.8-23.8l65.5-95.7-72.7-106.7c-8.3-11.7-15.1-12.5-35.8-12.5l0-9.1c9.1 .7 27.9 .7 37.7 .7 12.4 0 30.8 0 42.9-.7l0 9.1c-12.5 .4-16.6 6.8-16.6 10.2 0 1.1 .4 2.3 3 6.4l55.7 81.6 49.7-72.1c2.7-3.7 4.5-6.8 4.5-11.3 0-6.1-3-13.6-15-14.8l0-9.1c9.4 .7 24.8 .7 37.2 .7 9 0 23.3 0 32-.7l0 9.1z"],
    "shopify": [448, 512, [], "e057", "M388.5 104.1c-.2-1.1-.7-2.1-1.5-2.8s-1.8-1.2-2.9-1.2c-2 0-37.2-.8-37.2-.8s-21.6-20.8-29.6-28.8l0 432.7 125.7-31.2s-54-365.5-54.4-367.9zM288.9 70.5c-1.9-6.1-4.3-11.9-7.2-17.6-10.4-20-26-30.9-44.4-30.9-1.3 0-2.7 .1-4 .4-.4-.8-1.2-1.2-1.6-2-8-8.8-18.4-12.8-30.8-12.4-24 .8-48 18-67.2 48.8-13.6 21.6-24 48.8-26.8 70.1-27.6 8.4-46.8 14.4-47.2 14.8-14 4.4-14.4 4.8-16 18-1.2 10-38 291.8-38 291.8l302.6 52.5 0-438.3c-1.5 .1-2.9 .2-4.4 .4 0 0-5.6 1.6-14.8 4.4zM233.6 87.7c-16 4.8-33.6 10.4-50.8 15.6 4.8-18.8 14.4-37.6 25.6-50 4.4-4.4 10.4-9.6 17.2-12.8 6.8 14.4 8.4 34 8 47.2zM200.8 24.4c5-.2 10 1.1 14.4 3.6-6.4 3.2-12.8 8.4-18.8 14.4-15.2 16.4-26.8 42-31.6 66.5-14.4 4.4-28.8 8.8-42 12.8 8.8-38.4 41.2-96.4 78-97.2zM154.4 244.6c1.6 25.6 69.2 31.2 73.2 91.7 2.8 47.6-25.2 80.1-65.6 82.5-48.8 3.2-75.6-25.6-75.6-25.6l10.4-44s26.8 20.4 48.4 18.8c14-.8 19.2-12.4 18.8-20.4-2-33.6-57.2-31.6-60.8-86.9-3.2-46.4 27.2-93.3 94.5-97.7 26-1.6 39.2 4.8 39.2 4.8l-15.2 57.6s-17.2-8-37.6-6.4c-29.6 2-30 20.8-29.6 25.6zM249.6 82.9c0-12-1.6-29.2-7.2-43.6 18.4 3.6 27.2 24 31.2 36.4-7.2 2-15.2 4.4-24 7.2z"],
    "square-reddit": [448, 512, ["reddit-square"], "f1a2", "M64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM305.9 166.4c20.6 0 37.3-16.7 37.3-37.3s-16.7-37.3-37.3-37.3c-18 0-33.1 12.8-36.6 29.8-30.2 3.2-53.8 28.8-53.8 59.9l0 .2c-32.8 1.4-62.8 10.7-86.6 25.5-8.8-6.8-19.9-10.9-32-10.9-28.9 0-52.3 23.4-52.3 52.3 0 21 12.3 39 30.1 47.4 1.7 60.7 67.9 109.6 149.3 109.6s147.6-48.9 149.3-109.7c17.7-8.4 29.9-26.4 29.9-47.3 0-28.9-23.4-52.3-52.3-52.3-12 0-23 4-31.9 10.8-24-14.9-54.3-24.2-87.5-25.4l0-.1c0-22.2 16.5-40.7 37.9-43.7 3.9 16.5 18.7 28.7 36.3 28.7l.2-.2zM155 248.1c14.6 0 25.8 15.4 25 34.4s-11.8 25.9-26.5 25.9-27.5-7.7-26.6-26.7 13.5-33.5 28.1-33.5l0-.1zm166.4 33.5c.9 19-12 26.7-26.6 26.7s-25.6-6.9-26.5-25.9 10.3-34.4 25-34.4 27.3 14.6 28.1 33.5l0 .1zm-42.1 49.6c-9 21.5-30.3 36.7-55.1 36.7s-46.1-15.1-55.1-36.7c-1.1-2.6 .7-5.4 3.4-5.7 16.1-1.6 33.5-2.5 51.7-2.5s35.6 .9 51.7 2.5c2.7 .3 4.5 3.1 3.4 5.7z"],
    "creative-commons-nc": [512, 512, [], "f4e8", "M255.6 8C395.4 8 504 115.9 504 256 504 403.2 385.5 504 255.6 504 121.1 504 8 393.2 8 256 8 123.1 112.7 8 255.6 8zM63.8 189.1c-7.4 20.4-11.1 42.7-11.1 66.9 0 110.9 92.1 202.4 203.7 202.4 122.4 0 177.2-101.8 178.5-104.1l-93.4-41.6c-7.7 37.1-41.2 53-68.2 55.4l0 38.1-28.8 0 0-38.2c-27.5-.3-52.6-10.2-75.3-29.7l34.1-34.5c31.7 29.4 86.4 31.8 86.4-2.2 0-6.2-2.2-11.2-6.6-15.1-14.2-6-1.8-.1-219.3-97.4zM256.4 52.3C218 52.3 144 61 85.9 145.3l94.8 42.5c10-31.3 40.4-42.9 63.8-44.3l0-38.1 28.8 0 0 38.1c22.7 1.2 43.4 8.9 62 23L303 199.7c-42.7-29.9-83.5-8-70 11.1 53.4 24.1 43.8 19.8 93 41.6l127.1 56.7c4.1-17.4 6.2-35.1 6.2-53.1 0-57-19.8-105-59.3-143.9-39.3-39.9-87.2-59.8-143.6-59.8z"],
    "galactic-republic": [512, 512, [], "f50c", "M256 8a248 248 0 1 1 0 496 248 248 0 1 1 0-496zm0 16.5a231.5 231.5 0 1 0 0 462.9 231.5 231.5 0 1 0 0-462.9zm27.6 21.8l0 24.6c30.3 4.5 59 16.3 83.6 34.5l17.4-17.4c-28.7-22.1-63.3-36.9-101-41.8zm-55.4 .1c-37.6 4.9-72.2 19.8-100.9 41.9l17.3 17.4 .1 0c24.1-17.8 52.6-30.1 83.5-34.7l0-24.5zm12.2 50.2l0 82.9c-10 2-19.4 5.9-27.7 11.4l-58.6-58.6-21.9 21.9 58.7 58.7c-5.5 8.2-9.4 17.6-11.5 27.6l-82.9 0 0 31 82.9 0c2 10 6 19.3 11.5 27.5l-58.7 58.7 21.9 21.9 58.6-58.6c8.4 5.6 17.8 9.5 27.7 11.5l0 82.9 31 0 0-82.9c10-2 19.4-6.1 27.6-11.5l58.7 58.7 21.9-21.9-58.7-58.7c5.5-8.2 9.5-17.5 11.5-27.5l82.9 0 0-31-82.9 0c-2-10-6-19.4-11.5-27.6l58.7-58.7-21.9-21.9-58.7 58.7c-8.2-5.5-17.6-9.5-27.6-11.5l0-82.9-31 0zm183.2 30.7l-17.4 17.4c18.3 24.6 30.2 53.4 34.7 83.7l24.6 0c-5-37.7-19.8-72.3-41.9-101zm-335.6 .1c-22.1 28.7-36.9 63.3-41.8 100.9l24.6 0c4.6-31 16.8-59.4 34.6-83.5L88.2 127.4zM46.3 283.7c4.9 37.6 19.7 72.2 41.8 100.9l17.4-17.4C87.7 343.1 75.6 314.6 71 283.7l-24.6 0 0 0zm394.7 0c-4.6 31-16.8 59.5-34.7 83.6l17.4 17.4c22.1-28.7 37-63.3 41.9-101l-24.6 0zM144.7 406.4l-17.4 17.4c28.7 22.1 63.3 37 101 41.9l0-24.6c-31-4.6-59.5-16.8-83.6-34.6zm222.5 0c-24.1 17.8-52.6 30.1-83.6 34.7l0 24.6c37.7-4.9 72.2-19.8 101-41.8l-17.3-17.4-.1 0z"],
    "facebook": [512, 512, [62000], "f09a", "M512 256C512 114.6 397.4 0 256 0S0 114.6 0 256C0 376 82.7 476.8 194.2 504.5l0-170.3-52.8 0 0-78.2 52.8 0 0-33.7c0-87.1 39.4-127.5 125-127.5 16.2 0 44.2 3.2 55.7 6.4l0 70.8c-6-.6-16.5-1-29.6-1-42 0-58.2 15.9-58.2 57.2l0 27.8 83.6 0-14.4 78.2-69.3 0 0 175.9C413.8 494.8 512 386.9 512 256z"],
    "gitlab": [512, 512, [], "f296", "M504 204.6l-.7-1.8-69.7-181.8c-1.4-3.6-3.9-6.6-7.2-8.6-2.4-1.6-5.1-2.5-8-2.8s-5.7 .1-8.4 1.1-5.1 2.7-7.1 4.8c-1.9 2.1-3.3 4.7-4.1 7.4l-47 144-190.5 0-47.1-144c-.8-2.8-2.2-5.3-4.1-7.4-2-2.1-4.4-3.7-7.1-4.8-2.6-1-5.5-1.4-8.4-1.1s-5.6 1.2-8 2.8c-3.2 2-5.8 5.1-7.2 8.6L9.8 202.8 9 204.6c-10 26.2-11.3 55-3.5 82 7.7 26.9 24 50.7 46.4 67.6l.3 .2 .6 .4 106 79.5c38.5 29.1 66.7 50.3 84.6 63.9 3.7 1.9 8.3 4.3 13 4.3s9.3-2.4 13-4.3c17.9-13.5 46.1-34.9 84.6-63.9l106.7-79.9 .3-.3c22.4-16.9 38.7-40.6 45.6-67.5 8.6-27 7.4-55.8-2.6-82z"],
    "qq": [448, 512, [], "f1d6", "M434.1 420.4c-11.5 1.4-44.9-52.7-44.9-52.7 0 31.3-16.1 72.2-51 101.8 16.8 5.2 54.8 19.2 45.8 34.4-7.3 12.3-125.5 7.9-159.6 4-34.1 3.8-152.3 8.3-159.6-4-9-15.2 28.9-29.2 45.8-34.4-34.9-29.5-51.1-70.4-51.1-101.8 0 0-33.3 54.1-44.9 52.7-5.4-.6-12.4-29.6 9.3-99.7 10.3-33 22-60.5 40.1-105.8-3.1-116.9 45.2-215 160.3-215 113.7 0 163.2 96.1 160.3 215 18.1 45.2 29.9 72.9 40.1 105.8 21.8 70.1 14.7 99.1 9.3 99.7z"],
    "stripe": [640, 512, [], "f429", "M165 144.7l-43.3 9.2-.2 142.4c0 26.3 19.8 43.3 46.1 43.3 14.6 0 25.3-2.7 31.2-5.9l0-33.8c-5.7 2.3-33.7 10.5-33.7-15.7l0-63.2 33.7 0 0-37.8-33.7 0-.1-38.5zm89.1 51.6l-2.7-13.1-38.4 0 0 153.2 44.3 0 0-103.1c10.5-13.8 28.2-11.1 33.9-9.3l0-40.8c-6-2.1-26.7-6-37.1 13.1zM346.4 124l-44.6 9.5 0 36.2 44.6-9.5 0-36.2zM44.9 228.3c0-6.9 5.8-9.6 15.1-9.7 13.5 0 30.7 4.1 44.2 11.4l0-41.8c-14.7-5.8-29.4-8.1-44.1-8.1-36 0-60 18.8-60 50.2 0 49.2 67.5 41.2 67.5 62.4 0 8.2-7.1 10.9-17 10.9-14.7 0-33.7-6.1-48.6-14.2l0 40c16.5 7.1 33.2 10.1 48.5 10.1 36.9 0 62.3-15.8 62.3-47.8 0-52.9-67.9-43.4-67.9-63.4zM640 261.6c0-45.5-22-81.4-64.2-81.4s-67.9 35.9-67.9 81.1c0 53.5 30.3 78.2 73.5 78.2 21.2 0 37.1-4.8 49.2-11.5l0-33.4c-12.1 6.1-26 9.8-43.6 9.8-17.3 0-32.5-6.1-34.5-26.9l86.9 0c.2-2.3 .6-11.6 .6-15.9zm-87.9-16.8c0-20 12.3-28.4 23.4-28.4 10.9 0 22.5 8.4 22.5 28.4l-45.9 0zM439.2 180.2c-17.4 0-28.6 8.2-34.8 13.9l-2.3-11-39.1 0 0 204.8 44.4-9.4 .1-50.2c6.4 4.7 15.9 11.2 31.4 11.2 31.8 0 60.8-23.2 60.8-79.6 .1-51.6-29.3-79.7-60.5-79.7zM428.6 302.7c-10.4 0-16.6-3.8-20.9-8.4l-.3-66c4.6-5.1 11-8.8 21.2-8.8 16.2 0 27.4 18.2 27.4 41.4 .1 23.9-10.9 41.8-27.4 41.8zM301.9 336.4l44.6 0 0-153.2-44.6 0 0 153.2z"],
    "dailymotion": [448, 512, [], "e052", "M298.9 267c-7.4-4.2-15.8-6.3-24.4-6.2-13.2 0-24.4 4.4-33.4 13.3s-13.6 20-13.6 33.4c0 14.1 4.4 25.6 13.3 34.6s20 13.4 33.4 13.4c13.7 0 25-4.6 34.1-13.8S322 321.1 322 307.5c0-8.2-2.1-16.3-6.1-23.5-4-7.1-9.8-13-17-17zM0 32l0 448 448 0 0-448-448 0zM374.7 405.3l-53.1 0 0-23.9-.7 0c-10.5 17.5-29.1 26.2-55.8 26.2-18.4 0-34.7-4.4-48.9-13.1-14.1-8.6-25.5-21-32.9-35.8-7.7-15.1-11.6-32.1-11.6-50.9 0-18.4 3.9-35.1 11.8-50.2 7.5-14.7 18.9-27.1 32.9-35.8 14.1-8.7 30-13.1 47.7-13.1 10.2-.1 20.2 1.6 29.7 5.2 8.9 3.5 17.2 9.1 25 17l0-77.9 55.8-12.1 0 264.4z"],
    "steam": [512, 512, [], "f1b6", "M504 256c0 137-111.2 248-248.4 248-113.8 0-209.6-76.3-239-180.4l95.2 39.3c6.4 32.1 34.9 56.4 68.9 56.4 39.2 0 71.9-32.4 70.2-73.5l84.5-60.2c52.1 1.3 95.8-40.9 95.8-93.5 0-51.6-42-93.5-93.7-93.5s-93.7 42-93.7 93.5l0 1.2-59.2 85.7c-15.5-.9-30.7 3.4-43.5 12.1L8 236.1C18.2 108.4 125.1 8 255.6 8 392.8 8 504 119 504 256zM163.7 384.3l-30.5-12.6c5.6 11.6 15.3 20.8 27.2 25.8 26.9 11.2 57.8-1.6 69-28.4 5.4-13 5.5-27.3 .1-40.3S214 305.6 201 300.2c-12.9-5.4-26.7-5.2-38.9-.6l31.5 13c19.8 8.2 29.2 30.9 20.9 50.7-8.3 19.9-31 29.2-50.8 21zM337.5 129.8a62.3 62.3 0 1 1 0 124.6 62.3 62.3 0 1 1 0-124.6zm.1 109a46.8 46.8 0 1 0 0-93.6 46.8 46.8 0 1 0 0 93.6z"],
    "snapchat": [512, 512, [62124, "snapchat-ghost"], "f2ab", "M497.1 366.6c-3.4-9.2-9.8-14.1-17.1-18.2-1.4-.8-2.6-1.5-3.7-1.9-2.2-1.1-4.4-2.2-6.6-3.4-22.8-12.1-40.6-27.3-53-45.4-3.5-5.1-6.6-10.5-9.1-16.1-1.1-3-1-4.7-.2-6.3 .8-1.2 1.7-2.2 2.9-3 3.9-2.6 8-5.2 10.7-7 4.9-3.2 8.8-5.7 11.2-7.4 9.4-6.5 15.9-13.5 20-21.3 2.9-5.4 4.5-11.3 4.9-17.4s-.6-12.2-2.8-17.8c-6.2-16.3-21.6-26.4-40.3-26.4-3.9 0-7.9 .4-11.7 1.2-1 .2-2.1 .5-3.1 .7 .2-11.2-.1-22.9-1.1-34.5-3.5-40.8-17.8-62.1-32.7-79.2-9.5-10.7-20.7-19.7-33.2-26.7-22.6-12.9-48.2-19.4-76.1-19.4s-53.4 6.5-76 19.4c-12.5 7-23.7 16.1-33.3 26.8-14.9 17-29.2 38.4-32.7 79.2-1 11.6-1.2 23.4-1.1 34.5-1-.3-2-.5-3.1-.7-3.9-.8-7.8-1.2-11.7-1.2-18.7 0-34.1 10.1-40.3 26.4-2.2 5.7-3.2 11.8-2.8 17.8s2 12 4.9 17.4c4.1 7.8 10.7 14.7 20 21.3 2.5 1.7 6.4 4.2 11.2 7.4 2.6 1.7 6.5 4.2 10.3 6.7 1.3 .9 2.4 2 3.3 3.3 .8 1.6 .8 3.4-.4 6.6-2.5 5.5-5.5 10.8-8.9 15.8-12.1 17.7-29.4 32.6-51.4 44.6-11.7 6.2-23.9 10.3-29 24.3-3.9 10.5-1.3 22.5 8.5 32.6 3.6 3.8 7.8 6.9 12.4 9.4 9.6 5.3 19.8 9.3 30.3 12.1 2.2 .6 4.3 1.5 6.1 2.7 3.6 3.1 3.1 7.9 7.8 14.8 2.4 3.6 5.4 6.7 9 9.1 10 6.9 21.3 7.4 33.2 7.8 10.8 .4 23 .9 36.9 5.5 5.8 1.9 11.8 5.6 18.7 9.9 16.7 10.3 39.6 24.3 77.8 24.3s61.3-14.1 78.1-24.4c6.9-4.2 12.9-7.9 18.5-9.8 13.9-4.6 26.2-5.1 36.9-5.5 11.9-.5 23.2-.9 33.2-7.8 4.2-2.9 7.7-6.7 10.2-11.2 3.4-5.8 3.4-9.9 6.6-12.8 1.8-1.2 3.7-2.1 5.8-2.6 10.7-2.8 21-6.9 30.8-12.2 4.9-2.6 9.3-6.1 13-10.2l.1-.2c9.2-9.9 11.5-21.5 7.8-31.8zm-34 18.3c-20.7 11.5-34.5 10.2-45.3 17.1-9.1 5.9-3.7 18.5-10.3 23.1-8.1 5.6-32.2-.4-63.2 9.9-25.6 8.5-42 32.8-88 32.8s-62-24.3-88.1-32.9c-31-10.3-55.1-4.2-63.2-9.9-6.6-4.6-1.2-17.2-10.3-23.1-10.7-6.9-24.5-5.7-45.3-17.1-13.2-7.3-5.7-11.8-1.3-13.9 75.1-36.4 87.1-92.6 87.7-96.7 .6-5 1.4-9-4.2-14.1-5.4-5-29.2-19.7-35.8-24.3-10.9-7.6-15.7-15.3-12.2-24.6 2.5-6.5 8.5-8.9 14.9-8.9 2 0 4 .2 6 .7 12 2.6 23.7 8.6 30.4 10.2 .8 .2 1.6 .3 2.5 .3 3.6 0 4.9-1.8 4.6-5.9-.8-13.1-2.6-38.7-.6-62.6 2.8-32.9 13.4-49.2 26-63.6 6.1-6.9 34.5-37 88.9-37S339 74.2 345 81.1c12.6 14.4 23.2 30.7 26 63.6 2.1 23.9 .3 49.5-.6 62.6-.3 4.3 1 5.9 4.6 5.9 .8 0 1.7-.1 2.5-.3 6.7-1.6 18.4-7.6 30.4-10.2 2-.4 4-.7 6-.7 6.4 0 12.4 2.5 14.9 8.9 3.5 9.4-1.2 17-12.2 24.6-6.6 4.6-30.4 19.3-35.8 24.3-5.6 5.1-4.8 9.1-4.2 14.2 .5 4.2 12.5 60.4 87.7 96.7 4.4 2.2 11.9 6.7-1.3 14.1z"],
    "galactic-senate": [512, 512, [], "f50d", "M249.9 33.5l0 26.1c-13.6 20.6-23.9 108.6-24.5 215.3 11.7-15.6 19.1-33.3 19.1-48.2l0-16.9c0-5.3 .8-10.5 2.2-15.6 .6-2.1 1.4-4.1 2.6-5.8s3.4-3.8 6.7-3.8 5.4 2.1 6.7 3.8c1.2 1.8 2 3.7 2.6 5.8 1.4 5.1 2.2 10.3 2.2 15.6l0 16.9c0 14.9 7.4 32.6 19.1 48.2-.6-106.8-10.9-194.7-24.5-215.3l0-26.1-12.3 0zM223.5 181.3c-9.5 2.1-18.7 5.2-27.5 9.1 8.9 16.1 9.8 32.6 1.7 37.3-8 4.6-21.8-4.2-31.4-19.8-11.6 8.8-21.9 19.3-30.6 31.1 14.7 9.6 22.9 22.9 18.3 30.7-4.5 7.7-20 7.1-35.5-1-5.8 13.2-9.7 27.5-11.6 42.4 9.7 .2 18.7 2.4 26.2 6 17.8-.3 32.8-2 40.5-4.2 5.6-26.4 23-48.2 46.3-59.5 .7-25.6 1.9-49.7 3.5-72.1zm65 0c1.6 22.4 2.7 46.5 3.5 72.1 23.3 11.3 40.8 33.2 46.3 59.5 7.7 2.3 22.7 3.9 40.5 4.2 7.5-3.7 16.5-5.8 26.2-6-1.9-14.9-5.9-29.2-11.7-42.4-15.4 8.1-30.9 8.7-35.5 1-4.6-7.7 3.6-21.1 18.3-30.7-8.7-11.8-19-22.3-30.6-31.1-9.5 15.6-23.4 24.4-31.4 19.8-8.1-4.6-7.2-21.2 1.7-37.3-8.8-3.9-18-7-27.4-9.1zM256 189.9c-3.2 0-5.9 8.8-6.1 19.9l0 0 0 16.9c0 41.4-49 95-93.5 95-52 0-122.8-1.4-156.4 29.2l0 2.5c9.4 17.1 20.6 33.2 33.2 48 12.5-21.1 51.6-41 108-41.4 45.7 1 79 20.3 90.8 40.9 0 0 0 0 0 .1 7.7 2.1 15.8 3.2 24 3.2 8.2 0 16.4-1.1 24-3.2 0 0 0 0 0-.1 11.7-20.5 45.1-39.8 90.8-40.9 56.4 .4 95.5 20.3 108 41.4 12.6-14.8 23.8-30.9 33.2-48l0-2.5c-33.6-30.6-104.4-29.2-156.4-29.2-44.5 0-93.5-53.6-93.5-95l0-16.9-.1 0c-.2-11.1-2.9-19.9-6.1-19.9zm0 177.9a40.6 40.6 0 1 1 0-81.3 40.6 40.6 0 1 1 0 81.3zm0-73.6a33 33 0 1 0 0 65.9 33 33 0 1 0 0-65.9zm0 59.8a26.8 26.8 0 1 1 0-53.6 26.8 26.8 0 1 1 0 53.6zm-114.8 13c-10.2 .1-21.6 .4-30.5 1.7 .4 4.4 1.5 18.6 7.1 29.8 9.1-2.6 18.4-3.9 27.6-3.9 41.3 .9 71.5 34.4 78.3 74.5l.1 4.7c10.4 1.9 21.2 2.9 32.2 2.9 11 0 21.8-1 32.2-2.9l.1-4.7c6.8-40.1 37-73.5 78.3-74.5 9.3 0 18.5 1.3 27.6 3.9 5.6-11.1 6.7-25.3 7.1-29.8-8.9-1.3-20.3-1.6-30.5-1.7-18.8 .4-35.2 4.2-48.6 9.7-12.5 16-29.2 30-49.6 33.1-.1 0-.2 0-.3 0 0 0-.1 0-.2 .1-5.2 1.1-10.6 1.6-16.2 1.6-5.5 0-10.9-.5-16.2-1.6-.1 0-.1 0-.2-.1-.1 0-.2 0-.3 0-20.4-3-37-17-49.6-33.1-13.4-5.5-29.9-9.2-48.6-9.7z"],
    "phoenix-framework": [640, 512, [], "f3dc", "M212.9 344.3c3.8-.1 22.8-1.4 25.6-2.2-2.4-2.6-43.6-1-68-49.6-4.3-8.6-7.5-17.6-6.4-27.6 2.9-25.5 32.9-30 52-18.5 36 21.6 63.3 91.3 113.7 97.5 37 4.5 84.6-17 108.2-45.4-.6-.1-.8-.2-1-.1-.4 .1-.8 .2-1.1 .3-33.3 12.1-94.3 9.7-134.7-14.8-37.6-22.8-53.1-58.7-51.8-74.6 1.8-21.3 22.9-23.2 35.9-19.6 14.4 3.9 24.4 17.6 38.9 27.4 15.6 10.4 32.9 13.7 51.3 10.3 14.9-2.7 34.4-12.3 36.5-14.5-1.1-.1-1.8-.1-2.5-.2-6.2-.6-12.4-.8-18.5-1.7-111.2-16.5-128.9-163.6-252.5-173.1-44.3-3.4-99.4 8.1-136.3 35-.8 .6-1.5 1.2-2.2 1.8 .1 .2 .1 .3 .2 .5 .8 0 1.6-.1 2.4-.2 6.3-1 12.5-.8 18.7 .3 23.8 4.3 47.7 23.1 55.9 76.5 5.3 34.3-.7 50.8 8 86.1 19 77.1 91 107.6 127.7 106.4zM75.3 64.9c-.9-1-.9-1.2-1.3-2 12.1-2.6 24.2-4.1 36.6-4.8-1.1 14.7-22.2 21.3-35.3 6.8zM272.2 415.4c-42.8 1.2-92-26.7-123.5-61.4-4.6-5-16.8-20.2-18.6-23.4l.4-.4c6.6 4.1 25.7 18.6 54.8 27 24.2 7 48.1 6.3 71.6-3.3 22.7-9.3 41-.5 43.1 2.9-18.5 3.8-20.1 4.4-24 7.9-5.1 4.4-4.6 11.7 7 17.2 26.2 12.4 63-2.8 97.2 25.4 2.4 2 8.1 7.8 10.1 10.7-.1 .2-.3 .3-.4 .5-4.8-1.5-16.4-7.5-40.2-9.3-24.7-2-46.3 5.3-77.5 6.2zM447 163.4c16.4-5.2 41.3-13.4 66.5-3.3 16.1 6.5 26.2 18.7 32.1 34.6 3.5 9.4 5.1 19.7 5.1 28.7-.2 0-.4 0-.6 .1-.2-.4-.4-.9-.5-1.3-5-22-29.9-43.8-67.6-29.9-50.2 18.6-130.4 9.7-176.9-48-.7-.9-2.4-1.7-1.3-3.2 .1-.2 2.1 .6 3 1.3 18.1 13.4 38.3 21.9 60.3 26.2 30.5 6.1 54.6 2.9 79.9-5.2zM549.7 280.9c-32.4 .2-33.8 50.1-103.6 64.4-18.2 3.7-38.7 4.6-44.9 4.2l0-.4c2.8-1.5 14.7-2.6 29.7-16.6 7.9-7.3 15.3-15.1 22.8-22.9 19.5-20.2 41.4-42.2 81.9-39 23.1 1.8 29.3 8.2 36.1 12.7 .3 .2 .4 .5 .7 .9-.5 0-.7 .1-.9 0-7-2.7-14.3-3.3-21.8-3.3zm-12.3-24.1c-.1 .2-.1 .4-.2 .6-28.9-4.4-48-7.9-68.5 4-17 9.9-31.4 20.5-62 24.4-27.1 3.4-45.1 2.4-66.1-8-.3-.2-.6-.4-1-.6 0-.2 .1-.3 .1-.5 24.9 3.8 36.4 5.1 55.5-5.8 22.3-12.9 40.1-26.6 71.3-31 29.6-4.1 51.3 2.5 70.9 16.9zM268.6 97.3c-.6-.6-1.1-1.2-2.1-2.3 7.6 0 29.7-1.2 53.4 8.4 19.7 8 32.2 21 50.2 32.9 11.1 7.3 23.4 9.3 36.4 8.1 4.3-.4 8.5-1.2 12.8-1.7 .4-.1 .9 0 1.5 .3-.6 .4-1.2 .9-1.8 1.2-8.1 4-16.7 6.3-25.6 7.1-26.1 2.6-50.3-3.7-73.4-15.4-19.3-9.9-36.4-22.9-51.4-38.6zM640 335.7c-3.5 3.1-22.7 11.6-42.7 5.3-12.3-3.9-19.5-14.9-31.6-24.1-10-7.6-20.9-7.9-28.1-8.4 .6-.8 .9-1.2 1.2-1.4 14.8-9.2 30.5-12.2 47.3-6.5 12.5 4.2 19.2 13.5 30.4 24.2 10.8 10.4 21 9.9 23.1 10.5 .1-.1 .2 0 .4 .4zm-212.5 137c2.2 1.2 1.6 1.5 1.5 2-18.5-1.4-33.9-7.6-46.8-22.2-21.8-24.7-41.7-27.9-48.6-29.7 .5-.2 .8-.4 1.1-.4 13.1 .1 26.1 .7 38.9 3.9 25.3 6.4 35 25.4 41.6 35.3 3.2 4.8 7.3 8.3 12.3 11.1z"],
    "git": [512, 512, [], "f1d3", "M216.3 158.4l-79.3 0c-40-10.5-130.5-7.8-130.5 74.8 0 30.1 15 51.2 35 61-25.1 23-37 33.8-37 49.2 0 11 4.5 21.1 17.9 26.8-14.3 13.4-22.4 23.1-22.4 41.4 0 32.1 28 50.8 101.6 50.8 70.8 0 111.8-26.4 111.8-73.2 0-58.7-45.2-56.5-151.6-63l13.4-21.6c27.3 7.6 118.7 10 118.7-67.9 0-18.7-7.7-31.7-15-41.1l37.4-2.8 0-34.5zM152.9 400.3c0 32.1-104.9 32.1-104.9 2.4 0-8.1 5.3-15 10.6-21.5 77.7 5.3 94.3 3.4 94.3 19.1zM102.1 265.7c-52.8 0-50.5-71.2 1.2-71.2 49.5 0 50.8 71.2-1.2 71.2zM235.4 366.2l0-32.1c26.7-3.7 27.2-2 27.2-11l0-119.5c0-8.5-2.1-7.4-27.2-16.3l4.5-32.9 84.2 0 0 168.7c0 6.5 .4 7.3 6.5 8.1l20.7 2.8 0 32.1-115.9 0zm52.5-244.3c-23.2 0-36.6-13.4-36.6-36.6s13.4-35.8 36.6-35.8c23.6 0 37 12.6 37 35.8s-13.4 36.6-37 36.6zM512 350.5c-17.5 8.5-43.1 16.3-66.3 16.3-48.4 0-66.7-19.5-66.7-65.5l0-106.5c0-5.4 1-4.1-31.7-4.1l0-36.2c35.8-4.1 50-22 54.5-66.3l38.6 0c0 65.8-1.3 61.8 3.3 61.8l57.3 0 0 40.6-60.6 0 0 97.1c0 6.9-4.9 51.4 60.6 26.8l11 35.8z"],
    "optin-monster": [576, 512, [], "f23c", "M572.8 421.4c5.6-9.5 4.7-15.2-5.4-11.6-3-4.9-7-9.5-11.1-13.8 2.9-9.7-.7-14.2-10.8-9.2-4.6-3.2-10.3-6.5-15.9-9.2 0-15.1-11.6-11.6-17.6-5.7-10.4-1.5-18.7-.3-26.8 5.7 .3-6.5 .3-13 .3-19.7 12.6 0 40.2-11 45.9-36.2 1.4-6.8 1.6-13.8-.3-21.9-3-13.5-14.3-21.3-25.1-25.7-.8-5.9-7.6-14.3-14.9-15.9s-12.4 4.9-14.1 10.3c-8.5 0-19.2 2.8-21.1 8.4-5.4-.5-11.1-1.4-16.8-1.9 2.7-1.9 5.4-3.5 8.4-4.6 5.4-9.2 14.6-11.4 25.7-11.6l0-2.8c19.5-.5 43-5.9 53.8-18.1 12.7-13.8 14.6-37.3 12.4-55.1-2.4-17.3-9.7-37.6-24.6-48.1-8.4-5.9-21.6-.8-22.7 9.5-2.2 19.6 1.2 30-38.6 25.1-10.3-23.8-24.6-44.6-42.7-60-69.6-59.7-167.7-53.8-244.2-37.6 19.7 4.6 41.1 8.6 59.7 16.5-26.2 2.4-52.7 11.3-76.2 23.2-32.8 17-44 29.9-56.7 42.4 14.9-2.2 28.9-5.1 43.8-3.8-9.7 5.4-18.4 12.2-26.5 20-25.8 .9-23.8-5.3-26.2-25.9-1.1-10.5-14.3-15.4-22.7-9.7-28.1 19.9-33.5 79.9-12.2 103.5 10.8 12.2 35.1 17.3 54.9 17.8-.3 1.1-.3 1.9-.3 2.7 10.8 .5 19.5 2.7 24.6 11.6 3 1.1 5.7 2.7 8.1 4.6-5.4 .5-11.1 1.4-16.5 1.9-3.3-6.6-13.7-8.1-21.1-8.1-1.6-5.7-6.5-12.2-14.1-10.3-6.8 1.9-14.1 10-14.9 15.9-22.5 9.5-30.1 26.8-25.1 47.6 5.3 24.8 33 36.2 45.9 36.2l0 19.7c-6.6-5-14.3-7.5-26.8-5.7-5.5-5.5-17.3-10.1-17.3 5.7-5.9 2.7-11.4 5.9-15.9 9.2-9.8-4.9-13.6-1.7-11.1 9.2-4.1 4.3-7.8 8.6-11.1 13.8-10.2-3.7-11 2.2-5.4 11.6-1.1 3.5-1.6 7-1.9 10.8-.5 31.6 44.6 64 73.5 65.1 17.3 .5 34.6-8.4 43-23.5 113.2 4.9 226.7 4.1 340.2 0 8.1 15.1 25.4 24.3 42.7 23.5 29.2-1.1 74.3-33.5 73.5-65.1 .2-3.7-.7-7.2-1.7-10.7zM499 167.4c1.1-3 2.4-8.4 2.4-14.6 0-5.9 6.8-8.1 14.1-.8 11.1 11.6 14.9 40.5 13.8 51.1-4.1-13.6-13-29-30.3-35.7zm-4.6 6.7c19.5 6.2 28.6 27.6 29.7 48.9-1.1 2.7-3 5.4-4.9 7.6-5.7 5.9-15.4 10-26.2 12.2 4.3-21.3 .3-47.3-12.7-63 4.9-.8 10.9-2.4 14.1-5.7zm-24.1 6.8c13.8 11.9 20 39.2 14.1 63.5-4.1 .5-8.1 .8-11.6 .8-1.9-21.9-6.8-44-14.3-64.6 3.7 .3 8.1 .3 11.8 .3zM47.7 203c-1.1-10.5 2.4-39.5 13.8-51.1 7-7.3 14.1-5.1 14.1 .8 0 6.2 1.4 11.6 2.4 14.6-17.3 6.8-26.2 22.2-30.3 35.7zm9.7 27.6c-1.9-2.2-3.5-4.9-4.9-7.6 1.4-21.3 10.3-42.7 29.7-48.9 3.2 3.2 9.2 4.9 14.1 5.7-13 15.7-17 41.6-12.7 63-10.8-2.2-20.5-6-26.2-12.2zm47.9 14.6c-4.1 0-8.1-.3-12.7-.8-4.6-18.6-1.9-38.9 5.4-53l0 .3 12.2-5.1c4.9-1.9 9.7-3.8 14.9-4.9-10.7 19.7-17.4 41.3-19.8 63.5zm184-10.5a76.1 76.1 0 1 1 0-152.2 76.1 76.1 0 1 1 0 152.2zm115.6 22.1c-.3 17.8-7 48.9-23 57-13.2 6.6-6.5-7.5-16.5-58.1 13.3 .3 26.6 .3 39.5 1.1zm-54-1.6c.8 4.9 3.8 40.3-1.6 41.9-11.6 3.5-40 4.3-51.1-1.1-4.1-3-4.6-35.9-4.3-41.1l0 .3c18.9-.3 38.1-.3 57 0zM278.5 309c-13 3.5-41.6 4.1-54.6-1.6-6.5-2.7-3.8-42.4-1.9-51.6 19.2-.5 38.4-.5 57.8-.8l0 .3c1.1 8.3 3.3 51.2-1.3 53.7zM172 257.9c12.2-.8 24.6-1.4 36.8-1.6-2.4 15.4-3 43.5-4.9 52.2-1.1 6.8-4.3 6.8-9.7 4.3-21.9-9.8-27.6-35.2-22.2-54.9zm-35.4 31.3c7.8-1.1 15.7-1.9 23.5-2.7 1.6 6.2 3.8 11.9 7 17.6 10 17 44 35.7 45.1 7 6.2 14.9 40.8 12.2 54.9 10.8 15.7-1.4 23.8-1.4 26.8-14.3 12.4 4.3 30.8 4.1 44 3 11.3-.8 20.8-.5 24.6-8.9 1.1 5.1 1.9 11.6 4.6 16.8 10.8 21.3 37.3 1.4 46.8-31.6 8.6 .8 17.6 1.9 26.5 2.7-.4 1.3-3.8 7.3 7.3 11.6-47.6 47-95.7 87.8-163.2 107-63.2-20.8-112.1-59.5-155.9-106.5 9.6-3.4 10.4-8.8 8-12.5zM115 461.7c-3.8 17.8-21.9 29.7-39.7 28.9-19.2-.8-46.5-17-59.2-36.5-2.7-31.1 43.8-61.3 66.2-54.6 14.9 4.3 27.8 30.8 33.5 54 0 3-.3 5.7-.8 8.2zm-8.7-66c-.5-13.5-.5-27-.3-40.5l.3 0c2.7-1.6 5.7-3.8 7.8-6.5 6.5-1.6 13-5.1 15.1-9.2 3.3-7.1-7-7.5-5.4-12.4 2.7-1.1 5.7-2.2 7.8-3.5 29.2 29.2 58.6 56.5 97.3 77-36.8 11.3-72.4 27.6-105.9 47-1.2-18.6-7.7-35.9-16.7-51.9zm337.6 64.6c-103 3.5-206.2 4.1-309.4 0 0 .3 0 .3-.3 .3l0-.3 .3 0c35.1-21.6 72.2-39.2 112.4-50.8 11.6 5.1 23 9.5 34.9 13.2 2.2 .8 2.2 .8 4.3 0 14.3-4.1 28.4-9.2 42.2-15.4 41.5 11.7 78.8 31.7 115.6 53zm10.5-12.4c-35.9-19.5-73-35.9-111.9-47.6 38.1-20 71.9-47.3 103.5-76.7 2.2 1.4 4.6 2.4 7.6 3.2 0 .8 .3 1.9 .5 2.4-4.6 2.7-7.8 6.2-5.9 10.3 2.2 3.8 8.6 7.6 15.1 8.9 2.4 2.7 5.1 5.1 8.1 6.8 0 13.8-.3 27.6-.8 41.3l.3-.3c-9.3 15.9-15.5 37-16.5 51.7zm105.9 6.2c-12.7 19.5-40 35.7-59.2 36.5-19.3 .9-40.5-13.2-40.5-37 5.7-23.2 18.9-49.7 33.5-54 22.7-6.9 69.2 23.4 66.2 54.5zM373.1 75.2c-3.8-72.1-100.8-79.7-126-23.5 44.6-24.3 90.3-15.7 126 23.5zM75 407.1c-15.7 1.6-49.5 25.4-49.5 43.2 0 11.6 15.7 19.5 32.2 14.9 12.2-3.2 31.1-17.6 35.9-27.3 6-11.6-3.7-32.7-18.6-30.8zM290.9 230.9c28.6 0 51.9-21.6 51.9-48.4 0-36.1-40.5-58.1-72.2-44.3 9.5 3 16.5 11.6 16.5 21.6 0 23.3-33.3 32-46.5 11.3-7.3 34.1 19.4 59.8 50.3 59.8zM68.2 474.1c.5 6.5 12.2 12.7 21.6 9.5 6.8-2.7 14.6-10.5 17.3-16.2 3-7-1.1-20-9.7-18.4-8.9 1.6-29.7 16.7-29.2 25.1zm433.2-67c-14.9-1.9-24.6 19.2-18.9 30.8 4.9 9.7 24.1 24.1 36.2 27.3 16.5 4.6 32.2-3.2 32.2-14.9 0-17.8-33.8-41.6-49.5-43.2zM479 449c-8.4-1.6-12.4 11.3-9.5 18.4 2.4 5.7 10.3 13.5 17.3 16.2 9.2 3.2 21.1-3 21.3-9.5 .9-8.4-20.2-23.5-29.1-25.1z"],
    "jenkins": [448, 512, [], "f3b6", "M455.4 425c-1.4-11.2-19-23.1-28.2-31.9-5.1-5-29-23.1-30.4-29.9-1.4-6.6 9.7-21.5 13.3-28.9 5.1-10.7 8.8-23.7 11.3-32.6 18.8-66.1 20.7-156.9-6.2-211.2-10.2-20.6-38.6-49-56.4-62.5-42-31.7-119.6-35.3-170.1-16.6-14.1 5.2-27.8 9.8-40.1 17.1-33.1 19.4-68.3 32.5-78.1 71.6-24.2 10.8-31.5 41.8-30.3 77.8 .2 7 4.1 15.8 2.7 22.4-.7 3.3-5.2 7.6-6.1 9.8-11.6 27.7-2.3 64 11.1 83.7 8.1 11.9 21.5 22.4 39.2 25.2 .7 10.6 3.3 19.7 8.2 30.4 3.1 6.8 14.7 19 10.4 27.7-2.2 4.4-21 13.8-27.3 17.6-21.1 12.5-36.4 20.3-55.9 34.3-12.6 9-32.3 10.2-29.2 31.1 2.1 14.1 10.1 31.6 14.7 45.8 .7 2 1.4 4.1 2.1 6l422 0c4.9-15.3 9.7-30.9 14.6-47.2 3.4-11.4 10.2-27.8 8.7-39.7zM174.2 33.7c1.8-.5 3.4 .7 4.9 2.4-.2 5.2-5.4 5.1-8.9 6.8-5.4 6.7-13.4 9.8-20 17.2-6.8 7.5-14.4 27.7-23.4 30-4.5 1.1-9.7-.8-13.6-.5-10.4 .7-17.7 6-28.3 7.5 13.6-29.9 56.1-54 89.3-63.4zM69.4 127.3c13.5-14.9 32.1-24.1 54.8-25.9 11.7 29.7-8.4 65-.9 97.6 2.3 9.9 10.2 25.4-2.4 25.7 .3-28.3-34.8-46.3-61.3-29.6-1.8-21.5-4.9-51.7 9.8-67.8zm36.7 200.2c-1-4.1-2.7-12.9-2.3-15.1 1.6-8.7 17.1-12.5 11-24.7-11.3-.1-13.8 10.2-24.1 11.3-26.7 2.6-45.6-35.4-44.4-58.4 1-19.5 17.6-38.2 40.1-35.8 16 1.8 21.4 19.2 24.5 34.7 9.2 .5 22.5-.4 26.9-7.6-.6-17.5-8.8-31.6-8.2-47.7 1-30.3 17.5-57.6 4.8-87.4 13.6-30.9 53.5-55.3 83.1-70 36.6-18.3 94.9-3.7 129.3 15.8 19.7 11.1 34.4 32.7 48.3 50.7-19.5-5.8-36.1 4.2-33.1 20.3 16.3-14.9 44.2-.2 52.5 16.4 7.9 15.8 7.8 39.3 9 62.8 2.9 57-10.4 115.9-39.1 157.1-7.7 11-14.1 23-24.9 30.6-26 18.2-65.4 34.7-99.2 23.4-44.7-15-65-44.8-89.5-78.8 .7 18.7 13.8 34.1 26.8 48.4 11.3 12.5 25 26.6 39.7 32.4-12.3-2.9-31.1-3.8-36.2 7.2-28.6-1.9-55.1-4.8-68.7-24.2-10.6-15.4-21.4-41.4-26.3-61.4zm222 124.1c4.1-3 11.1-2.9 17.4-3.6-5.4-2.7-13-3.7-19.3-2.2-.1-4.2-2-6.8-3.2-10.2 10.6-3.8 35.5-28.5 49.6-20.3 6.7 3.9 9.5 26.2 10.1 37 .4 9-.8 18-4.5 22.8-18.8-.6-35.8-2.8-50.7-7 .9-6.1-1-12.1 .6-16.5zm-17.2-20c-16.8 .8-26-1.2-38.3-10.8 .2-.8 1.4-.5 1.5-1.4 18 8 40.8-3.3 59-4.9-7.9 5.1-14.6 11.6-22.2 17.1zm-12.1 33.2c-1.6-9.4-3.5-12-2.8-20.2 25-16.6 29.7 28.6 2.8 20.2zM194.3 438.6c-11.6-.7-48.1-14-38.5-23.7 9.4 6.5 27.5 4.9 41.3 7.3 .8 4.4-2.8 10.2-2.8 16.4zM26 497.1c-4.3-12.7-9.2-25.1-14.8-36.9 30.8-23.8 65.3-48.9 102.2-63.5 2.8-1.1 23.2 25.4 26.2 27.6 16.5 11.7 37 21 56.2 30.2 1.2 8.8 3.9 20.2 8.7 35.5 .7 2.3 1.4 4.7 2.2 7.2l-180.7 0 0-.1zm240.6 5.7l-.8 0c.3-.2 .5-.4 .8-.5l0 .5zm7.5-5.7c2.1-1.4 4.3-2.8 6.4-4.3 1.1 1.4 2.2 2.8 3.2 4.3l-9.6 0zm15.1-24.7c-10.8 7.3-20.6 18.3-33.3 25.2-6 3.3-27 11.7-33.4 10.2-3.6-.8-3.9-5.3-5.4-9.5-3.1-9-10.1-23.4-10.8-37-.8-17.2-2.5-46 16-42.4 14.9 2.9 32.3 9.7 43.9 16.1 7.1 3.9 11.1 8.6 21.9 9.5-.1 1.4-.1 2.8-.2 4.3-5.9 3.9-15.3 3.8-21.8 7.1 9.5 .4 17 2.7 23.5 5.9-.1 3.4-.3 7-.4 10.6zm53.4 24.7l-14 0c-.1-3.2-2.8-5.8-6.1-5.8s-5.9 2.6-6.1 5.8l-17.4 0c-2.8-4.4-5.7-8.6-8.9-12.5 2.1-2.2 4-4.7 6-6.9 9 3.7 14.8-4.9 21.7-4.2 7.9 .8 14.2 11.7 25.4 11l-.6 12.6zm8.7 0c.2-4 .4-7.8 .6-11.5 15.6-7.3 29 1.3 35.7 11.5l-36.3 0zm83.4-37c-2.3 11.2-5.8 24-9.9 37.1-.2-.1-.4-.1-.6-.1l-27.9 0c.6-1.1 1.2-2.2 1.9-3.3-2.6-6.1-9-8.7-10.9-15.5 12.1-22.7 6.5-93.4-24.2-78.5 4.3-6.3 15.6-11.5 20.8-19.3 13 10.4 20.8 20.3 33.2 31.4 6.8 6 20 13.3 21.4 23.1 .8 5.5-2.6 18.9-3.8 25.1zM190.5 130.5c5.4-14.9 27.2-34.7 45-32 7.7 1.2 18 8.2 12.2 17.7-30.2-7-45.2 12.6-54.4 33.1-8.1-2-4.9-13.1-2.8-18.8zm184.1 63.1c8.2-3.6 22.4-.7 29.6-5.3-4.2-11.5-10.3-21.4-9.3-37.7 .5 0 1 0 1.4 .1 6.8 14.2 12.7 29.2 21.4 41.7-5.7 13.5-43.6 25.4-43.1 1.2zm-96.8 2.7c-6.8-10.9-19-32.5-14.5-45.3 6.5 11.9 8.6 24.4 17.8 33.3 4.1 4 12.2 9 8.2 20.2-.9 2.7-7.8 8.6-11.7 9.7-14.4 4.3-47.9 .9-36.6-17.1 11.9 .7 27.9 7.8 36.8-.8zm27.3 70c3.8 6.6 1.4 18.7 12.1 20.6 20.2 3.4 43.6-12.3 58.1-17.8 9-15.2-.8-20.7-8.9-30.5-16.6-20-38.8-44.8-38-74.7 6.7-4.9 7.3 7.4 8.2 9.7 8.7 20.3 30.4 46.2 46.3 63.5 3.9 4.3 10.3 8.4 11 11.2 2.1 8.2-5.4 18-4.5 23.5-21.7 13.9-45.8 29.1-81.4 25.6-7.4-6.7-10.3-21.4-2.9-31.1zm-201.3-9.2c-6.8-3.9-8.4-21-16.4-21.4-11.4-.7-9.3 22.2-9.3 35.5-7.8-7.1-9.2-29.1-3.5-40.3-6.6-3.2-9.5 3.6-13.1 5.9 4.7-34.1 49.8-15.8 42.3 20.3zm299.6 28.8c-10.1 19.2-24.4 40.4-54 41-.6-6.2-1.1-15.6 0-19.4 22.7-2.2 36.6-13.7 54-21.6zM261.5 298.3c18.9 9.9 53.6 11 79.3 10.2 1.4 5.6 1.3 12.6 1.4 19.4-33 1.8-72-6.4-80.7-29.6zM353.7 345c-1.7 4.3-5.3 9.3-9.8 11.1-12.1 4.9-45.6 8.7-62.4-.3-10.7-5.7-17.5-18.5-23.4-26-2.8-3.6-16.9-12.9-.2-12.9 13.1 32.7 58 29 95.8 28.1z"],
    "slideshare": [512, 512, [], "f1e7", "M187.9 153.7c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7s61.7-26 61.7-57.7c0-32-27.7-57.7-61.7-57.7zm143.4 0c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7 34.3 0 61.7-26 61.7-57.7 .1-32-27.4-57.7-61.7-57.7zm156.6 90l-6 4.3 0-198.3c0-27.4-20.6-49.7-46-49.7L76.8 0c-25.4 0-46 22.3-46 49.7l0 198.3c-2-1.4-4.3-2.9-6.3-4.3-15.1-10.6-25.1 4-16 17.7 18.3 22.6 53.1 50.3 106.3 72-56.3 191.7 137.4 222.3 134.3 124.1 0-.7 .3-56.6 .3-96.6 5.1 1.1 9.4 2.3 13.7 3.1 0 39.7 .3 92.8 .3 93.5-3.1 98.3 190.6 67.7 134.3-124 53.1-21.7 88-49.4 106.3-72 9.1-13.8-.9-28.3-16.1-17.8zm-30.5 19.2c-68.9 37.4-128.3 31.1-160.6 29.7-23.7-.9-32.6 9.1-33.7 24.9-10.3-7.7-18.6-15.5-20.3-17.1-5.1-5.4-13.7-8-27.1-7.7-31.7 1.1-89.7 7.4-157.4-28l0-192.4c0-34.9 8.9-45.7 40.6-45.7l317.7 0c30.3 0 40.9 12.9 40.9 45.7l0 190.6-.1 0z"],
    "uber": [448, 512, [], "f402", "M414.1 32L33.9 32C15.2 32 0 47.2 0 65.9L0 446c0 18.8 15.2 34 33.9 34L414 480c18.7 0 33.9-15.2 33.9-33.9l0-380.2C448 47.2 432.8 32 414.1 32zM237.6 391.1C163 398.6 96.4 344.2 88.9 269.6l94.4 0 0 20.4c0 3.7 3 6.8 6.8 6.8l67.9 0c3.7 0 6.8-3 6.8-6.8l0-67.9c0-3.7-3-6.8-6.8-6.8l-67.9 0c-3.7 0-6.8 3-6.8 6.8l0 20.4-94.4 0c7-69.4 65.4-122.2 135.1-122.2s128.1 52.8 135.1 122.2c7.5 74.5-46.9 141.1-121.5 148.6z"],
    "digital-ocean": [512, 512, [], "f391", "M87 481.8l73.7 0 0-73.6-73.7 0 0 73.6zM25.4 346.6l0 61.6 61.6 0 0-61.6-61.6 0zM491.6 176.9C468.6 102.7 409.2 43.6 335 20.3 164.9-32.8 8 93.7 8 255.9l95.8 0c0-101.8 101-180.5 208.1-141.7 39.7 14.3 71.5 46.1 85.8 85.7 39.1 107-39.7 207.8-141.4 208l0 .3-.3 0 0 95.8c162.6 0 288.8-156.8 235.6-327.1zm-235.3 231l0-95.3-95.6 0 0 95.6 95.3 0 0-.3 .3 0z"],
    "soundcloud": [640, 512, [], "f1be", "M640.2 298.6c-1.3 23.1-11.5 44.8-28.4 60.5s-39.2 24.4-62.3 24.1l-218 0c-4.8 0-9.4-2-12.8-5.4s-5.3-8-5.3-12.8l0-234.8c-.2-4 .9-8 3.1-11.4s5.3-6.1 9-7.7c0 0 20.1-13.9 62.3-13.9 25.8 0 51.1 6.9 73.3 20.1 17.3 10.2 32.3 23.8 44.1 40.1s20 34.8 24.2 54.4c7.5-2.1 15.3-3.2 23.1-3.2 11.7-.1 23.3 2.2 34.2 6.7s20.5 11.3 28.7 19.7 14.6 18.3 18.9 29.3 6.3 22.6 5.9 34.3zm-354-153.5c.1-1 0-2-.3-2.9s-.8-1.8-1.5-2.6-1.5-1.3-2.4-1.7c-1.8-.8-4-.8-5.8 0-.9 .4-1.7 1-2.4 1.7s-1.2 1.6-1.5 2.6-.4 1.9-.3 2.9c-6 78.9-10.6 152.9 0 231.6 .2 1.7 1 3.3 2.3 4.5 2.6 2.4 6.8 2.4 9.4 0 1.3-1.2 2.1-2.8 2.3-4.5 11.3-79.4 6.6-152 0-231.6l.2 0zm-44 27.3c-.2-1.8-1.1-3.5-2.4-4.7s-3.1-1.9-5-1.9-3.6 .7-5 1.9-2.2 2.9-2.4 4.7c-7.9 67.9-7.9 136.5 0 204.4 .3 1.8 1.2 3.4 2.5 4.5s3.1 1.8 4.8 1.8 3.5-.6 4.8-1.8 2.2-2.8 2.5-4.5c8.8-67.8 8.8-136.5 .1-204.4l.1 0zm-44.3-6.9c-.2-1.8-1-3.4-2.3-4.6s-3-1.8-4.8-1.8-3.5 .7-4.8 1.8-2.1 2.8-2.3 4.6c-6.7 72-10.2 139.3 0 211.1 0 1.9 .7 3.7 2.1 5s3.1 2.1 5 2.1 3.7-.7 5-2.1 2.1-3.1 2.1-5c10.5-72.8 7.3-138.2 .1-211.1l-.1 0zm-44 20.6c0-1.9-.8-3.8-2.1-5.2s-3.2-2.1-5.2-2.1-3.8 .8-5.2 2.1-2.1 3.2-2.1 5.2c-8.1 63.3-8.1 127.5 0 190.8 .2 1.8 1 3.4 2.4 4.6s3.1 1.9 4.8 1.9 3.5-.7 4.8-1.9 2.2-2.8 2.4-4.6c8.8-63.3 8.9-127.5 .3-190.8l-.1 0zm-44.5 47.6c0-1.9-.8-3.8-2.1-5.1s-3.2-2.1-5.1-2.1-3.8 .8-5.1 2.1-2.1 3.2-2.1 5.1c-10.5 49.2-5.5 93.9 .4 143.6 .3 1.6 1.1 3.1 2.3 4.2s2.8 1.7 4.5 1.7 3.2-.6 4.5-1.7 2.1-2.5 2.3-4.2c6.6-50.4 11.6-94.1 .4-143.6zm-44.1-7.5c-.2-1.8-1.1-3.5-2.4-4.8s-3.2-1.9-5-1.9-3.6 .7-5 1.9-2.2 2.9-2.4 4.8c-9.3 50.2-6.2 94.4 .3 144.5 .7 7.6 13.6 7.5 14.4 0 7.2-50.9 10.5-93.8 .3-144.5l-.2 0zM20.7 250.8c-.2-1.8-1.1-3.5-2.4-4.8s-3.2-1.9-5-1.9-3.6 .7-5 1.9-2.3 2.9-2.4 4.8c-8.5 33.7-5.9 61.6 .6 95.4 .2 1.7 1 3.3 2.3 4.4s2.9 1.8 4.7 1.8 3.4-.6 4.7-1.8 2.1-2.7 2.3-4.4c7.5-34.5 11.2-61.8 .4-95.4l-.2 0z"],
    "square-figma": [448, 512, [], "e7e4", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM173.7 96c-33 0-59.8 26.8-59.8 59.8 0 21 10.8 39.4 27.2 50.1-16.4 10.7-27.2 29.1-27.2 50.1s10.8 39.5 27.2 50.1c-16.4 10.7-27.2 29.1-27.2 50.1 0 33.1 27.1 59.8 60.1 59.8 33.2 0 60.6-26.9 60.6-60.3l0-55.7c10.6 9.8 24.8 15.8 40.4 15.8l1.1 0c33 0 59.8-26.8 59.8-59.8 0-21-10.8-39.5-27.2-50.1 16.4-10.7 27.2-29.1 27.2-50.1 0-33-26.8-59.8-59.8-59.8L173.7 96zm41.6 219.8l0 39.9c0 22.6-18.6 41-41.3 41-22.4 0-40.7-18.2-40.7-40.5 0-22.3 18.1-40.4 40.3-40.4l41.7 0zm0-100.3l0 80.9-41.7 0c-22.3-.1-40.3-18.2-40.3-40.5 0-22.3 18.1-40.5 40.5-40.5l41.6 0zm60.8 0c22.3 0 40.5 18.1 40.5 40.5s-18.1 40.5-40.5 40.5l-1.1 0c-22.3 0-40.4-18.1-40.4-40.5s18.1-40.5 40.4-40.5l1.1 0zm-60.8-19.3l-41.6 0c-22.3 0-40.5-18.1-40.5-40.4s18.1-40.5 40.5-40.5l41.6 0 0 80.9zm60.8-80.9c22.3 0 40.5 18.1 40.5 40.5s-18.1 40.4-40.5 40.4l-41.5 0 0-80.9 41.5 0z"],
    "creative-commons-sa": [512, 512, [], "f4ef", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zM145.7 221c13-83.9 80.5-95.7 108.9-95.7 99.8 0 127.5 82.5 127.5 134.2 0 63.6-41 132.9-128.9 132.9-38.9 0-99.1-20-109.4-97l62.5 0c1.5 30.1 19.6 45.2 54.5 45.2 23.3 0 58-18.2 58-82.8 0-82.5-49.1-80.6-56.7-80.6-33.1 0-51.7 14.6-55.8 43.8l18.2 0-49.2 49.2-49-49.2 19.4 0z"],
    "chrome": [512, 512, [], "f268", "M0 256c0-46.6 12.5-90.4 34.3-128.9L144.1 318.3c21.9 39.2 63.8 65.7 111.9 65.7 14.3 0 27.1-2.3 40.8-6.6L220.5 509.6C95.9 492.3 0 385.3 0 256zm365.1 65.6c12.3-19.2 18.9-42.5 18.9-65.6 0-38.2-16.8-72.5-43.3-96l152.7 0c12 29.6 18.6 62.1 18.6 96 0 141.4-114.6 255.1-256 256L365.1 321.6zM477.8 128L256 128c-62.9 0-113.7 44.1-125.5 102.7L54.2 98.5C101 38.5 174 0 256 0 350.8 0 433.5 51.5 477.8 128zM344 256a88 88 0 1 1 -176 0 88 88 0 1 1 176 0z"],
    "trade-federation": [512, 512, [], "f513", "M256 8.8a247.2 247.2 0 1 0 0 494.4 247.2 247.2 0 1 0 0-494.4zm0 11.6a235.6 235.6 0 1 1 0 471.2 235.6 235.6 0 1 1 0-471.2zM411.1 163.1l0-46.8-193.8 0 0 81.7-155.1 0 36.7 46 117.7 0 0 196.8 48.8 0 0-195.8 83.3 0 0-47-83.3 0 0-34.8 145.7 0 0-.1zm-73.3 45.1l0 23.9-82.9 0 0 197.4-26.8 0 0-197.4-123.8 0-20.1-23.9 143.9 0 0-80.6 171.8 0 0 24.4-145 0 0 56.2 82.9 0zm-161.3-69l-12.4-20.7 2.1 23.8-23.5 5.4 23.3 5.4-2.1 24 12.3-20.5 22.2 9.5-15.7-18.1 15.8-18.1-22 9.3zm-29.6-19.7l9.3-11.5-12.7 5.9-8-12.4 1.7 13.9-14.3 3.8 13.7 2.7-.8 14.7 6.8-12.2 13.8 5.3-9.5-10.2zM312.3 264.7l-13.1 5.6-7.3-12.2 1.3 14.2-13.9 3.2 13.9 3.2-1.2 14.2 7.3-12.2 13.1 5.5-9.4-10.7 9.3-10.8zm106.9-77.2l-20.9 9.1-12-19.6 2.2 22.7-22.3 5.4 22.2 4.9-1.8 22.9 11.5-19.6 21.2 8.8-15.1-17 15-17.6zM256 29.9a226.1 226.1 0 1 0 0 452.2 226.1 226.1 0 1 0 0-452.2zM350.6 196l0 51-83.3 0 0 195.7-52.7 0 0-196.8-116.7 0-40-49.9 157.4 0 0-81.6 197.8 0 0 50.7-145.7 0 0 30.9 83.2 0zM256 43.2c60.3 0 114.8 25 153.6 65.2l-199.1 0 0 81.6-157.4 0C81.1 104.8 161.4 43.2 256 43.2zm0 427.1c-117.9 0-213.6-95.6-213.6-213.5 0-21.2 3.1-41.8 8.9-61.1l43.8 56.3 114.7 0 0 196.8 64.6 0 0-195.8 83.3 0 0-62.7-83.2 0 0-19.2 145.6 0 0-50.8c30.8 37 49.3 84.6 49.3 136.5 .1 117.9-95.5 213.5-213.4 213.5zM186.8 275l-11-21.4 1.7 24.5-23.7 3.9 23.8 5.9-3.7 23.8 13-20.9 21.5 10.8-15.8-18.8 16.9-17.1-22.7 9.3z"],
    "vaadin": [448, 512, [], "f408", "M224.5 140.7C226 123.1 229.4 88 274.3 88l98.6 0c20.7 0 32.1-7.8 32.1-21.6l0-12.3c0-12.2 9.3-22.1 21.5-22.1S448 41.9 448 54.1l0 36.5c0 42.9-21.5 62-66.8 62l-100.5 0c-30.1 0-33 14.7-33 27.1 0 1.3-.1 2.5-.2 3.7-.7 12.3-10.9 22.2-23.4 22.2s-22.7-9.8-23.4-22.2c-.1-1.2-.2-2.4-.2-3.7 0-12.3-3-27.1-33-27.1l-100.7 0C21.5 152.6 0 133.5 0 90.6L0 54.1C0 41.9 9.4 32 21.6 32s21.5 9.9 21.5 22.1l0 12.3C43.1 80.2 54.5 88 75.2 88l98.6 0c44.8 0 48.3 35.1 49.8 52.7l.9 0zM224 456c11.5 0 21.4-7 25.7-16.3 1.1-1.8 97.1-169.6 98.2-171.4 11.9-19.6-3.2-44.3-27.2-44.3-13.9 0-23.3 6.4-29.8 20.3L224 362 157.1 244.3c-6.4-13.9-15.9-20.3-29.8-20.3-24 0-39.1 24.6-27.2 44.3 1.1 1.9 97.1 169.6 98.2 171.4 4.3 9.3 14.2 16.3 25.7 16.3z"],
    "deviantart": [320, 512, [], "f1bd", "M320 93.2l-98.2 179.1 7.4 9.5 90.8 0 0 127.7-160.9 0-13.5 9.2-43.7 84c-.3 0-8.6 8.6-9.2 9.2l-92.7 0 0-93.2 93.2-179.4-7.4-9.2-85.8 0 0-127.6 156 0 13.5-9.2 43.7-84c.3 0 8.6-8.6 9.2-9.2l97.6 0 0 93.1z"],
    "medium": [448, 512, [62407, "medium-m"], "f23a", "M369.4 32c43.4 0 78.6 35.2 78.6 78.6l0 83.8c-1.9-.1-3.8-.2-5.7-.2l-.4 0c-10 0-22.3 2.4-31.1 6.8-10 4.6-18.7 11.5-26 20.6-11.8 14.6-18.9 34.3-20.6 56.4-.1 .7-.1 1.3-.2 2s-.1 1.2-.1 1.9c-.1 1.2-.1 2.4-.1 3.6 0 1.9-.1 3.8 0 5.8 1.2 50.1 28.2 90.2 76.3 90.2 2.7 0 5.3-.1 7.9-.4l0 20.4c0 43.4-35.2 78.6-78.6 78.6L78.6 480C35.2 480 0 444.8 0 401.4L0 110.6C0 67.2 35.2 32 78.6 32l290.8 0zM82.3 138.9l.3 .1c13.2 3 19.8 7.4 19.8 23.4l0 187.2c0 16-6.7 20.4-19.9 23.4l-.3 .1 0 2.8 52.8 0 0-2.8-.3-.1c-13.2-3-19.9-7.4-19.9-23.4l0-176.3 86.1 202.5 4.9 0 88.6-208.2 0 186.6c-1.1 12.6-7.8 16.5-19.7 19.2l-.3 .1 0 2.7 91.9 0 0-2.7-.3-.1c-11.9-2.7-18.7-6.6-19.9-19.2l-.1-191.8 .1 0c0-16 6.7-20.4 19.9-23.4l.3-.1 0-2.7-72.2 0-67 157.4-67-157.4-77.8 0 0 2.7zM448 340.3c-25.1-7.4-43-35.1-41.2-67.8l0 0 41.1 0 0 67.8zm-6.4-135.6c2.3 0 4.4 .3 6.4 .9l0 57.4-40.2 0c1.5-33.6 13.6-57.9 33.8-58.3z"],
    "opencart": [640, 512, [], "f23d", "M331.8 440.4a45.8 45.8 0 1 1 91.5 .3 45.8 45.8 0 1 1 -91.5-.3zM169.4 394.9a45.7 45.7 0 1 0 .3 91.3 45.7 45.7 0 1 0 -.3-91.3zm291.7-270c-302.2 0-379.2-12.8-461.1-99.2 34.4 51.7 53.3 148.9 373.1 144.2 333.3-5 130 86.1 70.8 188.9 186.7-166.7 319.4-233.9 17.2-233.9z"],
    "y-combinator": [448, 512, [], "f23b", "M448 32l0 448-448 0 0-448 448 0zM236 287.5l77.5-145.5-32.7 0-45.8 91c-4.7 9.3-9 18.3-12.8 26.8l-12.2-26.8-45.2-91-35 0 76.7 143.8 0 94.5 29.5 0 0-92.8z"],
    "line": [512, 512, [], "f3c0", "M311 196.8l0 81.3c0 2.1-1.6 3.7-3.7 3.7l-13 0c-1.3 0-2.4-.7-3-1.5L254 230 254 278.2c0 2.1-1.6 3.7-3.7 3.7l-13 0c-2.1 0-3.7-1.6-3.7-3.7l0-81.3c0-2.1 1.6-3.7 3.7-3.7l12.9 0c1.1 0 2.4 .6 3 1.6l37.3 50.3 0-48.2c0-2.1 1.6-3.7 3.7-3.7l13 0c2.1-.1 3.8 1.6 3.8 3.5l0 .1zm-93.7-3.7l-13 0c-2.1 0-3.7 1.6-3.7 3.7l0 81.3c0 2.1 1.6 3.7 3.7 3.7l13 0c2.1 0 3.7-1.6 3.7-3.7l0-81.3c0-1.9-1.6-3.7-3.7-3.7zm-31.4 68.1l-35.6 0 0-64.4c0-2.1-1.6-3.7-3.7-3.7l-13 0c-2.1 0-3.7 1.6-3.7 3.7l0 81.3c0 1 .3 1.8 1 2.5 .7 .6 1.5 1 2.5 1l52.2 0c2.1 0 3.7-1.6 3.7-3.7l0-13c0-1.9-1.6-3.7-3.5-3.7l.1 0zm193.7-68.1l-52.3 0c-1.9 0-3.7 1.6-3.7 3.7l0 81.3c0 1.9 1.6 3.7 3.7 3.7l52.2 0c2.1 0 3.7-1.6 3.7-3.7l0-13.1c0-2.1-1.6-3.7-3.7-3.7l-35.5 0 0-13.6 35.5 0c2.1 0 3.7-1.6 3.7-3.7l0-13.1c0-2.1-1.6-3.7-3.7-3.7l-35.5 0 0-13.7 35.5 0c2.1 0 3.7-1.6 3.7-3.7l0-13c-.1-1.9-1.7-3.7-3.7-3.7l.1 0zM512 93.4l0 326c-.1 51.2-42.1 92.7-93.4 92.6l-326 0C41.4 511.9-.1 469.8 0 418.6l0-326C.1 41.4 42.2-.1 93.4 0l326 0c51.2 .1 92.7 42.1 92.6 93.4zM441.6 233.5c0-83.4-83.7-151.3-186.4-151.3S68.8 150.1 68.8 233.5c0 74.7 66.3 137.4 155.9 149.3 21.8 4.7 19.3 12.7 14.4 42.1-.8 4.7-3.8 18.4 16.1 10.1s107.3-63.2 146.5-108.2c27-29.7 39.9-59.8 39.9-93.1l0-.2z"],
    "amilia": [448, 512, [], "f36d", "M240.2 32c-61.9 0-131.5 16.9-184.2 55.4-5.1 3.1-9.1 9.2-7.2 19.4 1.1 5.1 5.1 27.4 10.2 39.6 4.1 10.2 14.2 10.2 20.3 6.1 32.5-22.3 96.5-47.7 152.3-47.7 57.9 0 58.9 28.4 58.9 73.1l0 38.5C203.1 227.7 78.3 251 46.8 264.2 11.3 280.5 16.4 357.7 16.4 376S31.6 480 141.3 480c47.8 0 113.7-20.7 153.3-42.1l0 25.4c0 3 2.1 8.2 6.1 9.1 3.1 1 50.7 2 59.9 2s62.5 .3 66.5-.7c4.1-1 5.1-6.1 5.1-9.1l0-296.6c-.1-80.3-57.9-136-192-136zm50.2 348c-21.4 13.2-48.7 24.4-79.1 24.4-52.8 0-58.9-33.5-59-44.7 0-12.2-3-42.7 18.3-52.9 24.3-13.2 75.1-29.4 119.8-33.5l0 106.7z"],
    "asymmetrik": [576, 512, [], "f372", "M517.5 309.2c38.8-40 58.1-80 58.5-116.1 .8-65.5-59.4-118.2-169.4-135-128.7-19.7-288.5 15.5-406.6 82.4 52-26.5 110.6-48.2 170.7-58.2 74.5-20.5 153-25.4 221.3-14.8 152.5 23.8 196.8 127.5 98.8 231.7-10.2 10.8-22 21.1-35 30.6L304.9 103.4 114.7 388.9c-65.6-29.4-76.5-90.2-19.1-151.2 20.8-22.2 48.3-41.9 79.5-58.1 20-12.2 39.7-22.6 62-30.7-65.1 20.3-122.7 52.9-161.6 92.9-27.7 28.6-41.4 57.1-41.7 82.9-.5 35.1 23.4 65.1 68.4 83l-34.5 51.7 101.6 0 22-34.4c22.2 1 45.3 0 68.6-2.7l-22.8 37.1 135.5 0-32.6-53.1c18.6-5.3 36.9-11.5 54.5-18.7l45.9 71.8 101.6 0-73.4-110.4c18.5-12.1 35-25.5 48.9-39.8zM329.9 389.7l-25-40.6-32.7 53.3c-23.4 3.5-46.7 5.1-69.2 4.4l101.9-159.3 78.7 123c-17.2 7.4-35.3 13.9-53.7 19.2z"],
    "phabricator": [512, 512, [], "f3db", "M331.1 262.1l-.1-13s21.7-19.8 21.1-21.2l-9.5-20c-.6-1.4-29.5-.5-29.5-.5l-9.4-9.3s.2-28.5-1.2-29.1l-20.1-9.2c-1.4-.6-20.7 21-20.7 21l-13.1-.2s-20.5-21.4-21.9-20.8l-20 8.3c-1.4 .5 .2 28.9 .2 28.9l-9.1 9.1s-29.2-.9-29.7 .4L160 226.3c-.6 1.4 21 21 21 21l.1 12.9S159.4 280 160 281.4l9.5 20c.6 1.4 29.5 .5 29.5 .5l9.4 9.3s-.2 31.8 1.2 32.3l20.1 8.3c1.4 .6 20.7-23.5 20.7-23.5l13.1 .2s20.5 23.8 21.8 23.3l20-7.5c1.4-.6-.2-32.1-.2-32.1l9.1-9.1s29.2 .9 29.7-.5l8.1-19.8c.7-1.1-20.9-20.7-20.9-20.7zm-44.9-8.7c.7 17.1-12.8 31.6-30.1 32.4s-32.1-12.5-32.8-29.6 12.8-31.6 30.1-32.3c17.3-.8 32.1 12.5 32.8 29.5zm201.2-37.9l-97-97-.1 .1c-75.1-73.3-195.4-72.8-269.8 1.6-50.9 51-27.8 27.9-95.7 95.3-22.3 22.3-22.3 58.7 0 81 69.9 69.4 46.4 46 97.4 97l.1-.1c75.1 73.3 195.4 72.9 269.8-1.6 51-50.9 27.9-27.9 95.3-95.3 22.3-22.3 22.3-58.7 0-81zM363.5 148.2a152.3 152.3 0 1 1 -215 215.6 152.3 152.3 0 1 1 215-215.6z"],
    "bots": [640, 512, [], "e340", "M86.3 197.8c-8-.1-15.9 1.7-23.1 5.1s-13.5 8.6-18.4 14.9l0-61.9c0-2.2-.9-4.3-2.4-5.8s-3.6-2.4-5.8-2.4l-28.4 0c-2.2 0-4.3 .9-5.8 2.4S0 153.8 0 156L0 333.6c0 1.1 .2 2.1 .6 3.1s1 1.9 1.8 2.7 1.7 1.4 2.7 1.8 2.1 .6 3.1 .6l28.4 0c1.1 0 2.1-.2 3.1-.6s1.9-1 2.7-1.8 1.4-1.7 1.8-2.7 .6-2.1 .6-3.1l0-8.1c11.6 13.4 25.9 19.8 41.6 19.8 34.6 0 61.9-26.2 61.9-73.8 0-45.9-27-73.6-61.9-73.6zM71.5 305.7c-9.6 0-21.2-4.9-26.7-12.5l0-43c5.5-7.6 17.2-12.8 26.7-12.8 17.7 0 31.1 13.1 31.1 34 0 21.2-13.4 34.3-31.1 34.3zm156.4-59a17.4 17.4 0 1 0 0 34.8 17.4 17.4 0 1 0 0-34.8zm46.1-90l0-44.7c2.8-1.2 5.2-3.3 6.6-6s1.9-5.8 1.3-8.9-2.2-5.7-4.6-7.7-5.4-3-8.4-3-6.1 1.1-8.4 3-4 4.7-4.6 7.7-.1 6.1 1.3 8.9 3.8 4.8 6.6 6l0 44.7c-28 1.3-54.4 13.6-73.6 34.1s-29.5 47.7-28.8 75.8 12.3 54.7 32.4 74.3 47 30.6 75.1 30.6 55-11 75.1-30.6 31.7-46.3 32.4-74.3-9.7-55.3-28.8-75.8-45.5-32.8-73.6-34.1zm86 107.4c0 30.5-40.8 55.3-91.1 55.3s-91.1-24.7-91.1-55.3 40.8-55.3 91.1-55.3 91.1 24.7 91.1 55.3l0 0zm-50.2 17.4c3.4 0 6.8-1 9.7-2.9s5.1-4.6 6.4-7.8 1.7-6.7 1-10.1-2.3-6.5-4.8-8.9-5.5-4.1-8.9-4.8-6.9-.3-10.1 1-5.9 3.5-7.8 6.4-2.9 6.2-2.9 9.7c0 4.6 1.8 9 5.1 12.3s7.7 5.1 12.3 5.1l0 0zm270.9-31c-14.8-2.6-22.4-3.8-22.4-9.9 0-5.5 7.3-9.9 17.7-9.9 12.2 .1 24.2 3.6 34.5 10.1 1.8 1.2 4 1.6 6.2 1.1s4-1.7 5.1-3.6c.1-.1 .1-.2 .2-.3l8.6-14.9c1.1-1.9 1.4-4.1 .8-6.1s-1.9-3.9-3.7-5c-15.7-9.4-33.7-14.3-52-14.1-39 0-60.2 21.5-60.2 46.2 0 36.3 33.7 41.9 57.6 45.6 13.4 2.3 24.1 4.4 24.1 11 0 6.4-5.5 10.8-18.9 10.8-13.6 0-31-6.2-42.6-13.6-.9-.6-1.9-1-3-1.2s-2.1-.2-3.2 .1-2.1 .7-2.9 1.3-1.6 1.4-2.2 2.3c0 .1-.1 .1-.1 .2l-10.2 16.9c-1.1 1.8-1.4 4-1 6s1.7 3.9 3.5 5c15.2 10.3 37.7 16.7 59.4 16.7 40.4 0 64-19.8 64-46.5 0-38.1-35.5-43.9-59.3-48.3zm-95.9 60.8c-.5-2-1.8-3.7-3.6-4.8s-3.9-1.5-5.9-1.1c-1.4 .3-2.8 .4-4.2 .4-7.8 0-12.5-6.1-12.5-14.2l0-51.2 20.3 0c2.2 0 4.2-.9 5.8-2.4s2.4-3.6 2.4-5.8l0-22.7c0-2.2-.9-4.2-2.4-5.8s-3.6-2.4-5.8-2.4l-20.3 0 0-30.2c0-2.2-.9-4.2-2.4-5.8s-3.6-2.4-5.8-2.4l-28.2 0c-2.2 0-4.2 .9-5.8 2.4s-2.4 3.6-2.4 5.8l0 30.2-15.1 0c-1.1 0-2.1 .2-3.1 .6s-1.9 1-2.6 1.8-1.4 1.7-1.8 2.6-.6 2-.6 3.1l0 22.7c0 1.1 .2 2.1 .6 3.1s1 1.9 1.8 2.6 1.7 1.4 2.6 1.8 2 .6 3.1 .6l15.1 0 0 63.7c0 27 15.4 41.3 43.9 41.3 12.2 0 21.4-2.2 27.6-5.4 1.6-.8 2.9-2.2 3.7-3.9s.9-3.6 .5-5.4l-5-19.3z"],
    "vine": [384, 512, [], "f1ca", "M384 254.7l0 52.1c-18.4 4.2-36.9 6.1-52.1 6.1-36.9 77.4-103 143.8-125.1 156.2-14 7.9-27.1 8.4-42.7-.8-27.1-16.3-129.9-100.6-164.1-365.6l74.5 0c18.7 159.1 64.5 240.7 114.8 301.8 27.9-27.9 54.8-65.1 75.6-106.9-49.8-25.3-80.1-80.9-80.1-145.6 0-65.6 37.7-115.1 102.2-115.1 114.9 0 106.2 127.9 81.6 181.5 0 0-46.4 9.2-63.5-20.5 3.4-11.3 8.2-30.8 8.2-48.5 0-31.3-11.3-46.6-28.4-46.6-18.2 0-30.8 17.1-30.8 50 .1 79.2 59.4 118.7 129.9 101.9z"],
    "medrt": [576, 512, [], "f3c8", "M129.7 256c0 121.8 83.9 222.8 193.5 241.1-18.7 4.5-38.2 6.9-58.2 6.9-137.6 0-249-111-249-248S127.4 8 264.9 8c20.1 0 39.6 2.4 58.2 6.9-109.6 18.3-193.4 119.3-193.4 241.1zM427.1 356.3c-77.7 55.4-179.6 47.5-240.4-14.6 5.5 14.1 12.7 27.7 21.7 40.5 61.6 88.2 182.4 109.3 269.7 47s108.1-184.3 46.5-272.6c-9-12.9-19.3-24.3-30.5-34.2 37.4 78.8 10.7 178.5-67 233.9zm-218.8-244c-1.4 1-2.7 2.1-4 3.1 64.3-17.8 135.9 4 178.9 60.5 35.7 47 42.9 106.6 24.4 158 56.7-56.2 67.6-142.1 22.3-201.8-50-65.5-149.1-74.4-221.6-19.8zM312 224c-4.4 0-8-3.6-8-8l0-40c0-4.4-3.6-8-8-8l-48 0c-4.4 0-8 3.6-8 8l0 40c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8l40 0c4.4 0 8 3.6 8 8l0 40c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-40c0-4.4 3.6-8 8-8l40 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-40 0z"],
    "osi": [512, 512, [], "f41a", "M8 266.4c2.3-135.8 97.4-232.4 213.8-248.1 138.8-18.6 255.6 75.8 278 201.1 21.3 118.8-44 230-151.6 274-9.3 3.8-14.4 1.7-18-7.7-17.8-46.3-35.6-92.6-53.4-139-3.1-8.1-1-13.2 7-16.8 24.2-11 39.3-29.4 43.3-55.8 1.5-9.7 1-19.6-1.5-29.1s-6.9-18.4-12.9-26.1-13.6-14.1-22.2-18.8-18.1-7.5-27.9-8.3c-39-3.4-71.8 23.7-77.5 59.7-5.2 33 11.1 63.7 41.9 77.7 9.6 4.4 11.5 8.6 7.8 18.4-17.9 46.6-35.8 93.2-53.7 139.9-2.6 6.9-8.3 9.3-15.5 6.5-52.6-20.3-101.4-61-130.8-119-24.9-49.2-25.2-87.7-26.8-108.7zm20.9-1.9c.4 6.6 .6 14.3 1.3 22.1 6.3 71.9 49.6 143.5 131 183.1 3.2 1.5 4.4 .8 5.6-2.3 14.9-39.1 29.9-78.2 45-117.3 1.3-3.3 .6-4.8-2.4-6.7-31.6-19.9-47.3-48.5-45.6-86 1-21.6 9.3-40.5 23.8-56.3 30-32.7 77-39.8 115.5-17.6 15.6 9 28.2 22.3 36.2 38.4s11.2 34.2 9 52c-3.6 30.6-19.3 53.9-45.7 69.8-2.7 1.6-3.5 2.9-2.3 6 15.2 39.2 30.3 78.4 45.2 117.7 1.2 3.1 2.4 3.8 5.6 2.3 35.5-16.6 65.2-40.3 88.1-72 34.8-48.2 49.1-101.9 42.3-161-13.7-117.5-119.4-214.8-255.5-198-106.1 13-195.3 102.5-197.1 225.8z"],
    "gg": [512, 512, [], "f260", "M179.2 230.4l102.4 102.4-102.4 102.4-179.2-179.2 179.2-179.2 44.8 44.8-25.6 25.6-19.2-19.2-128 128 128 128 51.5-51.5-77.1-76.5 25.6-25.6zM332.8 76.8l-102.4 102.4 102.4 102.4 25.6-25.6-77.1-76.5 51.5-51.5 128 128-128 128-19.2-19.2-25.6 25.6 44.8 44.8 179.2-179.2-179.2-179.2z"],
    "buysellads": [448, 512, [], "f20d", "M224 150.7l42.9 160.7-85.8 0 42.9-160.7zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM382.7 405.3l-94.5-298.7-128.4 0-94.5 298.7 90.7 0 111.7-91.6 24.2 91.6 90.8 0z"],
    "google-plus": [512, 512, [], "f2b3", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM185.3 380c-32.9 0-64.4-13.1-87.7-36.3s-36.3-54.8-36.3-87.7 13.1-64.4 36.3-87.7 54.8-36.3 87.7-36.3c31.3 0 60.1 11 83 32.3l-33.6 32.6c-13.2-12.9-31.3-19.1-49.4-19.1-42.9 0-77.2 35.5-77.2 78.1S142.3 334 185.3 334c32.6 0 64.9-19.1 70.1-53.3l-70.1 0 0-42.6 116.9 0c1.3 6.8 1.9 13.8 1.9 20.7 0 70.8-47.5 121.2-118.8 121.2zM415.5 273.8l0 35.5-35.5 0 0-35.5-35.5 0 0-35.5 35.5 0 0-35.5 35.5 0 0 35.5 35.2 0 0 35.5-35.2 0z"],
    "screenpal": [512, 512, [], "e570", "M278.6 22.5a22.5 22.5 0 1 1 -45 0 22.5 22.5 0 1 1 45 0zM198.7 259a57.4 57.4 0 1 1 114.8 0 57.4 57.4 0 1 1 -114.8 0zm138.6 91c22.3-19.9 36.5-47.3 39.9-77l119.5 0c-3.5 61.4-30.4 119.2-75.2 161.4-44.7 42.2-103.9 65.8-165.4 65.8S135.4 476.6 90.7 434.4C45.9 392.2 19.1 334.4 15.5 273l119.7 0c3.4 29.7 17.6 57.1 39.9 77s51.2 30.9 81.1 30.9c29 0 58.7-11 81.1-30.9zM28.3 141.7a22.5 22.5 0 1 1 45-1.4 22.5 22.5 0 1 1 -45 1.4zm455.6-.7a22.4 22.4 0 1 1 -44.9 0 22.4 22.4 0 1 1 44.9 0zM318 95.3c-17.3 13.8-39.2 22.8-61.9 22.8s-44.6-9-61.9-22.8c-17.3-14.7-28.8-35.1-32.4-57.5 15.1-6.4 30.8-11.3 46.9-14.5 0 12.6 5 24.6 13.9 33.5s20.9 13.9 33.5 13.9 24.6-5 33.5-13.9 13.9-20.9 13.9-33.5c16.1 3.2 31.8 8.1 46.9 14.5-3.6 22.4-15.1 42.8-32.4 57.5zM82.9 231c-21.4 7.6-44.7 7.4-65.9-.6 2-16.3 5.6-32.3 10.8-47.9 5.4 3.1 11.3 5.1 17.5 6 6.2 .8 12.4 .4 18.5-1.2 6-1.7 11.6-4.4 16.6-8.2s9.1-8.5 12.2-13.9 5.1-11.4 6-17.5c.8-6.2 .4-12.5-1.2-18.5s-4.4-11.6-8.2-16.6c-3.8-4.9-8.5-9.1-13.9-12.2 10.8-12.3 22.9-23.5 36-33.3 17.6 14.3 29.5 34.5 33.6 56.8s.1 45.4-11.2 65c-11.4 19.6-29.4 34.5-50.7 42.1zm346.4 .1c-21.3-7.6-39.3-22.6-50.7-42.2-11.3-19.6-15.2-42.7-11.1-65 4.1-22.2 16-42.4 33.5-56.7 13.1 9.8 25.2 21 36 33.3-10.7 6.4-18.4 16.7-21.5 28.8-3.2 12-2.3 24.8 4.8 35.6 6.2 10.8 16.4 18.7 28.4 22s24.9 1.7 35.7-4.3c5.3 15.5 8.9 31.6 10.9 47.8-22.1 8.1-44.6 8.3-66 .7z"],
    "bitcoin": [512, 512, [], "f379", "M8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm354.3-35.3c4.9-33-20.2-50.7-54.6-62.6l11.1-44.7-27.2-6.8-10.9 43.5c-7.2-1.8-14.5-3.5-21.8-5.1l10.9-43.8-27.2-6.8-11.2 44.7c-5.9-1.3-11.7-2.7-17.4-4.1l0-.1-37.5-9.4-7.2 29.1s20.2 4.6 19.8 4.9c11 2.8 13 10 12.7 15.8l-12.7 50.9c.8 .2 1.7 .5 2.8 .9-.9-.2-1.9-.5-2.9-.7l-17.8 71.3c-1.3 3.3-4.8 8.4-12.5 6.5 .3 .4-19.8-4.9-19.8-4.9l-13.5 31.1 35.4 8.8c6.6 1.7 13 3.4 19.4 5l-11.3 45.2 27.2 6.8 11.2-44.7c7.2 2 14.4 3.8 21.7 5.6l-11.1 44.5 27.2 6.8 11.3-45.1c46.4 8.8 81.3 5.2 96-36.7 11.8-33.8-.6-53.3-25-66 17.8-4.1 31.2-15.8 34.7-39.9zm-62.2 87.2c-8.4 33.8-65.3 15.5-83.8 10.9l14.9-59.9c18.4 4.6 77.6 13.7 68.8 49zm8.4-87.7c-7.7 30.7-55 15.1-70.4 11.3l13.5-54.3c15.4 3.8 64.8 11 56.8 43z"],
    "swift": [448, 512, [], "f8e1", "M448 156.1c0-4.5-.1-9-.2-13.5-.1-9.9-1-19.7-2.6-29.4-1.7-9.7-4.8-19.2-9.2-28-9-17.7-23.4-32.1-41.2-41.1-8.8-4.5-18.3-7.6-28-9.2-9.7-1.6-19.6-2.5-29.4-2.6-4.5-.1-9-.2-13.5-.2L124.1 32c-4.5 0-9 .1-13.5 .2-2.4 .1-4.9 .2-7.4 .3-7.4 .3-14.8 1.1-22.1 2.3-7.3 1.3-14.4 3.3-21.2 6.1-2.3 1-4.6 2-6.8 3.1-6.6 3.4-12.8 7.5-18.4 12.3-1.9 1.6-3.7 3.3-5.4 5-7 7-12.9 15-17.4 23.8-4.4 8.8-7.6 18.3-9.2 28-1.6 9.7-2.4 19.6-2.5 29.4-.1 4.5-.2 9-.2 13.5L0 355.9c0 4.5 .1 9 .2 13.5 .1 9.9 1 19.7 2.6 29.4 1.7 9.7 4.8 19.2 9.2 28 9 17.7 23.4 32.1 41.1 41.1 8.8 4.4 18.3 7.5 28 9.2 9.7 1.6 19.6 2.5 29.4 2.6 4.5 .1 9 .2 13.5 .2l199.8 0c4.5 0 9-.1 13.5-.2 9.9-.1 19.7-1 29.4-2.6 9.7-1.7 19.2-4.8 28-9.2 17.7-9 32.1-23.4 41.1-41.2 4.4-8.8 7.6-18.3 9.2-28 1.6-9.7 2.5-19.6 2.6-29.4 .1-4.5 .2-9 .2-13.5l0-183.8c0-5.4 0-10.7 0-16zm-69.9 241c-20-38.9-57.2-29.3-76.3-19.5-1.7 1-3.5 2-5.2 3l-.4 .2c-39.5 21-92.5 22.5-145.8-.4-43.4-18.8-80.1-50.3-105.3-90.4 12.3 9.1 25.4 16.9 39.2 23.4 56.4 26.4 113 24.5 153 0-57-43.8-104.6-101-141.1-147.2-7-8.1-13.2-16.8-18.8-25.9 43.7 40 112.7 90.2 137.5 104.1-52.6-55.5-98.9-123.9-96.7-121.7 82.8 83.4 159.2 130.6 159.2 130.6 2.9 1.6 5 2.8 6.7 4 1.6-4.1 3-8.2 4.2-12.5 13.2-48.3-1.7-103.6-35.3-149.2 76.8 46.1 122.2 133.7 103.6 207.8-.4 1.7-1 3.4-1.4 5.1 38.5 47.4 28 98.2 23.1 88.6l0 0z"],
    "files-pinwheel": [512, 512, [], "e69f", "M253.5 246.4L137.2 130.2c-.6-.6-1-1.3-1.4-2s-.5-1.6-.5-2.4 .2-1.6 .5-2.4 .8-1.4 1.4-2L253.6 5.1c.9-.9 2-1.5 3.2-1.7s2.5-.1 3.6 .3 2.1 1.3 2.8 2.3 1.1 2.2 1.1 3.5l0 232.5c0 1.3-.3 2.5-1 3.6s-1.7 1.9-2.9 2.4-2.5 .6-3.7 .3-2.4-.9-3.2-1.9zm40.3-4.4l0-134.4c0-.8 .1-1.6 .5-2.4s.8-1.5 1.3-2.1 1.3-1.1 2-1.4 1.6-.5 2.4-.5l134.4 0c1.2 0 2.5 .4 3.5 1.1s1.8 1.7 2.3 2.8 .6 2.4 .3 3.6-.9 2.3-1.7 3.2L304.3 246.4c-.9 .8-2 1.4-3.2 1.6s-2.4 .1-3.5-.4-2.1-1.3-2.8-2.3-1.1-2.2-1.1-3.4l.1 .1zm30.6 35c-1.2 0-2.5-.3-3.5-1s-1.9-1.6-2.4-2.8-.6-2.4-.4-3.6 .8-2.3 1.7-3.2L404 182.2c.6-.6 1.3-1 2-1.4s1.6-.5 2.4-.5 1.6 .2 2.4 .5 1.4 .8 2 1.4l84.4 84.2c.9 .9 1.5 2 1.7 3.2s.1 2.5-.3 3.6-1.3 2.1-2.3 2.8-2.2 1.1-3.5 1.1l-168.5 0 .1-.1zm90.7 131l-95.3-95.2c-.9-.9-1.5-2-1.7-3.2s-.1-2.5 .4-3.7 1.3-2.1 2.4-2.8 2.3-1 3.5-1l95.2 0c1.7 0 3.2 .7 4.4 1.8s1.8 2.8 1.8 4.4l0 95.3c0 1.2-.4 2.5-1.1 3.5s-1.7 1.8-2.8 2.3-2.4 .6-3.6 .3-2.3-.9-3.2-1.7zM16.8 302.1l216.9 0c1.2 0 2.5 .4 3.5 1.1s1.8 1.7 2.3 2.8 .6 2.4 .3 3.6-.8 2.3-1.7 3.2L129.7 421.2c-.6 .6-1.3 1-2 1.4s-1.6 .5-2.4 .5-1.6-.2-2.4-.5-1.4-.8-2-1.4L12.3 312.8c-.9-.9-1.5-2-1.7-3.2s-.1-2.5 .4-3.6 1.3-2.1 2.3-2.8 2.3-1 3.5-1l0-.1zM264.3 465.3c0 .8-.2 1.6-.5 2.4s-.8 1.5-1.4 2-1.3 1-2 1.4-1.6 .5-2.4 .5l-128 0c-1.2 0-2.5-.4-3.5-1.1s-1.8-1.7-2.3-2.8-.6-2.4-.3-3.6 .8-2.3 1.7-3.2l128-128c.9-.9 2-1.5 3.2-1.7s2.5-.1 3.6 .3 2.1 1.3 2.8 2.3 1.1 2.2 1.1 3.5l0 128zm40-132.5l82.8 82.7c.6 .6 1 1.3 1.4 2s.5 1.6 .5 2.4-.2 1.6-.5 2.4-.8 1.4-1.4 2L304.3 507c-.9 .9-2 1.5-3.2 1.7s-2.5 .1-3.6-.3-2.1-1.3-2.8-2.3-1.1-2.2-1.1-3.5l0-165.4c0-1.2 .4-2.5 1.1-3.5s1.7-1.8 2.8-2.3 2.4-.6 3.6-.3 2.3 .8 3.2 1.7zM79 122.4c0-1.2 .3-2.5 1-3.5s1.7-1.8 2.8-2.3 2.4-.6 3.6-.4 2.3 .8 3.2 1.7L238.1 266.4c.9 .9 1.5 2 1.7 3.2s.1 2.5-.3 3.6-1.3 2.1-2.3 2.8-2.2 1.1-3.5 1.1l-148.4 0c-1.7 0-3.2-.7-4.4-1.8s-1.8-2.8-1.8-4.4l0-148.4-.1-.1z"],
    "laravel": [512, 512, [], "f3bd", "M504.6 115.8c-.1-.2-.2-.5-.3-.7-.1-.4-.3-.8-.5-1.2-.2-.2-.3-.5-.5-.7-.2-.3-.5-.6-.7-.9-.2-.2-.5-.4-.8-.6-.3-.2-.6-.5-.9-.7L404.6 55.5c-1.2-.7-2.6-1.1-4-1.1s-2.8 .4-4 1.1L300.3 111c-.3 .2-.6 .4-.9 .7-.3 .2-.5 .4-.8 .6-.3 .3-.5 .6-.7 .9-.2 .2-.4 .4-.5 .7-.2 .4-.4 .8-.5 1.2-.1 .2-.2 .4-.3 .7-.2 .7-.3 1.4-.3 2.1l0 105.2-80.2 46.2 0-205.9c0-.7-.1-1.4-.3-2.1-.1-.2-.2-.4-.3-.7-.1-.4-.3-.8-.5-1.2-.1-.3-.4-.5-.5-.7-.2-.3-.5-.6-.7-.9-.2-.2-.5-.4-.8-.6-.3-.2-.6-.5-.9-.7L115.8 1.1c-1.2-.7-2.6-1.1-4-1.1s-2.8 .4-4 1.1L11.5 56.5c-.3 .2-.6 .4-.9 .7-.3 .2-.5 .4-.8 .6-.3 .3-.5 .6-.7 .9-.2 .3-.4 .5-.6 .7-.2 .4-.4 .8-.5 1.2-.1 .2-.2 .4-.3 .7-.2 .7-.3 1.4-.3 2.1l0 329.7c0 1.4 .4 2.8 1.1 4s1.7 2.2 2.9 2.9L204 510.9c.4 .2 .9 .4 1.3 .5 .2 .1 .4 .2 .6 .3 1.3 .4 2.8 .4 4.1 0 .2-.1 .4-.2 .6-.2 .5-.2 1-.3 1.4-.6L404.6 400.1c1.2-.7 2.2-1.7 2.9-2.9s1.1-2.6 1.1-4l0-105.3 92.2-53.1c1.2-.7 2.2-1.7 2.9-3s1.1-2.6 1.1-4l0-109.8c0-.7-.1-1.4-.2-2.1zM111.8 17.3l80.2 46.1-80.2 46.2-80.2-46.2 80.2-46.2zm88.2 60l0 201.3c-33.2 19.1-59.9 34.5-80.2 46.2l0-201.3C153 104.4 179.7 89 200 77.3zm0 412.8L23.5 388.5 23.5 77.3c20.3 11.7 47.1 27.1 80.2 46.2l0 215.2c0 .3 .1 .6 .1 .9 0 .4 .1 .8 .2 1.2 .1 .3 .2 .6 .4 .9 .1 .3 .3 .7 .4 1 .2 .3 .4 .5 .6 .8 .2 .3 .4 .6 .7 .8 .2 .2 .5 .4 .8 .6 .3 .2 .6 .5 .9 .7l92.2 52.2 .1 92.4zm8-106.2L128 338.6c54.7-31.5 113.5-65.3 176.3-101.5l80.1 46.1C355 300 296.2 333.5 208 383.9zm184.5 4.6l-176.5 101.6 0-92.3C317.4 340 376.2 306.4 392.5 297l0 91.4zm0-119.1c-20.3-11.6-47.1-27-80.2-46.1l0-91.4c20.3 11.7 47.1 27.1 80.2 46.2l0 91.3zm8-105.3l-80.2-46.2 80.2-46.2 80.2 46.1-80.2 46.2zm8 105.3l0-91.3c33.2-19.1 60-34.5 80.3-46.2l0 91.4-80.3 46.2z"],
    "wpforms": [448, 512, [], "f298", "M448 75.2l0 361.7c0 24.3-19 43.2-43.2 43.2l-361.6 0C19.3 480 0 461.4 0 436.8L0 75.2C0 51.1 18.8 32 43.2 32l361.7 0c24 0 43.1 18.8 43.1 43.2zM410.7 436.8l0-361.6c0-3-2.6-5.8-5.8-5.8l-9.3 0-110.3 74.6-61.3-49.9-61.2 49.9-110.3-74.7-9.3 0c-3.2 0-5.8 2.8-5.8 5.8l0 361.7c0 3 2.6 5.8 5.8 5.8l361.7 0c3.2 .1 5.8-2.7 5.8-5.8zM150.2 186l0 37-73.5 0 0-37 73.5 0zm0 74.4l0 37.3-73.5 0 0-37.3 73.5 0zm11.1-147.3l54-43.7-118.5 0 64.5 43.7zm210 72.9l0 37-196 0 0-37 196 0zm0 74.4l0 37.3-196 0 0-37.3 196 0zM286.7 113.1l64.5-43.7-118.4 0 53.9 43.7zM371.3 335l0 37.3-99.4 0 0-37.3 99.4 0z"],
    "speaker-deck": [512, 512, [], "f83c", "M213.9 296L100 296c-26.5 0-52-10.5-70.7-29.3S0 222.5 0 196 10.5 144 29.3 125.3 73.5 96 100 96l132.8 0c10.6 0 20.8 4.2 28.3 11.7s11.7 17.7 11.7 28.3-4.2 20.8-11.7 28.3-17.7 11.7-28.3 11.7L98 176c-26.5 0-26.4 40 0 40l113.8 0c26.5 0 52 10.5 70.7 29.3s29.3 44.2 29.3 70.7-10.5 52-29.3 70.7-44.2 29.3-70.7 29.3L40 416c-10.6 0-20.8-4.2-28.3-11.7S0 386.6 0 376 4.2 355.2 11.7 347.7 29.4 336 40 336l173.9 0c26.5 0 26.5-40 0-40zM298 416c13.5-9.2 25-21 33.8-34.7s14.7-29.2 17.3-45.3l64.6 0c2.6 0 5.2-.6 7.6-1.6s4.6-2.5 6.4-4.4 3.3-4.1 4.2-6.5 1.5-5 1.4-7.6l0-120c0-2.6-.5-5.2-1.4-7.6s-2.4-4.6-4.2-6.5-4-3.3-6.4-4.4-5-1.6-7.6-1.6l-117.2 0c9.7-11.1 15-25.3 15-40s-5.3-28.9-15-40l136.9 0c43.4 0 78.6 35.8 78.6 80l0 160c0 44.2-35.2 80-78.6 80L298 416z"],
    "flickr": [448, 512, [], "f16e", "M400 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM144.5 192a63.5 63.5 0 1 1 0 127 63.5 63.5 0 1 1 0-127zm159 0a63.5 63.5 0 1 1 0 127 63.5 63.5 0 1 1 0-127z"],
    "cc-visa": [576, 512, [], "f1f0", "M470.1 231.3s7.6 37.2 9.3 45l-33.4 0c3.3-8.9 16-43.5 16-43.5-.2 .3 3.3-9.1 5.3-14.9l2.8 13.4zM576 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l480 0c26.5 0 48 21.5 48 48zM152.5 331.2l63.2-155.2-42.5 0-39.3 106-4.3-21.5-14-71.4c-2.3-9.9-9.4-12.7-18.2-13.1l-64.7 0-.7 3.1c15.8 4 29.9 9.8 42.2 17.1l35.8 135 42.5 0zm94.4 .2l25.2-155.4-40.2 0-25.1 155.4 40.1 0zm139.9-50.8c.2-17.7-10.6-31.2-33.7-42.3-14.1-7.1-22.7-11.9-22.7-19.2 .2-6.6 7.3-13.4 23.1-13.4 13.1-.3 22.7 2.8 29.9 5.9l3.6 1.7 5.5-33.6c-7.9-3.1-20.5-6.6-36-6.6-39.7 0-67.6 21.2-67.8 51.4-.3 22.3 20 34.7 35.2 42.2 15.5 7.6 20.8 12.6 20.8 19.3-.2 10.4-12.6 15.2-24.1 15.2-16 0-24.6-2.5-37.7-8.3l-5.3-2.5-5.6 34.9c9.4 4.3 26.8 8.1 44.8 8.3 42.2 .1 69.7-20.8 70-53zM528 331.4l-32.4-155.4-31.1 0c-9.6 0-16.9 2.8-21 12.9l-59.7 142.5 42.2 0s6.9-19.2 8.4-23.3l51.6 0c1.2 5.5 4.8 23.3 4.8 23.3l37.2 0z"],
    "upwork": [640, 512, [], "e641", "M493.9 295.6c-50.3 0-83.5-38.9-92.8-53.9 11.9-95.3 46.8-125.4 92.8-125.4 45.5 0 80.9 36.4 80.9 89.7s-35.4 89.7-80.9 89.7l0-.1zm0-237.8c-81.9 0-127.8 53.4-141 108.4-14.9-28-25.9-65.5-34.5-100.3l-113.2 0 0 141c0 51.1-23.3 89-68.8 89s-71.6-37.8-71.6-89l.5-141-65.3 0 0 141c0 41.1 13.3 78.4 37.6 105.1 25 27.5 59.2 41.8 98.8 41.8 78.8 0 133.8-60.4 133.8-146.9l0-94.8c8.2 31.2 27.8 91.1 65.3 143.6l-35 199.4 66.4 0 23.1-141.3c7.6 6.3 15.7 12 24.2 17 22.2 14 47.7 21.9 73.9 22.8 0 0 4 .2 6.1 .2 81.2 0 145.9-62.9 145.9-147.8S575.3 57.9 494.1 57.9l-.2-.1z"],
    "kakao-talk": [576, 512, [], "e7d7", "M288 2.5c159.1 0 288 101.7 288 227.1 0 125.4-128.9 227.1-288 227.1-17.5 0-34.6-1.2-51.2-3.6-16.6 11.7-112.6 79.1-121.7 80.4 0 0-3.7 1.4-6.9-.4s-2.6-6.7-2.6-6.7C106.6 519.8 130.6 437.2 135 421.9 53.9 381.8 0 310.6 0 229.5 0 104.1 128.9 2.5 288 2.5zM86.2 161.7c-9 0-16.3 7.3-16.3 16.3s7.3 16.3 16.3 16.3l25.9 0 0 98.7c0 8.8 7.5 15.9 16.6 15.9s16.6-7.1 16.6-15.9l0-98.7 25.9 0c9 0 16.3-7.3 16.3-16.3s-7.3-16.3-16.3-16.3l-85.1 0zm140.8 0c-10.8 .2-19.3 8.4-22.1 16.4L165.2 282.7c-5 15.7-.6 21.5 3.9 23.6 3.2 1.5 6.9 2.3 10.6 2.3 6.9 0 12.2-2.8 13.8-7.3l8.2-21.6 50.7 0 8.2 21.5c1.6 4.5 6.9 7.3 13.8 7.3 3.7 0 7.3-.8 10.6-2.3 4.6-2.1 9-7.9 3.9-23.6L249.2 178.1c-2.8-8-11.3-16.2-22.2-16.4zm180.9 0c-9.2 0-16.6 7.5-16.6 16.6l0 113.7c0 9.2 7.5 16.6 16.6 16.6s16.6-7.5 16.6-16.6l0-36.2 5.8-5.8 38.9 51.6c3.2 4.2 8 6.6 13.3 6.6 3.6 0 7.1-1.1 10-3.3 3.5-2.7 5.8-6.6 6.4-11s-.5-8.8-3.2-12.3l-40.9-54.2 37.9-37.8c2.6-2.6 3.9-6.2 3.7-10.1-.2-3.9-2-7.6-4.9-10.5-3.1-3.1-7.3-4.9-11.4-4.9-3.6 0-6.8 1.3-9.2 3.7l-46.3 46.4 0-35.7c0-9.2-7.5-16.6-16.6-16.6zm-91.3 0c-9.3 0-16.9 7.5-16.9 16.6l0 112.8c0 8.4 7.1 15.2 15.9 15.3l53.3 0c8.8 0 15.9-6.9 15.9-15.3s-7.2-15.2-15.9-15.2l-35.3 0 0-97.6c0-9.2-7.6-16.6-17-16.6zm-73 88.6l-33.2 0 16.6-47.1 16.6 47.1z"],
    "flutter": [448, 512, [], "e694", "M429.5 236.3L291.7 374.1 429.5 512 272 512c-36.1-36.1-82.1-82.1-137.9-137.9l137.9-137.8 157.5 0zM272 0L16 256 94.8 334.8 429.5 0 272 0z"],
    "buffer": [448, 512, [], "f837", "M428.2 380.7L231.7 478.5c-2.3 1-4.8 1.5-7.3 1.5s-5-.5-7.3-1.5L20.5 380.7c-4-2-4-5.3 0-7.3L67.6 350c2.3-1 4.8-1.5 7.3-1.5s5 .5 7.3 1.5l134.8 67c2.3 1 4.8 1.5 7.3 1.5s5-.5 7.3-1.5l134.8-67c2.3-1 4.8-1.5 7.3-1.5s5 .5 7.3 1.5l47.1 23.4c4 2 4 5.2 0 7.2zm0-136.5l-47.1-23.4c-2.3-1-4.8-1.5-7.3-1.5s-5 .5-7.3 1.5L231.7 287.8c-2.3 1-4.8 1.5-7.3 1.5s-5-.5-7.3-1.5L82.3 220.7c-2.3-1-4.8-1.5-7.3-1.5s-5 .5-7.3 1.5L20.5 244.1c-4 2-4 5.3 0 7.3l196.5 97.8c2.3 1 4.8 1.5 7.3 1.5s5-.5 7.3-1.5l196.5-97.8c4-2 4-5.3 0-7.3zM20.5 130.4L217 220.7c4.7 1.9 10 1.9 14.7 0l196.5-90.3c4-1.9 4-4.9 0-6.7L231.7 33.4c-4.7-1.9-10-1.9-14.7 0L20.5 123.7c-4 1.8-4 4.9 0 6.7z"],
    "gratipay": [512, 512, [], "f184", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM374.3 233.7L257.7 391.3 141.3 233.7c-9-12.3-19.7-52 14-74.3 29-18.7 56.4-4.3 70.7 12.3 16.4 18.5 48.1 17.4 63.7 0 14.3-16.6 41.7-31 70.3-12.3 34 22.3 23.3 61.9 14.2 74.3z"],
    "google-pay": [640, 512, [], "e079", "M105.7 215l0 41.2 57.1 0c-1.2 6.6-3.6 12.9-7.2 18.5s-8.4 10.4-13.9 14.1c-9.5 6.6-21.7 10.3-36 10.3-27.6 0-50.9-18.9-59.3-44.2-4.4-13.3-4.4-27.7 0-41 8.4-25.5 31.7-44.4 59.3-44.4 7.5-.1 14.9 1.2 21.9 4s13.3 6.9 18.6 12.1L176.5 155c-19.1-18.1-44.4-28.1-70.7-27.8-19.7 .1-38.9 5.7-55.6 16.1s-30.1 25.3-38.8 43C3.9 201.2 0 217.7 0 234.4s3.9 33.2 11.3 48.1l0 .2c8.7 17.7 22.1 32.5 38.8 43s35.9 16 55.6 16c28.5 0 52.5-9.5 70-25.9 20-18.6 31.4-46.2 31.4-78.9 0-7.3-.6-14.6-1.8-21.8l-99.7 0zm389.4-4c-10.1-9.4-23.9-14.1-41.4-14.1-22.5 0-39.3 8.3-50.5 24.9L424.1 235c7.6-11.3 18.1-17 31.3-17 8.4 0 16.5 3.2 22.7 8.8 3 2.6 5.5 5.9 7.1 9.6s2.5 7.6 2.5 11.7l0 5.5c-9.1-5.1-20.6-7.8-34.6-7.8-16.4 0-29.6 3.9-39.5 11.8s-14.8 18.3-14.8 31.6c-.2 5.9 1 11.8 3.4 17.2s6 10.2 10.5 14.1c9.2 8.3 21 12.5 34.8 12.5 16.3 0 29.2-7.3 39-21.9l1 0 0 17.7 22.6 0 0-78.7c.1-16.6-4.9-29.7-15-39zm-19.2 89.3c-3.5 3.5-7.6 6.3-12.2 8.2s-9.5 2.9-14.4 2.9c-6.7 .1-13.1-2.1-18.3-6.2-2.4-1.8-4.4-4.2-5.7-6.9s-2-5.7-2-8.7c0-7 3.2-12.8 9.5-17.4s14.5-7 24.1-7c13.2-.2 23.5 2.8 30.8 8.8 0 10.1-4 18.9-11.7 26.4zm-93.7-142c-5.3-5.3-11.6-9.5-18.6-12.3s-14.4-4.2-21.9-4l-62.7 0 0 186.7 23.6 0 0-75.6 39 0c16 0 29.5-5.4 40.5-15.9 .9-.9 1.8-1.8 2.6-2.7 9.6-10.5 14.8-24.4 14.3-38.6s-6.6-27.7-16.9-37.6l0 0zm-16.6 62.2c-3 3.2-6.6 5.7-10.6 7.4s-8.4 2.5-12.7 2.3l-39.6 0 0-65.2 39.6 0c8.5 0 16.6 3.3 22.6 9.2 6.1 6.1 9.6 14.3 9.8 23s-3.1 17-9 23.3l0 0zM614.3 201l-36.5 91.7-.5 0-37.4-91.7-25.7 0 51.8 119.6-29.4 64.3 24.3 0 79-183.9-25.7 0z"],
    "apple": [384, 512, [], "f179", "M319.1 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7-55.8 .9-115.1 44.5-115.1 133.2 0 26.2 4.8 53.3 14.4 81.2 12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zM262.5 104.5c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z"],
    "tumblr": [320, 512, [], "f173", "M309.9 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6l0-144-47.5 0c-5.5 0-10-4.5-10-10l0-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1 .8-11 6.5-16.3 16.1-16.3l70.9 0c5.5 0 10 4.5 10 10l0 115.2 83 0c5.5 0 10 4.4 10 9.9l0 81.7c0 5.5-4.5 10-10 10l-83.4 0 0 133.2c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5 .9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"],
    "phoenix-squadron": [512, 512, [], "f511", "M96 63.4c46.5-36.1 105.6-56.1 164.5-54.6 29.6-.4 59.1 5.4 86.9 15.3-24.1-4.6-49-6.3-73.4-2.5-42.9 5.3-83 27.2-111.8 59.2 5.7-1 10.8-3.7 16-5.9 18.1-7.9 37.5-13.3 57.2-14.8 19.7-2.1 39.6-.4 59.3 1.9-14.4 2.8-29.1 4.6-43 9.6-34.4 11.1-65.3 33.2-86.3 62.6-13.8 19.7-23.6 42.9-24.7 67.1-.4 16.5 5.2 34.8 19.8 44 11.2 6.8 24.6 9.2 37.5 6.7 15.4-2.5 30.1-8.6 43.6-16.3 11.5-6.8 22.7-14.6 32-24.3 3.8-3.2 2.5-8.4 2.6-12.8-2.1-.3-4.4-1.1-6.3 .3-11.4 6.3-23.4 11.4-35.8 15.4-20 6.2-42.2 8.5-62.1 .8 12.8 1.7 26.1 .3 37.7-5.4 20.2-9.7 36.8-25.2 54.4-38.8 27.7-21.3 57.5-39.9 88.9-55.3 25.7-12 52.9-22.8 81.6-24.1-15.6 13.7-32.1 26.5-46.8 41.4-14.5 14-27.5 29.5-40.1 45.2-3.5 4.6-9 6.9-13.6 10.2-22.4 15-40.3 35.8-51.9 60.1-9.3 19.7-14.5 41.9-11.8 63.6 1.9 13.7 8.7 27.6 20.9 34.9 12.9 8 29 8.1 43.5 5.1 32.8-7.4 61.4-28.9 81-55.8 20.4-27.5 30.5-62.2 29.2-96.3-.5-7.5-1.6-15-1.7-22.5 8 19.5 14.8 39.7 16.6 60.8 2 14.3 .7 28.8-1.6 42.9-1.9 11-5.7 21.5-7.8 32.4 20.4-22.9 34-50.9 39.3-81.1 5.6-35.5 .7-71.9-14.2-104.6 20.8 32 32.3 69.6 35.7 107.5 .5 12.7 .5 25.5 0 38.2-2.8 34.3-12.9 67.6-29.6 97.8-26.1 47.3-68 85.6-117.2 108-78.3 36.2-174.7 31.3-248-14.7-39-23.8-70.6-58-91.4-98.7-14.7-28.9-23.3-60.5-25.4-92.9l0-31.3C3.9 172 40.9 105.8 96 63.4zm222 80.3c5.5-.9 10.8-2.4 16-4.5 5-1.8 9.2-5.9 10.3-11.2-9 5-18 9.9-26.3 15.7z"],
    "centercode": [512, 512, [], "f380", "M201.8 254.8a64.1 64.1 0 1 1 127.4 13.8 64.1 64.1 0 1 1 -127.4-13.8zm41.6 248.9C96.7 496-8.2 365.5 10.1 224.3 21.3 137.7 75.9 67.4 149.2 32.3 310.2-44.8 498.9 69.7 503.9 248.9 508 395.9 385.5 511.1 243.4 503.7zm179.9-180c27.9-118-160.5-205.9-237.2-234.2-57.5 56.3-69.1 188.6-33.8 344.4 68.8 15.8 169.1-26.4 271-110.2z"],
    "debian": [448, 512, [], "e60b", "M380.4 245.6c3-7.6 5.5-14 5.2-24.4l-4.3 9c4.4-13.2 4-27.1 3.6-40.4-.2-6-.3-11.8 0-17.4l-1.8-.5c-1.5-45.2-40.6-93.1-75.3-109.4-30-13.8-76.1-16.2-97.3-5.8 1.3-1.1 4.2-2 6.8-2.7l.3-.1c3.3-1 6-1.7 4-2.9-19.2 1.9-24.9 5.5-31.1 9.4l-.1 0c-4.6 2.9-9.5 6-20.3 8.7-3.5 3.4 1.7 2 5.8 .9s7.2-1.9-.1 2.4c-3.5 1-6.6 1.3-9.6 1.6l-.1 0c-8.3 .8-15.8 1.6-30.7 17 .8 1.3 3.4-.2 5.3-1.3l.1-.1c2.3-1.4 3.4-2-1.7 4.4-19.1-2.4-60.3 43.7-69.1 59l4.6 .8c-3.2 8-6.8 14.8-10 20.8-4.3 8.1-7.9 14.9-8.7 21.3-.3 5.1-1 11-1.7 17.3-.1 1-.2 2-.3 3l-.1 .6c-3 27.3-6.7 60.8 3.9 73l-1.3 13c.6 1.2 1.1 2.3 1.6 3.5 .2 .4 .4 .8 .5 1.1 1 2.1 2 4.2 3.3 6.2l-3 .2c7 22.1 10.8 22.5 15.1 22.9 4.4 .4 9.3 .9 18.7 24.2-2.7-.9-5.5-1.9-9.4-7.2-.5 4.1 5.8 16.3 13.1 25.8l-3.1 3.6c2.1 3.7 4.8 6.2 7.6 8.8 1 .9 2.1 1.9 3.1 2.9-11.9-6.5 3.2 13.7 11.9 25.2 .8 1.1 1.5 2 2.2 2.9 1.4 1.9 2.5 3.4 2.9 4.1l2.4-4.2c-.3 6.1 4.3 13.9 13.1 24.7l7.3-.3c3 6 14 16.7 20.7 17.2l-4.4 5.8c8.1 2.6 10.3 4.3 12.7 6.2 2.6 2.1 5.4 4.3 16.1 8.1l-4.2-7.4c3.5 3 6.2 5.9 8.8 8.7l.1 .1c5.2 5.6 9.9 10.6 19.7 15.3 10.7 3.7 16.6 4.7 22.7 5.8 .3 0 .6 .1 .9 .1 5.4 .8 11.2 1.8 20.8 4.5-1.1-.1-2.2-.1-3.3-.1-2.3-.1-4.7-.1-7-.1-14.4-.2-29.2-.4-42.7-5.2-96.6-25.7-184.9-139-178.4-255.6-.6-9.9-.3-20.9 0-30.7 .4-13.5 .7-24.8-1.6-28.3l1-3.1c5.3-17.4 11.7-38.2 23.8-62.8l-.1-.2 0-.1c.4 .4 3.4 3.4 8.8-5.8 .8-1.8 1.6-3.7 2.4-5.6 .5-1.1 .9-2.2 1.4-3.2 2.5-6.1 5.1-12.3 8.4-17.9l2.6-.6c1.7-10.1 17-23.8 29.8-35.2l1.1-1c5.7-5.1 10.7-9.7 13.6-13.1l.7 4.4c17-15.9 44.6-27.5 65.6-36.4l.5-.2c4.8-2 9.3-3.9 13.3-5.7-3.4 3.8 2.2 2.7 10 1 4.8-1 10.4-2.1 15.3-2.4l-3.9 2.1c-2.7 1.4-5.4 2.8-8 4.6 8.1-2 11.7-1.4 15.7-.8l.3 0c3.5 .6 7.3 1.2 14.6 .2-5.6 .8-12.3 3-11.2 3.8 7.9 .9 12.8-.1 17.2-1l.2 0c5.5-1.1 10.3-2 19.3 .9l-1-4.8c7.3 2.6 12.7 4.3 17.5 5.8l.5 .1c10 3 17.6 5.3 34.2 14.1 3.2 .2 5.3-.5 7.4-1.2l.1 0c3.6-1.1 7-2.1 15.2 1.2 .3 .5 .5 1 .7 1.4 .1 .2 .2 .5 .3 .7l0 .1c1 2.6 1.8 4.6 14.6 12.1 1.7-.7-2.7-4.7-6.4-8.2l-.1-.1c-.2-.1-.3-.3-.5-.4 32.2 17.3 67.3 54.1 78 93.5-6-11.1-5.2-5.5-4.3 .5 .6 4 1.2 8.1-.2 7.5 4.5 12.1 8.1 24.5 10.4 37.4l-.8-2.9-.1-.3c-3.3-11.9-9.6-34.3-19.9-49.3-.4 4.3-2.8 3.9-5.2 3.5l-.1 0c-3.3-.6-6.2-1.1-1.9 12.6 2.6 3.8 3.1 2.4 3.5 1.1 .5-1.5 .9-2.7 4.7 5.2 .1 4.1 1 8.2 2.1 12.7l.1 .6c.1 .3 .1 .5 .2 .8l.1 .6c.6 2.6 1.3 5.4 1.8 8.4-1.1-.2-2.3-2.2-3.4-4.2-1.4-2.4-2.8-4.7-3.7-3.2 2.4 11.5 6.5 17.4 8 18.3-.3 .6-.6 .7-1.1 .7-.8 0-1.8 .1-1.9 5.3 .7 13.7 3.3 12.5 5.3 11.6 .6-.3 1.2-.6 1.7-.4-.6 2.5-1.6 5.1-2.7 7.9-2.8 7.1-6 15.4-3.4 26.1-.8-3-2-6-3.1-8.9l-.1-.4c-.2-.5-.4-1-.6-1.5-.3-.8-.6-1.6-.9-2.3-.6 4.4-.3 7.7-.1 10.6l0 .7c.4 5.3 .7 10-3 19.9 4.3-14.2 3.8-26.9-.2-20.8 1 10.9-3.7 20.4-8 28.9l-.1 .2c-3.6 7.1-6.8 13.5-5.9 19.3l-5.2-7.1c-7.5 10.9-7 13.3-6.5 15.5l0 .1c.5 1.9 1 3.8-3.4 10.8 1.7-2.9 1.3-3.6 1-4.2-.4-.8-.7-1.5 1.7-5.1-1.6 .1-5.5 3.9-10.1 8.5-3.9 3.9-8.5 8.4-12.8 11.8-37.5 30.1-82.3 34-125.6 17.8 .2-1-.2-2.1-3.1-4.1-36.8-28.2-58.5-52.1-50.9-107.5 2.1-1.6 3.6-5.8 5.3-10.8l.2-.4 .1-.3 0-.1c2.9-8.4 6.5-18.8 14.3-23.8 7.8-17.3 31.3-33.3 56.4-33.7 25.6-1.4 47.2 13.7 58.1 27.9-19.8-18.4-52.1-24-79.7-10.4-28.2 12.7-45 43.8-42.5 74.7 .3-.4 .6-.6 .9-.8l.2-.2c.6-.5 1.1-.9 1.4-3.3-.9 60.2 64.8 104.3 112.1 82l.6 1.3c12.7-3.5 15.9-6.5 20.3-10.7l.1-.1c2.2-2.1 4.7-4.5 8.9-7.3-.3 .7-1.3 1.7-2.4 2.7-2.2 2.1-4.6 4.5-1.6 4.6 5-1.3 18.5-13.4 28.5-22.3 .6-.5 1.2-1 1.7-1.5 1.5-1.3 2.8-2.5 4-3.6l.3-.3c1.9-4.2 1.6-5.6 1.3-7l0-.1c-.4-1.6-.8-3.3 2.4-9.6l7.3-3.7c.8-2.1 1.5-4.1 2.2-6 .2-.6 .5-1.2 .7-1.8l-.4-.2-.1-.1zM248 334.1c-6-3-13.7-8.9-14.8-11.4l-.4 .3c-.3 .6-.5 1.3-.2 2.2-12.2-5.7-23.4-14.3-32.6-24.9 4.9 7.1 10.1 14.1 17 19.5-6.9-2.3-15.1-11.8-21.6-19.3l-.1-.1c-4.3-5-7.9-9.1-9.7-9.5 19.8 35.5 80.5 62.3 112.3 49-14.7 .5-33.4 .3-49.9-5.8zm79.3-119.7l-.1-.2c-.5-1.5-1.1-3.1-1.7-3.4 1.4-5.8 5.4-10.7 4.4 4.6-1 3.8-1.8 1.5-2.6-1zm-4.2 22.2c-1.3 7.9-5 15.5-10.1 22.5 .2-2-1.2-2.4-2.6-2.8-2.9-.8-5.9-1.6 5.6-16.1-.5 1.9-2.1 4.6-3.7 7.3l-.3 .4c-3.6 5.9-6.7 11 4 4.3l1-1.8c2.6-4.5 5-8.8 6-13.8l.1 0zm-55.6 33.9c7.1 .6 14.1 .6 21-1.1-2.5 2.4-5.2 4.8-8.3 7.2-11.1-1.7-21.2-6-12.7-6.1zm-92.6 11.6c3.6 7.1 6.4 11.5 9 15.7l.1 .2c2.3 3.7 4.4 7.1 6.8 11.7-5.1-4.2-8.7-9.5-12.5-15l-.3-.5c-1.4-2.1-2.8-4.2-4.4-6.2l1.2-5.9 .1 0zm7.5-9.6c1.6 3.3 3.2 6.4 5.7 9.1l2.6 7.7-1.3-2.1c-3.2-5.3-6.3-10.6-8-16.7l1 2zm238.9-41.6c-2.3 17.4-7.7 34.6-16 50.3 7.6-14.9 12.5-30.9 14.8-47.2l1.2-3.1zM35.8 110.6c.4 .8 1.4 .5 2.3 .3 1.9-.5 3.6-.9-.1 7.6-.5 .3-1 .7-1.5 1-1.4 .9-2.8 1.9-3.9 3 1.9-3.8 3.5-7.4 3.2-11.9zM25.5 152.3c-.7 3.7-1.5 7.9-3.4 13.9 .2-1.9 0-3.5-.2-4.9l0-.1c-.4-3.4-.7-6.3 4.3-12.8-.3 1.2-.5 2.5-.7 3.8l0 .1z"],
    "mastodon": [448, 512, [], "f4f6", "M433 179.1c0-97.2-63.7-125.7-63.7-125.7-62.5-28.7-228.6-28.4-290.5 0 0 0-63.7 28.5-63.7 125.7 0 115.7-6.6 259.4 105.6 289.1 40.5 10.7 75.3 13 103.3 11.4 50.8-2.8 79.3-18.1 79.3-18.1l-1.7-36.9s-36.3 11.4-77.1 10.1c-40.4-1.4-83-4.4-89.6-54-.6-4.6-.9-9.3-.9-13.9 85.6 20.9 158.7 9.1 178.7 6.7 56.1-6.7 105-41.3 111.2-72.9 9.8-49.8 9-121.5 9-121.5zM357.9 304.3l-46.6 0 0-114.2c0-49.7-64-51.6-64 6.9l0 62.5-46.3 0 0-62.5c0-58.5-64-56.6-64-6.9l0 114.2-46.7 0c0-122.1-5.2-147.9 18.4-175 25.9-28.9 79.8-30.8 103.8 6.1l11.6 19.5 11.6-19.5c24.1-37.1 78.1-34.8 103.8-6.1 23.7 27.3 18.4 53 18.4 175l0 0z"],
    "sketch": [512, 512, [], "f7c6", "M27.8 162.2l-18.5 24.9 90.5 0 6.9-130.7-78.9 105.8zM396.6 45.7L268 32 403.7 179.2 396.6 45.7zM112.5 218.3l-11.2-22-91.1 0 224.9 261.7-122.6-239.7zm2-31.2l284 0C340.6 124.3 293.3 72.9 256.6 33L114.5 187.1zm297.3 9.1l-133.9 261.8 224.8-261.7-90.9 0 0-.1zM415.7 69l-9.4-12.6 .9 17.3 6.1 113.4 90.3 0-87.9-118.1zM113.8 93.5L109.2 179.1 245 32 116.4 45.7 113.8 93.5zM401.5 196.2l-290 0c18.2 35.6 66.6 130.2 145.1 283.8L401.5 196.2z"],
    "web-awesome": [640, 512, [], "e682", "M372.2 52c0 20.9-12.4 39-30.2 47.2L448 192 552.4 171.1c-5.3-7.7-8.4-17.1-8.4-27.1 0-26.5 21.5-48 48-48s48 21.5 48 48c0 26-20.6 47.1-46.4 48L481 442.3c-10.3 23-33.2 37.7-58.4 37.7l-205.2 0c-25.2 0-48-14.8-58.4-37.7L46.4 192C20.6 191.1 0 170 0 144 0 117.5 21.5 96 48 96s48 21.5 48 48c0 10.1-3.1 19.4-8.4 27.1L192 192 298.1 99.1c-17.7-8.3-30-26.3-30-47.1 0-28.7 23.3-52 52-52s52 23.3 52 52l.1 0z"],
    "sass": [640, 512, [], "f41e", "M301.8 378.9l0 0zm249.1-87c-20.1 0-40 4.6-58 13.5-5.9-11.9-12-22.3-13-30.1-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.3-6.7-24 2.5-25.3 5.9c-2.3 6.2-4.1 12.6-5.3 19.1-2.3 11.7-25.8 53.5-39.1 75.3-4.4-8.5-8.1-16-8.9-22-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.3-6.7-24 2.5-25.3 5.9-2.7 11.4-5.3 19.1-33.9 77.3-42.1 95.4c-4.2 9.2-7.8 16.6-10.4 21.6-.4 .8-.7 1.3-.9 1.7 .3-.5 .5-1 .5-.8-2.2 4.3-3.5 6.7-3.5 6.7l0 .1c-1.7 3.2-3.6 6.1-4.5 6.1-.6 0-1.9-8.4 .3-19.9 4.7-24.2 15.8-61.8 15.7-63.1-.1-.7 2.1-7.2-7.3-10.7-9.1-3.3-12.4 2.2-13.2 2.2s-1.4 2-1.4 2 10.1-42.4-19.4-42.4c-18.4 0-44 20.2-56.6 38.5-7.9 4.3-25 13.6-43 23.5-6.9 3.8-14 7.7-20.7 11.4-.5-.5-.9-1-1.4-1.5-35.8-38.2-101.9-65.2-99.1-116.5 1-18.7 7.5-67.8 127.1-127.4 98-48.8 176.3-35.4 189.8-5.6 19.4 42.5-41.9 121.6-143.7 133-38.8 4.3-59.2-10.7-64.3-16.3-5.3-5.9-6.1-6.2-8.1-5.1-3.3 1.8-1.2 7 0 10.1 3 7.9 15.5 21.9 36.8 28.9 18.7 6.1 64.2 9.5 119.2-11.8 61.8-23.8 109.9-90.1 95.8-145.6-14.4-56.4-107.9-74.9-196.3-43.5-52.7 18.7-109.7 48.1-150.7 86.4-48.7 45.6-56.5 85.3-53.3 101.9 11.4 58.9 92.6 97.3 125.1 125.7-1.6 .9-3.1 1.7-4.5 2.5-16.3 8.1-78.2 40.5-93.7 74.7-17.5 38.8 2.9 66.6 16.3 70.4 41.8 11.6 84.6-9.3 107.6-43.6s20.2-79.1 9.6-99.5c-.1-.3-.3-.5-.4-.8 4.2-2.5 8.5-5 12.8-7.5 8.3-4.9 16.4-9.4 23.5-13.3-4 10.8-6.9 23.8-8.4 42.6-1.8 22 7.3 50.5 19.1 61.7 5.2 4.9 11.5 5 15.4 5 13.8 0 20-11.4 26.9-25 8.5-16.6 16-35.9 16-35.9s-9.4 52.2 16.3 52.2c9.4 0 18.8-12.1 23-18.3l0 .1s.2-.4 .7-1.2c1-1.5 1.5-2.4 1.5-2.4l0-.3c3.8-6.5 12.1-21.4 24.6-46 16.2-31.8 31.7-71.5 31.7-71.5 1.5 8.7 3.6 17.3 6.2 25.8 2.8 9.5 8.7 19.9 13.4 30-3.8 5.2-6.1 8.2-6.1 8.2 0 .1 0 .1 .1 .2-3 4-6.4 8.3-9.9 12.5-12.8 15.2-28 32.6-30 37.6-2.4 5.9-1.8 10.3 2.8 13.7 3.4 2.6 9.4 3 15.7 2.5 11.5-.8 19.6-3.6 23.5-5.4 7.2-2.6 14-6.1 20.2-10.6 12.5-9.2 20.1-22.4 19.4-39.8-.4-9.6-3.5-19.2-7.3-28.2 1.1-1.6 2.3-3.3 3.4-5 19.8-28.9 35.1-60.6 35.1-60.6 1.5 8.7 3.6 17.3 6.2 25.8 2.4 8.1 7.1 17 11.4 25.7-18.6 15.1-30.1 32.6-34.1 44.1-7.4 21.3-1.6 30.9 9.3 33.1 4.9 1 11.9-1.3 17.1-3.5 7.7-2.6 15-6.3 21.6-11.1 12.5-9.2 24.6-22.1 23.8-39.6-.3-7.9-2.5-15.8-5.4-23.4 15.7-6.6 36.1-10.2 62.1-7.2 55.7 6.5 66.6 41.3 64.5 55.8s-13.8 22.6-17.7 25-5.1 3.3-4.8 5.1c.5 2.6 2.3 2.5 5.6 1.9 4.6-.8 29.2-11.8 30.3-38.7 1.6-34-31.1-71.4-89-71.1l0 0zM121.8 436.6c-18.4 20.1-44.2 27.7-55.3 21.3-11.9-6.9-7.2-36.5 15.5-57.9 13.8-13 31.6-25 43.4-32.4 2.7-1.6 6.6-4 11.4-6.9 .8-.5 1.2-.7 1.2-.7 .9-.6 1.9-1.1 2.9-1.7 8.3 30.4 .3 57.2-19.1 78.3l0 0zm134.4-91.4c-6.4 15.7-19.9 55.7-28.1 53.6-7-1.8-11.3-32.3-1.4-62.3 5-15.1 15.6-33.1 21.9-40.1 10.1-11.3 21.2-14.9 23.8-10.4 3.5 5.9-12.2 49.4-16.2 59.2zm111 53c-2.7 1.4-5.2 2.3-6.4 1.6-.9-.5 1.1-2.4 1.1-2.4s13.9-14.9 19.4-21.7c3.2-4 6.9-8.7 10.9-13.9 0 .5 .1 1 .1 1.6-.1 17.9-17.3 30-25.1 34.8l0 0zm85.6-19.5c-2-1.4-1.7-6.1 5-20.7 2.6-5.7 8.6-15.3 19-24.5 1.2 3.5 1.8 7.1 1.9 10.8-.1 22.5-16.2 30.9-25.9 34.4l0 0z"],
    "square-whatsapp": [448, 512, ["whatsapp-square"], "f40c", "M92.1 254.6c0 24.9 7 49.2 20.2 70.1l3.1 5-13.3 48.6 49.9-13.1 4.8 2.9c20.2 12 43.4 18.4 67.1 18.4l.1 0c72.6 0 133.3-59.1 133.3-131.8 0-35.2-15.2-68.3-40.1-93.2-25-25-58-38.7-93.2-38.7-72.7 0-131.8 59.1-131.9 131.8zM274.8 330c-12.6 1.9-22.4 .9-47.5-9.9-36.8-15.9-61.8-51.5-66.9-58.7-.4-.6-.7-.9-.8-1.1-2-2.6-16.2-21.5-16.2-41 0-18.4 9-27.9 13.2-32.3 .3-.3 .5-.5 .7-.8 3.6-4 7.9-5 10.6-5 2.6 0 5.3 0 7.6 .1l.8 0c2.3 0 5.2 0 8.1 6.8 1.2 2.9 3 7.3 4.9 11.8 3.3 8 6.7 16.3 7.3 17.6 1 2 1.7 4.3 .3 6.9-3.4 6.8-6.9 10.4-9.3 13-3.1 3.2-4.5 4.7-2.3 8.6 15.3 26.3 30.6 35.4 53.9 47.1 4 2 6.3 1.7 8.6-1 2.3-2.6 9.9-11.6 12.5-15.5 2.6-4 5.3-3.3 8.9-2s23.1 10.9 27.1 12.9c.8 .4 1.5 .7 2.1 1 2.8 1.4 4.7 2.3 5.5 3.6 .9 1.9 .9 9.9-2.4 19.1-3.3 9.3-19.1 17.7-26.7 18.8zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM148.1 393.9L64 416 86.5 333.8c-13.9-24-21.2-51.3-21.2-79.3 .1-87.4 71.2-158.5 158.6-158.5 42.4 0 82.2 16.5 112.2 46.5 29.9 30 47.9 69.8 47.9 112.2 0 87.4-72.7 158.5-160.1 158.5-26.6 0-52.7-6.7-75.8-19.3z"],
    "skype": [448, 512, [], "f17e", "M424.7 299.8c2.9-14 4.7-28.9 4.7-43.8 0-113.5-91.9-205.3-205.3-205.3-14.9 0-29.7 1.7-43.8 4.7-19-14.7-42.6-23.4-68.3-23.4-61.8 0-112 50.2-112 112 0 25.7 8.7 49.3 23.3 68.2-2.9 14-4.7 28.9-4.7 43.8 0 113.5 91.9 205.3 205.3 205.3 14.9 0 29.7-1.7 43.8-4.7 19 14.6 42.6 23.3 68.2 23.3 61.8 0 112-50.2 112-112 .1-25.6-8.6-49.2-23.2-68.1zM230.1 391.3c-65.6 0-120.5-29.2-120.5-65 0-16 9-30.6 29.5-30.6 31.2 0 34.1 44.9 88.1 44.9 25.7 0 42.3-11.4 42.3-26.3 0-18.7-16-21.6-42-28-62.5-15.4-117.8-22-117.8-87.2 0-59.2 58.6-81.1 109.1-81.1 55.1 0 110.8 21.9 110.8 55.4 0 16.9-11.4 31.8-30.3 31.8-28.3 0-29.2-33.5-75-33.5-25.7 0-42 7-42 22.5 0 19.8 20.8 21.8 69.1 33 41.4 9.3 90.7 26.8 90.7 77.6 0 59.1-57.1 86.5-112 86.5z"],
    "angular": [448, 512, [], "f420", "M185.7 268.1l76.2 0-38.1-91.6-38.1 91.6zM223.8 32L16 106.4 47.8 382.1 223.8 480 399.8 382.1 431.6 106.4 223.8 32zM354 373.8l-48.6 0-26.2-65.4-110.6 0-26.2 65.4-48.7 0 130.1-292.3 130.2 292.3z"],
    "opensuse": [640, 512, [], "e62b", "M471.1 102.7s-.3 18.3-.3 20.3c-9.1-3-74.4-24.1-135.7-26.3-51.9-1.8-122.8-4.3-223 57.3-19.4 12.4-73.9 46.1-99.6 109.7-5.5 13.3-12.6 43.3-5.5 71.4 3.3 12.8 8.9 24.9 16.5 35.7 17.4 25 46.6 41.6 78.1 44.4 44.4 3.9 78.1-16 90-53.3 8.2-25.8 0-63.6-31.5-82.9-25.6-15.7-53.3-12.1-69.2-1.6-13.9 9.2-21.8 23.5-21.6 39.2 .3 27.8 24.3 42.6 41.5 42.6 5.4 0 10.7-.9 15.8-2.7 6.5-1.8 13.3-6.5 13.3-14.9 0-12.1-11.6-14.8-16.8-13.9-2.9 .5-4.5 2-11.8 2.4-2-.2-12-3.1-12-14l0-.1c.2-12.3 13.2-18 25.5-16.9 32.3 2.8 47.7 40.7 28.5 65.7-18.3 23.7-76.6 23.2-99.7-20.4-26-49.2 12.7-111.2 87-98.4 33.2 5.7 83.6 35.5 102.4 104.3l45.9 0c-5.7-17.6-8.9-68.3 42.7-68.3 56.7 0 63.9 39.9 79.8 68.3l48.6 0c-12.8-18.3-21.7-38.7-18.9-55.8 5.6-33.8 39.7-18.4 82.4-17.4 66.5 .4 102.1-27 103.1-28 3.7-3.1 6.5-15.8 7-17.7 1.3-5.1-3.2-2.4-3.2-2.4-8.7 5.2-30.5 15.2-50.9 15.6-25.3 .5-76.2-25.4-81.6-28.2-.3-.4 .1 1.2-11-25.5 88.4 58.3 118.3 40.5 145.2 21.7 .8-.6 4.3-2.9 3.6-5.7-13.8-48.1-22.4-62.7-34.5-69.6-37-21.6-125-34.7-129.2-35.3 .1-.1-.9-.3-.9 .7zm60.4 72.8a37.6 37.6 0 1 1 75.2 2.6 37.6 37.6 0 1 1 -75.2-2.6zm38.6-25.3c-3.6-.3-7.1 .1-10.5 1.2s-6.5 2.9-9.2 5.3-4.8 5.3-6.3 8.5-2.4 6.7-2.5 10.3 .5 7.1 1.8 10.4 3.3 6.3 5.8 8.9 5.5 4.5 8.8 5.9 6.9 2 10.4 1.9c3.6 .3 7.1-.1 10.5-1.2s6.5-2.9 9.2-5.3 4.8-5.3 6.3-8.5 2.4-6.7 2.5-10.3-.5-7.1-1.8-10.4-3.3-6.3-5.8-8.9-5.5-4.5-8.8-5.9-6.9-2-10.4-1.9zm4.3 28.8c-15.4 0-15.4-15.6 0-15.6s15.4 15.6 0 15.6z"],
    "dropbox": [576, 512, [], "f16b", "M288.4 116.3l-132 84.3 132 84.3-132 84.3-132.4-85.1 132.3-84.3-132.3-83.5 132.3-84.3 132.1 84.3zM155.6 395.7l132-84.3 132 84.3-132 84.3-132-84.3zM288.4 284.1l132-84.3-132-83.6 131.3-84.2 132.3 84.3-132.3 84.3 132.3 84.2-132.3 84.3-131.3-85z"],
    "deezer": [512, 512, [], "e077", "M14.8 101.1C6.6 101.1 0 127.6 0 160.3s6.6 59.2 14.8 59.2 14.8-26.5 14.8-59.2-6.6-59.2-14.8-59.2zM448.7 40.9c-7.7 0-14.5 17.1-19.4 44.1-7.7-46.7-20.2-77-34.2-77-16.8 0-31.1 42.9-38 105.4-6.6-45.4-16.8-74.2-28.3-74.2-16.1 0-29.6 56.9-34.7 136.2-9.4-40.8-23.2-66.3-38.3-66.3s-28.8 25.5-38.3 66.3c-5.1-79.3-18.6-136.2-34.7-136.2-11.5 0-21.7 28.8-28.3 74.2-6.6-62.5-21.2-105.4-37.8-105.4-14 0-26.5 30.4-34.2 77-4.8-27-11.7-44.1-19.4-44.1-14.3 0-26 59.2-26 132.1S49 305.2 63.3 305.2c5.9 0 11.5-9.9 15.8-26.8 6.9 61.7 21.2 104.1 38 104.1 13 0 24.5-25.5 32.1-65.6 5.4 76.3 18.6 130.4 34.2 130.4 9.7 0 18.6-21.4 25.3-56.4 7.9 72.2 26.3 122.7 47.7 122.7s39.5-50.5 47.7-122.7c6.6 35 15.6 56.4 25.3 56.4 15.6 0 28.8-54.1 34.2-130.4 7.7 40.1 19.4 65.6 32.1 65.6 16.6 0 30.9-42.3 38-104.1 4.3 16.8 9.7 26.8 15.8 26.8 14.3 0 26-59.2 26-132.1S463 40.9 448.7 40.9zm48.5 60.2c-8.2 0-14.8 26.5-14.8 59.2s6.6 59.2 14.8 59.2 14.8-26.5 14.8-59.2-6.6-59.2-14.8-59.2z"],
    "creative-commons-sampling": [512, 512, [], "f4f0", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm3.6 53.2c2.8-.3 11.5 1 11.5 11.5l6.6 107.2 4.9-59.3c0-6 4.7-10.6 10.6-10.6s10.6 4.7 10.6 10.6c0 2.5-.5-5.7 5.7 81.5l5.8-64.2c.3-2.9 2.9-9.3 10.2-9.3 3.8 0 9.9 2.3 10.6 8.9l11.5 96.5 5.3-12.8c1.8-4.4 5.2-6.6 10.2-6.6l58 0 0 21.3-50.9 0-18.2 44.3c-3.9 9.9-19.5 9.1-20.8-3.1l-4-31.9-7.5 92.6c-.3 3-3 9.3-10.2 9.3-3 0-9.8-2.1-10.6-9.3 0-1.9 .6 5.8-6.2-77.9l-5.3 72.2c-1.1 4.8-4.8 9.3-10.6 9.3-2.9 0-9.8-2-10.6-9.3 0-1.9 .5 6.7-5.8-87.7L255 383.9c0 6.3-3.6 12.4-10.6 12.4-5.2 0-10.6-4.1-10.6-12L228 296.6c-5.8 92.5-5.3 84-5.3 85.9-1.1 4.8-4.8 9.3-10.6 9.3-3 0-9.8-2.1-10.6-9.3 0-.7-.4-1.1-.4-2.6l-6.2-88.6-4.9 56.7c-.7 6.5-6.7 9.3-10.6 9.3-5.8 0-9.6-4.1-10.6-8.9L157.7 272c-2 4-3.5 8.4-11.1 8.4l-51.4 0 0-21.3 44.8 0 13.7-27.9c4.4-9.9 18.2-7.2 19.9 2.7l3.1 20.4 8.4-97.9c0-6 4.8-10.6 10.6-10.6 .5 0 10.6-.2 10.6 12.4l4.9 69.1 6.6-92.6c0-10.1 9.5-10.6 10.2-10.6 .6 0 10.6 .7 10.6 10.6l5.3 80.6 6.2-97.9c.1-1.1-.6-10.3 9.9-11.5z"],
    "jedi-order": [448, 512, [], "f50e", "M398.9 373.6c95.9-122.1 17.2-233.1 17.2-233.1 45.4 85.8-41.4 170.5-41.4 170.5 105-171.5-60.5-271.5-60.5-271.5 96.9 72.7-10.1 190.7-10.1 190.7 85.8 158.4-68.6 230.1-68.6 230.1s-.4-16.9-2.2-85.7c4.3 4.5 34.5 36.2 34.5 36.2l-24.2-47.4 62.6-9.1-62.6-9.1 20.2-55.5-31.4 45.9c-2.2-87.7-7.8-305.1-7.9-306.9 0 1-5.6 219-7.9 306.9l-31.4-45.9 20.2 55.5-62.6 9.1 62.6 9.1-24.2 47.4 34.5-36.2c-1.8 68.8-2.2 85.7-2.2 85.7S59.1 388.6 144.9 230.2c0 0-107-118.1-10.1-190.7 0 0-165.5 99.9-60.5 271.5 0 0-86.8-84.8-41.4-170.5 0 0-78.7 111 17.2 233.1 0 0-26.2-16.1-49.4-77.7 0 0 16.9 183.3 222 185.7l4.1 0c205-2.4 222-185.7 222-185.7-23.6 61.5-49.9 77.7-49.9 77.7z"],
    "r-project": [576, 512, [], "f4f7", "M578.5 226.6C578.5 119.1 448.4 32 288 32S-2.5 119.1-2.5 226.6c0 95.8 103.3 175.4 239.4 191.5l0 61.9 99.1 0 0-61.5c24.3-2.7 47.6-7.4 69.4-13.9l40.1 75.4 112 0-67.4-113.7c54.5-35.4 88.4-84.9 88.4-139.7zM111.7 241.1c0-73.5 98.9-133 220.8-133s211.9 40.7 211.9 133c0 50.1-26.5 85-70.3 106.4-2.4-1.6-4.7-2.9-6.4-3.7-10.2-5.2-27.8-10.5-27.8-10.5s86.6-6.4 86.6-92.7-90.6-87.9-90.6-87.9l-199 0 0 208.3c-74.1-21.5-125.2-67.1-125.2-119.9zm225.1 38.3l0-55.6c57.8 0 87.8-6.8 87.8 27.3 0 36.5-38.2 28.3-87.8 28.3zm-.9 72.5l26.6 0c10.8 0 18.9 11.7 24 19.2-16.1 1.9-33 2.8-50.6 2.9l0-22.1z"],
    "instalod": [512, 512, [], "e081", "M153.6 480l233.7 0 115.4-204.2-298.3 57.4-50.8 146.8zM505 240.1L387.4 32 155.9 32 360.5 267.9 505 240.1zM124.6 48.8L7.5 256 123.5 461.2 225.9 165.6 124.6 48.8z"],
    "canadian-maple-leaf": [512, 512, [], "f785", "M383.8 351.7c2.5-2.5 105.2-92.4 105.2-92.4l-17.5-7.5c-10-4.9-7.4-11.5-5-17.4 2.4-7.6 20.1-67.3 20.1-67.3s-47.7 10-57.7 12.5c-7.5 2.4-10-2.5-12.5-7.5s-15-32.4-15-32.4-52.6 59.9-55.1 62.3c-10 7.5-20.1 0-17.6-10 0-10 27.6-129.6 27.6-129.6s-30.1 17.4-40.1 22.4c-7.5 5-12.6 5-17.6-5-5.1-7.5-42.7-79.8-42.7-79.8s-37.5 72.3-42.5 79.8c-5 10-10 10-17.6 5-10-5-40.1-22.4-40.1-22.4S183.3 182 183.3 192c2.5 10-7.5 17.5-17.6 10-2.5-2.5-55.1-62.3-55.1-62.3s-12.5 27.3-15 32.3-5 9.9-12.5 7.5C73 177 25.4 167 25.4 167S43 226.7 45.5 234.3c2.4 6 5 12.5-5 17.4L23 259.3s102.6 89.9 105.2 92.4c5.1 5 10 7.5 5.1 22.5-5.1 15-10.1 35.1-10.1 35.1s95.2-20.1 105.3-22.6c8.7-.9 18.3 2.5 18.3 12.5S241 512 241 512l30 0s-5.8-102.7-5.8-112.8 9.5-13.4 18.4-12.5c10 2.5 105.2 22.6 105.2 22.6s-5-20.1-10-35.1 0-17.5 5-22.5z"],
    "ethereum": [320, 512, [], "f42e", "M311.9 260.8L160 353.6 8 260.8 160 0 311.9 260.8zM160 383.4L8 290.6 160 512 312 290.6 160 383.4z"],
    "houzz": [448, 512, [], "f27c", "M276 330.7l-104.6 0 0 149.3-154.3 0 0-448 109.5 0 0 104.5 305.1 85.6 0 257.9-155.7 0 0-149.3z"],
    "viber": [512, 512, [], "f409", "M444.3 49.9c-12.7-11.7-64.1-49-178.7-49.5 0 0-135.1-8.1-200.9 52.3-36.6 36.6-49.5 90.3-50.9 156.8s-3.1 191.1 117 224.9l.1 0-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM458.2 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9 .4-85.7 .4-85.7l0 0C43.4 372.7 49.4 266.6 50.5 211.1s11.6-101 42.6-131.6c55.7-50.5 170.4-43 170.4-43 96.9 .4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9 .6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4 .7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5 .9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9 .1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7 .5 133 51.4 133.7 139.2zM375.2 329l0 .2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8l.2 0c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1 .8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z"],
    "kickstarter": [448, 512, ["square-kickstarter"], "f3bb", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM320.8 233l-23.3 23.1 23.3 22.9c24.1 23.9 24.1 63 0 86.9s-63.4 23.9-87.6 0l-8.5-8.4c-11.3 16-29.7 26.5-50.9 26.5-34.1 0-61.9-27.5-61.9-61.4l0-133.2c0-33.8 27.7-61.4 61.9-61.4 21.1 0 39.6 10.5 50.9 26.5l8.5-8.4c24.1-23.9 63.4-23.9 87.6 0s24.1 63 0 86.9z"],
    "spotify": [512, 512, [], "f1bc", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM356.7 372.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"],
    "leanpub": [576, 512, [], "f212", "M386.6 111.5l15.1 249-11-.3c-36.2-.8-71.6 8.8-102.7 28-31-19.2-66.4-28-102.7-28-45.6 0-82.1 10.7-123.5 27.7L93.2 129.6c28.5-11.8 61.5-18.1 92.2-18.1 41.2 0 73.8 13.2 102.7 42.5 27.7-28.3 59-41.7 98.5-42.5zM569.2 448c-25.5 0-47.5-5.2-70.5-15.6-34.3-15.6-70-25-107.9-25-39 0-74.9 12.9-102.7 40.6-27.7-27.7-63.7-40.6-102.7-40.6-37.9 0-73.6 9.3-107.9 25-22.2 9.9-44.7 15.6-69.2 15.6L7 448 49.6 98.9c39.3-22.2 87-34.9 132.3-34.9 37.1 0 75.2 7.7 106.2 29.1 31-21.4 69.2-29.1 106.2-29.1 45.3 0 93 12.6 132.3 34.9L569.2 448zm-43.4-44.7L491.8 123c-30.7-14-67.2-21.4-101-21.4-38.4 0-74.4 12.1-102.7 38.7-28.3-26.6-64.2-38.7-102.7-38.7-33.8 0-70.3 7.4-101 21.4l-34 280.2c47.2-19.5 82.9-33.5 135-33.5 37.6 0 70.8 9.6 102.7 29.6 31.8-20 65.1-29.6 102.7-29.6 52.2 0 87.8 14 135 33.5z"],
    "java": [384, 512, [], "f4e4", "M277.8 312.9c9.8-6.7 23.4-12.5 23.4-12.5s-38.7 7-77.2 10.2c-47.1 3.9-97.7 4.7-123.1 1.3-60.1-8 33-30.1 33-30.1s-36.1-2.4-80.6 19c-52.5 25.4 130 37 224.5 12.1zm-85.4-32.1c-19-42.7-83.1-80.2 0-145.8 103.7-81.8 50.5-135 50.5-135 21.5 84.5-75.6 110.1-110.7 162.6-23.9 35.9 11.7 74.4 60.2 118.2zM307 104.6c.1 0-175.2 43.8-91.5 140.2 24.7 28.4-6.5 54-6.5 54s62.7-32.4 33.9-72.9C216 188.1 195.4 169.3 307 104.6zm-6.1 270.5c-.5 1-1.2 1.8-2 2.6 128.3-33.7 81.1-118.9 19.8-97.3-3.3 1.2-6.2 3.4-8.2 6.3 3.6-1.3 7.3-2.3 11-3 31-6.5 75.5 41.5-20.6 91.4zM348 437.4s14.5 11.9-15.9 21.2c-57.9 17.5-240.8 22.8-291.6 .7-18.3-7.9 16-19 26.8-21.3 11.2-2.4 17.7-2 17.7-2-20.3-14.3-131.3 28.1-56.4 40.2 204.2 33.2 372.4-14.9 319.4-38.8zM124.5 396c-78.7 22 47.9 67.4 148.1 24.5-9.8-3.8-19.2-8.4-28.2-13.8-44.7 8.5-65.4 9.1-106 4.5-33.5-3.8-13.9-15.2-13.9-15.2zm179.8 97.2c-78.7 14.8-175.8 13.1-233.3 3.6 0-.1 11.8 9.7 72.4 13.6 92.2 5.9 233.8-3.3 237.1-46.9 0 0-6.4 16.5-76.2 29.7zM260.7 353c-59.2 11.4-93.5 11.1-136.8 6.6-33.5-3.5-11.6-19.7-11.6-19.7-86.8 28.8 48.2 61.4 169.5 25.9-7.8-2.8-15-7.1-21.1-12.8z"],
    "nfc-symbol": [512, 512, [], "e531", "M360.9 32.4c7.7-1.3 15.7 .5 21.2 5 84.1 58.7 129.9 136.3 129.9 217.7 0 83.1-45.8 160.8-129.9 219.5-4.8 4-11.7 5.9-18.6 5.3-7-.6-13.5-3.6-18.4-8.5L161.7 288.7c-5.6-5.5-8.7-13-9.6-20.9 0-7.8 4-15.3 9.5-20.9 5.6-5.5 13.1-8.7 20.9-8.7 7.9 0 15.4 3.1 20.9 8.6L368.5 411.2c54.6-44.7 84.3-99.2 84.3-156.1 0-61.6-36.9-122.2-103.9-169.3-6.4-4.5-10.8-11.4-12.1-19.1-1.4-7.7 .4-15.7 5-22.1 4.5-6.4 11.4-10.8 19.1-12.1zm-206 447.2c-7.7 1.3-15.6-.5-22.1-5-83.1-58.7-129-136.4-129-219.5 0-81.4 45.8-159 129-217.7 5.7-4 12.6-5.9 19.6-5.3 6.9 .6 13.4 3.6 18.3 8.5L354.1 223.3c5.6 5.5 8.7 13 8.7 20.9 .1 6.9-3 15.3-8.6 20.9-5.5 5.5-13 8.7-20.9 8.7-7.8 0-16.2-3.1-20.9-8.6L147.3 100.7c-54.6 45.2-84.3 99.2-84.3 154.4 0 63.4 36.9 124 103.1 171.1 7.3 4.6 11.6 11.4 13 19.2 1.3 7.7-.5 15.7-5 22.1s-11.4 10.7-19.2 12.1z"],
    "wodu": [640, 512, [], "e088", "M178.4 339.7l-37.3 0-28.9-116.2-.5 0-28.5 116.2-38 0-45.2-170.8 37.5 0 27 116.2 .5 0 29.7-116.2 35.2 0 29.2 117.7 .5 0 28-117.7 36.8 0-45.9 170.8zm93-127c39 0 64.1 25.8 64.1 65.3 0 39.2-25.1 65-64.1 65-38.7 0-63.9-25.8-63.9-65 0-39.5 25.1-65.3 63.9-65.3zm0 104.8c23.2 0 30.1-19.9 30.1-39.5 0-19.9-6.9-39.7-30.1-39.7-27.7 0-29.9 19.9-29.9 39.7 0 19.6 6.9 39.5 29.9 39.5zm163.7 6.5l-.5 0c-7.9 13.4-21.8 19.1-37.5 19.1-37.3 0-55.5-32-55.5-66.2 0-33.2 18.4-64.1 54.8-64.1 14.6 0 28.9 6.2 36.8 18.4l.2 0 0-62.2 34 0 0 170.8-32.3 0 0-15.8zm-29.7-85.6c-22.2 0-29.9 19.1-29.9 39.5 0 19.4 8.8 39.7 29.9 39.7 22.5 0 29.2-19.6 29.2-39.9 0-20.1-7.2-39.2-29.2-39.2zM593 339.7l-32.3 0 0-17.2-.7 0c-8.6 13.9-23.4 20.6-37.8 20.6-36.1 0-45.2-20.3-45.2-50.9l0-76.1 34 0 0 69.8c0 20.3 6 30.4 21.8 30.4 18.4 0 26.3-10.3 26.3-35.4l0-64.8 34 0 0 123.6zm9.5-36.8l37.5 0 0 36.8-37.5 0 0-36.8z"],
    "square-steam": [448, 512, ["steam-square"], "f1b7", "M165.6 309.1c18.6 7.7 27.3 28.9 19.6 47.4s-29 27.2-47.6 19.4l-28.5-11.8c5 10.6 13.8 19.4 25.4 24.2 25.2 10.5 54.1-1.4 64.6-26.5 5.1-12.1 5.1-25.5 .1-37.7-5.1-12.1-14.5-21.6-26.7-26.7-12.1-5-25-4.8-36.4-.5l29.5 12.2zM448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 144.7 116.6 48.1c12-8.2 26.2-12.1 40.7-11.3l55.4-80.2 0-1.1c0-48.2 39.3-87.5 87.6-87.5s87.6 39.3 87.6 87.5c0 49.2-40.9 88.7-89.6 87.5l-79 56.3c1.6 38.5-29.1 68.8-65.7 68.8-31.8 0-58.5-22.7-64.5-52.7L0 319.2 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM241.9 196.2a58.4 58.4 0 1 0 116.8 0 58.4 58.4 0 1 0 -116.8 0zm102.4-.1a43.9 43.9 0 1 1 -87.8 0 43.9 43.9 0 1 1 87.8 0z"],
    "creative-commons-nc-eu": [512, 512, [], "f4e9", "M255.7 8C111.6 8 8 124.8 8 256 8 392.3 119.7 504 255.7 504 385.9 504 504 403.1 504 256 504 117 396.4 8 255.7 8zm.6 450.7c-112 0-203.6-92.5-203.6-202.7 0-23.2 3.7-45.2 10.9-66l65.7 29.1-4.7 0 0 29.5 23.3 0c0 6.2-.4 3.2-.4 19.5l-22.8 0 0 29.5 27 0c11.4 67 67.2 101.3 124.6 101.3 26.6 0 50.6-7.9 64.8-15.8l-10-46.1c-8.7 4.6-28.2 10.8-47.3 10.8-28.2 0-58.1-10.9-67.3-50.2l90.3 0 128.3 56.8c-1.5 2.1-56.2 104.3-178.8 104.3zM239.6 268.1l-.5-.4 .9 .4-.4 0zm77.2-19.5l3.7 0 0-29.5-70.3 0-28.6-12.6c2.5-5.5 5.4-10.5 8.8-14.3 12.9-15.8 31.1-22.4 51.1-22.4 18.3 0 35.3 5.4 46.1 10l11.6-47.3c-15-6.6-37-12.4-62.3-12.4-39 0-72.2 15.8-95.9 42.3-5.3 6.1-9.8 12.9-13.9 20.1L85.5 146.4c64.6-96.8 157.7-93.6 170.7-93.6 113 0 203 90.2 203 203.4 0 18.7-2.1 36.3-6.3 52.9L316.8 248.6z"],
    "npm": [576, 512, [], "f3d4", "M288 288l-32 0 0-64 32 0 0 64zM576 160l0 192-288 0 0 32-128 0 0-32-160 0 0-192 576 0zM160 192l-128 0 0 128 64 0 0-96 32 0 0 96 32 0 0-128zm160 0l-128 0 0 160 64 0 0-32 64 0 0-128zm224 0l-192 0 0 128 64 0 0-96 32 0 0 96 32 0 0-96 32 0 0 96 32 0 0-128z"],
    "cloudscale": [448, 512, [], "f383", "M318.1 154l-9.4 7.6c-22.5-19.3-51.5-33.6-83.3-33.6-71.6 0-129.4 60.8-129.4 132.3 0 6.6 .4 13.1 1.4 19.4-2-56 41.8-97.4 92.6-97.4 24.2 0 46.2 9.4 62.6 24.7l-25.2 20.4c-8.3-.9-16.8 1.8-23.1 8.1-11.1 11-11.1 28.9 0 40 11.1 11 28.9 11 40 0 6.3-6.3 9-14.9 8.1-23.1l75.2-88.8c6.3-6.5-3.3-15.9-9.5-9.6zM213.7 246.5a14 14 0 1 1 20.6 19 14 14 0 1 1 -20.6-19zM224 32a224 224 0 1 0 0 448 224 224 0 1 0 0-448zm0 64a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"],
    "themeco": [448, 512, [], "f5c6", "M202.9 8.4c9.9-5.7 26-5.8 36-.2L430 115.9c10 5.6 18 19.4 18 30.9L448 364c0 11.4-8.1 25.3-18 31L238.8 503.7c-9.9 5.7-26 5.6-35.8-.2L17.9 395.1C8 389.3 0 375.4 0 364L0 146.7c0-11.4 8-25.4 17.9-31.1L202.9 8.4zM125.5 208.3c-15.9 0-31.9 .1-47.8 .1l0 101.4 19.1 0 0-29.8 28.7 0c49.7 0 49.6-71.7 0-71.7zM265.6 308.6l-30.7-34.6c37-7.5 34.8-65.2-10.9-65.5-16.1 0-32.2-.1-48.3-.1l0 101.6 19.1 0 0-33.9 18.4 0 29.6 33.9 22.8 0 0-1.3zm-41.6-82.3c23.3 0 23.3 32.5 0 32.5l-29.1 0 0-32.5 29.1 0zm-95.6-1.6c21.2 0 21.1 38.9 0 38.9l-32.3 0 0-38.8 32.3 0zm192.6-18.2c-68.5 0-71 105.8 0 105.8 69.5 0 69.4-105.8 0-105.8zm0 17.4c44.1 0 44.8 70.9 0 70.9s-44.4-70.9 0-70.9z"],
    "google-play": [448, 512, [], "f3ab", "M293.6 234.3L72.9 13 353.7 174.2 293.6 234.3zM15.3 0C2.3 6.8-6.4 19.2-6.4 35.3l0 441.3c0 16.1 8.7 28.5 21.7 35.3L271.9 255.9 15.3 0zM440.5 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-14.3 18-46.5-1.2-60.8zM72.9 499L353.7 337.8 293.6 277.7 72.9 499z"],
    "korvue": [448, 512, [], "f42f", "M387.6 34l-327 0C27.9 34 1.1 60.8 1.1 93.5l0 327.1c0 32.6 26.8 59.4 59.5 59.4l327.1 0c33 0 59.5-26.8 59.5-59.5l0-327C447.1 60.8 420.3 34 387.6 34zM88.2 120.8l96 0 0 116 61.8-116 110.9 0-81.2 132-187.5 0 0-132zM250 392.9l-65.7-113.6 0 113.6-96 0 0-130.8 191.5 0 88.6 130.8-118.4 0z"],
    "w3c": [640, 512, [], "e7de", "M105.2 305.3l30.9-104.7c7.9-26.7 8.6-40.6 .2-68.8l-10.1-33.9 44.1 0 61 207.4 45.7-155.5c13.3-45.3 21.1-51.9 59.4-51.9l132.8 0c-24.2 42.9-49.3 85.2-73.9 127.9 2.6 .8 5.2 1.8 7.7 2.8 17.3 7.1 32.2 19.4 42 35.5 11.2 18.5 16.8 40.2 16.8 65.2 0 30.8-8.2 56.8-24.6 77.8-14.5 18.6-35 29.5-58.2 31.2 0 .3-5.2 .4-5.8 .4-39.7-.1-70.8-32.1-83.1-68.7l42.9 0c3.5 5.3 6.8 10.7 11.2 15.5 8.1 7.3 18.5 10.9 29.3 11.1 13.1 0 23.3-9.1 29.9-19.8 8.1-13.2 12.2-29 12.2-47.5 0-13.1-1.8-24.3-5.3-33.6-.9-2.3-1.9-4.5-3-6.6-1.4-2.6-2.9-5.1-4.7-7.4-10.1-13.2-29.3-19.7-47.5-19.8l-28.2 0 70.3-122-35.6 0c-43.1 0-35.9-5.4-50.4 43.3l-75.7 255.3-4.2 0-63.1-211.1-63.1 211.1-4.2 0-101-340.7 44.2 0 61 207.4zM467 335.7c.3 .6 11.3 20.3 18.3 30.3 7.1 10.1 19.8 20.9 24.8 24.6s19.1 12.5 34.3 13.9c15.2 1.5 23.3 .2 38.7-6.6 15.4-6.8 27.9-20.4 34.9-28.1 6.9-7.6 17.9-27.3 18.2-27.7l3.3 16.8c1.7 9-1 23.7-4.1 30-4.3 8.6-7.6 13.5-14 20.3-6.1 6.5-16.7 13.5-21.3 16.4-4.6 2.9-23.1 15.1-50.1 10.3s-44.7-25.9-53.9-38.2c-9.8-13.2-16.7-28.3-19-33.2-3.8-8.4-9.9-28.2-10.1-28.8zm169.7-218c3.3 20.3-.1 28.7-9.1 46l-12.7 24.2c-.3-.6-10-20.7-25.9-31.9-13.6-9.6-22.5-11.7-36.3-8.8-17.8 3.7-38 25-46.8 51.2-10.5 31.4-10.7 46.6-11 60.6-.6 22.4 2.9 35.6 2.9 35.6s-15.4-28.5-15.2-70.1c.1-29.7 4.8-56.7 18.5-83.3 12.1-23.4 30.1-37.4 46.1-39.1 16.5-1.7 29.6 6.3 39.7 14.9 10.6 9 21.3 28.8 21.3 28.8l24.9-49.8 3.6 21.8z"],
    "grav": [512, 512, [], "f2d6", "M302.6 210.6c4.5 4.5 4.5 12.3 0 16.8l-10 10c-4.5 4.9-12.3 4.9-17.1 0l-10.8-10.8c-4.5-4.9-4.5-12.3 0-17.1l10-10c4.5-4.5 12.3-4.5 17.1 0l10.8 11.1zm-31.2-20.3a7.7 7.7 0 1 0 -10.6-11 7.7 7.7 0 1 0 10.6 11zm-26.8 5.5a7.5 7.5 0 1 0 10.7 10.5 7.5 7.5 0 1 0 -10.7-10.5zM319.4 182c-20.5-14.9-34.9-44.6-12.3-70.3 22.3-25.7 42-17.8 61.7 .8 12.3 11.7 30.2 25.7 17.8 49.8-12.9 24.3-46.6 34.3-67.2 19.7zm49.2-45.9c-9.2-10.3-24.1 7.1-16 16.6 7.6 9.3 33.1 2.5 16-16.6zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm443.7 44c2.6-16.6-20.9-17.1-26-26.5-14-24.9-28.6-38-56.3-31.4 12-8.3 24.3-6.3 24.3-6.3 .3-6.6 0-13.4-9.7-25.7 4-12.9 .3-23.1 .3-23.1 16-8.9 27.7-25.2 30-44.6 3.7-32-19.4-61.1-51.4-64.8-22.8-2.6-45.1 7.9-56.1 26.5-23.9 41.4 1.4 73.2 23.1 84-14.9-1.4-35.4-12.3-41.4-35.4-6.8-26.5 2.9-51.4 9.2-63.4 0 0-4.5-6-8.3-9.2 0 0-14.2 0-25.4 5.5 12.3-15.7 26-14.9 26-14.9 0-6.6-.6-15.4-3.7-22.3-5.6-11.4-24.6-13.3-32.7 2.9 .1-.2 .3-.4 .4-.5-5.2 12.3-1.1 57.7 17.4 90-2.6 1.4-9.4 6.3-13.4 10.3-22.3 10-58 62.2-58 62.2-29.1 11.1-79.7 52.5-72.9 82.3 .3 3.1 1.4 5.7 3.1 7.7-2.9 2.3-5.7 5.2-8.6 8.6-12.3 14.2-5.5 36.3 18.3 25.2 16.3-7.4 30.6-20.9 37.5-31.4 0 0-5.7-5.2-16.8-4.5 28.6-6.8 35.4-9.7 47.7-9.4 8.3 4 8.3-35.4 8.3-35.4 0-15.2-2.3-32-11.5-42.8 12.9 12.6 30 33.8 28.9 62.6-.8 18.9-15.7 23.7-15.7 23.7-9.4 17.1-44.6 68-31.4 109.4 0 0-10-15.4-10.5-22.8-18 20-48 54-25.4 66.6 27.5 15.2 112.3-91.5 130.3-146.9 35.7-21.5 57.2-48.8 66-67.1 22.7 44.9 98.4 97.5 104.4 60.9z"],
    "aws": [640, 512, [], "f375", "M180.4 203c-.7 22.6 10.6 32.7 10.9 39-.1 1.3-.6 2.5-1.3 3.6s-1.7 2-2.8 2.6l-12.8 9c-1.7 1.2-3.6 1.8-5.6 1.9-.4 0-8.2 1.8-20.5-25.6-7.5 9.4-17 16.9-27.9 22s-22.7 7.7-34.7 7.5c-16.3 .9-60.4-9.2-58.1-56.2-1.6-38.3 34.1-62.1 70.9-60 7.1 0 21.6 .4 47 6.3l0-15.6c2.7-26.5-14.7-47-44.8-43.9-2.4 0-19.4-.5-45.8 10.1-7.4 3.4-8.3 2.8-10.8 2.8-7.4 0-4.4-21.5-2.9-24.2 5.2-6.4 35.9-18.4 65.9-18.2 20.1-1.8 40.1 4.4 55.7 17.3 6.3 7.1 11.2 15.4 14.2 24.4s4.2 18.5 3.5 28l0 69.3zM94 235.4c32.4-.5 46.2-20 49.3-30.5 2.5-10.1 2.1-16.4 2.1-27.4-9.7-2.3-23.6-4.9-39.6-4.9-15.2-1.1-42.8 5.6-41.7 32.3-1.2 16.8 11.1 31.4 30 30.5zm170.9 23.1c-7.9 .7-11.5-4.9-12.7-10.4L202.4 83.4c-1-2.8-1.6-5.6-1.9-8.6-.2-1.2 .1-2.4 .8-3.4s1.8-1.6 3-1.8c.2 0-2.1 0 22.2 0 8.8-.9 11.6 6 12.6 10.4L274.9 220.8 308.1 80c.5-3.2 2.9-11.1 12.8-10.2l17.2 0c2.2-.2 11.1-.5 12.7 10.4L384.1 222.7 421 80.1c.5-2.2 2.7-11.4 12.7-10.4l19.7 0c.9-.1 6.2-.8 5.3 8.6-.4 1.8 3.4-10.7-52.8 169.9-1.1 5.5-4.8 11.1-12.7 10.4l-18.7 0c-10.9 1.2-12.5-9.7-12.7-10.7l-33.2-137.1-32.8 137c-.2 1.1-1.7 11.9-12.7 10.7l-18.3 0 0 0zm273.5 5.6c-5.9 0-33.9-.3-57.4-12.3-2.3-1-4.3-2.6-5.7-4.8s-2.1-4.6-2.1-7.1l0-10.7c0-8.5 6.2-6.9 8.8-5.9 10 4.1 16.5 7.1 28.8 9.6 36.7 7.5 52.8-2.3 56.7-4.5 13.2-7.8 14.2-25.7 5.3-34.9-10.5-8.8-15.5-9.1-53.1-21-4.6-1.3-43.7-13.6-43.8-52.4-.6-28.2 25-56.2 69.5-56 12.7 0 46.4 4.1 55.6 15.6 1.4 2.1 2 4.6 1.9 7l0 10.1c0 4.4-1.6 6.7-4.9 6.7-7.7-.9-21.4-11.2-49.2-10.8-6.9-.4-39.9 .9-38.4 25-.4 19 26.6 26.1 29.7 26.9 36.5 11 48.6 12.8 63.1 29.6 17.1 22.2 7.9 48.3 4.3 55.4-19.1 37.5-68.4 34.4-69.3 34.4zm40.2 104.9c-70 51.7-171.7 79.2-258.5 79.2-117.1 .8-230.3-42.3-317.3-120.7-6.5-5.9-.8-14 7.2-9.5 96.5 55.2 205.7 84.2 316.9 84.1 83-.4 165.1-17.3 241.6-49.5 11.8-5 21.8 7.8 10.1 16.4zm29.2-33.3c-9-11.5-59.3-5.4-81.8-2.7-6.8 .8-7.9-5.1-1.8-9.5 40.1-28.2 105.9-20.1 113.4-10.6 7.5 9.5-2.1 75.4-39.6 106.9-5.8 4.9-11.3 2.3-8.7-4.1 8.4-21.3 27.4-68.5 18.4-80z"],
    "glide-g": [448, 512, [], "f2a6", "M407.1 211.2c-3.5-1.4-11.6-3.8-15.4-3.8-37.1 0-62.2 16.8-93.5 34.5l-.9-.9c7-47.3 23.5-91.9 23.5-140.4 0-71.5-38.2-100.6-108.4-100.6-115.1 0-173.4 113.7-173.4 198.4 0 87.9 51.3 136.6 138.6 136.6 12 0 11-1 11 3.8-16.9 128.9-90.8 133.1-90.8 94.6 0-39.2 45-58.6 45.5-61-.3-12.2-47-27.6-58.9-27.6-33.9 .1-52.4 51.2-52.4 79.3 0 51.9 32.8 87.9 85.5 87.9 77.4 0 134-77.8 151.4-145.4 15.1-60.5 11.2-63.3 19.7-67.6 32.2-16.2 57.5-27 93.8-27 17.8 0 30.5 3.7 58.9 8.4 2.9 0 6.7-2.9 6.7-5.8 0-8-33.4-60.5-40.9-63.4zM231.8 126.8c-9.3 44.7-18.6 89.6-27.8 134.3-2.3 10.2-13.3 7.8-22 7.8-38.3 0-49-41.8-49-73.1 0-47 18-109.3 61.8-133.4 7-4.1 14.8-6.7 22.6-6.7 18.6 0 20 13.3 20 28.7-.1 14.3-2.7 28.5-5.6 42.4z"],
    "jsfiddle": [576, 512, [], "f1cc", "M511.1 237.5c-4.7-2.6-5.7-5.7-6.4-10.8-2.4-16.5-3.5-33.6-9.1-49.1-35.9-100-154-143.4-246.8-91.6-27.4 15.2-49 36.4-65.5 63.9-3.2-1.5-5.5-2.7-7.8-3.7-30.1-12.4-59-10.1-85.3 9.2-25.5 18.7-36.4 44.5-32.7 76.4 .4 3-2 7.6-4.5 9.5-39.7 30-56 78.1-41.9 124.6 13.8 45.6 57.5 79.8 105.6 81.4 30.3 1 60.6 .5 91 .5 84 0 168.1 .5 252.1-.5 52.7-.6 96.1-36.9 108.2-87.3 11.5-48.1-11.1-97.3-56.8-122.6zm21.1 156.9c-18.2 22.4-42.3 35.3-71.3 35.7-56.9 .8-113.8 .2-170.7 .2 0 .7-163 .2-163.7 .2-43.9-.3-76.7-19.8-95.2-60-18.9-41.2-4-90.8 34.2-116.1 9.2-6.1 12.5-11.6 10.1-23.1-5.5-26.4 4.5-48 26.4-63 23-15.7 47.4-16.1 72-3.1 10.3 5.4 14.6 11.6 22.2-2.5 14.2-26.4 34.6-46.7 60.7-61.3 97.5-54.4 228.4 7.6 230.2 132.7 .1 8.2 2.4 12.4 9.8 15.9 57.6 26.8 74.5 96.1 35.1 144.5zm-87.8-80.5c-5.8 31.2-34.6 55.1-66.7 55.1-17 0-32.1-6.5-44.1-17.7-27.7-25.7-71.1-75-95.9-93.4-20.1-14.9-42-12.3-60.3 3.8-50 44.1 15.9 121.8 67.1 77.2 4.5-4 7.8-9.5 12.7-12.8 8.2-5.5 20.8-.9 13.2 10.6-17.4 26.3-49.3 38.2-78.9 29.3-28.9-8.7-48.8-36-48.6-70.2 1.2-22.5 12.4-43.1 35.4-56 22.6-12.6 46.4-13.1 67 2.5 50.8 38.5 75.6 81.7 107.3 101.2 24.6 15.1 54.3 7.4 68.8-17.5 28.8-49.2-34.6-105-78.9-63.5-4 3.7-6.9 8.9-11.4 11.7-11 6.8-17.3-4.1-12.8-10.4 20.7-28.6 50.5-40.4 83.3-28.2 31.4 11.7 49.1 44.4 42.8 78.2z"],
    "keybase": [448, 512, [], "f4f5", "M286.2 419a18 18 0 1 0 0 36 18 18 0 1 0 0-36zM398.1 271.4c-9.5-14.6-39.4-52.4-87.3-73.7-6.1-2.7-12.2-5.1-18.4-7.3 4.1-9.9 6-20.6 5.8-31.4s-2.7-21.3-7.2-31.1-10.9-18.5-18.9-25.7-17.4-12.6-27.6-16c-12.4-4.1-23.3-6-32.4-5.8-.6-2-1.9-11 9.4-35l-22.9-13.5-5.5 7.6c-8.7 12.1-16.9 23.6-24.3 34.9-2.7-.6-5.5-1.1-8.3-1.2-41.5-2.4-39-2.3-41.1-2.3-50.6 0-50.8 52.1-50.8 45.9l-2.4 36.7c-1.6 27 19.8 50.2 47.6 51.8l8.9 .5C106 215.5 90.4 227.5 76.6 241.4 14 304.7 14 374 14 429.8l0 33.6 23.3-29.8c3.1 13.1 8 25.8 14.6 37.6 5.8 10.1 14.9 9.4 19.6 7.3 4.2-1.9 10-6.9 3.8-20.1-8-16.8-13.3-34.7-15.8-53.1l46.8-59.8-24.7 74.1c58.2-42.4 157.4-61.8 236.2-38.6 34.2 10.1 67.4 .7 84.7-23.8 .7-1 1.2-2.2 1.8-3.2 1.8 9.4 2.7 18.9 2.8 28.4 0 23.3-3.7 52.9-14.9 81.6-2.5 6.5 1.8 14.5 8.6 15.7 7.4 1.6 15.3-3.1 18.4-11.1 9.6-25.5 14.6-54.6 14.6-86.2 0-38.6-13-77.5-35.9-110.9zM142.4 128.6l-15.7-.9-1.4 21.8 13.1 .8c-.6 6.5-.5 13.1 .3 19.6l-22.4-1.3c-1.6-.1-3.2-.5-4.7-1.1s-2.8-1.6-3.9-2.8-1.9-2.6-2.5-4.1-.8-3.1-.7-4.7L107 119c1-12.2 13.9-11.3 13.3-11.3l29.1 1.7c-2.8 6.2-5.1 12.6-7 19.2zM290.8 300.8c-2.1 1.6-4.8 2.4-7.5 2.2s-5.1-1.5-6.9-3.5l-9.7-11.5-34.4 27c-1.6 1.3-3.7 1.9-5.8 1.7s-4-1.2-5.3-2.8l-15.8-18.6c-1.2-1.6-1.7-3.5-1.5-5.4s1.3-3.7 2.8-4.9l34.6-27.2-14.1-16.7-17.1 13.5c-1.6 1.2-3.5 1.8-5.5 1.6s-3.8-1.1-5.1-2.6c0 0-3.7-4.4-3.8-4.5-1.2-1.6-1.7-3.5-1.5-5.5s1.3-3.7 2.8-4.9L214 225.2s-18.5-22-18.6-22.1c-.8-1-1.3-2.1-1.7-3.3s-.4-2.5-.3-3.7 .6-2.4 1.2-3.5 1.5-2 2.5-2.8c2.1-1.7 4.8-2.4 7.4-2.2s5.1 1.5 6.9 3.6l81.1 96.3c.8 1 1.3 2.1 1.7 3.3s.4 2.5 .3 3.7-.6 2.5-1.2 3.5-1.5 2.1-2.5 2.8zM187.4 419a18 18 0 1 0 0 36 18 18 0 1 0 0-36z"],
    "lumon-drop": [576, 512, [], "e7e3", "M480 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96L96 448c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l384 0zM302.4 114.7c-9.8-16.4-20.5-16.4-29.6 0l-68.9 114c-10.7 15.6-16.4 32.8-16.4 52.5 0 50.9 44.3 94.3 100.1 94.3 55 0 100.9-43.5 100.9-94.3 0-19.7-6.6-37.8-17.2-52.5l-68.9-114z"],
    "weebly": [512, 512, [], "f5cc", "M425.1 65.8c-39.9 0-73.3 25.7-83.7 64.3-18.2-58.1-65.5-64.3-85-64.3-19.8 0-66.8 6.3-85.3 64.3-10.4-38.6-43.4-64.3-83.7-64.3-49 0-87.5 33.9-87.5 77.2 0 29 4.2 33.3 77.2 233.5 22.4 60.6 67.8 69.4 92.7 69.4 39.2 0 70-19.5 85.9-54 15.9 34.8 46.7 54.3 85.9 54.3 25 0 70.4-9.1 92.7-69.7 76.6-208.6 77.5-205.6 77.5-227.2 .6-48.3-36-83.5-86.9-83.5zm26.3 114.8L385.9 357.1c-7.9 21.5-21.2 37.2-46.2 37.2-23.4 0-37.4-12.4-44-33.9l-39.3-117.4-1 0-39.3 117.4c-7 21.5-20.9 33.6-44 33.6-25 0-38.3-15.7-46.2-37.2L60.9 181.6c-5.4-14.8-7.9-23.9-7.9-34.5 0-16.3 15.8-29.4 38.3-29.4 18.7 0 32 11.8 36.1 29.1l44 139.8 1 0 44.7-136.8c6-19.7 16.5-32.1 39-32.1s32.9 12.1 39 32.1l44.7 136.8 1 0 44-139.8c4.1-17.2 17.4-29.1 36.1-29.1 22.2 0 38.3 13.3 38.3 35.7-.3 7.9-4.1 16-7.6 27.2z"],
    "docker": [640, 512, [], "f395", "M349.9 236.3l-66.1 0 0-59.4 66.1 0 0 59.4zm0-204.3l-66.1 0 0 60.7 66.1 0 0-60.7zm78.2 144.8l-66.1 0 0 59.4 66.1 0 0-59.4zM271.8 104.7l-66.1 0 0 60.1 66.1 0 0-60.1zm78.1 0l-66.1 0 0 60.1 66.1 0 0-60.1zm276.8 100c-14.4-9.7-47.6-13.2-73.1-8.4-3.3-24-16.7-44.9-41.1-63.7l-14-9.3-9.3 14c-18.4 27.8-23.4 73.6-3.7 103.8-8.7 4.7-25.8 11.1-48.4 10.7l-434.7 0c-8.7 50.8 5.8 116.8 44 162.1 37.1 43.9 92.7 66.2 165.4 66.2 157.4 0 273.9-72.5 328.4-204.2 21.4 .4 67.6 .1 91.3-45.2 1.5-2.5 6.6-13.2 8.5-17.1l-13.3-8.9zM115.6 176.8l-66 0 0 59.4 66.1 0 0-59.4-.1 0zm78.1 0l-66.1 0 0 59.4 66.1 0 0-59.4zm78.1 0l-66.1 0 0 59.4 66.1 0 0-59.4zm-78.1-72.1l-66.1 0 0 60.1 66.1 0 0-60.1z"],
    "magento": [448, 512, [], "f3c4", "M445.9 127.9l0 256.1-63.4 36.5 0-255.8-158.5-91.6-158.6 91.6 .4 255.9-63.3-36.6 0-255.9 221.9-128.1 221.5 127.9zM255.8 420.5l-31.6 18.4-31.8-18.2 0-256-63.3 36.6 .1 255.9 94.9 54.9 95.1-54.9 0-256-63.4-36.6 0 255.9z"],
    "git-alt": [448, 512, [], "f841", "M439.6 236.1L244 40.5C238.6 35 231.2 32 223.6 32s-15 3-20.4 8.4l-40.7 40.6 51.5 51.5c27.1-9.1 52.7 16.8 43.4 43.7l49.7 49.7c34.2-11.8 61.2 31 35.5 56.7-26.5 26.5-70.2-2.9-56-37.3l-46.3-46.3 0 121.9c25.3 12.5 22.3 41.8 9.1 55-6.4 6.4-15.2 10.1-24.3 10.1s-17.8-3.6-24.3-10.1c-17.6-17.6-11.1-46.9 11.2-56l0-123c-20.8-8.5-24.6-30.7-18.6-45L142.6 101 8.5 235.1C3 240.6 0 247.9 0 255.5s3 15 8.5 20.4L204.1 471.6c5.4 5.4 12.7 8.4 20.4 8.4s15-3 20.4-8.4L439.6 276.9c5.4-5.4 8.4-12.8 8.4-20.4s-3-15-8.4-20.4z"],
    "firefox-browser": [512, 512, [], "e007", "M130.2 127.5l0 0zm351.4 45.4c-10.6-25.5-32.1-53-48.9-61.7 13.7 26.9 21.7 53.9 24.7 74 0 .1 0 .3 .1 .4-27.6-68.8-74.4-96.5-112.6-156.8-15-23.7-10.9-25.2-13.1-24.7l-.1 .1c-46.7 26-75.3 78.4-82.6 122.7-16.6 .9-32.9 5-47.9 12.1-1.4 .6-2.5 1.7-3.1 3s-.9 2.8-.6 4.3c.2 .8 .6 1.6 1.1 2.3s1.2 1.3 1.9 1.7 1.6 .7 2.4 .8 1.7 0 2.5-.3l.5-.2c15.5-7.3 32.4-11.2 49.5-11.3 62.8-.6 97.2 44 107.6 62.3-13-9.2-36.4-18.2-58.8-14.3 87.7 43.9 64.2 194.5-57.4 189.2-59.5-2.6-97.1-51-100.5-90.8 0 0 11.2-41.9 80.6-41.9 7.5 0 28.9-20.9 29.3-27-.1-2-42.5-18.9-59.1-35.2-8.8-8.7-13.1-12.9-16.8-16.1-2-1.7-4.1-3.3-6.3-4.8-5.6-19.5-5.8-40-.7-59.6-25.1 11.4-44.6 29.4-58.7 45.4l-.1 0c-9.7-12.2-9-52.6-8.4-61.1-.1-.5-7.2 3.7-8.2 4.3-8.6 6.1-16.5 12.9-23.8 20.4-16.3 16.6-44.1 50.2-55.5 101.2-4.5 20.4-6.8 44.4-6.8 52.3 0 134.7 109.2 243.9 243.9 243.9 120.6 0 223-87.2 240.4-202.6 11.6-76.7-14.7-131.1-14.7-132z"],
    "cloudsmith": [512, 512, [], "f384", "M512 227.6L512 284.5 284.4 512 227.6 512 0 284.4 0 227.6 227.6 0 284.5 0 512 227.6zm-256 162c17.8 .5 35.6-2.6 52.2-9.1s31.8-16.2 44.6-28.7 23-27.3 29.9-43.8 10.5-34.1 10.5-52-3.6-35.5-10.5-52-17.1-31.3-29.9-43.8-28-22.2-44.6-28.7-34.4-9.6-52.2-9.1c-17.8-.5-35.6 2.6-52.2 9.1s-31.8 16.3-44.6 28.7-23 27.3-29.9 43.8-10.5 34.1-10.5 52 3.6 35.5 10.5 52 17.1 31.3 29.9 43.8 28 22.2 44.6 28.7 34.4 9.6 52.2 9.1z"],
    "wizards-of-the-coast": [640, 512, [], "f730", "M219.2 345.7c-1.9 1.4-11.1 8.4-.3 23.6 4.6 6.4 14.1 12.8 21.7 6.6 6.5-4.9 7.4-12.9 .3-23-5.5-7.8-14.3-12.9-21.7-7.1zm336.8 75.9c-.3 1.7-.6 1.7 .8 0 2.1-4.2 4.2-10.2 5-19.9 3.1-38.5-40.3-71.5-101.3-78-54.7-6-124.4 9.2-188.8 60.5l-.3 1.6c2.6 5 5 10.7 3.4 21.2l.8 .3c63.9-58.4 131.2-77.2 184.4-73.8 58.4 3.7 100 34 100 68.1 0 10-2.6 15.7-3.9 20.2zM392.3 240.4c.8 7.1 4.2 10.2 9.2 10.5 5.5 .3 9.4-2.6 10.5-6.6 .8-3.4 2.1-29.8 2.1-29.8S402.8 221 399.1 225c-3.7 3.7-7.3 8.4-6.8 15.5zm-50-151.1c-204.5 0-329.2 137.5-341.5 151.9-1 .5-1.3 .8 .8 1.3 60.5 16.5 155.8 81.2 196.1 202.2l1 .3c55.2-69.9 140.9-128.1 237-128.1 80.9 0 130.2 42.2 130.2 80.4 0 18.3-6.6 33.5-22.3 46.3 0 1-.2 .8 .8 .8 14.7-10.7 27.5-28.8 27.5-48.2 0-22.8-12.1-38.2-12.1-38.2 7.1 7.1 10.7 16.2 10.7 16.2 5.8-40.9 27-62.3 27-62.3-2.4-9.7-6.8-17.8-6.8-17.8 7.6 8.1 14.4 27.5 14.4 41.4 0 10.5-3.4 22.8-12.6 31.9l.3 .5c8.1-5 16.5-16.8 16.5-38 0-15.7-4.7-25.9-4.7-25.9 5.8-5.2 11.3-9.2 16-11.8 .8 3.4 2.1 9.7 2.4 14.9 0 1 .8 1.8 1 0 .8-5.8-.3-16.2-.3-16.5 6-3.1 9.7-4.5 9.7-4.5-15.7-110.3-144-196.9-291.2-196.9zM243 378.9c-11.1 9-24.2 4.1-30.6-4.2-7.4-9.6-6.8-24.1 4.2-32.5 14.8-11.4 27.1-.5 31.2 5.5 .3 .4 12.1 16.6-4.7 31.2zm2.1-136.4l9.4-17.8 11.8 71-12.6 6-24.6-28.8 14.1-26.7 3.7 4.4-1.8-8.1zm18.6 117.6l-.3-.3c2-4.1-2.5-6.6-17.5-31.7-1.3-2.4-3.1-2.9-4.4-2.6l-.3-.5c7.9-5.8 15.4-10.2 25.4-15.7l.5 .3c1.3 1.8 2.1 2.9 3.4 4.7l-.3 .5c-1-.3-2.4-.8-5.2 .3-2.1 .8-7.9 3.7-12.3 7.6l0 1.3c1.6 2.4 3.9 6.6 5.8 9.7l.3 0c10-6.3 7.6-4.5 11.5-7.9l.3 0c.5 1.8 .5 1.8 1.8 5.5l-.3 .3c-3.1 .6-4.7 .3-11.5 5.5l0 .3c9.5 17 11 16.8 12.6 16l.3 .3c-2.3 1.6-6.3 4.2-9.7 6.6zM319 327.6c-3.1 1.6-6 2.9-10 5l-.3-.3c1.3-2.6 1.2-2.7-11.8-32.5l-.3-.3c-.2 0-8.9 3.7-10 7.3l-.5 0-1-5.8 .3-.5c7.3-4.6 25.5-11.6 27.8-12.6l.5 .3 3.1 5-.3 .5c-3.5-1.8-7.4 .8-12.3 2.6l0 .3c12.3 32 12.7 30.6 14.7 30.6l0 .2zm44.8-16.5c-4.2 1-5.2 1.3-9.7 2.9l-.3-.3 .5-4.5c-1-3.4-3.1-11.5-3.7-13.6l-.3-.3c-3.4 .8-8.9 2.6-12.8 3.9l-.3 .3c.8 2.6 3.1 9.9 4.2 13.9 .8 2.4 1.8 2.9 2.9 3.1l0 .5c-3.7 1-7.1 2.6-10.2 3.9l-.3-.3c1-1.3 1-2.9 .3-5-1-3.1-8.1-23.8-9.2-27.2-.5-1.8-1.6-3.1-2.6-3.1l0-.5c3.1-1 6-2.1 10.7-3.4l.3 .3-.3 4.7c1.3 3.9 2.4 7.6 3.1 9.7l.3 0c3.9-1.3 9.4-2.9 12.8-3.9l.3-.3-2.6-9.4c-.5-1.8-1-3.4-2.6-3.9l0-.3c4.4-1 7.3-1.8 10.7-2.4l.3 .3c-1 1.3-1 2.9-.5 4.4 1.6 6.3 4.7 20.4 6.3 26.5 .5 2.6 1.8 3.4 2.6 3.9zm32.2-6.8l-.3 .3c-4.7 .5-14.1 2.4-22.5 4.2l-.3-.3 .8-4.2c-1.6-7.9-3.4-18.6-5-26.2-.3-1.8-.8-2.9-2.6-3.7l.8-.5c9.2-1.6 20.2-2.4 24.9-2.6l.3 .3c.5 2.4 .8 3.1 1.6 5.5l-.3 .3c-1.1-1.1-3.3-3.2-16.2-.8l-.3 .3c.3 1.6 1 6.6 1.6 9.9l.3 .3c9.5-1.7 4.8-.1 10.7-2.4l.3 0c0 1.6-.3 1.8-.3 5.2l-.3 0c-4.8-1-2.2-.9-10.2 0l-.3 .3c.3 2.1 1.6 9.4 2.1 12.6l.3 .3c1.2 .4 14.2-.6 16.2-4.7l.3 0c-.5 2.4-1 4.2-1.6 6zm10.7-44.5c-4.5 2.4-8.1 2.9-11 2.9-.2 0-11.4 1.1-17.5-10-6.7-10.8-1-25.2 5.5-31.7 8.8-8.1 23.4-10.1 28.5-17 8-10.3-13-22.3-29.6-5.8l-2.6-2.9 5.2-16.2c25.6-1.6 45.2-3 50 16.2 .8 3.1 0 9.4-.3 12.1 0 2.6-1.8 18.8-2.1 23-.5 4.2-.8 18.3-.8 20.7 .3 2.4 .5 4.2 1.6 5.5 1.6 1.8 5.8 1.8 5.8 1.8l-.8 4.7c-11.8-1.1-10.3-.6-20.4-1-3.2-5.1-2.2-3.3-4.2-7.9 0 0-4.2 3.9-7.3 5.5zM443.9 281c-6.4-10.6-19.8-7.2-21.7 5.5-2.6 17.1 14.3 19.8 20.7 10.2l.3 .3c-.5 1.8-1.8 6-1.8 6.3l-.5 .5c-10.3 6.9-28.5-2.5-25.7-18.6 1.9-10.9 14.4-18.9 28.8-9.9l.3 .5c0 1.1-.3 3.4-.3 5.3zm5.8-87.7l0-6.6c.7 0 19.6 3.3 27.8 7.3l-1.6 17.5s10.2-9.4 15.4-10.7c5.2-1.6 14.9 7.3 14.9 7.3l-11.3 11.3c-12.1-6.4-19.6-.1-20.7 .8-5.3 38.7-8.6 42.2 4.4 46.1l-.5 4.7c-17.6-4.3-18.5-4.5-36.9-7.3l.8-4.7c7.3 0 7.5-5.3 7.6-6.8 0 0 5-53.2 5-55.3 0-2.9-5-3.7-5-3.7zm11 114.4c-8.1-2.1-14.1-11-10.7-20.7 3.1-9.4 12.3-12.3 18.9-10.2 9.2 2.6 12.8 11.8 10.7 19.4-2.6 8.9-9.4 13.9-18.9 11.5zm42.2 9.7c-2.4-.5-7.1-2.4-8.6-2.9l0-.3 1.6-1.8c.6-8.2 .6-7.3 .3-7.6-4.8-1.8-6.7-2.4-7.1-2.4-1.3 1.8-2.9 4.5-3.7 5.5l-.8 3.4 0 .3c-1.3-.3-3.9-1.3-6-1.6l0-.3 2.6-1.8c3.4-4.7 10-14.1 13.9-20.2l0-2.1 .5-.3c2.1 .8 5.5 2.1 7.6 2.9 .5 .5 .2-1.9-1 25.1-.2 1.8 0 2.6 .8 3.9zm-4.7-89.8c11.3-18.3 30.8-16.2 34-3.4l7.6-26.2c2.3-6.2-2.8-9.9-4.5-11.3l1.8-3.7c12.2 10.4 16.4 14 22.5 20.4-25.9 73.1-30.8 80.8-24.6 84.3l-1.8 4.4c-6.4-3.3-8.9-4.4-17.8-8.6l2.1-6.8c-.3-.3-3.9 3.9-9.7 3.7-19.1-1.3-22.9-31.7-9.7-52.9zm29.3 79.3c0-5.7-6.3-7.9-7.9-5.2-1.3 2.1 1 5 2.9 8.4 1.6 2.6 2.6 6.3 1 9.4-2.6 6.3-12.4 5.3-15.4-.8 0-.7-.3 .1 1.8-4.7l.8-.3c-.6 5.7 6.1 9.6 8.4 5 1-2.1-.5-5.5-2.1-8.4-1.6-2.6-3.7-6.3-1.8-9.7 2.7-5.1 11.3-4.5 14.7 2.4l0 .5-2.4 3.4zm21.2 13.4c-2-3.3-.9-2.1-4.5-4.7l-.3 0c-2.4 4.2-5.8 10.5-8.6 16.2-1.3 2.4-1 3.4-.8 3.9l-.3 .3-5.8-4.4 .3-.3 2.1-1.3c3.1-5.8 6.6-12.1 9.2-17l0-.3c-2.6-2-1.2-1.5-6-1.8l0-.3 3.1-3.4 .3 0c3.7 2.4 10 6.8 12.3 8.9l.3 .3-1.3 3.9zM575.8 276l-2.9-2.9c.8-2.4 1.8-5 2.1-7.6 .7-9.7-11.5-11.8-11.5-5 0 5 7.9 19.4 7.9 27.8 0 10.2-5.8 15.7-13.9 16.5-8.4 .8-20.2-10.5-20.2-10.5l5-14.4 2.9 2.1c-3 17.8 17.7 20.4 13.3 5.2-1.1-4-18.7-34.2 2.1-38.2 13.6-2.4 23 16.5 23 16.5L575.8 276zm35.6-10.2c-11-30.4-60.5-127.5-192-129.6-53.4-1-94.3 15.4-132.8 38l85.6-9.2-91.4 20.7 25.1 19.6-3.9-16.5c7.5-1.7 39.1-8.5 66.8-8.9l-22.3 80.4c13.6-.7 19-9 19.6-22.8l5-1 .3 26.7c-22.5 3.2-37.3 6.7-49.5 9.9l13.1-43.2-61.5-36.7 2.4 8.1 10.2 5c6.3 18.6 19.4 56.6 20.4 58.7 2 4.3 3.2 5.8 12 4.5l1.1 5c-16.1 4.9-23.7 7.6-39 14.4l-2.4-4.7c4.4-2.9 8.7-3.9 5.5-12.8-23.7-62.5-21.5-58.1-22.8-59.4l2.4-4.4 33.5 67.3c-3.8-11.9 1.7 1.7-33-78.8l-41.9 88.5 4.7-13.9-35.9-42.2 27.8 93.5-11.8 8.4c-111.9-101.7-105.8-98.4-113.7-98.7-5.5-.3-13.6 5.5-13.6 5.5l-5-6c30.6-23.5 31.6-24.3 58.4-42.7l4.2 7.1s-5.8 4.2-7.9 7.1c-5.9 9.3 1.7 13.3 61.8 75.7l-18.8-58.9 39.8-10.2 25.7 30.6 4.4-12.3-5-24.6 13.1-3.4 .5 3.1 3.7-10.5-94.3 29.3 11.3-5-13.6-42.4 17.3-9.2 30.1 36.1 28.5-13.1c-1.4-7.5-2.5-14.5-4.7-19.6l17.3 13.9 4.7-2.1-59.2-42.7 23.1 11.5c19-6.1 25.2-7.5 32.2-9.7l2.6 11c-12.6 12.6 1.4 16.8 6.5 19.4l-13.6-61 12 28.3c4.2-1.3 7.3-2.1 7.3-2.1l2.6 8.6s-3.1 1-6.3 2.1l8.9 21 33.8-65.7-20.7 61c42.4-24.1 81.4-36.7 132-35.9 67 1 167.3 40.8 199.8 139.8 .8 2.1 0 2.6-.8 .3zm-408-113.4s1.8-.5 4.2-1.3l9.4 7.6c-.4 0-3.4-.3-11.3 2.4l-2.4-8.6zm143.8 38.5c-1.6-.6-26.5-4.8-33.3 20.7l21.7 17 11.5-37.7zM318.4 67.1c-58.4 0-106.1 12-115 14.4l0 .8c8.4 2.1 14.4 4.2 21.2 11.8l1.6 .3c6.6-1.8 49-13.9 110.2-13.9 180.2 0 301.7 116.8 301.7 223.4l0 10c0 1.3 .8 2.6 1.1 .5 .5-2.1 .8-8.6 .8-19.6 .3-83.8-96.6-227.6-321.6-227.6zM529.5 236.8c1.3-5.8 0-12.3-7.3-13.1-9.6-1.1-16.1 23.8-17 33.5-.8 5.5-1.3 14.9 6 14.9 4.7 0 9.7-.9 18.3-35.4zM468 279.7c-2.6-.8-9.4-.8-12.6 10.5-1.8 6.8 .5 13.4 6 14.7 3.7 1.1 8.9 .5 11.8-10.7 2.6-9.9-1.8-13.6-5.2-14.4zm23 21c1.8 .5 3.1 1 5.8 1.8 0-1.8 .5-8.4 .8-12.1-1 1.3-5.5 8.1-6.6 10l0 .3z"],
    "creative-commons-nd": [512, 512, [], "f4eb", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm94 144.3l0 42.5-180.3 0 0-42.5 180.3 0zm0 79.8l0 42.5-180.3 0 0-42.5 180.3 0z"],
    "usps": [512, 512, [], "f7e1", "M428.3 241.7c25.8-41.3 15.2-48.8-11.7-48.8l-27 0c-.1 0-1.5-1.4-10.9 8-11.2 5.6-37.9 6.3-37.9 8.7 0 4.5 70.3-3.1 88.1 0 9.5 1.5-1.5 20.4-4.4 32-.5 4.5 2.4 2.3 3.8 .1zM316.2 264.3c64-21.3 97.3-23.9 102-26.2 4.4-2.9-4.4-6.6-26.2-5.8-51.7 2.2-137.6 37.1-172.6 53.9l-30.7-93.3 196.6 0c-2.7-28.2-152.9-22.6-337.9-22.6L-5 415.8c196.4-97.3 258.9-130.3 321.2-151.5zM62.7 96c253.3 53.7 330 65.7 332.1 85.2 36.4 0 45.9 0 52.4 6.6 21.1 19.7-14.6 67.7-14.6 67.7-4.4 2.9-406.4 160.2-406.4 160.2L449.3 415.7 517 96 62.7 96z"],
    "square-letterboxd": [448, 512, [], "e62e", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM105.1 187C66.4 187 35 218.3 35 257s31.4 70 70.1 70c24.8 0 46.5-12.8 59-32.2l.5-.7-.4-.6c-6.5-10.6-10.2-23.1-10.2-36.5 0-13.6 3.9-26.3 10.6-37.1-12.4-19.8-34.4-32.9-59.5-32.9zM224 187c-24.8 0-46.5 12.8-59 32.2l-.5 .7 .4 .6c6.5 10.6 10.2 23.1 10.2 36.5 0 13.6-3.9 26.3-10.6 37.1 12.4 19.7 34.4 32.9 59.5 32.9 24.8 0 46.5-12.8 59-32.2l.5-.7-.4-.6c-6.5-10.6-10.2-23.1-10.2-36.5 0-13.6 3.9-26.3 10.6-37.1-12.4-19.7-34.4-32.9-59.5-32.9zm118.9 0c-24.8 0-46.5 12.8-59 32.2l-.5 .7 .4 .6c6.5 10.6 10.2 23.1 10.2 36.5 0 13.6-3.9 26.3-10.6 37.1 12.4 19.8 34.4 32.9 59.5 32.9 38.7 0 70.1-31.3 70.1-70s-31.4-70-70.1-70z"],
    "mandalorian": [384, 512, [], "f50f", "M200.6 511.9c-1-3.3-1.7-15.8-1.4-24.6 .6-15.9 1-24.7 1.4-28.8 .6-6.2 2.9-20.7 3.3-21.4 .6-1 .4-27.9-.2-33.1-.3-2.6-.6-11.9-.7-20.7-.1-16.5-.5-20.1-2.7-24.8-1.1-2.3-1.2-3.8-1-11.4 .2-4.2 .1-8.5-.3-12.7-2-13-3.5-27.7-3.2-33.9s.4-7.1 2.1-9.7c3.1-4.7 6.5-14 8.6-23.3 2.3-9.9 3.9-17.2 4.6-20.7 1.1-5.1 2.6-10.1 4.4-15.1 2.3-6.2 2.5-15.4 .4-15.4-.3 0-1.4 1.2-2.4 2.7s-4.8 4.8-8.3 7.4c-8.4 6.1-11.7 9.4-12.7 12.6s-1 7.2-.2 7.8c.3 .2 1.3 2.4 2.1 4.9 1.6 5 1.9 10.3 .7 15.4-.4 1.8-1 5.5-1.5 8.2s-1 6.5-1.3 8.2c-.2 1.5-.7 3-1.5 4.3-1 1-1.1 .9-2.1-.5-.7-1.5-1.2-3.1-1.4-4.7-.2-1.7-1.6-7.1-3.1-11.9-3.3-10.9-3.5-16.2-1-21 .8-1.4 1.4-3 1.7-4.6 0-2.4-2.2-5.3-7.4-9.9-7-6.2-8.6-7.9-10.2-11.3-1.7-3.6-3.1-4.1-4.5-1.5-1.8 3-2.6 9.1-3 22l-.3 12.2 2 2.2c3.2 3.7 12.1 16.5 13.8 19.8 3.4 6.7 4.3 11.7 4.4 23.6s1 22.8 2 24.7c.4 .7 .5 1.4 .3 1.5s.4 2.1 1.3 4.3c1 2.9 1.7 5.9 2.1 9 .4 3.5 .9 7 1.7 10.4 2.2 9.6 2.8 14.1 2.4 20.1-.2 3.3-.5 11.1-.7 17.3-1.3 41.8-1.8 58-2 61.2-.1 2-.4 11.5-.6 21.1-.4 16.3-1.3 27.4-2.4 28.6-.6 .7-8.1-4.9-12.5-9.5-3.8-3.9-4-4.8-2.8-9.9 .7-3 2.3-18.3 3.3-32.6 .4-4.8 .8-10.5 1-12.7 .8-9.4 1.7-20.3 2.6-34.8 .6-8.5 1.3-16.4 1.7-17.7s.9-9.9 1.1-19.1l.4-16.8-2.3-4.3c-1.7-3.3-4.9-6.9-13.2-15.3-6-6.1-11.8-12.3-12.9-13.8l-2-2.8 .8-10.9c1.1-15.7 1.1-48.6 0-59.1l-.9-8.7-3.3-4.5c-5.9-8.1-5.8-7.7-6.2-33.3-.1-6.1-.4-11.5-.6-12.1-.8-1.9-3-2.7-8.5-3-8.9-.6-11-1.9-23.8-14.6-6.2-6-12.3-12-13.8-13.2-2.8-2.4-2.8-2-.6-9.6l1.4-4.6-1.7-3c-.8-1.4-1.6-2.8-2.6-4.1-1.3-1.5-5.5-10.9-6-13.5-.2-.7-.2-1.4-.1-2.1s.5-1.3 .9-1.8c2.2-2.9 3.4-5.7 4.5-10.7 2.3-11.2 7.7-26.1 10.6-29.2 3.2-3.5 7.7-1 9.4 5 1.3 4.8 1.4 9.8 .1 18.6-.5 3.7-.9 7.4-1 11.1 0 4 .2 4.7 2.3 7.4 3.3 4.4 7.7 7.4 15.2 10.5 1.7 .7 3.3 1.7 4.7 2.8 11.2 10.7 18.6 16.2 22.9 16.9 5.2 .8 8 4.5 10 13.4 1.3 5.7 4 11.1 5.5 11.1 1.2-.2 2.3-.7 3.3-1.4 2-1.2 2.2-1.7 2.2-4.2-.3-6-.9-11.9-2-17.8-.4-1.7-.8-4.1-.9-5.4s-.6-3.8-1-5.7c-2.6-11.2-3.6-15.5-4.1-16-1.6-2-4.1-10.2-4.9-15.9-1.6-11.1-4-14.2-12.9-17.4-4.9-1.8-9.4-4.5-13.3-7.9-1.2-1-4-3.2-6.4-5.1s-4.4-3.5-4.6-3.8c-.8-.7-1.7-1.4-2.7-2-6.2-4.2-8.8-7-11.3-12l-2.4-5c-.1-8.7-.3-17.3-.4-26l6.9-6.6c4-3.8 8.5-7.4 10.6-8.4 3.3-1.7 4.4-1.9 11.4-2 8.5-.2 10.1 0 11.7 1.6s1.4 6.4-.3 8.5c-.6 .7-1.1 1.5-1.3 2.3 0 .6-2.6 4.9-5.4 9-1.1 2.2-1.9 4.5-2.4 6.8 20.4 13.4 21.6 3.8 14.1 29l11.4 2.5c3.1-8.7 6.5-17.3 8.6-26.2 .3-7.6-12-4.2-15.4-8.7-2.3-5.9 3.1-14.2 6.1-19.2 1.6-2.3 6.6-4.7 8.8-4.1 .9 .2 4.2-.4 7.4-1.3 2.5-.8 5-1.3 7.5-1.7 2-.2 4.1-.7 6-1.3 3.7-1.1 4.5-1.2 6.3-.4 1.9 .6 3.8 1.1 5.8 1.4 2.1 .3 4.1 .9 6 1.9 1.6 .9 3.3 1.7 5 2.2 2.5 .7 3 .6 7-1.7L226 5.4 236.7 5c10.4-.4 10.8-.5 15.3-2.7L256.5 0 259 1.4c1.8 1 3.1 2.7 4.9 6 2.4 4.5 2.4 4.6 1.4 7.4-.9 2.4-.9 3.3-.1 6.4 .5 2 1.2 4 2.1 5.9 .6 1.3 1.1 2.6 1.3 4 .3 4.3 0 5.3-2.4 6.9-2.2 1.5-7 7.9-7 9.3-.2 1-.6 2-1.1 3-5 11.5-6.8 13.6-14.3 17-9.2 4.2-12.3 5.2-16.2 5.2-3.1 0-4 .2-4.5 1.3-1.2 1.4-2.5 2.7-4.1 3.7-1.8 1.2-3.3 2.9-4.4 4.8-.5 1.2-1.4 2.2-2.5 2.9-.9 .4-1.8 1-2.5 1.7-2.2 1.9-4.6 3.7-7 5.4-3.3 2.3-6.9 5-7.9 6-.7 .7-1.5 1.3-2.4 1.7-.8 .4-1.6 .9-2.1 1.6-1.3 1.4-1.5 2.1-1.1 4.6 .3 2 .8 4 1.4 5.9 1.3 3.8 1.3 7.9 0 10.6s-.9 6.7 1.4 9.6c2 2.6 2.2 4.6 .7 8.8-.8 2.9-1.1 5.9-1.1 8.9 0 4.9 .2 6.3 1.5 8.4s1.8 2.5 3.2 2.3c2-.2 2.3-1.1 4.7-12.1 2.2-10 3.7-11.9 13.8-17.1 2.9-1.5 7.5-4 10-5.4s6.8-3.7 9.4-4.9c5.9-2.6 11.2-6.6 15.2-11.7 7.1-8.8 10-16.2 12.8-33.3 .4-2.8 1.3-5.4 2.9-7.7 1.4-2.2 2.4-4.7 2.9-7.3 1-5.3 2.9-9.1 5.6-11.5 4.7-4.2 6-1.1 4.6 10.9-.5 3.9-1.1 10.3-1.4 14.4l-.6 7.4c3 2.7 5.9 5.5 8.9 8.2l.1 8.4c.1 4.6 .5 9.5 .9 10.9l.8 2.5-6.4 6.3c-8.5 8.3-12.9 13.9-16.8 21.6-1.8 3.5-3.7 7.1-4.4 8-2.2 3.1-6.5 13-8.8 20.3l-2.3 7.2-7 6.5c-3.8 3.6-8 7.2-9.2 8.2-3 2.3-4.3 5.1-4.3 10-.1 2.5 .4 5 1.6 7.3 .8 1.6 1.5 3.2 2.1 4.8 .3 1 .9 2 1.6 2.9 1.4 1.6 1.9 16.1 .8 23.2-.7 4.5-3.6 12-4.7 12-1.8 0-4.1 9.3-5.1 20.7-.2 2-.6 5.9-1 8.7s-1 10-1.4 16c-.8 12.2-.2 18.8 2 23.2 3.4 6.7 .5 12.7-11 22.8l-4 3.5 .1 5.2c.1 3 .4 6 1.1 8.9 4.6 16 4.7 16.9 4.4 37.1-.5 26.4-.3 40.3 .6 44.2 .5 2.3 .9 4.6 1.1 7 .2 2 .7 5.3 1.1 7.4 .5 2.3 .8 11 .8 22.7l0 19.1-1.8 2.6c-2.7 3.9-15.1 13.5-15.5 12.3l.1 0zm29.5-45.1c-.2-.3-.3-6.9-.3-14.6 0-14.1-.9-27.5-2.3-34.4-.4-2-.8-9.7-.9-17.1-.2-11.9-1.4-24.4-2.6-26.4-.7-1.1-3-17.7-3-21.3 0-4.2 1-6 5.3-9.1s4.9-3.1 5.5-.7c.3 1.1 1.4 5.6 2.6 10 3.9 15.1 4.1 16.3 4 21.7-.1 5.8-.1 6.1-1.7 17.7-1 7.1-1.2 12.4-1 28.4 .2 19.4-.6 35.7-2 41.3-.7 2.8-2.8 5.5-3.4 4.4l-.1 0zm-71-37.6c-.8-3.6-1.3-7.2-1.7-10.8s-1-7.2-1.7-10.8c-.5-2.1-.9-4.3-1-6.5-.3-3.2-.9-7.5-1.3-9.5-1-4.8-3.3-19.4-3.4-21.1 0-.7-.3-4-.7-7.4-.7-6.2-.8-27.7-.2-28.3 1-1 6.6 2.8 11.3 7.4l5.3 5.3-.4 6.5c-.2 3.6-.6 10.2-.8 14.8-.5 13.3-.7 8.7-1.6 28.4-.8 17.4-1.9 31.3-2.6 32-.1 .1-.2 .1-.2 .2s-.2 0-.3 0-.2 0-.3-.1-.1-.1-.2-.2l0 0zM72 162.6c21.1 12.8 17.8 14.2 28.5 17.7 13 4.3 18.9 7.1 23.2 16.9-43.7 36.1-69 57.9-76.7 70.9-31 52-6 101.6 62.8 87.2-14.2 29.2-78 28.6-98.7-4.9-24.7-40-22.1-118.3 61-187.7l0 0zm210.8 179c56.7 6.9 82.3-37.7 46.5-89.2 0 0-26.9-29.3-64.3-68 3-15.5 9.5-32.1 30.6-53.8 89.2 63.5 92 141.6 92.5 149.4 4.3 70.6-78.7 91.2-105.3 61.7l0 0z"],
    "slack": [448, 512, [62447, "slack-hash"], "f198", "M94.1 315.1c0 25.9-21.2 47.1-47.1 47.1S0 341 0 315.1 21.2 268 47.1 268l47.1 0 0 47.1zm23.7 0c0-25.9 21.2-47.1 47.1-47.1S212 289.2 212 315.1l0 117.8c0 25.9-21.2 47.1-47.1 47.1s-47.1-21.2-47.1-47.1l0-117.8zm47.1-189c-25.9 0-47.1-21.2-47.1-47.1S139 32 164.9 32 212 53.2 212 79.1l0 47.1-47.1 0zm0 23.7c25.9 0 47.1 21.2 47.1 47.1S190.8 244 164.9 244L47.1 244C21.2 244 0 222.8 0 196.9s21.2-47.1 47.1-47.1l117.8 0zm189 47.1c0-25.9 21.2-47.1 47.1-47.1S448 171 448 196.9 426.8 244 400.9 244l-47.1 0 0-47.1zm-23.7 0c0 25.9-21.2 47.1-47.1 47.1S236 222.8 236 196.9l0-117.8C236 53.2 257.2 32 283.1 32s47.1 21.2 47.1 47.1l0 117.8zm-47.1 189c25.9 0 47.1 21.2 47.1 47.1S309 480 283.1 480 236 458.8 236 432.9l0-47.1 47.1 0zm0-23.7c-25.9 0-47.1-21.2-47.1-47.1S257.2 268 283.1 268l117.8 0c25.9 0 47.1 21.2 47.1 47.1s-21.2 47.1-47.1 47.1l-117.8 0z"],
    "angellist": [384, 512, [], "f209", "M315.6 215.4c11.7-32.6 45.4-126.9 45.4-157.1 0-26.6-15.7-48.9-43.7-48.9-44.6 0-84.6 131.7-97.1 163.1-9.7-28.5-55.1-172.5-95.1-172.5-31.1 0-45.7 22.9-45.7 51.7 0 35.3 34.2 126.8 46.6 162-6.3-2.3-13.1-4.3-20-4.3-23.4 0-48.3 29.1-48.3 52.6 0 8.9 4.9 21.4 8 29.7-36.9 10-51.1 34.6-51.1 71.7-.1 72.2 68.3 148.6 164.5 148.6 118 0 191.4-88.6 191.4-202.9 0-43.1-6.9-82-54.9-93.7zM280.2 108c4-12.3 21.1-64.3 37.1-64.3 8.6 0 10.9 8.9 10.9 16 0 19.1-38.6 124.6-47.1 148l-34-6 33.1-93.7zM110.8 48.3c0-11.9 14.5-45.7 46.3 47.1l34.6 100.3c-15.6-1.3-27.7-3-35.4 1.4-10.9-28.8-45.5-119.7-45.5-148.8zM108.5 244c29.3 0 67.1 94.6 67.1 107.4 0 5.1-4.9 11.4-10.6 11.4-20.9 0-76.9-76.9-76.9-97.7 .1-7.7 12.7-21.1 20.4-21.1zM292.8 430.3c-29.1 32-66.3 48.6-109.7 48.6-59.4 0-106.3-32.6-128.9-88.3-17.1-43.4 3.8-68.3 20.6-68.3 11.4 0 54.3 60.3 54.3 73.1 0 4.9-7.7 8.3-11.7 8.3-16.1 0-22.4-15.5-51.1-51.4-29.7 29.7 20.5 86.9 58.3 86.9 26.1 0 43.1-24.2 38-42 3.7 0 8.3 .3 11.7-.6 1.1 27.1 9.1 59.4 41.7 61.7 0-.9 2-7.1 2-7.4 0-17.4-10.6-32.6-10.6-50.3 0-28.3 21.7-55.7 43.7-71.7 8-6 17.7-9.7 27.1-13.1 9.7-3.7 20-8 27.4-15.4-1.1-11.2-5.7-21.1-16.9-21.1-27.7 0-120.6 4-120.6-39.7 0-6.7 .1-13.1 17.4-13.1 32.3 0 114.3 8 138.3 29.1 18.1 16.1 24.3 113.2-31 174.7zm-98.6-126c9.7 3.1 19.7 4 29.7 6-7.4 5.4-14 12-20.3 19.1-2.8-8.5-6.2-16.8-9.4-25.1z"],
    "android": [576, 512, [], "f17b", "M420.5 253.9a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-265.1 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm273.7-96.5l47.9-83c.8-1.1 1.3-2.4 1.5-3.8s.2-2.7-.1-4.1-.9-2.6-1.7-3.7-1.8-2-3-2.7-2.5-1.1-3.9-1.3-2.7 0-4 .4-2.5 1.1-3.6 1.9-1.9 2-2.5 3.2l-48.5 84.1c-38.8-17.4-80.8-26.4-123.3-26.4s-84.5 9-123.3 26.4L116.2 64.4c-.6-1.2-1.5-2.3-2.5-3.2s-2.3-1.5-3.6-1.9-2.7-.5-4-.4-2.7 .6-3.9 1.3-2.2 1.6-3 2.7-1.4 2.4-1.7 3.7-.3 2.7-.1 4.1 .8 2.6 1.5 3.8l47.9 83C64.5 202.2 8.2 285.5 0 384l576 0c-8.2-98.5-64.5-181.8-146.9-226.6z"],
    "meetup": [576, 512, [], "f2e0", "M131.1 414.3c1.1 5.7-2.3 11.1-8 12.3-5.4 1.1-10.9-2.3-12-8-1.1-5.4 2.3-11.1 7.7-12.3s11.1 2.3 12.3 8zm143.1 71.4c-6.3 4.6-8 13.4-3.7 20 4.6 6.6 13.4 8.3 20 3.7 6.3-4.6 8-13.4 3.4-20-4.2-6.5-13.1-8.3-19.7-3.7zm-86-462.3a11.8 11.8 0 1 0 -4.9-23 11.8 11.8 0 1 0 4.9 23zM66.5 226.3a22.2 22.2 0 1 0 -24.7 36.9 22.2 22.2 0 1 0 24.7-36.9zm272-170.9a22.1 22.1 0 1 0 -22.4-38 22.1 22.1 0 1 0 22.4 38zm-191.1 58a16.9 16.9 0 1 0 -18.8-28 16.9 16.9 0 1 0 18.8 28zm372.3 156c-7.4 1.7-12.3 9.1-10.6 16.9 1.4 7.4 8.9 12.3 16.3 10.6 7.4-1.4 12.3-8.9 10.6-16.6-1.5-7.4-8.9-12.3-16.3-10.9zm39.7-56.8a10.1 10.1 0 1 0 -19.8 4.3 10.1 10.1 0 1 0 19.8-4.3zm-80.3-73.7a18.8 18.8 0 1 0 20.7 31.3 18.8 18.8 0 1 0 -20.7-31.3zm-6.3 139.4c26.3 43.1 15.1 100-26.3 129.1-17.4 12.3-37.1 17.7-56.9 17.1-12 47.1-69.4 64.6-105.1 32.6-1.1 .9-2.6 1.7-3.7 2.9-39.1 27.1-92.3 17.4-119.4-22.3-9.7-14.3-14.6-30.6-15.1-46.9-65.4-10.9-90-94-41.1-139.7-28.3-46.9 .6-107.4 53.4-114.9 25.1-66.2 107.6-97.6 163.6-54.2 67.4-22.3 136.3 29.4 130.9 101.1 41.1 12.6 52.8 66.9 19.7 95.2zm-70 74.3c-3.1-20.6-40.9-4.6-43.1-27.1-3.1-32 43.7-101.1 40-128-3.4-24-19.4-29.1-33.4-29.4-13.4-.3-16.9 2-21.4 4.6-2.9 1.7-6.6 4.9-11.7-.3-6.3-6-11.1-11.7-19.4-12.9-12.3-2-17.7 2-26.6 9.7-3.4 2.9-12 12.9-20 9.1-3.4-1.7-15.4-7.7-24-11.4-16.3-7.1-40 4.6-48.6 20-12.9 22.9-38 113.1-41.7 125.1-8.6 26.6 10.9 48.6 36.9 47.1 11.1-.6 18.3-4.6 25.4-17.4 4-7.4 41.7-107.7 44.6-112.6 2-3.4 8.9-8 14.6-5.1 5.7 3.1 6.9 9.4 6 15.1-1.1 9.7-28 70.9-28.9 77.7-3.4 22.9 26.9 26.6 38.6 4 3.7-7.1 45.7-92.6 49.4-98.3 4.3-6.3 7.4-8.3 11.7-8 3.1 0 8.3 .9 7.1 10.9-1.4 9.4-35.1 72.3-38.9 87.7-4.6 20.6 6.6 41.4 24.9 50.6 11.4 5.7 62.5 15.7 58.5-11.1zm5.7 92.3a23.3 23.3 0 1 0 26.2 38.4 23.3 23.3 0 1 0 -26.2-38.4z"],
    "fonticons-fi": [384, 512, [], "f3a2", "M114.4 224l92.4 0-15.2 51.2-76.4 0 0 157.8c0 8-2.8 9.2 4.4 10l59.6 5.6 0 34.4-179.2 0 0-35.2 29.2-2.8c7.2-.8 9.2-3.2 9.2-10.8l0-155.8c0-3.2-4-3.2-8-3.2l-30.4 0 0-51.2 38.4 0 0-28.8c0-68 36.4-96 106-96 46.8 0 88.8 11.2 88.8 72.4L163.6 180c.4-25.6-6-31.6-22.4-31.6-25.2 0-26 13.6-26 37.6l0 32c0 3.2-4.8 6-.8 6zM384 483l-140.8 0 0-34.4 28-3.6c7.2-.8 10.4-2.4 10.4-10l0-148c0-5.6-4-9.2-9.2-10.8l-33.2-8.8 9.2-40.4 110 0 0 208c0 8-3.6 8.8 4 10l21.6 3.6 0 34.4zM354 135.8l12.4 45.6-10 10-42.8-22.8-42.8 22.8-10-10 12.4-45.6-30-36.4 4.8-10 38 0 21.2-38.4 12.8 0 21.2 38.4 38 0 4.8 13.2-30 33.2z"],
    "palfed": [576, 512, [], "f3d8", "M384.9 193.9c0-47.4-55.2-44.2-95.4-29.8-1.3 39.4-2.5 80.7-3 119.8 .7 2.8 2.6 6.2 15.1 6.2 36.8 0 83.4-42.8 83.3-96.2zM190.4 266.1c.2 0 6.5-2.7 11.2-2.7 26.6 0 20.7 44.1-14.4 44.1-21.5 0-37.1-18.1-37.1-43 0-42 42.9-95.6 100.7-126.5 1-12.4 3-22 10.5-28.2 11.2-9 26.6-3.5 29.5 11.1 72.2-22.2 135.2 1 135.2 72 0 77.9-79.3 152.6-140.1 138.2-.1 39.4 .9 74.4 2.7 100l0 .2c.2 3.4 .6 12.5-5.3 19.1-9.6 10.6-33.4 10-36.4-22.3-4.1-44.4 .2-206.1 1.4-242.5-21.5 15-58.5 50.3-58.5 75.9 .2 2.5 .4 4 .6 4.6zM8 181.1s-.1 37.4 38.4 37.4l30 0 22.4 217.2s0 44.3 44.7 44.3l288.9 0s44.7-.4 44.7-44.3l22.4-217.2 30 0s38.4 1.2 38.4-37.4c0 0 .1-37.4-38.4-37.4l-30.1 0c-7.3-25.6-30.2-74.3-119.4-74.3l-28 0 0-19.1s-2.7-18.4-21.1-18.4l-85.8 0S224 31.9 224 50.3l0 19.1-28.1 0s-105 4.2-120.5 74.3l-29 0S8 142.5 8 181.1z"],
    "wpbeginner": [512, 512, [], "f297", "M463.2 322.4c56.2 64.3 4.2 157.6-91.9 157.6-39.6 0-78.8-17.7-100.1-50-6.9 .4-22.7 .4-29.6 0-21.4 32.4-60.6 50-100.1 50-95.5 0-148.3-93-91.9-157.6-79.1-131.9 31.3-290.4 206.8-290.4 175.6 0 285.9 158.6 206.8 290.4zm-339.6-83l41.5 0 0-58.1-41.5 0 0 58.1zm217.2 86.1l0-23.8c-60.5 20.9-132.4 9.2-187.6-34l.2 24.9c51.1 46.4 131.7 57.9 187.3 32.9zM190 239.4l166.1 0 0-58.1-166.1 0 0 58.1z"],
    "diaspora": [448, 512, [], "f791", "M219.7 354.6c-1.4 0-88 119.9-88.7 119.9S44.4 414 44 413.3 130.6 287.5 130.6 285.8c0-2.2-129.6-44-137.6-47.1-1.3-.5 31.4-101.8 31.7-102.1 .6-.7 144.4 47 145.5 47 .4 0 .9-.6 1-1.3 .4-2 1-148.6 1.7-149.6 .8-1.2 104.5-.7 105.1-.3 1.5 1 3.5 156.1 6.1 156.1 1.4 0 138.7-47 139.3-46.3 .8 .9 31.9 102.2 31.5 102.6-.9 .9-140.2 47.1-140.6 48.8-.3 1.4 82.8 122.1 82.5 122.9s-85.5 63.5-86.3 63.5c-1-.2-89-125.5-90.9-125.5l0 0z"],
    "product-hunt": [512, 512, [], "f288", "M326.3 218.8c0 20.5-16.7 37.2-37.2 37.2l-70.3 0 0-74.4 70.3 0c20.5 0 37.2 16.7 37.2 37.2zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm367.9-37.2c0-47.9-38.9-86.8-86.8-86.8l-119.9 0 0 248 49.6 0 0-74.4 70.3 0c47.9 0 86.8-38.9 86.8-86.8z"],
    "square-upwork": [448, 512, [], "e67c", "M56 32l336 0c30.9 0 56 25.1 56 56l0 336c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56L0 88C0 57.1 25.1 32 56 32zM270.9 274.2c6.6-52.9 25.9-69.5 51.4-69.5 25.3 0 44.9 20.2 44.9 49.7s-19.7 49.7-44.9 49.7c-27.9 0-46.3-21.5-51.4-29.9zm-26.7-41.8c-8.2-15.5-14.3-36.3-19.2-55.6l-62.9 0 0 78.1c0 28.4-12.9 49.4-38.2 49.4S84.1 283.4 84.1 255l.3-78.1-36.2 0 0 78.1c0 22.8 7.4 43.5 20.9 58.2 13.9 15.2 32.8 23.2 54.8 23.2 43.7 0 74.2-33.5 74.2-81.5l0-52.5c4.6 17.3 15.4 50.5 36.2 79.7l-19.3 110.5 36.8 0 12.8-78.4c4.2 3.5 8.7 6.6 13.4 9.4 12.3 7.8 26.4 12.2 40.9 12.6l3.4 0c45.1 0 80.9-34.9 80.9-81.9s-35.9-82.2-80.9-82.2c-45.4 0-70.9 29.7-78.1 60.1l0 .2z"],
    "cuttlefish": [448, 512, [], "f38c", "M348 305.5c-17.5 31.6-57.4 54.5-96 54.5-56.6 0-104-47.4-104-104s47.4-104 104-104c38.6 0 78.5 22.9 96 54.5 13.7-50.9 41.7-93.3 87-117.8-45.3-49.6-110.5-80.7-183-80.7-137 0-248 111-248 248S115 504 252 504c72.5 0 137.7-31.1 183-80.7-45.3-24.5-73.3-66.9-87-117.8z"],
    "medapps": [320, 512, [], "f3c6", "M118.3 238.4c3.5-12.5 6.9-33.6 13.2-33.6 8.3 1.8 9.6 23.4 18.6 36.6 4.6-23.5 5.3-85.1 14.1-86.7 9-.7 19.7 66.5 22 77.5 9.9 4.1 48.9 6.6 48.9 6.6 1.9 7.3-24 7.6-40 7.8-4.6 14.8-5.4 27.7-11.4 28-4.7 .2-8.2-28.8-17.5-49.6l-9.4 65.5c-4.4 13-15.5-22.5-21.9-39.3-3.3-.1-62.4-1.6-47.6-7.8l31-5zM228 448c21.2 0 21.2-32 0-32L92 416c-21.2 0-21.2 32 0 32l136 0zm-24 64c21.2 0 21.2-32 0-32l-88 0c-21.2 0-21.2 32 0 32l88 0zm34.2-141.5c3.2-18.9 5.2-36.4 11.9-48.8 7.9-14.7 16.1-28.1 24-41 24.6-40.4 45.9-75.2 45.9-125.5 0-85.6-71.8-155.2-160-155.2S0 69.6 0 155.2c0 50.2 21.3 85.1 45.9 125.5 7.9 12.9 16 26.3 24 41 6.7 12.5 8.7 29.8 11.9 48.9 3.5 21 36.1 15.7 32.6-5.1-3.6-21.7-5.6-40.7-15.3-58.6-32.6-60.4-66.1-95.6-66.1-151.7 0-67.9 57-123.2 127-123.2S287 87.3 287 155.2c0 56.1-33.5 91.3-66.1 151.6-9.7 18-11.7 37.4-15.3 58.6-3.4 20.6 29 26.4 32.6 5.1z"],
    "pix": [512, 512, [], "e43a", "M242.4 292.5c5.4-5.4 14.7-5.4 20.1 0l77 77c14.2 14.2 33.1 22 53.1 22l15.1 0-97.1 97.1c-30.3 29.5-79.5 29.5-109.8 0l-97.5-97.4 9.3 0c20 0 38.9-7.8 53.1-22l76.7-76.7zm20.1-73.6c-6.4 5.5-14.6 5.6-20.1 0l-76.7-76.7c-14.2-15.1-33.1-22-53.1-22l-9.3 0 97.4-97.4c30.4-30.3 79.6-30.3 109.9 0l97.2 97.1-15.2 0c-20 0-38.9 7.8-53.1 22l-77 77zM112.6 142.7c13.8 0 26.5 5.6 37.1 15.4l76.7 76.7c7.2 6.3 16.6 10.8 26.1 10.8 9.4 0 18.8-4.5 26-10.8l77-77c9.8-9.7 23.3-15.3 37.1-15.3l37.7 0 58.3 58.3c30.3 30.3 30.3 79.5 0 109.8l-58.3 58.3-37.7 0c-13.8 0-27.3-5.6-37.1-15.4l-77-77c-13.9-13.9-38.2-13.9-52.1 .1l-76.7 76.6c-10.6 9.8-23.3 15.4-37.1 15.4l-31.8 0-58-58c-30.3-30.3-30.3-79.5 0-109.8l58-58.1 31.8 0z"],
    "square-tumblr": [448, 512, ["tumblr-square"], "f174", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM256.8 416c-75.5 0-91.9-55.5-91.9-87.9l0-90-29.7 0c-3.4 0-6.2-2.8-6.2-6.2l0-42.5c0-4.5 2.8-8.5 7.1-10 38.8-13.7 50.9-47.5 52.7-73.2 .5-6.9 4.1-10.2 10-10.2l44.3 0c3.4 0 6.2 2.8 6.2 6.2l0 72 51.9 0c3.4 0 6.2 2.8 6.2 6.2l0 51.1c0 3.4-2.8 6.2-6.2 6.2l-52.1 0 0 83.3c0 21.4 14.8 33.5 42.5 22.4 3-1.2 5.6-2 8-1.4 2.2 .5 3.6 2.1 4.6 4.9L318 387.1c1 3.2 2 6.7-.3 9.1-8.5 9.1-31.2 19.8-60.9 19.8z"],
    "react": [512, 512, [], "f41b", "M418.2 177.2c-5.4-1.8-10.8-3.5-16.2-5.1 .9-3.7 1.7-7.4 2.5-11.1 12.3-59.6 4.2-107.5-23.1-123.3-26.3-15.1-69.2 .6-112.6 38.4-4.3 3.7-8.5 7.6-12.5 11.5-2.7-2.6-5.5-5.2-8.3-7.7-45.5-40.4-91.1-57.4-118.4-41.5-26.2 15.2-34 60.3-23 116.7 1.1 5.6 2.3 11.1 3.7 16.7-6.4 1.8-12.7 3.8-18.6 5.9-53.4 18.5-91.7 47.7-91.7 77.9 0 31.2 40.8 62.5 96.3 81.5 4.5 1.5 9 3 13.6 4.3-1.5 6-2.8 11.9-4 18-10.5 55.5-2.3 99.5 23.9 114.6 27 15.6 72.4-.4 116.6-39.1 3.5-3.1 7-6.3 10.5-9.7 4.4 4.3 9 8.4 13.6 12.4 42.8 36.8 85.1 51.7 111.2 36.6 27-15.6 35.8-62.9 24.4-120.5-.9-4.4-1.9-8.9-3-13.5 3.2-.9 6.3-1.9 9.4-2.9 57.7-19.1 99.5-50 99.5-81.7 0-30.3-39.4-59.7-93.8-78.4zM282.9 92.3c37.2-32.4 71.9-45.1 87.7-36 16.9 9.7 23.4 48.9 12.8 100.4-.7 3.4-1.4 6.7-2.3 10-22.2-5-44.7-8.6-67.3-10.6-13-18.6-27.2-36.4-42.6-53.1 3.9-3.7 7.7-7.2 11.7-10.7zM167.2 307.5c5.1 8.7 10.3 17.4 15.8 25.9-15.6-1.7-31.1-4.2-46.4-7.5 4.4-14.4 9.9-29.3 16.3-44.5 4.6 8.8 9.3 17.5 14.3 26.1zM136.9 187.2c14.4-3.2 29.7-5.8 45.6-7.8-5.3 8.3-10.5 16.8-15.4 25.4-4.9 8.5-9.7 17.2-14.2 26-6.3-14.9-11.6-29.5-16-43.6zm27.4 68.9c6.6-13.8 13.8-27.3 21.4-40.6s15.8-26.2 24.4-38.9c15-1.1 30.3-1.7 45.9-1.7s31 .6 45.9 1.7c8.5 12.6 16.6 25.5 24.3 38.7s14.9 26.7 21.7 40.4c-6.7 13.8-13.9 27.4-21.6 40.8-7.6 13.3-15.7 26.2-24.2 39-14.9 1.1-30.4 1.6-46.1 1.6s-30.9-.5-45.6-1.4c-8.7-12.7-16.9-25.7-24.6-39s-14.8-26.8-21.5-40.6zm180.6 51.2c5.1-8.8 9.9-17.7 14.6-26.7 6.4 14.5 12 29.2 16.9 44.3-15.5 3.5-31.2 6.2-47 8 5.4-8.4 10.5-17 15.5-25.6zm14.4-76.5c-4.7-8.8-9.5-17.6-14.5-26.2-4.9-8.5-10-16.9-15.3-25.2 16.1 2 31.5 4.7 45.9 8-4.6 14.8-10 29.2-16.1 43.4zM256.2 118.3c10.5 11.4 20.4 23.4 29.6 35.8-19.8-.9-39.7-.9-59.5 0 9.8-12.9 19.9-24.9 29.9-35.8zM140.2 57c16.8-9.8 54.1 4.2 93.4 39 2.5 2.2 5 4.6 7.6 7-15.5 16.7-29.8 34.5-42.9 53.1-22.6 2-45 5.5-67.2 10.4-1.3-5.1-2.4-10.3-3.5-15.5-9.4-48.4-3.2-84.9 12.6-94zM115.7 320.6c-4.2-1.2-8.3-2.5-12.4-3.9-21.3-6.7-45.5-17.3-63-31.2-10.1-7-16.9-17.8-18.8-29.9 0-18.3 31.6-41.7 77.2-57.6 5.7-2 11.5-3.8 17.3-5.5 6.8 21.7 15 43 24.5 63.6-9.6 20.9-17.9 42.5-24.8 64.5zm116.6 98c-16.5 15.1-35.6 27.1-56.4 35.3-11.1 5.3-23.9 5.8-35.3 1.3-15.9-9.2-22.5-44.5-13.5-92 1.1-5.6 2.3-11.2 3.7-16.7 22.4 4.8 45 8.1 67.9 9.8 13.2 18.7 27.7 36.6 43.2 53.4-3.2 3.1-6.4 6.1-9.6 8.9zm24.5-24.3c-10.2-11-20.4-23.2-30.3-36.3 9.6 .4 19.5 .6 29.5 .6 10.3 0 20.4-.2 30.4-.7-9.2 12.7-19.1 24.8-29.6 36.4zm130.7 30c-.9 12.2-6.9 23.6-16.5 31.3-15.9 9.2-49.8-2.8-86.4-34.2-4.2-3.6-8.4-7.5-12.7-11.5 15.3-16.9 29.4-34.8 42.2-53.6 22.9-1.9 45.7-5.4 68.2-10.5 1 4.1 1.9 8.2 2.7 12.2 4.9 21.6 5.7 44.1 2.5 66.3zm18.2-107.5c-2.8 .9-5.6 1.8-8.5 2.6-7-21.8-15.6-43.1-25.5-63.8 9.6-20.4 17.7-41.4 24.5-62.9 5.2 1.5 10.2 3.1 15 4.7 46.6 16 79.3 39.8 79.3 58 0 19.6-34.9 44.9-84.8 61.4zM256 301.8a45.8 45.8 0 1 0 0-91.6 45.8 45.8 0 1 0 0 91.6z"],
    "jxl": [448, 512, [], "e67b", "M412.2 32L35.8 32C16 32 0 48 0 67.8L0 444.2C0 464 16 480 35.8 480l376.4 0c19.8 0 35.8-16 35.8-35.8l0-376.4C448 48 432 32 412.2 32zM378.6 333.7c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0zm0-113.9c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0zm0-113.9c0 40.2-32.6 72.8-72.8 72.8l-235.6 0c0-40.2 32.6-72.8 72.8-72.8l235.6 0z"],
    "square-linkedin": [448, 512, [], "e7d0", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm5 170.2l66.5 0 0 213.8-66.5 0 0-213.8zm71.7-67.7a38.5 38.5 0 1 1 -77 0 38.5 38.5 0 1 1 77 0zM317.9 416l0-104c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9l0 105.8-66.4 0 0-213.8 63.7 0 0 29.2 .9 0c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9l0 117.2-66.4 0z"],
    "css": [448, 512, [], "e6a2", "M376.3 32L0 32 0 408.3c0 19 7.6 37.2 21 50.7s31.7 21 50.7 21l304.6 0c19 0 37.2-7.6 50.7-21s21-31.7 21-50.7l0-304.6c0-19-7.6-37.2-21-50.7s-31.7-21-50.7-21zM332.4 431.4c-7.7-8.5-11.7-20.7-12-36.6l31.3 0c.2 14.1 5.1 21.1 14.8 21.1c4.9 0 8.4-1.6 10.5-4.7c2-3.1 3-8 3-14.8c0-5.4-1.3-9.9-4-13.4c-3.5-4.2-8.1-7.5-13.2-9.5L351.2 368c-10.3-4.9-17.8-10.8-22.5-17.6c-4.5-6.8-6.7-16.3-6.7-28.4c0-13.6 4-24.6 11.8-33.1c8.1-8.5 19.1-12.7 33.2-12.7c13.6 0 24.1 4.2 31.5 12.5c7.5 8.4 11.5 20.3 11.8 35.9l-30.1 0c.2-5.1-.9-10.2-3-14.8c-1.7-3.4-5-5.1-10-5.1c-8.8 0-13.2 5.2-13.2 15.7c0 5.3 1.1 9.4 3.2 12.6c3.1 3.5 7 6.2 11.4 7.8l11.1 4.9c11.5 5.3 19.7 11.7 24.8 19.4c5.1 7.7 7.6 18 7.6 31c0 15.5-4 27.4-12.3 35.7c-8.2 8.3-19.5 12.5-34.1 12.5s-25.6-4.2-33.4-12.7zm-101 0c-7.7-8.5-11.7-20.7-12-36.6l31.3 0c.2 14.1 5.1 21.1 14.8 21.1c4.9 0 8.4-1.6 10.4-4.7c2-3.1 3-8 3-14.8c0-5.4-1.3-9.9-3.9-13.4c-3.5-4.2-8.1-7.5-13.2-9.5L250.2 368c-10.3-4.9-17.8-10.8-22.5-17.6c-4.5-6.8-6.7-16.3-6.7-28.4c0-13.6 4-24.6 11.8-33.1c8.1-8.5 19.1-12.7 33.2-12.7c13.6 0 24.1 4.2 31.4 12.5c7.6 8.4 11.5 20.3 11.9 35.9l-30.1 0c.2-5.1-.9-10.2-3-14.8c-1.7-3.4-5-5.1-10-5.1c-8.8 0-13.2 5.2-13.2 15.7c0 5.3 1.1 9.4 3.2 12.6c3.1 3.5 7 6.2 11.4 7.8l11.1 4.9c11.5 5.3 19.7 11.7 24.8 19.4c5.1 7.7 7.6 18 7.6 31c0 15.5-4.1 27.4-12.3 35.7s-19.5 12.5-34.1 12.5s-25.6-4.2-33.4-12.7zm-105.6 1.1c-8.4-7.7-12.5-19.2-12.5-34.5l0-75.4c0-15.2 4.4-26.7 13.2-34.6c8.9-7.8 20.7-11.8 35.2-11.8c14.1 0 25.2 4 33.4 12c8.3 8 12.5 20 12.5 35.9l0 6-33.1 0 0-5.8c0-6.1-1.3-10.7-4-13.6c-1.1-1.5-2.6-2.7-4.3-3.5s-3.5-1.2-5.4-1.1c-5.4 0-9.2 1.8-11.4 5.6c-2.3 5.2-3.3 10.8-3 16.4l0 65.5c0 13.7 4.8 20.6 14.4 20.8c4.5 0 7.9-1.6 10.2-4.8c2.5-4.1 3.7-8.8 3.5-13.6l0-4.9 33.1 0 0 5.1c0 10.6-2.1 19.5-6.2 26.6c-4 6.9-9.9 12.5-17.1 16c-7.7 3.7-16.1 5.5-24.6 5.3c-14.2 0-25.5-3.9-33.8-11.6z"],
    "hashnode": [512, 512, [], "e499", "M35.7 171.1c-46.9 46-46.9 122.9 0 169.8L171.6 476.8c46 46.9 122.9 46.9 169.8 0L477.3 340.9c46.9-46.9 46.9-123.8 0-169.8L341.4 35.2c-46.9-46.9-123.8-46.9-169.8 0L35.7 171.1zM196 196.5a84.5 84.5 0 1 1 120 119 84.5 84.5 0 1 1 -120-119z"],
    "reddit-alien": [512, 512, [], "f281", "M373 138.6c-25.2 0-46.3-17.5-51.9-41-30.6 4.3-54.2 30.7-54.2 62.4l0 .2c47.4 1.8 90.6 15.1 124.9 36.3 12.6-9.7 28.4-15.5 45.5-15.5 41.3 0 74.7 33.4 74.7 74.7 0 29.8-17.4 55.5-42.7 67.5-2.4 86.8-97 156.6-213.2 156.6S45.5 410.1 43 323.4c-25.4-11.9-43-37.7-43-67.7 0-41.3 33.4-74.7 74.7-74.7 17.2 0 33 5.8 45.7 15.6 34-21.1 76.8-34.4 123.7-36.4l0-.3c0-44.3 33.7-80.9 76.8-85.5 4.9-24.2 26.3-42.4 52.1-42.4 29.4 0 53.3 23.9 53.3 53.3s-23.9 53.3-53.3 53.3zM157.5 255.3c-20.9 0-38.9 20.8-40.2 47.9s17.1 38.1 38 38.1 36.6-9.8 37.8-36.9-14.7-49.1-35.7-49.1l.1 0zM395 303.1c-1.2-27.1-19.2-47.9-40.2-47.9s-36.9 22-35.7 49.1 16.9 36.9 37.8 36.9 39.3-11 38-38.1l.1 0zm-60.1 70.8c1.5-3.6-1-7.7-4.9-8.1-23-2.3-47.9-3.6-73.8-3.6s-50.8 1.3-73.8 3.6c-3.9 .4-6.4 4.5-4.9 8.1 12.9 30.8 43.3 52.4 78.7 52.4s65.8-21.6 78.7-52.4z"],
    "tiktok": [448, 512, [], "e07b", "M448.5 209.9c-44 .1-87-13.6-122.8-39.2l0 178.7c0 33.1-10.1 65.4-29 92.6s-45.6 48-76.6 59.6-64.8 13.5-96.9 5.3-60.9-25.9-82.7-50.8-35.3-56-39-88.9 2.9-66.1 18.6-95.2 40-52.7 69.6-67.7 62.9-20.5 95.7-16l0 89.9c-15-4.7-31.1-4.6-46 .4s-27.9 14.6-37 27.3-14 28.1-13.9 43.9 5.2 31 14.5 43.7 22.4 22.1 37.4 26.9 31.1 4.8 46-.1 28-14.4 37.2-27.1 14.2-28.1 14.2-43.8l0-349.4 88 0c-.1 7.4 .6 14.9 1.9 22.2 3.1 16.3 9.4 31.9 18.7 45.7s21.3 25.6 35.2 34.6c19.9 13.1 43.2 20.1 67 20.1l0 87.4z"],
    "wordpress": [512, 512, [], "f19a", "M61.7 169.4l101.5 278c-71-34.4-119.9-107.2-119.9-191.4 0-30.9 6.6-60.1 18.4-86.6zm337.9 75.9c0-26.3-9.4-44.5-17.5-58.7-10.8-17.5-20.9-32.4-20.9-49.9 0-19.6 14.8-37.8 35.7-37.8 .9 0 1.8 .1 2.8 .2-37.9-34.7-88.3-55.9-143.7-55.9-74.3 0-139.7 38.1-177.8 95.9 5 .2 9.7 .3 13.7 .3 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l77.5 230.4 46.6-139.6-33.1-90.8c-11.5-.7-22.3-2-22.3-2-11.5-.7-10.1-18.2 1.3-17.5 0 0 35.1 2.7 56 2.7 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l76.9 228.7 21.2-70.9c9-29.4 16-50.5 16-68.7zM259.7 274.6L195.9 460.1c19.1 5.6 39.2 8.7 60.1 8.7 24.8 0 48.5-4.3 70.6-12.1-.6-.9-1.1-1.9-1.5-2.9L259.7 274.6zm183-120.7c.9 6.8 1.4 14 1.4 21.9 0 21.6-4 45.8-16.2 76.2l-65 187.9c63.3-36.9 105.8-105.4 105.8-183.9 0-37-9.4-71.8-26-102.1zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm484.6 0a236.6 236.6 0 1 0 -473.2 0 236.6 236.6 0 1 0 473.2 0z"],
    "ideal": [512, 512, [], "e013", "M93.8 165.5a49.1 49.1 0 1 0 0 98.1 49.1 49.1 0 1 0 0-98.1zM54.3 425.8l78.9 0 0-140.5-78.9 0 0 140.5zM205.8 214.2c0-20-10-22.5-18.7-22.5l-14 0 0 45.8 14 0c9.7 0 18.7-2.8 18.7-23.3zm201.7 46l0-91.3 22.8 0 0 68.6 33.7 0C454.6 113.1 356.8 86.2 267.8 86.2l-94.8 0 0 82.8 14 0c25.6 0 41.5 17.4 41.5 45.3 0 28.8-15.5 46-41.5 46l-14 0 0 165.6 94.8 0c144.6 0 194.9-67.2 196.7-165.6l-57.1 0zm-109.8 0l-56.2 0 0-91.2 54.4 0 0 22.7-31.7 0 0 10.6 30 0 0 22.7-30 0 0 12.5 33.5 0 0 22.7zm74.7 0l-5.2-17.7-29.7 0-5.2 17.7-23.7 0 27.5-91.3 32.3 0 27.5 91.3-23.7 0zM267.8 32L.1 32 .1 480 267.8 480c161.8 0 251-79.7 251-224.5 0-83.5-32.6-223.5-251-223.5zm0 426.9l-246.6 0 0-405.9 246.6 0c142.1 0 229.9 64.6 229.9 202.4 0 134.1-81 203.4-229.9 203.4zm83.9-264.9l-7.5 25.8 16.4 0-7.5-25.8-1.4 0z"],
    "pied-piper-pp": [448, 512, [], "f1a7", "M205.3 174.6c0 21.1-14.2 38.1-31.7 38.1-7.1 0-12.8-1.2-17.2-3.7l0-68c4.4-2.7 10.1-4.2 17.2-4.2 17.5 0 31.7 16.9 31.7 37.8zm52.6 67c-7.1 0-12.8 1.5-17.2 4.2l0 68c4.4 2.5 10.1 3.7 17.2 3.7 17.4 0 31.7-16.9 31.7-37.8 0-21.1-14.3-38.1-31.7-38.1zM448 80l0 352c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l352 0c26.5 0 48 21.5 48 48zM185 255.1c41 0 74.2-35.6 74.2-79.6S226 95.9 185 95.9c-12 0-24.1 3.2-34.6 8.8l-45.7 0 0 206.3 51.8-10.1 0-50.6c8.6 3.1 18.1 4.8 28.5 4.8zm158.4 25.3c0-44-33.2-79.6-73.9-79.6-3.2 0-6.4 .2-9.6 .7-3.7 12.5-10.1 23.8-19.2 33.4-13.8 15-32.2 23.8-51.8 24.8l0 156.3 51.8-10.1 0-50.6c8.6 3.2 18.2 4.7 28.7 4.7 40.8 0 74-35.6 74-79.6z"],
    "ussunnah": [512, 512, [], "f407", "M496.9 268.1c0 63.9-25.4 125.2-70.6 170.3S319.9 509 256 509 130.8 483.5 85.7 438.4 15.1 331.9 15.1 268c0-63.9 25.4-125.2 70.6-170.4S192.2 27.1 256.1 27.1 381.3 52.4 426.5 97.6 497 204.1 497 268l-.1 .1zM39.5 268c-.6 28.8 4.5 57.5 15.1 84.3s26.4 51.2 46.6 71.8 44.2 37 70.8 48.1 55.1 16.9 83.9 16.9 57.4-5.8 83.9-16.9 50.6-27.5 70.8-48.1 36-45 46.6-71.8 15.7-55.5 15.1-84.3c.6-28.8-4.5-57.5-15.1-84.3s-26.4-51.2-46.6-71.8-44.2-37-70.8-48.1-55.1-16.9-83.9-16.9-57.4 5.8-83.9 16.9-50.6 27.5-70.8 48.1-36 45-46.6 71.8-15.7 55.5-15.1 84.3zm385.9 63.3c-12.7 0-21.6-1.9-26.7-5.9-5.5-4.3-8.2-12.3-8.2-23.8l0-96.5c0-6.5-5.2-20.2-15.7-41.2 7 0 17-9.1 30-27.2l0 147.8c0 11 2.4 19.4 7 25.3 3.7 4.7 10.1 8.9 19 12.6 1.2 .4 2.6 .9 4.1 1.4 2.9 .9 6.3 2.1 10.3 3.5-1.8 2.7-8.3 4-19.9 4l.1 0zm-219 0c-1.3 2.4-3.6 5.5-6.8 9.4l-18.5 22.5c-1-6.1-4-13-9.3-20.6s-9.7-11.4-13.4-11.4l-89.8 0c3.3-5.3 4.9-8.8 4.9-10.8s-.8-5.3-2.4-9.7c-1.5-4.4-2.4-8.5-2.4-12.4 0-7.4 2.1-13.9 6.3-19.3l20-25.6-7.1-17.7 16.1-19.8 6.7 16.8 8-10.3c-1.8 6.4-2.6 12.3-2.6 17.7 0 4.2 2.8 13.3 8.3 27.3l16.2 40.7 17.7 0c2.8 .4 7.7 5 14.6 13.9 1.8 2.4 4.3 5.8 7.7 10.2 1.4 1.9 2.9 3.9 4.6 6.1 1.3-2.3 2-4.6 2-7.1 0-2-1.3-6.6-4-13.4L178 304.1c-4-10.6-6.1-17.7-6.1-21.3 0-6.3 1.9-12.3 5.8-17.9 .5-.6 1-1.3 1.5-1.9 4.4-5.6 8.8-11.1 13.3-16.5-1.1 4.6-1.7 8.7-1.7 12 0 3.7 1.7 9.9 5.1 18.8l7.9 20.4c1.9 4.7 3 8.2 3.7 10.3l25.9 0-.9-2.6c-1.4-3.9-4-7-7.7-9.3l15.6-20.1 12.3 32 13.4 0-6.1-15.8c-1.5-3.9-4-7-7.7-9.3l15.7-20.1 17.3 45.2 13.4 0-11.4-29.4c-1.5-3.9-4-7-7.7-9.3l15.6-20 22.4 58.7 26.2 0c1.5 0 3-1.1 4.5-3.1s2.2-4.1 2.2-6.3l0-93.5c0-6.5-4.5-20.3-13.7-41.2 5.4 0 14.1-9.1 26.2-27.2l0 163.5c0 7.2 .6 12 1.7 14.6 1.6 3.4 5.3 6.2 11.1 8.2-3.9 5.6-8.7 8.5-14.5 8.5l-154.8 0-.1-.2zm-98-44c-2.7-6.7-4-11.7-4-15-.6 1.2-2.4 3.7-5.4 7.6-1.4 1.9-2.2 3.7-2.2 5.3 0 2.6 .8 5.7 2.2 9.3l5.6 13.9c5 0 9 0 11.9-.1l-8.2-20.9 .1-.1zm13.5-72.4c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0zm-27.6 0c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0zm87 27.5c-3-5.2-7-9.3-11.9-11.9-3.5-1.9-5.3-4.3-5.3-7.4 0-2.4 4.6-8.6 14-18.3 .2 3.8 1.9 7.6 4.9 11.2 3.1 3.6 4.6 7 4.6 10.1 0 2.6-2.1 8-6.2 16.3l-.1 0z"],
    "fort-awesome-alt": [512, 512, [], "f3a3", "M208 237.4l-22.2 0c-2.1 0-3.7 1.6-3.7 3.7l0 51.7c0 2.1 1.6 3.7 3.7 3.7l22.2 0c2.1 0 3.7-1.6 3.7-3.7l0-51.7c0-2.1-1.6-3.7-3.7-3.7zm118.2 0l-22.2 0c-2.1 0-3.7 1.6-3.7 3.7l0 51.7c0 2.1 1.6 3.7 3.7 3.7l22.2 0c2.1 0 3.7-1.6 3.7-3.7l0-51.7c-.1-2.1-1.7-3.7-3.7-3.7zm132-125.1c-2.3-3.2-4.6-6.4-7.1-9.5-9.8-12.5-20.8-24-32.8-34.4-4.5-3.9-9.1-7.6-13.9-11.2-1.6-1.2-3.2-2.3-4.8-3.5-27.6-19.6-59.3-33.7-93.6-40.7-16.2-3.3-32.9-5-50-5s-33.9 1.7-50 5c-34.3 7.1-66 21.2-93.3 40.8-1.6 1.1-3.2 2.3-4.8 3.5-4.8 3.6-9.4 7.3-13.9 11.2-3 2.6-5.9 5.3-8.8 8s-5.7 5.5-8.4 8.4c-5.5 5.7-10.7 11.8-15.6 18-2.4 3.1-4.8 6.3-7.1 9.5-28.9 40.6-45.8 90.1-45.8 143.6 0 2 .1 4 .1 6 .1 .7 .1 1.3 .1 2 .1 1.3 .1 2.7 .2 4 0 .8 .1 1.5 .1 2.3 0 1.3 .1 2.5 .2 3.7 .1 .8 .1 1.6 .2 2.4 .1 1.1 .2 2.3 .3 3.5 0 .8 .1 1.6 .2 2.4 .1 1.2 .3 2.4 .4 3.6 .1 .8 .2 1.5 .3 2.3 .1 1.3 .3 2.6 .5 3.9 .1 .6 .2 1.3 .3 1.9l.9 5.7c.1 .6 .2 1.1 .3 1.7 .3 1.3 .5 2.7 .8 4 .2 .8 .3 1.6 .5 2.4 .2 1 .5 2.1 .7 3.2 .2 .9 .4 1.7 .6 2.6 .2 1 .4 2 .7 3 .2 .9 .5 1.8 .7 2.7 .3 1 .5 1.9 .8 2.9 .3 .9 .5 1.8 .8 2.7 .2 .9 .5 1.9 .8 2.8s.5 1.8 .8 2.7c.3 1 .6 1.9 .9 2.8 .6 1.6 1.1 3.3 1.7 4.9 .4 1 .7 1.9 1 2.8 .3 1 .7 2 1.1 3 .3 .8 .6 1.5 .9 2.3l1.2 3c.3 .7 .6 1.5 .9 2.2 .4 1 .9 2 1.3 3l.9 2.1c.5 1 .9 2 1.4 3 .3 .7 .6 1.3 .9 2 .5 1 1 2.1 1.5 3.1 .2 .6 .5 1.1 .8 1.7 .6 1.1 1.1 2.2 1.7 3.3 .1 .2 .2 .3 .3 .5 2.2 4.1 4.4 8.2 6.8 12.2 .2 .4 .5 .8 .7 1.2 .7 1.1 1.3 2.2 2 3.3 .3 .5 .6 .9 .9 1.4 .6 1.1 1.3 2.1 2 3.2 .3 .5 .6 .9 .9 1.4 .7 1.1 1.4 2.1 2.1 3.2 .2 .4 .5 .8 .8 1.2 .7 1.1 1.5 2.2 2.3 3.3 .2 .2 .3 .5 .5 .7 37.5 51.7 94.4 88.5 160 99.4 .9 .1 1.7 .3 2.6 .4 1 .2 2.1 .4 3.1 .5s1.9 .3 2.8 .4c1 .2 2 .3 3 .4 .9 .1 1.9 .2 2.9 .3s1.9 .2 2.9 .3 2.1 .2 3.1 .3c.9 .1 1.8 .1 2.7 .2 1.1 .1 2.3 .1 3.4 .2 .8 0 1.7 .1 2.5 .1 1.3 0 2.6 .1 3.9 .1 .7 .1 1.4 .1 2.1 .1 2 .1 4 .1 6 .1s4-.1 6-.1c.7 0 1.4-.1 2.1-.1 1.3 0 2.6 0 3.9-.1 .8 0 1.7-.1 2.5-.1 1.1-.1 2.3-.1 3.4-.2 .9 0 1.8-.1 2.7-.2 1-.1 2.1-.2 3.1-.3s1.9-.2 2.9-.3c.9-.1 1.9-.2 2.9-.3s2-.3 3-.4 1.9-.3 2.8-.4c1-.2 2.1-.3 3.1-.5 .9-.1 1.7-.3 2.6-.4 65.6-11 122.5-47.7 160.1-102.4 .2-.2 .3-.5 .5-.7 .8-1.1 1.5-2.2 2.3-3.3 .2-.4 .5-.8 .8-1.2 .7-1.1 1.4-2.1 2.1-3.2 .3-.5 .6-.9 .9-1.4 .6-1.1 1.3-2.1 2-3.2 .3-.5 .6-.9 .9-1.4 .7-1.1 1.3-2.2 2-3.3 .2-.4 .5-.8 .7-1.2 2.4-4 4.6-8.1 6.8-12.2 .1-.2 .2-.3 .3-.5 .6-1.1 1.1-2.2 1.7-3.3 .2-.6 .5-1.1 .8-1.7 .5-1 1-2.1 1.5-3.1 .3-.7 .6-1.3 .9-2 .5-1 1-2 1.4-3l.9-2.1c.5-1 .9-2 1.3-3 .3-.7 .6-1.5 .9-2.2l1.2-3c.3-.8 .6-1.5 .9-2.3 .4-1 .7-2 1.1-3s.7-1.9 1-2.8c.6-1.6 1.2-3.3 1.7-4.9 .3-1 .6-1.9 .9-2.8s.5-1.8 .8-2.7c.2-.9 .5-1.9 .8-2.8s.6-1.8 .8-2.7c.3-1 .5-1.9 .8-2.9 .2-.9 .5-1.8 .7-2.7 .2-1 .5-2 .7-3 .2-.9 .4-1.7 .6-2.6 .2-1 .5-2.1 .7-3.2 .2-.8 .3-1.6 .5-2.4 .3-1.3 .6-2.7 .8-4 .1-.6 .2-1.1 .3-1.7l.9-5.7c.1-.6 .2-1.3 .3-1.9 .1-1.3 .3-2.6 .5-3.9 .1-.8 .2-1.5 .3-2.3 .1-1.2 .3-2.4 .4-3.6 0-.8 .1-1.6 .2-2.4 .1-1.1 .2-2.3 .3-3.5 .1-.8 .1-1.6 .2-2.4 .1 1.7 .1 .5 .2-.7 0-.8 .1-1.5 .1-2.3 .1-1.3 .2-2.7 .2-4 .1-.7 .1-1.3 .1-2 .1-2 .1-4 .1-6 0-53.5-16.9-103-45.8-143.7zM448 371.5c-9.4 15.5-20.6 29.9-33.6 42.9-20.6 20.6-44.5 36.7-71.2 48-13.9 5.8-28.2 10.3-42.9 13.2l0-75.8c0-58.6-88.6-58.6-88.6 0l0 75.8c-14.7-2.9-29-7.3-42.9-13.2-26.7-11.3-50.6-27.4-71.2-48-13-13-24.2-27.4-33.6-42.9l0-71.3c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 25.8 29.6 0 0-144c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-4.8 6.5-3.7 9.5-3.7l0-90.2c-4.4-2-7.4-6.7-7.4-11.5 0-16.8 25.4-16.8 25.4 0 0 4.8-3 9.4-7.4 11.5l0 3.9c6.3-1.4 12.7-2.3 19.2-2.3 9.4 0 18.4 3.5 26.3 3.5 7.2 0 15.2-3.5 19.4-3.5 2.1 0 3.7 1.6 3.7 3.7l0 48.4c0 5.6-18.7 6.5-22.4 6.5-8.6 0-16.6-3.5-25.4-3.5-7 0-14.1 1.2-20.8 2.8l0 30.7c3 0 9.5-1.1 9.5 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 25.9 29.5 0 0-25.9c0-2.1 1.6-3.7 3.7-3.7l22.1 0c2.1 0 3.7 1.6 3.7 3.7l0 144 29.5 0 0-25.8c0-2.1 1.6-3.7 3.7-3.7l22.2 0c2.1 0 3.7 1.6 3.7 3.7l0 71.3z"],
    "buromobelexperte": [448, 512, [], "f37f", "M0 32l0 128 128 0 0-128-128 0zM120 152l-112 0 0-112 112 0 0 112zM160 32l0 128 128 0 0-128-128 0zM280 152l-112 0 0-112 112 0 0 112zM320 32l0 128 128 0 0-128-128 0zM440 152l-112 0 0-112 112 0 0 112zM0 192l0 128 128 0 0-128-128 0zM120 312l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM280 312l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM440 312l-112 0 0-112 112 0 0 112zM0 352l0 128 128 0 0-128-128 0zM120 472l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0zM280 472l-112 0 0-112 112 0 0 112zm40-120l0 128 128 0 0-128-128 0z"],
    "bilibili": [512, 512, [], "e3d9", "M488.6 104.1c16.7 18.1 24.4 39.7 23.3 65.7l0 202.4c-.4 26.4-9.2 48.1-26.5 65.1-17.2 17-39.1 25.9-65.5 26.7L92 464c-26.4-.8-48.2-9.8-65.3-27.2-17.1-17.4-26-40.3-26.7-68.6L0 169.8c.8-26 9.7-47.6 26.7-65.7 17.1-16.3 38.8-25.3 65.3-26.1l29.4 0-25.4-25.8c-5.7-5.7-8.6-13-8.6-21.8s2.9-16.1 8.6-21.8 13-8.6 21.9-8.6 16.1 2.9 21.9 8.6l73.3 69.4 88 0 74.5-69.4C381.7 2.9 389.2 0 398 0s16.1 2.9 21.9 8.6c5.7 5.7 8.6 13 8.6 21.8s-2.9 16.1-8.6 21.8L394.6 78 423.9 78c26.4 .8 48 9.8 64.7 26.1zm-38.8 69.7c-.4-9.6-3.7-17.4-10.7-23.5-5.2-6.1-14-9.4-22.7-9.8l-320.4 0c-9.6 .4-17.4 3.7-23.6 9.8-6.1 6.1-9.4 13.9-9.8 23.5l0 194.4c0 9.2 3.3 17 9.8 23.5s14.4 9.8 23.6 9.8l320.4 0c9.2 0 17-3.3 23.3-9.8s9.7-14.3 10.1-23.5l0-194.4zM185.5 216.5c6.3 6.3 9.7 14.1 10.1 23.2l0 33.3c-.4 9.2-3.7 16.9-9.8 23.2-6.2 6.3-14 9.5-23.6 9.5s-17.5-3.2-23.6-9.5-9.4-14-9.8-23.2l0-33.3c.4-9.1 3.8-16.9 10.1-23.2s13.2-9.6 23.3-10c9.2 .4 17 3.7 23.3 10zm191.5 0c6.3 6.3 9.7 14.1 10.1 23.2l0 33.3c-.4 9.2-3.7 16.9-9.8 23.2s-14 9.5-23.6 9.5-17.4-3.2-23.6-9.5c-7-6.3-9.4-14-9.7-23.2l0-33.3c.3-9.1 3.7-16.9 10-23.2s14.1-9.6 23.3-10c9.2 .4 17 3.7 23.3 10z"],
    "neos": [448, 512, [], "f612", "M383.8 512l-95.1 0-108.2-154.5 0 91.1-86.4 63.4-97.7 0 0-482.2 40.5-29.8 108 0 123.7 176.1 0-112.7 86.4-63.4 97.7 0 0 461.5-68.9 50.5zM7.2 35.3l0 460.7 72-52.9 0-249.1 215.5 307.6 84.8 0 52.4-38.2-78.3 0-316.1-450.5-30.2 22.3zM89.7 501.9l80-58.8 0-101-79.8-114.4 0 220.9-72.6 53.3 72.3 0 0 0zM49 10.8l310.6 442.6 82.4 0 0-442.6-79.8 0 0 317.6-222.9-317.6-90.3 0zM279.4 191.6l72 102.8 0-278.5-72 53 0 122.7z"],
    "dev": [448, 512, [], "f6cc", "M120.1 208.3c-3.9-2.9-7.8-4.3-11.6-4.3l-17.4 0 0 104.5 17.4 0c3.9 0 7.8-1.4 11.6-4.3s5.8-7.3 5.8-13.1l0-69.7c0-5.8-2-10.2-5.8-13.1zM404.1 32L43.9 32C19.7 32 .1 51.6 0 75.8L0 436.2C.1 460.4 19.7 480 43.9 480l360.2 0c24.2 0 43.8-19.6 43.9-43.8l0-360.4C447.9 51.6 428.3 32 404.1 32zM154.2 291.2c0 18.8-11.6 47.3-48.4 47.3l-46.4 0 0-165.5 47.4 0c35.4 0 47.4 28.5 47.4 47.3l0 70.9zm100.7-88.7l-53.3 0 0 38.4 32.6 0 0 29.6-32.6 0 0 38.4 53.3 0 0 29.6-62.2 0c-11.2 .3-20.4-8.5-20.7-19.7l0-125.1c-.3-11.1 8.6-20.4 19.7-20.7l63.2 0 0 29.5zM358.5 317.8c-13.2 30.7-36.8 24.6-47.4 0l-38.5-144.8 32.6 0 29.7 113.7 29.6-113.7 32.6 0-38.5 144.8z"],
    "hotjar": [512, 512, [], "f3b1", "M361.8 0c0 131.6-80.7 176.8-140.2 209.4-.6 .3-1.1 .6-1.6 .9-53.8 30.2-88.7 49.8-89.6 122l-98.1 0c0-131.5 80.7-176.7 140.2-209.3 54.8-29.8 90.3-50 90.3-123l99 0zM301.3 302.6c54.8-29.8 90.3-50 90.3-123l98 0c0 131.6-80.7 176.7-140.2 209.4-54.8 29.8-90.3 50-90.3 123l-98 0c0-131.6 80.7-176.8 140.2-209.4z"],
    "dochub": [448, 512, [], "f394", "M413.9 160L272 160 272 19.6 413.9 160zM320 192l0 130c0 66.8-36.5 100.1-113.3 100.1l-94.7 0 0-337.3 94.7 0c12 0 23.1 .8 33.1 2.5l0-84C228.9 1.1 217.4 0 205.2 0L16 0 16 512 205.2 512C345.7 512 416 447.4 416 318.1l0-126.1-96 0z"],
    "vimeo": [448, 512, [], "f40a", "M403.2 32L44.8 32C20.1 32 0 52.1 0 76.8L0 435.2C0 459.9 20.1 480 44.8 480l358.4 0c24.7 0 44.8-20.1 44.8-44.8l0-358.4C448 52.1 427.9 32 403.2 32zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2L53.4 191.3c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3 .9 49 22.5 47.1 64.7z"],
    "maxcdn": [512, 512, [], "f136", "M461.1 442.7l-97.4 0 51.9-242.7c2.3-10.2 .9-19.5-4.4-25.7-5-6.1-13.7-9.6-24.2-9.6l-49.3 0-59.5 278-97.4 0 59.5-278-83.4 0-59.5 278-97.4 0 59.5-278-44.6-95.4 372.1 0c39.4 0 75.3 16.3 98.3 44.9 23.3 28.6 31.8 67.4 23.6 105.9L461.1 442.7z"],
    "square-font-awesome-stroke": [448, 512, ["font-awesome-alt"], "f35c", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm154 58c0 9.3-4.8 17.4-12.1 22l188.9 0c7.3 0 13.2 5.9 13.2 13.2 0 1.8-.4 3.7-1.1 5.4L312 264 342.9 333.4c.8 1.7 1.1 3.5 1.1 5.4 0 7.3-5.9 13.2-13.2 13.2l-186.8 0 0 32-32 0 0-209.5c-6.1-4.8-10-12.2-10-20.5 0-14.4 11.6-26 26-26s26 11.6 26 26z"],
    "speakap": [448, 512, [], "f3f3", "M64.4 391.8C-15 303.6-7.6 167.4 81.1 87.6s224.8-73 304.2 15.2 72 224.4-16.6 304.1c-18.7 16.9 64 43.1 42 52.3-82.1 34.2-253.9 35-346.2-67.5l0 0zM277.7 180.2l38.5-40.9c-9.6-8.9-32-26.8-76.2-27.6-52.3-.9-95.9 28.3-96.8 80-.2 11.3 .3 36.7 29.4 54.8 34.5 21.4 86.5 21.5 86 52.3-.4 21.3-26.4 25.8-38.6 25.6-3 0-30.2-.5-47.6-24.6l-40 42.6c28.2 27 59 32.6 83.5 33 10.2 .2 96.4 .3 97.8-81 .3-15.8-2.1-39.7-28.9-56.6-34.4-21.6-85-19.4-84.4-49.7 .4-23.3 31-25.4 37.5-25.3 .4 0 26.6 .3 39.6 17.4l0 0z"],
    "fantasy-flight-games": [512, 512, [], "f6dc", "M256 32.9L32.9 256 256 479.1 479.1 256 256 32.9zM88.3 255.8c2-2 11.9-12.3 96.5-97.5 41.4-41.8 86.2-43.8 119.8-18.7 24.6 18.4 62.1 58.9 62.1 59 .7 .7 1.1 2.9 .6 3.4-11.3 11.8-22.7 23.5-33.5 34.7-34.2-32.3-40.5-38.2-48.5-44-17.8-12.7-41.4-10.1-57 5.1-2.2 2.1-1.8 3.4 .1 5.4 2.9 2.9 28.1 28.3 35.1 35.8-11.9 11.6-23.7 23-35.7 34.7-12-12.5-24.5-25.5-36.5-38.1-21.4 21.1-41.7 41.1-61.8 61L88.3 255.8zM323.2 357.4c-35.5 35.4-78.1 38.1-107 20.5-22.1-13.5-39.4-32.1-72.9-66.8 12-12.4 23.8-24.4 35.4-36.3 33 31.9 37.1 36 44.7 42.1 18.5 14.7 42.5 13.7 59.3-1.8 3.7-3.4 3.7-3.6 .1-7.2-10.6-10.7-21.2-21.4-31.8-32.2-1.3-1.3-3-2.5-.8-4.7 10.8-10.7 21.5-21.5 32.2-32.3 .3-.3 .6-.4 1.9-1.1 12.4 12.9 24.9 25.9 37.2 38.8 21-20.7 41.2-40.7 61.3-60.4 13.7 13.4 27.1 26.6 40.9 40-20.2 20.9-81.7 82.7-100.5 101.5zM256 0L0 256 256 512 512 256 256 0zM16 256L256 16 496 256 256 496 16 256z"],
    "linux": [448, 512, [], "f17c", "M220.9 123.3c1 .5 1.8 1.7 3 1.7 1.1 0 2.8-.4 2.9-1.5 .2-1.4-1.9-2.3-3.2-2.9-1.7-.7-3.9-1-5.5-.1-.4 .2-.8 .7-.6 1.1 .3 1.3 2.3 1.1 3.4 1.7zM199 125c1.2 0 2-1.2 3-1.7 1.1-.6 3.1-.4 3.5-1.6 .2-.4-.2-.9-.6-1.1-1.6-.9-3.8-.6-5.5 .1-1.3 .6-3.4 1.5-3.2 2.9 .1 1 1.8 1.5 2.8 1.4zM420 403.8c-3.6-4-5.3-11.6-7.2-19.7-1.8-8.1-3.9-16.8-10.5-22.4-1.3-1.1-2.6-2.1-4-2.9-1.3-.8-2.7-1.5-4.1-2 9.2-27.3 5.6-54.5-3.7-79.1-11.4-30.1-31.3-56.4-46.5-74.4-17.1-21.5-33.7-41.9-33.4-72 .5-45.9 5.1-131.2-75.8-131.3-102.4-.2-76.8 103.4-77.9 135.2-1.7 23.4-6.4 41.8-22.5 64.7-18.9 22.5-45.5 58.8-58.1 96.7-6 17.9-8.8 36.1-6.2 53.3-6.5 5.8-11.4 14.7-16.6 20.2-4.2 4.3-10.3 5.9-17 8.3s-14 6-18.5 14.5c-2.1 3.9-2.8 8.1-2.8 12.4 0 3.9 .6 7.9 1.2 11.8 1.2 8.1 2.5 15.7 .8 20.8-5.2 14.4-5.9 24.4-2.2 31.7 3.8 7.3 11.4 10.5 20.1 12.3 17.3 3.6 40.8 2.7 59.3 12.5 19.8 10.4 39.9 14.1 55.9 10.4 11.6-2.6 21.1-9.6 25.9-20.2 12.5-.1 26.3-5.4 48.3-6.6 14.9-1.2 33.6 5.3 55.1 4.1 .6 2.3 1.4 4.6 2.5 6.7l0 .1c8.3 16.7 23.8 24.3 40.3 23 16.6-1.3 34.1-11 48.3-27.9 13.6-16.4 36-23.2 50.9-32.2 7.4-4.5 13.4-10.1 13.9-18.3 .4-8.2-4.4-17.3-15.5-29.7zM223.8 87.3c9.8-22.2 34.2-21.8 44-.4 6.5 14.2 3.6 30.9-4.3 40.4-1.6-.8-5.9-2.6-12.6-4.9 1.1-1.2 3.1-2.7 3.9-4.6 4.8-11.8-.2-27-9.1-27.3-7.3-.5-13.9 10.8-11.8 23-4.1-2-9.4-3.5-13-4.4-1-6.9-.3-14.6 2.9-21.8zM183.1 75.8c10.1 0 20.8 14.2 19.1 33.5-3.5 1-7.1 2.5-10.2 4.6 1.2-8.9-3.3-20.1-9.6-19.6-8.4 .7-9.8 21.2-1.8 28.1 1 .8 1.9-.2-5.9 5.5-15.6-14.6-10.5-52.1 8.4-52.1zm-13.6 60.7c6.2-4.6 13.6-10 14.1-10.5 4.7-4.4 13.5-14.2 27.9-14.2 7.1 0 15.6 2.3 25.9 8.9 6.3 4.1 11.3 4.4 22.6 9.3 8.4 3.5 13.7 9.7 10.5 18.2-2.6 7.1-11 14.4-22.7 18.1-11.1 3.6-19.8 16-38.2 14.9-3.9-.2-7-1-9.6-2.1-8-3.5-12.2-10.4-20-15-8.6-4.8-13.2-10.4-14.7-15.3-1.4-4.9 0-9 4.2-12.3zm3.3 334c-2.7 35.1-43.9 34.4-75.3 18-29.9-15.8-68.6-6.5-76.5-21.9-2.4-4.7-2.4-12.7 2.6-26.4l0-.2c2.4-7.6 .6-16-.6-23.9-1.2-7.8-1.8-15 .9-20 3.5-6.7 8.5-9.1 14.8-11.3 10.3-3.7 11.8-3.4 19.6-9.9 5.5-5.7 9.5-12.9 14.3-18 5.1-5.5 10-8.1 17.7-6.9 8.1 1.2 15.1 6.8 21.9 16l19.6 35.6c9.5 19.9 43.1 48.4 41 68.9zm-1.4-25.9c-4.1-6.6-9.6-13.6-14.4-19.6 7.1 0 14.2-2.2 16.7-8.9 2.3-6.2 0-14.9-7.4-24.9-13.5-18.2-38.3-32.5-38.3-32.5-13.5-8.4-21.1-18.7-24.6-29.9s-3-23.3-.3-35.2c5.2-22.9 18.6-45.2 27.2-59.2 2.3-1.7 .8 3.2-8.7 20.8-8.5 16.1-24.4 53.3-2.6 82.4 .6-20.7 5.5-41.8 13.8-61.5 12-27.4 37.3-74.9 39.3-112.7 1.1 .8 4.6 3.2 6.2 4.1 4.6 2.7 8.1 6.7 12.6 10.3 12.4 10 28.5 9.2 42.4 1.2 6.2-3.5 11.2-7.5 15.9-9 9.9-3.1 17.8-8.6 22.3-15 7.7 30.4 25.7 74.3 37.2 95.7 6.1 11.4 18.3 35.5 23.6 64.6 3.3-.1 7 .4 10.9 1.4 13.8-35.7-11.7-74.2-23.3-84.9-4.7-4.6-4.9-6.6-2.6-6.5 12.6 11.2 29.2 33.7 35.2 59 2.8 11.6 3.3 23.7 .4 35.7 16.4 6.8 35.9 17.9 30.7 34.8-2.2-.1-3.2 0-4.2 0 3.2-10.1-3.9-17.6-22.8-26.1-19.6-8.6-36-8.6-38.3 12.5-12.1 4.2-18.3 14.7-21.4 27.3-2.8 11.2-3.6 24.7-4.4 39.9-.5 7.7-3.6 18-6.8 29-32.1 22.9-76.7 32.9-114.3 7.2zm257.4-11.5c-.9 16.8-41.2 19.9-63.2 46.5-13.2 15.7-29.4 24.4-43.6 25.5s-26.5-4.8-33.7-19.3c-4.7-11.1-2.4-23.1 1.1-36.3 3.7-14.2 9.2-28.8 9.9-40.6 .8-15.2 1.7-28.5 4.2-38.7 2.6-10.3 6.6-17.2 13.7-21.1 .3-.2 .7-.3 1-.5 .8 13.2 7.3 26.6 18.8 29.5 12.6 3.3 30.7-7.5 38.4-16.3 9-.3 15.7-.9 22.6 5.1 9.9 8.5 7.1 30.3 17.1 41.6 10.6 11.6 14 19.5 13.7 24.6zM173.4 148.7c2 1.9 4.7 4.5 8 7.1 6.6 5.2 15.8 10.6 27.3 10.6 11.6 0 22.5-5.9 31.8-10.8 4.9-2.6 10.9-7 14.8-10.4s5.9-6.3 3.1-6.6-2.6 2.6-6 5.1c-4.4 3.2-9.7 7.4-13.9 9.8-7.4 4.2-19.5 10.2-29.9 10.2s-18.7-4.8-24.9-9.7c-3.1-2.5-5.7-5-7.7-6.9-1.5-1.4-1.9-4.6-4.3-4.9-1.4-.1-1.8 3.7 1.7 6.5z"],
    "cotton-bureau": [512, 512, [], "f89e", "M474.3 330.4C450.6 422.3 380.1 475 272.4 478.8l0-49.2c0-48 26.4-74.4 74.4-74.4 62 0 99.2-37.2 99.2-99.2 0-61.4-36.5-98.3-97.4-99.1-33-69.3-146.5-64.7-177.2 0-60.9 .8-97.4 37.7-97.4 99.1 0 62.1 37.3 99.4 99.4 99.4 48 0 74.6 26.2 74.6 74.4l0 49.2c-134.4-5-211.1-85.1-211.1-223 0-141.8 81.4-223.2 223.2-223.2 114.8 0 189.8 53.2 214.7 148.8l25.3 0C473.9 71.5 388.2 8 259.8 8 105 8 12 101.2 12 255.8 12 411.1 105.2 504.3 259.8 504 388.1 504 473.7 440.2 499.5 330.4l-25.2 0zM357 182.3c41.4 3.4 64.2 29 64.2 73.7 0 48-26.4 74.4-74.4 74.4-28.6 0-49.3-9.6-61.6-27.3 83.1-16.5 75.6-99.7 71.8-120.7zm-81.7 97.4c-2.5-10.3-16.3-87 56.2-97 2.3 10.1 16.5 87.1-56.3 97l0 0zM260 132c28.6 0 49 9.7 61.4 27.6-28.4 5.5-49.4 20.6-61.6 43.4-12.2-22.9-33.2-38-61.6-43.4 12.4-17.7 33.3-27.4 61.6-27.4l.2-.3zm-71.5 50.7c73.2 10.6 58.9 86.8 56.5 97-72.4-9.8-59-87-56.2-97l-.2 0zM173.2 330.4c-48 0-74.4-26.4-74.4-74.4 0-44.4 22.9-70 64.2-73.7-6.8 37.2-1.4 106.5 71.6 120.7-12.1 17.6-32.8 27.3-61.1 27.3l-.3 0zm53.2 12.4c14.3-7.6 26-19.3 33.6-33.5 7.8 14.5 19.3 25.5 33.8 33.5-14.4 7.6-26.1 19.4-33.6 33.8-8-14.5-19.1-26.2-33.6-33.8l-.3 0z"],
    "google-wallet": [448, 512, [], "f1ee", "M156.8 126.8c37.6 60.6 64.2 113.1 84.3 162.5-8.3 33.8-18.8 66.5-31.3 98.3-13.2-52.3-26.5-101.3-56-148.5 6.5-36.4 2.3-73.6 3-112.3zM109.3 200l-93.2 0c-6.5 0-10.5 7.5-6.5 12.7 42.2 54.3 71.7 117.8 91.7 187.3l103.5 0c-16.2-69.7-38.7-133.7-82.5-193.5-3-4-8-6.5-13-6.5zm47.8-88c68.5 108 130 234.5 138.2 368L409 480c-12-138-68.4-265-143.2-368l-108.7 0zM408.9 43.5c-1.8-6.8-8.2-11.5-15.2-11.5l-88.3 0c-5.3 0-9 5-7.8 10.3 13.2 46.5 22.3 95.5 26.5 146 48.2 86.2 79.7 178.3 90.6 270.8 15.8-60.5 25.3-133.5 25.3-203 0-73.6-12.1-145.1-31.1-212.6z"],
    "foursquare": [384, 512, [], "f180", "M331.1 3L57.9 3C20.4 3 8 31.3 8 49.1L8 482.9c0 20.3 12.1 27.7 18.2 30.1 6.2 2.5 22.8 4.6 32.9-7.1 128.9-149.4 131.1-151.9 131.1-151.9 3.1-3.4 3.4-3.1 6.8-3.1l83.4 0c35.1 0 40.6-25.2 44.3-39.7l48.6-243C381.8 25.8 371.1 3 331.1 3zM314.8 76.8l-11.4 59.7c-1.2 6.5-9.5 13.2-16.9 13.2l-106.4 0c-12 0-20.6 8.3-20.6 20.3l0 13c0 12 8.6 20.6 20.6 20.6l90.4 0c8.3 0 16.6 9.2 14.8 18.2-1.8 8.9-10.5 53.8-11.4 58.8-.9 4.9-6.8 13.5-16.9 13.5l-73.5 0c-13.5 0-17.2 1.8-26.5 12.6 0 0-8.9 11.4-89.5 108.3-.9 .9-1.8 .6-1.8-.3l0-338.8c0-7.7 6.8-16.6 16.6-16.6l219 0c8.2 0 15.6 7.7 13.5 17.5z"],
    "shirtsinbulk": [448, 512, [], "f214", "M100 410.3l30.6 13.4 4.4-9.9-30.6-13.4-4.4 9.9zm39.4 17.5l30.6 13.4 4.4-9.9-30.6-13.4-4.4 9.9zm172.1-14l4.4 9.9 30.6-13.4-4.4-9.9-30.6 13.4zM179.1 445l30.3 13.7 4.4-9.9-30.3-13.4-4.4 9.6zM60.4 392.8l30.6 13.4 4.4-9.6-30.6-13.7-4.4 9.9zm211.4 38.5l4.4 9.9 30.6-13.4-4.4-9.9-30.6 13.4zm-39.3 17.5l4.4 9.9 30.6-13.7-4.4-9.6-30.6 13.4zm118.4-52.2l4.4 9.6 30.6-13.4-4.4-9.9-30.6 13.7zM170 46.6l-33.5 0 0 10.5 33.5 0 0-10.5zm-47.2 0l-33.6 0 0 10.5 33.5 0 .1-10.5zm-47.3 0l-33.2 0 0 10.5 33.3 0-.1-10.5zm141.5 0l-33.2 0 0 10.5 33.2 0 0-10.5zm94.5 0l-33.5 0 0 10.5 33.5 0 0-10.5zm47.3 0l-33.5 0 0 10.5 33.5 0 0-10.5zm-94.6 0l-33.2 0 0 10.5 33.2 0 0-10.5zm141.5 0l-33.3 0 0 10.5 33.3 0 0-10.5zM52.8 351.1l-10.8 0 0 33.5 10.8 0 0-33.5zm70-215.9l-33.6 0 0 10.5 33.5 0 .1-10.5zm-70 10.6l22.8 0 0-10.5-33.6 0 0 33.5 10.8 0 0-23zM221.7 374.4a91.3 91.3 0 1 0 0-182.6 91.3 91.3 0 1 0 0 182.6zM173.5 263.3c0-25.4 29.5-31.8 49.6-31.8 16.9 0 29.2 5.8 44.3 12l-8.8 16.9-.9 0c-6.4-9.9-24.8-13.1-35.6-13.1-9 0-29.8 1.8-29.8 14.9 0 21.6 78.5-10.2 78.5 37.9 0 25.4-31.5 31.2-51 31.2-18.1 0-32.4-2.9-47.2-12.2l9-18.4 .9 0c6.1 12.2 23.6 14.9 35.9 14.9 8.7 0 32.7-1.2 32.7-14.3 0-26.1-77.6 6.3-77.6-38zM52.8 178.4l-10.8 0 0 33.6 10.8 0 0-33.6zM395.2 384.6l10.8 0 0-33.5-10.8 0 0 33.5zM52.8 307.9l-10.8 0 0 33.5 10.8 0 0-33.5zM0 3.7l0 406 221.7 98.6 226.3-98.6 0-406-448 0zM418.8 390.8l-196.8 85.7-192.8-85.7 0-270.1 389.7 0 0 270.1-.1 0zm0-299.3l-389.6 0 0-58.6 389.7 0 0 58.6-.1 0zM52.8 221.6l-10.8 0 0 33.5 10.8 0 0-33.5zm0 43.2l-10.8 0 0 33.5 10.8 0 0-33.5zM170 135.2l-33.5 0 0 10.5 33.5 0 0-10.5zM395.2 298.3l10.8 0 0-33.5-10.8 0 0 33.5zm0-43.2l10.8 0 0-33.5-10.8 0 0 33.5zM217 135.2l-33.2 0 0 10.5 33.2 0 0-10.5zM395.2 212l10.8 0 0-33.5-10.8 0 0 33.5zm0 129.5l10.8 0 0-33.5-10.8 0 0 33.5zm-131-206.3l-33.2 0 0 10.5 33.2 0 0-10.5zm47.3 0l-33.5 0 0 10.5 33.5 0 0-10.5zm83.7 33.6l10.8 0 0-33.5-33.5 0 0 10.5 22.8 0-.1 23zm-36.4-33.6l-33.5 0 0 10.5 33.5 0 0-10.5z"],
    "mintbit": [512, 512, [], "e62f", "M73.2 512l0-73.1 292.5 0 0-73.2 73.2 0 0-146.3 73.1 0 0-219.4-219.4 0 0 73.1-146.3 0 0 73.2-73.1 0 0 292.6-73.2 0 0 73.1 73.2 0zm73.1-219.4l73.2 0 0 73.1-73.2 0 0-73.1zm73.2-73.1l73.1 0 0 73.1-73.2 0 0-73.2 .1 .1zm73.1 0l0-73.2 73.2 0 0 73.1-73.2 0 0 .1zM365.7 73.1l73.2 0 0 73.2-73.2 0 0-73.2z"],
    "staylinked": [448, 512, [], "f3f5", "M386.7 292.5l2.7 2.7-170-167.3c-3.5-3.5-9.7-3.7-13.8-.5L148.3 171c-4.2 3.2-4.6 8.7-1.1 12.2l68.1 64.3c3.6 3.5 9.9 3.7 14 .5l.1-.1c4.1-3.2 10.4-3 14 .5l84 81.3c3.6 3.5 3.2 9-.9 12.2l-93.2 74c-4.2 3.3-10.5 3.1-14.2-.4L67.2 268c-3.5-3.5-9.7-3.7-13.9-.5L7.5 302.4c-4.2 3.2-4.7 8.7-1.2 12.2L215 510.7s7.4 6.8 17.3-.8L430.3 346c4-3.2 4.4-8.7 .7-12.2l-44.3-41.3zm54.5-83.4L230.7 2.5c-1.5-1.2-8-5.5-16.3 1.1L7.6 165.7c-4.2 3.2-4.8 8.7-1.2 12.2l42.3 41.7 171.7 165.1c3.7 3.5 10.1 3.7 14.3 .4l50.2-38.8-.3-.3 7.7-6c4.2-3.2 4.6-8.7 .9-12.2l-57.1-54.4c-3.6-3.5-10-3.7-14.2-.5l-.1 .1c-4.2 3.2-10.5 3.1-14.2-.4L113 180.8c-3.6-3.5-3.1-8.9 1.1-12.2l92.2-71.5c4.1-3.2 10.3-3 13.9 .5l160.4 159c3.7 3.5 10 3.7 14.1 .5l45.8-35.8c4.1-3.2 4.4-8.7 .7-12.2z"],
    "webflow": [640, 512, [], "e65c", "M640 64l-204.2 399.2-191.8 0 85.5-165.5-3.8 0C255.1 389.3 149.9 449.5 0 463.2L0 300.1s95.9-5.7 152.3-64.9l-152.3 0 0-171.2 171.1 0 0 140.8 3.8 0 70-140.8 129.4 0 0 139.9 3.8 0 72.6-139.9 189.3 0z"],
    "renren": [512, 512, [], "f18b", "M214 169.1C214 279.5 153 374.5 66.4 416.5 30 373.2 8 317.7 8 256.6 8 133.9 97.1 32.2 214 12.5l0 156.6zM255 504c-42.9 0-83.3-11-118.5-30.4 57.2-36.1 103.4-90.7 118.5-154.6 15.5 63.9 61.7 118.5 118.8 154.7-35.1 19.3-75.5 30.3-118.8 30.3zm190.6-87.5C359 374.5 298 279.6 298 169.1l0-156.6c116.9 19.7 206 121.4 206 244.1 0 61.1-22 116.6-58.4 159.9z"],
    "rev": [448, 512, [], "f5b2", "M158.7 274.9a65.6 65.6 0 1 1 131.2 0 65.6 65.6 0 1 1 -131.2 0zm270.7-5.1l-.1 0c-.7-29.3-7.7-58.2-20.5-84.6s-31.2-49.7-53.8-68.4L309.6 143c22 14.2 40.1 33.8 52.7 56.8s19.1 48.8 19.1 75.1c0 86.6-70.5 157.1-157.1 157.1S67.2 361.5 67.2 274.9c0-81.9 63-149.3 143-156.4l0 39.1 108.8-62.8-108.8-62.8 0 38.3c-106.7 7.2-191 96-191 204.6 0 111.6 89.1 202.3 200.1 205l0 .1 210.2 0 0-210.2z"],
    "keycdn": [512, 512, [], "f3ba", "M63.8 409.3l60.5-59c32.1 42.8 71.1 66 126.6 67.4 30.5 .7 60.3-7 86.4-22.4 5.1 5.3 18.5 19.5 20.9 22-32.2 20.7-69.6 31.1-108.1 30.2-43.3-1.1-84.6-16.7-117.7-44.4 .3-.6-38.2 37.5-38.6 37.9 9.5 29.8-13.1 62.4-46.3 62.4-26.8-.1-47.5-21.7-47.5-48.5 0-34.3 33.1-56.6 63.8-45.6zM418.7 156.9c19.1 31.3 29.6 67.4 28.7 104-1.1 44.8-19 87.5-48.6 121 .3 .3 23.8 25.2 24.1 25.5 9.6-1.3 19.2 2 25.9 9.1 11.3 12 10.9 30.9-1.1 42.4-12 11.3-30.9 10.9-42.4-1.1-6.7-7-9.4-16.8-7.6-26.3-24.9-26.6-44.4-47.2-44.4-47.2 42.7-34.1 63.3-79.6 64.4-124.2 .7-28.9-7.2-57.2-21.1-82.2l22.1-21zM104 53.1c6.7 7 9.4 16.8 7.6 26.3l45.9 48.1c-4.7 3.8-13.3 10.4-22.8 21.3-25.4 28.5-39.6 64.8-40.7 102.9-.7 28.9 6.1 57.2 20 82.4L92 355.6c-19.3-31.6-28.9-67.7-27.8-104.7 1-44.6 18.3-87.6 47.5-121.1L86.4 103.4c-9.6 1.3-19.2-2-25.9-9.1-11.3-12-10.9-30.9 1.1-42.4 11.9-11.2 30.6-10.9 42.4 1.2zM464.9 8c26 0 47.1 22.4 47.1 48.3S490.9 104 464.9 104c-6.3 .1-14-1.1-15.9-1.8l-62.9 59.7c-32.7-43.6-76.7-65.9-126.9-67.2-30.5-.7-60.3 6.8-86.2 22.4l-21.1-22C184.1 74.3 221.5 64 260 64.9 303.3 66 344.6 81.6 377.7 109.5l41.1-38.6c-1.5-4.7-2.2-9.6-2.2-14.5-.1-26.7 22.3-48.4 48.3-48.4zM256.7 113.4c5.5 0 10.9 .4 16.4 1.1 78.1 9.8 133.4 81.1 123.8 159.1-9.8 78.1-81.1 133.4-159.1 123.8-78.1-9.8-133.4-81.1-123.8-159.2 9.3-72.4 70.1-124.6 142.7-124.8zm-59 119.4c.6 22.7 12.2 41.8 32.4 52.2l-11 51.7 73.7 0-11-51.7c20.1-10.9 32.1-29 32.4-52.2-.4-32.8-25.8-57.5-58.3-58.3-32.1 .8-57.3 24.8-58.2 58.3z"],
    "hire-a-helper": [512, 512, [], "f3b0", "M443.1 0L71.9 0C67.9 37.3 37.4 67.8 0 71.7L0 443.2c37.4 4.9 66 32.4 71.9 68.8l372.2 0c3-36.4 32.5-65.8 67.9-69.8l0-370.5C475.6 65.8 447 36.4 443.1 0zm-37 404.9c-36.3 0-18.8-2-55.1-2-35.8 0-21 2-56.1 2-5.9 0-4.9-8.2 0-9.8 22.8-7.6 22.9-10.2 24.6-12.8 10.4-15.6 5.9-83 5.9-113 0-5.3-6.4-12.8-13.8-12.8l-111.2 0c-7.4 0-13.8 7.5-13.8 12.8 0 30-4.5 97.4 5.9 113 1.7 2.5 1.8 5.2 24.6 12.8 4.9 1.6 6 9.8 0 9.8-35.1 0-20.3-2-56.1-2-36.3 0-18.8 2-55.1 2-7.9 0-5.8-10.8 0-10.8 10.2-3.4 13.5-3.5 21.7-13.8 7.7-12.9 7.9-44.4 7.9-127.8l0-101.2c0-22.2-12.2-28.3-28.6-32.4-8.8-2.2-4-11.8 1-11.8 36.5 0 20.6 2 57.1 2 32.7 0 16.5-2 49.2-2 3.3 0 8.5 8.3 1 10.8-4.9 1.6-27.6 3.7-27.6 39.3 0 45.6-.2 55.8 1 68.8 0 1.3 2.3 12.8 12.8 12.8l109.2 0c10.5 0 12.8-11.5 12.8-12.8 1.2-13 1-23.2 1-68.8 0-35.6-22.7-37.7-27.6-39.3-7.5-2.5-2.3-10.8 1-10.8 32.7 0 16.5 2 49.2 2 36.5 0 20.6-2 57.1-2 4.9 0 9.9 9.6 1 11.8-16.4 4.1-28.6 10.3-28.6 32.4l0 101.2c0 83.4 .1 114.9 7.9 127.8 8.2 10.2 11.4 10.4 21.7 13.8 5.8 0 7.8 10.8 0 10.8z"],
    "square-hacker-news": [448, 512, ["hacker-news-square"], "f3af", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM21 229.2s.1-.1 .1-.2 .1-.2 .2-.2c0 .1 0 .3-.1 .4l-.2 0zM239.2 384l-31.4 0 0-102.7-79.8-153.3 37.3 0c41.5 77.7 48.1 95.8 54.1 112 1.6 4.3 3.1 8.5 5.2 13.6 3.2-7 5.1-11.9 7.1-17.3 5.9-15.3 12.8-33.2 53.5-108.3l34.8 0-80.8 155.1 0 100.9z"],
    "creative-commons-pd-alt": [512, 512, [], "f4ed", "M255.6 8C112.7 8 8 123.1 8 256 8 394.5 121.6 504 255.6 504 385.5 504 504 403.1 504 256 504 118.1 397.4 8 255.6 8zm.8 450.8c-112.5 0-203.7-93-203.7-202.8 0-105.4 85.5-203.3 203.7-203.3 112.6 0 202.9 89.5 202.8 203.3 0 121.7-99.6 202.8-202.8 202.8zM324.7 186l-53.2 0 0 137.2 53.2 0c21.4 0 70-5.1 70-68.6 0-63.4-48.6-68.6-70-68.6zm.8 108.5l-19.9 0 0-79.7 19.4-.1c3.8 0 35-2.1 35 39.9 0 24.6-10.5 39.9-34.5 39.9zM211.7 186l-68.2 0 0 137.3 34.6 0 0-44.3 27 0c54.1 0 57.1-37.5 57.1-46.5 0-31-16.8-46.5-50.5-46.5zm-4.9 67.3l-29.2 0 0-41.6 28.3 0c30.9 0 28.8 41.6 .9 41.6z"],
    "orcid": [512, 512, [], "f8d2", "M294.7 188.2l-45.9 0 0 153.8 47.5 0c67.6 0 83.1-51.3 83.1-76.9 0-41.6-26.5-76.9-84.7-76.9zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM175.2 368.8l-29.8 0 0-207.5 29.8 0 0 207.5zM160.3 98.5a19.6 19.6 0 1 1 0 39.2 19.6 19.6 0 1 1 0-39.2zM300 369l-81 0 0-207.7 80.6 0c76.7 0 110.4 54.8 110.4 103.9 0 53.3-41.7 103.9-110 103.9z"],
    "behance": [576, 512, [], "f1b4", "M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8l-167.1 0 0 354.4 171.8 0c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9l73.1 0c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2l-79 0 0-82.7zm83.3 233.7l-83.3 0 0-97.6 84.9 0c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zM519.7 128.9l-143.7 0 0-34.9 143.7 0 0 34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3l-62.2 0c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3l185.1 0c.3-4.2 .6-8.7 .6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8l-114.7 0z"],
    "monero": [512, 512, [], "f3d0", "M360 384l108.4 0C425 455.9 346.1 504 256 504S87 455.9 43.6 384l108.4 0 0-127.8 104 104.8 104-105 0 128zM96 336l0-208 159.4 159.4 160.6-159.4 0 208 74.8 0c8.5-25.1 13.2-52 13.2-80 0-137-111-248-248-248S8 119 8 256c0 28 4.6 54.9 13.2 80L96 336z"],
    "figma": [384, 512, [], "f799", "M14 95.8C14 42.9 56.9 0 109.8 0L274.2 0c52.9 0 95.8 42.9 95.8 95.8 0 33.5-17.2 63-43.2 80.1 26 17.1 43.2 46.6 43.2 80.1 0 52.9-42.9 95.8-95.8 95.8l-2.1 0c-24.8 0-47.4-9.4-64.4-24.9l0 88.3c0 53.6-44 96.8-97.4 96.8-52.8 0-96.3-42.8-96.3-95.8 0-33.5 17.2-63 43.2-80.1-26-17.1-43.2-46.6-43.2-80.1s17.2-63 43.2-80.1C31.2 158.8 14 129.3 14 95.8zm162.3 95.8l-66.5 0c-35.6 0-64.4 28.8-64.4 64.4 0 35.4 28.6 64.2 64 64.4l66.9 0 0-128.8zM207.7 256c0 35.6 28.8 64.4 64.4 64.4l2.1 0c35.6 0 64.4-28.8 64.4-64.4s-28.8-64.4-64.4-64.4l-2.1 0c-35.6 0-64.4 28.8-64.4 64.4zm-97.9 95.8l-.4 0c-35.4 .2-64 29-64 64.4s29.2 64.4 64.9 64.4c36.3 0 66-29.4 66-65.5l0-63.4-66.5 0zm0-320.4c-35.6 0-64.4 28.8-64.4 64.4s28.8 64.4 64.4 64.4l66.5 0 0-128.8-66.5 0zm97.9 128.8l66.5 0c35.6 0 64.4-28.8 64.4-64.4s-28.8-64.4-64.4-64.4l-66.5 0 0 128.8z"],
    "instagram": [448, 512, [], "f16d", "M224.3 141a115 115 0 1 0 -.6 230 115 115 0 1 0 .6-230zm-.6 40.4a74.6 74.6 0 1 1 .6 149.2 74.6 74.6 0 1 1 -.6-149.2zm93.4-45.1a26.8 26.8 0 1 1 53.6 0 26.8 26.8 0 1 1 -53.6 0zm129.7 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM399 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"],
    "perbyte": [448, 512, [], "e083", "M305.3 284.6l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5zM149.4 128.7l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5zM366.6 32L81.4 32c-21.6 0-42.2 8.6-57.5 23.9S0 91.8 0 113.4L0 398.6c0 21.6 8.6 42.2 23.9 57.5S59.8 480 81.4 480l285.3 0c21.6 0 42.2-8.6 57.5-23.9S448 420.2 448 398.6l0-285.3c0-21.6-8.6-42.2-23.9-57.5S388.2 32 366.6 32zm63.6 366.6c0 16.9-6.7 33-18.7 45s-28.1 18.6-45 18.7l-285.3 0c-16.9 0-33-6.7-45-18.7s-18.6-28.1-18.7-45l0-285.3c0-16.9 6.7-33 18.7-45s28.1-18.6 45-18.7l285.3 0c16.9 0 33 6.7 45 18.7s18.6 28.1 18.7 45l0 285.3zm-125-269.9l-58.7 0 0 98.7 58.7 0c16.3 0 29-4.6 38.2-13.8s13.8-21.2 13.8-36.1c0-14.6-4.7-26.3-14-35.3s-22-13.5-37.9-13.5z"],
    "square-vimeo": [448, 512, ["vimeo-square"], "f194", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM318.5 309.5c-43.5 56.5-80.3 84.8-110.4 84.8-18.7 0-34.4-17.2-47.3-51.6-3.8-13.9-7.3-26.9-10.5-39-18.2-68.3-28.6-107.4-46.2-107.4-2.4 0-10.8 5-25.1 15.1L64 192c7-6.1 13.9-12.4 20.6-18.5 29.1-26.3 55.6-50.3 73.5-51.9 24.9-2.4 40.2 14.6 46 51.1 20.5 129.6 29.6 149.2 66.8 90.5 13.4-21.2 20.6-37.2 21.5-48.3 3.4-32.8-25.6-30.6-45.2-22.2 15.7-51.5 45.8-76.5 90.1-75.1 32.9 1 48.4 22.4 46.5 64-1.4 31.1-23.2 73.8-65.3 127.9z"],
    "pushed": [448, 512, [], "f3e1", "M415.1 111.9l-98.5-9 14-33.4c10.4-23.5-10.8-40.4-28.7-37L30.6 76.9c-15.1 2.7-26 18.3-21.4 36.6L114.3 461.8c6.5 21.3 36.7 24.2 47.7 7L197.3 388 432.5 156.7c16.4-16.8 4.3-42.9-17.4-44.8zM305.7 53.6c5.1-.7 7.5 2.5 5.2 7.4l-16.8 39.9-177.4-16.3 189-31zM30.8 107.9c-3.1-5.1 1-10 6.1-9.1l248.7 22.7-96.9 230.7-157.9-244.3zM144.1 456.4c-2.6 4-7.9 3.1-9.4-1.2L51.6 179.7 179.3 377.3c-7 15-35.2 79.1-35.2 79.1zM416.9 141.9l-198.7 195.4 89.7-213.7 106.4 9.7c4 1.1 5.7 5.3 2.6 8.6z"],
    "mixcloud": [640, 512, [], "f289", "M213 346.6l-33.2 0 0-151.5 6.2-21.6-10.7 0-38.1 173.1-61 0-38.4-173.1-10.5 0 5.9 21.6 0 151.5-33.2 0 0-181.6 65.7 0 36.6 173.1 8.5 0 36.6-173.1 65.7 0 0 181.6zm331.5-63l-86 62.1 0-38.1 72.9-51.8-72.9-51.8 0-38.1 86 62.3 9.3 0 86.3-62.3 0 38.1-73.1 51.8 73.1 51.8 0 38.1-86.3-62.1-9.3 0zM430.2 272.3l-182 0 0-33.1 182 0 0 33.1z"],
    "yandex-international": [320, 512, [], "f414", "M129.5 512l0-166.1-111-297.9 55.8 0 81.8 229.7 94.1-277.7 51.3 0-120.7 347.8 0 164.2-51.3 0z"],
    "hive": [512, 512, [], "e07f", "M260.4 254.9L131.5 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3-.8 .1-1.1 .3-.6 .5-.8 .8L.3 254.9c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1L129.1 478.9c.2 .3 .5 .6 .8 .8s.7 .3 1.1 .3 .8-.1 1.1-.3 .6-.5 .8-.8L260.4 257.1c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1zm39.1-25.7c.2 .3 .5 .6 .8 .8s.7 .3 1.1 .3l66.5 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8 .3-.7 .3-1.1-.1-.8-.3-1.1L259.1 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3l-66.5 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8-.3 .7-.3 1.1 .1 .8 .3 1.1L299.4 229.2zm212.3 25.7L384.9 33.1c-.2-.3-.5-.6-.8-.8s-.7-.3-1.1-.3l-66.6 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8-.3 .7-.3 1.1 .1 .8 .3 1.1L440.7 256 314.5 476.7c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1 .5 .6 .8 .8 .7 .3 1.1 .3l66.6 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8L511.7 257.1c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1zM366 284.9l-66.5 0c-.4 0-.8 .1-1.1 .3s-.6 .5-.8 .8L188.8 476.7c-.2 .3-.3 .7-.3 1.1s.1 .8 .3 1.1 .5 .6 .8 .8 .7 .3 1.1 .3l66.5 0c.4 0 .8-.1 1.1-.3s.6-.5 .8-.8L367.9 288.3c.2-.3 .3-.7 .3-1.1s-.1-.8-.3-1.1-.5-.6-.8-.8-.7-.3-1.1-.3z"],
    "creative-commons-zero": [512, 512, [], "f4f3", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm-.4 60.5c-81.9 0-102.5 77.3-102.5 142.8S174.1 398.8 256 398.8 358.5 321.5 358.5 256 337.9 113.2 256 113.2zm0 53.9c3.3 0 6.4 .5 9.2 1.2 5.9 5.1 8.8 12.1 3.1 21.9L213.8 290.4c-1.7-12.7-1.9-25.1-1.9-34.4 0-28.8 2-88.9 44.1-88.9zm40.8 46.2c2.9 15.4 3.3 31.4 3.3 42.7 0 28.9-2 88.9-44.1 88.9-13.5 0-32.6-7.7-20.1-26.4l60.9-105.2z"],
    "square-snapchat": [448, 512, ["snapchat-square"], "f2ad", "M384 32L64 32c-17 0-33.3 6.7-45.3 18.7S0 79 0 96L0 416c0 17 6.7 33.3 18.7 45.3S47 480 64 480l320 0c17 0 33.3-6.7 45.3-18.7S448 433 448 416l0-320c0-17-6.7-33.3-18.7-45.3S401 32 384 32zm-3.9 319.3l-.1 .1c-2.5 2.8-5.4 5.1-8.7 6.8-6.5 3.6-13.4 6.3-20.6 8.2-1.4 .4-2.7 1-3.9 1.8-2.2 1.9-2.1 4.6-4.4 8.6-1.7 3-4 5.5-6.8 7.5-6.7 4.6-14.2 4.9-22.2 5.2-7.2 .3-15.4 .6-24.7 3.7-3.8 1.2-7.8 3.7-12.4 6.5-11.3 6.9-26.7 16.4-52.3 16.4s-40.9-9.4-52.1-16.3c-4.7-2.9-8.7-5.4-12.5-6.6-9.3-3.1-17.5-3.4-24.7-3.7-8-.3-15.5-.6-22.2-5.2-2.4-1.6-4.4-3.7-6-6.1-3.2-4.6-2.9-7.8-5.3-9.9-1.3-.8-2.6-1.5-4.1-1.8-7.1-1.9-13.9-4.6-20.3-8.1-3.1-1.6-5.9-3.8-8.3-6.3-6.6-6.8-8.3-14.8-5.7-21.8 3.4-9.3 11.6-12.1 19.4-16.3 14.8-8 26.3-18.1 34.4-29.9 2.3-3.3 4.3-6.9 6-10.6 .8-2.2 .8-3.3 .2-4.4-.6-.9-1.3-1.6-2.2-2.2-2.5-1.7-5.1-3.4-6.9-4.5-3.3-2.1-5.9-3.8-7.5-5-6.3-4.4-10.6-9-13.4-14.2-1.9-3.6-3-7.6-3.3-11.6s.4-8.1 1.9-11.9c4.1-10.9 14.5-17.7 27-17.7 2.6 0 5.3 .3 7.8 .8 .7 .2 1.4 .3 2 .5-.1-7.4 .1-15.4 .7-23.1 2.4-27.3 11.9-41.6 21.9-53 6.4-7.2 13.9-13.2 22.3-17.9 15.1-8.6 32.2-13 50.9-13s35.8 4.4 50.9 13c8.3 4.7 15.9 10.8 22.2 17.9 10 11.4 19.5 25.7 21.9 53 .6 7.7 .9 15.4 .7 23.1 .7-.2 1.4-.3 2.1-.5 2.6-.6 5.2-.8 7.8-.8 12.5 0 22.8 6.8 27 17.7 1.5 3.8 2.1 7.9 1.9 11.9s-1.4 8-3.3 11.6c-2.7 5.2-7.1 9.9-13.4 14.2-1.7 1.2-4.3 2.9-7.5 5-1.8 1.2-4.5 2.9-7.2 4.7-.8 .5-1.4 1.2-1.9 2-.5 1-.5 2.2 .2 4.2 1.7 3.8 3.7 7.4 6.1 10.8 8.3 12.1 20.2 22.3 35.5 30.4 1.5 .8 3 1.5 4.4 2.3 .7 .3 1.6 .8 2.5 1.3 4.9 2.7 9.2 6 11.5 12.2 2.5 6.9 1 14.7-5.2 21.3zm-16.7-18.5c-50.3-24.3-58.3-61.9-58.7-64.7-.4-3.4-.9-6 2.8-9.5 3.6-3.3 19.5-13.2 24-16.3 7.3-5.1 10.5-10.2 8.2-16.5-1.7-4.3-5.7-6-10-6-1.3 0-2.7 .2-4 .4-8 1.7-15.8 5.8-20.4 6.9-.5 .1-1.1 .2-1.7 .2-2.4 0-3.3-1.1-3.1-4 .6-8.8 1.8-25.9 .4-41.9-1.9-22-9-32.9-17.4-42.6-4.1-4.6-23.1-24.7-59.5-24.7s-55.4 20.1-59.5 24.8c-8.4 9.7-15.5 20.6-17.4 42.6-1.4 16-.1 33.1 .4 41.9 .2 2.8-.7 4-3.1 4-.6 0-1.1-.1-1.7-.2-4.5-1.1-12.3-5.1-20.3-6.9-1.3-.3-2.6-.4-4-.4-4.3 0-8.3 1.6-10 6-2.4 6.3 .8 11.4 8.2 16.5 4.4 3.1 20.4 13 24 16.3 3.7 3.4 3.2 6.1 2.8 9.5-.4 2.8-8.4 40.4-58.7 64.7-2.9 1.4-8 4.4 .9 9.3 13.9 7.6 23.1 6.8 30.3 11.4 6.1 3.9 2.5 12.4 6.9 15.4 5.5 3.8 21.6-.3 42.3 6.6 17.4 5.7 28.1 22 59 22s41.8-16.3 58.9-22c20.8-6.9 36.9-2.8 42.3-6.6 4.4-3.1 .8-11.5 6.9-15.4 7.2-4.6 16.4-3.8 30.3-11.5 8.8-4.9 3.8-7.9 .9-9.4z"],
    "themeisle": [512, 512, [], "f2b2", "M208 88.3c0-10 6.3-21.7 17.7-21.7 11.1 0 17.7 11.7 17.7 21.7 0 10.3-6.6 21.7-17.7 21.7-11.4 0-17.7-11.4-17.7-21.7zm304 160c0 36-11.4 102.3-36.3 129.7-22.9 24.9-87.4 61.1-120.9 70.6l-1.1 .3 0 32.6c0 16.3-12.6 30.6-29.1 30.6-10 0-19.4-5.7-24.6-14.3-5.4 8.6-14.9 14.3-24.9 14.3s-19.4-5.7-24.9-14.3c-5.1 8.6-14.6 14.3-24.6 14.3-10.3 0-19.4-5.7-24.9-14.3-5.1 8.6-14.6 14.3-24.6 14.3-18.9 0-29.4-15.7-29.4-32.9-16.3 12.3-35.7 19.4-56.6 19.4-22 0-43.4-8.3-60.3-22.9 10.3-.3 20.6-2.3 30.3-5.7-20.9-5.7-39.4-18.9-52-36.3 21.4 4.6 46.2 1.7 67.1-11.1-22-22-56.6-58.9-68.6-87.4-5.7-13.4-6.9-31.4-6.9-45.7 0-49.7 20.3-160 86.3-160 10.6 0 18.9 4.9 23.1 14.9 3.7-5.4 7.7-10.5 12-15.4 2-2.6 5.7-5.4 7.1-8.3 8-12.6 11.7-21.1 21.7-34 32.3-41.1 81.7-69.4 134.9-69.4 6 0 12 .3 17.7 1.1 10.9-11.7 26-18.3 41.7-18.3 14.6 0 29.7 6 40 16.3 .9 .9 1.4 2.3 1.4 3.4 0 3.7-10.3 13.4-12.9 16.3 4.3 1.4 15.7 6.9 15.7 12 0 2.9-2.9 5.1-4.6 7.1 31.4 27.7 49.4 67.1 56.3 108 4.3-5.1 10.3-8.6 17.1-8.6 10.6 0 20.9 7.1 28.6 14 20.9 18.6 25.7 53.1 25.7 79.7zM188 89.4c0 18.3 12.6 37.1 32.3 37.1s32.3-18.9 32.3-37.1c0-18-12.6-36.9-32.3-36.9S188 71.4 188 89.4zM237.7 194c0-19.7 3.7-39.1 8.6-58.3-52 79.5-13.5 184.6 68.9 184.6 21.4 0 42.6-7.7 60-20 2-7.4 3.7-14.9 3.7-22.6 0-14.3-6.3-21.4-20.6-21.4-4.6 0-9.1 .9-13.4 1.7-63.3 12.7-107.1 3.7-107.1-64zM196.6 448.9c0-11.1-8.9-20.9-20.3-20.9s-20 9.7-20 20.9l0 32.6c0 11.1 8.6 21.1 20 21.1s20.3-9.7 20.3-21.1l0-32.6zm49.1 0c0-11.1-8.6-20.9-20-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20-10 20-21.1l0-32.6zm49.7 0c0-11.1-8.9-20.9-20.3-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20.3-9.7 20.3-21.1l0-32.6zm49.7 0c0-11.1-8.9-20.9-20.3-20.9s-20.3 9.7-20.3 20.9l0 32.6c0 11.1 8.9 21.1 20.3 21.1s20.3-10 20.3-21.1l0-32.6zM421.7 286c-30.9 59.1-90.3 102.6-158.6 102.6-96.6 0-160.6-84.6-160.6-176.6 0-16.9 2-33.4 6-49.7-20 33.7-29.7 72.6-29.7 111.4 0 60.3 24.9 121.7 71.4 160.9 5.1-9.7 14.9-16.3 26-16.3 10 0 19.4 5.7 24.6 14.3 5.4-8.6 14.6-14.3 24.9-14.3 10 0 19.4 5.7 24.6 14.3 5.4-8.6 14.9-14.3 24.9-14.3s19.4 5.7 24.9 14.3c5.1-8.6 14.6-14.3 24.6-14.3 10.9 0 20.9 6.6 25.7 16 43.4-36.3 68.6-92 71.4-148.3zm10.6-99.7c0-53.7-34.6-105.7-92.6-105.7-30.3 0-58.6 15.1-78.9 36.9-20 66.4-27.4 136.6 41.4 136.6 28.8 0 97.4-28.5 84.3 36.9 28.9-26 45.7-65.7 45.7-104.6z"],
    "dart-lang": [512, 512, [], "e693", "M378.6 78.9c-2.8-.1-5.6-.2-8.5-.2l-264.1 0 143.2-72c7.4-4.4 18.8-6.7 30.4-6.7 13.5 0 29.4 9.2 37 16.8l62 62 0 .1zM107.3 96.5l262.8 0c16 0 25.4 1.4 35.4 9.3l106.5 106.4 0 208.8-79.3 .7-325.4-325.2zM96.5 373l0-262.2 323.8 323.8 .7 77.4-212.2 0-98.1-98.2C99.4 402.5 96.5 398.5 96.5 373zM78.7 105.3l0 267.7c0 3.3 .1 6.3 .2 9.1l-62-62C6.5 309.3 0 294.3 0 279.6 0 272.8 3.9 262.1 6.7 256l72-150.7z"],
    "deploydog": [512, 512, [], "f38e", "M382.2 136l51.7 0 0 239.6-51.7 0 0-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9l0-103.9zM317.5 297.8a33.2 33.2 0 1 0 66.4 1 33.2 33.2 0 1 0 -66.4-1zM188.5 136l51.7 0 0 239.6-51.7 0 0-20.7c-19.8 24.8-52.8 24.1-73.8 14.7-26.2-11.7-44.3-38.1-44.3-71.8 0-29.8 14.8-57.9 43.3-70.8 20.2-9.1 52.7-10.6 74.8 12.9l0-103.9zM123.8 297.8a33.2 33.2 0 1 0 66.4 1 33.2 33.2 0 1 0 -66.4-1zM448 96c17.5 0 32 14.4 32 32l0 256c0 17.5-14.4 32-32 32L64 416c-17.5 0-32-14.4-32-32l0-256c0-17.5 14.4-32 32-32l384 0zm0-32L64 64C28.8 64 0 92.8 0 128L0 384c0 35.2 28.8 64 64 64l384 0c35.2 0 64-28.8 64-64l0-256c0-35.2-28.8-64-64-64z"],
    "flipboard": [448, 512, [], "f44d", "M0 32l0 448 448 0 0-448-448 0zM358.4 211.2l-89.6 0 0 89.6-89.6 0 0 89.6-89.6 0 0-268.8 268.8 0 0 89.6z"],
    "buy-n-large": [576, 512, [], "f8a6", "M288.2 32C133.5 32 8 132.3 8 256S133.5 480 288.2 480 568.4 379.7 568.4 256 442.9 32 288.2 32zM202.8 389.2l-138.5 1.4 77.2-290.7 133.4 0c63.2 0 84.9 28.6 78 72.8-.4 2.3-.9 4.6-1.5 6.9-5.6-1.3-11.4-1.9-17.2-1.9-42.3 0-76.7 33.9-76.7 75.7 0 37.1 27.1 68 62.9 74.5-18.2 37.2-56.2 60.9-117.7 61.5zM358.2 207.1l32 0-22.2 90.3-35.4 0-11.2-35.6-7.8 35.6-37.8 0 26.6-90.3 31.3 0 15 36.8 9.4-36.8zM504.1 389.2l-197.1 0 15.8-61.2c3.8 .6 7.6 .8 11.5 .8 42.3 0 76.7-33.9 76.7-75.6 0-32.6-21-60.5-50.4-71.1l21.3-82.4 92.5 0-53 205.4 103.9 0-21.2 84.1zM211.9 269.4l-24.7 0-13.8 56.5 24.7 0c16.1 0 32.1-3.2 37.9-26.6 5.6-22.3-8-29.8-24.1-29.8zM233.2 170l-21.3 0-11.7 47.7 21.4 0c18 0 35.4-14.6 39.2-30.1 4.6-18.9-9.5-17.6-27.6-17.6z"],
    "watchman-monitoring": [512, 512, [], "e087", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zM121.7 429.1c-51.6-40.2-84.9-102.8-84.9-173.1 0-21.7 3.2-43.3 9.6-64.1l102.9-17.9-.1 11-13.9 2s-.1 12.5-.1 19.5c0 2 .4 4 1.2 5.8s2.1 3.4 3.7 4.6l9.5 7.4-27.7 204.9zM227.4 145.9l8.5-7.6s6.9-5.4-.1-9.3c-7.2-4-39.5-34.5-39.5-34.5-5.3-5.5-8.3-7.3-15.5 0 0 0-32.3 30.5-39.5 34.5-7.1 4-.1 9.3-.1 9.3l8.5 7.6 0 4.4-73.5-19.2c39.6-56.9 105.5-94.3 180-94.3 31.3 0 62.2 6.7 90.6 19.6s53.8 31.8 74.3 55.4l-193.5 37.7 0-3.6zm34.1 329.3l-33.9-250.9 9.5-7.4c1.6-1.2 2.8-2.8 3.7-4.6s1.3-3.8 1.2-5.8c0-7-.1-19.5-.1-19.5l-13.9-2-.1-10.5 241.7 31.4c3.9 16.4 5.8 33.3 5.8 50.1 0 119.1-95.4 216.2-213.8 219.1z"],
    "hips": [640, 512, [], "f452", "M251.6 157.6c0-1.9-.9-2.8-2.8-2.8l-40.9 0c-1.6 0-2.7 1.4-2.7 2.8l0 201.8c0 1.4 1.1 2.8 2.7 2.8l40.9 0c1.9 0 2.8-.9 2.8-2.8l0-201.8zM156.5 168c-16.1-11.8-36.3-17.9-60.3-18-18.1-.1-34.6 3.7-49.8 11.4l0-81.2c0-1.8-.9-2.7-2.8-2.7l-40.9 0C.9 77.5 0 78.4 0 80.2L0 359.4c0 1.9 .9 2.8 2.7 2.8l41 0c1.9 0 2.8-.9 2.8-2.8l0-136.1c0-.8-2.8-27 45.8-27 48.5 0 45.8 26.1 45.8 27l0 122.6c0 9 7.3 16.3 16.4 16.3l27.3 0c1.8 0 2.7-.9 2.7-2.8l0-136.1c0-23.4-9.3-41.8-28-55.3zM634.9 278.1c-6.8-15.7-18.4-27-34.9-34.1l-57.6-25.3c-8.6-3.6-9.2-11.2-2.6-16.1 7.4-5.5 44.3-13.9 84 6.8 1.7 1 4-.3 4-2.4l0-44.7c0-1.3-.6-2.1-1.9-2.6-17.7-6.6-36.1-9.9-55.1-9.9-26.5 0-45.3 5.8-58.5 15.4-.5 .4-28.4 20-22.7 53.7 3.4 19.6 15.8 34.2 37.2 43.6L580.4 286c11.6 5.1 15.2 13.3 12.2 21.2-3.7 9.1-13.2 13.6-36.5 13.6-24.3 0-44.7-8.9-58.4-19.1-2.1-1.4-4.4 .2-4.4 2.3l0 34.4c0 10.4 4.9 17.3 14.6 20.7 15.6 5.5 31.6 8.2 48.2 8.2 12.7 0 25.8-1.2 36.3-4.3 .7-.3 36-8.9 45.6-45.8 3.5-13.5 2.4-26.5-3.1-39.1zM376.2 149.8c-31.7 0-104.2 20.1-104.2 103.5l0 183.5c0 .8 .6 2.7 2.7 2.7l40.9 0c1.9 0 2.8-.9 2.8-2.7l0-88.8c16.5 12.7 35.8 19.1 57.7 19.1 60.5 0 108.7-48.5 108.7-108.7 .1-60.3-48.2-108.6-108.6-108.6zm0 46.6a62.2 62.2 0 1 1 0 124.3 62.2 62.2 0 1 1 0-124.3zM228.3 72.5c-15.9 0-28.8 12.9-28.9 28.9 0 15.6 12.7 28.9 28.9 28.9s28.9-13.1 28.9-28.9c0-16.2-13-28.9-28.9-28.9z"],
    "cloudversify": [640, 512, [], "f385", "M160.6 304c8.2 68.5 67.4 115.5 146 111.3 51.2 43.3 136.8 45.8 186.4-5.6 69.2 1.1 118.5-44.6 131.5-99.5 14.8-62.5-18.2-132.5-92.1-155.1-33-88.1-131.4-101.5-186.5-85-57.3 17.3-84.3 53.2-99.3 109.7-7.8 2.7-26.5 8.9-45 24.1 11.7 0 15.2 8.9 15.2 19.5l0 20.4c0 10.7-8.7 19.5-19.5 19.5l-20.2 0c-10.7 0-19.5-6-19.5-16.7l0-6.6-46.8 0c-3.8 0-10.8 4.3-10.8 11.9l0 40.4c0 6.4 5.3 11.8 11.7 11.8l48.9 0 0-.1zM388 312c-10.7 46.3 21.7 72.4 55.3 86.8-107.2 33.8-171.6-50.8-135.3-110.8-33.2 21.6-33.7 71.2-29.2 92.9-17.9-12.4-53.8-32.4-57.4-79.8-3-39.9 21.5-75.7 57-93.9 30.6-15.8 103.5-8.5 133.6 40.8-14.1-48-53.8-70.1-101.8-74.8 30.9-30.7 64.4-50.3 114.2-43.7 69.8 9.3 133.2 82.8 67.7 150.5 35-16.3 48.7-54.4 47.5-76.9l10.5 19.6c11.8 22 15.2 47.6 9.4 72-9.2 39-40.6 68.8-79.7 76.5-32.1 6.3-83.1-5.1-91.8-59.2zM140 208l-39.8 0c-8.9 0-16.2-7.3-16.2-16.2l0-39.6c0-8.9 7.3-16.2 16.2-16.2l39.8 0c8.9 0 16.2 7.3 16.2 16.2l0 39.6c0 8.9-7.3 16.2-16.2 16.2zM22.1 168c-5.6 0-10.1-4.5-10.1-10.1l0-27.8c0-5.6 4.5-10.1 10.1-10.1l27.7 0c5.5 0 10.1 4.5 10.1 10.1l0 27.8c0 5.6-4.5 10.1-10.1 10.1l-27.7 0zM180 142.7l0-21.4c0-5.1 4.2-9.3 9.3-9.3l21.4 0c5.1 0 9.3 4.2 9.3 9.3l0 21.4c0 5.1-4.2 9.3-9.3 9.3l-21.4 0c-5.1 0-9.3-4.2-9.3-9.3zM68 235.5l0 25c0 6.3-5.1 11.5-11.4 11.5l-25.2 0c-6.3 0-11.4-5.2-11.4-11.5l0-25c0-6.3 5.1-11.5 11.4-11.5l25.1 0c6.4 0 11.5 5.2 11.5 11.5z"],
    "goodreads": [448, 512, [], "f3a8", "M299.9 191.2c5.1 37.3-4.7 79-35.9 100.7-22.3 15.5-52.8 14.1-70.8 5.7-37.1-17.3-49.5-58.6-46.8-97.2 4.3-60.9 40.9-87.9 75.3-87.5 46.9-.2 71.8 31.8 78.2 78.3zM448 88l0 336c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56L0 88C0 57.1 25.1 32 56 32l336 0c30.9 0 56 25.1 56 56zM330 313.2s-.1-34-.1-217.3l-29 0 0 40.3c-.8 .3-1.2-.5-1.6-1.2-9.6-20.7-35.9-46.3-76-46-51.9 .4-87.2 31.2-100.6 77.8-4.3 14.9-5.8 30.1-5.5 45.6 1.7 77.9 45.1 117.8 112.4 115.2 28.9-1.1 54.5-17 69-45.2 .5-1 1.1-1.9 1.7-2.9 .2 .1 .4 .1 .6 .2 .3 3.8 .2 30.7 .1 34.5-.2 14.8-2 29.5-7.2 43.5-7.8 21-22.3 34.7-44.5 39.5-17.8 3.9-35.6 3.8-53.2-1.2-21.5-6.1-36.5-19-41.1-41.8-.3-1.6-1.3-1.3-2.3-1.3l-26.8 0c.8 10.6 3.2 20.3 8.5 29.2 24.2 40.5 82.7 48.5 128.2 37.4 49.9-12.3 67.3-54.9 67.4-106.3z"],
    "tidal": [640, 512, [], "e7dc", "M107.2 48l-1.3 0c-32.3 33.1-65.4 65.5-98 98.5-2.6 2.8-6.1 5.1-7.9 8.6 35.6 35.4 71 71 106.6 106.4 35.4-35.3 70.7-70.8 106.1-106.1l0-1.3-73.2-73.2C128.8 69.8 117.3 59.6 107.2 48zm213.5 0l-1.3 0c-34.9 36.1-71.5 71-106.3 107.2 35.9 35.1 71 71 106.7 106.3 34.3-34.1 68.4-68.4 102.6-102.4 1.5-1.5 3.3-2.8 4.1-4.8-34.6-33.8-68.4-68.2-102.6-102.1-1.3-1.3-2.3-2.6-3.3-4.1zm213.5 0l-1.3 0c-17.2 18-35.1 35.3-52.6 53-17.9 17.7-35.4 35.7-53.5 53.3 .8 2.3 3 3.6 4.6 5.5L533.3 261.5c36.1-34.9 70.8-71.2 106.7-106.1-.5-2.2-2.6-3.5-4-5L555.8 70.2c-7.1-7.4-14.9-14.2-21.5-22.2zM319.6 261.7c-34.9 35.1-70 70-104.9 104.9-.3 .7-.7 1.7-1 2.3 24 23.7 47.7 47.5 71.5 71.3 11.8 11.3 22.8 23.5 34.9 34.4 8.4-7.4 16.4-16.4 24.7-24.3 25.5-25.3 51-51 76.5-76.3 1.8-2.2 4.3-3.6 5.5-6.3-35.4-34.9-70.5-70.2-105.6-105.4l-1.5-.7z"],
    "unity": [448, 512, [], "e049", "M243.6 91.6l80.1 46.8c2.9 1.6 3 6.2 0 7.8l-95.2 55.6c-2.9 1.7-6.3 1.6-9 0l-95.2-55.6c-2.9-1.6-3-6.3 0-7.8l80.1-46.8 0-91.6-204.4 119.4 0 238.8 78.4-45.8 0-93.6c-.1-3.3 3.8-5.7 6.7-3.9l95.2 55.6c2.9 1.7 4.5 4.7 4.5 7.8l0 111.2c.1 3.3-3.8 5.7-6.7 3.9L98 346.8 19.6 392.6 224 512 428.4 392.6 350 346.8 269.9 393.6c-2.8 1.7-6.8-.5-6.7-3.9l0-111.2c0-3.3 1.8-6.3 4.5-7.8L362.9 215c2.8-1.7 6.8 .5 6.7 3.9l0 93.6 78.4 45.8 0-238.8-204.4-119.4 0 91.6z"],
    "tencent-weibo": [320, 512, [], "f1d5", "M40.5 495.8c1.4 19.9-27.6 22.2-29.7 2.9-11.6-129.9 31.1-239.5 101.4-313.2-15.6-34 9.2-77.1 50.6-77.1 30.3 0 55.1 24.6 55.1 55.1 0 44-49.5 70.8-86.9 45.1-65.7 71.3-101.4 169.8-90.5 287.2zM160.2 .1c-125.9 0-204.3 134.2-148.3 242.3 8.7 17.4 35.3 4.5 26.3-13.4-46.3-92.6 21-199.2 122-199.2 75.4 0 136.9 61.4 136.9 136.9 0 90.8-86.9 153.9-167.7 133.1-19.1-4.1-25.6 24.4-6.6 29.1 110.7 23.2 204-60 204-162.3 0-91.9-74.6-166.5-166.6-166.5z"],
    "free-code-camp": [576, 512, [], "f2c5", "M97.4 96.2c10.4-10.6 16-17.1 16-21.9 0-2.8-1.9-5.5-3.8-7.4-2.4-1.8-5.4-2.8-8.4-2.8-8.5 0-20.9 8.8-35.8 25.7-41.5 47.3-62.7 93.1-61.8 160.6S21 367.3 57.6 412.2c18.8 23.6 33.2 35.8 43.5 35.8 3.2-.3 6.1-1.6 8.4-3.8 1.9-2.8 3.8-5.6 3.8-8.4 0-5.6-3.9-12.2-13.2-20.6-44.5-42.3-67.3-97-67.5-165-.2-61.4 21.6-112.4 64.8-154zM239.6 420.1c.6 .4 .9 .6 .9 .6l-.9-.6zm93.8 .6l.2-.1c-.2 .1-.3 .2-.2 .1zm3.1-158.2c-16.2-4.2 50.4-82.9-68.1-177.2 0 0 15.5 49.4-62.8 159.6-74.3 104.4 23.5 168.7 34 175.2-6.7-4.3-47.4-35.7 9.6-128.6 11-18.3 25.5-34.9 43.5-72.2 0 0 15.9 22.4 7.6 71.1-12.5 73.6 53.8 52.5 54.8 53.5 22.8 26.8-17.7 73.5-21.6 76.6 5.5-3.7 117.7-78 33-188.1-6 6-13.8 34.2-30 30.1zM511 89.7c-14.9-16.9-27.4-25.7-35.9-25.7-3 .1-5.9 1.1-8.4 2.8-1.9 1.9-3.8 4.7-3.8 7.4 0 4.8 5.6 11.3 16 21.9 43.2 41.6 65 92.6 64.8 154.1-.2 68-23 122.6-67.5 165-9.3 8.4-13.2 14.9-13.2 20.6 0 2.7 1.9 5.6 3.8 8.4 2.3 2.2 5.2 3.6 8.4 3.8 10.3 0 24.7-12.1 43.5-35.8 36.6-44.9 53.1-94.4 54.1-161.9S552.5 137 511 89.7z"],
    "x-twitter": [448, 512, [], "e61b", "M357.2 48L427.8 48 273.6 224.2 455 464 313 464 201.7 318.6 74.5 464 3.8 464 168.7 275.5-5.2 48 140.4 48 240.9 180.9 357.2 48zM332.4 421.8l39.1 0-252.4-333.8-42 0 255.3 333.8z"],
    "sticker-mule": [576, 512, [], "f3f7", "M561.7 199.6l0 0zm-6.2-77.4c-7.7-22.3-5.1-7.2-13.4-36.9-1.6-6.5-3.6-14.5-6.2-20-4.4-8.7-4.6-7.5-4.6-9.5 0-5.3 30.7-45.3 19-46.9-5.7-.6-12.2 11.6-20.6 17-8.6 4.2-8 5-10.3 5-2.6 0-5.7-3-6.2-5-2-5.7 1.9-25.9-3.6-25.9-3.6 0-12.3 24.8-17 25.8-5.2 1.3-27.9-11.4-75.1 18-25.3 13.2-86.9 65.2-87 65.3-6.7 4.7-20 4.7-35.5 16-44.4 30.1-109.6 9.4-110.7 9-110.6-26.8-128-15.2-159 11.5-20.8 17.9-23.7 36.5-24.2 38.9-4.2 20.4 5.2 48.3 6.7 64.3 1.8 19.3-2.7 17.7 7.7 98.3 .5 1 4.1 0 5.1 1.5 0 8.4-3.8 12.1-4.1 13-1.5 4.5-1.5 10.5 0 16 2.3 8.2 8.2 37.2 8.2 46.9 0 41.8 .4 44 2.6 49.4 3.9 10 12.5 9.1 17 12 3.1 3.5-.5 8.5 1 12.5 .5 2 3.6 4 6.2 5 9.2 3.6 27 .3 29.9-2.5 1.6-1.5 .5-4.5 3.1-5 5.1 0 10.8-.5 14.4-2.5 5.1-2.5 4.1-6 1.5-10.5-.4-.8-7-13.3-9.8-16-2.1-2-5.1-3-7.2-4.5-5.8-4.9-10.3-19.4-10.3-19.5-4.6-19.4-10.3-46.3-4.1-66.8 4.6-17.2 39.5-87.7 39.6-87.8 4.1-6.5 17-11.5 27.3-7 6 1.9 19.3 22 65.4 30.9 47.9 8.7 97.4-2 112.2-2 2.8 2-1.9 13-.5 38.9 0 26.4-.4 13.7-4.1 29.9-2.2 9.7 3.4 23.2-1.5 46.9-1.4 9.8-9.9 32.7-8.2 43.4 .5 1 1 2 1.5 3.5 .5 4.5 1.5 8.5 4.6 10 7.3 3.6 12-3.5 9.8 11.5-.7 3.1-2.6 12 1.5 15 4.4 3.7 30.6 3.4 36.5 .5 2.6-1.5 1.6-4.5 6.4-7.4 1.9-.9 11.3-.4 11.3-6.5 .3-1.8-9.2-19.9-9.3-20-2.6-3.5-9.2-4.5-11.3-8-6.9-10.1-1.7-52.6 .5-59.4 3-11 5.6-22.4 8.7-32.4 11-42.5 10.3-50.6 16.5-68.3 .8-1.8 6.4-23.1 10.3-29.9 9.3-17 21.7-32.4 33.5-47.4 18-22.9 34-46.9 52-69.8 6.1-7 8.2-13.7 18-8 10.8 5.7 21.6 7 31.9 17 14.6 12.8 10.2 18.2 11.8 22.9 1.5 5 7.7 10.5 14.9 9.5 10.4-2 13-2.5 13.4-2.5 2.6-.5 5.7-5 7.2-8 3.1-5.5 7.2-9 7.2-16.5 0-7.7-.4-2.8-20.6-52.9z"],
    "twitch": [448, 512, [], "f1e8", "M359.4 103.5l-38.6 0 0 109.7 38.6 0 0-109.7zM253.2 103l-38.6 0 0 109.8 38.6 0 0-109.8zM89 0l-96.5 91.4 0 329.2 115.8 0 0 91.4 96.5-91.4 77.3 0 173.8-164.6 0-256-366.9 0zM417.3 237.8l-77.2 73.1-77.2 0-67.6 64 0-64-86.9 0 0-274.3 308.9 0 0 201.2z"],
    "kickstarter-k": [448, 512, [], "f3bc", "M356.7 256.2l40.8-40.5c42.2-41.9 42.2-110.3 0-152.1s-111-41.9-153.2 0L229.3 78.4C209.6 50.3 177.1 32 140.2 32 80.5 32 32 80.2 32 139.5l0 233c0 59.4 48.5 107.5 108.2 107.5 37.1 0 69.3-18.3 89-46.4l14.9 14.7c42.2 41.9 111 41.9 153.2 0s42.2-110.3 0-152.1l-40.8-40 .1 0z"],
    "critical-role": [448, 512, [], "f6c9", "M225.8 0c.3 .2 216.6 124.5 217.1 124.7 3 1.2 3.7 3.5 3.7 6.6-.1 83.4-.1 166.9 0 250.4 .1 1.2-.2 2.4-.8 3.4s-1.5 1.9-2.6 2.4c-21.4 12-207.9 118.3-218.9 124.6l-3 0c-79.3-45.7-218.3-125.4-218.4-125.5-.6-.3-1.1-.7-1.4-1.3s-.5-1.2-.4-1.9c0-.9 0-225.9-.1-253.1-.1-1 .2-2 .7-2.9s1.3-1.6 2.2-2C27.2 112.1 213.2 6 224.1 0l1.8 0zM215.4 20.4l-.2-.2c-64.7 36.9-129.5 73.7-194.2 110.6 0 .1 .1 .2 .1 .4L52 142.9c-7.7 6-8.3 6-10.6 5.1-.1 0-24.2-9.3-26.8-10l0 230.4c.9-1.4 64.1-110.9 64.1-111 1.6-2.8 3-1.9 9.1-1.5 1.4 .1 1.5 .2 .8 1.4-41.2 71.3-36.4 63-67.5 116.9-.8 1.4-.6 1.1 1.2 1.1l186.5 0c1.4 0 1.7-.2 1.7-1.6l0-8.9c0-1.3 2.4-.8-18.4-1-7.5-.1-14.1-3.2-21.4-12.7-7.4-9.7-14.6-19.4-21.8-29.2-2.3-3.1-3.4-2.4-16.8-2.4-1.8 0-1.8 0-1.8 1.8 .3 26.2 .2 25.3 1 32.7 .5 4.4 2.2 4.2 9.7 4.8 3.1 .3 3.9 4.1 .5 4.9-1.6 .4-31.6 .5-33.7-.1-.5-.1-1-.5-1.3-.9s-.5-1-.4-1.6 .3-1.1 .6-1.5 .9-.7 1.4-.8c3.3-.8 6.2 .8 6.7-4.4 1.3-13.7 1.2-9 1.1-79.4 0-10.8-.4-12.6-5.4-13.6-1.2-.2-3.5-.2-4.7-.6-2.9-1-2-4.8 1.8-4.8 33.7 0 46.1-1.1 56.1 4.9 7.7 4.6 12 11.5 12.5 20.4 .9 14.6-6.5 22.3-15 32.6-.2 .1-.3 .3-.4 .5s-.1 .4-.1 .6 0 .4 .1 .6 .2 .4 .4 .5c2.6 3.2 5 6.6 7.7 9.8 27.6 33.2 24.1 30.5 41.3 33.1 .9 .1 1-.4 1-1.2l0-11c0-1 .3-1.4 1.4-1.3 7.8 1.2 15.8 1.1 23.6-.3 1.1-.1 1.5 .2 1.5 1.3 0 .1 .9 26.7 .9 26.8 0 1.5 .7 1.6 1.9 1.6l186.7 0c-27.2-47-54.2-94-81.2-140.8 2.3-.7-.4 0 6.7-1.4 2-.4 2.1-.4 3.1 1.4 7.3 12.6 77.3 134 77.4 134.1l0-230.4c-1.7 .5-103.3 38.7-105.8 39.7-1.1 .4-1.5 .2-1.9-.9-.6-1.9-1.3-3.8-2.1-5.6-.3-.8-.1-1.1 .6-1.4 .1 0 95.5-35.8 103-38.8-65.4-37.6-130.6-75-196-112.6l86.8 150.4-.3 .3c-9.6-.9-10.5-1.6-11.8-3.9-1-1.7-73.5-127.7-82-142.2-9.1 14.7-83.6 146.2-85.4 146.3-2.9 .2-5.9 .1-9.2 .1 28.8-49.8 57.6-99.5 86.2-149l0 0zm51.9 129.9c1.9-.1 3.7-.4 5.5-.8 1.7-.3 2.5 .2 2.6 1.9 0 .1 .1 19.1-.9 20.5s-1.9 1.2-2.6-.2c-5-9.7 6.2-9.7-39.1-12-.7 0-1 .2-1 .9 0 .1 3.7 122 3.7 122.1 0 .9 .5 1.2 1.2 1.5 3 1.2 5.9 2.5 8.7 4 7.3 4.3 11.4 10.8 12.4 19.3 1.4 11.8-2.8 35.8-32.2 37.1-2.8 .1-28.3 1.1-34.1-23.3-4.7-19.3 8.3-32.7 19.9-36.4 .6-.1 1.2-.4 1.5-.9s.5-1.1 .5-1.7c.1-5.6 3-107.1 3.7-121.3 0-1.1-.6-1.2-1.4-1.1-32.3 .5-36.7-.3-40.2 8.5-2.4 6.2-4.1 1.3-4 .2 1.1-6 2.2-12 3.3-18 .4-2.1 1.4-2.6 3.4-1.9 5.6 2.1 6.7 1.7 37.2 1.9 1.7 0 1.8-.1 1.8-1.8 .7-27.5 .6-22.6 1-29.6 .1-.6-.1-1.2-.3-1.7s-.7-.9-1.3-1.1c-5.6-2.9-8.8-7.6-8.9-13.9-.4-14.8 17.7-21.7 27.4-11.5 6.8 7.2 5.8 18.9-2.5 24.2-.8 .4-1.4 1.1-1.8 1.8s-.6 1.6-.4 2.5c0 .6-.1-4.3 1 30 0 .9 .4 1.1 1.2 1.1 .1 0 23-.1 34.5-.4l0-.1zM68.3 141.7c19.8-4.5 32.7-.6 52.5 1.7 2.8 .3 3.7 1.2 3.6 4-.2 5-1.2 22.3-1.2 23.1 0 .5-.2 1-.5 1.4s-.7 .7-1.2 .9c-4.1 1.7-3.6-4.4-4-7.3-3.1-22.4-73.9-32.7-74.6 25.4-.3 23.9 17 53.6 54.1 50.9 27.2-2 19-20.2 24.8-20.5 .4-.1 .9 0 1.3 .1s.8 .4 1.1 .7 .5 .7 .6 1.2 .1 .9 0 1.3c-1.8 10.8-3.4 19-3.4 19.2-1.5 9.2-86.7 22.1-93.4-42.1-2.7-25.8 10.4-53.4 40.3-60.2zm80 87.7l-19.5 0c-.6 0-1.2-.1-1.6-.4s-.8-.8-1-1.4c2.4-3.8 5.9 .9 5.9-6.1-.1-25.8 .2-38 .2-40.1 0-3.4-.5-4.6-3.3-4.9-7-.7-3.1-3.4-1.1-3.4 11.8-.1 22.6-.2 30 .7 8.8 1.1 16.7 12.6 7.9 22.6-2 2.2-4 4.4-6.1 6.7 1 1.2 6.9 8.8 17.3 19.7 2.7 2.8 6.2 3.5 9.9 3.1 .6 0 1.1-.2 1.5-.6s.7-.9 .7-1.5c.3-3.4 .3 4.7 .4-40.6 0-5.6-.3-6.6-3.2-6.8-4-.4-4-2.3-.7-3.4l19.1-.1c.3 0 4.5 .5 1 3.4 0 0-.2 0-.2 0-3.6 .3-3.9 1-4 4.6-.3 43.9 .1 40.2 .4 42.8 .1 .8 .3 2.2 5.1 2.1 2.5 0 3.9 3.4 0 3.4-10.4 .1-20.7 0-31.1 .1-10.7 0-13.5-6.2-24.2-20.8-1.6-2.2-8.3-2.4-8.2-.4 .9 16.5 0 17.8 4 17.7 4.8-.1 4.7 3.6 .8 3.5l.1 0zm275-10.1c-1.2 7.1 .2 10.4-5.3 10.3-61.5-.4-47.8-.2-50.7-.3-1.2-.1-2.4-.4-3.6-.7-2.5-.6 1.5-1.2-.4-5.6-1.4-3.4-2.8-6.8-4.1-10.2-.1-.4-.4-.8-.7-1.1s-.8-.4-1.3-.4c-4.9-.2-9.7-.2-14.6 .1-.3 0-.6 .2-.9 .3s-.5 .4-.7 .7c-1.6 3.6-3.1 7.3-4.5 11-1.3 3.2 7.9 1.3 12.2 2.2 3 .6 4.5 3.7 .7 3.7l-26.4 0c-2.9 0-3.1-3.2-.7-3.2 1.2 .1 2.4-.2 3.5-.9s1.9-1.5 2.4-2.6c1.5-3 2.8-6 4.1-9.1 18.2-42.1 17.1-40.2 18.4-41.6 .2-.2 .4-.4 .7-.6s.6-.2 .8-.2 .6 .1 .8 .2 .5 .3 .7 .6c2.9 3.3 18.4 44.7 23.6 51.9 2 2.7 5.7 2 6.4 2 3.6 .1 4-1.1 4.1-4.3 .1-1.9 .1 1.2 .1-41.2 0-4.5-2.4-3.7-5.6-4.3-.3 0-2.6-.6-.1-3.1 .2-.2-.9-.2 21.7-.2 2.3 0 5.3 2.8-1.2 3.4-.4 0-.7 0-1.1 .2s-.6 .3-.9 .6-.4 .6-.6 .9-.2 .7-.1 1.1c-.1 1.6-.2 38.9 .3 41.2 .2 .7 .6 1.4 1.2 1.8s1.3 .7 2.1 .6c13.3 .4 14.9 .4 16-3.4 1.7-5.8 4.1-2.5 3.7-.2l0 .1zM318.6 283.6c-4.2 0-4.4-3.4-.6-3.4 35.9-.2 28.1 .4 37.2-.6 1.7-.2 2.4 .2 2.3 1.9-.3 3.4-.6 6.8-1 10.2-.2 2.2-3.2 2.6-3.4-.2-.4-5.3-2.2-4.5-15.6-5.1-1.6-.1-1.6 0-1.6 1.5l0 16.1c0 1.7 0 1.6 1.6 1.5 3.1-.2 10.3 .3 15.7-1.5 .5-.2 3.3-1.8 3.1 1.8 0 .2-.8 10.4-1.2 11.4-.5 1.3-1.9 1.5-2.6 .3-1.2-2 0-5.1-3.7-5.3-15.4-.9-12.9-2.5-12.9 6 0 12.3-.8 16.1 3.9 16.2 16.6 .5 14.4 0 16.4-5.7 .8-2.4 3.5-1.8 3.2 .6-.4 3.2-.8 6.4-1.2 9.6 0 .4-.2 2.4-4.7 2.4-37.2-.1-34.5-.2-35.2-.3-2.7-.5-2.2-3 .2-3.4 1.1-.2 4 .5 4.2-2.6 2.4-56.2-.1-51.3-3.9-51.3l0 0zm-.4-109.5c2.5 .6 3.1 1.8 3 4.6-.3 5.3-.3 9-.6 9.7-.7 2.2-3.1 2.1-3.3-.3-.4-4.8-3-7.8-7.6-9.1-26.3-7.7-32.8 15.5-27.2 30.2 5.9 15.4 22 15.9 28.9 13.8 5.9-1.9 5.9-6.5 6.9-7.6 1.2-1.3 2.2-1.8 3.1 1.1 0 .1 .6 11.9-6 12.7-1.6 .2-19.4 3.7-32.7-3.4-21-11.2-16.7-35.5-6.9-45.3 14-14.1 39.9-7.1 42.3-6.5l0 0zM289.8 280.1c3.3 0 3.7 3 .2 3.4-2.6 .3-5-.4-5 5.5 0 2-.2 29 .4 41.4 .1 2.3 1.2 3.5 3.4 3.7 22 1.2 15-1.7 18.8-6.3 1.8-2.2 2.8 .8 2.8 1.1 .3 13.6-4 12.4-5.2 12.4l-38.2-.2c-1.9-.2-2.1-3-.4-3.4 2-.5 4.9 .4 5.1-2.8 1-15.9 .6-44.6 .3-47.8-.3-3.8-2.8-3.3-5.7-3.7-2.5-.4-2-3.2 .3-3.2 1.4 0 18 0 23.1 0zm-31.6-57.8c.1 4.1 2.9 3.5 6 3.6 2.6 .1 2.5 3.4-.1 3.4-6.5 0-13.7 0-21.6-.1-3.8 0-3.4-3.4 0-3.4 4.5 0 3.2 1.6 3.4-45.5 0-5.1-3.3-3.5-4.7-4.2-2.6-1.2-1.4-3.1 .4-3.2 1.3 0 20.2-.4 21.2 .2s1.9 1.6-.4 2.9c-1 .5-3.9-.3-4.2 2.5 0 .2-.8 1.6-.1 43.8l0 0zM221.3 496.6c.5 .3 1 .5 1.6 .5s1.1-.2 1.6-.5c17-9.8 182-103.6 197.4-112.5-.1-.4 11.3-.2-181.5-.3-1.2 0-1.6 .4-1.5 1.6 0 .1 1.3 44.5 1.2 50.4-.1 2.6-.6 5.2-1.4 7.7-.6 1.8 .4-.5-13.5 32.2-.7 1.7-1 2.2-2-.1-4.2-10.3-8.3-20.7-12.6-31-1.5-3.4-2.2-7.1-2-10.8 .2-2.5 .8-16.1 1.5-48 0-1.9 0-2-2-2l-183 0c2.6 1.6 178.3 102.6 196 112.8l.1 0zM130.4 307.9c0 2.4 .4 2.8 2.8 3 11.5 1.2 21 3.7 25.6-7.3 6-14.5 2.7-34.4-12.5-38.8-2-.6-16-2.8-15.9 1.5 0 8 0 11.6 0 41.6zm105.8-15c0 2.1 1.1 38.7 1.1 39.1 .3 9.9-25.6 5.8-25.2-2.6 .1-2 1.4-37.4 1.1-39.4-14.1 7.4-14.4 40.2 6.4 48.8 4 1.7 8.4 1.9 12.5 .6s7.6-4 9.9-7.7c4.9-7.8 6.8-29.5-5.4-39-.1 .1-.2 .1-.4 .1l0 0zm-12.3-198c-9.8 0-9.7 14.8-.1 14.9s10.1-14.9 .1-14.9l0 0zM143.7 198.6c0 1.8 .4 2.4 2.2 2.6 13.6 1.4 12.5-11 12.2-13.4-1.7-11.2-14.4-10.2-14.4-7.8 0 4.5 0 13.7 0 18.6zM356 205l-6.1-15.8c-2.2 5.5-4.2 10.6-6.2 15.8l12.3 0z"],
    "steam-symbol": [448, 512, [], "f3f6", "M273.5 177.5a61 61 0 1 1 122 0 61 61 0 1 1 -122 0zm174.5 .2c0 63-51 113.8-113.7 113.8L225 371.3c-4 43-40.5 76.8-84.5 76.8-40.5 0-74.7-28.8-83-67L0 358 0 250.7 97.2 290c15.1-9.2 32.2-13.3 52-11.5l71-101.7C220.7 114.5 271.7 64 334.2 64 397 64 448 115 448 177.7zM203 363c0-34.7-27.8-62.5-62.5-62.5-4.5 0-9 .5-13.5 1.5l26 10.5c25.5 10.2 38 39 27.7 64.5-10.2 25.5-39.2 38-64.7 27.5-10.2-4-20.5-8.3-30.7-12.2 10.5 19.7 31.2 33.2 55.2 33.2 34.7 0 62.5-27.8 62.5-62.5zM410.5 177.7a76.4 76.4 0 1 0 -152.8 0 76.4 76.4 0 1 0 152.8 0z"],
    "mailchimp": [448, 512, [], "f59e", "M331 243.5c3.1-.4 6.2-.4 9.3 0 1.7-3.8 2-10.4 .5-17.6-2.2-10.7-5.3-17.1-11.5-16.1s-6.5 8.7-4.2 19.4c1.3 6 3.5 11.1 6 14.3l0 0zM277.4 252c4.5 2 7.2 3.3 8.3 2.1 1.9-1.9-3.5-9.4-12.1-13.1-5-2.1-10.4-2.8-15.8-2.2s-10.5 2.7-14.8 5.8c-3 2.2-5.8 5.2-5.4 7.1 .9 3.7 10-2.7 22.6-3.5 7-.4 12.8 1.8 17.3 3.7l0 0zm-9 5.1c-9.1 1.4-15 6.5-13.5 10.1 .9 .3 1.2 .8 5.2-.8 6-2.3 12.4-2.9 18.7-1.9 2.9 .3 4.3 .5 4.9-.5 1.5-2.2-5.7-8-15.4-6.9l0 0zm54.2 17.1c3.4-6.9-10.9-13.9-14.3-7s10.9 13.9 14.3 7l0 0zm15.7-20.5c-7.7-.1-8 15.8-.3 15.9s8-15.8 .3-16l0 0zM119.5 332.7c-1.3 .3-6 1.5-8.5-2.3-5.2-8 11.1-20.4 3-35.8-9.1-17.5-27.8-13.5-35-5.5-8.7 9.6-8.7 23.5-5 24.1 4.3 .6 4.1-6.5 7.4-11.6 .9-1.4 2.1-2.6 3.5-3.6s3-1.6 4.6-2 3.4-.4 5 0 3.3 1 4.7 1.9c11.6 7.6 1.4 17.8 2.3 28.6 1.4 16.7 18.4 16.4 21.6 9 .2-.4 .3-.8 .3-1.2s-.2-.8-.5-1.1c0 .9 .7-1.3-3.4-.4l0 0zm299.7-17.1c-3.3-11.7-2.6-9.2-6.8-20.5 2.4-3.7 15.3-24-3.1-43.3-10.4-10.9-33.9-16.5-41.1-18.5-1.5-11.4 4.6-58.7-21.5-83 20.8-21.6 33.8-45.3 33.7-65.7-.1-39.2-48.2-51-107.4-26.5l-12.5 5.3c-.1 0-22.7-22.3-23.1-22.6-67.5-58.9-278.8 175.9-211.3 232.9l14.8 12.5c-4 10.7-5.4 22.2-4.1 33.5 3.4 33.4 36 60.4 67.5 60.4 57.7 133.1 267.9 133.3 322.3 3 1.7-4.5 9.1-24.6 9.1-42.4s-10.1-25.3-16.5-25.3l0 0zm-316 48.2c-22.8-.6-47.5-21.1-49.9-45.5-6.2-61.3 74.3-75.3 84-12.3 4.5 29.6-4.7 58.5-34.1 57.8l0 0zM84.7 249.6c-15.2 3-28.5 11.5-36.7 23.5-4.9-4.1-14-12-15.6-15-13-24.8 14.2-73 33.3-100.2 47.1-67.2 120.9-118.1 155-108.9 5.5 1.6 23.9 22.9 23.9 22.9s-34.1 18.9-65.8 45.3C136.2 150 104 197.7 84.7 249.6zM323.6 350.7s-35.7 5.3-69.5-7.1c6.2-20.2 27 6.1 96.4-13.8 15.3-4.4 35.4-13 51-25.4 3.4 7.8 5.8 15.9 7.1 24.3 3.7-.7 14.2-.5 11.4 18.1-3.3 19.9-11.7 36-25.9 50.8-8.9 9.6-19.4 17.5-31.2 23.3-6.5 3.4-13.3 6.3-20.3 8.6-53.5 17.5-108.3-1.7-126-43-1.4-3.1-2.6-6.4-3.6-9.7-7.5-27.2-1.1-59.8 18.8-80.4 1.2-1.3 2.5-2.9 2.5-4.8-.2-1.7-.8-3.3-1.9-4.5-7-10.1-31.2-27.4-26.3-60.8 3.5-24 24.5-40.9 44.1-39.9l5 .3c8.5 .5 15.9 1.6 22.9 1.9 11.7 .5 22.2-1.2 34.6-11.6 4.2-3.5 7.6-6.5 13.3-7.5 2.3-.6 4.7-.7 7-.3s4.6 1.2 6.6 2.5c10 6.6 11.4 22.7 11.9 34.5 .3 6.7 1.1 23 1.4 27.6 .6 10.7 3.4 12.2 9.1 14 3.2 1 6.2 1.8 10.5 3.1 13.2 3.7 21 7.5 26 12.3 2.5 2.5 4.2 5.8 4.7 9.3 1.6 11.4-8.8 25.4-36.3 38.2-46.7 21.7-93.7 14.4-100.5 13.7-20.2-2.7-31.6 23.3-19.5 41.1 22.6 33.4 122.4 20 151.4-21.4 .7-1 .1-1.6-.7-1-41.8 28.6-97.1 38.2-128.5 26-4.8-1.8-14.7-6.4-15.9-16.7 43.6 13.5 71 .7 71 .7s2-2.8-.6-2.5zM171.7 157.5c16.7-19.4 37.4-36.2 55.8-45.6 .1-.1 .3-.1 .5-.1s.3 .1 .4 .2 .2 .3 .2 .4 0 .3-.1 .5c-1.5 2.7-4.3 8.3-5.2 12.7 0 .1 0 .3 0 .4s.2 .3 .3 .4 .3 .1 .4 .1 .3 0 .4-.1c11.5-7.8 31.5-16.2 49-17.3 .2 0 .3 0 .5 .1s.2 .2 .3 .4 .1 .3 0 .5-.1 .3-.3 .4c-2.9 2.2-5.5 4.8-7.7 7.7-.1 .1-.1 .2-.1 .4s0 .3 .1 .4 .2 .2 .3 .3 .2 .1 .4 .1c12.3 .1 29.7 4.4 41 10.7 .8 .4 .2 1.9-.6 1.7-69.5-15.9-123.1 18.5-134.5 26.8-.2 .1-.3 .1-.5 .1s-.3-.1-.5-.2-.2-.3-.2-.5 .1-.4 .2-.5l-.1 0z"],
    "lumon": [640, 512, [], "e7e2", "M452.5 223.5c9.8 0 16.5 6.3 16.5 16.6l0 31.8c0 10.3-6.6 16.6-16.6 16.6l-56.2 0c-9.8 0-16.5-6.3-16.5-16.6l0-31.8c0-10.3 6.7-16.6 16.5-16.6l56.3 0zm-25.7 13.1c-1.5-2.6-3.2-2.6-4.6 0l-10.7 17.6c-1.7 2.4-2.6 5.1-2.6 8.2 0 7.9 6.9 14.6 15.6 14.6 8.5 0 15.6-6.7 15.6-14.6 0-3-1-5.8-2.7-8.2l-10.7-17.6zM85.8 223.8c1 0 1.5 .6 1.5 1.5l0 50.3 64.6 0c1 0 1.6 .6 1.6 1.5l0 9.7c0 .9-.6 1.5-1.6 1.5l-78.4 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l12.3 0zm88.3 0c1 0 1.5 .6 1.5 1.5l0 45c0 4 2 5.2 5.7 5.2l46.9 0c3.8 0 5.7-1.3 5.7-5.2l0-45c0-.9 .5-1.5 1.5-1.5l12.3 0c1 0 1.6 .6 1.6 1.5l0 46c0 10.5-5.3 16.8-17.6 16.8l-54 0c-12.3 0-17.6-6.3-17.6-16.8l0-46c0-.9 .6-1.5 1.6-1.5l12.3 0zm108.2 0c1 0 1.6 .5 2.2 1.4l30.5 46.4 1.4 0 30.5-46.4c.6-.9 1.2-1.4 2.2-1.4l18 0c1 0 1.5 .6 1.5 1.5l0 61.4c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-43.8-1.1 0-28.7 43.8c-.6 .9-1.3 1.5-2.4 1.5l-10.7 0c-1 0-1.7-.6-2.3-1.5l-28.7-43.8-1.1 0 0 43.8c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l17.9 0zm214.4 0c.9 0 1.3 .4 2.2 1.1l52.7 46.3 1.3 0 0-46c0-.9 .6-1.5 1.6-1.5l12.3 0c1 0 1.6 .6 1.6 1.5l0 61.4c0 .9-.6 1.5-1.6 1.5l-14.4 0c-1 0-1.4-.4-2.3-1.1l-52.6-46.3-1.4 0 0 46c0 .9-.5 1.5-1.5 1.5l-12.3 0c-1 0-1.6-.6-1.6-1.5l0-61.4c0-.9 .6-1.5 1.6-1.5l14.4 0zM320 114.1c87.9 0 167.7 15.7 225.5 41l2.7 1.2C587.1 173.8 640 206.5 640 256s-52.9 82.2-91.8 99.6l-2.7 1.2c-57.8 25.4-137.6 41-225.5 41-76.2 0-155.1-10.5-225.5-41-39.6-17.4-94.5-50.3-94.5-100.8s54.9-83.5 94.5-100.8c70.4-30.5 149.3-41 225.5-41zm-88.9 229c20.3 29 52.8 49.6 88.9 49.6 36.2 0 68.7-20.6 89-49.7l-177.9 .1zm-96.1 0c43.3 29.7 96.7 43.5 148.4 48-24.2-9.1-44.4-26.7-58.6-48.1l-89.9 0zm280.3-.1c-14.2 21.4-34.4 39.1-58.6 48.1 51.8-4.5 105.3-18.3 148.6-48.2l-90 0zm-337.4 .1c44.1 23.1 93.7 35.4 142.7 42.6-33.4-8.6-66.5-21.9-94.4-42.6l-48.3 0zm436.2-.2c-27.9 20.8-61.1 34.2-94.6 42.8 47.3-6.9 89.6-18.5 123.9-33.6l1.7-.8c6.1-2.7 11.9-5.5 17.4-8.4l-48.5 0zM520 173.6c10.7 8.7 19.8 18.1 27 28.2 .4 .6 .5 1.3 .1 2s-1 1-1.7 1l-1.6 0c-.6 0-1.2-.3-1.5-.8-7.9-10.9-18.2-21.1-30.6-30.4l-93.5 0c5.4 8.8 9.9 18.5 13.4 28.6 .2 .6 .1 1.2-.2 1.7s-.9 .8-1.6 .8l-1.4 0c-.8 0-1.5-.5-1.8-1.3-3.8-10.7-8.7-20.8-14.5-29.9l-184.3 .1c-5.8 9.1-10.7 19.1-14.4 29.8-.3 .8-1 1.3-1.8 1.3l-1.4 0c-.6 0-1.2-.3-1.6-.8s-.5-1.1-.2-1.7c3.5-10.2 8-19.7 13.4-28.6l-93.6 0c-12.3 9.3-22.6 19.4-30.4 30.3-.4 .5-.9 .8-1.5 .8l-1.6 0c-.7 0-1.4-.4-1.7-1s-.3-1.4 .1-2c7.6-10.5 16.7-19.9 26.8-28l-51 0c-28.9 16.6-62 43.3-63.5 79.7l44.7 0c.5 0 1 .2 1.3 .6s.6 .8 .6 1.3l0 1.3c0 1.1-.9 1.9-1.9 1.9l-44.7 0C6.8 295 40 321.7 69 338.3l50.9 0c-10.3-8.4-19.1-17.4-26.1-27l-.8-1.1c-.4-.6-.5-1.3-.1-2s1-1 1.7-1l1.6 0 .2 0c.5 .1 1 .3 1.3 .8 7.9 10.9 18.1 21 30.5 30.3l93.6 0c-5.3-8.8-9.8-18.4-13.4-28.5-.2-.6-.1-1.2 .2-1.7s.9-.8 1.6-.8l1.4 0 .2 0c.7 .1 1.4 .6 1.7 1.3 3.8 10.7 8.6 20.7 14.4 29.8l184.5-.1c5.8-9.1 10.6-19.1 14.4-29.7l.1-.1c.3-.7 1-1.1 1.7-1.1l1.4 0c.6 0 1.2 .3 1.6 .8s.5 1.2 .2 1.7c-3.5 10.1-8 19.7-13.3 28.5l93.7 0c12.3-9.3 22.5-19.4 30.3-30.2l.1-.2c.4-.4 .9-.6 1.4-.6l1.6 0c.7 0 1.4 .4 1.7 1s.3 1.4-.1 2c-7.1 10-16.1 19.3-26.7 27.9l51.1 0c28.8-16.6 61.8-43.3 63.4-79.6l-44.7 0c-1 0-1.9-.9-1.9-1.9l0-1.3c0-1.1 .9-1.9 1.9-1.9l44.7 0c-1.6-36.5-34.9-63.3-63.9-79.9l-50.9 0zM220.5 126.2c-49.1 7.1-98.7 19.5-143 42.7l48.4 0c27.9-20.8 61-34.1 94.5-42.7zm62.8-5.4c-51.8 4.5-105.2 18.3-148.6 48.1l90 0c14.2-21.4 34.4-39 58.6-48.1zm36.6-1.6c-36.2 0-68.7 20.6-89 49.7l177.9-.1c-20.3-29.1-52.7-49.6-88.9-49.6zm36.6 1.6c24.2 9.1 44.4 26.6 58.5 48l89.8 0c-43.3-29.7-96.6-43.5-148.3-48zm62.8 5.4c33.4 8.5 66.4 21.9 94.3 42.5l48.3 0c-44.1-23.1-93.6-35.4-142.6-42.5z"],
    "nutritionix": [448, 512, [], "f3d6", "M112 8.1S245.4-.1 233 112.5c0 0 19.1-74.9 103-40.6 0 0-17.7 74-88 56 0 0 14.6-54.6 66.1-56.6 0 0-39.9-10.3-82.1 48.8 0 0-19.8-94.5-93.6-99.7 0 0 75.2 19.4 77.6 107.5 0 .1-106.4 7-104-119.8zM424 323.7c0 48.5-9.7 95.3-32 132.3-42.2 30.9-105 48-168 48-62.9 0-125.8-17.1-168-48-22.3-37-32-83.8-32-132.3 0-48.4 17.7-94.7 40-131.7 42.2-30.9 97.1-48.6 160-48.6 63 0 117.8 17.6 160 48.6 22.3 37 40 83.3 40 131.7zM144 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM216 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM288 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM360 428a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm0-66.2a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM384 256c-4.8-22.3-7.4-36.9-16-56-38.8-19.9-90.5-32-144-32S118.8 180.1 80 200c-8.8 19.5-11.2 33.9-16 56 42.2-7.9 98.7-14.8 160-14.8s117.8 6.9 160 14.8z"],
    "creative-commons-sampling-plus": [512, 512, [], "f4f1", "M255.6 8C397.4 8 504 118.1 504 256 504 403.1 385.5 504 255.6 504 121.6 504 8 394.5 8 256 8 123.1 112.7 8 255.6 8zm.8 44.7c-118.2 0-203.7 97.9-203.7 203.3 0 109.8 91.2 202.8 203.7 202.8 103.2 0 202.8-81.1 202.8-202.8 .1-113.8-90.2-203.3-202.8-203.3zm107 205.6c-4.7 0-9 2.8-10.7 7.2l-4 9.5-11-92.8c-1.7-13.9-22-13.4-23.1 .4l-4.3 51.4-5.2-68.8c-1.1-14.3-22.1-14.2-23.2 0l-3.5 44.9-5.9-94.3c-.9-14.5-22.3-14.4-23.2 0l-5.1 83.7-4.3-66.3c-.9-14.4-22.2-14.4-23.2 0l-5.3 80.2-4.1-57c-1.1-14.3-22-14.3-23.2-.2l-7.7 89.8-1.8-12.2c-1.7-11.4-17.1-13.6-22-3.3l-13.2 27.7-43.9 0 0 23.2 51.3 0c4.4 0 8.4-2.5 10.4-6.4l10.7 73.1c2 13.5 21.9 13 23.1-.7l3.8-43.6 5.7 78.3c1.1 14.4 22.3 14.2 23.2-.1l4.6-70.4 4.8 73.3c.9 14.4 22.3 14.4 23.2-.1l4.9-80.5 4.5 71.8c.9 14.3 22.1 14.5 23.2 .2l4.6-58.6 4.9 64.4c1.1 14.3 22 14.2 23.1 .1l6.8-83 2.7 22.3c1.4 11.8 17.7 14.1 22.3 3.1l18-43.4 50.5 0 0-23.2-58.4 .3zm-78 5.2l-21.9 0 0 21.9c0 4.1-3.3 7.5-7.5 7.5-4.1 0-7.5-3.3-7.5-7.5l0-21.9-21.9 0c-4.1 0-7.5-3.3-7.5-7.5 0-4.1 3.4-7.5 7.5-7.5l21.9 0 0-21.9c0-4.1 3.4-7.5 7.5-7.5s7.5 3.3 7.5 7.5l0 21.9 21.9 0c4.1 0 7.5 3.3 7.5 7.5 0 4.1-3.4 7.5-7.5 7.5z"],
    "redhat": [512, 512, [], "f7bc", "M341.5 285.6c33.7 0 82.3-6.9 82.3-47 .2-6.7 .9-1.8-20.9-96.2-4.6-19.1-8.7-27.8-42.3-44.6-26.1-13.3-82.9-35.4-99.7-35.4-15.7 0-20.2 20.2-38.9 20.2-18 0-31.3-15.1-48.1-15.1-16.1 0-26.7 11-34.8 33.6-27.5 77.6-26.3 74.3-26.1 78.3 0 24.8 97.6 106.1 228.5 106.1zM429 254.8c4.7 22 4.7 24.3 4.7 27.2 0 37.7-42.3 58.6-98 58.6-125.7 .1-235.9-73.6-235.9-122.3 0-6.8 1.4-13.5 4.1-19.7-45.2 2.3-103.8 10.3-103.8 62 0 84.7 200.6 189 359.5 189 121.8 0 152.5-55.1 152.5-98.6 0-34.2-29.6-73-82.9-96.2z"],
    "square-pied-piper": [448, 512, ["pied-piper-square"], "e01e", "M32.1 419l-32 60.2 .8-328C.9 85.3 54.1 32 120.1 32l327.2 0C354.3 60.9 257.4 126.2 193.4 200.6 122.8 282 82.7 338 32.1 419zm416-387S305.3 98.8 261.7 199.1c-23.2 53.6-28.9 118.1-71 158.6-28.9 27.8-69.8 38.2-105.3 56.3-23.2 12-66.4 40.5-84.9 66l328.4 0c66 0 119.3-53.3 119.3-119.2-.1 0-.1-328.8-.1-328.8z"],
    "whatsapp": [448, 512, [], "f232", "M380.9 97.1c-41.9-42-97.7-65.1-157-65.1-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480 117.7 449.1c32.4 17.7 68.9 27 106.1 27l.1 0c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3 18.6-68.1-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1s56.2 81.2 56.1 130.5c0 101.8-84.9 184.6-186.6 184.6zM325.1 300.5c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8s-14.3 18-17.6 21.8c-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7s-12.5-30.1-17.1-41.2c-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2s-9.7 1.4-14.8 6.9c-5.1 5.6-19.4 19-19.4 46.3s19.9 53.7 22.6 57.4c2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4s4.6-24.1 3.2-26.4c-1.3-2.5-5-3.9-10.5-6.6z"],
    "imdb": [448, 512, [], "f2d8", "M89.5 323.6l-35.6 0 0-137.4 35.6 0 0 137.4zm66.6-73.1l9.1-64.3 46.3 0 0 137.4-31 0 0-92.7-13.4 92.7-21.3 0-13-90.7-.1 90.7-31.2 0 0-137.4 46.1 0c.5 8.3 2.8 18.1 4.3 29.4l4.2 34.9zm67.6 73.1l0-137.4 26.6 0c17 0 27 .9 33 2.4 6.1 1.7 10.7 4.2 13.9 7.9 3.1 3.3 5.1 6.6 5.8 12 .9 4.4 1.4 13.1 1.4 26.2l0 48.2c0 12.3-.7 20.5-1.9 24.7-1.1 4.1-3.1 7.4-6 9.7-2.8 2.4-6.4 4.1-10.7 5-4.2 .8-10.6 1.3-19.1 1.3l-43 0zm35.5-113.9l0 89.4c5.1 0 8.3-1 9.4-2.3 1.1-2 1.8-7.6 1.8-16.7l0-53.3c0-6.2-.1-10.2-.7-12-.3-1.8-1.2-3-2.6-4.7-1.4 0-4.1-.4-7.9-.4zm57.3 113.9l0-137.4 34.1 0 0 43.9c2.9-2.4 6.1-4.9 9.5-6.6 3.6-1.5 8.8-2.4 12.8-2.4 4.8 0 8.9 .8 12.3 2.2 3.4 1.5 6 3.5 8 6.2 1.7 2.6 2.7 5.3 3.1 7.8 .4 2.6-.2 8-.2 16.2l0 38.6c0 8.2 .2 14.3-.8 18.4-1.1 4-3.8 7.6-7.8 9.6-4.1 3.9-8.9 5.3-14.6 5.3-4 0-9.2-.9-12.7-2.5-3.5-1.8-6.7-4.5-9.6-8l-2.1 8.7-32 0zm45.1-20.7c.7-1.8 1-6 1-12.5l0-35.4c0-5.6-.3-9.5-1.1-11.2-.7-1.9-3.7-2.7-5.8-2.7-2 0-3.4 .8-4.1 2.3-.6 1.5-1 5.4-1 11.6l0 36.4c0 6.1 .4 10 1.2 11.6 .6 1.7 2.1 2.5 4.1 2.5 2.2 0 4.2-.8 5.7-2.6zM418.4 32c15.7 1.2 28.7 15.2 28.7 31.9l0 384.2c0 16.4-11.9 30.4-28.2 31-.3 0-.5 .9-.8 .9L29.9 480c-.3 0-.6-.9-.8-.1-15.7-1.4-27.9-13.8-29-30.2L0 61.8C1.1 45.9 13.8 33.1 30.3 31.1l387.4 0c.2 0 .5 .9 .7 .9zM30.3 41.3C19 42 10 51 9.3 62.4l0 387.3c.4 5.4 2.7 10.5 6.4 14.3 3.8 3.9 8.8 6.3 14.2 6.7l388.2 0c11.5-1 20.6-11.6 20.6-22.6l0-384.2c0-5.7-2.1-11.3-6-15.5s-9.3-6.8-15-7.2l-387.4 0z"],
    "python": [448, 512, [], "f3e2", "M439.8 200.5c-7.7-30.9-22.3-54.2-53.4-54.2l-40.1 0 0 47.4c0 36.8-31.2 67.8-66.8 67.8l-106.8 0c-29.2 0-53.4 25-53.4 54.3l0 101.8c0 29 25.2 46 53.4 54.3 33.8 9.9 66.3 11.7 106.8 0 26.9-7.8 53.4-23.5 53.4-54.3l0-40.7-106.7 0 0-13.6 160.2 0c31.1 0 42.6-21.7 53.4-54.2 11.2-33.5 10.7-65.7 0-108.6zM286.2 444.7a20.4 20.4 0 1 1 0-40.7 20.4 20.4 0 1 1 0 40.7zM167.8 248.1l106.8 0c29.7 0 53.4-24.5 53.4-54.3l0-101.9c0-29-24.4-50.7-53.4-55.6-35.8-5.9-74.7-5.6-106.8 .1-45.2 8-53.4 24.7-53.4 55.6l0 40.7 106.9 0 0 13.6-147 0c-31.1 0-58.3 18.7-66.8 54.2-9.8 40.7-10.2 66.1 0 108.6 7.6 31.6 25.7 54.2 56.8 54.2l36.7 0 0-48.8c0-35.3 30.5-66.4 66.8-66.4zM161.2 64.7a20.4 20.4 0 1 1 0 40.8 20.4 20.4 0 1 1 0-40.8z"],
    "cash-app": [448, 512, [], "e7d4", "M440.3 96.9c-9.4-26.5-30.3-47.4-56.8-57-24.1-7.9-46.3-7.9-91.6-7.9L156 32c-44.8 0-67.2 0-91.3 7.5-26.5 9.6-47.4 30.5-57 57-7.7 24.3-7.7 46.7-7.7 91.7L0 323.8c0 45.2 0 67.4 7.5 91.5 9.6 26.5 30.5 47.4 57 57 24.3 7.7 46.7 7.7 91.6 7.7l135.7 0c45 0 67.4 0 91.6-7.7 26.5-9.6 47.4-30.5 57-57 7.7-24.3 7.7-46.7 7.7-91.5l0-135.5c0-45 0-67.4-7.7-91.5zM323.1 185.4l-25.8 21.1c-2.3 1.9-5.5 1.5-7.3-.9-13.2-16.2-33.7-25.4-56.1-25.4-25 0-40.6 10.9-40.6 26.2-.4 12.8 11.7 19.6 49.1 27.7 47.2 10 68.7 29.7 68.7 62.7 0 41.4-33.7 71.9-86.4 75.3l-5.1 24.5c-.4 2.3-2.6 4.1-5.1 4.1l-40.6 0c-3.4 0-5.8-3.2-5.1-6.4l6.4-27.3c-26-7.5-47.2-22-59.3-39.7-1.5-2.3-1.1-5.3 1.1-7l28.2-22c2.3-1.9 5.8-1.3 7.5 1.1 14.9 20.9 38 33.3 65.7 33.3 25 0 43.8-12.2 43.8-29.7 0-13.4-9.4-19.6-41.2-26.2-54.2-11.7-75.8-31.8-75.8-64.9 0-38.4 32.2-67.2 80.9-71l5.3-25.4c.4-2.3 2.6-4.1 5.1-4.1l39.9 0c3.2 0 5.8 3 5.1 6.2l-6.2 28.4c20.9 6.4 38 17.9 48.7 32.2 1.7 2.1 1.3 5.3-.9 7z"],
    "pinterest-p": [384, 512, [], "f231", "M204 6.5c-102.6 0-204 68.4-204 179.1 0 70.4 39.6 110.4 63.6 110.4 9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8 0-99.3-85.8-164.1-180-164.1z"],
    "whmcs": [448, 512, [], "f40d", "M448 161l0-21.3-28.5-8.8-2.2-10.4 20.1-20.7-10.4-19.4-29 7.5-7.2-7.5 7.5-28.2-19.1-11.6-21.3 21-10.7-3.2-7-26.4-22.6 0-6.2 26.4-12.1 3.2-19.7-21-19.4 11 8.1 27.7-8.1 8.4-28.5-7.5-11 19.1 20.7 21-2.9 10.4-28.5 7.8-.3 21.7 28.8 7.5 2.4 12.1-20.1 19.9 10.4 18.5 29.6-7.5 7.2 8.6-8.1 26.9 19.9 11.6 19.4-20.4 11.6 2.9 6.7 28.5 22.6 .3 6.7-28.8 11.6-3.5 20.7 21.6 20.4-12.1-8.8-28 7.8-8.1 28.8 8.8 10.3-20.1-20.9-18.8 2.2-12.1 29.1-7zM328.8 92.6a56.8 56.8 0 1 1 0 113.6 56.8 56.8 0 1 1 0-113.6zm72.3 130l46.9 14.5 0 39.9-55.1 13.4-4.1 22.7 38.9 35.3-19.2 37.9-54-16.7-14.6 15.2 16.7 52.5-38.3 22.7-38.9-40.5-21.7 6.6-12.6 54-42.4-.5-12.6-53.6-21.7-5.6-36.4 38.4-37.4-21.7 15.2-50.5-13.7-16.1-55.5 14.1-19.7-34.8 37.9-37.4-4.8-22.8-54-14.1 .5-40.9 53.5-14.7 5.7-19.7-38.9-39.4 20.7-35.8 53.6 14.1 15.2-15.7-15.2-52 36.4-20.7 36.8 39.4 22.7-6.1 11.6-52 42.4 0 11.6 45.9-22.6-5.9-6.3-1.7-3.3 5.7-11 19.1-3.3 5.6 4.6 4.6 17.2 17.4-.3 1-23.8 6.5-6.2 1.7c0 3.2-.1 9.6-.3 19.3-47.5 10.4-83.3 52.8-83.3 103.5 0 58.3 47.3 105.7 105.7 105.7 50.5 0 92.7-35.4 103.2-82.8 9.9 .1 16.6 .2 20.1 .3l1.6-6.7 5.6-24 1.9-.6 17.1 17.8 4.7 4.9 5.8-3.4 20.4-12.1 5.8-3.5-2-6.5-6.8-21.2z"],
    "joget": [512, 512, [], "f3b7", "M386.1 45C345.6 19.9 300.6 8 256.2 8 173 8 91.8 49.9 44.9 125.9-27 242.5 9.3 395.2 125.9 467.1s269.3 35.6 341.2-80.9C539 269.6 502.7 116.8 386.1 45zm51.8 323.2c-40.4 65.5-110.4 101.5-182 101.5-6.8 0-13.6-.4-20.4-1-9-13.6-19.9-33.3-23.7-42.4-5.7-13.7-27.2-45.6 31.2-67.1 51.7-19.1 176.7-16.5 208.8-17.6-4 9-8.6 17.9-13.9 26.6zM237.1 281.9c-55.5-1.4-81.7-20.8-58.5-48.2s51.1-40.7 68.9-51.2c17.9-10.5 27.3-33.7-23.6-29.7-128.6 8.7-167.3 99.3-178.3 140.2-8.8-49.7-.1-102.7 28.5-149.1 61.9-100.5 193.5-131.7 294-69.8 74.8 46.1 111.2 130.9 99.3 212.7-24.9-.5-179.3-3.6-230.3-4.9zm183.8-54.8c-22.7-6-57 11.3-86.7 27.2-29.7 15.8-31.1 8.2-31.1 8.2s40.2-28.1 50.7-34.5 31.9-14 13.4-24.6c-3.2-1.8-6.7-2.7-10.4-2.7-17.8 0-41.5 18.7-67.5 35.6-31.5 20.5-65.3 31.3-65.3 31.3L393.5 266 440 242.6s3.6-9.5-19.1-15.5z"],
    "square-youtube": [448, 512, [61798, "youtube-square"], "f431", "M282 256.2l-95.2-54.1 0 108.2 95.2-54.1zM384 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64zm14.4 136.1c7.6 28.6 7.6 88.2 7.6 88.2s0 59.6-7.6 88.1c-4.2 15.8-16.5 27.7-32.2 31.9-28.3 7.7-142.2 7.7-142.2 7.7s-113.9 0-142.2-7.6c-15.7-4.2-28-16.1-32.2-31.9-7.6-28.6-7.6-88.2-7.6-88.2s0-59.7 7.6-88.2c4.2-15.8 16.5-28.2 32.2-32.4 28.3-7.7 142.2-7.7 142.2-7.7s113.9 0 142.2 7.7c15.7 4.2 28 16.6 32.2 32.4z"],
    "atlassian": [512, 512, [], "f77b", "M152.2 236.4c-7.7-8.2-19.7-7.7-24.8 2.8L1.6 490.2c-5 10 2.4 21.7 13.4 21.7l175 0c5.8 .1 11-3.2 13.4-8.4 37.9-77.8 15.1-196.3-51.2-267.1zM244.4 8.1c-122.3 193.4-8.5 348.6 65 495.5 2.5 5.1 7.7 8.4 13.4 8.4L497 512c11.2 0 18.4-11.8 13.4-21.7 0 0-234.5-470.6-240.4-482.3-5.3-10.6-18.8-10.8-25.6 .1z"],
    "pied-piper-hat": [640, 512, [], "f4e5", "M640 24.9c-80.8 53.6-89.4 92.5-96.4 104.4-6.7 12.2-11.7 60.3-23.3 83.6-11.7 23.6-54.2 42.2-66.1 50-11.7 7.8-28.3 38.1-41.9 64.2-108.1-4.4-167.4 38.8-259.2 93.6 29.4-9.7 43.3-16.7 43.3-16.7 94.2-36 139.3-68.3 281.1-49.2 1.1 0 1.9 .6 2.8 .8 3.9 2.2 5.3 6.9 3.1 10.8l-53.9 95.8c-2.5 4.7-7.8 7.2-13.1 6.1-126.8-23.8-226.9 17.3-318.9 18.6-73.4 1.1-97.5-33.5-97.5-35.1 0-1.1 .6-1.7 1.7-1.7 0 0 38.3 0 103.1-15.3 73.6-140.3 139.2-189.4 210.6-189.4 0 0 71.7 0 90.6 61.9 22.8-39.7 28.3-49.2 28.3-49.2 5.3-9.4 35-77.2 86.4-141.4 51.5-64 90.4-79.9 119.3-91.8z"],
    "internet-explorer": [512, 512, [], "f26b", "M483.1 159.7c10.9-24.6 21.4-60.4 21.4-87.9 0-72.7-79.6-98.4-209.7-38.6-107.6-7.2-211.2 73.7-237.1 186.5 30.9-34.9 78.3-82.3 122-101.2-54.3 48.3-100.6 109.4-135.7 173.2-20.7 37.9-44 99.2-44 145 0 98.6 92.9 86.5 180.3 42 31.4 15.4 66.6 15.6 101.7 15.6 97.1 0 184.2-54.3 216.8-146l-120.8 0c-52.5 88.6-196.8 53-196.8-47.4l328.8 0c6.4-43.6-1.7-95.7-26.9-141.2zM64.6 346.9C82.3 398 118.3 442.7 164.8 470.2 76.1 519.1-8.4 499.3 64.6 346.9zM180.5 238c2-55.2 50.3-94.9 104-94.9 53.4 0 102 39.7 104 94.9l-208 0zM365.1 50.4c21.4-10.3 48.6-22 72.6-22 31.4 0 54.3 21.7 54.3 53.7 0 20-7.4 49-14.6 67.9-26.3-42.3-66-81.6-112.3-99.6z"],
    "airbnb": [448, 512, [], "f834", "M224.5 373.1c-25.2-31.7-40.1-59.4-45-83.2-22.5-88 112.6-88 90.1 0-5.4 24.2-20.3 52-45 83.2l-.1 0zm138.2 73.2c-42.1 18.3-83.7-10.9-119.3-50.5 103.9-130.1 46.1-200-18.8-200-54.9 0-85.2 46.5-73.3 100.5 6.9 29.2 25.2 62.4 54.4 99.5-32.5 36-60.5 52.7-85.2 54.9-50 7.4-89.1-41.1-71.3-91.1 15.1-39.2 111.7-231.2 115.9-241.6 15.8-30.1 25.6-57.4 59.4-57.4 32.3 0 43.4 25.9 60.4 59.9 36 70.6 89.4 177.5 114.8 239.1 13.2 33.1-1.4 71.3-37 86.6zm47-136.1c-128.9-274.3-136-278.2-185.1-278.2-45.5 0-64.9 31.7-84.7 72.8-106.2 212.3-116.4 242.4-117.3 245-25.2 69.3 26.7 130.2 89.6 130.2 21.7 0 60.6-6.1 112.4-62.4 58.7 63.8 101.3 62.4 112.4 62.4 62.9 .1 114.9-60.9 89.6-130.2 0-3.9-16.8-38.9-16.8-39.6l0 0z"],
    "js": [448, 512, [], "f3b8", "M0 32l0 448 448 0 0-448-448 0zM243.8 381.4c0 43.6-25.6 63.5-62.9 63.5-33.7 0-53.2-17.4-63.2-38.5L152 385.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5l0-143.1 42.1 0 0 143.7zm99.6 63.5c-39.1 0-64.4-18.6-76.7-43L301 382.1c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6z"],
    "quinscape": [512, 512, [], "f459", "M313.7 474.6l-1 0c-41.9 0-82.1-16.7-111.8-46.3s-46.3-69.9-46.3-111.8 16.7-82.1 46.3-111.8 69.9-46.3 111.8-46.3c94.9 0 168.2 83.1 157 176.6 4 5.1 8.2 9.6 11.2 15.3 13.4-30.3 20.3-62.4 20.3-97.7 0-135.1-109.5-244.6-244.6-244.6S12.1 117.5 12.1 252.6 121.6 497.2 256.6 497.2c23.8 .2 47.6-3.2 70.4-10.1-5.2-3.5-8.9-8.1-13.3-12.5zm78.3-169a99.2 99.2 0 1 0 0 198.4 99.2 99.2 0 1 0 0-198.4z"],
    "adversal": [512, 512, [], "f36a", "M482.1 32L28.7 32C5.8 32 0 37.9 0 60.9L0 451.1C0 474.4 5.8 480 28.7 480l453.4 0c24.4 0 29.9-5.2 29.9-29.7l0-388.1c0-24.6-5.4-30.2-29.9-30.2zM178.4 220.3c-27.5-20.2-72.1-8.7-84.2 23.4-4.3 11.1-9.3 9.5-17.5 8.3-9.7-1.5-17.2-3.2-22.5-5.5-28.8-11.4 8.6-55.3 24.9-64.3 41.1-21.4 83.4-22.2 125.3-4.8 40.9 16.8 34.5 59.2 34.5 128.5 2.7 25.8-4.3 58.3 9.3 88.8 1.9 4.4 .4 7.9-2.7 10.7-8.4 6.7-39.3 2.2-46.6-7.4-1.9-2.2-1.8-3.6-3.9-6.2-3.6-3.9-7.3-2.2-11.9 1-57.4 36.4-140.3 21.4-147-43.3-3.1-29.3 12.4-57.1 39.6-71 38.2-19.5 112.2-11.8 114-30.9 1.1-10.2-1.9-20.1-11.3-27.3zm286.7 222c0 15.1-11.1 9.9-17.8 9.9l-394.9 0c-7.4 0-18.2 4.8-17.8-10.7 .4-13.9 10.5-9.1 17.1-9.1 132.3-.4 264.5-.4 396.8 0 6.8 0 16.6-4.4 16.6 9.9zm3.8-340.5l0 291c0 5.7-.7 13.9-8.1 13.9-12.4-.4-27.5 7.1-36.1-5.6-5.8-8.7-7.8-4-12.4-1.2-53.4 29.7-128.1 7.1-144.4-85.2-6.1-33.4-.7-67.1 15.7-100 11.8-23.9 56.9-76.1 136.1-30.5l0-71c0-26.2-.1-26.2 26-26.2 3.1 0 6.6 .4 9.7 0 10.1-.8 13.6 4.4 13.6 14.3-.1 .2-.1 .3-.1 .5zM417.4 334.1c-19.5 47.6-72.9 43.3-90 5.2-15.1-33.3-15.5-68.2 .4-101.5 16.3-34.1 59.7-35.7 81.5-4.8 20.6 28.8 14.9 84.6 8.1 101.1zM122.6 369.4c-7.5-1.3-33-3.3-33.7-27.8-.4-13.9 7.8-23 19.8-25.8 24.4-5.9 49.3-9.9 73.7-14.7 8.9-2 7.4 4.4 7.8 9.5 1.4 33-26.1 59.2-67.6 58.8z"],
    "creative-commons": [512, 512, [], "f25e", "M253.8 214.9l-33.2 17.3c-9.4-19.6-25.2-19.9-27.5-19.9-22.1 0-33.2 14.6-33.2 43.8 0 23.6 9.2 43.8 33.2 43.8 14.5 0 24.6-7.1 30.6-21.3l30.6 15.5c-6.2 11.5-25.7 39-65.1 39-22.6 0-74-10.3-74-77 0-58.7 43-77.1 72.6-77.1 30.7 0 52.7 11.9 66 35.9zm143 0l-32.8 17.3c-9.5-19.8-25.7-19.9-27.9-19.9-22.1 0-33.2 14.6-33.2 43.8 0 23.5 9.2 43.8 33.2 43.8 14.4 0 24.6-7.1 30.5-21.3l31 15.5c-2.1 3.8-21.4 39-65.1 39-22.7 0-74-9.9-74-77 0-58.7 43-77.1 72.6-77.1 30.7 0 52.6 11.9 65.6 35.9zM255.6 8C112.7 8 8 123.1 8 256.1 8 394.5 121.6 504.1 255.6 504.1 385.5 504.1 504 403.2 504 256.1 504 118.2 397.4 8 255.6 8zm.9 450.8c-112.5 0-203.7-93-203.7-202.8 0-105.4 85.4-203.3 203.7-203.3 112.5 0 202.8 89.5 202.8 203.3 0 121.7-99.7 202.8-202.8 202.8z"],
    "notion": [512, 512, [], "e7d9", "M94.9 100.2c14.9 12.1 20.5 11.2 48.6 9.3L407.8 93.6c5.6 0 .9-5.6-.9-6.5L362.9 55.4c-8.4-6.5-19.6-14-41.1-12.1L65.9 61.9c-9.3 .9-11.2 5.6-7.5 9.3l36.4 28.9zm15.9 61.6l0 278.1c0 14.9 7.5 20.5 24.3 19.6l290.5-16.8c16.8-.9 18.7-11.2 18.7-23.3l0-276.2c0-12.1-4.7-18.7-15-17.7L125.7 143.1c-11.2 .9-14.9 6.5-14.9 18.7zm286.7 14.9c1.9 8.4 0 16.8-8.4 17.8l-14 2.8 0 205.3c-12.2 6.5-23.4 10.3-32.7 10.3-15 0-18.7-4.7-29.9-18.7l-91.5-143.7 0 139 29 6.5s0 16.8-23.4 16.8l-64.4 3.7c-1.9-3.7 0-13.1 6.5-14.9l16.8-4.7 0-183.8-23.3-1.9c-1.9-8.4 2.8-20.5 15.9-21.5l69.1-4.7 95.3 145.6 0-128.8-24.3-2.8c-1.9-10.3 5.6-17.7 14.9-18.7l64.5-3.8zM44.4 36.7L310.6 17.1c32.7-2.8 41.1-.9 61.6 14l85 59.7c14 10.3 18.7 13.1 18.7 24.3l0 327.6c0 20.5-7.5 32.7-33.6 34.5L133.2 495.8c-19.6 .9-29-1.9-39.2-14.9L31.4 399.7c-11.2-14.9-15.9-26.1-15.9-39.2l0-291.2c0-16.8 7.5-30.8 28.9-32.7z"],
    "chromecast": [512, 512, [], "f838", "M448 64L64.2 64c-23.6 0-42.7 19.1-42.7 42.7l0 63.9 42.7 0 0-63.9 383.8 0 0 298.6-149.2 0 0 42.7 149.4 0c23.6 0 42.7-19.1 42.7-42.7l0-298.6C490.9 83.1 471.6 64 448 64zM21.5 383.6l0 63.9 63.9 0c0-35.3-28.6-63.9-63.9-63.9zm0-85l0 42.4c58.9 0 106.6 48.1 106.6 107l42.7 0c.1-82.4-66.9-149.3-149.3-149.4zM213.6 448l42.7 0C255.8 318.5 151 213.7 21.5 213.4l0 42.4c106-.2 192 86.2 192.1 192.2z"],
    "wikipedia-w": [640, 512, [], "f266", "M640 51.2l-.3 12.2c-28.1 .8-45 15.8-55.8 40.3-25 57.8-103.3 240-155.3 358.6l-13.6 0-81.9-193.1c-32.5 63.6-68.3 130-99.2 193.1-.3 .3-15 0-15-.3-46.9-109.7-96.1-218.6-143.1-328.6-11.4-26.7-49.4-70-75.6-69.7 0-3.1-.3-10-.3-14.2l161.9 0 0 13.9c-19.2 1.1-52.8 13.3-43.3 34.2 21.9 49.7 103.6 240.3 125.6 288.6 15-29.7 57.8-109.2 75.3-142.8-13.9-28.3-58.6-133.9-72.8-160-9.7-17.8-36.1-19.4-55.8-19.7l0-13.9 142.5 .3 0 13.1c-19.4 .6-38.1 7.8-29.4 26.1 18.9 40 30.6 68.1 48.1 104.7 5.6-10.8 34.7-69.4 48.1-100.8 8.9-20.6-3.9-28.6-38.6-29.4 .3-3.6 0-10.3 .3-13.6 44.4-.3 111.1-.3 123.1-.6l0 13.6C462.4 64 439.1 76 426.8 94.9L367.6 217.7c6.4 16.1 63.3 142.8 69.2 156.7L559.2 91.8c-8.6-23.1-36.4-28.1-47.2-28.3l0-13.9 127.8 1.1 .2 .5z"],
    "sitrox": [448, 512, [], "e44a", "M212.4 0l0 0 235.6 0 0 128-384 0C64 57.6 141.8 .5 212.4 0zm24.8 192l0 0c69.9 .5 146.7 57.6 146.7 128l-173.2 0 0 0C140.9 319.6 64 262.4 64 192l173.3 0zm-1.7 320c70.7-.5 148.4-57.6 148.4-128l-384 0 0 128 235.6 0 0 0z"],
    "square-gitlab": [448, 512, ["gitlab-square"], "e5ae", "M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm337.5 12.5l44.6 116.4 .4 1.2c5.6 16.8 7.2 35.2 2.3 52.5-5 17.2-15.4 32.4-29.8 43.3l-.2 .1-68.4 51.2-54.1 40.9c-.5 .2-1.1 .5-1.7 .8-2 1-4.4 2-6.7 2-3 0-6.8-1.8-8.3-2.8l-54.2-40.9-67.9-50.9-.4-.3-.2-.1c-14.3-10.8-24.8-26-29.7-43.3s-4.2-35.7 2.2-52.5l.5-1.2 44.7-116.4c.9-2.3 2.5-4.3 4.5-5.6 1.6-1 3.4-1.6 5.2-1.8 1.3-.7 2.1-.4 3.4 .1 .6 .2 1.2 .5 2 .7 1 .4 1.6 .9 2.4 1.5 .6 .4 1.2 1 2.1 1.5 1.2 1.4 2.2 3 2.7 4.8l29.2 92.2 122.9 0 30.2-92.2c.5-1.8 1.4-3.4 2.6-4.8s2.8-2.4 4.5-3.1c1.7-.6 3.6-.9 5.4-.7s3.6 .8 5.2 1.8c2 1.3 3.7 3.3 4.6 5.6z"],
    "shoelace": [512, 512, [], "e60c", "M405.2 331c2.2-1.1 4.4-2.3 6.5-3.7l8.3-4.8c1.5-1.1 4.4-3.4 8.7-6.7l.5-.5c3.4-3.4 7.2-5 11.3-4.9 1.8 0 3.9 .5 6.4 1.5l31-27.5c.9-.7 1.7-1.3 2.6-1.8l.2 0c3.3-1.9 6-1.8 8.2 .4 3.9 2.1 4.2 5.6 .9 10.6L457.2 322c.2 .5 .4 1 .4 1.5 .5 2.2 .3 4.4-.5 6.6-.7 1.5-1.8 2.9-3.1 4.2-1.4 1.4-2.7 2.8-4.2 4.2L431 352.2c-1.7 1.2-3.4 2.3-5.1 3.3-2.1 1.3-4.3 2.5-6.6 3.6-1 .4-1.9 .9-2.9 1.3-5.9 2.5-11.9 4.2-18.2 5-2.9 24.5-11.3 47.1-25.1 67.8-17.5 25.7-41.4 45.4-71.8 58.8-30.2 13.5-63 20.2-98.2 20.2-48.6-.5-88-11.4-118.2-32.8-35.1-25-52.6-57.9-52.6-99.1l0-5.6c1.2-28.1 9.5-54.6 24.8-79.8 15.1-24.9 37.1-41.7 66.1-50.5 14.9-4.4 29.9-6.6 45-6.6 15.5 0 31.6 2.9 48.1 8.6s35.2 15.5 55.9 29.5l54.1 36.3c15.1 9.8 28.8 16.5 41.2 20-2.6-25.1-11.7-46.6-27.3-64.5-15.7-18.1-35.6-31.3-59.9-39.7L257 220c-21.4-7.5-37.3-14.9-47.7-22.2-28.2-19.1-43.8-45.2-47-78.5l-.5-9.8c0-32.1 13-58.9 39-80.5 23-19.3 50.6-29 82.5-29 24 0 45.6 6.9 64.7 20.8 19.2 14 30.1 33.8 32.6 59.4l.5 10c0 18.6-4.8 34.5-14.4 47.7-9.8 13.2-18.5 19.9-26 19.9-1.6-.1-3.1-.3-4.5-.6l-34 32c-5.5 3-9.2 2.5-11.1-1.6-1.9-2.2-1.8-4.9 .5-8.2l.2-.2c.5-.7 1.2-1.5 2-2.4l31.6-30c-.4-1.5-.6-3.1-.6-4.8 0-4.1 1.6-7.6 4.9-10.4 13.8-12.4 20.8-26.7 20.8-42.8 0-16-6.1-29.5-18.2-40.4s-28.7-16.5-49.7-16.8c-26.2 0-47.8 7.9-64.7 23.7S192.6 89.9 192.6 112c0 17.8 6.9 33.9 20.6 48.3 13.6 14.2 34.6 25.4 63 33.5 39.8 11.5 70.2 31 91.3 58.3 18.7 24.2 29.1 51.3 31.3 81.4 2.2-.7 4.3-1.5 6.5-2.6l-.1 .1zM294.4 178.7c0 1.1 .6 1.6 1.8 1.6 .1 0 9.7-8.9 28.8-26.6 0-2.4-5.1 .9-15.3 10-10.2 9.2-15.3 14.2-15.3 14.9l0 .1zm8 6.4c0-1-.5-1.5-1.5-1.5-1.1 0-2.1 .5-2.9 1.6-1.9-.1-3.3 .1-4.2 .7-.4 .2-.5 .5-.5 .7 0 .7 .5 1.3 1.5 1.6l3.3 0c2.9-1.1 4.4-2.2 4.4-3.3l-.1 .2zM325 165.2c0-2.8-1.6-2.8-4.9 0-1.6 1.5-3.6 3.5-6 6.2-.8 .6-2.6 2.2-5.3 4.9-2.8 2.9-4.2 4.7-4.2 5.3l.2 1.3c.7 .2 1.2 .4 1.5 .4 .1 0 3.3-2.9 9.5-8.7s9.3-8.9 9.3-9.3l-.1-.1zm159.7 120l-30.6 27c1.8 1 3.2 2.4 4 4.2l30.2-27c.2-1.2 .1-2.2-.5-2.9-.6-.5-1.6-.9-3.1-1.3zm-1.6-.9l-.7-.7-27 21.9 1.6 2 26-23.1 .1-.1zM366.9 363.9c-8-2.1-15.4-4.6-22.2-7.5-15.3-6.2-34.3-17-57-32.4l-37.4-25.3c-15.8-10.1-30.2-17.6-43.2-22.6-13.1-4.9-26-7.3-38.6-7.3l-5.5 0c-32.2 1.7-57.2 13.8-75 36.2-16.6 20.8-25 45.3-25 73.6 0 31.8 12.8 56.7 38.2 74.7 25.4 18.1 60.2 27.1 104.4 27.1 34.7 0 64-6.2 87.8-18.6 23.7-12.4 42.1-28.8 55.2-49.2 9.8-15.5 15.9-31.8 18.2-48.8l.1 .1z"],
    "sellcast": [448, 512, [], "f2da", "M353.5 32L94.8 32C42.7 32 .1 74.6 .1 126.6l0 258.7C.1 437.4 42.7 480 94.8 480l258.7 0c52.1 0 94.7-42.6 94.7-94.6l0-258.8c0-52-42.6-94.6-94.7-94.6zm-50 316.4c-27.9 48.2-89.9 64.9-138.2 37.2-22.9 39.8-54.9 8.6-42.3-13.2l15.7-27.2c5.9-10.3 19.2-13.9 29.5-7.9 18.6 10.8-.1-.1 18.5 10.7 27.6 15.9 63.4 6.3 79.4-21.3 15.9-27.6 6.3-63.4-21.3-79.4-17.8-10.2-.6-.4-18.6-10.6-24.6-14.2-3.4-51.9 21.6-37.5 18.6 10.8-.1-.1 18.5 10.7 48.4 28 65.1 90.3 37.2 138.5zm21.8-208.8c-17 29.5-16.3 28.8-19 31.5-6.5 6.5-16.3 8.7-26.5 3.6-18.6-10.8 .1 .1-18.5-10.7-27.6-15.9-63.4-6.3-79.4 21.3s-6.3 63.4 21.3 79.4c0 0 18.5 10.6 18.6 10.6 24.6 14.2 3.4 51.9-21.6 37.5-18.6-10.8 .1 .1-18.5-10.7-48.2-27.8-64.9-90.1-37.1-138.4 27.9-48.2 89.9-64.9 138.2-37.2l4.8-8.4c14.3-24.9 52-3.3 37.7 21.5z"],
    "mix": [448, 512, [], "f3cb", "M0 64L0 412.9c0 56.2 88 58.1 88 0l0-238.6c7.9-52.9 88-50.4 88 6.5l0 175.3c0 57.9 96 58 96 0L272 240c5.3-54.7 88-52.5 88 4.3l0 23.8c0 59.9 88 56.6 88 0L448 64 0 64z"],
    "cc-apple-pay": [576, 512, [], "f416", "M302.2 218.4c0 17.2-10.5 27.1-29 27.1l-24.3 0 0-54.2 24.4 0c18.4 0 28.9 9.8 28.9 27.1zM349.7 281c0 8.3 7.2 13.7 18.5 13.7 14.4 0 25.2-9.1 25.2-21.9l0-7.7-23.5 1.5c-13.3 .9-20.2 5.8-20.2 14.4zM576 79l0 352c0 26.5-21.5 48-48 48L48 479c-26.5 0-48-21.5-48-48L0 79C0 52.5 21.5 31 48 31l480 0c26.5 0 48 21.5 48 48zM127.8 197.2c8.4 .7 16.8-4.2 22.1-10.4 5.2-6.4 8.6-15 7.7-23.7-7.4 .3-16.6 4.9-21.9 11.3-4.8 5.5-8.9 14.4-7.9 22.8zm60.6 74.5c-.2-.2-19.6-7.6-19.8-30-.2-18.7 15.3-27.7 16-28.2-8.8-13-22.4-14.4-27.1-14.7-12.2-.7-22.6 6.9-28.4 6.9-5.9 0-14.7-6.6-24.3-6.4-12.5 .2-24.2 7.3-30.5 18.6-13.1 22.6-3.4 56 9.3 74.4 6.2 9.1 13.7 19.1 23.5 18.7 9.3-.4 13-6 24.2-6 11.3 0 14.5 6 24.3 5.9 10.2-.2 16.5-9.1 22.8-18.2 6.9-10.4 9.8-20.4 10-21zm135.4-53.4c0-26.6-18.5-44.8-44.9-44.8l-51.2 0 0 136.4 21.2 0 0-46.6 29.3 0c26.8 0 45.6-18.4 45.6-45zm90 23.7c0-19.7-15.8-32.4-40-32.4-22.5 0-39.1 12.9-39.7 30.5l19.1 0c1.6-8.4 9.4-13.9 20-13.9 13 0 20.2 6 20.2 17.2l0 7.5-26.4 1.6c-24.6 1.5-37.9 11.6-37.9 29.1 0 17.7 13.7 29.4 33.4 29.4 13.3 0 25.6-6.7 31.2-17.4l.4 0 0 16.4 19.6 0 0-68 .1 0zM516 210.9l-21.5 0-24.9 80.6-.4 0-24.9-80.6-22.3 0 35.9 99.3-1.9 6c-3.2 10.2-8.5 14.2-17.9 14.2-1.7 0-4.9-.2-6.2-.3l0 16.4c1.2 .4 6.5 .5 8.1 .5 20.7 0 30.4-7.9 38.9-31.8L516 210.9z"],
    "brave": [448, 512, [], "e63c", "M145.6 0l157 0 44.7 50.8s39.3-10.9 57.8 7.6 33.8 34.9 33.8 34.9l-12 29.5 15.3 43.7s-44.9 170.2-50.1 191c-10.4 40.9-17.4 56.8-46.9 77.5s-82.9 56.8-91.6 62.2c-1.9 1.2-3.9 2.5-5.9 3.9-7.5 5.1-15.8 10.8-23.5 10.8s-16.1-5.7-23.5-10.8c-2-1.4-4-2.8-5.9-3.9-8.7-5.5-62.1-41.5-91.6-62.2s-36.5-36.6-46.9-77.5c-5.3-20.8-50.1-191-50.1-191L21.5 122.8 9.3 93.3s15.3-16.4 33.8-34.9 57.8-7.6 57.8-7.6L145.6 0zm78.5 407.6c3.7 0 8.9-4.7 13-8.4 .6-.5 1.2-1.1 1.7-1.5 4.2-3.7 47.8-37.5 51-39.8s5.4-6.5 1.9-8.7c-2.8-1.7-10-5.5-20.3-10.8-3-1.6-6.3-3.2-9.7-5-15.4-8-34.5-14.7-37.5-14.7s-22.1 6.8-37.5 14.7c-3.5 1.8-6.7 3.5-9.7 5-10.3 5.3-17.6 9.1-20.3 10.8-3.6 2.2-1.4 6.4 1.9 8.7s46.8 36.1 51 39.8c.5 .5 1.1 1 1.7 1.5 4.1 3.7 9.3 8.4 13 8.4l-.2 0zm0-165.7c4.7 0 17.6-3 26.4-5l2-.5c7.8-1.8 7.3-6.3 6.4-13-.1-.8-.2-1.6-.3-2.4-.6-6.1-5.8-33.1-9.1-50.3-1.1-5.8-2-10.5-2.4-12.9-1.5-8.1-.6-9.4 .7-11.3 .2-.3 .5-.7 .7-1.1 1.4-2.3 16-6.2 27.9-9.5 2.5-.7 4.8-1.3 6.9-1.9 10.6-3 32.4-.6 44.2 .6 1.8 .2 3.4 .4 4.7 .5 9.6 .9 10.4 2.3 7.2 3.8-2.3 1.1-16.2 6.3-28.7 10.9-4.7 1.8-9.2 3.5-12.8 4.8-1.5 .5-3 1.1-4.5 1.7-12.5 4.6-27.2 10-28.9 19.4-1.5 8.3 5.2 19.9 11.3 30.3 1.6 2.8 3.2 5.5 4.6 8.1 6.3 11.9 6.5 13.3 6.1 18.1-.4 3.9-14.5 12.7-22.4 17.6-1.8 1.1-3.3 2.1-4.2 2.7-.8 .5-2.1 1.4-3.8 2.4-8.6 5.2-26.3 16-26.3 22.5 0 7.8 24.6 28.1 32.4 33.2s28.9 16.1 37.9 17.8 23-8.5 31.2-23.8c7.7-14.4 1.7-28.5-3.2-40l-.9-2.2c-4.5-10.6 1.9-17 6.2-21.3 .5-.5 1-1 1.4-1.4l43-45.7c1.3-1.3 2.5-2.6 3.7-3.8 5.8-5.7 10.8-10.5 10.8-22.8 0-14.9-57.5-84.5-57.5-84.5s-48.5 9.3-55.1 9.3c-5.2 0-15.3-3.5-25.8-7.1-2.7-.9-5.4-1.9-8-2.7-13-4.3-21.8-4.4-21.8-4.4s-8.7 0-21.8 4.4c-2.7 .9-5.4 1.8-8 2.7-10.5 3.6-20.6 7.1-25.8 7.1-6.5 0-55.1-9.3-55.1-9.3s-57.5 69.6-57.5 84.5c0 12.3 4.9 17.1 10.8 22.8 1.2 1.2 2.5 2.4 3.7 3.8l43.1 45.8c.4 .5 .9 .9 1.4 1.4 4.3 4.3 10.6 10.7 6.2 21.3l-.9 2.2c-4.9 11.5-11 25.6-3.2 40 8.2 15.3 22.2 25.5 31.2 23.8s30.1-12.7 37.9-17.8 32.4-25.4 32.4-33.2c0-6.5-17.7-17.3-26.3-22.5-1.7-1-3.1-1.9-3.8-2.4-.9-.6-2.4-1.5-4.2-2.7-7.9-4.9-22-13.7-22.4-17.6-.4-4.8-.3-6.2 6.1-18.1 1.3-2.5 2.9-5.3 4.6-8.1 6-10.4 12.8-22 11.3-30.3-1.7-9.4-16.4-14.8-28.9-19.4-1.6-.6-3.1-1.1-4.5-1.7-3.6-1.4-8.1-3.1-12.8-4.8l-.1 0c-12.5-4.7-26.4-9.9-28.7-10.9-3.2-1.5-2.3-2.8 7.2-3.8 1.3-.1 2.9-.3 4.7-.5 11.8-1.3 33.6-3.6 44.2-.6 2.1 .6 4.4 1.2 6.9 1.9 11.9 3.2 26.5 7.2 27.9 9.5 .2 .4 .5 .7 .7 1.1 1.3 1.9 2.2 3.2 .7 11.3-.4 2.4-1.3 7.1-2.4 12.9-3.3 17.2-8.5 44.2-9.1 50.3-.1 .8-.2 1.7-.3 2.4-.8 6.7-1.4 11.2 6.4 13l2 .5c8.8 2 21.8 5 26.4 5l0-.1z"],
    "etsy": [384, 512, [], "f2d7", "M384 348c-1.8 10.7-13.8 110-15.5 132-117.9-4.3-219.9-4.7-368.5 0l0-25.5c45.5-8.9 60.6-8 61-35.2 1.8-72.3 3.5-244.1 0-322-1-28.5-12.1-26.8-61-36L0 35.8c73.9 2.4 255.9 8.6 363-3.8-3.5 38.2-7.8 126.5-7.8 126.5l-23.2 0C320.9 115.7 313.2 68 277.3 68l-137 0c-10.2 0-10.7 3.5-10.7 9.8l0 163.8c58 .5 88.5-2.5 88.5-2.5 29.8-1 27.6-8.5 40.7-65.3l25.8 0c-4.4 101.4-3.9 61.8-1.8 160.3L257 334c-9.2-40.1-9.1-61-39.5-61.5 0 0-21.5-2-88-2l0 139c0 26 14.3 38.3 44.3 38.3l89.3 0c63.6 0 66.6-25 98.7-99.8l22.2 0z"],
    "btc": [384, 512, [], "f15a", "M310.4 242.6c27.7-14.2 45.4-39.4 41.3-81.3-5.4-57.4-52.5-76.6-114.8-81.9l0-79.4-48.5 0 0 77.2c-12.6 0-25.5 .3-38.4 .6l0-77.8-48.5 0 0 79.4c-17.8 .5-38.6 .3-97.4 0l0 51.7c38.3-.7 58.4-3.1 63 21.4l0 217.4c-2.9 19.5-18.5 16.7-53.3 16.1L4 443.7c88.5 0 97.4 .3 97.4 .3l0 68 48.5 0 0-67.1c13.2 .3 26.2 .3 38.4 .3l0 66.7 48.5 0 0-68c81.3-4.4 135.6-24.9 142.9-101.5 5.7-61.4-23.3-88.9-69.3-99.9zM150.8 134.6c27.4 0 113.1-8.5 113.1 48.5 0 54.5-85.7 48.2-113.1 48.2l0-96.7zm0 251.8l0-106.5c32.8 0 133.1-9.1 133.1 53.3 0 60.2-100.4 53.3-133.1 53.3z"],
    "adn": [512, 512, [], "f170", "M256 167.5l64.9 98.8-129.8 0 64.9-98.8zM8 256a248 248 0 1 1 496 0 248 248 0 1 1 -496 0zm396.2 82.7l-148.2-223.2-148.2 223.2 30.4 0 33.6-51.7 168.6 0 33.6 51.7 30.2 0z"],
    "square-x-twitter": [448, 512, [], "e61a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm297.1 84l-103.8 118.6 122.1 161.4-95.6 0-74.8-97.9-85.7 97.9-47.5 0 111-126.9-117.1-153.1 98 0 67.7 89.5 78.2-89.5 47.5 0zM323.3 367.6l-169.9-224.7-28.3 0 171.8 224.7 26.4 0z"],
    "square-font-awesome": [448, 512, [], "e5ad", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm90 122c0 9.3-4.8 17.4-12.1 22l188.9 0c7.3 0 13.2 5.9 13.2 13.2 0 1.8-.4 3.7-1.1 5.4L312 264 342.9 333.4c.7 1.7 1.1 3.5 1.1 5.4 0 7.3-5.9 13.2-13.2 13.2l-186.8 0 0 32-32 0 0-209.5c-6.1-4.8-10-12.2-10-20.5 0-14.4 11.6-26 26-26s26 11.6 26 26z"],
    "forumbee": [448, 512, [], "f211", "M5.8 309.7C2 292.7 0 275.5 0 258.3 0 135 99.8 35 223.1 35 239.7 35 256.4 37 272.4 40.5 149 87.5 51.9 186 5.8 309.7zM398.7 120.5c-13.7-17.5-29.7-32.7-47.8-45.3-149.6 44.3-266.3 162.1-309.7 312 12.5 18.1 28 35.6 45.2 49 43.1-151.3 161.2-271.7 312.3-315.7zm15.8 252.7c15.2-25.1 25.4-53.7 29.5-82.8-79.4 42.9-145 110.6-187.6 190.3 30-4.4 58.9-15.3 84.6-31.3 35 13.1 70.9 24.3 107 33.6-9.3-36.5-20.4-74.5-33.5-109.8zm29.7-145.5c-2.6-19.5-7.9-38.7-15.8-56.8-137.9 45.8-246.4 156.6-291.3 295.1 18.1 7.6 37 12.5 56.6 15.2 46.3-114.1 136.8-206.8 250.5-253.5z"],
    "42-group": [640, 512, ["innosoft"], "e080", "M320 96l0 320c21 0 41.8-4.1 61.2-12.2s37-19.8 51.9-34.7 26.6-32.5 34.7-51.9 12.2-40.2 12.2-61.2-4.1-41.8-12.2-61.2-19.8-37.1-34.7-51.9-32.5-26.6-51.9-34.7-40.2-12.2-61.2-12.2zM0 256L160 416 320 256 160 96 0 256zm480 0c0 21 4.1 41.8 12.2 61.2s19.8 37 34.7 51.9 32.5 26.6 51.9 34.7 40.2 12.2 61.2 12.2l0-320c-42.4 0-83.1 16.9-113.1 46.9S480 213.6 480 256z"],
    "stumbleupon-circle": [512, 512, [], "f1a3", "M264 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zm0 177.5c-9.8 0-17.8 8-17.8 17.8l0 106.9c0 40.9-33.9 73.9-74.9 73.9-41.4 0-74.9-33.5-74.9-74.9l0-46.5 57.3 0 0 45.8c0 10 8 17.8 17.8 17.8s17.8-7.9 17.8-17.8l0-108.4c0-40 34.2-72.1 74.7-72.1 40.7 0 74.7 32.3 74.7 72.6l0 23.7-34.1 10.1-22.9-10.7 0-20.6c.1-9.6-7.9-17.6-17.7-17.6zM431.6 309.1c0 41.4-33.5 74.9-74.9 74.9-41.2 0-74.9-33.2-74.9-74.2l0-46.8 22.9 10.7 34.1-10.1 0 47.1c0 9.8 8 17.6 17.8 17.6s17.8-7.9 17.8-17.6l0-48 57.3 0c-.1 45.9-.1 46.4-.1 46.4z"],
    "symfony": [512, 512, [], "f83d", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM389.7 151.5c-11.5 .4-19.4-6.4-19.8-16.9-.3-9.2 6.7-13.4 6.5-18.9-.2-6.5-10.2-6.8-12.9-6.7-39.8 1.3-48.6 57-58.9 113.8 21.4 3.2 36.6-.7 45.1-6.2 12-7.7-3.3-15.7-1.4-24.6 4-18.2 32.6-19 32 5.3-.4 17.9-25.9 41.8-77.6 35.7-10.8 59.5-18.4 115-58.2 161.7-29 34.5-58.4 39.8-71.6 40.3-24.6 .9-41-12.3-41.6-29.8-.6-17 14.4-26.3 24.3-26.6 21.9-.8 30.1 25.7 14.9 34-12.1 9.7 .1 12.6 2.1 12.6 10.4-.4 17.3-5.5 22.2-9 24-20 33.2-54.9 45.4-118.3 8.2-49.7 17-78 18.2-82-16.9-12.7-27.1-28.6-49.8-34.7-15.6-4.2-25.1-.6-31.8 7.8-7.9 10-5.3 23 2.4 30.7l12.6 14c15.5 17.9 24 31.9 20.8 50.6-5.1 29.9-40.7 52.9-82.9 39.9-36-11.1-42.7-36.6-38.4-50.6 7.5-24.2 42.4-11.7 34.6 13.6-2.8 8.6-4.9 8.7-6.3 13.1-4.6 14.8 41.8 28.4 51-1.4 4.5-14.5-5.3-21.7-22.2-39.9-28.5-31.7-16-65.5 2.9-79.7 52.8-39.4 100.5 17.5 110.6 25.8 37.2-109 100.5-105.5 102.4-105.5 25.2-.8 44.2 10.6 44.8 28.6 .2 7.7-4.2 22.6-19.5 23.1z"],
    "salesforce": [640, 512, [], "f83b", "M249.4 245.6l-26.4 0c.7-5.2 3.3-14.1 13.6-14.1 6.8 0 12 3.8 12.7 14.1zM386 231.8c-.5 0-14.1-1.8-14.1 20s13.6 20 14.1 20c13 0 14.1-13.5 14.1-20 0-21.8-13.7-20-14.1-20zM142.8 255.5c-1.1 .9-2 2-2.5 3.2s-.8 2.7-.7 4c0 4.8 2.1 6.1 3.3 7 4.7 3.7 15.1 2.1 20.9 1l0-16.9c-5.3-1.1-16.7-2-20.9 1.6zM640.5 232c0 87.6-80 154.4-165.4 136.4-18.4 33-70.7 70.8-132.2 41.6-41.2 96-177.9 92.2-213.8-5.2-119.7 23.9-178.8-138.4-75.3-199.3-34.8-79.4 22.6-173.6 114.3-173.6 19.1 0 37.9 4.4 55 12.9s32 20.7 43.6 35.8c20.7-21.4 49.4-34.8 81.1-34.8 42.3 0 79 23.5 98.8 58.6 92.8-40.7 193.8 28.2 193.8 127.5zM120.9 263.8c0-11.8-11.7-15.2-17.9-17.2-5.3-2.1-13.4-3.5-13.4-8.9 0-9.5 17-6.7 25.2-2.1 0 0 1.2 .7 1.6-.5 .2-.7 2.4-6.6 2.6-7.3 .1-.3 .1-.6-.1-.8s-.4-.5-.6-.6c-12.3-7.6-40.7-8.5-40.7 12.7 0 12.5 11.5 15.4 17.9 17.2 4.7 1.6 13.2 3 13.2 8.7 0 4-3.5 7.1-9.2 7.1-6.9 0-13.5-2.2-19-6.3-.5-.2-1.4-.7-1.6 .7l-2.4 7.5c-.5 .9 .2 1.2 .2 1.4 1.8 1.4 10.3 6.6 22.8 6.6 13.2 0 21.4-7.1 21.4-18.1l0 0zm32-42.6c-10.1 0-18.7 3.2-21.4 5.2-.1 .1-.2 .2-.3 .3s-.1 .2-.1 .4 0 .3 0 .4 .1 .3 .2 .4l2.6 7.1c.1 .2 .2 .5 .5 .6s.5 .2 .7 .1c.6 0 6.8-4 16.9-4 4 0 7.1 .7 9.2 2.4 3.6 2.8 3.1 8.3 3.1 10.6-4.8-.3-19.1-3.4-29.4 3.8-2.3 1.6-4.3 3.8-5.5 6.3s-1.9 5.4-1.8 8.2c0 5.9 1.5 10.4 6.6 14.4 12.2 8.2 36.3 2 38.1 1.4 1.6-.3 3.5-.7 3.5-1.9l0-33.9c0-4.6 .3-21.6-22.8-21.6l0 .1zm46.6-21c0-.2 0-.3-.1-.5s-.1-.3-.3-.4-.2-.2-.4-.3-.3-.1-.5-.1l-9.8 0c-.2 0-.3 0-.5 .1s-.3 .1-.4 .3-.2 .2-.3 .4-.1 .3-.1 .5l0 79c0 .2 0 .3 .1 .5s.1 .3 .3 .4 .2 .2 .4 .3 .3 .1 .5 .1l9.9 0c.2 0 .3 0 .5-.1s.3-.1 .4-.3 .2-.2 .3-.4 .1-.3 .1-.5l-.1-79zm55.7 28.9c-2.1-2.3-6.8-7.5-17.6-7.5-3.5 0-14.2 .2-20.7 8.9-6.4 7.6-6.6 18.1-6.6 21.4 0 3.1 .2 14.3 7.1 21.2 2.6 2.9 9.1 8.2 22.8 8.2 10.8 0 16.5-2.3 18.6-3.8 .5-.2 .7-.7 .2-1.9l-2.3-6.8c-.1-.3-.3-.5-.6-.6s-.5-.2-.8-.1c-2.6 .9-6.3 2.8-15.3 2.8-17.4 0-16.8-14.7-16.9-16.7l37.2 0c.3 0 .5-.1 .7-.3s.4-.4 .4-.7c-.3 0 2.1-14.7-6.1-24.2l0 0zm36.7 52.7c13.2 0 21.4-7.1 21.4-18.1 0-11.8-11.7-15.2-17.9-17.2-4.1-1.7-13.4-3.4-13.4-8.9 0-3.8 3.3-6.4 8.5-6.4 5.8 .1 11.5 1.6 16.7 4.2 0 0 1.2 .7 1.6-.5 .2-.7 2.4-6.6 2.6-7.3 .1-.3 .1-.6-.1-.8s-.4-.5-.6-.6c-7.9-4.9-16.7-4.9-20.2-4.9-12 0-20.5 7.3-20.5 17.6 0 12.5 11.5 15.4 17.9 17.2 6.1 2 13.2 3.3 13.2 8.7 0 4-3.5 7.1-9.2 7.1-6.9 0-13.5-2.2-19-6.4-.1-.1-.3-.2-.5-.2s-.4 0-.5 .1-.3 .2-.4 .3-.2 .3-.2 .5l-2.3 7.5c-.5 .9 .2 1.2 .2 1.4 1.7 1.4 10.3 6.6 22.8 6.6l0 0zM357.6 224c0-.7-.2-1.2-1.2-1.2l-11.8 0c0-.1 .9-8.9 4.5-12.5 4.2-4.2 11.8-1.6 12-1.6 1.2 .5 1.4 0 1.6-.5l2.8-7.8c.7-.9 0-1.2-.2-1.4-5.1-2-17.4-2.9-24.5 4.2-5.5 5.5-7 13.9-8 19.5l-8.5 0c-.3 0-.6 .2-.8 .4s-.3 .5-.4 .8l-1.4 7.8c0 .7 .2 1.2 1.2 1.2l8.2 0c-8.5 47.9-8.7 50.2-10.3 55.5-1.1 3.6-3.3 6.9-5.9 7.8-.1 0-3.9 1.7-9.6-.2 0 0-.9-.5-1.4 .7-.2 .7-2.6 6.8-2.8 7.5s0 1.4 .5 1.4c5.1 2 13 1.8 17.9 0 6.3-2.3 9.7-7.9 11.5-12.9 2.8-7.7 2.8-9.8 11.8-59.7l12.2 0c.3 0 .6-.2 .8-.4s.3-.5 .4-.8l1.4-7.8zM411 240c-.6-1.7-5.1-18.1-25.2-18.1-15.2 0-23 10-25.2 18.1-1 3-3.2 14 0 23.5 .1 .3 4.4 18.1 25.2 18.1 15 0 22.9-9.6 25.2-18.1 3.2-9.6 1-20.5 0-23.5zm45.4-16.7c-5-1.7-16.6-1.9-22.1 5.4l0-4.5c0-.2 0-.3-.1-.5s-.1-.3-.3-.4-.2-.2-.4-.3-.3-.1-.5-.1l-9.4 0c-.2 0-.3 0-.5 .1s-.3 .1-.4 .3-.2 .2-.3 .4-.1 .3-.1 .5l0 55.3c0 .2 0 .3 .1 .5s.1 .3 .3 .4 .2 .2 .4 .3 .3 .1 .5 .1l9.6 0c.2 0 .3 0 .5-.1s.3-.1 .4-.3 .2-.2 .3-.4 .1-.3 .1-.5l0-27.8c0-2.9 .1-11.4 4.5-15.1 4.9-4.9 12-3.4 13.4-3.1 .3 0 .6-.1 .8-.3s.4-.4 .6-.7c1.2-2.6 2.2-5.3 3.1-8 .1-.3 .1-.5 0-.8s-.3-.5-.5-.6l0 0zm46.8 54.1l-2.1-7.3c-.5-1.2-1.4-.7-1.4-.7-4.2 1.8-10.1 1.9-11.3 1.9-4.6 0-17.2-1.1-17.2-19.8 0-6.2 1.8-19.8 16.5-19.8 3.9-.1 7.8 .5 11.5 1.6 0 0 .9 .5 1.2-.7 .9-2.6 1.6-4.5 2.6-7.5 .2-.9-.5-1.2-.7-1.2-11.6-3.9-22.3-2.5-27.8 0-1.6 .7-16.2 6.5-16.2 27.5 0 2.9-.6 30.1 28.9 30.1 5.3 0 10.6-1 15.5-2.8 .2-.2 .4-.4 .5-.6s.1-.5 0-.8l0 0zm53.9-39.5c-.8-3-5.4-16.2-22.3-16.2-16 0-23.5 10.1-25.6 18.6-1.2 3.8-1.7 7.8-1.7 11.8 0 25.9 18.8 29.4 29.9 29.4 10.8 0 16.5-2.3 18.6-3.8 .5-.2 .7-.7 .2-1.9l-2.4-6.8c-.1-.3-.3-.5-.6-.6s-.6-.2-.8-.1c-2.6 .9-6.3 2.8-15.3 2.8-17.4 0-16.9-14.7-16.9-16.7l37.2 0c.3 0 .5-.1 .7-.3s.4-.4 .4-.7c-.2 0 .9-7.1-1.4-15.5l0 0zm-23.3-6.4c-10.3 0-13 9-13.6 14.1l26.4 0c-.9-11.9-7.6-14.1-12.7-14.1l0 0z"],
    "sourcetree": [448, 512, [], "f7d3", "M427.4 203c0-112.1-90.9-203-203-203-112.1-.2-203 90.6-203.2 202.6-.1 43 13.5 84.8 38.7 119.6s60.9 60.6 101.8 73.8l0 101.7c0 3.8 1.5 7.4 4.2 10.1s6.3 4.2 10.1 4.2l96.4 0c3.8 0 7.4-1.5 10.1-4.2s4.2-6.3 4.2-10.1l0-101.6c40.8-13.2 76.5-39 101.7-73.7s38.9-76.5 39-119.4zm-271.6 0c0-90.8 137.3-90.8 137.3 0-.1 89.9-137.3 91-137.3 0z"],
    "linkedin-in": [448, 512, [], "f0e1", "M100.3 448l-92.9 0 0-299.1 92.9 0 0 299.1zM53.8 108.1C24.1 108.1 0 83.5 0 53.8 0 39.5 5.7 25.9 15.8 15.8s23.8-15.8 38-15.8 27.9 5.7 38 15.8 15.8 23.8 15.8 38c0 29.7-24.1 54.3-53.8 54.3zM447.9 448l-92.7 0 0-145.6c0-34.7-.7-79.2-48.3-79.2-48.3 0-55.7 37.7-55.7 76.7l0 148.1-92.8 0 0-299.1 89.1 0 0 40.8 1.3 0c12.4-23.5 42.7-48.3 87.9-48.3 94 0 111.3 61.9 111.3 142.3l0 164.3-.1 0z"],
    "html5": [384, 512, [], "f13b", "M0 32L34.9 427.8 191.5 480 349.1 427.8 384 32 0 32zM308.2 159.9l-183.8 0 4.1 49.4 175.6 0-13.6 148.4-97.9 27 0 .3-1.1 0-98.7-27.3-6-75.8 47.7 0 3.5 38.1 53.5 14.5 53.7-14.5 6-62.2-166.9 0-12.8-145.6 241.1 0-4.4 47.7z"],
    "rust": [512, 512, [], "e07a", "M508.5 249.8l-21.8-13.5c-.2-2-.3-3.9-.5-5.9l18.7-17.5c.9-.9 1.6-1.9 2-3.1s.5-2.5 .2-3.7-.8-2.4-1.6-3.3-1.8-1.7-3-2.1l-24-9c-.5-1.9-1.1-3.8-1.7-5.6l15-20.8c.7-1 1.2-2.2 1.3-3.4s0-2.5-.5-3.7-1.2-2.2-2.2-2.9-2.1-1.3-3.4-1.5l-25.4-4.2c-.9-1.7-1.8-3.4-2.7-5.2l10.7-23.4c.5-1.1 .7-2.4 .6-3.6s-.5-2.4-1.2-3.5-1.6-1.9-2.8-2.5-2.4-.8-3.6-.8l-25.8 .9c-1.2-1.5-2.4-2.9-3.6-4.4L439 81.8c.3-1.2 .3-2.5-.1-3.7s-1-2.3-1.9-3.2-2-1.5-3.2-1.9-2.5-.4-3.7-.1L405 78.9c-1.4-1.2-2.9-2.4-4.4-3.6l.9-25.8c.1-1.3-.2-2.5-.8-3.6s-1.4-2.1-2.5-2.8-2.2-1.1-3.5-1.2-2.5 .1-3.7 .6L367.7 53.2c-1.7-.9-3.4-1.8-5.1-2.7l-4.2-25.4c-.2-1.2-.7-2.4-1.5-3.4s-1.8-1.7-2.9-2.2-2.4-.7-3.7-.5-2.4 .6-3.4 1.3L326 35.3c-1.9-.6-3.8-1.1-5.6-1.7l-9-24c-.4-1.2-1.2-2.2-2.1-3s-2.1-1.4-3.3-1.6-2.5-.2-3.7 .2-2.3 1.1-3.1 2L281.6 25.9c-2-.2-3.9-.4-5.9-.5L262.3 3.5c-.7-1.1-1.6-1.9-2.7-2.6s-2.3-.9-3.6-.9-2.5 .3-3.6 .9-2 1.5-2.7 2.6L236.2 25.3c-2 .2-3.9 .3-5.9 .6L212.9 7.1c-.9-.9-1.9-1.6-3.1-2s-2.5-.5-3.7-.2-2.4 .8-3.3 1.6-1.7 1.8-2.1 3l-9 24c-1.9 .6-3.8 1.1-5.7 1.7l-20.8-15c-1-.7-2.2-1.2-3.4-1.3s-2.5 0-3.7 .5-2.2 1.2-2.9 2.2-1.3 2.1-1.5 3.4l-4.2 25.4c-1.7 .9-3.4 1.8-5.2 2.7L120.9 42.6c-1.1-.5-2.4-.7-3.7-.6s-2.5 .5-3.5 1.2-1.9 1.7-2.5 2.8-.8 2.4-.8 3.6l.9 25.8c-1.5 1.2-3 2.4-4.4 3.6L81.8 73c-1.2-.3-2.5-.3-3.7 .1s-2.3 1-3.2 1.9-1.5 2-1.9 3.2-.4 2.5-.1 3.7L78.9 107c-1.2 1.4-2.4 2.9-3.6 4.4l-25.8-.9c-1.3 0-2.5 .2-3.6 .8s-2.1 1.4-2.8 2.4-1.1 2.2-1.2 3.5 .1 2.5 .6 3.6l10.7 23.4c-.9 1.7-1.8 3.4-2.7 5.2l-25.4 4.1c-1.2 .2-2.4 .7-3.4 1.5s-1.7 1.8-2.2 2.9-.7 2.4-.5 3.7 .6 2.4 1.3 3.4l15 20.8c-.6 1.9-1.1 3.8-1.7 5.7l-24 9c-1.2 .4-2.2 1.2-3 2.1s-1.4 2.1-1.6 3.3-.2 2.5 .2 3.7 1.1 2.3 2 3.1l18.7 17.5c-.2 2-.4 3.9-.6 5.9L3.5 249.8c-1.1 .7-1.9 1.6-2.6 2.7s-.9 2.3-.9 3.6 .3 2.5 .9 3.6 1.5 2 2.6 2.7l21.8 13.5c.2 2 .3 3.9 .6 5.9L7.1 299.1c-.9 .9-1.6 1.9-2 3.1s-.5 2.5-.2 3.7 .8 2.4 1.6 3.3 1.8 1.7 3 2.1l24 9c.6 1.9 1.1 3.8 1.7 5.6l-15 20.8c-.7 1-1.2 2.2-1.3 3.4s0 2.5 .5 3.7 1.2 2.2 2.2 2.9 2.1 1.3 3.4 1.5l25.4 4.2c.9 1.7 1.8 3.4 2.7 5.1L42.6 391.1c-.5 1.1-.7 2.4-.6 3.6s.5 2.5 1.2 3.5c.7 1.1 1.6 1.9 2.7 2.5s2.4 .8 3.6 .8l25.8-.9c1.2 1.5 2.4 2.9 3.6 4.4L73 430.2c-.3 1.2-.3 2.5 .1 3.7s1 2.3 1.9 3.2 2 1.5 3.2 1.9 2.5 .4 3.7 .1l25.2-5.9c1.5 1.2 2.9 2.4 4.4 3.6l-.9 25.8c0 1.3 .2 2.5 .8 3.6s1.4 2.1 2.5 2.8 2.2 1.1 3.5 1.2 2.5-.1 3.6-.6l23.4-10.7c1.7 .9 3.4 1.8 5.1 2.7l4.2 25.4c.2 1.2 .7 2.4 1.5 3.4s1.8 1.8 2.9 2.2 2.4 .7 3.7 .5 2.4-.6 3.4-1.3l20.8-15c1.9 .6 3.8 1.1 5.6 1.7l9 24c.4 1.2 1.2 2.2 2.1 3s2.1 1.4 3.3 1.6 2.5 .2 3.7-.2 2.3-1.1 3.1-2l17.5-18.7c2 .2 3.9 .4 5.9 .6l13.5 21.8c.7 1.1 1.6 1.9 2.7 2.6s2.3 .9 3.6 .9 2.5-.3 3.6-.9 2-1.5 2.7-2.6l13.5-21.8c2-.2 3.9-.3 5.9-.6l17.5 18.7c.9 .9 1.9 1.6 3.1 2s2.5 .5 3.7 .2 2.4-.8 3.3-1.6 1.7-1.8 2.1-3l9-24c1.9-.6 3.8-1.1 5.6-1.7l20.8 15c1 .7 2.2 1.2 3.4 1.3s2.5 0 3.7-.5 2.2-1.2 2.9-2.2 1.3-2.1 1.5-3.4l4.2-25.4c1.7-.9 3.4-1.8 5.1-2.7l23.4 10.7c1.1 .5 2.4 .7 3.6 .6s2.4-.5 3.5-1.2 1.9-1.6 2.5-2.8 .8-2.4 .8-3.6l-.9-25.8c1.5-1.2 2.9-2.4 4.4-3.6l25.2 5.9c1.2 .3 2.5 .3 3.7-.1s2.3-1 3.2-1.9 1.5-2 1.9-3.2 .4-2.5 .1-3.7L433.1 405c1.2-1.4 2.4-2.9 3.6-4.4l25.8 .9c1.3 .1 2.5-.2 3.6-.8s2.1-1.4 2.8-2.5c.7-1 1.1-2.2 1.2-3.5s-.1-2.5-.6-3.6l-10.7-23.4c.9-1.7 1.8-3.4 2.7-5.1l25.4-4.2c1.2-.2 2.4-.7 3.4-1.5s1.8-1.8 2.2-2.9 .7-2.4 .5-3.7-.6-2.4-1.3-3.4l-15-20.8c.6-1.9 1.1-3.8 1.7-5.6l24-9c1.2-.4 2.2-1.2 3-2.1s1.4-2.1 1.6-3.3 .2-2.5-.2-3.7-1.1-2.3-2-3.1l-18.7-17.5c.2-1.9 .4-3.9 .6-5.9l21.8-13.5c1.1-.7 1.9-1.6 2.6-2.7s.9-2.3 .9-3.6-.3-2.5-.9-3.6-1.5-2-2.6-2.7l0 0zm-151 129.1c-3.6-.8-7.4-.1-10.5 1.9s-5.3 5.2-6 8.8l-7.6 35.7c-24.6 11.1-51.3 16.8-78.3 16.7s-53.6-6.1-78.1-17.4l-7.6-35.7c-.4-1.8-1.1-3.5-2.1-5s-2.4-2.8-3.9-3.8-3.2-1.7-5-2-3.6-.3-5.4 .1l-31.5 6.8c-5.8-6-11.3-12.5-16.3-19.2l153.2 0c1.7 0 2.9-.3 2.9-1.9l0-54.2c0-1.6-1.2-1.9-2.9-1.9l-44.8 0 0-34.4 48.5 0c4.4 0 23.7 1.3 29.8 25.9 1.9 7.5 6.2 32.1 9.1 40 2.9 8.8 14.6 26.5 27.1 26.5l79 0c-5.3 7.1-11.1 13.8-17.3 20.1l-32.1-6.9zm25.8 34.5c0 3-.9 6-2.6 8.5s-4 4.5-6.8 5.6-5.8 1.5-8.8 .9-5.7-2-7.8-4.2-3.6-4.8-4.2-7.8-.3-6 .8-8.8 3.1-5.2 5.6-6.9 5.4-2.6 8.5-2.6l.4 0c4 .1 7.7 1.8 10.5 4.6s4.3 6.7 4.3 10.6l.1 0zm-225.6-.7c0 3-.9 6-2.6 8.5s-4.1 4.5-6.8 5.6-5.8 1.5-8.8 .9-5.7-2-7.8-4.2-3.6-4.8-4.2-7.8-.3-6 .9-8.8 3.1-5.2 5.6-6.8 5.4-2.6 8.5-2.6l.5 0c4 .1 7.7 1.8 10.5 4.6s4.3 6.7 4.3 10.6l.1 0zM69.6 234.2l32.8-14.6c1.7-.7 3.2-1.8 4.4-3.1s2.2-2.9 2.9-4.6 1-3.5 .9-5.3-.5-3.6-1.2-5.3l-6.8-15.2 26.6 0 0 119.7-53.6 0c-6.6-23.2-8.7-47.6-6.1-71.6zM58.3 198.1c0-2 .4-4 1.2-5.8s1.9-3.5 3.3-4.9 3.1-2.5 4.9-3.3 3.8-1.2 5.8-1.2l.5 0c3 .1 5.9 1 8.3 2.8s4.3 4.1 5.4 6.9 1.3 5.8 .7 8.8-2.1 5.6-4.3 7.7-4.9 3.5-7.8 4.1-6 .2-8.7-.9-5.1-3.1-6.8-5.6-2.5-5.4-2.5-8.4l0 0zm155.2 24.5l0-35.3 63.3 0c3.3 0 23.1 3.8 23.1 18.6 0 12.3-15.2 16.7-27.7 16.7l-58.7 0zM399 306.7c-9.8 1.1-20.6-4.1-22-10.1-5.8-32.5-15.4-39.4-30.6-51.4 18.9-12 38.5-29.6 38.5-53.3 0-25.5-17.5-41.6-29.4-49.5-16.8-11-35.3-13.2-40.3-13.2l-198.9 0c27.5-30.7 64.4-51.5 104.9-59.2l23.5 24.6c1.3 1.3 2.8 2.4 4.4 3.1s3.5 1.1 5.3 1.2 3.6-.3 5.3-.9 3.2-1.7 4.6-2.9l26.3-25c26.8 5 52.1 15.8 74.3 31.6s40.6 36.2 54.1 59.9l-18 40.6c-1.5 3.4-1.5 7.2-.2 10.6s3.9 6.2 7.3 7.7l34.6 15.3c1.1 10.8 1.2 21.7 .4 32.5l-19.3 0c-1.9 0-2.7 1.3-2.7 3.1l0 8.8c0 20.8-11.7 25.3-22 26.5zM240 60.2c0-4 1.6-7.9 4.5-10.7s6.7-4.5 10.7-4.5l.4 0c3 .1 5.9 1 8.4 2.8s4.3 4.1 5.4 6.9 1.3 5.8 .7 8.8-2.1 5.6-4.3 7.7-4.9 3.5-7.8 4-6 .2-8.7-.9-5.1-3.1-6.8-5.6-2.5-5.4-2.5-8.4zM436.8 214c-2 0-4-.4-5.8-1.2s-3.5-1.9-4.9-3.3-2.5-3.1-3.3-4.9-1.2-3.8-1.2-5.8 .4-4 1.2-5.8 1.9-3.5 3.3-4.9 3.1-2.5 4.9-3.3 3.8-1.2 5.8-1.2l.4 0c4 .1 7.9 1.7 10.7 4.6s4.4 6.8 4.3 10.8-1.7 7.9-4.6 10.7-6.8 4.4-10.8 4.3z"],
    "hornbill": [512, 512, [], "f592", "M76.8 370.3c1 7.8-.4 15.8-4.1 22.8s-9.6 12.6-16.7 16.1-15.1 4.7-22.9 3.3-15-5.1-20.6-10.7-9.2-12.9-10.5-20.7 0-15.8 3.6-22.9 9.3-12.8 16.3-16.5 15-5 22.9-3.9c-78.3-111.3 52-190.5 52-190.5-5.9 43-8.2 91.2-8.2 91.2-67.3 41.5 .9 64.1 39.8 72.9 9.9 27 27.8 50.2 51.4 66.7s51.6 25.3 80.3 25.3c1.9 0 3.8-.2 5.7-.3l.1 18.9c-99.2 1.4-158.7-29.1-188.9-51.6zm108-327.7c.9-7.2-.2-14.6-3.4-21.2-3-6.2-7.6-11.5-13.4-15.3s-12.5-5.9-19.4-6.2-13.8 1.4-19.8 4.7-11.1 8.3-14.5 14.3-5.2 12.8-5 19.7 2.2 13.7 5.9 19.5 8.9 10.6 15.1 13.6 13.1 4.4 20 3.9c-22.6 29.9-53.8 89.6-52.4 190l21.8-.2c0-.9-.1-1.8-.1-2.7 0-28 8.4-55.3 24.1-78.5s37.9-41.2 63.8-51.6c8-37.7 30.7-114.3 73.8-44.3 0 0 48.1 2.4 91.2 8.2 0 0-77.8-128-187.6-54.1l0 0zM489 176.8c6.3-3 11.7-7.7 15.5-13.6s5.9-12.7 6.1-19.8-1.6-14-5.2-20-8.7-11-14.9-14.3-13.2-4.8-20.2-4.4-13.8 2.8-19.5 6.9-10.2 9.6-13 16.1-3.7 13.6-2.7 20.5c-31.7-21.9-89.8-49.1-183.4-47.7l.1 22.5c2.7-.2 5.4-.4 8.1-.4 28.1 0 55.6 8.5 78.9 24.3s41.2 38.3 51.6 64.5c39.1 9 105.1 31.6 38.5 72.5 0 0-2.3 48.1-8.2 91.2 0 0 133.4-81.2 49-194.6 6.6 .6 13.3-.6 19.3-3.5l0 0zM374.4 436.2c21.4-32.5 46.4-89.7 45.1-179.7l-19.5 .1c.1 2.1 .3 4.1 .3 6.2 0 28.6-8.8 56.5-25.1 80s-39.5 41.4-66.3 51.4c-8.9 39-31.4 106.7-72.8 39.5 0 0-48.1-2.3-91.2-8.2 0 0 79.9 131.3 191.9 51 .3 4.9 1.5 9.6 3.6 14 2.9 6.1 7.5 11.4 13.1 15.1s12.2 6 19 6.4 13.6-1.1 19.6-4.2 11.1-7.8 14.7-13.6 5.6-12.4 5.7-19.2-1.5-13.5-4.8-19.4-8.2-10.9-14.1-14.3-12.6-5.2-19.4-5.1l0-.1z"],
    "php": [640, 512, [], "f457", "M320 104.5c171.4 0 303.2 72.2 303.2 151.5S491.3 407.5 320 407.5C148.6 407.5 16.8 335.3 16.8 256S148.7 104.5 320 104.5zm0-16.8C143.3 87.7 0 163 0 256S143.3 424.3 320 424.3 640 349 640 256 496.7 87.7 320 87.7zM218.2 242.5c-7.9 40.5-35.8 36.3-70.1 36.3l13.7-70.6c38 0 63.8-4.1 56.4 34.3zM97.4 350.3l36.7 0 8.7-44.8c41.1 0 66.6 3 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7l-70.7 0-32.7 168.7zM283.1 136.7l36.5 0-8.7 44.8c31.5 0 60.7-2.3 74.8 10.7 14.8 13.6 7.7 31-8.3 113.1l-37 0c15.4-79.4 18.3-86 12.7-92-5.4-5.8-17.7-4.6-47.4-4.6l-18.8 96.6-36.5 0 32.7-168.6zM505 242.5c-8 41.1-36.7 36.3-70.1 36.3l13.7-70.6c38.2 0 63.8-4.1 56.4 34.3zM384.2 350.3l36.8 0 8.7-44.8c43.2 0 67.1 2.5 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7l-70.7 0-32.8 168.7z"],
    "disqus": [576, 512, [], "e7d5", "M290.2 512c-62.6 0-119.9-22.9-164.2-60.8L17 466.1 59.1 362.2c-14.7-32.4-22.9-68.3-22.9-106.2 0-141.4 113.7-256 254-256 140.3 0 254 114.6 254 256 0 141.4-113.7 256-254 256zM428.9 255.3l0-.7C428.9 180.7 376.8 128 287 128l-97 0 0 256 95.6 0c90.5 0 143.4-54.9 143.4-128.7zM288 321.1l-28.4 0 0-130.2 28.4 0c41.7 0 69.3 23.8 69.3 64.7l0 .7c0 41.3-27.7 64.7-69.3 64.7z"],
    "500px": [384, 512, [], "f26e", "M71.8 344.3c-6.5-14.2-6.9-18.3 7.4-23.1 25.6-8 8 9.2 43.2 49.2l.3 0 0-93.9c1.2-50.2 44-92.2 97.7-92.2 53.9 0 97.7 43.5 97.7 96.8 0 63.4-60.8 113.2-128.5 93.3-10.5-4.2-2.1-31.7 8.5-28.6 53 0 89.4-10.1 89.4-64.4 0-61-77.1-89.6-116.9-44.6-23.5 26.4-17.6 42.1-17.6 157.6 50.7 31 118.3 22 160.4-20.1 24.8-24.8 38.5-58 38.5-93 0-35.2-13.8-68.2-38.8-93.3-24.8-24.8-57.8-38.5-93.3-38.5S151 163.3 126.3 188c-.3 .3-16 16.5-21.2 23.9l-.5 .6c-3.3 4.7-6.3 9.1-20.1 6.1-6.9-1.7-14.3-5.8-14.3-11.8L70.2 20c0-5 3.9-10.5 10.5-10.5L322 9.5c8.3 0 8.3 11.6 8.3 15.1 0 3.9 0 15.1-8.3 15.1l-223.2 0 0 132.9 .3 0c104.2-109.8 282.8-36 282.8 108.9 0 178.1-244.8 220.3-310.1 62.8zM135.1 83.5c-.5 4.2 4.6 24.5 14.6 20.6 124.8-47.5 202.8 40.4 209.4 40.4 4.8 0 22.8-15.3 14.3-22.8-93.2-89-234.5-57-238.3-38.2zM361.5 414.7c-110 109.9-299 60.8-332-104.2 0-12.2-30.4-7.4-28.9 3.3 24 173.4 246 256.9 381.6 121.3 6.9-7.8-12.6-28.4-20.7-20.4zM182.1 306.6c0 4 4.3 7.3 5.5 8.5 3 3 6.1 4.4 8.5 4.4 3.8 0 2.6 .2 22.3-19.5 19.6 19.3 19.1 19.5 22.3 19.5 5.4 0 18.5-10.4 10.7-18.2l-17.3-17.3 18.2-18.2c6.3-6.8-10.1-21.8-16.2-15.7L218.2 268c-18.6-18.8-18.4-19.5-21.5-19.5-5 0-18 11.7-12.4 17.3L202.5 284c-18.1 17.9-20.4 19.2-20.4 22.6z"],
    "affiliatetheme": [512, 512, [], "f36b", "M159.7 237.4C108.4 308.3 43.1 348.2 14 326.6-15.2 304.9 2.8 230 54.2 159.1 105.5 88.2 170.8 48.3 199.9 69.9s11.1 96.6-40.2 167.5zm351.2-57.3c-73.8 123.4-191.9 187.7-264.5 143.6-25-15.2-41.3-41.2-49-73.8-33.6 64.8-92.8 113.8-164.1 133.2 49.8 59.3 124.1 96.9 207 96.9 150 0 271.6-123.1 271.6-274.9 .1-8.5-.3-16.8-1-25z"],
    "red-river": [448, 512, [], "f3e3", "M353.2 32L94.8 32C42.4 32 0 74.4 0 126.8L0 385.2C0 437.6 42.4 480 94.8 480l258.4 0c52.4 0 94.8-42.4 94.8-94.8l0-258.4C448 74.4 405.6 32 353.2 32zM144.9 200.9l0 56.3c0 27-21.9 48.9-48.9 48.9l0-154.2c0-13.2 10.7-23.9 23.9-23.9l154.2 0c0 27-21.9 48.9-48.9 48.9l-56.3 0c-12.3-.6-24.6 11.6-24 24zm176.3 72l-56.3 0c-12.3-.6-24.6 11.6-24 24l0 56.3c0 27-21.9 48.9-48.9 48.9l0-154.2c0-13.2 10.7-23.9 23.9-23.9l154.2 0c0 27-21.9 48.9-48.9 48.9z"],
    "twitter": [512, 512, [], "f099", "M459.4 151.7c.3 4.5 .3 9.1 .3 13.6 0 138.7-105.6 298.6-298.6 298.6-59.5 0-114.7-17.2-161.1-47.1 8.4 1 16.6 1.3 25.3 1.3 49.1 0 94.2-16.6 130.3-44.8-46.1-1-84.8-31.2-98.1-72.8 6.5 1 13 1.6 19.8 1.6 9.4 0 18.8-1.3 27.6-3.6-48.1-9.7-84.1-52-84.1-103l0-1.3c14 7.8 30.2 12.7 47.4 13.3-28.3-18.8-46.8-51-46.8-87.4 0-19.5 5.2-37.4 14.3-53 51.7 63.7 129.3 105.3 216.4 109.8-1.6-7.8-2.6-15.9-2.6-24 0-57.8 46.8-104.9 104.9-104.9 30.2 0 57.5 12.7 76.7 33.1 23.7-4.5 46.5-13.3 66.6-25.3-7.8 24.4-24.4 44.8-46.1 57.8 21.1-2.3 41.6-8.1 60.4-16.2-14.3 20.8-32.2 39.3-52.6 54.3z"],
    "fort-awesome": [512, 512, [], "f286", "M489.5 287.9l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-178.3c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.6 0 0-32c0-6-8-4.6-11.7-4.6l0-38c8.3-2 17.1-3.4 25.7-3.4 10.9 0 20.9 4.3 31.4 4.3 4.6 0 27.7-1.1 27.7-8l0-60c0-2.6-2-4.6-4.6-4.6-5.1 0-15.1 4.3-24 4.3-9.7 0-20.9-4.3-32.6-4.3-8 0-16 1.1-23.7 2.9l0-4.9c5.4-2.6 9.1-8.3 9.1-14.3 0-20.7-31.4-20.8-31.4 0 0 6 3.7 11.7 9.1 14.3l0 111.7c-3.7 0-11.7-1.4-11.7 4.6l0 32-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 32-36.3 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 178.3-36.6 0 0-32c0-2.6-2-4.6-4.6-4.6l-27.4 0c-2.6 0-4.6 2-4.6 4.6l0 219.5 182.9 0 0-96c0-72.6 109.7-72.6 109.7 0l0 96 182.9 0 0-219.5c.1-2.6-1.9-4.6-4.5-4.6zm-288.1-4.5c0 2.6-2 4.6-4.6 4.6l-27.4 0c-2.6 0-4.6-2-4.6-4.6l0-64c0-2.6 2-4.6 4.6-4.6l27.4 0c2.6 0 4.6 2 4.6 4.6l0 64zm146.4 0c0 2.6-2 4.6-4.6 4.6l-27.4 0c-2.6 0-4.6-2-4.6-4.6l0-64c0-2.6 2-4.6 4.6-4.6l27.4 0c2.6 0 4.6 2 4.6 4.6l0 64z"],
    "mixer": [448, 512, [], "e056", "M82.6 76.1c-3.8-5.1-8.7-9.4-14.2-12.5s-11.7-5.1-18.1-5.7-12.8 .1-18.8 2.2-11.6 5.3-16.3 9.6c-17.6 16.2-19 43.5-4.8 62.8l91.8 123-92.3 124.1c-14.2 19.3-13.1 46.6 4.7 62.8 4.7 4.3 10.3 7.6 16.3 9.6s12.5 2.8 18.8 2.2 12.5-2.5 18.1-5.7 10.4-7.4 14.2-12.5L210.9 262.7c1.5-2.1 2.3-4.6 2.3-7.1s-.8-5-2.3-7.1L82.6 76.1zM438.2 379.6l-92.3-124.1 91.8-123c14.2-19.2 12.8-46.6-4.7-62.8-4.7-4.3-10.3-7.6-16.3-9.6s-12.5-2.8-18.8-2.2-12.5 2.5-18.1 5.7-10.4 7.4-14.2 12.5l-128 172.1c-1.5 2.1-2.3 4.6-2.3 7.1s.8 5 2.3 7.1L366 435.9c3.8 5.1 8.7 9.4 14.2 12.5s11.7 5.1 18.1 5.7 12.8-.1 18.8-2.2 11.6-5.3 16.3-9.6c17.8-16.2 19-43.5 4.7-62.8z"],
    "lyft": [512, 512, [], "f3c3", "M0 81.1l77.8 0 0 208.7c0 33.1 15 52.8 27.2 61-12.7 11.1-51.2 20.9-80.2-2.8-17-14-24.8-37.3-24.8-59L0 81.1zM485.9 254.6l0-22 23.8 0 0-76.8-26.1 0c-10.1-46.3-51.2-80.7-100.3-80.7-56.6 0-102.7 46-102.7 102.7l0 179.2c16 2.3 35.4-.3 51.7-14 17.1-14 24.8-37.2 24.8-59l0-6.7 38.8 0 0-76.8-38.8 0 0-23.3c0-34.6 52.2-34.6 52.2 0l0 77.1c0 56.6 46 102.7 102.7 102.7l0-76.5c-14.5 0-26.1-11.7-26.1-25.9zm-294.3-99l0 113c0 15.4-23.8 15.4-23.8 0l0-113-76.8 0 0 132.7c0 23.8 8 54 45 63.9 37 9.8 58.2-10.6 58.2-10.6-2.1 13.4-14.5 23.3-34.9 25.3-15.5 1.6-35.2-3.6-45-7.8l0 70.3c25.1 7.5 51.5 9.8 77.6 4.7 47.1-9.1 76.8-48.4 76.8-100.8l0-178.2-77.1 0 0 .5z"],
    "apple-pay": [640, 512, [], "f415", "M116.9 158.5c-7.5 8.9-19.5 15.9-31.5 14.9-1.5-12 4.4-24.8 11.3-32.6 7.5-9.1 20.6-15.6 31.3-16.1 1.2 12.4-3.7 24.7-11.1 33.8zm10.9 17.2c-17.4-1-32.3 9.9-40.5 9.9-8.4 0-21-9.4-34.8-9.1-17.9 .3-34.5 10.4-43.6 26.5-18.8 32.3-4.9 80 13.3 106.3 8.9 13 19.5 27.3 33.5 26.8 13.3-.5 18.5-8.6 34.5-8.6 16.1 0 20.8 8.6 34.8 8.4 14.5-.3 23.6-13 32.5-26 10.1-14.8 14.3-29.1 14.5-29.9-.3-.3-28-10.9-28.3-42.9-.3-26.8 21.9-39.5 22.9-40.3-12.5-18.6-32-20.6-38.8-21.1zm100.4-36.2l0 194.9 30.3 0 0-66.6 41.9 0c38.3 0 65.1-26.3 65.1-64.3s-26.4-64-64.1-64l-73.2 0zM258.5 165l34.9 0c26.3 0 41.3 14 41.3 38.6s-15 38.8-41.4 38.8l-34.8 0 0-77.4zM420.7 335.9c19 0 36.6-9.6 44.6-24.9l.6 0 0 23.4 28 0 0-97c0-28.1-22.5-46.3-57.1-46.3-32.1 0-55.9 18.4-56.8 43.6l27.3 0c2.3-12 13.4-19.9 28.6-19.9 18.5 0 28.9 8.6 28.9 24.5l0 10.8-37.8 2.3c-35.1 2.1-54.1 16.5-54.1 41.5 .1 25.2 19.7 42 47.8 42zm8.2-23.1c-16.1 0-26.4-7.8-26.4-19.6 0-12.3 9.9-19.4 28.8-20.5l33.6-2.1 0 11c0 18.2-15.5 31.2-36 31.2zm102.5 74.6c29.5 0 43.4-11.3 55.5-45.4l53.1-149-30.8 0-35.6 115.1-.6 0-35.6-115.1-31.6 0 51.2 141.9-2.8 8.6c-4.6 14.6-12.1 20.3-25.5 20.3-2.4 0-7-.3-8.9-.5l0 23.4c1.8 .4 9.3 .7 11.6 .7z"],
    "artstation": [512, 512, [], "f77a", "M2.1 377.4l43 74.3c4.3 8.5 10.8 15.7 18.9 20.7s17.4 7.6 27 7.6l285.4 0-59.2-102.6-315.1 0zM501.9 350L335.7 59.3c-4.4-8.2-10.9-15.1-18.9-20S299.7 32 290.4 32l-88.4 0 257.3 447.6 40.7-70.5c1.9-3.2 21-29.7 2-59.1zM275.2 304.5l-115.5-200-115.5 200 231 0z"],
    "node-js": [448, 512, [], "f3d3", "M224.5 508c-6.7 0-13.5-1.8-19.4-5.2l-61.7-36.5c-9.2-5.2-4.7-7-1.7-8 12.3-4.3 14.8-5.2 27.9-12.7 1.4-.8 3.2-.5 4.6 .4l47.4 28.1c1.7 1 4.1 1 5.7 0L412 367.5c1.7-1 2.8-3 2.8-5l0-213.2c0-2.1-1.1-4-2.9-5.1L227.3 37.7c-1.7-1-4-1-5.7 0L37.1 144.3c-1.8 1-2.9 3-2.9 5.1l0 213.1c0 2 1.1 4 2.9 4.9l50.6 29.2c27.5 13.7 44.3-2.4 44.3-18.7l0-210.4c0-3 2.4-5.3 5.4-5.3l23.4 0c2.9 0 5.4 2.3 5.4 5.3l0 210.5c0 36.6-20 57.6-54.7 57.6-10.7 0-19.1 0-42.5-11.6L20.6 396.1c-12-6.9-19.4-19.8-19.4-33.7l0-213.1c0-13.8 7.4-26.8 19.4-33.7L205.1 9c11.7-6.6 27.2-6.6 38.8 0L428.6 115.7c12 6.9 19.4 19.8 19.4 33.7l0 213.1c0 13.8-7.4 26.7-19.4 33.7L243.9 502.8c-5.9 3.4-12.6 5.2-19.4 5.2zM373.6 297.9c0-39.9-27-50.5-83.7-58-57.4-7.6-63.2-11.5-63.2-24.9 0-11.1 4.9-25.9 47.4-25.9 37.9 0 51.9 8.2 57.7 33.8 .5 2.4 2.7 4.2 5.2 4.2l24 0c1.5 0 2.9-.6 3.9-1.7s1.5-2.6 1.4-4.1c-3.7-44.1-33-64.6-92.2-64.6-52.7 0-84.1 22.2-84.1 59.5 0 40.4 31.3 51.6 81.8 56.6 60.5 5.9 65.2 14.8 65.2 26.7 0 20.6-16.6 29.4-55.5 29.4-48.9 0-59.6-12.3-63.2-36.6-.4-2.6-2.6-4.5-5.3-4.5l-23.9 0c-3 0-5.3 2.4-5.3 5.3 0 31.1 16.9 68.2 97.8 68.2 58.4-.1 92-23.2 92-63.4z"],
    "uncharted": [448, 512, [], "e084", "M171.8 232.8c1.1 0 2.1-.3 3-.9s1.6-1.4 2-2.4c2.2-9.8 7.4-18.6 14.9-25.3 1.2-.8 1.7-2.5 1.7-4.1-.1-.7-.3-1.3-.6-1.9s-.9-1.1-1.4-1.4L74.5 128.5 149.1 85c1.5-.8 2.7-2 3.6-3.5s1.4-3.1 1.4-4.8c0-1.7-.4-3.4-1.3-4.9s-2.2-2.7-3.7-3.4L126.7 55.6c-1.5-.8-3.1-1.2-4.8-1.2s-3.3 .4-4.8 1.2L17 113.6c-1.5 .8-2.7 2-3.6 3.5s-1.4 3.1-1.4 4.8L12 237c0 1.7 .4 3.4 1.3 4.9s2.2 2.7 3.7 3.4l22.4 12.8c1.5 .9 3.2 1.3 5 1.2 2.4 .1 4.8-.8 6.6-2.5 1.8-1.9 2.8-4.4 2.9-7l0-85.3 115.9 67.9c.6 .3 1.4 .4 2.1 .4zM323.4 377.7c-1.7 .1-3.4 .5-5 1.2l-74.5 43.1 0-134.2c0-2.9-2.9-5.8-6.2-4.6-9.4 2.8-19.5 3-29 .4-.7-.2-1.5-.2-2.2-.1s-1.4 .4-2 .9-1.1 1-1.4 1.7-.5 1.4-.5 2.1l0 133.3-74.5-43.1c-1.5-.9-3.2-1.3-5-1.2-2.5 0-4.9 1-6.7 2.8s-2.8 4.2-2.8 6.7l0 26.1c0 1.7 .4 3.4 1.3 4.9s2.2 2.7 3.7 3.4l100.2 57.6c1.5 .9 3.2 1.3 5 1.2 1.7 0 3.4-.4 5-1.2l100.2-57.6c1.5-.8 2.7-2 3.6-3.5s1.4-3.1 1.4-4.8l0-26.1c-.8-4.6-5.4-9.1-10.4-9.1zM286.1 78a23 23 0 1 0 0-46 23 23 0 1 0 0 46zm63.6-10.1a23 23 0 1 0 0 46 23 23 0 1 0 0-46zm63.2 83.7a23 23 0 1 0 0-46 23 23 0 1 0 0 46zm-63.2-9.2a23 23 0 1 0 0 46 23 23 0 1 0 0-46zm-63.6 83.2c4.5 0 9-1.3 12.8-3.9s6.7-6.1 8.5-10.3 2.2-8.8 1.3-13.3-3.1-8.6-6.3-11.8-7.3-5.4-11.8-6.3-9.1-.4-13.3 1.3-7.8 4.7-10.3 8.5-3.9 8.2-3.9 12.8c0 3 .6 6 1.8 8.8s2.9 5.3 5 7.5 4.7 3.8 7.5 5 5.8 1.8 8.8 1.8l0 0zM224 262c4.5 0 9-1.4 12.8-3.9s6.7-6.1 8.5-10.3 2.2-8.8 1.3-13.3-3.1-8.6-6.3-11.8-7.3-5.4-11.8-6.3-9.1-.4-13.3 1.3-7.8 4.7-10.3 8.5-3.9 8.2-3.9 12.8c0 3 .6 6 1.7 8.8s2.8 5.3 5 7.5 4.7 3.8 7.5 5 5.8 1.8 8.8 1.8l0 0zm188.9-82.4c-4.6 0-9 1.3-12.8 3.9s-6.7 6.1-8.5 10.3-2.2 8.8-1.3 13.3 3.1 8.6 6.3 11.8 7.3 5.4 11.8 6.3 9.1 .4 13.3-1.3 7.8-4.7 10.3-8.5 3.9-8.2 3.9-12.8c0-6.1-2.4-11.9-6.7-16.3s-10.2-6.7-16.3-6.7l0 0zm0 72.3c-4.6 0-9 1.3-12.8 3.9s-6.7 6.1-8.5 10.3-2.2 8.8-1.3 13.3 3.1 8.6 6.3 11.8 7.3 5.4 11.8 6.3 9.1 .4 13.3-1.3 7.8-4.7 10.3-8.5 3.9-8.2 3.9-12.8c0-6.1-2.4-11.9-6.7-16.3s-10.2-6.7-16.3-6.7l0 0z"],
    "playstation": [576, 512, [], "f3df", "M571 372.3c-11.3 14.2-38.8 24.3-38.8 24.3l-205.1 73.6 0-54.3 150.9-53.8c17.1-6.1 19.8-14.8 5.8-19.4-13.9-4.6-39.1-3.3-56.2 2.9l-100.5 35.5 0-56.4c23.2-7.8 47.1-13.6 75.7-16.8 40.9-4.5 90.9 .6 130.2 15.5 44.2 14 49.2 34.7 38 48.9zM346.6 279.8l0-139c0-16.3-3-31.3-18.3-35.6-11.7-3.8-19 7.1-19 23.4l0 347.9-93.8-29.8 0-414.7c39.9 7.4 98 24.9 129.2 35.4 79.5 27.3 106.4 61.3 106.4 137.8 0 74.5-46 102.8-104.5 74.6zM43.3 410.2c-45.4-12.8-53-39.5-32.3-54.8 19.1-14.2 51.7-24.9 51.7-24.9l134.5-47.8 0 54.5-96.8 34.6c-17.1 6.1-19.7 14.8-5.8 19.4s39.1 3.3 56.2-2.9l46.4-16.9 0 48.8c-51.6 9.3-101.4 7.3-153.9-10z"],
    "microblog": [448, 512, [], "e01a", "M399.8 362.2c29.5-34.7 47.1-78.3 47.1-125.8 0-113-99.6-204.4-222.5-204.4S2 123.5 2 236.4 101.6 440.9 224.5 440.9c27 0 53.9-4.5 79.4-13.4 1.4-.5 3-.5 4.5-.1s2.7 1.4 3.6 2.6c18.6 25.1 47.6 42.7 79.9 49.9 1.1 .2 2.3 0 3.3-.6s1.7-1.6 1.9-2.8c.1-.6 .1-1.3 0-1.9s-.4-1.2-.8-1.7c-12.3-16-18.7-35.8-18-56s8.4-39.5 21.7-54.7l-.2 .1zM330 212.4l-57.3 43.5 20.8 68.9c.4 1.3 .4 2.7-.1 4s-1.2 2.4-2.3 3.2-2.4 1.2-3.8 1.2-2.7-.4-3.8-1.2l-59.1-41-59.1 41.1c-1.1 .8-2.4 1.2-3.8 1.2s-2.7-.4-3.8-1.2-1.9-1.9-2.3-3.2-.5-2.7-.1-4l20.8-68.9-57.3-43.5c-1.1-.8-1.9-1.9-2.3-3.2s-.4-2.7 0-4 1.2-2.4 2.3-3.2 2.4-1.3 3.7-1.3l71.9-1.5 23.7-67.9c.4-1.3 1.3-2.4 2.4-3.2s2.4-1.2 3.8-1.2 2.7 .4 3.8 1.2 1.9 1.9 2.4 3.2l23.7 67.9 71.9 1.5c1.4 0 2.7 .4 3.8 1.2s1.9 1.9 2.3 3.2 .4 2.7 0 4-1.2 2.4-2.3 3.3l0 0z"],
    "gitkraken": [576, 512, [], "f3a6", "M557.7 118.1c-2.3-6.1-9.3-9.2-15.3-6.6-5.7 2.4-8.5 8.9-6.3 14.6 10.9 29 16.9 60.5 16.9 93.3 0 134.6-100.3 245.7-230.2 262.7l0-123.7c7.9-1.5 15.5-3.6 23-6.2l0 104c106.7-25.9 185.9-122.1 185.9-236.8 0-91.8-50.8-171.8-125.8-213.3-5.7-3.2-13-.9-15.9 5-2.7 5.5-.6 12.2 4.7 15.1 67.9 37.6 113.9 110 113.9 193.2 0 93.3-57.9 173.1-139.8 205.4l0-92.2c14.2-4.5 24.9-17.7 24.9-33.5 0-13.1-6.8-24.4-17.3-30.5 8.3-79.5 44.5-58.6 44.5-83.9l0-14.7c0-38-87.9-161.8-129-164.7-2.5-.2-5-.2-7.6 0-41.2 3-129.1 126.7-129.1 164.7l0 14.8c0 25.3 36.3 4.3 44.5 83.9-10.6 6.1-17.3 17.4-17.3 30.5 0 15.8 10.6 29 24.8 33.5l0 92.2c-81.9-32.2-139.8-112-139.8-205.4 0-83.1 46-155.5 113.9-193.2 5.4-3 7.4-9.6 4.7-15.1-2.9-5.9-10.1-8.2-15.9-5-75 41.5-125.8 121.5-125.8 213.3 0 114.7 79.2 210.8 185.9 236.8l0-104c7.6 2.5 15.1 4.6 23 6.2l0 123.7c-129.8-17-230.2-128.1-230.2-262.7 0-32.8 6-64.3 16.9-93.3 2.2-5.8-.6-12.2-6.3-14.6-6-2.6-13 .4-15.3 6.6-11.8 31.5-18.3 65.6-18.3 101.3 0 155.1 122.6 281.6 276.3 287.8l0-145.9c6.8 .4 15 .5 23.4 0l0 145.8c153.7-6.1 276.3-132.6 276.3-287.7 0-35.7-6.5-69.8-18.3-101.4zM357.9 322.9a23.7 23.7 0 1 1 0-47.4 23.7 23.7 0 1 1 0 47.4zM218.1 275.4a23.7 23.7 0 1 1 0 47.4 23.7 23.7 0 1 1 0-47.4z"],
    "telegram": [512, 512, [62462, "telegram-plane"], "f2c6", "M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM371 176.7c-3.7 39.2-19.9 134.4-28.1 178.3-3.5 18.6-10.3 24.8-16.9 25.4-14.4 1.3-25.3-9.5-39.3-18.7-21.8-14.3-34.2-23.2-55.3-37.2-24.5-16.1-8.6-25 5.3-39.5 3.7-3.8 67.1-61.5 68.3-66.7 .2-.7 .3-3.1-1.2-4.4s-3.6-.8-5.1-.5c-2.2 .5-37.1 23.5-104.6 69.1-9.9 6.8-18.9 10.1-26.9 9.9-8.9-.2-25.9-5-38.6-9.1-15.5-5-27.9-7.7-26.8-16.3 .6-4.5 6.7-9 18.4-13.7 72.3-31.5 120.5-52.3 144.6-62.3 68.9-28.6 83.2-33.6 92.5-33.8 2.1 0 6.6 .5 9.6 2.9 2 1.7 3.2 4.1 3.5 6.7 .5 3.2 .6 6.5 .4 9.8z"],
    "itunes-note": [384, 512, [], "f3b5", "M381.9 388.2c-6.4 27.4-27.2 42.8-55.1 48-24.5 4.5-44.9 5.6-64.5-10.2-23.9-20.1-24.2-53.4-2.7-74.4 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 6.4-7.2 4.4-4.1 4.4-163.2 0-11.2-5.5-14.3-17-12.3-8.2 1.4-185.7 34.6-185.7 34.6-10.2 2.2-13.4 5.2-13.4 16.7 0 234.7 1.1 223.9-2.5 239.5-4.2 18.2-15.4 31.9-30.2 39.5-16.8 9.3-47.2 13.4-63.4 10.4-43.2-8.1-58.4-58-29.1-86.6 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 10.1-11.5 1.8-256.6 5.2-270.2 .8-5.2 3-9.6 7.1-12.9 4.2-3.5 11.8-5.5 13.4-5.5 204-38.2 228.9-43.1 232.4-43.1 11.5-.8 18.1 6 18.1 17.6 .2 344.5 1.1 326-1.8 338.5z"],
    "less": [640, 512, [], "f41d", "M613.2 219c0-20.5 3.2-32.6 3.2-54.6 0-34.2-12.6-45.2-40.5-45.2l-20.5 0 0 24.2 6.3 0c14.2 0 17.3 4.7 17.3 22.1 0 16.3-1.6 32.6-1.6 51.5 0 24.2 7.9 33.6 23.6 37.3l0 1.6c-15.8 3.7-23.6 13.1-23.6 37.3 0 18.9 1.6 34.2 1.6 51.5 0 17.9-3.7 22.6-17.3 22.6l0 .5-6.3 0 0 25.2 20.5 0c27.8 0 40.5-11 40.5-45.2 0-22.6-3.2-34.2-3.2-54.6 0-11 6.8-22.6 27.3-23.6l0-27.3c-20.5-.7-27.3-12.3-27.3-23.3zM507.6 251c-15.8-6.3-30.5-10-30.5-20.5 0-7.9 6.3-12.6 17.9-12.6s22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-21 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51s-22.5-41-43-47.8zM148.7 310.4c-3.7 0-8.4-3.2-8.4-13.1l0-178.2-74.6 0c-28.4 0-41 11-41 45.2 0 22.6 3.2 35.2 3.2 54.6 0 11-6.8 22.6-27.3 23.6l0 27.3c20.5 .5 27.3 12.1 27.3 23.1 0 19.4-3.2 31-3.2 53.6 0 34.2 12.6 45.2 40.5 45.2l20.5 0 0-24.2-6.3 0c-13.1 0-17.3-5.3-17.3-22.6s1.6-32.1 1.6-51.5c0-24.2-7.9-33.6-23.6-37.3l0-1.6c15.8-3.7 23.6-13.1 23.6-37.3 0-18.9-1.6-34.2-1.6-51.5s3.7-22.1 17.3-22.1l14.1 0 0 150.8c0 32.1 11 53.1 43.1 53.1 10 0 17.9-1.6 23.6-3.7l-5.3-34.2c-3.1 .8-4.6 .8-6.2 .8zM380.4 251c-16.3-6.3-31-10-31-20.5 0-7.9 6.3-12.6 17.9-12.6s22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-20.5 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51 .1-28.9-22.5-41-43-47.8zm-155-68.8c-38.4 0-75.1 32.1-74.1 82.5 0 52 34.2 82.5 79.3 82.5 18.9 0 39.9-6.8 56.2-17.9L271 301.5c-11.6 6.8-22.6 10-34.2 10-21 0-37.3-10-41.5-34.2l95.2 0c.5-3.7 1.6-11 1.6-19.4 .6-42.6-22.6-75.7-66.7-75.7zm-30 66.2c3.2-21 15.8-31 30.5-31 18.9 0 26.3 13.1 26.3 31l-56.8 0z"],
    "firefox": [512, 512, [], "f269", "M503.5 241.5c-.1-1.6-.2-3.1-.2-4.7l0-.1-.4-4.7 0-.1c-1.3-13.9-3.7-27.7-7.3-41.2 0-.1 0-.1-.1-.2l-1.1-4c-.1-.2-.1-.5-.2-.6-.4-1.2-.7-2.5-1.1-3.7-.1-.2-.1-.6-.2-.8-.4-1.2-.7-2.4-1.1-3.5-.1-.4-.2-.6-.4-1-.4-1.2-.7-2.3-1.2-3.5l-.4-1.1c-.4-1.1-.8-2.3-1.2-3.4-.1-.3-.2-.7-.4-1-.5-1.1-.8-2.3-1.3-3.4-.1-.2-.2-.6-.4-.8-.5-1.2-1-2.3-1.4-3.5 0-.1-.1-.2-.1-.4-1.6-3.8-3.2-7.7-5-11.4l-.4-.7c-.5-1-.8-1.8-1.3-2.6-.2-.5-.5-1.1-.7-1.6-.4-.8-.8-1.6-1.2-2.4-.4-.6-.6-1.2-1-1.8s-.8-1.4-1.2-2.3c-.4-.6-.7-1.3-1.1-1.9s-.8-1.4-1.2-2.2c-.4-.7-.8-1.4-1.2-2-.4-.7-.8-1.3-1.2-2s-.8-1.3-1.2-2-.8-1.3-1.2-1.9-.8-1.4-1.3-2.2c-.4-.6-.8-1.2-1.2-1.8l-1.4-2.1c-.4-.6-.8-1.2-1.2-1.8-.5-.7-1.1-1.6-1.6-2.3-.4-.5-.7-1.1-1.1-1.6l-1.8-2.5c-.4-.5-.6-.8-1-1.3-1-1.3-1.8-2.5-2.8-3.7-7.2-9.4-15-18.3-23.5-26.6-5.7-6-11.8-11.5-18.3-16.7-4-3.5-8.2-6.7-12.5-9.8-7.7-5.8-16-10.8-24.6-15.1-2.4-1.3-4.8-2.5-7.2-3.7-17.7-8.6-36.3-15.2-55.4-19.6-1.9-.4-3.8-.8-5.6-1.2l-.1 0c-1-.1-1.8-.4-2.8-.5-12.5-2.4-25.2-3.7-38-4l-10.6 0c-15.3 .2-30.5 1.9-45.5 5-33.6 7.1-63.2 21.2-82.9 39-1.1 1-1.9 1.7-2.4 2.2l-.5 .5 .1 0c0 0 .1 0 .1 0s0-.1 0-.1l-.1 .1c.1-.1 .1-.1 .2-.1 14.6-8.8 34.9-16 49.4-19.6l5.9-1.4c.4-.1 .8-.1 1.2-.2 1.7-.4 3.4-.7 5.2-1.1 .2 0 .6-.1 .8-.1 64.2-11.7 132.6 7.5 180.2 53 10.3 9.8 19.3 20.8 26.9 32.8 30.4 49.2 27.5 111.1 3.8 147.6-34.4 53-111.4 71.3-159 24.8-16-15.5-25.2-36.7-25.6-59-.2-10.7 2-21.2 6.2-31 1.7-3.8 13.1-25.7 18.2-24.6-13.1-2.8-37.5 2.6-54.7 28.2-15.4 22.9-14.5 58.2-5 83.3-6-12.4-10.1-25.6-12.1-39.2-12.2-82.6 43.3-153 94.3-170.5-27.5-24-96.5-22.3-147.7 15.4-29.9 22-51.2 53.2-62.5 90.4 1.7-20.9 9.6-52.1 25.8-83.9-17.2 8.9-39 37-49.8 62.9-15.6 37.4-21 82.2-16.1 124.8 .4 3.2 .7 6.4 1.1 9.6 19.9 117.1 122 206.4 244.8 206.4 137.1 0 248.3-111.2 248.3-248.4-.1-4.5-.2-9.1-.5-13.5z"],
    "kaggle": [320, 512, [], "f5fa", "M304.2 501.5L158.4 320.3 298.2 185c2.6-2.7 1.7-10.5-5.3-10.5l-69.2 0c-3.5 0-7 1.8-10.5 5.3l-132.3 133.7 0-306c0-5-2.5-7.5-7.5-7.5L21.5 0C16.5 0 14 2.5 14 7.5l0 497c0 5 2.5 7.5 7.5 7.5l51.9 0c5 0 7.5-2.5 7.5-7.5l0-109 30.8-29.3 110.5 140.6c3 3.5 6.5 5.3 10.5 5.3l66.9 0c3.5 0 5.5-1 6-3l-1.4-7.6z"],
    "facebook-messenger": [512, 512, [], "f39f", "M256.6 8c-140 0-248.6 102.3-248.6 240.6 0 72.3 29.7 134.8 78.1 177.9 8.3 7.5 6.6 11.9 8 58.2 .1 3.2 1 6.4 2.6 9.2s3.9 5.2 6.7 6.9 5.9 2.8 9.1 3 6.5-.3 9.5-1.6C174.9 479 175.6 477.2 184.6 479.6 337.8 521.8 504 423.7 504 248.6 504 110.3 396.6 8 256.6 8zM405.8 193.1l-73 115.6c-2.8 4.3-6.4 8.1-10.6 11s-9.1 4.8-14.1 5.8-10.3 .8-15.3-.4-9.7-3.4-13.8-6.4l-58.1-43.5c-2.6-1.9-5.8-3-9-3s-6.4 1.1-9 3l-78.4 59.4c-10.5 7.9-24.2-4.6-17.1-15.7l73-115.6c2.8-4.3 6.4-8.1 10.6-11s9.1-4.8 14.1-5.8 10.3-.8 15.3 .4 9.7 3.4 13.9 6.4l58.1 43.5c2.6 1.9 5.8 3 9 3s6.4-1.1 9-3l78.4-59.4c10.4-8 24.1 4.5 17.1 15.6z"],
    "audible": [640, 512, [], "f373", "M640 199.9l0 54-320 200-320-199.9 0-54 320 200 320-200.1zm-194.5 72l47.1-29.4c-37.2-55.8-100.7-92.6-172.7-92.6s-135.5 36.7-172.6 92.4l.3 0c2.5-2.3 5.1-4.5 7.7-6.7 89.7-74.4 219.4-58.1 290.2 36.3zM225.4 290.7c16.9-11.9 36.5-18.7 57.4-18.7 34.4 0 65.2 18.4 86.4 47.6l45.4-28.4c-20.9-29.9-55.6-49.5-94.8-49.5-38.9 0-73.4 19.4-94.4 49zM103.6 161.1C235.4 56.8 421.8 84.7 521.1 223.2l.7 1 48.8-30.4c-53.5-81.7-145.8-135.7-250.7-135.7-103.5 0-196.6 53.5-250.5 135.6 9.9-10.5 22.7-23.5 34.2-32.6z"],
    "patreon": [512, 512, [], "f3d9", "M490 153.8c-.1-65.4-51-119-110.7-138.3-74.2-24-172-20.5-242.9 12.9-85.8 40.5-112.8 129.3-113.8 217.8-.8 72.8 6.4 264.4 114.6 265.8 80.3 1 92.3-102.5 129.5-152.3 26.4-35.5 60.5-45.5 102.4-55.9 72-17.8 121.1-74.7 121-150l-.1 0z"],
    "vnv": [640, 512, [], "f40b", "M104.9 352c-34.1 0-46.4-30.4-46.4-30.4L2.6 210.1S-7.8 192 13 192l32.8 0c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.7-74.5c5.6-9.5 8.4-18.1 18.8-18.1l32.8 0c20.8 0 10.4 18.1 10.4 18.1L186.4 321.6S174.2 352 140 352l-35.1 0zm395 0c-34.1 0-46.4-30.4-46.4-30.4L397.6 210.1S387.2 192 408 192l32.8 0c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.8-74.5c5.6-9.5 8.4-18.1 18.8-18.1l32.9 0c20.8 0 10.4 18.1 10.4 18.1L581.5 321.6S569.3 352 535.1 352l-35.2 0zM337.6 192c34.1 0 46.4 30.4 46.4 30.4l55.9 111.5S450.3 352 429.5 352l-32.8 0c-10.4 0-13.2-8.7-18.8-18.1l-36.7-74.5s-5.2-13.1-21.1-13.1-21.1 13.1-21.1 13.1l-36.7 74.5c-5.6 9.4-8.4 18.1-18.8 18.1l-32.9 0c-20.8 0-10.4-18.1-10.4-18.1l55.9-111.5S268.3 192 302.5 192l35.1 0z"],
    "pagelines": [384, 512, [], "f18c", "M384.1 312.7c-55.1 136.7-187.1 54-187.1 54-40.5 81.8-107.4 134.4-184.6 134.7-16.1 0-16.6-24.4 0-24.4 64.4-.3 120.5-42.7 157.2-110.1-41.1 15.9-118.6 27.9-161.6-82.2 109-44.9 159.1 11.2 178.3 45.5 9.9-24.4 17-50.9 21.6-79.7 0 0-139.7 21.9-149.5-98.1 119.1-47.9 152.6 76.7 152.6 76.7 1.6-16.7 3.3-52.6 3.3-53.4 0 0-106.3-73.7-38.1-165.2 124.6 43 61.4 162.4 61.4 162.4 .5 1.6 .5 23.8 0 33.4 0 0 45.2-89 136.4-57.5-4.2 134-141.9 106.4-141.9 106.4-4.4 27.4-11.2 53.4-20 77.5 0 0 83-91.8 172-20z"],
    "amazon": [448, 512, [], "f270", "M257.7 162.7c-48.7 1.8-169.5 15.5-169.5 117.5 0 109.5 138.3 114 183.5 43.2 6.5 10.2 35.4 37.5 45.3 46.8l56.8-56s-32.3-25.3-32.3-52.8l0-147.1C341.5 89 317 32 229.2 32 141.2 32 94.5 87 94.5 136.3l73.5 6.8c16.3-49.5 54.2-49.5 54.2-49.5 40.7-.1 35.5 29.8 35.5 69.1zm0 86.8c0 80-84.2 68-84.2 17.2 0-47.2 50.5-56.7 84.2-57.8l0 40.6zM393.7 413c-7.7 10-70 67-174.5 67S34.7 408.5 10.2 379c-6.8-7.7 1-11.3 5.5-8.3 73.3 44.5 187.8 117.8 372.5 30.3 7.5-3.7 13.3 2 5.5 12zm39.8 2.2c-6.5 15.8-16 26.8-21.2 31-5.5 4.5-9.5 2.7-6.5-3.8s19.3-46.5 12.7-55c-6.5-8.3-37-4.3-48-3.2-10.8 1-13 2-14-.3-2.3-5.7 21.7-15.5 37.5-17.5 15.7-1.8 41-.8 46 5.7 3.7 5.1 0 27.1-6.5 43.1z"],
    "envira": [448, 512, [], "f299", "M0 32c477.6 0 366.6 317.3 367.1 366.3l80.9 81.7-26 0-70.4-71.2C312.6 413 227.2 443.3 137.2 371.8 47 300.3 52 214.7 0 32zM79.7 78c-49.7-23.5-5.2 9.2-5.2 9.2 45.2 31.2 66 73.7 90.2 119.9 31.5 60.2 79 139.7 144.2 167.7 65 28 34.2 12.5 6-8.5-28.2-21.2-68.2-87-91-130.2-31.7-60-61-118.6-144.2-158.1z"],
    "linode": [448, 512, [], "f2b8", "M366.3 186.9l-59.5 36.9-.8 36.9-29.3-19.3-39.4 24.3c2.2 55.2 2.5 59.3 2.5 59.5l-97.2 65.4-15.1-104.7 108.1-62-40.2-26-75.4 38.5-21-143.3 129-49.4-91.3-43.6-125.7 39.4 27.7 134.9 41.9 32.7-31.8 15.1 20.9 101.4 29.3 27.7-20.9 12.6 16.8 78.8 66.2 69.6c-10.8-74.8-11.7-78.6-11.7-78.8l77.9-55.3C244 365.4 242.3 367 242.3 367l.8 24.3 33.5 28.5-.8-77.1 46.9-33.5 26.8-18.4-2.5 36 25.1 17.6 6.7-74.6 58.7-43.6-71.2-39.4z"],
    "accusoft": [640, 512, [], "f369", "M322.1 252l0-1-51.2-65.8s-12 1.6-25 15.1c-9 9.3-242.1 239.1-243.4 240.9-7 10 1.6 6.8 15.7 1.7 .8 0 114.5-36.6 114.5-36.6 .5-.6-.1-.1 .6-.6-.4-5.1-.8-26.2-1-27.7-.6-5.2 2.2-6.9 7-8.9l92.6-33.8c.6-.8 88.5-81.7 90.2-83.3zM482.2 372.1c13.3 16.1 20.7 13.3 30.8 9.3 3.2-1.2 115.4-47.6 117.8-48.9 8-4.3-1.7-16.7-7.2-23.4-2.1-2.5-205.1-245.6-207.2-248.3-9.7-12.2-14.3-12.9-38.4-12.8-10.2 0-106.8 .5-116.5 .6-19.2 .1-32.9-.3-19.2 16.9 7.7 9.5 234.2 299.7 239.9 306.6zm152.7 1.6c-2.3-.3-24.6-4.7-38-7.2 0 0-115 50.4-117.5 51.6-16 7.3-26.9-3.2-36.7-14.6l-57.1-74c-5.4-.9-60.4-9.6-65.3-9.3-3.1 .2-9.6 .8-14.4 2.9-4.9 2.1-145.2 52.8-150.2 54.7-5.1 2-11.4 3.6-11.1 7.6 .2 2.5 2 2.6 4.6 3.5 2.7 .8 300.9 67.6 308 69.1 15.6 3.3 38.5 10.5 53.6 1.7 2.1-1.2 123.8-76.4 125.8-77.8 5.4-4 4.3-6.8-1.7-8.2z"],
    "erlang": [640, 512, [], "f39d", "M87.2 53.5l-87.2 0 0 405 100.4 0c-49.7-52.6-78.8-125.3-78.7-212.1-.1-76.7 24-142.7 65.5-192.9zm238.2 9.7c-45.9 .1-85.1 33.5-89.2 83.2l169.9 0c-1.1-49.7-34.5-83.1-80.7-83.2zm230.7-9.6l.3 0-.1-.1-.2 .1zm.3 0c31.4 42.7 48.7 97.5 46.2 162.7 .5 6 .5 11.7 0 24.1l-372.4 0c-.2 109.7 38.9 194.9 138.6 195.3 68.5-.3 118-51 151.9-106.1l96.4 48.2c-17.4 30.9-36.5 57.8-57.9 80.8l80.8 0 0-405-83.6 0z"],
    "cc-discover": [576, 512, [], "f1f2", "M520.4 196.1c0-7.9-5.5-12.1-15.6-12.1l-4.9 0 0 24.9 4.7 0c10.3 0 15.8-4.4 15.8-12.8zM528 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48zM483.9 170.9c22.6 0 52.9-4.1 52.9 24.4 0 12.6-6.6 20.7-18.7 23.2l25.8 34.4-19.6 0-22.2-32.8-2.2 0 0 32.8-16 0 0-82zM428 171l45.3 0 0 14-29.3 0 0 18.2 28.3 0 0 13.8-28.3 0 0 22.2 29.3 0 0 13.8-45.3 0 0-82zm-68.7 0l21.9 55.2 22.2-55.2 17.5 0-35.5 84.2-8.6 0-35-84.2 17.5 0zm-55.9 86.2a44.6 44.6 0 1 1 0-89.2 44.6 44.6 0 1 1 0 89.2zm-49.3-83.1l0 19c-20.1-20.1-46.8-4.7-46.8 19 0 25 27.5 38.5 46.8 19.2l0 19c-29.7 14.3-63.3-5.7-63.3-38.2 0-31.2 33.1-53 63.3-38zm-97.2 66.3c11.4 0 22.4-15.3-3.3-24.4-15-5.5-20.2-11.4-20.2-22.7 0-23.2 30.6-31.4 49.7-14.3l-8.4 10.8c-10.4-11.6-24.9-6.2-24.9 2.5 0 4.4 2.7 6.9 12.3 10.3 18.2 6.6 23.6 12.5 23.6 25.6 0 29.5-38.8 37.4-56.6 11.3l10.3-9.9c3.7 7.1 9.9 10.8 17.5 10.8zM55.4 253l-23.4 0 0-82 23.4 0c26.1 0 44.1 17 44.1 41.1 0 18.5-13.2 40.9-44.1 40.9zm67.5 0l-16 0 0-82 16 0 0 82zM544 433c0 8.2-6.8 15-15 15l-401 0c189.6-35.6 382.7-139.2 416-160l0 145zM74.1 191.6c-5.2-4.9-11.6-6.6-21.9-6.6l-4.2 0 0 54.2 4.2 0c10.3 0 17-2 21.9-6.4 5.7-5.2 8.9-12.8 8.9-20.7s-3.2-15.5-8.9-20.5z"],
    "safari": [512, 512, [], "f267", "M274.7 274.7L237.3 237.3 166 346 274.7 274.7zM256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM411.8 182.8l14.8-6.1c1-.4 2-.6 3.1-.6s2.1 .2 3.1 .6 1.8 1 2.6 1.7 1.3 1.6 1.7 2.6 .6 2 .6 3.1-.2 2.1-.6 3.1-1 1.9-1.7 2.6-1.6 1.3-2.6 1.7L418 197.6c-2 .8-4.2 .8-6.1 0s-3.5-2.4-4.3-4.3-.8-4.2 0-6.1 2.4-3.5 4.3-4.3zM314.4 94l6.1-14.8c.8-2 2.4-3.5 4.3-4.3s4.2-.8 6.1 0 3.5 2.4 4.3 4.3 .8 4.2 0 6.1l-6.1 14.8c-.8 2-2.4 3.5-4.3 4.3s-4.2 .8-6.1 0c-1-.4-1.9-1-2.6-1.7s-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1zM256 60c2.1 0 4.2 .8 5.7 2.3S264 65.9 264 68l0 16c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3-4.2-.8-5.7-2.3-2.3-3.5-2.3-5.7l0-16c0-2.1 .8-4.2 2.3-5.7S253.9 60 256 60zM181 74.9c1-.4 2-.6 3.1-.6s2.1 .2 3.1 .6 1.9 1 2.6 1.7 1.3 1.6 1.7 2.6L197.6 94c.4 1 .7 2 .7 3.1s-.2 2.1-.6 3.1-1 1.9-1.7 2.6-1.6 1.4-2.6 1.8-2 .6-3.1 .6-2.1-.2-3.1-.6-1.9-1-2.6-1.8-1.3-1.7-1.7-2.7l-6.1-14.8c-.8-2-.8-4.2 0-6.1s2.4-3.5 4.3-4.3zm-63.6 42.5c1.5-1.5 3.5-2.3 5.7-2.3s4.2 .8 5.7 2.3L140 128.7c1.5 1.5 2.3 3.5 2.3 5.6s-.8 4.1-2.3 5.6c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3l-11.3-11.3c-1.5-1.5-2.3-3.5-2.3-5.6s.8-4.1 2.3-5.6l0 0zM60 256c0-2.1 .8-4.2 2.3-5.7S65.9 248 68 248l16 0c2.1 0 4.2 .8 5.7 2.3s2.3 3.5 2.3 5.7-.8 4.2-2.3 5.7-3.5 2.3-5.7 2.3l-16 0c-2.1 0-4.2-.8-5.7-2.3S60 258.1 60 256zm40.2 73.2l-14.8 6.1c-1 .4-2 .6-3.1 .6s-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1 1-1.9 1.7-2.6 1.6-1.3 2.6-1.7L94 314.4c2-.8 4.2-.8 6.1 0s3.5 2.4 4.3 4.3 .8 4.2 0 6.1-2.4 3.5-4.3 4.3zm4.3-136c-.4 1-1 1.9-1.7 2.6s-1.6 1.3-2.6 1.7-2 .6-3.1 .6-2.1-.2-3.1-.6l-14.8-6.1c-2-.8-3.5-2.4-4.3-4.3s-.8-4.2 0-6.1 2.4-3.5 4.3-4.3 4.2-.8 6.1 0l14.8 6.1c2 .8 3.5 2.4 4.3 4.3s.8 4.2 0 6.1l0 0zM197.6 418l-6.1 14.8c-.4 1-1 1.9-1.7 2.6s-1.6 1.3-2.6 1.7-2 .6-3.1 .6-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6-.6-2-.6-3.1 .2-2.1 .6-3.1l6.1-14.8c.4-1 1-1.9 1.7-2.7s1.6-1.4 2.6-1.8 2-.6 3.1-.6 2.1 .2 3.1 .6 1.9 1 2.6 1.8 1.3 1.7 1.7 2.6 .6 2 .6 3.1-.2 2.1-.7 3.1zM264 444c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3-4.2-.8-5.7-2.3-2.3-3.5-2.3-5.7l0-16c0-2.1 .8-4.2 2.3-5.7s3.5-2.3 5.7-2.3 4.2 .8 5.7 2.3 2.3 3.5 2.3 5.7l0 16zm67-6.9c-1 .4-2 .6-3.1 .6s-2.1-.2-3.1-.6-1.9-1-2.6-1.7-1.3-1.6-1.7-2.6L314.4 418c-.8-2-.8-4.2 0-6.1s2.4-3.5 4.3-4.3 4.2-.8 6.1 0 3.5 2.4 4.3 4.3l6.1 14.8c.8 2 .8 4.2 0 6.1s-2.4 3.5-4.3 4.3zm63.6-42.5c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L372 383.3c-1.5-1.5-2.3-3.5-2.3-5.6s.8-4.1 2.3-5.6 3.5-2.3 5.7-2.3 4.2 .8 5.7 2.3l11.3 11.3c1.5 1.5 2.3 3.5 2.3 5.6s-.8 4.1-2.3 5.6l0 0zM286.2 286.2L110.3 401.7 225.8 225.8 401.7 110.3 286.2 286.2zM437.1 331c-.8 2-2.4 3.5-4.3 4.3s-4.2 .8-6.1 0l-14.8-6.1c-2-.8-3.5-2.4-4.3-4.3s-.8-4.2 0-6.1c.4-1 1-1.9 1.7-2.6s1.6-1.3 2.6-1.7 2-.6 3.1-.6 2.1 .2 3.1 .6l14.8 6.1c2 .8 3.5 2.4 4.3 4.3s.8 4.2 0 6.1zm6.9-67l-16 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7 .8-4.2 2.3-5.7 3.5-2.3 5.7-2.3l16 0c2.1 0 4.2 .8 5.7 2.3s2.3 3.5 2.3 5.7-.8 4.2-2.3 5.7-3.5 2.3-5.7 2.3z"],
    "space-awesome": [512, 512, [], "e5ac", "M96 256l32 0 0 256-128 0 0-160 32 0 0-32 32 0 0-32 32 0 0-32zm416 96l0 160-128 0 0-256 32 0 0 32 32 0 0 32 32 0 0 32 32 0zM320 64l32 0 0 384-32 0 0-32-128 0 0 32-32 0 0-384 32 0 0-32 32 0 0-32 64 0 0 32 32 0 0 32zm-32 64l-64 0 0 64 64 0 0-64z"],
    "node": [640, 512, [], "f419", "M316.3 452c-2.1 0-4.2-.6-6.1-1.6L291 439c-2.9-1.6-1.5-2.2-.5-2.5 3.8-1.3 4.6-1.6 8.7-4 .4-.2 1-.1 1.4 .1l14.8 8.8c.5 .3 1.3 .3 1.8 0L375 408c.5-.3 .9-.9 .9-1.6l0-66.7c0-.7-.3-1.3-.9-1.6l-57.8-33.3c-.5-.3-1.2-.3-1.8 0l-57.8 33.3c-.6 .3-.9 1-.9 1.6l0 66.7c0 .6 .4 1.2 .9 1.5l15.8 9.1c8.6 4.3 13.9-.8 13.9-5.8l0-65.9c0-.9 .7-1.7 1.7-1.7l7.3 0c.9 0 1.7 .7 1.7 1.7l0 65.9c0 11.5-6.2 18-17.1 18-3.3 0-6 0-13.3-3.6l-15.2-8.7c-3.7-2.2-6.1-6.2-6.1-10.5l0-66.7c0-4.3 2.3-8.4 6.1-10.5l57.8-33.4c3.7-2.1 8.5-2.1 12.1 0l57.8 33.4c3.7 2.2 6.1 6.2 6.1 10.5l0 66.7c0 4.3-2.3 8.4-6.1 10.5l-57.8 33.4c-1.7 1.1-3.8 1.7-6 1.7zM363 386.2c0-12.5-8.4-15.8-26.2-18.2-18-2.4-19.8-3.6-19.8-7.8 0-3.5 1.5-8.1 14.8-8.1 11.9 0 16.3 2.6 18.1 10.6 .2 .8 .8 1.3 1.6 1.3l7.5 0c.5 0 .9-.2 1.2-.5 .3-.4 .5-.8 .4-1.3-1.2-13.8-10.3-20.2-28.8-20.2-16.5 0-26.3 7-26.3 18.6 0 12.7 9.8 16.1 25.6 17.7 18.9 1.9 20.4 4.6 20.4 8.3 0 6.5-5.2 9.2-17.4 9.2-15.3 0-18.7-3.8-19.8-11.4-.1-.8-.8-1.4-1.7-1.4l-7.5 0c-.9 0-1.7 .7-1.7 1.7 0 9.7 5.3 21.3 30.6 21.3 18.5 0 29-7.2 29-19.8zm54.5-50.1c0 6.1-5 11.1-11.1 11.1s-11.1-5-11.1-11.1c0-6.3 5.2-11.1 11.1-11.1 6-.1 11.1 4.8 11.1 11.1zm-1.8 0c0-5.2-4.2-9.3-9.4-9.3-5.1 0-9.3 4.1-9.3 9.3s4.2 9.4 9.3 9.4c5.2-.1 9.4-4.3 9.4-9.4zm-4.5 6.2l-2.6 0c-.1-.6-.5-3.8-.5-3.9-.2-.7-.4-1.1-1.3-1.1l-2.2 0 0 5-2.4 0 0-12.5 4.3 0c1.5 0 4.4 0 4.4 3.3 0 2.3-1.5 2.8-2.4 3.1 1.7 .1 1.8 1.2 2.1 2.8 .1 1 .3 2.7 .6 3.3zm-2.8-8.8c0-1.7-1.2-1.7-1.8-1.7l-2 0 0 3.5 1.9 0c1.6 0 1.9-1.1 1.9-1.8zM137.3 191c0-2.7-1.4-5.1-3.7-6.4L72.3 149.3c-1-.6-2.2-.9-3.4-1l-.6 0c-1.2 0-2.3 .4-3.4 1L3.7 184.6C1.4 185.9 0 188.4 0 191l.1 95c0 1.3 .7 2.5 1.8 3.2s2.5 .7 3.7 0L42 268.3c2.3-1.4 3.7-3.8 3.7-6.4l0-44.4c0-2.6 1.4-5.1 3.7-6.4l15.5-8.9c1.2-.7 2.4-1 3.7-1s2.6 .3 3.7 1l15.5 8.9c2.3 1.3 3.7 3.8 3.7 6.4l0 44.4c0 2.6 1.4 5.1 3.7 6.4l36.4 20.9c1.1 .7 2.6 .7 3.7 0 1.1-.6 1.8-1.9 1.8-3.2l.2-95zM472.5 87.3l0 176.4c0 2.6-1.4 5.1-3.7 6.4l-61.3 35.4c-2.3 1.3-5.1 1.3-7.4 0l-61.3-35.4c-2.3-1.3-3.7-3.8-3.7-6.4l0-70.8c0-2.6 1.4-5.1 3.7-6.4l61.3-35.4c2.3-1.3 5.1-1.3 7.4 0l15.3 8.8c1.7 1 3.9-.3 3.9-2.2l0-94c0-2.8 3-4.6 5.5-3.2l36.5 20.4c2.3 1.2 3.8 3.7 3.8 6.4zm-46 128.9c0-.7-.4-1.3-.9-1.6l-21-12.2c-.6-.3-1.3-.3-1.9 0l-21 12.2c-.6 .3-.9 .9-.9 1.6l0 24.3c0 .7 .4 1.3 .9 1.6l21 12.1c.6 .3 1.3 .3 1.8 0l21-12.1c.6-.3 .9-.9 .9-1.6l0-24.3 .1 0zm209.8-.7c2.3-1.3 3.7-3.8 3.7-6.4l0-17.1c0-2.6-1.4-5.1-3.7-6.4l-60.9-35.4c-2.3-1.3-5.1-1.3-7.4 0l-61.3 35.4c-2.3 1.3-3.7 3.8-3.7 6.4l0 70.8c0 2.7 1.4 5.1 3.7 6.4l60.9 34.7c2.2 1.3 5 1.3 7.3 0l36.8-20.5c2.5-1.4 2.5-5 0-6.4L550 241.6c-1.2-.7-1.9-1.9-1.9-3.2l0-22.2c0-1.3 .7-2.5 1.9-3.2l19.2-11.1c1.1-.7 2.6-.7 3.7 0L592.1 213c1.1 .7 1.9 1.9 1.9 3.2l0 17.4c0 2.8 3.1 4.6 5.6 3.2l36.7-21.3zM559 219c-.4 .3-.7 .7-.7 1.2l0 13.6c0 .5 .3 1 .7 1.2l11.8 6.8c.4 .3 1 .3 1.4 0L584 235c.4-.3 .7-.7 .7-1.2l0-13.6c0-.5-.3-1-.7-1.2l-11.8-6.8c-.4-.3-1-.3-1.4 0L559 219zM304.8 262.5l0-70.4c0-2.6-1.6-5.1-3.9-6.4l-61.1-35.2c-2.1-1.2-5-1.4-7.4 0l-61.1 35.2c-2.3 1.3-3.9 3.7-3.9 6.4l0 70.4c0 2.8 1.9 5.2 4 6.4l61.2 35.2c2.4 1.4 5.2 1.3 7.4 0l61-35.2c1.8-1 3.1-2.7 3.6-4.7 .1-.5 .2-1.1 .2-1.7zM230.5 137.6l-.8 .5 1.1 0-.3-.5zm76.2 130.2l-.4-.7 0 .9 .4-.2z"],
    "codepen": [512, 512, [], "f1cb", "M502.3 159.7l-234-156c-8-4.9-16.5-5-24.6 0l-234 156c-6 4-9.7 11.1-9.7 18.3L0 334c0 7.1 3.7 14.3 9.7 18.3l234 156c8 4.9 16.5 5 24.6 0l234-156c6-4 9.7-11.1 9.7-18.3l0-156c0-7.1-3.7-14.3-9.7-18.3zM278 63.1l172.3 114.9-76.9 51.4-95.4-63.7 0-102.6zm-44 0L234 165.7 138.6 229.4 61.7 178 234 63.1zM44 219.1L99.1 256 44 292.8 44 219.1zM234 448.8L61.7 334 138.6 282.6 234 346.3 234 448.8zM256 308l-77.7-52 77.7-52 77.7 52-77.7 52zm22 140.9l0-102.6 95.4-63.7 76.9 51.4-172.3 114.9zm190-156l-55.1-36.9 55.1-36.9 0 73.7z"],
    "ravelry": [512, 512, [], "f2d9", "M498.6 234.2c-1.2-10.3-1.7-20.8-3.7-31-2.5-12.4-5.7-24.6-9.6-36.6-6.8-20.9-17.2-40.3-30.9-57.5-5.9-7.6-12.1-14.8-18.8-21.7-14.1-14-30-26.1-47.1-36.1-17.8-10.6-36.8-18.9-56.7-24.7-11-3.1-22.3-5.4-33.5-7.6-6.8-1.3-13.7-1.7-20.6-2.5-.3 0-.6-.4-.9-.6-10.8 0-21.5 0-32.3 0-2.4 .4-4.8 .9-7.2 1.2-11.6 1.2-23.1 3.6-34.3 7.1-13.8 4.1-27.1 9.6-39.8 16.4-13.3 7-26.1 15.1-38.1 24.2-6.2 4.6-12.3 9.4-18 14.5-10.2 9.2-20.4 18.4-29.9 28.3-12.8 13.3-24.1 28.1-33.6 44-8.6 14-15.5 29-20.5 44.6-7.2 22.7-10.3 46.6-9.2 70.3 .6 13.5 2 26.9 4.4 40.2 3.4 18.4 9 36.3 16.7 53.3 13.6 29.2 32.1 51.5 50.4 67.9 12.8 11.6 26.8 21.9 41.8 30.6 17.7 10.4 36.4 18.9 55.9 25.3 13.3 4.3 26.9 7.6 40.6 9.8 6.1 1 12.3 1.3 18.4 1.9 .4 .1 .8 .3 1.2 .6l32.3 0c2.5-.4 5-.9 7.5-1.1 16.3-1.3 32.1-5.3 47.5-10.7 17.2-5.9 33.7-13.9 49-23.8 9.7-6.4 19.4-13.1 28.7-20.1 5.8-4.3 11-9.5 16.3-14.5 4-3.7 7.8-7.6 11.5-11.5 12-12.7 22.6-26.6 31.4-41.6 9.5-16 17.4-32.9 22.3-50.9 2.9-10.4 4.9-21 7-31.7 1-5.3 1.3-10.7 1.9-16.1 0-.3 .4-.6 .6-.9l0-37.1c-.2-.6-.4-1.2-.6-1.8zm-161.1-1.2s-16.6-3-28.5-3c-27.2 0-33.6 14.9-33.6 37l0 93.7-73.5 0 0-190.7 73.5 0 0 31.9c8.9-26.8 26.8-36.2 62-36.2l0 67.3z"],
    "alipay": [448, 512, [], "f642", "M377.7 32L70.3 32C31.4 32 0 63.4 0 102.3L0 409.7C0 448.6 31.4 480 70.3 480l307.5 0c38.5 0 69.8-31.1 70.3-69.6-46-25.6-110.6-60.3-171.6-88.4-32.1 44-84.1 81-148.6 81-70.6 0-93.7-45.3-97-76.4-4-39 14.9-81.5 99.5-81.5 35.4 0 79.4 10.2 127.1 25 16.5-30.1 26.5-60.3 26.5-60.3l-178.2 0 0-16.7 92.1 0 0-31.2-109.4 0 0-19 109.4 0 0-50.4 50.9 0 0 50.4 109.4 0 0 19-109.4 0 0 31.2 88.8 0s-15.2 46.6-38.3 90.9c48.9 16.7 100 36 148.6 52.7l0-234.4c.2-38.7-31.2-70.3-69.9-70.3zM47.3 323c1 20.2 10.2 53.7 69.9 53.7 52.1 0 92.6-39.7 117.9-72.9-44.6-18.7-84.5-31.4-109.4-31.4-67.4 0-79.4 33.1-78.4 50.6z"],
    "cc-amex": [576, 512, [], "f1f3", "M0 432c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-1.1-61.7 0-31.9-35.1-31.9 35.1-203.7 0 0-163.8-65.8 0 81.7-184.7 78.6 0 28.1 63.2 0-63.2 97.2 0 16.9 47.6 17-47.6 75.5 0 0-2.4c0-26.5-21.5-48-48-48L48 32C21.5 32 0 53.5 0 80L0 432zm440.4-21.7l42.2-46.3 42 46.3 51.4 0-68-72.1 68-72.1-50.6 0-42 46.7-41.5-46.7-51.4 0 67.5 72.5-67.4 71.6 0-33.1-83 0 0-22.2 80.9 0 0-32.3-80.9 0 0-22.4 83 0 0-33.1-122 0 0 143.2 171.8 0zm96.3-72l39.3 41.9 0-83.3-39.3 41.4zm-36.3-92l36.9-100.6 0 100.6 38.7 0 0-143.3-60.2 0-32.2 89.3-31.9-89.3-61.2 0 0 143.1-63.2-143.1-51.2 0-62.4 143.3 43 0 11.9-28.7 65.9 0 12 28.7 82.7 0 0-100.3 36.8 100.3 34.4 0zM282 185.4l19.5-46.9 19.4 46.9-38.9 0z"],
    "pied-piper-alt": [576, 512, [], "f1a8", "M244 246c-3.2-2-6.3-2.9-10.1-2.9-6.6 0-12.6 3.2-19.3 3.7l1.7 4.9 27.7-5.7zM379.9 443.9c-19 0-64.1 9.5-79.9 19.8l6.9 45.1c35.7 6.1 70.1 3.6 106-9.8-4.8-10-23.5-55.1-33-55.1zM340.8 177c6.6 2.8 11.5 9.2 22.7 22.1 2-1.4 7.5-5.2 7.5-8.6 0-4.9-11.8-13.2-13.2-23 11.2-5.7 25.2-6 37.6-8.9 68.1-16.4 116.3-52.9 146.8-116.7 6.1-12.6 11.8-25.8 12.4-39.9l-2 2.6c-28.4 50-33 63.2-81.3 100-31.9 24.4-69.2 40.2-106.6 54.6l-6.3-.3 0-21.8c-19.6 1.6-19.7-14.6-31.6-23-18.7 20.6-31.6 40.8-58.9 51.1-12.7 4.8-19.6 10-25.9 21.8 34.9-16.4 91.2-13.5 98.8-10zM555.5 0l-.6 1.1-.3 .9 .6-.6 .3-1.4zM496.3 382.1c-33.9-56.9-75.3-118.4-150-115.5l-.3-6c-1.1-13.5 32.8 3.2 35.1-31l-14.4 7.2c-19.8-45.7-8.6-54.3-65.5-54.3-14.7 0-26.7 1.7-41.4 4.6 2.9 18.6 2.2 36.7-10.9 50.3l19.5 5.5c-1.7 3.2-2.9 6.3-2.9 9.8 0 21 42.8 2.9 42.8 33.6 0 18.4-36.8 60.1-54.9 60.1-8 0-53.7-50-53.4-60.1l.3-4.6 52.3-11.5c13-2.6 12.3-22.7-2.9-22.7-3.7 0-43.1 9.2-49.4 10.6-2-5.2-7.5-14.1-13.8-14.1-3.2 0-6.3 3.2-9.5 4-9.2 2.6-31 2.9-21.5 20.1L15.9 298.5c-5.5 1.1-8.9 6.3-8.9 11.8 0 6 5.5 10.9 11.5 10.9 8 0 131.3-28.4 147.4-32.2 2.6 3.2 4.6 6.3 7.8 8.6 20.1 14.4 59.8 85.9 76.4 85.9 24.1 0 58-22.4 71.3-41.9 3.2-4.3 6.9-7.5 12.4-6.9 .6 13.8-31.6 34.2-33 43.7-1.4 10.2-1 35.2-.3 41.1 26.7 8.1 52-3.6 77.9-2.9 4.3-21 10.6-41.9 9.8-63.5l-.3-9.5c-1.4-34.2-10.9-38.5-34.8-58.6-1.1-1.1-2.6-2.6-3.7-4 2.2-1.4 1.1-1 4.6-1.7 88.5 0 56.3 183.6 111.5 229.9 33.1-15 72.5-27.9 103.5-47.2-29-25.6-52.6-45.7-72.7-79.9zM300.1 428.2l0 27.2 11.8-3.4-2.9-23.8-8.9 0zM231.4 277.8l24.1 61.2 21-13.8-31.3-50.9-13.8 3.5zm84.4 154.9l2 12.4c9-1.5 58.4-6.6 58.4-14.1 0-1.4-.6-3.2-.9-4.6-26.8 0-36.9 3.8-59.5 6.3z"],
    "letterboxd": [640, 512, [], "e62d", "M521.3 128C586.9 128 640 181.1 640 246.6S586.9 365.2 521.3 365.2c-42.5 0-79.7-22.3-100.7-55.8 11.4-18.2 18-39.7 18-62.8s-6.6-44.6-18-62.8l.8-1.2c20.8-32.3 56.8-53.9 97.9-54.6l2 0zM320 128c42.5 0 79.7 22.3 100.7 55.8-11.4 18.2-18 39.7-18 62.8s6.6 44.6 18 62.8l-.8 1.2c-20.8 32.3-56.8 53.9-97.9 54.6l-2 0c-42.5 0-79.7-22.3-100.7-55.8 11.4-18.2 18-39.7 18-62.8s-6.6-44.6-18-62.8l.8-1.2c20.8-32.3 56.8-53.9 97.9-54.6l2 0zm-201.3 0c42.5 0 79.7 22.3 100.7 55.8-11.4 18.2-18 39.7-18 62.8s6.6 44.6 18 62.8l-.8 1.2c-20.8 32.3-56.8 53.9-97.9 54.6l-2 0C53.1 365.1 0 312.1 0 246.6S53.1 128 118.7 128z"],
    "opera": [512, 512, [], "f26a", "M321.9 32.7c-170.2 0-252.6 223.8-147.5 355.1 36.5 45.4 88.6 75.6 147.5 75.6 36.3 0 70.3-11.1 99.4-30.4-43.8 39.2-101.9 63-165.3 63-3.9 0-8 0-11.9-.3-131.5-6.1-236.1-114.6-236.1-247.7 0-137 111-248 248-248l.8 0c63.1 .3 120.7 24.1 164.4 63.1-29-19.4-63.1-30.4-99.3-30.4zM423.7 430.4c-40.9 24.7-90.7 23.6-132-5.8 56.2-20.5 97.7-91.6 97.7-176.6 0-84.7-41.2-155.8-97.4-176.6 41.8-29.2 91.2-30.3 132.9-5 105.9 98.7 105.5 265.7-1.2 364z"],
    "weibo": [512, 512, [], "f18a", "M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7c-106.3 0-214.8-51.4-214.8-136.3 0-44.3 28-95.4 76.3-143.7 99.7-99.7 203.2-100.9 173.6-5.7-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zM358.5 300.4c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8 .3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4 .6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"],
    "readme": [576, 512, [], "f4d5", "M528.3 46.5l-139.8 0c-48.1 0-89.9 33.3-100.4 80.3-10.6-47-52.3-80.3-100.4-80.3L48 46.5C21.5 46.5 0 68 0 94.5L0 340.3c0 26.5 21.5 48 48 48l89.7 0c102.2 0 132.7 24.4 147.3 75 .7 2.8 5.2 2.8 6 0 14.7-50.6 45.2-75 147.3-75l89.7 0c26.5 0 48-21.5 48-48l0-245.7c0-26.4-21.3-47.9-47.7-48.1zM242 311.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zM501.3 311.8c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.9c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.9-.1 0zm0-60.9c0 1.9-1.5 3.5-3.5 3.5l-160.3 0c-1.9 0-3.5-1.5-3.5-3.5l0-22.8c0-1.9 1.5-3.5 3.5-3.5l160.4 0c1.9 0 3.5 1.5 3.5 3.5l0 22.8-.1 0z"],
    "golang": [640, 512, [], "e40f", "M400.1 194.8c-10.9 2.8-19.9 4.3-29.1 7.6-7.3 1.9-14.7 3.9-23.2 6.1l-.6 .1c-4.2 1.2-4.6 1.3-8.5-3.2-4.7-5.3-8.1-8.7-14.6-11.9-19.7-9.6-38.7-6.8-56.4 4.7-21.2 13.7-32.1 34-31.8 59.2 .3 25 17.4 45.5 41.2 48.9 22 2.8 39.8-4.6 53.8-20.5 2.1-2.6 4-5.3 6.1-8.3 .8-1 1.5-2.1 2.3-3.3l-60.1 0c-6.5 0-8.1-4-5.9-9.3 4-9.7 11.5-25.9 15.9-34 .9-1.8 3.1-5.8 6.9-5.8l101.1 0c4.5-13.4 11.8-26.9 21.6-39.7 22.7-29.9 49.3-45.5 87.2-52 31.8-5.6 61.7-2.5 88.9 15.9 24.6 16.8 39.8 39.6 43.9 69.5 5.3 42.1-6.9 76.3-36.7 105.6-19.7 20.9-44.9 34-73.9 39.9-5.6 1-11.1 1.5-16.5 2-2.9 .2-5.7 .5-8.5 .8-28.3-.6-54.2-8.7-76-27.4-15.3-13.3-25.9-29.6-31.1-48.5-3.7 7.3-8 14.4-14 21.1-21.6 29.6-50.9 48-87.9 52.9-30.6 4.1-58.9-1.8-83.9-20.5-23-17.5-36.1-40.5-39.5-69.2-4.1-34 5.9-65.4 26.4-91.3 22.2-29 51.5-47.4 87.3-53.9 29.3-6.2 57.3-1.9 82.6 15.3 16.5 10.9 28.3 25.8 36.1 43.9 1.9 2.8 .6 4.4-3.1 5.3zM48.3 200.4c-1.3 0-1.6-.6-.9-1.6l6.6-8.4c.6-.9 2.2-1.5 3.4-1.5l111.3 0c1.2 0 1.5 .9 .9 1.8l-5.3 8.1c-.6 1-2.2 1.9-3.1 1.9l-112.8-.3zM1.2 229.1c-1.2 0-1.6-.7-.9-1.6l6.5-8.4c.6-.9 2.2-1.6 3.4-1.6l142.1 0c1.2 0 1.8 1 1.5 1.9l-2.5 7.5c-.3 1.2-1.5 1.9-2.8 1.9L1.2 229.1zm74.5 26.8c-.6 .9-.3 1.8 .9 1.8l68 .3c.9 0 2.2-.9 2.2-2.1l.6-7.5c0-1.3-.6-2.2-1.9-2.2l-62.3 0c-1.2 0-2.5 .9-3.1 1.9l-4.4 7.8zm501.5-18c-.2-2.6-.3-4.8-.7-7-5.6-30.8-34-48.3-63.6-41.4-29 6.5-47.7 24.9-54.5 54.2-5.6 24.3 6.2 48.9 28.6 58.9 17.2 7.5 34.3 6.6 50.8-1.9 24.6-13.6 38-32.7 39.6-59.5-.1-1.2-.1-2.3-.2-3.3z"],
    "stack-exchange": [448, 512, [], "f18d", "M18.1 332.3l412.7 0 0 22c0 37.7-29.3 68-65.3 68l-19 0-86.8 89.7 0-89.7-176.3 0c-36 0-65.3-30.3-65.3-68l0-22zm0-23.6l412.7 0 0-85-412.7 0 0 85zm0-109.4l412.7 0 0-85-412.7 0 0 85zM365.4 0L83.4 0c-36 0-65.3 30.3-65.3 67.7l0 22.3 412.7 0 0-22.3C430.7 30.3 401.4 0 365.4 0z"],
    "gulp": [256, 512, [], "f3ae", "M210 391.1l-14.1 24.6-4.6 80.2c0 8.9-28.3 16.1-63.1 16.1s-63.1-7.2-63.1-16.1l-5.8-79.4-14.9-25.4c41.2 17.3 126 16.7 165.6 0zM14 137.8L27.6 263.3c5.9-20 20.8-47 40-55.2 6.3-2.7 12.7-2.7 18.7 .9 5.2 3 9.6 9.3 10.1 11.8 1.2 6.5-2 9.1-4.5 9.1-3 0-5.3-4.6-6.8-7.3-4.1-7.3-10.3-7.6-16.9-2.8-6.9 5-12.9 13.4-17.1 20.7-5.1 8.8-9.4 18.5-12 28.2-1.5 5.6-2.9 14.6-.6 19.9 1 2.2 2.5 3.6 4.9 3.6 5 0 12.3-6.6 15.8-10.1 4.5-4.5 10.3-11.5 12.5-16l5.2-15.5c2.6-6.8 9.9-5.6 9.9 0 0 10.2-3.7 13.6-10 34.7-5.8 19.5-7.6 25.8-7.6 25.8-.7 2.8-3.4 7.5-6.3 7.5-1.2 0-2.1-.4-2.6-1.2-1-1.4-.9-5.3-.8-6.3 .2-3.2 6.3-22.2 7.3-25.2-2 2.2-4.1 4.4-6.4 6.6-5.4 5.1-14.1 11.8-21.5 11.8-3.4 0-5.6-.9-7.7-2.4l7.6 79.6c2 5 39.2 17.1 88.2 17.1 49.1 0 86.3-12.2 88.2-17.1l10.9-94.6c-5.7 5.2-12.3 11.6-19.6 14.8-5.4 2.3-17.4 3.8-17.4-5.7 0-5.2 9.1-14.8 14.4-21.5 1.4-1.7 4.7-5.9 4.7-8.1 0-2.9-6-2.2-11.7 2.5-3.2 2.7-6.2 6.3-8.7 9.7-4.3 6-6.6 11.2-8.5 15.5-6.2 14.2-4.1 8.6-9.1 22-5 13.3-4.2 11.8-5.2 14-.9 1.9-2.2 3.5-4 4.5-1.9 1-4.5 .9-6.1-.3-.9-.6-1.3-1.9-1.3-3.7 0-.9 .1-1.8 .3-2.7 1.5-6.1 7.8-18.1 15-34.3 1.6-3.7 1-2.6 .8-2.3-6.2 6-10.9 8.9-14.4 10.5-5.8 2.6-13 2.6-14.5-4.1-.1-.4-.1-.8-.2-1.2-11.8 9.2-24.3 11.7-20-8.1-4.6 8.2-12.6 14.9-22.4 14.9-4.1 0-7.1-1.4-8.6-5.1-2.3-5.5 1.3-14.9 4.6-23.8 1.7-4.5 4-9.9 7.1-16.2 1.6-3.4 4.2-5.4 7.6-4.5 .6 .2 1.1 .4 1.6 .7 2.6 1.8 1.6 4.5 .3 7.2-3.8 7.5-7.1 13-9.3 20.8-.9 3.3-2 9 1.5 9 2.4 0 4.7-.8 6.9-2.4 4.6-3.4 8.3-8.5 11.1-13.5 2-3.6 4.4-8.3 5.6-12.3 .5-1.7 1.1-3.3 1.8-4.8 1.1-2.5 2.6-5.1 5.2-5.1 1.3 0 2.4 .5 3.2 1.5 1.7 2.2 1.3 4.5 .4 6.9-2 5.6-4.7 10.6-6.9 16.7-1.3 3.5-2.7 8-2.7 11.7 0 3.4 3.7 2.6 6.8 1.2 2.4-1.1 4.8-2.8 6.8-4.5 1.2-4.9 .9-3.8 26.4-68.2 1.3-3.3 3.7-4.7 6.1-4.7 1.2 0 2.2 .4 3.2 1.1 1.7 1.3 1.7 4.1 1 6.2-.7 1.9-.6 1.3-4.5 10.5-5.2 12.1-8.6 20.8-13.2 31.9-1.9 4.6-7.7 18.9-8.7 22.3-.6 2.2-1.3 5.8 1 5.8 5.4 0 19.3-13.1 23.1-17 .2-.3 .5-.4 .9-.6 .6-1.9 1.2-3.7 1.7-5.5 1.4-3.8 2.7-8.2 5.3-11.3 .8-1 1.7-1.6 2.7-1.6 2.8 0 4.2 1.2 4.2 4 0 1.1-.7 5.1-1.1 6.2 1.4-1.5 2.9-3 4.5-4.5 15-13.9 25.7-6.8 25.7 .2 0 7.4-8.9 17.7-13.8 23.4-1.6 1.9-4.9 5.4-5 6.4 0 1.3 .9 1.8 2.2 1.8 2 0 6.4-3.5 8-4.7 5-3.9 11.8-9.9 16.6-14.1l14.8-136.8c-30.5 17.1-197.6 17.2-228.3 .2zm229.7-8.5c0 21-231.2 21-231.2 0 0-8.8 51.8-15.9 115.6-15.9 9 0 17.8 .1 26.3 .4L167 65.1 228.3 .6c1.4-1.4 5.8-.2 9.9 3.5s6.6 7.9 5.3 9.3l-.1 .1-57.3 60.5-10 40.7c39.9 2.6 67.6 8.1 67.6 14.6zm-69.4 4.6c0-.8-.9-1.5-2.5-2.1l-.2 .8c0 1.3-5 2.4-11.1 2.4s-11.1-1.1-11.1-2.4c0-.1 0-.2 .1-.3l.2-.7c-1.8 .6-3 1.4-3 2.3 0 2.1 6.2 3.7 13.7 3.7 7.7 .1 13.9-1.6 13.9-3.7z"],
    "yelp": [384, 512, [], "f1e9", "M42.9 240.3l99.6 48.6c19.2 9.4 16.2 37.5-4.5 42.7L30.5 358.5c-3.2 .8-6.4 .9-9.6 .3s-6.2-1.8-8.9-3.7-4.9-4.3-6.6-7.1-2.7-5.9-3.1-9.2c-3.3-28.8-.2-57.9 9-85.3 1-3.1 2.7-5.9 4.9-8.3s4.9-4.2 7.9-5.5 6.2-1.8 9.5-1.8 6.4 .9 9.3 2.3zm44 239.3c23.8 16.3 50.9 27.3 79.4 32.1 3.2 .6 6.5 .4 9.6-.4s6.1-2.3 8.6-4.4 4.6-4.6 6-7.5 2.3-6.1 2.4-9.4l3.9-110.8c.7-21.3-25.5-31.9-39.8-16.1L82.8 445.5c-2.2 2.4-3.8 5.3-4.8 8.4s-1.3 6.4-.9 9.6 1.5 6.3 3.1 9.1 3.9 5.2 6.6 7l0 0zM232.2 369.7l58.8 94c1.7 2.8 4 5.1 6.8 6.9s5.8 3 9 3.5 6.5 .3 9.7-.5 6.1-2.4 8.6-4.4c22.3-18.4 40.3-41.5 52.7-67.6 1.4-2.9 2.1-6.1 2.2-9.4s-.6-6.5-1.9-9.4-3.2-5.7-5.6-7.8-5.2-3.9-8.3-4.9L258.7 335.7c-20.3-6.5-37.8 15.8-26.5 33.9zM380.6 237.4c-11.5-26.5-28.7-50.2-50.4-69.3-2.4-2.1-5.3-3.7-8.4-4.7s-6.4-1.2-9.6-.8-6.3 1.5-9.1 3.2-5.1 4-6.9 6.7l-62 91.9c-11.9 17.7 4.7 40.6 25.2 34.7L366 268.6c3.1-.9 6-2.5 8.5-4.6s4.5-4.7 5.8-7.7 2.1-6.2 2.2-9.4-.6-6.5-1.9-9.5l0 0zM62.1 30.2c-2.8 1.4-5.4 3.3-7.4 5.7s-3.6 5.2-4.5 8.2-1.2 6.2-.9 9.3 1.3 6.1 2.9 8.9L156.3 242.6c11.7 20.2 42.6 11.9 42.6-11.4l0-208.3c0-3.1-.6-6.3-1.8-9.2s-3.1-5.5-5.4-7.6-5-3.8-8-4.8-6.1-1.4-9.3-1.2c-39 3.1-77 13.3-112.3 30.1z"],
    "gofore": [448, 512, [], "f3a7", "M348 319.8l-13.2 0 0 34.7c-24.5 23.1-56.3 35.8-89.9 35.8-73.2 0-132.4-60.2-132.4-134.4 0-74.1 59.2-134.4 132.4-134.4 35.3 0 68.6 14 93.6 39.4l62.3-63.3c-41.8-42.3-97.1-65.6-156.1-65.6-122.7 0-220.7 100.6-220.7 224 0 122.5 97 224 220.7 224 63.2 0 124.5-26.2 171-82.5-2-27.6-13.4-77.7-67.7-77.7zM335.9 207.3l-106.3 0 0 89 118.4 0c33.5 0 60.5 15.1 76 41.8l0-30.6c0-65.2-40.4-100.2-88.1-100.2z"],
    "aviato": [640, 512, [], "f421", "M107.2 283.5l-19-41.8-52.1 0-19 41.8-17.1 0 62.2-131.4 62.2 131.4-17.2 0zm-45-98.1l-19.6 42.5 39.2 0-19.6-42.5zM174.9 287.8l-62.2-131.4 17.1 0 45.1 96 45.1-96 17 0-62.1 131.4zm80.6-4.3l0-127.1 15.5 0 0 127.1-15.5 0zM464.6 167.9l0 115.6-17.3 0 0-115.6-41.2 0 0-11.5 99.6 0 0 11.5-41.1 0zM640 218.8c0 9.2-1.7 17.8-5.1 25.8s-8.2 15.1-14.2 21.1-13.1 10.8-21.1 14.2-16.6 5.1-25.8 5.1-17.8-1.7-25.8-5.1-15.1-8.2-21.1-14.2-10.8-13-14.2-21.1c-3.4-8-5.1-16.6-5.1-25.8s1.7-17.8 5.1-25.8 8.2-15.1 14.2-21.1 13-8.4 21.1-11.9c8-3.4 16.6-5.1 25.8-5.1s17.8 1.7 25.8 5.1 15.1 5.8 21.1 11.9c6 6 10.7 13.1 14.2 21.1 3.4 8 5.1 16.6 5.1 25.8zm-15.5 0c0-7.3-1.3-14-3.9-20.3s-6.2-11.7-10.8-16.3-10-8.2-16.2-10.9-12.8-4-19.8-4-13.6 1.3-19.8 4-11.6 6.3-16.2 10.9-8.2 10-10.8 16.3-3.9 13.1-3.9 20.3c0 7.3 1.3 14 3.9 20.3s6.2 11.7 10.8 16.3 10 8.2 16.2 10.9 12.8 4 19.8 4 13.6-1.3 19.8-4 11.6-6.3 16.2-10.9 8.2-10 10.8-16.3 3.9-13.1 3.9-20.3zm-94.8 96.7l0-6.3 88.9-10-242.9 13.4c.6-2.2 1.1-4.6 1.4-7.2 .3-2 .5-4.2 .6-6.5l64.8-8.1-64.9 1.9c0-.4-.1-.7-.1-1.1-2.8-17.2-25.5-23.7-25.5-23.7l-1.1-26.3 23.8 0 19 41.8 17.1 0-62.2-131.4-62.2 131.4 17.1 0 19-41.8 23.6 0-1.1 26.4s-22.7 6.5-25.5 23.7c-.1 .3-.1 .7-.1 1.1l-64.9-1.9 64.8 8.1c.1 2.3 .3 4.4 .6 6.5 .3 2.6 .8 5 1.4 7.2l-242.9-13.5 88.9 10 0 6.3c-5.9 .9-10.5 6-10.5 12.2 0 6.8 5.6 12.4 12.4 12.4s12.4-5.6 12.4-12.4c0-6.2-4.6-11.3-10.5-12.2l0-5.8 80.3 9 0 5.4c-5.7 1.1-9.9 6.2-9.9 12.1 0 6.8 5.6 10.2 12.4 10.2s12.4-3.4 12.4-10.2c0-6-4.3-11-9.9-12.1l0-4.9 28.4 3.2 0 23.7-5.9 0 0 13.9 5.9 0 0-6.6 5 0 0 6.6 5.9 0 0-13.8-5.9 0 0-23.2 38.3 4.3c8.1 11.4 19 13.6 19 13.6l-.1 6.7-5.1 .2-.1 12.1 4.1 0 .1-5 5.2 0 .1 5 4.1 0-.1-12.1-5.1-.2-.1-6.7s10.9-2.1 19-13.6l38.3-4.3 0 23.2-5.9 0 0 13.8 5.9 0 0-6.6 5 0 0 6.6 5.9 0 0-13.8-5.9 0 0-23.7 28.4-3.2 0 4.9c-5.7 1.1-9.9 6.2-9.9 12.1 0 6.8 5.6 10.2 12.4 10.2s12.4-3.4 12.4-10.2c0-6-4.3-11-9.9-12.1l0-5.4 80.3-9 0 5.8c-5.9 .9-10.5 6-10.5 12.2 0 6.8 5.6 12.4 12.4 12.4s12.4-5.6 12.4-12.4c-.2-6.3-4.7-11.4-10.7-12.3zM328.9 227.9l19.6-42.5 19.6 42.5-17.9 0-1.7-40.3-1.7 40.3-17.9 0z"],
    "padlet": [640, 512, [], "e4a0", "M297.9 0l.1 0c7.6 .1 14.4 4.7 17.5 11.8l132 308.5 .3-.1 .2 .4-2.8 10-42.9 158c-3.7 16.2-19.7 26.3-35.8 22.6l-68.4-15.6-68.5 15.6c-16.1 3.7-32.1-6.4-35.8-22.6l-42.9-158-2.7-10 .1-.4 132.1-308.4c3-7 9.9-11.6 17.5-11.8zM160.1 322.1l131 39.1 6.9 122.5 7.9-121.5 130.6-39.3 .2-.1-131 25.1-8.6-320.2-5.2 320.2-131.8-25.8zM426 222.6l94.4-41 73.8 0-157 247.6 31.6-109-42.8-97.6zm171.5-41.2l41.4 76.2c4 7.5-3.9 15.9-11.6 12.2l-47.6-22.7 17.8-65.7zM127.3 318.5L158.7 430 1.6 154.5c-5.9-10.4 5.5-22 15.9-16.2l151.8 84.2-42.1 96z"],
    "edge-legacy": [448, 512, [], "e078", "M-6 228.2l.4-.5c0 .2 0 .3-.1 .5l-.3 0zm460.6 15.5c0-44-7.8-84.5-28.8-122.4-41-73.4-113.6-113.3-198.6-113.3-139.9-.3-218.3 105.2-232.8 219.7 42.4-61.3 117.1-121.4 220.4-125 0 0 109.7 0 99.4 105l-175.8 0c6.4-37.4 18.5-59 34.3-78.9-75 34.9-121.8 96.1-120.8 188.3 .8 71.5 50.1 144.8 120.8 172 83.4 31.8 192.8 7.2 240.1-21.3l0-104.4c-80.9 56.5-270.9 60.9-272.3-67.6l314.1 0 0-52.1z"],
    "square-lastfm": [448, 512, ["lastfm-square"], "f203", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM210.7 280.8c-1.8-5.5-3.4-10.8-5-15.9-12.9-41.9-21-68.4-58-68.4-22.4 0-45.1 16.1-45.1 61.2 0 35.2 18 57.2 43.3 57.2 28.6 0 47.6-21.3 47.6-21.3l11.7 31.9s-19.8 19.4-61.2 19.4c-51.3 0-79.9-30.1-79.9-85.8 0-57.9 28.6-92 82.5-92 67.9 0 79.3 35.3 96.4 88.4 1.4 4.4 2.9 8.9 4.4 13.5 8.8 26.8 24.2 46.2 61.2 46.2 24.9 0 38.1-5.5 38.1-19.1 0-17.5-16.9-21.2-40-26.4-3.2-.7-6.5-1.4-9.9-2.2-30.4-7.3-42.5-23.1-42.5-48 0-40 32.3-52.4 65.2-52.4 37.4 0 60.1 13.6 63 46.6l-36.7 4.4c-1.5-15.8-11-22.4-28.6-22.4-16.1 0-26 7.3-26 19.8 0 11 4.8 17.6 20.9 21.3 2.2 .5 4.5 1 6.7 1.4 31.1 6.5 65.1 13.7 65.1 56.1 .1 36.7-30.7 50.6-76.1 50.6-63.4 0-85.4-28.6-97.1-64.1z"],
    "goodreads-g": [320, 512, [], "f3a9", "M10.8 403.3l2.8 0c12.7 0 25.5 0 38.2 .1 1.6 0 3.1-.4 3.6 2.1 7.1 34.9 30 54.6 62.9 63.9 26.9 7.6 54.1 7.8 81.3 1.8 33.8-7.4 56-28.3 68-60.4 8-21.5 10.7-43.8 11-66.5 .1-5.8 .3-47-.2-52.8l-.9-.3c-.8 1.5-1.7 2.9-2.5 4.4-22.1 43.1-61.3 67.4-105.4 69.1-103 4-169.4-57-172-176.2-.5-23.7 1.8-46.9 8.3-69.7 20.6-71.1 74.6-118.2 153.9-118.8 61.3-.4 101.5 38.7 116.2 70.3 .5 1.1 1.3 2.3 2.4 1.9l0-61.6 44.3 0c0 280.3 .1 332.2 .1 332.2-.1 78.5-26.7 143.7-103 162.2-69.5 16.9-159 4.8-196-57.2-8-13.5-11.8-28.3-13-44.5zM157.1 36.5c-52.5-.5-108.5 40.7-115 133.8-4.1 59 14.8 122.2 71.5 148.6 27.6 12.9 74.3 15 108.3-8.7 47.6-33.2 62.7-97 54.8-154-9.7-71.1-47.8-120-119.6-119.7z"],
    "cc-mastercard": [576, 512, [], "f1f1", "M482.9 410.3c0 6.8-4.6 11.7-11.2 11.7-6.8 0-11.2-5.2-11.2-11.7s4.4-11.7 11.2-11.7c6.6 0 11.2 5.2 11.2 11.7zM172.1 398.6c-7.1 0-11.2 5.2-11.2 11.7S165 422 172.1 422c6.5 0 10.9-4.9 10.9-11.7-.1-6.5-4.4-11.7-10.9-11.7zm117.5-.3c-5.4 0-8.7 3.5-9.5 8.7l19.1 0c-.9-5.7-4.4-8.7-9.6-8.7zm107.8 .3c-6.8 0-10.9 5.2-10.9 11.7s4.1 11.7 10.9 11.7 11.2-4.9 11.2-11.7c0-6.5-4.4-11.7-11.2-11.7zm105.9 26.1c0 .3 .3 .5 .3 1.1 0 .3-.3 .5-.3 1.1-.3 .3-.3 .5-.5 .8-.3 .3-.5 .5-1.1 .5-.3 .3-.5 .3-1.1 .3-.3 0-.5 0-1.1-.3-.3 0-.5-.3-.8-.5-.3-.3-.5-.5-.5-.8-.3-.5-.3-.8-.3-1.1 0-.5 0-.8 .3-1.1 0-.5 .3-.8 .5-1.1 .3-.3 .5-.3 .8-.5 .5-.3 .8-.3 1.1-.3 .5 0 .8 0 1.1 .3 .5 .3 .8 .3 1.1 .5s.2 .6 .5 1.1zm-2.2 1.4c.5 0 .5-.3 .8-.3 .3-.3 .3-.5 .3-.8s0-.5-.3-.8c-.3 0-.5-.3-1.1-.3l-1.6 0 0 3.5 .8 0 0-1.4 .3 0 1.1 1.4 .8 0-1.1-1.3zM576 81l0 352c0 26.5-21.5 48-48 48L48 481c-26.5 0-48-21.5-48-48L0 81C0 54.5 21.5 33 48 33l480 0c26.5 0 48 21.5 48 48zM64 220.6c0 76.5 62.1 138.5 138.5 138.5 27.2 0 53.9-8.2 76.5-23.1-72.9-59.3-72.4-171.2 0-230.5-22.6-15-49.3-23.1-76.5-23.1-76.4-.1-138.5 62-138.5 138.2zM288 329.4c70.5-55 70.2-162.2 0-217.5-70.2 55.3-70.5 162.6 0 217.5zM145.7 405.7c0-8.7-5.7-14.4-14.7-14.7-4.6 0-9.5 1.4-12.8 6.5-2.4-4.1-6.5-6.5-12.2-6.5-3.8 0-7.6 1.4-10.6 5.4l0-4.4-8.2 0 0 36.7 8.2 0c0-18.9-2.5-30.2 9-30.2 10.2 0 8.2 10.2 8.2 30.2l7.9 0c0-18.3-2.5-30.2 9-30.2 10.2 0 8.2 10 8.2 30.2l8.2 0 0-23-.2 0zM190.6 392l-7.9 0 0 4.4c-2.7-3.3-6.5-5.4-11.7-5.4-10.3 0-18.2 8.2-18.2 19.3 0 11.2 7.9 19.3 18.2 19.3 5.2 0 9-1.9 11.7-5.4l0 4.6 7.9 0 0-36.8zm40.5 25.6c0-15-22.9-8.2-22.9-15.2 0-5.7 11.9-4.8 18.5-1.1l3.3-6.5c-9.4-6.1-30.2-6-30.2 8.2 0 14.3 22.9 8.3 22.9 15 0 6.3-13.5 5.8-20.7 .8l-3.5 6.3c11.2 7.6 32.6 6 32.6-7.5zm35.4 9.3l-2.2-6.8c-3.8 2.1-12.2 4.4-12.2-4.1l0-16.6 13.1 0 0-7.4-13.1 0 0-11.2-8.2 0 0 11.2-7.6 0 0 7.3 7.6 0 0 16.7c0 17.6 17.3 14.4 22.6 10.9zm13.3-13.4l27.5 0c0-16.2-7.4-22.6-17.4-22.6-10.6 0-18.2 7.9-18.2 19.3 0 20.5 22.6 23.9 33.8 14.2l-3.8-6c-7.8 6.4-19.6 5.8-21.9-4.9zM338.9 392c-4.6-2-11.6-1.8-15.2 4.4l0-4.4-8.2 0 0 36.7 8.2 0 0-20.7c0-11.6 9.5-10.1 12.8-8.4l2.4-7.6zm10.6 18.3c0-11.4 11.6-15.1 20.7-8.4l3.8-6.5c-11.6-9.1-32.7-4.1-32.7 15 0 19.8 22.4 23.8 32.7 15l-3.8-6.5c-9.2 6.5-20.7 2.6-20.7-8.6zM416.2 392l-8.2 0 0 4.4c-8.3-11-29.9-4.8-29.9 13.9 0 19.2 22.4 24.7 29.9 13.9l0 4.6 8.2 0 0-36.8zm33.7 0c-2.4-1.2-11-2.9-15.2 4.4l0-4.4-7.9 0 0 36.7 7.9 0 0-20.7c0-11 9-10.3 12.8-8.4l2.4-7.6zm40.3-14.9l-7.9 0 0 19.3c-8.2-10.9-29.9-5.1-29.9 13.9 0 19.4 22.5 24.6 29.9 13.9l0 4.6 7.9 0 0-51.7zm7.6-75.1l0 4.6 .8 0 0-4.6 1.9 0 0-.8-4.6 0 0 .8 1.9 0zm6.6 123.8c0-.5 0-1.1-.3-1.6-.3-.3-.5-.8-.8-1.1s-.8-.5-1.1-.8c-.5 0-1.1-.3-1.6-.3-.3 0-.8 .3-1.4 .3-.5 .3-.8 .5-1.1 .8-.5 .3-.8 .8-.8 1.1-.3 .5-.3 1.1-.3 1.6 0 .3 0 .8 .3 1.4 0 .3 .3 .8 .8 1.1 .3 .3 .5 .5 1.1 .8 .5 .3 1.1 .3 1.4 .3 .5 0 1.1 0 1.6-.3 .3-.3 .8-.5 1.1-.8s.5-.8 .8-1.1c.3-.6 .3-1.1 .3-1.4zm3.2-124.7l-1.4 0-1.6 3.5-1.6-3.5-1.4 0 0 5.4 .8 0 0-4.1 1.6 3.5 1.1 0 1.4-3.5 0 4.1 1.1 0 0-5.4zm4.4-80.5c0-76.2-62.1-138.3-138.5-138.3-27.2 0-53.9 8.2-76.5 23.1 72.1 59.3 73.2 171.5 0 230.5 22.6 15 49.5 23.1 76.5 23.1 76.4 .1 138.5-61.9 138.5-138.4z"],
    "discourse": [448, 512, [], "f393", "M225.9 32C103.3 32 0 130.5 0 252.1 0 256 .1 480 .1 480l225.8-.2C348.6 479.8 448 377.5 448 255.9S348.6 32 225.9 32zM224 384c-19.4 0-37.9-4.3-54.4-12.1L88.5 392 111.4 317c-9.8-18.1-15.4-38.9-15.4-61 0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128z"],
    "black-tie": [448, 512, [], "f27e", "M0 32l0 448 448 0 0-448-448 0zM316.5 357.2l-92.5 88.7-92.5-88.7 64.5-184-64.5-86.6 184.9 0-64.4 86.6 64.5 184z"],
    "square-facebook": [448, 512, ["facebook-square"], "f082", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l98.2 0 0-145.8-52.8 0 0-78.2 52.8 0 0-33.7c0-87.1 39.4-127.5 125-127.5 16.2 0 44.2 3.2 55.7 6.4l0 70.8c-6-.6-16.5-1-29.6-1-42 0-58.2 15.9-58.2 57.2l0 27.8 83.6 0-14.4 78.2-69.3 0 0 145.8 129 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"],
    "battle-net": [512, 512, [], "f835", "M448.8 225.6c26.9 .2 35.6-7.4 38.9-12.4 12.5-16.3-7.1-47.6-52.8-71.3 17.8-33.6 30.1-63.7 36.3-85.3 3.4-11.8 1.1-19 .5-20.3-1.7 10.5-15.8 48.5-48.2 100-25-11.2-56.5-20.1-93.8-23.8-8.9-16.9-34.9-63.9-60.5-88.9-16.8-16.5-30.3-22.6-40.8-23.5l0 0c-13.8-1.6-22.7 5.8-27.4 11-17.2 18.5-24.3 48.9-25 84.1-7.2-12.3-17.2-24.6-28.5-25.9l-.2 0c-20.7-3.5-38.4 29.2-36 81.3-38.4 1.4-71 5.8-93 11.2-9.9 2.4-16.2 7.3-17.8 9.7 1-.4 22.4-9.2 111.6-9.2 5.2 53 29.8 101.8 26 93.2-9.7 15.4-38.2 62.4-47.3 97.7-5.9 22.9-4.4 37.6 .2 47.1 5.6 12.8 16.4 16.7 23.2 18.3 25 5.7 55.4-3.6 86.7-21.1-7.5 12.8-13.9 28.5-9.1 39.3 7.3 19.6 44.5 18.7 88.4-9.4 20.2 32.2 40.1 57.9 55.7 74.1 2.6 2.8 5.5 5.2 8.8 7.1 5.1 3.2 8.6 3.4 8.6 3.4-8.2-6.7-34-38-62.5-91.8 22.2-16 45.7-38.9 67.5-69.3 122.8 4.6 143.3-24.8 148-31.6 14.7-19.9 3.4-57.4-57.3-93.7zM371 331.8c23.8-37.7 30.3-67.8 29.4-92.3 27.9 17.6 47.2 37.6 49.1 58.8 1.1 12.9-8.1 29.1-78.5 33.5zM217.1 387.7c9.8-6.2 19.5-13.1 29.2-20.5 6.7 13.3 13.6 26.1 20.6 38.2-40.6 21.9-68.8 12.8-49.8-17.7zm215-171.3c-10.3-5.3-21.2-10.3-32.4-15 7.9-12.1 15.5-24.4 22.7-36.9 39.1 24.1 45.9 53.2 9.6 51.9zM279.4 398c-5.5-11.4-11-23.5-16.5-36.4 43.2 1.3 62.4-18.7 63.3-20.4 0 .1-25 15.6-62.5 12.2 30.6-25.6 59.1-53.7 85.1-84 8.7-10.2 17-20.6 24.9-31.1-.4-.3-1.5-3-16.5-12-51.7 60.3-102.3 98-132.8 115.9-20.6-11.2-40.8-31.8-55.7-61.5-20-39.9-30-82.4-31.6-116.1 12.3 .9 25.3 2.2 38.8 3.9-22.3 36.8-14.4 63-13.5 64.2 0-.1-1-29.2 20.1-59.6 9 52.5 24 103.8 44.7 152.8 .9-.4 1.8 .9 18.7-8.2-26.3-74.5-33.8-138.2-34-173.4 20-12.4 48.2-19.8 81.6-17.8 44.6 2.7 86.4 15.2 116.3 30.7-7.1 10.4-14.9 21.3-23.3 32.5-20.7-37.7-47.3-43.9-48.9-43.7 .1 0 25.9 14.1 41.5 47.2-37.5-13.8-76.1-24.4-115.3-31.7-13.1-2.4-26.2-4.4-39.4-6-.1 .4-1.8 1.8-2.2 20.3 77.9 14.5 136.6 39.9 167.2 57.2 .7 23.6-7 51.6-25.4 79.6-24.6 37.3-56.4 67.2-84.8 85.4zm27.4-287c-44.6-1.7-73.6 7.4-94.7 20.7 2-52.3 21.3-76.4 38.2-75.3 16.9-4.2 54.9 52.2 56.5 54.6zm-130.7 3.1c.5 12.1 1.6 24.6 3.2 37.3-14.6-.9-28.7-1.3-42.4-1.3-.1 3.2-.1-51 24.7-49.6l.1 0c5.8 1.1 10.6 6.9 14.4 13.6zm-28.1 162c20.8 39.7 43.3 60.6 65.3 72.3-46.8 24.8-77.5 20-84.9 4.5-.2-.2-11.1-15.3 19.7-76.8l0 0z"],
    "bimobject": [448, 512, [], "f378", "M416 32L32 32C14.4 32 0 46.4 0 64L0 448c0 17.6 14.4 32 32 32l384 0c17.6 0 32-14.4 32-32l0-384c0-17.6-14.4-32-32-32zM352 289.4c0 49.4-11.4 82.6-103.8 82.6l-16.9 0c-44.1 0-62.4-14.9-70.4-38.8l-.9 0 0 34.8-64 0 0-232 64 0 0 74.7 1.1 0c4.6-30.5 39.7-38.8 69.7-38.8l17.3 0c92.4 0 103.8 33.1 103.8 82.5l0 35 .1 0zm-64-28.9l0 22.9c0 21.7-3.4 33.8-38.4 33.8l-45.3 0c-28.9 0-44.1-6.5-44.1-35.7l0-19c0-29.3 15.2-35.7 44.1-35.7l45.3 0c35-.2 38.4 12 38.4 33.7z"]
  };

  bunker(function () {
    defineIcons('fab', icons);
    defineIcons('fa-brands', icons);
  });

}());
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _so;
  var z = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      }
    };
  var a = "classic",
    o = "duotone",
    d = "sharp",
    t = "sharp-duotone",
    i = "chisel",
    n = "etch",
    h = "jelly",
    s = "jelly-duo",
    f = "jelly-fill",
    g = "notdog",
    l = "notdog-duo",
    u = "slab",
    p = "slab-press",
    e = "thumbprint",
    w = "whiteboard",
    m = "Classic",
    y = "Duotone",
    x = "Sharp",
    c = "Sharp Duotone",
    I = "Chisel",
    b = "Etch",
    F = "Jelly",
    v = "Jelly Duo",
    S = "Jelly Fill",
    A = "Notdog",
    P = "Notdog Duo",
    j = "Slab",
    B = "Slab Press",
    N = "Thumbprint",
    k = "Whiteboard",
    so = (_so = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, a, m), o, y), d, x), t, c), i, I), n, b), h, F), s, v), f, S), g, A), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, l, P), u, j), p, B), e, N), w, k));
  var io = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      }
    };
  var Ro = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var Oo = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Go = ["kit"];
  var D = "kit",
    r = "kit-duotone",
    T = "Kit",
    C = "Kit Duotone",
    qo = _defineProperty(_defineProperty({}, D, T), r, C);
  var Xo = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var et = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var dt = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _fl;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var f$1 = "classic",
    a$1 = "duotone",
    n$1 = "sharp",
    t$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    u$1 = "jelly",
    s$1 = "jelly-duo",
    p$1 = "jelly-fill",
    y$1 = "notdog",
    e$1 = "notdog-duo",
    m$1 = "slab",
    c$1 = "slab-press",
    r$1 = "thumbprint",
    w$1 = "whiteboard",
    x$1 = "Classic",
    I$1 = "Duotone",
    b$1 = "Sharp",
    F$1 = "Sharp Duotone",
    v$1 = "Chisel",
    S$1 = "Etch",
    A$1 = "Jelly",
    j$1 = "Jelly Duo",
    P$1 = "Jelly Fill",
    B$1 = "Notdog",
    k$1 = "Notdog Duo",
    N$1 = "Slab",
    D$1 = "Slab Press",
    C$1 = "Thumbprint",
    T$1 = "Whiteboard",
    fl = (_fl = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, f$1, x$1), a$1, I$1), n$1, b$1), t$1, F$1), h$1, v$1), g$1, S$1), u$1, A$1), s$1, j$1), p$1, P$1), y$1, B$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, e$1, k$1), m$1, N$1), c$1, D$1), r$1, C$1), w$1, T$1));
  var L = "kit",
    d$1 = "kit-duotone",
    R$1 = "Kit",
    W$1 = "Kit Duotone",
    lo$1 = _defineProperty(_defineProperty({}, L, R$1), d$1, W$1);
  var zo$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      }
    },
    J$1 = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"]
    },
    Go$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      }
    },
    _$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    K$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    M$1 = K$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    O$1 = ["aw", "fw", "pull-left", "pull-right"],
    Ho$1 = [].concat(_toConsumableArray(Object.keys(J$1)), _$1, O$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(K$1.map(function (o) {
      return "".concat(o, "x");
    })).concat(M$1.map(function (o) {
      return "w-".concat(o);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[a];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, z);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), z[a]), Oo['kit']), Oo['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, Ro);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[a]), dt['kit']), dt['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Go$1);
  _PREFIX_TO_LONG_STYLE[a] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[a]), et['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, zo$1);
  _LONG_STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[a]), Xo['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, io);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Go), _toConsumableArray(Ho$1));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM136 232l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "calendar-check": [448, 512, [], "f274", "M328 0c13.3 0 24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24zM64 112c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 112zm230.7 65.9c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L211.4 374.1c-4.1 5.7-10.5 9.3-17.5 9.8-7 .5-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l36 36 105.6-145.2z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 0l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-96-48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M64 48l224 0c8.8 0 16 7.2 16 16l0 48 48 0 0-48c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-48-112 0c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zm176 72c0-13.3-10.7-24-24-24L104 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l105.6 0c8.8-8.6 19-15.8 30.2-21.1 .1-.9 .2-1.9 .2-2.9zM448 464l-160 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l101.5 0c4.2 0 8.3 1.7 11.3 4.7l58.5 58.5c3 3 4.7 7.1 4.7 11.3L464 448c0 8.8-7.2 16-16 16zM224 224l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-165.5c0-17-6.7-33.3-18.7-45.3l-58.5-58.5c-12-12-28.3-18.7-45.3-18.7L288 160c-35.3 0-64 28.7-64 64z"],
    "hand-point-left": [512, 512, [], "f0a5", "M64 128l177.6 0c-1 5.2-1.6 10.5-1.6 16l0 16-176 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm224 16c0-17.7 14.3-32 32-32l24 0c66.3 0 120 53.7 120 120l0 48c0 52.5-33.7 97.1-80.7 113.4 .5-3.1 .7-6.2 .7-9.4 0-20-9.2-37.9-23.6-49.7 4.9-9 7.6-19.4 7.6-30.3 0-15.1-5.3-29-14-40 8.8-11 14-24.9 14-40l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80zm32-80l0 0c-18 0-34.6 6-48 16L64 80C28.7 80 0 108.7 0 144s28.7 64 64 64l82 0c-1.3 5.1-2 10.5-2 16 0 25.3 14.7 47.2 36 57.6-2.6 7-4 14.5-4 22.4 0 20 9.2 37.9 23.6 49.7-4.9 9-7.6 19.4-7.6 30.3 0 35.3 28.7 64 64 64l88 0c92.8 0 168-75.2 168-168l0-48c0-92.8-75.2-168-168-168l-24 0zM256 400c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0zM240 224c0 5.5 .7 10.9 2 16l-34 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0 16zm24 64l40 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l24 0z"],
    "file-excel": [384, 512, [], "f1c3", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm99.2 265.6c-8-10.6-23-12.8-33.6-4.8s-12.8 23-4.8 33.6L162 344 124.8 393.6c-8 10.6-5.8 25.6 4.8 33.6s25.6 5.8 33.6-4.8L192 384 220.8 422.4c8 10.6 23 12.8 33.6 4.8s12.8-23 4.8-33.6L222 344 259.2 294.4c8-10.6 5.8-25.6-4.8-33.6s-25.6-5.8-33.6 4.8L192 304 163.2 265.6z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M61.4 64C27.5 64 0 91.5 0 125.4 0 126.3 0 127.1 .1 128L0 128 0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256-.1 0c0-.9 .1-1.7 .1-2.6 0-33.9-27.5-61.4-61.4-61.4L61.4 64zM464 192.3L464 384c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-191.7 154.8 117.4c31.4 23.9 74.9 23.9 106.4 0L464 192.3zM48 125.4C48 118 54 112 61.4 112l389.2 0c7.4 0 13.4 6 13.4 13.4 0 4.2-2 8.2-5.3 10.7L280.2 271.5c-14.3 10.8-34.1 10.8-48.4 0L53.3 136.1c-3.3-2.5-5.3-6.5-5.3-10.7z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M384 432c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0zm64-16c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320zM224 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9S110.5 192 120 192l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"],
    "truck": [576, 512, [128666, 9951], "f0d1", "M64 80c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l3.3 0c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64l102.6 0c4.9-17.4 15.1-32.7 28.7-43.9L368 96c0-8.8-7.2-16-16-16L64 80zm3.3 368L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 55.4 0c17 0 33.3 6.7 45.3 18.7l40.6 40.6c12 12 18.7 28.3 18.7 45.3L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64zM416 256l112 0 0-23.4c0-4.2-1.7-8.3-4.7-11.3l-40.6-40.6c-3-3-7.1-4.7-11.3-4.7l-55.4 0 0 80zm0 48l0 32.4c2.6-.2 5.3-.4 8-.4 40.3 0 74.2 27.1 84.7 64l3.3 0c8.8 0 16-7.2 16-16l0-80-112 0zM152 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm272 0a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "bell": [448, 512, [128276, 61602], "f0f3", "M224 0c-13.3 0-24 10.7-24 24l0 9.7C118.6 45.3 56 115.4 56 200l0 14.5c0 37.7-10 74.7-29 107.3L5.1 359.2C1.8 365 0 371.5 0 378.2 0 399.1 16.9 416 37.8 416l372.4 0c20.9 0 37.8-16.9 37.8-37.8 0-6.7-1.8-13.3-5.1-19L421 321.7c-19-32.6-29-69.6-29-107.3l0-14.5c0-84.6-62.6-154.7-144-166.3l0-9.7c0-13.3-10.7-24-24-24zM392.4 368l-336.9 0 12.9-22.1C91.7 306 104 260.6 104 214.5l0-14.5c0-66.3 53.7-120 120-120s120 53.7 120 120l0 14.5c0 46.2 12.3 91.5 35.5 131.4L392.4 368zM156.1 464c9.9 28 36.6 48 67.9 48s58-20 67.9-48l-135.8 0z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M203.7 512.9s0 0 0 0l-37.8 26.7c-7.3 5.2-16.9 5.8-24.9 1.7S128 529 128 520l0-72-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0-91.9 64.9zm64.3-104.1c8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM134.1 153.9l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zm192 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zM256 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zM384 432c8.8 0 16-7.2 16-16l0-64-88 0 0 80 72 0zm16-128l0-80-88 0 0 80 88 0zm-136 0l0-80-80 0 0 80 80 0zm-128 0l0-80-88 0 0 80 88 0zM48 352l0 64c0 8.8 7.2 16 16 16l72 0 0-80-88 0zm136 0l0 80 80 0 0-80-80 0zM120 112l-56 0c-8.8 0-16 7.2-16 16l0 48 352 0 0-48c0-8.8-7.2-16-16-16l-264 0z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M64 64l0 177.6c5.2-1 10.5-1.6 16-1.6l16 0 0-176c0-8.8-7.2-16-16-16S64 55.2 64 64zM80 288c-17.7 0-32 14.3-32 32l0 24c0 66.3 53.7 120 120 120l48 0c52.5 0 97.1-33.7 113.4-80.7-3.1 .5-6.2 .7-9.4 .7-20 0-37.9-9.2-49.7-23.6-9 4.9-19.4 7.6-30.3 7.6-15.1 0-29-5.3-40-14-11 8.8-24.9 14-40 14l-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0zM0 320l0 0c0-18 6-34.6 16-48L16 64C16 28.7 44.7 0 80 0s64 28.7 64 64l0 82c5.1-1.3 10.5-2 16-2 25.3 0 47.2 14.7 57.6 36 7-2.6 14.5-4 22.4-4 20 0 37.9 9.2 49.7 23.6 9-4.9 19.4-7.6 30.3-7.6 35.3 0 64 28.7 64 64l0 88c0 92.8-75.2 168-168 168l-48 0C75.2 512 0 436.8 0 344l0-24zm336-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM160 240c5.5 0 10.9 .7 16 2l0-34c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32 16 0zm64 24l0 40c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24z"],
    "hand-lizard": [512, 512, [], "f258", "M72 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0c4.5 0 8.9 1.3 12.7 3.6l64 40c7 4.4 11.3 12.1 11.3 20.4l0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-10.7-46.9-29.3-145.1 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l104 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L72 208c-39.8 0-72-32.2-72-72S32.2 64 72 64l209.6 0c46.7 0 90.9 21.5 119.7 58.3l78.4 100.1c20.9 26.7 32.3 59.7 32.3 93.7L512 424c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-107.9c0-23.2-7.8-45.8-22.1-64.1L363.5 151.9c-19.7-25.2-49.9-39.9-81.9-39.9L72 112z"],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", "M448 48c8.8 0 16 7.2 16 16l0 384c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l384 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144z"],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", "M64 80c-8.8 0-16 7.2-16 16l0 162c5.1-1.3 10.5-2 16-2l320 0c5.5 0 10.9 .7 16 2l0-162c0-8.8-7.2-16-16-16L64 80zM48 320l0 96c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L64 304c-8.8 0-16 7.2-16 16zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm216 48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM80 104c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24zm0 80c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24zm64 56l-32 0c-17.7 0-32 14.3-32 32l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-17.7-14.3-32-32-32zm-16 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-242.7c0-4.2-1.7-8.3-4.7-11.3L320 86.6 320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-96-32 0zm80 0l0 80 128 0 0-80-128 0zM0 96C0 60.7 28.7 32 64 32l242.7 0c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM160 320a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M464 256c0-114.9-93.1-208-208-208S48 141.1 48 256c0 75.9 40.7 142.4 101.5 178.7-3.6-10.9-5.5-22.6-5.5-34.7l0-37.5c-10.2-12.6-18.3-26.9-23.8-42.4-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8-5.5 15.6-13.6 29.9-23.8 42.5l0 37.5c0 12.1-1.9 23.8-5.5 34.7 60.8-36.3 101.5-102.7 101.5-178.7zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm125.8-75.7c-6.2-5.2-7.6-14.3-3.1-21.1s13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3zm263.6-21.1c4.5 6.8 3.1 15.9-3.1 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5zM320 416l0-37.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 37.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M193.1 32c-18.7 0-36.2 9.4-46.6 24.9L120.5 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-56.5 0-26-39.1C355.1 41.4 337.6 32 318.9 32L193.1 32zm-6.7 51.6c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l69.3 0c8 0 15.5-4 20-10.7l33.2-49.8zM256 384a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM192 272a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M0 256c0-29.6 5-57.9 14.2-84.4l17.3 16.9-4.6 27c-4.2 24.4 5.6 46.2 22 59.9 9.8 105.8 98.8 188.7 207.1 188.7s197.4-82.8 207.1-188.6c16.4-13.7 26.1-35.4 22-59.9l-4.6-27 17.3-16.9c9.2 26.4 14.2 54.8 14.2 84.4 0 141.4-114.6 256-256 256S0 397.4 0 256zM256 48c-15.2 0-30 1.6-44.3 4.7L201.4 31.8C197 23 191.1 15.8 184.2 10.2 207 3.6 231.1 0 256 0s49 3.6 71.8 10.2C320.9 15.8 315 23 310.6 31.8L300.3 52.7C286 49.6 271.2 48 256 48zM372.2 302.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM353.7 53.1c5.9-11.9 22.8-11.9 28.7 0l23.3 47.2 52 7.6c13.1 1.9 18.4 18 8.9 27.3l-37.7 36.7 8.9 51.8c2.2 13.1-11.5 23-23.2 16.9L368 216 321.5 240.5c-11.7 6.2-25.5-3.8-23.2-16.9l8.9-51.8-37.7-36.7c-9.5-9.3-4.3-25.4 8.9-27.3l52-7.6 23.3-47.2zm-195.3 0l23.3 47.2 52 7.6c13.1 1.9 18.4 18 8.9 27.3l-37.7 36.7 8.9 51.8c2.2 13.1-11.5 23-23.2 16.9L144 216 97.5 240.5c-11.7 6.2-25.5-3.8-23.2-16.9l8.9-51.8-37.7-36.7c-9.5-9.3-4.3-25.4 8.9-27.3l52-7.6 23.3-47.2c5.9-11.9 22.8-11.9 28.7 0z"],
    "eye": [576, 512, [128065], "f06e", "M288 80C222.8 80 169.2 109.6 128.1 147.7 89.6 183.5 63 226 49.4 256 63 286 89.6 328.5 128.1 364.3 169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256 513 226 486.4 183.5 447.9 147.7 406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1 3.3 7.9 3.3 16.7 0 24.6-14.9 35.7-46.2 87.7-93 131.1-47.1 43.7-111.8 80.6-192.6 80.6S142.5 443.2 95.4 399.4c-46.8-43.5-78.1-95.4-93-131.1-3.3-7.9-3.3-16.7 0-24.6 14.9-35.7 46.2-87.7 93-131.1zM288 336c44.2 0 80-35.8 80-80 0-29.6-16.1-55.5-40-69.3-1.4 59.7-49.6 107.9-109.3 109.3 13.8 23.9 39.7 40 69.3 40zm-79.6-88.4c2.5 .3 5 .4 7.6 .4 35.3 0 64-28.7 64-64 0-2.6-.2-5.1-.4-7.6-37.4 3.9-67.2 33.7-71.1 71.1zm45.6-115c10.8-3 22.2-4.5 33.9-4.5 8.8 0 17.5 .9 25.8 2.6 .3 .1 .5 .1 .8 .2 57.9 12.2 101.4 63.7 101.4 125.2 0 70.7-57.3 128-128 128-61.6 0-113-43.5-125.2-101.4-1.8-8.6-2.8-17.5-2.8-26.6 0-11 1.4-21.8 4-32 .2-.7 .3-1.3 .5-1.9 11.9-43.4 46.1-77.6 89.5-89.5z"],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", "M464 256c0-114.9-93.1-208-208-208S48 141.1 48 256c0 41.8 12.3 80.7 33.6 113.3 8.2 44.7 47.3 78.6 94.3 78.7 24.7 10.3 51.7 16 80.1 16 114.9 0 208-93.1 208-208zM288 352c-5.5 0-10.9 .6-16 1.8 0-.6 0-1.2 0-1.8 0-16.2-4-31.5-11.1-44.9 8.7-2 17.8-3.1 27.1-3.1 40.2 0 75.7 19.8 97.5 50 7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm176-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM185.4 276.8c6.5 7.8 12.6 16.1 18.3 24.6 9 13.4 20.3 30.2 20.3 47.4 0 28.3-21.5 51.2-48 51.2s-48-22.9-48-51.2c0-17.2 11.2-34 20.3-47.4 5.7-8.5 11.9-16.7 18.3-24.6 2.4-2.9 5.7-4.8 9.4-4.8s7 1.9 9.4 4.8z"],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", "M425.5 7c-6.9-6.9-17.2-8.9-26.2-5.2S384.5 14.3 384.5 24l0 56-48 0c-88.4 0-160 71.6-160 160 0 46.7 20.7 80.4 43.6 103.4 8.1 8.2 16.5 14.9 24.3 20.4 9.2 6.5 21.7 5.7 30.1-1.9s10.2-20 4.5-29.8c-3.6-6.3-6.5-14.9-6.5-26.7 0-36.2 29.3-65.5 65.5-65.5l46.5 0 0 56c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l136-136c9.4-9.4 9.4-24.6 0-33.9L425.5 7zm7 97l0-22.1 78.1 78.1-78.1 78.1 0-22.1c0-13.3-10.7-24-24-24L338 192c-50.9 0-93.9 33.5-108.3 79.6-3.3-9.4-5.2-19.8-5.2-31.6 0-61.9 50.1-112 112-112l72 0c13.3 0 24-10.7 24-24zm-320-8c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0z"],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", "M240 432L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 176-88 0c-39.8 0-72 32.2-72 72l0 88zM380.1 320L288 412.1 288 344c0-13.3 10.7-24 24-24l68.1 0zM0 416c0 35.3 28.7 64 64 64l197.5 0c17 0 33.3-6.7 45.3-18.7L429.3 338.7c12-12 18.7-28.3 18.7-45.3L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", "M96 400c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L96 400zM73.2 352l64.6 0-79.5-88.3C51.7 256.3 48 246.8 48 236.9L48 204c0-16.1 11.9-29.5 27.4-31.7 11.8-1.7 20.6-11.8 20.6-23.8L96 72c0-13.3 10.7-24 24-24 7.2 0 13.6 3.1 18 8.1 4.6 5.2 11.1 8.1 18 8.1s13.4-3 18-8.1c4.4-5 10.8-8.1 18-8.1 8.5 0 15.9 4.4 20.2 11.1 6.9 10.7 20.9 14.2 32 8 3.5-1.9 7.4-3.1 11.8-3.1 10.6 0 19.7 6.9 22.8 16.6 3.8 11.7 15.9 18.7 28 16 1.7-.4 3.4-.6 5.2-.6 13.3 0 24 10.7 24 24l0 92.2c0 14.4-3.5 28.5-10.2 41.2l-52.2 98.6 54.3 0 40.3-76.2c10.4-19.6 15.8-41.5 15.8-63.6l0-92.2c0-38.4-30.1-69.8-68.1-71.9-12.9-19.3-34.9-32.1-59.9-32.1-5.7 0-11.2 .7-16.5 1.9-12.7-11.1-29.3-17.9-47.5-17.9-13.1 0-25.4 3.5-36 9.6-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 58.7C19.7 143 0 171.2 0 204l0 32.9c0 21.7 8 42.7 22.6 58.9L73.2 352z"],
    "chess-queen": [512, 512, [9819], "f445", "M325.3 90.8c9.1-4.8 20.6-3.3 28.2 4.3l39.8 39.8 3.7 3.3c9.1 7.1 20.9 10 32.4 7.7l46.4-9.3 3.5-.4c8-.4 15.8 3.2 20.6 9.8 5.5 7.6 6.1 17.6 1.6 25.8l-112.6 202.6 51.5 70.9 1.8 2.7c4 6.6 6.2 14.2 6.2 22 0 23.3-18.9 42.1-42.1 42.1l-299.8 0c-21.8 0-39.8-16.6-41.9-37.8l-.2-4.3 .1-3.3c.6-7.7 3.4-15.1 7.9-21.4l51.5-70.9-112.5-202.6c-4.5-8.2-3.9-18.3 1.6-25.8s14.9-11.2 24.1-9.4l46.4 9.3c13.1 2.6 26.7-1.5 36.1-10.9L159.5 95 163 92.2c8.6-5.8 20.1-5.6 28.5 1.1l40 32 2.8 2.1c14.4 9.6 33.5 8.9 47.2-2.1l40-32 3.8-2.5zM164.7 400l-46.6 64 276.7 0-46.6-64-183.6 0zM311.5 162.8c-30.1 24.1-72.1 25.6-103.8 4.5l-6.2-4.5-23.3-18.6-24.6 24.6c-19.8 19.8-47.7 28.9-75.1 24.8l88.1 158.5 179.8 0 88-158.5c-25.7 3.8-51.7-3.9-71.1-21l-4-3.7-24.6-24.6-23.2 18.6zM256.5 72a40 40 0 1 1 0-80 40 40 0 1 1 0 80z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M504.1 353C512.9 367.2 525.3 379 539.8 387.2 495.1 462 413.4 512 320 512S144.9 462 100.2 387.2c14.6-8.2 26.9-20 35.8-34.3 34.9 66 104.2 111 184.1 111s149.2-45 184.1-111zm16.4-152.5C496.2 112.6 415.7 48 320 48S143.8 112.6 119.5 200.5c-10.6-4.8-22.7-6.8-35.4-5l-13.4 1.9C97.2 84.3 198.8 0 320 0S542.8 84.3 569.3 197.4l-13.4-1.9c-12.7-1.8-24.8 .2-35.4 5zM455.8 320c-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8zM212 208l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zM640 300.6c0 28.4-23 51.4-51.4 51.4-25.6 0-47.3-18.8-50.9-44.1L531 261.1c-1.5-10.6 7.5-19.6 18.1-18.1l46.7 6.7c25.3 3.6 44.1 25.3 44.1 50.9zm-640 0c0-25.6 18.8-47.3 44.1-50.9L90.9 243c10.6-1.5 19.6 7.5 18.1 18.1l-6.7 46.7C98.7 333.2 77 352 51.4 352 23 352 0 329 0 300.6z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M441 58.9L453.1 71c9.4 9.4 9.4 24.6 0 33.9L424 134.1 377.9 88 407 58.9c9.4-9.4 24.6-9.4 33.9 0zM209.8 256.2L344 121.9 390.1 168 255.8 302.2c-2.9 2.9-6.5 5-10.4 6.1l-58.5 16.7 16.7-58.5c1.1-3.9 3.2-7.5 6.1-10.4zM373.1 25L175.8 222.2c-8.7 8.7-15 19.4-18.3 31.1l-28.6 100c-2.4 8.4-.1 17.4 6.1 23.6s15.2 8.5 23.6 6.1l100-28.6c11.8-3.4 22.5-9.7 31.1-18.3L487 138.9c28.1-28.1 28.1-73.7 0-101.8L474.9 25C446.8-3.1 401.2-3.1 373.1 25zM88 64C39.4 64 0 103.4 0 152L0 424c0 48.6 39.4 88 88 88l272 0c48.6 0 88-39.4 88-88l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 22.1-17.9 40-40 40L88 464c-22.1 0-40-17.9-40-40l0-272c0-22.1 17.9-40 40-40l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 64z"],
    "face-grin-beam-sweat": [576, 512, [128517, "grin-beam-sweat"], "f583", "M530.2 15.9c-8.8-10.7-18.5-20.9-29-30-3-2.6-7.4-2.6-10.4 0-10.5 9.1-20.1 19.3-29 30-14.7 17.8-29.8 40.1-29.8 64.1 0 36.4 27.6 64 64 64s64-27.6 64-64c0-24-15.2-46.3-29.8-64.1zm-132 8.9C364.8 8.9 327.4 0 288 0 146.6 0 32 114.6 32 256S146.6 512 288 512 544 397.4 544 256c0-24.4-3.4-48-9.8-70.4-11.9 4.2-24.7 6.4-38.2 6.4-3.4 0-6.8-.1-10.2-.4 6.6 20.3 10.2 41.9 10.2 64.4 0 114.9-93.1 208-208 208S80 370.9 80 256 173.1 48 288 48c34.8 0 67.5 8.5 96.3 23.6 1.4-17.4 6.9-33.1 13.8-46.8zM423.8 320c4.1-11.6-7.8-21.4-19.6-17.8-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8 19.8 55.9 73.1 95.9 135.8 95.9 62.7 0 116-40.1 135.8-96zM180 208c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8zm188-28c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM232 120l0 136c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2 280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm118.3 58.2c-4.2-13.7 7.1-26.2 21.4-26.2l232.6 0c14.3 0 25.6 12.5 21.4 26.2-18 58.9-72.9 101.8-137.7 101.8S136.3 373.1 118.3 314.2zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "paper-plane": [576, 512, [61913], "f1d8", "M290.5 287.7L491.4 86.9 359 456.3 290.5 287.7zM457.4 53L256.6 253.8 88 185.3 457.4 53zM38.1 216.8l205.8 83.6 83.6 205.8c5.3 13.1 18.1 21.7 32.3 21.7 14.7 0 27.8-9.2 32.8-23.1L570.6 8c3.5-9.8 1-20.6-6.3-28s-18.2-9.8-28-6.3L39.4 151.7c-13.9 5-23.1 18.1-23.1 32.8 0 14.2 8.6 27 21.7 32.3z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M378.9 80c-27.3 0-53 13.1-69 35.2l-34.4 47.6c-4.5 6.2-11.7 9.9-19.4 9.9s-14.9-3.7-19.4-9.9l-34.4-47.6c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1zM271 87.1c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 68.6-42.9 128.9-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.3 9.4-27.5 14.1-43.1 14.1s-30.8-4.7-43.1-14.1C176.4 438 123.2 391.5 79.1 338 42.9 294.1 0 233.7 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l15 20.7 15-20.7z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 48 0 0-64 389.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96zM80 400l0-256 356.4 0-48.2 108.5c-5.5 12.4-5.5 26.6 0 39L436.4 400 80 400z"],
    "clone": [512, 512, [], "f24d", "M288 464L64 464c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l48 0 0-48-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-48 0 0 48c0 8.8-7.2 16-16 16zM224 304c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-224 0zm-64-16c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M97.5 400l50-160 379.4 0-50 160-379.4 0zm190.7 48L477 448c21 0 39.6-13.6 45.8-33.7l50-160c9.7-30.9-13.4-62.3-45.8-62.3l-379.4 0c-21 0-39.6 13.6-45.8 33.7L80.2 294.4 80.2 96c0-8.8 7.2-16 16-16l138.7 0c3.5 0 6.8 1.1 9.6 3.2L282.9 112c13.8 10.4 30.7 16 48 16l117.3 0c8.8 0 16 7.2 16 16l48 0c0-35.3-28.7-64-64-64L330.9 80c-6.9 0-13.7-2.2-19.2-6.4L273.3 44.8C262.2 36.5 248.8 32 234.9 32L96.2 32c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l192 0z"],
    "window-minimize": [512, 512, [128469], "f2d1", "M0 424c0-13.3 10.7-24 24-24l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24z"],
    "star-half": [576, 512, [61731], "f089", "M285.7-15.8c10.8 2.6 18.4 12.2 18.4 23.3l0 387.1c0 9-5.1 17.3-13.1 21.4L143.8 491c-8 4.1-17.7 3.3-25-2s-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.1-14.9 19.1-16.3L193.1 125.3 258.8-3.3c5-9.9 16.2-15 27-12.4zM256.1 107.4L230.3 158c-3.5 6.8-10 11.6-17.6 12.8l-125.5 20 89.8 89.9c5.4 5.4 7.9 13.1 6.7 20.7l-19.8 125.5 92.2-46.9 0-272.6z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M402.6 50.2c-5.4 1.7-11.3 1.8-16.2-.9-5.8-3.2-11.8-6.2-17.8-8.9-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7 52.6 0 95.2 42.6 95.2 95.2 0 13.2-2.7 25.8-7.6 37.3-4.5 10.5-18.4 9.8-24.9 .4-3.8-5.5-7.8-10.8-12-16-3.5-4.4-4.5-10.2-3.8-15.8 .2-1.9 .4-3.9 .4-5.9 0-26.1-21.2-47.2-47.2-47.2-4.9 0-9.7 .8-14.2 2.2zM32.5 132.9c-6.5 9.4-20.5 10.1-24.9-.4-4.9-11.5-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2 19.3 0 37.3 5.8 52.3 15.7 9.6 6.3 6.3 19.9-4.1 24.6-6.1 2.8-12 5.7-17.8 8.9-4.9 2.7-10.9 2.6-16.2 .9-4.5-1.4-9.2-2.2-14.2-2.2-26.1 0-47.2 21.2-47.2 47.2 0 2 .1 4 .4 5.9 .7 5.6-.3 11.4-3.8 15.8-4.2 5.2-8.2 10.5-12 16zM432 288a176 176 0 1 0 -352 0 176 176 0 1 0 352 0zM396.5 462.5C358.1 493.4 309.2 512 256 512s-102.1-18.6-140.5-49.5L73 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l42.5-42.5C50.6 390.1 32 341.2 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 53.2-18.6 102.1-49.5 140.5L473 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-42.5-42.5zM280 184l0 94.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-4.5-4.5-7-10.6-7-17l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "newspaper": [512, 512, [128240], "f1ea", "M168 80c-13.3 0-24 10.7-24 24l0 304c0 8.4-1.4 16.5-4.1 24L440 432c13.3 0 24-10.7 24-24l0-304c0-13.3-10.7-24-24-24L168 80zM72 480c-39.8 0-72-32.2-72-72L0 112C0 98.7 10.7 88 24 88s24 10.7 24 24l0 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304c0-39.8 32.2-72 72-72l272 0c39.8 0 72 32.2 72 72l0 304c0 39.8-32.2 72-72 72L72 480zM192 152c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm152 24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM216 256l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 80l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "hospital": [576, 512, [127973, 62589, "hospital-alt", "hospital-wide"], "f0f8", "M176 0c-35.3 0-64 28.7-64 64l0 48-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-272c0-35.3-28.7-64-64-64l-48 0 0-48c0-35.3-28.7-64-64-64L176 0zM160 64c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 72c0 13.3 10.7 24 24 24l72 0c8.8 0 16 7.2 16 16l0 272c0 8.8-7.2 16-16 16l-176 0 0-80c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 80-176 0c-8.8 0-16-7.2-16-16l0-272c0-8.8 7.2-16 16-16l72 0c13.3 0 24-10.7 24-24l0-72zM112 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM96 336l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm320 0l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm16-112c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM264 104l0 32-32 0c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 192l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm48 112l0-96 96 0 0 96-96 0z"],
    "object-ungroup": [640, 512, [], "f248", "M48.2 66.8c-.1-.8-.2-1.7-.2-2.5l0-.2c0-8.8 7.2-16 16-16 .9 0 1.9 .1 2.8 .2 7.5 1.3 13.2 7.9 13.2 15.8 0 8.8-7.2 16-16 16-7.9 0-14.5-5.7-15.8-13.2zM0 64c0 26.9 16.5 49.9 40 59.3l0 105.3c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 26.9 0 49.9-16.5 59.3-40l201.3 0c9.5 23.5 32.5 40 59.3 40 35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-105.3c23.5-9.5 40-32.5 40-59.3 0-35.3-28.7-64-64-64-26.9 0-49.9 16.5-59.3 40L123.3 40C113.9 16.5 90.9 0 64 0 28.7 0 0 28.7 0 64zm368 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM324.7 88c6.5 16 19.3 28.9 35.3 35.3l0 105.3c-16 6.5-28.9 19.3-35.3 35.3l-201.3 0c-6.5-16-19.3-28.9-35.3-35.3l0-105.3c16-6.5 28.9-19.3 35.3-35.3l201.3 0zM384 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 288c0 7.9-5.7 14.5-13.2 15.8-.8 .1-1.7 .2-2.5 .2l-.2 0c-8.8 0-16-7.2-16-16 0-.9 .1-1.9 .2-2.8 1.3-7.5 7.9-13.2 15.8-13.2 8.8 0 16 7.2 16 16zm436.7-40c6.5 16 19.3 28.9 35.3 35.3l0 105.3c-16 6.5-28.9 19.3-35.3 35.3l-201.3 0c-6.5-16-19.3-28.9-35.3-35.3l0-20.7-48 0 0 20.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 26.9 0 49.9-16.5 59.3-40l201.3 0c9.5 23.5 32.5 40 59.3 40 35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-105.3c23.5-9.5 40-32.5 40-59.3 0-35.3-28.7-64-64-64-26.9 0-49.9 16.5-59.3 40l-52.7 0 0 9.6c10.7 10.9 19.1 23.9 24.6 38.4l28 0zm59.3-8a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM271.8 450.7a16 16 0 1 1 -31.5-5.5 16 16 0 1 1 31.5 5.5zm301.5 13c-7.5-1.3-13.2-7.9-13.2-15.8 0-8.8 7.2-16 16-16 7.9 0 14.5 5.7 15.8 13.2l0 .1c.1 .9 .2 1.8 .2 2.7 0 8.8-7.2 16-16 16-.9 0-1.9-.1-2.8-.2z"],
    "comment": [512, 512, [128489, 61669], "f075", "M51.9 384.9C19.3 344.6 0 294.4 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240 397.4 480 256 480c-36.5 0-71.2-7.2-102.6-20L37 509.9c-3.7 1.6-7.5 2.1-11.5 2.1-14.1 0-25.5-11.4-25.5-25.5 0-4.3 1.1-8.5 3.1-12.2l48.8-89.4zm37.3-30.2c12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240c0 42.8 15.1 82.4 41.2 114.7z"],
    "chess-pawn": [384, 512, [9823], "f443", "M192-32c66.3 0 120 53.7 120 120 0 27.6-9.3 52.9-24.9 73.2 9.8 3 16.9 12.1 16.9 22.8 0 13.3-10.7 24-24 24l-.6 0 24.6 160 53.6 67c6.7 8.4 10.4 18.8 10.4 29.6 0 26.2-21.2 47.4-47.4 47.4L63.4 512c-26.2 0-47.4-21.2-47.4-47.4 0-10.8 3.7-21.2 10.4-29.6l53.6-67 24.6-160-.6 0c-13.3 0-24-10.7-24-24 0-10.8 7.1-19.8 16.9-22.8-15.6-20.3-24.9-45.6-24.9-73.2 0-66.3 53.7-120 120-120zM115.9 400l-51.2 64 254.7 0-51.2-64-152.2 0zm36.2-184.7l-21 136.7 121.9 0-21-136.7-1.1-7.3-77.6 0-1.1 7.3zM192 16a72 72 0 1 0 0 144 72 72 0 1 0 0-144z"],
    "calendar-plus": [448, 512, [], "f271", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16l-264 0zm104 64c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "clipboard": [384, 512, [128203], "f328", "M232 96l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm0 48c37.1 0 67.6-28 71.6-64L320 80c8.8 0 16 7.2 16 16l0 352c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l16.4 0c4 36 34.5 64 71.6 64l80 0zM291.9 32C279 12.7 257 0 232 0L152 0c-25 0-47 12.7-59.9 32L64 32C28.7 32 0 60.7 0 96L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352c0-35.3-28.7-64-64-64l-28.1 0z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M360 32l7.4 .4c35 3.6 62.5 32.2 64.4 67.7 17.8 11.8 30.1 31.4 32 53.9l.2 6c0 5.7-.7 11.2-2 16.5 10.2 11.5 16.8 26.3 17.8 42.7l.2 4.8c0 13.2-3.6 25.4-9.8 36 4.9 8.4 8.2 17.9 9.3 28l.4 8c0 37.3-28.3 67.9-64.6 71.6l-7.4 .4-109.7 0 14.1 30 3.1 7.6c12.5 35.7-1.8 75.5-34.2 95l-7.2 3.9c-37.5 17.6-81.7 3.6-102.6-31.2l-.6-.9-2.7-5-.6-1.2-30.1-64c-9.4 17.8-28 29.9-49.5 29.9l-32 0c-30.9 0-56-25.1-56-56L0 152c0-30.9 25.1-56 56-56l32 0c12.4 0 23.9 4.1 33.2 11 13.2-21.4 32-39.4 55-51.6l12.2-6.5 .7-.3 6.6-3.2 .7-.3 7.1-3c16.7-6.6 34.5-9.9 52.6-9.9L360 32zM255.9 80c-12 0-23.9 2.3-35.1 6.6l-4.7 2-5.3 2.6 0 0-12.2 6.5c-29.2 15.5-48.3 44.9-50.7 77.6l-.2 8 0 112.9 .1 4.1c.5 8.2 2.5 16.2 6 23.7l56.8 120.9 2.1 3.8c8.4 13.7 26 19.1 40.8 12.2l2.9-1.6c13-7.8 18.7-23.7 13.7-38l-1.2-3-30.2-64.2c-3.5-7.4-2.9-16.1 1.5-23.1s12-11.1 20.2-11.1l147.5 0 2.4-.1c11.3-1.1 20.3-10.1 21.4-21.4l.1-2.5c0-7.1-3.1-13.5-8.2-18-5.2-4.6-8.2-11.1-8.2-18s3-13.4 8.2-18c4.4-3.9 7.4-9.3 8-15.3l.2-2.7c0-8.4-4.4-15.9-11.2-20.2-10.7-6.9-14.2-20.9-8-32 1.5-2.6 2.5-5.6 2.9-8.6l.2-3.2c0-10.6-6.9-19.6-16.6-22.8-11.7-3.8-18.7-15.9-16-28 .2-.9 .3-1.8 .4-2.6l.2-2.6c0-12.4-9.5-22.6-21.6-23.8L360 80 255.9 80zM56 144c-4.4 0-8 3.6-8 8l0 224c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-224c0-4.4-3.6-8-8-8l-32 0z"],
    "id-badge": [384, 512, [], "f2c1", "M256 48l0 16c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-16-64 0c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16l-64 0zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM160 320l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16L96 416c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-24-96a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zm230.7 89.9c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L211.4 366.1c-4.1 5.7-10.5 9.3-17.5 9.8-7 .5-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l36 36 105.6-145.2z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M216 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 81.8 98.1c24.7 29.6 38.2 67 38.2 105.6 0 43.7-17.4 85.7-48.3 116.6l-8.6 8.6 46.5 58.2c6.7 8.4 10.4 18.8 10.4 29.6 0 26.2-21.2 47.4-47.4 47.4L47.4 512C21.2 512 0 490.8 0 464.6 0 453.9 3.7 443.4 10.4 435l46.5-58.2-8.6-8.6C17.4 337.4 0 295.4 0 251.7 0 213.1 13.5 175.8 38.2 146.1L120 48 104 48C90.7 48 80 37.3 80 24S90.7 0 104 0L216 0zM94.4 406.8l-45.7 57.2 222.7 0-45.7-57.1-5.5-6.9-120.3 0-5.5 6.8zM156.9 78.7L75.1 176.8c-15.3 18.4-24.6 41-26.7 64.7L48 251.7c0 31 12.3 60.7 34.2 82.7l17.7 17.7 120.2 0c6.2-6.2 12.1-12.1 17.8-17.7 21.9-21.9 34.2-51.6 34.2-82.6l-.4-10.2c-1.5-17-6.7-33.3-15.2-48L209 241c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l51.8-51.8-63.7-76.5-3.1-3.8-3.1 3.8z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M512 416c0 35.3-28.5 64-63.9 64L64 480c-35.4 0-64-28.7-64-64L0 164c.1-15.5 7.8-30 20.5-38.8L206-2.7c30.1-20.7 69.8-20.7 99.9 0L491.5 125.2c12.8 8.8 20.4 23.3 20.5 38.8l0 252zM64 432l384.1 0c8.8 0 15.9-7.1 15.9-16l0-191.7-154.8 117.4c-31.4 23.9-74.9 23.9-106.4 0L48 224.3 48 416c0 8.9 7.2 16 16 16zM463.6 164.4L278.7 36.8c-13.7-9.4-31.7-9.4-45.4 0L48.4 164.4 231.8 303.5c14.3 10.8 34.1 10.8 48.4 0L463.6 164.4z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM167 167c-9.4 9.4-9.4 24.6 0 33.9l55 55-55 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55-55-55c-9.4-9.4-24.6-9.4-33.9 0z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 64c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9S337.5 320 328 320l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"],
    "file-image": [384, 512, [128443], "f1c5", "M176 48L64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88zM316.1 160L224 67.9 224 136c0 13.3 10.7 24 24 24l68.1 0zM0 64C0 28.7 28.7 0 64 0L197.5 0c17 0 33.3 6.7 45.3 18.7L365.3 141.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM259.4 432l-134.8 0c-15.8 0-28.6-12.8-28.6-28.6 0-6.4 2.1-12.5 6-17.6l67.6-86.9C175 292 183.3 288 192 288s17 4 22.4 10.9L282 385.9c3.9 5 6 11.2 6 17.6 0 15.8-12.8 28.6-28.6 28.6zM112 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M400 96c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320zM384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4S160 369.5 160 360l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z"],
    "sun": [576, 512, [9728], "f185", "M200.6-7.9c-6.7-4.4-15.1-5.2-22.5-2.2S165.4-.5 163.9 7.3L143 110.6 39.7 131.4c-7.8 1.6-14.4 7-17.4 14.3s-2.2 15.8 2.2 22.5L82.7 256 24.5 343.8c-4.4 6.7-5.2 15.1-2.2 22.5s9.6 12.8 17.4 14.3L143 401.4 163.9 504.7c1.6 7.8 7 14.4 14.3 17.4s15.8 2.2 22.5-2.2l87.8-58.2 87.8 58.2c6.7 4.4 15.1 5.2 22.5 2.2s12.8-9.6 14.3-17.4l20.9-103.2 103.2-20.9c7.8-1.6 14.4-7 17.4-14.3s2.2-15.8-2.2-22.5l-58.2-87.8 58.2-87.8c4.4-6.7 5.2-15.1 2.2-22.5s-9.6-12.8-17.4-14.3L433.8 110.6 413 7.3C411.4-.5 406-7 398.6-10.1s-15.8-2.2-22.5 2.2L288.4 50.3 200.6-7.9zM186.9 135.7l17-83.9 71.3 47.3c8 5.3 18.5 5.3 26.5 0l71.3-47.3 17 83.9c1.9 9.5 9.3 16.8 18.8 18.8l83.9 17-47.3 71.3c-5.3 8-5.3 18.5 0 26.5l47.3 71.3-83.9 17c-9.5 1.9-16.9 9.3-18.8 18.8l-17 83.9-71.3-47.3c-8-5.3-18.5-5.3-26.5 0l-71.3 47.3-17-83.9c-1.9-9.5-9.3-16.9-18.8-18.8l-83.9-17 47.3-71.3c5.3-8 5.3-18.5 0-26.5l-47.3-71.3 83.9-17c9.5-1.9 16.8-9.3 18.8-18.8zM239.6 256a48.4 48.4 0 1 1 96.8 0 48.4 48.4 0 1 1 -96.8 0zm144.8 0a96.4 96.4 0 1 0 -192.8 0 96.4 96.4 0 1 0 192.8 0z"],
    "image": [448, 512, [], "f03e", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm128 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm136 72c8.5 0 16.4 4.5 20.7 11.8l80 136c4.4 7.4 4.4 16.6 .1 24.1S352.6 384 344 384l-240 0c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l17.2 24.6 46.5-79c4.3-7.3 12.2-11.8 20.7-11.8z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M296.5 291.1C321 265.2 336 230.4 336 192 336 112.5 271.5 48 192 48S48 112.5 48 192c0 38.4 15 73.2 39.5 99.1 21.3 22.4 44.9 54 53.3 92.9l102.4 0c8.4-39 32-70.5 53.3-92.9zm34.8 33C307.7 349 288 379.4 288 413.7l0 18.3c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-18.3C96 379.4 76.3 349 52.7 324.1 20 289.7 0 243.2 0 192 0 86 86 0 192 0S384 86 384 192c0 51.2-20 97.7-52.7 132.1zM144 184c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M512 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l448 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM208 248a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-32 40c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80l-64 0zM376 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM184 320c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "map": [512, 512, [128506, 62072], "f279", "M512 48c0-8.3-4.3-16-11.3-20.4s-15.9-4.8-23.3-1.1L352.5 88.1 180 29.4c-13.7-4.7-28.7-3.8-41.9 2.3L13.8 90.3C5.4 94.2 0 102.7 0 112L0 464c0 8.2 4.2 15.9 11.1 20.3s15.6 4.9 23.1 1.4l127.3-59.9 170.7 56.9c13.7 4.6 28.5 3.7 41.6-2.5l124.4-58.5c8.4-4 13.8-12.4 13.8-21.7l0-352zM144 82.1l0 299-96 45.2 0-299 96-45.2zm48 303.3l0-301.1 128 43.5 0 300.3-128-42.7zM368 134l96-47.4 0 298.2-96 45.2 0-296z"],
    "hand-point-down": [384, 512, [], "f0a7", "M64 448l0-177.6c5.2 1 10.5 1.6 16 1.6l16 0 0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16zM80 224c-17.7 0-32-14.3-32-32l0-24c0-66.3 53.7-120 120-120l48 0c52.5 0 97.1 33.7 113.4 80.7-3.1-.5-6.2-.7-9.4-.7-20 0-37.9 9.2-49.7 23.6-9-4.9-19.4-7.6-30.3-7.6-15.1 0-29 5.3-40 14-11-8.8-24.9-14-40-14l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0zM0 192l0 0c0 18 6 34.6 16 48l0 208c0 35.3 28.7 64 64 64s64-28.7 64-64l0-82c5.1 1.3 10.5 2 16 2 25.3 0 47.2-14.7 57.6-36 7 2.6 14.5 4 22.4 4 20 0 37.9-9.2 49.7-23.6 9 4.9 19.4 7.6 30.3 7.6 35.3 0 64-28.7 64-64l0-88C384 75.2 308.8 0 216 0L168 0C75.2 0 0 75.2 0 168l0 24zm336 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64zM160 272c5.5 0 10.9-.7 16-2l0 34c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32 16 0zm64-24l0-40c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M256 48a208 208 0 1 0 0 416 208 208 0 1 0 0-416zM512 256a256 256 0 1 1 -512 0 256 256 0 1 1 512 0zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M464 256c0-114.9-93.1-208-208-208S48 141.1 48 256c0 74.1 38.8 139.2 97.1 176-.7-5.2-1.1-10.6-1.1-16l0-53.5c-10.2-12.6-18.3-26.9-23.8-42.4-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8-5.5 15.6-13.6 29.9-23.8 42.5l0 53.5c0 5.4-.4 10.8-1.1 16 58.4-36.8 97.1-101.9 97.1-176zm48 0c0 116.3-77.6 214.6-183.9 245.7-19.5 16.4-44.6 26.3-72.1 26.3s-52.6-9.9-72.1-26.3C77.6 470.6 0 372.3 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm16 208l0-37.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 37.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M387 228.3c-4.4-2.8-7.6-7-9.2-11.9s-1.4-10.2 .5-15L411.6 118c-19.9-22.4-44.6-40.5-72.4-52.7l-69.1 57.6c-4 3.3-9 5.1-14.1 5.1s-10.2-1.8-14.1-5.1L172.8 65.3c-27.8 12.2-52.5 30.3-72.4 52.7l33.4 83.4c1.9 4.8 2.1 10.1 .5 15s-4.9 9.1-9.2 11.9L49 276.2c3 30.9 12.7 59.7 27.6 85.2l89.7-6c5.2-.3 10.3 1.1 14.5 4.2s7.2 7.4 8.4 12.5l22 87.2c14.4 3.2 29.4 4.8 44.8 4.8s30.3-1.7 44.8-4.8l22-87.2c1.3-5 4.2-9.4 8.4-12.5s9.3-4.5 14.5-4.2l89.7 6c15-25.4 24.7-54.3 27.6-85.1L387 228.3zM256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zm62 221c8.4 6.1 11.9 16.9 8.7 26.8l-18.3 56.3c-3.2 9.9-12.4 16.6-22.8 16.6l-59.2 0c-10.4 0-19.6-6.7-22.8-16.6l-18.3-56.3c-3.2-9.9 .3-20.7 8.7-26.8l47.9-34.8c8.4-6.1 19.8-6.1 28.2 0L318 221z"],
    "face-surprise": [512, 512, [128558, "surprise"], "f5c2", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm176-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-48 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M64 400l384 0c8.8 0 16-7.2 16-16l0-240c0-8.8-7.2-16-16-16l-149.3 0c-17.3 0-34.2-5.6-48-16L212.3 83.2c-2.8-2.1-6.1-3.2-9.6-3.2L64 80c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16zm384 48L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4L448 80c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64z"],
    "cloud": [576, 512, [9729], "f0c2", "M80 192c0-88.4 71.6-160 160-160 47.1 0 89.4 20.4 118.7 52.7 10.6-3.1 21.8-4.7 33.3-4.7 66.3 0 120 53.7 120 120 0 13.2-2.1 25.9-6.1 37.8 41.6 21.1 70.1 64.3 70.1 114.2 0 70.7-57.3 128-128 128l-304 0c-79.5 0-144-64.5-144-144 0-56.8 32.9-105.9 80.7-129.4-.4-4.8-.7-9.7-.7-14.6zM240 80c-61.9 0-112 50.1-112 112 0 8.4 .9 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4 0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.4-25.7-68.9-60.5-77.6-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.2 2-21.7c7-11.1 11-24.2 11-38.3 0-39.8-32.2-72-72-72-11.1 0-21.5 2.5-30.8 6.9-10.5 5-23.1 1.7-29.8-7.8-20.3-28.6-53.7-47.1-91.3-47.1z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "face-grin-squint": [512, 512, [128518, "grin-squint"], "f585", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm372.2 46.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zm-249.6-143c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3c-6.2-5.2-7.6-14.3-3.1-21.1zm263.6 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M406.5 399.6C387.4 352.9 341.5 320 288 320l-64 0c-53.5 0-99.4 32.9-118.5 79.6-35.6-37.3-57.5-87.9-57.5-143.6 0-114.9 93.1-208 208-208s208 93.1 208 208c0 55.7-21.9 106.2-57.5 143.6zm-40.1 32.7C334.4 452.4 296.6 464 256 464s-78.4-11.6-110.5-31.7c7.3-36.7 39.7-64.3 78.5-64.3l64 0c38.8 0 71.2 27.6 78.5 64.3zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-272a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm-88-40a88 88 0 1 0 176 0 88 88 0 1 0 -176 0z"],
    "rectangle-list": [512, 512, ["list-alt"], "f022", "M64 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM160 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm104-56l160 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 128l160 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M256.5 0c-25.3 0-47.2 14.7-57.6 36-7-2.6-14.5-4-22.4-4-35.3 0-64 28.7-64 64l0 165.5-2.7-2.7c-25-25-65.5-25-90.5 0s-25 65.5 0 90.5L107 437c48 48 113.1 75 181 75l16.5 0c1.5 0 3-.1 4.5-.4 91.7-6.2 165-79.4 171.1-171.1 .3-1.5 .4-3 .4-4.5l0-176c0-35.3-28.7-64-64-64-5.5 0-10.9 .7-16 2l0-2c0-35.3-28.7-64-64-64-7.9 0-15.4 1.4-22.4 4-10.4-21.3-32.3-36-57.6-36zm-16 96.1l0-.1 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 168c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136c0-8.8 7.2-16 16-16s16 7.2 16 16l0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16s16 7.2 16 16l0 172.9c-.1 .6-.1 1.3-.2 1.9-3.4 69.7-59.3 125.6-129 129-.6 0-1.3 .1-1.9 .2L288 464C232.9 464 180 442.1 141 403.1L53.2 315.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l43.7 43.7c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-223.4c0-8.8 7.2-16 16-16 8.8 0 16 7.1 16 15.9l0 136.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-135.9z"],
    "thumbs-up": [512, 512, [128077, 61575], "f164", "M171.5 38.8C192.3 4 236.5-10 274 7.6l7.2 3.8C316 32.3 330 76.5 312.4 114l0 0-14.1 30 109.7 0 7.4 .4c36.3 3.7 64.6 34.4 64.6 71.6 0 13.2-3.6 25.4-9.8 36 6.1 10.6 9.7 22.8 9.8 36 0 18.3-6.9 34.8-18 47.5 1.3 5.3 2 10.8 2 16.5 0 25.1-12.9 47-32.2 59.9-1.9 35.5-29.4 64.2-64.4 67.7l-7.4 .4-104.1 0c-18 0-35.9-3.4-52.6-9.9l-7.1-3-.7-.3-6.6-3.2-.7-.3-12.2-6.5c-12.3-6.5-23.3-14.7-32.9-24.1-4.1 26.9-27.3 47.4-55.3 47.4l-32 0c-30.9 0-56-25.1-56-56L0 200c0-30.9 25.1-56 56-56l32 0c10.8 0 20.9 3.1 29.5 8.5l50.1-106.5 .6-1.2 2.7-5 .6-.9zM56 192c-4.4 0-8 3.6-8 8l0 224c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-224c0-4.4-3.6-8-8-8l-32 0zM253.6 51c-14.8-6.9-32.3-1.6-40.7 12l-2.2 4-56.8 120.9c-3.5 7.5-5.5 15.5-6 23.7l-.1 4.2 0 112.9 .2 7.9c2.4 32.7 21.4 62.1 50.7 77.7l11.5 6.1 6.3 3.1c12.4 5.6 25.8 8.5 39.4 8.5l104.1 0 2.4-.1c12.1-1.2 21.6-11.5 21.6-23.9l-.2-2.6c-.1-.9-.2-1.7-.4-2.6-2.7-12.1 4.3-24.2 16-28 9.7-3.1 16.6-12.2 16.6-22.8 0-4.3-1.1-8.2-3.1-11.8-6.3-11.1-2.8-25.2 8-32 6.8-4.3 11.2-11.8 11.2-20.2 0-7.1-3.1-13.5-8.2-18-5.2-4.6-8.2-11.1-8.2-18s3-13.4 8.2-18c5.1-4.5 8.2-10.9 8.2-18l-.1-2.4c-1.1-11.3-10.1-20.3-21.4-21.4l-2.4-.1-147.5 0c-8.2 0-15.8-4.2-20.2-11.1-4.4-6.9-5-15.7-1.5-23.1L269 93.6c7-15 1.4-32.7-12.5-41L253.6 51z"],
    "building": [384, 512, [127970, 61687], "f1ad", "M64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0-80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 80 80 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm96 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM240 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM96 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm144-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"],
    "chess-rook": [384, 512, [9820], "f447", "M352 0c17.7 0 32 14.3 32 32l0 138.7c0 13.8-4.5 27.3-12.8 38.4l-35.2 46.9 0 112 40.8 68.1c4.7 7.8 7.2 16.7 7.2 25.8 0 27.7-22.4 50.1-50.1 50.1L50.1 512c-27.7 0-50.1-22.4-50.1-50.1 0-9.1 2.5-18 7.2-25.8L48 368 48 256 12.8 209.1C4.5 198 0 184.5 0 170.7L0 32C0 14.3 14.3 0 32 0L352 0zM48.3 460.8l-.3 1.1c0 1.2 1 2.1 2.1 2.1l283.8 0c1.2 0 2.1-1 2.1-2.1l-.3-1.1-36.5-60.8-214.4 0-36.5 60.8zM48 170.7c0 2.6 .6 5.1 1.8 7.4l1.4 2.2 0 0 35.2 46.9 9.6 12.8 0 112 192 0 0-112 9.6-12.8 35.2-46.9 0 0 1.4-2.2c1.2-2.3 1.8-4.8 1.8-7.4l0-122.7-64 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-64 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-64 0 0 122.7z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-80c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 47.2-36 67.2-56 74.5l0 3.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8.1c0-20.5 14.8-35.2 30.1-40.2 6.4-2.1 13.2-5.5 18.2-10.3 4.3-4.2 7.7-10 7.7-19.6 0-17.7-14.3-32-32-32zM224 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "file": [384, 512, [128196, 128459, 61462], "f15b", "M176 48L64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88zM316.1 160L224 67.9 224 136c0 13.3 10.7 24 24 24l68.1 0zM0 64C0 28.7 28.7 0 64 0L197.5 0c17 0 33.3 6.7 45.3 18.7L365.3 141.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64z"],
    "face-sad-cry": [512, 512, [128557, "sad-cry"], "f5b3", "M400 406.1L400 288c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152.6c-28.7 15-61.4 23.4-96 23.4s-67.3-8.5-96-23.4L160 288c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 118.1C72.6 368.2 48 315 48 256 48 141.1 141.1 48 256 48s208 93.1 208 208c0 59-24.6 112.2-64 150.1zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 196l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20 9-20 20-20zm172 20c0-11 9-20 20-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20zM208 336l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "calendar-minus": [448, 512, [], "f272", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16l-264 0zm32 136l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "face-tired": [512, 512, [128555, "tired"], "f5c8", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm176.5 64.3C196.1 302.1 223.8 288 256 288s59.9 14.1 79.5 32.3c19 17.8 32.5 41.7 32.5 63.7 0 5.4-2.7 10.4-7.2 13.4s-10.2 3.4-15.2 1.3l-17.2-7.5c-22.8-10-47.5-15.1-72.4-15.1s-49.6 5.2-72.4 15.1l-17.2 7.5c-4.9 2.2-10.7 1.7-15.2-1.3s-7.2-8-7.2-13.4c0-22 13.5-45.9 32.5-63.7zM122.6 159.2c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3c-6.2-5.2-7.6-14.3-3.1-21.1zm263.6 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1z"],
    "hand-point-right": [512, 512, [], "f0a4", "M448 128l-177.6 0c1 5.2 1.6 10.5 1.6 16l0 16 176 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zM224 144c0-17.7-14.3-32-32-32l-24 0c-66.3 0-120 53.7-120 120l0 48c0 52.5 33.7 97.1 80.7 113.4-.5-3.1-.7-6.2-.7-9.4 0-20 9.2-37.9 23.6-49.7-4.9-9-7.6-19.4-7.6-30.3 0-15.1 5.3-29 14-40-8.8-11-14-24.9-14-40l0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80zM192 64l0 0c18 0 34.6 6 48 16l208 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-82 0c1.3 5.1 2 10.5 2 16 0 25.3-14.7 47.2-36 57.6 2.6 7 4 14.5 4 22.4 0 20-9.2 37.9-23.6 49.7 4.9 9 7.6 19.4 7.6 30.3 0 35.3-28.7 64-64 64l-88 0C75.2 448 0 372.8 0 280l0-48C0 139.2 75.2 64 168 64l24 0zm64 336c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0zm16-176c0 5.5-.7 10.9-2 16l34 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0 16zm-24 64l-40 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm11.3-387.3c-6.2-6.2-16.4-6.2-22.6 0l-104 104c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l72 0 0 104c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-104 72 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-104-104z"],
    "hand-scissors": [512, 512, [], "f257", "M.2 276.3c-1.2-35.3 26.4-65 61.7-66.2l3.3-.1-8.2-1.8C22.5 200.5 .7 166.3 8.3 131.8S50.2 75.5 84.7 83.2l173 38.3c2.3-2.9 4.6-5.7 7.1-8.5l18.4-20.3C299.9 74.5 323.5 64 348.3 64l10.2 0c54.1 0 104.1 28.7 131.3 75.4l1.5 2.6c13.6 23.2 20.7 49.7 20.7 76.6L512 344c0 66.3-53.7 120-120 120l-104 0c-35.3 0-64-28.7-64-64 0-2.8 .2-5.6 .5-8.3-19.4-11-32.5-31.8-32.5-55.7 0-.8 0-1.6 0-2.4L66.4 338c-35.3 1.2-65-26.4-66.2-61.7zm63.4-18.2c-8.8 .3-15.7 7.7-15.4 16.6s7.7 15.7 16.5 15.4l161.5-5.6c9.8-.3 18.7 5.3 22.7 14.2s2.2 19.3-4.5 26.4c-2.8 2.9-4.4 6.7-4.4 11 0 8.8 7.2 16 16 16 9.1 0 17.4 5.1 21.5 13.3s3.2 17.9-2.3 25.1c-2 2.7-3.2 6-3.2 9.6 0 8.8 7.2 16 16 16l104 0c39.8 0 72-32.2 72-72l0-125.4c0-18.4-4.9-36.5-14.2-52.4l-1.5-2.6c-18.6-32-52.8-51.6-89.8-51.6l-10.2 0c-11.3 0-22 4.8-29.6 13.1l0 0-18.4 20.3c-.6 .6-1.1 1.3-1.7 1.9l57 13.2c8.6 2 14 10.6 12 19.2s-10.6 14-19.2 12L262.8 171.8 74.3 130c-8.6-1.9-17.2 3.5-19.1 12.2s3.5 17.2 12.2 19.1l187.5 41.6c10.2 2.3 17.8 10.9 18.7 21.4l.1 1c.6 6.6-1.5 13.1-5.8 18.1s-10.6 7.9-17.2 8.2L63.6 258.1z"],
    "gem": [512, 512, [128142], "f3a5", "M168.5 72l87.5 93 87.5-93-175 0zM383.9 99.1l-72.3 76.9 129 0-56.6-76.9zm50 124.9L78.1 224 256 420.3 433.9 224zM71.5 176l129 0-72.3-76.9-56.6 76.9zm434.3 40.1l-232 256c-4.5 5-11 7.9-17.8 7.9s-13.2-2.9-17.8-7.9l-232-256c-7.7-8.5-8.3-21.2-1.5-30.4l112-152c4.5-6.1 11.7-9.8 19.3-9.8l240 0c7.6 0 14.8 3.6 19.3 9.8l112 152c6.8 9.2 6.1 21.9-1.5 30.4z"],
    "rectangle-xmark": [512, 512, [62164, "rectangle-times", "times-rectangle", "window-close"], "f410", "M64 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm334.1 49.9c9.4 9.4 9.4 24.6 0 33.9l-44.1 44.1 44.1 44.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-44.1-44.1-44.1 44.1c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l44.1-44.1-44.1-44.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l44.1 44.1 44.1-44.1c9.4-9.4 24.6-9.4 33.9 0z"],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", "M166.2-16c-13.3 0-25.3 8.3-30 20.8L120 48 24 48C10.7 48 0 58.7 0 72S10.7 96 24 96l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0-16.2-43.2C307.1-7.7 295.2-16 281.8-16L166.2-16zM32 144l0 304c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-304-48 0 0 304c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16l0-304-48 0zm160 72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176z"],
    "life-ring": [512, 512, [], "f1cd", "M385.1 419.1C349.7 447.2 304.8 464 256 464s-93.7-16.8-129.1-44.9l80.4-80.4c14.3 8.4 31 13.3 48.8 13.3s34.5-4.8 48.8-13.3l80.4 80.4zm68.1 .2C489.9 374.9 512 318.1 512 256S489.9 137.1 453.2 92.7L465 81c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L419.3 58.8C374.9 22.1 318.1 0 256 0S137.1 22.1 92.7 58.8L81 47c-9.4-9.4-24.6-9.4-33.9 0S37.7 71.6 47 81L58.8 92.7C22.1 137.1 0 193.9 0 256S22.1 374.9 58.8 419.3L47 431c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l11.8-11.8C137.1 489.9 193.9 512 256 512s118.9-22.1 163.3-58.8L431 465c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-11.8-11.8zm-34.1-34.1l-80.4-80.4c8.4-14.3 13.3-31 13.3-48.8s-4.8-34.5-13.3-48.8l80.4-80.4C447.2 162.3 464 207.2 464 256s-16.8 93.7-44.9 129.1zM385.1 92.9l-80.4 80.4c-14.3-8.4-31-13.3-48.8-13.3s-34.5 4.8-48.8 13.3L126.9 92.9C162.3 64.8 207.2 48 256 48s93.7 16.8 129.1 44.9zM173.3 304.8L92.9 385.1C64.8 349.7 48 304.8 48 256s16.8-93.7 44.9-129.1l80.4 80.4c-8.4 14.3-13.3 31-13.3 48.8s4.8 34.5 13.3 48.8zM208 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "copyright": [512, 512, [169], "f1f9", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM205.1 306.9c-28.1-28.1-28.1-73.7 0-101.8s73.7-28.1 101.8 0c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-46.9-46.9-122.8-46.9-169.7 0s-46.9 122.8 0 169.7 122.8 46.9 169.7 0c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0c-28.1 28.1-73.7 28.1-101.8 0z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M48 256a208 208 0 1 1 416 0 208 208 0 1 1 -416 0zm464 0a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM124.7 244.7c-6.2 6.2-6.2 16.4 0 22.6l104 104c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-72 104 0c13.3 0 24-10.7 24-24l0-16c0-13.3-10.7-24-24-24l-104 0 0-72c0-6.5-3.9-12.3-9.9-14.8s-12.9-1.1-17.4 3.5l-104 104z"],
    "calendar": [448, 512, [128197, 128198], "f133", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 48 352 0 0-48c0-8.8-7.2-16-16-16l-264 0zM48 224l0 192c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-192-352 0z"],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM182.4 382.5c-12.4 5.2-26.5-4.1-21.1-16.4 16-36.6 52.4-62.1 94.8-62.1s78.8 25.6 94.8 62.1c5.4 12.3-8.7 21.6-21.1 16.4-22.4-9.5-47.4-14.8-73.7-14.8s-51.3 5.3-73.7 14.8zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M48 56c0-13.3-10.7-24-24-24S0 42.7 0 56L0 400c0 44.2 35.8 80 80 80l408 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L80 432c-17.7 0-32-14.3-32-32L48 56zm104 72l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L152 80c-13.3 0-24 10.7-24 24s10.7 24 24 24zm0 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zm0 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"],
    "house": [512, 512, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M240 6.1c9.1-8.2 22.9-8.2 32 0l232 208c9.9 8.8 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-8-7.2 0 205.3c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L240 6.1zm16 50.1L96 199.7 96 448c0 8.8 7.2 16 16 16l48 0 0-104c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 104 48 0c8.8 0 16-7.2 16-16l0-248.3-160-143.4zM208 464l96 0 0-104c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l0 104z"],
    "face-frown": [512, 512, [9785, "frown"], "f119", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM334.7 384.6C319.7 369 293.6 352 256 352s-63.7 17-78.7 32.6c-9.2 9.6-24.4 9.9-33.9 .7s-9.9-24.4-.7-33.9c22.1-23 60-47.4 113.3-47.4s91.2 24.4 113.3 47.4c9.2 9.6 8.9 24.8-.7 33.9s-24.8 8.9-33.9-.7zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "user": [448, 512, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M144 128a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm208 0a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM48 480c0-70.7 57.3-128 128-128l96 0c70.7 0 128 57.3 128 128l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-97.2-78.8-176-176-176l-96 0C78.8 304 0 382.8 0 480l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8z"],
    "snowflake": [512, 512, [10052, 10054], "f2dc", "M280.1-8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 78.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l57 57 0 76.5-66.2-38.2-20.9-77.8c-3.4-12.8-16.6-20.4-29.4-17S95.2 98 98.7 110.8l8.4 31.5-67.6-39C28 96.6 13.3 100.5 6.7 112S4 138.2 15.5 144.8l67.6 39-31.5 8.4c-12.8 3.4-20.4 16.6-17 29.4s16.6 20.4 29.4 17l77.8-20.9 66.2 38.2-66.2 38.2-77.8-20.9c-12.8-3.4-26 4.2-29.4 17s4.2 26 17 29.4l31.5 8.4-67.6 39C4 373.8 .1 388.5 6.7 400s21.3 15.4 32.8 8.8l67.6-39-8.4 31.5c-3.4 12.8 4.2 26 17 29.4s26-4.2 29.4-17l20.9-77.8 66.2-38.2 0 76.5-57 57c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 78.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-78.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-57-57 0-76.5 66.2 38.2 20.9 77.8c3.4 12.8 16.6 20.4 29.4 17s20.4-16.6 17-29.4l-8.4-31.5 67.6 39c11.5 6.6 26.2 2.7 32.8-8.8s2.7-26.2-8.8-32.8l-67.6-39 31.5-8.4c12.8-3.4 20.4-16.6 17-29.4s-16.6-20.4-29.4-17l-77.8 20.9-66.2-38.2 66.2-38.2 77.8 20.9c12.8 3.4 26-4.2 29.4-17s-4.2-26-17-29.4l-31.5-8.4 67.6-39c11.5-6.6 15.4-21.3 8.8-32.8s-21.3-15.4-32.8-8.8l-67.6 39 8.4-31.5c3.4-12.8-4.2-26-17-29.4s-26 4.2-29.4 17l-20.9 77.8-66.2 38.2 0-76.5 57-57c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23 0-78.1z"],
    "bookmark": [384, 512, [128278, 61591], "f02e", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 417.1c0 25.6-28.5 40.8-49.8 26.6L192 412.8 49.8 507.7C28.5 521.9 0 506.6 0 481.1L0 64zM64 48c-8.8 0-16 7.2-16 16l0 387.2 117.4-78.2c16.1-10.7 37.1-10.7 53.2 0L336 451.2 336 64c0-8.8-7.2-16-16-16L64 48z"],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", "M48 416c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320zm16 64c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zm64-224c0-6.7 2.8-13 7.7-17.6l112-104c7-6.5 17.2-8.2 25.9-4.4S288 142.5 288 152l0 208c0 9.5-5.7 18.2-14.4 22s-18.9 2.1-25.9-4.4l-112-104c-4.9-4.5-7.7-10.9-7.7-17.6z"],
    "handshake": [640, 512, [129309, 62662, "handshake-alt", "handshake-simple"], "f2b5", "M598.1 75.4c10.7-7.8 13.1-22.8 5.3-33.5s-22.8-13.1-33.5-5.3l-74.5 54.2-9.9-6.6C465.8 71 442.6 64 418.9 64l-59.2 0-.4 0-143.6 0c-26.7 0-52.5 8.9-73.4 25.1L70.1 36.6c-10.7-7.8-25.7-5.4-33.5 5.3s-5.4 25.7 5.3 33.5l88 64c9.6 6.9 22.7 5.9 31.1-2.4l3.9-3.9c13.5-13.5 31.8-21.1 50.9-21.1l46.3 0-91.7 91.7c-15.6 15.6-15.6 40.9 0 56.6l.8 .8C218 308 294 308 340.9 261.1l27.1-27.1 97.8 97.8c15.6 15.6 15.6 40.9 0 56.6l-9.8 9.8-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l28 28c-17.5 10.4-37.2 16.7-57.6 18.5L313 399c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l15 15-3.8 0c-36.1 0-70.7-14.3-96.2-39.8L65 279c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L160.2 442.1c34.5 34.5 81.3 53.9 130.1 53.9l51.8 0 1 1 1-1 5.7 0c48.8 0 95.6-19.4 130.1-53.9l19.9-19.9c1.2-1.2 2.3-2.3 3.4-3.5 .7-.5 1.3-1.1 1.9-1.7L609 313c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-53.8 53.8c-4.2-12.8-11.3-24.9-21.5-35.1L385 183c-9.4-9.4-24.6-9.4-33.9 0l-44.1 44.1c-26.5 26.5-68.5 28-96.7 4.6l98.7-98.7c13.4-13.4 31.6-21 50.6-21.1l8.5 0 .2 0 50.8 0c14.2 0 28.1 4.2 39.9 12.1L482.7 140c8.4 5.6 19.3 5.3 27.4-.6l88-64z"],
    "face-smile-wink": [512, 512, [128521, "smile-wink"], "f4da", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm177.3 63.4C192.3 335 218.4 352 256 352s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "face-grin-squint-tears": [512, 512, [129315, "grin-squint-tears"], "f586", "M403.1 403.1c67.2-67.2 78.8-168.9 34.9-248l36.7-5.2c4.5-.6 8.8-1.6 13.1-2.8 44.6 94.9 27.7 211.5-50.7 290s-195.1 95.3-290 50.7c1.2-4.2 2.1-8.6 2.8-13.1l5.2-36.7c79.1 43.9 180.8 32.3 248-34.9zM75 75c78.4-78.4 195.1-95.3 290-50.7-1.2 4.2-2.1 8.6-2.8 13.1l-5.2 36.7c-79.1-43.9-180.8-32.3-248 34.9s-78.8 168.9-34.9 248l-36.7 5.2c-4.5 .6-8.8 1.6-13.1 2.8-44.6-94.9-27.7-211.5 50.7-290zM370.9 206.5c5.8-10.9 21.1-12.4 26.4-1.3 25.6 53.5 16.2 119.6-28.2 163.9-44.3 44.3-110.3 53.7-163.8 28.2-11.1-5.3-9.6-20.6 1.3-26.4 32-17.1 64.2-40.8 93.8-70.4 29.7-29.7 53.4-61.9 70.5-94zM93.3 281.9c-1.7-8 2.9-15.9 10.6-18.4l84.6-28c5.7-1.9 12.1-.4 16.3 3.9s5.8 10.6 3.9 16.3l-28 84.6c-2.6 7.7-10.5 12.3-18.4 10.6s-13.4-9-12.7-17.1l3.9-43.1-43.1 3.9c-8.1 .7-15.5-4.7-17.1-12.7zM294.6 110.4l-3.9 43.1 43.1-3.9c8.1-.7 15.5 4.7 17.1 12.7s-2.9 15.9-10.6 18.4l-84.6 28c-5.7 1.9-12.1 .4-16.3-3.9s-5.8-10.6-3.9-16.3l28-84.6c2.6-7.7 10.5-12.3 18.4-10.6s13.4 9 12.7 17.1zM512 51.4c0 25.6-18.8 47.3-44.1 50.9L421.1 109c-10.6 1.5-19.6-7.5-18.1-18.1l6.7-46.7C413.3 18.8 435 0 460.6 0 489 0 512 23 512 51.4zM44.1 409.7L90.9 403c10.6-1.5 19.6 7.5 18.1 18.1l-6.7 46.7C98.7 493.2 77 512 51.4 512 23 512 0 489 0 460.6 0 435 18.8 413.3 44.1 409.7z"],
    "file-audio": [384, 512, [], "f1c7", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM221.9 267.6c-4.7 10-.3 21.9 9.7 26.6 19.2 8.9 32.4 28.3 32.4 50.8s-13.2 41.9-32.4 50.8c-10 4.7-14.4 16.6-9.7 26.6s16.6 14.4 26.6 9.7C281.2 416.8 304 383.6 304 345s-22.8-71.9-55.6-87.1c-10-4.7-21.9-.3-26.6 9.7zM104 305c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24l16 0 27.2 34c3 3.8 7.6 6 12.5 6l.3 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16l-.3 0c-4.9 0-9.5 2.2-12.5 6l-27.2 34-16 0zM223.3 373c9.9-5.4 16.7-16 16.7-28.1s-6.7-22.7-16.7-28.1c-7.8-4.2-15.3 3.3-15.3 12.1l0 32c0 8.8 7.6 16.3 15.3 12.1z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16l-264 0zm171.9 92.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M256 464a208 208 0 1 1 0-416 208 208 0 1 1 0 416zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM244.7 387.3c6.2 6.2 16.4 6.2 22.6 0l104-104c4.6-4.6 5.9-11.5 3.5-17.4S366.5 256 360 256l-72 0 0-104c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 104-72 0c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l104 104z"],
    "file-lines": [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm56 256c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "comments": [576, 512, [128490, 61670], "f086", "M76.2 258.7c6.1-15.2 4-32.6-5.6-45.9-14.5-20.1-22.6-43.7-22.6-68.8 0-66.8 60.5-128 144-128s144 61.2 144 128-60.5 128-144 128c-15.9 0-31.1-2.3-45.3-6.5-10.3-3.1-21.4-2.5-31.4 1.5l-50.4 20.2 11.4-28.5zM0 144c0 35.8 11.6 69.1 31.7 96.8L1.9 315.2c-1.3 3.2-1.9 6.6-1.9 10 0 14.8 12 26.8 26.8 26.8 3.4 0 6.8-.7 10-1.9l96.3-38.5c18.6 5.5 38.4 8.4 58.9 8.4 106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144zM384 512c20.6 0 40.3-3 58.9-8.4l96.3 38.5c3.2 1.3 6.6 1.9 10 1.9 14.8 0 26.8-12 26.8-26.8 0-3.4-.7-6.8-1.9-10l-29.7-74.4c20-27.8 31.7-61.1 31.7-96.8 0-82.4-61.7-151.5-145-170.7-1.6 16.3-5.1 31.9-10.1 46.9 63.9 14.8 107.2 67.3 107.2 123.9 0 25.1-8.1 48.7-22.6 68.8-9.6 13.3-11.7 30.6-5.6 45.9l11.4 28.5-50.4-20.2c-10-4-21.1-4.5-31.4-1.5-14.2 4.2-29.4 6.5-45.3 6.5-72.2 0-127.1-45.7-140.7-101.2-15.6 3.2-31.7 5-48.1 5.2 16.4 81.9 94.7 144 188.8 144z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-464a208 208 0 1 0 0 416 208 208 0 1 0 0-416zm70.7 121.9c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L243.4 366.1c-4.1 5.7-10.5 9.3-17.5 9.8-7 .5-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l36 36 105.6-145.2z"],
    "moon": [512, 512, [127769, 9214], "f186", "M239.3 48.7c-107.1 8.5-191.3 98.1-191.3 207.3 0 114.9 93.1 208 208 208 33.3 0 64.7-7.8 92.6-21.7-103.4-23.4-180.6-115.8-180.6-226.3 0-65.8 27.4-125.1 71.3-167.3zM0 256c0-141.4 114.6-256 256-256 19.4 0 38.4 2.2 56.7 6.3 9.9 2.2 17.3 10.5 18.5 20.5s-4 19.8-13.1 24.4c-60.6 30.2-102.1 92.7-102.1 164.8 0 101.6 82.4 184 184 184 5 0 9.9-.2 14.8-.6 10.1-.8 19.6 4.8 23.8 14.1s2 20.1-5.3 27.1C387.3 484.8 324.8 512 256 512 114.6 512 0 397.4 0 256z"],
    "closed-captioning": [512, 512, [], "f20a", "M448 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l384 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm88 144l32 0c4.4 0 8 3.6 8 8 0 13.3 10.7 24 24 24s24-10.7 24-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 80c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8zm168 8c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8 0 13.3 10.7 24 24 24s24-10.7 24-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 80c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-80z"],
    "images": [576, 512, [], "f302", "M480 80c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16l-320 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l320 0zM160 32c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L160 32zm80 112a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm140.7 3.8c-4.3-7.3-12.2-11.8-20.7-11.8s-16.4 4.5-20.7 11.8l-46.5 79-17.2-24.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S191.1 320 200 320l240 0c8.6 0 16.6-4.6 20.8-12.1s4.2-16.7-.1-24.1l-80-136zM48 152c0-13.3-10.7-24-24-24S0 138.7 0 152L0 448c0 35.3 28.7 64 64 64l360 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 464c-8.8 0-16-7.2-16-16l0-296z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm387.3 11.3c6.2-6.2 6.2-16.4 0-22.6l-104-104c-4.6-4.6-11.5-5.9-17.4-3.5S256 145.5 256 152l0 72-104 0c-13.3 0-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24l104 0 0 72c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l104-104z"],
    "id-card": [576, 512, [62147, "drivers-license"], "f2c2", "M48 416l0-256 480 0 0 256c0 8.8-7.2 16-16 16l-192 0c0-44.2-35.8-80-80-80l-64 0c-44.2 0-80 35.8-80 80l-32 0c-8.8 0-16-7.2-16-16zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM208 312a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM376 208c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM212.5 147.5c-7.4-4.5-16.7-4.7-24.3-.5S176 159.3 176 168l0 176c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88zM298 256l-74 45.2 0-90.4 74 45.2z"],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm118.3 58.2c-4.2-13.7 7.1-26.2 21.4-26.2l232.6 0c14.3 0 25.6 12.5 21.4 26.2-18 58.9-72.9 101.8-137.7 101.8S136.3 373.1 118.3 314.2zM176 180c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zm132 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M384 48c8.8 0 16 7.2 16 16l0 384c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16L80 64c0-8.8 7.2-16 16-16l288 0zM96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L96 0zM240 248a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-32 40c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80l-64 0zM512 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM496 192c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zm16 144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"],
    "hourglass": [384, 512, [9203, 62032, "hourglass-empty"], "f254", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l8 0 0 19c0 40.3 16 79 44.5 107.5l81.5 81.5-81.5 81.5C48 366 32 404.7 32 445l0 19-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-19c0-40.3-16-79-44.5-107.5l-81.5-81.5 81.5-81.5C336 146 352 107.3 352 67l0-19 8 0c13.3 0 24-10.7 24-24S373.3 0 360 0L24 0zM192 289.9l81.5 81.5C293 391 304 417.4 304 445l0 19-224 0 0-19c0-27.6 11-54 30.5-73.5L192 289.9zm0-67.9l-81.5-81.5C91 121 80 94.6 80 67l0-19 224 0 0 19c0 27.6-11 54-30.5 73.5L192 222.1z"],
    "headphones": [448, 512, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M48 224c0-97.2 78.8-176 176-176s176 78.8 176 176l0 44.8c-14.1-8.2-30.5-12.8-48-12.8l-16 0c-26.5 0-48 21.5-48 48l0 128c0 26.5 21.5 48 48 48l16 0c53 0 96-43 96-96l0-160C448 100.3 347.7 0 224 0S0 100.3 0 224L0 384c0 53 43 96 96 96l16 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-16 0c-17.5 0-33.9 4.7-48 12.8L48 224zm0 128c0-26.5 21.5-48 48-48l16 0 0 128-16 0c-26.5 0-48-21.5-48-48l0-32zm352 0l0 32c0 26.5-21.5 48-48 48l-16 0 0-128 16 0c26.5 0 48 21.5 48 48z"],
    "file-powerpoint": [384, 512, [], "f1c4", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm88 256c-13.3 0-24 10.7-24 24l0 128c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 28 0c37.6 0 68-30.4 68-68s-30.4-68-68-68l-52 0zm52 88l-28 0 0-40 28 0c11 0 20 9 20 20s-9 20-20 20z"],
    "window-maximize": [512, 512, [128470], "f2d0", "M48 224l0 160c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-160-416 0zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128z"],
    "comment-dots": [512, 512, [128172, 62075, "commenting"], "f4ad", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM144 272a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm144-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm80 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-grin-tongue-wink": [512, 512, [128540, "grin-tongue-wink"], "f58b", "M366.9 432c.8-5.2 1.1-10.6 1.1-16l0-53.5c10.2-12.6 18.3-26.9 23.8-42.5 4.1-11.6-7.8-21.4-19.6-17.8-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8 5.5 15.5 13.6 29.9 23.8 42.4l0 53.5c0 5.4 .4 10.8 1.1 16-58.4-36.8-97.1-101.9-97.1-176 0-114.9 93.1-208 208-208s208 93.1 208 208c0 74.1-38.8 139.2-97.1 176zm-38.8 69.7C434.4 470.6 512 372.3 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256C0 372.3 77.6 470.6 183.9 501.7 203.4 518.1 228.5 528 256 528s52.6-9.9 72.1-26.3zM320 378.6l0 37.4c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-37.4c0-14.7 11.9-26.6 26.6-26.6l2 0c11.3 0 21.1 7.9 23.6 18.9 2.8 12.6 20.8 12.6 23.6 0 2.5-11.1 12.3-18.9 23.6-18.9l2 0c14.7 0 26.6 11.9 26.6 26.6zM132 232c0-11 9-20 20-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20zm228.4-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM288 208a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "hourglass-half": [384, 512, ["hourglass-2"], "f252", "M0 24C0 10.7 10.7 0 24 0L360 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 19c0 40.3-16 79-44.5 107.5l-81.5 81.5 81.5 81.5C336 366 352 404.7 352 445l0 19 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-19c0-40.3 16-79 44.5-107.5l81.5-81.5-81.5-81.5C48 146 32 107.3 32 67l0-19-8 0C10.7 48 0 37.3 0 24zM110.5 371.5c-3.9 3.9-7.5 8.1-10.7 12.5l184.4 0c-3.2-4.4-6.8-8.6-10.7-12.5l-81.5-81.5-81.5 81.5zM80.8 432c-.5 4.3-.8 8.6-.8 13l0 19 224 0 0-19c0-4.4-.3-8.7-.8-13L80.8 432zM254.1 160l-124.1 0 62.1 62.1 62.1-62.1zm39.7-48C300.4 98.1 304 82.7 304 67l0-19-224 0 0 19c0 15.7 3.6 31.1 10.2 45l203.5 0z"],
    "credit-card": [512, 512, [128179, 62083, "credit-card-alt"], "f09d", "M448 112c8.8 0 16 7.2 16 16l0 32-416 0 0-32c0-8.8 7.2-16 16-16l384 0zm16 112l0 160c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-160 416 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM80 344c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm144 0c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0c-13.3 0-24 10.7-24 24z"],
    "hand-spock": [512, 512, [128406], "f259", "M138.3 80.8c-9.2-33.8 10.5-68.8 44.3-78.4 34-9.6 69.4 10.2 79 44.2L291.9 153.7 305.1 84c6.6-34.7 40.1-57.5 74.8-50.9 31.4 6 53 33.9 52 64.9 10-2.6 20.8-2.8 31.5-.1 34.3 8.6 55.1 43.3 46.6 77.6L454.7 397.2C437.8 464.7 377.2 512 307.6 512l-33.7 0c-56.9 0-112.2-19-157.2-53.9l-92-71.6c-27.9-21.7-32.9-61.9-11.2-89.8s61.9-32.9 89.8-11.2l17 13.2-51.8-131.2c-13-32.9 3.2-70.1 36-83 11.1-4.4 22.7-5.4 33.7-3.7zm77.1-21.2c-2.4-8.5-11.2-13.4-19.7-11s-13.4 11.2-11 19.7l54.8 182.4c3.5 12.3-3.3 25.2-15.4 29.3s-25.3-2-30-13.9L142.9 138.1c-3.2-8.2-12.5-12.3-20.8-9s-12.3 12.5-9 20.8l73.3 185.6c12 30.3-23.7 57-49.4 37L73.8 323.4c-7-5.4-17-4.2-22.5 2.8s-4.2 17 2.8 22.5l92 71.6c36.5 28.4 81.4 43.8 127.7 43.8l33.7 0c47.5 0 89-32.4 100.5-78.5l55.4-221.6c2.1-8.6-3.1-17.3-11.6-19.4s-17.3 3.1-19.4 11.6l-26 104c-2.9 11.7-13.4 19.9-25.5 19.9-16.5 0-28.9-15-25.8-31.2L383.7 99c1.7-8.7-4-17.1-12.7-18.7S354 84.3 352.3 93L320.5 260c-2.2 11.6-12.4 20-24.2 20-11 0-20.7-7.3-23.7-17.9L215.4 59.6z"],
    "bell-slash": [576, 512, [128277, 61943], "f1f6", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-87.8-87.8c17.5-3.3 30.8-18.7 30.8-37.1 0-6.7-1.8-13.3-5.1-19L485 321.7c-19-32.6-29-69.6-29-107.3l0-14.5c0-84.6-62.6-154.7-144-166.3l0-9.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 9.7c-42.2 6-79.4 27.8-105.4 59.1L41-24.9zM192.8 126.9C214.7 98.4 249.2 80 288 80 354.3 80 408 133.7 408 200l0 14.5c0 46.2 12.3 91.5 35.5 131.4l12.9 22.1-22.6 0-241.1-241.1zM132.5 345.9c19.5-33.4 31.3-70.7 34.6-109l-46.7-46.7c-.2 3.3-.3 6.6-.3 9.9l0 14.5c0 37.7-10 74.7-29 107.3L69.1 359.2c-3.4 5.8-5.1 12.3-5.1 19 0 20.9 16.9 37.8 37.8 37.8l244.4 0-48-48-178.6 0 12.9-22.1zM220.1 464c9.9 28 36.6 48 67.9 48s58-20 67.9-48l-135.8 0z"],
    "star": [576, 512, [11088, 61446], "f005", "M288.1-32c9 0 17.3 5.1 21.4 13.1L383 125.3 542.9 150.7c8.9 1.4 16.3 7.7 19.1 16.3s.5 18-5.8 24.4L441.7 305.9 467 465.8c1.4 8.9-2.3 17.9-9.6 23.2s-17 6.1-25 2L288.1 417.6 143.8 491c-8 4.1-17.7 3.3-25-2s-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.1-14.9 19.1-16.3l159.9-25.4 73.6-144.2c4.1-8 12.4-13.1 21.4-13.1zm0 76.8L230.3 158c-3.5 6.8-10 11.6-17.6 12.8l-125.5 20 89.8 89.9c5.4 5.4 7.9 13.1 6.7 20.7l-19.8 125.5 113.3-57.6c6.8-3.5 14.9-3.5 21.8 0l113.3 57.6-19.8-125.5c-1.2-7.6 1.3-15.3 6.7-20.7l89.8-89.9-125.5-20c-7.6-1.2-14.1-6-17.6-12.8L288.1 44.8z"],
    "flag": [448, 512, [127988, 61725], "f024", "M48 24C48 10.7 37.3 0 24 0S0 10.7 0 24L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-100 80.3-20.1c41.1-10.3 84.6-5.5 122.5 13.4 44.2 22.1 95.5 24.8 141.7 7.4l34.7-13c12.5-4.7 20.8-16.6 20.8-30l0-279.7c0-23-24.2-38-44.8-27.7l-9.6 4.8c-46.3 23.2-100.8 23.2-147.1 0-35.1-17.6-75.4-22-113.5-12.5L48 52 48 24zm0 77.5l96.6-24.2c27-6.7 55.5-3.6 80.4 8.8 54.9 27.4 118.7 29.7 175 6.8l0 241.8-24.4 9.1c-33.7 12.6-71.2 10.7-103.4-5.4-48.2-24.1-103.3-30.1-155.6-17.1l-68.6 17.2 0-237z"],
    "lemon": [448, 512, [127819], "f094", "M368 80c-3.2 0-6.2 .4-8.9 1.3-19.1 5.5-46.1 10.7-74.3 3.3-57.4-14.9-124.6 7.4-174.7 57.5S37.7 259.4 52.6 316.8c7.3 28.2 2.2 55.2-3.3 74.3-.8 2.8-1.3 5.8-1.3 8.9 0 17.7 14.3 32 32 32 3.2 0 6.2-.4 8.9-1.3 19.1-5.5 46.1-10.7 74.3-3.3 57.4 14.9 124.6-7.4 174.7-57.5s72.4-117.3 57.5-174.7c-7.3-28.2-2.2-55.2 3.3-74.3 .8-2.8 1.3-5.8 1.3-8.9 0-17.7-14.3-32-32-32zm0-48c44.2 0 80 35.8 80 80 0 7.7-1.1 15.2-3.1 22.3-4.6 15.8-7.1 32.9-3 48.9 20.1 77.6-10.9 161.5-70 220.7s-143.1 90.2-220.7 70c-16-4.1-33-1.6-48.9 3-7.1 2-14.6 3.1-22.3 3.1-44.2 0-80-35.8-80-80 0-7.7 1.1-15.2 3.1-22.3 4.6-15.8 7.1-32.9 3-48.9-20.1-77.6 10.9-161.5 70-220.7S219.3 18 296.8 38.1c16 4.1 33 1.6 48.9-3 7.1-2 14.6-3.1 22.3-3.1zM246.7 167c-52 15.2-96.5 59.7-111.7 111.7-3.7 12.7-17.1 20-29.8 16.3S85.2 278 89 265.3c19.8-67.7 76.6-124.5 144.3-144.3 12.7-3.7 26.1 3.6 29.8 16.3s-3.6 26.1-16.3 29.8z"],
    "window-restore": [576, 512, [], "f2d2", "M512 80L224 80c-8.8 0-16 7.2-16 16l0 16-48 0 0-16c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64l-48 0 0-48 48 0c8.8 0 16-7.2 16-16l0-192c0-8.8-7.2-16-16-16zM368 288l-320 0 0 128c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-128zM64 160l288 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64z"],
    "face-grin-hearts": [512, 512, [128525, "grin-hearts"], "f584", "M464 256c0 114.9-93.1 208-208 208S48 370.9 48 256c0-3.5 .1-7.1 .3-10.6-14-13.9-29.7-33.1-39.3-56.7-5.8 21.4-8.9 44-8.9 67.3 0 141.4 114.6 256 256 256S512 397.4 512 256c0-23.3-3.1-45.9-8.9-67.3-9.6 23.7-25.4 42.8-39.3 56.7 .2 3.5 .3 7 .3 10.6zM368 58.9c11.7-6 24.5-9.6 37.7-10.6-42.1-30.4-93.8-48.3-149.7-48.3S148.4 17.9 106.3 48.3c13.2 1 26 4.6 37.7 10.6 13.8-7.1 29.3-10.9 45.1-10.9l2.9 0c8.9 0 17.6 1.2 25.8 3.5 12.4-2.3 25.2-3.5 38.2-3.5s25.8 1.2 38.2 3.5c8.2-2.3 16.9-3.5 25.8-3.5l2.9 0c15.8 0 31.3 3.8 45.1 10.9zm4.2 243.4c-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8 19.8 55.9 73.1 95.9 135.8 95.9 62.7 0 116-40.1 135.8-96 4.1-11.6-7.8-21.4-19.6-17.8zM322.9 96L320 96c-26.5 0-48 21.5-48 48 0 53.4 66.9 95.7 89 108.2 4.4 2.5 9.6 2.5 14 0 22.1-12.5 89-54.8 89-108.2 0-26.5-21.5-48-48-48l-2.9 0c-13.5 0-26.5 5.4-36 14.9l-9.1 9.1-9.1-9.1c-9.5-9.5-22.5-14.9-36-14.9zm-188 14.9c-9.5-9.5-22.5-14.9-36-14.9L96 96c-26.5 0-48 21.5-48 48 0 53.4 66.9 95.7 89 108.2 4.4 2.5 9.6 2.5 14 0 22.1-12.5 89-54.8 89-108.2 0-26.5-21.5-48-48-48l-2.9 0c-13.5 0-26.5 5.4-36 14.9l-9.1 9.1-9.1-9.1z"],
    "face-kiss-beam": [512, 512, [128537, "kiss-beam"], "f597", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 16l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-64-92c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zm132 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "file-pdf": [576, 512, [], "f1c1", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0 48-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM240 380l32 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-12 0 0 28c0 11-9 20-20 20s-20-9-20-20l0-128c0-11 9-20 20-20zm32 80c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0zm96-80l32 0c28.7 0 52 23.3 52 52l0 64c0 28.7-23.3 52-52 52l-32 0c-11 0-20-9-20-20l0-128c0-11 9-20 20-20zm32 128c6.6 0 12-5.4 12-12l0-64c0-6.6-5.4-12-12-12l-12 0 0 88 12 0zm76-108c0-11 9-20 20-20l48 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 24 28 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-128z"],
    "face-grin-wide": [512, 512, [128515, "grin-alt"], "f581", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm372.2 46.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM224 192c0 35.3-14.3 64-32 64s-32-28.7-32-64 14.3-64 32-64 32 28.7 32 64zm96 64c-17.7 0-32-28.7-32-64s14.3-64 32-64 32 28.7 32 64-14.3 64-32 64z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm125.2 76.4c-6.5-14 5-28.4 20.4-28.4l220.8 0c15.4 0 26.8 14.4 20.4 28.4-22.8 49.4-72.8 83.6-130.8 83.6s-107.9-34.2-130.8-83.6zm-2.6-173.2c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3c-6.2-5.2-7.6-14.3-3.1-21.1zm263.6 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1z"],
    "face-kiss-wink-heart": [640, 512, [128536, "kiss-wink-heart"], "f598", "M386 439.5c-29.2 15.6-62.5 24.5-98 24.5-114.9 0-208-93.1-208-208S173.2 48 288 48c113.2 0 205.2 90.4 207.9 202.9 14.3 1.5 28.6 6 41.9 13.7 2 1.2 4 2.4 5.9 3.7 .2-4.1 .3-8.2 .3-12.3 0-141.4-114.6-256-256-256S32 114.6 32 256 146.6 512 288 512c41.4 0 80.5-9.8 115.1-27.3-5.8-12.9-12-28.5-17.2-45.2zM256 288c0 8.8 7.2 16 16 16l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c26.5 0 48-21.5 48-48 0-12.3-4.6-23.5-12.2-32 7.6-8.5 12.2-19.7 12.2-32 0-26.5-21.5-48-48-48l-32 0c-8.8 0-16 7.2-16 16zm-48-48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm152-44l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20 9-20 20-20zM542.8 350c-2.2-18.3-12.9-34.6-28.9-43.8-28.1-16.2-63.9-6.6-80.1 21.5l-2.7 4.6c-24.5 42.5 7.9 117.9 24.4 150.8 5.1 10.1 15.5 16.1 26.8 15.5 36.7-2.2 118.2-11.7 142.8-54.2l2.7-4.6c16.2-28.1 6.6-63.9-21.5-80.1-16-9.2-35.4-10.4-52.4-3.1l-9.8 4.2-1.3-10.6z"],
    "copy": [448, 512, [], "f0c5", "M384 336l-192 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l133.5 0c4.2 0 8.3 1.7 11.3 4.7l58.5 58.5c3 3 4.7 7.1 4.7 11.3L400 320c0 8.8-7.2 16-16 16zM192 384l192 0c35.3 0 64-28.7 64-64l0-197.5c0-17-6.7-33.3-18.7-45.3L370.7 18.7C358.7 6.7 342.5 0 325.5 0L192 0c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-16-48 0 0 16c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l16 0 0-48-16 0z"],
    "chess-king": [448, 512, [9818], "f43f", "M224-32c13.3 0 24 10.7 24 24l0 40 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 80 161.8 0c21.1 0 38.2 17.1 38.2 38.2 0 6.4-1.6 12.7-4.7 18.3L357.2 374.5 405.6 435c6.7 8.4 10.4 18.8 10.4 29.6 0 26.2-21.2 47.4-47.4 47.4L79.4 512c-26.2 0-47.4-21.2-47.4-47.4 0-10.8 3.7-21.2 10.4-29.6L90.8 374.5 4.7 216.6C1.6 210.9 0 204.6 0 198.2 0 177.1 17.1 160 38.2 160l161.8 0 0-80-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-40c0-13.3 10.7-24 24-24zM131.8 400l-3.6 4.4-47.6 59.6 286.6 0-47.6-59.6-3.6-4.4-184.3 0zm1.1-48.5l.3 .5 181.6 0 .3-.5 78.3-143.5-338.7 0 78.3 143.5z"],
    "square-plus": [448, 512, [61846, "plus-square"], "f0fe", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM200 344l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"],
    "file-code": [384, 512, [], "f1c9", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM170.2 295.6c8.6-10.1 7.5-25.2-2.6-33.8s-25.2-7.5-33.8 2.6l-48 56c-7.7 9-7.7 22.2 0 31.2l48 56c8.6 10.1 23.8 11.2 33.8 2.6s11.2-23.8 2.6-33.8l-34.6-40.4 34.6-40.4zm80-31.2c-8.6-10.1-23.8-11.2-33.8-2.6s-11.2 23.8-2.6 33.8l34.6 40.4-34.6 40.4c-8.6 10.1-7.5 25.2 2.6 33.8s25.2 7.5 33.8-2.6l48-56c7.7-9 7.7-22.2 0-31.2l-48-56z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm372.2 46.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "money-bill-1": [512, 512, ["money-bill-alt"], "f3d1", "M112 112c0 35.3-28.7 64-64 64l0 160c35.3 0 64 28.7 64 64l288 0c0-35.3 28.7-64 64-64l0-160c-35.3 0-64-28.7-64-64l-288 0zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm256 16a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm-16 44c-11 0-20 9-20 20 0 9.7 6.9 17.7 16 19.6l0 48.4-4 0c-11 0-20 9-20 20s9 20 20 20l48 0c11 0 20-9 20-20s-9-20-20-20l-4 0 0-68c0-11-9-20-20-20l-16 0z"],
    "eye-slash": [576, 512, [], "f070", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-96.4-96.4c2.7-2.4 5.4-4.8 8-7.2 46.8-43.5 78.1-95.4 93-131.1 3.3-7.9 3.3-16.7 0-24.6-14.9-35.7-46.2-87.7-93-131.1-47.1-43.7-111.8-80.6-192.6-80.6-56.8 0-105.6 18.2-146 44.2L41-24.9zM176.9 111.1c32.1-18.9 69.2-31.1 111.1-31.1 65.2 0 118.8 29.6 159.9 67.7 38.5 35.7 65.1 78.3 78.6 108.3-13.6 30-40.2 72.5-78.6 108.3-3.1 2.8-6.2 5.6-9.4 8.4L393.8 328c14-20.5 22.2-45.3 22.2-72 0-70.7-57.3-128-128-128-26.7 0-51.5 8.2-72 22.2l-39.1-39.1zm182 182l-108-108c11.1-5.8 23.7-9.1 37.1-9.1 44.2 0 80 35.8 80 80 0 13.4-3.3 26-9.1 37.1zM103.4 173.2l-34-34c-32.6 36.8-55 75.8-66.9 104.5-3.3 7.9-3.3 16.7 0 24.6 14.9 35.7 46.2 87.7 93 131.1 47.1 43.7 111.8 80.6 192.6 80.6 37.3 0 71.2-7.9 101.5-20.6L352.2 422c-20 6.4-41.4 10-64.2 10-65.2 0-118.8-29.6-159.9-67.7-38.5-35.7-65.1-78.3-78.6-108.3 10.4-23.1 28.6-53.6 54-82.8z"],
    "file-word": [384, 512, [], "f1c2", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm71.3 274.2c-3.2-12.9-16.2-20.7-29.1-17.5S85.5 273 88.7 285.8l32 128c2.5 10.2 11.4 17.5 21.9 18.1s20.1-5.7 23.8-15.5l25.5-68.1 25.5 68.1c3.7 9.8 13.3 16.1 23.8 15.5s19.4-7.9 21.9-18.1l32-128c3.2-12.9-4.6-25.9-17.5-29.1s-25.9 4.6-29.1 17.5l-13.3 53.2-20.9-55.8C211 262.2 202 256 192 256s-19 6.2-22.5 15.6l-20.9 55.8-13.3-53.2z"],
    "face-angry": [512, 512, [128544, "angry"], "f556", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-144c24.1 0 45.4 11.8 58.5 30 7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5c-21.7-30.2-57.3-50-97.5-50s-75.7 19.8-97.5 50c-7.7 10.8-5.3 25.8 5.5 33.5s25.8 5.3 33.5-5.5c13.1-18.2 34.4-30 58.5-30zm-80-96c17.7 0 32-14.3 32-32l0-.3 9.7 3.2c10.5 3.5 21.8-2.2 25.3-12.6s-2.2-21.8-12.6-25.3l-96-32c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3l28.9 9.6c-4.1 5.4-6.6 12.1-6.6 19.4 0 17.7 14.3 32 32 32zm192-32c0-7.3-2.4-14-6.6-19.4l28.9-9.6c10.5-3.5 16.1-14.8 12.6-25.3s-14.8-16.1-25.3-12.6l-96 32c-10.5 3.5-16.1 14.8-12.6 25.3s14.8 16.1 25.3 12.6l9.7-3.2 0 .3c0 17.7 14.3 32 32 32s32-14.3 32-32z"],
    "chess-knight": [448, 512, [9822], "f441", "M232-32c110.5 0 200 89.5 200 200l0 127.7c0 18.9-6.1 37.1-17.2 52.2l-5.1 6.2-36.3 40.7 32.1 40.2c6.7 8.4 10.4 18.8 10.4 29.6l-.2 4.8c-2.4 23.9-22.6 42.5-47.1 42.5l-289.2 0-4.8-.2c-23.9-2.4-42.5-22.6-42.5-47.1 0-10.8 3.7-21.2 10.4-29.6l37.6-47 0-24.3c0-24.3 10.1-47.6 27.8-64.2l63.5-59.5-17.4 0-.2 .2c-20.3 20.3-49.6 28.2-77.1 21.1l-5.5-1.6c-30.9-10.3-52.3-38-54.9-70.1l-.2-6.4 0-1.4c0-19.7 7.1-38.8 19.9-53.8l76.1-88.8 0-47.1 .1-2.5C113.4-22.6 123.6-32 136-32l96 0zM80.7 464l286.6 0-38.4-48-209.9 0-38.4 48zM160 48c0 5.7-2.1 11.3-5.8 15.6L72.3 159.1C67 165.4 64 173.4 64 181.7l0 1.4 .4 5.2c1.9 11.9 10.3 21.9 21.9 25.8l4.5 1.1c10.5 1.9 21.3-1.4 29-9l7.2-7.2 3.7-3c3.9-2.6 8.5-4 13.3-4l88 0c9.8 0 18.7 6 22.3 15.2s1.3 19.6-5.9 26.3l-107.8 101c-8.1 7.6-12.7 18.1-12.7 29.2l0 4.3 205.2 0 40.7-45.8 2.3-2.8c5.1-6.8 7.8-15.2 7.8-23.7L384 168c0-83.9-68.1-152-152-152l-72 0 0 32zm32 72a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "face-grin-beam": [512, 512, [128516, "grin-beam"], "f582", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm372.2 46.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM176 180c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zm132 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "hand-peace": [448, 512, [9996], "f25b", "M219 1.4c-35.2-3.7-66.6 21.8-70.3 57l-6.4 60.6-17.4-49.4C113.2 36.3 76.6 18.8 43.3 30.5S-7.6 78.8 4.1 112.1L56.9 262.2C41.7 276.7 32.2 297.3 32.2 320l0 24c0 92.8 75.2 168 168 168l48 0c92.8 0 168-75.2 168-168l0-120c0-35.3-28.7-64-64-64-7.9 0-15.4 1.4-22.4 4-10.4-21.3-32.3-36-57.6-36-.7 0-1.5 0-2.2 0l5.9-56.3c3.7-35.2-21.8-66.6-57-70.3zm-.2 155.4c-6.6 10.1-10.5 22.2-10.5 35.2l0 48c0 .7 0 1.4 0 2-5.1-1.3-10.5-2-16-2l-7.4 0-5.4-15.3 17-161.3c.9-8.8 8.8-15.2 17.6-14.2s15.2 8.8 14.2 17.6l-9.5 90.1zM79.6 85.6l54.3 154.4-21.7 0c-4 0-8 .3-11.9 .9L49.4 96.2c-2.9-8.3 1.5-17.5 9.8-20.4s17.5 1.5 20.4 9.8zM256.2 192c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48zm38.4 108c10.4 21.3 32.3 36 57.6 36 5.5 0 10.9-.7 16-2l0 10c0 66.3-53.7 120-120 120l-48 0c-66.3 0-120-53.7-120-120l0-24c0-17.7 14.3-32 32-32l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c35.3 0 64-28.7 64-64 0-.7 0-1.4 0-2 5.1 1.3 10.5 2 16 2 7.9 0 15.4-1.4 22.4-4zm73.6-28c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48z"],
    "compass": [512, 512, [129517], "f14e", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm306.7 69.1L162.4 380.6c-19.4 7.5-38.5-11.6-31-31l55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4l144.3-55.5c19.4-7.5 38.5 11.6 31 31L325.1 306.7c-3.3 8.5-9.9 15.1-18.4 18.4zM288 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square": [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"],
    "face-grin": [512, 512, [128512, "grin"], "f580", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm372.2 46.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-smile": [512, 512, [128578, "smile"], "f118", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm177.3 63.4C192.3 335 218.4 352 256 352s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-smile-beam": [512, 512, [128522, "smile-beam"], "f5b8", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm177.3 63.4C192.3 335 218.4 352 256 352s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7zM176 180c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zm132 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "folder-closed": [512, 512, [], "e185", "M448 400L64 400c-8.8 0-16-7.2-16-16l0-144 416 0 0 144c0 8.8-7.2 16-16 16zm16-208l-416 0 0-96c0-8.8 7.2-16 16-16l138.7 0c3.5 0 6.8 1.1 9.6 3.2L250.7 112c13.8 10.4 30.7 16 48 16L448 128c8.8 0 16 7.2 16 16l0 48zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64z"],
    "keyboard": [576, 512, [9000], "f11c", "M64 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM176 320l224 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm-72-72c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16-96l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm64 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16-96l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm64 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16-96l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm64 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16-96l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm64 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16-96l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16z"],
    "face-rolling-eyes": [512, 512, [128580, "meh-rolling-eyes"], "f5a5", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 376c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24zM160 264c-22.1 0-40-17.9-40-40 0-9.5 3.3-18.1 8.8-25 3.2 14.3 16 25 31.2 25s28-10.7 31.2-25c5.5 6.8 8.8 15.5 8.8 25 0 22.1-17.9 40-40 40zm0 40a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm192-40c-22.1 0-40-17.9-40-40 0-9.5 3.3-18.1 8.8-25 3.2 14.3 16 25 31.2 25s28-10.7 31.2-25c5.5 6.8 8.8 15.5 8.8 25 0 22.1-17.9 40-40 40zm0 40a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "face-grimace": [512, 512, [128556, "grimace"], "f57f", "M256 48a208 208 0 1 0 0 416 208 208 0 1 0 0-416zM512 256a256 256 0 1 1 -512 0 256 256 0 1 1 512 0zM152 352c0 11.9 8.6 21.8 20 23.7l0-47.3c-11.4 1.9-20 11.8-20 23.7zm84 24l0-48-24 0 0 48 24 0zm64 0l0-48-24 0 0 48 24 0zm40-.3c11.4-1.9 20-11.8 20-23.7s-8.6-21.8-20-23.7l0 47.3zM176 288l160 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-160 0c-35.3 0-64-28.7-64-64s28.7-64 64-64zm0-112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-464a208 208 0 1 0 0 416 208 208 0 1 0 0-416zm0 304a96 96 0 1 1 0-192 96 96 0 1 1 0 192z"],
    "object-group": [576, 512, [], "f247", "M40 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm48 59.3c16-6.5 28.9-19.3 35.3-35.3l329.3 0c6.5 16 19.3 28.9 35.3 35.3l0 265.3c-16 6.5-28.9 19.3-35.3 35.3l-329.3 0c-6.5-16-19.3-28.9-35.3-35.3l0-265.3zM512 0c-26.9 0-49.9 16.5-59.3 40L123.3 40C113.9 16.5 90.9 0 64 0 28.7 0 0 28.7 0 64 0 90.9 16.5 113.9 40 123.3l0 265.3c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 26.9 0 49.9-16.5 59.3-40l329.3 0c9.5 23.5 32.5 40 59.3 40 35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-265.3c23.5-9.5 40-32.5 40-59.3 0-35.3-28.7-64-64-64zM488 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 424a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm424 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM192 176l88 0 0 56-88 0 0-56zm-8-40c-17.7 0-32 14.3-32 32l0 72c0 17.7 14.3 32 32 32l104 0c17.7 0 32-14.3 32-32l0-72c0-17.7-14.3-32-32-32l-104 0zm72 184l0 24c0 17.7 14.3 32 32 32l104 0c17.7 0 32-14.3 32-32l0-72c0-17.7-14.3-32-32-32l-24 0c0 14.6-3.9 28.2-10.7 40l26.7 0 0 56-88 0 0-16.4c-2.6 .3-5.3 .4-8 .4l-32 0z"],
    "face-flushed": [512, 512, [128563, "flushed"], "f579", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM160 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm216-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM192 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l128 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-128 0zM160 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm144-80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "star-half-stroke": [576, 512, ["star-half-alt"], "f5c0", "M309.5-18.9c-4.1-8-12.4-13.1-21.4-13.1s-17.3 5.1-21.4 13.1L193.1 125.3 33.2 150.7c-8.9 1.4-16.3 7.7-19.1 16.3s-.5 18 5.8 24.4l114.4 114.5-25.2 159.9c-1.4 8.9 2.3 17.9 9.6 23.2s16.9 6.1 25 2L288.1 417.6 432.4 491c8 4.1 17.7 3.3 25-2s11-14.2 9.6-23.2L441.7 305.9 556.1 191.4c6.4-6.4 8.6-15.8 5.8-24.4s-10.1-14.9-19.1-16.3L383 125.3 309.5-18.9zM264.1 91.8l0 284.1-100.1 50.9 19.8-125.5c1.2-7.6-1.3-15.3-6.7-20.7l-89.8-89.9 125.5-20c7.6-1.2 14.1-6 17.6-12.8l33.8-66.2zm48 284.1l0-284.1 33.8 66.2c3.5 6.8 10 11.6 17.6 12.8l125.5 20-89.8 89.9c-5.4 5.4-7.9 13.1-6.7 20.7l19.8 125.5-100.1-50.9z"],
    "file-video": [384, 512, [], "f1c8", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM80 288l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-24 35 35c3.2 3.2 7.5 5 12 5 9.4 0 17-7.6 17-17l0-94.1c0-9.4-7.6-17-17-17-4.5 0-8.8 1.8-12 5l-35 35 0-24c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm118.3 58.2c-4.2-13.7 7.1-26.2 21.4-26.2l232.6 0c14.3 0 25.6 12.5 21.4 26.2-18 58.9-72.9 101.8-137.7 101.8S136.3 373.1 118.3 314.2zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "hand-pointer": [448, 512, [], "f25a", "M160 64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 136c0 10.3 6.6 19.5 16.4 22.8s20.6-.1 26.8-8.3c3-3.9 7.6-6.4 12.8-6.4 8.8 0 16 7.2 16 16 0 10.3 6.6 19.5 16.4 22.8s20.6-.1 26.8-8.3c3-3.9 7.6-6.4 12.8-6.4 7.8 0 14.3 5.6 15.7 13 1.6 8.2 7.3 15.1 15.1 18s16.7 1.6 23.3-3.6c2.7-2.1 6.1-3.4 9.9-3.4 8.8 0 16 7.2 16 16l0 120c0 39.8-32.2 72-72 72l-116.6 0c-37.4 0-72.4-18.7-93.2-49.9L50.7 312.9c-4.9-7.4-2.9-17.3 4.4-22.2s17.3-2.9 22.2 4.4L116 353.2c5.9 8.8 16.8 12.7 26.9 9.7s17-12.4 17-23L160 64zM176 0c-35.3 0-64 28.7-64 64l0 197.7C91.2 238 55.5 232.8 28.5 250.7-.9 270.4-8.9 310.1 10.8 339.5L78.3 440.8c29.7 44.5 79.6 71.2 133.1 71.2L328 512c66.3 0 120-53.7 120-120l0-120c0-35.3-28.7-64-64-64-4.5 0-8.8 .5-13 1.3-11.7-15.4-30.2-25.3-51-25.3-6.9 0-13.5 1.1-19.7 3.1-11.6-16.4-30.7-27.1-52.3-27.1-2.7 0-5.4 .2-8 .5L240 64c0-35.3-28.7-64-64-64zm48 304c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96zm48-16c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16zm80 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96z"],
    "registered": [512, 512, [174], "f25d", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 34.4 0 41 68.3c6.8 11.4 21.6 15 32.9 8.2s15-21.6 8.2-32.9l-30.2-50.3c24.6-11.5 41.6-36.4 41.6-65.3 0-39.8-32.2-72-72-72l-80 0zm72 96l-48 0 0-48 56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0z"]
  };

  bunker(function () {
    defineIcons('far', icons);
    defineIcons('fa-regular', icons);
  });

}());
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _so;
  var z = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      }
    };
  var a = "classic",
    o = "duotone",
    d = "sharp",
    t = "sharp-duotone",
    i = "chisel",
    n = "etch",
    h = "jelly",
    s = "jelly-duo",
    f = "jelly-fill",
    g = "notdog",
    l = "notdog-duo",
    u = "slab",
    p = "slab-press",
    e = "thumbprint",
    w = "whiteboard",
    m = "Classic",
    y = "Duotone",
    x = "Sharp",
    c = "Sharp Duotone",
    I = "Chisel",
    b = "Etch",
    F = "Jelly",
    v = "Jelly Duo",
    S = "Jelly Fill",
    A = "Notdog",
    P = "Notdog Duo",
    j = "Slab",
    B = "Slab Press",
    N = "Thumbprint",
    k = "Whiteboard",
    so = (_so = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, a, m), o, y), d, x), t, c), i, I), n, b), h, F), s, v), f, S), g, A), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_so, l, P), u, j), p, B), e, N), w, k));
  var io = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      }
    };
  var Ro = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var Oo = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Go = ["kit"];
  var D = "kit",
    r = "kit-duotone",
    T = "Kit",
    C = "Kit Duotone",
    qo = _defineProperty(_defineProperty({}, D, T), r, C);
  var Xo = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var et = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var dt = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _fl;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var f$1 = "classic",
    a$1 = "duotone",
    n$1 = "sharp",
    t$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    u$1 = "jelly",
    s$1 = "jelly-duo",
    p$1 = "jelly-fill",
    y$1 = "notdog",
    e$1 = "notdog-duo",
    m$1 = "slab",
    c$1 = "slab-press",
    r$1 = "thumbprint",
    w$1 = "whiteboard",
    x$1 = "Classic",
    I$1 = "Duotone",
    b$1 = "Sharp",
    F$1 = "Sharp Duotone",
    v$1 = "Chisel",
    S$1 = "Etch",
    A$1 = "Jelly",
    j$1 = "Jelly Duo",
    P$1 = "Jelly Fill",
    B$1 = "Notdog",
    k$1 = "Notdog Duo",
    N$1 = "Slab",
    D$1 = "Slab Press",
    C$1 = "Thumbprint",
    T$1 = "Whiteboard",
    fl = (_fl = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, f$1, x$1), a$1, I$1), n$1, b$1), t$1, F$1), h$1, v$1), g$1, S$1), u$1, A$1), s$1, j$1), p$1, P$1), y$1, B$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_fl, e$1, k$1), m$1, N$1), c$1, D$1), r$1, C$1), w$1, T$1));
  var L = "kit",
    d$1 = "kit-duotone",
    R$1 = "Kit",
    W$1 = "Kit Duotone",
    lo$1 = _defineProperty(_defineProperty({}, L, R$1), d$1, W$1);
  var zo$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      }
    },
    J$1 = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"]
    },
    Go$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      }
    },
    _$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    K$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    M$1 = K$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    O$1 = ["aw", "fw", "pull-left", "pull-right"],
    Ho$1 = [].concat(_toConsumableArray(Object.keys(J$1)), _$1, O$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(K$1.map(function (o) {
      return "".concat(o, "x");
    })).concat(M$1.map(function (o) {
      return "w-".concat(o);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[a];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, z);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), z[a]), Oo['kit']), Oo['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, Ro);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[a]), dt['kit']), dt['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Go$1);
  _PREFIX_TO_LONG_STYLE[a] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[a]), et['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, zo$1);
  _LONG_STYLE_TO_PREFIX[a] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[a]), Xo['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, io);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Go), _toConsumableArray(Ho$1));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 96c-53 0-96 43-96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96z"],
    "1": [256, 512, [], "31", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l64 0 0 320-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-352c0-17.7-14.3-32-32-32L32 32z"],
    "2": [384, 512, [], "32", "M48 64c0-17.7 14.3-32 32-32l171 0c60.2 0 109 48.8 109 109 0 43.8-26.2 83.3-66.4 100.4l-139.1 59C119 315.4 96 350.2 96 388.7l0 27.3 224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-59.3c0-64.2 38.4-122.2 97.5-147.3l139.1-59c16.6-7.1 27.4-23.4 27.4-41.4 0-24.9-20.2-45-45-45L80 96C62.3 96 48 81.7 48 64z"],
    "3": [320, 512, [], "33", "M80 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l112 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l160 0c70.7 0 128 57.3 128 128 0 38.2-16.8 72.5-43.3 96 26.6 23.5 43.3 57.8 43.3 96 0 70.7-57.3 128-128 128L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L80 288z"],
    "4": [384, 512, [], "34", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 288c0 35.3 28.7 64 64 64l192 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-224c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 224-192 0 0-224z"],
    "5": [320, 512, [], "35", "M0 64C0 46.3 14.3 32 32 32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0 0 112 120 0c75.1 0 136 60.9 136 136S259.1 480 184 480L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l152 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L32 272c-17.7 0-32-14.3-32-32L0 64z"],
    "6": [384, 512, [], "36", "M256 32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0c-48.6 0-88 39.4-88 88l0 32.2c22.9-15.3 50.4-24.2 80-24.2l48 0c79.5 0 144 64.5 144 144S287.5 480 208 480l-48 0C80.5 480 16 415.5 16 336l0-152C16 100.1 84.1 32 168 32l88 0zM80 336c0 44.2 35.8 80 80 80l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0c-44.2 0-80 35.8-80 80z"],
    "7": [320, 512, [], "37", "M0 64C0 46.3 14.3 32 32 32l256 0c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-224 384c-8.9 15.3-28.5 20.4-43.8 11.5s-20.4-28.5-11.5-43.8L232.3 96 32 96C14.3 96 0 81.7 0 64z"],
    "8": [320, 512, [], "38", "M304 160c0-70.7-57.3-128-128-128l-32 0c-70.7 0-128 57.3-128 128 0 34.6 13.7 66 36 89-31.5 23.3-52 60.8-52 103 0 70.7 57.3 128 128 128l64 0c70.7 0 128-57.3 128-128 0-42.2-20.5-79.7-52-103 22.3-23 36-54.4 36-89zM176.1 288l15.9 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l48.1 0zm0-64L144 224c-35.3 0-64-28.7-64-64 0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64 0 35.3-28.6 64-64 64z"],
    "9": [384, 512, [], "39", "M208 320c29.6 0 57.1-8.9 80-24.2l0 32.2c0 48.6-39.4 88-88 88L96 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l104 0c83.9 0 152-68.1 152-152l0-152.1C351.9 96.4 287.5 32 208 32l-48 0C80.5 32 16 96.5 16 176S80.5 320 160 320l48 0zm80-144c0 44.2-35.8 80-80 80l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c44.2 0 80 35.8 80 80z"],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", "M136 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 56 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-114.9 0c-24.9 0-45.1 20.2-45.1 45.1 0 22.5 16.5 41.5 38.7 44.7l91.6 13.1c53.8 7.7 93.7 53.7 93.7 108 0 60.3-48.9 109.1-109.1 109.1l-10.9 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-72 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l130.9 0c24.9 0 45.1-20.2 45.1-45.1 0-22.5-16.5-41.5-38.7-44.7l-91.6-13.1C55.9 273.5 16 227.4 16 173.1 16 112.9 64.9 64 125.1 64l10.9 0 0-40z"],
    "dog": [576, 512, [128021], "f6d3", "M32 112c16.6 0 30.2 12.6 31.8 28.7l.3 6.6C65.8 163.4 79.4 176 96 176l179.1 0 140.9 60.4 0 243.6c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-131.3C296 361 268.8 368 240 368s-56-7-80-19.3L160 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-245.6c-37.3-13.2-64-48.6-64-90.4 0-17.7 14.3-32 32-32zM355.8-32c7.7 0 14.9 3.6 19.6 9.8L392 0 444.1 0c12.7 0 24.9 5.1 33.9 14.1L496 32 552 32c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-64 0-7 28-124.7-53.4 31.6-147.2C334.3-23.9 344.2-32 355.8-32zM448 44a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "truck-moving": [640, 512, [], "f4df", "M64 32C28.7 32 0 60.7 0 96L0 424c0 48.6 39.4 88 88 88 25.2 0 48-10.6 64-27.6 16 17 38.8 27.6 64 27.6 40.3 0 74.2-27.1 84.7-64l134.6 0c10.4 36.9 44.4 64 84.7 64 43 0 78.9-30.9 86.5-71.7 20-10.8 33.5-32 33.5-56.3l0-146.7c0-17-6.7-33.3-18.7-45.3L576 146.7c-12-12-28.3-18.7-45.3-18.7l-50.7 0 0-32c0-35.3-28.7-64-64-64L64 32zM480 192l50.7 0 45.3 45.3 0 50.7-96 0 0-96zM88 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm392 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM216 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", "M480.1 192l7.9 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2S477.9 .2 471 7L419.3 58.8C375 22.1 318 0 256 0 127 0 20.3 95.4 2.6 219.5 .1 237 12.2 253.2 29.7 255.7s33.7-9.7 36.2-27.1C79.2 135.5 159.3 64 256 64 300.4 64 341.2 79 373.7 104.3L327 151c-6.9 6.9-8.9 17.2-5.2 26.2S334.3 192 344 192l136.1 0zm29.4 100.5c2.5-17.5-9.7-33.7-27.1-36.2s-33.7 9.7-36.2 27.1c-13.3 93-93.4 164.5-190.1 164.5-44.4 0-85.2-15-117.7-40.3L185 361c6.9-6.9 8.9-17.2 5.2-26.2S177.7 320 168 320L24 320c-13.3 0-24 10.7-24 24L0 488c0 9.7 5.8 18.5 14.8 22.2S34.1 511.8 41 505l51.8-51.8C137 489.9 194 512 256 512 385 512 491.7 416.6 509.4 292.5z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm72 200l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "align-justify": [448, 512, [], "f039", "M448 64c0-17.7-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32zm0 256c0-17.7-14.3-32-32-32L32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM0 192c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32zM448 448c0-17.7-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32z"],
    "calendar-check": [448, 512, [], "f274", "M320 0c17.7 0 32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32zm22 161.7c-10.7-7.8-25.7-5.4-33.5 5.3L189.1 331.2 137 279.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.9 7.5 18.8 7s13.4-4.1 17.5-9.8L347.3 195.2c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 288l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-96-80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "kitchen-set": [576, 512, [], "e51a", "M240 144a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm44.4 32C269.9 240.1 212.5 288 144 288 64.5 288 0 223.5 0 144S64.5 0 144 0c68.5 0 125.9 47.9 140.4 112l71.8 0c8.8-9.8 21.6-16 35.8-16l104 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-104 0c-14.2 0-27-6.2-35.8-16l-71.8 0zM144 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM400 240c13.3 0 24 10.7 24 24l0 8 96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-240 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l96 0 0-8c0-13.3 10.7-24 24-24zM288 464l0-112 224 0 0 112c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48zM48 320l128 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-80c0-8.8 7.2-16 16-16zm128 64c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32 16 0zM24 464l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "dna": [384, 512, [129516], "f471", "M352 0c17.7 0 32 14.3 32 32 0 57.8-24.4 104.8-57.4 144.5-24.1 28.9-53.8 55.1-83.6 79.5 29.8 24.5 59.5 50.6 83.6 79.5 33 39.6 57.4 86.7 57.4 144.5 0 17.7-14.3 32-32 32s-32-14.3-32-32L64 480c0 17.7-14.3 32-32 32S0 497.7 0 480C0 422.2 24.4 375.2 57.4 335.5 81.5 306.6 111.2 280.5 141 256 111.2 231.5 81.5 205.4 57.4 176.5 24.4 136.8 0 89.8 0 32 0 14.3 14.3 0 32 0S64 14.3 64 32l256 0c0-17.7 14.3-32 32-32zM283.5 384l-182.9 0c-8.2 10.5-15.1 21.1-20.6 32l224.2 0c-5.6-10.9-12.5-21.5-20.6-32zM238 336c-14.3-13-29.8-25.8-46-39-16.2 13.1-31.7 26-46 39l92 0zM100.5 128l182.9 0c8.2-10.5 15.1-21.1 20.6-32L79.9 96c5.6 10.9 12.5 21.5 20.6 32zM146 176c14.3 13 29.8 25.8 46 39 16.2-13.1 31.7-26 46-39l-92 0z"],
    "child-reaching": [384, 512, [], "e59d", "M256 64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM152.9 169.3c-23.7-8.4-44.5-24.3-58.8-45.8L74.6 94.2C64.8 79.5 45 75.6 30.3 85.4S11.6 115 21.4 129.8L40.9 159c18.1 27.1 42.8 48.4 71.1 62.4L112 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-258.4c29.1-14.2 54.4-36.2 72.7-64.2l18.2-27.9c9.6-14.8 5.4-34.6-9.4-44.3s-34.6-5.5-44.3 9.4L291 122.4c-21.8 33.4-58.9 53.6-98.8 53.6-12.6 0-24.9-2-36.6-5.8-.9-.3-1.8-.7-2.7-.9z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-224c0-61.9 50.1-112 112-112l64 0 0-48c0-35.3-28.7-64-64-64L64 0zM248 112l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm40 48c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-165.5c0-17-6.7-33.3-18.7-45.3l-58.5-58.5c-12-12-28.3-18.7-45.3-18.7L288 160z"],
    "meteor": [512, 512, [9732], "f753", "M493.7 .9l-194.2 74.7 2.3-29.3c1-12.8-12.8-21.5-24-15.1L101.3 133.4C38.6 169.7 0 236.6 0 309 0 421.1 90.9 512 203 512 275.4 512 342.3 473.4 378.6 410.7L480.8 234.3c6.5-11.1-2.2-25-15.1-24l-29.3 2.3 74.7-194.2c.6-1.5 .9-3.2 .9-4.8 0-7.5-6-13.5-13.5-13.5-1.7 0-3.3 .3-4.8 .9zM192 192a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm16 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "gears": [640, 512, ["cogs"], "f085", "M415.9 210.5c12.2-3.3 25 2.5 30.5 13.8L465 261.9c10.3 1.4 20.4 4.2 29.9 8.1l35-23.3c10.5-7 24.4-5.6 33.3 3.3l19.2 19.2c8.9 8.9 10.3 22.9 3.3 33.3l-23.3 34.9c1.9 4.7 3.6 9.6 5 14.7 1.4 5.1 2.3 10.1 3 15.2l37.7 18.6c11.3 5.6 17.1 18.4 13.8 30.5l-7 26.2c-3.3 12.1-14.6 20.3-27.2 19.5l-42-2.7c-6.3 8.1-13.6 15.6-21.9 22l2.7 41.9c.8 12.6-7.4 24-19.5 27.2l-26.2 7c-12.2 3.3-24.9-2.5-30.5-13.8l-18.6-37.6c-10.3-1.4-20.4-4.2-29.9-8.1l-35 23.3c-10.5 7-24.4 5.6-33.3-3.3l-19.2-19.2c-8.9-8.9-10.3-22.8-3.3-33.3l23.3-35c-1.9-4.7-3.6-9.6-5-14.7s-2.3-10.2-3-15.2l-37.7-18.6c-11.3-5.6-17-18.4-13.8-30.5l7-26.2c3.3-12.1 14.6-20.3 27.2-19.5l41.9 2.7c6.3-8.1 13.6-15.6 21.9-22l-2.7-41.8c-.8-12.6 7.4-24 19.5-27.2l26.2-7zM448.4 340a44 44 0 1 0 .1 88 44 44 0 1 0 -.1-88zM224.9-45.5l26.2 7c12.1 3.3 20.3 14.7 19.5 27.2l-2.7 41.8c8.3 6.4 15.6 13.8 21.9 22l42-2.7c12.5-.8 23.9 7.4 27.2 19.5l7 26.2c3.2 12.1-2.5 24.9-13.8 30.5l-37.7 18.6c-.7 5.1-1.7 10.2-3 15.2s-3.1 10-5 14.7l23.3 35c7 10.5 5.6 24.4-3.3 33.3L307.3 262c-8.9 8.9-22.8 10.3-33.3 3.3L239 242c-9.5 3.9-19.6 6.7-29.9 8.1l-18.6 37.6c-5.6 11.3-18.4 17-30.5 13.8l-26.2-7c-12.2-3.3-20.3-14.7-19.5-27.2l2.7-41.9c-8.3-6.4-15.6-13.8-21.9-22l-42 2.7c-12.5 .8-23.9-7.4-27.2-19.5l-7-26.2c-3.2-12.1 2.5-24.9 13.8-30.5l37.7-18.6c.7-5.1 1.7-10.1 3-15.2 1.4-5.1 3-10 5-14.7L55.1 46.5c-7-10.5-5.6-24.4 3.3-33.3L77.6-6c8.9-8.9 22.8-10.3 33.3-3.3l35 23.3c9.5-3.9 19.6-6.7 29.9-8.1l18.6-37.6c5.6-11.3 18.3-17 30.5-13.8zM192.4 84a44 44 0 1 0 0 88 44 44 0 1 0 0-88z"],
    "file-circle-plus": [576, 512, [58606], "e494", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "icicles": [512, 512, [], "f7ad", "M75.8 304.8L1 35.7C.3 33.2 0 30.7 0 28.2 0 12.6 12.6 0 28.2 0L482.4 0c16.3 0 29.6 13.2 29.6 29.6 0 1.6-.1 3.3-.4 4.9L434.6 496.1c-1.5 9.2-9.5 15.9-18.8 15.9-9.2 0-17.1-6.6-18.7-15.6L336 160 307.2 303.9c-1.9 9.3-10.1 16.1-19.6 16.1-9.2 0-17.2-6.2-19.4-15.1L240 192 210.6 368.2c-1.5 9.1-9.4 15.8-18.6 15.8s-17.1-6.7-18.6-15.8L144 192 115.9 304.3c-2.3 9.2-10.6 15.7-20.1 15.7-9.3 0-17.5-6.2-20-15.2z"],
    "arrow-trend-up": [576, 512, [], "e098", "M384 160c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-82.7-169.4 169.4c-12.5 12.5-32.8 12.5-45.3 0L192 269.3 54.6 406.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l160-160c12.5-12.5 32.8-12.5 45.3 0L320 306.7 466.7 160 384 160z"],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", "M248 106.6c18.9-9 32-28.3 32-50.6c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 98.8c-2.8 1.3-5.5 2.9-8 4.7l-80.1-45.8c1.6-20.8-8.6-41.6-27.9-52.8C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c1.3 .8 2.6 1.5 4 2.1l0 90.8c-1.3 .6-2.7 1.3-4 2.1C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c19.3-11.1 29.4-32 27.8-52.8l50.5-28.9c-11.5-11.2-19.9-25.6-23.8-41.7L88 306.1c-2.6-1.8-5.2-3.3-8-4.7l0-90.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-.1 1.4-.2 2.8-.2 4.3c0 22.3 13.1 41.6 32 50.6l0 98.8c-18.9 9-32 28.3-32 50.6c0 30.9 25.1 56 56 56c30.7 0 55.6-24.7 56-55.2c-7.5-12.9-13.5-26.8-17.6-41.5c-4.2-4-9.1-7.3-14.4-9.9l0-98.8c2.8-1.3 5.5-2.9 8-4.7l10.5 6c5.5-15.3 13.1-29.5 22.4-42.5l-9.1-5.2c.1-1.4 .2-2.8 .2-4.3c0-22.3-13.1-41.6-32-50.6l0-98.8zM440.5 132C425 105.2 390.8 96 364 111.5c-19.3 11.1-29.4 32-27.8 52.8l-50.6 28.9c11.5 11.2 19.9 25.6 23.8 41.7L360 205.9c.4 .3 .8 .6 1.3 .9c21.7-9.5 45.6-14.8 70.8-14.8c2 0 4 0 5.9 .1c12.1-17.3 13.8-40.6 2.6-60.1zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm47.9-225c4.3 3.7 5.4 9.9 2.6 14.9L452.4 356l35.6 0c5.2 0 9.8 3.3 11.4 8.2s-.1 10.3-4.2 13.4l-96 72c-4.5 3.4-10.8 3.2-15.1-.6s-5.4-9.9-2.6-14.9L411.6 380 376 380c-5.2 0-9.8-3.3-11.4-8.2s.1-10.3 4.2-13.4l96-72c4.5-3.4 10.8-3.2 15.1 .6z"],
    "question": [320, 512, [10067, 10068, 61736], "3f", "M64 160c0-53 43-96 96-96s96 43 96 96c0 42.7-27.9 78.9-66.5 91.4-28.4 9.2-61.5 35.3-61.5 76.6l0 24c0 17.7 14.3 32 32 32s32-14.3 32-32l0-24c0-1.7 .6-4.1 3.5-7.3 3-3.3 7.9-6.5 13.7-8.4 64.3-20.7 110.8-81 110.8-152.3 0-88.4-71.6-160-160-160S0 71.6 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32zm96 352c22.1 0 40-17.9 40-40s-17.9-40-40-40-40 17.9-40 40 17.9 40 40 40z"],
    "hands-bound": [576, 512, [], "e4f9", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 213.9c0 14.2 5.1 27.9 14.3 38.7L99.6 352 96 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-3.6 0 85.3-99.5c9.2-10.8 14.3-24.5 14.3-38.7L576 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112.8-69.3 92.4c-5.7 7.6-16.1 9.6-24.2 4.8-9.7-5.7-12.1-18.7-5.1-27.5L441 180c10.8-13.5 8.9-33.3-4.4-44.5s-33-9.8-44.5 3.2l-46.7 52.5C329 209.7 320 233.4 320 258.1l0 93.9-64 0 0-93.9c0-24.6-9-48.4-25.4-66.8l-46.7-52.5c-11.5-13-31.3-14.4-44.5-3.2S124.2 166.4 135 180l27.6 34.5c7 8.8 4.7 21.8-5.1 27.5-8.1 4.8-18.6 2.7-24.2-4.8L64 144.8 64 32zm64 448l0 32 128 0 0-32 64 0 0 32 128 0 0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L96 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0z"],
    "person-walking-luggage": [512, 512, [], "e554", "M264.3 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-8 181.3l-22.6 22.6c-6 6-9.4 14.1-9.4 22.6l0 37.5c0 12.3-7 23-17.2 28.4-.9 4.2-2.4 8.4-4.3 12.3l-69 138.1-.8-.4-27.7 55.3c-9.9 19.8-33.9 27.8-53.7 17.9L14.6 521c-19.8-9.9-27.8-33.9-17.9-53.7L47.3 366.3c9.9-19.8 33.9-27.8 53.7-17.9l30.7 15.3 28.3-56.6c.3-.6 .4-1.2 .4-1.8l0-16.9c0-.2 0-.3 0-.5l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L422.1 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-29.2 0-56.7-13.3-75-36l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3L448 507.5c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2L372 428.4c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zm.1 165.8c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4-2.2 7.6c-4.5 15.7-12.9 30-24.4 41.5l-68.3 68.3c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L238 421.1c3.8-3.8 6.6-8.6 8.1-13.8L256.4 371z"],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM175 441c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23 0-86.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 86.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64z"],
    "person-booth": [576, 512, [], "f756", "M40 24A56 56 0 1 1 152 24 56 56 0 1 1 40 24zm51.1 88c23.5 0 45.5 11.3 59.1 30.4l48.7 68.2c6 8.4 15.7 13.4 26 13.4l31.1 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-31.1 0c-31 0-60.1-15-78.1-40.2l-2.8-3.9 0 80.1 41.6 31.2C209.8 373.3 224 401.8 224 432l0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80c0-10.1-4.7-19.6-12.8-25.6L70.4 348.8C46.2 330.7 32 302.2 32 272l0-100.9C32 138.5 58.5 112 91.1 112zM32 512l0-132.7c3.1 2.7 6.3 5.4 9.6 7.9L96 428 96 512c0 17.7-14.3 32-32 32s-32-14.3-32-32zm544-88l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-168 0c-7.1 0-13.8-3.1-18.4-8.6s-6.5-12.6-5.3-19.6l30.7-176.7-63.1-137.6 0 72c-5.2-1-10.5-1.6-16-1.6l-32 0 0-120c0-30.9 25.1-56 56-56L520 0c30.9 0 56 25.1 56 56l0 368zM288 336c5.5 0 10.8-.6 16-1.6L304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-184 32 0z"],
    "locust": [576, 512, [], "e520", "M328 32c137 0 248 111 248 248l0 40-.4 8.2C571.5 368.5 537.4 400 496 400l-12.3 0 25.2 44.1c6.6 11.5 2.6 26.2-8.9 32.8s-26.2 2.6-32.7-8.9l-38.8-67.9-80.4 0-48.2 69.7c-7.5 10.9-22.5 13.6-33.4 6.1s-13.6-22.5-6.1-33.4l29.3-42.3-74.5 0-51.7 70.2c-7.9 10.7-22.9 12.9-33.6 5.1s-12.9-22.9-5.1-33.6l40.5-55-43-16.4-79.3 100.5c-8.2 10.4-23.3 12.2-33.7 4s-12.2-23.3-4-33.7l240-304 2.1-2.3c5.2-5.1 12.5-7.5 19.9-6.6 8.4 1.1 15.6 6.5 18.9 14.3l21.7 50.7 40.9-55.5 2.1-2.4c5.1-5.3 12.5-8 20-7.2 8.5 1 15.9 6.5 19.3 14.4l41.8 97.5 64.2 0c10.2 0 20 2 29 5.5-16.4-94-98.3-165.5-197-165.5l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0zM488 296a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM43.5 331.1C36.2 321.4 32 309.5 32 296.8 32 265.5 57.5 240 88.9 240l27.6 0-72.9 91.1zM225.1 240l48.2 0 1.4-1.9-16.9-39.5-32.7 41.5zm107.8 0l46.7 0-17.2-40-29.5 40z"],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", "M566.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9S384 396.9 384 384l0-64-336 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l336 0 0-64c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l128 128z"],
    "truck-droplet": [576, 512, [], "e58c", "M64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-146.7c0-17-6.7-33.3-18.7-45.3L512 146.7c-12-12-28.3-18.7-45.3-18.7l-50.7 0 0-32c0-35.3-28.7-64-64-64L64 32zM512 237.3l0 50.7-96 0 0-96 50.7 0 45.3 45.3zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM208 304c-39.8 0-72-32.2-72-72 0-33.2 34.5-78 55.8-102.4 8.7-10 23.8-10 32.5 0 21.2 24.4 55.8 69.1 55.8 102.4 0 48-32.2 72-72 72z"],
    "hand-holding-medical": [576, 512, [], "e05c", "M240 24c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 56 56 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-56 0 0 56c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-56-56 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l56 0 0-56zM66.7 384l42.5-42.5c24-24 56.6-37.5 90.5-37.5L352 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5s9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l34.7 0z"],
    "hand-point-left": [512, 512, [], "f0a5", "M32 96C14.3 96 0 110.3 0 128s14.3 32 32 32l208 0 0-64-208 0zM192 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0zm-64-64c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32zm96 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0zm88-96l-.6 0c5.4 9.4 8.6 20.3 8.6 32 0 13.2-4 25.4-10.8 35.6 24.9 8.7 42.8 32.5 42.8 60.4 0 11.7-3.1 22.6-8.6 32l8.6 0c88.4 0 160-71.6 160-160l0-61.7c0-42.4-16.9-83.1-46.9-113.1l-11.6-11.6C429.5 77.5 396.9 64 363 64l-27 0c-35.3 0-64 28.7-64 64l0 88c0 22.1 17.9 40 40 40s40-17.9 40-40l0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56c0 39.8-32.2 72-72 72z"],
    "calculator": [384, 512, [128425], "f1ec", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 64l192 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L96 160c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32zm16 168a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 352a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM64 424c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24zm232-24c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24z"],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", "M0 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80zM288 64c0 17.7 14.3 32 32 32l50.7 0-73.4 73.4c-9.2 9.2-11.9 22.9-6.9 34.9S307.1 224 320 224l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 73.4-73.4c9.2-9.2 11.9-22.9 6.9-34.9S461 32 448 32L320 32c-17.7 0-32 14.3-32 32zM412.6 273.7C407.2 262.8 396.1 256 384 256s-23.2 6.8-28.6 17.7l-80 160c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l7.2-14.3 88.4 0 7.2 14.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-80-160zM384 359.6l20.2 40.4-40.4 0 20.2-40.4z"],
    "microphone-slash": [576, 512, [], "f131", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L424.7 358.8C458.9 324.2 480 276.6 480 224l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 39.3-15.7 74.9-41.3 100.9L356.8 291C373.6 273.7 384 250 384 224l0-128c0-53-43-96-96-96s-96 43-96 96l0 30.2-151-151zm298.3 434l-41.4-41.4c-3.3 .2-6.5 .3-9.8 .3-79.5 0-144-64.5-144-144l0-10.2-43.6-43.6c-2.8 3.9-4.4 8.7-4.4 13.8l0 40c0 97.9 73.3 178.7 168 190.5l0 49.5-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-49.5c9.3-1.2 18.4-3 27.3-5.4z"],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM325.8 139.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-23.8 23.8-71-71 23.8-23.8c15.6-15.6 40.9-15.6 56.6 0zM119.9 289l91.5-91.6 71 71-91.6 91.5c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", "M160 0c17.7 0 32 14.3 32 32l0 112-64 0 0-112c0-17.7 14.3-32 32-32zM32 64c0-17.7 14.3-32 32-32S96 46.3 96 64l0 80-64 0 0-80zm192 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6 13.2 0 25.4-4 35.6-10.8 8.7 24.9 32.5 42.8 60.4 42.8 11.7 0 22.6-3.1 32-8.6l0 8.6c0 52.3-25.1 98.8-64 128l0 96c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-78.4c-17.3-7.9-33.2-18.8-46.9-32.5L37.5 357.5C13.5 333.5 0 300.9 0 267l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM140.8 172.8l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6s18.6-41.6 41.6-41.6zm188.8 41.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm-98.3-33.8l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2z"],
    "sim-card": [384, 512, [], "f7c4", "M0 64C0 28.7 28.7 0 64 0L258.7 0c17 0 33.3 6.7 45.3 18.7L365.3 80c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 256c-17.7 0-32 14.3-32 32l0 40 128 0 0-72-96 0zM64 416c0 17.7 14.3 32 32 32l48 0 0-72-80 0 0 40zm256 0l0-40-128 0 0 72 96 0c17.7 0 32-14.3 32-32zm0-128c0-17.7-14.3-32-32-32l-48 0 0 72 80 0 0-40z"],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", "M384 32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L398.4 96c-5.2 25.8-22.9 47.1-46.4 57.3l0 294.7 160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-384 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-294.7c-23.5-10.3-41.2-31.6-46.4-57.3L128 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c14.6-19.4 37.8-32 64-32s49.4 12.6 64 32zm55.6 288L584.4 320 512 195.8 439.6 320zM512 416c-62.9 0-115.2-34-126-78.9-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9zM126.8 195.8L54.4 320 199.3 320 126.8 195.8zM.9 337.1c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9S11.7 382 .9 337.1z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M135.2 117.4l-26.1 74.6 293.8 0-26.1-74.6C372.3 104.6 360.2 96 346.6 96L165.4 96c-13.6 0-25.7 8.6-30.2 21.4zM39.6 196.8L74.8 96.3C88.3 57.8 124.6 32 165.4 32l181.2 0c40.8 0 77.1 25.8 90.6 64.3l35.2 100.5c23.2 9.6 39.6 32.5 39.6 59.2l0 192c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 256c0-26.7 16.4-49.6 39.6-59.2zM128 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M128 32c0-17.7-14.3-32-32-32S64 14.3 64 32l0 32-32 0C14.3 64 0 78.3 0 96s14.3 32 32 32l32 0 0 256c0 35.3 28.7 64 64 64l208 0 0-64-208 0 0-352zM384 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-256c0-35.3-28.7-64-64-64l-208 0 0 64 208 0 0 352z"],
    "medal": [448, 512, [127941], "f5a2", "M224.3 128L139.7-12.9c-6.5-10.8-20.1-14.7-31.3-9.1L21.8 21.3C9.9 27.2 5.1 41.6 11 53.5L80.6 192.6c-30.1 33.9-48.3 78.5-48.3 127.4 0 106 86 192 192 192s192-86 192-192c0-48.9-18.3-93.5-48.3-127.4L437.6 53.5c5.9-11.9 1.1-26.3-10.7-32.2L340.2-22.1c-11.2-5.6-24.9-1.6-31.3 9.1L224.3 128zm30.8 142.5c1.4 2.8 4 4.7 7 5.1l50.1 7.3c7.7 1.1 10.7 10.5 5.2 16l-36.3 35.4c-2.2 2.2-3.2 5.2-2.7 8.3l8.6 49.9c1.3 7.6-6.7 13.5-13.6 9.9l-44.8-23.6c-2.7-1.4-6-1.4-8.7 0l-44.8 23.6c-6.9 3.6-14.9-2.2-13.6-9.9l8.6-49.9c.5-3-.5-6.1-2.7-8.3l-36.3-35.4c-5.6-5.4-2.5-14.8 5.2-16l50.1-7.3c3-.4 5.7-2.4 7-5.1l22.4-45.4c3.4-7 13.3-7 16.8 0l22.4 45.4z"],
    "scroll": [576, 512, [128220], "f70e", "M0 112C0 70.5 31.6 36.4 72 32.4l0-.4 280 0c53 0 96 43 96 96l0 176-176 0c-39.8 0-72 32.2-72 72l0 60c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-228-64 0c-26.5 0-48-21.5-48-48l0-48zM236.8 480c7.1-13.1 11.2-28.1 11.2-44l0-60c0-13.3 10.7-24 24-24l248 0c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-227.2 0zM80 80c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32z"],
    "file-excel": [384, 512, [], "f1c3", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM164 266.7c-7.4-11-22.3-14-33.3-6.7s-14 22.3-6.7 33.3L163.2 352 124 410.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l28-42 28 42c7.4 11 22.3 14 33.3 6.7s14-22.3 6.7-33.3L220.8 352 260 293.3c7.4-11 4.4-25.9-6.7-33.3s-25.9-4.4-33.3 6.7l-28 42-28-42z"],
    "filter": [512, 512, [], "f0b0", "M32 64C19.1 64 7.4 71.8 2.4 83.8S.2 109.5 9.4 118.6L192 301.3 192 416c0 8.5 3.4 16.6 9.4 22.6l64 64c9.2 9.2 22.9 11.9 34.9 6.9S320 492.9 320 480l0-178.7 182.6-182.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 64 480 64L32 64z"],
    "drum": [512, 512, [129345], "f569", "M501.2 76.1c11.1-7.3 14.2-22.1 6.9-33.2s-22.1-14.2-33.2-6.9L370.2 104.5C335.8 98.7 297 96 256 96 114.6 96 0 128 0 208L0 368c0 31.3 27.4 58.8 72 78.7L72 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 119.4c33 8.9 71.1 14.5 112 16.1L232 376c0-13.3 10.7-24 24-24s24 10.7 24 24l0 103.5c40.9-1.6 79-7.2 112-16.1L392 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.7c44.6-19.9 72-47.4 72-78.7l0-160c0-41.1-30.2-69.5-78.8-87.4l67.9-44.5zM307.4 145.6l-64.6 42.3c-11.1 7.3-14.2 22.1-6.9 33.2s22.1 14.2 33.2 6.9l111.1-72.8c14.7 3.2 27.9 7 39.4 11.5 38.8 15.1 44.4 30.6 44.4 41.3 0 .8-2.7 17.2-46 35.9-38.9 16.8-96 28.1-162 28.1S132.9 260.7 94 243.9c-43.3-18.7-46-35.1-46-35.9 0-10.6 5.6-26.2 44.4-41.3 38.3-14.9 95.4-22.7 163.6-22.7 18 0 35.1 .5 51.4 1.6z"],
    "map-pin": [320, 512, [128205], "f276", "M192 284.4C256.1 269.9 304 212.5 304 144 304 64.5 239.5 0 160 0S16 64.5 16 144c0 68.5 47.9 125.9 112 140.4L128 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-195.6zM168 96c-30.9 0-56 25.1-56 56 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-57.4 46.6-104 104-104 13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", "M118.2 62.4C101.5 56.8 92.4 38.6 98 21.9S121.7-3.9 138.5 1.6l113 37.7c13.9-23.5 39.6-39.3 68.9-39.3 44.2 0 80 35.8 80 80 0 3-.2 5.9-.5 8.8l122.6 40.9c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L366.7 145.2c-4.5 3.2-9.3 5.9-14.4 8.2l0 326.7c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-294.7c-21-9.2-37.2-27-44.2-49l-125.9-42zM200.8 288L128.3 163.8 55.9 288 200.8 288zm-72.4 96c-62.9 0-115.2-34-126-78.9-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9zm382.8-92.2l-72.4 124.2 144.9 0-72.4-124.2zm126 141.3C626.4 478 574.1 512 511.2 512s-115.2-34-126-78.9c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1z"],
    "arrows-to-circle": [512, 512, [], "e4bd", "M9.4 9.4C21.9-3.1 42.1-3.1 54.6 9.4L128 82.7 128 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l18.7 0-73.4-73.4C-3.1 42.1-3.1 21.9 9.4 9.4zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM502.6 54.6L429.3 128 448 128c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 18.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zm-45.3 448L384 429.3 384 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-18.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0zM9.4 457.4L82.7 384 64 384c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M48 64c-26.5 0-48 21.5-48 48 0 15.1 7.1 29.3 19.2 38.4l208 156c17.1 12.8 40.5 12.8 57.6 0l208-156c12.1-9.1 19.2-23.3 19.2-38.4 0-26.5-21.5-48-48-48L48 64zM0 196L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-188-198.4 148.8c-34.1 25.6-81.1 25.6-115.2 0L0 196z"],
    "baby": [384, 512, [], "f77c", "M120 88a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM7.7 144.5c13-17.9 38-21.8 55.9-8.8L99.8 162c26.8 19.5 59.1 30 92.2 30s65.4-10.5 92.2-30l36.2-26.4c17.9-13 42.9-9 55.9 8.8s9 42.9-8.8 55.9l-36.2 26.4c-13.6 9.9-28.1 18.2-43.3 25l0 36.3-192 0 0-36.3c-15.2-6.7-29.7-15.1-43.3-25L16.5 200.3c-17.9-13-21.8-38-8.8-55.9zM97.5 329.3l60.6 53-26 37.2 24.3 24.3c15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-48-48C38 438.6 36.1 417 47.2 401.1l50.2-71.8zm128.5 53l60.6-53 50.2 71.8c11.1 15.9 9.2 37.5-4.5 51.2l-48 48c-15.6 15.6-40.9 15.6-56.6 0s-15.6-40.9 0-56.6l24.3-24.3-26-37.2z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zM224 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9S110.5 192 120 192l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"],
    "tent": [512, 512, [], "e57d", "M26.9 206.9L3.7 444.9C1.8 463.7 16.6 480 35.5 480l172.7 0c26.5 0 48-21.5 48-48l0-129c0-8.3 6.7-15 15-15 5.5 0 10.6 3 13.2 7.9l86.1 159c8.4 15.5 24.6 25.1 42.2 25.1l64.1 0c18.9 0 33.7-16.3 31.8-35.1L485.6 207.1c-1.9-19.6-12.8-37.3-29.5-47.8L280.9 48.3c-15.7-10-35.8-9.9-51.5 .1L56.1 159.2c-16.5 10.6-27.3 28.2-29.2 47.7z"],
    "a": [384, 512, [97], "41", "M221.5 51.7C216.6 39.8 204.9 32 192 32s-24.6 7.8-29.5 19.7c-93.3 224-146.7 352-160 384-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2l31.8-76.3 197.3 0 31.8 76.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8c-13.3-32-66.7-160-160-384zM264 320l-144 0 72-172.8 72 172.8z"],
    "parachute-box": [512, 512, [], "f4cd", "M128 224C128 152.2 144.3 88.4 169.5 43.4 195.1-2.4 226.6-24 256-24s60.9 21.6 86.5 67.4C367.7 88.4 384 152.2 384 224l-104 0 0 96 8 0c9.3 0 18.1 2 26 5.5l118.4-101.5-.5 0c0-78.4-17.7-150.6-47.6-204-6.1-11-12.9-21.3-20.3-30.9 86.5 35.9 147.8 115.1 147.8 218.9 0 7-3.1 13.7-8.4 18.2L347.4 360.1c3 7.4 4.6 15.4 4.6 23.9l0 64c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-64c0-8.4 1.6-16.5 4.6-23.9L8.4 226.2C3.1 221.7 0 215 0 208 0 104.2 61.3 24.9 147.8-10.9 140.5-1.4 133.7 9 127.6 20 97.7 73.4 80 145.6 80 224l-.5 0 118.4 101.5c8-3.5 16.8-5.5 26-5.5l8 0 0-96-104 0z"],
    "cart-arrow-down": [640, 512, [], "f218", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 187.2 0 0 102.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-102.1 177.4 0c20 0 35.1 18.2 31.4 37.9L537.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M144 480c-79.5 0-144-64.5-144-144 0-63.4 41-117.2 97.9-136.5-1.3-7.7-1.9-15.5-1.9-23.5 0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0zM305 191c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72z"],
    "at": [512, 512, [61946], "40", "M256 64C150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 32c0 53-43 96-96 96-29.3 0-55.6-13.2-73.2-33.9-22.8 21-53.3 33.9-86.8 33.9-70.7 0-128-57.3-128-128s57.3-128 128-128c27.9 0 53.7 8.9 74.7 24.1 5.7-5 13.1-8.1 21.3-8.1 17.7 0 32 14.3 32 32l0 112c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", "M0 64C0 46.3 14.3 32 32 32l264 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-76.7 0c17.7 19.8 30.1 44.6 34.7 72l42 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-42 0c-10.4 62.2-60.8 110.9-123.8 118.9L274.6 422c14.4 10.3 17.7 30.3 7.4 44.6s-30.3 17.7-44.6 7.4L13.4 314C2.1 306-2.7 291.5 1.5 278.2S18.1 256 32 256l80 0c35.8 0 66.1-23.5 76.3-56L24 200c-13.3 0-24-10.7-24-24s10.7-24 24-24l164.3 0c-10.2-32.5-40.5-56-76.3-56L32 96C14.3 96 0 81.7 0 64z"],
    "truck": [576, 512, [128666, 9951], "f0d1", "M0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 50.7 0c17 0 33.3 6.7 45.3 18.7L557.3 192c12 12 18.7 28.3 18.7 45.3L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64L64 448c-35.3 0-64-28.7-64-64L0 96zM512 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM192 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M128 96c0-35.3 28.7-64 64-64l352 0c35.3 0 64 28.7 64 64l0 240-96 0 0-16c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 16-129.1 0c10.9-18.8 17.1-40.7 17.1-64 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-49zM333 448c-5.1-24.2-16.3-46.1-32.1-64L608 384c0 35.3-28.7 64-64 64l-211 0zM64 272a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM0 480c0-53 43-96 96-96l96 0c53 0 96 43 96 96 0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32z"],
    "user-check": [640, 512, [], "f4fc", "M286 304c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L78 512c-16.4 0-29.7-13.3-29.7-29.7 0-98.5 79.8-178.3 178.3-178.3l59.4 0zM585.7 105.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L522.1 274.9c-4.2 5.7-10.7 9.4-17.7 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7zM256.3 248a120 120 0 1 1 0-240 120 120 0 1 1 0 240z"],
    "user-ninja": [448, 512, [129399], "f504", "M352 128c0 70.7-57.3 128-128 128-57.2 0-105.6-37.5-122-89.3-1.1 1.3-2.2 2.6-3.5 3.8-15.8 15.8-38.8 20.7-53.6 22.1-8.1 .8-14.6-5.7-13.8-13.8 1.4-14.7 6.3-37.8 22.1-53.6 5.8-5.8 12.6-10.1 19.6-13.4-7-3.2-13.8-7.6-19.6-13.4-15.8-15.8-20.7-38.8-22.1-53.6-.8-8.1 5.7-14.6 13.8-13.8 14.7 1.4 37.8 6.3 53.6 22.1 4.8 4.8 8.7 10.4 11.7 16.1 21.3-41.2 64.3-69.4 113.8-69.4 70.7 0 128 57.3 128 128zM144 112c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L160 96c-8.8 0-16 7.2-16 16zm-1.4 211l67 50.2c8.5 6.4 20.3 6.4 28.8 0l67-50.2c6.5-4.9 15.2-6.2 22.6-2.8 61.4 28.2 104.1 90.2 104.1 162.1 0 16.4-13.3 29.7-29.7 29.7L45.7 512c-16.4 0-29.7-13.3-29.7-29.7 0-72 42.7-134 104.1-162.1 7.4-3.4 16.1-2.1 22.6 2.8z"],
    "plant-wilt": [512, 512, [], "e5aa", "M344-32c66.3 0 120 53.7 120 120l0 6.2c29.3 12.2 48 41.3 48 76.9 0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3c-40.7-36.8-66-83.7-66-111.7 0-35.6 18.7-64.7 48-76.9l0-6.2c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 424c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-296c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 38.2c29.3 12.2 48 41.3 48 76.9 0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3C25.3 405.9 0 359 0 331.1 0 295.4 18.7 266.4 48 254.2L48 216c0-66.3 53.7-120 120-120 20.2 0 39.3 5 56 13.8L224 88c0-66.3 53.7-120 120-120z"],
    "weight-scale": [448, 512, ["weight"], "f496", "M116.6 192c-3-10.1-4.6-20.9-4.6-32 0-61.9 50.1-112 112-112S336 98.1 336 160c0 11.1-1.6 21.9-4.6 32l-71 0 24.6-44.3c6.4-11.6 2.3-26.2-9.3-32.6s-26.2-2.3-32.6 9.3l-37.6 67.7-88.8 0zM128 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-64 0C293.3 11.9 260 0 224 0s-69.3 11.9-96 32z"],
    "caret-right": [256, 512, [], "f0da", "M32.5 96c0-12.9 7.8-24.6 19.8-29.6S78 64.2 87.1 73.4l160 160c12.5 12.5 12.5 32.8 0 45.3l-160 160c-9.2 9.2-22.9 11.9-34.9 6.9S32.5 428.9 32.5 416l0-320z"],
    "florin-sign": [384, 512, [], "e184", "M314.7 32c-38.8 0-73.7 23.3-88.6 59.1L170.7 224 64 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l80 0-45.1 108.3c-5 11.9-16.6 19.7-29.5 19.7L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l37.3 0c38.8 0 73.7-23.3 88.6-59.1L213.3 288 320 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0 45.1-108.3c5-11.9 16.6-19.7 29.5-19.7L352 96c17.7 0 32-14.3 32-32s-14.3-32-32-32l-37.3 0z"],
    "bell": [448, 512, [128276, 61602], "f0f3", "M224 0c-17.7 0-32 14.3-32 32l0 3.2C119 50 64 114.6 64 192l0 21.7c0 48.1-16.4 94.8-46.4 132.4L7.8 358.3C2.7 364.6 0 372.4 0 380.5 0 400.1 15.9 416 35.5 416l376.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2l-9.8-12.2C400.4 308.5 384 261.8 384 213.7l0-21.7c0-77.4-55-142-128-156.8l0-3.2c0-17.7-14.3-32-32-32zM162 464c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0z"],
    "lari-sign": [384, 512, [], "e1c8", "M144 0c13.3 0 24 10.7 24 24l0 41.5c7.9-1 15.9-1.5 24-1.5s16.1 .5 24 1.5L216 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54c58.9 23.8 103.2 76 116.2 139.7 3.5 17.3-7.7 34.2-25 37.7s-34.2-7.7-37.7-25c-6.7-33.2-26.4-61.8-53.4-80.2l0 81.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-101.8c-7.8-1.5-15.8-2.2-24-2.2s-16.2 .8-24 2.2L168 232c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-81.8c-33.8 23-56 61.9-56 105.8 0 70.7 57.3 128 128 128l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l16.9 0C18.5 350 0 305.2 0 256 0 175.4 49.6 106.4 120 78l0-54c0-13.3 10.7-24 24-24z"],
    "mill-sign": [384, 512, [], "e1ed", "M297-22.2c12.3 5 18.2 19 13.2 31.3l-29 71.3C338.8 85.1 384 133.3 384 192l0 208c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-208c0-26.5-21.5-48-48-48-6.4 0-12.5 1.2-18 3.5l-30 73.8 0 178.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-21.2-57.8 142.2c-5 12.3-19 18.2-31.3 13.2s-18.2-19-13.2-31.3L160 251.3 160 192c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 208c0 17.7-14.3 32-32 32S0 417.7 0 400L0 112c0-17.7 14.3-32 32-32 10.9 0 20.5 5.4 26.3 13.7 16-8.7 34.3-13.7 53.7-13.7 31.3 0 59.7 12.9 80 33.6 9.6-9.8 20.9-17.8 33.5-23.5L265.8-9c5-12.3 19-18.2 31.3-13.2z"],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", "M424.5 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM166.4 45.5c10.2-14.4 30.2-17.9 44.6-7.7l272 192c14.4 10.2 17.9 30.2 7.7 44.6s-30.2 17.9-44.6 7.7l-92.2-65.1-62.2 53.3 32.1 26.7c18.2 15.2 28.8 37.7 28.8 61.5l0 87.8 77.5 15.2c6.2 1.2 12.6 .9 18.7-.8l41.2-11.8c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-41.2 11.8c-13.4 3.8-27.4 4.4-41.1 1.8L87.1 443.3c-17.2-3.4-33-11.8-45.3-24.1L15.5 393c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l26.2 26.2c5.6 5.6 12.8 9.4 20.6 11l64.2 12.6 0-123.7c0-27.7 12-54 32.8-72.2l69-60.4-88.2-62.3C159.6 80 156.2 60 166.4 45.5zm58.1 375.7l64 12.5 0-75.3c0-4.7-2.1-9.3-5.8-12.3l-58.2-48.5 0 123.6z"],
    "tty": [512, 512, ["teletype"], "f1e4", "M450.2 266.8c15.8 6.5 34.1 .3 42.6-14.6l2.4-4.2c27.9-48.9 23.6-118.8-31.3-154.5-126-82-289.6-82-415.6 0-54.9 35.7-59.3 105.7-31.3 154.5l2.4 4.2c8.5 14.9 26.7 21.1 42.6 14.6l81.9-33.7c13.9-5.7 22.4-19.9 20.9-34.9l-5.1-51c62.5-21 130.8-19.9 192.6 3.3l-4.8 47.7c-1.5 15 7 29.2 20.9 34.9l81.9 33.7zM32 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm352 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm128-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM128 448c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32z"],
    "users-rectangle": [576, 512, [], "e594", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm224 72a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 152c53 0 96 43 96 96l0 24c0 13.3-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-24c0-53 43-96 96-96zm96-64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM168 272.3c-15.2 22.8-24 50.2-24 79.7l0 24c0 8.4 1.4 16.5 4.1 24l-46.8 0C89.6 400 80 390.4 80 378.7L80 368c0-50.3 38.7-91.6 88-95.7zM427.9 400c2.7-7.5 4.1-15.6 4.1-24l0-24c0-29.5-8.8-56.9-24-79.7 49.3 4.1 88 45.3 88 95.7l0 10.7c0 11.8-9.6 21.3-21.3 21.3l-46.8 0zM96 192a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", "M80 0C44.7 0 16 28.7 16 64l0 384c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L80 0zm72 416l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", "M265.4-6.6c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L285.3 64 352 64c53 0 96 43 96 96l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7-14.3-32-32-32l-66.7 0 25.4 25.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-80-80c-12.5-12.5-12.5-32.8 0-45.3l80-80zm-82.7 272l80 80c12.5 12.5 12.5 32.8 0 45.3l-80 80c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L162.7 400 96 400c-17.7 0-32 14.3-32 32l0 32c0 17.7-14.3 32-32 32S0 481.7 0 464l0-32c0-53 43-96 96-96l66.7 0-25.4-25.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0zM320 368a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 160a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"],
    "exclamation": [128, 512, [10069, 10071, 61738], "21", "M64 432c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40c0-22.1 17.9-40 40-40zM64 0c26.5 0 48 21.5 48 48 0 .6 0 1.1 0 1.7l-16 304c-.9 17-15 30.3-32 30.3S33 370.7 32 353.7L16 49.7c0-.6 0-1.1 0-1.7 0-26.5 21.5-48 48-48z"],
    "church": [512, 512, [9962], "f51d", "M280-8c0-13.3-10.7-24-24-24S232-21.3 232-8l0 24-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 48-98.6 65.8C120 186.7 112 201.6 112 217.7l0 38.3-79.8 45.6C12.3 313 0 334.2 0 357.1L0 448c0 35.3 28.7 64 64 64 74.7 0 85.4 0 320 0l64 0c35.3 0 64-28.7 64-64l0-90.9c0-23-12.3-44.2-32.2-55.6L400 256 400 217.7c0-16-8-31-21.4-39.9l-98.6-65.8 0-48 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-24zM256 320c35.3 0 64 28.7 64 64l0 80-128 0 0-80c0-35.3 28.7-64 64-64z"],
    "toggle-off": [576, 512, [], "f204", "M384 128c70.7 0 128 57.3 128 128S454.7 384 384 384l-192 0c-70.7 0-128-57.3-128-128s57.3-128 128-128l192 0zM576 256c0-106-86-192-192-192L192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192zM192 336a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "shoe-prints": [576, 512, [], "f54b", "M296 192c-21.1-12.1-42.3-24.2-72-29.3l0-140.3C257.7 13 311.4 0 352 0 448 0 576 48 576 128s-119.6 96-176 96c-48 0-76-16-104-32zM128 32l48 0 0 128-48 0c-35.3 0-64-28.7-64-64s28.7-64 64-64zM232 320c28-16 56-32 104-32 56.4 0 176 16 176 96S384 512 288 512c-40.5 0-94.3-13-128-22.4l0-140.3c29.7-5.2 50.9-17.3 72-29.4zM64 480c-35.3 0-64-28.7-64-64s28.7-64 64-64l48 0 0 128-48 0z"],
    "file-circle-exclamation": [576, 512, [], "e4eb", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "wallet": [512, 512, [], "f555", "M64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L72 128c-13.3 0-24-10.7-24-24S58.7 80 72 80l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 32zM416 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M0 352L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-5.2 0-10.2 1.7-14.4 4.8L166.4 539.2c-4.2 3.1-9.2 4.8-14.4 4.8-13.3 0-24-10.7-24-24l0-72-32 0c-53 0-96-43-96-96z"],
    "trophy": [512, 512, [127942], "f091", "M144.3 0l224 0c26.5 0 48.1 21.8 47.1 48.2-.2 5.3-.4 10.6-.7 15.8l49.6 0c26.1 0 49.1 21.6 47.1 49.8-7.5 103.7-60.5 160.7-118 190.5-15.8 8.2-31.9 14.3-47.2 18.8-20.2 28.6-41.2 43.7-57.9 51.8l0 73.1 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0 0-73.1c-16-7.7-35.9-22-55.3-48.3-18.4-4.8-38.4-12.1-57.9-23.1-54.1-30.3-102.9-87.4-109.9-189.9-1.9-28.1 21-49.7 47.1-49.7l49.6 0c-.3-5.2-.5-10.4-.7-15.8-1-26.5 20.6-48.2 47.1-48.2zM101.5 112l-52.4 0c6.2 84.7 45.1 127.1 85.2 149.6-14.4-37.3-26.3-86-32.8-149.6zM380 256.8c40.5-23.8 77.1-66.1 83.3-144.8L411 112c-6.2 60.9-17.4 108.2-31 144.8z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM134.1 153.9l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zm192 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zM256 304a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "bacteria": [640, 512, [], "e059", "M256-32c13.3 0 24 10.7 24 24l0 11c8.6 2.2 16.9 5.6 24.8 10.3L311 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L345 151c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1c-10 10-20 20-30.1 30.1L217 279c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L73 313c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L39 169c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1c10-10 20-20 30.1-30.1L103 105c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9S191.6-2.3 201 7l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24zM128 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM240 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm296 40l0 11c8.6 2.2 16.9 5.6 24.8 10.3L567 199c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L601 343c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1c-10 10-20 20-30.1 30.1L473 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L329 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L295 361c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1c10-10 20-20 30.1-30.1L359 297c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24s24 10.7 24 24zM448 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M502.6 54.6l-40 40c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l40-40c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zm-320 320l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM240 128c-57.6 0-105.1 43.6-111.3 99.5-1.9 17.6-17.8 30.2-35.3 28.3s-30.2-17.8-28.3-35.3c9.7-88 84.3-156.5 174.9-156.5 97.2 0 176 78.8 176 176 0 46-17.7 87.9-46.6 119.3-12 13-17.4 24.8-17.4 34.7l0 6.1c0 61.9-50.1 112-112 112-17.7 0-32-14.3-32-32s14.3-32 32-32c26.5 0 48-21.5 48-48l0-6.1c0-32.9 17.4-59.6 34.4-78 18.4-20 29.6-46.6 29.6-75.9 0-61.9-50.1-112-112-112zm0 80c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-17.7-14.3-32-32-32z"],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM0 224c0-35.3 28.7-64 64-64l64 0c3.2 0 6.4 .2 9.5 .7L93.1 205.1C65 233.2 65 278.8 93.1 306.9l56 56c3.4 3.4 7 6.4 10.9 9l0 92.1c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-120.6C12.9 332.4 0 311.7 0 288l0-64zM352 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm66.9 141.1l-44.4-44.4c3.1-.5 6.3-.7 9.5-.7l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L480 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-92.1c3.9-2.6 7.5-5.6 10.9-9l56-56c28.1-28.1 28.1-73.7 0-101.8zM302.8 177.8c9-3.7 19.3-1.7 26.2 5.2l56 56c9.4 9.4 9.4 24.6 0 33.9l-56 56c-6.9 6.9-17.2 8.9-26.2 5.2S288 321.7 288 312l0-24-64 0 0 24c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-56-56c-9.4-9.4-9.4-24.6 0-33.9l56-56c6.9-6.9 17.2-8.9 26.2-5.2S224 190.3 224 200l0 24 64 0 0-24c0-9.7 5.8-18.5 14.8-22.2z"],
    "hands-clapping": [512, 512, [], "e1a8", "M344 8l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24S344-5.3 344 8zM220 10.7l32 48c7.4 11 4.4 25.9-6.7 33.3s-25.9 4.4-33.3-6.7l-32-48c-7.4-11-4.4-25.9 6.7-33.3S212.6-.3 220 10.7zM135 119c9.4-9.4 24.6-9.4 33.9 0L292.7 242.7c10.1 10.1 27.3 2.9 27.3-11.3l0-39.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 153.6c0 57.1-30 110-78.9 139.4-64 38.4-145.8 28.3-198.5-24.4L7 361c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l53 53c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1L23 265c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l93 93c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1L55 185c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l117 117c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1l-93-93c-9.4-9.4-9.4-24.6 0-33.9zM433.1 484.9c-24.2 14.5-50.9 22.1-77.7 23.1 48.1-39.6 76.6-99 76.6-162.4l0-98.1c8.2-.1 16-6.4 16-16l0-39.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 153.6c0 57.1-30 110-78.9 139.4zM453.3 4c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7z"],
    "virus-covid-slash": [576, 512, [], "e4a9", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-83-83 11.4-11.4c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-11.3 11.3-23.8-23.8c17.9-23.5 29.9-51.7 34.1-82.3l33.6 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-33.6 0c-4.2-30.7-16.3-58.8-34.1-82.3l23.8-23.8 11.3 11.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L440.7 46.7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l11.3 11.3-23.8 23.8C370.8 97.9 342.7 85.8 312 81.6l0-33.6 16 0c13.3 0 24-10.7 24-24S341.3 0 328 0L248 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 33.6c-30.7 4.2-58.8 16.3-82.3 34.1L157.9 92 169.2 80.6c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L123.9 58.1 41-24.9zM113.6 232l-33.6 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 33.6 0c4.2 30.7 16.3 58.8 34.1 82.3l-23.8 23.8-11.3-11.3c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56.6 56.6c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-11.3-11.3 23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1l0 33.6-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-33.6c13.4-1.8 26.4-5.2 38.7-9.9L123.5 193.3c-4.7 12.3-8 25.2-9.9 38.7z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zM64 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm128 0l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM64 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M215 17L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17zM385 257l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-78.1 0c-13.3 0-24 10.7-24 24l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40c0-39.8 32.2-72 72-72l78.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M32 32C32 14.3 46.3 0 64 0S96 14.3 96 32l0 208-64 0 0-208zM224 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-64-64c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6 13.2 0 25.4-4 35.6-10.8 8.7 24.9 32.5 42.8 60.4 42.8 11.7 0 22.6-3.1 32-8.6l0 8.6c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72z"],
    "bezier-curve": [640, 512, [], "f55b", "M296 136l0-48 48 0 0 48-48 0zM288 32c-26.5 0-48 21.5-48 48l0 4-118.4 0C111.2 62.7 89.3 48 64 48 28.7 48 0 76.7 0 112s28.7 64 64 64c25.3 0 47.2-14.7 57.6-36l66.9 0c-58.9 39.6-98.9 105-104 180L80 320c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-3.3 0c5.9-67 48.5-123.4 107.5-149.1 8.6 12.7 23.2 21.1 39.8 21.1l64 0c16.6 0 31.1-8.4 39.8-21.1 59 25.7 101.6 82.1 107.5 149.1l-3.3 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-4.5 0c-5-75-45.1-140.4-104-180l66.9 0c10.4 21.3 32.3 36 57.6 36 35.3 0 64-28.7 64-64s-28.7-64-64-64c-25.3 0-47.2 14.7-57.6 36l-118.4 0 0-4c0-26.5-21.5-48-48-48l-64 0zM88 376l48 0 0 48-48 0 0-48zm416 48l0-48 48 0 0 48-48 0z"],
    "person-half-dress": [384, 512, [], "e548", "M143.4-3.9c9.7-16.8 27.8-28.1 48.6-28.1 30.9 0 56 25.1 56 56 0 25.4-16.9 46.8-40 53.7l0 0c-5.1 1.5-10.4 2.3-16 2.3-30.9 0-56-25.1-56-56l0 0c0-10.1 2.7-19.7 7.4-27.9zM318.3 299.1L272 236.7 272 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160 0-.4 0-238.6c36.2 4.4 69.2 23.4 91.2 53l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6zM176 113l0 399c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-25.8 0c-10.9 0-18.6-10.7-15.2-21.1l43-129-48.3 65.1c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95c22-29.6 55.1-48.6 91.2-53z"],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM256 152c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24zm72 80c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l208 0zM192 360c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0c13.3 0 24 10.7 24 24z"],
    "school-circle-xmark": [640, 512, [], "e56d", "M64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l276 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-88c0-22.1 17.9-40 40-40l48 0c1 0 1.9 0 2.9 .1 26.3-74.6 97.5-128.1 181.1-128.1 28.6 0 55.6 6.2 80 17.4l0-33.4c0-35.3-28.7-64-64-64l-64 0-127.9-115.1c-18.3-16.4-46-16.4-64.2 0L128 128 64 128zm64 240c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM112 256l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zM288 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "hand-lizard": [512, 512, [], "f258", "M0 112C0 85.5 21.5 64 48 64l238.5 0c36.8 0 71.2 18 92.1 48.2l113.5 164c13 18.7 19.9 41 19.9 63.8l0 76c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-13.8-78.1-50.2-161.9 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l128 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L48 160c-26.5 0-48-21.5-48-48z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M96 64c-35.3 0-64 28.7-64 64l0 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-256c0-35.3-28.7-64-64-64L96 64zM480 384l-64 0 0-32c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 32-160 0 0-256 384 0 0 256z"],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", "M290.4 19.8C295.4 7.8 307.1 0 320 0L480 0c17.7 0 32 14.3 32 32l0 160c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9L400 157.3 246.6 310.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L354.7 112 297.4 54.6c-9.2-9.2-11.9-22.9-6.9-34.9zM0 176c0-44.2 35.8-80 80-80l80 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-80 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 80c0 44.2-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80L0 176z"],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64z"],
    "clover": [512, 512, [], "e139", "M310.4 16C346.6 16 376 45.4 376 81.7l0 5.2c0 11.2-2.7 22.3-7.8 32.2l-2.3 4.2-20.1 33.5c-1.1 1.9-1.2 3.4-1.1 4.5 .2 1.3 .9 2.7 2.1 3.9s2.6 1.9 3.9 2.1c1.1 .2 2.6 .1 4.5-1.1l33.5-20.1 4.2-2.3c10-5.1 21-7.8 32.2-7.8l5.2 0c36.2 0 65.6 29.4 65.6 65.7 0 17.4-6.9 34.1-19.2 46.4l-1.3 1.3c-3.7 3.7-3.7 9.6 0 13.3l1.3 1.3c12.3 12.3 19.2 29 19.2 46.4 0 36.2-29.4 65.6-65.6 65.6l-5.2 0c-12.8 0-25.5-3.5-36.5-10.1l-33.5-20.1c-1.9-1.1-3.4-1.2-4.5-1.1-1.3 .2-2.7 .9-3.9 2.1s-1.9 2.6-2.1 3.9c-.2 1.1-.1 2.6 1.1 4.5l20.1 33.5c6.6 11 10.1 23.6 10.1 36.5l0 5.2c0 36.2-29.4 65.6-65.6 65.6-17.4 0-34.1-6.9-46.4-19.2l-1.3-1.3c-3.7-3.7-9.6-3.7-13.3 0l-1.3 1.3c-12.3 12.3-29 19.2-46.4 19.2-36.2 0-65.6-29.4-65.7-65.6l0-5.2c0-12.8 3.5-25.5 10.1-36.5l20.1-33.5c1.1-1.9 1.2-3.4 1.1-4.5-.2-1.3-.9-2.7-2.1-3.9s-2.6-1.9-3.9-2.1c-.5-.1-1.2-.1-1.9 0l-2.5 1-33.5 20.1c-11 6.6-23.6 10.1-36.5 10.1l-5.2 0C45.4 376 16 346.6 16 310.4 16 293 22.9 276.3 35.2 264l1.3-1.3 1.2-1.5c2.1-3.1 2.1-7.2 0-10.3l-1.2-1.5-1.3-1.3C22.9 235.8 16 219.1 16 201.7 16 165.4 45.4 136 81.7 136l5.2 0c12.8 0 25.5 3.5 36.5 10.1l33.5 20.1 2.5 1c.7 .1 1.4 .1 1.9 .1 1.3-.2 2.7-.9 3.9-2.1s1.9-2.6 2.1-3.9c.1-.5 .1-1.2-.1-1.9l-1-2.5-20.1-33.5c-6.6-11-10.1-23.6-10.1-36.5l0-5.2c0-36.2 29.4-65.7 65.7-65.7 17.4 0 34.1 6.9 46.4 19.2l1.3 1.3c3.7 3.6 9.6 3.7 13.3 0l1.3-1.3 4.8-4.4C280.5 21.3 295.1 16 310.4 16z"],
    "teeth-open": [512, 512, [], "f62f", "M64 32C28.7 32 0 60.7 0 96l0 80c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-80c0-35.3-28.7-64-64-64L64 32zm0 272c-35.3 0-64 28.7-64 64l0 48c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48c0-35.3-28.7-64-64-64L64 304zm80-160c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zm128 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zM80 112c17.7 0 32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24c0-17.7 14.3-32 32-32zm320 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24zM48 384l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32zm144 48c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm128 0c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm112-16c-17.7 0-32-14.3-32-32l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM64 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 288c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "warehouse": [576, 512, [], "f494", "M0 142.1L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 240c0 17.7 14.3 32 32 32s32-14.3 32-32l0-337.9c0-27.5-17.6-52-43.8-60.7L303.2 5.1c-9.9-3.3-20.5-3.3-30.4 0L43.8 81.4C17.6 90.1 0 114.6 0 142.1zM464 256l-352 0 0 64 352 0 0-64zM112 416l352 0 0-64-352 0 0 64zm352 32l-352 0 0 64 352 0 0-64z"],
    "swatchbook": [512, 512, [], "f5c3", "M0 48C0 21.5 21.5 0 48 0l96 0c26.5 0 48 21.5 48 48l0 368c0 53-43 96-96 96S0 469 0 416L0 48zM240 409.6l0-271.5 48.1-48.1c18.7-18.7 49.1-18.7 67.9 0l67.9 67.9c18.7 18.7 18.7 49.1 0 67.9L240 409.6zM205.5 512l192-192 66.6 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-258.5 0zM80 64c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 64zM64 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "campground": [512, 512, [9978], "f6bb", "M344.8 52.3c11.2-13.7 9.2-33.8-4.5-45s-33.8-9.2-45 4.5l-39.2 48-39.2-48C205.6-1.9 185.4-4 171.7 7.2s-15.7 31.4-4.5 45l47.4 58-202 246.9C4.5 367.1 0 379.6 0 392.6L0 432c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-39.4c0-12.9-4.5-25.5-12.7-35.5l-202-246.9 47.4-58zM256 288l112 128-224 0 112-128z"],
    "person-walking-arrow-right": [576, 512, [], "e552", "M104.5 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-8 181.3L73.9 227.9c-6 6-9.4 14.1-9.4 22.6l0 37.5c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L262.3 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-29.2 0-56.7-13.3-75-36l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8L130 347.5c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zM96.6 371c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4-2.2 7.6c-4.5 15.7-12.9 30-24.4 41.5L55.1 534.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l68.3-68.3c3.8-3.8 6.6-8.6 8.1-13.8L96.6 371zM505.5 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-102.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l102.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72z"],
    "glasses": [576, 512, [], "f530", "M143.3 96c-14 0-26.5 9.2-30.6 22.6L70.4 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l153.6 0-42.3-137.4C459.2 105.2 446.8 96 432.7 96L400 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l32.7 0c42.1 0 79.4 27.5 91.8 67.8l45.4 147.5c4.1 13.2 6.1 26.9 6.1 40.7l0 96c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-32-64 0 0 32c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-96c0-13.8 2.1-27.5 6.1-40.7L51.5 99.8C63.9 59.5 101.1 32 143.3 32L176 32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32.7 0zM64 320l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64-128 0zm416 96c17.7 0 32-14.3 32-32l0-64-128 0 0 64c0 17.7 14.3 32 32 32l64 0z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 192l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "memory": [512, 512, [], "f538", "M64 64C28.7 64 0 92.7 0 128l0 7.4C0 142.2 4.4 148 10.1 151.7 23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6l0 55.4 512 0 0-55.4c0-6.8-4.4-12.6-10.1-16.3-13.2-8.6-21.9-23.4-21.9-40.3s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3l0-7.4c0-35.3-28.7-64-64-64L64 64zM512 416l0-64-512 0 0 64c0 17.7 14.3 32 32 32l64 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 88 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 88 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 64 0c17.7 0 32-14.3 32-32zM160 160l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "gift": [512, 512, [127873], "f06b", "M321.5 68.8C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zm-131 0l34.8 59.2-73.3 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3l-24.1 41-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0c-48.6 0-88 39.4-88 88 0 14.4 3.5 28 9.6 40L32 128c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-41.6 0c6.1-12 9.6-25.6 9.6-40 0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM480 272l-200 0 0 208 136 0c35.3 0 64-28.7 64-64l0-144zm-248 0l-200 0 0 144c0 35.3 28.7 64 64 64l136 0 0-208z"],
    "money-bill-wheat": [512, 512, [], "e52a", "M176-16c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80 0-8.8 7.2-16 16-16zM56 0l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 48C42.7 48 32 37.3 32 24S42.7 0 56 0zM24 72l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 120C10.7 120 0 109.3 0 96S10.7 72 24 72zm8 96c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM272 0c0-8.8 7.2-16 16-16 44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80zM400-16c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80 0-8.8 7.2-16 16-16zm80 144c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM352 112c8.8 0 16 7.2 16 16 0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-96 16c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM0 304c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 304zM48 416l0 48 48 0c0-26.5-21.5-48-48-48zM96 304l-48 0 0 48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48l48 0 0-48zM416 304c0 26.5 21.5 48 48 48l0-48-48 0zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "dungeon": [512, 512, [], "f6d9", "M347.5 144.8c6.5 5.4 12.5 11.3 18 17.7 8.7 10.2 23.7 14 35.1 6.9l54.1-33.8c11.2-7 14.7-21.7 6.9-32.2-15.3-20.5-33.5-38.6-54.1-53.8-10.4-7.6-24.7-4.3-31.8 6.4l-35.1 52.6c-7.8 11.6-3.8 27.3 7 36.2zM327.8 41.1c8.6-12.9 2.9-30.5-12.2-34.1-19.1-4.6-39.1-7-59.6-7s-40.4 2.4-59.6 7c-15.1 3.6-20.8 21.2-12.2 34.1l40 60c5.2 7.8 14.5 11.7 23.9 11.2 5.2-.3 10.6-.3 15.8 0 9.4 .5 18.7-3.4 23.9-11.2l40-60zM50.5 103.3c-7.9 10.5-4.3 25.3 6.9 32.2l54.1 33.8c11.4 7.1 26.3 3.3 35.1-6.9 5.5-6.4 11.5-12.3 18-17.7 10.8-8.9 14.8-24.6 7-36.2L136.4 55.9c-7.1-10.7-21.5-14-31.8-6.4-20.6 15.1-38.8 33.3-54.1 53.8zm62 141.1c.8-9.9-3.3-19.9-11.8-25.1L41 182c-12.9-8-29.9-2.3-33.6 12.5-4.9 19.7-7.5 40.3-7.5 61.6l0 24c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-24c0-3.9 .2-7.8 .5-11.6zm287.1 0c.3 3.8 .5 7.7 .5 11.6l0 24c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-24c0-21.2-2.6-41.8-7.5-61.6-3.6-14.7-20.7-20.5-33.6-12.5l-59.7 37.3c-8.4 5.3-12.6 15.2-11.8 25.1zM88 352l-64 0c-13.3 0-24 10.7-24 24L0 488c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm400 0l-64 0c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM280 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304zm-80 32c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272zm160 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272z"],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", "M192 56l0 40 128 0 0-40c0-4.4-3.6-8-8-8L200 48c-4.4 0-8 3.6-8 8zm-48 8l0-8c0-30.9 25.1-56 56-56L312 0c30.9 0 56 25.1 56 56l0 424-224 0 0-416zM96 176l0 304-32 0c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l32 0 0 80zM416 480l0-384 32 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-32 0zM244 208c-8.8 0-16 7.2-16 16l0 36-36 0c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l36 0 0 36c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-36 36 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-36 0 0-36c0-8.8-7.2-16-16-16l-24 0z"],
    "person-cane": [448, 512, [], "e53c", "M232-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM144 236.7L97.7 299.1c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95C142 132 181.7 112 224 112s82 20 107.2 53.9l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6L304 236.7 304 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-275.3zM392 384c-4.4 0-8 3.6-8 8 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128c0-4.4-3.6-8-8-8z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-26.9-16.5-49.9-40-59.3L280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 172.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "envelope-open-text": [576, 512, [], "f658", "M288 33.9L96.4 175.8 254.5 293c5.3 3.9 11.2 6.9 17.5 8.7L272 464c0 5.5 .5 10.8 1.3 16L96 480c-35.3 0-64-28.7-64-64l0-239.9c0-20.3 9.6-39.4 25.9-51.4L254.5-21c9.7-7.2 21.4-11 33.5-11s23.8 3.9 33.5 11L518.1 124.7c7.2 5.3 13.1 12 17.4 19.6-2.5-.2-5-.3-7.5-.3L436.6 144 288 33.9zM320 240c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-224zm80 16c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0z"],
    "toolbox": [512, 512, [129520], "f552", "M176 56l0 40 160 0 0-40c0-4.4-3.6-8-8-8L184 48c-4.4 0-8 3.6-8 8zM128 96l0-40c0-30.9 25.1-56 56-56L328 0c30.9 0 56 25.1 56 56l0 40 28.1 0c12.7 0 24.9 5.1 33.9 14.1l51.9 51.9c9 9 14.1 21.2 14.1 33.9l0 76.1-136 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-144 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-136 0 0-76.1c0-12.7 5.1-24.9 14.1-33.9l51.9-51.9c9-9 21.2-14.1 33.9-14.1L128 96zM0 416l0-96 136 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 144 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 136 0 0 96c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64z"],
    "power-off": [512, 512, [9211], "f011", "M288 0c0-17.7-14.3-32-32-32S224-17.7 224 0l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32L288 0zM146.3 98.4c14.5-10.1 18-30.1 7.9-44.6s-30.1-18-44.6-7.9C43.4 92.1 0 169 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-87-43.4-163.9-109.7-210.1-14.5-10.1-34.4-6.6-44.6 7.9s-6.6 34.4 7.9 44.6c49.8 34.8 82.3 92.4 82.3 157.6 0 106-86 192-192 192S64 362 64 256c0-65.2 32.5-122.9 82.3-157.6z"],
    "signal": [512, 512, [128246, "signal-5", "signal-perfect"], "f012", "M488 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400zM360 128c-13.3 0-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304c0-13.3-10.7-24-24-24zM280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208zM152 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM48 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"],
    "arrows-spin": [512, 512, [], "e4bb", "M481.7 240.1c-17.6-1.2-32.9 12-34.2 29.7-3.3 47-23.6 89.4-54.8 121L361 359c-6.9-6.9-17.2-8.9-26.2-5.2S320 366.3 320 376l0 112c0 13.3 10.7 24 24 24l112 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-35-35c41.7-42.2 68.9-98.8 73.4-161.8 1.2-17.6-12-32.9-29.7-34.2zM39 41L74 76c-41.7 42.2-68.9 98.8-73.4 161.8-1.2 17.6 12 32.9 29.7 34.2s32.9-12 34.2-29.7c3.3-47 23.6-89.4 54.8-121L151 153c6.9 6.9 17.2 8.9 26.2 5.2S192 145.7 192 136l0-112c0-13.3-10.7-24-24-24L56 0C46.3 0 37.5 5.8 33.8 14.8S32.2 34.1 39 41zm201-10.7c-1.2 17.6 12 32.9 29.7 34.2 47 3.3 89.4 23.6 121 54.8L359 151c-6.9 6.9-8.9 17.2-5.2 26.2S366.3 192 376 192l112 0c13.3 0 24-10.7 24-24l0-112c0-9.7-5.8-18.5-14.8-22.2S477.9 32.2 471 39L436 74c-42.2-41.7-98.8-68.9-161.8-73.4-17.6-1.2-32.9 12-34.2 29.7zM41 473l35-35c42.2 41.7 98.8 68.9 161.8 73.4 17.6 1.2 32.9-12 34.2-29.7s-12-32.9-29.7-34.2c-47-3.3-89.4-23.6-121-54.8L153 361c6.9-6.9 8.9-17.2 5.2-26.2S145.7 320 136 320L24 320c-13.3 0-24 10.7-24 24L0 456c0 9.7 5.8 18.5 14.8 22.2S34.1 479.8 41 473z"],
    "joint": [576, 512, [], "f595", "M360 0c13.3 0 24 10.7 24 24l0 19c0 40.3 16 79 44.5 107.5l21 21C469 191 480 217.4 480 245l0 19c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-19c0-14.9-5.9-29.1-16.4-39.6l-21-21C357.1 146.9 336 96 336 43l0-19c0-13.3 10.7-24 24-24zM552 288c-13.3 0-24-10.7-24-24l0-19c0-40.3-16-79-44.5-107.5l-21-21C443 97 432 70.6 432 43l0-19c0-13.3 10.7-24 24-24s24 10.7 24 24l0 19c0 14.9 5.9 29.1 16.4 39.6l21 21C554.9 141.1 576 192 576 245l0 19c0 13.3-10.7 24-24 24zM292.7 320c5.6 0 10.7 2.9 13.6 7.6L394.6 471c1.3 2.1 0 4.9-2.4 5.2-16.1 2.5-32.4 3.7-48.7 3.7l-38.1 0c-5.6 0-10.7-2.9-13.6-7.6l-79-128.4c-6-9.8 0-22.6 11.5-23.3 6.7-.4 13.4-.6 20.2-.6l48.3 0zM459.3 465.9c-6.4 1-12.7-1.9-16.1-7.4L374.1 346.1c-6.7-10.9 1.5-24.7 14.2-22.9 1.3 .2 2.6 .4 3.8 .6l136.4 21c27.3 4.2 47.4 27.7 47.4 55.3s-20.1 51.1-47.4 55.3l-69.2 10.6zM138.7 336c6.7-1.5 13.6 1.4 17.2 7.2l68.9 112c6.6 10.7-1.2 24.4-13.8 23.1-13-1.4-25.9-3.5-38.6-6.5L31.2 439.2C12.9 435 0 418.7 0 400s12.9-35 31.2-39.2L138.7 336z"],
    "braille": [384, 512, [], "f2a1", "M80 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 136c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0 56c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zm248-80c0 13.3-10.7 24-24 24s-24-10.7-24-24 10.7-24 24-24 24 10.7 24 24zm56 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zM304 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-192a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M288 0c6.6 0 12.9 2.7 17.4 7.5l144 152 .5 .5 78.1 0c17.7 0 32 14.3 32 32 0 14.5-9.6 26.7-22.8 30.7L491.1 429.9c-6.5 29.3-32.5 50.1-62.5 50.1l-281.3 0c-30 0-56-20.8-62.5-50.1l-46-207.2c-13.2-3.9-22.8-16.2-22.8-30.7 0-17.7 14.3-32 32-32l78.1 0 .5-.5 144-152C275.1 2.7 281.4 0 288 0zm0 58.9L192.2 160 383.8 160 288 58.9zM208 264c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zm80-24c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm128 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112z"],
    "bridge": [512, 512, [], "e4c8", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96s96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-94c0-38.8 26.4-72.6 64-82l0-112-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64z"],
    "plane-arrival": [576, 512, [128748], "f5af", "M386.6 193.1L265.9 3.7c-4.8-7.6-12.6-12.8-21.4-14.3l-43.1-7.6c-10.8-1.9-20.2 7.3-18.6 18.1l24 161.6-105-18.5-33.8-61.8C64.5 74.7 58.2 70.2 51.1 69L34 66c-9.8-1.7-18.8 5.9-18.8 15.8l.6 106.3c.2 30.9 22.4 57.3 52.9 62.7l13.5 2.4 0 0 417.6 73.6c30.5 5.4 59.5-15 64.9-45.4s-15-59.5-45.4-64.9L386.6 193.1zM224 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm131.2-15.3a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"],
    "cash-register": [512, 512, [], "f788", "M96 0C60.7 0 32 28.7 32 64s28.7 64 64 64l48 0 0 32-57 0c-31.6 0-58.5 23.1-63.3 54.4L1.1 364.1C.4 368.8 0 373.6 0 378.4L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-69.6c0-4.8-.4-9.6-1.1-14.4L488.2 214.4C483.5 183.1 456.6 160 425 160l-217 0 0-32 48 0c35.3 0 64-28.7 64-64S291.3 0 256 0L96 0zm0 48l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 80c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 424c0-13.3 10.7-24 24-24l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24zm48-160a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm120-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM160 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM328 240a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM256 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM424 240a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM352 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "ring": [512, 512, [], "f70b", "M64 208c0 7.8 4.4 18.7 17.1 30.3 45.4-24.2 107.7-38.3 174.9-38.3s129.5 14.1 174.9 38.3c12.8-11.6 17.1-22.5 17.1-30.3 0-12.3-10.8-32-47.9-50.6-35.2-17.6-86.1-29.4-144.1-29.4s-108.9 11.8-144.1 29.4C74.8 176 64 195.7 64 208zm192 40c-47 0-89.3 7.6-122.9 19.7 33.2 12.4 75.7 20.3 122.9 20.3s89.7-7.8 122.9-20.3C345.3 255.6 303 248 256 248zM0 208C0 158.4 39.4 122.2 83.3 100.2 129.1 77.3 190.3 64 256 64s126.9 13.3 172.7 36.2c43.9 22 83.3 58.2 83.3 107.8l0 96c0 49.6-39.4 85.8-83.3 107.8-45.9 22.9-107 36.2-172.7 36.2S129.1 434.7 83.3 411.8C39.4 389.8 0 353.6 0 304l0-96z"],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", "M384 192c53 0 96-43 96-96s-43-96-96-96-96 43-96 96c0 5.4 .5 10.8 1.3 16L159.6 184.1c-16.9-15-39.2-24.1-63.6-24.1-53 0-96 43-96 96s43 96 96 96c24.4 0 46.6-9.1 63.6-24.1L289.3 400c-.9 5.2-1.3 10.5-1.3 16 0 53 43 96 96 96s96-43 96-96-43-96-96-96c-24.4 0-46.6 9.1-63.6 24.1L190.7 272c.9-5.2 1.3-10.5 1.3-16s-.5-10.8-1.3-16l129.7-72.1c16.9 15 39.2 24.1 63.6 24.1z"],
    "person-circle-exclamation": [640, 512, [], "e53f", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "binoculars": [512, 512, [], "f1e5", "M128 32l32 0c17.7 0 32 14.3 32 32l0 32-96 0 0-32c0-17.7 14.3-32 32-32zm64 96l0 320c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-59.1c0-34.6 9.4-68.6 27.2-98.3 13.7-22.8 22.5-48.2 25.8-74.6L60.5 156c2-16 15.6-28 31.8-28l99.8 0zm227.8 0c16.1 0 29.8 12 31.8 28L459 216c3.3 26.4 12.1 51.8 25.8 74.6 17.8 29.7 27.2 63.7 27.2 98.3l0 59.1c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-320 99.8 0zM320 64c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32-96 0 0-32zm-32 64l0 160-64 0 0-160 64 0z"],
    "kip-sign": [384, 512, [], "e1c4", "M340.8 88.3c13.4-11.5 15-31.7 3.5-45.1s-31.7-15-45.1-3.5L128 186.4 128 64c0-17.7-14.3-32-32-32S64 46.3 64 64l0 168-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 168c0 17.7 14.3 32 32 32s32-14.3 32-32l0-122.4 171.2 146.7c13.4 11.5 33.6 9.9 45.1-3.5s9.9-33.6-3.5-45.1L173.2 280 352 280c13.3 0 24-10.7 24-24s-10.7-24-24-24L173.2 232 340.8 88.3z"],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", "M64 32C28.7 32 0 60.7 0 96L0 260.1C18.1 247.4 40.2 240 64 240l320 0c23.8 0 45.9 7.4 64 20.1L448 96c0-35.3-28.7-64-64-64L64 32zM448 352c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-64zM224 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "ranking-star": [576, 512, [], "e561", "M321.8 54.1L298.2 6.3c-3.9-8.3-16.1-8.6-20.4 0l-23.6 47.8-52.3 7.5c-9.3 1.4-13.3 12.9-6.4 19.8l38 37-9 52.1c-1.4 9.3 8.2 16.5 16.8 12.2l46.9-24.8 46.6 24.4c8.6 4.3 18.3-2.9 16.8-12.2l-9-52.1 38-36.6c6.8-6.8 2.9-18.3-6.4-19.8l-52.3-7.5zM256 256c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0zM48 320c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-64 0zM416 432l0 32c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z"],
    "user-tie": [448, 512, [], "f508", "M224 248a120 120 0 1 1 0-240 120 120 0 1 1 0 240zm-30.5 56l61 0c9.7 0 17.5 7.8 17.5 17.5 0 4.2-1.5 8.2-4.2 11.4l-27.4 32 31 115.1 .6 0 34.6-138.5c2.2-8.7 11.1-14 19.5-10.8 61.9 23.6 105.9 83.6 105.9 153.8 0 15.1-12.3 27.4-27.4 27.4L43.4 512c-15.1 0-27.4-12.3-27.4-27.4 0-70.2 44-130.2 105.9-153.8 8.4-3.2 17.3 2.1 19.5 10.8l34.6 138.5 .6 0 31-115.1-27.4-32c-2.7-3.2-4.2-7.2-4.2-11.4 0-9.7 7.8-17.5 17.5-17.5z"],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", "M0 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm168 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm224-56a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "store-slash": [576, 512, [], "e071", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-58.6-58.6c1.1-4 1.6-8.2 1.6-12.5l0-151.2c-12.5 4.6-26.1 7.2-40.5 7.2-8.1 0-15.9-.8-23.5-2.4l0 66.4-30.2 0-137.5-137.5c2.9-3.6 5.5-7.4 7.6-11.5 11.6 22 34.7 37 61.3 37 26.8 0 49.8-15.1 61.4-37.1 11.4 22.1 34.5 37.1 60.8 37.1 45.6 0 78.4-43.7 65.6-87.5L513.8 72.3C506.8 48.4 484.9 32 460 32L116 32c-5.5 0-10.8 .8-15.9 2.3L41-24.9zM151.5 221.3L48.7 118.6 38.9 152.5c-12.8 43.7 20 87.5 65.6 87.5 18.1 0 34.7-7.1 47-18.7zM410.2 480l-128-128-154.2 0 0-66.4c-7.6 1.6-15.5 2.4-23.5 2.4-14.4 0-28-2.6-40.5-7.2L64 432c0 26.5 21.5 48 48 48l298.2 0z"],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", "M192 128a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM448 384a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM438.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-384 384c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l384-384z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM64 72c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 48C74.7 48 64 58.7 64 72zm0 96c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm64 72l-32 0c-17.7 0-32 14.3-32 32l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-17.7-14.3-32-32-32zm-16 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "display": [512, 512, [], "e163", "M448 96l0 256-384 0 0-256 384 0zM64 32C28.7 32 0 60.7 0 96L0 352c0 35.3 28.7 64 64 64l144 0-16 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0-16-48 144 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 32z"],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", "M174.9 272c10.7 0 20.7 5.3 26.6 14.2l11.8 17.8 26.7 0c26.5 0 48 21.5 48 48l0 112c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 352c0-26.5 21.5-48 48-48l26.7 0 11.8-17.8c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0zm278.6-12c5.6-4.9 13.9-5.3 19.9-.9s8.3 12.4 5.3 19.3L440.3 368 496 368c6.7 0 12.6 4.1 15 10.4s.6 13.3-4.4 17.7l-128 112c-5.6 4.9-13.9 5.3-19.9 .9s-8.3-12.4-5.3-19.3l38.5-89.7-55.8 0c-6.7 0-12.6-4.1-15-10.4s-.6-13.3 4.4-17.7l128-112zM144 360a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM483.8 .4c6.5-1.1 13.1 .4 18.5 4.4 6.1 4.5 9.7 11.7 9.7 19.2l0 152-.3 4.9c-3.3 24.2-30.5 43.1-63.7 43.1-35.3 0-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .6 16 1.6l0-49.3-112 33.6 0 110.2-.3 4.9c-3.3 24.2-30.5 43.1-63.7 43.1-35.3 0-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .6 16 1.6L304 72c0-10.6 7-20 17.1-23l160-48 2.7-.6zM188.9 0C226 0 256 30 256 67.1l0 6.1c0 56.1-75.2 112.1-110.3 135.3-10.8 7.1-24.6 7.1-35.4 0-35.1-23.1-110.3-79.2-110.3-135.3l0-6.1C0 30 30 0 67.1 0 88.2 0 108 9.9 120.7 26.8l7.3 9.8 7.3-9.8C148 9.9 167.8 0 188.9 0z"],
    "ruler-vertical": [256, 512, [], "f548", "M0 16C0-10.5 21.5-32 48-32l160 0c26.5 0 48 21.5 48 48l0 24-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 24c0 26.5-21.5 48-48 48L48 544c-26.5 0-48-21.5-48-48L0 16z"],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", "M576 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L413.5 77.5 234.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C70.8 88.8 64 99.9 64 112l0 352c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 173.3 57.8c-4.3-6.4-8.5-13.1-12.6-19.9-11-18.3-21.9-39.3-30-61.8l-101.2-33.7 0-284.5 128 42.7 0 99.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 48zM512 224c-66.3 0-120 52.8-120 117.9 0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", "M133.1 32c17.3 0 34.2 3.4 49.9 9.7l54.8 85.2-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.4 60.6C319.6 42.3 348.6 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32z"],
    "cow": [640, 512, [128004], "f6c8", "M96 224l0 192c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88.2c9.9 6.6 20.6 12 32 16.1l0 24.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16.9c5.3 .6 10.6 .9 16 .9s10.7-.3 16-.9l0 16.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24.2c11.4-4 22.1-9.4 32-16.1l0 88.2c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-160 32 32 0 49.5c0 9.5 2.8 18.7 8.1 26.6L530 427c8.8 13.1 23.5 21 39.3 21 22.5 0 41.9-15.9 46.3-38l20.3-101.6c2.6-13-.3-26.5-8-37.3l-3.9-5.5 0-81.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 14.4-52.9-74.1C496 86.5 452.4 64 405.9 64L144 64C77.7 64 24 117.7 24 184l0 54C9.4 249.8 0 267.8 0 288l0 17.6c0 8 6.4 14.4 14.4 14.4 31.8 0 57.6-25.8 57.6-57.6L72 184c0-24.3 12.1-45.8 30.5-58.9-4.2 10.8-6.5 22.6-6.5 34.9l0 64zM560 336a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM166.6 166.6c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l178.7 0c12.5 0 22.6 10.1 22.6 22.6 0 6-2.4 11.8-6.6 16l-23.4 23.4C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9l-23.4-23.4z"],
    "rss": [448, 512, ["feed"], "f09e", "M0 64c0-17.7 14.3-32 32-32 229.8 0 416 186.2 416 416 0 17.7-14.3 32-32 32s-32-14.3-32-32C384 253.6 226.4 96 32 96 14.3 96 0 81.7 0 64zM0 416a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM32 160c159.1 0 288 128.9 288 288 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-123.7-100.3-224-224-224-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "cloud-moon": [640, 512, [], "f6c3", "M480 0c14.6 0 28.8 1.6 42.5 4.7 7.4 1.7 13 7.8 13.9 15.4s-3 14.9-9.8 18.3c-45.4 22.6-76.6 69.5-76.6 123.6 0 76.2 61.8 138 138 138 3.7 0 7.4-.1 11.1-.4 7.6-.6 14.7 3.6 17.8 10.6s1.5 15.1-3.9 20.4c-26 25-59.1 42.7-95.9 49.9-11.1-25.3-30.2-46.3-54.1-59.8-7.6-63.4-61.6-112.6-127.1-112.6-11.2 0-22.1 1.5-32.5 4.2-4.8-4.2-9.9-8.2-15.2-11.8-.1-2.8-.2-5.6-.2-8.4 0-106 86-192 192-192zm-.1 431.9c0 44.2-35.8 80-80 80l-271.9 0c-53 0-96-43-96-96 0-47.6 34.6-87 80-94.6-.4-52.8 42.9-97.3 96-97.3 34.9 0 65.4 18.6 82.2 46.4 13-9.1 28.8-14.4 45.8-14.4 44.2 0 80 35.8 80 80 0 5.9-.6 11.7-1.9 17.2 37.4 6.7 65.8 39.4 65.8 78.7z"],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", "M224 0l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 5.5-.7 10.9-2 16l-252 0c-1.3-5.1-2-10.5-2-16l0-128c0-35.3 28.7-64 64-64l32 0zm96 512c-11.2 0-21.8-2.9-31-8 9.5-16.5 15-35.6 15-56l0-128c0-20.4-5.5-39.5-15-56 9.2-5.1 19.7-8 31-8l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64l-128 0zM0 320c0-35.3 28.7-64 64-64l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 320z"],
    "code-branch": [448, 512, [], "f126", "M80 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm80-24c0 32.8-19.7 61-48 73.3l0 70.7 176 0c26.5 0 48-21.5 48-48l0-22.7c-28.3-12.3-48-40.5-48-73.3 0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3l0 22.7c0 61.9-50.1 112-112 112l-176 0 0 70.7c28.3 12.3 48 40.5 48 73.3 0 44.2-35.8 80-80 80S0 476.2 0 432c0-32.8 19.7-61 48-73.3l0-205.3C19.7 141 0 112.8 0 80 0 35.8 35.8 0 80 0s80 35.8 80 80zm232 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM80 456a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8c-22.4 31.4-35.5 69.8-35.5 111.2 0 106 86 192 192 192 41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3c22.4-31.4 35.5-69.8 35.5-111.2 0-106-86-192-192-192-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "jug-detergent": [384, 512, [], "e519", "M96 24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 96C74.7 96 64 85.3 64 72S74.7 48 88 48l8 0 0-24zM0 256c0-70.7 57.3-128 128-128l128 0c70.7 0 128 57.3 128 128l0 192c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256zm256 0l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", "M204.2 18.4c12 5 19.8 16.6 19.8 29.6l0 80 112 0c97.2 0 176 78.8 176 176 0 113.3-81.5 163.9-100.2 174.1-2.5 1.4-5.3 1.9-8.1 1.9-10.9 0-19.7-8.9-19.7-19.7 0-7.5 4.3-14.4 9.8-19.5 9.4-8.8 22.2-26.4 22.2-56.7 0-53-43-96-96-96l-96 0 0 80c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c9.2-9.2 22.9-11.9 34.9-6.9z"],
    "sun-plant-wilt": [640, 512, [], "e57a", "M160 0c-5.5 0-10.6 2.8-13.5 7.4l-1.1 2.1-24.8 55.4-56.7-21.7c-5.9-2.2-12.5-.8-17 3.7S41 58 43.2 63.9l21.7 56.7-55.4 24.8C3.7 148 0 153.7 0 160s3.7 12 9.5 14.6l55.4 24.8-21.7 56.7c-2.2 5.9-.8 12.5 3.7 17s11.1 5.9 17 3.7l56.7-21.7 24.8 55.4c2.6 5.8 8.3 9.5 14.6 9.5s12-3.7 14.6-9.5l24.8-55.4 56.8 21.7c5.9 2.2 12.5 .8 17-3.7s5.9-11.1 3.7-17l-21.7-56.7 55.4-24.8c5.8-2.6 9.5-8.3 9.5-14.6s-3.7-12-9.5-14.6l-55.4-24.8 21.7-56.7 .7-2.2c1.2-5.3-.4-10.9-4.3-14.8s-9.5-5.5-14.8-4.3l-2.2 .7-56.8 21.7-24.8-55.4C172 3.7 166.3 0 160 0zm0 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm376 16l0 53.4c-14.8 7.7-24 23.1-24 44.6 0 16.8 16 44 37.4 67.2 5.8 6.2 15.5 6.2 21.2 0 21.4-23.3 37.4-50.6 37.4-67.2 0-21.5-9.2-37-24-44.6l0-53.4c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 22.7c-9.8-4.3-20.6-6.7-32-6.7-44.2 0-80 35.8-80 80l0 21.4c-14.8 7.6-24 23.1-24 44.6 0 16.8 16 44 37.4 67.2 5.8 6.2 15.5 6.2 21.2 0 21.4-23.3 37.4-50.6 37.4-67.2 0-21.5-9.2-37-24-44.6l0-21.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176-424 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-104 0 0-272c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "bacterium": [576, 512, [], "e05a", "M408 16c0-13.3-10.7-24-24-24S360 2.7 360 16l0 23.4c-13.9 5.3-26.9 13.5-38.2 24.5L305 47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-10 10-20 20-30.1 30.1L177 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-11 11.3-19.2 24.3-24.5 38.2L48 328c-13.3 0-24 10.7-24 24s10.7 24 24 24l16.3 0c1.3 18.3 7.1 36.4 17.4 52.4L71 439c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l10.6-10.6c16 10.3 34.1 16.1 52.4 17.4l0 16.3c0 13.3 10.7 24 24 24s24-10.7 24-24l0-23.4c13.9-5.3 26.9-13.5 38.2-24.5L271 465c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c10-10 20-20 30.1-30.1L399 337c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c11-11.3 19.2-24.3 24.5-38.2l23.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16.3 0c-1.3-18.3-7.1-36.4-17.4-52.4L505 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L460.4 49.7c-16-10.3-34.1-16.1-52.4-17.4L408 16zM160 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM272 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "record-vinyl": [512, 512, [], "f8d9", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 240a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-112a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-242.7c0-17-6.7-33.3-18.7-45.3L352 50.7C340 38.7 323.7 32 306.7 32L64 32zm32 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-64zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "toilets-portable": [512, 512, [], "e584", "M64 0l96 0c35.3 0 64 28.7 64 64l0 16-224 0 0-16C0 28.7 28.7 0 64 0zM0 128l224 0 0 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-128 0 0 8c0 13.3-10.7 24-24 24S0 501.3 0 488L0 128zM128 248l0 48c0 13.3 10.7 24 24 24l24 0 0-96-24 0c-13.3 0-24 10.7-24 24zM352 0l96 0c35.3 0 64 28.7 64 64l0 16-224 0 0-16c0-35.3 28.7-64 64-64zM288 128l224 0 0 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-128 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-360zM416 248l0 48c0 13.3 10.7 24 24 24l24 0 0-96-24 0c-13.3 0-24 10.7-24 24z"],
    "o": [448, 512, [111], "4f", "M224 96a160 160 0 1 0 0 320 160 160 0 1 0 0-320zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"],
    "palette": [512, 512, [127912], "f53f", "M512 256c0 .9 0 1.8 0 2.7-.4 36.5-33.6 61.3-70.1 61.3L344 320c-26.5 0-48 21.5-48 48 0 3.4 .4 6.7 1 9.9 2.1 10.2 6.5 20 10.8 29.9 6.1 13.8 12.1 27.5 12.1 42 0 31.8-21.6 60.7-53.4 62-3.5 .1-7 .2-10.6 .2-141.4 0-256-114.6-256-256S114.6 0 256 0 512 114.6 512 256zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "unlock": [384, 512, [128275], "f09c", "M128 96c0-35.3 28.7-64 64-64 31.7 0 58 23 63.1 53.3 2.9 17.4 19.4 29.2 36.9 26.3s29.2-19.4 26.3-36.9C308.1 14.1 255.5-32 192-32 121.3-32 64 25.3 64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-192 0 0-64z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M379.6 .3c-8.9 1.2-17.2 6.2-22.4 14.1-6.8 10.4-7 24.1-.4 34.6 5.6 8.9 15.5 12.7 23.8 18.5 7.5 5.2 17.6 13.2 27.7 24.2 20 21.7 39.5 54.3 39.5 100.3 0 17.7 14.3 32 32 32s32-14.3 32-32c0-66-28.5-113.4-56.5-143.7-13.9-15.1-27.8-26.1-38.3-33.3-11-7.6-23.5-16.6-37.6-14.7zM240 128c-57.6 0-105.1 43.6-111.3 99.5-1.9 17.6-17.8 30.2-35.3 28.3s-30.2-17.8-28.3-35.3c9.7-88 84.3-156.5 174.9-156.5 97.2 0 176 78.8 176 176 0 46-17.7 87.9-46.6 119.3-12 13-17.4 24.8-17.4 34.7l0 6.1c0 61.9-50.1 112-112 112-17.7 0-32-14.3-32-32s14.3-32 32-32c26.5 0 48-21.5 48-48l0-6.1c0-32.9 17.4-59.6 34.4-78 18.4-20 29.6-46.6 29.6-75.9 0-61.9-50.1-112-112-112zM0 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM86.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zM240 208c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-17.7-14.3-32-32-32z"],
    "code-pull-request": [512, 512, [], "e13c", "M328 24c0-9.7-5.8-18.5-14.8-22.2S293.9 .2 287 7L231 63c-9.4 9.4-9.4 24.6 0 33.9l56 56c6.9 6.9 17.2 8.9 26.2 5.2S328 145.7 328 136l0-24 24 0c17.7 0 32 14.3 32 32l0 214.7c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3L448 144c0-53-43-96-96-96l-24 0 0-24zM72 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm56 73.3c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80S16 35.8 16 80c0 32.8 19.7 61 48 73.3l0 205.3c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-205.3zM72 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm344-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "key": [512, 512, [128273], "f084", "M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391c-4.5 4.5-7 10.6-7 17l0 80c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "skull": [512, 512, [128128], "f54c", "M416 427.4c58.5-44 96-111.6 96-187.4 0-132.5-114.6-240-256-240S0 107.5 0 240c0 75.8 37.5 143.4 96 187.4L96 464c0 26.5 21.5 48 48 48l32 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 64 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c26.5 0 48-21.5 48-48l0-36.6zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", "M192 256a112 112 0 1 0 0 224 112 112 0 1 0 0-224zM16 368c0-86.3 62.1-158.1 144.1-173.1-.1-.9-.1-1.9-.1-2.9l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-61.4-28 22.4c-13.8 11-33.9 8.8-45-5s-8.8-33.9 5-45l80-64c11.7-9.3 28.3-9.3 40 0l80 64c13.8 11 16 31.2 5 45s-31.2 16-45 5l-28-22.4 0 61.4 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 16c0 1 0 1.9-.1 2.9 82 15 144.1 86.8 144.1 173.1 0 97.2-78.8 176-176 176S16 465.2 16 368z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M372.5 256.5l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6 0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1zm-90.8 49.5c4.1 9.3 6.2 19.4 6.2 29.5 0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3z"],
    "tree": [448, 512, [127794], "f1bb", "M224-32c7 0 13.7 3.1 18.3 8.5l136 160c6.1 7.1 7.4 17.1 3.5 25.6S369.4 176 360 176l-24.9 0 75.2 88.5c6.1 7.1 7.4 17.1 3.5 25.6S401.4 304 392 304l-38.5 0 88.8 104.5c6.1 7.1 7.4 17.1 3.5 25.6S433.4 448 424 448l-168 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-168 0c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L94.5 304 56 304c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L112.9 176 88 176c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l136-160C210.3-28.9 217-32 224-32z"],
    "smog": [576, 512, [], "f75f", "M176 288C96.5 288 32 223.5 32 144S96.5 0 176 0c27.2 0 52.6 7.5 74.3 20.6 20.1-13 44-20.6 69.7-20.6 47.4 0 88.7 25.7 110.9 64l1.1 0c61.9 0 112 50.1 112 112 0 60.3-47.6 109.4-107.2 111.9-22.6 20-52.3 32.1-84.8 32.1-32.5 0-62.1-12.1-84.7-32L176 288zM512 392c0 13.3-10.7 24-24 24L24 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l464 0c13.3 0 24 10.7 24 24zM88 464l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm176 0l288 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "s": [320, 512, [115], "53", "M0 157.5C0 88.2 56.2 32 125.5 32L272 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L125.5 96c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61L210.1 230C272.9 237.9 320 291.2 320 354.5 320 423.8 263.8 480 194.5 480L48 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l146.5 0c34 0 61.5-27.5 61.5-61.5 0-31-23.1-57.2-53.9-61L109.9 282C47.1 274.1 0 220.8 0 157.5z"],
    "jedi": [576, 512, [], "f669", "M246 315.7l-21.2-31.9c-2.1-3.2-1.7-7.4 1-10.1s6.9-3.1 10.1-1l29.5 19.7c2.1 1.4 4.9-.1 5-2.6L279.7 8c.1-4.5 3.8-8 8.3-8s8.1 3.5 8.3 8l9.4 281.9c.1 2.5 2.9 3.9 5 2.6l29.5-19.7c3.2-2.1 7.4-1.7 10.1 1s3.1 6.9 1 10.1L330 315.7c-1.3 1.9-.2 4.5 2 4.9l37.6 7.5c3.7 .7 6.4 4 6.4 7.8s-2.7 7.1-6.4 7.8L332 351.4c-2.2 .4-3.3 3-2 4.9l21.2 31.9c2.1 3.2 1.7 7.4-1 10.1s-6.9 3.1-10.1 1l-26.3-17.6c-2.2-1.4-5.1 .2-5 2.8l2.1 61.5c59.8-10.8 105.1-63.1 105.1-126 0-37-15.7-70.4-40.8-93.7-7-6.5-6.5-18.6 1-24.4 34-26.3 55.8-67.5 55.8-113.9 0-16.8-2.9-33-8.2-48-4.6-13 10.2-30 21.4-22 53.5 38 92.7 94.8 107.8 160.7 .5 2.1-.2 4.3-1.7 5.9l-28.4 28.4c-4 4-1.2 10.9 4.5 10.9l26 0c3.4 0 6.2 2.6 6.3 6 .1 3.3 .2 6.6 .2 10 0 17.5-1.7 34.7-4.8 51.3-.2 1.2-.9 2.4-1.7 3.3l-46.5 46.5c-4 4-1.2 10.9 4.5 10.9l14.6 0c4.6 0 7.7 4.8 5.7 9-44.5 89.5-136.9 151-243.7 151S88.8 450.5 44.3 361c-2.1-4.2 1-9 5.7-9l14.6 0c5.7 0 8.6-6.9 4.5-10.9L22.6 294.6c-.9-.9-1.5-2-1.7-3.3-3.2-16.6-4.8-33.8-4.8-51.3 0-3.3 .1-6.7 .2-10 .1-3.4 2.9-6 6.3-6l26 0c5.7 0 8.6-6.9 4.5-10.9L24.6 184.6c-1.5-1.5-2.2-3.8-1.7-5.9 15.2-66 54.3-122.8 107.8-160.7 11.3-8 26 8.9 21.4 22-5.3 15-8.2 31.2-8.2 48 0 46.3 21.9 87.5 55.8 113.9 7.5 5.8 8 17.9 1 24.4-25.1 23.4-40.8 56.7-40.8 93.7 0 62.9 45.4 115.2 105.1 126l2.1-61.5c.1-2.6-2.8-4.2-5-2.8l-26.3 17.6c-3.2 2.1-7.4 1.7-10.1-1s-3.1-6.9-1-10.1L246 356.3c1.3-1.9 .2-4.5-2-4.9l-37.6-7.5c-3.7-.7-6.4-4-6.4-7.8s2.7-7.1 6.4-7.8l37.6-7.5c2.2-.4 3.3-3 2-4.9z"],
    "person-hiking": [448, 512, ["hiking"], "f6ec", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM128 173.6c0-34 27.6-61.6 61.6-61.6 20.3 0 39.7 8.1 54 22.4l48.2 48.2c6 6 14.1 9.4 22.6 9.4l37.5 0c5.8 0 11.3 1.6 16 4.3l0-76.3c0-13.3 10.7-24 24-24s24 10.7 24 24l0 400c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-268.3c-4.7 2.7-10.2 4.3-16 4.3l-37.5 0c-25.5 0-49.9-10.1-67.9-28.1l-6.6-6.6 0 109.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-101zm-4.8 203.7c2.3 2.3 4.7 4.4 7.1 6.5l44.9 38.5c-3.6 8.4-8.5 16.3-14.4 23.4L88.6 532.5c-11.3 13.6-31.5 15.4-45.1 4.1s-15.4-31.5-4.1-45.1l72.3-86.7c2.6-3.1 4.5-6.6 5.8-10.4l5.7-17.1zM0 160c0-35.3 28.7-64 64-64 17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96z"],
    "arrows-up-to-line": [448, 512, [], "e4c2", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l384 0c17.7 0 32-14.3 32-32S433.7 0 416 0L32 0zm86.6 137.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L64 237.3 64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zm256 0c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4 0 242.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64z"],
    "mars-double": [640, 512, [9891], "f227", "M288 32c0-17.7 14.3-32 32-32L448 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c37 0 71.4 11.4 99.8 31l95-95-50.7 0c-17.7 0-32-14.3-32-32zM176 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm160 64c-6.8 0-13.4-.4-20-1.1 23.6-18.9 43.3-42.5 57.6-69.4 43.3-15.5 74.4-56.9 74.4-105.5 0-25.2-8.3-48.5-22.4-67.2 7.1 2.1 14.6 3.2 22.4 3.2 17 0 32.7-5.3 45.7-14.3 11.7 23.6 18.3 50.2 18.3 78.3 0 97.2-78.8 176-176 176zM528 157.3L528 32c0-11.4-2.4-22.2-6.7-32L608 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-48 48z"],
    "thermometer": [512, 512, [], "f491", "M96 382.1l0-88.8c0-14.9 5.9-29.1 16.4-39.6l21.7-21.7 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 46.1-46.1 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 46.1-46.1 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 7.8-7.8c19.4-19.4 45.6-30.2 73-30.2 57 0 103.2 46.2 103.2 103.2 0 27.4-10.9 53.6-30.2 73L258.3 399.6c-10.5 10.5-24.7 16.4-39.6 16.4l-88.8 0-89 89c-9.4 9.4-24.6 9.4-33.9 0S-2.3 480.4 7 471l89-89z"],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", "M480.5 10.3L259.1 158c-29.1 19.4-47.6 50.9-50.6 85.3 62.3 12.8 111.4 61.9 124.3 124.3 34.5-3 65.9-21.5 85.3-50.6L565.7 95.5c6.7-10.1 10.3-21.9 10.3-34.1 0-33.9-27.5-61.4-61.4-61.4-12.1 0-24 3.6-34.1 10.3zM288 400c0-61.9-50.1-112-112-112S64 338.1 64 400c0 3.9 .2 7.8 .6 11.6 1.8 17.5-10.2 36.4-27.8 36.4L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112z"],
    "neuter": [384, 512, [9906], "f22c", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM223.9 349.1C305.9 334.1 368 262.3 368 176 368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144.1 173.1-.1 1-.1 1.9-.1 2.9l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-1 0-1.9-.1-2.9z"],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm232 96.7l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9l19.3 23.6c35.1-17.4 63.4-46.6 79.6-82.4l-22.1-18c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M0 256c0 104.4 62.5 194.2 152.2 234.1-5.3-13-8.2-27.2-8.2-42.1l0-61.7c-16.9-16.5-30.1-36.7-38.3-59.3-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1c11.9-3.7 23.9 6.3 19.6 18.1-8.3 22.6-21.5 42.8-38.3 59.3l0 61.7c0 14.9-2.9 29.1-8.2 42.1 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256zm125.8-91.7c-6.2-5.2-7.6-14.3-3.1-21.1s13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 192 125.8 164.3zm263.6-21.1c4.5 6.8 3.1 15.9-3.1 21.1L353 192 386.2 219.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "comment-dollar": [512, 512, [], "f651", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm4-352c11 0 20 9 20 20l0 4 8 0c11 0 20 9 20 20s-9 20-20 20l-47.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 4.7c0 11-9 20-20 20s-20-9-20-20l0-4-24 0c-11 0-20-9-20-20s9-20 20-20l55.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-4c0-11 9-20 20-20z"],
    "hippo": [640, 512, [129435], "f6ed", "M407 47c9.4-9.4 24.6-9.4 33.9 0l17.2 17.2c1.9-.1 3.9-.2 5.8-.2l32 0c11.2 0 21.9 2.3 31.6 6.5L543 55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L564 101.9c7.6 12.2 12 26.7 12 42.1 0 10.2 7.4 18.8 16.7 23 27.9 12.5 47.3 40.5 47.3 73 0 26.2-12.6 49.4-32 64l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-64 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-17.6c-11.8-2.4-22.7-7.4-32-14.4-1.5-1.1-2.9-2.3-4.3-3.5-17-14.7-27.7-36.4-27.7-60.5 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 44.7 26.2 83.2 64 101.2l0 10.8c0 17.7 14.3 32 32 32l32 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-76c-19.8 7.7-41.4 12-64 12s-44.2-4.3-64-12l0 76c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-118.9-18.1 40.7c-5.4 12.1-19.6 17.6-31.7 12.2S-3.3 362.4 2.1 350.3L24 300.9c5.3-11.9 8-24.7 8-37.7 0-107.5 85.2-195.2 191.8-199.1l.2-.1 64 0c41.7 0 83.4 12.1 117.2 25.7 1.7-1.8 3.5-3.6 5.3-5.2L407 81c-9.4-9.4-9.4-24.6 0-33.9zm73 185a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm88 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM480 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "bowl-food": [512, 512, [], "e4c6", "M0 176c0-35.3 28.7-64 64-64 .5 0 1.1 0 1.6 0 7.4-36.5 39.7-64 78.4-64 15 0 29 4.1 40.9 11.2 13.3-25.7 40.1-43.2 71.1-43.2s57.8 17.6 71.1 43.2c12-7.1 26-11.2 40.9-11.2 38.7 0 71 27.5 78.4 64 .5 0 1.1 0 1.6 0 35.3 0 64 28.7 64 64 0 11.7-3.1 22.6-8.6 32L8.6 208C3.1 198.6 0 187.7 0 176zM0 283.4C0 268.3 12.3 256 27.4 256l457.1 0c15.1 0 27.4 12.3 27.4 27.4 0 70.5-44.4 130.7-106.7 154.1L403.5 452c-2 16-15.6 28-31.8 28l-231.5 0c-16.1 0-29.8-12-31.8-28l-1.8-14.4C44.4 414.1 0 353.9 0 283.4z"],
    "square-virus": [448, 512, [], "e578", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 80c13.3 0 24 10.7 24 24 0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24zM192 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "cloud-sun-rain": [576, 512, [127782], "f743", "M303.2-3.2c-1.1-5.2-4.6-9.5-9.5-11.6s-10.5-1.5-14.9 1.4L208 33.6 137.3-13.3c-4.4-2.9-10-3.5-14.9-1.4s-8.5 6.4-9.5 11.6L96 80 12.8 96.8c-5.2 1.1-9.5 4.6-11.6 9.5s-1.5 10.5 1.4 14.9L49.6 192 2.7 262.7c-2.9 4.4-3.5 10-1.4 14.9s6.4 8.5 11.6 9.5L96 304 112.8 387.2c1.1 5.2 4.6 9.5 9.5 11.6s10.5 1.5 14.9-1.4l67.3-44.6c-15.8-19.4-26-43.5-28.2-69.9-37.5-13.1-64.4-48.7-64.4-90.7 0-53 43-96 96-96 21.7 0 41.8 7.2 57.8 19.4 15.5-17.6 36.9-30 61.1-34L320 80 303.2-3.2zM243 159.1c-8.8-9.3-21.2-15.1-35-15.1-26.5 0-48 21.5-48 48 0 17 8.9 32 22.2 40.5 10.2-31.4 32.1-57.4 60.7-73l.1-.4zM304 352l192 0c44.2 0 80-35.8 80-80 0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-30.8 0-57.5 17.4-70.9 42.8-9.3-6.8-20.7-10.8-33.1-10.8-30.9 0-56 25.1-56 56 0 3.2 .3 6.4 .8 9.4-36.9 7.1-64.8 39.6-64.8 78.6 0 44.2 35.8 80 80 80zm-19 49.1c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4zm120 0c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4zm120 0c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4z"],
    "arrow-right-long": [576, 512, ["long-arrow-right"], "f178", "M566.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L466.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l434.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"],
    "building-un": [512, 512, [], "e4d9", "M32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 272-112 0c-20.9 0-39.5 10.1-51.2 25.6-8-6-18-9.6-28.8-9.6-26.5 0-48 21.5-48 48l0 64 64 0 0 48-144 0c-35.3 0-64-28.7-64-64L32 64zM144 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM144 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM427.4 380.5c9-2.1 18.3 2.2 22.5 10.5l26.1 52.2 0-43.3c0-11 9-20 20-20s20 9 20 20l0 128c0 9.3-6.4 17.3-15.4 19.5s-18.3-2.2-22.5-10.5L452 484.7 452 528c0 11-9 20-20 20s-20-9-20-20l0-128c0-9.3 6.4-17.3 15.4-19.5zM324 400l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-11 9-20 20-20s20 9 20 20l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-11 9-20 20-20s20 9 20 20z"],
    "temperature-low": [512, 512, [], "f76b", "M96 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 96zm96 336c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-28.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 28.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "door-open": [448, 512, [], "f52b", "M288 64l64 0 0 416c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-384c0-35.3-28.7-64-64-64l-96 0 0 0-160 0C60.7 0 32 28.7 32 64l0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-416zM160 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "align-left": [448, 512, [], "f036", "M288 64c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l224 0c17.7 0 32 14.3 32 32zm0 256c0 17.7-14.3 32-32 32L32 352c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zM0 192c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 224c-17.7 0-32-14.3-32-32zM448 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M149.1 64.8L138.7 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-74.7 0-10.4-31.2C356.4 45.2 338.1 32 317.4 32L194.6 32c-20.7 0-39 13.2-45.5 32.8zM256 192a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "users-rays": [640, 512, [], "e593", "M31-33C21.7-23.6 21.7-8.4 31 1L87 57c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L65-33c-9.4-9.4-24.6-9.4-33.9 0zM609-33c-9.4-9.4-24.6-9.4-33.9 0L519 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L609 1c9.4-9.4 9.4-24.6 0-33.9zM65 545l56-56c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L31 511c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0zm544 0c9.4-9.4 9.4-24.6 0-33.9l-56-56c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0zM320 208a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 32c-61.9 0-112 50.1-112 112l0 8c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-8c0-61.9-50.1-112-112-112zm216-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM451.2 260.4C469.4 286.3 480 317.9 480 352l0 8c0 8.4-1.4 16.5-4.1 24l78.8 0c11.8 0 21.3-9.6 21.3-21.3l0-10.7c0-53-43-96-96-96-10 0-19.7 1.5-28.8 4.4zm-262.4 0c-9.1-2.9-18.8-4.4-28.8-4.4-53 0-96 43-96 96l0 10.7c0 11.8 9.6 21.3 21.3 21.3l78.8 0c-2.7-7.5-4.1-15.6-4.1-24l0-8c0-34.1 10.6-65.7 28.8-91.6zM216 160a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"],
    "rainbow": [640, 512, [127752], "f75b", "M320 96C178.6 96 64 210.6 64 352l0 64c0 17.7-14.3 32-32 32S0 433.7 0 416l0-64C0 175.3 143.3 32 320 32S640 175.3 640 352l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64C576 210.6 461.4 96 320 96zm0 112c-79.5 0-144 64.5-144 144l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-114.9 93.1-208 208-208s208 93.1 208 208l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-79.5-64.5-144-144-144zM288 352l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-53 43-96 96-96s96 43 96 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "sitemap": [512, 512, [], "f0e8", "M192 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-8 0 0 64 120 0c39.8 0 72 32.2 72 72l0 56 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-56c0-13.3-10.7-24-24-24l-120 0 0 80 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-80-120 0c-13.3 0-24 10.7-24 24l0 56 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-56c0-39.8 32.2-72 72-72l120 0 0-64-8 0c-17.7 0-32-14.3-32-32l0-64z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M256 512c141.4 0 256-114.6 256-256 0-24.4-3.4-48.1-9.8-70.5 18.6-36.1-2.7-83.6-46.7-90-46.9-58.3-118.9-95.5-199.5-95.5S103.4 37.3 56.5 95.5c-44 6.4-65.3 53.9-46.7 90-6.4 22.4-9.8 46-9.8 70.5 0 141.4 114.6 256 256 256zM386.7 324.9c11.9-3.7 23.9 6.3 19.6 18.1-22.4 61.3-81.3 105.1-150.3 105.1S128.1 404.2 105.7 342.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1zm-31.6-231c5.3-10.7 20.5-10.7 25.8 0l20.9 42.4 46.7 6.8c11.8 1.7 16.5 16.2 8 24.5l-33.8 33 8 46.6c2 11.7-10.3 20.7-20.9 15.2l-41.8-22-41.8 22c-10.5 5.5-22.9-3.4-20.9-15.2l8-46.6-33.8-33c-8.5-8.3-3.8-22.8 8-24.5l46.7-6.8 20.9-42.4zm-198.2 0l20.9 42.4 46.7 6.8c11.8 1.7 16.5 16.2 8 24.5l-33.8 33 8 46.6c2 11.7-10.3 20.7-20.9 15.2l-41.8-22-41.8 22c-10.5 5.5-22.9-3.4-20.9-15.2l8-46.6-33.8-33c-8.5-8.3-3.8-22.8 8-24.5l46.7-6.8 20.9-42.4c5.3-10.7 20.5-10.7 25.8 0z"],
    "sort-up": [384, 512, ["sort-asc"], "f0de", "M32 224c-12.9 0-24.6-7.8-29.6-19.8S.2 178.5 9.4 169.4l160-160c12.5-12.5 32.8-12.5 45.3 0l160 160c9.2 9.2 11.9 22.9 6.9 34.9S364.9 224 352 224L32 224z"],
    "eye": [576, 512, [128065], "f06e", "M288 32c-80.8 0-145.5 36.8-192.6 80.6-46.8 43.5-78.1 95.4-93 131.1-3.3 7.9-3.3 16.7 0 24.6 14.9 35.7 46.2 87.7 93 131.1 47.1 43.7 111.8 80.6 192.6 80.6s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1 3.3-7.9 3.3-16.7 0-24.6-14.9-35.7-46.2-87.7-93-131.1-47.1-43.7-111.8-80.6-192.6-80.6zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64-11.5 0-22.3-3-31.7-8.4-1 10.9-.1 22.1 2.9 33.2 13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-12.2-45.7-55.5-74.8-101.1-70.8 5.3 9.3 8.4 20.1 8.4 31.7z"],
    "caret-left": [256, 512, [], "f0d9", "M224 96c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c9.2 9.2 22.9 11.9 34.9 6.9S224 428.9 224 416l0-320z"],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", "M224 112c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80l16 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80l-16 0zM0 288c0-76.3 35.7-160 112-160 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3 76.3 0 112 83.7 112 160 0 128-80 224-160 224-16.5 0-38.1-6.6-51.5-11.3-8.1-2.8-16.9-2.8-25 0-13.4 4.7-35 11.3-51.5 11.3-80 0-160-96-160-224z"],
    "scroll-torah": [576, 512, ["torah"], "f6a0", "M0 48C0 21.5 21.5 0 48 0 68.9 0 86.7 13.4 93.3 32l389.5 0c6.6-18.6 24.4-32 45.3-32 26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48-20.9 0-38.7-13.4-45.3-32L93.3 480c-6.6 18.6-24.4 32-45.3 32-26.5 0-48-21.5-48-48L0 48zM177.9 301c-1.2 2-1.9 4.2-1.9 6.6 0 6.9 5.6 12.5 12.5 12.5l56.9 0 30.5 49.2c2.6 4.2 7.2 6.8 12.2 6.8s9.6-2.6 12.2-6.8l30.5-49.2 56.9 0c6.9 0 12.5-5.6 12.5-12.5 0-2.3-.6-4.6-1.9-6.6l-27.8-45 27.8-45c1.2-2 1.9-4.2 1.9-6.6 0-6.9-5.6-12.5-12.5-12.5l-56.9 0-30.5-49.2c-2.6-4.2-7.2-6.8-12.2-6.8s-9.6 2.6-12.2 6.8l-30.5 49.2-56.9 0c-6.9 0-12.5 5.6-12.5 12.5 0 2.3 .6 4.6 1.9 6.6l27.8 45-27.8 45z"],
    "house-lock": [640, 512, [], "e510", "M528 224.1c44.2 0 80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l185 171.8C440.2 195 400 244.8 400 304l0 24.4c-19.6 17.6-32 43.1-32 71.5l0 96c0 5.5 .5 10.9 1.3 16.1L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM272 320c-26.5 0-48 21.5-48 48l0 96 96 0 0-87.3c0-16.5 7-31.5 18.4-42.1-8.7-9-20.9-14.6-34.4-14.6l-32 0zm256-47.9c-17.7 0-32 14.3-32 32l0 47.9 64 0 0-47.9c0-17.7-14.3-32-32-32z"],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", "M32 96C14.3 96 0 110.3 0 128L0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256c0-17.7-14.3-32-32-32zM390.6 342.6l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4-133.5 0 9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-6 6-9.4 14.1-9.4 22.6s3.4 16.6 9.4 22.6l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 133.5 0-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0zM576 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256z"],
    "trash": [448, 512, [], "f1f8", "M136.7 5.9L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-8.7-26.1C306.9-7.2 294.7-16 280.9-16L167.1-16c-13.8 0-26 8.8-30.4 21.9zM416 144L32 144 53.1 467.1C54.7 492.4 75.7 512 101 512L347 512c25.3 0 46.3-19.6 47.9-44.9L416 144z"],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm271 98c5.5-1.3 11.1-2 17-2 24.1 0 45.4 11.8 58.5 30 7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5c-21.7-30.2-57.3-50-97.5-50-12.5 0-24.6 1.9-35.9 5.5 9.8 12.7 16.5 27.9 18.9 44.6zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM185.4 292.8c-2.4-2.9-5.7-4.8-9.4-4.8s-7 1.9-9.4 4.8c-6.5 7.8-12.6 16.1-18.3 24.6-9 13.4-20.3 30.2-20.3 47.4 0 28.3 21.5 51.2 48 51.2s48-22.9 48-51.2c0-17.2-11.2-34-20.3-47.4-5.7-8.5-11.9-16.7-18.3-24.6z"],
    "fax": [512, 512, [128224, 128439], "f1ac", "M160 64l0 80 64 0 0-80 146.7 0 45.3 45.3 0 34.7 64 0 0-34.7c0-17-6.7-33.3-18.7-45.3L416 18.7C404 6.7 387.7 0 370.7 0L224 0c-35.3 0-64 28.7-64 64zM32 128c-17.7 0-32 14.3-32 32L0 448c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32l-48 0zm448 64l-320 0 0 256c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32zM224 288a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM336 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM312 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM424 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM400 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "person-circle-plus": [640, 512, [], "e541", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "hamsa": [512, 512, [], "f665", "M34.6 288L80 288c8.8 0 16-7.2 16-16L96 72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 132c0 11 9 20 20 20s20-9 20-20l0-164c0-22.1 17.9-40 40-40s40 17.9 40 40l0 164c0 11 9 20 20 20s20-9 20-20l0-132c0-22.1 17.9-40 40-40s40 17.9 40 40l0 200c0 8.8 7.2 16 16 16l45.4 0c19.1 0 34.6 15.5 34.6 34.6 0 8.6-3.2 16.9-9 23.3L416.6 441c-41.1 45.2-99.4 71-160.6 71S136.6 486.2 95.4 441L9 345.9c-5.8-6.4-9-14.7-9-23.3 0-19.1 15.5-34.6 34.6-34.6zM256 288c-38.4 0-76.8 35.8-90.6 50.2-3.6 3.7-5.4 8.7-5.4 13.8s1.8 10.1 5.4 13.8C179.2 380.2 217.6 416 256 416s76.8-35.8 90.6-50.2c3.6-3.7 5.4-8.7 5.4-13.8s-1.8-10.1-5.4-13.8C332.8 323.8 294.4 288 256 288zm0 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "person-circle-question": [640, 512, [], "e542", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-100c-11.6 0-21.3 8.2-23.5 19.2-1.8 8.7-10.2 14.3-18.9 12.5s-14.3-10.2-12.5-18.9c5.2-25.6 27.8-44.8 54.9-44.8 30.9 0 56 25.1 56 56 0 19.8-11.7 37.8-29.8 45.9l-10.4 4.6c-1.2 7.7-7.8 13.5-15.8 13.5-8.8 0-16-7.2-16-16 0-11.2 6.6-21.3 16.8-25.9l12.4-5.5c6.6-2.9 10.8-9.4 10.8-16.6 0-13.3-10.7-24-24-24z"],
    "clipboard-check": [384, 512, [], "f46c", "M256 0c23.7 0 44.4 12.9 55.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0zm26.9 212.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L288.2 246.1c7.8-10.7 5.4-25.7-5.3-33.5zM136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64z"],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", "M384.5 24l0 72-64 0c-79.5 0-144 64.5-144 144 0 93.4 82.8 134.8 100.6 142.6 2.2 1 4.6 1.4 7.1 1.4l2.5 0c9.8 0 17.8-8 17.8-17.8 0-8.3-5.9-15.5-12.8-20.3-8.9-6.2-19.2-18.2-19.2-40.5 0-45 36.5-81.5 81.5-81.5l30.5 0 0 72c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l136-136c9.4-9.4 9.4-24.6 0-33.9L425.5 7c-6.9-6.9-17.2-8.9-26.2-5.2S384.5 14.3 384.5 24zm-272 72c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32c0 8.8-7.2 16-16 16l-256 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0z"],
    "receipt": [384, 512, [129534], "f543", "M14 2.2C22.5-1.7 32.5-.3 39.6 5.8L80 40.4 120.4 5.8c9-7.7 22.3-7.7 31.2 0L192 40.4 232.4 5.8c9-7.7 22.2-7.7 31.2 0L304 40.4 344.4 5.8c7.1-6.1 17.1-7.5 25.6-3.6S384 14.6 384 24l0 464c0 9.4-5.5 17.9-14 21.8s-18.5 2.5-25.6-3.6l-40.4-34.6-40.4 34.6c-9 7.7-22.2 7.7-31.2 0l-40.4-34.6-40.4 34.6c-9 7.7-22.3 7.7-31.2 0L80 471.6 39.6 506.2c-7.1 6.1-17.1 7.5-25.6 3.6S0 497.4 0 488L0 24C0 14.6 5.5 6.1 14 2.2zM104 136c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM80 352c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm24-120c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "equals": [448, 512, [62764], "3d", "M32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 128zm0 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 320z"],
    "chevron-up": [448, 512, [], "f077", "M201.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 173.3 54.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"],
    "virus-slash": [576, 512, [], "e075", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-88.6-88.6c1.7-12.1-2-24.8-11.3-34-31.2-31.2-9.1-84.5 35-84.5 22.1 0 40-17.9 40-40s-17.9-40-40-40c-44.1 0-66.1-53.3-35-84.5 15.6-15.6 15.6-40.9 0-56.6s-40.9-15.6-56.6 0c-31.2 31.2-84.5 9.1-84.5-35 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 44.1-53.3 66.1-84.5 35-9.3-9.3-22-13-34-11.3L41-24.9zM72 216c-22.1 0-40 17.9-40 40s17.9 40 40 40c44.1 0 66.1 53.3 35 84.5-15.6 15.6-15.6 40.9 0 56.6s40.9 15.6 56.6 0c31.2-31.2 84.5-9.1 84.5 35 0 22.1 17.9 40 40 40s40-17.9 40-40c0-21.4 12.6-37.6 29.1-45.1l-240-240C109.6 203.4 93.4 216 72 216z"],
    "slash": [576, 512, [], "f715", "M7-25c9.4-9.4 24.6-9.4 33.9 0L569 503c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9C-2.3-.4-2.3-15.6 7-25z"],
    "expand": [448, 512, [], "f065", "M32 32C14.3 32 0 46.3 0 64l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM64 352c0-17.7-14.3-32-32-32S0 334.3 0 352l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64zM320 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0zM448 352c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96z"],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", "M64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 213.5c0 17-6.7 33.3-18.7 45.3L322.7 461.3c-12 12-28.3 18.7-45.3 18.7L64 480zM389.5 304L296 304c-13.3 0-24 10.7-24 24l0 93.5 117.5-117.5z"],
    "table-columns": [448, 512, ["columns"], "f0db", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 64l0 256 128 0 0-256-128 0zm320 0l-128 0 0 256 128 0 0-256z"],
    "person-shelter": [512, 512, [], "e54f", "M271.9 4.2c-9.8-5.6-21.9-5.6-31.8 0l-224 128C6.2 137.9 0 148.5 0 160L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32L64 178.6 256 68.9 448 178.6 448 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-11.5-6.2-22.1-16.1-27.8l-224-128zM256 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-8 192l16 0 0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-174.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-33.2-61.7C329.7 245.1 294.4 224 256 224s-73.7 21.1-91.9 54.9l-33.2 61.7c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L200 313.5 200 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88z"],
    "circle-notch": [512, 512, [], "f1ce", "M222.7 32.1c5 16.9-4.6 34.8-21.5 39.8-79.3 23.6-137.1 97.1-137.1 184.1 0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1-16.9-5-26.6-22.9-21.5-39.8s22.9-26.6 39.8-21.5C434.9 42.1 512 140 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256c0-116 77.1-213.9 182.9-245.4 16.9-5 34.8 4.6 39.8 21.5z"],
    "water": [512, 512, [], "f773", "M410.6 124.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm0 144c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.7-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm-71.2 144c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9z"],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", "M576 128c0-35.3-28.7-64-64-64L205.3 64c-17 0-33.3 6.7-45.3 18.7L9.4 233.4c-6 6-9.4 14.1-9.4 22.6s3.4 16.6 9.4 22.6L160 429.3c12 12 28.3 18.7 45.3 18.7L512 448c35.3 0 64-28.7 64-64l0-256zM284.1 188.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z"],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM106.8 277.2c30.6-30.6 73.1-45.9 115.8-42.2L341 353.3c3.7 42.8-11.6 85.2-42.2 115.9-27.4 27.4-64.6 42.8-103.3 42.8L22.1 512c-12.2 0-22.1-9.9-22.1-22.1 0-6.3 2.7-12.3 7.3-16.5L133.7 359.7c4.2-3.7-.4-10.4-5.4-7.9L77.2 377.4c-6.1 3-13.2-1.4-13.2-8.2 0-31.5 12.5-61.8 34.8-84l8-8zm417-270c12.6-10.3 31.1-9.5 42.8 2.2s12.4 30.2 2.2 42.8l-2.2 2.4-192 192 34.8 34.7c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6l-29.1 0-108.3-108.3 0-29.1c0-12.5 10.1-22.6 22.6-22.6 6 0 11.8 2.4 16 6.6l34.8 34.7 192-192 2.4-2.2z"],
    "j": [320, 512, [106], "4a", "M288 32c17.7 0 32 14.3 32 32l0 256c0 88.4-71.6 160-160 160S0 408.4 0 320l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 53 43 96 96 96s96-43 96-96l0-256c0-17.7 14.3-32 32-32z"],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", "M0 368l0 64c0 26.5 21.5 48 48 48l50 0c40.6 0 80.4-11 115.2-31.9l133.5-80.1-93.3 0-64.9 38.9c-14 8.4-28.9 14.7-44.5 19l0-66.4c9.7-5.6 17.8-13.7 23.4-23.4l198.8 0c67.1 0 127.8-20.6 170.3-70.6 4.6-5.4 4.6-13.3 0-18.8-42.5-50.1-103.2-70.6-170.3-70.6l-198.8 0c-5.6-9.7-13.7-17.8-23.4-23.4l0-66.4c15.6 4.2 30.6 10.6 44.5 19l64.9 38.9 93.3 0-133.5-80.1C178.4 43 138.6 32 98 32L48 32C21.5 32 0 53.5 0 80L0 368zm96 0l0 64-48 0 0-64 48 0zM96 80l0 64-48 0 0-64 48 0zM416 224c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"],
    "yin-yang": [512, 512, [9775], "f6ad", "M224 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 352a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-448c53 0 96 43 96 96s-43 96-96 96-96 43-96 96 43 96 96 96C150 448 64 362 64 256S150 64 256 64zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "stop": [448, 512, [9209], "f04d", "M64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"],
    "trowel": [576, 512, [], "e589", "M407.9 181.4L277.3 312 342.6 377.4c7.9 7.9 11.1 19.4 8.4 30.3s-10.8 19.6-21.5 22.9l-256 80c-11.4 3.5-23.8 .5-32.2-7.9s-11.5-20.8-7.9-32.2l80-256c3.3-10.7 12-18.9 22.9-21.5s22.4 .5 30.3 8.4L232 266.7 362.6 136.1c-14.3-14.6-14.2-38 .3-52.5l95.4-95.4c26.9-26.9 70.5-26.9 97.5 0s26.9 70.5 0 97.5l-95.4 95.4c-14.5 14.5-37.9 14.6-52.5 .3z"],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", "M7.4 253.6C2.6 245.9 0 237.1 0 228l0-36c0-26.5 21.5-48 48-48l16 0 0-80c0-26.5 21.5-48 48-48 17.3 0 32.4 9.1 40.9 22.8 4.3-22.1 23.8-38.8 47.1-38.8 23.4 0 42.9 16.8 47.1 38.9 7.3-4.4 15.8-6.9 24.9-6.9 22.1 0 40.8 15 46.3 35.4 5.5-2.2 11.4-3.4 17.7-3.4 26.5 0 48 21.5 48 48l0 96.9c0 9.9-2.3 19.7-6.8 28.6l-39.6 79.1c-10.8 21.7-33 35.4-57.2 35.4L96 352c-16.5 0-31.8-8.4-40.6-22.4l-48-76zM32 480l0-48c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32z"],
    "temperature-high": [512, 512, [], "f769", "M96 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 96zm96 336c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3L216 96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 212.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "greater-than": [512, 512, [62769], "3e", "M34.9 50.6c-7.4 16-.4 35.1 15.6 42.5L403.6 256 50.6 419c-16 7.4-23.1 26.4-15.6 42.5s26.4 23 42.5 15.6l416-192c11.3-5.2 18.6-16.6 18.6-29.1s-7.3-23.8-18.6-29.1L77.4 35c-16-7.4-35.1-.4-42.5 15.6z"],
    "crutch": [512, 512, [], "f7f7", "M297.4 9.4c12.5-12.5 32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-1.4-1.4-158.6 158.6c-18 18-42.4 28.1-67.9 28.1l-59 0c-8.5 0-16.6 3.4-22.6 9.4-61.7 61.7-92.8 92.8-93.3 93.3-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l16-16 0 0 77.3-77.3c6-6 9.4-14.1 9.4-22.6l0-59c0-25.5 10.1-49.9 28.1-67.9L298.7 56 297.4 54.6c-12.5-12.5-12.5-32.8 0-45.3zM344 101.3L261.3 184 328 250.7 410.7 168 344 101.3zm-128 128l-30.6 30.6c-6 6-9.4 14.1-9.4 22.6l0 53.5 53.5 0c8.5 0 16.6-3.4 22.6-9.4L282.7 296 216 229.3z"],
    "septagon": [576, 512, ["heptagon"], "e820", "M267.4-31.5c15.9-5.5 33.5-4.6 48.8 2.7l172.4 83 6.3 3.5c14.2 9 24.5 23.3 28.3 39.9l42.6 186.5 1.2 7.2c1.6 14.3-1.7 28.8-9.4 41.1l-4.2 5.9-119.3 149.6c-12.1 15.2-30.6 24.1-50 24.1l-191.3 0c-19.5 0-37.9-8.9-50-24.1L23.5 338.4c-12.1-15.2-16.7-35.2-12.3-54.2l42.6-186.5 2-7c5.6-15.9 17.2-29 32.6-36.4l172.4-83 6.7-2.7z"],
    "street-view": [512, 512, [], "f21d", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 48c0 17.7-14.3 32-32 32l-1.8 0-11.1 99.5c-1.8 16.2-15.5 28.5-31.8 28.5l-38.7 0c-16.3 0-30-12.3-31.8-28.5l-11.1-99.5-1.8 0c-17.7 0-32-14.3-32-32l0-48c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"],
    "wave-square": [512, 512, [], "f83e", "M64 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 288 96 0 0-128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-288-96 0 0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-128z"],
    "angle-left": [256, 512, [8249], "f104", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"],
    "screwdriver": [576, 512, [129691], "f54a", "M352.1 146.7l0-49.6c0-10.7 5.3-20.7 14.2-26.6L485.2-8.7c6.3-4.2 14.8-3.4 20.2 2l45.4 45.5c5.4 5.4 6.2 13.8 2 20.2L473.6 177.8c-5.9 8.9-15.9 14.2-26.6 14.2l-49.6 0-90.7 90.7c15 33.3 8.9 73.9-18.5 101.3L162.1 510.1c-18.7 18.7-49.1 18.7-67.9 0L34.1 449.9c-18.7-18.7-18.7-49.1 0-67.9L160.1 256c27.4-27.4 67.9-33.6 101.3-18.5l90.7-90.7z"],
    "tractor": [576, 512, [128668], "f722", "M160 96l0 96 133.4 0-57.6-96-75.8 0zM96 223L96 64c0-17.7 14.3-32 32-32l107.8 0c22.5 0 43.3 11.8 54.9 31.1l77.4 128.9 64 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 48 0c26.5 0 48 21.5 48 48l0 41.5c0 14.2-6.3 27.8-17.3 36.9l-35 29.2c26.5 15.2 44.3 43.7 44.3 76.4 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-14.4 3.5-28 9.6-40l-101.2 0c-3 13.4-7.9 26-14.4 37.7 7.7 9.4 7.2 23.4-1.6 32.2l-22.6 22.6c-8.8 8.8-22.7 9.3-32.2 1.6-9.3 5.2-19.3 9.3-29.8 12.3-1.2 12.1-11.4 21.6-23.9 21.6l-32 0c-12.4 0-22.7-9.5-23.9-21.6-10.5-3-20.4-7.2-29.8-12.3-9.4 7.7-23.4 7.2-32.2-1.6L35.5 453.8c-8.8-8.8-9.3-22.7-1.6-32.2-5.2-9.3-9.3-19.3-12.3-29.8-12.1-1.2-21.6-11.4-21.6-23.9l0-32c0-12.4 9.5-22.7 21.6-23.9 3-10.5 7.2-20.4 12.3-29.8-7.7-9.4-7.2-23.4 1.6-32.2l22.6-22.6c8.8-8.8 22.7-9.3 32.2-1.6 1.9-1 3.7-2 5.7-3zm64 65a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM440 424a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z"],
    "bridge-circle-xmark": [576, 512, [], "e4cb", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "vials": [512, 512, [], "f493", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l0 352c0 53 43 96 96 96s96-43 96-96l0-352 64 0 0 352c0 53 43 96 96 96s96-43 96-96l0-352c17.7 0 32-14.3 32-32S497.7 0 480 0L32 0zM160 64l0 128-64 0 0-128 64 0zm256 0l0 128-64 0 0-128 64 0z"],
    "stethoscope": [576, 512, [129658], "f0f1", "M32 48C32 21.5 53.5 0 80 0l48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 128c0 53 43 96 96 96s96-43 96-96l0-128-32 0c-17.7 0-32-14.3-32-32S238.3 0 256 0l48 0c26.5 0 48 21.5 48 48l0 144c0 77.4-55 142-128 156.8l0 19.2c0 61.9 50.1 112 112 112s112-50.1 112-112l0-85.5c-37.3-13.2-64-48.7-64-90.5 0-53 43-96 96-96s96 43 96 96c0 41.8-26.7 77.4-64 90.5l0 85.5c0 97.2-78.8 176-176 176S160 465.2 160 368l0-19.2C87 334 32 269.4 32 192L32 48zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "podcast": [448, 512, [], "f2ce", "M336 359.8c39.1-32.3 64-81.1 64-135.8 0-97.2-78.8-176-176-176S48 126.8 48 224C48 278.7 72.9 327.5 112 359.8 112.4 377.4 115.2 400.2 118.4 421.6 48 383.9 0 309.5 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224c0 85.6-48 159.9-118.5 197.6 3.3-21.4 6-44.2 6.4-61.8zm-14-53.4c-8.3-12.6-19.2-21.6-30.4-27.8-2.1-1.1-4.2-2.2-6.3-3.2 11.7-13.9 18.8-31.9 18.8-51.5 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 19.6 7.1 37.6 18.8 51.5-2.1 1-4.2 2-6.3 3.2-11.2 6.2-22.1 15.2-30.4 27.8-18.8-22.3-30.1-51-30.1-82.4 0-70.7 57.3-128 128-128s128 57.3 128 128c0 31.4-11.3 60.2-30.1 82.4zM224 312c32.9 0 64 8.6 64 43.8 0 33-12.9 104.1-20.6 132.9-5.1 19-24.5 23.4-43.4 23.4s-38.2-4.4-43.4-23.4c-7.8-28.5-20.6-99.7-20.6-132.8 0-35.1 31.1-43.8 64-43.8zm0-128a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "arrow-up-right-dots": [512, 512, [], "e4b7", "M96 32C78.3 32 64 46.3 64 64S78.3 96 96 96L114.7 96 9.4 201.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.3 160 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L96 32zM403.8 70.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM279.7 194.2a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm162.2-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM156.2 317.8a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM70.1 403.8a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0z"],
    "chess-queen": [512, 512, [9819], "f445", "M256 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM5.5 185L128 384 71.8 454.3c-5 6.3-7.8 14.1-7.8 22.2 0 19.6 15.9 35.5 35.5 35.5l312.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2L384 384 506.5 185c3.6-5.9 5.5-12.7 5.5-19.6l0-.6c0-20.3-16.5-36.8-36.8-36.8-7.3 0-14.4 2.2-20.4 6.2l-16.9 11.3c-12.7 8.5-29.6 6.8-40.4-4l-34.1-34.1C356.1 100.1 346.2 96 336 96s-20.1 4.1-27.3 11.3l-30.1 30.1c-12.5 12.5-32.8 12.5-45.3 0l-30.1-30.1C196.1 100.1 186.2 96 176 96s-20.1 4.1-27.3 11.3l-34.1 34.1c-10.8 10.8-27.7 12.5-40.4 4L57.3 134.2c-6.1-4-13.2-6.2-20.4-6.2-20.3 0-36.8 16.5-36.8 36.8l0 .6c0 6.9 1.9 13.7 5.5 19.6z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M320.5 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 257.9c-62.9-14.3-110.2-69.7-111.9-136.5l16.1 14.1c10 8.7 25.1 7.7 33.9-2.3s7.7-25.1-2.3-33.9l-64-56c-9-7.9-22.6-7.9-31.6 0l-64 56c-10 8.7-11 23.9-2.3 33.9s23.9 11 33.9 2.3l16.2-14.2c2.1 113.1 94.4 204.1 208 204.1 16.6 0 32.7-1.9 48.2-5.6-20.3-30.5-32.2-67-32.2-106.4 0-27.3 5.7-53.3 16-76.9l0-136.6c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zm208 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M64 144a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm0 224c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-112c0 30.9-25.1 56-56 56s-56-25.1-56-56 25.1-56 56-56 56 25.1 56 56z"],
    "heart-circle-exclamation": [576, 512, [], "e4fe", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 17.6-3.4 35.6-9.5 53.7-21.8-8.6-45.6-13.4-70.5-13.4-106 0-192 86-192 192 0 28.5 6.2 55.6 17.4 80-.5 0-.9 0-1.4 0-15.5 0-30.8-4.6-43.1-14.1-73-55.7-212.9-186-212.9-298.2l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"],
    "building-circle-exclamation": [576, 512, [], "e4d3", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-80c0-17.7 14.3-32 32-32l32 0c2 0 4 .2 5.9 .5 6-23.6 16.3-45.4 30.1-64.5l-4 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 4c27.5-19.8 60.3-32.4 96-35.4L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "person-arrow-up-from-line": [576, 512, [], "e539", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM318.3 299.1l-46.3-62.4 0 243.3 272 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 544c-17.7 0-32-14.3-32-32s14.3-32 32-32l80 0 0-243.3-46.3 62.4c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95C110 132 149.7 112 192 112s82 20 107.2 53.9l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6zM208 480l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128 32 0zM566.6 102.6c-12.5 12.5-32.8 12.5-45.3 0L496 77.3 496 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-146.7-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3z"],
    "not-equal": [448, 512, [], "f53e", "M378.6 81.8c9.8-14.7 5.8-34.6-8.9-44.4s-34.6-5.8-44.4 8.9L270.9 128 32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l196.2 0-85.3 128-110.9 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l68.2 0-30.8 46.2c-9.8 14.7-5.8 34.6 8.9 44.4s34.6 5.8 44.4-8.9L177.1 384 416 384c17.7 0 32-14.3 32-32s-14.3-32-32-32l-196.2 0 85.3-128 110.9 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-68.2 0 30.8-46.2z"],
    "train-tram": [384, 512, [128650], "e5b4", "M0 8C0-5.3 10.7-16 24-16l336 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-120 0 0 64 40 0c53 0 96 43 96 96l0 160c0 31.2-14.9 59-38 76.5l64.3 76c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8l-74.6-88.1c-3.6 .4-7.3 .6-11.1 .6l-128 0c-3.8 0-7.5-.2-11.1-.6L42.3 535.5c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8l64.3-76C46.9 411 32 383.2 32 352l0-160c0-53 43-96 96-96l40 0 0-64-120 0 0 8c0 13.3-10.7 24-24 24S0 53.3 0 40L0 8zM128 160c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-128 0zm32 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "plane-departure": [576, 512, [128747], "f5b0", "M372 143.9L172.7 40.2c-8-4.1-17.3-4.8-25.7-1.7l-41.1 15c-10.3 3.7-13.8 16.4-7.1 25L200.3 206.4 100.1 242.8 40 206.2c-6.2-3.8-13.8-4.5-20.7-2.1L3 210.1c-9.4 3.4-13.4 14.5-8.3 23.1l53.6 91.8c15.6 26.7 48.1 38.4 77.1 27.8l12.9-4.7 0 0 398.4-145c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L372 143.9zM32.2 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-512 0z"],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", "M345 273c9.4-9.4 9.4-24.6 0-33.9L201 95c-6.9-6.9-17.2-8.9-26.2-5.2S160 102.3 160 112l0 80-112 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l112 0 0 80c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L345 273zm7 143c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0z"],
    "sd-card": [384, 512, [], "f7c2", "M384 64c0-35.3-28.7-64-64-64L125.3 0C108.3 0 92 6.7 80 18.7L18.7 80C6.7 92 0 108.3 0 125.3L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384zM160 88l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "house-circle-exclamation": [640, 512, [], "e50a", "M496 544a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l217.6 202c-10.2-1.7-20.7-2.6-31.3-2.6-78.6 0-146.1 47.2-175.8 114.8-5.1-1.8-10.5-2.8-16.2-2.8l-32 0c-26.5 0-48 21.5-48 48l0 96 91 0c6.1 17.3 14.6 33.4 25.1 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM496 444a20 20 0 1 0 0 40 20 20 0 1 0 0-40zm0-140c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16 8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"],
    "shekel-sign": [448, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", "M32 32C14.3 32 0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352 128 0c35.3 0 64 28.7 64 64l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-70.7-57.3-128-128-128L32 32zM320 480c70.7 0 128-57.3 128-128l0-288c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 288c0 35.3-28.7 64-64 64l-128 0 0-224c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l160 0z"],
    "radio": [512, 512, [128251], "f8d7", "M494.8 15c12.7-3.7 20-17.1 16.3-29.8S494-34.8 481.3-31L51.8 94.9C42.4 97.6 33.9 102.1 26.6 108 10.5 119.7 0 138.6 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L218.5 96 494.8 15zM368 208a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM64 248c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 272c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 368c-13.3 0-24-10.7-24-24z"],
    "hand-dots": [512, 512, ["allergies"], "f461", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4S-3.6 325.7 12.4 341L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208zM200 352a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-88 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M96 512l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-66.7c18.6-6.6 32-24.4 32-45.3l0-288c0-26.5-21.5-48-48-48L96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96zM64 416c0-17.7 14.3-32 32-32l256 0 0 64-256 0c-17.7 0-32-14.3-32-32zM272 163.2l0 12.8c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-12.8c-19.4-11.7-32-30.3-32-51.2 0-35.3 35.8-64 80-64s80 28.7 80 64c0 20.9-12.6 39.5-32 51.2zM208 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm74.2 95.7c4.6 10.1 .1 21.9-9.9 26.5l-47.9 21.8 47.9 21.8c10.1 4.6 14.5 16.4 9.9 26.5s-16.4 14.5-26.5 9.9L224 294 144.3 330.2c-10.1 4.6-21.9 .1-26.5-9.9s-.1-21.9 9.9-26.5l47.9-21.8-47.9-21.8c-10.1-4.6-14.5-16.4-9.9-26.5s16.4-14.5 26.5-9.9L224 250 303.7 213.8c10.1-4.6 21.9-.1 26.5 9.9z"],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", "M192 32c-35.3 0-64 28.7-64 64l0 64 192 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l0-64c0-70.7 57.3-128 128-128 63.5 0 116.1 46.1 126.2 106.7 2.9 17.4-8.8 33.9-26.3 36.9s-33.9-8.8-36.9-26.3C250 55.1 223.7 32 192 32zm40 328c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM209 263c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 86.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-86.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M554.8 203.4l16.3 2.3C547.7 88.4 444.2 0 320 0S92.3 88.4 68.9 205.7l16.3-2.3c37-5.3 68.6 26.4 63.4 63.4l-6.7 46.7c-4.1 29-21.6 53.2-45.8 66.8 43.7 78.5 127.6 131.7 223.8 131.7s180.1-53.1 223.8-131.7c-24.1-13.5-41.6-37.8-45.8-66.8l-6.7-46.7c-5.3-37 26.4-68.6 63.4-63.4zM470.3 326.9C447.9 388.2 389.1 432 320 432S192.1 388.2 169.7 326.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1c11.9-3.7 23.9 6.3 19.6 18.1zM212 208l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zM640 300.6c0-25.6-18.8-47.3-44.1-50.9L549.1 243c-10.6-1.5-19.6 7.5-18.1 18.1l6.7 46.7c3.6 25.3 25.3 44.1 50.9 44.1 28.4 0 51.4-23 51.4-51.4zm-640 0C0 329 23 352 51.4 352 77 352 98.7 333.2 102.3 307.9l6.7-46.7c1.5-10.6-7.5-19.6-18.1-18.1l-46.7 6.7C18.8 253.3 0 275 0 300.6z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0L368 46.1 465.9 144 490.3 119.6c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7zm-299.2 220c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L432 177.9 334.1 80 172.4 241.7zM96 64C43 64 0 107 0 160L0 416c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 64z"],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", "M256.2 48c114.8 .1 207.8 93.2 207.8 208 0 22.1-3.4 43.4-9.8 63.4-2 .4-4.1 .6-6.2 .6l-2.7 0c-8.5 0-16.6-3.4-22.6-9.4l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6l0-50.7c0-8.8 7.2-16 16-16s16-7.2 16-16-7.2-16-16-16l-24 0c-13.3 0-24 10.7-24 24s-10.7 24-24 24l-56 0c-8.8 0-16 7.2-16 16s-7.2 16-16 16l-25.4 0c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l70.1-70.1c2.1-2.1 3.3-5 3.3-8 0-6.2-5.1-11.3-11.3-11.3l-14.1 0c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l23.1-23.1c.8-.8 1.6-1.5 2.5-2.2zM438.4 356.1c-32.8 59.6-93.9 101.4-165.2 107.2-.7-2.3-1.1-4.8-1.1-7.3 0-13.3-10.7-24-24-24l-26.7 0c-8.5 0-16.6-3.4-22.6-9.4l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6l0-66.7c0-17.7 14.3-32 32-32l98.7 0c8.5 0 16.6 3.4 22.6 9.4l29.3 29.3c6 6 14.1 9.4 22.6 9.4l5.5 0c8.5 0 16.6 3.4 22.6 9.4l16 16c4.2 4.2 10 6.6 16 6.6 4.8 0 9.3 1.5 13 4.1zM256 512l26.2-1.3c-8.6 .9-17.3 1.3-26.2 1.3zm26.2-1.3C411.3 497.6 512 388.6 512 256 512 114.6 397.4 0 256 0l0 0C114.6 0 0 114.6 0 256 0 383.5 93.2 489.3 215.3 508.8 228.5 510.9 242.1 512 256 512zM187.3 123.3l-32 32c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l32-32c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "face-grin-beam-sweat": [576, 512, [128517, "grin-beam-sweat"], "f583", "M546.2-.1c14.7 17.8 29.8 40.1 29.8 64.1 0 36.4-27.6 64-64 64s-64-27.6-64-64c0-24 15.2-46.3 29.8-64.1 8.8-10.7 18.5-20.8 29-30 3-2.6 7.4-2.6 10.4 0 10.5 9.1 20.1 19.3 29 30zM288 0c42.5 0 82.6 10.4 117.8 28.7-3.6 10.9-5.8 22.7-5.8 35.3 0 62.9 49.1 112 112 112 6.4 0 12.7-.5 18.8-1.5 8.6 25.6 13.2 53 13.2 81.5 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0zM418.7 308.9C379.5 321.1 335.1 328 288 328s-91.5-6.9-130.7-19.1c-11.9-3.7-23.9 6.3-19.6 18.1 22.4 61.3 81.3 105.1 150.3 105.1s127.9-43.8 150.3-105.1c4.3-11.8-7.7-21.8-19.6-18.1zM208 180c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28zm132 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M448 256c0-106-86-192-192-192l0 384c106 0 192-86 192-192zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "person-military-to-person": [512, 512, [], "e54c", "M71 12.5c-8.6 1-15 8.2-15 16.8 0 9.3 7.5 16.8 16.7 16.9l111.4 0c8.8-.1 15.9-7.2 15.9-16L200 16c0-9.5-8.3-17-17.8-15.9L71 12.5zM189.5 78.1l-122.9 0c-1.6 5.7-2.5 11.7-2.5 17.9 0 35.3 28.7 64 64 64s64-28.7 64-64c0-6.2-.9-12.2-2.5-17.9zM32 256l0 32c0 17.7 14.3 32 32 32l128 0c1.8 0 3.5-.1 5.2-.4L53 208.6C40.1 220.3 32 237.2 32 256zm190.2 42.5c1.1-3.3 1.8-6.8 1.8-10.5l0-32c0-35.3-28.7-64-64-64l-64 0c-3.7 0-7.4 .3-10.9 .9L222.2 298.5zM384 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-35.3 0-64 28.7-64 64l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-35.3-28.7-64-64-64l-64 0zM215.8 450.1c5.2-4.6 8.2-11.1 8.2-18.1s-3-13.5-8.2-18.1l-64-56c-7.1-6.2-17.1-7.7-25.7-3.8S112 366.6 112 376l0 32-88 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l88 0 0 32c0 9.4 5.5 18 14.1 21.9s18.6 2.4 25.7-3.8l64-56zM288 431.9c0 6.9 3 13.5 8.1 18.1l64 56.4c7.1 6.2 17.1 7.8 25.7 3.9S400 497.8 400 488.4l0-32.4 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-32c0-9.4-5.5-18-14.1-21.9s-18.6-2.4-25.7 3.8l-64 56c-5.2 4.5-8.2 11.1-8.2 18z"],
    "table-cells-column-lock": [640, 512, [], "e678", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 90.8c-10.1 15.2-16 33.4-16 53.1l0 96c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49zM128 224l0 192 64 0 0-192-64 0zm432 48.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 368c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "truck-field-un": [640, 512, [], "e58e", "M96 32C60.7 32 32 60.7 32 96l0 32c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l0 48c0 21.1 13.7 39.1 32.6 45.5-.4 3.4-.6 7-.6 10.5 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l144.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l.4 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-24.7 0-1.7-4.2-43.8-106.3c-12.3-30-41.6-49.5-74-49.5l-40.4 0C364.4 44.9 343.7 32 320 32L96 32zM384 224l0-96 31.9 0c6.5 0 12.3 3.9 14.8 9.9l35.4 86.1-82.1 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM256.6 132.9l27.4 41 0-29.9c0-11 9-20 20-20s20 9 20 20l0 96c0 8.8-5.8 16.6-14.2 19.1s-17.5-.7-22.4-8l-27.4-41 0 29.9c0 11-9 20-20 20s-20-9-20-20l0-96c0-8.8 5.8-16.6 14.2-19.1s17.5 .7 22.4 8zM132 144l0 64c0 6.6 5.4 12 12 12s12-5.4 12-12l0-64c0-11 9-20 20-20s20 9 20 20l0 64c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-64c0-11 9-20 20-20s20 9 20 20z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 136c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2 280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "book": [448, 512, [128212], "f02d", "M384 512L96 512c-53 0-96-43-96-96L0 96C0 43 43 0 96 0L400 0c26.5 0 48 21.5 48 48l0 288c0 20.9-13.4 38.7-32 45.3l0 66.7c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0zM96 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0-64-256 0zm32-232c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm24 72c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM101.6 314c-3.7-13.7 7.5-26 21.7-26l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "cloud-meatball": [512, 512, [], "f73b", "M0 224c0 53 43 96 96 96l26.9 0c3.5-12.1 10.1-23.3 19.2-32.4l1.4-1.4c15-15 35.3-22.9 56.1-22.2 14.2-15.1 34.2-23.9 55.4-23.9l2 0c21.1 0 41.1 8.8 55.4 23.9 20.8-.6 41.1 7.3 56.1 22.2l1.4 1.4c9.2 9.2 15.7 20.4 19.2 32.4l26.9 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2zM156.5 424.3c9.5 6.3 14.2 17.7 11.9 28.8-1.8 9.2 1 18.7 7.7 25.3l1.4 1.4c6.6 6.6 16.1 9.5 25.3 7.7 11.1-2.2 22.5 2.5 28.8 11.9 5.2 7.8 14 12.5 23.3 12.5l2 0c9.4 0 18.1-4.7 23.3-12.5 6.3-9.5 17.7-14.2 28.8-11.9 9.2 1.8 18.7-1 25.3-7.7l1.4-1.4c6.6-6.6 9.5-16.1 7.7-25.3-2.2-11.1 2.5-22.5 11.9-28.8 7.8-5.2 12.5-14 12.5-23.3l0-2c0-9.4-4.7-18.1-12.5-23.3-9.5-6.3-14.2-17.7-11.9-28.8 1.8-9.2-1-18.7-7.7-25.3l-1.4-1.4c-6.6-6.6-16.1-9.5-25.3-7.7-11.1 2.2-22.5-2.5-28.8-11.9-5.2-7.8-14-12.5-23.3-12.5l-2 0c-9.4 0-18.1 4.7-23.3 12.5-6.3 9.5-17.7 14.2-28.8 11.9-9.2-1.8-18.7 1-25.3 7.7l-1.4 1.4c-6.6 6.6-9.5 16.1-7.7 25.3 2.2 11.1-2.5 22.5-11.9 28.8-7.8 5.2-12.5 14-12.5 23.3l0 2c0 9.4 4.7 18.1 12.5 23.3zM48 448a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm416 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM240 96c6.7 0 13.1 2.8 17.7 7.8L328.8 181.3 375 135c9.4-9.4 24.6-9.4 33.9 0l64 64c4.5 4.5 7 10.6 7 17l0 112c0 13.3-10.7 24-24 24l-304 0c-13.3 0-24-10.7-24-24l0-112c0-6 2.3-11.8 6.3-16.2l88-96c4.5-5 11-7.8 17.7-7.8z"],
    "rupiah-sign": [512, 512, [], "e23d", "M0 64C0 46.3 14.3 32 32 32l80 0c79.5 0 144 64.5 144 144 0 54.3-30 101.5-74.4 126.1l41 136.7c5.1 16.9-4.5 34.8-21.5 39.8s-34.8-4.5-39.8-21.5L120.1 319.8c-2.7 .1-5.4 .2-8.1 .2l-48 0 0 128c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64zM64 256l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160zm256-32l80 0c61.9 0 112 50.1 112 112S461.9 448 400 448l-48 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32zm80 160c26.5 0 48-21.5 48-48s-21.5-48-48-48l-48 0 0 96 48 0z"],
    "text-width": [448, 512, [], "f035", "M40 0C17.9 0 0 17.9 0 40L0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 128 0 0 160-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-160 128 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-22.1-17.9-40-40-40L40 0zm78.6 406.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 229.5 0-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4-229.5 0 9.4-9.4z"],
    "satellite": [512, 512, [128752], "f7bf", "M199 7c9.4-9.4 24.6-9.4 33.9 0l89.4 89.4 55-55c12.5-12.5 32.8-12.5 45.3 0l48 48c12.5 12.5 12.5 32.8 0 45.3l-55 55 89.4 89.4c9.4 9.4 9.4 24.6 0 33.9l-96 96c-9.4 9.4-24.6 9.4-33.9 0l-89.4-89.4-15.5 15.5c11.4 24.6 17.8 52 17.8 80.9 0 31.7-7.7 61.5-21.2 87.8-4.7 9-16.7 10.3-23.8 3.1l-96.3-96.3-60 60c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l60-60-96.3-96.3c-7.2-7.2-5.9-19.2 3.1-23.8 26.3-13.6 56.2-21.2 87.8-21.2 28.9 0 56.3 6.4 80.9 17.8L192.4 226.3 103 137c-9.4-9.4-9.4-24.6 0-33.9L199 7zm17 50.9l-62.1 62.1 72.4 72.4 62.1-62.1-72.4-72.4zM392 358.1l62.1-62.1-72.4-72.4-62.1 62.1 72.4 72.4z"],
    "magnifying-glass-minus": [512, 512, ["search-minus"], "f010", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM136 184c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "people-group": [512, 512, [], "e533", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm96 312c0 25-12.7 47-32 59.9l0 92.1c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-92.1C172.7 359 160 337 160 312l0-40c0-53 43-96 96-96s96 43 96 96l0 40zM96 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm16 240l0 32c0 32.5 12.1 62.1 32 84.7l0 75.3c0 1.2 0 2.5 .1 3.7-8.5 7.6-19.7 12.3-32.1 12.3l-32 0c-26.5 0-48-21.5-48-48l0-56.6C12.9 364.4 0 343.7 0 320l0-32c0-53 43-96 96-96 12.7 0 24.8 2.5 35.9 6.9-12.6 21.4-19.9 46.4-19.9 73.1zM368 464l0-75.3c19.9-22.5 32-52.2 32-84.7l0-32c0-26.7-7.3-51.6-19.9-73.1 11.1-4.5 23.2-6.9 35.9-6.9 53 0 96 43 96 96l0 32c0 23.7-12.9 44.4-32 55.4l0 56.6c0 26.5-21.5 48-48 48l-32 0c-12.3 0-23.6-4.6-32.1-12.3 0-1.2 .1-2.5 .1-3.7zM416 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "square-binary": [448, 512, [], "e69b", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 4c-24.3 0-44 19.7-44 44l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0zm-4 44c0-2.2 1.8-4 4-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48zm140-44c-11 0-20 9-20 20 0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0zM132 296c0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20zm96 24l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0c-24.3 0-44 19.7-44 44zm44-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48c0-2.2 1.8-4 4-4z"],
    "masks-theater": [576, 512, [127917, "theater-masks"], "f630", "M-5 118L23.5 279.7c14 79.5 76.3 141.8 155.8 155.8l12.7 2.2c-16.5-28.6-27.1-60.7-30.6-94.5l-24.1 4.3c-9.7 1.7-18.8-5.8-16.9-15.5 4.8-24.7 19.1-46.6 39.7-60.9l0-74.6c-1.4 .8-3 1.3-4.7 1.6l-63 11.1c-8.7 1.5-17.3-4.4-15.9-13.1 3.1-19.6 18.4-36 39.1-39.7 17.2-3 33.9 3.5 44.6 15.8l0-22.7c0-22.5 6.9-52.4 32.3-73.4 26-21.5 67.7-43.9 124.9-54.2-30.5-16.3-86.3-32-163.8-18.4-80.3 14.2-128 50.1-150.1 76.1-9 10.5-10.8 24.9-8.4 38.5zM208 138.7l0 174.8c0 80.7 50.5 152.9 126.4 180.4L362.1 504c14.1 5.1 29.6 5.1 43.7 0L433.6 494C509.5 466.4 560 394.3 560 313.5l0-174.8c0-6.9-2.1-13.8-7-18.6-22.6-22.5-78.2-56-169-56s-146.4 33.6-169 56c-4.9 4.9-7 11.7-7 18.6zm66.1 187.1c-1.4-7 7-11 12.7-6.6 26.9 20.6 60.6 32.9 97.2 32.9s70.2-12.3 97.2-32.9c5.7-4.4 14.1-.4 12.7 6.6-10.1 51.4-55.5 90.3-109.9 90.3s-99.8-38.8-109.9-90.3zm.5-101.5C281.2 205.5 299 192 320 192s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7l-64 0c-8.8 0-16.3-7.4-13.4-15.7zM480 240l-64 0c-8.8 0-16.3-7.4-13.4-15.7 6.5-18.8 24.4-32.3 45.4-32.3s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7z"],
    "cart-plus": [640, 512, [], "f217", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 412.7 0c20 0 35.1 18.2 31.4 37.9L537.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM336 78.4c-13.3 0-24 10.7-24 24l0 33.6-33.6 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l33.6 0 0 33.6c0 13.3 10.7 24 24 24s24-10.7 24-24l0-33.6 33.6 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-33.6 0 0-33.6c0-13.3-10.7-24-24-24z"],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", "M156.6 46.3c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3L13.5 189.4C4.6 207.2 0 226.8 0 246.7L0 256c0 70.7 57.3 128 128 128l80 0 0-.3c35.2-2.7 65.4-22.8 82.1-51.7 8.8-15.3 3.6-34.9-11.7-43.7s-34.9-3.6-43.7 11.7c-7 12-19.9 20-34.7 20-22.1 0-40-17.9-40-40s17.9-40 40-40c14.8 0 27.7 8 34.7 20 8.8 15.3 28.4 20.5 43.7 11.7s20.5-28.4 11.7-43.7c-12.8-22.1-33.6-39.1-58.4-47.1l80.8-22c17-4.6 27.1-22.2 22.5-39.3s-22.2-27.1-39.3-22.5l-100.7 27.5 81.6-68c13.6-11.3 15.4-31.5 4.1-45.1S249.1-3.9 235.5 7.4l-101.9 84.9 23-46zM483.4 465.7c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l85.9-171.7c8.9-17.8 13.5-37.4 13.5-57.2l0-9.3c0-70.7-57.3-128-128-128l-80 0 0 .3c-35.2 2.7-65.4 22.8-82.1 51.7-8.9 15.3-3.6 34.9 11.7 43.7s34.9 3.6 43.7-11.7c7-12 19.9-20 34.7-20 22.1 0 40 17.9 40 40s-17.9 40-40 40c-14.8 0-27.7-8-34.7-20-8.9-15.3-28.4-20.5-43.7-11.7s-20.5 28.4-11.7 43.7c12.8 22.1 33.6 39.1 58.4 47.1l-80.8 22c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5l100.7-27.5-81.6 68c-13.6 11.3-15.4 31.5-4.1 45.1s31.5 15.4 45.1 4.1l101.9-84.9-23 46z"],
    "table-cells-row-unlock": [640, 512, [], "e691", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 90.8c-10.1 15.2-16 33.4-16 53.1l0 96c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49zM128 224l0 192 64 0 0-192-64 0zm432 48c-.1-17.6-14.4-31.9-32-31.9-17.7 0-32 14.3-32 32l0 47.9 96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80 44.2 0 79.9 35.8 80 79.9l-48 0z"],
    "rocket": [512, 512, [], "f135", "M128 320L24.5 320c-24.9 0-40.2-27.1-27.4-48.5L50 183.3C58.7 168.8 74.3 160 91.2 160l95 0c76.1-128.9 189.6-135.4 265.5-124.3 12.8 1.9 22.8 11.9 24.6 24.6 11.1 75.9 4.6 189.4-124.3 265.5l0 95c0 16.9-8.8 32.5-23.3 41.2l-88.2 52.9c-21.3 12.8-48.5-2.6-48.5-27.4L192 384c0-35.3-28.7-64-64-64l-.1 0zM400 160a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "shrimp": [512, 512, [129424], "e448", "M72 32C32.2 32 0 64.2 0 104 0 141.9 29.3 172.9 66.4 175.8 77.6 257.2 147.4 320 232 320l56 0 0-192-216 0c-13.3 0-24-10.7-24-24S58.7 80 72 80l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 32zM224 456c0 13.3 10.7 24 24 24l72 0 0-72.2-64.1-22.4c-12.5-4.4-26.2 2.2-30.6 14.7s2.2 26.2 14.7 30.6l4.5 1.6C233 433.9 224 443.9 224 456zm128 23.3c36.4-3.3 69.5-17.6 96.1-39.6l-86.5-34.6c-3 1.8-6.2 3.2-9.6 4.3l0 69.9zM472.6 415c24.6-30.3 39.4-68.9 39.4-111 0-12.3-1.3-24.3-3.7-35.9L382.8 355.1c.8 3.4 1.2 7 1.2 10.6 0 4.6-.7 9-1.9 13.1L472.6 415zM336 128l-16 0 0 192 18.3 0c9.9 0 19.1 3.2 26.6 8.5l133.5-92.4C471.8 172.6 409.1 128 336 128zM168 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", "M0 56C0 42.7 10.7 32 24 32l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 80C10.7 80 0 69.3 0 56zM0 160c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0 0 256c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256-128 0c-17.7 0-32-14.3-32-32z"],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", "M234.2 8.6c12.3-11.4 31.3-11.4 43.5 0L368 92.3 368 80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 101.5 37.8 35.1c9.6 9 12.8 22.9 8 35.1S493.2 272 480 272l-16 0 0 176c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208zM224 248l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "users-slash": [640, 512, [], "e073", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L321.8 224c56.6-1 102.2-47.2 102.2-104 0-57.4-46.6-104-104-104-56.8 0-103 45.6-104 102.2L73-24.9zM512 288c-17.2 0-33.7 3.4-48.7 9.6l170 170c4.2-5.4 6.7-12.2 6.7-19.6l0-32c0-70.7-57.3-128-128-128zM59.9 97.7c-21.5 12.5-35.9 35.7-35.9 62.3 0 39.8 32.2 72 72 72 26.6 0 49.8-14.4 62.3-35.9L59.9 97.7zM250.2 288C196.8 313.9 160 368.7 160 432l0 16c0 17.7 14.3 32 32 32l250.2 0-192-192zM128 288C57.3 288 0 345.3 0 416l0 32c0 17.7 14.3 32 32 32l86.7 0c-4.3-9.8-6.7-20.6-6.7-32l0-16c0-53.2 20-101.8 52.9-138.6-11.7-3.5-24.1-5.4-36.9-5.4zM616 160a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "paper-plane": [576, 512, [61913], "f1d8", "M536.4-26.3c9.8-3.5 20.6-1 28 6.3s9.8 18.2 6.3 28l-178 496.9c-5 13.9-18.1 23.1-32.8 23.1-14.2 0-27-8.6-32.3-21.7l-64.2-158c-4.5-11-2.5-23.6 5.2-32.6l94.5-112.4c5.1-6.1 4.7-15-.9-20.6s-14.6-6-20.6-.9L229.2 276.1c-9.1 7.6-21.6 9.6-32.6 5.2L38.1 216.8c-13.1-5.3-21.7-18.1-21.7-32.3 0-14.7 9.2-27.8 23.1-32.8l496.9-178z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M96 512l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-66.7c18.6-6.6 32-24.4 32-45.3l0-288c0-26.5-21.5-48-48-48L96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96zM64 416c0-17.7 14.3-32 32-32l256 0 0 64-256 0c-17.7 0-32-14.3-32-32zM310.6 208L279 208c-1.4 23.1-6 44.2-12.6 61.2 22.7-12.5 39.4-34.8 44.2-61.2zm-173.1 0c4.8 26.4 21.5 48.7 44.2 61.2-6.7-17-11.2-38-12.6-61.2l-31.6 0zm76.4 55c4.5 9.6 8.2 13.8 10.2 15.5 2-1.7 5.7-5.8 10.2-15.5 6.2-13.4 11.1-32.5 12.7-55l-45.8 0c1.6 22.5 6.5 41.6 12.7 55zm-12.7-87l45.8 0c-1.6-22.5-6.5-41.6-12.7-55-4.5-9.6-8.2-13.8-10.2-15.5-2 1.7-5.7 5.8-10.2 15.5-6.2 13.4-11.1 32.5-12.7 55zm109.5 0c-4.8-26.4-21.5-48.7-44.2-61.2 6.7 17 11.2 38 12.6 61.2l31.6 0zM169 176c1.4-23.1 6-44.2 12.6-61.2-22.7 12.5-39.4 34.8-44.2 61.2l31.6 0zM96 192a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"],
    "table": [448, 512, [], "f0ce", "M256 160l0 96 128 0 0-96-128 0zm-64 0l-128 0 0 96 128 0 0-96zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm384 0l-128 0 0 96 128 0 0-96zM192 416l0-96-128 0 0 96 128 0z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167c9.4-9.4 24.6-9.4 33.9 0L377 271z"],
    "battery-half": [640, 512, ["battery-3"], "f242", "M528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm56 112c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-144 0z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0 0-64 373.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96z"],
    "handcuffs": [576, 512, [], "e4f8", "M320-32c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32 32-14.3 32-32zM192 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM152 96c-13.3 0-24 10.7-24 24l0 16c0 1 .1 1.9 .2 2.9-74.7 26.3-128.2 97.5-128.2 181.1 0 106 86 192 192 192s192-86 192-192c0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0zM64 320a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm448 0c0 66.9-51.3 121.8-116.6 127.5-14.3 22.8-32.4 43.1-53.4 59.9 13.5 3 27.6 4.6 42 4.6 106 0 192-86 192-192 0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0c-12.3 0-22.4 9.2-23.8 21.1 30.3 19.2 56.1 45 75.2 75.4 65.4 5.8 116.6 60.6 116.6 127.5zM384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "hat-cowboy-side": [640, 512, [], "f8c1", "M640 388.3c0 16.9-7.1 32.2-18.4 43.1l-35-23.3-292.7-195.1c-36.1-24.1-78.6-36.9-122-36.9l-3.9 0c-2.7 0-5.4 0-8 .1l22.2-100c5.7-25.8 28.6-44.1 55-44.1 12.2 0 24.1 4 33.8 11.3l4.7 3.5c26.3 19.7 62.4 19.7 88.6 0l4.7-3.5c9.8-7.3 21.6-11.3 33.8-11.3 26.4 0 49.3 18.3 55 44.1l33 148.5C574.5 232.3 640 302.6 640 388.3zM171.9 224c33.9 0 67.1 10 95.4 28.9L560 448 56 448c-30.9 0-56-25.1-56-56 0-92.8 75.2-168 168-168l3.9 0z"],
    "industry": [512, 512, [], "f275", "M32 32C14.3 32 0 46.3 0 64L0 432c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-279.8c0-18.2-19.4-29.7-35.4-21.1l-156.6 84.3 0-63.2c0-18.2-19.4-29.7-35.4-21.1L128 215.4 128 64c0-17.7-14.3-32-32-32L32 32z"],
    "lines-leaning": [384, 512, [], "e51e", "M190.4 74.1c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2l-128 384c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l128-384zm70.9-41.7c-17.4-2.9-33.9 8.9-36.8 26.3l-64 384c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3l64-384c2.9-17.4-8.9-33.9-26.3-36.8zM352 32c-17.7 0-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32z"],
    "passport": [384, 512, [], "f5ab", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 408c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zM278.6 208c-4.8 26.4-21.5 48.7-44.2 61.2 6.7-17 11.2-38 12.6-61.2l31.6 0zm-173.1 0l31.6 0c1.4 23.1 6 44.2 12.6 61.2-22.7-12.5-39.4-34.8-44.2-61.2zm76.4 55c-6.2-13.4-11.1-32.5-12.7-55l45.8 0c-1.6 22.5-6.5 41.6-12.7 55-4.5 9.6-8.2 13.8-10.2 15.5-2-1.7-5.7-5.8-10.2-15.5zm0-142c4.5-9.6 8.2-13.8 10.2-15.5 2 1.7 5.7 5.8 10.2 15.5 6.2 13.4 11.1 32.5 12.7 55l-45.8 0c1.6-22.5 6.5-41.6 12.7-55zm96.7 55L247 176c-1.4-23.1-6-44.2-12.6-61.2 22.7 12.5 39.4 34.8 44.2 61.2zM137 176l-31.6 0c4.8-26.4 21.5-48.7 44.2-61.2-6.7 17-11.2 38-12.6 61.2zm183 16a128 128 0 1 0 -256 0 128 128 0 1 0 256 0z"],
    "infinity": [640, 512, [8734, 9854], "f534", "M0 256c0-88.4 71.6-160 160-160 50.4 0 97.8 23.7 128 64l32 42.7 32-42.7c30.2-40.3 77.6-64 128-64 88.4 0 160 71.6 160 160S568.4 416 480 416c-50.4 0-97.8-23.7-128-64l-32-42.7-32 42.7c-30.2 40.3-77.6 64-128 64-88.4 0-160-71.6-160-160zm280 0l-43.2-57.6c-18.1-24.2-46.6-38.4-76.8-38.4-53 0-96 43-96 96s43 96 96 96c30.2 0 58.7-14.2 76.8-38.4L280 256zm80 0l43.2 57.6c18.1 24.2 46.6 38.4 76.8 38.4 53 0 96-43 96-96s-43-96-96-96c-30.2 0-58.7 14.2-76.8 38.4L360 256z"],
    "clone": [512, 512, [], "f24d", "M288 448l-224 0 0-224 48 0 0-64-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-64 0 0 48zm-64-96l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64z"],
    "forward": [576, 512, [9193], "f04e", "M371.7 43.1C360.1 32 343 28.9 328.3 35.2S304 56 304 72l0 136.3-172.3-165.1C120.1 32 103 28.9 88.3 35.2S64 56 64 72l0 368c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9L304 303.7 304 440c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9l192-184c7.9-7.5 12.3-18 12.3-28.9s-4.5-21.3-12.3-28.9l-192-184z"],
    "m": [448, 512, [109], "4d", "M22.7 33.4c13.5-4.1 28.1 1.1 35.9 12.9L224 294.3 389.4 46.3c7.8-11.7 22.4-17 35.9-12.9S448 49.9 448 64l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-278.3-133.4 200.1c-5.9 8.9-15.9 14.2-26.6 14.2s-20.7-5.3-26.6-14.2L64 169.7 64 448c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64C0 49.9 9.2 37.5 22.7 33.4z"],
    "road-spikes": [640, 512, [], "e568", "M64 116.8c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.8-26.6 49.8L64 352 64 116.8zM32 384l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "mountain": [512, 512, [127956], "f6fc", "M256.5 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5-7.2 12.1-20.3 19.5-34.3 19.5l-432 0c-14.1 0-27.1-7.4-34.3-19.5s-7.5-27.1-.8-39.5l216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0zM170.4 249.9l26.8 26.8c6.2 6.2 16.4 6.2 22.6 0l43.3-43.3c6-6 14.1-9.4 22.6-9.4l42.8 0-72.1-133.5-86.1 159.4z"],
    "chess": [512, 512, [], "f439", "M168 56l0 40-78.1 0c-14.3 0-25.9 11.6-25.9 25.9 0 4 .9 8 2.7 11.6l33.4 66.8c-11.4 1.8-20.2 11.7-20.2 23.7 0 13.3 10.7 24 24 24l5.6 0-13.6 136-56.2 70.3c-5 6.3-7.8 14.1-7.8 22.2 0 19.6 15.9 35.5 35.5 35.5l248.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2L288 384 274.4 248 280 248c13.3 0 24-10.7 24-24 0-11.9-8.7-21.9-20.2-23.7l33.4-66.8c1.8-3.6 2.7-7.6 2.7-11.6 0-14.3-11.6-25.9-25.9-25.9l-78.1 0 0-40 16 0c13.3 0 24-10.7 24-24S245.3 8 232 8l-16 0 0-16c0-13.3-10.7-24-24-24S168-21.3 168-8l0 16-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0zM325.8 279.6l8.5 85.5 47.4 59.2 4.2 5.7c9.2 13.7 14.1 29.9 14.1 46.5 0 12.7-2.8 24.8-7.9 35.5l83.1 0c20.3 0 36.8-16.5 36.8-36.8 0-7.3-2.2-14.4-6.2-20.4l-25.8-38.7 0-64 13.3-13.3c12-12 18.7-28.3 18.7-45.3L512 192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16-32 0 0-16c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32c0 22.4-10.2 42.4-26.2 55.6z"],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", "M160 0C107 0 64 43 64 96l0 164.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 96c0-53-43-96-96-96zm64 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3L136 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 156.7c23.5 9.5 40 32.5 40 59.3z"],
    "b": [320, 512, [98], "42", "M32 32C14.3 32 0 46.3 0 64L0 448c0 17.7 14.3 32 32 32l160 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zM160 224l-96 0 0-128 96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64zM64 288l128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0 0-128z"],
    "shield-virus": [512, 512, [], "e06c", "M253.4 2.9C249.2 1 244.7 0 240 0s-9.2 1-13.4 2.9L38.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L253.4 2.9zM240 128c13.3 0 24 10.7 24 24 0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24zM208 264a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "litecoin-sign": [384, 512, [], "e1d3", "M128 64c0-17.7-14.3-32-32-32S64 46.3 64 64l0 157.9-38.6 11c-12.7 3.6-20.1 16.9-16.5 29.7s16.9 20.1 29.7 16.5L64 271.8 64 448c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-224 0 0-162.5 134.6-38.5c12.7-3.6 20.1-16.9 16.5-29.7s-16.9-20.1-29.7-16.5L128 203.6 128 64z"],
    "dice-d6": [512, 512, [], "f6d1", "M224.4 8.3C244-2.8 268-2.8 287.6 8.3l176 99.7c20 11.4 32.4 32.6 32.4 55.7l0 197.4c0 23-12.4 44.3-32.4 55.7l-176 99.7c-19.6 11.1-43.6 11.1-63.1 0l-176-99.7C28.4 405.5 16 384.2 16 361.2l0-197.4c0-23 12.4-44.3 32.4-55.7l176-99.7zM102.6 155.6c-8.8-3.1-18.8 .3-23.8 8.6s-3.2 18.7 3.6 25l3.2 2.4 150.2 90.2 0 148.7c0 11 9 20 20 20 11 0 20-9 20-20l0-148.7 150.3-90.2c9.5-5.7 12.6-18 6.9-27.4s-18-12.5-27.4-6.9l-149.7 89.8-149.7-89.8-3.7-1.7z"],
    "grip-lines-vertical": [192, 512, [], "f7a5", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"],
    "golf-ball-tee": [384, 512, ["golf-ball"], "f450", "M298.5 384.1c12.1 1.2 21.5 11.5 21.5 23.9s-9.4 22.6-21.5 23.9l-2.5 .1-80 0 0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-80 0c-13.3 0-24-10.7-24-24 0-12.4 9.4-22.6 21.5-23.9l2.5-.1 208 0 2.5 .1zM192 0c106 0 192 86 192 192 0 57.4-25.2 108.8-65.1 144L65.1 336C25.2 300.8 0 249.4 0 192 0 86 86 0 192 0zm32 240c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16zm64-64c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16zm-80-16c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16z"],
    "hexagon": [576, 512, [11043], "f312", "M33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M56 225.6L32.4 296.2 32.4 96c0-35.3 28.7-64 64-64l138.7 0c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4l117.3 0c35.3 0 64 28.7 64 64l0 16-365.4 0c-41.3 0-78 26.4-91.1 65.6zM477.8 448L99 448c-32.8 0-55.9-32.1-45.5-63.2l48-144C108 221.2 126.4 208 147 208l378.8 0c32.8 0 55.9 32.1 45.5 63.2l-48 144c-6.5 19.6-24.9 32.8-45.5 32.8z"],
    "kaaba": [512, 512, [128331], "f66b", "M256 51.3L92.8 112.4 247.5 171.1c5.5 2.1 11.5 2.1 17 0L419.2 112.4 256 51.3zM0 129.3c0-20 12.4-37.9 31.1-44.9l208-78c10.9-4.1 22.8-4.1 33.7 0l208 78c18.7 7 31.1 24.9 31.1 44.9l0 36-253.2 96c-1.8 .7-3.8 .7-5.7 0l-253.2-96 0-36zm0 140l0-52.7 236.1 89.6c12.8 4.9 26.9 4.9 39.7 0l236.1-89.6 0 52.7-128 48.6 0 51.3 128-48.6 0 62.2c0 20-12.4 37.9-31.1 44.9l-208 78c-10.9 4.1-22.8 4.1-33.7 0l-208-78C12.4 420.7 0 402.7 0 382.7l0-62.2 128 48.6 0-51.3-128-48.6zM236.1 410.1c12.8 4.9 26.9 4.9 39.7 0l60.1-22.8 0-51.3-77.2 29.3c-1.8 .7-3.8 .7-5.7 0l-77.2-29.3 0 51.3 60.1 22.8z"],
    "hand-holding": [576, 512, [], "f4bd", "M66.7 384l42.5-42.5c24-24 56.6-37.5 90.5-37.5L352 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5s9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l34.7 0z"],
    "single-quote-right": [192, 512, [], "e81c", "M64 416c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0c30.9 0 56-25.1 56-56l0-8-64 0c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 136c0 66.3-53.7 120-120 120l-8 0z"],
    "bottle-droplet": [320, 512, [], "e4c4", "M80 0c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 103.3c64.9 20.4 112 81 112 152.7l0 192c0 35.3-28.7 64-64 64L64 544c-35.3 0-64-28.7-64-64L0 288c0-71.6 47.1-132.3 112-152.7L112 32C94.3 32 80 17.7 80 0zm80 416c35.3 0 64-32.4 64-64 0-21.2-28.9-64.5-47.9-90.6-8.1-11.1-24.2-11.1-32.3 0-19 26.1-47.9 69.4-47.9 90.6 0 31.6 28.7 64 64 64z"],
    "window-minimize": [512, 512, [128469], "f2d1", "M0 416c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32z"],
    "chevron-right": [320, 512, [9002], "f054", "M311.1 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L243.2 256 73.9 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z"],
    "egg": [384, 512, [129370], "f7fb", "M192 496C86 496 0 394 0 288 0 176 64 16 192 16S384 176 384 288c0 106-86 208-192 208zM154.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2-11.2 31.6-16.9 65.1-16.9 93.5 0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8 10.1-28.5 25-54.1 43.7-71.2z"],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", "M256 0c-17.7 0-32 14.3-32 32 0 .9 0 1.8 .1 2.6-80.5 13.4-144 76.9-157.5 157.4L64 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 160-51.2 38.4C4.7 460.4 0 469.9 0 480 0 497.7 14.3 512 32 512l448 0c17.7 0 32-14.3 32-32 0-10.1-4.7-19.6-12.8-25.6L448 416 448 256c17.7 0 32-14.3 32-32s-14.3-32-32-32l-2.7 0c-13.5-80.4-77-143.9-157.5-157.4 .1-.9 .1-1.7 .1-2.6 0-17.7-14.3-32-32-32zm80 256l64 0 0 160-64 0 0-160zM224 416l0-160 64 0 0 160-64 0zM112 256l64 0 0 160-64 0 0-160z"],
    "worm": [448, 512, [], "e599", "M224 96c0-53 43-96 96-96l38.4 0C407.9 0 448 40.1 448 89.6L448 376c0 75.1-60.9 136-136 136S176 451.1 176 376l0-80c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 168c0 26.5-21.5 48-48 48S0 490.5 0 464L0 296c0-75.1 60.9-136 136-136s136 60.9 136 136l0 80c0 22.1 17.9 40 40 40s40-17.9 40-40l0-184-32 0c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "user-injured": [448, 512, [], "f728", "M242.7 80L334 80c-10.7-24.6-29.5-44.9-52.9-57.6L242.7 80zm-.9-70.7C236 8.4 230 8 224 8 174.8 8 132.5 37.6 114 80l80.6 0 47.1-70.7zM224 248c66.3 0 120-53.7 120-120l-240 0c0 66.3 53.7 120 120 120zM98.7 341.8C49.3 370.2 16 423.5 16 484.6 16 499.7 28.3 512 43.4 512l151 0-95.8-170.2zm45.1-17.7l42.7 75.9 85.5 0c44.2 0 80 35.8 80 80 0 11.4-2.4 22.2-6.7 32l59.2 0c15.1 0 27.4-12.3 27.4-27.4 0-90.9-73.7-164.6-164.6-164.6l-86.9 0c-12.6 0-24.9 1.4-36.7 4.1zM213.5 448l36 64 22.5 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-58.5 0z"],
    "strikethrough": [512, 512, [], "f0cc", "M96 157.5C96 88.2 152.2 32 221.5 32L368 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L221.5 96c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61l44.1 5.5 222 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l83.1 0C103 204.6 96 181.8 96 157.5zM349.2 336l65.5 0c.9 6.1 1.4 12.2 1.4 18.5 0 69.3-56.2 125.5-125.5 125.5L144 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l146.5 0c34 0 61.5-27.5 61.5-61.5 0-6.4-1-12.7-2.8-18.5z"],
    "blog": [512, 512, [], "f781", "M224 24c0-13.3 10.7-24 24-24 145.8 0 264 118.2 264 264 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-119.3-96.7-216-216-216-13.3 0-24-10.7-24-24zM80 96c26.5 0 48 21.5 48 48l0 224c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16 79.5 0 144 64.5 144 144S255.5 512 176 512 32 447.5 32 368l0-224c0-26.5 21.5-48 48-48zm168 0c92.8 0 168 75.2 168 168 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3-53.7-120-120-120-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "stopwatch-20": [448, 512, [], "e06f", "M168.5 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 25.3c-108 11.9-192 103.5-192 214.7 0 119.3 96.7 216 216 216s216-96.7 216-216c0-39.8-10.8-77.1-29.6-109.2l28.2-28.2c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-23.4 23.4c-32.9-30.2-75.2-50.3-122-55.5l0-25.3 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0zm-60 240c0-28.7 23.3-52 52-52s52 23.3 52 52l0 3.8c0 11.7-3.2 23.1-9.3 33l-43.8 71.2 33.1 0c11 0 20 9 20 20s-9 20-20 20l-57.8 0c-14.5 0-26.2-11.7-26.2-26.2 0-4.9 1.3-9.6 3.9-13.8l56.7-92.1c2.2-3.6 3.4-7.8 3.4-12.1l0-3.8c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm180-52c28.7 0 52 23.3 52 52l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-28.7 23.3-52 52-52zm-12 52l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-6.6-5.4-12-12-12s-12 5.4-12 12z"],
    "truck-pickup": [640, 512, [128763], "f63c", "M363.8 96l57.6 96-133.4 0 0-96 75.8 0zM496 192L418.6 63.1C407.1 43.8 386.2 32 363.8 32L256 32c-17.7 0-32 14.3-32 32l0 128-144 0c-26.5 0-48 21.5-48 48l0 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l32.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l160.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l32.4 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-80c0-26.5-21.5-48-48-48l-64 0zM112 392a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm376-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", "M512 32C512 140.1 435.4 230.3 333.6 251.4 325.7 193.3 299.6 141 261.1 100.5 301.2 40 369.9 0 448 0l32 0c17.7 0 32 14.3 32 32zM0 96C0 78.3 14.3 64 32 64l32 0c123.7 0 224 100.3 224 224l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160C100.3 320 0 219.7 0 96z"],
    "transgender": [576, 512, [9895, "transgender-alt"], "f225", "M128-32c17.7 0 32 14.3 32 32s-14.3 32-32 32L97.9 32 136 70.1 151 55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-15 15 14.2 14.2c27.9-23.8 64.2-38.2 103.8-38.2 36.7 0 70.6 12.4 97.6 33.2L466.7 32 448 32c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7-84.4 84.4c13 23.1 20.4 49.9 20.4 78.3 0 77.4-55 142-128 156.8l0 35.2 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-35.2c-73-14.8-128-79.4-128-156.8 0-31.4 9-60.7 24.7-85.4l-16.7-16.7-15 15c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l15-15-38.1-38.1 0 30.1c0 17.7-14.3 32-32 32S0 113.7 0 96L0 0C0-17.7 14.3-32 32-32l96 0zM288 336a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "star-half": [576, 512, [61731], "f089", "M304.1 7.6c0-11.1-7.6-20.7-18.4-23.3s-21.9 2.5-27 12.4L193.1 125.3 33.2 150.7c-8.9 1.4-16.3 7.7-19.1 16.3s-.5 18 5.8 24.4l114.4 114.5-25.2 159.9c-1.4 8.9 2.3 17.9 9.6 23.2s16.9 6.1 25 2L291 416.1c8-4.1 13.1-12.4 13.1-21.4l0-387.1z"],
    "photo-film": [640, 512, ["photo-video"], "f87c", "M192 64c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-320 0c-35.3 0-64-28.7-64-64l0-224zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm156.5 11.5C472.1 100.4 464.4 96 456 96s-16.1 4.4-20.5 11.5l-54 88.3-17.9-25.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S279.1 288 288 288l256 0c8.7 0 16.7-4.7 20.9-12.3s4.1-16.8-.5-24.3l-88-144zM144 128l0 160c0 61.9 50.1 112 112 112l192 0 0 16c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l80 0zM52 196l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm0 96c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0z"],
    "pump-medical": [320, 512, [], "e06a", "M96 0l0 80 128 0 0-24 72 0c13.3 0 24-10.7 24-24S309.3 8 296 8l-72 0 0-8c0-17.7-14.3-32-32-32l-64 0C110.3-32 96-17.7 96 0zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 128zm64 120c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40z"],
    "fire": [448, 512, [128293], "f06d", "M160.5-26.4c9.3-7.8 23-7.5 31.9 .9 12.3 11.6 23.3 24.4 33.9 37.4 13.5 16.5 29.7 38.3 45.3 64.2 5.2-6.8 10-12.8 14.2-17.9 1.1-1.3 2.2-2.7 3.3-4.1 7.9-9.8 17.7-22.1 30.8-22.1 13.4 0 22.8 11.9 30.8 22.1 1.3 1.7 2.6 3.3 3.9 4.8 10.3 12.4 24 30.3 37.7 52.4 27.2 43.9 55.6 106.4 55.6 176.6 0 123.7-100.3 224-224 224S0 411.7 0 288c0-91.1 41.1-170 80.5-225 19.9-27.7 39.7-49.9 54.6-65.1 8.2-8.4 16.5-16.7 25.5-24.2zM225.7 416c25.3 0 47.7-7 68.8-21 42.1-29.4 53.4-88.2 28.1-134.4-4.5-9-16-9.6-22.5-2l-25.2 29.3c-6.6 7.6-18.5 7.4-24.7-.5-17.3-22.1-49.1-62.4-65.3-83-5.4-6.9-15.2-8-21.5-1.9-18.3 17.8-51.5 56.8-51.5 104.3 0 68.6 50.6 109.2 113.7 109.2z"],
    "magnifying-glass-plus": [512, 512, ["search-plus"], "f00e", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 112c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "flask": [448, 512, [], "f0c3", "M288 0L128 0C110.3 0 96 14.3 96 32s14.3 32 32 32L128 215.5 7.5 426.3C2.6 435 0 444.7 0 454.7 0 486.4 25.6 512 57.3 512l333.4 0c31.6 0 57.3-25.6 57.3-57.3 0-10-2.6-19.8-7.5-28.4L320 215.5 320 64c17.7 0 32-14.3 32-32S337.7 0 320 0L288 0zM192 215.5l0-151.5 64 0 0 151.5c0 11.1 2.9 22.1 8.4 31.8l41.6 72.7-164 0 41.6-72.7c5.5-9.7 8.4-20.6 8.4-31.8z"],
    "align-right": [448, 512, [], "f038", "M448 64c0 17.7-14.3 32-32 32L192 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zm0 256c0 17.7-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zM0 192c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 224c-17.7 0-32-14.3-32-32zM448 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "cable-car": [512, 512, [128673, 57551, "tram"], "f7da", "M288-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 24a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 288c0-35.3 28.7-64 64-64l136 0 0-96.2-193.4 55.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l224-64 0 0 224-64c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-206.6 59 0 109.9 136 0c35.3 0 64 28.7 64 64l0 160c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-160zm80 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l56 0 0-96-56 0zm184 96l0-96-80 0 0 96 80 0zm48 0l56 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-56 0 0 96z"],
    "kit-medical": [512, 512, ["first-aid"], "f479", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l16 0 0-384-16 0zm64 0l0 384 256 0 0-384-256 0zM448 448c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-16 0 0 384 16 0zM224 184c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40z"],
    "grip-lines": [448, 512, [], "f7a4", "M32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 288zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160z"],
    "burger": [512, 512, ["hamburger"], "f805", "M48 384c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80l288 0c44.2 0 80-35.8 80-80 0-8.8-7.2-16-16-16L48 384zM32 202c0 12.2 9.9 22 22 22L458 224c12.2 0 22-9.9 22-22 0-17.2-2.6-34.4-10.8-49.5-22.2-40.8-82.3-120.5-213.2-120.5S65 111.6 42.8 152.5C34.6 167.6 32 184.8 32 202zM0 304c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 272c-17.7 0-32 14.3-32 32zM256 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 128a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm248-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "snowman": [640, 512, [9731, 9924], "f7d0", "M403 211.7c32.2-24.9 53-63.9 53-107.7 0-75.1-60.9-136-136-136S184 28.9 184 104c0 43.9 20.8 82.9 53 107.7-32.2 16.3-59 41.8-76.8 73.1L112 264.2 112 224c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 19.6-22.5-9.7c-12.2-5.2-26.3 .4-31.5 12.6s.4 26.3 12.6 31.5c36.1 15.5 75.9 32.5 119.4 51.2-3.9 14.9-6 30.6-6 46.7 0 70 39.1 130.8 96.6 161.9 7.9 4.3 16.9 6.1 25.9 6.1l123 0c9 0 18-1.8 25.9-6.1 57.5-31.1 96.6-92 96.6-161.9 0-16.2-2.1-31.8-6-46.7 43.5-18.7 83.4-35.7 119.4-51.2 12.2-5.2 17.8-19.3 12.6-31.5s-19.3-17.8-31.5-12.6l-22.5 9.7 0-19.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40.2-48.2 20.6c-17.9-31.3-44.6-56.8-76.8-73.1zM296 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24-120a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM292.2 159.3c-2.7-4.8-4.2-10.2-4.2-15.7 0-17.5 14.2-31.6 31.6-31.6l.8 0c17.5 0 31.6 14.2 31.6 31.6 0 5.5-1.4 10.9-4.2 15.7L327 195.8c-3.1 5.4-10.8 5.4-13.9 0l-20.9-36.6z"],
    "hotel": [512, 512, [127976], "f594", "M16 24C16 10.7 26.7 0 40 0L472 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 416 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-416-8 0C26.7 48 16 37.3 16 24zm208 88l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM128 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm96 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM352 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM112 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm240-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM288 384l43.8 0c9.9 0 17.5-9 14-18.2-13.8-36.1-48.8-61.8-89.7-61.8s-75.9 25.7-89.7 61.8c-3.5 9.2 4.1 18.2 14 18.2l43.8 0 0 80 64 0 0-80z"],
    "print": [512, 512, [128424, 128438, 9113], "f02f", "M64 64C64 28.7 92.7 0 128 0L341.5 0c17 0 33.3 6.7 45.3 18.7l42.5 42.5c12 12 18.7 28.3 18.7 45.3l0 37.5-384 0 0-80zM0 256c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 96c0 17.7-14.3 32-32 32l-32 0 0 64c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-64-32 0c-17.7 0-32-14.3-32-32l0-96zM128 416l0 32 256 0 0-96-256 0 0 64zM456 272a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", "M512 258.9c-23.4 8-47.8 13.1-72.6 15.1 5.9-98.6-30.7-191.1-94.9-258.3 97.8 36 167.5 130 167.5 240.3 0 1 0 1.9 0 2.9zm-5.9 52c-5.2 23.7-13.6 46.2-24.9 66.9-94.7 52.2-214 50-308.4-13.6 21.7-31.3 49.8-58.9 83.8-80.5 79.5 41.6 168.5 49.1 249.5 27.1zM279.7 241.6c-3.7-89.7-41.7-170.5-101.3-229.7 22.3-7.1 46-11.2 70.5-11.9 92.5 55.9 150.3 160.3 142.4 273.8-38-3.2-75.9-13.7-111.6-32.3zM130.5 32.8C149.1 49.1 165.8 67.7 179.9 88.2 91.5 132.3 29.7 210.3 3.7 299.5 1.3 285.3 0 270.8 0 256 0 160.2 52.6 76.7 130.5 32.8zm73.4 97c16.3 34.5 26.1 72.6 27.9 112.8-75.8 48-126.8 121.3-148.3 202.5-17.6-16.1-33-34.6-45.5-55 2.1-108.1 63.7-210.4 165.9-260.3zM256 512c-47.7 0-92.3-13-130.5-35.7 4.8-24.3 12.6-48 23.2-70.4 82.4 54.4 180.8 68.9 271 47-44.4 37-101.5 59.2-163.7 59.2z"],
    "traffic-light": [320, 512, [128678], "f637", "M64-32C28.7-32 0-3.3 0 32L0 384c0 88.4 71.6 160 160 160s160-71.6 160-160l0-352c0-35.3-28.7-64-64-64L64-32zm96 392c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"],
    "plane-circle-check": [640, 512, [], "e555", "M232 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 78 71.5c-69.3 29-118 97.4-118 177.2 0 49.3 18.6 94.3 49.1 128.3L288 512 179.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C58.7 396.4 48 388.7 48 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L232 151.3 232 24zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "users": [640, 512, [], "f0c0", "M320 16a104 104 0 1 1 0 208 104 104 0 1 1 0-208zM96 88a72 72 0 1 1 0 144 72 72 0 1 1 0-144zM0 416c0-70.7 57.3-128 128-128 12.8 0 25.2 1.9 36.9 5.4-32.9 36.8-52.9 85.4-52.9 138.6l0 16c0 11.4 2.4 22.2 6.7 32L32 480c-17.7 0-32-14.3-32-32l0-32zm521.3 64c4.3-9.8 6.7-20.6 6.7-32l0-16c0-53.2-20-101.8-52.9-138.6 11.7-3.5 24.1-5.4 36.9-5.4 70.7 0 128 57.3 128 128l0 32c0 17.7-14.3 32-32 32l-86.7 0zM472 160a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM160 432c0-88.4 71.6-160 160-160s160 71.6 160 160l0 16c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-16z"],
    "certificate": [576, 512, [], "f0a3", "M239.2-8c-6.1-6.2-15-8.7-23.4-6.4S200.9-5.6 198.8 2.8L183.5 63c-1.1 4.4-5.6 7-9.9 5.7L113.8 51.9c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l16.9 59.8c1.2 4.3-1.4 8.8-5.7 9.9L35.1 166.5c-8.4 2.1-15 8.7-17.3 17.1s.2 17.3 6.4 23.4l44.5 43.3c3.2 3.1 3.2 8.3 0 11.5L24.3 305.1c-6.2 6.1-8.7 15-6.4 23.4s8.9 14.9 17.3 17.1l60.2 15.3c4.4 1.1 7 5.6 5.7 9.9L84.2 430.5c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l59.8-16.9c4.3-1.2 8.8 1.4 9.9 5.7l15.3 60.2c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l43.3-44.5c3.1-3.2 8.3-3.2 11.5 0L337.3 520c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3L393.1 449c1.1-4.4 5.6-7 9.9-5.7l59.8 16.9c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-16.9-59.8c-1.2-4.3 1.4-8.8 5.7-9.9l60.2-15.3c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4l-44.5-43.3c-3.2-3.1-3.2-8.3 0-11.5l44.5-43.3c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-60.2-15.3c-4.4-1.1-7-5.6-5.7-9.9l16.9-59.8c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1L403 68.8c-4.3 1.2-8.8-1.4-9.9-5.7L377.8 2.8c-2.1-8.4-8.7-15-17.1-17.3s-17.3 .2-23.4 6.4L294 36.5c-3.1 3.2-8.3 3.2-11.5 0L239.2-8z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M504.4 132.5c-4.5 10.5-18.4 9.8-24.9 .4-27.8-40-66.1-72.2-111-92.6-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7 52.6 0 95.2 42.6 95.2 95.2 0 13.2-2.7 25.8-7.6 37.3zm-471.9 .4c-6.5 9.4-20.5 10.1-24.9-.4-4.9-11.5-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2 19.3 0 37.3 5.8 52.3 15.7 9.6 6.3 6.3 19.9-4.1 24.6-44.8 20.4-83.1 52.6-111 92.6zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.2-35.2C48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-35.2-35.2zM280 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 6.4 2.5 12.5 7 17l56 56c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-49-49 0-94.1z"],
    "helicopter-symbol": [512, 512, [], "e502", "M445.4 224l64.7 0C495.6 108.2 403.8 16.4 288 2l0 64.7C368.4 80.1 431.9 143.6 445.4 224zM510 288l-64.7 0C431.9 368.4 368.4 431.9 288 445.3l0 64.7c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510l0-64.7C143.6 431.9 80.2 368.4 66.7 288L2 288zm0-64l64.7 0C80.2 143.6 143.6 80.1 224 66.7L224 2C108.2 16.4 16.4 108.2 2 224zm206-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 96 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-96 0 0-64z"],
    "house-chimney-crack": [512, 512, ["house-damage"], "f6f1", "M234.2 8.6c12.3-11.4 31.3-11.4 43.5 0L368 92.3 368 80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 101.5 37.8 35.1c9.6 9 12.8 22.9 8 35.1S493.2 272 480 272l-16 0 0 176c0 35.3-28.7 64-64 64l-105.6 0-38.4-64 80.8-67.3c7.8-6.5 7.6-18.6-.4-24.9L218.6 263.2c-14.6-11.5-33.8 7-22.8 22L256 368 170.5 439.2c-6.1 5-7.5 13.8-3.5 20.5l31.3 52.2-86.4 0c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208z"],
    "person-military-pointing": [512, 512, [], "e54a", "M214.9 14.1C202 15.2 192 26 192 39 192 52.8 203.2 64 217 64l151 0c8.8 0 16-7.2 16-16l0-30.6C384 8 376 .7 366.7 1.4L214.9 14.1zM208 112c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16L209.6 96c-1 5.2-1.6 10.5-1.6 16zM40 224c-22.1 0-40 17.9-40 40s17.9 40 40 40l152 0 0 89.4 162.8-162.8c-13.3-4.3-27.3-6.5-41.6-6.5L40 224zm345.7 20.9l-171.1 171.1 169.4 0 0-46.3 53.6 90.6c11.2 19 35.8 25.3 54.8 14.1s25.3-35.8 14.1-54.8L430.3 290.8c-11.2-19-26.6-34.5-44.6-45.9zM192 448l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32-192 0z"],
    "database": [448, 512, [], "f1c0", "M448 205.8c-14.8 9.8-31.8 17.7-49.5 24-47 16.8-108.7 26.2-174.5 26.2S96.4 246.5 49.5 229.8c-17.6-6.3-34.7-14.2-49.5-24L0 288c0 44.2 100.3 80 224 80s224-35.8 224-80l0-82.2zm0-77.8l0-48C448 35.8 347.7 0 224 0S0 35.8 0 80l0 48c0 44.2 100.3 80 224 80s224-35.8 224-80zM398.5 389.8C351.6 406.5 289.9 416 224 416S96.4 406.5 49.5 389.8c-17.6-6.3-34.7-14.2-49.5-24L0 432c0 44.2 100.3 80 224 80s224-35.8 224-80l0-66.2c-14.8 9.8-31.8 17.7-49.5 24z"],
    "newspaper": [512, 512, [128240], "f1ea", "M0 416L0 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 288c0 13.3 10.7 24 24 24s24-10.7 24-24L96 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64zM160 128l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm24 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-240 0zm-24-72c0 13.3 10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-240 0c-13.3 0-24 10.7-24 24zM360 176c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M96 320c-53 0-96-43-96-96 0-42.5 27.6-78.6 65.9-91.2-1.3-6.7-1.9-13.7-1.9-20.8 0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80 0 5.5-.6 10.8-1.6 16 .5 0 1.1 0 1.6 0 53 0 96 43 96 96s-43 96-96 96L96 320zm1.6 68.2c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16l30.2-68.2zm152 0c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16l30.2-68.2zm121.8 68.2l30.2-68.2c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16z"],
    "maximize": [448, 512, ["expand-arrows-alt"], "f31e", "M168 32L24 32C10.7 32 0 42.7 0 56L0 200c0 9.7 5.8 18.5 14.8 22.2S34.1 223.8 41 217l40-40 79 79-79 79-40-40c-6.9-6.9-17.2-8.9-26.2-5.2S0 302.3 0 312L0 456c0 13.3 10.7 24 24 24l144 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-40-40 79-79 79 79-40 40c-6.9 6.9-8.9 17.2-5.2 26.2S270.3 480 280 480l144 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-40 40-79-79 79-79 40 40c6.9 6.9 17.2 8.9 26.2 5.2S448 209.7 448 200l0-144c0-13.3-10.7-24-24-24L280 32c-9.7 0-18.5 5.8-22.2 14.8S256.2 66.1 263 73l40 40-79 79-79-79 40-40c6.9-6.9 8.9-17.2 5.2-26.2S177.7 32 168 32z"],
    "location-arrow": [512, 512, [], "f124", "M477.9 75.5c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2l-416 160C7.9 199-.3 211.2 0 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l160-416z"],
    "city": [576, 512, [127961], "f64f", "M320 0c-35.3 0-64 28.7-64 64l0 32-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-64 0 0-72C96 10.7 85.3 0 72 0S48 10.7 48 24l0 74c-27.6 7.1-48 32.2-48 62L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-64 0 0-128c0-35.3-28.7-64-64-64L320 0zm64 112l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm-16 80c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zm16 112l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm112-16c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM256 304l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM240 192c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM128 304l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM112 192c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0z"],
    "x-ray": [512, 512, [], "f497", "M0 64C0 46.3 14.3 32 32 32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 320c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 96C14.3 96 0 81.7 0 64zm280 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 48-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0 0 48-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-48 80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-48 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-16z"],
    "umbrella-beach": [512, 512, [127958], "f5ca", "M497.5 341.1c-5.9 16.7-25.3 23-41.1 15.1l-178.2-89.1-1.6 3.2-88.8 177.7 292.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l84.2 0 103.2-206.3 1.6-3.2-165.4-82.7c-15.8-7.9-22.4-27.3-12.5-42 45.9-68.6 124.1-113.8 212.9-113.8 141.4 0 256 114.6 256 256 0 29.8-5.1 58.5-14.5 85.1z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 96l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm-9.4 182.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"],
    "headset": [448, 512, [], "f590", "M224 64c-79 0-144.7 57.3-157.7 132.7 9.3-3 19.3-4.7 29.7-4.7l16 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-16 0c-53 0-96-43-96-96l0-64C0 100.3 100.3 0 224 0S448 100.3 448 224l0 168.1c0 66.3-53.8 120-120.1 120l-87.9-.1-32 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 0 40 0c39.8 0 72-32.2 72-72l0-20.9c-14.1 8.2-30.5 12.8-48 12.8l-16 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l16 0c10.4 0 20.3 1.6 29.7 4.7-13-75.3-78.6-132.7-157.7-132.7z"],
    "splotch": [512, 512, [], "f5bc", "M208.5 62.3l28.1-36.9C248.8 9.4 267.8 0 288 0 316.5 0 341.6 18.7 349.8 46l17.8 59.4c10.3 34.4 36.1 62 69.8 74.6l39.8 14.9c20.9 7.9 34.8 27.9 34.8 50.2 0 16.9-7.9 32.8-21.5 42.9l-67.3 50.5c-24.3 18.2-37.2 47.9-33.8 78.1l2.5 22.7c4.3 38.7-26 72.6-65 72.6-14.8 0-29.3-5.1-40.9-14.3l-55.3-44.3c-4.5-3.6-9.3-6.7-14.5-9.2-15.8-7.9-33.7-10.4-51-7.3L82.4 451.9c-34.6 6.3-66.4-20.3-66.4-55.4 0-13.2 4.7-26 13.1-36.2l11.2-13.4c14.6-17.4 22.6-39.4 22.6-62.1 0-18.8-5.5-37.2-15.8-53L8.8 173.5C3.1 164.7 0 154.4 0 143.9 0 110.5 30.1 85.1 63 90.7l51.3 8.7c35.9 6.1 72.2-8.2 94.2-37.1z"],
    "up-long": [320, 512, ["long-arrow-alt-up"], "f30c", "M137.4-22.6c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9S300.9 160 288 160l-64 0 0 336c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-336-64 0c-12.9 0-24.6-7.8-29.6-19.8S.2 114.5 9.4 105.4l128-128z"],
    "hexagon-nodes": [448, 512, [], "e699", "M248 106.6c18.9-9 32-28.3 32-50.6c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 98.8c-2.8 1.3-5.5 2.9-8 4.7l-80.1-45.8c1.6-20.8-8.6-41.6-27.9-52.8C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c1.3 .8 2.6 1.5 4 2.1l0 90.8c-1.3 .6-2.7 1.3-4 2.1C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c19.3-11.1 29.4-32 27.8-52.8l50.5-28.9c-11.5-11.2-19.9-25.6-23.8-41.7L88 306.1c-2.6-1.8-5.2-3.3-8-4.7l0-90.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-.1 1.4-.2 2.8-.2 4.3c0 22.3 13.1 41.6 32 50.6l0 98.8c-18.9 9-32 28.3-32 50.6c0 30.9 25.1 56 56 56s56-25.1 56-56c0-22.3-13.1-41.6-32-50.6l0-98.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-1.6 20.8 8.6 41.6 27.8 52.8c26.8 15.5 61 6.3 76.5-20.5s6.3-61-20.5-76.5c-1.3-.8-2.7-1.5-4-2.1l0-90.8c1.4-.6 2.7-1.3 4-2.1c26.8-15.5 36-49.7 20.5-76.5S390.8 96 364 111.5c-19.3 11.1-29.4 32-27.8 52.8l-50.6 28.9c11.5 11.2 19.9 25.6 23.8 41.7L360 205.9c2.6 1.8 5.2 3.3 8 4.7l0 90.8c-2.8 1.3-5.5 2.9-8 4.6l-80.1-45.8c.1-1.4 .2-2.8 .2-4.3c0-22.3-13.1-41.6-32-50.6l0-98.8z"],
    "hospital": [576, 512, [127973, 62589, "hospital-alt", "hospital-wide"], "f0f8", "M128 64c0-35.3 28.7-64 64-64L384 0c35.3 0 64 28.7 64 64l0 64 64 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l64 0 0-64zM272 352c-17.7 0-32 14.3-32 32l0 80 96 0 0-80c0-17.7-14.3-32-32-32l-32 0zM128 368l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM112 256c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM512 368l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 256c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM264 104l0 32-32 0c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z"],
    "person-harassing": [576, 512, [], "e549", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM59.4 304.5L88 256.9 88 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-244.7 47.4 57.1c11.3 13.6 31.5 15.5 45.1 4.2s15.5-31.5 4.2-45.1l-73.7-88.9c-18.2-22-45.3-34.7-73.9-34.7l-35.9 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9zM480 240a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM464 344l0 58.7-41.4-41.4c-7.3-7.3-17.6-10.6-27.8-9s-18.9 8.1-23.5 17.3l-48 96c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l28.1-56.3 54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3 36.4 0 65.9-29.5 65.9-65.9L576 344c0-30.9-25.1-56-56-56s-56 25.1-56 56zM288 48c0 8.8 7.2 16 16 16l56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0c-8.8 0-16 7.2-16 16zm-.8 49.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l48 24c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-48-24z"],
    "money-bill-trend-up": [512, 512, [], "e529", "M480 8c0-13.3-10.7-24-24-24L354.2-16c-13.3 0-24 10.7-24 24s10.7 24 24 24l43.9 0-111.3 111.3-95.1-81.5c-9-7.7-22.2-7.7-31.2 0l-112 96c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l96.4-82.6 96.4 82.6c9.5 8.2 23.7 7.6 32.6-1.3l127-127 0 43.9c0 13.3 10.7 24 24 24s24-10.7 24-24L480 8zM48 256c-26.5 0-48 21.5-48 48L0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 256zm47.3 56c-3.4 20.1-19.2 36-39.4 39.4-4.4 .7-8-2.9-8-7.3l0-32c0-4.4 3.6-8 8-8l32 0c4.4 0 8.1 3.6 7.3 8zm0 144.1c.7 4.4-2.9 8-7.3 8l-32 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8.1 8-7.3 20.1 3.4 36 19.2 39.4 39.4zM456 416.7c4.4-.7 8 2.9 8 7.3l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8.1-3.6-7.3-8 3.4-20.1 19.2-36 39.4-39.4zM416.7 312c-.7-4.4 2.9-8 7.3-8l32 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8.1-8 7.3-20.1-3.4-36-19.2-39.4-39.4zM192 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "pen-ruler": [512, 512, ["pencil-ruler"], "f5ae", "M404 0c19.2 0 37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1L445.9 204 308 66.1 352.9 21.2C366.4 7.6 384.8 0 404 0zM58.9 315.1L274.1 100 412 237.9 196.9 453.1c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7zM225.4 80.8L80.8 225.4 11.7 156.3c-15.6-15.6-15.6-40.9 0-56.6l88-88c15.6-15.6 40.9-15.6 56.6 0l5.9 5.9-56.3 56.3c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l56.3-56.3 34.9 34.9zM431.2 286.6l34.9 34.9-56.3 56.3c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l56.3-56.3 5.9 5.9c15.6 15.6 15.6 40.9 0 56.6l-88 88c-15.6 15.6-40.9 15.6-56.6 0l-69.1-69.1 144.6-144.6z"],
    "repeat": [512, 512, [128257], "f363", "M470.6 118.6c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9S352 19.1 352 32l0 32-160 0C86 64 0 150 0 256 0 273.7 14.3 288 32 288s32-14.3 32-32c0-70.7 57.3-128 128-128l160 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64zM41.4 393.4c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9S160 492.9 160 480l0-32 160 0c106 0 192-86 192-192 0-17.7-14.3-32-32-32s-32 14.3-32 32c0 70.7-57.3 128-128 128l-160 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64z"],
    "bone": [640, 512, [129460], "f5d7", "M197.4 160c-3.9 0-7.2-2.8-8.1-6.6-10.2-42.1-48.1-73.4-93.3-73.4-53 0-96 43-96 96 0 29.1 12.9 55.1 33.3 72.7 4.3 3.7 4.3 10.8 0 14.5-20.4 17.6-33.3 43.7-33.3 72.7 0 53 43 96 96 96 45.2 0 83.1-31.3 93.3-73.4 .9-3.8 4.2-6.6 8.1-6.6l245.1 0c3.9 0 7.2 2.8 8.1 6.6 10.2 42.1 48.1 73.4 93.3 73.4 53 0 96-43 96-96 0-29.1-12.9-55.1-33.3-72.7-4.3-3.7-4.3-10.8 0-14.5 20.4-17.6 33.3-43.7 33.3-72.7 0-53-43-96-96-96-45.2 0-83.1 31.3-93.3 73.4-.9 3.8-4.2 6.6-8.1 6.6l-245.1 0z"],
    "fire-flame-curved": [384, 512, ["fire-alt"], "f7e4", "M153.6 29.9l16-21.3C173.6 3.2 180 0 186.7 0 198.4 0 208 9.6 208 21.3l0 22.1c0 13.1 5.4 25.7 14.9 34.7L307.6 159C356.4 205.6 384 270.2 384 337.7 384 434 306 512 209.7 512L192 512C86 512 0 426 0 320l0-3.8c0-48.8 19.4-95.6 53.9-130.1l3.5-3.5c4.2-4.2 10-6.6 16-6.6 12.5 0 22.6 10.1 22.6 22.6L96 288c0 35.3 28.7 64 64 64s64-28.7 64-64l0-3.9c0-18-7.2-35.3-19.9-48l-38.6-38.6c-24-24-37.5-56.7-37.5-90.7 0-27.7 9-54.8 25.6-76.9z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M96 0C43 0 0 43 0 96L0 384c0 29.8 20.4 54.9 48 62l0 34c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 192 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-34c27.6-7.1 48-32.2 48-62l0-288c0-53-43-96-96-96L96 0zM64 128c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32l0-96zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "venus-mars": [640, 512, [9892], "f228", "M480-64c-17.7 0-32 14.3-32 32S462.3 0 480 0L530.7 0 474 56.7c-26.3-15.7-57.1-24.7-90-24.7-35.4 0-68.4 10.5-96 28.5-27.6-18-60.6-28.5-96-28.5-97.2 0-176 78.8-176 176 0 86.3 62.1 158.1 144 173.1l0 34.9-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-34.9c23.3-4.3 44.9-13.1 64-25.6 27.6 18 60.6 28.5 96 28.5 97.2 0 176-78.8 176-176 0-41.1-14.1-79-37.8-109L576 45.3 576 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L480-64zM336 309.2c20.2-28.6 32-63.5 32-101.2s-11.8-72.6-32-101.2c14.6-6.9 30.8-10.8 48-10.8 61.9 0 112 50.1 112 112S445.9 320 384 320c-17.2 0-33.5-3.9-48-10.8zM288 150.3c10.2 16.9 16 36.6 16 57.7s-5.8 40.9-16 57.7c-10.2-16.9-16-36.6-16-57.7s5.8-40.9 16-57.7zm-48-43.5c-20.2 28.6-32 63.5-32 101.2s11.8 72.6 32 101.2c-14.5 6.9-30.8 10.8-48 10.8-61.9 0-112-50.1-112-112S130.1 96 192 96c17.2 0 33.5 3.9 48 10.8z"],
    "blender": [512, 512, [], "f517", "M0 56C0 25.1 25.1 0 56 0L437.6 0c21.3 0 36.6 20.3 30.8 40.8L457.1 80 344 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l99.4 0-18.3 64-81.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l67.4 0-27.4 96-256 0-9.1-96-62.9 0c-30.9 0-56-25.1-56-56L0 56zM114.3 192L100.6 48 56 48c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8l58.3 0zM136 384l240 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-240 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40zm120 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "u": [384, 512, [117], "55", "M32 32c17.7 0 32 14.3 32 32l0 224c0 70.7 57.3 128 128 128s128-57.3 128-128l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32l0 224c0 106-86 192-192 192S0 394 0 288L0 64C0 46.3 14.3 32 32 32z"],
    "share": [512, 512, ["mail-forward"], "f064", "M307.8 18.4c-12 5-19.8 16.6-19.8 29.6l0 80-112 0c-97.2 0-176 78.8-176 176 0 113.3 81.5 163.9 100.2 174.1 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-7.5-4.3-14.4-9.8-19.5-9.4-8.8-22.2-26.4-22.2-56.7 0-53 43-96 96-96l96 0 0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9z"],
    "phone-flip": [512, 512, [128381, "phone-alt"], "f879", "M351.8 25c7.8-18.8 28.4-28.9 48.1-23.5l5.5 1.5c64.6 17.6 119.8 80.2 103.7 156.4-37.1 175-174.8 312.7-349.8 349.8-76.3 16.2-138.8-39.1-156.4-103.7l-1.5-5.5c-5.4-19.7 4.7-40.3 23.5-48.1l97.3-40.5c16.5-6.9 35.6-2.1 47 11.8l38.6 47.2c70.3-34.9 126.8-93.3 159.3-164.9l-44.1-36.1c-13.9-11.3-18.6-30.4-11.8-47L351.8 25z"],
    "toilet-portable": [320, 512, [], "e583", "M0 64l0 16 320 0 0-16c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm24 64L0 128 0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 224 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-360-296 0zm224 96l24 0 0 96-24 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"],
    "person-pregnant": [384, 512, [], "e31e", "M192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm80 321.2c8.6-4.5 16.8-10 24.3-16.5l4-3.4c22.6-19.4 35.7-47.7 35.7-77.6 0-35.9-18.8-69.1-49.6-87.6l-30.4-18.2 0-1.8c0-46.5-37.7-84.1-84.1-84.1-28.1 0-54.4 14.1-70 37.5L21.4 270.2c-9.8 14.7-5.8 34.6 8.9 44.4s34.6 5.8 44.4-8.9l29-43.5-30.5 113.5c-2.6 9.6-.6 19.9 5.5 27.8S94 416 104 416l8 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-110.8z"],
    "less-than": [512, 512, [62774], "3c", "M477.1 50.6c7.4 16 .4 35.1-15.6 42.5L108.4 256 461.4 419c16 7.4 23 26.4 15.6 42.5s-26.4 23-42.5 15.6l-416-192C7.3 279.8 0 268.5 0 256S7.3 232.2 18.6 227l416-192c16-7.4 35.1-.4 42.5 15.6z"],
    "superscript": [576, 512, [], "f12b", "M544 32c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-32 16C449.9 27.3 443.5 46.5 451.4 62.3 457 73.5 468.3 80 480 80l0 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-128zM96 64C78.3 64 64 78.3 64 96s14.3 32 32 32l15.3 0 89.6 128-89.6 128-15.3 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c10.4 0 20.2-5.1 26.2-13.6L240 311.8 325.8 434.4c6 8.6 15.8 13.6 26.2 13.6l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-15.3 0-89.6-128 89.6-128 15.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-10.4 0-20.2 5.1-26.2 13.6L240 200.2 154.2 77.6C148.2 69.1 138.4 64 128 64L96 64z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 160l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M150.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 77.3 96 434.7 54.6 393.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96c6 6 14.1 9.4 22.6 9.4s16.6-3.4 22.6-9.4l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-41.4 41.4 0-357.5 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96z"],
    "poo-storm": [512, 512, ["poo-bolt"], "f75a", "M268.9-31.8c-5.5-.7-11 1.4-14.5 5.7s-4.6 10.1-2.8 15.3c2.8 8.2 4.3 16.9 4.3 26.1 0 21.7-8.5 37.2-21.9 47.6-13.9 10.8-34.1 17-58.1 17l-24 0c-48.6 0-88 39.4-88 88 0 14.8 3.7 28.8 10.2 41.1-42 6.6-74.2 43-74.2 86.9 0 46.6 36.2 84.7 81.9 87.8 3.1-12.4 9.9-23.8 19.6-32.5L242.7 225c12.2-10.9 28-17 44.4-17 44.6 0 76.5 43 63.7 85.7l-12.7 42.4c28.8 1.2 52.7 21.1 59.8 47.9l26.2 0c48.6 0 88-39.4 88-88 0-43.9-32.1-80.3-74.2-86.9 6.5-12.3 10.2-26.2 10.2-41.1 0-48.6-39.4-88-88-88l-9.4 0c.9-5.4 1.4-10.9 1.4-16.6 0-48.7-36.1-88.9-83.1-95.2zM144.6 416l61.8 0-31.2 104.1c-3.6 11.9 5.3 23.9 17.8 23.9 4.6 0 9-1.7 12.4-4.7L346.5 412.9c3.5-3.1 5.5-7.6 5.5-12.4 0-9.2-7.4-16.6-16.6-16.6l-61.8 0 31.2-104.1c3.6-11.9-5.3-23.9-17.8-23.9-4.6 0-9 1.7-12.4 4.7L133.5 387.1c-3.5 3.1-5.5 7.6-5.5 12.4 0 9.2 7.4 16.6 16.6 16.6z"],
    "video-slash": [576, 512, [], "f4e2", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-153-153 0-222.2c0-35.3-28.7-64-64-64L129.8 64 41-24.9zM32 128l0 256c0 35.3 28.7 64 64 64l256 0c7.8 0 15.3-1.4 22.2-4L36 105.8c-2.6 6.9-4 14.4-4 22.2zM464 336l73.5 58.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2L464 176 464 336z"],
    "square-xmark": [448, 512, [10062, "times-square", "xmark-square"], "f2d3", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm71 135c9.4-9.4 24.6-9.4 33.9 0l55 55 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 55 55c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-55-55-55 55c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l55-55-55-55c-9.4-9.4-9.4-24.6 0-33.9z"],
    "hand-holding-droplet": [576, 512, ["hand-holding-water"], "f4c1", "M275.5 6.6L209.2 103C198 119.3 192 138.6 192 158.3l0 1.7c0 53 43 96 96 96s96-43 96-96l0-1.7c0-19.8-6-39-17.2-55.3L300.5 6.6C297.7 2.5 293 0 288 0s-9.7 2.5-12.5 6.6zM109.3 341.5L66.7 384 32 384c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l320.5 0c29 0 57.3-9.3 80.7-26.5l126.6-93.3c17.8-13.1 21.6-38.1 8.5-55.9s-38.1-21.6-55.9-8.5L392.6 416 280 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-152.2 0c-33.9 0-66.5 13.5-90.5 37.5z"],
    "won-sign": [512, 512, [8361, "krw", "won"], "f159", "M62.4 53.9C56.8 37.1 38.7 28.1 21.9 33.6S-3.9 57.4 1.7 74.1L56.9 240 32 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l40.9 0 56.7 170.1c4.5 13.5 17.4 22.4 31.6 21.9s26.4-10.4 29.8-24.2L233 288 279 288 321 455.8c3.4 13.8 15.6 23.7 29.8 24.2s27.1-8.4 31.6-21.9L439.1 288 480 288c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24.9 0 55.3-165.9c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2l-62 186.1-54.6 0-45.9-183.8C283.5 42 270.7 32 256 32s-27.5 10-31 24.2L179 240 124.4 240 62.4 53.9zm78 234.1l26.6 0-11.4 45.6-15.2-45.6zM245 240l11-44.1 11 44.1-22 0zm100 48l26.6 0-15.2 45.6-11.4-45.6z"],
    "object-ungroup": [640, 512, [], "f248", "M32 119.4C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0 87.7 0 108.4 12.9 119.4 32l209.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-209.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-113.1zM119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4l0 113.1c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1c-9.7-5.6-17.8-13.7-23.4-23.4L119.4 96zM544 279.4c-9.7-5.6-17.8-13.7-23.4-23.4l-29.2 0c-5.3-17.7-14.8-33.5-27.4-46.4l0-17.6 56.6 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-209.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-24.6 64 0 0 24.6c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1z"],
    "comment": [512, 512, [128489, 61669], "f075", "M512 240c0 132.5-114.6 240-256 240-37.1 0-72.3-7.4-104.1-20.7L33.5 510.1c-9.4 4-20.2 1.7-27.1-5.8S-2 485.8 2.8 476.8l48.8-92.2C19.2 344.3 0 294.3 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240z"],
    "hill-avalanche": [576, 512, [], "e507", "M440.1 401.9c34.2 23.1 81.1 19.5 111.4-10.8 34.4-34.4 34.4-90.1 0-124.5-27.8-27.8-69.5-33.1-102.6-16-11.8 6.1-16.4 20.6-10.3 32.3s20.6 16.4 32.3 10.3c15.1-7.8 34-5.3 46.6 7.3 15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7c22.3-14.2 37.1-39.1 37.1-67.5 0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-27.3 0-51.5 13.7-65.9 34.6-5.8-20-24.2-34.6-46.1-34.6-26.5 0-48 21.5-48 48 0 4 .5 7.9 1.4 11.6L440.1 401.9zM480.4 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM68.7 87C43.5 61.8 .4 79.7 .4 115.3L.4 432c0 44.2 35.8 80 80 80l316.7 0c35.6 0 53.5-43.1 28.3-68.3L68.7 87z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M176 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 38.1-63-63c-9.4-9.4-24.6-9.4-33.9 0S21.7 55.6 31 65l63 63-38.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c13.3 0 24-10.7 24-24l0-96zm0 400l0-96c0-13.3-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l38.1 0-63 63c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l63-63 0 38.1c0 13.3 10.7 24 24 24s24-10.7 24-24zm312 24c13.3 0 24-10.7 24-24l0-38.1 63 63c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63-63 38.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24zM464 56l0 96c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-38.1 0 63-63c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-63 63 0-38.1c0-13.3-10.7-24-24-24s-24 10.7-24 24zM320 120c-57.3 0-99.4 34-125.6 64.3-20 23.1-32.4 45.8-37.6 56.1-2.5 5-4.9 9.7-4.9 15.6s2.3 10.6 4.9 15.6c5.2 10.3 17.6 33 37.6 56.1 26.2 30.3 68.2 64.3 125.6 64.3s99.4-34 125.6-64.3c20-23.1 32.4-45.8 37.6-56.1 2.5-5 4.9-9.7 4.9-15.6s-2.3-10.6-4.9-15.6c-5.2-10.3-17.6-33-37.6-56.1-26.2-30.3-68.2-64.3-125.6-64.3zM256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "snowplow": [640, 512, [], "f7d2", "M128 160l0-96c0-35.3 28.7-64 64-64L296.4 0c24.2 0 46.4 13.7 57.2 35.4l87.6 175.1c4.4 8.9 6.8 18.7 6.8 28.6l0 56.9 80 0 0-80c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40l0 208c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24c-48.6 0-88-39.4-88-88l0-80-63 0c9.5 16.5 15 35.6 15 56 0 61.9-50.1 112-112 112l-224 0c-61.9 0-112-50.1-112-112 0-30.5 12.2-58.2 32-78.4L64 224c0-35.3 28.7-64 64-64zm91.7 34.9l43.6 29.1 113.2 0-80-160-104.4 0 0 108.8 27.7 22.1zM416 400c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l224 0c26.5 0 48-21.5 48-48zm-280 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM232 400a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "chart-gantt": [512, 512, [], "e0e4", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0zm64 112c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0zM384 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0z"],
    "video": [576, 512, ["video-camera"], "f03d", "M96 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L96 64zM464 336l73.5 58.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2L464 176 464 336z"],
    "chess-pawn": [384, 512, [9823], "f443", "M192-32c66.3 0 120 53.7 120 120 0 27-8.9 51.9-24 72 17.7 0 32 14.3 32 32s-14.3 32-32 32l-10.7 0 26.7 160 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 106.7 224 96 224c-17.7 0-32-14.3-32-32s14.3-32 32-32c-15.1-20.1-24-45-24-72 0-66.3 53.7-120 120-120z"],
    "synagogue": [576, 512, [128333], "f69b", "M16 80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32-128 0 0-32zm0 368l0-288 128 0 126.2-84.2c10.7-7.2 24.8-7.2 35.5 0l126.2 84.2 128 0 0 288c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64zM560 112l-128 0 0-32c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32zM224 384l0 80 128 0 0-80c0-35.3-28.7-64-64-64s-64 28.7-64 64zm64-152a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "building-circle-check": [576, 512, [], "e4d2", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-80c0-17.7 14.3-32 32-32l32 0c2 0 4 .2 5.9 .5 6-23.6 16.3-45.4 30.1-64.5l-4 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 4c27.5-19.8 60.3-32.4 96-35.4L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-86.6-60.9c7.1 5.2 8.7 15.2 3.5 22.3l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5z"],
    "calendar-plus": [448, 512, [], "f271", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zm96 192c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "wheelchair-move": [448, 512, ["wheelchair-alt"], "e2ce", "M312 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM205.4 124.1c-6.4-5.2-15.6-4.7-21.4 1.1l-33.4 33.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L138.8 80c29-29 75.2-31.4 107-5.5l81.3 66c21.4 17.4 23.8 49.2 5.2 69.5l-41.8 46 98 0c30.3 0 53 27.7 47.1 57.4L407.4 454.3c-3.5 17.3-20.3 28.6-37.7 25.1s-28.6-20.3-25.1-37.7L369 320 316.8 320c2.1 10.3 3.2 21 3.2 32 0 88.4-71.6 160-160 160S0 440.4 0 352 71.6 192 160 192c6 0 11.9 .3 17.8 1l50.4-50.4-22.7-18.5zM160 448a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "user-shield": [576, 512, [], "f505", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56C95.8 304 16 383.8 16 482.3 16 498.7 29.3 512 45.7 512l251.5 0C261 469.4 240 414.5 240 356.4l0-31.1c0-7.3 1-14.5 2.9-21.3l-48.6 0zm251 184.5l-13.3 6.3 0-188.1 96 32 0 19.6c0 55.8-32.2 106.5-82.7 130.3zM421.9 259.5l-112 37.3c-13.1 4.4-21.9 16.6-21.9 30.4l0 31.1c0 74.4 43 142.1 110.2 173.7l18.5 8.7c4.8 2.2 10 3.4 15.2 3.4s10.5-1.2 15.2-3.4l18.5-8.7C533 500.3 576 432.6 576 358.2l0-31.1c0-13.8-8.8-26-21.9-30.4l-112-37.3c-6.6-2.2-13.7-2.2-20.2 0z"],
    "bold": [384, 512, [], "f032", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l32 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zM288 160c0 35.3-28.7 64-64 64l-96 0 0-128 96 0c35.3 0 64 28.7 64 64zM128 416l0-128 128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0z"],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", "M256 107.9L241 87.1C216 52.5 175.9 32 133.1 32 59.6 32 0 91.6 0 165.1l0 2.6c0 23.6 6.2 48 16.6 72.3l106 0c3.2 0 6.1-1.9 7.4-4.9l31.8-76.3c3.7-8.8 12.3-14.6 21.8-14.8s18.3 5.4 22.2 14.1l51.3 113.9 41.4-82.8c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3l23.2 46.3c1.4 2.7 4.1 4.4 7.2 4.4l123.6 0c10.5-24.3 16.6-48.7 16.6-72.3l0-2.6C512 91.6 452.4 32 378.9 32 336.2 32 296 52.5 271 87.1l-15 20.7zM469.6 288l-97.8 0c-21.2 0-40.6-12-50.1-31l-1.7-3.4-42.5 85.1c-4.1 8.3-12.7 13.5-22 13.3s-17.6-5.7-21.4-14.1l-49.3-109.5-10.5 25.2c-8.7 20.9-29.1 34.5-51.7 34.5l-80.2 0c47.2 73.8 123 141.7 170.4 177.9 12.4 9.4 27.6 14.1 43.1 14.1s30.8-4.6 43.1-14.1C346.6 429.7 422.4 361.8 469.6 288z"],
    "square-root-variable": [576, 512, ["square-root-alt"], "f698", "M282.6 78.1c8-27.3 33-46.1 61.4-46.1l200 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L344 96 238.7 457c-3.6 12.3-14.1 21.2-26.8 22.8s-25.1-4.6-31.5-15.6L77.6 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l45.6 0c22.8 0 43.8 12.1 55.3 31.8l65.2 111.8 84.4-289.5zM393.4 233.4c12.5-12.5 32.8-12.5 45.3 0l41.4 41.4 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-41.4 41.4 41.4 41.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-41.4-41.4-41.4 41.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l41.4-41.4-41.4-41.4c-12.5-12.5-12.5-32.8 0-45.3z"],
    "hands-bubbles": [512, 512, ["hands-wash"], "e05e", "M384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM0 160l.1 72.6c0 44.8 17.6 87.1 47.9 118.4 .3-77 40.1-148.4 105.4-189.3l1.9-1.2c-2.5-3.7-2.8-8.6-.4-12.7l62-107.4c6.6-11.5 2.7-26.2-8.8-32.8S182 5 175.4 16.5l-68 117.8 0 0 0 0-43.3 75 0-49.3c0-17.7-14.4-32-32-32S0 142.4 0 160zm213.6-35.9c14.1-8.8 29.8-12.7 45.2-12.1l36.5-63.3c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8l-67.1 116.2 27-16.9zm86.5-35.7l-16.4 28.4c15.1 5.5 28.6 15.6 38.3 29.7l19.7-34.2c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zm46.4 63.7l-12.5 21.7c2 8.6 2.5 17.5 1.7 26.1l4.3 0 0 0 34.4 0 13.7-23.8c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zM283.1 175c-9.4-15-29.1-19.5-44.1-10.2l-60.2 37.6C127.3 234.7 96 291.2 96 352l0 8c0 8.9 .8 17.6 2.2 26.1 35.4 8.2 61.8 40 61.8 77.9 0 6.3-.7 12.5-2.1 18.4 25.2 18.6 56.4 29.6 90.1 29.6l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-92 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-124 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l156 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-156 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-136 0 0 0 0 0-93.2 0 46.2-28.9c15-9.4 19.5-29.1 10.2-44.1z"],
    "marker": [512, 512, [], "f5a1", "M408.8 0c-27.4 0-53.6 10.9-73 30.2L318.1 48 305 34.9c-28.1-28.1-73.7-28.1-101.8 0L103 135c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L237.1 68.9c9.4-9.4 24.6-9.4 33.9 0L284.1 81.9 184 182.1 329.9 328 481.8 176.2c19.4-19.4 30.2-45.6 30.2-73 0-57-46.2-103.2-103.2-103.2zM102.4 263.7c-49.9 49.9-83.3 114-95.5 183.5L.4 483.8C-1 491.6 1.5 499.4 7 505s13.4 8 21.1 6.7l36.7-6.5c69.5-12.3 133.6-45.6 183.5-95.5L296 361.9 150.1 216 102.4 263.7z"],
    "clipboard": [384, 512, [128203], "f328", "M320 32l-8.6 0C300.4 12.9 279.7 0 256 0L128 0C104.3 0 83.6 12.9 72.6 32L64 32C28.7 32 0 60.7 0 96L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352c0-35.3-28.7-64-64-64zM136 112c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0z"],
    "place-of-worship": [512, 512, [], "f67f", "M160 79l0 81-44.8 33.6C103.1 202.7 96 216.9 96 232l0 40-60.6 30.3C13.7 313.2 0 335.3 0 359.6L0 448c0 35.3 28.7 64 64 64 74.7 0 85.4 0 320 0l64 0c35.3 0 64-28.7 64-64l0-88.4c0-24.2-13.7-46.4-35.4-57.2L416 272 416 232c0-15.1-7.1-29.3-19.2-38.4L352 160 352 79c0-9.5-4.2-18.5-11.5-24.6L271.4-3.2c-8.9-7.4-21.8-7.4-30.7 0L171.5 54.4C164.2 60.5 160 69.5 160 79zm96 241c35.3 0 64 28.7 64 64l0 80-128 0 0-80c0-35.3 28.7-64 64-64z"],
    "cannabis": [512, 512, [], "f55f", "M256 0c5.3 0 10.3 2.7 13.3 7.1 15.8 23.5 36.7 63.7 49.2 109 7.3 26.4 11.8 55.3 10.3 84 11.6-8.9 23.7-16.7 35.9-23.7 41-23.3 84.4-36.9 112.2-42.5 5.2-1 10.7 .6 14.4 4.4s5.4 9.2 4.4 14.5c-5.6 27.7-19.3 70.9-42.7 111.7-9.1 15.9-19.9 31.7-32.5 46.3 27.9 6.6 52.5 17.2 67.3 25.4 5.1 2.8 8.2 8.2 8.2 14s-3.2 11.2-8.2 14c-15.2 8.4-40.9 19.5-69.8 26.1-20.2 4.6-42.9 7.2-65.2 4.6l8.3 33.2c1.5 6.1-.6 12.5-5.5 16.4s-11.6 4.6-17.2 1.8L280 417.2 280 488c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-70.8-58.5 29.1c-5.6 2.8-12.3 2.1-17.2-1.8s-7-10.3-5.5-16.4l8.3-33.2c-22.2 2.6-45 0-65.2-4.6-28.9-6.6-54.5-17.6-69.8-26.1-5.1-2.8-8.2-8.2-8.2-14s3.2-11.2 8.2-14l6.2-3.3c15-7.6 36.8-16.4 61.1-22.2-12.5-14.5-23.3-30.4-32.4-46.2-23.4-40.8-37.1-84-42.7-111.7-1.1-5.2 .6-10.7 4.4-14.5s9.2-5.4 14.4-4.4c27.9 5.5 71.2 19.2 112.2 42.5 12.2 6.9 24.3 14.8 35.8 23.7-1.4-28.7 3.1-57.6 10.3-84 12.5-45.3 33.4-85.5 49.2-109l1.2-1.6C246.9 2 251.3 0 256 0z"],
    "people-roof": [576, 512, [], "e537", "M302.3-12.6c-9-4.5-19.6-4.5-28.6 0l-256 128C1.9 123.3-4.5 142.5 3.4 158.3s27.1 22.2 42.9 14.3L288 51.8 529.7 172.6c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-256-128zM288 272a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 48c-53 0-96 43-96 96l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-53-43-96-96-96zM160 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm352 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 336c-44.2 0-80 35.8-80 80l0 33.1c0 17 13.8 30.9 30.9 30.9l87.8 0c-4.3-9.8-6.7-20.6-6.7-32l0-48c0-18.4 3.5-36 9.8-52.2-12.2-7.5-26.5-11.8-41.8-11.8zM425.4 480l87.8 0c17 0 30.9-13.8 30.9-30.9l0-33.1c0-44.2-35.8-80-80-80-15.3 0-29.6 4.3-41.8 11.8 6.3 16.2 9.8 33.8 9.8 52.2l0 48c0 11.4-2.4 22.2-6.7 32z"],
    "disease": [512, 512, [], "f7fa", "M236.5 29.4L224 48c-20 30-53.6 48-89.7 48L68 96c-37.5 0-67.9 30.4-67.9 67.9 0 18 7.2 35.2 19.9 47.9l27 27c11 11 17.2 25.9 17.2 41.5 0 15.8-6.4 30.9-17.7 42L33.4 335.1c-11.1 10.8-17.3 25.7-17.3 41.2 0 36.8 34.1 64.2 70.1 56.2l62.3-13.8c7.7-1.7 15.7-2.6 23.6-2.6 32.8 0 64.2 14.6 85.2 39.8l30.5 36.6c10.4 12.4 25.7 19.6 41.9 19.6 30.1 0 54.5-24.4 54.5-54.5l0-51.2c0-41.4 25.4-78.5 64-93.5l22.2-8.6c25.2-9.8 41.8-34.1 41.8-61.1 0-26.4-15.9-50.3-40.3-60.5L429 164.8c-33.2-13.9-57.6-43-65.5-78.1l-7.9-35.2c-6.8-30.1-33.5-51.5-64.3-51.5-22 0-42.6 11-54.8 29.4zM160 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "book-bible": [448, 512, ["bible"], "f647", "M96 512c-53 0-96-43-96-96L0 96C0 43 43 0 96 0L400 0c26.5 0 48 21.5 48 48l0 288c0 20.9-13.4 38.7-32 45.3l0 66.7c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 512zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0-64-256 0zM192 80l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "chess-board": [448, 512, [], "f43c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 64l0 64 64 0 0-64 64 0 0 64 64 0 0-64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64 64 0 0-64-64 0 0-64 64 0 0-64-64 0 0-64 64 0zm64 128l64 0 0-64-64 0 0 64zm0 64l0-64-64 0 0 64 64 0zm64 0l-64 0 0 64 64 0 0-64zm0 0l64 0 0-64-64 0 0 64z"],
    "mars": [512, 512, [9794], "f222", "M320 32c0-17.7 14.3-32 32-32L480 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S32 401.2 32 304 110.8 128 208 128c37 0 71.4 11.4 99.8 31l95-95-50.7 0c-17.7 0-32-14.3-32-32zM208 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "laptop": [640, 512, [128187], "f109", "M128 32C92.7 32 64 60.7 64 96l0 240 64 0 0-240 384 0 0 240 64 0 0-240c0-35.3-28.7-64-64-64L128 32zM19.2 384C8.6 384 0 392.6 0 403.2 0 445.6 34.4 480 76.8 480l486.4 0c42.4 0 76.8-34.4 76.8-76.8 0-10.6-8.6-19.2-19.2-19.2L19.2 384z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M136.4 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zm-88 354.3c0-98.5 79.8-178.3 178.3-178.3l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L78.1 512c-16.4 0-29.7-13.3-29.7-29.7zM612.3 124.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "flag-usa": [448, 512, [], "f74d", "M32 0C49.7 0 64 14.3 64 32l0 16 69-17.2c38.1-9.5 78.3-5.1 113.5 12.5 46.3 23.2 100.8 23.2 147.1 0l9.6-4.8C423.8 28.1 448 43.1 448 66.1l0 36.1-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-20.3-9-41.8-14.7-63.6-16.9l0 32.2c17.4 2.1 34.4 6.7 50.6 13.9l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 62-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 61.9-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 33.5c0 13.3-8.3 25.3-20.8 30l-34.7 13c-46.2 17.3-97.6 14.6-141.7-7.4-37.9-19-81.4-23.7-122.5-13.4L64 400 64 480c0 17.7-14.3 32-32 32S0 497.7 0 480L0 32C0 14.3 14.3 0 32 0zm80 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "hand-middle-finger": [448, 512, [128405], "f806", "M232 0c-22.1 0-40 17.9-40 40l0 164.2c-8.5-7.6-19.7-12.2-32-12.2-26.5 0-48 21.5-48 48l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-55.7c-2 1.4-3.9 3-5.8 4.5L55 284.8C40.4 297 32 315 32 334L32 372c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1L304 512c70.7 0 128-57.3 128-128l0-96c0-26.5-21.5-48-48-48-12.4 0-23.6 4.7-32.1 12.3-1.9-24.8-22.6-44.3-47.9-44.3-12.3 0-23.5 4.6-32 12.2L272 40c0-22.1-17.9-40-40-40z"],
    "mortar-pestle": [512, 512, [], "f5a7", "M504.3 11.1C493.3-1.6 474.5-3.7 461 6.2L252.3 160 397.3 160 502.6 54.6c11.8-11.8 12.6-30.8 1.6-43.5zM32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32c0 82.5 43.4 147.7 123.9 176.2-11.1 13.9-19.4 30.3-23.9 48.1-4.4 17.1 10.4 31.7 28.1 31.7l192 0c17.7 0 32.4-14.6 28.1-31.7-4.5-17.8-12.8-34.1-23.9-48.1 80.5-28.6 123.9-93.7 123.9-176.2 17.7 0 32-14.3 32-32s-14.3-32-32-32L32 192z"],
    "head-side-cough": [512, 512, [], "e061", "M96 512l64 0c53 0 96-43 96-96l0-80c0-8.8 7.2-16 16-16l1 0c26 0 47-21 47-47 0-11-3.9-21.6-10.9-30.1L273.3 200C271.4 197.6 270.1 194.7 269.7 191.7 254 83.3 160.7 0 48 0 40.4 0 32.9 .4 25.4 1.1 10.5 2.6 0 15.9 0 30.9L0 480c0 17.7 14.3 32 32 32l64 0zm16-320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm63.1 237.2l-41.5-3.5c-12.2-1-21.6-11.2-21.6-23.4 0-10.8 7.3-20.2 17.8-22.8l40.4-10.1c19.2-4.8 37.8 9.7 37.8 29.5 0 17.8-15.2 31.8-32.9 30.3zM480 312a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-64 48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm128 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM480 504a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "plane-lock": [640, 512, [], "e558", "M232 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 82.1 75.2C409.7 248.1 400 274.9 400 304l0 24.4c-7.3 6.6-13.6 14.2-18.7 22.7l-37.3-12.4 0 99.7 24 19.2 0 38.3c0 13.5 2.8 26.4 7.8 38.1L288 512 179.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C58.7 396.4 48 388.7 48 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L232 151.3 232 24zM560 304.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "battery-three-quarters": [640, 512, ["battery-4"], "f241", "M528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm56 112c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l224 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-224 0z"],
    "franc-sign": [320, 512, [], "e18f", "M80 32C62.3 32 48 46.3 48 64l0 256-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-64 144 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-144 0 0-96 176 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", "M32 64C19.1 64 7.4 71.8 2.4 83.8S.2 109.5 9.4 118.6L192 301.3 192 416c0 8.5 3.4 16.6 9.4 22.6l64 64c2.5 2.5 5.3 4.5 8.3 6-21.2-30.9-33.6-68.3-33.6-108.6 0-99.4 75.5-181.1 172.3-191l90.4-90.4c9.2-9.2 11.9-22.9 6.9-34.9S492.9 64 480 64L32 64zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM416 320c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-45.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l53.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-8.1z"],
    "cheese": [512, 512, [], "f7ef", "M512 240.2l0 15.8-512 0c0-20 10-38.7 26.6-49.8L274.9 40.7c8.6-5.7 18.6-8.7 28.9-8.7 115 0 208.2 93.2 208.2 208.2zm0 63.8l0 112c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-112 512 0z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm96-344l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-96 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 96 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "school": [576, 512, [127979], "f549", "M0 192c0-35.3 28.7-64 64-64l64 0 127.9-115.1c18.3-16.4 46-16.4 64.2 0L448 128 512 128c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192zM224 376l0 88 128 0 0-88c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm-112 8c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm16-144l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 384c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm16-144l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM288 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "dice-five": [448, 512, [9860], "f523", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "tornado": [448, 512, [127786], "f76f", "M0 32L0 45.6C0 62.7 1.7 79.6 5 96l352.8 0c3.2-6.9 7.5-13.3 13-18.8l38.6-38.6c4.2-4.2 6.6-10 6.6-16 0-12.5-10.1-22.6-22.6-22.6L32 0C14.3 0 0 14.3 0 32zM355.7 144l-336 0c12.4 29.7 30.2 56.8 52.7 80l339.6 0-47.2-62.9c-3.9-5.2-7-11-9.2-17.1zM242.6 334.7c8.2 4.8 15.8 10.7 22.5 17.3L445 352c2-9.8 3-19.9 3-30.1 0-17.1-2.9-34-8.6-49.9L136 272 242.6 334.7zM294.3 400c5.3 17 6.5 35.2 3.6 53l-5.9 35.7c-2 12.2 7.4 23.4 19.8 23.4 5.3 0 10.4-2.1 14.2-5.9l78.2-78.2c8.5-8.5 15.8-17.8 21.9-27.9l-131.8 0z"],
    "jet-fighter": [576, 512, ["fighter-jet"], "f0fb", "M496.2 206.8c-10.7-4.5-22.2-6.8-33.8-6.8L362 200 248 48 296 48c13.3 0 24-10.7 24-24S309.3 0 296 0L152 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 152-54.4 0-52.8-66c-3-3.8-7.6-6-12.5-6L16 128c-8.8 0-16 7.2-16 16l0 88 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 88c0 8.8 7.2 16 16 16l24.3 0c4.9 0 9.5-2.2 12.5-6l52.8-66 54.4 0 0 152-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 114-152 100.4 0c11.6 0 23.1-2.3 33.8-6.8l65-27.1c8.9-3.7 14.8-12.5 14.8-22.2s-5.8-18.4-14.8-22.2l-65-27.1z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M384 32c26.5 0 48 21.5 48 48 0 6.3-1.3 12.2-3.4 17.7 20.4 5.5 35.4 24.1 35.4 46.3 0 9.1-2.6 17.6-7 24.9 22.2 4.2 39 23.7 39 47.1 0 19.7-11.9 36.6-28.9 44 17 7.4 28.9 24.3 28.9 44 0 26.5-21.5 48-48 48l-160 0 28.2 70.4c2.5 6.3 3.8 13.1 3.8 19.9l0 4.2c0 27.3-22.1 49.4-49.4 49.4-18.7 0-35.8-10.6-44.2-27.3L170.1 356.3c-6.7-13.3-10.1-28-10.1-42.9l0-186.6c0-19.4 8.9-37.8 24-50l12.2-9.7C224.6 44.4 259.8 32 296.1 32L384 32zM80 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32L0 128c0-17.7 14.3-32 32-32l48 0z"],
    "broom": [576, 512, [129529], "f51a", "M566.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192-34.7-34.7c-4.2-4.2-10-6.6-16-6.6-12.5 0-22.6 10.1-22.6 22.6l0 29.1 108.3 108.3 29.1 0c12.5 0 22.6-10.1 22.6-22.6 0-6-2.4-11.8-6.6-16l-34.7-34.7 192-192zM341.1 353.4L222.6 234.9c-42.7-3.7-85.2 11.7-115.8 42.3l-8 8c-22.3 22.3-34.8 52.5-34.8 84 0 6.8 7.1 11.2 13.2 8.2l51.1-25.5c5-2.5 9.5 4.1 5.4 7.9L7.3 473.4C2.7 477.6 0 483.6 0 489.9 0 502.1 9.9 512 22.1 512l173.3 0c38.8 0 75.9-15.4 103.4-42.8 30.6-30.6 45.9-73.1 42.3-115.8z"],
    "file-import": [384, 512, ["arrow-right-to-file"], "f56f", "M64 0C28.7 0 0 28.7 0 64l0 240 182.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-182.1 0 0 96c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-277.5c0-17-6.7-33.3-18.7-45.3L258.7 18.7C246.7 6.7 230.5 0 213.5 0L64 0zM325.5 176L232 176c-13.3 0-24-10.7-24-24L208 58.5 325.5 176z"],
    "utensils": [512, 512, [127860, 61685, "cutlery"], "f2e7", "M63.9 14.4C63.1 6.2 56.2 0 48 0s-15.1 6.2-16 14.3L17.9 149.7c-1.3 6-1.9 12.1-1.9 18.2 0 45.9 35.1 83.6 80 87.7L96 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-224.4c44.9-4.1 80-41.8 80-87.7 0-6.1-.6-12.2-1.9-18.2L223.9 14.3C223.1 6.2 216.2 0 208 0s-15.1 6.2-15.9 14.4L178.5 149.9c-.6 5.7-5.4 10.1-11.1 10.1-5.8 0-10.6-4.4-11.2-10.2L143.9 14.6C143.2 6.3 136.3 0 128 0s-15.2 6.3-15.9 14.6L99.8 149.8c-.5 5.8-5.4 10.2-11.2 10.2-5.8 0-10.6-4.4-11.1-10.1L63.9 14.4zM448 0C432 0 320 32 320 176l0 112c0 35.3 28.7 64 64 64l32 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-448c0-17.7-14.3-32-32-32z"],
    "id-badge": [384, 512, [], "f2c1", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zm96 352l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16L96 448c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-24-96a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM152 64l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "spider": [512, 512, [128375], "f717", "M369.3-31c11.9-3.5 24.4 2.7 29 13.9l.8 2.3 40 136c2.5 8.4 .1 17.5-6.1 23.7l-64.1 64.1 76.4-20.8 19.9-59.8 .9-2.3c5-11.1 17.7-16.8 29.5-12.9 11.8 3.9 18.5 16.1 15.8 28l-.7 2.4-24 72c-2.5 7.6-8.7 13.4-16.5 15.6l-91.1 24.8 91.1 24.8c7.7 2.1 13.9 8 16.5 15.6l24 72 .7 2.4c2.7 11.9-4.1 24.1-15.8 28-11.8 3.9-24.5-1.8-29.5-12.9l-.9-2.3-19.9-59.8-76.4-20.8 64.1 64.1c6.1 6.1 8.5 15.1 6.2 23.4l-40 144-.8 2.3c-4.4 11.3-16.8 17.7-28.8 14.4-12-3.3-19.3-15.2-17.2-27.2l.5-2.4 36.2-130.5-37.2-37.2C351 406 308.4 448 256 448s-95-42-96-94.1l-37 37 36 122.3 .6 2.4c2.2 11.9-4.9 23.9-16.8 27.4-11.9 3.5-24.4-2.7-29-13.9l-.8-2.3-40-136c-2.5-8.4-.1-17.5 6.1-23.8l64.1-64.1-76.4 20.8-19.9 59.8-.9 2.3c-5 11.1-17.7 16.8-29.5 12.9s-18.5-16.1-15.8-28l.7-2.4 24-72c2.5-7.6 8.7-13.4 16.5-15.6l91.1-24.8-91.1-24.8c-7.7-2.1-13.9-8-16.5-15.6l-24-72-.7-2.4c-2.7-11.9 4.1-24.1 15.8-28s24.5 1.8 29.5 12.9l.9 2.3 19.9 59.8 76.4 20.8-64.1-64.1c-6.2-6.2-8.5-15.3-6.1-23.7l40-136 .8-2.3c4.6-11.3 17.1-17.4 29-13.9 11.9 3.5 19 15.5 16.8 27.4l-.6 2.4-36 122.3 53 53c1-43.3 36.4-78.1 79.9-78.1s78.9 34.8 79.9 78.2l53.1-53.1-36-122.3-.6-2.4c-2.2-12 4.9-23.9 16.8-27.4z"],
    "mobile-retro": [384, 512, [], "e527", "M16 64C16 28.7 44.7 0 80 0L304 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64L16 64zm80 96l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm8 192a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM168 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0z"],
    "signs-post": [512, 512, ["map-signs"], "f277", "M256.4 0c-17.7 0-32 14.3-32 32l0 32-160 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l160 0 0 64-153.4 0c-4.2 0-8.3 1.7-11.3 4.7l-48 48c-6.2 6.2-6.2 16.4 0 22.6l48 48c3 3 7.1 4.7 11.3 4.7l153.4 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 160 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-160 0 0-64 153.4 0c4.2 0 8.3-1.7 11.3-4.7l48-48c6.2-6.2 6.2-16.4 0-22.6l-48-48c-3-3-7.1-4.7-11.3-4.7l-153.4 0 0-32c0-17.7-14.3-32-32-32z"],
    "group-arrows-rotate": [512, 512, [], "e4f6", "M37.6 122.3c-11.5 18.7-20.6 39-27 60.5-5 16.9 4.6 34.8 21.5 39.8s34.8-4.6 39.8-21.5c18.4-61.9 67.3-110.8 129.2-129.2 16.9-5 26.6-22.9 21.5-39.8S199.8 5.6 182.9 10.6C161.4 17 141.1 26.1 122.3 37.6 112.3 15.4 89.9 0 64 0 28.7 0 0 28.7 0 64 0 89.9 15.4 112.3 37.6 122.3zm436.7 0c22.2-10 37.6-32.4 37.6-58.3 0-35.3-28.7-64-64-64-25.9 0-48.3 15.4-58.3 37.6-18.7-11.5-39-20.6-60.5-27-16.9-5-34.8 4.6-39.8 21.5s4.6 34.8 21.5 39.8c61.9 18.4 110.8 67.3 129.2 129.2 5 16.9 22.9 26.6 39.8 21.5s26.6-22.9 21.5-39.8c-6.4-21.5-15.5-41.8-27-60.5zM512 448c0-25.9-15.4-48.3-37.6-58.3 11.5-18.7 20.6-39 27-60.5 5-16.9-4.6-34.8-21.5-39.8s-34.8 4.6-39.8 21.5c-18.4 61.9-67.3 110.8-129.2 129.2-16.9 5-26.6 22.9-21.5 39.8s22.9 26.6 39.8 21.5c21.5-6.4 41.8-15.5 60.5-27 10 22.2 32.4 37.6 58.3 37.6 35.3 0 64-28.7 64-64zM37.6 389.7c-22.2 10-37.6 32.4-37.6 58.3 0 35.3 28.7 64 64 64 25.9 0 48.3-15.4 58.3-37.6 18.7 11.5 39 20.6 60.5 27 16.9 5 34.8-4.6 39.8-21.5s-4.6-34.8-21.5-39.8c-61.9-18.4-110.8-67.3-129.2-129.2-5-16.9-22.9-26.6-39.8-21.5S5.6 312.2 10.6 329.1c6.4 21.5 15.5 41.8 27 60.5zM256 192c15.6 0 30 5.6 41.1 14.9l-15.3 15.3c-6.6 6.6-1.9 17.8 7.4 17.8l60.5 0c5.7 0 10.4-4.7 10.4-10.4l0-60.5c0-9.3-11.2-13.9-17.8-7.4l-11.2 11.2c-19.8-17.9-46.2-28.9-75.1-28.9-43.6 0-81.3 24.9-99.8 61.1-6 11.8-1.4 26.3 10.4 32.3s26.3 1.4 32.3-10.4c10.6-20.8 32.2-34.9 57-34.9zm58.6 93.1c-10.6 20.8-32.2 34.9-57 34.9-15.7 0-30-5.6-41.1-14.9l15.3-15.3c6.6-6.6 1.9-17.8-7.4-17.8L164 272c-5.7 0-10.4 4.7-10.4 10.4l0 60.5c0 9.3 11.2 13.9 17.8 7.4l11.2-11.2c19.8 17.9 46.2 28.9 75.1 28.9 43.6 0 81.3-24.9 99.8-61.1 6-11.8 1.4-26.3-10.4-32.3s-26.3-1.4-32.3 10.4z"],
    "arrows-split-up-and-left": [512, 512, [], "e4bc", "M342.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l41.4-41.4 0 195.9c-18.8-10.9-40.7-17.1-64-17.1l-114.7 0 41.4-41.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 320 224 320c35.3 0 64 28.7 64 64 0 70.7 57.3 128 128 128l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-35.3 0-64-28.7-64-64l0-306.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96z"],
    "fill-drip": [576, 512, [], "f576", "M309.7 71.6l-64.4 64.4 33.4 33.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-33.4-33.4-96.4 96.4c-2.9 2.9-5.1 6.5-6.3 10.3l321.5 0 53.7-53.7c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3L346.3 71.6C341.5 66.7 334.9 64 328 64s-13.5 2.7-18.3 7.6zM58.3 232.4l96.4-96.4-49.4-49.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L200 90.7 264.4 26.3C281.3 9.5 304.1 0 328 0s46.7 9.5 63.6 26.3L517.7 152.4C534.5 169.3 544 192.1 544 216s-9.5 46.7-26.3 63.6L311.6 485.7C294.7 502.5 271.9 512 248 512s-46.7-9.5-63.6-26.3L58.3 359.6C41.5 342.7 32 319.9 32 296s9.5-46.7 26.3-63.6zM512 544c-35.3 0-64-28.7-64-64 0-25.2 32.6-79.6 51.2-108.7 6-9.4 19.5-9.4 25.5 0 18.7 29.1 51.2 83.5 51.2 108.7 0 35.3-28.7 64-64 64z"],
    "shield-heart": [512, 512, [], "e574", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM249.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "person-skiing-nordic": [576, 512, ["skiing-nordic"], "f7ca", "M424.8 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm99.8 193.7c7.6 15.2 1.9 33.6-12.6 42l0 180.3-32 0 0-164.2-10.1 5c-27.4 13.7-60.7 6.1-79.4-18.2l-19.6-25.5-39.5 68.8 24.8 12.4c29.5 14.7 42.9 49.5 31.1 80.2l-28.2 73.4 149.4 0c7.9 0 15.6-2.3 22.2-6.7l7.9-5.3c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3l-7.9 5.3C543 506.9 526 512 508.6 512l-189.1 0c-.5 0-1 0-1.5 0L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l88 0c0-8.2 3.1-16.4 9.4-22.6l74.1-74.1 10.2-35.9c11.3 18.3 27.7 33.8 48.4 44.2l4.8 2.4-1.9 6.8c-3 10.5-8.6 20-16.3 27.7l-51.5 51.5 101.3 0 37.1-96.4-55.6-27.8C230.4 319 215.3 267 239.3 227.1l37.7-62.7-27.7-7.7c-9-2.5-18.1 3.2-20 12.3l-5.9 29.3c-3.1 15.6-17.1 26.3-32.5 25.7l-130 208-37.7 0 140.6-225c-3.4-6.3-4.6-13.8-3.1-21.3l5.9-29.3c9.1-45.6 55.1-73.8 99.9-61.4l32.5 9c46.7 13 88 40.8 117.6 79.3l24.9 32.3 40.4-20.2c15.8-7.9 35-1.5 42.9 14.3z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM342 145.7c-10.7-7.8-25.7-5.4-33.5 5.3L189.1 315.2 137 263.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.9 7.5 18.8 7s13.4-4.1 17.5-9.8L347.3 179.2c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M96 77.3c0-7.3 5.9-13.3 13.3-13.3 3.5 0 6.9 1.4 9.4 3.9l14.9 14.9c-3.6 9.1-5.5 18.9-5.5 29.2 0 19.9 7.2 38 19.2 52-5.3 9.2-4 21.1 3.8 29 9.4 9.4 24.6 9.4 33.9 0L289 89c9.4-9.4 9.4-24.6 0-33.9-7.8-7.9-19.8-9.1-29-3.8-14-12-32.1-19.2-52-19.2-10.3 0-20.2 2-29.2 5.5L163.9 22.6C149.4 8.1 129.7 0 109.3 0 66.6 0 32 34.6 32 77.3L32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 48c0 28.4 12.4 54 32 71.6L64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 256 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40.4c19.6-17.6 32-43.1 32-71.6l0-48c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 256 96 77.3z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M64 384L48.3 368.3C17.4 337.4 0 295.4 0 251.7 0 213.1 13.5 175.8 38.2 146.1L106.7 64 96 64C78.3 64 64 49.7 64 32S78.3 0 96 0L224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-10.7 0 47.6 57.1-85.9 85.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l82.3-82.3c18.7 27.3 28.7 59.7 28.7 93 0 43.7-17.4 85.7-48.3 116.6L256 384 312.2 454.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L35.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L64 384z"],
    "prescription-bottle-medical": [384, 512, ["prescription-bottle-alt"], "f486", "M0 32C0 14.3 14.3 0 32 0L352 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64L0 32zM32 144l320 0 0 304c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-304zM160 248l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "draw-polygon": [512, 512, [58055, "vector-polygon"], "f5ee", "M64 0c23.7 0 44.4 12.9 55.4 32l273.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 34-26.5 61.8-60 63.9l-2.1 2.9-71.5 99.1c3.6 8 5.6 16.9 5.6 26.2s-2 18.2-5.6 26.2l2.2 3.1 69.3 96 2.1 2.9c33.5 2.1 60 29.9 60 63.9 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-273.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-273.1C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0zM394.2 413.4l-65.5-90.6-2.2-3.1c-2.1 .2-4.3 .3-6.5 .3-35.3 0-64-28.7-64-64s28.7-64 64-64c2.2 0 4.4 .1 6.5 .3l67.7-93.7c-.6-.9-1.1-1.7-1.6-2.6L119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4l0 273.1c9.7 5.6 17.8 13.7 23.4 23.4l273.1 0c.5-.9 1.1-1.8 1.6-2.6z"],
    "i-cursor": [256, 512, [], "f246", "M.1 29.3C-1.4 47 11.7 62.4 29.3 63.9l8 .7C70.5 67.3 96 95 96 128.3l0 95.7-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 95.7c0 33.3-25.5 61-58.7 63.8l-8 .7C11.7 449.6-1.4 465 .1 482.7S17 513.4 34.7 511.9l8-.7c34.1-2.8 64.2-18.9 85.4-42.9 21.2 24 51.2 40 85.4 42.9l8 .7c17.6 1.5 33.1-11.6 34.5-29.2s-11.6-33.1-29.2-34.5l-8-.7C185.5 444.7 160 417 160 383.7l0-95.7 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-95.7c0-33.3 25.5-61 58.7-63.8l8-.7c17.6-1.5 30.7-16.9 29.2-34.5S239-1.4 221.3 .1l-8 .7c-34.1 2.8-64.2 18.9-85.4 42.9-21.2-24-51.2-40-85.4-42.9l-8-.7C17-1.4 1.6 11.7 .1 29.3z"],
    "heart-circle-plus": [576, 512, [], "e500", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 17.6-3.4 35.6-9.5 53.7-21.8-8.6-45.6-13.4-70.5-13.4-106 0-192 86-192 192 0 28.5 6.2 55.6 17.4 80-.5 0-.9 0-1.4 0-15.5 0-30.8-4.6-43.1-14.1-73-55.7-212.9-186-212.9-298.2l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"],
    "shield-dog": [512, 512, [], "e573", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM160.9 286.2c4.8 1.2 9.9 1.8 15.1 1.8 35.3 0 64-28.7 64-64l0-64 44.2 0c12.1 0 23.2 6.8 28.6 17.7l7.2 14.3 64 0c8.8 0 16 7.2 16 16l0 32c0 44.2-35.8 80-80 80l-48 0 0 50.7c0 7.3-5.9 13.3-13.3 13.3-1.8 0-3.6-.4-5.2-1.1l-98.7-42.3c-6.6-2.8-10.8-9.3-10.8-16.4 0-2.8 .6-5.5 1.9-8l15-30zM160 160l48 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-8.8 7.2-16 16-16zm128 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "greater-than-equal": [448, 512, [], "f532", "M21.9 94.4C5.1 88.8-3.9 70.6 1.7 53.9S25.4 28.1 42.1 33.6l384 128C439.2 166 448 178.2 448 192s-8.8 26-21.9 30.4l-384 128c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5L314.8 192 21.9 94.4zM416 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M64.4 175.8L256 33.9 447.6 175.8 289.5 293c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64.4 175.8zM256-32c-12.1 0-23.8 3.9-33.5 11L25.9 124.7C9.6 136.8 0 155.8 0 176.1L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-239.9c0-20.3-9.6-39.4-25.9-51.4L289.5-21c-9.7-7.2-21.4-11-33.5-11z"],
    "mound": [512, 512, [], "e52d", "M112.4 179.2C142 127.7 196.8 96 256.2 96s114.2 31.7 143.9 83.2L508.7 368c12.3 21.3-3.1 48-27.7 48L31.5 416c-24.6 0-40-26.6-27.7-48L112.4 179.2z"],
    "voicemail": [640, 512, [], "f897", "M144 160a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM263.8 320c15.3-22.9 24.2-50.4 24.2-80 0-79.5-64.5-144-144-144S0 160.5 0 240 64.5 384 144 384l352 0c79.5 0 144-64.5 144-144S575.5 96 496 96 352 160.5 352 240c0 29.6 8.9 57.1 24.2 80l-112.5 0zM496 160a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "vest": [448, 512, [], "e085", "M200 464l0-170.1c0-3.9-.5-7.8-1.4-11.6L144.4 65.4C162.1 77.2 188.2 88 224 88s61.9-10.8 79.6-22.6L249.4 282.3c-1 3.8-1.4 7.7-1.4 11.6L248 464c0 26.5 21.5 48 48 48l104 0c26.5 0 48-21.5 48-48l0-193.5c0-9.5-2.8-18.7-8.1-26.6l-47.9-71.8c-5.3-7.9-8.1-17.1-8.1-26.6L384 48c0-26.5-21.5-48-48-48l-3.5 0c-.3 0-.6 0-1 0-.6 0-1.2 0-1.8 0-18.8 0-34.1 9.7-44.1 18.8-9.3 8.4-28.5 21.2-61.7 21.2s-52.4-12.8-61.7-21.2c-10-9.1-25.3-18.8-44.1-18.8-.6 0-1.2 0-1.8 0-.3 0-.6 0-1 0L112 0C85.5 0 64 21.5 64 48l0 97.5c0 9.5-2.8 18.7-8.1 26.6L8.1 243.9C2.8 251.8 0 261.1 0 270.5L0 464c0 26.5 21.5 48 48 48l104 0c26.5 0 48-21.5 48-48z"],
    "audio-description": [512, 512, [], "f29e", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm96 96l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 48 0 0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104c0-35.3-28.7-64-64-64l-16 0c-35.3 0-64 28.7-64 64zm48 32l0-32c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 32-48 0zm152-96c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l48 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm48 144l-24 0 0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24z"],
    "w": [576, 512, [119], "57", "M20.8 34c16.5-6.2 35 2.2 41.2 18.7L172.2 346.7 257.3 55c4-13.7 16.5-23 30.7-23s26.7 9.4 30.7 23L403.8 346.7 514 52.8c6.2-16.5 24.6-24.9 41.2-18.7S580.2 58.7 574 75.2l-144 384c-4.8 12.9-17.4 21.3-31.2 20.7s-25.7-9.8-29.5-23L288 178.3 206.7 457c-3.9 13.2-15.8 22.5-29.5 23s-26.3-7.8-31.2-20.7L2 75.2C-4.2 58.7 4.2 40.2 20.8 34z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M341.6 29.2l-101.6 101.6-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 101.6-101.6c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM55.4 323.3c-15 15-23.4 35.4-23.4 56.6l0 42.4-26.6 39.9c-8.5 12.7-6.8 29.6 4 40.4s27.7 12.5 40.4 4l39.9-26.6 42.4 0c21.2 0 41.6-8.4 56.6-23.4l109.4-109.4-45.3-45.3-109.4 109.4c-3 3-7.1 4.7-11.3 4.7l-36.1 0 0-36.1c0-4.2 1.7-8.3 4.7-11.3l109.4-109.4-45.3-45.3-109.4 109.4z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM167 167c9.4-9.4 24.6-9.4 33.9 0l55 55 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 55 55c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-55-55-55 55c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l55-55-55-55c-9.4-9.4-9.4-24.6 0-33.9z"],
    "trailer": [640, 512, [], "e041", "M32 96c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 256 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-296.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8L96 416c-35.3 0-64-28.7-64-64L32 96zm408 16c-13.3 0-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24zM112 136l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24s-24 10.7-24 24zm176-24c-13.3 0-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24zM264 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "turkish-lira-sign": [448, 512, ["try", "turkish-lira"], "e2bb", "M160 32c17.7 0 32 14.3 32 32l0 43.6 121.4-34.7c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-134.6 38.5 0 46.1 121.4-34.7c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-134.6 38.5 0 162.5 72 0c53 0 96-43 96-96 0-17.7 14.3-32 32-32s32 14.3 32 32c0 88.4-71.6 160-160 160l-104 0c-17.7 0-32-14.3-32-32l0-176.2-25.4 7.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l38.6-11 0-46.1-25.4 7.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l38.6-11 0-61.9c0-17.7 14.3-32 32-32z"],
    "volcano": [512, 512, [127755], "f770", "M160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15 11.2-18.6 31.6-31 54.8-31s43.6 12.4 54.8 31c11.1-9.4 25.5-15 41.2-15 35.3 0 64 28.7 64 64s-28.7 64-64 64c-14.7 0-28.3-5-39.1-13.3l-32 48C275.3 187 266 192 256 192s-19.3-5-24.9-13.3l-32-48C188.3 139 174.7 144 160 144zM144 352l48.4-24.2c10.2-5.1 21.6-7.8 33-7.8 19.6 0 38.4 7.8 52.2 21.6l32.5 32.5c6.3 6.3 14.9 9.9 23.8 9.9 11.3 0 21.8-5.6 28-15l9.7-14.6-59-66.3c-9.1-10.2-22.2-16.1-35.9-16.1l-41.8 0c-13.7 0-26.8 5.9-35.9 16.1l-59.9 67.4 4.7-3.5zm19.4-95.8c18.2-20.5 44.3-32.2 71.8-32.2l41.8 0c27.4 0 53.5 11.7 71.8 32.2l150.2 169c8.5 9.5 13.2 21.9 13.2 34.7 0 28.8-23.4 52.2-52.2 52.2L52.2 512C23.4 512 0 488.6 0 459.8 0 447.1 4.7 434.7 13.2 425.2l150.2-169z"],
    "wand-sparkles": [512, 512, [], "f72b", "M464 6.1c9.5-8.5 24-8.1 33 .9l8 8c9 9 9.4 23.5 .9 33l-85.8 95.9c-2.6 2.9-4.1 6.7-4.1 10.7l0 21.4c0 8.8-7.2 16-16 16l-15.8 0c-4.6 0-8.9 1.9-11.9 5.3L100.7 500.9c-6.3 7.1-15.3 11.1-24.8 11.1-8.8 0-17.3-3.5-23.5-9.8L9.7 459.7c-6.2-6.2-9.7-14.7-9.7-23.5 0-9.5 4-18.5 11.1-24.8l111.6-99.8c3.4-3 5.3-7.4 5.3-11.9l0-27.6c0-8.8 7.2-16 16-16l34.6 0c3.9 0 7.7-1.5 10.7-4.1L464 6.1zM432 288c3.6 0 6.7 2.4 7.7 5.8l14.8 51.7 51.7 14.8c3.4 1 5.8 4.1 5.8 7.7s-2.4 6.7-5.8 7.7l-51.7 14.8-14.8 51.7c-1 3.4-4.1 5.8-7.7 5.8s-6.7-2.4-7.7-5.8l-14.8-51.7-51.7-14.8c-3.4-1-5.8-4.1-5.8-7.7s2.4-6.7 5.8-7.7l51.7-14.8 14.8-51.7c1-3.4 4.1-5.8 7.7-5.8zM87.7 69.8l14.8 51.7 51.7 14.8c3.4 1 5.8 4.1 5.8 7.7s-2.4 6.7-5.8 7.7l-51.7 14.8-14.8 51.7c-1 3.4-4.1 5.8-7.7 5.8s-6.7-2.4-7.7-5.8L57.5 166.5 5.8 151.7c-3.4-1-5.8-4.1-5.8-7.7s2.4-6.7 5.8-7.7l51.7-14.8 14.8-51.7c1-3.4 4.1-5.8 7.7-5.8s6.7 2.4 7.7 5.8zM208 0c3.7 0 6.9 2.5 7.8 6.1l6.8 27.3 27.3 6.8c3.6 .9 6.1 4.1 6.1 7.8s-2.5 6.9-6.1 7.8l-27.3 6.8-6.8 27.3c-.9 3.6-4.1 6.1-7.8 6.1s-6.9-2.5-7.8-6.1l-6.8-27.3-27.3-6.8c-3.6-.9-6.1-4.1-6.1-7.8s2.5-6.9 6.1-7.8l27.3-6.8 6.8-27.3c.9-3.6 4.1-6.1 7.8-6.1z"],
    "microphone": [384, 512, [], "f130", "M192 0C139 0 96 43 96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96zM48 184c0-13.3-10.7-24-24-24S0 170.7 0 184l0 40c0 97.9 73.3 178.7 168 190.5l0 49.5-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-49.5c94.7-11.8 168-92.6 168-190.5l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 79.5-64.5 144-144 144S48 303.5 48 224l0-40z"],
    "crown": [576, 512, [128081], "f521", "M313 87.2c9.2-7.3 15-18.6 15-31.2 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 12.6 5.9 23.9 15 31.2L194.6 194.8c-10 15.7-31.3 19.6-46.2 8.4L88.9 158.7c4.5-6.4 7.1-14.3 7.1-22.7 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 21.8 17.5 39.6 39.2 40L87.8 393.5c4.7 31.3 31.6 54.5 63.3 54.5l273.8 0c31.7 0 58.6-23.2 63.3-54.5L520.8 176c21.7-.4 39.2-18.2 39.2-40 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 8.4 2.6 16.3 7.1 22.7l-59.4 44.6c-14.9 11.2-36.2 7.3-46.2-8.4L313 87.2z"],
    "tent-arrow-turn-left": [512, 512, [], "e580", "M-.5 113l72 72c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-31-31 350.1 0c22.1 0 40 17.9 40 40l0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24c0-48.6-39.4-88-88-88l-350.1 0 31-31c9.4-9.4 9.4-24.6 0-33.9S80.9-2.3 71.5 7L-.5 79c-9.4 9.4-9.4 24.6 0 33.9zM60.3 292.6L37.1 476c-2.4 19.1 12.5 36 31.7 36l154.5 0c17.7 0 32-14.3 32-32l0-117.4c0-5.9 4.7-10.6 10.6-10.6 4 0 7.7 2.3 9.5 5.9l68.2 136.5c5.4 10.8 16.5 17.7 28.6 17.7l71.9 0c19.3 0 34.2-16.9 31.7-36L452.7 292.7c-1.2-9.7-6.9-18.4-15.3-23.4L271.9 169.9c-10.2-6.1-22.9-6.1-33.1 .1L75.4 269.3c-8.3 5.1-13.9 13.7-15.1 23.3z"],
    "truck-fast": [640, 512, ["shipping-fast"], "f48b", "M64 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 32 50.7 0c17 0 33.3 6.7 45.3 18.7L621.3 192c12 12 18.7 28.3 18.7 45.3L640 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-3.3 0c-35.3 0-64-28.7-64-64l0-48-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 240c-13.3 0-24-10.7-24-24s10.7-24 24-24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 144c-13.3 0-24-10.7-24-24S10.7 96 24 96l40 0zM576 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM256 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "user-pen": [640, 512, ["user-edit"], "f4ff", "M256.1 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56c-98.5 0-178.3 79.8-178.3 178.3 0 16.4 13.3 29.7 29.7 29.7l196.5 0 10.9-54.5c4.3-21.7 15-41.6 30.6-57.2l67.3-67.3c-28-18.3-61.4-28.9-97.4-28.9l-59.4 0zM332.3 466.9l-11.9 59.6c-.2 .9-.3 1.9-.3 2.9 0 8 6.5 14.6 14.6 14.6 1 0 1.9-.1 2.9-.3l59.6-11.9c12.4-2.5 23.8-8.6 32.7-17.5l118.9-118.9-80-80-118.9 118.9c-8.9 8.9-15 20.3-17.5 32.7zm267.8-123c22.1-22.1 22.1-57.9 0-80s-57.9-22.1-80 0l-28.8 28.8 80 80 28.8-28.8z"],
    "user-clock": [576, 512, [], "f4fd", "M224 8a120 120 0 1 1 0 240 120 120 0 1 1 0-240zM194.3 304l59.4 0c3.9 0 7.9 .1 11.8 .4-16.2 28.2-25.5 60.8-25.5 95.6 0 41.8 13.4 80.5 36 112L45.7 512C29.3 512 16 498.7 16 482.3 16 383.8 95.8 304 194.3 304zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16z"],
    "shower": [512, 512, [128703], "f2cc", "M64 131.9c0-19.8 16.1-35.9 35.9-35.9 9.5 0 18.6 3.8 25.4 10.5l16.2 16.2c-21 38.9-17.4 87.5 10.9 123L151 247c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L345 121c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-1.3 1.3c-35.5-28.3-84.1-31.9-123-10.9L170.5 61.3C151.8 42.5 126.4 32 99.9 32 44.7 32 0 76.7 0 131.9L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-316.1zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 160c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9S337.5 320 328 320l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"],
    "map-location": [640, 512, ["map-marked"], "f59f", "M576 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L413.5 77.5 234.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C70.8 88.8 64 99.9 64 112l0 352c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 173.3 57.8c-4.3-6.4-8.5-13.1-12.6-19.9-11-18.3-21.9-39.3-30-61.8l-101.2-33.7 0-284.5 128 42.7 0 99.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 48zM392 341.9c0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9S392 276.8 392 341.9z"],
    "pen-fancy": [512, 512, [128395, 10002], "f5ac", "M373.5 27.1c15-17.2 36.7-27.1 59.6-27.1 43.6 0 79 35.4 79 79 0 22.8-9.9 44.6-27.1 59.6L283.7 313.8 273 303 209 239 198.2 228.3 373.5 27.1zM161.1 259C162 260 188 286 239 337l13.9 13.9-17.1 74.2c-3.9 17.1-16.9 30.7-33.8 35.4l-169.8 47.5 92.3-92.3c1.2 .1 2.3 .2 3.5 .2 17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32c0 1.2 .1 2.4 .2 3.5L3.9 479.8 51.5 310c4.7-16.9 18.3-29.9 35.4-33.8L161.1 259z"],
    "euro-sign": [448, 512, [8364, "eur", "euro"], "f153", "M73.3 192C100.8 99.5 186.5 32 288 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-65.6 0-122 39.5-146.7 96L272 192c13.3 0 24 10.7 24 24s-10.7 24-24 24l-143.2 0c-.5 5.3-.8 10.6-.8 16s.3 10.7 .8 16L272 272c13.3 0 24 10.7 24 24s-10.7 24-24 24l-130.7 0c24.7 56.5 81.1 96 146.7 96l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-101.5 0-187.2-67.5-214.7-160L40 320c-13.3 0-24-10.7-24-24s10.7-24 24-24l24.6 0c-.7-10.5-.7-21.5 0-32L40 240c-13.3 0-24-10.7-24-24s10.7-24 24-24l33.3 0z"],
    "house-circle-xmark": [640, 512, [], "e50b", "M496 544a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l217.6 202c-10.2-1.7-20.7-2.6-31.3-2.6-78.6 0-146.2 47.2-175.9 114.8-5-1.8-10.5-2.8-16.1-2.8l-32 0c-26.5 0-48 21.5-48 48l0 96 90.9 0c6.1 17.3 14.6 33.4 25.2 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM555.3 340.7c-6.2-6.2-16.4-6.2-22.6 0l-36.7 36.7-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l36.7 36.7-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l36.7-36.7 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-36.7-36.7 36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"],
    "lira-sign": [384, 512, [8356], "f195", "M84.9 256l-28.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11.6 0C53.2 124.7 116.8 42 207.6 42l8.2 0c33.6 0 66.2 11.3 92.5 32.2l16.1 12.7c13.9 11 16.2 31.1 5.2 45s-31.1 16.2-45 5.2l-16.1-12.7c-15-11.9-33.6-18.4-52.8-18.4l-8.2 0c-53.8 0-90.1 52.9-73.5 102l162.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-145.1 0c2.3 10.6 3.6 21.3 3.9 32l141.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L150 336c-4.8 18.6-12.6 36.5-23.6 52.9l-18.1 27.1 212.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-272 0c-11.8 0-22.6-6.5-28.2-16.9s-5-23 1.6-32.9l51.2-76.8c3.7-5.6 6.9-11.4 9.4-17.4l-26 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l34.8 0c-.5-10.8-2.6-21.6-6.4-32z"],
    "yen-sign": [384, 512, [165, "cny", "jpy", "rmb", "yen"], "f157", "M74.9 46.7c-9.6-14.9-29.4-19.2-44.2-9.6S11.5 66.4 21.1 81.3L143.7 272 88 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 32-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0 0-32 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-55.7 0 122.6-190.7c9.6-14.9 5.3-34.7-9.6-44.2s-34.7-5.3-44.2 9.6L192 228.8 74.9 46.7z"],
    "box-open": [640, 512, [], "f49e", "M560.3 237.2c10.4 11.8 28.3 14.4 41.8 5.5 14.7-9.8 18.7-29.7 8.9-44.4l-48-72c-2.8-4.2-6.6-7.7-11.1-10.2L351.4 4.7c-19.3-10.7-42.8-10.7-62.2 0L88.8 116c-5.4 3-9.7 7.4-12.6 12.8L27.7 218.7c-12.6 23.4-3.8 52.5 19.6 65.1l33 17.7 0 53.3c0 23 12.4 44.3 32.4 55.7l176 99.7c19.6 11.1 43.5 11.1 63.1 0l176-99.7c20.1-11.4 32.4-32.6 32.4-55.7l0-117.5zm-240-9.8L170.2 144 320.3 60.6 470.4 144 320.3 227.4zm-41.5 50.2l-21.3 46.2-165.8-88.8 25.4-47.2 161.7 89.8z"],
    "truck-field": [640, 512, [], "e58d", "M32 96c0-35.3 28.7-64 64-64l224 0c23.7 0 44.4 12.9 55.4 32l40.4 0c32.4 0 61.6 19.6 74 49.5l43.8 106.3 1.7 4.2 24.7 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-144.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-3.6 .2-7.1 .6-10.5-19-6.4-32.6-24.4-32.6-45.5l0-48c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l0-32zm352 32l0 96 82.1 0-35.4-86.1c-2.5-6-8.3-9.9-14.8-9.9L384 128zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm280 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "location-pin-lock": [512, 512, [], "e51f", "M0 188.6C0 84.4 86 0 192 0 294.1 0 377.6 78.3 383.6 177 320.7 185.1 272 238.8 272 304l0 24.4c-19.6 17.6-32 43.1-32 71.5l0 75.7c-9.9 11.6-18.9 21.7-26.4 29.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM192 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm240 48.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM288 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "person-praying": [384, 512, [128720, "pray"], "f683", "M320 64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM200.7 264l22.9 31.5c6.5 8.9 16.3 14.7 27.2 16.1s21.9-1.7 30.4-8.7l88-72c17.1-14 19.6-39.2 5.6-56.3s-39.2-19.6-56.3-5.6l-55.2 45.2-26.2-36c-15.6-21.5-40.6-34.2-67.2-34.2-30.9 0-59.2 17.1-73.6 44.4L47.8 280.9c-20.2 38.5-9.4 85.9 25.6 111.8L126.6 432 40 432c-22.1 0-40 17.9-40 40s17.9 40 40 40l208 0c17.3 0 32.6-11.1 38-27.5s-.3-34.4-14.2-44.7l-116.1-85.8 45-90z"],
    "clipboard-list": [384, 512, [], "f46d", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 0c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24zm0 128c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24zM96 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "sack-dollar": [512, 512, [128176], "f81d", "M328 112l-144 0-37.3-74.5c-1.8-3.6-2.7-7.6-2.7-11.6 0-14.3 11.6-25.9 25.9-25.9L342.1 0c14.3 0 25.9 11.6 25.9 25.9 0 4-.9 8-2.7 11.6L328 112zM169.6 160l172.8 0 48.7 40.6C457.6 256 496 338 496 424.5 496 472.8 456.8 512 408.5 512l-305.1 0C55.2 512 16 472.8 16 424.5 16 338 54.4 256 120.9 200.6L169.6 160zM260 224c-11 0-20 9-20 20l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L216 384c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l47.5 0c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20z"],
    "mountain-sun": [576, 512, [], "e52f", "M256.5 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5-7.2 12.1-20.3 19.5-34.3 19.5l-432 0c-14.1 0-27.1-7.4-34.3-19.5s-7.5-27.1-.8-39.5l216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0zM170.4 249.9l26.8 26.8c6.2 6.2 16.4 6.2 22.6 0l43.3-43.3c6-6 14.1-9.4 22.6-9.4l42.8 0-72.1-133.5-86.1 159.4zM496.5 160a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96zM320 480l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 32c-17.7 0-32 14.3-32 32s14.3 32 32 32z"],
    "users-line": [576, 512, [], "e592", "M224 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM176 336c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 13.3-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24l0-8zM392 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm27.2 100.4c9.1-2.9 18.8-4.4 28.8-4.4 53 0 96 43 96 96l0 10.7c0 11.8-9.6 21.3-21.3 21.3l-78.8 0c2.7-7.5 4.1-15.6 4.1-24l0-8c0-34.1-10.6-65.7-28.8-91.6zm-262.4 0c-18.2 26-28.8 57.5-28.8 91.6l0 8c0 8.4 1.4 16.5 4.1 24l-78.8 0C41.6 368 32 358.4 32 346.7L32 336c0-53 43-96 96-96 10 0 19.7 1.5 28.8 4.4zM72 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM0 440c0-13.3 10.7-24 24-24l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 464c-13.3 0-24-10.7-24-24z"],
    "star-of-david": [512, 512, [10017], "f69a", "M415.9 311.9l-27.8 48.1 55.7 0-27.8-48.1zM383.6 256l-60.2-104-134.8 0-60.2 104 60.2 104 134.8 0 60.2-104zm64.7 0l58.4 100.9c3.5 6 5.3 12.8 5.3 19.7 0 21.7-17.6 39.4-39.4 39.4l-117 0-61.3 105.8C286.5 535.6 271.8 544 256 544s-30.5-8.4-38.4-22.2l-61.3-105.8-117 0c-21.7 0-39.4-17.6-39.4-39.4 0-6.9 1.8-13.7 5.3-19.7L63.7 256 5.3 155.1C1.8 149.1 0 142.3 0 135.4 0 113.6 17.6 96 39.4 96l117 0 61.3-105.8C225.5-23.6 240.2-32 256-32s30.5 8.4 38.4 22.2l61.3 105.8 117 0c21.7 0 39.4 17.6 39.4 39.4 0 6.9-1.8 13.7-5.3 19.7L448.3 256zM388.1 152l27.8 48.1 27.8-48.1-55.7 0zM291 96l-35-60.4-35 60.4 70 0zM123.9 152l-55.7 0 27.8 48.1 27.8-48.1zM96.1 311.9l-27.8 48.1 55.7 0-27.8-48.1zM221 416l35 60.4 35-60.4-70 0z"],
    "notes-medical": [512, 512, [], "f481", "M96 352c0 35.3 28.7 64 64 64l181.5 0c17 0 33.3-6.7 45.3-18.7L493.3 290.7c12-12 18.7-28.3 18.7-45.3L512 64c0-35.3-28.7-64-64-64L160 0C124.7 0 96 28.7 96 64l0 288zM288 112l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 448c0 35.3 28.7 64 64 64l264 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 464c-8.8 0-16-7.2-16-16l0-328z"],
    "austral-sign": [448, 512, [], "e0a9", "M266.5 240l-85 0 42.5-106.4 42.5 106.4zm68.9 0L262.9 58.3C256.5 42.4 241.1 32 224 32s-32.5 10.4-38.9 26.3L112.6 240 32 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l61.4 0-19.2 48-42.3 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l23.1 0-20.8 52.1c-6.6 16.4 1.4 35 17.9 41.6s35-1.4 41.6-17.9l30.3-75.9 200 0 30.3 75.9c6.6 16.4 25.2 24.4 41.6 17.9s24.4-25.2 17.9-41.6L392.9 384 416 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-42.3 0-19.2-48 61.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80.6 0zm-49.7 48l19.2 48-161.6 0 19.2-48 123.3 0z"],
    "clipboard-user": [384, 512, [], "f7f3", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zM192 344a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM98.3 413c-12.9 15.6 2.2 35 22.4 35l142.5 0c20.2 0 35.3-19.4 22.4-35-14.7-17.7-36.9-29-61.7-29l-64 0c-24.8 0-47 11.3-61.7 29z"],
    "file-image": [384, 512, [128443], "f1c5", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM92.6 448l198.8 0c15.8 0 28.6-12.8 28.6-28.6 0-7.3-2.8-14.4-7.9-19.7L215.3 297.9c-6-6.3-14.4-9.9-23.2-9.9l-.3 0c-8.8 0-17.1 3.6-23.2 9.9L71.9 399.7C66.8 405 64 412.1 64 419.4 64 435.2 76.8 448 92.6 448z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4S160 369.5 160 360l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z"],
    "vial": [512, 512, [129514], "f492", "M342.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L306.7 64 28.1 342.6C10.1 360.6 0 385 0 410.5L0 416c0 53 43 96 96 96l5.5 0c25.5 0 49.9-10.1 67.9-28.1l278.6-278.6 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160zM205.3 256l146.7-146.7 50.7 50.7-96 96-101.5 0z"],
    "helicopter": [576, 512, [128641], "f533", "M176 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0 0 48-220.8 0-32.8-39.4C69.9 83.2 63.1 80 56 80L24 80C15.7 80 8 84.3 3.6 91.4s-4.8 15.9-1.1 23.4l48 96C54.6 218.9 62.9 224 72 224l107.8 0 104 143.1c15.1 20.7 39.1 32.9 64.7 32.9l75.5 0c75.1 0 136-60.9 136-136S499.1 128 424 128l-48 0 0-48 152 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L176 32zM376 192l48 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-48 0 0-144zM552 416c-13.3 0-24 10.7-24 24 0 4.4-3.6 8-8 8l-272 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c30.9 0 56-25.1 56-56 0-13.3-10.7-24-24-24z"],
    "mitten": [448, 512, [], "f7b5", "M352 384L64 384 5.4 178.9C1.8 166.4 0 153.4 0 140.3 0 62.8 62.8 0 140.3 0l3.4 0c66 0 123.5 44.9 139.5 108.9l31.4 125.8 17.6-20.1C344.8 200.2 362.9 192 382 192l2.8 0c34.9 0 63.3 28.3 63.3 63.3 0 15.9-6 31.2-16.8 42.9L352 384zM32 464c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32l0-16z"],
    "gas-pump": [512, 512, [9981], "f52f", "M32 64C32 28.7 60.7 0 96 0L256 0c35.3 0 64 28.7 64 64l0 192 8 0c48.6 0 88 39.4 88 88l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-154c-27.6-7.1-48-32.2-48-62l0-59.5-25.8-28.3c-8.9-9.8-8.2-25 1.6-33.9s25-8.2 33.9 1.6l71.7 78.8c9.4 10.3 14.6 23.7 14.6 37.7L512 376c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-32c0-22.1-17.9-40-40-40l-8 0 0 161.4c9.3 3.3 16 12.2 16 22.6 0 13.3-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24 0-10.5 6.7-19.3 16-22.6L32 64zM96 80l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L112 64c-8.8 0-16 7.2-16 16z"],
    "envelope-circle-check": [640, 512, [], "e4e8", "M64 112c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 81.4c-24.4-11.2-51.4-17.4-80-17.4-87.7 0-161.7 58.8-184.7 139.2-7.1-1.3-14.1-4.2-20.1-8.8l-208-156C71.1 141.3 64 127.1 64 112zM304 368c0 28.6 6.2 55.6 17.4 80L128 448c-35.3 0-64-28.7-64-64l0-188 198.4 148.8c12.6 9.4 26.9 15.4 41.7 17.9 0 1.8-.1 3.5-.1 5.3zm48 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "person-skating": [512, 512, ["skating"], "f7c5", "M368 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM128 128c0-17.7 14.3-32 32-32l150.1 0c49.9 0 74.9 60.3 39.6 95.6l-63.9 63.9 69.8 31c17.3 7.7 28.5 24.9 28.5 43.9l0 85.6c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-75.2-82.4-36.6c-41-18.2-51-72-19.3-103.7l40.4-40.4-98.7 0c-17.7 0-32-14.3-32-32zM89.4 361.4l75.9-75.9c7.7 19.7 21.6 37.3 41 49.6l-71.6 71.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3zm346.5 87.1c8.6 2.1 13.8 10.8 11.6 19.4l-.4 1.7c-6.2 24.9-28.6 42.4-54.3 42.4L304 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l88.8 0c11 0 20.6-7.5 23.3-18.2l.4-1.7c2.1-8.6 10.8-13.8 19.4-11.6zM143.2 486.3l-6.2 3.1c-21.6 10.8-47.6 6.6-64.6-10.5L12.7 419.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l59.6 59.6c7.3 7.3 18.5 9.1 27.7 4.5l6.2-3.1c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5z"],
    "sun": [576, 512, [9728], "f185", "M178.2-10.1c7.4-3.1 15.8-2.2 22.5 2.2l87.8 58.2 87.8-58.2c6.7-4.4 15.1-5.2 22.5-2.2S411.4-.5 413 7.3l20.9 103.2 103.2 20.9c7.8 1.6 14.4 7 17.4 14.3s2.2 15.8-2.2 22.5l-58.2 87.8 58.2 87.8c4.4 6.7 5.2 15.1 2.2 22.5s-9.6 12.8-17.4 14.3L433.8 401.4 413 504.7c-1.6 7.8-7 14.4-14.3 17.4s-15.8 2.2-22.5-2.2l-87.8-58.2-87.8 58.2c-6.7 4.4-15.1 5.2-22.5 2.2s-12.8-9.6-14.3-17.4L143 401.4 39.7 380.5c-7.8-1.6-14.4-7-17.4-14.3s-2.2-15.8 2.2-22.5L82.7 256 24.5 168.2c-4.4-6.7-5.2-15.1-2.2-22.5s9.6-12.8 17.4-14.3L143 110.6 163.9 7.3c1.6-7.8 7-14.4 14.3-17.4zM207.6 256a80.4 80.4 0 1 1 160.8 0 80.4 80.4 0 1 1 -160.8 0zm208.8 0a128.4 128.4 0 1 0 -256.8 0 128.4 128.4 0 1 0 256.8 0z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M232.4 1.1c-122.2 11.4-219.5 108.7-230.9 230.9 16.2-.1 32-1.8 47.2-5 13-2.7 25.7 5.5 28.4 18.5s-5.5 25.7-18.5 28.4c-18.4 3.9-37.6 6-57.1 6.1 11.4 122.2 108.7 219.5 230.9 230.9 .1-19.5 2.2-38.7 6.1-57.1 2.7-13 15.5-21.3 28.4-18.5s21.3 15.5 18.5 28.4c-3.2 15.2-4.9 31-5 47.2 122.2-11.4 219.5-108.7 230.9-230.9-16.2 .1-32 1.8-47.2 5-13 2.7-25.7-5.5-28.4-18.5s5.5-25.7 18.5-28.4c18.4-3.9 37.6-6 57.1-6.1-11.4-122.2-108.7-219.5-230.9-230.9-.1 19.5-2.2 38.7-6.1 57.1-2.7 13-15.5 21.3-28.4 18.5s-21.3-15.5-18.5-28.4c3.2-15.2 4.9-31 5-47.2zm2.8 151.4c-21.4 32.9-49.5 60.9-82.3 82.3-11.1 7.2-26 4.1-33.2-7s-4.1-26 7-33.2c27.2-17.7 50.5-41 68.3-68.3 7.2-11.1 22.1-14.3 33.2-7s14.3 22.1 7 33.2zM393.1 284.2c7.2 11.1 4.1 26-7 33.2-27.2 17.7-50.5 41-68.3 68.3-7.2 11.1-22.1 14.3-33.2 7s-14.3-22.1-7-33.2c21.4-32.9 49.5-60.9 82.3-82.3 11.1-7.2 26-4.1 33.2 7z"],
    "image": [448, 512, [], "f03e", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM272 224c8.4 0 16.1 4.4 20.5 11.5l88 144c4.5 7.4 4.7 16.7 .5 24.3S368.7 416 360 416L88 416c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l26.4 37.8 61.4-100.5c4.4-7.1 12.1-11.5 20.5-11.5z"],
    "notdef": [384, 512, [], "e1fe", "M64 390.3L153.5 256 64 121.7 64 390.3zM102.5 448L281.5 448 192 313.7 102.5 448zm128-192L320 390.3 320 121.7 230.5 256zM281.5 64L102.5 64 192 198.3 281.5 64zM0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 48z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M92.7 58.8l78.4 78.4c18.2-25 28.9-55.9 28.9-89.2 0-14.1-1.9-27.7-5.5-40.6-38 9.4-72.6 27.2-101.8 51.4zM58.8 92.7c-24.2 29.2-42 63.8-51.4 101.8 12.9 3.6 26.5 5.5 40.6 5.5 33.3 0 64.1-10.7 89.2-28.9L58.8 92.7zM256 0c-4.6 0-9.2 .1-13.7 .4 3.7 15.3 5.7 31.2 5.7 47.6 0 46.6-15.9 89.4-42.6 123.4L256 222.1 419.3 58.8C374.9 22.1 318.1 0 256 0zM48 248c-16.4 0-32.4-2-47.6-5.7-.2 4.5-.4 9.1-.4 13.7 0 62.1 22.1 118.9 58.8 163.3L222.1 256 171.4 205.4C137.4 232.1 94.6 248 48 248zm463.6 21.7c.2-4.5 .4-9.1 .4-13.7 0-62.1-22.1-118.9-58.8-163.3L289.9 256 340.6 306.6c34-26.7 76.9-42.6 123.4-42.6 16.4 0 32.4 2 47.6 5.7zm-7.1 47.8c-12.9-3.6-26.5-5.5-40.6-5.5-33.3 0-64.1 10.7-89.2 28.9l78.4 78.4c24.2-29.2 42-63.8 51.4-101.8zM340.9 374.8c-18.2 25-28.9 55.9-28.9 89.2 0 14.1 1.9 27.7 5.5 40.6 38-9.4 72.6-27.2 101.8-51.4l-78.4-78.4zm-34.3-34.3L256 289.9 92.7 453.2c44.3 36.7 101.2 58.8 163.3 58.8 4.6 0 9.2-.1 13.7-.4-3.7-15.3-5.7-31.2-5.7-47.6 0-46.6 15.9-89.4 42.6-123.4z"],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", "M36.4 353.2c4.1-14.6 11.8-27.9 22.6-38.7l181.2-181.2 33.9-33.9c16.6 16.6 51.3 51.3 104 104l33.9 33.9-33.9 33.9-181.2 181.2c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 510.6c-8.3 2.3-17.3 0-23.4-6.2S-1.4 489.3 .9 481L36.4 353.2zm55.6-3.7c-4.4 4.7-7.6 10.4-9.3 16.6l-24.1 86.9 86.9-24.1c6.4-1.8 12.2-5.1 17-9.7L91.9 349.5zm354-146.1c-16.6-16.6-51.3-51.3-104-104L308 65.5C334.5 39 349.4 24.1 352.9 20.6 366.4 7 384.8-.6 404-.6S441.6 7 455.1 20.6l35.7 35.7C504.4 69.9 512 88.3 512 107.4s-7.6 37.6-21.2 51.1c-3.5 3.5-18.4 18.4-44.9 44.9z"],
    "person-walking-arrow-loop-left": [640, 512, [], "e551", "M160 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM73.4 227.9l22.6-22.6 0 69.3c0 28 12.2 54.7 33.5 72.9l71.4 61.2c5.9 5.1 9.8 12.1 10.9 19.8l12.6 88.1c2.5 17.5 18.7 29.7 36.2 27.2s29.7-18.7 27.2-36.2l-12.6-88.1c-3.3-23.1-14.9-44.1-32.6-59.3l-34.5-29.6 0-115.2 3.8 4.7c18.2 22.8 45.8 36 75 36l33.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-33.2 0c-9.7 0-18.9-4.4-25-12l-17.9-22.4c-23-28.8-57.9-45.6-94.8-45.6-32.2 0-63.1 12.8-85.8 35.6L28.1 182.6C10.1 200.6 0 225 0 250.5L0 288c0 17.7 14.3 32 32 32s32-14.3 32-32l0-37.5c0-8.5 3.4-16.6 9.4-22.6zM85.8 407.3c-1.5 5.2-4.3 10-8.1 13.8L9.4 489.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.3-68.3c11.5-11.5 19.9-25.8 24.4-41.5l2.2-7.6-46-39.4c-2.5-2.2-5-4.4-7.4-6.8L85.8 407.3zM359 335c-9.4 9.4-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-31-31 102.1 0c1.2 0 2.4-.1 3.5-.3 56.1-3.9 100.5-50.6 100.5-107.7 0-59.6-48.4-108-108-108l-92 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l92 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-98.1 0 31-31c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-72 72z"],
    "dice-six": [448, 512, [9861], "f526", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M214.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 402.7 329.4 265.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-160 160zm160-352l-160 160c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 210.7 329.4 73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"],
    "syringe": [576, 512, [128137], "f48e", "M497.5-17c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l15 15-46.1 46.1-63-63c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l7 7-78.1 78.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41-41-46.1 46.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41-41-37.7 37.7c-10.5 10.5-16.4 24.7-16.4 39.6l0 88.8-57 57c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l57-57 88.8 0c14.9 0 29.1-5.9 39.6-16.4l229.7-229.7 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63-63 46.1-46.1 15 15c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"],
    "wheat-awn": [576, 512, ["wheat-alt"], "e2cd", "M79.7 234.6c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0L134.1 444.3 49.4 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zm104-104c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zM495.2 15c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.2L529.2 49 414.7 163.4c7.7 1 15.2 3 22.5 5.9L495.5 111c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.1l-1.7 1.8-52.7 52.7 39 39c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1l39 39 52.7-52.7c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.1l-1.7 1.8-58.3 58.3c2.8 7.1 4.7 14.5 5.7 22.1L495.2 15z"],
    "plane-up": [512, 512, [], "e22d", "M200 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 173.6 159.2c6.6 6.1 10.4 14.6 10.4 23.6l0 43.7c0 10.9-10.7 18.6-21.1 15.2l-162.9-54.3 0 99.7 66 52.8c3.8 3 6 7.6 6 12.5l0 19.8c0 10.4-9.8 18-19.9 15.5L256 512 147.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C26.7 396.4 16 388.7 16 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L200 151.3 200 24z"],
    "align-center": [448, 512, [], "f037", "M352 64c0-17.7-14.3-32-32-32L128 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32zm96 128c0-17.7-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM0 448c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32zM352 320c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32z"],
    "hockey-puck": [512, 512, [], "f453", "M256 256C114.6 256 0 213 0 160s114.6-96 256-96 256 43 256 96-114.6 96-256 96zM0 352L0 242.7c16.9 12.3 37 22.2 58.1 30.1 53 19.9 123 31.2 197.9 31.2s144.9-11.3 197.9-31.2c21.2-7.9 41.2-17.8 58.1-30.1L512 352c0 53-114.6 96-256 96S0 405 0 352z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM135 239l80-80c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-39 39 150.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-150.1 0 39 39c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9z"],
    "plug-circle-bolt": [640, 512, [], "e55b", "M192-32c17.7 0 32 14.3 32 32l0 96 128 0 0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 3.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.7C165.2 398.1 96 319.1 96 224l0-64c-17.7 0-32-14.3-32-32S78.3 96 96 96l64 0 0-96c0-17.7 14.3-32 32-32zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm177.4-77c-5.8-4.2-13.8-4-19.4 .5l-80 64c-5.3 4.2-7.4 11.4-5.1 17.8S433.2 416 440 416l32.9 0-15.9 42.4c-2.5 6.7-.2 14.3 5.6 18.6s13.8 4 19.4-.5l80-64c5.3-4.2 7.4-11.4 5.1-17.8S558.8 384 552 384l-32.9 0 15.9-42.4c2.5-6.7 .2-14.3-5.6-18.6z"],
    "restroom": [640, 512, [], "f7bd", "M80 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-154.8c-8.1 9.2-21.1 13.2-33.5 9.4-16.9-5.3-26.3-23.2-21-40.1l29.7-95.2C44.4 156.9 83.6 128 128 128s83.6 28.9 96.8 71.2l29.7 95.2c5.3 16.9-4.1 34.8-21 40.1-12.4 3.9-25.4-.2-33.5-9.4L200 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0zM320 0c13.3 0 24 10.7 24 24l0 464c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-464c0-13.3 10.7-24 24-24zM464 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM440 480l0-96-17.8 0c-10.9 0-18.6-10.7-15.2-21.1l9-26.9c-3.2 0-6.4-.5-9.5-1.5-16.9-5.3-26.3-23.2-21-40.1l29.7-95.2C428.4 156.9 467.6 128 512 128s83.6 28.9 96.8 71.2l29.7 95.2c5.3 16.9-4.1 34.8-21 40.1-3.2 1-6.4 1.5-9.5 1.5l9 26.9c3.5 10.4-4.3 21.1-15.2 21.1l-17.8 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-16 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32z"],
    "anchor-lock": [640, 512, [], "e4ad", "M320.5 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 257.9c-62.9-14.3-110.2-69.7-111.9-136.5l16.1 14.1c10 8.7 25.1 7.7 33.9-2.3s7.7-25.1-2.3-33.9l-64-56c-9-7.9-22.6-7.9-31.6 0l-64 56c-10 8.7-11 23.9-2.3 33.9s23.9 11 33.9 2.3l16.2-14.2c2.1 113.1 94.4 204.1 208 204.1 28.3 0 55.4-5.7 80-15.9l0-.2 0-72.2c-14.4 9.6-30.6 16.7-48 20.7l0-257.9c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zm272 304.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416.5 400l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "timeline": [576, 512, [], "e29c", "M160 169.3c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3l0 54.7-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0 0 54.7c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-54.7 224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-54.7c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3l0 54.7-256 0 0-54.7z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M292.9 384c7.3-22.3 21.9-42.5 38.4-59.9 32.7-34.4 52.7-80.9 52.7-132.1 0-106-86-192-192-192S0 86 0 192c0 51.2 20 97.7 52.7 132.1 16.5 17.4 31.2 37.6 38.4 59.9l201.7 0zM288 432l-192 0 0 16c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-16zM184 112c-39.8 0-72 32.2-72 72 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3 53.7-120 120-120 13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm41-159c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39-150.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l150.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80z"],
    "mars-and-venus": [512, 512, [9893], "f224", "M368 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l112 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-34.7-63 63c19.5 28.4 31 62.7 31 99.8 0 86.3-62.1 158.1-144 173.1l0 34.9 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-34.9c-81.9-15-144-86.8-144-173.1 0-97.2 78.8-176 176-176 37 0 71.4 11.4 99.8 31l63-63-34.7 0zM352 208a112 112 0 1 0 -224 0 112 112 0 1 0 224 0z"],
    "network-wired": [576, 512, [], "f6ff", "M248 88l80 0 0 48-80 0 0-48zm-8-56c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l16 0 0 32-224 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 0 32-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0 0-32 192 0 0 32-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0 0-32 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-224 0 0-32 16 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-96 0zM448 376l8 0 0 48-80 0 0-48 72 0zm-256 0l8 0 0 48-80 0 0-48 72 0z"],
    "building-shield": [576, 512, [], "e4d8", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l201.2 0c-12.5-14.7-23.2-30.8-31.8-48l-89.5 0 0-80c0-17.7 14.3-32 32-32l32 0 0-26.7c0-18.1 6.1-35.2 16.6-48.8-.4-1.4-.6-2.9-.6-4.5l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 1 86.7-28.9c3.1-1 6.2-1.8 9.3-2.5L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM445.3 488.5l-13.3 6.3 0-188.1 96 32 0 19.6c0 55.8-32.2 106.5-82.7 130.3zM421.9 259.5l-112 37.3c-13.1 4.4-21.9 16.6-21.9 30.4l0 31.1c0 74.4 43 142.1 110.2 173.7l18.5 8.7c4.8 2.2 10 3.4 15.2 3.4s10.5-1.2 15.2-3.4l18.5-8.7C533 500.3 576 432.6 576 358.2l0-31.1c0-13.8-8.8-26-21.9-30.4l-112-37.3c-6.6-2.2-13.7-2.2-20.2 0z"],
    "code": [576, 512, [], "f121", "M360.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6zm64.6 136.1c-12.5 12.5-12.5 32.8 0 45.3l73.4 73.4-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0zm-274.7 0c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 150.6 182.6c12.5-12.5 12.5-32.8 0-45.3z"],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", "M475.3 .1c9.9-.8 19.6 3 26.6 10s10.8 16.7 10 26.6c-4 49.3-17.4 126.2-46.3 199.7-1.8 4.5-5.5 7.9-10.2 9.3L374.5 270c-3.9 1.2-6.5 4.7-6.5 8.8 0 5.1 4.1 9.2 9.2 9.2l38.6 0c12 0 19.7 12.8 13.5 23.1-4 6.7-8.3 13.2-12.7 19.6-2 2.9-5 5-8.4 6.1L310.5 366c-3.9 1.2-6.5 4.7-6.5 8.8 0 5.1 4.1 9.2 9.2 9.2l16 0c14.6 0 21 17.4 8.8 25.4-68 45-137.7 43.3-182.4 31.3-12.7-3.4-24-9.9-34.4-17.9L48 496c-8.8 8.8-23.2 8.8-32 0s-8.8-23.2 0-32l80-80 .5 .5c.7-1.3 1.6-2.5 2.7-3.6L256 224c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0L89.7 326.2c-8.9 8.9-24 4.4-25-8.2-4.3-53.2 9.3-123.1 72.6-186.4 91.1-91.1 254.2-124.7 337.9-131.5z"],
    "file-circle-question": [576, 512, [], "e4ef", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-100c-11.6 0-21.3 8.2-23.5 19.2-1.8 8.7-10.2 14.3-18.9 12.5s-14.3-10.2-12.5-18.9c5.2-25.6 27.8-44.8 54.9-44.8 30.9 0 56 25.1 56 56 0 19.8-11.7 37.8-29.8 45.9l-10.4 4.6c-1.2 7.7-7.8 13.5-15.8 13.5-8.8 0-16-7.2-16-16 0-11.2 6.6-21.3 16.8-25.9l12.4-5.5c6.6-2.9 10.8-9.4 10.8-16.6 0-13.3-10.7-24-24-24z"],
    "signature": [640, 512, [], "f5b7", "M192 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 7.8c0 27.7-2.4 55.3-7.1 82.5l-84.4 25.3c-40.6 12.2-68.4 49.6-68.4 92l0 32.4-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72.5 0c4.2 36 34.8 64 72 64 26 0 50-13.9 62.9-36.5l13.9-24.3c26.8-47 46.5-97.7 58.4-150.5l94.4-28.3-12.5 37.5c-3.3 9.8-1.6 20.5 4.4 28.8S405.7 320 416 320l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-83.6 0 18-53.9c3.8-11.3 .9-23.8-7.4-32.4s-20.7-11.8-32.2-8.4L316.4 198.1c2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96s-96 43-96 96l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32zm-9.2 177l49-14.7c-10.4 33.8-24.5 66.4-42.1 97.2l-13.9 24.3c-1.5 2.6-4.3 4.3-7.4 4.3-4.7 0-8.5-3.8-8.5-8.5l0-71.9c0-14.1 9.3-26.6 22.8-30.7zM616 416c13.3 0 24-10.7 24-24s-10.7-24-24-24l-292.9 0c-6.5 16.3-13.7 32.3-21.6 48L616 416z"],
    "earth-americas": [512, 512, [127758, "earth", "earth-america", "globe-americas"], "f57d", "M55.7 199.7l30.9 30.9c6 6 14.1 9.4 22.6 9.4l21.5 0c8.5 0 16.6 3.4 22.6 9.4l29.3 29.3c6 6 9.4 14.1 9.4 22.6l0 37.5c0 8.5 3.4 16.6 9.4 22.6l13.3 13.3c6 6 9.4 14.1 9.4 22.6l0 18.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-2.7c0-8.5 3.4-16.6 9.4-22.6l45.3-45.3c6-6 9.4-14.1 9.4-22.6l0-34.7c0-17.7-14.3-32-32-32l-82.7 0c-8.5 0-16.6-3.4-22.6-9.4l-16-16c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l34.7 0c12.5 0 22.6-10.1 22.6-22.6 0-6-2.4-11.8-6.6-16l-19.7-19.7C242 130 240 125.1 240 120s2-10 5.7-13.7l17.3-17.3c5.8-5.8 9.1-13.7 9.1-21.9 0-7.2-2.4-13.7-6.4-18.9-3.2-.1-6.4-.2-9.6-.2-95.4 0-175.7 64.2-200.3 151.7zM464 256c0-34.6-8.4-67.2-23.4-95.8-6.4 .9-12.7 3.9-17.9 9.1l-13.4 13.4c-6 6-9.4 14.1-9.4 22.6l0 34.7c0 17.7 14.3 32 32 32l24.1 0c2.5 0 5-.3 7.3-.8 .4-5 .5-10.1 .5-15.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "carrot": [640, 512, [129365], "f787", "M453.1-36.7L440.9-24.6c-31.2 31.2-31.2 81.9 0 113.1 15.6 15.6 31.2 31.2 46.9 46.9 31.2 31.2 81.9 31.2 113.1 0l12.1-12.1c6.2-6.2 6.2-16.4 0-22.6L600.9 88.6c-31.2-31.2-81.9-31.2-113.1 0 31.2-31.2 31.2-81.9 0-113.1L475.7-36.7c-6.2-6.2-16.4-6.2-22.6 0zM331.6 96c-45.2 0-87.1 20.4-115 54.3L273.3 207c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L191.6 193.2 67.2 466.8c-5.5 12.1-2.9 26.4 6.5 35.9s23.7 12 35.9 6.5l141.6-64.4-43.8-43.8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l56.5 56.5 95.3-43.3c53.1-24.1 87.2-77.1 87.2-135.5 0-82.2-66.6-148.8-148.8-148.8z"],
    "temperature-full": [320, 512, ["temperature-4", "thermometer-4", "thermometer-full"], "f2c7", "M160 0C107 0 64 43 64 96l0 164.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 96c0-53-43-96-96-96zm64 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3L136 96c0-13.3 10.7-24 24-24s24 10.7 24 24l0 212.7c23.5 9.5 40 32.5 40 59.3z"],
    "table-cells-row-lock": [640, 512, [], "e67a", "M256 288l0-64 153.3 0c17.1-42.2 56-73.2 102.7-79l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-47.9-112 0 0-64 113.3 0c3.7-22 14.8-41.4 30.7-55.6l0-8.4-144 0zm0-192l192 0 0 64-192 0 0-64zM560 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M0 256L28.5 28c2-16 15.6-28 31.8-28L228.9 0c15 0 27.1 12.1 27.1 27.1 0 3.2-.6 6.5-1.7 9.5L208 160 347.3 160c20.2 0 36.7 16.4 36.7 36.7 0 7.4-2.2 14.6-6.4 20.7l-192.2 281c-5.9 8.6-15.6 13.7-25.9 13.7l-2.9 0c-15.7 0-28.5-12.8-28.5-28.5 0-2.3 .3-4.6 .9-6.9L176 288 32 288c-17.7 0-32-14.3-32-32z"],
    "cloud-showers-water": [512, 512, [], "e4e4", "M279.2 55.7C263.9 22.8 230.6 0 192 0 139 0 96 43 96 96 60.7 96 32 124.7 32 160s28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-1.6 0c-7.4-36.5-39.7-64-78.4-64-22.2 0-42.3 9.1-56.8 23.7zM410.6 476.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zM100.1 303.6c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64C29 365 35.8 378.6 48.4 382.8s26.2-2.6 30.4-15.2l21.3-64zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64zm112 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M182.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L128 77.3 128 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-434.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 256l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-24-96a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm240-48l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "angle-right": [256, 512, [8250], "f105", "M247.1 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L179.2 256 41.9 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM176 320l160 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "arrow-up-from-ground-water": [640, 512, [], "e4b5", "M303 7c9.4-9.4 24.6-9.4 33.9 0l88 88c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47 0 278.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-278.1-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L303 7zM240 192l0 163.1c-10.6-2.2-21.3-3.2-32-3.1-32.5 .2-64.9 10.7-92.3 31.4-8.8 6.6-15.9 10.9-21.7 13.5l-.8 .4c-3.7 1.7-6.4 2.9-9.8 .3-6-4.5-12.6-8-19.3-10.4L64 240c0-26.5 21.5-48 48-48l128 0zm336 48l0 155.2c-1.1 .8-2.2 1.5-3.3 2.4-4.1 3.1-8.3 .8-12.6-1.5-.6-.3-1.2-.6-1.8-1-5.2-2.7-11.1-6.6-18-11.7-28.1-21.1-61.3-31.6-94.4-31.4-15.5 .1-31 2.5-46 7.3l0-167.3 128 0c26.5 0 48 21.5 48 48zM403.4 476.1C379.1 494.3 351.1 512 320 512s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-23.8 17.9-54.1 35.5-88.1 35.3-20.4-.1-40.7-6.7-59.8-21.1-10.6-8-12.7-23-4.7-33.6s23-12.7 33.6-4.7c11.3 8.5 21.6 11.4 31.2 11.5 17.6 .1 37.3-9.4 58.9-25.7 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 16.9 12.7 32.9 21.5 47.8 24.6 13.7 2.8 27.4 .9 42.3-10.3 10.6-8 25.6-5.9 33.6 4.7s5.9 25.6-4.7 33.6c-26.4 19.9-54.2 24.4-80.7 19.1-25.3-5.1-48.1-18.9-67.2-33.3-21.3-16.1-49.9-16.1-71.2 0z"],
    "map": [512, 512, [128506, 62072], "f279", "M512 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L349.5 77.5 170.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C6.8 88.8 0 99.9 0 112L0 464c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 179.4 59.8c8.1 2.7 16.8 2.1 24.4-1.7l128-64c10.8-5.4 17.7-16.5 17.7-28.6l0-352zM192 376.9l0-284.5 128 42.7 0 284.5-128-42.7z"],
    "user-plus": [640, 512, [], "f234", "M136 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zM48 482.3C48 383.8 127.8 304 226.3 304l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L77.7 512C61.3 512 48 498.7 48 482.3zM544 96c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "venus": [384, 512, [9792], "f221", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM223.9 349.1C305.9 334.1 368 262.3 368 176 368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144.1 173.1-.1 1-.1 1.9-.1 2.9l0 64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-64c0-1 0-1.9-.1-2.9z"],
    "diagram-successor": [448, 512, [], "e47a", "M289.2 137.9c2.5-6 8.3-9.9 14.8-9.9l40 0 0-24c0-13.3-10.7-24-24-24l-98 0c1.3 5.1 2 10.5 2 16l0 64c0 35.3-28.7 64-64 64l-96 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l256 0c39.8 0 72 32.2 72 72l0 24 40 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-64 64c-6.2 6.2-16.4 6.2-22.6 0l-64-64c-4.6-4.6-5.9-11.5-3.5-17.4zM384 480L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64zM160 160l0-64-96 0 0 64 96 0z"],
    "head-side-cough-slash": [576, 512, [], "e062", "M535-24.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 537.1c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25-25 0-447.2c0-15 10.5-28.3 25.4-29.8 7.4-.7 14.9-1.1 22.6-1.1 112.7 0 206 83.3 221.7 191.7 .4 3 1.7 5.9 3.6 8.3l2.2 2.6 227.5-227.5zM133.8 512L288 357.8 288 416c0 53-43 96-96 96l-58.2 0zM176 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm336 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-88 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-64 48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm128 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-88-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "diagram-project": [512, 512, ["project-diagram"], "f542", "M0 80C0 53.5 21.5 32 48 32l96 0c26.5 0 48 21.5 48 48l0 16 128 0 0-16c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-16-128 0 0 16c0 7.3-1.7 14.3-4.6 20.5l68.6 91.5 80 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-96c0-7.3 1.7-14.3 4.6-20.5L128 224 48 224c-26.5 0-48-21.5-48-48L0 80z"],
    "terminal": [512, 512, [], "f120", "M9.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L146.7 256 9.4 118.6zM224 384l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "house-fire": [640, 512, [], "e50c", "M448 192c14.1 .4 23.8 11.4 32.7 21.7 2 2.3 4 4.6 6 6.7l19 19.9 12.2-13.8c5.4-6.1 13.3-8.9 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.2 26.2 88.2 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.1 5.7-5.2 13.1-7.7 20.3-7.5zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l147.5 137c-19.2-4.3-40 .5-55.5 14.4-36.4 32.6-67.7 69.8-90.3 106.4-10.3 16.6-19.7 34.9-26.8 53.7L272 320c-26.5 0-48 21.5-48 48l0 96 64.6 0c7.3 17.2 16.8 33.4 28.2 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM489.3 343.7c-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.7 51.9-54.7 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64c0-36.5-37-73-54.7-88.4z"],
    "mask": [576, 512, [], "f6fa", "M288 64C64 64 0 160 0 272S80 448 176 448l8.4 0c24.2 0 46.4-13.7 57.2-35.4l23.2-46.3c4.4-8.8 13.3-14.3 23.2-14.3s18.8 5.5 23.2 14.3l23.2 46.3c10.8 21.7 33 35.4 57.2 35.4l8.4 0c96 0 176-64 176-176S512 64 288 64zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm320-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "hurricane": [384, 512, [], "f751", "M0 208C0 104.4 75.7 18.5 174.9 2.6 184 1.2 192 8.6 192 17.9l0 63.3c0 8.4 6.5 15.3 14.7 16.5 100.3 14.9 177.3 101.3 177.3 205.7 0 103.6-75.7 189.5-174.9 205.4-9.2 1.5-17.1-5.9-17.1-15.2l0-63.3C192 421.9 185.5 415 177.3 413.7 77 398.9 0 312.4 0 208zm288 48a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-96-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", "M447.6 175c-31.6-74.6-105.5-127-191.6-127-22.1 0-43.4 3.5-63.4 9.8-.4 2-.6 4.1-.6 6.2l0 73.4c0 12.5 10.1 22.6 22.6 22.6 6 0 11.8-2.4 16-6.6l16-16c6-6 14.1-9.4 22.6-9.4l5.5 0c28.5 0 42.8 34.5 22.6 54.6-6 6-14.1 9.4-22.6 9.4l-61.5 0c-8.5 0-16.6 3.4-22.6 9.4l-21.3 21.3c-6 6-9.4 14.1-9.4 22.6l0 42.7c0 17.7 14.3 32 32 32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7 14.3 32 32 32l2.7 0c8.5 0 16.6-3.4 22.6-9.4l29.3-29.3c6-6 9.4-14.1 9.4-22.6l0-18.7c0-8.8 7.2-16 16-16s16-7.2 16-16l0-34.7c0-8.5-3.4-16.6-9.4-22.6l-16-16c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l45 0c12.4 0 22.7-7.1 28-17zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "thumbtack": [384, 512, [128204, 128392, "thumb-tack"], "f08d", "M32 32C32 14.3 46.3 0 64 0L320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-29.5 0 10.3 134.1c37.1 21.2 65.8 56.4 78.2 99.7l3.8 13.4c2.8 9.7 .8 20-5.2 28.1S362 352 352 352L32 352c-10 0-19.5-4.7-25.5-12.7s-8-18.4-5.2-28.1L5 297.8c12.4-43.3 41-78.5 78.2-99.7L93.5 64 64 64C46.3 64 32 49.7 32 32zM160 400l64 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112z"],
    "hand-point-down": [384, 512, [], "f0a7", "M32 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-208-64 0 0 208zM224 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-64 64c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32zm160-96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-96-88l0 .6c9.4-5.4 20.3-8.6 32-8.6 13.2 0 25.4 4 35.6 10.8 8.7-24.9 32.5-42.8 60.4-42.8 11.7 0 22.6 3.1 32 8.6l0-8.6C384 71.6 312.4 0 224 0L162.3 0C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149l0 27c0 35.3 28.7 64 64 64l88 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c39.8 0 72 32.2 72 72z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm208-48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "temperature-empty": [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", "M64 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S16 447.5 16 368c0-42.6 18.5-81 48-107.3L64 96zm96 336c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"],
    "border-none": [448, 512, [], "f850", "M32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zM288 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm0-384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "highlighter": [576, 512, [], "f591", "M315 315L473.4 99.9 444.1 70.6 229 229 315 315zm-187 5l0 0 0-71.7c0-15.3 7.2-29.6 19.5-38.6L420.6 8.4C428 2.9 437 0 446.2 0 457.6 0 468.5 4.5 476.6 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5 0 9.2-2.9 18.2-8