// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//! This file contains the Generated Glean Metrics API (Ping portion)
//!
//! The contents of this module are generated by
//! `toolkit/components/glean/build_scripts/glean_parser_ext/run_glean_parser.py`, from
//! ping definitions files identified by `toolkit/components/glean/metrics_index.py`.

include!(mozbuild::objdir_path!(
    "toolkit/components/glean/api/src/pings.rs"
));

#[cfg(feature = "with_gecko")]
pub fn record_profiler_ping_marker(ping_name: &String) {
    use crate::private::profiler_utils::PingMarker;
    use crate::private::profiler_utils::TelemetryProfilerCategory;
    if gecko_profiler::current_thread_is_being_profiled_for_markers() {
        gecko_profiler::add_marker(
            "Ping::submit",
            TelemetryProfilerCategory,
            Default::default(),
            PingMarker::new_for_submit(ping_name.clone(), None),
        );
    }
}
