/// AUTO GENERATED BY build.rs

use std::collections::HashMap;

use webrender_build::shader::ShaderVersion;

pub struct SourceWithDigest {
    pub source: &'static str,
    pub digest: &'static str,
}

pub struct OptimizedSourceWithDigest {
    pub vert_source: &'static str,
    pub frag_source: &'static str,
    pub digest: &'static str,
}

lazy_static! {
  pub static ref UNOPTIMIZED_SHADERS: HashMap<&'static str, SourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert("base", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/base.glsl"), digest: "d5ae695bab268b7d"});
    shaders.insert("blend", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/blend.glsl"), digest: "632e49345a7b9212"});
    shaders.insert("brush", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush.glsl"), digest: "25d75cc503d5110f"});
    shaders.insert("brush_blend", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_blend.glsl"), digest: "4c73380adb018e67"});
    shaders.insert("brush_image", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_image.glsl"), digest: "7799be2c14079031"});
    shaders.insert("brush_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_linear_gradient.glsl"), digest: "d1600a65bc54710a"});
    shaders.insert("brush_mix_blend", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_mix_blend.glsl"), digest: "4f3feece18ea8896"});
    shaders.insert("brush_opacity", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_opacity.glsl"), digest: "b69f555b3cf0185d"});
    shaders.insert("brush_solid", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_solid.glsl"), digest: "a88c4c02e369f6b2"});
    shaders.insert("brush_yuv_image", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/brush_yuv_image.glsl"), digest: "8da60d432aad3590"});
    shaders.insert("clip_shared", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/clip_shared.glsl"), digest: "7d88369ce4939c77"});
    shaders.insert("composite", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/composite.glsl"), digest: "7cd9992d7fe3c8bb"});
    shaders.insert("cs_blur", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_blur.glsl"), digest: "136a5b8bacd66997"});
    shaders.insert("cs_border_segment", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_border_segment.glsl"), digest: "c8e71ab0082eda8a"});
    shaders.insert("cs_border_solid", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_border_solid.glsl"), digest: "b5b914af8b69233d"});
    shaders.insert("cs_clip_box_shadow", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_clip_box_shadow.glsl"), digest: "a4f1f9ca289731e4"});
    shaders.insert("cs_clip_rectangle", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_clip_rectangle.glsl"), digest: "20c45fd2caa0c6b1"});
    shaders.insert("cs_conic_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_conic_gradient.glsl"), digest: "fc6177f5f3c6ac8b"});
    shaders.insert("cs_fast_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_fast_linear_gradient.glsl"), digest: "d61c63a203671fbf"});
    shaders.insert("cs_line_decoration", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_line_decoration.glsl"), digest: "8b8301f98084aa89"});
    shaders.insert("cs_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_linear_gradient.glsl"), digest: "46ce0a81a5e44370"});
    shaders.insert("cs_radial_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_radial_gradient.glsl"), digest: "ce2eb7e38f7a7a45"});
    shaders.insert("cs_scale", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_scale.glsl"), digest: "f1261b7accba411"});
    shaders.insert("cs_svg_filter_node", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/cs_svg_filter_node.glsl"), digest: "557f34975a1d503d"});
    shaders.insert("debug_color", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/debug_color.glsl"), digest: "51948a4e62ec49ef"});
    shaders.insert("debug_font", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/debug_font.glsl"), digest: "9546b37587d9114e"});
    shaders.insert("dithering", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/dithering.glsl"), digest: "546e054502d20aa0"});
    shaders.insert("ellipse", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ellipse.glsl"), digest: "951dc637533b8416"});
    shaders.insert("gpu_buffer", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/gpu_buffer.glsl"), digest: "55c6bea60ba278bb"});
    shaders.insert("gpu_cache_update", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/gpu_cache_update.glsl"), digest: "4ad2e4e46e03b7c2"});
    shaders.insert("gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/gradient.glsl"), digest: "d72f0a3d2c7310b4"});
    shaders.insert("gradient_shared", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/gradient_shared.glsl"), digest: "b6da23e10d3de9c1"});
    shaders.insert("image_source", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/image_source.glsl"), digest: "d5bdfbfd6d833887"});
    shaders.insert("prim_shared", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/prim_shared.glsl"), digest: "83ae87b274bff92a"});
    shaders.insert("ps_clear", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_clear.glsl"), digest: "44180e904e9ec507"});
    shaders.insert("ps_copy", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_copy.glsl"), digest: "f0e76514309bd9fa"});
    shaders.insert("ps_quad", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_quad.glsl"), digest: "f58e673d1f4acb2"});
    shaders.insert("ps_quad_gradient", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_quad_gradient.glsl"), digest: "dc083b438fe2a1d0"});
    shaders.insert("ps_quad_mask", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_quad_mask.glsl"), digest: "d75484cab33d08e6"});
    shaders.insert("ps_quad_repeat", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_quad_repeat.glsl"), digest: "69a28a6808783e41"});
    shaders.insert("ps_quad_textured", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_quad_textured.glsl"), digest: "4e9bd236db63ddbd"});
    shaders.insert("ps_split_composite", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_split_composite.glsl"), digest: "a15fb294e09e782"});
    shaders.insert("ps_text_run", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/ps_text_run.glsl"), digest: "7b8dc6677ead2832"});
    shaders.insert("rect", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/rect.glsl"), digest: "fc8ccaeee104d458"});
    shaders.insert("render_task", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/render_task.glsl"), digest: "e63b52526d4047fd"});
    shaders.insert("sample_color0", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/sample_color0.glsl"), digest: "a2c2acd5c7727200"});
    shaders.insert("shared", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/shared.glsl"), digest: "abc76c7c94e87e5e"});
    shaders.insert("shared_other", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/shared_other.glsl"), digest: "9f6298a27dfe79c6"});
    shaders.insert("transform", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/transform.glsl"), digest: "ef27af05d40f53f0"});
    shaders.insert("yuv", SourceWithDigest { source: include_str!("/build/firefox-nightly/src/mozilla-central/gfx/wr/webrender/res/yuv.glsl"), digest: "2a842da0f4efcbe2"});
    shaders
  };

  pub static ref OPTIMIZED_SHADERS: HashMap<(ShaderVersion, &'static str), OptimizedSourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert((ShaderVersion::Gl, "brush_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_Gl.frag"),
        digest: "f39b9d65cfd1985",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_ALPHA_PASS_Gl.frag"),
        digest: "36a7d8c3673d53dd",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "f1e15049b10d53d5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "e7345e295d1a00aa",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "20f4ab8768133244",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "6eba5b8061f99a70",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "e9e5536808b5ddf0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "4b9e71cb674b285d",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "2f2685bfce50c427",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "df2b28c932e03a29",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "fd4d755e09e76aaf",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "f919f97b4d30da4e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.frag"),
        digest: "7397df3b3000456d",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "335f39c8a3b500b3",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "8bc4c9ef21b5b903",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "48472b139d2424ac",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "ae59192aa32770f5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "994d4d07700578a2",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "98124f3919698a44",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "d0a130b98087bb78",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.frag"),
        digest: "149a0216bae6c8f1",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_TEXTURE_2D_Gl.frag"),
        digest: "1f357d265da050c1",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_image_TEXTURE_RECT_Gl.frag"),
        digest: "335426a80a00836e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_Gl.frag"),
        digest: "5df1f1ac4a74fd6f",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_ALPHA_PASS_Gl.frag"),
        digest: "522d33571056487c",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.frag"),
        digest: "e44c456a31ce2de0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_Gl.frag"),
        digest: "b2fab6fb6b942140",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_ALPHA_PASS_Gl.frag"),
        digest: "93e519efe28cde69",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "d07e29ac563990bd",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_Gl.frag"),
        digest: "4c423c72ea555005",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ALPHA_PASS_Gl.frag"),
        digest: "922b60f38746d5ab",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.frag"),
        digest: "91e5b8dd3314b8c2",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ANTIALIASING_Gl.frag"),
        digest: "aabbd0321d96f7f8",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.frag"),
        digest: "572bd6ae31ae8ed5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_opacity_DEBUG_OVERDRAW_Gl.frag"),
        digest: "8c6526f1ef35e3f5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_Gl.frag"),
        digest: "391a09601aacabde",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_ALPHA_PASS_Gl.frag"),
        digest: "b3122c5205795fb2",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_solid_DEBUG_OVERDRAW_Gl.frag"),
        digest: "af5643c588920950",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.frag"),
        digest: "d20734697104be4a",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "a7ac702f8adced4a",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.frag"),
        digest: "e628e66c7e8b55cc",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "34ed38fa134f1968",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.frag"),
        digest: "b43f863b3a3a970a",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "23ee839539d5fd14",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_2D_Gl.frag"),
        digest: "38337df702db9563",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.frag"),
        digest: "b110320ae45549f4",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_RECT_Gl.frag"),
        digest: "9b2aaced4f63da7a",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "59af6a9ec94e3c8",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_2D_Gl.frag"),
        digest: "b32d10135c3b408c",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_2D_YUV_Gl.frag"),
        digest: "f6074057f0d78cc0",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_RECT_Gl.frag"),
        digest: "daedc68c52f634ec",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/composite_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "3343284f00e49354",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_ALPHA_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_blur_ALPHA_TARGET_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_blur_ALPHA_TARGET_Gl.frag"),
        digest: "1b00c373598eba4c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_COLOR_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_blur_COLOR_TARGET_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_blur_COLOR_TARGET_Gl.frag"),
        digest: "c15f1f64491e4156",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_segment"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_border_segment_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_border_segment_Gl.frag"),
        digest: "8495134f5ed37bf5",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_border_solid_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_border_solid_Gl.frag"),
        digest: "9fd688a8c266d2da",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_box_shadow_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_box_shadow_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_box_shadow_TEXTURE_2D_Gl.frag"),
        digest: "99d0d4c5b02a61e",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_rectangle_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_rectangle_Gl.frag"),
        digest: "77ceb5634ad01cae",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_rectangle_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_clip_rectangle_FAST_PATH_Gl.frag"),
        digest: "f2ec7e42e13493c9",
    });
    shaders.insert((ShaderVersion::Gl, "cs_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_conic_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_conic_gradient_Gl.frag"),
        digest: "62367e600dc704f2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_fast_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_fast_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_fast_linear_gradient_Gl.frag"),
        digest: "3d4ec20a2b40f905",
    });
    shaders.insert((ShaderVersion::Gl, "cs_line_decoration"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_line_decoration_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_line_decoration_Gl.frag"),
        digest: "7943c68da0973c69",
    });
    shaders.insert((ShaderVersion::Gl, "cs_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_linear_gradient_Gl.frag"),
        digest: "efc10ff6f6cc1952",
    });
    shaders.insert((ShaderVersion::Gl, "cs_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_radial_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_radial_gradient_Gl.frag"),
        digest: "7336dc777aa9329c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_scale_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_scale_TEXTURE_2D_Gl.frag"),
        digest: "287afd7873f6d6b2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_scale_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_scale_TEXTURE_RECT_Gl.frag"),
        digest: "4fbbb7c5d7cb368e",
    });
    shaders.insert((ShaderVersion::Gl, "cs_svg_filter_node"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_svg_filter_node_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/cs_svg_filter_node_Gl.frag"),
        digest: "df4294d835bdbea6",
    });
    shaders.insert((ShaderVersion::Gl, "debug_color"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/debug_color_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/debug_color_Gl.frag"),
        digest: "f458fe7ea40bd77e",
    });
    shaders.insert((ShaderVersion::Gl, "debug_font"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/debug_font_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/debug_font_Gl.frag"),
        digest: "503ec56c19b6bd2c",
    });
    shaders.insert((ShaderVersion::Gl, "ps_clear"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_clear_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_clear_Gl.frag"),
        digest: "9ef2acc3bbd621e8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_copy"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_copy_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_copy_Gl.frag"),
        digest: "514726576460ee72",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_gradient_Gl.frag"),
        digest: "4287a587695f1832",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_mask_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_mask_Gl.frag"),
        digest: "e97912effa972721",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_mask_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_mask_FAST_PATH_Gl.frag"),
        digest: "e06c42fea88a9413",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_repeat"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_repeat_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_repeat_Gl.frag"),
        digest: "fc0a285699d7c48b",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_textured"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_textured_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_quad_textured_Gl.frag"),
        digest: "7034baab6c724695",
    });
    shaders.insert((ShaderVersion::Gl, "ps_split_composite"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_split_composite_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_split_composite_Gl.frag"),
        digest: "3f1201183d0b9725",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "f5e9b734876c69c5",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "4ff99b8a8fcae827",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "5a0e5bd0cb7538e3",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "af63cf200cd64946",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "2b6e6191d96b3045",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-nightly/src/mozilla-central/obj/x86_64-unknown-linux-gnu/release/build/webrender-efadbe06cb05029d/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "5f615e14c3c3581a",
    });
    shaders
  };
}
