/* This file was autogenerated by toolkit/crashreporter/annotations/generate.py. DO NOT EDIT */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef CrashAnnotations_h
#define CrashAnnotations_h

#include <cstddef>
#include <cstdint>

#include "mozilla/Maybe.h"
#include "nsStringFwd.h"

namespace CrashReporter {

using mozilla::Maybe;

// Typed enum representing all crash annotations
enum class Annotation : uint32_t {
  AbortMessage = 0,
  Accessibility = 1,
  AccessibilityClient = 2,
  AccessibilityInProcClient = 3,
  AdapterDeviceID = 4,
  AdapterDriverVendor = 5,
  AdapterDriverVersion = 6,
  AdapterSubsysID = 7,
  AdapterVendorID = 8,
  additional_minidumps = 9,
  Addons = 10,
  Android_Board = 11,
  Android_Brand = 12,
  Android_CPU_ABI = 13,
  Android_CPU_ABI2 = 14,
  Android_Device = 15,
  Android_Display = 16,
  Android_Fingerprint = 17,
  Android_Hardware = 18,
  Android_Manufacturer = 19,
  Android_Model = 20,
  Android_PackageName = 21,
  Android_ProcessName = 22,
  Android_Version = 23,
  AndroidComponentVersion = 24,
  AppInitDLLs = 25,
  ApplicationBuildID = 26,
  ApplicationServicesVersion = 27,
  AsyncShutdownTimeout = 28,
  AvailablePageFile = 29,
  AvailablePhysicalMemory = 30,
  AvailableSwapMemory = 31,
  AvailableVirtualMemory = 32,
  BackgroundTaskMode = 33,
  BackgroundTaskName = 34,
  BlockedDllList = 35,
  BlocklistInitFailed = 36,
  Breadcrumbs = 37,
  BuildID = 38,
  Comments = 39,
  ContentSandboxCapabilities = 40,
  ContentSandboxCapable = 41,
  ContentSandboxEnabled = 42,
  ContentSandboxLevel = 43,
  ContentSandboxWin32kState = 44,
  CPUMicrocodeVersion = 45,
  CrashTime = 46,
  CrashType = 47,
  CycleCollector = 48,
  DesktopEnvironment = 49,
  DeviceResetReason = 50,
  DistributionID = 51,
  DOMFissionEnabled = 52,
  DOMIPCEnabled = 53,
  DumperError = 54,
  EMCheckCompatibility = 55,
  EventLoopNestingLevel = 56,
  FontName = 57,
  GeckoViewVersion = 58,
  GleanVersion = 59,
  GMPLibraryPath = 60,
  GMPPlugin = 61,
  GPUProcessLaunchCount = 62,
  GPUProcessStatus = 63,
  GpuSandboxLevel = 64,
  GraphicsCompileShader = 65,
  GraphicsCriticalError = 66,
  GraphicsDrawShader = 67,
  GraphicsFontFile = 68,
  GraphicsNumActiveRenderers = 69,
  GraphicsNumRenderers = 70,
  GraphicsStartupTest = 71,
  Hang = 72,
  HasDeviceTouchScreen = 73,
  HeadlessMode = 74,
  InstallTime = 75,
  ipc_channel_error = 76,
  IpcCreatePipeCloExecErrno = 77,
  IpcCreatePipeFcntlErrno = 78,
  IpcCreatePipeSocketPairErrno = 79,
  IPCFatalErrorMsg = 80,
  IPCFatalErrorProtocol = 81,
  IPCMessageLargeBufferShmemFailureSize = 82,
  IPCMessageName = 83,
  IPCMessageSize = 84,
  IPCReadErrorReason = 85,
  IPCShutdownState = 86,
  IPCSystemError = 87,
  IsGarbageCollecting = 88,
  IsWayland = 89,
  IsWebRenderResourcePathOverridden = 90,
  JavaException = 91,
  JavaStackTrace = 92,
  JSActorMessage = 93,
  JSActorName = 94,
  JSLargeAllocationFailure = 95,
  JSModuleLoadError = 96,
  JSOutOfMemory = 97,
  LastInteractionDuration = 98,
  LastStartupWasCrash = 99,
  LauncherProcessState = 100,
  LinuxMemoryPSI = 101,
  LinuxUnderMemoryPressure = 102,
  LowPhysicalMemoryEvents = 103,
  MacAvailableMemorySysctl = 104,
  MacMemoryPressure = 105,
  MacMemoryPressureCriticalTime = 106,
  MacMemoryPressureNormalTime = 107,
  MacMemoryPressureSysctl = 108,
  MacMemoryPressureWarningTime = 109,
  MainThreadRunnableName = 110,
  Marionette = 111,
  MemtestOutput = 112,
  MinidumpSha256Hash = 113,
  ModuleSignatureInfo = 114,
  MozCrashReason = 115,
  NimbusEnrollments = 116,
  Notes = 117,
  OOMAllocationSize = 118,
  PHCAllocStack = 119,
  PHCBaseAddress = 120,
  PHCFreeStack = 121,
  PHCKind = 122,
  PHCUsableSize = 123,
  PluginFilename = 124,
  PluginName = 125,
  PluginVersion = 126,
  ProcessType = 127,
  ProductID = 128,
  ProductName = 129,
  ProfileDirectory = 130,
  ProfilerChildShutdownPhase = 131,
  PurgeablePhysicalMemory = 132,
  QuotaManagerShutdownTimeout = 133,
  QuotaManagerStorageIsNetworkResource = 134,
  RDDProcessStatus = 135,
  ReleaseChannel = 136,
  RemoteAgent = 137,
  RemoteType = 138,
  SafeMode = 139,
  SecondsSinceLastCrash = 140,
  ServerURL = 141,
  ShutdownProgress = 142,
  ShutdownReason = 143,
  StackTraces = 144,
  StartupCacheValid = 145,
  StartupCrash = 146,
  StartupTime = 147,
  StorageConnectionNotClosed = 148,
  SubmittedFrom = 149,
  SystemMemoryUsePercentage = 150,
  TelemetryClientId = 151,
  TelemetryEnvironment = 152,
  TelemetryProfileGroupId = 153,
  TelemetryServerURL = 154,
  TelemetrySessionId = 155,
  TestBoolean = 156,
  TestInteger = 157,
  TestKey = 158,
  TestUnicode = 159,
  TextureUsage = 160,
  ThreadLastCreateError = 161,
  Throttleable = 162,
  TotalPageFile = 163,
  TotalPhysicalMemory = 164,
  TotalVirtualMemory = 165,
  UnknownNetAddrSocketFamily = 166,
  UptimeTS = 167,
  URL = 168,
  URLSegments = 169,
  User32BeforeBlocklist = 170,
  useragent_locale = 171,
  UserFontRulesExhausted = 172,
  UtilityActorsName = 173,
  UtilityProcessStatus = 174,
  Vendor = 175,
  Version = 176,
  VRProcessStatus = 177,
  WasmLibrarySandboxMallocFailed = 178,
  WindowsErrorReporting = 179,
  WindowsFileDialogErrorCode = 180,
  WindowsPackageFamilyName = 181,
  Winsock_LSP = 182,
  XPCOMSpinEventLoopStack = 183,
  Count = 184
};

// Stringified crash annotation names
const char* const kAnnotationStrings[] = {
  "AbortMessage",
  "Accessibility",
  "AccessibilityClient",
  "AccessibilityInProcClient",
  "AdapterDeviceID",
  "AdapterDriverVendor",
  "AdapterDriverVersion",
  "AdapterSubsysID",
  "AdapterVendorID",
  "additional_minidumps",
  "Add-ons",
  "Android_Board",
  "Android_Brand",
  "Android_CPU_ABI",
  "Android_CPU_ABI2",
  "Android_Device",
  "Android_Display",
  "Android_Fingerprint",
  "Android_Hardware",
  "Android_Manufacturer",
  "Android_Model",
  "Android_PackageName",
  "Android_ProcessName",
  "Android_Version",
  "AndroidComponentVersion",
  "AppInitDLLs",
  "ApplicationBuildID",
  "ApplicationServicesVersion",
  "AsyncShutdownTimeout",
  "AvailablePageFile",
  "AvailablePhysicalMemory",
  "AvailableSwapMemory",
  "AvailableVirtualMemory",
  "BackgroundTaskMode",
  "BackgroundTaskName",
  "BlockedDllList",
  "BlocklistInitFailed",
  "Breadcrumbs",
  "BuildID",
  "Comments",
  "ContentSandboxCapabilities",
  "ContentSandboxCapable",
  "ContentSandboxEnabled",
  "ContentSandboxLevel",
  "ContentSandboxWin32kState",
  "CPUMicrocodeVersion",
  "CrashTime",
  "CrashType",
  "CycleCollector",
  "DesktopEnvironment",
  "DeviceResetReason",
  "DistributionID",
  "DOMFissionEnabled",
  "DOMIPCEnabled",
  "DumperError",
  "EMCheckCompatibility",
  "EventLoopNestingLevel",
  "FontName",
  "GeckoViewVersion",
  "GleanVersion",
  "GMPLibraryPath",
  "GMPPlugin",
  "GPUProcessLaunchCount",
  "GPUProcessStatus",
  "GpuSandboxLevel",
  "GraphicsCompileShader",
  "GraphicsCriticalError",
  "GraphicsDrawShader",
  "GraphicsFontFile",
  "GraphicsNumActiveRenderers",
  "GraphicsNumRenderers",
  "GraphicsStartupTest",
  "Hang",
  "HasDeviceTouchScreen",
  "HeadlessMode",
  "InstallTime",
  "ipc_channel_error",
  "IpcCreatePipeCloExecErrno",
  "IpcCreatePipeFcntlErrno",
  "IpcCreatePipeSocketPairErrno",
  "IPCFatalErrorMsg",
  "IPCFatalErrorProtocol",
  "IPCMessageLargeBufferShmemFailureSize",
  "IPCMessageName",
  "IPCMessageSize",
  "IPCReadErrorReason",
  "IPCShutdownState",
  "IPCSystemError",
  "IsGarbageCollecting",
  "IsWayland",
  "IsWebRenderResourcePathOverridden",
  "JavaException",
  "JavaStackTrace",
  "JSActorMessage",
  "JSActorName",
  "JSLargeAllocationFailure",
  "JSModuleLoadError",
  "JSOutOfMemory",
  "LastInteractionDuration",
  "LastStartupWasCrash",
  "LauncherProcessState",
  "LinuxMemoryPSI",
  "LinuxUnderMemoryPressure",
  "LowPhysicalMemoryEvents",
  "MacAvailableMemorySysctl",
  "MacMemoryPressure",
  "MacMemoryPressureCriticalTime",
  "MacMemoryPressureNormalTime",
  "MacMemoryPressureSysctl",
  "MacMemoryPressureWarningTime",
  "MainThreadRunnableName",
  "Marionette",
  "MemtestOutput",
  "MinidumpSha256Hash",
  "ModuleSignatureInfo",
  "MozCrashReason",
  "NimbusEnrollments",
  "Notes",
  "OOMAllocationSize",
  "PHCAllocStack",
  "PHCBaseAddress",
  "PHCFreeStack",
  "PHCKind",
  "PHCUsableSize",
  "PluginFilename",
  "PluginName",
  "PluginVersion",
  "ProcessType",
  "ProductID",
  "ProductName",
  "ProfileDirectory",
  "ProfilerChildShutdownPhase",
  "PurgeablePhysicalMemory",
  "QuotaManagerShutdownTimeout",
  "QuotaManagerStorageIsNetworkResource",
  "RDDProcessStatus",
  "ReleaseChannel",
  "RemoteAgent",
  "RemoteType",
  "SafeMode",
  "SecondsSinceLastCrash",
  "ServerURL",
  "ShutdownProgress",
  "ShutdownReason",
  "StackTraces",
  "StartupCacheValid",
  "StartupCrash",
  "StartupTime",
  "StorageConnectionNotClosed",
  "SubmittedFrom",
  "SystemMemoryUsePercentage",
  "TelemetryClientId",
  "TelemetryEnvironment",
  "TelemetryProfileGroupId",
  "TelemetryServerURL",
  "TelemetrySessionId",
  "TestBoolean",
  "TestInteger",
  "TestKey",
  "TestUnicode",
  "TextureUsage",
  "ThreadLastCreateError",
  "Throttleable",
  "TotalPageFile",
  "TotalPhysicalMemory",
  "TotalVirtualMemory",
  "UnknownNetAddrSocketFamily",
  "UptimeTS",
  "URL",
  "URLSegments",
  "User32BeforeBlocklist",
  "useragent_locale",
  "UserFontRulesExhausted",
  "UtilityActorsName",
  "UtilityProcessStatus",
  "Vendor",
  "Version",
  "VRProcessStatus",
  "WasmLibrarySandboxMallocFailed",
  "WindowsErrorReporting",
  "WindowsFileDialogErrorCode",
  "WindowsPackageFamilyName",
  "Winsock_LSP",
  "XPCOMSpinEventLoopStack"
};

// Type of each annotation
enum class AnnotationType : uint8_t {
  String = 0,   // Any type of string, const char*, nsCString, etc...
  Boolean = 1,  // Stored as a byte
  U32 = 2,      // C/C++'s uint32_t or Rust's u32
  U64 = 3,      // C/C++'s uint64_t or Rust's u64
  USize = 4,    // C/C++'s size_t or Rust's usize
  Object = 5,   // Not able to be read/written from the C++ API.
};

// Type of each annotation
const AnnotationType kAnnotationTypes[] = {
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U64,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Object,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String
};

// Allowlist of crash annotations that can be included in a crash ping
const Annotation kCrashPingAllowedList[] = {
  Annotation::ApplicationBuildID,
  Annotation::AsyncShutdownTimeout,
  Annotation::AvailablePageFile,
  Annotation::AvailablePhysicalMemory,
  Annotation::AvailableSwapMemory,
  Annotation::AvailableVirtualMemory,
  Annotation::BackgroundTaskName,
  Annotation::BlockedDllList,
  Annotation::BlocklistInitFailed,
  Annotation::BuildID,
  Annotation::CrashTime,
  Annotation::CrashType,
  Annotation::DOMFissionEnabled,
  Annotation::EventLoopNestingLevel,
  Annotation::FontName,
  Annotation::GPUProcessLaunchCount,
  Annotation::Hang,
  Annotation::HeadlessMode,
  Annotation::ipc_channel_error,
  Annotation::IsGarbageCollecting,
  Annotation::JavaException,
  Annotation::JSLargeAllocationFailure,
  Annotation::JSOutOfMemory,
  Annotation::LastInteractionDuration,
  Annotation::LinuxMemoryPSI,
  Annotation::LowPhysicalMemoryEvents,
  Annotation::MainThreadRunnableName,
  Annotation::MinidumpSha256Hash,
  Annotation::MozCrashReason,
  Annotation::NimbusEnrollments,
  Annotation::OOMAllocationSize,
  Annotation::ProcessType,
  Annotation::ProductID,
  Annotation::ProductName,
  Annotation::ProfilerChildShutdownPhase,
  Annotation::PurgeablePhysicalMemory,
  Annotation::QuotaManagerShutdownTimeout,
  Annotation::ReleaseChannel,
  Annotation::RemoteType,
  Annotation::SecondsSinceLastCrash,
  Annotation::ShutdownProgress,
  Annotation::ShutdownReason,
  Annotation::StartupCrash,
  Annotation::SystemMemoryUsePercentage,
  Annotation::TextureUsage,
  Annotation::TotalPageFile,
  Annotation::TotalPhysicalMemory,
  Annotation::TotalVirtualMemory,
  Annotation::UptimeTS,
  Annotation::User32BeforeBlocklist,
  Annotation::UtilityActorsName,
  Annotation::Version,
  Annotation::WindowsErrorReporting,
  Annotation::WindowsFileDialogErrorCode,
  Annotation::WindowsPackageFamilyName
};

// Allowlist of crash annotations that can be only included in a crash ping
const Annotation kCrashPingOnlyAllowedList[] = {
  Annotation::StackTraces
};

// Allowlist of crash annotations that can be included in a crash report
// (excludes those in kCrashPingAllowedList).
const Annotation kCrashReportAllowedList[] = {
  Annotation::AbortMessage,
  Annotation::Accessibility,
  Annotation::AccessibilityClient,
  Annotation::AccessibilityInProcClient,
  Annotation::AdapterDeviceID,
  Annotation::AdapterDriverVendor,
  Annotation::AdapterDriverVersion,
  Annotation::AdapterSubsysID,
  Annotation::AdapterVendorID,
  Annotation::additional_minidumps,
  Annotation::Addons,
  Annotation::Android_Board,
  Annotation::Android_Brand,
  Annotation::Android_CPU_ABI,
  Annotation::Android_CPU_ABI2,
  Annotation::Android_Device,
  Annotation::Android_Display,
  Annotation::Android_Fingerprint,
  Annotation::Android_Hardware,
  Annotation::Android_Manufacturer,
  Annotation::Android_Model,
  Annotation::Android_PackageName,
  Annotation::Android_ProcessName,
  Annotation::Android_Version,
  Annotation::AndroidComponentVersion,
  Annotation::AppInitDLLs,
  Annotation::ApplicationServicesVersion,
  Annotation::BackgroundTaskMode,
  Annotation::Breadcrumbs,
  Annotation::Comments,
  Annotation::ContentSandboxCapabilities,
  Annotation::ContentSandboxCapable,
  Annotation::ContentSandboxEnabled,
  Annotation::ContentSandboxLevel,
  Annotation::ContentSandboxWin32kState,
  Annotation::CPUMicrocodeVersion,
  Annotation::CycleCollector,
  Annotation::DesktopEnvironment,
  Annotation::DeviceResetReason,
  Annotation::DistributionID,
  Annotation::DOMIPCEnabled,
  Annotation::DumperError,
  Annotation::EMCheckCompatibility,
  Annotation::GeckoViewVersion,
  Annotation::GleanVersion,
  Annotation::GMPLibraryPath,
  Annotation::GMPPlugin,
  Annotation::GPUProcessStatus,
  Annotation::GpuSandboxLevel,
  Annotation::GraphicsCompileShader,
  Annotation::GraphicsCriticalError,
  Annotation::GraphicsDrawShader,
  Annotation::GraphicsFontFile,
  Annotation::GraphicsNumActiveRenderers,
  Annotation::GraphicsNumRenderers,
  Annotation::GraphicsStartupTest,
  Annotation::HasDeviceTouchScreen,
  Annotation::InstallTime,
  Annotation::IpcCreatePipeCloExecErrno,
  Annotation::IpcCreatePipeFcntlErrno,
  Annotation::IpcCreatePipeSocketPairErrno,
  Annotation::IPCFatalErrorMsg,
  Annotation::IPCFatalErrorProtocol,
  Annotation::IPCMessageLargeBufferShmemFailureSize,
  Annotation::IPCMessageName,
  Annotation::IPCMessageSize,
  Annotation::IPCReadErrorReason,
  Annotation::IPCShutdownState,
  Annotation::IPCSystemError,
  Annotation::IsWayland,
  Annotation::IsWebRenderResourcePathOverridden,
  Annotation::JavaStackTrace,
  Annotation::JSActorMessage,
  Annotation::JSActorName,
  Annotation::JSModuleLoadError,
  Annotation::LastStartupWasCrash,
  Annotation::LauncherProcessState,
  Annotation::LinuxUnderMemoryPressure,
  Annotation::MacAvailableMemorySysctl,
  Annotation::MacMemoryPressure,
  Annotation::MacMemoryPressureCriticalTime,
  Annotation::MacMemoryPressureNormalTime,
  Annotation::MacMemoryPressureSysctl,
  Annotation::MacMemoryPressureWarningTime,
  Annotation::Marionette,
  Annotation::MemtestOutput,
  Annotation::ModuleSignatureInfo,
  Annotation::Notes,
  Annotation::PHCAllocStack,
  Annotation::PHCBaseAddress,
  Annotation::PHCFreeStack,
  Annotation::PHCKind,
  Annotation::PHCUsableSize,
  Annotation::PluginFilename,
  Annotation::PluginName,
  Annotation::PluginVersion,
  Annotation::QuotaManagerStorageIsNetworkResource,
  Annotation::RDDProcessStatus,
  Annotation::RemoteAgent,
  Annotation::SafeMode,
  Annotation::StartupCacheValid,
  Annotation::StartupTime,
  Annotation::StorageConnectionNotClosed,
  Annotation::SubmittedFrom,
  Annotation::TelemetryEnvironment,
  Annotation::TestBoolean,
  Annotation::TestInteger,
  Annotation::TestKey,
  Annotation::TestUnicode,
  Annotation::ThreadLastCreateError,
  Annotation::Throttleable,
  Annotation::UnknownNetAddrSocketFamily,
  Annotation::URL,
  Annotation::URLSegments,
  Annotation::useragent_locale,
  Annotation::UserFontRulesExhausted,
  Annotation::UtilityProcessStatus,
  Annotation::Vendor,
  Annotation::VRProcessStatus,
  Annotation::WasmLibrarySandboxMallocFailed,
  Annotation::Winsock_LSP,
  Annotation::XPCOMSpinEventLoopStack
};

// Annotations which should be skipped when they have specific values
struct AnnotationSkipValue {
  Annotation annotation;
  const char* value;
};

const AnnotationSkipValue kSkipIfList[] = {
  { Annotation::BlocklistInitFailed, "0" },
  { Annotation::EventLoopNestingLevel, "0" },
  { Annotation::IsGarbageCollecting, "0" },
  { Annotation::LowPhysicalMemoryEvents, "0" },
  { Annotation::OOMAllocationSize, "0" },
  { Annotation::TextureUsage, "0" },
  { Annotation::User32BeforeBlocklist, "0" }
};

/**
 * Return the type of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns The type of this annotation
 */
static inline AnnotationType TypeOfAnnotation(Annotation aAnnotation) {
  return kAnnotationTypes[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Return the string representation of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns A constant string holding the annotation name
 */
static inline const char* AnnotationToString(Annotation aAnnotation) {
  return kAnnotationStrings[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Converts a string to its corresponding crash annotation.
 *
 * @param aValue the string to be converted
 * @return the annotation corresponding to the string or nothing
 */
Maybe<Annotation> AnnotationFromString(const nsACString& aValue);

/**
 * Checks if the given crash annotation is allowed for inclusion in a crash
 * ping.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in a crash ping, false
 *         otherwise
 */
bool IsAnnotationAllowedForPing(Annotation aAnnotation);

/**
 * Checks if the given crash annotation is allowed for inclusion in a crash
 * report.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in a crash report, false
 *         otherwise
 */
bool IsAnnotationAllowedForReport(Annotation aAnnotation);

/**
 * Checks if the annotation should be included. Some annotations are skipped if
 * their value matches a specific one (like the value 0).
 *
 * @param aAnnotation the crash annotation to be checked
 * @param aValue the contents of the annotation as a string
 * @return true if the annotation should be included, false otherwise
 */
bool ShouldIncludeAnnotation(Annotation aAnnotation, const char* aValue);

/**
 * Abstract annotation writer, this is needed only for code that writes out
 * annotations in the exception handler.
 */
class AnnotationWriter {
 public:
  virtual void Write(Annotation aAnnotation, const char* aValue,
                     size_t aLen = 0) = 0;
  virtual void Write(Annotation aAnnotation, bool aValue) = 0;
  virtual void Write(Annotation aAnnotation, uint64_t aValue) = 0;
};

#ifdef XP_WIN

extern void RecordDllAnnotations(bool* aBlocklistInitFailed,
                                 bool* aUser32BeforeBlocklist);

#endif  // XP_WIN

}  // namespace CrashReporter

#endif  // CrashAnnotations_h
