//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PContent_h
#define PContent_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "Units.h"
#include "mozilla/PerfStats.h"
#include "mozilla/TelemetryComms.h"
#include "mozilla/chrome/RegistryMessageUtils.h"
#include "mozilla/dom/BrowsingContext.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SharedMemoryHandle.h"
#include "mozilla/ipc/SideVariant.h"
#include "nsIDNSService.h"
#include "CrashReporter/CrashReporterInitArgs.h"
#include "mozilla/dom/DOMTypes.h"
#include "mozilla/dom/WindowGlobalTypes.h"
#include "mozilla/dom/IPCBlob.h"
#include "mozilla/ipc/IPCStream.h"
#include "mozilla/dom/IPCTransferable.h"
#include "mozilla/dom/JSIPCValue.h"
#include "mozilla/embedding/PPrintingTypes.h"
#include "mozilla/dom/PTabContext.h"
#include "mozilla/ipc/ProtocolTypes.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"
#include "mozilla/dom/PContentPermission.h"
#include "mozilla/gfx/GraphicsMessages.h"
#include "mozilla/dom/MemoryReportTypes.h"
#include "mozilla/dom/ClientIPCTypes.h"
#include "mozilla/HangTypes.h"
#include "mozilla/dom/PrefsTypes.h"
#include "mozilla/net/NeckoChannelParams.h"
#include "mozilla/psm/PSMIPCTypes.h"
#include "mozilla/widget/LookAndFeelTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ChromeRegistryItem|
//
class ChromeRegistryItem final
{
public:
    enum Type {
        T__None,
        TChromePackage = 1,
        TOverrideMapping,
        TSubstitutionMapping,
        T__Last = TSubstitutionMapping
    };

private:
    typedef ::ChromePackage ChromePackage;
    typedef ::OverrideMapping OverrideMapping;
    typedef ::SubstitutionMapping SubstitutionMapping;
    typedef ChromePackage ChromePackage__tdef;
    typedef OverrideMapping OverrideMapping__tdef;
    typedef SubstitutionMapping SubstitutionMapping__tdef;

    ChromePackage*
    ptr_ChromePackage()
    {
        return (&(mVChromePackage));
    }
    const ChromePackage*
    constptr_ChromePackage() const
    {
        return (&(mVChromePackage));
    }
    OverrideMapping*
    ptr_OverrideMapping()
    {
        return (&(mVOverrideMapping));
    }
    const OverrideMapping*
    constptr_OverrideMapping() const
    {
        return (&(mVOverrideMapping));
    }
    SubstitutionMapping*
    ptr_SubstitutionMapping()
    {
        return (&(mVSubstitutionMapping));
    }
    const SubstitutionMapping*
    constptr_SubstitutionMapping() const
    {
        return (&(mVSubstitutionMapping));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ChromeRegistryItem() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ChromeRegistryItem(const ChromePackage& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(ChromePackage&& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(const OverrideMapping& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(OverrideMapping&& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(const SubstitutionMapping& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(SubstitutionMapping&& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(const ChromeRegistryItem& aOther);

    MOZ_IMPLICIT ChromeRegistryItem(ChromeRegistryItem&& aOther);

    ~ChromeRegistryItem();

    Type
    type() const
    {
        return mType;
    }

    ChromeRegistryItem&
    operator=(const ChromePackage& aRhs);

    ChromeRegistryItem&
    operator=(ChromePackage&& aRhs);

    ChromeRegistryItem&
    operator=(const OverrideMapping& aRhs);

    ChromeRegistryItem&
    operator=(OverrideMapping&& aRhs);

    ChromeRegistryItem&
    operator=(const SubstitutionMapping& aRhs);

    ChromeRegistryItem&
    operator=(SubstitutionMapping&& aRhs);

    ChromeRegistryItem&
    operator=(const ChromeRegistryItem& aRhs);

    ChromeRegistryItem&
    operator=(ChromeRegistryItem&& aRhs);

    ChromePackage&
    get_ChromePackage()
    {
        AssertSanity(TChromePackage);
        return (*(ptr_ChromePackage()));
    }
    const ChromePackage&
    get_ChromePackage() const
    {
        AssertSanity(TChromePackage);
        return (*(constptr_ChromePackage()));
    }
    operator ChromePackage&()
    {
        return get_ChromePackage();
    }
    operator const ChromePackage&() const
    {
        return get_ChromePackage();
    }

    OverrideMapping&
    get_OverrideMapping()
    {
        AssertSanity(TOverrideMapping);
        return (*(ptr_OverrideMapping()));
    }
    const OverrideMapping&
    get_OverrideMapping() const
    {
        AssertSanity(TOverrideMapping);
        return (*(constptr_OverrideMapping()));
    }
    operator OverrideMapping&()
    {
        return get_OverrideMapping();
    }
    operator const OverrideMapping&() const
    {
        return get_OverrideMapping();
    }

    SubstitutionMapping&
    get_SubstitutionMapping()
    {
        AssertSanity(TSubstitutionMapping);
        return (*(ptr_SubstitutionMapping()));
    }
    const SubstitutionMapping&
    get_SubstitutionMapping() const
    {
        AssertSanity(TSubstitutionMapping);
        return (*(constptr_SubstitutionMapping()));
    }
    operator SubstitutionMapping&()
    {
        return get_SubstitutionMapping();
    }
    operator const SubstitutionMapping&() const
    {
        return get_SubstitutionMapping();
    }

private:
    union {
        ChromePackage mVChromePackage;
        OverrideMapping mVOverrideMapping;
        SubstitutionMapping mVSubstitutionMapping;
    };
    Type mType;
};

namespace IPC {
template<>
struct ParamTraits <::ChromeRegistryItem>
{
    typedef ::ChromeRegistryItem paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SystemFontListEntry|
//
namespace mozilla {
namespace dom {
class SystemFontListEntry final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SystemFontListEntry() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SystemFontListEntry(
            const nsCString& _pattern,
            const bool& _appFontFamily) :
        pattern_(_pattern),
        appFontFamily_(_appFontFamily)
    {
    }

    MOZ_IMPLICIT SystemFontListEntry(
            nsCString&& _pattern,
            bool&& _appFontFamily) :
        pattern_(std::move(_pattern)),
        appFontFamily_(std::move(_appFontFamily))
    {
    }

    nsCString&
    pattern()
    {
        return pattern_;
    }
    const nsCString&
    pattern() const
    {
        return pattern_;
    }

    bool&
    appFontFamily()
    {
        return appFontFamily_;
    }
    const bool&
    appFontFamily() const
    {
        return appFontFamily_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> pattern_;
    ::mozilla::ipc::IPDLStructMember<bool> appFontFamily_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::SystemFontListEntry>
{
    typedef ::mozilla::dom::SystemFontListEntry paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SystemFontOptions|
//
namespace mozilla {
namespace dom {
class SystemFontOptions final
{
private:
    typedef ::int32_t int32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SystemFontOptions() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SystemFontOptions(
            const int32_t& _antialias,
            const int32_t& _subpixelOrder,
            const int32_t& _hintStyle,
            const int32_t& _lcdFilter) :
        antialias_(_antialias),
        subpixelOrder_(_subpixelOrder),
        hintStyle_(_hintStyle),
        lcdFilter_(_lcdFilter)
    {
    }

    MOZ_IMPLICIT SystemFontOptions(
            int32_t&& _antialias,
            int32_t&& _subpixelOrder,
            int32_t&& _hintStyle,
            int32_t&& _lcdFilter) :
        antialias_(std::move(_antialias)),
        subpixelOrder_(std::move(_subpixelOrder)),
        hintStyle_(std::move(_hintStyle)),
        lcdFilter_(std::move(_lcdFilter))
    {
    }

    int32_t&
    antialias()
    {
        return antialias_;
    }
    const int32_t&
    antialias() const
    {
        return antialias_;
    }

    int32_t&
    subpixelOrder()
    {
        return subpixelOrder_;
    }
    const int32_t&
    subpixelOrder() const
    {
        return subpixelOrder_;
    }

    int32_t&
    hintStyle()
    {
        return hintStyle_;
    }
    const int32_t&
    hintStyle() const
    {
        return hintStyle_;
    }

    int32_t&
    lcdFilter()
    {
        return lcdFilter_;
    }
    const int32_t&
    lcdFilter() const
    {
        return lcdFilter_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<int32_t> antialias_;
    ::mozilla::ipc::IPDLStructMember<int32_t> subpixelOrder_;
    ::mozilla::ipc::IPDLStructMember<int32_t> hintStyle_;
    ::mozilla::ipc::IPDLStructMember<int32_t> lcdFilter_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::SystemFontOptions>
{
    typedef ::mozilla::dom::SystemFontOptions paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SystemFontList|
//
namespace mozilla {
namespace dom {
class SystemFontList final
{
private:
    typedef ::mozilla::dom::SystemFontListEntry SystemFontListEntry;
    typedef ::mozilla::dom::SystemFontOptions SystemFontOptions;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SystemFontList() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SystemFontList(
            const nsTArray<SystemFontListEntry>& _entries,
            const SystemFontOptions& _options) :
        entries_(_entries),
        options_(_options)
    {
    }

    MOZ_IMPLICIT SystemFontList(
            nsTArray<SystemFontListEntry>&& _entries,
            SystemFontOptions&& _options) :
        entries_(std::move(_entries)),
        options_(std::move(_options))
    {
    }

    nsTArray<SystemFontListEntry>&
    entries()
    {
        return entries_;
    }
    const nsTArray<SystemFontListEntry>&
    entries() const
    {
        return entries_;
    }

    SystemFontOptions&
    options()
    {
        return options_;
    }
    const SystemFontOptions&
    options() const
    {
        return options_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<SystemFontListEntry>> entries_;
    ::mozilla::ipc::IPDLStructMember<SystemFontOptions> options_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::SystemFontList>
{
    typedef ::mozilla::dom::SystemFontList paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union SystemParameterValue|
//
namespace mozilla {
namespace dom {
class SystemParameterValue final
{
public:
    enum Type {
        T__None,
        Tbool = 1,
        Tfloat,
        T__Last = Tfloat
    };

private:
    typedef bool bool__tdef;
    typedef float float__tdef;

    bool*
    ptr_bool()
    {
        return (&(mVbool));
    }
    const bool*
    constptr_bool() const
    {
        return (&(mVbool));
    }
    float*
    ptr_float()
    {
        return (&(mVfloat));
    }
    const float*
    constptr_float() const
    {
        return (&(mVfloat));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT SystemParameterValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT SystemParameterValue(const bool& aOther);

    MOZ_IMPLICIT SystemParameterValue(bool&& aOther);

    MOZ_IMPLICIT SystemParameterValue(const float& aOther);

    MOZ_IMPLICIT SystemParameterValue(float&& aOther);

    MOZ_IMPLICIT SystemParameterValue(const SystemParameterValue& aOther);

    MOZ_IMPLICIT SystemParameterValue(SystemParameterValue&& aOther);

    ~SystemParameterValue();

    Type
    type() const
    {
        return mType;
    }

    SystemParameterValue&
    operator=(const bool& aRhs);

    SystemParameterValue&
    operator=(bool&& aRhs);

    SystemParameterValue&
    operator=(const float& aRhs);

    SystemParameterValue&
    operator=(float&& aRhs);

    SystemParameterValue&
    operator=(const SystemParameterValue& aRhs);

    SystemParameterValue&
    operator=(SystemParameterValue&& aRhs);

    bool&
    get_bool()
    {
        AssertSanity(Tbool);
        return (*(ptr_bool()));
    }
    const bool&
    get_bool() const
    {
        AssertSanity(Tbool);
        return (*(constptr_bool()));
    }
    operator bool&()
    {
        return get_bool();
    }
    operator const bool&() const
    {
        return get_bool();
    }

    float&
    get_float()
    {
        AssertSanity(Tfloat);
        return (*(ptr_float()));
    }
    const float&
    get_float() const
    {
        AssertSanity(Tfloat);
        return (*(constptr_float()));
    }
    operator float&()
    {
        return get_float();
    }
    operator const float&() const
    {
        return get_float();
    }

private:
    union {
        bool mVbool;
        float mVfloat;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::SystemParameterValue>
{
    typedef ::mozilla::dom::SystemParameterValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClipboardCapabilities|
//
namespace mozilla {
namespace dom {
class ClipboardCapabilities final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClipboardCapabilities() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClipboardCapabilities(
            const bool& _supportsSelectionClipboard,
            const bool& _supportsFindClipboard,
            const bool& _supportsSelectionCache) :
        supportsSelectionClipboard_(_supportsSelectionClipboard),
        supportsFindClipboard_(_supportsFindClipboard),
        supportsSelectionCache_(_supportsSelectionCache)
    {
    }

    MOZ_IMPLICIT ClipboardCapabilities(
            bool&& _supportsSelectionClipboard,
            bool&& _supportsFindClipboard,
            bool&& _supportsSelectionCache) :
        supportsSelectionClipboard_(std::move(_supportsSelectionClipboard)),
        supportsFindClipboard_(std::move(_supportsFindClipboard)),
        supportsSelectionCache_(std::move(_supportsSelectionCache))
    {
    }

    bool&
    supportsSelectionClipboard()
    {
        return supportsSelectionClipboard_;
    }
    const bool&
    supportsSelectionClipboard() const
    {
        return supportsSelectionClipboard_;
    }

    bool&
    supportsFindClipboard()
    {
        return supportsFindClipboard_;
    }
    const bool&
    supportsFindClipboard() const
    {
        return supportsFindClipboard_;
    }

    bool&
    supportsSelectionCache()
    {
        return supportsSelectionCache_;
    }
    const bool&
    supportsSelectionCache() const
    {
        return supportsSelectionCache_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> supportsSelectionClipboard_;
    ::mozilla::ipc::IPDLStructMember<bool> supportsFindClipboard_;
    ::mozilla::ipc::IPDLStructMember<bool> supportsSelectionCache_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClipboardCapabilities>
{
    typedef ::mozilla::dom::ClipboardCapabilities paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileDescOrError|
//
namespace mozilla {
namespace dom {
class FileDescOrError final
{
public:
    enum Type {
        T__None,
        TFileDescriptor = 1,
        Tnsresult,
        T__Last = Tnsresult
    };

private:
    typedef ::mozilla::ipc::FileDescriptor FileDescriptor;
    typedef ::nsresult nsresult;
    typedef FileDescriptor FileDescriptor__tdef;
    typedef nsresult nsresult__tdef;

    FileDescriptor*
    ptr_FileDescriptor()
    {
        return (&(mVFileDescriptor));
    }
    const FileDescriptor*
    constptr_FileDescriptor() const
    {
        return (&(mVFileDescriptor));
    }
    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileDescOrError() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileDescOrError(const FileDescriptor& aOther);

    MOZ_IMPLICIT FileDescOrError(FileDescriptor&& aOther);

    MOZ_IMPLICIT FileDescOrError(const nsresult& aOther);

    MOZ_IMPLICIT FileDescOrError(nsresult&& aOther);

    MOZ_IMPLICIT FileDescOrError(const FileDescOrError& aOther);

    MOZ_IMPLICIT FileDescOrError(FileDescOrError&& aOther);

    ~FileDescOrError();

    Type
    type() const
    {
        return mType;
    }

    FileDescOrError&
    operator=(const FileDescriptor& aRhs);

    FileDescOrError&
    operator=(FileDescriptor&& aRhs);

    FileDescOrError&
    operator=(const nsresult& aRhs);

    FileDescOrError&
    operator=(nsresult&& aRhs);

    FileDescOrError&
    operator=(const FileDescOrError& aRhs);

    FileDescOrError&
    operator=(FileDescOrError&& aRhs);

    FileDescriptor&
    get_FileDescriptor()
    {
        AssertSanity(TFileDescriptor);
        return (*(ptr_FileDescriptor()));
    }
    const FileDescriptor&
    get_FileDescriptor() const
    {
        AssertSanity(TFileDescriptor);
        return (*(constptr_FileDescriptor()));
    }
    operator FileDescriptor&()
    {
        return get_FileDescriptor();
    }
    operator const FileDescriptor&() const
    {
        return get_FileDescriptor();
    }

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

private:
    union {
        FileDescriptor mVFileDescriptor;
        nsresult mVnsresult;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileDescOrError>
{
    typedef ::mozilla::dom::FileDescOrError paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DomainPolicyClone|
//
namespace mozilla {
namespace dom {
class DomainPolicyClone final
{
private:
    typedef ::nsIURI nsIURI;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DomainPolicyClone() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DomainPolicyClone(
            const bool& _active,
            const nsTArray<RefPtr<nsIURI>>& _blocklist,
            const nsTArray<RefPtr<nsIURI>>& _allowlist,
            const nsTArray<RefPtr<nsIURI>>& _superBlocklist,
            const nsTArray<RefPtr<nsIURI>>& _superAllowlist) :
        active_(_active),
        blocklist_(_blocklist),
        allowlist_(_allowlist),
        superBlocklist_(_superBlocklist),
        superAllowlist_(_superAllowlist)
    {
    }

    MOZ_IMPLICIT DomainPolicyClone(
            bool&& _active,
            nsTArray<RefPtr<nsIURI>>&& _blocklist,
            nsTArray<RefPtr<nsIURI>>&& _allowlist,
            nsTArray<RefPtr<nsIURI>>&& _superBlocklist,
            nsTArray<RefPtr<nsIURI>>&& _superAllowlist) :
        active_(std::move(_active)),
        blocklist_(std::move(_blocklist)),
        allowlist_(std::move(_allowlist)),
        superBlocklist_(std::move(_superBlocklist)),
        superAllowlist_(std::move(_superAllowlist))
    {
    }

    bool&
    active()
    {
        return active_;
    }
    const bool&
    active() const
    {
        return active_;
    }

    nsTArray<RefPtr<nsIURI>>&
    blocklist()
    {
        return blocklist_;
    }
    const nsTArray<RefPtr<nsIURI>>&
    blocklist() const
    {
        return blocklist_;
    }

    nsTArray<RefPtr<nsIURI>>&
    allowlist()
    {
        return allowlist_;
    }
    const nsTArray<RefPtr<nsIURI>>&
    allowlist() const
    {
        return allowlist_;
    }

    nsTArray<RefPtr<nsIURI>>&
    superBlocklist()
    {
        return superBlocklist_;
    }
    const nsTArray<RefPtr<nsIURI>>&
    superBlocklist() const
    {
        return superBlocklist_;
    }

    nsTArray<RefPtr<nsIURI>>&
    superAllowlist()
    {
        return superAllowlist_;
    }
    const nsTArray<RefPtr<nsIURI>>&
    superAllowlist() const
    {
        return superAllowlist_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> active_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<RefPtr<nsIURI>>> blocklist_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<RefPtr<nsIURI>>> allowlist_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<RefPtr<nsIURI>>> superBlocklist_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<RefPtr<nsIURI>>> superAllowlist_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::DomainPolicyClone>
{
    typedef ::mozilla::dom::DomainPolicyClone paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct AndroidSystemInfo|
//
namespace mozilla {
namespace dom {
class AndroidSystemInfo final
{
private:
    typedef ::nsString nsString;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    AndroidSystemInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT AndroidSystemInfo(
            const nsString& _device,
            const nsString& _manufacturer,
            const nsString& _release_version,
            const nsString& _hardware,
            const uint32_t& _sdk_version,
            const bool& _isTablet) :
        device_(_device),
        manufacturer_(_manufacturer),
        release_version_(_release_version),
        hardware_(_hardware),
        isTablet_(_isTablet),
        sdk_version_(_sdk_version)
    {
    }

    MOZ_IMPLICIT AndroidSystemInfo(
            nsString&& _device,
            nsString&& _manufacturer,
            nsString&& _release_version,
            nsString&& _hardware,
            uint32_t&& _sdk_version,
            bool&& _isTablet) :
        device_(std::move(_device)),
        manufacturer_(std::move(_manufacturer)),
        release_version_(std::move(_release_version)),
        hardware_(std::move(_hardware)),
        isTablet_(std::move(_isTablet)),
        sdk_version_(std::move(_sdk_version))
    {
    }

    nsString&
    device()
    {
        return device_;
    }
    const nsString&
    device() const
    {
        return device_;
    }

    nsString&
    manufacturer()
    {
        return manufacturer_;
    }
    const nsString&
    manufacturer() const
    {
        return manufacturer_;
    }

    nsString&
    release_version()
    {
        return release_version_;
    }
    const nsString&
    release_version() const
    {
        return release_version_;
    }

    nsString&
    hardware()
    {
        return hardware_;
    }
    const nsString&
    hardware() const
    {
        return hardware_;
    }

    uint32_t&
    sdk_version()
    {
        return sdk_version_;
    }
    const uint32_t&
    sdk_version() const
    {
        return sdk_version_;
    }

    bool&
    isTablet()
    {
        return isTablet_;
    }
    const bool&
    isTablet() const
    {
        return isTablet_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> device_;
    ::mozilla::ipc::IPDLStructMember<nsString> manufacturer_;
    ::mozilla::ipc::IPDLStructMember<nsString> release_version_;
    ::mozilla::ipc::IPDLStructMember<nsString> hardware_;
    ::mozilla::ipc::IPDLStructMember<bool> isTablet_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> sdk_version_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::AndroidSystemInfo>
{
    typedef ::mozilla::dom::AndroidSystemInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GetFilesResponseSuccess|
//
namespace mozilla {
namespace dom {
class GetFilesResponseSuccess final
{
private:
    typedef ::mozilla::dom::IPCBlob IPCBlob;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GetFilesResponseSuccess() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GetFilesResponseSuccess(const nsTArray<IPCBlob>& _blobs) :
        blobs_(_blobs)
    {
    }

    MOZ_IMPLICIT GetFilesResponseSuccess(nsTArray<IPCBlob>&& _blobs) :
        blobs_(std::move(_blobs))
    {
    }

    nsTArray<IPCBlob>&
    blobs()
    {
        return blobs_;
    }
    const nsTArray<IPCBlob>&
    blobs() const
    {
        return blobs_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCBlob>> blobs_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::GetFilesResponseSuccess>
{
    typedef ::mozilla::dom::GetFilesResponseSuccess paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GetFilesResponseFailure|
//
namespace mozilla {
namespace dom {
class GetFilesResponseFailure final
{
private:
    typedef ::nsresult nsresult;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GetFilesResponseFailure() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GetFilesResponseFailure(const nsresult& _errorCode) :
        errorCode_(_errorCode)
    {
    }

    MOZ_IMPLICIT GetFilesResponseFailure(nsresult&& _errorCode) :
        errorCode_(std::move(_errorCode))
    {
    }

    nsresult&
    errorCode()
    {
        return errorCode_;
    }
    const nsresult&
    errorCode() const
    {
        return errorCode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsresult> errorCode_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::GetFilesResponseFailure>
{
    typedef ::mozilla::dom::GetFilesResponseFailure paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union GetFilesResponseResult|
//
namespace mozilla {
namespace dom {
class GetFilesResponseResult final
{
public:
    enum Type {
        T__None,
        TGetFilesResponseSuccess = 1,
        TGetFilesResponseFailure,
        T__Last = TGetFilesResponseFailure
    };

private:
    typedef ::mozilla::dom::GetFilesResponseSuccess GetFilesResponseSuccess;
    typedef ::mozilla::dom::GetFilesResponseFailure GetFilesResponseFailure;
    typedef GetFilesResponseSuccess GetFilesResponseSuccess__tdef;
    typedef GetFilesResponseFailure GetFilesResponseFailure__tdef;

    GetFilesResponseSuccess*
    ptr_GetFilesResponseSuccess()
    {
        return (&(mVGetFilesResponseSuccess));
    }
    const GetFilesResponseSuccess*
    constptr_GetFilesResponseSuccess() const
    {
        return (&(mVGetFilesResponseSuccess));
    }
    GetFilesResponseFailure*
    ptr_GetFilesResponseFailure()
    {
        return (&(mVGetFilesResponseFailure));
    }
    const GetFilesResponseFailure*
    constptr_GetFilesResponseFailure() const
    {
        return (&(mVGetFilesResponseFailure));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT GetFilesResponseResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT GetFilesResponseResult(const GetFilesResponseSuccess& aOther);

    MOZ_IMPLICIT GetFilesResponseResult(GetFilesResponseSuccess&& aOther);

    MOZ_IMPLICIT GetFilesResponseResult(const GetFilesResponseFailure& aOther);

    MOZ_IMPLICIT GetFilesResponseResult(GetFilesResponseFailure&& aOther);

    MOZ_IMPLICIT GetFilesResponseResult(const GetFilesResponseResult& aOther);

    MOZ_IMPLICIT GetFilesResponseResult(GetFilesResponseResult&& aOther);

    ~GetFilesResponseResult();

    Type
    type() const
    {
        return mType;
    }

    GetFilesResponseResult&
    operator=(const GetFilesResponseSuccess& aRhs);

    GetFilesResponseResult&
    operator=(GetFilesResponseSuccess&& aRhs);

    GetFilesResponseResult&
    operator=(const GetFilesResponseFailure& aRhs);

    GetFilesResponseResult&
    operator=(GetFilesResponseFailure&& aRhs);

    GetFilesResponseResult&
    operator=(const GetFilesResponseResult& aRhs);

    GetFilesResponseResult&
    operator=(GetFilesResponseResult&& aRhs);

    GetFilesResponseSuccess&
    get_GetFilesResponseSuccess()
    {
        AssertSanity(TGetFilesResponseSuccess);
        return (*(ptr_GetFilesResponseSuccess()));
    }
    const GetFilesResponseSuccess&
    get_GetFilesResponseSuccess() const
    {
        AssertSanity(TGetFilesResponseSuccess);
        return (*(constptr_GetFilesResponseSuccess()));
    }
    operator GetFilesResponseSuccess&()
    {
        return get_GetFilesResponseSuccess();
    }
    operator const GetFilesResponseSuccess&() const
    {
        return get_GetFilesResponseSuccess();
    }

    GetFilesResponseFailure&
    get_GetFilesResponseFailure()
    {
        AssertSanity(TGetFilesResponseFailure);
        return (*(ptr_GetFilesResponseFailure()));
    }
    const GetFilesResponseFailure&
    get_GetFilesResponseFailure() const
    {
        AssertSanity(TGetFilesResponseFailure);
        return (*(constptr_GetFilesResponseFailure()));
    }
    operator GetFilesResponseFailure&()
    {
        return get_GetFilesResponseFailure();
    }
    operator const GetFilesResponseFailure&() const
    {
        return get_GetFilesResponseFailure();
    }

private:
    union {
        GetFilesResponseSuccess mVGetFilesResponseSuccess;
        GetFilesResponseFailure mVGetFilesResponseFailure;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::GetFilesResponseResult>
{
    typedef ::mozilla::dom::GetFilesResponseResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct BlobURLRegistrationData|
//
namespace mozilla {
namespace dom {
class BlobURLRegistrationData final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::IPCBlob IPCBlob;
    typedef ::nsIPrincipal nsIPrincipal;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    BlobURLRegistrationData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT BlobURLRegistrationData(
            const nsCString& _url,
            const IPCBlob& _blob,
            mozilla::NotNull<nsIPrincipal*> _principal,
            const nsCString& _partitionKey,
            const bool& _revoked) :
        url_(_url),
        blob_(_blob),
        principal_(_principal),
        partitionKey_(_partitionKey),
        revoked_(_revoked)
    {
    }

    MOZ_IMPLICIT BlobURLRegistrationData(
            nsCString&& _url,
            IPCBlob&& _blob,
            mozilla::NotNull<RefPtr<nsIPrincipal>>&& _principal,
            nsCString&& _partitionKey,
            bool&& _revoked) :
        url_(std::move(_url)),
        blob_(std::move(_blob)),
        principal_(std::move(_principal)),
        partitionKey_(std::move(_partitionKey)),
        revoked_(std::move(_revoked))
    {
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    IPCBlob&
    blob()
    {
        return blob_;
    }
    const IPCBlob&
    blob() const
    {
        return blob_;
    }

    mozilla::NotNull<RefPtr<nsIPrincipal>>&
    principal()
    {
        return principal_;
    }
    mozilla::NotNull<nsIPrincipal*>
    principal() const
    {
        return principal_;
    }

    nsCString&
    partitionKey()
    {
        return partitionKey_;
    }
    const nsCString&
    partitionKey() const
    {
        return partitionKey_;
    }

    bool&
    revoked()
    {
        return revoked_;
    }
    const bool&
    revoked() const
    {
        return revoked_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<IPCBlob> blob_;
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<RefPtr<nsIPrincipal>>> principal_;
    ::mozilla::ipc::IPDLStructMember<nsCString> partitionKey_;
    ::mozilla::ipc::IPDLStructMember<bool> revoked_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::BlobURLRegistrationData>
{
    typedef ::mozilla::dom::BlobURLRegistrationData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct JSWindowActorEventDecl|
//
namespace mozilla {
namespace dom {
class JSWindowActorEventDecl final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    JSWindowActorEventDecl() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT JSWindowActorEventDecl(
            const nsString& _name,
            const bool& _capture,
            const bool& _systemGroup,
            const bool& _allowUntrusted,
            const mozilla::Maybe<bool>& _passive,
            const bool& _createActor) :
        name_(_name),
        capture_(_capture),
        systemGroup_(_systemGroup),
        allowUntrusted_(_allowUntrusted),
        passive_(_passive),
        createActor_(_createActor)
    {
    }

    MOZ_IMPLICIT JSWindowActorEventDecl(
            nsString&& _name,
            bool&& _capture,
            bool&& _systemGroup,
            bool&& _allowUntrusted,
            mozilla::Maybe<bool>&& _passive,
            bool&& _createActor) :
        name_(std::move(_name)),
        capture_(std::move(_capture)),
        systemGroup_(std::move(_systemGroup)),
        allowUntrusted_(std::move(_allowUntrusted)),
        passive_(std::move(_passive)),
        createActor_(std::move(_createActor))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    bool&
    capture()
    {
        return capture_;
    }
    const bool&
    capture() const
    {
        return capture_;
    }

    bool&
    systemGroup()
    {
        return systemGroup_;
    }
    const bool&
    systemGroup() const
    {
        return systemGroup_;
    }

    bool&
    allowUntrusted()
    {
        return allowUntrusted_;
    }
    const bool&
    allowUntrusted() const
    {
        return allowUntrusted_;
    }

    mozilla::Maybe<bool>&
    passive()
    {
        return passive_;
    }
    const mozilla::Maybe<bool>&
    passive() const
    {
        return passive_;
    }

    bool&
    createActor()
    {
        return createActor_;
    }
    const bool&
    createActor() const
    {
        return createActor_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<bool> capture_;
    ::mozilla::ipc::IPDLStructMember<bool> systemGroup_;
    ::mozilla::ipc::IPDLStructMember<bool> allowUntrusted_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<bool>> passive_;
    ::mozilla::ipc::IPDLStructMember<bool> createActor_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::JSWindowActorEventDecl>
{
    typedef ::mozilla::dom::JSWindowActorEventDecl paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct JSWindowActorInfo|
//
namespace mozilla {
namespace dom {
class JSWindowActorInfo final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::JSWindowActorEventDecl JSWindowActorEventDecl;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    JSWindowActorInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT JSWindowActorInfo(
            const nsCString& _name,
            const bool& _allFrames,
            const bool& _loadInDevToolsLoader,
            const mozilla::Maybe<nsCString>& _url,
            const nsTArray<JSWindowActorEventDecl>& _events,
            const nsTArray<nsCString>& _observers,
            const nsTArray<nsString>& _matches,
            const nsTArray<nsCString>& _remoteTypes,
            const nsTArray<nsString>& _messageManagerGroups) :
        name_(_name),
        allFrames_(_allFrames),
        loadInDevToolsLoader_(_loadInDevToolsLoader),
        url_(_url),
        events_(_events),
        observers_(_observers),
        matches_(_matches),
        remoteTypes_(_remoteTypes),
        messageManagerGroups_(_messageManagerGroups)
    {
    }

    MOZ_IMPLICIT JSWindowActorInfo(
            nsCString&& _name,
            bool&& _allFrames,
            bool&& _loadInDevToolsLoader,
            mozilla::Maybe<nsCString>&& _url,
            nsTArray<JSWindowActorEventDecl>&& _events,
            nsTArray<nsCString>&& _observers,
            nsTArray<nsString>&& _matches,
            nsTArray<nsCString>&& _remoteTypes,
            nsTArray<nsString>&& _messageManagerGroups) :
        name_(std::move(_name)),
        allFrames_(std::move(_allFrames)),
        loadInDevToolsLoader_(std::move(_loadInDevToolsLoader)),
        url_(std::move(_url)),
        events_(std::move(_events)),
        observers_(std::move(_observers)),
        matches_(std::move(_matches)),
        remoteTypes_(std::move(_remoteTypes)),
        messageManagerGroups_(std::move(_messageManagerGroups))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    bool&
    allFrames()
    {
        return allFrames_;
    }
    const bool&
    allFrames() const
    {
        return allFrames_;
    }

    bool&
    loadInDevToolsLoader()
    {
        return loadInDevToolsLoader_;
    }
    const bool&
    loadInDevToolsLoader() const
    {
        return loadInDevToolsLoader_;
    }

    mozilla::Maybe<nsCString>&
    url()
    {
        return url_;
    }
    const mozilla::Maybe<nsCString>&
    url() const
    {
        return url_;
    }

    nsTArray<JSWindowActorEventDecl>&
    events()
    {
        return events_;
    }
    const nsTArray<JSWindowActorEventDecl>&
    events() const
    {
        return events_;
    }

    nsTArray<nsCString>&
    observers()
    {
        return observers_;
    }
    const nsTArray<nsCString>&
    observers() const
    {
        return observers_;
    }

    nsTArray<nsString>&
    matches()
    {
        return matches_;
    }
    const nsTArray<nsString>&
    matches() const
    {
        return matches_;
    }

    nsTArray<nsCString>&
    remoteTypes()
    {
        return remoteTypes_;
    }
    const nsTArray<nsCString>&
    remoteTypes() const
    {
        return remoteTypes_;
    }

    nsTArray<nsString>&
    messageManagerGroups()
    {
        return messageManagerGroups_;
    }
    const nsTArray<nsString>&
    messageManagerGroups() const
    {
        return messageManagerGroups_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<bool> allFrames_;
    ::mozilla::ipc::IPDLStructMember<bool> loadInDevToolsLoader_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> url_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<JSWindowActorEventDecl>> events_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> observers_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> matches_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> remoteTypes_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> messageManagerGroups_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::JSWindowActorInfo>
{
    typedef ::mozilla::dom::JSWindowActorInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct JSProcessActorInfo|
//
namespace mozilla {
namespace dom {
class JSProcessActorInfo final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    JSProcessActorInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT JSProcessActorInfo(
            const nsCString& _name,
            const bool& _isESModule,
            const bool& _loadInDevToolsLoader,
            const mozilla::Maybe<nsCString>& _url,
            const nsTArray<nsCString>& _observers,
            const nsTArray<nsCString>& _remoteTypes) :
        name_(_name),
        isESModule_(_isESModule),
        loadInDevToolsLoader_(_loadInDevToolsLoader),
        url_(_url),
        observers_(_observers),
        remoteTypes_(_remoteTypes)
    {
    }

    MOZ_IMPLICIT JSProcessActorInfo(
            nsCString&& _name,
            bool&& _isESModule,
            bool&& _loadInDevToolsLoader,
            mozilla::Maybe<nsCString>&& _url,
            nsTArray<nsCString>&& _observers,
            nsTArray<nsCString>&& _remoteTypes) :
        name_(std::move(_name)),
        isESModule_(std::move(_isESModule)),
        loadInDevToolsLoader_(std::move(_loadInDevToolsLoader)),
        url_(std::move(_url)),
        observers_(std::move(_observers)),
        remoteTypes_(std::move(_remoteTypes))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    bool&
    isESModule()
    {
        return isESModule_;
    }
    const bool&
    isESModule() const
    {
        return isESModule_;
    }

    bool&
    loadInDevToolsLoader()
    {
        return loadInDevToolsLoader_;
    }
    const bool&
    loadInDevToolsLoader() const
    {
        return loadInDevToolsLoader_;
    }

    mozilla::Maybe<nsCString>&
    url()
    {
        return url_;
    }
    const mozilla::Maybe<nsCString>&
    url() const
    {
        return url_;
    }

    nsTArray<nsCString>&
    observers()
    {
        return observers_;
    }
    const nsTArray<nsCString>&
    observers() const
    {
        return observers_;
    }

    nsTArray<nsCString>&
    remoteTypes()
    {
        return remoteTypes_;
    }
    const nsTArray<nsCString>&
    remoteTypes() const
    {
        return remoteTypes_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<bool> isESModule_;
    ::mozilla::ipc::IPDLStructMember<bool> loadInDevToolsLoader_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> url_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> observers_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> remoteTypes_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::JSProcessActorInfo>
{
    typedef ::mozilla::dom::JSProcessActorInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GMPAPITags|
//
namespace mozilla {
namespace dom {
class GMPAPITags final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GMPAPITags() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GMPAPITags(
            const nsCString& _api,
            const nsTArray<nsCString>& _tags) :
        api_(_api),
        tags_(_tags)
    {
    }

    MOZ_IMPLICIT GMPAPITags(
            nsCString&& _api,
            nsTArray<nsCString>&& _tags) :
        api_(std::move(_api)),
        tags_(std::move(_tags))
    {
    }

    nsCString&
    api()
    {
        return api_;
    }
    const nsCString&
    api() const
    {
        return api_;
    }

    nsTArray<nsCString>&
    tags()
    {
        return tags_;
    }
    const nsTArray<nsCString>&
    tags() const
    {
        return tags_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> api_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> tags_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::GMPAPITags>
{
    typedef ::mozilla::dom::GMPAPITags paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct GMPCapabilityData|
//
namespace mozilla {
namespace dom {
class GMPCapabilityData final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::GMPAPITags GMPAPITags;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    GMPCapabilityData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT GMPCapabilityData(
            const nsCString& _name,
            const nsCString& _version,
            const nsTArray<GMPAPITags>& _capabilities) :
        name_(_name),
        version_(_version),
        capabilities_(_capabilities)
    {
    }

    MOZ_IMPLICIT GMPCapabilityData(
            nsCString&& _name,
            nsCString&& _version,
            nsTArray<GMPAPITags>&& _capabilities) :
        name_(std::move(_name)),
        version_(std::move(_version)),
        capabilities_(std::move(_capabilities))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    nsCString&
    version()
    {
        return version_;
    }
    const nsCString&
    version() const
    {
        return version_;
    }

    nsTArray<GMPAPITags>&
    capabilities()
    {
        return capabilities_;
    }
    const nsTArray<GMPAPITags>&
    capabilities() const
    {
        return capabilities_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<nsCString> version_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<GMPAPITags>> capabilities_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::GMPCapabilityData>
{
    typedef ::mozilla::dom::GMPCapabilityData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct L10nFileSourceDescriptor|
//
namespace mozilla {
namespace dom {
class L10nFileSourceDescriptor final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    L10nFileSourceDescriptor() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT L10nFileSourceDescriptor(
            const nsCString& _name,
            const nsCString& _metasource,
            const nsTArray<nsCString>& _locales,
            const nsCString& _prePath,
            const nsTArray<nsCString>& _index) :
        name_(_name),
        metasource_(_metasource),
        locales_(_locales),
        prePath_(_prePath),
        index_(_index)
    {
    }

    MOZ_IMPLICIT L10nFileSourceDescriptor(
            nsCString&& _name,
            nsCString&& _metasource,
            nsTArray<nsCString>&& _locales,
            nsCString&& _prePath,
            nsTArray<nsCString>&& _index) :
        name_(std::move(_name)),
        metasource_(std::move(_metasource)),
        locales_(std::move(_locales)),
        prePath_(std::move(_prePath)),
        index_(std::move(_index))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    nsCString&
    metasource()
    {
        return metasource_;
    }
    const nsCString&
    metasource() const
    {
        return metasource_;
    }

    nsTArray<nsCString>&
    locales()
    {
        return locales_;
    }
    const nsTArray<nsCString>&
    locales() const
    {
        return locales_;
    }

    nsCString&
    prePath()
    {
        return prePath_;
    }
    const nsCString&
    prePath() const
    {
        return prePath_;
    }

    nsTArray<nsCString>&
    index()
    {
        return index_;
    }
    const nsTArray<nsCString>&
    index() const
    {
        return index_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<nsCString> metasource_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> locales_;
    ::mozilla::ipc::IPDLStructMember<nsCString> prePath_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> index_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::L10nFileSourceDescriptor>
{
    typedef ::mozilla::dom::L10nFileSourceDescriptor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct XPCOMInitData|
//
namespace mozilla {
namespace dom {
class XPCOMInitData final
{
private:
    typedef ::int32_t int32_t;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::ClipboardCapabilities ClipboardCapabilities;
    typedef ::mozilla::dom::DomainPolicyClone DomainPolicyClone;
    typedef ::nsIURI nsIURI;
    typedef ::mozilla::gfx::GfxVarUpdate GfxVarUpdate;
    typedef ::mozilla::gfx::ContentDeviceData ContentDeviceData;
    typedef ::mozilla::gfx::GfxInfoFeatureStatus GfxInfoFeatureStatus;
    typedef ::mozilla::dom::L10nFileSourceDescriptor L10nFileSourceDescriptor;
    typedef ::mozilla::Telemetry::DynamicScalarDefinition DynamicScalarDefinition;
    typedef ::mozilla::PerfStats::MetricMask MetricMask;
    typedef ::nsIDNSService::ResolverMode ResolverMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    XPCOMInitData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT XPCOMInitData(
            const bool& _isOffline,
            const bool& _isConnected,
            const int32_t& _captivePortalState,
            const bool& _isLangRTL,
            const bool& _haveBidiKeyboards,
            const nsTArray<nsCString>& _dictionaries,
            const ClipboardCapabilities& _clipboardCaps,
            const DomainPolicyClone& _domainPolicy,
            nsIURI* _userContentSheetURL,
            const nsTArray<GfxVarUpdate>& _gfxNonDefaultVarUpdates,
            const ContentDeviceData& _contentDeviceData,
            const nsTArray<GfxInfoFeatureStatus>& _gfxFeatureStatus,
            const nsTArray<nsCString>& _sysLocales,
            const nsTArray<nsCString>& _appLocales,
            const nsTArray<nsCString>& _requestedLocales,
            const nsTArray<L10nFileSourceDescriptor>& _l10nFileSources,
            const nsTArray<DynamicScalarDefinition>& _dynamicScalarDefs,
            const MetricMask& _perfStatsMask,
            const nsCString& _trrDomain,
            const ResolverMode& _trrMode,
            const ResolverMode& _trrModeFromPref) :
        isOffline_(_isOffline),
        isConnected_(_isConnected),
        isLangRTL_(_isLangRTL),
        haveBidiKeyboards_(_haveBidiKeyboards),
        dictionaries_(_dictionaries),
        clipboardCaps_(_clipboardCaps),
        domainPolicy_(_domainPolicy),
        userContentSheetURL_(_userContentSheetURL),
        gfxNonDefaultVarUpdates_(_gfxNonDefaultVarUpdates),
        contentDeviceData_(_contentDeviceData),
        gfxFeatureStatus_(_gfxFeatureStatus),
        sysLocales_(_sysLocales),
        appLocales_(_appLocales),
        requestedLocales_(_requestedLocales),
        l10nFileSources_(_l10nFileSources),
        dynamicScalarDefs_(_dynamicScalarDefs),
        perfStatsMask_(_perfStatsMask),
        trrDomain_(_trrDomain),
        trrMode_(_trrMode),
        trrModeFromPref_(_trrModeFromPref),
        captivePortalState_(_captivePortalState)
    {
    }

    MOZ_IMPLICIT XPCOMInitData(
            bool&& _isOffline,
            bool&& _isConnected,
            int32_t&& _captivePortalState,
            bool&& _isLangRTL,
            bool&& _haveBidiKeyboards,
            nsTArray<nsCString>&& _dictionaries,
            ClipboardCapabilities&& _clipboardCaps,
            DomainPolicyClone&& _domainPolicy,
            RefPtr<nsIURI>&& _userContentSheetURL,
            nsTArray<GfxVarUpdate>&& _gfxNonDefaultVarUpdates,
            ContentDeviceData&& _contentDeviceData,
            nsTArray<GfxInfoFeatureStatus>&& _gfxFeatureStatus,
            nsTArray<nsCString>&& _sysLocales,
            nsTArray<nsCString>&& _appLocales,
            nsTArray<nsCString>&& _requestedLocales,
            nsTArray<L10nFileSourceDescriptor>&& _l10nFileSources,
            nsTArray<DynamicScalarDefinition>&& _dynamicScalarDefs,
            MetricMask&& _perfStatsMask,
            nsCString&& _trrDomain,
            ResolverMode&& _trrMode,
            ResolverMode&& _trrModeFromPref) :
        isOffline_(std::move(_isOffline)),
        isConnected_(std::move(_isConnected)),
        isLangRTL_(std::move(_isLangRTL)),
        haveBidiKeyboards_(std::move(_haveBidiKeyboards)),
        dictionaries_(std::move(_dictionaries)),
        clipboardCaps_(std::move(_clipboardCaps)),
        domainPolicy_(std::move(_domainPolicy)),
        userContentSheetURL_(std::move(_userContentSheetURL)),
        gfxNonDefaultVarUpdates_(std::move(_gfxNonDefaultVarUpdates)),
        contentDeviceData_(std::move(_contentDeviceData)),
        gfxFeatureStatus_(std::move(_gfxFeatureStatus)),
        sysLocales_(std::move(_sysLocales)),
        appLocales_(std::move(_appLocales)),
        requestedLocales_(std::move(_requestedLocales)),
        l10nFileSources_(std::move(_l10nFileSources)),
        dynamicScalarDefs_(std::move(_dynamicScalarDefs)),
        perfStatsMask_(std::move(_perfStatsMask)),
        trrDomain_(std::move(_trrDomain)),
        trrMode_(std::move(_trrMode)),
        trrModeFromPref_(std::move(_trrModeFromPref)),
        captivePortalState_(std::move(_captivePortalState))
    {
    }

    bool&
    isOffline()
    {
        return isOffline_;
    }
    const bool&
    isOffline() const
    {
        return isOffline_;
    }

    bool&
    isConnected()
    {
        return isConnected_;
    }
    const bool&
    isConnected() const
    {
        return isConnected_;
    }

    int32_t&
    captivePortalState()
    {
        return captivePortalState_;
    }
    const int32_t&
    captivePortalState() const
    {
        return captivePortalState_;
    }

    bool&
    isLangRTL()
    {
        return isLangRTL_;
    }
    const bool&
    isLangRTL() const
    {
        return isLangRTL_;
    }

    bool&
    haveBidiKeyboards()
    {
        return haveBidiKeyboards_;
    }
    const bool&
    haveBidiKeyboards() const
    {
        return haveBidiKeyboards_;
    }

    nsTArray<nsCString>&
    dictionaries()
    {
        return dictionaries_;
    }
    const nsTArray<nsCString>&
    dictionaries() const
    {
        return dictionaries_;
    }

    ClipboardCapabilities&
    clipboardCaps()
    {
        return clipboardCaps_;
    }
    const ClipboardCapabilities&
    clipboardCaps() const
    {
        return clipboardCaps_;
    }

    DomainPolicyClone&
    domainPolicy()
    {
        return domainPolicy_;
    }
    const DomainPolicyClone&
    domainPolicy() const
    {
        return domainPolicy_;
    }

    RefPtr<nsIURI>&
    userContentSheetURL()
    {
        return userContentSheetURL_;
    }
    nsIURI*
    userContentSheetURL() const
    {
        return userContentSheetURL_;
    }

    nsTArray<GfxVarUpdate>&
    gfxNonDefaultVarUpdates()
    {
        return gfxNonDefaultVarUpdates_;
    }
    const nsTArray<GfxVarUpdate>&
    gfxNonDefaultVarUpdates() const
    {
        return gfxNonDefaultVarUpdates_;
    }

    ContentDeviceData&
    contentDeviceData()
    {
        return contentDeviceData_;
    }
    const ContentDeviceData&
    contentDeviceData() const
    {
        return contentDeviceData_;
    }

    nsTArray<GfxInfoFeatureStatus>&
    gfxFeatureStatus()
    {
        return gfxFeatureStatus_;
    }
    const nsTArray<GfxInfoFeatureStatus>&
    gfxFeatureStatus() const
    {
        return gfxFeatureStatus_;
    }

    nsTArray<nsCString>&
    sysLocales()
    {
        return sysLocales_;
    }
    const nsTArray<nsCString>&
    sysLocales() const
    {
        return sysLocales_;
    }

    nsTArray<nsCString>&
    appLocales()
    {
        return appLocales_;
    }
    const nsTArray<nsCString>&
    appLocales() const
    {
        return appLocales_;
    }

    nsTArray<nsCString>&
    requestedLocales()
    {
        return requestedLocales_;
    }
    const nsTArray<nsCString>&
    requestedLocales() const
    {
        return requestedLocales_;
    }

    nsTArray<L10nFileSourceDescriptor>&
    l10nFileSources()
    {
        return l10nFileSources_;
    }
    const nsTArray<L10nFileSourceDescriptor>&
    l10nFileSources() const
    {
        return l10nFileSources_;
    }

    nsTArray<DynamicScalarDefinition>&
    dynamicScalarDefs()
    {
        return dynamicScalarDefs_;
    }
    const nsTArray<DynamicScalarDefinition>&
    dynamicScalarDefs() const
    {
        return dynamicScalarDefs_;
    }

    MetricMask&
    perfStatsMask()
    {
        return perfStatsMask_;
    }
    const MetricMask&
    perfStatsMask() const
    {
        return perfStatsMask_;
    }

    nsCString&
    trrDomain()
    {
        return trrDomain_;
    }
    const nsCString&
    trrDomain() const
    {
        return trrDomain_;
    }

    ResolverMode&
    trrMode()
    {
        return trrMode_;
    }
    const ResolverMode&
    trrMode() const
    {
        return trrMode_;
    }

    ResolverMode&
    trrModeFromPref()
    {
        return trrModeFromPref_;
    }
    const ResolverMode&
    trrModeFromPref() const
    {
        return trrModeFromPref_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> isOffline_;
    ::mozilla::ipc::IPDLStructMember<bool> isConnected_;
    ::mozilla::ipc::IPDLStructMember<bool> isLangRTL_;
    ::mozilla::ipc::IPDLStructMember<bool> haveBidiKeyboards_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> dictionaries_;
    ::mozilla::ipc::IPDLStructMember<ClipboardCapabilities> clipboardCaps_;
    ::mozilla::ipc::IPDLStructMember<DomainPolicyClone> domainPolicy_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> userContentSheetURL_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<GfxVarUpdate>> gfxNonDefaultVarUpdates_;
    ::mozilla::ipc::IPDLStructMember<ContentDeviceData> contentDeviceData_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<GfxInfoFeatureStatus>> gfxFeatureStatus_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> sysLocales_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> appLocales_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> requestedLocales_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<L10nFileSourceDescriptor>> l10nFileSources_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<DynamicScalarDefinition>> dynamicScalarDefs_;
    ::mozilla::ipc::IPDLStructMember<MetricMask> perfStatsMask_;
    ::mozilla::ipc::IPDLStructMember<nsCString> trrDomain_;
    ::mozilla::ipc::IPDLStructMember<ResolverMode> trrMode_;
    ::mozilla::ipc::IPDLStructMember<ResolverMode> trrModeFromPref_;
    ::mozilla::ipc::IPDLStructMember<int32_t> captivePortalState_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::XPCOMInitData>
{
    typedef ::mozilla::dom::XPCOMInitData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct VisitedQueryResult|
//
namespace mozilla {
namespace dom {
class VisitedQueryResult final
{
private:
    typedef ::nsIURI nsIURI;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    VisitedQueryResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT VisitedQueryResult(
            nsIURI* _uri,
            const bool& _visited) :
        uri_(_uri),
        visited_(_visited)
    {
    }

    MOZ_IMPLICIT VisitedQueryResult(
            RefPtr<nsIURI>&& _uri,
            bool&& _visited) :
        uri_(std::move(_uri)),
        visited_(std::move(_visited))
    {
    }

    RefPtr<nsIURI>&
    uri()
    {
        return uri_;
    }
    nsIURI*
    uri() const
    {
        return uri_;
    }

    bool&
    visited()
    {
        return visited_;
    }
    const bool&
    visited() const
    {
        return visited_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> uri_;
    ::mozilla::ipc::IPDLStructMember<bool> visited_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::VisitedQueryResult>
{
    typedef ::mozilla::dom::VisitedQueryResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StringBundleDescriptor|
//
namespace mozilla {
namespace dom {
class StringBundleDescriptor final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::ipc::ReadOnlySharedMemoryHandle ReadOnlySharedMemoryHandle;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StringBundleDescriptor() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StringBundleDescriptor(
            const nsCString& _bundleURL,
            ReadOnlySharedMemoryHandle&& _mapHandle) :
        bundleURL_(_bundleURL),
        mapHandle_(std::move(_mapHandle))
    {
    }

    MOZ_IMPLICIT StringBundleDescriptor(
            nsCString&& _bundleURL,
            ReadOnlySharedMemoryHandle&& _mapHandle) :
        bundleURL_(std::move(_bundleURL)),
        mapHandle_(std::move(_mapHandle))
    {
    }

    nsCString&
    bundleURL()
    {
        return bundleURL_;
    }
    const nsCString&
    bundleURL() const
    {
        return bundleURL_;
    }

    ReadOnlySharedMemoryHandle&
    mapHandle()
    {
        return mapHandle_;
    }
    const ReadOnlySharedMemoryHandle&
    mapHandle() const
    {
        return mapHandle_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> bundleURL_;
    ::mozilla::ipc::IPDLStructMember<ReadOnlySharedMemoryHandle> mapHandle_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::StringBundleDescriptor>
{
    typedef ::mozilla::dom::StringBundleDescriptor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCURLClassifierFeature|
//
namespace mozilla {
namespace dom {
class IPCURLClassifierFeature final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCURLClassifierFeature() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCURLClassifierFeature(
            const nsCString& _featureName,
            const nsTArray<nsCString>& _tables) :
        featureName_(_featureName),
        tables_(_tables)
    {
    }

    MOZ_IMPLICIT IPCURLClassifierFeature(
            nsCString&& _featureName,
            nsTArray<nsCString>&& _tables) :
        featureName_(std::move(_featureName)),
        tables_(std::move(_tables))
    {
    }

    nsCString&
    featureName()
    {
        return featureName_;
    }
    const nsCString&
    featureName() const
    {
        return featureName_;
    }

    nsTArray<nsCString>&
    tables()
    {
        return tables_;
    }
    const nsTArray<nsCString>&
    tables() const
    {
        return tables_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> featureName_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> tables_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCURLClassifierFeature>
{
    typedef ::mozilla::dom::IPCURLClassifierFeature paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PostMessageData|
//
namespace mozilla {
namespace dom {
class PostMessageData final
{
private:
    typedef ::mozilla::dom::MaybeDiscardedBrowsingContext MaybeDiscardedBrowsingContext;
    typedef ::nsString nsString;
    typedef ::nsIURI nsIURI;
    typedef ::nsIPrincipal nsIPrincipal;
    typedef ::nsCString nsCString;
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PostMessageData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PostMessageData(
            const MaybeDiscardedBrowsingContext& _source,
            const nsString& _origin,
            const nsString& _targetOrigin,
            nsIURI* _targetOriginURI,
            nsIPrincipal* _callerPrincipal,
            nsIPrincipal* _subjectPrincipal,
            nsIURI* _callerURI,
            const bool& _isFromPrivateWindow,
            const nsCString& _scriptLocation,
            const uint64_t& _innerWindowId) :
        source_(_source),
        origin_(_origin),
        targetOrigin_(_targetOrigin),
        targetOriginURI_(_targetOriginURI),
        callerPrincipal_(_callerPrincipal),
        subjectPrincipal_(_subjectPrincipal),
        callerURI_(_callerURI),
        isFromPrivateWindow_(_isFromPrivateWindow),
        scriptLocation_(_scriptLocation),
        innerWindowId_(_innerWindowId)
    {
    }

    MOZ_IMPLICIT PostMessageData(
            MaybeDiscardedBrowsingContext&& _source,
            nsString&& _origin,
            nsString&& _targetOrigin,
            RefPtr<nsIURI>&& _targetOriginURI,
            RefPtr<nsIPrincipal>&& _callerPrincipal,
            RefPtr<nsIPrincipal>&& _subjectPrincipal,
            RefPtr<nsIURI>&& _callerURI,
            bool&& _isFromPrivateWindow,
            nsCString&& _scriptLocation,
            uint64_t&& _innerWindowId) :
        source_(std::move(_source)),
        origin_(std::move(_origin)),
        targetOrigin_(std::move(_targetOrigin)),
        targetOriginURI_(std::move(_targetOriginURI)),
        callerPrincipal_(std::move(_callerPrincipal)),
        subjectPrincipal_(std::move(_subjectPrincipal)),
        callerURI_(std::move(_callerURI)),
        isFromPrivateWindow_(std::move(_isFromPrivateWindow)),
        scriptLocation_(std::move(_scriptLocation)),
        innerWindowId_(std::move(_innerWindowId))
    {
    }

    MaybeDiscardedBrowsingContext&
    source()
    {
        return source_;
    }
    const MaybeDiscardedBrowsingContext&
    source() const
    {
        return source_;
    }

    nsString&
    origin()
    {
        return origin_;
    }
    const nsString&
    origin() const
    {
        return origin_;
    }

    nsString&
    targetOrigin()
    {
        return targetOrigin_;
    }
    const nsString&
    targetOrigin() const
    {
        return targetOrigin_;
    }

    RefPtr<nsIURI>&
    targetOriginURI()
    {
        return targetOriginURI_;
    }
    nsIURI*
    targetOriginURI() const
    {
        return targetOriginURI_;
    }

    RefPtr<nsIPrincipal>&
    callerPrincipal()
    {
        return callerPrincipal_;
    }
    nsIPrincipal*
    callerPrincipal() const
    {
        return callerPrincipal_;
    }

    RefPtr<nsIPrincipal>&
    subjectPrincipal()
    {
        return subjectPrincipal_;
    }
    nsIPrincipal*
    subjectPrincipal() const
    {
        return subjectPrincipal_;
    }

    RefPtr<nsIURI>&
    callerURI()
    {
        return callerURI_;
    }
    nsIURI*
    callerURI() const
    {
        return callerURI_;
    }

    bool&
    isFromPrivateWindow()
    {
        return isFromPrivateWindow_;
    }
    const bool&
    isFromPrivateWindow() const
    {
        return isFromPrivateWindow_;
    }

    nsCString&
    scriptLocation()
    {
        return scriptLocation_;
    }
    const nsCString&
    scriptLocation() const
    {
        return scriptLocation_;
    }

    uint64_t&
    innerWindowId()
    {
        return innerWindowId_;
    }
    const uint64_t&
    innerWindowId() const
    {
        return innerWindowId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<MaybeDiscardedBrowsingContext> source_;
    ::mozilla::ipc::IPDLStructMember<nsString> origin_;
    ::mozilla::ipc::IPDLStructMember<nsString> targetOrigin_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> targetOriginURI_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> callerPrincipal_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> subjectPrincipal_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> callerURI_;
    ::mozilla::ipc::IPDLStructMember<bool> isFromPrivateWindow_;
    ::mozilla::ipc::IPDLStructMember<nsCString> scriptLocation_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> innerWindowId_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::PostMessageData>
{
    typedef ::mozilla::dom::PostMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union SyncedContextInitializer|
//
namespace mozilla {
namespace dom {
class SyncedContextInitializer final
{
public:
    enum Type {
        T__None,
        TBrowsingContextInitializer = 1,
        TWindowContextInitializer,
        T__Last = TWindowContextInitializer
    };

private:
    typedef ::mozilla::dom::BrowsingContextInitializer BrowsingContextInitializer;
    typedef ::mozilla::dom::WindowContextInitializer WindowContextInitializer;
    typedef BrowsingContextInitializer BrowsingContextInitializer__tdef;
    typedef WindowContextInitializer WindowContextInitializer__tdef;

    BrowsingContextInitializer*
    ptr_BrowsingContextInitializer()
    {
        return (&(mVBrowsingContextInitializer));
    }
    const BrowsingContextInitializer*
    constptr_BrowsingContextInitializer() const
    {
        return (&(mVBrowsingContextInitializer));
    }
    WindowContextInitializer*
    ptr_WindowContextInitializer()
    {
        return (&(mVWindowContextInitializer));
    }
    const WindowContextInitializer*
    constptr_WindowContextInitializer() const
    {
        return (&(mVWindowContextInitializer));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT SyncedContextInitializer() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT SyncedContextInitializer(const BrowsingContextInitializer& aOther);

    MOZ_IMPLICIT SyncedContextInitializer(BrowsingContextInitializer&& aOther);

    MOZ_IMPLICIT SyncedContextInitializer(const WindowContextInitializer& aOther);

    MOZ_IMPLICIT SyncedContextInitializer(WindowContextInitializer&& aOther);

    MOZ_IMPLICIT SyncedContextInitializer(const SyncedContextInitializer& aOther);

    MOZ_IMPLICIT SyncedContextInitializer(SyncedContextInitializer&& aOther);

    ~SyncedContextInitializer();

    Type
    type() const
    {
        return mType;
    }

    SyncedContextInitializer&
    operator=(const BrowsingContextInitializer& aRhs);

    SyncedContextInitializer&
    operator=(BrowsingContextInitializer&& aRhs);

    SyncedContextInitializer&
    operator=(const WindowContextInitializer& aRhs);

    SyncedContextInitializer&
    operator=(WindowContextInitializer&& aRhs);

    SyncedContextInitializer&
    operator=(const SyncedContextInitializer& aRhs);

    SyncedContextInitializer&
    operator=(SyncedContextInitializer&& aRhs);

    BrowsingContextInitializer&
    get_BrowsingContextInitializer()
    {
        AssertSanity(TBrowsingContextInitializer);
        return (*(ptr_BrowsingContextInitializer()));
    }
    const BrowsingContextInitializer&
    get_BrowsingContextInitializer() const
    {
        AssertSanity(TBrowsingContextInitializer);
        return (*(constptr_BrowsingContextInitializer()));
    }
    operator BrowsingContextInitializer&()
    {
        return get_BrowsingContextInitializer();
    }
    operator const BrowsingContextInitializer&() const
    {
        return get_BrowsingContextInitializer();
    }

    WindowContextInitializer&
    get_WindowContextInitializer()
    {
        AssertSanity(TWindowContextInitializer);
        return (*(ptr_WindowContextInitializer()));
    }
    const WindowContextInitializer&
    get_WindowContextInitializer() const
    {
        AssertSanity(TWindowContextInitializer);
        return (*(constptr_WindowContextInitializer()));
    }
    operator WindowContextInitializer&()
    {
        return get_WindowContextInitializer();
    }
    operator const WindowContextInitializer&() const
    {
        return get_WindowContextInitializer();
    }

private:
    union {
        BrowsingContextInitializer mVBrowsingContextInitializer;
        WindowContextInitializer mVWindowContextInitializer;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::SyncedContextInitializer>
{
    typedef ::mozilla::dom::SyncedContextInitializer paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OriginAgentClusterInitializer|
//
namespace mozilla {
namespace dom {
class OriginAgentClusterInitializer final
{
private:
    typedef ::nsIPrincipal nsIPrincipal;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OriginAgentClusterInitializer() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OriginAgentClusterInitializer(
            mozilla::NotNull<nsIPrincipal*> _principal,
            const bool& _useOriginAgentCluster) :
        principal_(_principal),
        useOriginAgentCluster_(_useOriginAgentCluster)
    {
    }

    MOZ_IMPLICIT OriginAgentClusterInitializer(
            mozilla::NotNull<RefPtr<nsIPrincipal>>&& _principal,
            bool&& _useOriginAgentCluster) :
        principal_(std::move(_principal)),
        useOriginAgentCluster_(std::move(_useOriginAgentCluster))
    {
    }

    mozilla::NotNull<RefPtr<nsIPrincipal>>&
    principal()
    {
        return principal_;
    }
    mozilla::NotNull<nsIPrincipal*>
    principal() const
    {
        return principal_;
    }

    bool&
    useOriginAgentCluster()
    {
        return useOriginAgentCluster_;
    }
    const bool&
    useOriginAgentCluster() const
    {
        return useOriginAgentCluster_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<RefPtr<nsIPrincipal>>> principal_;
    ::mozilla::ipc::IPDLStructMember<bool> useOriginAgentCluster_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::OriginAgentClusterInitializer>
{
    typedef ::mozilla::dom::OriginAgentClusterInitializer paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union BlobURLDataRequestResult|
//
namespace mozilla {
namespace dom {
class BlobURLDataRequestResult final
{
public:
    enum Type {
        T__None,
        TIPCBlob = 1,
        Tnsresult,
        T__Last = Tnsresult
    };

private:
    typedef ::mozilla::dom::IPCBlob IPCBlob;
    typedef ::nsresult nsresult;
    typedef IPCBlob IPCBlob__tdef;
    typedef nsresult nsresult__tdef;

    IPCBlob*
    ptr_IPCBlob()
    {
        return (&(mVIPCBlob));
    }
    const IPCBlob*
    constptr_IPCBlob() const
    {
        return (&(mVIPCBlob));
    }
    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT BlobURLDataRequestResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT BlobURLDataRequestResult(const IPCBlob& aOther);

    MOZ_IMPLICIT BlobURLDataRequestResult(IPCBlob&& aOther);

    MOZ_IMPLICIT BlobURLDataRequestResult(const nsresult& aOther);

    MOZ_IMPLICIT BlobURLDataRequestResult(nsresult&& aOther);

    MOZ_IMPLICIT BlobURLDataRequestResult(const BlobURLDataRequestResult& aOther);

    MOZ_IMPLICIT BlobURLDataRequestResult(BlobURLDataRequestResult&& aOther);

    ~BlobURLDataRequestResult();

    Type
    type() const
    {
        return mType;
    }

    BlobURLDataRequestResult&
    operator=(const IPCBlob& aRhs);

    BlobURLDataRequestResult&
    operator=(IPCBlob&& aRhs);

    BlobURLDataRequestResult&
    operator=(const nsresult& aRhs);

    BlobURLDataRequestResult&
    operator=(nsresult&& aRhs);

    BlobURLDataRequestResult&
    operator=(const BlobURLDataRequestResult& aRhs);

    BlobURLDataRequestResult&
    operator=(BlobURLDataRequestResult&& aRhs);

    IPCBlob&
    get_IPCBlob()
    {
        AssertSanity(TIPCBlob);
        return (*(ptr_IPCBlob()));
    }
    const IPCBlob&
    get_IPCBlob() const
    {
        AssertSanity(TIPCBlob);
        return (*(constptr_IPCBlob()));
    }
    operator IPCBlob&()
    {
        return get_IPCBlob();
    }
    operator const IPCBlob&() const
    {
        return get_IPCBlob();
    }

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

private:
    union {
        IPCBlob mVIPCBlob;
        nsresult mVnsresult;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::BlobURLDataRequestResult>
{
    typedef ::mozilla::dom::BlobURLDataRequestResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TextRecognitionQuad|
//
namespace mozilla {
namespace dom {
class TextRecognitionQuad final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::ImagePoint ImagePoint;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TextRecognitionQuad() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TextRecognitionQuad(
            const float& _confidence,
            const nsString& _string,
            const nsTArray<ImagePoint>& _points) :
        string_(_string),
        points_(_points),
        confidence_(_confidence)
    {
    }

    MOZ_IMPLICIT TextRecognitionQuad(
            float&& _confidence,
            nsString&& _string,
            nsTArray<ImagePoint>&& _points) :
        string_(std::move(_string)),
        points_(std::move(_points)),
        confidence_(std::move(_confidence))
    {
    }

    float&
    confidence()
    {
        return confidence_;
    }
    const float&
    confidence() const
    {
        return confidence_;
    }

    nsString&
    string()
    {
        return string_;
    }
    const nsString&
    string() const
    {
        return string_;
    }

    nsTArray<ImagePoint>&
    points()
    {
        return points_;
    }
    const nsTArray<ImagePoint>&
    points() const
    {
        return points_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> string_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<ImagePoint>> points_;
    ::mozilla::ipc::IPDLStructMember<float> confidence_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::TextRecognitionQuad>
{
    typedef ::mozilla::dom::TextRecognitionQuad paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TextRecognitionResult|
//
namespace mozilla {
namespace dom {
class TextRecognitionResult final
{
private:
    typedef ::mozilla::dom::TextRecognitionQuad TextRecognitionQuad;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TextRecognitionResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TextRecognitionResult(const nsTArray<TextRecognitionQuad>& _quads) :
        quads_(_quads)
    {
    }

    MOZ_IMPLICIT TextRecognitionResult(nsTArray<TextRecognitionQuad>&& _quads) :
        quads_(std::move(_quads))
    {
    }

    nsTArray<TextRecognitionQuad>&
    quads()
    {
        return quads_;
    }
    const nsTArray<TextRecognitionQuad>&
    quads() const
    {
        return quads_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<TextRecognitionQuad>> quads_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::TextRecognitionResult>
{
    typedef ::mozilla::dom::TextRecognitionResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union TextRecognitionResultOrError|
//
namespace mozilla {
namespace dom {
class TextRecognitionResultOrError final
{
public:
    enum Type {
        T__None,
        TTextRecognitionResult = 1,
        TnsCString,
        T__Last = TnsCString
    };

private:
    typedef ::mozilla::dom::TextRecognitionResult TextRecognitionResult;
    typedef ::nsCString nsCString;
    typedef TextRecognitionResult TextRecognitionResult__tdef;
    typedef nsCString nsCString__tdef;

    TextRecognitionResult*
    ptr_TextRecognitionResult()
    {
        return (&(mVTextRecognitionResult));
    }
    const TextRecognitionResult*
    constptr_TextRecognitionResult() const
    {
        return (&(mVTextRecognitionResult));
    }
    nsCString*
    ptr_nsCString()
    {
        return (&(mVnsCString));
    }
    const nsCString*
    constptr_nsCString() const
    {
        return (&(mVnsCString));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT TextRecognitionResultOrError() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT TextRecognitionResultOrError(const TextRecognitionResult& aOther);

    MOZ_IMPLICIT TextRecognitionResultOrError(TextRecognitionResult&& aOther);

    MOZ_IMPLICIT TextRecognitionResultOrError(const nsCString& aOther);

    MOZ_IMPLICIT TextRecognitionResultOrError(nsCString&& aOther);

    MOZ_IMPLICIT TextRecognitionResultOrError(const TextRecognitionResultOrError& aOther);

    MOZ_IMPLICIT TextRecognitionResultOrError(TextRecognitionResultOrError&& aOther);

    ~TextRecognitionResultOrError();

    Type
    type() const
    {
        return mType;
    }

    TextRecognitionResultOrError&
    operator=(const TextRecognitionResult& aRhs);

    TextRecognitionResultOrError&
    operator=(TextRecognitionResult&& aRhs);

    TextRecognitionResultOrError&
    operator=(const nsCString& aRhs);

    TextRecognitionResultOrError&
    operator=(nsCString&& aRhs);

    TextRecognitionResultOrError&
    operator=(const TextRecognitionResultOrError& aRhs);

    TextRecognitionResultOrError&
    operator=(TextRecognitionResultOrError&& aRhs);

    TextRecognitionResult&
    get_TextRecognitionResult()
    {
        AssertSanity(TTextRecognitionResult);
        return (*(ptr_TextRecognitionResult()));
    }
    const TextRecognitionResult&
    get_TextRecognitionResult() const
    {
        AssertSanity(TTextRecognitionResult);
        return (*(constptr_TextRecognitionResult()));
    }
    operator TextRecognitionResult&()
    {
        return get_TextRecognitionResult();
    }
    operator const TextRecognitionResult&() const
    {
        return get_TextRecognitionResult();
    }

    nsCString&
    get_nsCString()
    {
        AssertSanity(TnsCString);
        return (*(ptr_nsCString()));
    }
    const nsCString&
    get_nsCString() const
    {
        AssertSanity(TnsCString);
        return (*(constptr_nsCString()));
    }
    operator nsCString&()
    {
        return get_nsCString();
    }
    operator const nsCString&() const
    {
        return get_nsCString();
    }

private:
    union {
        TextRecognitionResult mVTextRecognitionResult;
        nsCString mVnsCString;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::TextRecognitionResultOrError>
{
    typedef ::mozilla::dom::TextRecognitionResultOrError paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
class PClipboardReadRequestParent;
} // namespace mozilla

namespace mozilla {
class PClipboardReadRequestChild;
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClipboardReadRequest|
//
namespace mozilla {
namespace dom {
class ClipboardReadRequest final
{
private:
    template<class FooSide> using ManagedEndpoint = ::mozilla::ipc::ManagedEndpoint<FooSide>;
    typedef ::mozilla::PClipboardReadRequestParent PClipboardReadRequestParent;
    typedef ::mozilla::PClipboardReadRequestChild PClipboardReadRequestChild;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClipboardReadRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClipboardReadRequest(
            ManagedEndpoint<::mozilla::PClipboardReadRequestChild>&& _childEndpoint,
            const nsTArray<nsCString>& _availableTypes) :
        childEndpoint_(std::move(_childEndpoint)),
        availableTypes_(_availableTypes)
    {
    }

    MOZ_IMPLICIT ClipboardReadRequest(
            ManagedEndpoint<::mozilla::PClipboardReadRequestChild>&& _childEndpoint,
            nsTArray<nsCString>&& _availableTypes) :
        childEndpoint_(std::move(_childEndpoint)),
        availableTypes_(std::move(_availableTypes))
    {
    }

    ManagedEndpoint<::mozilla::PClipboardReadRequestChild>&
    childEndpoint()
    {
        return childEndpoint_;
    }
    const ManagedEndpoint<::mozilla::PClipboardReadRequestChild>&
    childEndpoint() const
    {
        return childEndpoint_;
    }

    nsTArray<nsCString>&
    availableTypes()
    {
        return availableTypes_;
    }
    const nsTArray<nsCString>&
    availableTypes() const
    {
        return availableTypes_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ManagedEndpoint<::mozilla::PClipboardReadRequestChild>> childEndpoint_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> availableTypes_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClipboardReadRequest>
{
    typedef ::mozilla::dom::ClipboardReadRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ClipboardReadRequestOrError|
//
namespace mozilla {
namespace dom {
class ClipboardReadRequestOrError final
{
public:
    enum Type {
        T__None,
        TClipboardReadRequest = 1,
        Tnsresult,
        T__Last = Tnsresult
    };

private:
    typedef ::mozilla::dom::ClipboardReadRequest ClipboardReadRequest;
    typedef ::nsresult nsresult;
    typedef ClipboardReadRequest ClipboardReadRequest__tdef;
    typedef nsresult nsresult__tdef;

    ClipboardReadRequest*
    ptr_ClipboardReadRequest()
    {
        return (&(mVClipboardReadRequest));
    }
    const ClipboardReadRequest*
    constptr_ClipboardReadRequest() const
    {
        return (&(mVClipboardReadRequest));
    }
    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ClipboardReadRequestOrError() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ClipboardReadRequestOrError(ClipboardReadRequest&& aOther);

    MOZ_IMPLICIT ClipboardReadRequestOrError(const nsresult& aOther);

    MOZ_IMPLICIT ClipboardReadRequestOrError(nsresult&& aOther);

    MOZ_IMPLICIT ClipboardReadRequestOrError(ClipboardReadRequestOrError&& aOther);

    ~ClipboardReadRequestOrError();

    Type
    type() const
    {
        return mType;
    }

    ClipboardReadRequestOrError&
    operator=(ClipboardReadRequest&& aRhs);

    ClipboardReadRequestOrError&
    operator=(const nsresult& aRhs);

    ClipboardReadRequestOrError&
    operator=(nsresult&& aRhs);

    ClipboardReadRequestOrError&
    operator=(ClipboardReadRequestOrError&& aRhs);

    ClipboardReadRequest&
    get_ClipboardReadRequest()
    {
        AssertSanity(TClipboardReadRequest);
        return (*(ptr_ClipboardReadRequest()));
    }
    const ClipboardReadRequest&
    get_ClipboardReadRequest() const
    {
        AssertSanity(TClipboardReadRequest);
        return (*(constptr_ClipboardReadRequest()));
    }
    operator ClipboardReadRequest&()
    {
        return get_ClipboardReadRequest();
    }
    operator const ClipboardReadRequest&() const
    {
        return get_ClipboardReadRequest();
    }

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

private:
    union {
        ClipboardReadRequest mVClipboardReadRequest;
        nsresult mVnsresult;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClipboardReadRequestOrError>
{
    typedef ::mozilla::dom::ClipboardReadRequestOrError paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct BroadcastBlobURLUnregistrationRequest|
//
namespace mozilla {
namespace dom {
class BroadcastBlobURLUnregistrationRequest final
{
private:
    typedef ::nsCString nsCString;
    typedef ::nsIPrincipal nsIPrincipal;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    BroadcastBlobURLUnregistrationRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT BroadcastBlobURLUnregistrationRequest(
            const nsCString& _url,
            nsIPrincipal* _principal) :
        url_(_url),
        principal_(_principal)
    {
    }

    MOZ_IMPLICIT BroadcastBlobURLUnregistrationRequest(
            nsCString&& _url,
            RefPtr<nsIPrincipal>&& _principal) :
        url_(std::move(_url)),
        principal_(std::move(_principal))
    {
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    RefPtr<nsIPrincipal>&
    principal()
    {
        return principal_;
    }
    nsIPrincipal*
    principal() const
    {
        return principal_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> principal_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::BroadcastBlobURLUnregistrationRequest>
{
    typedef ::mozilla::dom::BroadcastBlobURLUnregistrationRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PContentParent;
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
class PContentChild;
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PContentChild and PContentParent
//
namespace mozilla {
namespace dom {
namespace PContent {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::PContentParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PContentChild>* aChild);

enum MessageType {
    PContentStart = PContentMsgStart << 16,
    Msg_ConstructPopupBrowser__ID,
    Msg_CloneDocumentTreeInto__ID,
    Msg_UpdateRemotePrintSettings__ID,
    Msg_PExtensionsConstructor__ID,
    Reply_PExtensionsConstructor__ID,
    Msg_ConstructBrowser__ID,
    Msg_PWebBrowserPersistDocumentConstructor__ID,
    Reply_PWebBrowserPersistDocumentConstructor__ID,
    Msg_RawMessage__ID,
    Msg_InitGMPService__ID,
    Msg_InitProcessHangMonitor__ID,
    Msg_InitProfiler__ID,
    Msg_InitRendering__ID,
    Msg_ReinitRendering__ID,
    Msg_NetworkLinkTypeChange__ID,
    Msg_SocketProcessCrashed__ID,
    Msg_ReinitRenderingForDeviceReset__ID,
    Msg_SetProcessSandbox__ID,
    Msg_RequestMemoryReport__ID,
    Reply_RequestMemoryReport__ID,
    Msg_DecodeImage__ID,
    Reply_DecodeImage__ID,
    Msg_BidiKeyboardNotify__ID,
    Msg_PCycleCollectWithLogsConstructor__ID,
    Reply_PCycleCollectWithLogsConstructor__ID,
    Msg_PTestShellConstructor__ID,
    Reply_PTestShellConstructor__ID,
    Msg_PScriptCacheConstructor__ID,
    Reply_PScriptCacheConstructor__ID,
    Msg_RegisterChrome__ID,
    Msg_RegisterChromeItem__ID,
    Msg_ClearImageCache__ID,
    Msg_ClearStyleSheetCache__ID,
    Msg_ClearScriptCache__ID,
    Msg_InvalidateScriptCache__ID,
    Msg_SetOffline__ID,
    Msg_SetConnectivity__ID,
    Msg_SetCaptivePortalState__ID,
    Msg_SetTRRMode__ID,
    Msg_NotifyVisited__ID,
    Msg_ThemeChanged__ID,
    Msg_PreferenceUpdate__ID,
    Msg_VarUpdate__ID,
    Msg_UpdatePerfStatsCollectionMask__ID,
    Msg_CollectPerfStatsJSON__ID,
    Reply_CollectPerfStatsJSON__ID,
    Msg_CollectScrollingMetrics__ID,
    Reply_CollectScrollingMetrics__ID,
    Msg_GeolocationUpdate__ID,
    Msg_GeolocationError__ID,
    Msg_UpdateDictionaryList__ID,
    Msg_UpdateFontList__ID,
    Msg_RebuildFontList__ID,
    Msg_ForceGlobalReflow__ID,
    Msg_FontListShmBlockAdded__ID,
    Msg_UpdateAppLocales__ID,
    Msg_UpdateRequestedLocales__ID,
    Msg_SystemTimezoneChanged__ID,
    Msg_UpdateL10nFileSources__ID,
    Msg_RegisterStringBundles__ID,
    Msg_SimpleURIUnknownRemoteSchemes__ID,
    Msg_UpdateSharedData__ID,
    Msg_AddPermission__ID,
    Msg_RemoveAllPermissions__ID,
    Msg_MemoryPressure__ID,
    Msg_MemoryPressureStop__ID,
    Msg_ApplicationBackground__ID,
    Msg_ApplicationForeground__ID,
    Msg_GarbageCollect__ID,
    Msg_CycleCollect__ID,
    Msg_UnlinkGhosts__ID,
    Msg_ActivateA11y__ID,
    Msg_ShutdownA11y__ID,
    Msg_SetCacheDomains__ID,
    Msg_AppInfo__ID,
    Msg_RemoteType__ID,
    Msg_InitRemoteWorkerService__ID,
    Msg_InitBlobURLs__ID,
    Msg_InitJSActorInfos__ID,
    Msg_UnregisterJSWindowActor__ID,
    Msg_UnregisterJSProcessActor__ID,
    Msg_SetXPCOMProcessAttributes__ID,
    Msg_LastPrivateDocShellDestroyed__ID,
    Msg_NotifyProcessPriorityChanged__ID,
    Msg_MinimizeMemoryUsage__ID,
    Msg_LoadAndRegisterSheet__ID,
    Msg_UnregisterSheet__ID,
    Msg_NotifyIdleObserver__ID,
    Msg_DomainSetChanged__ID,
    Msg_Shutdown__ID,
    Msg_LoadProcessScript__ID,
    Msg_UpdateWindow__ID,
    Msg_NotifyEmptyHTTPCache__ID,
    Msg_Push__ID,
    Msg_PushWithData__ID,
    Msg_GetFilesResponse__ID,
    Msg_BlobURLRegistration__ID,
    Msg_BlobURLUnregistration__ID,
    Msg_GMPsChanged__ID,
    Msg_ProvideAnonymousTemporaryFile__ID,
    Msg_SetPermissionsWithKey__ID,
    Msg_RefreshScreens__ID,
    Msg_ShareCodeCoverageMutex__ID,
    Msg_FlushCodeCoverageCounters__ID,
    Reply_FlushCodeCoverageCounters__ID,
    Msg_SetInputEventQueueEnabled__ID,
    Msg_FlushInputEventQueue__ID,
    Msg_ResumeInputEventQueue__ID,
    Msg_SuspendInputEventQueue__ID,
    Msg_AddDynamicScalars__ID,
    Msg_CrossProcessRedirect__ID,
    Reply_CrossProcessRedirect__ID,
    Msg_StartDelayedAutoplayMediaComponents__ID,
    Msg_UpdateMediaControlAction__ID,
    Msg_RegisterBrowsingContextGroup__ID,
    Msg_DestroyBrowsingContextGroup__ID,
    Msg_SetUseOriginAgentCluster__ID,
    Msg_LoadURI__ID,
    Reply_LoadURI__ID,
    Msg_InternalLoad__ID,
    Msg_DisplayLoadError__ID,
    Msg_GoBack__ID,
    Msg_GoForward__ID,
    Msg_GoToIndex__ID,
    Msg_Reload__ID,
    Msg_StopLoad__ID,
    Msg_OnAllowAccessFor__ID,
    Msg_OnContentBlockingDecision__ID,
    Msg_AbortOrientationPendingPromises__ID,
    Msg_HistoryCommitIndexAndLength__ID,
    Msg_GetLayoutHistoryState__ID,
    Reply_GetLayoutHistoryState__ID,
    Msg_DispatchLocationChangeEvent__ID,
    Msg_DispatchBeforeUnloadToSubtree__ID,
    Reply_DispatchBeforeUnloadToSubtree__ID,
    Msg_DispatchNavigateToTraversable__ID,
    Reply_DispatchNavigateToTraversable__ID,
    Msg_UpdateMediaCodecsSupported__ID,
    Msg_InitNextGenLocalStorageEnabled__ID,
    Msg_PRemotePrintJobConstructor__ID,
    Reply_PRemotePrintJobConstructor__ID,
    Msg_ConsumeHistoryActivation__ID,
    Msg_SynchronizeLayoutHistoryState__ID,
    Msg_SessionHistoryEntryTitle__ID,
    Msg_SessionHistoryEntryScrollRestorationIsManual__ID,
    Msg_SessionHistoryEntryScrollPosition__ID,
    Msg_SessionHistoryEntryCacheKey__ID,
    Msg_SessionHistoryEntryStoreWindowNameInContiguousEntries__ID,
    Msg_SessionHistoryEntryWireframe__ID,
    Msg_GetLoadingSessionHistoryInfoFromParent__ID,
    Reply_GetLoadingSessionHistoryInfoFromParent__ID,
    Msg_SynchronizeNavigationAPIState__ID,
    Msg_RemoveFromBFCache__ID,
    Msg_InitBackground__ID,
    Msg_CreateGMPService__ID,
    Msg_CreateClipboardContentAnalysis__ID,
    Msg_InitStreamFilter__ID,
    Reply_InitStreamFilter__ID,
    Msg_PRemoteSpellcheckEngineConstructor__ID,
    Reply_PRemoteSpellcheckEngineConstructor__ID,
    Msg_InitCrashReporter__ID,
    Msg_IsSecureURI__ID,
    Reply_IsSecureURI__ID,
    Msg_AccumulateMixedContentHSTS__ID,
    Msg_PHalConstructor__ID,
    Reply_PHalConstructor__ID,
    Msg_PHeapSnapshotTempFileHelperConstructor__ID,
    Reply_PHeapSnapshotTempFileHelperConstructor__ID,
    Msg_PNeckoConstructor__ID,
    Reply_PNeckoConstructor__ID,
    Msg_PSpeechSynthesisConstructor__ID,
    Reply_PSpeechSynthesisConstructor__ID,
    Msg_PMediaConstructor__ID,
    Reply_PMediaConstructor__ID,
    Msg_PWebrtcGlobalConstructor__ID,
    Reply_PWebrtcGlobalConstructor__ID,
    Msg_CreateAudioIPCConnection__ID,
    Reply_CreateAudioIPCConnection__ID,
    Msg_PURLClassifierConstructor__ID,
    Reply_PURLClassifierConstructor__ID,
    Msg_PURLClassifierLocalConstructor__ID,
    Reply_PURLClassifierLocalConstructor__ID,
    Msg_PURLClassifierLocalByNameConstructor__ID,
    Reply_PURLClassifierLocalByNameConstructor__ID,
    Msg_PSessionStorageObserverConstructor__ID,
    Reply_PSessionStorageObserverConstructor__ID,
    Msg_StartVisitedQueries__ID,
    Msg_SetURITitle__ID,
    Msg_LoadURIExternal__ID,
    Msg_ExtProtocolChannelConnectParent__ID,
    Msg_SyncMessage__ID,
    Reply_SyncMessage__ID,
    Msg_AddSecurityState__ID,
    Msg_PExternalHelperAppConstructor__ID,
    Reply_PExternalHelperAppConstructor__ID,
    Msg_PHandlerServiceConstructor__ID,
    Reply_PHandlerServiceConstructor__ID,
    Msg_AddGeolocationListener__ID,
    Msg_RemoveGeolocationListener__ID,
    Msg_SetGeolocationHigherAccuracy__ID,
    Msg_ConsoleMessage__ID,
    Msg_ScriptErrorWithStack__ID,
    Msg_SetClipboard__ID,
    Msg_GetClipboard__ID,
    Reply_GetClipboard__ID,
    Msg_GetClipboardDataSnapshot__ID,
    Reply_GetClipboardDataSnapshot__ID,
    Msg_GetClipboardDataSnapshotSync__ID,
    Reply_GetClipboardDataSnapshotSync__ID,
    Msg_EmptyClipboard__ID,
    Msg_ClipboardHasType__ID,
    Reply_ClipboardHasType__ID,
    Msg_PClipboardWriteRequestConstructor__ID,
    Reply_PClipboardWriteRequestConstructor__ID,
    Msg_GetIconForExtension__ID,
    Reply_GetIconForExtension__ID,
    Msg_FirstIdle__ID,
    Msg_CopyFavicon__ID,
    Msg_FindImageText__ID,
    Reply_FindImageText__ID,
    Msg_GraphicsError__ID,
    Msg_BeginDriverCrashGuard__ID,
    Reply_BeginDriverCrashGuard__ID,
    Msg_EndDriverCrashGuard__ID,
    Reply_EndDriverCrashGuard__ID,
    Msg_AddIdleObserver__ID,
    Msg_RemoveIdleObserver__ID,
    Msg_BackUpXResources__ID,
    Msg_RequestAnonymousTemporaryFile__ID,
    Msg_NotifyShutdownSuccess__ID,
    Msg_FinishShutdown__ID,
    Msg_PContentPermissionRequestConstructor__ID,
    Reply_PContentPermissionRequestConstructor__ID,
    Msg_ShutdownProfile__ID,
    Msg_ShutdownPerfStats__ID,
    Msg_GetFontListShmBlock__ID,
    Reply_GetFontListShmBlock__ID,
    Msg_InitializeFamily__ID,
    Reply_InitializeFamily__ID,
    Msg_SetCharacterMap__ID,
    Msg_SetupFamilyCharMap__ID,
    Msg_InitOtherFamilyNames__ID,
    Reply_InitOtherFamilyNames__ID,
    Msg_StartCmapLoading__ID,
    Msg_GetHyphDict__ID,
    Reply_GetHyphDict__ID,
    Msg_CreateWindow__ID,
    Reply_CreateWindow__ID,
    Msg_CreateWindowInDifferentProcess__ID,
    Msg_NotifyPushObservers__ID,
    Msg_NotifyPushObserversWithData__ID,
    Msg_GetFilesRequest__ID,
    Msg_DeleteGetFilesRequest__ID,
    Msg_StoreAndBroadcastBlobURLRegistration__ID,
    Msg_UnstoreAndBroadcastBlobURLUnregistration__ID,
    Msg_RecordPageLoadEvent__ID,
    Msg_AccumulateChildHistograms__ID,
    Msg_AccumulateChildKeyedHistograms__ID,
    Msg_UpdateChildScalars__ID,
    Msg_UpdateChildKeyedScalars__ID,
    Msg_RecordChildEvents__ID,
    Msg_RecordDiscardedData__ID,
    Msg_AddMemoryReport__ID,
    Msg_BHRThreadHang__ID,
    Msg_AddCertException__ID,
    Reply_AddCertException__ID,
    Msg_AutomaticStorageAccessPermissionCanBeGranted__ID,
    Reply_AutomaticStorageAccessPermissionCanBeGranted__ID,
    Msg_StorageAccessPermissionGrantedForOrigin__ID,
    Reply_StorageAccessPermissionGrantedForOrigin__ID,
    Msg_CompleteAllowAccessFor__ID,
    Reply_CompleteAllowAccessFor__ID,
    Msg_StoreUserInteractionAsPermission__ID,
    Msg_TestCookiePermissionDecided__ID,
    Reply_TestCookiePermissionDecided__ID,
    Msg_NotifyMediaPlaybackChanged__ID,
    Msg_NotifyMediaAudibleChanged__ID,
    Msg_NotifyPictureInPictureModeChanged__ID,
    Msg_NotifyMediaSessionUpdated__ID,
    Msg_NotifyUpdateMediaMetadata__ID,
    Msg_NotifyMediaSessionPlaybackStateChanged__ID,
    Msg_NotifyMediaSessionSupportedActionChanged__ID,
    Msg_NotifyMediaFullScreenState__ID,
    Msg_NotifyPositionStateChanged__ID,
    Msg_NotifyGuessedPositionStateChanged__ID,
    Msg_AddOrRemovePageAwakeRequest__ID,
    Msg_ReportServiceWorkerShutdownProgress__ID,
    Msg_AbortOtherOrientationPendingPromises__ID,
    Msg_HistoryReload__ID,
    Msg_NotifyOnHistoryReload__ID,
    Reply_NotifyOnHistoryReload__ID,
    Msg_HistoryCommit__ID,
    Msg_HistoryGo__ID,
    Reply_HistoryGo__ID,
    Msg_NavigationTraverse__ID,
    Reply_NavigationTraverse__ID,
    Msg_BlobURLDataRequest__ID,
    Reply_BlobURLDataRequest__ID,
    Msg_SetActiveSessionHistoryEntry__ID,
    Msg_ReplaceActiveSessionHistoryEntry__ID,
    Msg_RemoveDynEntriesFromActiveSessionHistoryEntry__ID,
    Msg_RemoveFromSessionHistory__ID,
    Msg_CleanupPendingLoadState__ID,
    Msg_ScriptError__ID,
    Msg_ReportFrameTimingData__ID,
    Msg_CommitBrowsingContextTransaction__ID,
    Msg_AsyncMessage__ID,
    Msg_NotifyPushSubscriptionModifiedObservers__ID,
    Msg_PushError__ID,
    Msg_CreateBrowsingContext__ID,
    Msg_DiscardBrowsingContext__ID,
    Reply_DiscardBrowsingContext__ID,
    Msg_AdjustWindowFocus__ID,
    Msg_WindowClose__ID,
    Msg_WindowFocus__ID,
    Msg_WindowBlur__ID,
    Msg_RaiseWindow__ID,
    Msg_ClearFocus__ID,
    Msg_SetFocusedBrowsingContext__ID,
    Msg_SetActiveBrowsingContext__ID,
    Msg_UnsetActiveBrowsingContext__ID,
    Msg_SetFocusedElement__ID,
    Msg_FinalizeFocusOuter__ID,
    Msg_InsertNewFocusActionId__ID,
    Msg_BlurToParent__ID,
    Msg_BlurToChild__ID,
    Msg_SetupFocusedAndActive__ID,
    Msg_ReviseActiveBrowsingContext__ID,
    Msg_ReviseFocusedBrowsingContext__ID,
    Msg_MaybeExitFullscreen__ID,
    Msg_WindowPostMessage__ID,
    Msg_CommitWindowContextTransaction__ID,
    Msg_CreateWindowContext__ID,
    Msg_DiscardWindowContext__ID,
    Reply_DiscardWindowContext__ID,
    Msg_FOGData__ID,
    Msg_GeckoTraceExport__ID,
    Msg_FlushFOGData__ID,
    Reply_FlushFOGData__ID,
    Msg_SetContainerFeaturePolicy__ID,
    Msg_UpdateAncestorOriginsList__ID,
    Msg_SetReferrerPolicyForEmbedderFrame__ID,
    Msg_GetSystemIcon__ID,
    Reply_GetSystemIcon__ID,
    Msg_GetSystemGeolocationPermissionBehavior__ID,
    Reply_GetSystemGeolocationPermissionBehavior__ID,
    Msg_RequestGeolocationPermissionFromUser__ID,
    Reply_RequestGeolocationPermissionFromUser__ID,
    Msg_AttributionEvent__ID,
    Msg_AttributionConversion__ID,
    PContentEnd
};

mozilla::UniquePtr<IPC::Message>
Msg_ConstructPopupBrowser(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CloneDocumentTreeInto(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateRemotePrintSettings(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PExtensionsConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PExtensionsConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ConstructBrowser(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PWebBrowserPersistDocumentConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PWebBrowserPersistDocumentConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RawMessage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitGMPService(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitProcessHangMonitor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitProfiler(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitRendering(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReinitRendering(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NetworkLinkTypeChange(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SocketProcessCrashed(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReinitRenderingForDeviceReset(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetProcessSandbox(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RequestMemoryReport(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_RequestMemoryReport(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DecodeImage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DecodeImage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BidiKeyboardNotify(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PCycleCollectWithLogsConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PCycleCollectWithLogsConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PTestShellConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PTestShellConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PScriptCacheConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PScriptCacheConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RegisterChrome(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RegisterChromeItem(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearImageCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearStyleSheetCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearScriptCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InvalidateScriptCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetOffline(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetConnectivity(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetCaptivePortalState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetTRRMode(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyVisited(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ThemeChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PreferenceUpdate(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_VarUpdate(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdatePerfStatsCollectionMask(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CollectPerfStatsJSON(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CollectPerfStatsJSON(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CollectScrollingMetrics(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CollectScrollingMetrics(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GeolocationUpdate(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GeolocationError(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateDictionaryList(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateFontList(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RebuildFontList(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ForceGlobalReflow(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FontListShmBlockAdded(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateAppLocales(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateRequestedLocales(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SystemTimezoneChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateL10nFileSources(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RegisterStringBundles(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SimpleURIUnknownRemoteSchemes(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateSharedData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddPermission(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveAllPermissions(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_MemoryPressure(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_MemoryPressureStop(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ApplicationBackground(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ApplicationForeground(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GarbageCollect(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CycleCollect(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnlinkGhosts(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ActivateA11y(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownA11y(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetCacheDomains(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AppInfo(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoteType(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitRemoteWorkerService(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitBlobURLs(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitJSActorInfos(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnregisterJSWindowActor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnregisterJSProcessActor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetXPCOMProcessAttributes(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_LastPrivateDocShellDestroyed(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyProcessPriorityChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_MinimizeMemoryUsage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_LoadAndRegisterSheet(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnregisterSheet(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyIdleObserver(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DomainSetChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_Shutdown(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_LoadProcessScript(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateWindow(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyEmptyHTTPCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_Push(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PushWithData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetFilesResponse(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BlobURLRegistration(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BlobURLUnregistration(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GMPsChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ProvideAnonymousTemporaryFile(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetPermissionsWithKey(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RefreshScreens(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShareCodeCoverageMutex(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FlushCodeCoverageCounters(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_FlushCodeCoverageCounters(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetInputEventQueueEnabled(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FlushInputEventQueue(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ResumeInputEventQueue(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SuspendInputEventQueue(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddDynamicScalars(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CrossProcessRedirect(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CrossProcessRedirect(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StartDelayedAutoplayMediaComponents(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateMediaControlAction(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RegisterBrowsingContextGroup(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DestroyBrowsingContextGroup(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetUseOriginAgentCluster(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_LoadURI(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_LoadURI(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InternalLoad(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DisplayLoadError(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GoBack(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GoForward(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GoToIndex(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_Reload(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StopLoad(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_OnAllowAccessFor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_OnContentBlockingDecision(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AbortOrientationPendingPromises(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_HistoryCommitIndexAndLength(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetLayoutHistoryState(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetLayoutHistoryState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DispatchLocationChangeEvent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DispatchBeforeUnloadToSubtree(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DispatchBeforeUnloadToSubtree(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DispatchNavigateToTraversable(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DispatchNavigateToTraversable(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateMediaCodecsSupported(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitNextGenLocalStorageEnabled(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PRemotePrintJobConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PRemotePrintJobConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ConsumeHistoryActivation(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SynchronizeLayoutHistoryState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryTitle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryScrollRestorationIsManual(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryScrollPosition(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryCacheKey(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryStoreWindowNameInContiguousEntries(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SessionHistoryEntryWireframe(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetLoadingSessionHistoryInfoFromParent(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetLoadingSessionHistoryInfoFromParent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SynchronizeNavigationAPIState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveFromBFCache(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitBackground(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateGMPService(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateClipboardContentAnalysis(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitStreamFilter(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitStreamFilter(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PRemoteSpellcheckEngineConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PRemoteSpellcheckEngineConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitCrashReporter(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_IsSecureURI(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_IsSecureURI(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AccumulateMixedContentHSTS(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PHalConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PHalConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PHeapSnapshotTempFileHelperConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PHeapSnapshotTempFileHelperConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PNeckoConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PNeckoConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PSpeechSynthesisConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PSpeechSynthesisConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PMediaConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PMediaConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PWebrtcGlobalConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PWebrtcGlobalConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateAudioIPCConnection(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CreateAudioIPCConnection(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PURLClassifierConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PURLClassifierConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PURLClassifierLocalConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PURLClassifierLocalConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PURLClassifierLocalByNameConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PURLClassifierLocalByNameConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PSessionStorageObserverConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PSessionStorageObserverConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StartVisitedQueries(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetURITitle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_LoadURIExternal(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ExtProtocolChannelConnectParent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SyncMessage(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_SyncMessage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddSecurityState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PExternalHelperAppConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PExternalHelperAppConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PHandlerServiceConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PHandlerServiceConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddGeolocationListener(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveGeolocationListener(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetGeolocationHigherAccuracy(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ConsoleMessage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ScriptErrorWithStack(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetClipboard(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetClipboard(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetClipboard(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetClipboardDataSnapshot(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetClipboardDataSnapshot(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetClipboardDataSnapshotSync(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetClipboardDataSnapshotSync(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_EmptyClipboard(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClipboardHasType(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_ClipboardHasType(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PClipboardWriteRequestConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PClipboardWriteRequestConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetIconForExtension(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetIconForExtension(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FirstIdle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CopyFavicon(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FindImageText(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_FindImageText(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GraphicsError(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BeginDriverCrashGuard(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_BeginDriverCrashGuard(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_EndDriverCrashGuard(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_EndDriverCrashGuard(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddIdleObserver(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveIdleObserver(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BackUpXResources(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RequestAnonymousTemporaryFile(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyShutdownSuccess(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FinishShutdown(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PContentPermissionRequestConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PContentPermissionRequestConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownProfile(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ShutdownPerfStats(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetFontListShmBlock(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetFontListShmBlock(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitializeFamily(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitializeFamily(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetCharacterMap(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetupFamilyCharMap(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InitOtherFamilyNames(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_InitOtherFamilyNames(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StartCmapLoading(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetHyphDict(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetHyphDict(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateWindow(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CreateWindow(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateWindowInDifferentProcess(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyPushObservers(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyPushObserversWithData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetFilesRequest(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DeleteGetFilesRequest(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StoreAndBroadcastBlobURLRegistration(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnstoreAndBroadcastBlobURLUnregistration(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RecordPageLoadEvent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AccumulateChildHistograms(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AccumulateChildKeyedHistograms(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateChildScalars(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateChildKeyedScalars(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RecordChildEvents(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RecordDiscardedData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddMemoryReport(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BHRThreadHang(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddCertException(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_AddCertException(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AutomaticStorageAccessPermissionCanBeGranted(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_AutomaticStorageAccessPermissionCanBeGranted(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StorageAccessPermissionGrantedForOrigin(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_StorageAccessPermissionGrantedForOrigin(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CompleteAllowAccessFor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CompleteAllowAccessFor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_StoreUserInteractionAsPermission(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_TestCookiePermissionDecided(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_TestCookiePermissionDecided(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaPlaybackChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaAudibleChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyPictureInPictureModeChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaSessionUpdated(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyUpdateMediaMetadata(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaSessionPlaybackStateChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaSessionSupportedActionChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyMediaFullScreenState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyPositionStateChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyGuessedPositionStateChanged(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AddOrRemovePageAwakeRequest(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReportServiceWorkerShutdownProgress(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AbortOtherOrientationPendingPromises(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_HistoryReload(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyOnHistoryReload(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_NotifyOnHistoryReload(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_HistoryCommit(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_HistoryGo(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_HistoryGo(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NavigationTraverse(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_NavigationTraverse(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BlobURLDataRequest(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_BlobURLDataRequest(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetActiveSessionHistoryEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReplaceActiveSessionHistoryEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveDynEntriesFromActiveSessionHistoryEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveFromSessionHistory(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CleanupPendingLoadState(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ScriptError(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReportFrameTimingData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CommitBrowsingContextTransaction(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AsyncMessage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_NotifyPushSubscriptionModifiedObservers(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PushError(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DiscardBrowsingContext(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DiscardBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AdjustWindowFocus(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_WindowClose(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_WindowFocus(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_WindowBlur(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RaiseWindow(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ClearFocus(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetFocusedBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetActiveBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UnsetActiveBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetFocusedElement(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FinalizeFocusOuter(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_InsertNewFocusActionId(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BlurToParent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_BlurToChild(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetupFocusedAndActive(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReviseActiveBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_ReviseFocusedBrowsingContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_MaybeExitFullscreen(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_WindowPostMessage(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CommitWindowContextTransaction(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CreateWindowContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DiscardWindowContext(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DiscardWindowContext(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FOGData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GeckoTraceExport(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_FlushFOGData(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_FlushFOGData(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetContainerFeaturePolicy(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_UpdateAncestorOriginsList(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetReferrerPolicyForEmbedderFrame(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetSystemIcon(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetSystemIcon(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetSystemGeolocationPermissionBehavior(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetSystemGeolocationPermissionBehavior(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RequestGeolocationPermissionFromUser(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_RequestGeolocationPermissionFromUser(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AttributionEvent(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_AttributionConversion(IPC::Message::routeid_t routingId);



} // namespace PContent
} // namespace dom
} // namespace mozilla

#endif // ifndef PContent_h
