//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBroadcastChannelParent.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/URLClassifierIPCUtils.h"
#include "mozilla/dom/CSPMessageUtils.h"
#include "mozilla/dom/DocShellMessageUtils.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PolicyContainerMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/SharedMessageBody.h"
#include "mozilla/dom/TabMessageUtils.h"
#include "mozilla/dom/ipc/StructuredCloneData.h"
#include "mozilla/dom/notification/IPCUtils.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsID.h"
#include "nsIPolicyContainer.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"
#include "nsStructuredCloneContainer.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PBroadcastChannelParent::PBroadcastChannelParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBroadcastChannelParent);
}

PBroadcastChannelParent::~PBroadcastChannelParent()
{
    MOZ_COUNT_DTOR(PBroadcastChannelParent);
}

auto PBroadcastChannelParent::ActorAlloc() -> void
{
}

auto PBroadcastChannelParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBroadcastChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBroadcastChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBroadcastChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBroadcastChannelParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBroadcastChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBroadcastChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBroadcastChannelParent::SendNotify(mozilla::NotNull<SharedMessageBody*> message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_Notify(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);


    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Notify", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelParent::SendRefMessageDelivered(
        const nsID& messageID,
        const uint32_t& actorsOnSamePid) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_RefMessageDelivered(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messageID);
    // Sentinel = 'messageID'
    ((&(writer__)))->WriteSentinel(308478835);
    IPC::WriteParam((&(writer__)), actorsOnSamePid);
    // Sentinel = 'actorsOnSamePid'
    ((&(writer__)))->WriteSentinel(809567725);


    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_RefMessageDelivered", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelParent::Send__delete__(PBroadcastChannelParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBroadcastChannelParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBroadcastChannelParent::OnMessageReceived(const Message& msg__) -> PBroadcastChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_PostMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_PostMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__message = IPC::ReadParam<mozilla::NotNull<RefPtr<SharedMessageBody>>>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'NotNull<SharedMessageBody>'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<SharedMessageBody>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPostMessage(message);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_Close__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Close", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBroadcastChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBroadcastChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBroadcastChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBroadcastChannel'
    (aWriter)->WriteSentinel(972424861);
}

auto ParamTraits<::mozilla::dom::PBroadcastChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBroadcastChannel actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBroadcastChannel'
    if ((!((aReader)->ReadSentinel(972424861)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBroadcastChannel actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBroadcastChannelMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBroadcastChannel)");

        return {};
    }
    return static_cast<::mozilla::dom::PBroadcastChannelParent*>(actor);
}

} // namespace IPC
