//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryRequestChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBFactoryChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundIDBFactoryChild::RecvPBackgroundIDBDatabaseConstructor(
        PBackgroundIDBDatabaseChild* actor,
        const DatabaseSpec& spec,
        mozilla::NotNull<PBackgroundIDBFactoryRequestChild*> request) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBFactoryChild::PBackgroundIDBFactoryChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBFactoryChild);
}

PBackgroundIDBFactoryChild::~PBackgroundIDBFactoryChild()
{
    MOZ_COUNT_DTOR(PBackgroundIDBFactoryChild);
}

auto PBackgroundIDBFactoryChild::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBFactoryChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBFactoryChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBFactoryChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBFactoryChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBFactoryChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundIDBFactoryChild::ManagedPBackgroundIDBDatabaseChild(nsTArray<PBackgroundIDBDatabaseChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBDatabaseChild.ToArray(aArr);
}

auto PBackgroundIDBFactoryChild::ManagedPBackgroundIDBDatabaseChild() const -> const ManagedContainer<PBackgroundIDBDatabaseChild>&
{
    return mManagedPBackgroundIDBDatabaseChild;
}

auto PBackgroundIDBFactoryChild::ManagedPBackgroundIDBFactoryRequestChild(nsTArray<PBackgroundIDBFactoryRequestChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBFactoryRequestChild.ToArray(aArr);
}

auto PBackgroundIDBFactoryChild::ManagedPBackgroundIDBFactoryRequestChild() const -> const ManagedContainer<PBackgroundIDBFactoryRequestChild>&
{
    return mManagedPBackgroundIDBFactoryRequestChild;
}

auto PBackgroundIDBFactoryChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBDatabaseMsgStart,
        PBackgroundIDBFactoryRequestMsgStart
    };
    return sIds;
}

auto PBackgroundIDBFactoryChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBDatabaseMsgStart:
        return (&(mManagedPBackgroundIDBDatabaseChild));
    case PBackgroundIDBFactoryRequestMsgStart:
        return (&(mManagedPBackgroundIDBFactoryRequestChild));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBFactoryChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PBackgroundIDBFactoryChild::OpenPBackgroundIDBDatabaseEndpoint(PBackgroundIDBDatabaseChild* aActor) -> ManagedEndpoint<PBackgroundIDBDatabaseParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseChild actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseChild actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBDatabaseParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBFactoryChild::BindPBackgroundIDBDatabaseEndpoint(
        ManagedEndpoint<PBackgroundIDBDatabaseChild> aEndpoint,
        PBackgroundIDBDatabaseChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBFactoryChild::OpenPBackgroundIDBFactoryRequestEndpoint(PBackgroundIDBFactoryRequestChild* aActor) -> ManagedEndpoint<PBackgroundIDBFactoryRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBFactoryRequestChild actor");
        return ManagedEndpoint<PBackgroundIDBFactoryRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBFactoryRequestChild actor");
        return ManagedEndpoint<PBackgroundIDBFactoryRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBFactoryRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBFactoryChild::BindPBackgroundIDBFactoryRequestEndpoint(
        ManagedEndpoint<PBackgroundIDBFactoryRequestChild> aEndpoint,
        PBackgroundIDBFactoryRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBFactoryChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBFactory::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBFactoryChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBFactoryChild::SendPBackgroundIDBFactoryRequestConstructor(const FactoryRequestParams& params) -> PBackgroundIDBFactoryRequestChild*
{
    PBackgroundIDBFactoryRequestChild* actor = (static_cast<indexedDB::BackgroundFactoryChild*>(this))->AllocPBackgroundIDBFactoryRequestChild(params);
    return SendPBackgroundIDBFactoryRequestConstructor(std::move(actor), std::move(params));
}

auto PBackgroundIDBFactoryChild::SendPBackgroundIDBFactoryRequestConstructor(
        PBackgroundIDBFactoryRequestChild* actor,
        const FactoryRequestParams& params) -> PBackgroundIDBFactoryRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBFactoryRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBFactoryRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBFactory::Msg_PBackgroundIDBFactoryRequestConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBFactoryChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_PBackgroundIDBFactoryRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBFactoryRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBFactoryChild::SendGetDatabases(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<GetDatabasesResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBFactory::Msg_GetDatabases(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBFactoryChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_GetDatabases", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PBackgroundIDBFactory::Reply_GetDatabases__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<GetDatabasesResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'GetDatabasesResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GetDatabasesResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PBackgroundIDBFactoryChild::SendGetDatabases(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo) -> RefPtr<GetDatabasesPromise>
{
    RefPtr<MozPromise<GetDatabasesResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<GetDatabasesResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetDatabases(std::move(persistenceType), std::move(principalInfo), [promise__](GetDatabasesResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PBackgroundIDBFactoryChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBFactoryRequestMsgStart:
        static_cast<indexedDB::BackgroundFactoryChild*>(this)->DeallocPBackgroundIDBFactoryRequestChild(static_cast<PBackgroundIDBFactoryRequestChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBFactoryChild::OnMessageReceived(const Message& msg__) -> PBackgroundIDBFactoryChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Reply_PBackgroundIDBFactoryRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Reply_GetDatabases__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_GetDatabases", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PBackgroundIDBFactory::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundFactoryChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundIDBFactory::Msg_PBackgroundIDBDatabaseConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBFactory", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBFactoryChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBFactory::Msg_PBackgroundIDBDatabaseConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__spec = IPC::ReadParam<DatabaseSpec>((&(reader__)));
            if (!maybe__spec) {
                FatalError("Error deserializing 'DatabaseSpec'");
                return MsgValueError;

            }
            auto& spec = *maybe__spec;
            // Sentinel = 'spec'
            if ((!(((&(reader__)))->ReadSentinel(72155564)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DatabaseSpec'");
                return MsgValueError;
            }
            auto maybe__request = IPC::ReadParam<mozilla::NotNull<PBackgroundIDBFactoryRequestChild*>>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'NotNull<PBackgroundIDBFactoryRequest>'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PBackgroundIDBFactoryRequest>'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            RefPtr<PBackgroundIDBDatabaseChild> actor = (static_cast<indexedDB::BackgroundFactoryChild*>(this))->AllocPBackgroundIDBDatabaseChild(spec, request);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundFactoryChild*>(this))->RecvPBackgroundIDBDatabaseConstructor(actor, std::move(spec), request);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBFactoryChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBFactoryChild::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBFactoryChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBFactory'
    (aWriter)->WriteSentinel(1435305976);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBFactoryChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBFactory actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBFactory'
    if ((!((aReader)->ReadSentinel(1435305976)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBFactory actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBFactoryMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBFactory)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBFactoryChild*>(actor);
}

} // namespace IPC
