/* THIS FILE IS AUTOGENERATED FROM EventTarget.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "EventHandlerBinding.h"
#include "EventListenerBinding.h"
#include "EventTargetBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/EventTarget.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/WindowProxyHolder.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "xpcprivate.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningAddEventListenerOptionsOrBoolean& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsAddEventListenerOptions()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsAddEventListenerOptions(), "mAddEventListenerOptions", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningAddEventListenerOptionsOrBoolean& aUnion)
{
  aUnion.Uninit();
}



EventListenerOptions::EventListenerOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
EventListenerOptions::InitIds(JSContext* cx, EventListenerOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->mozSystemGroup_id.init(cx, "mozSystemGroup") ||
      !atomsCache->capture_id.init(cx, "capture")) {
    return false;
  }
  return true;
}

bool
EventListenerOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  EventListenerOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<EventListenerOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->capture_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'capture' member of EventListenerOptions", &mCapture)) {
      return false;
    }
  } else {
    mCapture = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (ThreadSafeIsChromeOrUAWidget(cx, *object)) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->mozSystemGroup_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'mozSystemGroup' member of EventListenerOptions", &mMozSystemGroup)) {
      return false;
    }
  } else {
    mMozSystemGroup = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
EventListenerOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
EventListenerOptions::TraceDictionary(JSTracer* trc)
{
}

EventListenerOptions&
EventListenerOptions::operator=(const EventListenerOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mCapture = aOther.mCapture;
  mMozSystemGroup = aOther.mMozSystemGroup;
  return *this;
}



AddEventListenerOptions::AddEventListenerOptions()
  : EventListenerOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
AddEventListenerOptions::InitIds(JSContext* cx, AddEventListenerOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->wantUntrusted_id.init(cx, "wantUntrusted") ||
      !atomsCache->signal_id.init(cx, "signal") ||
      !atomsCache->passive_id.init(cx, "passive") ||
      !atomsCache->once_id.init(cx, "once")) {
    return false;
  }
  return true;
}

bool
AddEventListenerOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AddEventListenerOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AddEventListenerOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventListenerOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->once_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'once' member of AddEventListenerOptions", &mOnce)) {
      return false;
    }
  } else {
    mOnce = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->passive_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPassive.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'passive' member of AddEventListenerOptions", &(mPassive.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->signal_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSignal.Construct();
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<mozilla::dom::AbortSignal>::value, "We can only store refcounted classes.");
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::AbortSignal, mozilla::dom::AbortSignal>(temp.ptr(), (mSignal.Value()), cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'signal' member of AddEventListenerOptions", "AbortSignal");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'signal' member of AddEventListenerOptions");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->wantUntrusted_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mWantUntrusted.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'wantUntrusted' member of AddEventListenerOptions", &(mWantUntrusted.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
AddEventListenerOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AddEventListenerOptions::TraceDictionary(JSTracer* trc)
{
  EventListenerOptions::TraceDictionary(trc);
}



AddEventListenerOptions&
AddEventListenerOptions::operator=(const AddEventListenerOptions& aOther)
{
  EventListenerOptions::operator=(aOther);
  mOnce = aOther.mOnce;
  mPassive.Reset();
  if (aOther.mPassive.WasPassed()) {
    mPassive.Construct(aOther.mPassive.Value());
  }
  mSignal.Reset();
  if (aOther.mSignal.WasPassed()) {
    mSignal.Construct(aOther.mSignal.Value());
  }
  mWantUntrusted.Reset();
  if (aOther.mWantUntrusted.WasPassed()) {
    mWantUntrusted.Construct(aOther.mWantUntrusted.Value());
  }
  return *this;
}


bool
EventListenerOptionsOrBoolean::TrySetToEventListenerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastEventListenerOptions& memberSlot = RawSetAsEventListenerOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyEventListenerOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "EventListenerOptions branch of (EventListenerOptions or boolean)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
EventListenerOptionsOrBoolean::TrySetToEventListenerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToEventListenerOptions(cx, value, tryNext, passedToJSImpl);
}







bool
EventListenerOptionsOrBoolean::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (EventListenerOptions or boolean)", &memberSlot)) {
      return false;
    }
  }
  return true;
}







bool
EventListenerOptionsOrBoolean::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToEventListenerOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "EventListenerOptions");
    return false;
  }
  return true;
}

bool
EventListenerOptionsOrBoolean::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}




OwningEventListenerOptionsOrBoolean::OwningEventListenerOptionsOrBoolean(OwningEventListenerOptionsOrBoolean&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eEventListenerOptions: {
      mType = eEventListenerOptions;
      mValue.mEventListenerOptions.SetValue(std::move(aOther.mValue.mEventListenerOptions.Value()));
      break;
    }
    case eBoolean: {
      mType = eBoolean;
      mValue.mBoolean.SetValue(std::move(aOther.mValue.mBoolean.Value()));
      break;
    }
  }
}



bool
OwningEventListenerOptionsOrBoolean::TrySetToEventListenerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    EventListenerOptions& memberSlot = RawSetAsEventListenerOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyEventListenerOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "EventListenerOptions branch of (EventListenerOptions or boolean)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningEventListenerOptionsOrBoolean::TrySetToEventListenerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToEventListenerOptions(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] EventListenerOptions&
OwningEventListenerOptionsOrBoolean::RawSetAsEventListenerOptions()
{
  if (mType == eEventListenerOptions) {
    return mValue.mEventListenerOptions.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eEventListenerOptions;
  return mValue.mEventListenerOptions.SetValue();
}

[[nodiscard]] EventListenerOptions&
OwningEventListenerOptionsOrBoolean::SetAsEventListenerOptions()
{
  if (mType == eEventListenerOptions) {
    return mValue.mEventListenerOptions.Value();
  }
  Uninit();
  mType = eEventListenerOptions;
  return mValue.mEventListenerOptions.SetValue();
}


void
OwningEventListenerOptionsOrBoolean::DestroyEventListenerOptions()
{
  MOZ_RELEASE_ASSERT(IsEventListenerOptions(), "Wrong type!");
  mValue.mEventListenerOptions.Destroy();
  mType = eUninitialized;
}



bool
OwningEventListenerOptionsOrBoolean::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (EventListenerOptions or boolean)", &memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] bool&
OwningEventListenerOptionsOrBoolean::RawSetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}

[[nodiscard]] bool&
OwningEventListenerOptionsOrBoolean::SetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  Uninit();
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}


void
OwningEventListenerOptionsOrBoolean::DestroyBoolean()
{
  MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
  mValue.mBoolean.Destroy();
  mType = eUninitialized;
}



bool
OwningEventListenerOptionsOrBoolean::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToEventListenerOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "EventListenerOptions");
    return false;
  }
  return true;
}

bool
OwningEventListenerOptionsOrBoolean::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningEventListenerOptionsOrBoolean::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eEventListenerOptions: {
      DestroyEventListenerOptions();
      break;
    }
    case eBoolean: {
      DestroyBoolean();
      break;
    }
  }
}

OwningEventListenerOptionsOrBoolean&
OwningEventListenerOptionsOrBoolean::operator=(OwningEventListenerOptionsOrBoolean&& aOther)
{
  this->~OwningEventListenerOptionsOrBoolean();
  new (this) OwningEventListenerOptionsOrBoolean (std::move(aOther));
  return *this;
}


OwningEventListenerOptionsOrBoolean&
OwningEventListenerOptionsOrBoolean::operator=(const OwningEventListenerOptionsOrBoolean& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eEventListenerOptions: {
      SetAsEventListenerOptions() = aOther.GetAsEventListenerOptions();
      break;
    }
    case eBoolean: {
      SetAsBoolean() = aOther.GetAsBoolean();
      break;
    }
  }
  return *this;
}


bool
AddEventListenerOptionsOrBoolean::TrySetToAddEventListenerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastAddEventListenerOptions& memberSlot = RawSetAsAddEventListenerOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyAddEventListenerOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "AddEventListenerOptions branch of (AddEventListenerOptions or boolean)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
AddEventListenerOptionsOrBoolean::TrySetToAddEventListenerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToAddEventListenerOptions(cx, value, tryNext, passedToJSImpl);
}







bool
AddEventListenerOptionsOrBoolean::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (AddEventListenerOptions or boolean)", &memberSlot)) {
      return false;
    }
  }
  return true;
}







bool
AddEventListenerOptionsOrBoolean::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToAddEventListenerOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "AddEventListenerOptions");
    return false;
  }
  return true;
}

bool
AddEventListenerOptionsOrBoolean::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}




OwningAddEventListenerOptionsOrBoolean::OwningAddEventListenerOptionsOrBoolean(OwningAddEventListenerOptionsOrBoolean&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eAddEventListenerOptions: {
      mType = eAddEventListenerOptions;
      mValue.mAddEventListenerOptions.SetValue(std::move(aOther.mValue.mAddEventListenerOptions.Value()));
      break;
    }
    case eBoolean: {
      mType = eBoolean;
      mValue.mBoolean.SetValue(std::move(aOther.mValue.mBoolean.Value()));
      break;
    }
  }
}



bool
OwningAddEventListenerOptionsOrBoolean::TrySetToAddEventListenerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    AddEventListenerOptions& memberSlot = RawSetAsAddEventListenerOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyAddEventListenerOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "AddEventListenerOptions branch of (AddEventListenerOptions or boolean)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningAddEventListenerOptionsOrBoolean::TrySetToAddEventListenerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToAddEventListenerOptions(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] AddEventListenerOptions&
OwningAddEventListenerOptionsOrBoolean::RawSetAsAddEventListenerOptions()
{
  if (mType == eAddEventListenerOptions) {
    return mValue.mAddEventListenerOptions.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eAddEventListenerOptions;
  return mValue.mAddEventListenerOptions.SetValue();
}

[[nodiscard]] AddEventListenerOptions&
OwningAddEventListenerOptionsOrBoolean::SetAsAddEventListenerOptions()
{
  if (mType == eAddEventListenerOptions) {
    return mValue.mAddEventListenerOptions.Value();
  }
  Uninit();
  mType = eAddEventListenerOptions;
  return mValue.mAddEventListenerOptions.SetValue();
}


void
OwningAddEventListenerOptionsOrBoolean::DestroyAddEventListenerOptions()
{
  MOZ_RELEASE_ASSERT(IsAddEventListenerOptions(), "Wrong type!");
  mValue.mAddEventListenerOptions.Destroy();
  mType = eUninitialized;
}



bool
OwningAddEventListenerOptionsOrBoolean::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (AddEventListenerOptions or boolean)", &memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] bool&
OwningAddEventListenerOptionsOrBoolean::RawSetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}

[[nodiscard]] bool&
OwningAddEventListenerOptionsOrBoolean::SetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  Uninit();
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}


void
OwningAddEventListenerOptionsOrBoolean::DestroyBoolean()
{
  MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
  mValue.mBoolean.Destroy();
  mType = eUninitialized;
}



bool
OwningAddEventListenerOptionsOrBoolean::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToAddEventListenerOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "AddEventListenerOptions");
    return false;
  }
  return true;
}

bool
OwningAddEventListenerOptionsOrBoolean::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningAddEventListenerOptionsOrBoolean::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eAddEventListenerOptions: {
      DestroyAddEventListenerOptions();
      break;
    }
    case eBoolean: {
      DestroyBoolean();
      break;
    }
  }
}

OwningAddEventListenerOptionsOrBoolean&
OwningAddEventListenerOptionsOrBoolean::operator=(OwningAddEventListenerOptionsOrBoolean&& aOther)
{
  this->~OwningAddEventListenerOptionsOrBoolean();
  new (this) OwningAddEventListenerOptionsOrBoolean (std::move(aOther));
  return *this;
}


OwningAddEventListenerOptionsOrBoolean&
OwningAddEventListenerOptionsOrBoolean::operator=(const OwningAddEventListenerOptionsOrBoolean& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eAddEventListenerOptions: {
      SetAsAddEventListenerOptions() = aOther.GetAsAddEventListenerOptions();
      break;
    }
    case eBoolean: {
      SetAsBoolean() = aOther.GetAsBoolean();
      break;
    }
  }
  return *this;
}


namespace EventTarget_Binding {

MOZ_CAN_RUN_SCRIPT static bool
addEventListener(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "EventTarget.addEventListener");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "addEventListener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  if (!args.requireAtLeast(cx, "EventTarget.addEventListener", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedCallback<RefPtr<binding_detail::FastEventListener>> arg1(cx);
  if (args[1].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg1 = new binding_detail::FastEventListener(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  AddEventListenerOptionsOrBoolean arg2;
  if (!(args.hasDefined(2))) {
    if (!arg2.RawSetAsAddEventListenerOptions().Init(cx, JS::NullHandleValue, "Member of (AddEventListenerOptions or boolean)")) {
      return false;
    }
  } else {
    if (!arg2.Init(cx, args[2], "Argument 3", false)) {
      return false;
    }
  }
  Nullable<bool> arg3;
  if (!(args.hasDefined(3)) || args[3].isNullOrUndefined()) {
    arg3.SetNull();
  } else if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3.SetValue())) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AddEventListener(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), Constify(arg2), Constify(arg3)))>, "Should be returning void here");
  MOZ_KnownLive(self)->AddEventListener(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), Constify(arg2), Constify(arg3));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo addEventListener_methodinfo = {
  { (JSJitGetterOp)addEventListener },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeEventListener(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "EventTarget.removeEventListener");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "removeEventListener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  if (!args.requireAtLeast(cx, "EventTarget.removeEventListener", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedCallback<RefPtr<binding_detail::FastEventListener>> arg1(cx);
  if (args[1].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg1 = new binding_detail::FastEventListener(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  EventListenerOptionsOrBoolean arg2;
  if (!(args.hasDefined(2))) {
    if (!arg2.RawSetAsEventListenerOptions().Init(cx, JS::NullHandleValue, "Member of (EventListenerOptions or boolean)")) {
      return false;
    }
  } else {
    if (!arg2.Init(cx, args[2], "Argument 3", false)) {
      return false;
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RemoveEventListener(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), Constify(arg2)))>, "Should be returning void here");
  MOZ_KnownLive(self)->RemoveEventListener(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), Constify(arg2));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo removeEventListener_methodinfo = {
  { (JSJitGetterOp)removeEventListener },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
dispatchEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "EventTarget.dispatchEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "dispatchEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  if (!args.requireAtLeast(cx, "EventTarget.dispatchEvent", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Event> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Event, mozilla::dom::Event>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Event");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->DispatchEvent(MOZ_KnownLive(NonNullHelper(arg0)), nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "EventTarget.dispatchEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo dispatchEvent_methodinfo = {
  { (JSJitGetterOp)dispatchEvent },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setEventHandler(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "setEventHandler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  if (!args.requireAtLeast(cx, "EventTarget.setEventHandler", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg1(cx);
  if (args[1].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg1 = new binding_detail::FastEventHandlerNonNull(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg1 = nullptr;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetEventHandler(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetEventHandler(NonNullHelper(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "EventTarget.setEventHandler"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setEventHandler_methodinfo = {
  { (JSJitGetterOp)setEventHandler },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getEventHandler(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "getEventHandler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  if (!args.requireAtLeast(cx, "EventTarget.getEventHandler", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetEventHandler(NonNullHelper(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

static const JSJitInfo getEventHandler_methodinfo = {
  { (JSJitGetterOp)getEventHandler },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ownerGlobal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "ownerGlobal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::EventTarget*>(void_self);
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->GetOwnerGlobalForBindings());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo ownerGlobal_getterinfo = {
  { get_ownerGlobal },
  { prototypes::id::EventTarget },
  { PrototypeTraits<prototypes::id::EventTarget>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::EventTarget* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::EventTarget>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::EventTarget>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("addEventListener", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&addEventListener_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeEventListener", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeEventListener_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dispatchEvent", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&dispatchEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("setEventHandler", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setEventHandler_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getEventHandler", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getEventHandler_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("ownerGlobal", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ownerGlobal_getterinfo, nullptr, nullptr),
  JS_PS_END
};

static const PrefableDisablers sChromeAttributes_disablers0 = {
  WebIDLPrefIndex::NoPref, GlobalNames::AudioWorkletGlobalScope | GlobalNames::DedicatedWorkerGlobalScope | GlobalNames::PaintWorkletGlobalScope | GlobalNames::ServiceWorkerGlobalScope | GlobalNames::SharedWorkerGlobalScope | GlobalNames::WorkerDebuggerGlobalScope, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { &sChromeAttributes_disablers0, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[3];

static const NativePropertiesN<2> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  true,  1 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] },
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[2] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::EventTarget,
  constructors::id::EventTarget,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "EventTarget", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "EventTarget");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::EventTarget,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::EventTarget>(mozilla::dom::EventTarget::Constructor(global, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "EventTarget constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::EventTarget>::Depth,
  prototypes::id::EventTarget,
  true,
  0,
  "EventTarget",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "EventTargetPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::EventTarget,
  PrototypeTraits<prototypes::id::EventTarget>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "EventTarget",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::EventTarget>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::EventTarget>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::EventTarget>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::EventTarget>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::EventTarget>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::EventTarget* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::EventTarget>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::EventTarget*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::EventTarget> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::EventTarget);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::EventTarget);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "EventTarget",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  {
    bool succeeded;
    if (!JS_SetImmutablePrototype(aCx, proto, &succeeded)) {
      *protoCache = nullptr;
      if (interfaceCache) {
        *interfaceCache = nullptr;
      }
      return;
    }

    MOZ_ASSERT(succeeded,
               "making a fresh prototype object's [[Prototype]] "
               "immutable can internally fail, but it should "
               "never be unsuccessful");
  }
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::EventTarget,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::EventTarget,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace EventTarget_Binding



} // namespace mozilla::dom
