/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIScreen.idl
 */

#ifndef __gen_nsIScreen_h__
#define __gen_nsIScreen_h__


#include "nsISupports.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
// %{C++:10-25
#include "Units.h"

namespace mozilla::dom {
// TODO(zrhoffman, bug 1444515): ScreenColorGamut should be forward-declared
// using `webidl` once the webidl identifier supports enums.
enum class ScreenColorGamut : uint8_t;
}  // namespace mozilla::dom

/**
 * The display type of nsIScreen belongs to.
 */
enum class DisplayType: int32_t {
  DISPLAY_PRIMARY,  // primary screen
  DISPLAY_EXTERNAL, // wired displays, such as HDMI, DisplayPort, etc.
  DISPLAY_VIRTUAL   // wireless displays, such as Chromecast, WiFi-Display, etc.
};
// %}

/* starting interface:    nsIScreen */
#define NS_ISCREEN_IID_STR "826e80c8-d70f-42e2-8aa9-82c05f2a370a"

#define NS_ISCREEN_IID \
  {0x826e80c8, 0xd70f, 0x42e2, \
    { 0x8a, 0xa9, 0x82, 0xc0, 0x5f, 0x2a, 0x37, 0x0a }}

class nsIScreen : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ISCREEN_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIScreen;

  /* void GetRect (out long left, out long top, out long width, out long height); */
  NS_IMETHOD GetRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) = 0;

  /* void GetAvailRect (out long left, out long top, out long width, out long height); */
  NS_IMETHOD GetAvailRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) = 0;

// %{C++:40-50
  mozilla::LayoutDeviceIntRect GetRect() {
    int32_t left = 0, top = 0, width = 0, height = 0;
    GetRect(&left, &top, &width, &height);
    return {left, top, width, height};
  }

  mozilla::LayoutDeviceIntRect GetAvailRect() {
    int32_t left = 0, top = 0, width = 0, height = 0;
    GetAvailRect(&left, &top, &width, &height);
    return {left, top, width, height};
  }
// %}
  /* void GetRectDisplayPix (out long left, out long top, out long width, out long height); */
  NS_IMETHOD GetRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) = 0;

  /* void GetAvailRectDisplayPix (out long left, out long top, out long width, out long height); */
  NS_IMETHOD GetAvailRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) = 0;

// %{C++:60-70
  mozilla::DesktopIntRect GetRectDisplayPix() {
    int32_t left = 0, top = 0, width = 0, height = 0;
    GetRectDisplayPix(&left, &top, &width, &height);
    return {left, top, width, height};
  }

  mozilla::DesktopIntRect GetAvailRectDisplayPix() {
    int32_t left = 0, top = 0, width = 0, height = 0;
    GetAvailRectDisplayPix(&left, &top, &width, &height);
    return {left, top, width, height};
  }
// %}
  /* [infallible] readonly attribute long pixelDepth; */
  NS_IMETHOD GetPixelDepth(int32_t *aPixelDepth) = 0;
  inline int32_t  GetPixelDepth()
  {
    int32_t result;
    mozilla::DebugOnly<nsresult> rv = GetPixelDepth(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [infallible] readonly attribute long colorDepth; */
  NS_IMETHOD GetColorDepth(int32_t *aColorDepth) = 0;
  inline int32_t  GetColorDepth()
  {
    int32_t result;
    mozilla::DebugOnly<nsresult> rv = GetColorDepth(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [noscript] readonly attribute ScreenColorGamut colorGamut; */
  NS_IMETHOD GetColorGamut(mozilla::dom::ScreenColorGamut * aColorGamut) = 0;

  /* [infallible] readonly attribute double contentsScaleFactor; */
  NS_IMETHOD GetContentsScaleFactor(double *aContentsScaleFactor) = 0;
  inline double  GetContentsScaleFactor()
  {
    double result;
    mozilla::DebugOnly<nsresult> rv = GetContentsScaleFactor(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [infallible] readonly attribute double defaultCSSScaleFactor; */
  NS_IMETHOD GetDefaultCSSScaleFactor(double *aDefaultCSSScaleFactor) = 0;
  inline double  GetDefaultCSSScaleFactor()
  {
    double result;
    mozilla::DebugOnly<nsresult> rv = GetDefaultCSSScaleFactor(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

// %{C++:105-116

  mozilla::DesktopToLayoutDeviceScale GetDesktopToLayoutDeviceScale() {
    return mozilla::DesktopToLayoutDeviceScale(GetContentsScaleFactor());
  }

  mozilla::CSSToLayoutDeviceScale GetCSSToLayoutDeviceScale() {
    return mozilla::CSSToLayoutDeviceScale(GetDefaultCSSScaleFactor());
  }

  mozilla::CSSToDesktopScale GetCSSToDesktopScale() {
    return GetCSSToLayoutDeviceScale() / GetDesktopToLayoutDeviceScale();
  }
// %}
  /* [infallible] readonly attribute float dpi; */
  NS_IMETHOD GetDpi(float *aDpi) = 0;
  inline float  GetDpi()
  {
    float result;
    mozilla::DebugOnly<nsresult> rv = GetDpi(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [infallible] readonly attribute long refreshRate; */
  NS_IMETHOD GetRefreshRate(int32_t *aRefreshRate) = 0;
  inline int32_t  GetRefreshRate()
  {
    int32_t result;
    mozilla::DebugOnly<nsresult> rv = GetRefreshRate(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [infallible] readonly attribute boolean isPseudoDisplay; */
  NS_IMETHOD GetIsPseudoDisplay(bool *aIsPseudoDisplay) = 0;
  inline bool  GetIsPseudoDisplay()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetIsPseudoDisplay(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISCREEN \
  NS_IMETHOD GetRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override; \
  NS_IMETHOD GetAvailRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override; \
  NS_IMETHOD GetRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override; \
  NS_IMETHOD GetAvailRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override; \
  using nsIScreen::GetPixelDepth; \
  NS_IMETHOD GetPixelDepth(int32_t *aPixelDepth) override; \
  using nsIScreen::GetColorDepth; \
  NS_IMETHOD GetColorDepth(int32_t *aColorDepth) override; \
  NS_IMETHOD GetColorGamut(mozilla::dom::ScreenColorGamut * aColorGamut) override; \
  using nsIScreen::GetContentsScaleFactor; \
  NS_IMETHOD GetContentsScaleFactor(double *aContentsScaleFactor) override; \
  using nsIScreen::GetDefaultCSSScaleFactor; \
  NS_IMETHOD GetDefaultCSSScaleFactor(double *aDefaultCSSScaleFactor) override; \
  using nsIScreen::GetDpi; \
  NS_IMETHOD GetDpi(float *aDpi) override; \
  using nsIScreen::GetRefreshRate; \
  NS_IMETHOD GetRefreshRate(int32_t *aRefreshRate) override; \
  using nsIScreen::GetIsPseudoDisplay; \
  NS_IMETHOD GetIsPseudoDisplay(bool *aIsPseudoDisplay) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSISCREEN \
  nsresult GetRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height); \
  nsresult GetAvailRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height); \
  nsresult GetRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height); \
  nsresult GetAvailRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height); \
  using nsIScreen::GetPixelDepth; \
  nsresult GetPixelDepth(int32_t *aPixelDepth); \
  using nsIScreen::GetColorDepth; \
  nsresult GetColorDepth(int32_t *aColorDepth); \
  nsresult GetColorGamut(mozilla::dom::ScreenColorGamut * aColorGamut); \
  using nsIScreen::GetContentsScaleFactor; \
  nsresult GetContentsScaleFactor(double *aContentsScaleFactor); \
  using nsIScreen::GetDefaultCSSScaleFactor; \
  nsresult GetDefaultCSSScaleFactor(double *aDefaultCSSScaleFactor); \
  using nsIScreen::GetDpi; \
  nsresult GetDpi(float *aDpi); \
  using nsIScreen::GetRefreshRate; \
  nsresult GetRefreshRate(int32_t *aRefreshRate); \
  using nsIScreen::GetIsPseudoDisplay; \
  nsresult GetIsPseudoDisplay(bool *aIsPseudoDisplay); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISCREEN(_to) \
  NS_IMETHOD GetRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return _to GetRect(left, top, width, height); } \
  NS_IMETHOD GetAvailRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return _to GetAvailRect(left, top, width, height); } \
  NS_IMETHOD GetRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return _to GetRectDisplayPix(left, top, width, height); } \
  NS_IMETHOD GetAvailRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return _to GetAvailRectDisplayPix(left, top, width, height); } \
  using nsIScreen::GetPixelDepth; \
  NS_IMETHOD GetPixelDepth(int32_t *aPixelDepth) override { return _to GetPixelDepth(aPixelDepth); } \
  using nsIScreen::GetColorDepth; \
  NS_IMETHOD GetColorDepth(int32_t *aColorDepth) override { return _to GetColorDepth(aColorDepth); } \
  NS_IMETHOD GetColorGamut(mozilla::dom::ScreenColorGamut * aColorGamut) override { return _to GetColorGamut(aColorGamut); } \
  using nsIScreen::GetContentsScaleFactor; \
  NS_IMETHOD GetContentsScaleFactor(double *aContentsScaleFactor) override { return _to GetContentsScaleFactor(aContentsScaleFactor); } \
  using nsIScreen::GetDefaultCSSScaleFactor; \
  NS_IMETHOD GetDefaultCSSScaleFactor(double *aDefaultCSSScaleFactor) override { return _to GetDefaultCSSScaleFactor(aDefaultCSSScaleFactor); } \
  using nsIScreen::GetDpi; \
  NS_IMETHOD GetDpi(float *aDpi) override { return _to GetDpi(aDpi); } \
  using nsIScreen::GetRefreshRate; \
  NS_IMETHOD GetRefreshRate(int32_t *aRefreshRate) override { return _to GetRefreshRate(aRefreshRate); } \
  using nsIScreen::GetIsPseudoDisplay; \
  NS_IMETHOD GetIsPseudoDisplay(bool *aIsPseudoDisplay) override { return _to GetIsPseudoDisplay(aIsPseudoDisplay); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISCREEN(_to) \
  NS_IMETHOD GetRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRect(left, top, width, height); } \
  NS_IMETHOD GetAvailRect(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAvailRect(left, top, width, height); } \
  NS_IMETHOD GetRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRectDisplayPix(left, top, width, height); } \
  NS_IMETHOD GetAvailRectDisplayPix(int32_t *left, int32_t *top, int32_t *width, int32_t *height) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAvailRectDisplayPix(left, top, width, height); } \
  NS_IMETHOD GetPixelDepth(int32_t *aPixelDepth) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPixelDepth(aPixelDepth); } \
  NS_IMETHOD GetColorDepth(int32_t *aColorDepth) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetColorDepth(aColorDepth); } \
  NS_IMETHOD GetColorGamut(mozilla::dom::ScreenColorGamut * aColorGamut) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetColorGamut(aColorGamut); } \
  NS_IMETHOD GetContentsScaleFactor(double *aContentsScaleFactor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentsScaleFactor(aContentsScaleFactor); } \
  NS_IMETHOD GetDefaultCSSScaleFactor(double *aDefaultCSSScaleFactor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultCSSScaleFactor(aDefaultCSSScaleFactor); } \
  NS_IMETHOD GetDpi(float *aDpi) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDpi(aDpi); } \
  NS_IMETHOD GetRefreshRate(int32_t *aRefreshRate) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRefreshRate(aRefreshRate); } \
  NS_IMETHOD GetIsPseudoDisplay(bool *aIsPseudoDisplay) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsPseudoDisplay(aIsPseudoDisplay); } 


#endif /* __gen_nsIScreen_h__ */
