/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/protocol/http/nsIHttpActivityObserver.idl
 */

#ifndef __gen_nsIHttpActivityObserver_h__
#define __gen_nsIHttpActivityObserver_h__


#include "nsISupports.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
// %{C++:8-12
namespace mozilla {
namespace net {
class HttpActivityArgs;
} // namespace net
} // namespace mozilla
// %}

/* starting interface:    nsIHttpActivityObserver */
#define NS_IHTTPACTIVITYOBSERVER_IID_STR "412880c8-6c36-48d8-bf8f-84f91f892503"

#define NS_IHTTPACTIVITYOBSERVER_IID \
  {0x412880c8, 0x6c36, 0x48d8, \
    { 0xbf, 0x8f, 0x84, 0xf9, 0x1f, 0x89, 0x25, 0x03 }}

class NS_NO_VTABLE nsIHttpActivityObserver : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IHTTPACTIVITYOBSERVER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIHttpActivityObserver;

  /* [must_use] void observeActivity (in nsISupports aHttpChannel, in uint32_t aActivityType, in uint32_t aActivitySubtype, in PRTime aTimestamp, in uint64_t aExtraSizeData, in ACString aExtraStringData); */
  JS_HAZ_CAN_RUN_SCRIPT [[nodiscard]] NS_IMETHOD ObserveActivity(nsISupports *aHttpChannel, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) = 0;

  /* [must_use] readonly attribute boolean isActive; */
  JS_HAZ_CAN_RUN_SCRIPT [[nodiscard]] NS_IMETHOD GetIsActive(bool *aIsActive) = 0;

  /* [noscript] void setIsActive (in boolean aActived); */
  NS_IMETHOD SetIsActive(bool aActived) = 0;

  /* [must_use,noscript] void observeActivityWithArgs (in HttpActivityArgs aArgs, in uint32_t aActivityType, in uint32_t aActivitySubtype, in PRTime aTimestamp, in uint64_t aExtraSizeData, in ACString aExtraStringData); */
  [[nodiscard]] NS_IMETHOD ObserveActivityWithArgs(const mozilla::net::HttpActivityArgs & aArgs, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) = 0;

  /* [must_use] void observeConnectionActivity (in ACString aHost, in int32_t aPort, in boolean aSSL, in boolean aHasECH, in boolean aIsHttp3, in uint32_t aActivityType, in uint32_t aActivitySubtype, in PRTime aTimestamp, in ACString aExtraStringData); */
  JS_HAZ_CAN_RUN_SCRIPT [[nodiscard]] NS_IMETHOD ObserveConnectionActivity(const nsACString& aHost, int32_t aPort, bool aSSL, bool aHasECH, bool aIsHttp3, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, const nsACString& aExtraStringData) = 0;

  enum {
    ACTIVITY_TYPE_SOCKET_TRANSPORT = 1U,
    ACTIVITY_TYPE_HTTP_TRANSACTION = 2U,
    ACTIVITY_TYPE_HTTP_CONNECTION = 3U,
    ACTIVITY_SUBTYPE_REQUEST_HEADER = 20481U,
    ACTIVITY_SUBTYPE_REQUEST_BODY_SENT = 20482U,
    ACTIVITY_SUBTYPE_RESPONSE_START = 20483U,
    ACTIVITY_SUBTYPE_RESPONSE_HEADER = 20484U,
    ACTIVITY_SUBTYPE_RESPONSE_COMPLETE = 20485U,
    ACTIVITY_SUBTYPE_TRANSACTION_CLOSE = 20486U,
    ACTIVITY_SUBTYPE_PROXY_RESPONSE_HEADER = 20487U,
    ACTIVITY_SUBTYPE_DNSANDSOCKET_CREATED = 20488U,
    ACTIVITY_SUBTYPE_SPECULATIVE_DNSANDSOCKET_CREATED = 20489U,
    ACTIVITY_SUBTYPE_ECH_SET = 20490U,
    ACTIVITY_SUBTYPE_CONNECTION_CREATED = 20491U,
    ACTIVITY_SUBTYPE_EARLYHINT_RESPONSE_HEADER = 20492U
  };

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPACTIVITYOBSERVER \
  [[nodiscard]] NS_IMETHOD ObserveActivity(nsISupports *aHttpChannel, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override; \
  [[nodiscard]] NS_IMETHOD GetIsActive(bool *aIsActive) override; \
  NS_IMETHOD SetIsActive(bool aActived) override; \
  [[nodiscard]] NS_IMETHOD ObserveActivityWithArgs(const mozilla::net::HttpActivityArgs & aArgs, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override; \
  [[nodiscard]] NS_IMETHOD ObserveConnectionActivity(const nsACString& aHost, int32_t aPort, bool aSSL, bool aHasECH, bool aIsHttp3, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, const nsACString& aExtraStringData) override; \

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPACTIVITYOBSERVER \
  [[nodiscard]] nsresult ObserveActivity(nsISupports *aHttpChannel, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData); \
  [[nodiscard]] nsresult GetIsActive(bool *aIsActive); \
  nsresult SetIsActive(bool aActived); \
  [[nodiscard]] nsresult ObserveActivityWithArgs(const mozilla::net::HttpActivityArgs & aArgs, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData); \
  [[nodiscard]] nsresult ObserveConnectionActivity(const nsACString& aHost, int32_t aPort, bool aSSL, bool aHasECH, bool aIsHttp3, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, const nsACString& aExtraStringData); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPACTIVITYOBSERVER(_to) \
  [[nodiscard]] NS_IMETHOD ObserveActivity(nsISupports *aHttpChannel, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override { return _to ObserveActivity(aHttpChannel, aActivityType, aActivitySubtype, aTimestamp, aExtraSizeData, aExtraStringData); } \
  [[nodiscard]] NS_IMETHOD GetIsActive(bool *aIsActive) override { return _to GetIsActive(aIsActive); } \
  NS_IMETHOD SetIsActive(bool aActived) override { return _to SetIsActive(aActived); } \
  [[nodiscard]] NS_IMETHOD ObserveActivityWithArgs(const mozilla::net::HttpActivityArgs & aArgs, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override { return _to ObserveActivityWithArgs(aArgs, aActivityType, aActivitySubtype, aTimestamp, aExtraSizeData, aExtraStringData); } \
  [[nodiscard]] NS_IMETHOD ObserveConnectionActivity(const nsACString& aHost, int32_t aPort, bool aSSL, bool aHasECH, bool aIsHttp3, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, const nsACString& aExtraStringData) override { return _to ObserveConnectionActivity(aHost, aPort, aSSL, aHasECH, aIsHttp3, aActivityType, aActivitySubtype, aTimestamp, aExtraStringData); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPACTIVITYOBSERVER(_to) \
  [[nodiscard]] NS_IMETHOD ObserveActivity(nsISupports *aHttpChannel, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ObserveActivity(aHttpChannel, aActivityType, aActivitySubtype, aTimestamp, aExtraSizeData, aExtraStringData); } \
  [[nodiscard]] NS_IMETHOD GetIsActive(bool *aIsActive) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsActive(aIsActive); } \
  NS_IMETHOD SetIsActive(bool aActived) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsActive(aActived); } \
  [[nodiscard]] NS_IMETHOD ObserveActivityWithArgs(const mozilla::net::HttpActivityArgs & aArgs, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, uint64_t aExtraSizeData, const nsACString& aExtraStringData) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ObserveActivityWithArgs(aArgs, aActivityType, aActivitySubtype, aTimestamp, aExtraSizeData, aExtraStringData); } \
  [[nodiscard]] NS_IMETHOD ObserveConnectionActivity(const nsACString& aHost, int32_t aPort, bool aSSL, bool aHasECH, bool aIsHttp3, uint32_t aActivityType, uint32_t aActivitySubtype, PRTime aTimestamp, const nsACString& aExtraStringData) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ObserveConnectionActivity(aHost, aPort, aSSL, aHasECH, aIsHttp3, aActivityType, aActivitySubtype, aTimestamp, aExtraStringData); } \

// %{C++:153-184

#define NS_HTTP_ACTIVITY_TYPE_SOCKET_TRANSPORT    \
            nsIHttpActivityObserver::ACTIVITY_TYPE_SOCKET_TRANSPORT
#define NS_HTTP_ACTIVITY_TYPE_HTTP_TRANSACTION    \
            nsIHttpActivityObserver::ACTIVITY_TYPE_HTTP_TRANSACTION
#define NS_ACTIVITY_TYPE_HTTP_CONNECTION          \
            nsIHttpActivityObserver::ACTIVITY_TYPE_HTTP_CONNECTION

#define NS_HTTP_ACTIVITY_SUBTYPE_REQUEST_HEADER    \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_REQUEST_HEADER
#define NS_HTTP_ACTIVITY_SUBTYPE_REQUEST_BODY_SENT \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_REQUEST_BODY_SENT
#define NS_HTTP_ACTIVITY_SUBTYPE_RESPONSE_START    \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_RESPONSE_START
#define NS_HTTP_ACTIVITY_SUBTYPE_RESPONSE_HEADER   \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_RESPONSE_HEADER
#define NS_HTTP_ACTIVITY_SUBTYPE_RESPONSE_COMPLETE \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_RESPONSE_COMPLETE
#define NS_HTTP_ACTIVITY_SUBTYPE_TRANSACTION_CLOSE \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_TRANSACTION_CLOSE
#define NS_HTTP_ACTIVITY_SUBTYPE_PROXY_RESPONSE_HEADER \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_PROXY_RESPONSE_HEADER
#define NS_HTTP_ACTIVITY_SUBTYPE_DNSANDSOCKET_CREATED \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_DNSANDSOCKET_CREATED
#define NS_HTTP_ACTIVITY_SUBTYPE_SPECULATIVE_DNSANDSOCKET_CREATED \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_SPECULATIVE_DNSANDSOCKET_CREATED
#define NS_HTTP_ACTIVITY_SUBTYPE_ECH_SET \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_ECH_SET
#define NS_HTTP_ACTIVITY_SUBTYPE_CONNECTION_CREATED \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_CONNECTION_CREATED
#define NS_HTTP_ACTIVITY_SUBTYPE_EARLYHINT_RESPONSE_HEADER \
            nsIHttpActivityObserver::ACTIVITY_SUBTYPE_EARLYHINT_RESPONSE_HEADER
// %}

/* starting interface:    nsIHttpActivityDistributor */
#define NS_IHTTPACTIVITYDISTRIBUTOR_IID_STR "7c512cb8-582a-4625-b5b6-8639755271b5"

#define NS_IHTTPACTIVITYDISTRIBUTOR_IID \
  {0x7c512cb8, 0x582a, 0x4625, \
    { 0xb5, 0xb6, 0x86, 0x39, 0x75, 0x52, 0x71, 0xb5 }}

class NS_NO_VTABLE nsIHttpActivityDistributor : public nsIHttpActivityObserver {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IHTTPACTIVITYDISTRIBUTOR_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIHttpActivityDistributor;

  /* void addObserver (in nsIHttpActivityObserver aObserver); */
  NS_IMETHOD AddObserver(nsIHttpActivityObserver *aObserver) = 0;

  /* void removeObserver (in nsIHttpActivityObserver aObserver); */
  NS_IMETHOD RemoveObserver(nsIHttpActivityObserver *aObserver) = 0;

  /* [noscript,notxpcom] boolean Activated (); */
  NS_IMETHOD_(bool) Activated(void) = 0;

  /* [noscript,notxpcom] boolean ObserveProxyResponseEnabled (); */
  NS_IMETHOD_(bool) ObserveProxyResponseEnabled(void) = 0;

  /* [noscript,notxpcom] boolean ObserveConnectionEnabled (); */
  NS_IMETHOD_(bool) ObserveConnectionEnabled(void) = 0;

  /* [must_use] attribute boolean observeProxyResponse; */
  [[nodiscard]] NS_IMETHOD GetObserveProxyResponse(bool *aObserveProxyResponse) = 0;
  [[nodiscard]] NS_IMETHOD SetObserveProxyResponse(bool aObserveProxyResponse) = 0;

  /* [must_use] attribute boolean observeConnection; */
  [[nodiscard]] NS_IMETHOD GetObserveConnection(bool *aObserveConnection) = 0;
  [[nodiscard]] NS_IMETHOD SetObserveConnection(bool aObserveConnection) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPACTIVITYDISTRIBUTOR \
  NS_IMETHOD AddObserver(nsIHttpActivityObserver *aObserver) override; \
  NS_IMETHOD RemoveObserver(nsIHttpActivityObserver *aObserver) override; \
  NS_IMETHOD_(bool) Activated(void) override; \
  NS_IMETHOD_(bool) ObserveProxyResponseEnabled(void) override; \
  NS_IMETHOD_(bool) ObserveConnectionEnabled(void) override; \
  [[nodiscard]] NS_IMETHOD GetObserveProxyResponse(bool *aObserveProxyResponse) override; \
  [[nodiscard]] NS_IMETHOD SetObserveProxyResponse(bool aObserveProxyResponse) override; \
  [[nodiscard]] NS_IMETHOD GetObserveConnection(bool *aObserveConnection) override; \
  [[nodiscard]] NS_IMETHOD SetObserveConnection(bool aObserveConnection) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPACTIVITYDISTRIBUTOR \
  nsresult AddObserver(nsIHttpActivityObserver *aObserver); \
  nsresult RemoveObserver(nsIHttpActivityObserver *aObserver); \
  nsresult_(bool) Activated(void); \
  nsresult_(bool) ObserveProxyResponseEnabled(void); \
  nsresult_(bool) ObserveConnectionEnabled(void); \
  [[nodiscard]] nsresult GetObserveProxyResponse(bool *aObserveProxyResponse); \
  [[nodiscard]] nsresult SetObserveProxyResponse(bool aObserveProxyResponse); \
  [[nodiscard]] nsresult GetObserveConnection(bool *aObserveConnection); \
  [[nodiscard]] nsresult SetObserveConnection(bool aObserveConnection); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPACTIVITYDISTRIBUTOR(_to) \
  NS_IMETHOD AddObserver(nsIHttpActivityObserver *aObserver) override { return _to AddObserver(aObserver); } \
  NS_IMETHOD RemoveObserver(nsIHttpActivityObserver *aObserver) override { return _to RemoveObserver(aObserver); } \
  NS_IMETHOD_(bool) Activated(void) override { return _to Activated(); } \
  NS_IMETHOD_(bool) ObserveProxyResponseEnabled(void) override { return _to ObserveProxyResponseEnabled(); } \
  NS_IMETHOD_(bool) ObserveConnectionEnabled(void) override { return _to ObserveConnectionEnabled(); } \
  [[nodiscard]] NS_IMETHOD GetObserveProxyResponse(bool *aObserveProxyResponse) override { return _to GetObserveProxyResponse(aObserveProxyResponse); } \
  [[nodiscard]] NS_IMETHOD SetObserveProxyResponse(bool aObserveProxyResponse) override { return _to SetObserveProxyResponse(aObserveProxyResponse); } \
  [[nodiscard]] NS_IMETHOD GetObserveConnection(bool *aObserveConnection) override { return _to GetObserveConnection(aObserveConnection); } \
  [[nodiscard]] NS_IMETHOD SetObserveConnection(bool aObserveConnection) override { return _to SetObserveConnection(aObserveConnection); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPACTIVITYDISTRIBUTOR(_to) \
  NS_IMETHOD AddObserver(nsIHttpActivityObserver *aObserver) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddObserver(aObserver); } \
  NS_IMETHOD RemoveObserver(nsIHttpActivityObserver *aObserver) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveObserver(aObserver); } \
  NS_IMETHOD_(bool) Activated(void) override; \
  NS_IMETHOD_(bool) ObserveProxyResponseEnabled(void) override; \
  NS_IMETHOD_(bool) ObserveConnectionEnabled(void) override; \
  [[nodiscard]] NS_IMETHOD GetObserveProxyResponse(bool *aObserveProxyResponse) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetObserveProxyResponse(aObserveProxyResponse); } \
  [[nodiscard]] NS_IMETHOD SetObserveProxyResponse(bool aObserveProxyResponse) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetObserveProxyResponse(aObserveProxyResponse); } \
  [[nodiscard]] NS_IMETHOD GetObserveConnection(bool *aObserveConnection) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetObserveConnection(aObserveConnection); } \
  [[nodiscard]] NS_IMETHOD SetObserveConnection(bool aObserveConnection) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetObserveConnection(aObserveConnection); } 


#endif /* __gen_nsIHttpActivityObserver_h__ */
