/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef IMAGE_RUST_JXLDECODERFFI_H_
#define IMAGE_RUST_JXLDECODERFFI_H_

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "cstdint"
#include "cstddef"

namespace mozilla {
namespace image {

enum class JxlDecoderStatus {
  Ok = 0,
  NeedMoreData = 1,
  Error = 2,
};

struct JxlApiDecoder;

struct JxlBasicInfo {
  uint32_t width;
  uint32_t height;
  bool has_alpha;
  bool alpha_premultiplied;
  bool is_animated;
  uint32_t num_loops;
  bool valid;
};

struct JxlFrameInfo {
  int32_t duration_ms;
  bool frame_duration_valid;
};

extern "C" {

JxlApiDecoder *jxl_decoder_new(bool metadata_only, bool premultiply);

/// # Safety
/// `decoder` must be a valid pointer returned by `jxl_decoder_new` and must not
/// have been previously destroyed. After this call, `decoder` is invalid.
void jxl_decoder_destroy(JxlApiDecoder *decoder);

/// # Safety
/// - `decoder` must be a valid pointer returned by `jxl_decoder_new`.
/// - `data` must be a valid pointer to a `*const u8` pointer.
/// - `data_len` must be a valid pointer to a `usize`.
/// - `*data` must point to a valid byte slice of length `*data_len`, or be null
///   when `*data_len` is 0.
/// - If `output_buffer` is non-null, it must point to a valid writable buffer
///   of at least `output_buffer_len` bytes.
JxlDecoderStatus jxl_decoder_process_data(JxlApiDecoder *decoder,
                                          const uint8_t **data,
                                          uintptr_t *data_len,
                                          uint8_t *output_buffer,
                                          uintptr_t output_buffer_len);

/// # Safety
/// `decoder` must be a valid pointer returned by `jxl_decoder_new`.
JxlBasicInfo jxl_decoder_get_basic_info(const JxlApiDecoder *decoder);

/// # Safety
/// `decoder` must be a valid pointer returned by `jxl_decoder_new`.
JxlFrameInfo jxl_decoder_get_frame_info(const JxlApiDecoder *decoder);

/// # Safety
/// `decoder` must be a valid pointer returned by `jxl_decoder_new`.
bool jxl_decoder_is_frame_ready(const JxlApiDecoder *decoder);

/// # Safety
/// `decoder` must be a valid pointer returned by `jxl_decoder_new`.
bool jxl_decoder_has_more_frames(const JxlApiDecoder *decoder);

}  // extern "C"

}  // namespace image
}  // namespace mozilla

#endif  // IMAGE_RUST_JXLDECODERFFI_H_
