/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_glean_NumeratorStandalone_h
#define mozilla_glean_NumeratorStandalone_h

#include <cstdint>  // uint32_t

namespace mozilla::glean::impl {

// Actually a RateMetric, but one whose denominator is a CounterMetric external
// to the RateMetric.
class NumeratorStandalone {
 public:
  constexpr explicit NumeratorStandalone(uint32_t aId) : mId(aId) {}

  /*
   * Increases the numerator by `amount`.
   *
   * @param aAmount The amount to increase by. Should be positive.
   */
  void AddToNumerator(int32_t aAmount = 1) const;

 protected:
  const uint32_t mId;
};

}  // namespace mozilla::glean::impl

#endif /* mozilla_glean_NumeratorStandalone_h */
